#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-theory
version: 1.2.3
id: tamarin-prover-theory-1.2.3-7MNueB2Sm6v3cHS3HIu31m
key: tamarin-prover-theory-1.2.3-7MNueB2Sm6v3cHS3HIu31m
license: GPL
copyright: Benedikt Schmidt, Simon Meier, ETH Zurich, 2010-2012
maintainer: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>
homepage: http://www.infsec.ethz.ch/research/software/tamarin
synopsis: Security protocol types and constraint solver library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides the types to represent security
    protocol, and it implements the constraint solver.
category: Theorem Provers
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>
exposed: True
indefinite: False
exposed-modules:
    Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.Solver.Types Theory.Constraint.System
    Theory.Constraint.System.Constraints Theory.Constraint.System.Dot
    Theory.Constraint.System.Guarded Theory.Constraint.System.JSON
    Theory.Model Theory.Model.Atom Theory.Model.Fact
    Theory.Model.Formula Theory.Model.Rule Theory.Model.Signature
    Theory.Proof Theory.Text.Parser Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.RuleVariants Theory.Tools.Wellformedness
abi: ceb0f9255c1de51e510a2d20689cccc0
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/tamarin-prover-theory-1.2.3
library-dirs: /usr/lib/ghc-8.2.2/site-local/tamarin-prover-theory-1.2.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/tamarin-prover-theory-1.2.3
hs-libraries: HStamarin-prover-theory-1.2.3-7MNueB2Sm6v3cHS3HIu31m
depends:
    aeson-1.2.4.0-JjRmYRp9s4v1lVpwJTIfmI
    aeson-pretty-0.8.5-FzWkciwehbK7ozQrwl1M4C base-4.10.1.0
    binary-0.8.5.1 bytestring-0.10.8.2 containers-0.5.10.2
    deepseq-1.4.3.0 dlist-0.8.0.4-8Td44GecKNEJmy7QK3HIQc
    fclabels-2.0.3.3-4WNPtbHFlNRFH87gHrbcA6
    mtl-2.2.2-8XubxMJDT8QLsstvlNotkc
    parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1
    parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp process-1.6.1.0
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz transformers-0.5.2.0
    uniplate-1.6.12-C9LyPJWeB4iIGtF2rPwmQR
    tamarin-prover-utils-1.2.3-CV2WfW5H3wOHztsELem0OH
    tamarin-prover-term-1.2.3-FQchfF90exDF1gSfVqfJT0
abi-depends: aeson-1.2.4.0-JjRmYRp9s4v1lVpwJTIfmI=1d66e10508b2b9b73c1f3ba29c389844
             aeson-pretty-0.8.5-FzWkciwehbK7ozQrwl1M4C=a209c274738982c57c3e35dcd2b9dcf7
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             dlist-0.8.0.4-8Td44GecKNEJmy7QK3HIQc=891025a77d043cfd28f763ce7f5a4b16
             fclabels-2.0.3.3-4WNPtbHFlNRFH87gHrbcA6=77fb45eb89f425325c76d910956f050c
             mtl-2.2.2-8XubxMJDT8QLsstvlNotkc=9d788b97813db77c2d48570ade6e04a9
             parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1=f329a0732f0d1ccfb717a7145bfd3a72
             parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp=b942a04aec0a266706b2e8e67bd137e3
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz=29872508833c96394f0471371217bab0
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             uniplate-1.6.12-C9LyPJWeB4iIGtF2rPwmQR=59adbb36731b1104a47b77d31858baa1
             tamarin-prover-utils-1.2.3-CV2WfW5H3wOHztsELem0OH=823a02395863ff544cfed0bbce3189d4
             tamarin-prover-term-1.2.3-FQchfF90exDF1gSfVqfJT0=ae6d836dddb429aac118d701dced6997
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

