/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.util.List;
import java.util.Map;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.Launcher;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.runtime.Boot;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.optionparser.OptionParser;

public final class JnlpBoot {
    private final OptionParser optionParser;

    public JnlpBoot(OptionParser optionParser) {
        this.optionParser = optionParser;
    }

    boolean run(Map<String, List<String>> extra) {
        ParserSettings settings = Boot.init(extra);
        if (settings == null) {
            return false;
        }
        try {
            OutputController.getLogger().log("Proceeding with jnlp");
            Launcher launcher = new Launcher(false);
            launcher.setParserSettings(settings);
            launcher.setInformationToMerge(extra);
            launcher.launch(Boot.getFileLocation());
        }
        catch (LaunchException launcher) {
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            Boot.fatalError(Translator.R("RUnexpected", ex.toString(), ex.getStackTrace()[0]));
        }
        return true;
    }
}

