/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging.headers;

import java.util.Date;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.headers.Header;
import net.sourceforge.jnlp.util.logging.headers.MessageWithHeader;
import net.sourceforge.jnlp.util.logging.headers.PluginHeader;

public class PluginMessage
implements MessageWithHeader {
    public PluginHeader header;
    public String restOfMessage;
    public boolean wasError = false;

    public PluginMessage(String orig) {
        this.restOfMessage = orig;
        this.header = new PluginHeader();
        String s = orig.trim();
        PluginHeader p = this.header;
        try {
            p.isC = true;
            p.application = false;
            if (s.startsWith("preinit_plugin")) {
                p.preinit = true;
            }
            p.level = s.startsWith("plugindebug ") || s.startsWith("preinit_plugindebug ") ? OutputController.Level.MESSAGE_DEBUG : (s.startsWith("pluginerror ") || s.startsWith("preinit_pluginerror ") ? OutputController.Level.ERROR_ALL : OutputController.Level.WARNING_ALL);
            String[] init = PluginHeader.whiteSpaces.split(s);
            p.timestamp = new Date(Long.parseLong(init[1]) / 1000L);
            String[] main = PluginHeader.bracketsPattern.split(s);
            p.user = main[1];
            p.caller = main[5];
            p.date = main[4];
            String[] threads = PluginHeader.threadsPattern.split(main[6]);
            p.thread1 = threads[2];
            p.thread2 = threads[4];
            int i = orig.indexOf(p.thread2);
            this.restOfMessage = orig.substring(i + p.thread2.length() + 2);
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            this.wasError = true;
        }
    }

    @Override
    public String getMessage() {
        return this.restOfMessage;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }
}

