!===============================================================================
! Copyright 2021-2022 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!  Content:
!      Intel(R) oneAPI Math Kernel Library (oneMKL)
!      FORTRAN OpenMP offload examples for DPOTRS
!*******************************************************************************

include "mkl_omp_offload.f90"

program dpotrs_example

#if defined(MKL_ILP64)
    use onemkl_lapack_omp_offload_ilp64
#else
    use onemkl_lapack_omp_offload_lp64
#endif

    character*1 :: L = 'L'
    integer, parameter :: n = 3, lda = 4
    integer i, j, num_errors, info

    double precision ::                              &
        matrix(lda,n) = (/  4.,  12., -16.,  -1.,    &
                           12.,  37., -43.,  -1.,    &
                          -16., -43.,  98.,  -1. /), &
        rhs(lda,n) =    (/  4.,  12., -16.,  -1.,    &
                           12.,  37., -43.,  -1.,    &
                          -16., -43.,  98.,  -1. /), &
        result(lda,n) = (/  1.,   0.,   0.,  -1.,    &
                            0.,   1.,   0.,  -1.,    &
                            0.,   0.,   1.,  -1. /)

    print *, "Input:"
    do i = 1, n
        write (* ,'(10G14.6)') matrix(i,1:i)
    end do

    ! Run on GPU
    !$omp target data map(matrix, rhs)
        !$omp target data map(info)
            !$omp target variant dispatch use_device_ptr(matrix, info)
            call dpotrf(L, n, matrix, lda, info)
            !$omp end target variant dispatch
        !$omp end target data
        if (info.ne.0) then
            print '("ERROR: Calculations failed with info = ", I0)', info
            stop info
        end if
        !$omp target data map(info)
            !$omp target variant dispatch use_device_ptr(matrix, rhs, info)
            call dpotrs(L, n, n, matrix, lda, rhs, lda, info)
            !$omp end target variant dispatch
        !$omp end target data
    !$omp end target data

    if (info.ne.0) then
        print '("ERROR: Calculations failed with info = ", I0)', info
        stop info
    end if

    num_errors = 0
    print *, "Result:"
    do i = 1, n
        write (* ,'(10G14.6)') rhs(i,1:i)
        do j = 1, n
            if ((abs(rhs(i,j)-result(i,j))).gt.1e-7) then
                num_errors = num_errors+1
            end if
        end do
    end do

    if (num_errors.gt.0) then
        print *, "ERROR: result mismatches!"
    end if

    stop num_errors

end program
