/* io.elementary.music-core.h generated by valac 0.54.7, the Vala compiler, do not modify */

#ifndef __CORE_IO_ELEMENTARY_MUSIC_CORE_H__
#define __CORE_IO_ELEMENTARY_MUSIC_CORE_H__

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <gst/gst.h>
#include <time.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif
#define MUSIC_MUSIC_PLAYLIST "autosaved_music"
#define MUSIC_TIME_UTILS_NANO_INV ((guint64) 1000000000)
#define MUSIC_TIME_UTILS_MILI_INV ((guint64) 1000)
#define BUILD_APP_ID "io.elementary.music"
#define BUILD_DATADIR "/usr/share"
#define BUILD_PLUGIN_DIR "/usr/lib/io.elementary.music/plugins"
#define BUILD_GETTEXT_PACKAGE "io.elementary.music"
#define BUILD_VERSION "5.1.1"
#define BUILD_EXEC_NAME "io.elementary.music"

#define MUSIC_TYPE_ALBUM (music_album_get_type ())
#define MUSIC_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_ALBUM, MusicAlbum))
#define MUSIC_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_ALBUM, MusicAlbumClass))
#define MUSIC_IS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_ALBUM))
#define MUSIC_IS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_ALBUM))
#define MUSIC_ALBUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_ALBUM, MusicAlbumClass))

typedef struct _MusicAlbum MusicAlbum;
typedef struct _MusicAlbumClass MusicAlbumClass;
typedef struct _MusicAlbumPrivate MusicAlbumPrivate;

#define MUSIC_TYPE_MEDIA (music_media_get_type ())
#define MUSIC_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_MEDIA, MusicMedia))
#define MUSIC_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_MEDIA, MusicMediaClass))
#define MUSIC_IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_MEDIA))
#define MUSIC_IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_MEDIA))
#define MUSIC_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_MEDIA, MusicMediaClass))

typedef struct _MusicMedia MusicMedia;
typedef struct _MusicMediaClass MusicMediaClass;

#define MUSIC_TYPE_EQUALIZER_PRESET (music_equalizer_preset_get_type ())
#define MUSIC_EQUALIZER_PRESET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_EQUALIZER_PRESET, MusicEqualizerPreset))
#define MUSIC_EQUALIZER_PRESET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_EQUALIZER_PRESET, MusicEqualizerPresetClass))
#define MUSIC_IS_EQUALIZER_PRESET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_EQUALIZER_PRESET))
#define MUSIC_IS_EQUALIZER_PRESET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_EQUALIZER_PRESET))
#define MUSIC_EQUALIZER_PRESET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_EQUALIZER_PRESET, MusicEqualizerPresetClass))

typedef struct _MusicEqualizerPreset MusicEqualizerPreset;
typedef struct _MusicEqualizerPresetClass MusicEqualizerPresetClass;
typedef struct _MusicEqualizerPresetPrivate MusicEqualizerPresetPrivate;

#define MUSIC_TYPE_LIBRARIES_MANAGER (music_libraries_manager_get_type ())
#define MUSIC_LIBRARIES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_LIBRARIES_MANAGER, MusicLibrariesManager))
#define MUSIC_LIBRARIES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_LIBRARIES_MANAGER, MusicLibrariesManagerClass))
#define MUSIC_IS_LIBRARIES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_LIBRARIES_MANAGER))
#define MUSIC_IS_LIBRARIES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_LIBRARIES_MANAGER))
#define MUSIC_LIBRARIES_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_LIBRARIES_MANAGER, MusicLibrariesManagerClass))

typedef struct _MusicLibrariesManager MusicLibrariesManager;
typedef struct _MusicLibrariesManagerClass MusicLibrariesManagerClass;
typedef struct _MusicLibrariesManagerPrivate MusicLibrariesManagerPrivate;

#define MUSIC_TYPE_LIBRARY (music_library_get_type ())
#define MUSIC_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_LIBRARY, MusicLibrary))
#define MUSIC_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_LIBRARY, MusicLibraryClass))
#define MUSIC_IS_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_LIBRARY))
#define MUSIC_IS_LIBRARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_LIBRARY))
#define MUSIC_LIBRARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_LIBRARY, MusicLibraryClass))

typedef struct _MusicLibrary MusicLibrary;
typedef struct _MusicLibraryClass MusicLibraryClass;
typedef struct _MusicLibraryPrivate MusicLibraryPrivate;

#define MUSIC_TYPE_PLAYLIST (music_playlist_get_type ())
#define MUSIC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PLAYLIST, MusicPlaylist))
#define MUSIC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_PLAYLIST, MusicPlaylistClass))
#define MUSIC_IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PLAYLIST))
#define MUSIC_IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_PLAYLIST))
#define MUSIC_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_PLAYLIST, MusicPlaylistClass))

typedef struct _MusicPlaylist MusicPlaylist;
typedef struct _MusicPlaylistClass MusicPlaylistClass;

#define MUSIC_TYPE_STATIC_PLAYLIST (music_static_playlist_get_type ())
#define MUSIC_STATIC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_STATIC_PLAYLIST, MusicStaticPlaylist))
#define MUSIC_STATIC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_STATIC_PLAYLIST, MusicStaticPlaylistClass))
#define MUSIC_IS_STATIC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_STATIC_PLAYLIST))
#define MUSIC_IS_STATIC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_STATIC_PLAYLIST))
#define MUSIC_STATIC_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_STATIC_PLAYLIST, MusicStaticPlaylistClass))

typedef struct _MusicStaticPlaylist MusicStaticPlaylist;
typedef struct _MusicStaticPlaylistClass MusicStaticPlaylistClass;

#define MUSIC_TYPE_SMART_PLAYLIST (music_smart_playlist_get_type ())
#define MUSIC_SMART_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_SMART_PLAYLIST, MusicSmartPlaylist))
#define MUSIC_SMART_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_SMART_PLAYLIST, MusicSmartPlaylistClass))
#define MUSIC_IS_SMART_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_SMART_PLAYLIST))
#define MUSIC_IS_SMART_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_SMART_PLAYLIST))
#define MUSIC_SMART_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_SMART_PLAYLIST, MusicSmartPlaylistClass))

typedef struct _MusicSmartPlaylist MusicSmartPlaylist;
typedef struct _MusicSmartPlaylistClass MusicSmartPlaylistClass;

#define MUSIC_TYPE_LIBRARY_WINDOW_INTERFACE (music_library_window_interface_get_type ())
#define MUSIC_LIBRARY_WINDOW_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_LIBRARY_WINDOW_INTERFACE, MusicLibraryWindowInterface))
#define MUSIC_IS_LIBRARY_WINDOW_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_LIBRARY_WINDOW_INTERFACE))
#define MUSIC_LIBRARY_WINDOW_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MUSIC_TYPE_LIBRARY_WINDOW_INTERFACE, MusicLibraryWindowInterfaceIface))

typedef struct _MusicLibraryWindowInterface MusicLibraryWindowInterface;
typedef struct _MusicLibraryWindowInterfaceIface MusicLibraryWindowInterfaceIface;
typedef struct _MusicMediaPrivate MusicMediaPrivate;

#define MUSIC_TYPE_NOTIFICATION_MANAGER (music_notification_manager_get_type ())
#define MUSIC_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_NOTIFICATION_MANAGER, MusicNotificationManager))
#define MUSIC_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_NOTIFICATION_MANAGER, MusicNotificationManagerClass))
#define MUSIC_IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_NOTIFICATION_MANAGER))
#define MUSIC_IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_NOTIFICATION_MANAGER))
#define MUSIC_NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_NOTIFICATION_MANAGER, MusicNotificationManagerClass))

typedef struct _MusicNotificationManager MusicNotificationManager;
typedef struct _MusicNotificationManagerClass MusicNotificationManagerClass;
typedef struct _MusicNotificationManagerPrivate MusicNotificationManagerPrivate;

#define MUSIC_PLUGINS_TYPE_INTERFACE (music_plugins_interface_get_type ())
#define MUSIC_PLUGINS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_PLUGINS_TYPE_INTERFACE, MusicPluginsInterface))
#define MUSIC_PLUGINS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_PLUGINS_TYPE_INTERFACE, MusicPluginsInterfaceClass))
#define MUSIC_PLUGINS_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_PLUGINS_TYPE_INTERFACE))
#define MUSIC_PLUGINS_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_PLUGINS_TYPE_INTERFACE))
#define MUSIC_PLUGINS_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_PLUGINS_TYPE_INTERFACE, MusicPluginsInterfaceClass))

typedef struct _MusicPluginsInterface MusicPluginsInterface;
typedef struct _MusicPluginsInterfaceClass MusicPluginsInterfaceClass;
typedef struct _MusicPluginsInterfacePrivate MusicPluginsInterfacePrivate;
typedef enum  {
	MUSIC_PLUGINS_INTERFACE_HOOK_CONTEXT,
	MUSIC_PLUGINS_INTERFACE_HOOK_SIDEBAR,
	MUSIC_PLUGINS_INTERFACE_HOOK_TOOLBAR,
	MUSIC_PLUGINS_INTERFACE_HOOK_SOURCE_VIEW,
	MUSIC_PLUGINS_INTERFACE_HOOK_SETTINGS_WINDOW,
	MUSIC_PLUGINS_INTERFACE_HOOK_WINDOW
} MusicPluginsInterfaceHook;

#define MUSIC_PLUGINS_INTERFACE_TYPE_HOOK (music_plugins_interface_hook_get_type ())

#define MUSIC_PLUGINS_TYPE_MANAGER (music_plugins_manager_get_type ())
#define MUSIC_PLUGINS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_PLUGINS_TYPE_MANAGER, MusicPluginsManager))
#define MUSIC_PLUGINS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_PLUGINS_TYPE_MANAGER, MusicPluginsManagerClass))
#define MUSIC_PLUGINS_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_PLUGINS_TYPE_MANAGER))
#define MUSIC_PLUGINS_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_PLUGINS_TYPE_MANAGER))
#define MUSIC_PLUGINS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_PLUGINS_TYPE_MANAGER, MusicPluginsManagerClass))

typedef struct _MusicPluginsManager MusicPluginsManager;
typedef struct _MusicPluginsManagerClass MusicPluginsManagerClass;
typedef void (*MusicPluginsInterfaceHookFunctionArg) (GObject* object, gpointer user_data);
typedef void (*MusicPluginsInterfaceHookFunction) (gpointer user_data);
typedef struct _MusicPluginsManagerPrivate MusicPluginsManagerPrivate;

#define MUSIC_SETTINGS_TYPE_MAIN (music_settings_main_get_type ())
#define MUSIC_SETTINGS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_SETTINGS_TYPE_MAIN, MusicSettingsMain))
#define MUSIC_SETTINGS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_SETTINGS_TYPE_MAIN, MusicSettingsMainClass))
#define MUSIC_SETTINGS_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_SETTINGS_TYPE_MAIN))
#define MUSIC_SETTINGS_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_SETTINGS_TYPE_MAIN))
#define MUSIC_SETTINGS_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_SETTINGS_TYPE_MAIN, MusicSettingsMainClass))

typedef struct _MusicSettingsMain MusicSettingsMain;
typedef struct _MusicSettingsMainClass MusicSettingsMainClass;
typedef struct _MusicSettingsMainPrivate MusicSettingsMainPrivate;

#define MUSIC_TYPE_DEVICE (music_device_get_type ())
#define MUSIC_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_DEVICE, MusicDevice))
#define MUSIC_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_DEVICE))
#define MUSIC_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MUSIC_TYPE_DEVICE, MusicDeviceIface))

typedef struct _MusicDevice MusicDevice;
typedef struct _MusicDeviceIface MusicDeviceIface;

#define MUSIC_TYPE_DEVICE_MANAGER (music_device_manager_get_type ())
#define MUSIC_DEVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_DEVICE_MANAGER, MusicDeviceManager))
#define MUSIC_DEVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_DEVICE_MANAGER, MusicDeviceManagerClass))
#define MUSIC_IS_DEVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_DEVICE_MANAGER))
#define MUSIC_IS_DEVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_DEVICE_MANAGER))
#define MUSIC_DEVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_DEVICE_MANAGER, MusicDeviceManagerClass))

typedef struct _MusicDeviceManager MusicDeviceManager;
typedef struct _MusicDeviceManagerClass MusicDeviceManagerClass;
typedef struct _MusicDeviceManagerPrivate MusicDeviceManagerPrivate;

#define MUSIC_TYPE_PIPELINE (music_pipeline_get_type ())
#define MUSIC_PIPELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PIPELINE, MusicPipeline))
#define MUSIC_PIPELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_PIPELINE, MusicPipelineClass))
#define MUSIC_IS_PIPELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PIPELINE))
#define MUSIC_IS_PIPELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_PIPELINE))
#define MUSIC_PIPELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_PIPELINE, MusicPipelineClass))

typedef struct _MusicPipeline MusicPipeline;
typedef struct _MusicPipelineClass MusicPipelineClass;
typedef struct _MusicPipelinePrivate MusicPipelinePrivate;

#define MUSIC_TYPE_EQUALIZER (music_equalizer_get_type ())
#define MUSIC_EQUALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_EQUALIZER, MusicEqualizer))
#define MUSIC_EQUALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_EQUALIZER, MusicEqualizerClass))
#define MUSIC_IS_EQUALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_EQUALIZER))
#define MUSIC_IS_EQUALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_EQUALIZER))
#define MUSIC_EQUALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_EQUALIZER, MusicEqualizerClass))

typedef struct _MusicEqualizer MusicEqualizer;
typedef struct _MusicEqualizerClass MusicEqualizerClass;
typedef struct _MusicEqualizerPrivate MusicEqualizerPrivate;

#define MUSIC_TYPE_PLAYBACK (music_playback_get_type ())
#define MUSIC_PLAYBACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PLAYBACK, MusicPlayback))
#define MUSIC_IS_PLAYBACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PLAYBACK))
#define MUSIC_PLAYBACK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MUSIC_TYPE_PLAYBACK, MusicPlaybackIface))

typedef struct _MusicPlayback MusicPlayback;
typedef struct _MusicPlaybackIface MusicPlaybackIface;
typedef struct _MusicPlaylistPrivate MusicPlaylistPrivate;
typedef struct _MusicSmartPlaylistPrivate MusicSmartPlaylistPrivate;

#define MUSIC_TYPE_SMART_QUERY (music_smart_query_get_type ())
#define MUSIC_SMART_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_SMART_QUERY, MusicSmartQuery))
#define MUSIC_SMART_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_SMART_QUERY, MusicSmartQueryClass))
#define MUSIC_IS_SMART_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_SMART_QUERY))
#define MUSIC_IS_SMART_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_SMART_QUERY))
#define MUSIC_SMART_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_SMART_QUERY, MusicSmartQueryClass))

typedef struct _MusicSmartQuery MusicSmartQuery;
typedef struct _MusicSmartQueryClass MusicSmartQueryClass;
typedef enum  {
	MUSIC_SMART_PLAYLIST_CONDITIONAL_TYPE_ALL = TRUE,
	MUSIC_SMART_PLAYLIST_CONDITIONAL_TYPE_ANY = FALSE
} MusicSmartPlaylistConditionalType;

#define MUSIC_SMART_PLAYLIST_TYPE_CONDITIONAL_TYPE (music_smart_playlist_conditional_type_get_type ())
typedef struct _MusicSmartQueryPrivate MusicSmartQueryPrivate;
typedef enum  {
	MUSIC_SMART_QUERY_COMPARATOR_TYPE_IS,
	MUSIC_SMART_QUERY_COMPARATOR_TYPE_IS_NOT,
	MUSIC_SMART_QUERY_COMPARATOR_TYPE_CONTAINS,
	MUSIC_SMART_QUERY_COMPARATOR_TYPE_NOT_CONTAINS,
	MUSIC_SMART_QUERY_COMPARATOR_TYPE_IS_EXACTLY,
	MUSIC_SMART_QUERY_COMPARATOR_TYPE_IS_AT_MOST,
	MUSIC_SMART_QUERY_COMPARATOR_TYPE_IS_AT_LEAST,
	MUSIC_SMART_QUERY_COMPARATOR_TYPE_IS_WITHIN,
	MUSIC_SMART_QUERY_COMPARATOR_TYPE_IS_BEFORE
} MusicSmartQueryComparatorType;

#define MUSIC_SMART_QUERY_TYPE_COMPARATOR_TYPE (music_smart_query_comparator_type_get_type ())
typedef enum  {
	MUSIC_SMART_QUERY_FIELD_TYPE_ALBUM,
	MUSIC_SMART_QUERY_FIELD_TYPE_ARTIST,
	MUSIC_SMART_QUERY_FIELD_TYPE_BITRATE,
	MUSIC_SMART_QUERY_FIELD_TYPE_COMMENT,
	MUSIC_SMART_QUERY_FIELD_TYPE_COMPOSER,
	MUSIC_SMART_QUERY_FIELD_TYPE_DATE_ADDED,
	MUSIC_SMART_QUERY_FIELD_TYPE_GENRE,
	MUSIC_SMART_QUERY_FIELD_TYPE_GROUPING,
	MUSIC_SMART_QUERY_FIELD_TYPE_LAST_PLAYED,
	MUSIC_SMART_QUERY_FIELD_TYPE_LENGTH,
	MUSIC_SMART_QUERY_FIELD_TYPE_PLAYCOUNT,
	MUSIC_SMART_QUERY_FIELD_TYPE_RATING,
	MUSIC_SMART_QUERY_FIELD_TYPE_SKIPCOUNT,
	MUSIC_SMART_QUERY_FIELD_TYPE_TITLE,
	MUSIC_SMART_QUERY_FIELD_TYPE_YEAR,
	MUSIC_SMART_QUERY_FIELD_TYPE_URI
} MusicSmartQueryFieldType;

#define MUSIC_SMART_QUERY_TYPE_FIELD_TYPE (music_smart_query_field_type_get_type ())
typedef struct _MusicStaticPlaylistPrivate MusicStaticPlaylistPrivate;

#define MUSIC_TYPE_ICON (music_icon_get_type ())
#define MUSIC_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_ICON, MusicIcon))
#define MUSIC_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_ICON, MusicIconClass))
#define MUSIC_IS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_ICON))
#define MUSIC_IS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_ICON))
#define MUSIC_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_ICON, MusicIconClass))

typedef struct _MusicIcon MusicIcon;
typedef struct _MusicIconClass MusicIconClass;
typedef struct _MusicIconPrivate MusicIconPrivate;

#define MUSIC_WIDGETS_TYPE_ALBUM_IMAGE (music_widgets_album_image_get_type ())
#define MUSIC_WIDGETS_ALBUM_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_WIDGETS_TYPE_ALBUM_IMAGE, MusicWidgetsAlbumImage))
#define MUSIC_WIDGETS_ALBUM_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_WIDGETS_TYPE_ALBUM_IMAGE, MusicWidgetsAlbumImageClass))
#define MUSIC_WIDGETS_IS_ALBUM_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_WIDGETS_TYPE_ALBUM_IMAGE))
#define MUSIC_WIDGETS_IS_ALBUM_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_WIDGETS_TYPE_ALBUM_IMAGE))
#define MUSIC_WIDGETS_ALBUM_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_WIDGETS_TYPE_ALBUM_IMAGE, MusicWidgetsAlbumImageClass))

typedef struct _MusicWidgetsAlbumImage MusicWidgetsAlbumImage;
typedef struct _MusicWidgetsAlbumImageClass MusicWidgetsAlbumImageClass;
typedef struct _MusicWidgetsAlbumImagePrivate MusicWidgetsAlbumImagePrivate;

struct _MusicAlbum {
	GObject parent_instance;
	MusicAlbumPrivate * priv;
};

struct _MusicAlbumClass {
	GObjectClass parent_class;
};

struct _MusicEqualizerPreset {
	GObject parent_instance;
	MusicEqualizerPresetPrivate * priv;
	GeeArrayList* gains;
};

struct _MusicEqualizerPresetClass {
	GObjectClass parent_class;
};

struct _MusicLibrariesManager {
	GObject parent_instance;
	MusicLibrariesManagerPrivate * priv;
	gdouble progress;
	gchar* current_operation;
	MusicLibrary* local_library;
};

struct _MusicLibrariesManagerClass {
	GObjectClass parent_class;
};

struct _MusicLibrary {
	GObject parent_instance;
	MusicLibraryPrivate * priv;
};

struct _MusicLibraryClass {
	GObjectClass parent_class;
	void (*initialize_library) (MusicLibrary* self);
	void (*add_files_to_library) (MusicLibrary* self, GeeCollection* files);
	GeeCollection* (*get_medias) (MusicLibrary* self);
	GeeCollection* (*get_playlists) (MusicLibrary* self);
	GeeCollection* (*get_smart_playlists) (MusicLibrary* self);
	void (*search_medias) (MusicLibrary* self, const gchar* search);
	GeeCollection* (*get_search_result) (MusicLibrary* self);
	void (*add_media) (MusicLibrary* self, MusicMedia* s);
	void (*add_medias) (MusicLibrary* self, GeeCollection* new_media);
	MusicMedia* (*find_media) (MusicLibrary* self, MusicMedia* to_find);
	MusicMedia* (*media_from_file) (MusicLibrary* self, GFile* file);
	MusicMedia* (*media_from_uri) (MusicLibrary* self, const gchar* uri);
	MusicMedia* (*media_from_id) (MusicLibrary* self, gint64 id);
	GeeCollection* (*medias_from_uris) (MusicLibrary* self, GeeCollection* uris);
	GeeCollection* (*medias_from_ids) (MusicLibrary* self, GeeCollection* ids);
	void (*update_media) (MusicLibrary* self, MusicMedia* s, gboolean update_meta, gboolean record_time);
	void (*update_medias) (MusicLibrary* self, GeeCollection* updates, gboolean update_meta, gboolean record_time);
	void (*remove_media) (MusicLibrary* self, MusicMedia* s, gboolean trash);
	void (*remove_medias) (MusicLibrary* self, GeeCollection* to_remove, gboolean trash);
	gboolean (*support_smart_playlists) (MusicLibrary* self);
	void (*add_smart_playlist) (MusicLibrary* self, MusicSmartPlaylist* p);
	void (*remove_smart_playlist) (MusicLibrary* self, gint64 id);
	MusicSmartPlaylist* (*smart_playlist_from_id) (MusicLibrary* self, gint64 id);
	MusicSmartPlaylist* (*smart_playlist_from_name) (MusicLibrary* self, const gchar* name);
	gboolean (*support_playlists) (MusicLibrary* self);
	void (*add_playlist) (MusicLibrary* self, MusicStaticPlaylist* p);
	void (*remove_playlist) (MusicLibrary* self, gint64 id);
	MusicStaticPlaylist* (*playlist_from_id) (MusicLibrary* self, gint64 id);
	MusicStaticPlaylist* (*playlist_from_name) (MusicLibrary* self, const gchar* name);
	gboolean (*start_file_operations) (MusicLibrary* self, const gchar* message);
	gboolean (*doing_file_operations) (MusicLibrary* self);
	void (*finish_file_operations) (MusicLibrary* self);
};

struct _MusicLibraryWindowInterfaceIface {
	GTypeInterface parent_iface;
	void (*update_sensitivities) (MusicLibraryWindowInterface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_sensitivities_finish) (MusicLibraryWindowInterface* self, GAsyncResult* _res_);
};

struct _MusicMedia {
	GObject parent_instance;
	MusicMediaPrivate * priv;
	guint _rating;
};

struct _MusicMediaClass {
	GObjectClass parent_class;
	gchar* (*get_uri) (MusicMedia* self);
	void (*set_uri) (MusicMedia* self, const gchar* value);
	guint64 (*get_file_size) (MusicMedia* self);
	void (*set_file_size) (MusicMedia* self, guint64 value);
	gboolean (*get_file_exists) (MusicMedia* self);
	GFile* (*get_file) (MusicMedia* self);
	void (*set_file) (MusicMedia* self, GFile* value);
	gboolean (*get_is_preview) (MusicMedia* self);
	void (*set_is_preview) (MusicMedia* self, gboolean value);
	gboolean (*get_is_temporary) (MusicMedia* self);
	void (*set_is_temporary) (MusicMedia* self, gboolean value);
	gboolean (*get_location_unknown) (MusicMedia* self);
	void (*set_location_unknown) (MusicMedia* self, gboolean value);
	gboolean (*get_has_embedded) (MusicMedia* self);
	void (*set_has_embedded) (MusicMedia* self, gboolean value);
	GIcon* (*get_unique_status_image) (MusicMedia* self);
	void (*set_unique_status_image) (MusicMedia* self, GIcon* value);
	gboolean (*get_show_indicator) (MusicMedia* self);
	void (*set_show_indicator) (MusicMedia* self, gboolean value);
	const gchar* (*get_title) (MusicMedia* self);
	void (*set_title) (MusicMedia* self, const gchar* value);
	guint (*get_track) (MusicMedia* self);
	void (*set_track) (MusicMedia* self, guint value);
	guint (*get_track_count) (MusicMedia* self);
	void (*set_track_count) (MusicMedia* self, guint value);
	const gchar* (*get_composer) (MusicMedia* self);
	void (*set_composer) (MusicMedia* self, const gchar* value);
	const gchar* (*get_artist) (MusicMedia* self);
	void (*set_artist) (MusicMedia* self, const gchar* value);
	const gchar* (*get_album_artist) (MusicMedia* self);
	void (*set_album_artist) (MusicMedia* self, const gchar* value);
	const gchar* (*get_album) (MusicMedia* self);
	void (*set_album) (MusicMedia* self, const gchar* value);
	guint (*get_album_number) (MusicMedia* self);
	void (*set_album_number) (MusicMedia* self, guint value);
	guint (*get_album_count) (MusicMedia* self);
	void (*set_album_count) (MusicMedia* self, guint value);
	MusicAlbum* (*get_album_info) (MusicMedia* self);
	void (*set_album_info) (MusicMedia* self, MusicAlbum* value);
	const gchar* (*get_grouping) (MusicMedia* self);
	void (*set_grouping) (MusicMedia* self, const gchar* value);
	const gchar* (*get_genre) (MusicMedia* self);
	void (*set_genre) (MusicMedia* self, const gchar* value);
	const gchar* (*get_comment) (MusicMedia* self);
	void (*set_comment) (MusicMedia* self, const gchar* value);
	const gchar* (*get_lyrics) (MusicMedia* self);
	void (*set_lyrics) (MusicMedia* self, const gchar* value);
	guint (*get_year) (MusicMedia* self);
	void (*set_year) (MusicMedia* self, guint value);
	guint (*get_bitrate) (MusicMedia* self);
	void (*set_bitrate) (MusicMedia* self, guint value);
	guint (*get_bpm) (MusicMedia* self);
	void (*set_bpm) (MusicMedia* self, guint value);
	guint (*get_samplerate) (MusicMedia* self);
	void (*set_samplerate) (MusicMedia* self, guint value);
	guint (*get_length) (MusicMedia* self);
	void (*set_length) (MusicMedia* self, guint value);
	guint (*get_rating) (MusicMedia* self);
	void (*set_rating) (MusicMedia* self, guint value);
	guint (*get_play_count) (MusicMedia* self);
	void (*set_play_count) (MusicMedia* self, guint value);
	guint (*get_skip_count) (MusicMedia* self);
	void (*set_skip_count) (MusicMedia* self, guint value);
	guint (*get_date_added) (MusicMedia* self);
	void (*set_date_added) (MusicMedia* self, guint value);
	guint (*get_last_played) (MusicMedia* self);
	void (*set_last_played) (MusicMedia* self, guint value);
	guint (*get_last_modified) (MusicMedia* self);
	void (*set_last_modified) (MusicMedia* self, guint value);
	gint (*get_resume_pos) (MusicMedia* self);
	void (*set_resume_pos) (MusicMedia* self, gint value);
	gboolean (*get_show) (MusicMedia* self);
	void (*set_show) (MusicMedia* self, gboolean value);
};

struct _MusicNotificationManager {
	GObject parent_instance;
	MusicNotificationManagerPrivate * priv;
};

struct _MusicNotificationManagerClass {
	GObjectClass parent_class;
};

struct _MusicPluginsInterface {
	GObject parent_instance;
	MusicPluginsInterfacePrivate * priv;
};

struct _MusicPluginsInterfaceClass {
	GObjectClass parent_class;
};

struct _MusicPluginsManager {
	GObject parent_instance;
	MusicPluginsManagerPrivate * priv;
};

struct _MusicPluginsManagerClass {
	GObjectClass parent_class;
};

struct _MusicSettingsMain {
	GraniteServicesSettings parent_instance;
	MusicSettingsMainPrivate * priv;
};

struct _MusicSettingsMainClass {
	GraniteServicesSettingsClass parent_class;
};

struct _MusicDeviceIface {
	GTypeInterface parent_iface;
	gboolean (*start_initialization) (MusicDevice* self);
	void (*finish_initialization) (MusicDevice* self);
	gchar* (*get_content_type) (MusicDevice* self);
	gchar* (*get_display_name) (MusicDevice* self);
	gchar* (*get_empty_device_title) (MusicDevice* self);
	gchar* (*get_empty_device_description) (MusicDevice* self);
	void (*set_display_name) (MusicDevice* self, const gchar* name);
	gchar* (*get_fancy_description) (MusicDevice* self);
	void (*set_mount) (MusicDevice* self, GMount* mount);
	GMount* (*get_mount) (MusicDevice* self);
	gchar* (*get_uri) (MusicDevice* self);
	void (*set_icon) (MusicDevice* self, GIcon* icon);
	GIcon* (*get_icon) (MusicDevice* self);
	guint64 (*get_capacity) (MusicDevice* self);
	gchar* (*get_fancy_capacity) (MusicDevice* self);
	guint64 (*get_used_space) (MusicDevice* self);
	guint64 (*get_free_space) (MusicDevice* self);
	void (*unmount) (MusicDevice* self);
	void (*eject) (MusicDevice* self);
	void (*synchronize) (MusicDevice* self);
	gboolean (*only_use_custom_view) (MusicDevice* self);
	GtkWidget* (*get_custom_view) (MusicDevice* self);
	gboolean (*read_only) (MusicDevice* self);
	MusicLibrary* (*get_library) (MusicDevice* self);
	gchar* (*get_unique_identifier) (MusicDevice* self);
};

struct _MusicDeviceManager {
	GObject parent_instance;
	MusicDeviceManagerPrivate * priv;
};

struct _MusicDeviceManagerClass {
	GObjectClass parent_class;
	void (*mount_changed) (MusicDeviceManager* self, GMount* mount);
	void (*mount_pre_unmount) (MusicDeviceManager* self, GMount* mount);
};

struct _MusicPipeline {
	GObject parent_instance;
	MusicPipelinePrivate * priv;
	GstPipeline* pipe;
	MusicEqualizer* eq;
	GstBus* bus;
	GstPad* pad;
	GstElement* audiosink;
	GstElement* audiosinkqueue;
	GstElement* eq_audioconvert;
	GstElement* eq_audioconvert2;
	GstElement* playbin;
	GstElement* audiotee;
	GstElement* audiobin;
	GstElement* preamp;
};

struct _MusicPipelineClass {
	GObjectClass parent_class;
};

struct _MusicEqualizer {
	GObject parent_instance;
	MusicEqualizerPrivate * priv;
	GstElement* element;
};

struct _MusicEqualizerClass {
	GObjectClass parent_class;
};

struct _MusicPlaybackIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_supported_uri) (MusicPlayback* self);
	void (*play) (MusicPlayback* self);
	void (*pause) (MusicPlayback* self);
	void (*set_state) (MusicPlayback* self, GstState s);
	void (*set_media) (MusicPlayback* self, MusicMedia* media);
	void (*set_position) (MusicPlayback* self, gint64 pos);
	gint64 (*get_position) (MusicPlayback* self);
	gint64 (*get_duration) (MusicPlayback* self);
	void (*set_volume) (MusicPlayback* self, gdouble val);
	gdouble (*get_volume) (MusicPlayback* self);
	gboolean (*update_position) (MusicPlayback* self);
	void (*enable_equalizer) (MusicPlayback* self);
	void (*disable_equalizer) (MusicPlayback* self);
	void (*set_equalizer_gain) (MusicPlayback* self, gint index, gint val);
};

struct _MusicPlaylist {
	GObject parent_instance;
	MusicPlaylistPrivate * priv;
	GIcon* icon;
	gchar* _name;
};

struct _MusicPlaylistClass {
	GObjectClass parent_class;
	void (*add_media) (MusicPlaylist* self, MusicMedia* to_remove);
	void (*add_medias) (MusicPlaylist* self, GeeCollection* to_add);
	void (*remove_media) (MusicPlaylist* self, MusicMedia* to_remove);
	void (*remove_medias) (MusicPlaylist* self, GeeCollection* to_remove);
	void (*clear) (MusicPlaylist* self);
	GeeArrayList* (*get_medias) (MusicPlaylist* self);
	void (*set_medias) (MusicPlaylist* self, GeeArrayList* value);
	const gchar* (*get_name) (MusicPlaylist* self);
	void (*set_name) (MusicPlaylist* self, const gchar* value);
};

struct _MusicSmartPlaylist {
	MusicPlaylist parent_instance;
	MusicSmartPlaylistPrivate * priv;
	GeeTreeSet* queries;
};

struct _MusicSmartPlaylistClass {
	MusicPlaylistClass parent_class;
	void (*analyse_all) (MusicSmartPlaylist* self);
	void (*clear_queries) (MusicSmartPlaylist* self);
	GeeCollection* (*get_queries) (MusicSmartPlaylist* self);
	void (*add_query) (MusicSmartPlaylist* self, MusicSmartQuery* s);
	void (*add_queries) (MusicSmartPlaylist* self, GeeCollection* queries);
	MusicSmartPlaylistConditionalType (*get_conditional) (MusicSmartPlaylist* self);
	void (*set_conditional) (MusicSmartPlaylist* self, MusicSmartPlaylistConditionalType value);
	gboolean (*get_limit) (MusicSmartPlaylist* self);
	void (*set_limit) (MusicSmartPlaylist* self, gboolean value);
	guint (*get_limit_amount) (MusicSmartPlaylist* self);
	void (*set_limit_amount) (MusicSmartPlaylist* self, guint value);
};

struct _MusicSmartQuery {
	GObject parent_instance;
	MusicSmartQueryPrivate * priv;
};

struct _MusicSmartQueryClass {
	GObjectClass parent_class;
};

struct _MusicStaticPlaylist {
	MusicPlaylist parent_instance;
	MusicStaticPlaylistPrivate * priv;
};

struct _MusicStaticPlaylistClass {
	MusicPlaylistClass parent_class;
};

struct _MusicIcon {
	GObject parent_instance;
	MusicIconPrivate * priv;
};

struct _MusicIconClass {
	GObjectClass parent_class;
};

struct _MusicWidgetsAlbumImage {
	GtkGrid parent_instance;
	MusicWidgetsAlbumImagePrivate * priv;
	GtkImage* image;
};

struct _MusicWidgetsAlbumImageClass {
	GtkGridClass parent_class;
};

VALA_EXTERN GType music_album_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicAlbum, g_object_unref)
VALA_EXTERN MusicAlbum* music_album_new (const gchar* name,
                             const gchar* artist);
VALA_EXTERN MusicAlbum* music_album_construct (GType object_type,
                                   const gchar* name,
                                   const gchar* artist);
VALA_EXTERN GType music_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicMedia, g_object_unref)
VALA_EXTERN MusicAlbum* music_album_new_from_media (MusicMedia* media);
VALA_EXTERN MusicAlbum* music_album_construct_from_media (GType object_type,
                                              MusicMedia* media);
VALA_EXTERN gchar* music_album_get_display_name (MusicAlbum* self);
VALA_EXTERN gchar* music_album_get_display_artist (MusicAlbum* self);
VALA_EXTERN gboolean music_album_is_compatible (MusicAlbum* self,
                                    MusicMedia* m);
VALA_EXTERN void music_album_remove_media (MusicAlbum* self,
                               MusicMedia* m);
VALA_EXTERN void music_album_add_media (MusicAlbum* self,
                            MusicMedia* m);
VALA_EXTERN guint music_album_get_hashkey (MusicAlbum* self);
VALA_EXTERN GeeCollection* music_album_get_media (MusicAlbum* self,
                                      guint n_disc);
VALA_EXTERN GdkPixbuf* music_album_get_cached_cover_pixbuf (MusicAlbum* self,
                                                gint scale);
VALA_EXTERN void music_album_save_cover_file (MusicAlbum* self,
                                  GFile* file);
VALA_EXTERN void music_album_save_cover_pixbuf (MusicAlbum* self,
                                    GdkPixbuf* pixbuf);
VALA_EXTERN GFile* music_album_get_cached_cover_file (MusicAlbum* self);
VALA_EXTERN const gchar* music_album_get_artist (MusicAlbum* self);
VALA_EXTERN void music_album_set_artist (MusicAlbum* self,
                             const gchar* value);
VALA_EXTERN const gchar* music_album_get_name (MusicAlbum* self);
VALA_EXTERN void music_album_set_name (MusicAlbum* self,
                           const gchar* value);
VALA_EXTERN guint music_album_get_year (MusicAlbum* self);
VALA_EXTERN void music_album_set_year (MusicAlbum* self,
                           guint value);
VALA_EXTERN GIcon* music_album_get_cover_icon (MusicAlbum* self);
VALA_EXTERN void music_album_set_cover_icon (MusicAlbum* self,
                                 GIcon* value);
VALA_EXTERN gboolean music_album_get_is_empty (MusicAlbum* self);
VALA_EXTERN GType music_equalizer_preset_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicEqualizerPreset, g_object_unref)
VALA_EXTERN MusicEqualizerPreset* music_equalizer_preset_new_basic (const gchar* name);
VALA_EXTERN MusicEqualizerPreset* music_equalizer_preset_construct_basic (GType object_type,
                                                              const gchar* name);
VALA_EXTERN MusicEqualizerPreset* music_equalizer_preset_new_with_gains (const gchar* name,
                                                             gint* items,
                                                             gint items_length1);
VALA_EXTERN MusicEqualizerPreset* music_equalizer_preset_construct_with_gains (GType object_type,
                                                                   const gchar* name,
                                                                   gint* items,
                                                                   gint items_length1);
VALA_EXTERN MusicEqualizerPreset* music_equalizer_preset_new_from_string (const gchar* data);
VALA_EXTERN MusicEqualizerPreset* music_equalizer_preset_construct_from_string (GType object_type,
                                                                    const gchar* data);
VALA_EXTERN gchar* music_equalizer_preset_to_string (MusicEqualizerPreset* self);
VALA_EXTERN void music_equalizer_preset_set_gain (MusicEqualizerPreset* self,
                                      gint index,
                                      gint val);
VALA_EXTERN gint music_equalizer_preset_get_gain (MusicEqualizerPreset* self,
                                      gint index);
VALA_EXTERN MusicEqualizerPreset* music_equalizer_preset_new (void);
VALA_EXTERN MusicEqualizerPreset* music_equalizer_preset_construct (GType object_type);
VALA_EXTERN const gchar* music_equalizer_preset_get_name (MusicEqualizerPreset* self);
VALA_EXTERN void music_equalizer_preset_set_name (MusicEqualizerPreset* self,
                                      const gchar* value);
VALA_EXTERN gboolean music_equalizer_preset_get_is_default (MusicEqualizerPreset* self);
VALA_EXTERN void music_equalizer_preset_set_is_default (MusicEqualizerPreset* self,
                                            gboolean value);
VALA_EXTERN GType music_libraries_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicLibrariesManager, g_object_unref)
VALA_EXTERN GType music_library_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicLibrary, g_object_unref)
VALA_EXTERN MusicLibrariesManager* music_libraries_manager_new (void);
VALA_EXTERN MusicLibrariesManager* music_libraries_manager_construct (GType object_type);
VALA_EXTERN void music_libraries_manager_add_library (MusicLibrariesManager* self,
                                          MusicLibrary* library);
VALA_EXTERN void music_libraries_manager_remove_library (MusicLibrariesManager* self,
                                             MusicLibrary* library);
VALA_EXTERN MusicLibrary* music_libraries_manager_get_library_from_index (MusicLibrariesManager* self,
                                                              gint index);
VALA_EXTERN void music_libraries_manager_search_for_string (MusicLibrariesManager* self,
                                                const gchar* search);
VALA_EXTERN void music_libraries_manager_transfer_to_local_library (MusicLibrariesManager* self,
                                                        GeeCollection* to_transfer);
VALA_EXTERN void music_libraries_manager_transfer_medias_async (MusicLibrariesManager* self,
                                                    GeeCollection* list,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN void music_libraries_manager_transfer_medias_finish (MusicLibrariesManager* self,
                                                     GAsyncResult* _res_);
VALA_EXTERN gboolean music_libraries_manager_do_progress_notification_with_timeout (MusicLibrariesManager* self);
VALA_EXTERN GType music_playlist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPlaylist, g_object_unref)
VALA_EXTERN GType music_static_playlist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicStaticPlaylist, g_object_unref)
VALA_EXTERN GType music_smart_playlist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicSmartPlaylist, g_object_unref)
VALA_EXTERN void music_library_initialize_library (MusicLibrary* self);
VALA_EXTERN void music_library_add_files_to_library (MusicLibrary* self,
                                         GeeCollection* files);
VALA_EXTERN GeeCollection* music_library_get_medias (MusicLibrary* self);
VALA_EXTERN GeeCollection* music_library_get_playlists (MusicLibrary* self);
VALA_EXTERN GeeCollection* music_library_get_smart_playlists (MusicLibrary* self);
VALA_EXTERN void music_library_search_medias (MusicLibrary* self,
                                  const gchar* search);
VALA_EXTERN GeeCollection* music_library_get_search_result (MusicLibrary* self);
VALA_EXTERN void music_library_add_media (MusicLibrary* self,
                              MusicMedia* s);
VALA_EXTERN void music_library_add_medias (MusicLibrary* self,
                               GeeCollection* new_media);
VALA_EXTERN MusicMedia* music_library_find_media (MusicLibrary* self,
                                      MusicMedia* to_find);
VALA_EXTERN MusicMedia* music_library_media_from_file (MusicLibrary* self,
                                           GFile* file);
VALA_EXTERN MusicMedia* music_library_media_from_uri (MusicLibrary* self,
                                          const gchar* uri);
VALA_EXTERN MusicMedia* music_library_media_from_id (MusicLibrary* self,
                                         gint64 id);
VALA_EXTERN GeeCollection* music_library_medias_from_uris (MusicLibrary* self,
                                               GeeCollection* uris);
VALA_EXTERN GeeCollection* music_library_medias_from_ids (MusicLibrary* self,
                                              GeeCollection* ids);
VALA_EXTERN void music_library_update_media (MusicLibrary* self,
                                 MusicMedia* s,
                                 gboolean update_meta,
                                 gboolean record_time);
VALA_EXTERN void music_library_update_medias (MusicLibrary* self,
                                  GeeCollection* updates,
                                  gboolean update_meta,
                                  gboolean record_time);
VALA_EXTERN void music_library_remove_media (MusicLibrary* self,
                                 MusicMedia* s,
                                 gboolean trash);
VALA_EXTERN void music_library_remove_medias (MusicLibrary* self,
                                  GeeCollection* to_remove,
                                  gboolean trash);
VALA_EXTERN gboolean music_library_support_smart_playlists (MusicLibrary* self);
VALA_EXTERN void music_library_add_smart_playlist (MusicLibrary* self,
                                       MusicSmartPlaylist* p);
VALA_EXTERN void music_library_remove_smart_playlist (MusicLibrary* self,
                                          gint64 id);
VALA_EXTERN MusicSmartPlaylist* music_library_smart_playlist_from_id (MusicLibrary* self,
                                                          gint64 id);
VALA_EXTERN MusicSmartPlaylist* music_library_smart_playlist_from_name (MusicLibrary* self,
                                                            const gchar* name);
VALA_EXTERN gboolean music_library_support_playlists (MusicLibrary* self);
VALA_EXTERN void music_library_add_playlist (MusicLibrary* self,
                                 MusicStaticPlaylist* p);
VALA_EXTERN void music_library_remove_playlist (MusicLibrary* self,
                                    gint64 id);
VALA_EXTERN MusicStaticPlaylist* music_library_playlist_from_id (MusicLibrary* self,
                                                     gint64 id);
VALA_EXTERN MusicStaticPlaylist* music_library_playlist_from_name (MusicLibrary* self,
                                                       const gchar* name);
VALA_EXTERN gboolean music_library_start_file_operations (MusicLibrary* self,
                                              const gchar* message);
VALA_EXTERN gboolean music_library_doing_file_operations (MusicLibrary* self);
VALA_EXTERN void music_library_finish_file_operations (MusicLibrary* self);
VALA_EXTERN gint music_library_playlist_count_without_read_only (MusicLibrary* self);
VALA_EXTERN void music_library_media_from_name (MusicLibrary* self,
                                    GeeCollection* tests,
                                    GeeCollection* found,
                                    GeeCollection* not_found);
VALA_EXTERN MusicLibrary* music_library_construct (GType object_type);
VALA_EXTERN GType music_library_window_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void music_library_window_interface_update_sensitivities (MusicLibraryWindowInterface* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
VALA_EXTERN void music_library_window_interface_update_sensitivities_finish (MusicLibraryWindowInterface* self,
                                                                 GAsyncResult* _res_);
VALA_EXTERN gchar* music_media_UNKNOWN;
VALA_EXTERN gchar* music_media_get_display_filename (MusicMedia* self);
VALA_EXTERN gchar* music_media_get_display_location (MusicMedia* self);
VALA_EXTERN gchar* music_media_get_display_title (MusicMedia* self);
VALA_EXTERN gchar* music_media_get_display_composer (MusicMedia* self);
VALA_EXTERN gchar* music_media_get_display_artist (MusicMedia* self);
VALA_EXTERN gchar* music_media_get_display_album_artist (MusicMedia* self,
                                             gboolean use_artist_fallback);
VALA_EXTERN gchar* music_media_get_display_album (MusicMedia* self);
VALA_EXTERN gchar* music_media_get_display_genre (MusicMedia* self);
VALA_EXTERN gboolean music_media_is_valid_string_field (const gchar* text);
VALA_EXTERN guint music_media_get_album_hashkey (MusicMedia* self);
VALA_EXTERN gchar* music_media_get_title_markup (MusicMedia* self);
VALA_EXTERN MusicMedia* music_media_new (const gchar* uri);
VALA_EXTERN MusicMedia* music_media_construct (GType object_type,
                                   const gchar* uri);
VALA_EXTERN MusicMedia* music_media_new_from_file (GFile* file);
VALA_EXTERN MusicMedia* music_media_construct_from_file (GType object_type,
                                             GFile* file);
VALA_EXTERN MusicMedia* music_media_copy (MusicMedia* self);
VALA_EXTERN gint64 music_media_get_rowid (MusicMedia* self);
VALA_EXTERN void music_media_set_rowid (MusicMedia* self,
                            gint64 value);
VALA_EXTERN gchar* music_media_get_uri (MusicMedia* self);
VALA_EXTERN void music_media_set_uri (MusicMedia* self,
                          const gchar* value);
VALA_EXTERN guint64 music_media_get_file_size (MusicMedia* self);
VALA_EXTERN void music_media_set_file_size (MusicMedia* self,
                                guint64 value);
VALA_EXTERN gboolean music_media_get_file_exists (MusicMedia* self);
VALA_EXTERN GFile* music_media_get_file (MusicMedia* self);
VALA_EXTERN void music_media_set_file (MusicMedia* self,
                           GFile* value);
VALA_EXTERN gboolean music_media_get_is_preview (MusicMedia* self);
VALA_EXTERN void music_media_set_is_preview (MusicMedia* self,
                                 gboolean value);
VALA_EXTERN gboolean music_media_get_is_temporary (MusicMedia* self);
VALA_EXTERN void music_media_set_is_temporary (MusicMedia* self,
                                   gboolean value);
VALA_EXTERN gboolean music_media_get_location_unknown (MusicMedia* self);
VALA_EXTERN void music_media_set_location_unknown (MusicMedia* self,
                                       gboolean value);
VALA_EXTERN gboolean music_media_get_has_embedded (MusicMedia* self);
VALA_EXTERN void music_media_set_has_embedded (MusicMedia* self,
                                   gboolean value);
VALA_EXTERN GIcon* music_media_get_unique_status_image (MusicMedia* self);
VALA_EXTERN void music_media_set_unique_status_image (MusicMedia* self,
                                          GIcon* value);
VALA_EXTERN gboolean music_media_get_show_indicator (MusicMedia* self);
VALA_EXTERN void music_media_set_show_indicator (MusicMedia* self,
                                     gboolean value);
VALA_EXTERN const gchar* music_media_get_title (MusicMedia* self);
VALA_EXTERN void music_media_set_title (MusicMedia* self,
                            const gchar* value);
VALA_EXTERN guint music_media_get_track (MusicMedia* self);
VALA_EXTERN void music_media_set_track (MusicMedia* self,
                            guint value);
VALA_EXTERN guint music_media_get_track_count (MusicMedia* self);
VALA_EXTERN void music_media_set_track_count (MusicMedia* self,
                                  guint value);
VALA_EXTERN const gchar* music_media_get_composer (MusicMedia* self);
VALA_EXTERN void music_media_set_composer (MusicMedia* self,
                               const gchar* value);
VALA_EXTERN const gchar* music_media_get_artist (MusicMedia* self);
VALA_EXTERN void music_media_set_artist (MusicMedia* self,
                             const gchar* value);
VALA_EXTERN const gchar* music_media_get_album_artist (MusicMedia* self);
VALA_EXTERN void music_media_set_album_artist (MusicMedia* self,
                                   const gchar* value);
VALA_EXTERN const gchar* music_media_get_album (MusicMedia* self);
VALA_EXTERN void music_media_set_album (MusicMedia* self,
                            const gchar* value);
VALA_EXTERN guint music_media_get_album_number (MusicMedia* self);
VALA_EXTERN void music_media_set_album_number (MusicMedia* self,
                                   guint value);
VALA_EXTERN guint music_media_get_album_count (MusicMedia* self);
VALA_EXTERN void music_media_set_album_count (MusicMedia* self,
                                  guint value);
VALA_EXTERN MusicAlbum* music_media_get_album_info (MusicMedia* self);
VALA_EXTERN void music_media_set_album_info (MusicMedia* self,
                                 MusicAlbum* value);
VALA_EXTERN const gchar* music_media_get_grouping (MusicMedia* self);
VALA_EXTERN void music_media_set_grouping (MusicMedia* self,
                               const gchar* value);
VALA_EXTERN const gchar* music_media_get_genre (MusicMedia* self);
VALA_EXTERN void music_media_set_genre (MusicMedia* self,
                            const gchar* value);
VALA_EXTERN const gchar* music_media_get_comment (MusicMedia* self);
VALA_EXTERN void music_media_set_comment (MusicMedia* self,
                              const gchar* value);
VALA_EXTERN const gchar* music_media_get_lyrics (MusicMedia* self);
VALA_EXTERN void music_media_set_lyrics (MusicMedia* self,
                             const gchar* value);
VALA_EXTERN guint music_media_get_year (MusicMedia* self);
VALA_EXTERN void music_media_set_year (MusicMedia* self,
                           guint value);
VALA_EXTERN guint music_media_get_bitrate (MusicMedia* self);
VALA_EXTERN void music_media_set_bitrate (MusicMedia* self,
                              guint value);
VALA_EXTERN guint music_media_get_bpm (MusicMedia* self);
VALA_EXTERN void music_media_set_bpm (MusicMedia* self,
                          guint value);
VALA_EXTERN guint music_media_get_samplerate (MusicMedia* self);
VALA_EXTERN void music_media_set_samplerate (MusicMedia* self,
                                 guint value);
VALA_EXTERN guint music_media_get_length (MusicMedia* self);
VALA_EXTERN void music_media_set_length (MusicMedia* self,
                             guint value);
VALA_EXTERN guint music_media_get_rating (MusicMedia* self);
VALA_EXTERN void music_media_set_rating (MusicMedia* self,
                             guint value);
VALA_EXTERN guint music_media_get_play_count (MusicMedia* self);
VALA_EXTERN void music_media_set_play_count (MusicMedia* self,
                                 guint value);
VALA_EXTERN guint music_media_get_skip_count (MusicMedia* self);
VALA_EXTERN void music_media_set_skip_count (MusicMedia* self,
                                 guint value);
VALA_EXTERN guint music_media_get_date_added (MusicMedia* self);
VALA_EXTERN void music_media_set_date_added (MusicMedia* self,
                                 guint value);
VALA_EXTERN guint music_media_get_last_played (MusicMedia* self);
VALA_EXTERN void music_media_set_last_played (MusicMedia* self,
                                  guint value);
VALA_EXTERN guint music_media_get_last_modified (MusicMedia* self);
VALA_EXTERN void music_media_set_last_modified (MusicMedia* self,
                                    guint value);
VALA_EXTERN gint music_media_get_resume_pos (MusicMedia* self);
VALA_EXTERN void music_media_set_resume_pos (MusicMedia* self,
                                 gint value);
VALA_EXTERN gboolean music_media_get_show (MusicMedia* self);
VALA_EXTERN void music_media_set_show (MusicMedia* self,
                           gboolean value);
VALA_EXTERN GType music_notification_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicNotificationManager, g_object_unref)
VALA_EXTERN MusicNotificationManager* music_notification_manager_get_default (void);
VALA_EXTERN MusicNotificationManager* music_notification_manager_new (void);
VALA_EXTERN MusicNotificationManager* music_notification_manager_construct (GType object_type);
VALA_EXTERN GType music_plugins_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPluginsInterface, g_object_unref)
VALA_EXTERN GType music_plugins_interface_hook_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType music_plugins_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPluginsManager, g_object_unref)
VALA_EXTERN MusicPluginsInterface* music_plugins_interface_new (MusicPluginsManager* manager);
VALA_EXTERN MusicPluginsInterface* music_plugins_interface_construct (GType object_type,
                                                          MusicPluginsManager* manager);
VALA_EXTERN void music_plugins_interface_register_function_arg (MusicPluginsInterface* self,
                                                    MusicPluginsInterfaceHook hook,
                                                    MusicPluginsInterfaceHookFunctionArg hook_function,
                                                    gpointer hook_function_target);
VALA_EXTERN void music_plugins_interface_register_function (MusicPluginsInterface* self,
                                                MusicPluginsInterfaceHook hook,
                                                MusicPluginsInterfaceHookFunction hook_function,
                                                gpointer hook_function_target);
VALA_EXTERN MusicPluginsManager* music_plugins_interface_get_manager (MusicPluginsInterface* self);
VALA_EXTERN GtkNotebook* music_plugins_interface_get_context (MusicPluginsInterface* self);
VALA_EXTERN GtkNotebook* music_plugins_interface_get_sidebar (MusicPluginsInterface* self);
VALA_EXTERN GtkApplication* music_plugins_interface_get_noise_app (MusicPluginsInterface* self);
VALA_EXTERN GtkToolbar* music_plugins_interface_get_toolbar (MusicPluginsInterface* self);
VALA_EXTERN GtkWindow* music_plugins_interface_get_window (MusicPluginsInterface* self);
VALA_EXTERN const gchar* music_plugins_interface_get_set_name (MusicPluginsInterface* self);
VALA_EXTERN MusicPluginsManager* music_plugins_manager_get_default (void);
VALA_EXTERN GtkWidget* music_plugins_manager_get_view (MusicPluginsManager* self);
VALA_EXTERN void music_plugins_manager_hook_app (MusicPluginsManager* self,
                                     GtkApplication* app);
VALA_EXTERN void music_plugins_manager_hook_example (MusicPluginsManager* self,
                                         const gchar* arg);
VALA_EXTERN void music_plugins_manager_set_toolbar (MusicPluginsManager* self,
                                        GtkToolbar* value);
VALA_EXTERN void music_plugins_manager_set_noise_app (MusicPluginsManager* self,
                                          GtkApplication* value);
VALA_EXTERN MusicPluginsInterface* music_plugins_manager_get_plugin_iface (MusicPluginsManager* self);
VALA_EXTERN void music_plugins_manager_set_context (MusicPluginsManager* self,
                                        GtkNotebook* value);
VALA_EXTERN void music_plugins_manager_set_sidebar (MusicPluginsManager* self,
                                        GtkNotebook* value);
VALA_EXTERN MusicLibrariesManager* music_libraries_manager;
VALA_EXTERN GType music_settings_main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicSettingsMain, g_object_unref)
VALA_EXTERN MusicSettingsMain* music_settings_main_get_default (void);
VALA_EXTERN gboolean music_settings_main_privacy_mode_enabled (MusicSettingsMain* self);
VALA_EXTERN const gchar* music_settings_main_get_music_mount_name (MusicSettingsMain* self);
VALA_EXTERN void music_settings_main_set_music_mount_name (MusicSettingsMain* self,
                                               const gchar* value);
VALA_EXTERN const gchar* music_settings_main_get_music_folder (MusicSettingsMain* self);
VALA_EXTERN void music_settings_main_set_music_folder (MusicSettingsMain* self,
                                           const gchar* value);
VALA_EXTERN const gchar* music_settings_main_get_path_string (MusicSettingsMain* self);
VALA_EXTERN void music_settings_main_set_path_string (MusicSettingsMain* self,
                                          const gchar* value);
VALA_EXTERN gchar** music_settings_main_get_plugins_disabled (MusicSettingsMain* self,
                                                  gint* result_length1);
VALA_EXTERN void music_settings_main_set_plugins_disabled (MusicSettingsMain* self,
                                               gchar** value,
                                               gint value_length1);
VALA_EXTERN GType music_device_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean music_device_start_initialization (MusicDevice* self);
VALA_EXTERN void music_device_finish_initialization (MusicDevice* self);
VALA_EXTERN gchar* music_device_get_content_type (MusicDevice* self);
VALA_EXTERN gchar* music_device_get_display_name (MusicDevice* self);
VALA_EXTERN gchar* music_device_get_empty_device_title (MusicDevice* self);
VALA_EXTERN gchar* music_device_get_empty_device_description (MusicDevice* self);
VALA_EXTERN void music_device_set_display_name (MusicDevice* self,
                                    const gchar* name);
VALA_EXTERN gchar* music_device_get_fancy_description (MusicDevice* self);
VALA_EXTERN void music_device_set_mount (MusicDevice* self,
                             GMount* mount);
VALA_EXTERN GMount* music_device_get_mount (MusicDevice* self);
VALA_EXTERN gchar* music_device_get_uri (MusicDevice* self);
VALA_EXTERN void music_device_set_icon (MusicDevice* self,
                            GIcon* icon);
VALA_EXTERN GIcon* music_device_get_icon (MusicDevice* self);
VALA_EXTERN guint64 music_device_get_capacity (MusicDevice* self);
VALA_EXTERN gchar* music_device_get_fancy_capacity (MusicDevice* self);
VALA_EXTERN guint64 music_device_get_used_space (MusicDevice* self);
VALA_EXTERN guint64 music_device_get_free_space (MusicDevice* self);
VALA_EXTERN void music_device_unmount (MusicDevice* self);
VALA_EXTERN void music_device_eject (MusicDevice* self);
VALA_EXTERN void music_device_synchronize (MusicDevice* self);
VALA_EXTERN gboolean music_device_only_use_custom_view (MusicDevice* self);
VALA_EXTERN GtkWidget* music_device_get_custom_view (MusicDevice* self);
VALA_EXTERN gboolean music_device_read_only (MusicDevice* self);
VALA_EXTERN MusicLibrary* music_device_get_library (MusicDevice* self);
VALA_EXTERN GeeCollection* music_device_delete_doubles (MusicDevice* self,
                                            GeeCollection* source_list,
                                            GeeCollection* to_remove);
VALA_EXTERN gboolean music_device_will_fit (MusicDevice* self,
                                GeeCollection* list);
VALA_EXTERN gchar* music_device_get_unique_identifier (MusicDevice* self);
VALA_EXTERN GType music_device_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicDeviceManager, g_object_unref)
VALA_EXTERN MusicDeviceManager* music_device_manager_get_default (void);
VALA_EXTERN void music_device_manager_get_pre_existing_mounts (MusicDeviceManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void music_device_manager_get_pre_existing_mounts_finish (MusicDeviceManager* self,
                                                          GAsyncResult* _res_);
VALA_EXTERN void music_device_manager_device_initialized (MusicDeviceManager* self,
                                              MusicDevice* d);
VALA_EXTERN void music_device_manager_mount_changed (MusicDeviceManager* self,
                                         GMount* mount);
VALA_EXTERN void music_device_manager_mount_pre_unmount (MusicDeviceManager* self,
                                             GMount* mount);
VALA_EXTERN GeeCollection* music_device_manager_get_initialized_devices (MusicDeviceManager* self);
VALA_EXTERN GeeCollection* music_device_manager_get_available_mounts (MusicDeviceManager* self);
VALA_EXTERN GType music_pipeline_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPipeline, g_object_unref)
VALA_EXTERN GType music_equalizer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicEqualizer, g_object_unref)
VALA_EXTERN MusicPipeline* music_pipeline_new (void);
VALA_EXTERN MusicPipeline* music_pipeline_construct (GType object_type);
VALA_EXTERN void music_pipeline_enable_equalizer (MusicPipeline* self);
VALA_EXTERN void music_pipeline_disable_equalizer (MusicPipeline* self);
VALA_EXTERN void music_equalizer_set_gain (MusicEqualizer* self,
                               gint index,
                               gdouble gain);
VALA_EXTERN GeeCollection* music_equalizer_get_default_presets (void);
VALA_EXTERN MusicEqualizer* music_equalizer_new (void);
VALA_EXTERN MusicEqualizer* music_equalizer_construct (GType object_type);
VALA_EXTERN GType music_playback_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeCollection* music_playback_get_supported_uri (MusicPlayback* self);
VALA_EXTERN void music_playback_play (MusicPlayback* self);
VALA_EXTERN void music_playback_pause (MusicPlayback* self);
VALA_EXTERN void music_playback_set_state (MusicPlayback* self,
                               GstState s);
VALA_EXTERN void music_playback_set_media (MusicPlayback* self,
                               MusicMedia* media);
VALA_EXTERN void music_playback_set_position (MusicPlayback* self,
                                  gint64 pos);
VALA_EXTERN gint64 music_playback_get_position (MusicPlayback* self);
VALA_EXTERN gint64 music_playback_get_duration (MusicPlayback* self);
VALA_EXTERN void music_playback_set_volume (MusicPlayback* self,
                                gdouble val);
VALA_EXTERN gdouble music_playback_get_volume (MusicPlayback* self);
VALA_EXTERN gboolean music_playback_update_position (MusicPlayback* self);
VALA_EXTERN void music_playback_enable_equalizer (MusicPlayback* self);
VALA_EXTERN void music_playback_disable_equalizer (MusicPlayback* self);
VALA_EXTERN void music_playback_set_equalizer_gain (MusicPlayback* self,
                                        gint index,
                                        gint val);
VALA_EXTERN void music_playlist_add_media (MusicPlaylist* self,
                               MusicMedia* to_remove);
VALA_EXTERN void music_playlist_add_medias (MusicPlaylist* self,
                                GeeCollection* to_add);
VALA_EXTERN void music_playlist_remove_media (MusicPlaylist* self,
                                  MusicMedia* to_remove);
VALA_EXTERN void music_playlist_remove_medias (MusicPlaylist* self,
                                   GeeCollection* to_remove);
VALA_EXTERN void music_playlist_clear (MusicPlaylist* self);
VALA_EXTERN gboolean music_playlist_is_empty (MusicPlaylist* self);
VALA_EXTERN MusicMedia* music_playlist_get (MusicPlaylist* self,
                                gint index);
VALA_EXTERN void music_playlist_set (MusicPlaylist* self,
                         gint index,
                         MusicMedia* m);
VALA_EXTERN GeeIterator* music_playlist_iterator (MusicPlaylist* self);
VALA_EXTERN MusicPlaylist* music_playlist_construct (GType object_type);
VALA_EXTERN GeeArrayList* music_playlist_get_medias (MusicPlaylist* self);
VALA_EXTERN gint64 music_playlist_get_rowid (MusicPlaylist* self);
VALA_EXTERN void music_playlist_set_rowid (MusicPlaylist* self,
                               gint64 value);
VALA_EXTERN const gchar* music_playlist_get_name (MusicPlaylist* self);
VALA_EXTERN void music_playlist_set_name (MusicPlaylist* self,
                              const gchar* value);
VALA_EXTERN GType music_smart_query_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicSmartQuery, g_object_unref)
VALA_EXTERN GType music_smart_playlist_conditional_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN MusicSmartPlaylist* music_smart_playlist_new (MusicLibrary* library);
VALA_EXTERN MusicSmartPlaylist* music_smart_playlist_construct (GType object_type,
                                                    MusicLibrary* library);
VALA_EXTERN void music_smart_playlist_analyse_all (MusicSmartPlaylist* self);
VALA_EXTERN void music_smart_playlist_clear_queries (MusicSmartPlaylist* self);
VALA_EXTERN GeeCollection* music_smart_playlist_get_queries (MusicSmartPlaylist* self);
VALA_EXTERN void music_smart_playlist_add_query (MusicSmartPlaylist* self,
                                     MusicSmartQuery* s);
VALA_EXTERN void music_smart_playlist_add_queries (MusicSmartPlaylist* self,
                                       GeeCollection* queries);
VALA_EXTERN gboolean music_smart_playlist_media_matches_query (MusicSmartQuery* q,
                                                   MusicMedia* s);
VALA_EXTERN MusicSmartPlaylistConditionalType music_smart_playlist_get_conditional (MusicSmartPlaylist* self);
VALA_EXTERN void music_smart_playlist_set_conditional (MusicSmartPlaylist* self,
                                           MusicSmartPlaylistConditionalType value);
VALA_EXTERN gint music_smart_playlist_get_query_count (MusicSmartPlaylist* self);
VALA_EXTERN void music_smart_playlist_set_query_count (MusicSmartPlaylist* self,
                                           gint value);
VALA_EXTERN gboolean music_smart_playlist_get_limit (MusicSmartPlaylist* self);
VALA_EXTERN void music_smart_playlist_set_limit (MusicSmartPlaylist* self,
                                     gboolean value);
VALA_EXTERN guint music_smart_playlist_get_limit_amount (MusicSmartPlaylist* self);
VALA_EXTERN void music_smart_playlist_set_limit_amount (MusicSmartPlaylist* self,
                                            guint value);
VALA_EXTERN MusicLibrary* music_smart_playlist_get_library (MusicSmartPlaylist* self);
VALA_EXTERN void music_smart_playlist_set_library (MusicSmartPlaylist* self,
                                       MusicLibrary* value);
VALA_EXTERN GType music_smart_query_comparator_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType music_smart_query_field_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN MusicSmartQuery* music_smart_query_new (void);
VALA_EXTERN MusicSmartQuery* music_smart_query_construct (GType object_type);
VALA_EXTERN MusicSmartQuery* music_smart_query_new_with_info (MusicSmartQueryFieldType field,
                                                  MusicSmartQueryComparatorType comparator,
                                                  GValue* value);
VALA_EXTERN MusicSmartQuery* music_smart_query_construct_with_info (GType object_type,
                                                        MusicSmartQueryFieldType field,
                                                        MusicSmartQueryComparatorType comparator,
                                                        GValue* value);
VALA_EXTERN gint music_smart_query_get_rowid (MusicSmartQuery* self);
VALA_EXTERN void music_smart_query_set_rowid (MusicSmartQuery* self,
                                  gint value);
VALA_EXTERN MusicSmartQueryFieldType music_smart_query_get_field (MusicSmartQuery* self);
VALA_EXTERN void music_smart_query_set_field (MusicSmartQuery* self,
                                  MusicSmartQueryFieldType value);
VALA_EXTERN MusicSmartQueryComparatorType music_smart_query_get_comparator (MusicSmartQuery* self);
VALA_EXTERN void music_smart_query_set_comparator (MusicSmartQuery* self,
                                       MusicSmartQueryComparatorType value);
VALA_EXTERN void music_smart_query_get_value (MusicSmartQuery* self,
                                  GValue * result);
VALA_EXTERN void music_smart_query_set_value (MusicSmartQuery* self,
                                  GValue * value);
VALA_EXTERN MusicStaticPlaylist* music_static_playlist_new_with_info (gint rowid,
                                                          const gchar* name);
VALA_EXTERN MusicStaticPlaylist* music_static_playlist_construct_with_info (GType object_type,
                                                                gint rowid,
                                                                const gchar* name);
VALA_EXTERN MusicStaticPlaylist* music_static_playlist_new (void);
VALA_EXTERN MusicStaticPlaylist* music_static_playlist_construct (GType object_type);
VALA_EXTERN gboolean music_static_playlist_get_read_only (MusicStaticPlaylist* self);
VALA_EXTERN void music_static_playlist_set_read_only (MusicStaticPlaylist* self,
                                          gboolean value);
VALA_EXTERN gboolean music_static_playlist_get_show_badge (MusicStaticPlaylist* self);
VALA_EXTERN void music_static_playlist_set_show_badge (MusicStaticPlaylist* self,
                                           gboolean value);
VALA_EXTERN gboolean music_static_playlist_get_allow_duplicate (MusicStaticPlaylist* self);
VALA_EXTERN void music_static_playlist_set_allow_duplicate (MusicStaticPlaylist* self,
                                                gboolean value);
VALA_EXTERN gint music_compare_titles (MusicMedia* a,
                           MusicMedia* b);
VALA_EXTERN gint music_compare_genres (MusicMedia* a,
                           MusicMedia* b);
VALA_EXTERN gint music_compare_artists (MusicMedia* a,
                            MusicMedia* b);
VALA_EXTERN gint music_compare_album_artists (MusicMedia* a,
                                  MusicMedia* b);
VALA_EXTERN gint music_compare_albums (MusicMedia* a,
                           MusicMedia* b);
VALA_EXTERN gint music_compare_standard (gint a,
                             gint b);
VALA_EXTERN gint music_compare_standard_unsigned (guint a,
                                      guint b);
VALA_EXTERN gint music_compare_standard_64 (gint64 a,
                                gint64 b);
VALA_EXTERN GFile* music_file_utils_get_data_directory (void);
VALA_EXTERN guint64 music_file_utils_get_size (GFile* file,
                                   GCancellable* cancellable);
VALA_EXTERN gboolean music_file_utils_is_valid_content_type (const gchar* file_content_type,
                                                 gchar** content_types,
                                                 gint content_types_length1);
VALA_EXTERN gint music_file_utils_count_music_files (GFile* music_folder,
                                         GeeCollection* files);
VALA_EXTERN GFile* music_file_utils_get_new_destination (MusicMedia* s);
VALA_EXTERN GType music_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicIcon, g_object_unref)
VALA_EXTERN MusicIcon* music_icon_new (const gchar* name);
VALA_EXTERN MusicIcon* music_icon_construct (GType object_type,
                                 const gchar* name);
VALA_EXTERN GFile* music_icon_get_file (MusicIcon* self,
                            gint size);
VALA_EXTERN GdkPixbuf* music_icon_render (MusicIcon* self,
                              GtkIconSize size,
                              GtkStyleContext* style_context);
VALA_EXTERN const gchar* music_icon_get_name (MusicIcon* self);
VALA_EXTERN GIcon* music_icon_get_gicon (MusicIcon* self);
VALA_EXTERN gboolean music_playlists_utils_save_playlist_m3u (MusicPlaylist* p,
                                                  const gchar* folder_uri,
                                                  const gchar* without_path);
VALA_EXTERN gchar* music_playlists_utils_get_playlist_m3u_file (MusicPlaylist* p,
                                                    const gchar* without_path);
VALA_EXTERN void music_playlists_utils_import_from_playlist_file_info (GeeHashMap* playlists,
                                                           MusicLibrary* library);
VALA_EXTERN gchar* music_playlists_utils_get_new_playlist_name (GeeCollection* playlists,
                                                    const gchar* name);
VALA_EXTERN void music_playlists_utils_export_playlist (MusicPlaylist* p);
VALA_EXTERN GeeHashMap* music_playlists_utils_get_playlists_to_import (const gchar* set_title,
                                                           GError** error);
VALA_EXTERN void music_search_search_in_media_list (GeeCollection* to_search,
                                        GeeCollection** results,
                                        const gchar* album_artist,
                                        const gchar* album,
                                        const gchar* genre,
                                        const gchar* grouping,
                                        const gchar* composer,
                                        gint year,
                                        gint rating,
                                        GCancellable* cancellable);
VALA_EXTERN gboolean music_search_match_fields_to_media (MusicMedia* media,
                                             const gchar* album_artist,
                                             const gchar* album,
                                             const gchar* genre,
                                             const gchar* grouping,
                                             const gchar* composer,
                                             gint year,
                                             gint rating);
VALA_EXTERN gboolean music_search_match_string_to_media (MusicMedia* m,
                                             const gchar* search);
VALA_EXTERN gboolean music_string_is_empty (const gchar* text,
                                gboolean check_white_space);
VALA_EXTERN gint music_string_compare (const gchar* a,
                           const gchar* b);
VALA_EXTERN gboolean music_string_is_white_space (const gchar* text);
VALA_EXTERN void music_string_base_search_method (const gchar* search,
                                      guint* parsed_rating,
                                      gchar** parsed_search_string);
VALA_EXTERN guint64 music_string_uint_from_string (const gchar* str);
VALA_EXTERN gchar* music_time_utils_pretty_timestamp_from_time (struct tm* dt);
VALA_EXTERN guint music_time_utils_nanoseconds_to_miliseconds (guint64 nanoseconds);
VALA_EXTERN guint music_time_utils_nanoseconds_to_seconds (guint64 nanoseconds);
VALA_EXTERN guint64 music_time_utils_seconds_to_nanoseconds (guint64 seconds);
VALA_EXTERN GType music_widgets_album_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicWidgetsAlbumImage, g_object_unref)
VALA_EXTERN MusicWidgetsAlbumImage* music_widgets_album_image_new (void);
VALA_EXTERN MusicWidgetsAlbumImage* music_widgets_album_image_construct (GType object_type);

VALA_EXTERN const gchar* MUSIC_MEDIA_CONTENT_TYPES[50];

G_END_DECLS

#endif
