// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAMA5D31.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,atsama5d31

// Atmel ATSAMA5D31 device: ARM Cortex-A5 processor-based embedded MPU, 536MHz, Linux support, FPU, LCD controller, 10/100 Ethernet, security (refer to http://www.atmel.com/devices/SAMA5D31.aspx for more)
//

package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATSAMA5D31"
)

// Interrupt numbers.
const (
	// Advanced Interrupt Controller
	IRQ_FIQ = 0

	// Power Management Controller
	IRQ_PMC = 1

	// Debug Unit
	IRQ_DBGU = 2

	// Parallel Input/Output Controller A
	IRQ_PIOA = 6

	// Parallel Input/Output Controller B
	IRQ_PIOB = 7

	// Parallel Input/Output Controller C
	IRQ_PIOC = 8

	// Parallel Input/Output Controller D
	IRQ_PIOD = 9

	// Parallel Input/Output Controller E
	IRQ_PIOE = 10

	// Software Modem Device
	IRQ_SMD = 11

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 12

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 13

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 14

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	IRQ_USART3 = 15

	// Universal Asynchronous Receiver Transmitter 0
	IRQ_UART0 = 16

	// Universal Asynchronous Receiver Transmitter 1
	IRQ_UART1 = 17

	// Two-wire Interface 0
	IRQ_TWI0 = 18

	// Two-wire Interface 1
	IRQ_TWI1 = 19

	// Two-wire Interface 2
	IRQ_TWI2 = 20

	// High Speed MultiMedia Card Interface 0
	IRQ_HSMCI0 = 21

	// High Speed MultiMedia Card Interface 1
	IRQ_HSMCI1 = 22

	// High Speed MultiMedia Card Interface 2
	IRQ_HSMCI2 = 23

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 24

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 25

	// Timer Counter 0
	IRQ_TC0 = 26

	// Timer Counter 0
	IRQ_TC1 = 27

	// Pulse Width Modulation Controller
	IRQ_PWM = 28

	// Analog-to-Digital Converter
	IRQ_ADC = 29

	// DMA Controller 0
	IRQ_DMAC0 = 30

	// DMA Controller 1
	IRQ_DMAC1 = 31

	// USB High Speed Device Port
	IRQ_UDPHS = 33

	// Ethernet MAC 10/100
	IRQ_EMAC = 35

	// LCD Controller
	IRQ_LCDC = 36

	// Image Sensor Interface
	IRQ_ISI = 37

	// Synchronous Serial Controller 0
	IRQ_SSC0 = 38

	// Synchronous Serial Controller 1
	IRQ_SSC1 = 39

	// True Random Number Generator
	IRQ_TRNG = 45

	// Advanced Interrupt Controller
	IRQ_IRQ = 47

	// Fuse Controller
	IRQ_FUSE = 48

	// Highest interrupt number on this device.
	IRQ_max = 48
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_FIQ, "FIQ_IRQHandler")
	_ = interrupt.Register(IRQ_PMC, "PMC_IRQHandler")
	_ = interrupt.Register(IRQ_DBGU, "DBGU_IRQHandler")
	_ = interrupt.Register(IRQ_PIOA, "PIOA_IRQHandler")
	_ = interrupt.Register(IRQ_PIOB, "PIOB_IRQHandler")
	_ = interrupt.Register(IRQ_PIOC, "PIOC_IRQHandler")
	_ = interrupt.Register(IRQ_PIOD, "PIOD_IRQHandler")
	_ = interrupt.Register(IRQ_PIOE, "PIOE_IRQHandler")
	_ = interrupt.Register(IRQ_SMD, "SMD_IRQHandler")
	_ = interrupt.Register(IRQ_USART0, "USART0_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_UART0, "UART0_IRQHandler")
	_ = interrupt.Register(IRQ_UART1, "UART1_IRQHandler")
	_ = interrupt.Register(IRQ_TWI0, "TWI0_IRQHandler")
	_ = interrupt.Register(IRQ_TWI1, "TWI1_IRQHandler")
	_ = interrupt.Register(IRQ_TWI2, "TWI2_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI0, "HSMCI0_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI1, "HSMCI1_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI2, "HSMCI2_IRQHandler")
	_ = interrupt.Register(IRQ_SPI0, "SPI0_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_TC0, "TC0_IRQHandler")
	_ = interrupt.Register(IRQ_TC1, "TC1_IRQHandler")
	_ = interrupt.Register(IRQ_PWM, "PWM_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC0, "DMAC0_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC1, "DMAC1_IRQHandler")
	_ = interrupt.Register(IRQ_UDPHS, "UDPHS_IRQHandler")
	_ = interrupt.Register(IRQ_EMAC, "EMAC_IRQHandler")
	_ = interrupt.Register(IRQ_LCDC, "LCDC_IRQHandler")
	_ = interrupt.Register(IRQ_ISI, "ISI_IRQHandler")
	_ = interrupt.Register(IRQ_SSC0, "SSC0_IRQHandler")
	_ = interrupt.Register(IRQ_SSC1, "SSC1_IRQHandler")
	_ = interrupt.Register(IRQ_TRNG, "TRNG_IRQHandler")
	_ = interrupt.Register(IRQ_IRQ, "IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_FUSE, "FUSE_IRQHandler")
)

// Peripherals.
var (
	// Software Modem Device
	SMD = (*SMD_Type)(unsafe.Pointer(uintptr(0x400000)))

	// AXI Matrix
	AXIMX = (*AXIMX_Type)(unsafe.Pointer(uintptr(0x800000)))

	// High Speed MultiMedia Card Interface 0
	HSMCI0 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf0000000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0004000)))

	// Synchronous Serial Controller 0
	SSC0 = (*SSC_Type)(unsafe.Pointer(uintptr(0xf0008000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0xf0010000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf0014000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf0018000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0xf001c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0xf0020000)))

	// Universal Asynchronous Receiver Transmitter 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0xf0024000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0xf002c000)))

	// LCD Controller
	LCDC = (*LCDC_Type)(unsafe.Pointer(uintptr(0xf0030000)))

	// Image Sensor Interface
	ISI = (*ISI_Type)(unsafe.Pointer(uintptr(0xf0034000)))

	// Special Function Registers
	SFR = (*SFR_Type)(unsafe.Pointer(uintptr(0xf0038000)))

	// High Speed MultiMedia Card Interface 1
	HSMCI1 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf8000000)))

	// High Speed MultiMedia Card Interface 2
	HSMCI2 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf8004000)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf8008000)))

	// Synchronous Serial Controller 1
	SSC1 = (*SSC_Type)(unsafe.Pointer(uintptr(0xf800c000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0xf8018000)))

	// Two-wire Interface 2
	TWI2 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf801c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8020000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8024000)))

	// Universal Asynchronous Receiver Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0xf8028000)))

	// Ethernet MAC 10/100
	EMAC = (*EMAC_Type)(unsafe.Pointer(uintptr(0xf802c000)))

	// USB High Speed Device Port
	UDPHS = (*UDPHS_Type)(unsafe.Pointer(uintptr(0xf8030000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0xf8040000)))

	// Fuse Controller
	FUSE = (*FUSE_Type)(unsafe.Pointer(uintptr(0xffffe400)))

	// DMA Controller 0
	DMAC0 = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffe600)))

	// DMA Controller 1
	DMAC1 = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffe800)))

	// AHB Multi-port DDR-SDRAM Controller
	MPDDRC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffea00)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffec00)))

	// Debug Unit
	DBGU = (*DBGU_Type)(unsafe.Pointer(uintptr(0xffffee00)))

	// Advanced Interrupt Controller
	AIC = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff200)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))

	// Parallel Input/Output Controller D
	PIOD = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))

	// Parallel Input/Output Controller E
	PIOE = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffffa00)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe00)))

	// Shutdown Controller
	SHDWC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe10)))

	// Periodic Interval Timer
	PIT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe40)))

	// Slow Clock Controller
	SCKC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe50)))

	// Boot Sequence Controller
	BSC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe54)))

	// General Purpose Backup Register
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe60)))

	// Real-time Clock
	RTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffeb0)))
)

// Software Modem Device
type SMD_Type struct {
}

// AXI Matrix
type AXIMX_Type struct {
	REMAP               volatile.Register32 // 0x0
	_                   [8140]byte
	PERIPH_ID4          volatile.Register32    // 0x1FD0
	PERIPH_ID5          volatile.Register32    // 0x1FD4
	PERIPH_ID6          volatile.Register32    // 0x1FD8
	PERIPH_ID7          volatile.Register32    // 0x1FDC
	PERIPH_ID0          volatile.Register32    // 0x1FE0
	PERIPH_ID1          volatile.Register32    // 0x1FE4
	PERIPH_ID2          volatile.Register32    // 0x1FE8
	PERIPH_ID3          volatile.Register32    // 0x1FEC
	COMP_ID             [4]volatile.Register32 // 0x1FF0
	_                   [12296]byte
	AMIB3_FN_MOD_BM_ISS volatile.Register32 // 0x5008
	_                   [24]byte
	AMIB3_FN_MOD2       volatile.Register32 // 0x5024
	_                   [250072]byte
	ASIB0_READ_QOS      volatile.Register32 // 0x42100
	ASIB0_WRITE_QOS     volatile.Register32 // 0x42104
	_                   [3872]byte
	ASIB1_FN_MOD_AHB    volatile.Register32 // 0x43028
	_                   [212]byte
	ASIB1_READ_QOS      volatile.Register32 // 0x43100
	ASIB1_WRITE_QOS     volatile.Register32 // 0x43104
	ASIB1_FN_MOD        volatile.Register32 // 0x43108
}

// High Speed MultiMedia Card Interface 0
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Synchronous Serial Controller 0
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Timer Counter 0
type TC_Type struct {
	CCR0  volatile.Register32 // 0x0
	CMR0  volatile.Register32 // 0x4
	SMMR0 volatile.Register32 // 0x8
	RAB0  volatile.Register32 // 0xC
	CV0   volatile.Register32 // 0x10
	RA0   volatile.Register32 // 0x14
	RB0   volatile.Register32 // 0x18
	RC0   volatile.Register32 // 0x1C
	SR0   volatile.Register32 // 0x20
	IER0  volatile.Register32 // 0x24
	IDR0  volatile.Register32 // 0x28
	IMR0  volatile.Register32 // 0x2C
	_     [16]byte
	CCR1  volatile.Register32 // 0x40
	CMR1  volatile.Register32 // 0x44
	SMMR1 volatile.Register32 // 0x48
	RAB1  volatile.Register32 // 0x4C
	CV1   volatile.Register32 // 0x50
	RA1   volatile.Register32 // 0x54
	RB1   volatile.Register32 // 0x58
	RC1   volatile.Register32 // 0x5C
	SR1   volatile.Register32 // 0x60
	IER1  volatile.Register32 // 0x64
	IDR1  volatile.Register32 // 0x68
	IMR1  volatile.Register32 // 0x6C
	_     [16]byte
	CCR2  volatile.Register32 // 0x80
	CMR2  volatile.Register32 // 0x84
	SMMR2 volatile.Register32 // 0x88
	RAB2  volatile.Register32 // 0x8C
	CV2   volatile.Register32 // 0x90
	RA2   volatile.Register32 // 0x94
	RB2   volatile.Register32 // 0x98
	RC2   volatile.Register32 // 0x9C
	SR2   volatile.Register32 // 0xA0
	IER2  volatile.Register32 // 0xA4
	IDR2  volatile.Register32 // 0xA8
	IMR2  volatile.Register32 // 0xAC
	_     [16]byte
	BCR   volatile.Register32 // 0xC0
	BMR   volatile.Register32 // 0xC4
	QIER  volatile.Register32 // 0xC8
	QIDR  volatile.Register32 // 0xCC
	QIMR  volatile.Register32 // 0xD0
	QISR  volatile.Register32 // 0xD4
	_     [12]byte
	WPMR  volatile.Register32 // 0xE4
}

// Two-wire Interface 0
type TWI_Type struct {
	CR           volatile.Register32 // 0x0
	MMR          volatile.Register32 // 0x4
	SMR          volatile.Register32 // 0x8
	IADR         volatile.Register32 // 0xC
	CWGR         volatile.Register32 // 0x10
	_            [12]byte
	SR           volatile.Register32 // 0x20
	IER          volatile.Register32 // 0x24
	IDR          volatile.Register32 // 0x28
	IMR          volatile.Register32 // 0x2C
	RHR          volatile.Register32 // 0x30
	THR          volatile.Register32 // 0x34
	_            [172]byte
	WPROT_MODE   volatile.Register32 // 0xE4
	WPROT_STATUS volatile.Register32 // 0xE8
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	MAN  volatile.Register32 // 0x50
	_    [144]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK      volatile.Register32 // 0x0
	ENA      volatile.Register32 // 0x4
	DIS      volatile.Register32 // 0x8
	SR       volatile.Register32 // 0xC
	IER1     volatile.Register32 // 0x10
	IDR1     volatile.Register32 // 0x14
	IMR1     volatile.Register32 // 0x18
	ISR1     volatile.Register32 // 0x1C
	SCM      volatile.Register32 // 0x20
	_        [4]byte
	SCUC     volatile.Register32 // 0x28
	SCUP     volatile.Register32 // 0x2C
	SCUPUPD  volatile.Register32 // 0x30
	IER2     volatile.Register32 // 0x34
	IDR2     volatile.Register32 // 0x38
	IMR2     volatile.Register32 // 0x3C
	ISR2     volatile.Register32 // 0x40
	OOV      volatile.Register32 // 0x44
	OS       volatile.Register32 // 0x48
	OSS      volatile.Register32 // 0x4C
	OSC      volatile.Register32 // 0x50
	OSSUPD   volatile.Register32 // 0x54
	OSCUPD   volatile.Register32 // 0x58
	FMR      volatile.Register32 // 0x5C
	FSR      volatile.Register32 // 0x60
	FCR      volatile.Register32 // 0x64
	FPV      volatile.Register32 // 0x68
	FPE      volatile.Register32 // 0x6C
	_        [12]byte
	ELMR     [2]volatile.Register32 // 0x7C
	_        [44]byte
	SMMR     volatile.Register32 // 0xB0
	_        [48]byte
	WPCR     volatile.Register32 // 0xE4
	WPSR     volatile.Register32 // 0xE8
	_        [68]byte
	CMPV0    volatile.Register32 // 0x130
	CMPVUPD0 volatile.Register32 // 0x134
	CMPM0    volatile.Register32 // 0x138
	CMPMUPD0 volatile.Register32 // 0x13C
	CMPV1    volatile.Register32 // 0x140
	CMPVUPD1 volatile.Register32 // 0x144
	CMPM1    volatile.Register32 // 0x148
	CMPMUPD1 volatile.Register32 // 0x14C
	CMPV2    volatile.Register32 // 0x150
	CMPVUPD2 volatile.Register32 // 0x154
	CMPM2    volatile.Register32 // 0x158
	CMPMUPD2 volatile.Register32 // 0x15C
	CMPV3    volatile.Register32 // 0x160
	CMPVUPD3 volatile.Register32 // 0x164
	CMPM3    volatile.Register32 // 0x168
	CMPMUPD3 volatile.Register32 // 0x16C
	CMPV4    volatile.Register32 // 0x170
	CMPVUPD4 volatile.Register32 // 0x174
	CMPM4    volatile.Register32 // 0x178
	CMPMUPD4 volatile.Register32 // 0x17C
	CMPV5    volatile.Register32 // 0x180
	CMPVUPD5 volatile.Register32 // 0x184
	CMPM5    volatile.Register32 // 0x188
	CMPMUPD5 volatile.Register32 // 0x18C
	CMPV6    volatile.Register32 // 0x190
	CMPVUPD6 volatile.Register32 // 0x194
	CMPM6    volatile.Register32 // 0x198
	CMPMUPD6 volatile.Register32 // 0x19C
	CMPV7    volatile.Register32 // 0x1A0
	CMPVUPD7 volatile.Register32 // 0x1A4
	CMPM7    volatile.Register32 // 0x1A8
	CMPMUPD7 volatile.Register32 // 0x1AC
	_        [80]byte
	CMR0     volatile.Register32 // 0x200
	CDTY0    volatile.Register32 // 0x204
	CDTYUPD0 volatile.Register32 // 0x208
	CPRD0    volatile.Register32 // 0x20C
	CPRDUPD0 volatile.Register32 // 0x210
	CCNT0    volatile.Register32 // 0x214
	DT0      volatile.Register32 // 0x218
	DTUPD0   volatile.Register32 // 0x21C
	CMR1     volatile.Register32 // 0x220
	CDTY1    volatile.Register32 // 0x224
	CDTYUPD1 volatile.Register32 // 0x228
	CPRD1    volatile.Register32 // 0x22C
	CPRDUPD1 volatile.Register32 // 0x230
	CCNT1    volatile.Register32 // 0x234
	DT1      volatile.Register32 // 0x238
	DTUPD1   volatile.Register32 // 0x23C
	CMR2     volatile.Register32 // 0x240
	CDTY2    volatile.Register32 // 0x244
	CDTYUPD2 volatile.Register32 // 0x248
	CPRD2    volatile.Register32 // 0x24C
	CPRDUPD2 volatile.Register32 // 0x250
	CCNT2    volatile.Register32 // 0x254
	DT2      volatile.Register32 // 0x258
	DTUPD2   volatile.Register32 // 0x25C
	CMR3     volatile.Register32 // 0x260
	CDTY3    volatile.Register32 // 0x264
	CDTYUPD3 volatile.Register32 // 0x268
	CPRD3    volatile.Register32 // 0x26C
	CPRDUPD3 volatile.Register32 // 0x270
	CCNT3    volatile.Register32 // 0x274
	DT3      volatile.Register32 // 0x278
	DTUPD3   volatile.Register32 // 0x27C
}

// LCD Controller
type LCDC_Type struct {
	LCDCFG0  volatile.Register32 // 0x0
	LCDCFG1  volatile.Register32 // 0x4
	LCDCFG2  volatile.Register32 // 0x8
	LCDCFG3  volatile.Register32 // 0xC
	LCDCFG4  volatile.Register32 // 0x10
	LCDCFG5  volatile.Register32 // 0x14
	LCDCFG6  volatile.Register32 // 0x18
	_        [4]byte
	LCDEN    volatile.Register32 // 0x20
	LCDDIS   volatile.Register32 // 0x24
	LCDSR    volatile.Register32 // 0x28
	LCDIER   volatile.Register32 // 0x2C
	LCDIDR   volatile.Register32 // 0x30
	LCDIMR   volatile.Register32 // 0x34
	LCDISR   volatile.Register32 // 0x38
	_        [4]byte
	BASECHER volatile.Register32 // 0x40
	BASECHDR volatile.Register32 // 0x44
	BASECHSR volatile.Register32 // 0x48
	BASEIER  volatile.Register32 // 0x4C
	BASEIDR  volatile.Register32 // 0x50
	BASEIMR  volatile.Register32 // 0x54
	BASEISR  volatile.Register32 // 0x58
	BASEHEAD volatile.Register32 // 0x5C
	BASEADDR volatile.Register32 // 0x60
	BASECTRL volatile.Register32 // 0x64
	BASENEXT volatile.Register32 // 0x68
	BASECFG0 volatile.Register32 // 0x6C
	BASECFG1 volatile.Register32 // 0x70
	BASECFG2 volatile.Register32 // 0x74
	BASECFG3 volatile.Register32 // 0x78
	BASECFG4 volatile.Register32 // 0x7C
	BASECFG5 volatile.Register32 // 0x80
	BASECFG6 volatile.Register32 // 0x84
	_        [184]byte
	OVR1CHER volatile.Register32 // 0x140
	OVR1CHDR volatile.Register32 // 0x144
	OVR1CHSR volatile.Register32 // 0x148
	OVR1IER  volatile.Register32 // 0x14C
	OVR1IDR  volatile.Register32 // 0x150
	OVR1IMR  volatile.Register32 // 0x154
	OVR1ISR  volatile.Register32 // 0x158
	OVR1HEAD volatile.Register32 // 0x15C
	OVR1ADDR volatile.Register32 // 0x160
	OVR1CTRL volatile.Register32 // 0x164
	OVR1NEXT volatile.Register32 // 0x168
	OVR1CFG0 volatile.Register32 // 0x16C
	OVR1CFG1 volatile.Register32 // 0x170
	OVR1CFG2 volatile.Register32 // 0x174
	OVR1CFG3 volatile.Register32 // 0x178
	OVR1CFG4 volatile.Register32 // 0x17C
	OVR1CFG5 volatile.Register32 // 0x180
	OVR1CFG6 volatile.Register32 // 0x184
	OVR1CFG7 volatile.Register32 // 0x188
	OVR1CFG8 volatile.Register32 // 0x18C
	OVR1CFG9 volatile.Register32 // 0x190
	_        [172]byte
	OVR2CHER volatile.Register32 // 0x240
	OVR2CHDR volatile.Register32 // 0x244
	OVR2CHSR volatile.Register32 // 0x248
	OVR2IER  volatile.Register32 // 0x24C
	OVR2IDR  volatile.Register32 // 0x250
	OVR2IMR  volatile.Register32 // 0x254
	OVR2ISR  volatile.Register32 // 0x258
	OVR2HEAD volatile.Register32 // 0x25C
	OVR2ADDR volatile.Register32 // 0x260
	OVR2CTRL volatile.Register32 // 0x264
	OVR2NEXT volatile.Register32 // 0x268
	OVR2CFG0 volatile.Register32 // 0x26C
	OVR2CFG1 volatile.Register32 // 0x270
	OVR2CFG2 volatile.Register32 // 0x274
	OVR2CFG3 volatile.Register32 // 0x278
	OVR2CFG4 volatile.Register32 // 0x27C
	OVR2CFG5 volatile.Register32 // 0x280
	OVR2CFG6 volatile.Register32 // 0x284
	OVR2CFG7 volatile.Register32 // 0x288
	OVR2CFG8 volatile.Register32 // 0x28C
	OVR2CFG9 volatile.Register32 // 0x290
	_        [172]byte
	HEOCHER  volatile.Register32 // 0x340
	HEOCHDR  volatile.Register32 // 0x344
	HEOCHSR  volatile.Register32 // 0x348
	HEOIER   volatile.Register32 // 0x34C
	HEOIDR   volatile.Register32 // 0x350
	HEOIMR   volatile.Register32 // 0x354
	HEOISR   volatile.Register32 // 0x358
	HEOHEAD  volatile.Register32 // 0x35C
	HEOADDR  volatile.Register32 // 0x360
	HEOCTRL  volatile.Register32 // 0x364
	HEONEXT  volatile.Register32 // 0x368
	HEOUHEAD volatile.Register32 // 0x36C
	HEOUADDR volatile.Register32 // 0x370
	HEOUCTRL volatile.Register32 // 0x374
	HEOUNEXT volatile.Register32 // 0x378
	HEOVHEAD volatile.Register32 // 0x37C
	HEOVADDR volatile.Register32 // 0x380
	HEOVCTRL volatile.Register32 // 0x384
	HEOVNEXT volatile.Register32 // 0x388
	HEOCFG0  volatile.Register32 // 0x38C
	HEOCFG1  volatile.Register32 // 0x390
	HEOCFG2  volatile.Register32 // 0x394
	HEOCFG3  volatile.Register32 // 0x398
	HEOCFG4  volatile.Register32 // 0x39C
	HEOCFG5  volatile.Register32 // 0x3A0
	HEOCFG6  volatile.Register32 // 0x3A4
	HEOCFG7  volatile.Register32 // 0x3A8
	HEOCFG8  volatile.Register32 // 0x3AC
	HEOCFG9  volatile.Register32 // 0x3B0
	HEOCFG10 volatile.Register32 // 0x3B4
	HEOCFG11 volatile.Register32 // 0x3B8
	HEOCFG12 volatile.Register32 // 0x3BC
	HEOCFG13 volatile.Register32 // 0x3C0
	HEOCFG14 volatile.Register32 // 0x3C4
	HEOCFG15 volatile.Register32 // 0x3C8
	HEOCFG16 volatile.Register32 // 0x3CC
	HEOCFG17 volatile.Register32 // 0x3D0
	HEOCFG18 volatile.Register32 // 0x3D4
	HEOCFG19 volatile.Register32 // 0x3D8
	HEOCFG20 volatile.Register32 // 0x3DC
	HEOCFG21 volatile.Register32 // 0x3E0
	HEOCFG22 volatile.Register32 // 0x3E4
	HEOCFG23 volatile.Register32 // 0x3E8
	HEOCFG24 volatile.Register32 // 0x3EC
	HEOCFG25 volatile.Register32 // 0x3F0
	HEOCFG26 volatile.Register32 // 0x3F4
	HEOCFG27 volatile.Register32 // 0x3F8
	HEOCFG28 volatile.Register32 // 0x3FC
	HEOCFG29 volatile.Register32 // 0x400
	HEOCFG30 volatile.Register32 // 0x404
	HEOCFG31 volatile.Register32 // 0x408
	HEOCFG32 volatile.Register32 // 0x40C
	HEOCFG33 volatile.Register32 // 0x410
	HEOCFG34 volatile.Register32 // 0x414
	HEOCFG35 volatile.Register32 // 0x418
	HEOCFG36 volatile.Register32 // 0x41C
	HEOCFG37 volatile.Register32 // 0x420
	HEOCFG38 volatile.Register32 // 0x424
	HEOCFG39 volatile.Register32 // 0x428
	HEOCFG40 volatile.Register32 // 0x42C
	HEOCFG41 volatile.Register32 // 0x430
	_        [12]byte
	HCRCHER  volatile.Register32 // 0x440
	HCRCHDR  volatile.Register32 // 0x444
	HCRCHSR  volatile.Register32 // 0x448
	HCRIER   volatile.Register32 // 0x44C
	HCRIDR   volatile.Register32 // 0x450
	HCRIMR   volatile.Register32 // 0x454
	HCRISR   volatile.Register32 // 0x458
	HCRHEAD  volatile.Register32 // 0x45C
	HCRADDR  volatile.Register32 // 0x460
	HCRCTRL  volatile.Register32 // 0x464
	HCRNEXT  volatile.Register32 // 0x468
	HCRCFG0  volatile.Register32 // 0x46C
	HCRCFG1  volatile.Register32 // 0x470
	HCRCFG2  volatile.Register32 // 0x474
	HCRCFG3  volatile.Register32 // 0x478
	HCRCFG4  volatile.Register32 // 0x47C
	_        [4]byte
	HCRCFG6  volatile.Register32 // 0x484
	HCRCFG7  volatile.Register32 // 0x488
	HCRCFG8  volatile.Register32 // 0x48C
	HCRCFG9  volatile.Register32 // 0x490
	_        [172]byte
	PPCHER   volatile.Register32 // 0x540
	PPCHDR   volatile.Register32 // 0x544
	PPCHSR   volatile.Register32 // 0x548
	PPIER    volatile.Register32 // 0x54C
	PPIDR    volatile.Register32 // 0x550
	PPIMR    volatile.Register32 // 0x554
	PPISR    volatile.Register32 // 0x558
	PPHEAD   volatile.Register32 // 0x55C
	PPADDR   volatile.Register32 // 0x560
	PPCTRL   volatile.Register32 // 0x564
	PPNEXT   volatile.Register32 // 0x568
	PPCFG0   volatile.Register32 // 0x56C
	PPCFG1   volatile.Register32 // 0x570
	PPCFG2   volatile.Register32 // 0x574
	PPCFG3   volatile.Register32 // 0x578
	PPCFG4   volatile.Register32 // 0x57C
	PPCFG5   volatile.Register32 // 0x580
	_        [124]byte
	BASECLUT [256]volatile.Register32 // 0x600
	OVR1CLUT [256]volatile.Register32 // 0xA00
	OVR2CLUT [256]volatile.Register32 // 0xE00
	HEOCLUT  [256]volatile.Register32 // 0x1200
	HCRCLUT  [256]volatile.Register32 // 0x1600
}

// Image Sensor Interface
type ISI_Type struct {
	CFG1       volatile.Register32 // 0x0
	CFG2       volatile.Register32 // 0x4
	PSIZE      volatile.Register32 // 0x8
	PDECF      volatile.Register32 // 0xC
	Y2R_SET0   volatile.Register32 // 0x10
	Y2R_SET1   volatile.Register32 // 0x14
	R2Y_SET0   volatile.Register32 // 0x18
	R2Y_SET1   volatile.Register32 // 0x1C
	R2Y_SET2   volatile.Register32 // 0x20
	CR         volatile.Register32 // 0x24
	SR         volatile.Register32 // 0x28
	IER        volatile.Register32 // 0x2C
	IDR        volatile.Register32 // 0x30
	IMR        volatile.Register32 // 0x34
	DMA_CHER   volatile.Register32 // 0x38
	DMA_CHDR   volatile.Register32 // 0x3C
	DMA_CHSR   volatile.Register32 // 0x40
	DMA_P_ADDR volatile.Register32 // 0x44
	DMA_P_CTRL volatile.Register32 // 0x48
	DMA_P_DSCR volatile.Register32 // 0x4C
	DMA_C_ADDR volatile.Register32 // 0x50
	DMA_C_CTRL volatile.Register32 // 0x54
	DMA_C_DSCR volatile.Register32 // 0x58
	_          [136]byte
	WPCR       volatile.Register32 // 0xE4
	WPSR       volatile.Register32 // 0xE8
}

// Special Function Registers
type SFR_Type struct {
	_          [16]byte
	OHCIICR    volatile.Register32 // 0x10
	OHCIISR    volatile.Register32 // 0x14
	_          [8]byte
	AHB        volatile.Register32 // 0x20
	BRIDGE     volatile.Register32 // 0x24
	SECURE     volatile.Register32 // 0x28
	_          [4]byte
	UTMICKTRIM volatile.Register32 // 0x30
	UTMIHSTRIM volatile.Register32 // 0x34
	UTMIFSTRIM volatile.Register32 // 0x38
	UTMISWAP   volatile.Register32 // 0x3C
	EBICFG     volatile.Register32 // 0x40
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	SEQR1  volatile.Register32 // 0x8
	SEQR2  volatile.Register32 // 0xC
	CHER   volatile.Register32 // 0x10
	CHDR   volatile.Register32 // 0x14
	CHSR   volatile.Register32 // 0x18
	_      [4]byte
	LCDR   volatile.Register32 // 0x20
	IER    volatile.Register32 // 0x24
	IDR    volatile.Register32 // 0x28
	IMR    volatile.Register32 // 0x2C
	ISR    volatile.Register32 // 0x30
	_      [8]byte
	OVER   volatile.Register32     // 0x3C
	EMR    volatile.Register32     // 0x40
	CWR    volatile.Register32     // 0x44
	CGR    volatile.Register32     // 0x48
	COR    volatile.Register32     // 0x4C
	CDR    [12]volatile.Register32 // 0x50
	_      [20]byte
	ACR    volatile.Register32 // 0x94
	_      [24]byte
	TSMR   volatile.Register32 // 0xB0
	XPOSR  volatile.Register32 // 0xB4
	YPOSR  volatile.Register32 // 0xB8
	PRESSR volatile.Register32 // 0xBC
	TRGR   volatile.Register32 // 0xC0
	_      [32]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// Ethernet MAC 10/100
type EMAC_Type struct {
	NCR   volatile.Register32 // 0x0
	NCFGR volatile.Register32 // 0x4
	NSR   volatile.Register32 // 0x8
	_     [8]byte
	TSR   volatile.Register32 // 0x14
	RBQP  volatile.Register32 // 0x18
	TBQP  volatile.Register32 // 0x1C
	RSR   volatile.Register32 // 0x20
	ISR   volatile.Register32 // 0x24
	IER   volatile.Register32 // 0x28
	IDR   volatile.Register32 // 0x2C
	IMR   volatile.Register32 // 0x30
	MAN   volatile.Register32 // 0x34
	PTR   volatile.Register32 // 0x38
	PFR   volatile.Register32 // 0x3C
	FTO   volatile.Register32 // 0x40
	SCF   volatile.Register32 // 0x44
	MCF   volatile.Register32 // 0x48
	FRO   volatile.Register32 // 0x4C
	FCSE  volatile.Register32 // 0x50
	ALE   volatile.Register32 // 0x54
	DTF   volatile.Register32 // 0x58
	LCOL  volatile.Register32 // 0x5C
	ECOL  volatile.Register32 // 0x60
	TUND  volatile.Register32 // 0x64
	CSE   volatile.Register32 // 0x68
	RRE   volatile.Register32 // 0x6C
	ROV   volatile.Register32 // 0x70
	RSE   volatile.Register32 // 0x74
	ELE   volatile.Register32 // 0x78
	RJA   volatile.Register32 // 0x7C
	USF   volatile.Register32 // 0x80
	STE   volatile.Register32 // 0x84
	RLE   volatile.Register32 // 0x88
	_     [4]byte
	HRB   volatile.Register32 // 0x90
	HRT   volatile.Register32 // 0x94
	SA1B  volatile.Register32 // 0x98
	SA1T  volatile.Register32 // 0x9C
	SA2B  volatile.Register32 // 0xA0
	SA2T  volatile.Register32 // 0xA4
	SA3B  volatile.Register32 // 0xA8
	SA3T  volatile.Register32 // 0xAC
	SA4B  volatile.Register32 // 0xB0
	SA4T  volatile.Register32 // 0xB4
	TID   volatile.Register32 // 0xB8
	_     [4]byte
	USRIO volatile.Register32 // 0xC0
	WOL   volatile.Register32 // 0xC4
}

// USB High Speed Device Port
type UDPHS_Type struct {
	CTRL        volatile.Register32 // 0x0
	FNUM        volatile.Register32 // 0x4
	_           [8]byte
	IEN         volatile.Register32 // 0x10
	INTSTA      volatile.Register32 // 0x14
	CLRINT      volatile.Register32 // 0x18
	EPTRST      volatile.Register32 // 0x1C
	_           [192]byte
	TST         volatile.Register32 // 0xE0
	_           [28]byte
	EPTCFG0     volatile.Register32 // 0x100
	EPTCTLENB0  volatile.Register32 // 0x104
	EPTCTLDIS0  volatile.Register32 // 0x108
	EPTCTL0     volatile.Register32 // 0x10C
	_           [4]byte
	EPTSETSTA0  volatile.Register32 // 0x114
	EPTCLRSTA0  volatile.Register32 // 0x118
	EPTSTA0     volatile.Register32 // 0x11C
	EPTCFG1     volatile.Register32 // 0x120
	EPTCTLENB1  volatile.Register32 // 0x124
	EPTCTLDIS1  volatile.Register32 // 0x128
	EPTCTL1     volatile.Register32 // 0x12C
	_           [4]byte
	EPTSETSTA1  volatile.Register32 // 0x134
	EPTCLRSTA1  volatile.Register32 // 0x138
	EPTSTA1     volatile.Register32 // 0x13C
	EPTCFG2     volatile.Register32 // 0x140
	EPTCTLENB2  volatile.Register32 // 0x144
	EPTCTLDIS2  volatile.Register32 // 0x148
	EPTCTL2     volatile.Register32 // 0x14C
	_           [4]byte
	EPTSETSTA2  volatile.Register32 // 0x154
	EPTCLRSTA2  volatile.Register32 // 0x158
	EPTSTA2     volatile.Register32 // 0x15C
	EPTCFG3     volatile.Register32 // 0x160
	EPTCTLENB3  volatile.Register32 // 0x164
	EPTCTLDIS3  volatile.Register32 // 0x168
	EPTCTL3     volatile.Register32 // 0x16C
	_           [4]byte
	EPTSETSTA3  volatile.Register32 // 0x174
	EPTCLRSTA3  volatile.Register32 // 0x178
	EPTSTA3     volatile.Register32 // 0x17C
	EPTCFG4     volatile.Register32 // 0x180
	EPTCTLENB4  volatile.Register32 // 0x184
	EPTCTLDIS4  volatile.Register32 // 0x188
	EPTCTL4     volatile.Register32 // 0x18C
	_           [4]byte
	EPTSETSTA4  volatile.Register32 // 0x194
	EPTCLRSTA4  volatile.Register32 // 0x198
	EPTSTA4     volatile.Register32 // 0x19C
	EPTCFG5     volatile.Register32 // 0x1A0
	EPTCTLENB5  volatile.Register32 // 0x1A4
	EPTCTLDIS5  volatile.Register32 // 0x1A8
	EPTCTL5     volatile.Register32 // 0x1AC
	_           [4]byte
	EPTSETSTA5  volatile.Register32 // 0x1B4
	EPTCLRSTA5  volatile.Register32 // 0x1B8
	EPTSTA5     volatile.Register32 // 0x1BC
	EPTCFG6     volatile.Register32 // 0x1C0
	EPTCTLENB6  volatile.Register32 // 0x1C4
	EPTCTLDIS6  volatile.Register32 // 0x1C8
	EPTCTL6     volatile.Register32 // 0x1CC
	_           [4]byte
	EPTSETSTA6  volatile.Register32 // 0x1D4
	EPTCLRSTA6  volatile.Register32 // 0x1D8
	EPTSTA6     volatile.Register32 // 0x1DC
	EPTCFG7     volatile.Register32 // 0x1E0
	EPTCTLENB7  volatile.Register32 // 0x1E4
	EPTCTLDIS7  volatile.Register32 // 0x1E8
	EPTCTL7     volatile.Register32 // 0x1EC
	_           [4]byte
	EPTSETSTA7  volatile.Register32 // 0x1F4
	EPTCLRSTA7  volatile.Register32 // 0x1F8
	EPTSTA7     volatile.Register32 // 0x1FC
	EPTCFG8     volatile.Register32 // 0x200
	EPTCTLENB8  volatile.Register32 // 0x204
	EPTCTLDIS8  volatile.Register32 // 0x208
	EPTCTL8     volatile.Register32 // 0x20C
	_           [4]byte
	EPTSETSTA8  volatile.Register32 // 0x214
	EPTCLRSTA8  volatile.Register32 // 0x218
	EPTSTA8     volatile.Register32 // 0x21C
	EPTCFG9     volatile.Register32 // 0x220
	EPTCTLENB9  volatile.Register32 // 0x224
	EPTCTLDIS9  volatile.Register32 // 0x228
	EPTCTL9     volatile.Register32 // 0x22C
	_           [4]byte
	EPTSETSTA9  volatile.Register32 // 0x234
	EPTCLRSTA9  volatile.Register32 // 0x238
	EPTSTA9     volatile.Register32 // 0x23C
	EPTCFG10    volatile.Register32 // 0x240
	EPTCTLENB10 volatile.Register32 // 0x244
	EPTCTLDIS10 volatile.Register32 // 0x248
	EPTCTL10    volatile.Register32 // 0x24C
	_           [4]byte
	EPTSETSTA10 volatile.Register32 // 0x254
	EPTCLRSTA10 volatile.Register32 // 0x258
	EPTSTA10    volatile.Register32 // 0x25C
	EPTCFG11    volatile.Register32 // 0x260
	EPTCTLENB11 volatile.Register32 // 0x264
	EPTCTLDIS11 volatile.Register32 // 0x268
	EPTCTL11    volatile.Register32 // 0x26C
	_           [4]byte
	EPTSETSTA11 volatile.Register32 // 0x274
	EPTCLRSTA11 volatile.Register32 // 0x278
	EPTSTA11    volatile.Register32 // 0x27C
	EPTCFG12    volatile.Register32 // 0x280
	EPTCTLENB12 volatile.Register32 // 0x284
	EPTCTLDIS12 volatile.Register32 // 0x288
	EPTCTL12    volatile.Register32 // 0x28C
	_           [4]byte
	EPTSETSTA12 volatile.Register32 // 0x294
	EPTCLRSTA12 volatile.Register32 // 0x298
	EPTSTA12    volatile.Register32 // 0x29C
	EPTCFG13    volatile.Register32 // 0x2A0
	EPTCTLENB13 volatile.Register32 // 0x2A4
	EPTCTLDIS13 volatile.Register32 // 0x2A8
	EPTCTL13    volatile.Register32 // 0x2AC
	_           [4]byte
	EPTSETSTA13 volatile.Register32 // 0x2B4
	EPTCLRSTA13 volatile.Register32 // 0x2B8
	EPTSTA13    volatile.Register32 // 0x2BC
	EPTCFG14    volatile.Register32 // 0x2C0
	EPTCTLENB14 volatile.Register32 // 0x2C4
	EPTCTLDIS14 volatile.Register32 // 0x2C8
	EPTCTL14    volatile.Register32 // 0x2CC
	_           [4]byte
	EPTSETSTA14 volatile.Register32 // 0x2D4
	EPTCLRSTA14 volatile.Register32 // 0x2D8
	EPTSTA14    volatile.Register32 // 0x2DC
	EPTCFG15    volatile.Register32 // 0x2E0
	EPTCTLENB15 volatile.Register32 // 0x2E4
	EPTCTLDIS15 volatile.Register32 // 0x2E8
	EPTCTL15    volatile.Register32 // 0x2EC
	_           [4]byte
	EPTSETSTA15 volatile.Register32 // 0x2F4
	EPTCLRSTA15 volatile.Register32 // 0x2F8
	EPTSTA15    volatile.Register32 // 0x2FC
	DMANXTDSC0  volatile.Register32 // 0x300
	DMAADDRESS0 volatile.Register32 // 0x304
	DMACONTROL0 volatile.Register32 // 0x308
	DMASTATUS0  volatile.Register32 // 0x30C
	DMANXTDSC1  volatile.Register32 // 0x310
	DMAADDRESS1 volatile.Register32 // 0x314
	DMACONTROL1 volatile.Register32 // 0x318
	DMASTATUS1  volatile.Register32 // 0x31C
	DMANXTDSC2  volatile.Register32 // 0x320
	DMAADDRESS2 volatile.Register32 // 0x324
	DMACONTROL2 volatile.Register32 // 0x328
	DMASTATUS2  volatile.Register32 // 0x32C
	DMANXTDSC3  volatile.Register32 // 0x330
	DMAADDRESS3 volatile.Register32 // 0x334
	DMACONTROL3 volatile.Register32 // 0x338
	DMASTATUS3  volatile.Register32 // 0x33C
	DMANXTDSC4  volatile.Register32 // 0x340
	DMAADDRESS4 volatile.Register32 // 0x344
	DMACONTROL4 volatile.Register32 // 0x348
	DMASTATUS4  volatile.Register32 // 0x34C
	DMANXTDSC5  volatile.Register32 // 0x350
	DMAADDRESS5 volatile.Register32 // 0x354
	DMACONTROL5 volatile.Register32 // 0x358
	DMASTATUS5  volatile.Register32 // 0x35C
	DMANXTDSC6  volatile.Register32 // 0x360
	DMAADDRESS6 volatile.Register32 // 0x364
	DMACONTROL6 volatile.Register32 // 0x368
	DMASTATUS6  volatile.Register32 // 0x36C
}

// True Random Number Generator
type TRNG_Type struct {
	CR    volatile.Register32 // 0x0
	_     [12]byte
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [48]byte
	ODATA volatile.Register32 // 0x50
}

// Fuse Controller
type FUSE_Type struct {
	CR volatile.Register32    // 0x0
	MR volatile.Register32    // 0x4
	IR volatile.Register32    // 0x8
	DR volatile.Register32    // 0xC
	SR [8]volatile.Register32 // 0x10
}

// DMA Controller 0
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	SPIP0  volatile.Register32 // 0x54
	DPIP0  volatile.Register32 // 0x58
	_      [8]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	SPIP1  volatile.Register32 // 0x7C
	DPIP1  volatile.Register32 // 0x80
	_      [8]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	SPIP2  volatile.Register32 // 0xA4
	DPIP2  volatile.Register32 // 0xA8
	_      [8]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	SPIP3  volatile.Register32 // 0xCC
	DPIP3  volatile.Register32 // 0xD0
	_      [8]byte
	SADDR4 volatile.Register32 // 0xDC
	DADDR4 volatile.Register32 // 0xE0
	DSCR4  volatile.Register32 // 0xE4
	CTRLA4 volatile.Register32 // 0xE8
	CTRLB4 volatile.Register32 // 0xEC
	CFG4   volatile.Register32 // 0xF0
	SPIP4  volatile.Register32 // 0xF4
	DPIP4  volatile.Register32 // 0xF8
	_      [8]byte
	SADDR5 volatile.Register32 // 0x104
	DADDR5 volatile.Register32 // 0x108
	DSCR5  volatile.Register32 // 0x10C
	CTRLA5 volatile.Register32 // 0x110
	CTRLB5 volatile.Register32 // 0x114
	CFG5   volatile.Register32 // 0x118
	SPIP5  volatile.Register32 // 0x11C
	DPIP5  volatile.Register32 // 0x120
	_      [8]byte
	SADDR6 volatile.Register32 // 0x12C
	DADDR6 volatile.Register32 // 0x130
	DSCR6  volatile.Register32 // 0x134
	CTRLA6 volatile.Register32 // 0x138
	CTRLB6 volatile.Register32 // 0x13C
	CFG6   volatile.Register32 // 0x140
	SPIP6  volatile.Register32 // 0x144
	DPIP6  volatile.Register32 // 0x148
	_      [8]byte
	SADDR7 volatile.Register32 // 0x154
	DADDR7 volatile.Register32 // 0x158
	DSCR7  volatile.Register32 // 0x15C
	CTRLA7 volatile.Register32 // 0x160
	CTRLB7 volatile.Register32 // 0x164
	CFG7   volatile.Register32 // 0x168
	SPIP7  volatile.Register32 // 0x16C
	DPIP7  volatile.Register32 // 0x170
	_      [112]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// AHB Multi-port DDR-SDRAM Controller
type EBI_Type struct {
	MR             volatile.Register32 // 0x0
	RTR            volatile.Register32 // 0x4
	CR             volatile.Register32 // 0x8
	TPR0           volatile.Register32 // 0xC
	TPR1           volatile.Register32 // 0x10
	TPR2           volatile.Register32 // 0x14
	_              [4]byte
	LPR            volatile.Register32 // 0x1C
	MD             volatile.Register32 // 0x20
	HS             volatile.Register32 // 0x24
	LPDDR2_LPR     volatile.Register32 // 0x28
	LPDDR2_CAL_MR4 volatile.Register32 // 0x2C
	LPDDR2_TIM_CAL volatile.Register32 // 0x30
	IO_CALIBR      volatile.Register32 // 0x34
	_              [12]byte
	SAW            [4]volatile.Register32 // 0x44
	_              [32]byte
	DLL_MO         volatile.Register32    // 0x74
	DLL_SOF        volatile.Register32    // 0x78
	DLL_MS         volatile.Register32    // 0x7C
	DLL_SS         [4]volatile.Register32 // 0x80
	_              [84]byte
	WPCR           volatile.Register32 // 0xE4
	WPSR           volatile.Register32 // 0xE8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG   [16]volatile.Register32 // 0x0
	SCFG   [16]volatile.Register32 // 0x40
	PRAS0  volatile.Register32     // 0x80
	PRBS0  volatile.Register32     // 0x84
	PRAS1  volatile.Register32     // 0x88
	PRBS1  volatile.Register32     // 0x8C
	PRAS2  volatile.Register32     // 0x90
	PRBS2  volatile.Register32     // 0x94
	PRAS3  volatile.Register32     // 0x98
	PRBS3  volatile.Register32     // 0x9C
	PRAS4  volatile.Register32     // 0xA0
	PRBS4  volatile.Register32     // 0xA4
	PRAS5  volatile.Register32     // 0xA8
	PRBS5  volatile.Register32     // 0xAC
	PRAS6  volatile.Register32     // 0xB0
	PRBS6  volatile.Register32     // 0xB4
	PRAS7  volatile.Register32     // 0xB8
	PRBS7  volatile.Register32     // 0xBC
	PRAS8  volatile.Register32     // 0xC0
	PRBS8  volatile.Register32     // 0xC4
	PRAS9  volatile.Register32     // 0xC8
	PRBS9  volatile.Register32     // 0xCC
	PRAS10 volatile.Register32     // 0xD0
	PRBS10 volatile.Register32     // 0xD4
	PRAS11 volatile.Register32     // 0xD8
	PRBS11 volatile.Register32     // 0xDC
	PRAS12 volatile.Register32     // 0xE0
	PRBS12 volatile.Register32     // 0xE4
	PRAS13 volatile.Register32     // 0xE8
	PRBS13 volatile.Register32     // 0xEC
	PRAS14 volatile.Register32     // 0xF0
	PRBS14 volatile.Register32     // 0xF4
	PRAS15 volatile.Register32     // 0xF8
	PRBS15 volatile.Register32     // 0xFC
	MRCR   volatile.Register32     // 0x100
	_      [12]byte
	SFR    [16]volatile.Register32 // 0x110
	_      [148]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// Debug Unit
type DBGU_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [28]byte
	CIDR volatile.Register32 // 0x40
	EXID volatile.Register32 // 0x44
	FNR  volatile.Register32 // 0x48
}

// Advanced Interrupt Controller
type AIC_Type struct {
	SSR   volatile.Register32 // 0x0
	SMR   volatile.Register32 // 0x4
	SVR   volatile.Register32 // 0x8
	_     [4]byte
	IVR   volatile.Register32 // 0x10
	FVR   volatile.Register32 // 0x14
	ISR   volatile.Register32 // 0x18
	_     [4]byte
	IPR0  volatile.Register32 // 0x20
	IPR1  volatile.Register32 // 0x24
	IPR2  volatile.Register32 // 0x28
	IPR3  volatile.Register32 // 0x2C
	IMR   volatile.Register32 // 0x30
	CISR  volatile.Register32 // 0x34
	EOICR volatile.Register32 // 0x38
	SPU   volatile.Register32 // 0x3C
	IECR  volatile.Register32 // 0x40
	IDCR  volatile.Register32 // 0x44
	ICCR  volatile.Register32 // 0x48
	ISCR  volatile.Register32 // 0x4C
	FFER  volatile.Register32 // 0x50
	FFDR  volatile.Register32 // 0x54
	FFSR  volatile.Register32 // 0x58
	_     [16]byte
	DCR   volatile.Register32 // 0x6C
	_     [116]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
	_       [20]byte
	DRIVER1 volatile.Register32 // 0x118
	DRIVER2 volatile.Register32 // 0x11C
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER    volatile.Register32 // 0x0
	PMC_SCDR    volatile.Register32 // 0x4
	PMC_SCSR    volatile.Register32 // 0x8
	_           [4]byte
	PMC_PCER0   volatile.Register32 // 0x10
	PMC_PCDR0   volatile.Register32 // 0x14
	PMC_PCSR0   volatile.Register32 // 0x18
	CKGR_UCKR   volatile.Register32 // 0x1C
	CKGR_MOR    volatile.Register32 // 0x20
	CKGR_MCFR   volatile.Register32 // 0x24
	CKGR_PLLAR  volatile.Register32 // 0x28
	_           [4]byte
	PMC_MCKR    volatile.Register32 // 0x30
	_           [4]byte
	PMC_USB     volatile.Register32    // 0x38
	PMC_SMD     volatile.Register32    // 0x3C
	PMC_PCK     [3]volatile.Register32 // 0x40
	_           [20]byte
	PMC_IER     volatile.Register32 // 0x60
	PMC_IDR     volatile.Register32 // 0x64
	PMC_SR      volatile.Register32 // 0x68
	PMC_IMR     volatile.Register32 // 0x6C
	_           [16]byte
	PMC_PLLICPR volatile.Register32 // 0x80
	_           [96]byte
	PMC_WPMR    volatile.Register32 // 0xE4
	PMC_WPSR    volatile.Register32 // 0xE8
	_           [20]byte
	PMC_PCER1   volatile.Register32 // 0x100
	PMC_PCDR1   volatile.Register32 // 0x104
	PMC_PCSR1   volatile.Register32 // 0x108
	PMC_PCR     volatile.Register32 // 0x10C
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// Bitfields for SMD: Software Modem Device
const ()

// Bitfields for AXIMX: AXI Matrix
const (
	// REMAP: Remap Register
	// Position of REMAP0 field.
	AXIMX_REMAP_REMAP0_Pos = 0x0
	// Bit mask of REMAP0 field.
	AXIMX_REMAP_REMAP0_Msk = 0x1
	// Bit REMAP0.
	AXIMX_REMAP_REMAP0 = 0x1
	// Position of REMAP1 field.
	AXIMX_REMAP_REMAP1_Pos = 0x1
	// Bit mask of REMAP1 field.
	AXIMX_REMAP_REMAP1_Msk = 0x2
	// Bit REMAP1.
	AXIMX_REMAP_REMAP1 = 0x2

	// PERIPH_ID4: Peripheral ID Register 4
	// Position of ID field.
	AXIMX_PERIPH_ID4_ID_Pos = 0x0
	// Bit mask of ID field.
	AXIMX_PERIPH_ID4_ID_Msk = 0xff
	// Part Number
	AXIMX_PERIPH_ID4_ID_ID0 = 0x1
	// 4KB count, JEP106 continuation code
	AXIMX_PERIPH_ID4_ID_ID4 = 0x4
	// JEP106[3:0, part number[11:8]
	AXIMX_PERIPH_ID4_ID_ID1 = 0xb3
	// Revision, JEP106 code flag, JEP106[6:4]
	AXIMX_PERIPH_ID4_ID_ID2 = 0xb6

	// PERIPH_ID5: Peripheral ID Register 5
	// Position of ID field.
	AXIMX_PERIPH_ID5_ID_Pos = 0x0
	// Bit mask of ID field.
	AXIMX_PERIPH_ID5_ID_Msk = 0xff
	// Part Number
	AXIMX_PERIPH_ID5_ID_ID0 = 0x1
	// 4KB count, JEP106 continuation code
	AXIMX_PERIPH_ID5_ID_ID4 = 0x4
	// JEP106[3:0, part number[11:8]
	AXIMX_PERIPH_ID5_ID_ID1 = 0xb3
	// Revision, JEP106 code flag, JEP106[6:4]
	AXIMX_PERIPH_ID5_ID_ID2 = 0xb6

	// PERIPH_ID6: Peripheral ID Register 6
	// Position of ID field.
	AXIMX_PERIPH_ID6_ID_Pos = 0x0
	// Bit mask of ID field.
	AXIMX_PERIPH_ID6_ID_Msk = 0xff
	// Part Number
	AXIMX_PERIPH_ID6_ID_ID0 = 0x1
	// 4KB count, JEP106 continuation code
	AXIMX_PERIPH_ID6_ID_ID4 = 0x4
	// JEP106[3:0, part number[11:8]
	AXIMX_PERIPH_ID6_ID_ID1 = 0xb3
	// Revision, JEP106 code flag, JEP106[6:4]
	AXIMX_PERIPH_ID6_ID_ID2 = 0xb6

	// PERIPH_ID7: Peripheral ID Register 7
	// Position of ID field.
	AXIMX_PERIPH_ID7_ID_Pos = 0x0
	// Bit mask of ID field.
	AXIMX_PERIPH_ID7_ID_Msk = 0xff
	// Part Number
	AXIMX_PERIPH_ID7_ID_ID0 = 0x1
	// 4KB count, JEP106 continuation code
	AXIMX_PERIPH_ID7_ID_ID4 = 0x4
	// JEP106[3:0, part number[11:8]
	AXIMX_PERIPH_ID7_ID_ID1 = 0xb3
	// Revision, JEP106 code flag, JEP106[6:4]
	AXIMX_PERIPH_ID7_ID_ID2 = 0xb6

	// PERIPH_ID0: Peripheral ID Register 0
	// Position of ID field.
	AXIMX_PERIPH_ID0_ID_Pos = 0x0
	// Bit mask of ID field.
	AXIMX_PERIPH_ID0_ID_Msk = 0xff
	// Part Number
	AXIMX_PERIPH_ID0_ID_ID0 = 0x1
	// 4KB count, JEP106 continuation code
	AXIMX_PERIPH_ID0_ID_ID4 = 0x4
	// JEP106[3:0, part number[11:8]
	AXIMX_PERIPH_ID0_ID_ID1 = 0xb3
	// Revision, JEP106 code flag, JEP106[6:4]
	AXIMX_PERIPH_ID0_ID_ID2 = 0xb6

	// PERIPH_ID1: Peripheral ID Register 1
	// Position of ID field.
	AXIMX_PERIPH_ID1_ID_Pos = 0x0
	// Bit mask of ID field.
	AXIMX_PERIPH_ID1_ID_Msk = 0xff
	// Part Number
	AXIMX_PERIPH_ID1_ID_ID0 = 0x1
	// 4KB count, JEP106 continuation code
	AXIMX_PERIPH_ID1_ID_ID4 = 0x4
	// JEP106[3:0, part number[11:8]
	AXIMX_PERIPH_ID1_ID_ID1 = 0xb3
	// Revision, JEP106 code flag, JEP106[6:4]
	AXIMX_PERIPH_ID1_ID_ID2 = 0xb6

	// PERIPH_ID2: Peripheral ID Register 2
	// Position of ID field.
	AXIMX_PERIPH_ID2_ID_Pos = 0x0
	// Bit mask of ID field.
	AXIMX_PERIPH_ID2_ID_Msk = 0xff
	// Part Number
	AXIMX_PERIPH_ID2_ID_ID0 = 0x1
	// 4KB count, JEP106 continuation code
	AXIMX_PERIPH_ID2_ID_ID4 = 0x4
	// JEP106[3:0, part number[11:8]
	AXIMX_PERIPH_ID2_ID_ID1 = 0xb3
	// Revision, JEP106 code flag, JEP106[6:4]
	AXIMX_PERIPH_ID2_ID_ID2 = 0xb6

	// PERIPH_ID3: Peripheral ID Register 3
	// Position of ID field.
	AXIMX_PERIPH_ID3_ID_Pos = 0x0
	// Bit mask of ID field.
	AXIMX_PERIPH_ID3_ID_Msk = 0xff
	// Part Number
	AXIMX_PERIPH_ID3_ID_ID0 = 0x1
	// 4KB count, JEP106 continuation code
	AXIMX_PERIPH_ID3_ID_ID4 = 0x4
	// JEP106[3:0, part number[11:8]
	AXIMX_PERIPH_ID3_ID_ID1 = 0xb3
	// Revision, JEP106 code flag, JEP106[6:4]
	AXIMX_PERIPH_ID3_ID_ID2 = 0xb6

	// COMP_ID: Component ID Register
	// Position of ID field.
	AXIMX_COMP_ID_ID_Pos = 0x0
	// Bit mask of ID field.
	AXIMX_COMP_ID_ID_Msk = 0xff

	// AMIB3_FN_MOD_BM_ISS: AMIB3 Bus Matrix Functionality Modification Register
	// Position of RD_ISS field.
	AXIMX_AMIB3_FN_MOD_BM_ISS_RD_ISS_Pos = 0x0
	// Bit mask of RD_ISS field.
	AXIMX_AMIB3_FN_MOD_BM_ISS_RD_ISS_Msk = 0x1
	// Bit RD_ISS.
	AXIMX_AMIB3_FN_MOD_BM_ISS_RD_ISS = 0x1
	// Position of WR_ISS field.
	AXIMX_AMIB3_FN_MOD_BM_ISS_WR_ISS_Pos = 0x1
	// Bit mask of WR_ISS field.
	AXIMX_AMIB3_FN_MOD_BM_ISS_WR_ISS_Msk = 0x2
	// Bit WR_ISS.
	AXIMX_AMIB3_FN_MOD_BM_ISS_WR_ISS = 0x2

	// AMIB3_FN_MOD2: AMIB3 Bypass Merge
	// Position of BP_MRG field.
	AXIMX_AMIB3_FN_MOD2_BP_MRG_Pos = 0x0
	// Bit mask of BP_MRG field.
	AXIMX_AMIB3_FN_MOD2_BP_MRG_Msk = 0x1
	// Bit BP_MRG.
	AXIMX_AMIB3_FN_MOD2_BP_MRG = 0x1

	// ASIB0_READ_QOS: ASIB0 Read Channel QoS Register
	// Position of RD_QOS field.
	AXIMX_ASIB0_READ_QOS_RD_QOS_Pos = 0x0
	// Bit mask of RD_QOS field.
	AXIMX_ASIB0_READ_QOS_RD_QOS_Msk = 0xf

	// ASIB0_WRITE_QOS: ASIB0 Write Channel QoS Register
	// Position of WR_QOS field.
	AXIMX_ASIB0_WRITE_QOS_WR_QOS_Pos = 0x0
	// Bit mask of WR_QOS field.
	AXIMX_ASIB0_WRITE_QOS_WR_QOS_Msk = 0xf

	// ASIB1_FN_MOD_AHB: ASIB1 AHB Functionality Modification Register
	// Position of RD_INCR_OVR field.
	AXIMX_ASIB1_FN_MOD_AHB_RD_INCR_OVR_Pos = 0x0
	// Bit mask of RD_INCR_OVR field.
	AXIMX_ASIB1_FN_MOD_AHB_RD_INCR_OVR_Msk = 0x1
	// Bit RD_INCR_OVR.
	AXIMX_ASIB1_FN_MOD_AHB_RD_INCR_OVR = 0x1
	// Position of WR_INCR_OVR field.
	AXIMX_ASIB1_FN_MOD_AHB_WR_INCR_OVR_Pos = 0x1
	// Bit mask of WR_INCR_OVR field.
	AXIMX_ASIB1_FN_MOD_AHB_WR_INCR_OVR_Msk = 0x2
	// Bit WR_INCR_OVR.
	AXIMX_ASIB1_FN_MOD_AHB_WR_INCR_OVR = 0x2
	// Position of LOCK_OVR field.
	AXIMX_ASIB1_FN_MOD_AHB_LOCK_OVR_Pos = 0x2
	// Bit mask of LOCK_OVR field.
	AXIMX_ASIB1_FN_MOD_AHB_LOCK_OVR_Msk = 0x4
	// Bit LOCK_OVR.
	AXIMX_ASIB1_FN_MOD_AHB_LOCK_OVR = 0x4

	// ASIB1_READ_QOS: ASIB1 Read Channel QoS Register
	// Position of RD_QOS field.
	AXIMX_ASIB1_READ_QOS_RD_QOS_Pos = 0x0
	// Bit mask of RD_QOS field.
	AXIMX_ASIB1_READ_QOS_RD_QOS_Msk = 0xf

	// ASIB1_WRITE_QOS: ASIB1 Write Channel QoS Register
	// Position of WR_QOS field.
	AXIMX_ASIB1_WRITE_QOS_WR_QOS_Pos = 0x0
	// Bit mask of WR_QOS field.
	AXIMX_ASIB1_WRITE_QOS_WR_QOS_Msk = 0xf

	// ASIB1_FN_MOD: ASIB1 Issuing Functionality Modification Register
	// Position of RD_ISS field.
	AXIMX_ASIB1_FN_MOD_RD_ISS_Pos = 0x0
	// Bit mask of RD_ISS field.
	AXIMX_ASIB1_FN_MOD_RD_ISS_Msk = 0x1
	// Bit RD_ISS.
	AXIMX_ASIB1_FN_MOD_RD_ISS = 0x1
	// Position of WR_ISS field.
	AXIMX_ASIB1_FN_MOD_WR_ISS_Pos = 0x1
	// Bit mask of WR_ISS field.
	AXIMX_ASIB1_FN_MOD_WR_ISS_Msk = 0x2
	// Bit WR_ISS.
	AXIMX_ASIB1_FN_MOD_WR_ISS = 0x2
)

// Bitfields for HSMCI0: High Speed MultiMedia Card Interface 0
const (
	// CR: Control Register
	// Position of MCIEN field.
	HSMCI_CR_MCIEN_Pos = 0x0
	// Bit mask of MCIEN field.
	HSMCI_CR_MCIEN_Msk = 0x1
	// Bit MCIEN.
	HSMCI_CR_MCIEN = 0x1
	// Position of MCIDIS field.
	HSMCI_CR_MCIDIS_Pos = 0x1
	// Bit mask of MCIDIS field.
	HSMCI_CR_MCIDIS_Msk = 0x2
	// Bit MCIDIS.
	HSMCI_CR_MCIDIS = 0x2
	// Position of PWSEN field.
	HSMCI_CR_PWSEN_Pos = 0x2
	// Bit mask of PWSEN field.
	HSMCI_CR_PWSEN_Msk = 0x4
	// Bit PWSEN.
	HSMCI_CR_PWSEN = 0x4
	// Position of PWSDIS field.
	HSMCI_CR_PWSDIS_Pos = 0x3
	// Bit mask of PWSDIS field.
	HSMCI_CR_PWSDIS_Msk = 0x8
	// Bit PWSDIS.
	HSMCI_CR_PWSDIS = 0x8
	// Position of SWRST field.
	HSMCI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	HSMCI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	HSMCI_CR_SWRST = 0x80

	// MR: Mode Register
	// Position of CLKDIV field.
	HSMCI_MR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	HSMCI_MR_CLKDIV_Msk = 0xff
	// Position of PWSDIV field.
	HSMCI_MR_PWSDIV_Pos = 0x8
	// Bit mask of PWSDIV field.
	HSMCI_MR_PWSDIV_Msk = 0x700
	// Position of RDPROOF field.
	HSMCI_MR_RDPROOF_Pos = 0xb
	// Bit mask of RDPROOF field.
	HSMCI_MR_RDPROOF_Msk = 0x800
	// Bit RDPROOF.
	HSMCI_MR_RDPROOF = 0x800
	// Position of WRPROOF field.
	HSMCI_MR_WRPROOF_Pos = 0xc
	// Bit mask of WRPROOF field.
	HSMCI_MR_WRPROOF_Msk = 0x1000
	// Bit WRPROOF.
	HSMCI_MR_WRPROOF = 0x1000
	// Position of FBYTE field.
	HSMCI_MR_FBYTE_Pos = 0xd
	// Bit mask of FBYTE field.
	HSMCI_MR_FBYTE_Msk = 0x2000
	// Bit FBYTE.
	HSMCI_MR_FBYTE = 0x2000
	// Position of PADV field.
	HSMCI_MR_PADV_Pos = 0xe
	// Bit mask of PADV field.
	HSMCI_MR_PADV_Msk = 0x4000
	// Bit PADV.
	HSMCI_MR_PADV = 0x4000
	// Position of CLKODD field.
	HSMCI_MR_CLKODD_Pos = 0x10
	// Bit mask of CLKODD field.
	HSMCI_MR_CLKODD_Msk = 0x10000
	// Bit CLKODD.
	HSMCI_MR_CLKODD = 0x10000

	// DTOR: Data Timeout Register
	// Position of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Pos = 0x0
	// Bit mask of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Msk = 0xf
	// Position of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Pos = 0x4
	// Bit mask of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Msk = 0x70
	// DTOCYC
	HSMCI_DTOR_DTOMUL_1 = 0x0
	// DTOCYC x 16
	HSMCI_DTOR_DTOMUL_16 = 0x1
	// DTOCYC x 128
	HSMCI_DTOR_DTOMUL_128 = 0x2
	// DTOCYC x 256
	HSMCI_DTOR_DTOMUL_256 = 0x3
	// DTOCYC x 1024
	HSMCI_DTOR_DTOMUL_1024 = 0x4
	// DTOCYC x 4096
	HSMCI_DTOR_DTOMUL_4096 = 0x5
	// DTOCYC x 65536
	HSMCI_DTOR_DTOMUL_65536 = 0x6
	// DTOCYC x 1048576
	HSMCI_DTOR_DTOMUL_1048576 = 0x7

	// SDCR: SD/SDIO Card Register
	// Position of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Pos = 0x0
	// Bit mask of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Msk = 0x3
	// Slot A is selected.
	HSMCI_SDCR_SDCSEL_SLOTA = 0x0
	// Position of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Pos = 0x6
	// Bit mask of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Msk = 0xc0
	// 1 bit
	HSMCI_SDCR_SDCBUS_1 = 0x0
	// 4 bit
	HSMCI_SDCR_SDCBUS_4 = 0x2
	// 8 bit
	HSMCI_SDCR_SDCBUS_8 = 0x3

	// ARGR: Argument Register
	// Position of ARG field.
	HSMCI_ARGR_ARG_Pos = 0x0
	// Bit mask of ARG field.
	HSMCI_ARGR_ARG_Msk = 0xffffffff

	// CMDR: Command Register
	// Position of CMDNB field.
	HSMCI_CMDR_CMDNB_Pos = 0x0
	// Bit mask of CMDNB field.
	HSMCI_CMDR_CMDNB_Msk = 0x3f
	// Position of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Pos = 0x6
	// Bit mask of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Msk = 0xc0
	// No response.
	HSMCI_CMDR_RSPTYP_NORESP = 0x0
	// 48-bit response.
	HSMCI_CMDR_RSPTYP_48_BIT = 0x1
	// 136-bit response.
	HSMCI_CMDR_RSPTYP_136_BIT = 0x2
	// R1b response type
	HSMCI_CMDR_RSPTYP_R1B = 0x3
	// Position of SPCMD field.
	HSMCI_CMDR_SPCMD_Pos = 0x8
	// Bit mask of SPCMD field.
	HSMCI_CMDR_SPCMD_Msk = 0x700
	// Not a special CMD.
	HSMCI_CMDR_SPCMD_STD = 0x0
	// Initialization CMD: 74 clock cycles for initialization sequence.
	HSMCI_CMDR_SPCMD_INIT = 0x1
	// Synchronized CMD: Wait for the end of the current data block transfer before sending the pending command.
	HSMCI_CMDR_SPCMD_SYNC = 0x2
	// CE-ATA Completion Signal disable Command. The host cancels the ability for the device to return a command completion signal on the command line.
	HSMCI_CMDR_SPCMD_CE_ATA = 0x3
	// Interrupt command: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_CMD = 0x4
	// Interrupt response: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_RESP = 0x5
	// Boot Operation Request. Start a boot operation mode, the host processor can read boot data from the MMC device directly.
	HSMCI_CMDR_SPCMD_BOR = 0x6
	// End Boot Operation. This command allows the host processor to terminate the boot operation mode.
	HSMCI_CMDR_SPCMD_EBO = 0x7
	// Position of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Pos = 0xb
	// Bit mask of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Msk = 0x800
	// Bit OPDCMD.
	HSMCI_CMDR_OPDCMD = 0x800
	// Push pull command.
	HSMCI_CMDR_OPDCMD_PUSHPULL = 0x0
	// Open drain command.
	HSMCI_CMDR_OPDCMD_OPENDRAIN = 0x1
	// Position of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Pos = 0xc
	// Bit mask of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Msk = 0x1000
	// Bit MAXLAT.
	HSMCI_CMDR_MAXLAT = 0x1000
	// 5-cycle max latency.
	HSMCI_CMDR_MAXLAT_5 = 0x0
	// 64-cycle max latency.
	HSMCI_CMDR_MAXLAT_64 = 0x1
	// Position of TRCMD field.
	HSMCI_CMDR_TRCMD_Pos = 0x10
	// Bit mask of TRCMD field.
	HSMCI_CMDR_TRCMD_Msk = 0x30000
	// No data transfer
	HSMCI_CMDR_TRCMD_NO_DATA = 0x0
	// Start data transfer
	HSMCI_CMDR_TRCMD_START_DATA = 0x1
	// Stop data transfer
	HSMCI_CMDR_TRCMD_STOP_DATA = 0x2
	// Position of TRDIR field.
	HSMCI_CMDR_TRDIR_Pos = 0x12
	// Bit mask of TRDIR field.
	HSMCI_CMDR_TRDIR_Msk = 0x40000
	// Bit TRDIR.
	HSMCI_CMDR_TRDIR = 0x40000
	// Write.
	HSMCI_CMDR_TRDIR_WRITE = 0x0
	// Read.
	HSMCI_CMDR_TRDIR_READ = 0x1
	// Position of TRTYP field.
	HSMCI_CMDR_TRTYP_Pos = 0x13
	// Bit mask of TRTYP field.
	HSMCI_CMDR_TRTYP_Msk = 0x380000
	// MMC/SD Card Single Block
	HSMCI_CMDR_TRTYP_SINGLE = 0x0
	// MMC/SD Card Multiple Block
	HSMCI_CMDR_TRTYP_MULTIPLE = 0x1
	// MMC Stream
	HSMCI_CMDR_TRTYP_STREAM = 0x2
	// SDIO Byte
	HSMCI_CMDR_TRTYP_BYTE = 0x4
	// SDIO Block
	HSMCI_CMDR_TRTYP_BLOCK = 0x5
	// Position of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Pos = 0x18
	// Bit mask of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Msk = 0x3000000
	// Not an SDIO Special Command
	HSMCI_CMDR_IOSPCMD_STD = 0x0
	// SDIO Suspend Command
	HSMCI_CMDR_IOSPCMD_SUSPEND = 0x1
	// SDIO Resume Command
	HSMCI_CMDR_IOSPCMD_RESUME = 0x2
	// Position of ATACS field.
	HSMCI_CMDR_ATACS_Pos = 0x1a
	// Bit mask of ATACS field.
	HSMCI_CMDR_ATACS_Msk = 0x4000000
	// Bit ATACS.
	HSMCI_CMDR_ATACS = 0x4000000
	// Normal operation mode.
	HSMCI_CMDR_ATACS_NORMAL = 0x0
	// This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR).
	HSMCI_CMDR_ATACS_COMPLETION = 0x1
	// Position of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Pos = 0x1b
	// Bit mask of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Msk = 0x8000000
	// Bit BOOT_ACK.
	HSMCI_CMDR_BOOT_ACK = 0x8000000

	// BLKR: Block Register
	// Position of BCNT field.
	HSMCI_BLKR_BCNT_Pos = 0x0
	// Bit mask of BCNT field.
	HSMCI_BLKR_BCNT_Msk = 0xffff
	// Position of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Msk = 0xffff0000

	// CSTOR: Completion Signal Timeout Register
	// Position of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Pos = 0x0
	// Bit mask of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Msk = 0xf
	// Position of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Pos = 0x4
	// Bit mask of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Msk = 0x70
	// CSTOCYC x 1
	HSMCI_CSTOR_CSTOMUL_1 = 0x0
	// CSTOCYC x 16
	HSMCI_CSTOR_CSTOMUL_16 = 0x1
	// CSTOCYC x 128
	HSMCI_CSTOR_CSTOMUL_128 = 0x2
	// CSTOCYC x 256
	HSMCI_CSTOR_CSTOMUL_256 = 0x3
	// CSTOCYC x 1024
	HSMCI_CSTOR_CSTOMUL_1024 = 0x4
	// CSTOCYC x 4096
	HSMCI_CSTOR_CSTOMUL_4096 = 0x5
	// CSTOCYC x 65536
	HSMCI_CSTOR_CSTOMUL_65536 = 0x6
	// CSTOCYC x 1048576
	HSMCI_CSTOR_CSTOMUL_1048576 = 0x7

	// RSPR: Response Register
	// Position of RSP field.
	HSMCI_RSPR_RSP_Pos = 0x0
	// Bit mask of RSP field.
	HSMCI_RSPR_RSP_Msk = 0xffffffff

	// RDR: Receive Data Register
	// Position of DATA field.
	HSMCI_RDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_RDR_DATA_Msk = 0xffffffff

	// TDR: Transmit Data Register
	// Position of DATA field.
	HSMCI_TDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_TDR_DATA_Msk = 0xffffffff

	// SR: Status Register
	// Position of CMDRDY field.
	HSMCI_SR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_SR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_SR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_SR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_SR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_SR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_SR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_SR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_SR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_SR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_SR_NOTBUSY = 0x20
	// Position of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_SR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_SR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_SR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_SR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_SR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_SR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_SR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_SR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_SR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_SR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_SR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_SR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_SR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_SR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_SR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_SR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_SR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_SR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_SR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_SR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_SR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_SR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_SR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_SR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_SR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_SR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_SR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_SR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_SR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_SR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_SR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_SR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_SR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_SR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_SR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_SR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_SR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_SR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_SR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_SR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_SR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_SR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_SR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_SR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_SR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_SR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_SR_UNRE = 0x80000000

	// IER: Interrupt Enable Register
	// Position of CMDRDY field.
	HSMCI_IER_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IER_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IER_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IER_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IER_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IER_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IER_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IER_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IER_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IER_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IER_NOTBUSY = 0x20
	// Position of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IER_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IER_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IER_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IER_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IER_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IER_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IER_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IER_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IER_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IER_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IER_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IER_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IER_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IER_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IER_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IER_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IER_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IER_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IER_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IER_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IER_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IER_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IER_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IER_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IER_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IER_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IER_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IER_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IER_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IER_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IER_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IER_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IER_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IER_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IER_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IER_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IER_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IER_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IER_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IER_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IER_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IER_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IER_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IER_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IER_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IER_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IER_UNRE = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of CMDRDY field.
	HSMCI_IDR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IDR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IDR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IDR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IDR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IDR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IDR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IDR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IDR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IDR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IDR_NOTBUSY = 0x20
	// Position of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IDR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IDR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IDR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IDR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IDR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IDR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IDR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IDR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IDR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IDR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IDR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IDR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IDR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IDR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IDR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IDR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IDR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IDR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IDR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IDR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IDR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IDR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IDR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IDR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IDR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IDR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IDR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IDR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IDR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IDR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IDR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IDR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IDR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IDR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IDR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IDR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IDR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IDR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IDR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IDR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IDR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IDR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IDR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IDR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IDR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IDR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IDR_UNRE = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of CMDRDY field.
	HSMCI_IMR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IMR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IMR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IMR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IMR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IMR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IMR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IMR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IMR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IMR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IMR_NOTBUSY = 0x20
	// Position of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IMR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IMR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IMR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IMR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IMR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IMR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IMR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IMR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IMR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IMR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IMR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IMR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IMR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IMR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IMR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IMR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IMR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IMR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IMR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IMR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IMR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IMR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IMR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IMR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IMR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IMR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IMR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IMR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IMR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IMR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IMR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IMR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IMR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IMR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IMR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IMR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IMR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IMR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IMR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IMR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IMR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IMR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IMR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IMR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IMR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IMR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IMR_UNRE = 0x80000000

	// DMA: DMA Configuration Register
	// Position of OFFSET field.
	HSMCI_DMA_OFFSET_Pos = 0x0
	// Bit mask of OFFSET field.
	HSMCI_DMA_OFFSET_Msk = 0x3
	// Position of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Pos = 0x4
	// Bit mask of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Msk = 0x70
	// Position of DMAEN field.
	HSMCI_DMA_DMAEN_Pos = 0x8
	// Bit mask of DMAEN field.
	HSMCI_DMA_DMAEN_Msk = 0x100
	// Bit DMAEN.
	HSMCI_DMA_DMAEN = 0x100
	// Position of ROPT field.
	HSMCI_DMA_ROPT_Pos = 0xc
	// Bit mask of ROPT field.
	HSMCI_DMA_ROPT_Msk = 0x1000
	// Bit ROPT.
	HSMCI_DMA_ROPT = 0x1000

	// CFG: Configuration Register
	// Position of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Pos = 0x0
	// Bit mask of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Msk = 0x1
	// Bit FIFOMODE.
	HSMCI_CFG_FIFOMODE = 0x1
	// Position of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Pos = 0x4
	// Bit mask of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Msk = 0x10
	// Bit FERRCTRL.
	HSMCI_CFG_FERRCTRL = 0x10
	// Position of HSMODE field.
	HSMCI_CFG_HSMODE_Pos = 0x8
	// Bit mask of HSMODE field.
	HSMCI_CFG_HSMODE_Msk = 0x100
	// Bit HSMODE.
	HSMCI_CFG_HSMODE = 0x100
	// Position of LSYNC field.
	HSMCI_CFG_LSYNC_Pos = 0xc
	// Bit mask of LSYNC field.
	HSMCI_CFG_LSYNC_Msk = 0x1000
	// Bit LSYNC.
	HSMCI_CFG_LSYNC = 0x1000

	// WPMR: Write Protection Mode Register
	// Position of WP_EN field.
	HSMCI_WPMR_WP_EN_Pos = 0x0
	// Bit mask of WP_EN field.
	HSMCI_WPMR_WP_EN_Msk = 0x1
	// Bit WP_EN.
	HSMCI_WPMR_WP_EN = 0x1
	// Position of WP_KEY field.
	HSMCI_WPMR_WP_KEY_Pos = 0x8
	// Bit mask of WP_KEY field.
	HSMCI_WPMR_WP_KEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of WP_VS field.
	HSMCI_WPSR_WP_VS_Pos = 0x0
	// Bit mask of WP_VS field.
	HSMCI_WPSR_WP_VS_Msk = 0xf
	// No Write Protection Violation occurred since the last read of this register (WP_SR)
	HSMCI_WPSR_WP_VS_NONE = 0x0
	// Write Protection detected unauthorized attempt to write a control register had occurred (since the last read.)
	HSMCI_WPSR_WP_VS_WRITE = 0x1
	// Software reset had been performed while Write Protection was enabled (since the last read).
	HSMCI_WPSR_WP_VS_RESET = 0x2
	// Both Write Protection violation and software reset with Write Protection enabled have occurred since the last read.
	HSMCI_WPSR_WP_VS_BOTH = 0x3
	// Position of WP_VSRC field.
	HSMCI_WPSR_WP_VSRC_Pos = 0x8
	// Bit mask of WP_VSRC field.
	HSMCI_WPSR_WP_VSRC_Msk = 0xffff00

	// FIFO: FIFO Memory Aperture0
	// Position of DATA field.
	HSMCI_FIFO_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_FIFO_DATA_Msk = 0xffffffff
)

// Bitfields for SPI0: Serial Peripheral Interface 0
const (
	// CR: Control Register
	// Position of SPIEN field.
	SPI_CR_SPIEN_Pos = 0x0
	// Bit mask of SPIEN field.
	SPI_CR_SPIEN_Msk = 0x1
	// Bit SPIEN.
	SPI_CR_SPIEN = 0x1
	// Position of SPIDIS field.
	SPI_CR_SPIDIS_Pos = 0x1
	// Bit mask of SPIDIS field.
	SPI_CR_SPIDIS_Msk = 0x2
	// Bit SPIDIS.
	SPI_CR_SPIDIS = 0x2
	// Position of SWRST field.
	SPI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	SPI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	SPI_CR_SWRST = 0x80
	// Position of LASTXFER field.
	SPI_CR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_CR_LASTXFER = 0x1000000

	// MR: Mode Register
	// Position of MSTR field.
	SPI_MR_MSTR_Pos = 0x0
	// Bit mask of MSTR field.
	SPI_MR_MSTR_Msk = 0x1
	// Bit MSTR.
	SPI_MR_MSTR = 0x1
	// Position of PS field.
	SPI_MR_PS_Pos = 0x1
	// Bit mask of PS field.
	SPI_MR_PS_Msk = 0x2
	// Bit PS.
	SPI_MR_PS = 0x2
	// Position of PCSDEC field.
	SPI_MR_PCSDEC_Pos = 0x2
	// Bit mask of PCSDEC field.
	SPI_MR_PCSDEC_Msk = 0x4
	// Bit PCSDEC.
	SPI_MR_PCSDEC = 0x4
	// Position of MODFDIS field.
	SPI_MR_MODFDIS_Pos = 0x4
	// Bit mask of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10
	// Bit MODFDIS.
	SPI_MR_MODFDIS = 0x10
	// Position of WDRBT field.
	SPI_MR_WDRBT_Pos = 0x5
	// Bit mask of WDRBT field.
	SPI_MR_WDRBT_Msk = 0x20
	// Bit WDRBT.
	SPI_MR_WDRBT = 0x20
	// Position of LLB field.
	SPI_MR_LLB_Pos = 0x7
	// Bit mask of LLB field.
	SPI_MR_LLB_Msk = 0x80
	// Bit LLB.
	SPI_MR_LLB = 0x80
	// Position of PCS field.
	SPI_MR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_MR_PCS_Msk = 0xf0000
	// Position of DLYBCS field.
	SPI_MR_DLYBCS_Pos = 0x18
	// Bit mask of DLYBCS field.
	SPI_MR_DLYBCS_Msk = 0xff000000

	// RDR: Receive Data Register
	// Position of RD field.
	SPI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SPI_RDR_RD_Msk = 0xffff
	// Position of PCS field.
	SPI_RDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000

	// TDR: Transmit Data Register
	// Position of TD field.
	SPI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SPI_TDR_TD_Msk = 0xffff
	// Position of PCS field.
	SPI_TDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_TDR_PCS_Msk = 0xf0000
	// Position of LASTXFER field.
	SPI_TDR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_TDR_LASTXFER = 0x1000000

	// SR: Status Register
	// Position of RDRF field.
	SPI_SR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_SR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_SR_RDRF = 0x1
	// Position of TDRE field.
	SPI_SR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_SR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_SR_TDRE = 0x2
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_SR_MODF = 0x4
	// Position of OVRES field.
	SPI_SR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_SR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_SR_OVRES = 0x8
	// Position of NSSR field.
	SPI_SR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_SR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_SR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_SR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_SR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_SR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_SR_UNDES = 0x400
	// Position of SPIENS field.
	SPI_SR_SPIENS_Pos = 0x10
	// Bit mask of SPIENS field.
	SPI_SR_SPIENS_Msk = 0x10000
	// Bit SPIENS.
	SPI_SR_SPIENS = 0x10000

	// IER: Interrupt Enable Register
	// Position of RDRF field.
	SPI_IER_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IER_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IER_RDRF = 0x1
	// Position of TDRE field.
	SPI_IER_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IER_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IER_TDRE = 0x2
	// Position of MODF field.
	SPI_IER_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IER_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IER_MODF = 0x4
	// Position of OVRES field.
	SPI_IER_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IER_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IER_OVRES = 0x8
	// Position of NSSR field.
	SPI_IER_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IER_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IER_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IER_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IER_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IER_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IER_UNDES = 0x400

	// IDR: Interrupt Disable Register
	// Position of RDRF field.
	SPI_IDR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IDR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IDR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IDR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IDR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IDR_TDRE = 0x2
	// Position of MODF field.
	SPI_IDR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IDR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IDR_MODF = 0x4
	// Position of OVRES field.
	SPI_IDR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IDR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IDR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IDR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IDR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IDR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IDR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IDR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IDR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IDR_UNDES = 0x400

	// IMR: Interrupt Mask Register
	// Position of RDRF field.
	SPI_IMR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IMR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IMR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IMR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IMR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IMR_TDRE = 0x2
	// Position of MODF field.
	SPI_IMR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IMR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IMR_MODF = 0x4
	// Position of OVRES field.
	SPI_IMR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IMR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IMR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IMR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IMR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IMR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IMR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IMR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IMR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IMR_UNDES = 0x400

	// CSR: Chip Select Register
	// Position of CPOL field.
	SPI_CSR_CPOL_Pos = 0x0
	// Bit mask of CPOL field.
	SPI_CSR_CPOL_Msk = 0x1
	// Bit CPOL.
	SPI_CSR_CPOL = 0x1
	// Position of NCPHA field.
	SPI_CSR_NCPHA_Pos = 0x1
	// Bit mask of NCPHA field.
	SPI_CSR_NCPHA_Msk = 0x2
	// Bit NCPHA.
	SPI_CSR_NCPHA = 0x2
	// Position of CSNAAT field.
	SPI_CSR_CSNAAT_Pos = 0x2
	// Bit mask of CSNAAT field.
	SPI_CSR_CSNAAT_Msk = 0x4
	// Bit CSNAAT.
	SPI_CSR_CSNAAT = 0x4
	// Position of CSAAT field.
	SPI_CSR_CSAAT_Pos = 0x3
	// Bit mask of CSAAT field.
	SPI_CSR_CSAAT_Msk = 0x8
	// Bit CSAAT.
	SPI_CSR_CSAAT = 0x8
	// Position of BITS field.
	SPI_CSR_BITS_Pos = 0x4
	// Bit mask of BITS field.
	SPI_CSR_BITS_Msk = 0xf0
	// 8 bits for transfer
	SPI_CSR_BITS_8_BIT = 0x0
	// 9 bits for transfer
	SPI_CSR_BITS_9_BIT = 0x1
	// 10 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2
	// 11 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3
	// 12 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4
	// 13 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5
	// 14 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6
	// 15 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7
	// 16 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8
	// Position of SCBR field.
	SPI_CSR_SCBR_Pos = 0x8
	// Bit mask of SCBR field.
	SPI_CSR_SCBR_Msk = 0xff00
	// Position of DLYBS field.
	SPI_CSR_DLYBS_Pos = 0x10
	// Bit mask of DLYBS field.
	SPI_CSR_DLYBS_Msk = 0xff0000
	// Position of DLYBCT field.
	SPI_CSR_DLYBCT_Pos = 0x18
	// Bit mask of DLYBCT field.
	SPI_CSR_DLYBCT_Msk = 0xff000000

	// WPMR: Write Protection Control Register
	// Position of WPEN field.
	SPI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SPI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SPI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SPI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SPI_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	SPI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	SPI_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	SPI_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	SPI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	SPI_WPSR_WPVSRC_Msk = 0xff00
)

// Bitfields for SSC0: Synchronous Serial Controller 0
const (
	// CR: Control Register
	// Position of RXEN field.
	SSC_CR_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	SSC_CR_RXEN_Msk = 0x1
	// Bit RXEN.
	SSC_CR_RXEN = 0x1
	// Position of RXDIS field.
	SSC_CR_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2
	// Bit RXDIS.
	SSC_CR_RXDIS = 0x2
	// Position of TXEN field.
	SSC_CR_TXEN_Pos = 0x8
	// Bit mask of TXEN field.
	SSC_CR_TXEN_Msk = 0x100
	// Bit TXEN.
	SSC_CR_TXEN = 0x100
	// Position of TXDIS field.
	SSC_CR_TXDIS_Pos = 0x9
	// Bit mask of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200
	// Bit TXDIS.
	SSC_CR_TXDIS = 0x200
	// Position of SWRST field.
	SSC_CR_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000
	// Bit SWRST.
	SSC_CR_SWRST = 0x8000

	// CMR: Clock Mode Register
	// Position of DIV field.
	SSC_CMR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SSC_CMR_DIV_Msk = 0xfff

	// RCMR: Receive Clock Mode Register
	// Position of CKS field.
	SSC_RCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_RCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_RCMR_CKS_MCK = 0x0
	// TK Clock signal
	SSC_RCMR_CKS_TK = 0x1
	// RK pin
	SSC_RCMR_CKS_RK = 0x2
	// Position of CKO field.
	SSC_RCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_RCMR_CKO_Msk = 0x1c
	// None, RK pin is an input
	SSC_RCMR_CKO_NONE = 0x0
	// Continuous Receive Clock, RK pin is an output
	SSC_RCMR_CKO_CONTINUOUS = 0x1
	// Receive Clock only during data transfers, RK pin is an output
	SSC_RCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_RCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_RCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_RCMR_CKI = 0x20
	// Position of CKG field.
	SSC_RCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_RCMR_CKG_Msk = 0xc0
	// None
	SSC_RCMR_CKG_CONTINUOUS = 0x0
	// Receive Clock enabled only if RF Pin is Low
	SSC_RCMR_CKG_EN_RF_LOW = 0x1
	// Receive Clock enabled only if RF Pin is High
	SSC_RCMR_CKG_EN_RF_HIGH = 0x2
	// Position of START field.
	SSC_RCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_RCMR_START_Msk = 0xf00
	// Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data.
	SSC_RCMR_START_CONTINUOUS = 0x0
	// Transmit start
	SSC_RCMR_START_TRANSMIT = 0x1
	// Detection of a low level on RF signal
	SSC_RCMR_START_RF_LOW = 0x2
	// Detection of a high level on RF signal
	SSC_RCMR_START_RF_HIGH = 0x3
	// Detection of a falling edge on RF signal
	SSC_RCMR_START_RF_FALLING = 0x4
	// Detection of a rising edge on RF signal
	SSC_RCMR_START_RF_RISING = 0x5
	// Detection of any level change on RF signal
	SSC_RCMR_START_RF_LEVEL = 0x6
	// Detection of any edge on RF signal
	SSC_RCMR_START_RF_EDGE = 0x7
	// Compare 0
	SSC_RCMR_START_CMP_0 = 0x8
	// Position of STOP field.
	SSC_RCMR_STOP_Pos = 0xc
	// Bit mask of STOP field.
	SSC_RCMR_STOP_Msk = 0x1000
	// Bit STOP.
	SSC_RCMR_STOP = 0x1000
	// Position of STTDLY field.
	SSC_RCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_RCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_RCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_RCMR_PERIOD_Msk = 0xff000000

	// RFMR: Receive Frame Mode Register
	// Position of DATLEN field.
	SSC_RFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_RFMR_DATLEN_Msk = 0x1f
	// Position of LOOP field.
	SSC_RFMR_LOOP_Pos = 0x5
	// Bit mask of LOOP field.
	SSC_RFMR_LOOP_Msk = 0x20
	// Bit LOOP.
	SSC_RFMR_LOOP = 0x20
	// Position of MSBF field.
	SSC_RFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_RFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_RFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_RFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_RFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_RFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_RFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_RFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_RFMR_FSOS_Msk = 0x700000
	// None, RF pin is an input
	SSC_RFMR_FSOS_NONE = 0x0
	// Negative Pulse, RF pin is an output
	SSC_RFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse, RF pin is an output
	SSC_RFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer, RF pin is an output
	SSC_RFMR_FSOS_LOW = 0x3
	// Driven High during data transfer, RF pin is an output
	SSC_RFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer, RF pin is an output
	SSC_RFMR_FSOS_TOGGLING = 0x5
	// Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_RFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_RFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_RFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Msk = 0xf0000000

	// TCMR: Transmit Clock Mode Register
	// Position of CKS field.
	SSC_TCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_TCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_TCMR_CKS_MCK = 0x0
	// RK Clock signal
	SSC_TCMR_CKS_RK = 0x1
	// TK pin
	SSC_TCMR_CKS_TK = 0x2
	// Position of CKO field.
	SSC_TCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_TCMR_CKO_Msk = 0x1c
	// None, TK pin is an input
	SSC_TCMR_CKO_NONE = 0x0
	// Continuous Transmit Clock, TK pin is an output
	SSC_TCMR_CKO_CONTINUOUS = 0x1
	// Transmit Clock only during data transfers, TK pin is an output
	SSC_TCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_TCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_TCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_TCMR_CKI = 0x20
	// Position of CKG field.
	SSC_TCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_TCMR_CKG_Msk = 0xc0
	// None
	SSC_TCMR_CKG_CONTINUOUS = 0x0
	// Transmit Clock enabled only if TF pin is Low
	SSC_TCMR_CKG_EN_TF_LOW = 0x1
	// Transmit Clock enabled only if TF pin is High
	SSC_TCMR_CKG_EN_TF_HIGH = 0x2
	// Position of START field.
	SSC_TCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_TCMR_START_Msk = 0xf00
	// Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data.
	SSC_TCMR_START_CONTINUOUS = 0x0
	// Receive start
	SSC_TCMR_START_RECEIVE = 0x1
	// Detection of a low level on TF signal
	SSC_TCMR_START_TF_LOW = 0x2
	// Detection of a high level on TF signal
	SSC_TCMR_START_TF_HIGH = 0x3
	// Detection of a falling edge on TF signal
	SSC_TCMR_START_TF_FALLING = 0x4
	// Detection of a rising edge on TF signal
	SSC_TCMR_START_TF_RISING = 0x5
	// Detection of any level change on TF signal
	SSC_TCMR_START_TF_LEVEL = 0x6
	// Detection of any edge on TF signal
	SSC_TCMR_START_TF_EDGE = 0x7
	// Position of STTDLY field.
	SSC_TCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_TCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_TCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_TCMR_PERIOD_Msk = 0xff000000

	// TFMR: Transmit Frame Mode Register
	// Position of DATLEN field.
	SSC_TFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_TFMR_DATLEN_Msk = 0x1f
	// Position of DATDEF field.
	SSC_TFMR_DATDEF_Pos = 0x5
	// Bit mask of DATDEF field.
	SSC_TFMR_DATDEF_Msk = 0x20
	// Bit DATDEF.
	SSC_TFMR_DATDEF = 0x20
	// Position of MSBF field.
	SSC_TFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_TFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_TFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_TFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_TFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_TFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_TFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_TFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_TFMR_FSOS_Msk = 0x700000
	// None, TF pin is an input
	SSC_TFMR_FSOS_NONE = 0x0
	// Negative Pulse, TF pin is an output
	SSC_TFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse,TF pin is an output
	SSC_TFMR_FSOS_POSITIVE = 0x2
	// TF pin Driven Low during data transfer
	SSC_TFMR_FSOS_LOW = 0x3
	// TF pin Driven High during data transfer
	SSC_TFMR_FSOS_HIGH = 0x4
	// TF pin Toggles at each start of data transfer
	SSC_TFMR_FSOS_TOGGLING = 0x5
	// Position of FSDEN field.
	SSC_TFMR_FSDEN_Pos = 0x17
	// Bit mask of FSDEN field.
	SSC_TFMR_FSDEN_Msk = 0x800000
	// Bit FSDEN.
	SSC_TFMR_FSDEN = 0x800000
	// Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_TFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_TFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_TFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Msk = 0xf0000000

	// RHR: Receive Holding Register
	// Position of RDAT field.
	SSC_RHR_RDAT_Pos = 0x0
	// Bit mask of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff

	// THR: Transmit Holding Register
	// Position of TDAT field.
	SSC_THR_TDAT_Pos = 0x0
	// Bit mask of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff

	// RSHR: Receive Sync. Holding Register
	// Position of RSDAT field.
	SSC_RSHR_RSDAT_Pos = 0x0
	// Bit mask of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff

	// TSHR: Transmit Sync. Holding Register
	// Position of TSDAT field.
	SSC_TSHR_TSDAT_Pos = 0x0
	// Bit mask of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff

	// RC0R: Receive Compare 0 Register
	// Position of CP0 field.
	SSC_RC0R_CP0_Pos = 0x0
	// Bit mask of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff

	// RC1R: Receive Compare 1 Register
	// Position of CP1 field.
	SSC_RC1R_CP1_Pos = 0x0
	// Bit mask of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff

	// SR: Status Register
	// Position of TXRDY field.
	SSC_SR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_SR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_SR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_SR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_SR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_SR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_SR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_SR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_SR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_SR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_SR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_SR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_SR_CP0 = 0x100
	// Position of CP1 field.
	SSC_SR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_SR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_SR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_SR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_SR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_SR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_SR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_SR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_SR_RXSYN = 0x800
	// Position of TXEN field.
	SSC_SR_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SSC_SR_TXEN_Msk = 0x10000
	// Bit TXEN.
	SSC_SR_TXEN = 0x10000
	// Position of RXEN field.
	SSC_SR_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SSC_SR_RXEN_Msk = 0x20000
	// Bit RXEN.
	SSC_SR_RXEN = 0x20000

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	SSC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IER_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IER_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IER_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IER_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IER_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IER_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IER_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IER_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IER_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IER_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IER_CP0 = 0x100
	// Position of CP1 field.
	SSC_IER_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IER_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IER_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IER_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IER_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IER_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IER_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IER_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IER_RXSYN = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	SSC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IDR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IDR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IDR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IDR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IDR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IDR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IDR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IDR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IDR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IDR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IDR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IDR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IDR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IDR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IDR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IDR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IDR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IDR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IDR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IDR_RXSYN = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	SSC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IMR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IMR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IMR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IMR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IMR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IMR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IMR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IMR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IMR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IMR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IMR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IMR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IMR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IMR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IMR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IMR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IMR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IMR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IMR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IMR_RXSYN = 0x800

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	SSC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SSC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SSC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SSC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SSC_WPMR_WPKEY_Msk = 0xffffff00
)

// Bitfields for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	// Position of CLKEN field.
	TC_CCR0_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR0_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR0_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR0_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR0_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR0_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR0_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR0_SWTRG = 0x4

	// CMR0: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR0_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR0_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR0_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR0_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR0_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR0_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR0_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR0_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR0_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR0_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR0_LDRA_Msk = 0x30000
	// None
	TC_CMR0_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR0_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR0_LDRB_Msk = 0xc0000
	// None
	TC_CMR0_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRB_EDGE = 0x3

	// CMR0_WAVE_EQ_1: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR0_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR0_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR0_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR0_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR0_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR0_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR0_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR0_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR0_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR0_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR0_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR0_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR0_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR0_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// SMMR0: Stepper Motor Mode Register (channel = 0)
	// Position of GCEN field.
	TC_SMMR0_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR0_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR0_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR0_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR0_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR0_DOWN = 0x2

	// RAB0: Register AB (channel = 0)
	// Position of RAB field.
	TC_RAB0_RAB_Pos = 0x0
	// Bit mask of RAB field.
	TC_RAB0_RAB_Msk = 0xffffffff

	// CV0: Counter Value (channel = 0)
	// Position of CV field.
	TC_CV0_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV0_CV_Msk = 0xffffffff

	// RA0: Register A (channel = 0)
	// Position of RA field.
	TC_RA0_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA0_RA_Msk = 0xffffffff

	// RB0: Register B (channel = 0)
	// Position of RB field.
	TC_RB0_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB0_RB_Msk = 0xffffffff

	// RC0: Register C (channel = 0)
	// Position of RC field.
	TC_RC0_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC0_RC_Msk = 0xffffffff

	// SR0: Status Register (channel = 0)
	// Position of COVFS field.
	TC_SR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR0_CPAS = 0x4
	// Position of CPBS field.
	TC_SR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR0_CPBS = 0x8
	// Position of CPCS field.
	TC_SR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR0_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR0_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR0_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR0_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR0_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR0_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR0_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR0_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR0_MTIOB = 0x40000

	// IER0: Interrupt Enable Register (channel = 0)
	// Position of COVFS field.
	TC_IER0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER0_CPAS = 0x4
	// Position of CPBS field.
	TC_IER0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER0_CPBS = 0x8
	// Position of CPCS field.
	TC_IER0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER0_ETRGS = 0x80

	// IDR0: Interrupt Disable Register (channel = 0)
	// Position of COVFS field.
	TC_IDR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR0_ETRGS = 0x80

	// IMR0: Interrupt Mask Register (channel = 0)
	// Position of COVFS field.
	TC_IMR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR0_ETRGS = 0x80

	// CCR1: Channel Control Register (channel = 1)
	// Position of CLKEN field.
	TC_CCR1_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR1_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR1_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR1_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR1_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR1_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR1_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR1_SWTRG = 0x4

	// CMR1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR1_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR1_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR1_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR1_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR1_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR1_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR1_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR1_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR1_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR1_LDRA_Msk = 0x30000
	// None
	TC_CMR1_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR1_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR1_LDRB_Msk = 0xc0000
	// None
	TC_CMR1_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRB_EDGE = 0x3

	// CMR1_WAVE_EQ_1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR1_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR1_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR1_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR1_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR1_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR1_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR1_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR1_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR1_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR1_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR1_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR1_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR1_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR1_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// SMMR1: Stepper Motor Mode Register (channel = 1)
	// Position of GCEN field.
	TC_SMMR1_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR1_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR1_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR1_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR1_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR1_DOWN = 0x2

	// RAB1: Register AB (channel = 1)
	// Position of RAB field.
	TC_RAB1_RAB_Pos = 0x0
	// Bit mask of RAB field.
	TC_RAB1_RAB_Msk = 0xffffffff

	// CV1: Counter Value (channel = 1)
	// Position of CV field.
	TC_CV1_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV1_CV_Msk = 0xffffffff

	// RA1: Register A (channel = 1)
	// Position of RA field.
	TC_RA1_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA1_RA_Msk = 0xffffffff

	// RB1: Register B (channel = 1)
	// Position of RB field.
	TC_RB1_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB1_RB_Msk = 0xffffffff

	// RC1: Register C (channel = 1)
	// Position of RC field.
	TC_RC1_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC1_RC_Msk = 0xffffffff

	// SR1: Status Register (channel = 1)
	// Position of COVFS field.
	TC_SR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR1_CPAS = 0x4
	// Position of CPBS field.
	TC_SR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR1_CPBS = 0x8
	// Position of CPCS field.
	TC_SR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR1_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR1_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR1_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR1_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR1_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR1_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR1_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR1_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR1_MTIOB = 0x40000

	// IER1: Interrupt Enable Register (channel = 1)
	// Position of COVFS field.
	TC_IER1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER1_CPAS = 0x4
	// Position of CPBS field.
	TC_IER1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER1_CPBS = 0x8
	// Position of CPCS field.
	TC_IER1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER1_ETRGS = 0x80

	// IDR1: Interrupt Disable Register (channel = 1)
	// Position of COVFS field.
	TC_IDR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR1_ETRGS = 0x80

	// IMR1: Interrupt Mask Register (channel = 1)
	// Position of COVFS field.
	TC_IMR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR1_ETRGS = 0x80

	// CCR2: Channel Control Register (channel = 2)
	// Position of CLKEN field.
	TC_CCR2_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR2_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR2_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR2_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR2_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR2_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR2_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR2_SWTRG = 0x4

	// CMR2: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR2_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR2_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR2_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR2_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR2_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR2_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR2_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR2_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR2_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR2_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR2_LDRA_Msk = 0x30000
	// None
	TC_CMR2_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR2_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR2_LDRB_Msk = 0xc0000
	// None
	TC_CMR2_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRB_EDGE = 0x3

	// CMR2_WAVE_EQ_1: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR2_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR2_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR2_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR2_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR2_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR2_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR2_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR2_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR2_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR2_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR2_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR2_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR2_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR2_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// SMMR2: Stepper Motor Mode Register (channel = 2)
	// Position of GCEN field.
	TC_SMMR2_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR2_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR2_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR2_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR2_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR2_DOWN = 0x2

	// RAB2: Register AB (channel = 2)
	// Position of RAB field.
	TC_RAB2_RAB_Pos = 0x0
	// Bit mask of RAB field.
	TC_RAB2_RAB_Msk = 0xffffffff

	// CV2: Counter Value (channel = 2)
	// Position of CV field.
	TC_CV2_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV2_CV_Msk = 0xffffffff

	// RA2: Register A (channel = 2)
	// Position of RA field.
	TC_RA2_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA2_RA_Msk = 0xffffffff

	// RB2: Register B (channel = 2)
	// Position of RB field.
	TC_RB2_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB2_RB_Msk = 0xffffffff

	// RC2: Register C (channel = 2)
	// Position of RC field.
	TC_RC2_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC2_RC_Msk = 0xffffffff

	// SR2: Status Register (channel = 2)
	// Position of COVFS field.
	TC_SR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR2_CPAS = 0x4
	// Position of CPBS field.
	TC_SR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR2_CPBS = 0x8
	// Position of CPCS field.
	TC_SR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR2_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR2_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR2_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR2_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR2_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR2_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR2_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR2_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR2_MTIOB = 0x40000

	// IER2: Interrupt Enable Register (channel = 2)
	// Position of COVFS field.
	TC_IER2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER2_CPAS = 0x4
	// Position of CPBS field.
	TC_IER2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER2_CPBS = 0x8
	// Position of CPCS field.
	TC_IER2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER2_ETRGS = 0x80

	// IDR2: Interrupt Disable Register (channel = 2)
	// Position of COVFS field.
	TC_IDR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR2_ETRGS = 0x80

	// IMR2: Interrupt Mask Register (channel = 2)
	// Position of COVFS field.
	TC_IMR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR2_ETRGS = 0x80

	// BCR: Block Control Register
	// Position of SYNC field.
	TC_BCR_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	TC_BCR_SYNC_Msk = 0x1
	// Bit SYNC.
	TC_BCR_SYNC = 0x1

	// BMR: Block Mode Register
	// Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Pos = 0x0
	// Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk = 0x3
	// Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TCLK0 = 0x0
	// Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA1 = 0x2
	// Signal connected to XC0: TIOA2
	TC_BMR_TC0XC0S_TIOA2 = 0x3
	// Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Pos = 0x2
	// Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk = 0xc
	// Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TCLK1 = 0x0
	// Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA0 = 0x2
	// Signal connected to XC1: TIOA2
	TC_BMR_TC1XC1S_TIOA2 = 0x3
	// Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Pos = 0x4
	// Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk = 0x30
	// Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TCLK2 = 0x0
	// Signal connected to XC2: TIOA1
	TC_BMR_TC2XC2S_TIOA1 = 0x2
	// Signal connected to XC2: TIOA2
	TC_BMR_TC2XC2S_TIOA2 = 0x3
	// Position of QDEN field.
	TC_BMR_QDEN_Pos = 0x8
	// Bit mask of QDEN field.
	TC_BMR_QDEN_Msk = 0x100
	// Bit QDEN.
	TC_BMR_QDEN = 0x100
	// Position of POSEN field.
	TC_BMR_POSEN_Pos = 0x9
	// Bit mask of POSEN field.
	TC_BMR_POSEN_Msk = 0x200
	// Bit POSEN.
	TC_BMR_POSEN = 0x200
	// Position of SPEEDEN field.
	TC_BMR_SPEEDEN_Pos = 0xa
	// Bit mask of SPEEDEN field.
	TC_BMR_SPEEDEN_Msk = 0x400
	// Bit SPEEDEN.
	TC_BMR_SPEEDEN = 0x400
	// Position of QDTRANS field.
	TC_BMR_QDTRANS_Pos = 0xb
	// Bit mask of QDTRANS field.
	TC_BMR_QDTRANS_Msk = 0x800
	// Bit QDTRANS.
	TC_BMR_QDTRANS = 0x800
	// Position of EDGPHA field.
	TC_BMR_EDGPHA_Pos = 0xc
	// Bit mask of EDGPHA field.
	TC_BMR_EDGPHA_Msk = 0x1000
	// Bit EDGPHA.
	TC_BMR_EDGPHA = 0x1000
	// Position of INVA field.
	TC_BMR_INVA_Pos = 0xd
	// Bit mask of INVA field.
	TC_BMR_INVA_Msk = 0x2000
	// Bit INVA.
	TC_BMR_INVA = 0x2000
	// Position of INVB field.
	TC_BMR_INVB_Pos = 0xe
	// Bit mask of INVB field.
	TC_BMR_INVB_Msk = 0x4000
	// Bit INVB.
	TC_BMR_INVB = 0x4000
	// Position of INVIDX field.
	TC_BMR_INVIDX_Pos = 0xf
	// Bit mask of INVIDX field.
	TC_BMR_INVIDX_Msk = 0x8000
	// Bit INVIDX.
	TC_BMR_INVIDX = 0x8000
	// Position of SWAP field.
	TC_BMR_SWAP_Pos = 0x10
	// Bit mask of SWAP field.
	TC_BMR_SWAP_Msk = 0x10000
	// Bit SWAP.
	TC_BMR_SWAP = 0x10000
	// Position of IDXPHB field.
	TC_BMR_IDXPHB_Pos = 0x11
	// Bit mask of IDXPHB field.
	TC_BMR_IDXPHB_Msk = 0x20000
	// Bit IDXPHB.
	TC_BMR_IDXPHB = 0x20000
	// Position of FILTER field.
	TC_BMR_FILTER_Pos = 0x13
	// Bit mask of FILTER field.
	TC_BMR_FILTER_Msk = 0x80000
	// Bit FILTER.
	TC_BMR_FILTER = 0x80000
	// Position of MAXFILT field.
	TC_BMR_MAXFILT_Pos = 0x14
	// Bit mask of MAXFILT field.
	TC_BMR_MAXFILT_Msk = 0x3f00000

	// QIER: QDEC Interrupt Enable Register
	// Position of IDX field.
	TC_QIER_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIER_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIER_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIER_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIER_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIER_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIER_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIER_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIER_QERR = 0x4

	// QIDR: QDEC Interrupt Disable Register
	// Position of IDX field.
	TC_QIDR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIDR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIDR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIDR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIDR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIDR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIDR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIDR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIDR_QERR = 0x4

	// QIMR: QDEC Interrupt Mask Register
	// Position of IDX field.
	TC_QIMR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIMR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIMR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIMR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIMR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIMR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIMR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIMR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIMR_QERR = 0x4

	// QISR: QDEC Interrupt Status Register
	// Position of IDX field.
	TC_QISR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QISR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QISR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QISR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QISR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QISR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QISR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QISR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QISR_QERR = 0x4
	// Position of DIR field.
	TC_QISR_DIR_Pos = 0x8
	// Bit mask of DIR field.
	TC_QISR_DIR_Msk = 0x100
	// Bit DIR.
	TC_QISR_DIR = 0x100

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	TC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	TC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	TC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	TC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	TC_WPMR_WPKEY_Msk = 0xffffff00
)

// Bitfields for TWI0: Two-wire Interface 0
const (
	// CR: Control Register
	// Position of START field.
	TWI_CR_START_Pos = 0x0
	// Bit mask of START field.
	TWI_CR_START_Msk = 0x1
	// Bit START.
	TWI_CR_START = 0x1
	// Position of STOP field.
	TWI_CR_STOP_Pos = 0x1
	// Bit mask of STOP field.
	TWI_CR_STOP_Msk = 0x2
	// Bit STOP.
	TWI_CR_STOP = 0x2
	// Position of MSEN field.
	TWI_CR_MSEN_Pos = 0x2
	// Bit mask of MSEN field.
	TWI_CR_MSEN_Msk = 0x4
	// Bit MSEN.
	TWI_CR_MSEN = 0x4
	// Position of MSDIS field.
	TWI_CR_MSDIS_Pos = 0x3
	// Bit mask of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8
	// Bit MSDIS.
	TWI_CR_MSDIS = 0x8
	// Position of SVEN field.
	TWI_CR_SVEN_Pos = 0x4
	// Bit mask of SVEN field.
	TWI_CR_SVEN_Msk = 0x10
	// Bit SVEN.
	TWI_CR_SVEN = 0x10
	// Position of SVDIS field.
	TWI_CR_SVDIS_Pos = 0x5
	// Bit mask of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20
	// Bit SVDIS.
	TWI_CR_SVDIS = 0x20
	// Position of QUICK field.
	TWI_CR_QUICK_Pos = 0x6
	// Bit mask of QUICK field.
	TWI_CR_QUICK_Msk = 0x40
	// Bit QUICK.
	TWI_CR_QUICK = 0x40
	// Position of SWRST field.
	TWI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	TWI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	TWI_CR_SWRST = 0x80

	// MMR: Master Mode Register
	// Position of IADRSZ field.
	TWI_MMR_IADRSZ_Pos = 0x8
	// Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_Msk = 0x300
	// No internal device address
	TWI_MMR_IADRSZ_NONE = 0x0
	// One-byte internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1
	// Two-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2
	// Three-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3
	// Position of MREAD field.
	TWI_MMR_MREAD_Pos = 0xc
	// Bit mask of MREAD field.
	TWI_MMR_MREAD_Msk = 0x1000
	// Bit MREAD.
	TWI_MMR_MREAD = 0x1000
	// Position of DADR field.
	TWI_MMR_DADR_Pos = 0x10
	// Bit mask of DADR field.
	TWI_MMR_DADR_Msk = 0x7f0000

	// SMR: Slave Mode Register
	// Position of SADR field.
	TWI_SMR_SADR_Pos = 0x10
	// Bit mask of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000

	// IADR: Internal Address Register
	// Position of IADR field.
	TWI_IADR_IADR_Pos = 0x0
	// Bit mask of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff

	// CWGR: Clock Waveform Generator Register
	// Position of CLDIV field.
	TWI_CWGR_CLDIV_Pos = 0x0
	// Bit mask of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff
	// Position of CHDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8
	// Bit mask of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00
	// Position of CKDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10
	// Bit mask of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000

	// SR: Status Register
	// Position of TXCOMP field.
	TWI_SR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_SR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_SR_TXRDY = 0x4
	// Position of SVREAD field.
	TWI_SR_SVREAD_Pos = 0x3
	// Bit mask of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8
	// Bit SVREAD.
	TWI_SR_SVREAD = 0x8
	// Position of SVACC field.
	TWI_SR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_SR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_SR_SVACC = 0x10
	// Position of GACC field.
	TWI_SR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_SR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_SR_GACC = 0x20
	// Position of OVRE field.
	TWI_SR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_SR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_SR_OVRE = 0x40
	// Position of NACK field.
	TWI_SR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_SR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_SR_NACK = 0x100
	// Position of ARBLST field.
	TWI_SR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_SR_ARBLST = 0x200
	// Position of SCLWS field.
	TWI_SR_SCLWS_Pos = 0xa
	// Bit mask of SCLWS field.
	TWI_SR_SCLWS_Msk = 0x400
	// Bit SCLWS.
	TWI_SR_SCLWS = 0x400
	// Position of EOSACC field.
	TWI_SR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_SR_EOSACC = 0x800

	// IER: Interrupt Enable Register
	// Position of TXCOMP field.
	TWI_IER_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IER_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IER_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IER_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IER_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IER_SVACC = 0x10
	// Position of GACC field.
	TWI_IER_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IER_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IER_GACC = 0x20
	// Position of OVRE field.
	TWI_IER_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IER_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IER_OVRE = 0x40
	// Position of NACK field.
	TWI_IER_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IER_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IER_NACK = 0x100
	// Position of ARBLST field.
	TWI_IER_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IER_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IER_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IER_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IER_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IER_EOSACC = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXCOMP field.
	TWI_IDR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IDR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IDR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IDR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IDR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IDR_SVACC = 0x10
	// Position of GACC field.
	TWI_IDR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IDR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IDR_GACC = 0x20
	// Position of OVRE field.
	TWI_IDR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IDR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IDR_OVRE = 0x40
	// Position of NACK field.
	TWI_IDR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IDR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IDR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IDR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IDR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IDR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IDR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IDR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IDR_EOSACC = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXCOMP field.
	TWI_IMR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IMR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IMR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IMR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IMR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IMR_SVACC = 0x10
	// Position of GACC field.
	TWI_IMR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IMR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IMR_GACC = 0x20
	// Position of OVRE field.
	TWI_IMR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IMR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IMR_OVRE = 0x40
	// Position of NACK field.
	TWI_IMR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IMR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IMR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IMR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IMR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IMR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IMR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IMR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IMR_EOSACC = 0x800

	// RHR: Receive Holding Register
	// Position of RXDATA field.
	TWI_RHR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXDATA field.
	TWI_THR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff

	// WPROT_MODE: Protection Mode Register
	// Position of WPROT field.
	TWI_WPROT_MODE_WPROT_Pos = 0x0
	// Bit mask of WPROT field.
	TWI_WPROT_MODE_WPROT_Msk = 0x1
	// Bit WPROT.
	TWI_WPROT_MODE_WPROT = 0x1
	// Position of SECURITY_CODE field.
	TWI_WPROT_MODE_SECURITY_CODE_Pos = 0x8
	// Bit mask of SECURITY_CODE field.
	TWI_WPROT_MODE_SECURITY_CODE_Msk = 0xffffff00

	// WPROT_STATUS: Protection Status Register
	// Position of WPROTERR field.
	TWI_WPROT_STATUS_WPROTERR_Pos = 0x0
	// Bit mask of WPROTERR field.
	TWI_WPROT_STATUS_WPROTERR_Msk = 0x1
	// Bit WPROTERR.
	TWI_WPROT_STATUS_WPROTERR = 0x1
	// Position of WPROTADDR field.
	TWI_WPROT_STATUS_WPROTADDR_Pos = 0x8
	// Bit mask of WPROTADDR field.
	TWI_WPROT_STATUS_WPROTADDR_Msk = 0xffffff00
)

// Bitfields for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	USART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_RSTSTA = 0x100
	// Position of STTBRK field.
	USART_CR_STTBRK_Pos = 0x9
	// Bit mask of STTBRK field.
	USART_CR_STTBRK_Msk = 0x200
	// Bit STTBRK.
	USART_CR_STTBRK = 0x200
	// Position of STPBRK field.
	USART_CR_STPBRK_Pos = 0xa
	// Bit mask of STPBRK field.
	USART_CR_STPBRK_Msk = 0x400
	// Bit STPBRK.
	USART_CR_STPBRK = 0x400
	// Position of STTTO field.
	USART_CR_STTTO_Pos = 0xb
	// Bit mask of STTTO field.
	USART_CR_STTTO_Msk = 0x800
	// Bit STTTO.
	USART_CR_STTTO = 0x800
	// Position of SENDA field.
	USART_CR_SENDA_Pos = 0xc
	// Bit mask of SENDA field.
	USART_CR_SENDA_Msk = 0x1000
	// Bit SENDA.
	USART_CR_SENDA = 0x1000
	// Position of RSTIT field.
	USART_CR_RSTIT_Pos = 0xd
	// Bit mask of RSTIT field.
	USART_CR_RSTIT_Msk = 0x2000
	// Bit RSTIT.
	USART_CR_RSTIT = 0x2000
	// Position of RSTNACK field.
	USART_CR_RSTNACK_Pos = 0xe
	// Bit mask of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000
	// Bit RSTNACK.
	USART_CR_RSTNACK = 0x4000
	// Position of RETTO field.
	USART_CR_RETTO_Pos = 0xf
	// Bit mask of RETTO field.
	USART_CR_RETTO_Msk = 0x8000
	// Bit RETTO.
	USART_CR_RETTO = 0x8000
	// Position of RTSEN field.
	USART_CR_RTSEN_Pos = 0x12
	// Bit mask of RTSEN field.
	USART_CR_RTSEN_Msk = 0x40000
	// Bit RTSEN.
	USART_CR_RTSEN = 0x40000
	// Position of RTSDIS field.
	USART_CR_RTSDIS_Pos = 0x13
	// Bit mask of RTSDIS field.
	USART_CR_RTSDIS_Msk = 0x80000
	// Bit RTSDIS.
	USART_CR_RTSDIS = 0x80000

	// CR_SPI_MODE: Control Register
	// Position of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_SPI_MODE_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_SPI_MODE_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_SPI_MODE_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_SPI_MODE_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_SPI_MODE_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_SPI_MODE_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_SPI_MODE_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_SPI_MODE_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_SPI_MODE_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_SPI_MODE_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_SPI_MODE_RSTSTA = 0x100
	// Position of FCS field.
	USART_CR_SPI_MODE_FCS_Pos = 0x12
	// Bit mask of FCS field.
	USART_CR_SPI_MODE_FCS_Msk = 0x40000
	// Bit FCS.
	USART_CR_SPI_MODE_FCS = 0x40000
	// Position of RCS field.
	USART_CR_SPI_MODE_RCS_Pos = 0x13
	// Bit mask of RCS field.
	USART_CR_SPI_MODE_RCS_Msk = 0x80000
	// Bit RCS.
	USART_CR_SPI_MODE_RCS = 0x80000

	// MR: Mode Register
	// Position of USART_MODE field.
	USART_MR_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_USART_MODE_Msk = 0xf
	// Normal mode
	USART_MR_USART_MODE_NORMAL = 0x0
	// RS485
	USART_MR_USART_MODE_RS485 = 0x1
	// Hardware Handshaking
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2
	// IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_0 = 0x4
	// IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IS07816_T_1 = 0x6
	// IrDA
	USART_MR_USART_MODE_IRDA = 0x8
	// SPI Master
	USART_MR_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=(DIV=8)) is selected
	USART_MR_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_CHRL_Msk = 0xc0
	// Character length is 5 bits
	USART_MR_CHRL_5_BIT = 0x0
	// Character length is 6 bits
	USART_MR_CHRL_6_BIT = 0x1
	// Character length is 7 bits
	USART_MR_CHRL_7_BIT = 0x2
	// Character length is 8 bits
	USART_MR_CHRL_8_BIT = 0x3
	// Position of SYNC field.
	USART_MR_SYNC_Pos = 0x8
	// Bit mask of SYNC field.
	USART_MR_SYNC_Msk = 0x100
	// Bit SYNC.
	USART_MR_SYNC = 0x100
	// Position of PAR field.
	USART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	USART_MR_PAR_Msk = 0xe00
	// Even parity
	USART_MR_PAR_EVEN = 0x0
	// Odd parity
	USART_MR_PAR_ODD = 0x1
	// Parity forced to 0 (Space)
	USART_MR_PAR_SPACE = 0x2
	// Parity forced to 1 (Mark)
	USART_MR_PAR_MARK = 0x3
	// No parity
	USART_MR_PAR_NO = 0x4
	// Multidrop mode
	USART_MR_PAR_MULTIDROP = 0x6
	// Position of NBSTOP field.
	USART_MR_NBSTOP_Pos = 0xc
	// Bit mask of NBSTOP field.
	USART_MR_NBSTOP_Msk = 0x3000
	// 1 stop bit
	USART_MR_NBSTOP_1_BIT = 0x0
	// 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_1_5_BIT = 0x1
	// 2 stop bits
	USART_MR_NBSTOP_2_BIT = 0x2
	// Position of CHMODE field.
	USART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	USART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	USART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_CHMODE_REMOTE_LOOPBACK = 0x3
	// Position of MSBF field.
	USART_MR_MSBF_Pos = 0x10
	// Bit mask of MSBF field.
	USART_MR_MSBF_Msk = 0x10000
	// Bit MSBF.
	USART_MR_MSBF = 0x10000
	// Position of MODE9 field.
	USART_MR_MODE9_Pos = 0x11
	// Bit mask of MODE9 field.
	USART_MR_MODE9_Msk = 0x20000
	// Bit MODE9.
	USART_MR_MODE9 = 0x20000
	// Position of CLKO field.
	USART_MR_CLKO_Pos = 0x12
	// Bit mask of CLKO field.
	USART_MR_CLKO_Msk = 0x40000
	// Bit CLKO.
	USART_MR_CLKO = 0x40000
	// Position of OVER field.
	USART_MR_OVER_Pos = 0x13
	// Bit mask of OVER field.
	USART_MR_OVER_Msk = 0x80000
	// Bit OVER.
	USART_MR_OVER = 0x80000
	// Position of INACK field.
	USART_MR_INACK_Pos = 0x14
	// Bit mask of INACK field.
	USART_MR_INACK_Msk = 0x100000
	// Bit INACK.
	USART_MR_INACK = 0x100000
	// Position of DSNACK field.
	USART_MR_DSNACK_Pos = 0x15
	// Bit mask of DSNACK field.
	USART_MR_DSNACK_Msk = 0x200000
	// Bit DSNACK.
	USART_MR_DSNACK = 0x200000
	// Position of VAR_SYNC field.
	USART_MR_VAR_SYNC_Pos = 0x16
	// Bit mask of VAR_SYNC field.
	USART_MR_VAR_SYNC_Msk = 0x400000
	// Bit VAR_SYNC.
	USART_MR_VAR_SYNC = 0x400000
	// Position of INVDATA field.
	USART_MR_INVDATA_Pos = 0x17
	// Bit mask of INVDATA field.
	USART_MR_INVDATA_Msk = 0x800000
	// Bit INVDATA.
	USART_MR_INVDATA = 0x800000
	// Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Pos = 0x18
	// Bit mask of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk = 0x7000000
	// Position of FILTER field.
	USART_MR_FILTER_Pos = 0x1c
	// Bit mask of FILTER field.
	USART_MR_FILTER_Msk = 0x10000000
	// Bit FILTER.
	USART_MR_FILTER = 0x10000000
	// Position of MAN field.
	USART_MR_MAN_Pos = 0x1d
	// Bit mask of MAN field.
	USART_MR_MAN_Msk = 0x20000000
	// Bit MAN.
	USART_MR_MAN = 0x20000000
	// Position of MODSYNC field.
	USART_MR_MODSYNC_Pos = 0x1e
	// Bit mask of MODSYNC field.
	USART_MR_MODSYNC_Msk = 0x40000000
	// Bit MODSYNC.
	USART_MR_MODSYNC = 0x40000000
	// Position of ONEBIT field.
	USART_MR_ONEBIT_Pos = 0x1f
	// Bit mask of ONEBIT field.
	USART_MR_ONEBIT_Msk = 0x80000000
	// Bit ONEBIT.
	USART_MR_ONEBIT = 0x80000000

	// MR_SPI_MODE: Mode Register
	// Position of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Msk = 0xf
	// SPI Master
	USART_MR_SPI_MODE_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_SPI_MODE_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_SPI_MODE_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=(DIV=8)) is selected
	USART_MR_SPI_MODE_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_SPI_MODE_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_SPI_MODE_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_SPI_MODE_CHRL_Msk = 0xc0
	// Character length is 8 bits
	USART_MR_SPI_MODE_CHRL_8_BIT = 0x3
	// Position of CPHA field.
	USART_MR_SPI_MODE_CPHA_Pos = 0x8
	// Bit mask of CPHA field.
	USART_MR_SPI_MODE_CPHA_Msk = 0x100
	// Bit CPHA.
	USART_MR_SPI_MODE_CPHA = 0x100
	// Position of CPOL field.
	USART_MR_SPI_MODE_CPOL_Pos = 0x10
	// Bit mask of CPOL field.
	USART_MR_SPI_MODE_CPOL_Msk = 0x10000
	// Bit CPOL.
	USART_MR_SPI_MODE_CPOL = 0x10000
	// Position of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Pos = 0x14
	// Bit mask of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Msk = 0x100000
	// Bit WRDBT.
	USART_MR_SPI_MODE_WRDBT = 0x100000

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IER_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IER_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IER_RXBRK = 0x4
	// Position of OVRE field.
	USART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_FRAME = 0x40
	// Position of PARE field.
	USART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IER_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IER_ITER_Msk = 0x400
	// Bit ITER.
	USART_IER_ITER = 0x400
	// Position of NACK field.
	USART_IER_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IER_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IER_NACK = 0x2000
	// Position of CTSIC field.
	USART_IER_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IER_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IER_CTSIC = 0x80000
	// Position of MANE field.
	USART_IER_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IER_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IER_MANE = 0x1000000

	// IER_SPI_MODE: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IER_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IER_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IER_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IER_SPI_MODE_UNRE = 0x400

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IDR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IDR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IDR_RXBRK = 0x4
	// Position of OVRE field.
	USART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IDR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IDR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IDR_ITER = 0x400
	// Position of NACK field.
	USART_IDR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IDR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IDR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IDR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IDR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IDR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IDR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IDR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IDR_MANE = 0x1000000

	// IDR_SPI_MODE: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IDR_SPI_MODE_UNRE = 0x400

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IMR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IMR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IMR_RXBRK = 0x4
	// Position of OVRE field.
	USART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IMR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IMR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IMR_ITER = 0x400
	// Position of NACK field.
	USART_IMR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IMR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IMR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IMR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IMR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IMR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IMR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IMR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IMR_MANE = 0x1000000

	// IMR_SPI_MODE: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IMR_SPI_MODE_UNRE = 0x400

	// CSR: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_CSR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_CSR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_CSR_RXBRK = 0x4
	// Position of OVRE field.
	USART_CSR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_CSR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_CSR_ITER_Msk = 0x400
	// Bit ITER.
	USART_CSR_ITER = 0x400
	// Position of NACK field.
	USART_CSR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_CSR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_CSR_NACK = 0x2000
	// Position of CTSIC field.
	USART_CSR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_CSR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_CSR_CTSIC = 0x80000
	// Position of CTS field.
	USART_CSR_CTS_Pos = 0x17
	// Bit mask of CTS field.
	USART_CSR_CTS_Msk = 0x800000
	// Bit CTS.
	USART_CSR_CTS = 0x800000
	// Position of MANERR field.
	USART_CSR_MANERR_Pos = 0x18
	// Bit mask of MANERR field.
	USART_CSR_MANERR_Msk = 0x1000000
	// Bit MANERR.
	USART_CSR_MANERR = 0x1000000

	// CSR_SPI_MODE: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_CSR_SPI_MODE_UNRE = 0x400

	// RHR: Receiver Holding Register
	// Position of RXCHR field.
	USART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	USART_RHR_RXCHR_Msk = 0x1ff
	// Position of RXSYNH field.
	USART_RHR_RXSYNH_Pos = 0xf
	// Bit mask of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000
	// Bit RXSYNH.
	USART_RHR_RXSYNH = 0x8000

	// THR: Transmitter Holding Register
	// Position of TXCHR field.
	USART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	USART_THR_TXCHR_Msk = 0x1ff
	// Position of TXSYNH field.
	USART_THR_TXSYNH_Pos = 0xf
	// Bit mask of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000
	// Bit TXSYNH.
	USART_THR_TXSYNH = 0x8000

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	USART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	USART_BRGR_CD_Msk = 0xffff
	// Position of FP field.
	USART_BRGR_FP_Pos = 0x10
	// Bit mask of FP field.
	USART_BRGR_FP_Msk = 0x70000

	// RTOR: Receiver Time-out Register
	// Position of TO field.
	USART_RTOR_TO_Pos = 0x0
	// Bit mask of TO field.
	USART_RTOR_TO_Msk = 0xffff

	// TTGR: Transmitter Timeguard Register
	// Position of TG field.
	USART_TTGR_TG_Pos = 0x0
	// Bit mask of TG field.
	USART_TTGR_TG_Msk = 0xff

	// FIDI: FI DI Ratio Register
	// Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Pos = 0x0
	// Bit mask of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff

	// NER: Number of Errors Register
	// Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Pos = 0x0
	// Bit mask of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff

	// IF: IrDA Filter Register
	// Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Pos = 0x0
	// Bit mask of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff

	// MAN: Manchester Encoder Decoder Register
	// Position of TX_PL field.
	USART_MAN_TX_PL_Pos = 0x0
	// Bit mask of TX_PL field.
	USART_MAN_TX_PL_Msk = 0xf
	// Position of TX_PP field.
	USART_MAN_TX_PP_Pos = 0x8
	// Bit mask of TX_PP field.
	USART_MAN_TX_PP_Msk = 0x300
	// The preamble is composed of '1's
	USART_MAN_TX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_TX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_TX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_TX_PP_ONE_ZERO = 0x3
	// Position of TX_MPOL field.
	USART_MAN_TX_MPOL_Pos = 0xc
	// Bit mask of TX_MPOL field.
	USART_MAN_TX_MPOL_Msk = 0x1000
	// Bit TX_MPOL.
	USART_MAN_TX_MPOL = 0x1000
	// Position of RX_PL field.
	USART_MAN_RX_PL_Pos = 0x10
	// Bit mask of RX_PL field.
	USART_MAN_RX_PL_Msk = 0xf0000
	// Position of RX_PP field.
	USART_MAN_RX_PP_Pos = 0x18
	// Bit mask of RX_PP field.
	USART_MAN_RX_PP_Msk = 0x3000000
	// The preamble is composed of '1's
	USART_MAN_RX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_RX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_RX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_RX_PP_ONE_ZERO = 0x3
	// Position of RX_MPOL field.
	USART_MAN_RX_MPOL_Pos = 0x1c
	// Bit mask of RX_MPOL field.
	USART_MAN_RX_MPOL_Msk = 0x10000000
	// Bit RX_MPOL.
	USART_MAN_RX_MPOL = 0x10000000
	// Position of ONE field.
	USART_MAN_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	USART_MAN_ONE_Msk = 0x20000000
	// Bit ONE.
	USART_MAN_ONE = 0x20000000
	// Position of DRIFT field.
	USART_MAN_DRIFT_Pos = 0x1e
	// Bit mask of DRIFT field.
	USART_MAN_DRIFT_Msk = 0x40000000
	// Bit DRIFT.
	USART_MAN_DRIFT = 0x40000000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	USART_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	USART_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	USART_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	USART_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	USART_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	USART_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	USART_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	USART_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	USART_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	USART_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for UART0: Universal Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	UART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	UART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	UART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	UART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	UART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	UART_CR_RSTTX = 0x8
	// Position of RXEN field.
	UART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	UART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	UART_CR_RXEN = 0x10
	// Position of RXDIS field.
	UART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	UART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	UART_CR_RXDIS = 0x20
	// Position of TXEN field.
	UART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	UART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	UART_CR_TXEN = 0x40
	// Position of TXDIS field.
	UART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	UART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	UART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	UART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	UART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	UART_CR_RSTSTA = 0x100

	// MR: Mode Register
	// Position of PAR field.
	UART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	UART_MR_PAR_Msk = 0xe00
	// Even Parity
	UART_MR_PAR_EVEN = 0x0
	// Odd Parity
	UART_MR_PAR_ODD = 0x1
	// Space: parity forced to 0
	UART_MR_PAR_SPACE = 0x2
	// Mark: parity forced to 1
	UART_MR_PAR_MARK = 0x3
	// No Parity
	UART_MR_PAR_NO = 0x4
	// Position of CHMODE field.
	UART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	UART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	UART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo
	UART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback
	UART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback
	UART_MR_CHMODE_REMOTE_LOOPBACK = 0x3

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	UART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IER_TXRDY = 0x2
	// Position of OVRE field.
	UART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IER_OVRE = 0x20
	// Position of FRAME field.
	UART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IER_FRAME = 0x40
	// Position of PARE field.
	UART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IER_PARE_Msk = 0x80
	// Bit PARE.
	UART_IER_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IER_TXEMPTY = 0x200

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	UART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IDR_TXRDY = 0x2
	// Position of OVRE field.
	UART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IDR_OVRE = 0x20
	// Position of FRAME field.
	UART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IDR_FRAME = 0x40
	// Position of PARE field.
	UART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IDR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IDR_TXEMPTY = 0x200

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	UART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IMR_TXRDY = 0x2
	// Position of OVRE field.
	UART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IMR_OVRE = 0x20
	// Position of FRAME field.
	UART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IMR_FRAME = 0x40
	// Position of PARE field.
	UART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IMR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IMR_TXEMPTY = 0x200

	// SR: Status Register
	// Position of RXRDY field.
	UART_SR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_SR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_SR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_SR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_SR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_SR_TXRDY = 0x2
	// Position of OVRE field.
	UART_SR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_SR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_SR_OVRE = 0x20
	// Position of FRAME field.
	UART_SR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_SR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_SR_FRAME = 0x40
	// Position of PARE field.
	UART_SR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_SR_PARE_Msk = 0x80
	// Bit PARE.
	UART_SR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_SR_TXEMPTY = 0x200

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	UART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	UART_RHR_RXCHR_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	UART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	UART_THR_TXCHR_Msk = 0xff

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	UART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	UART_BRGR_CD_Msk = 0xffff
)

// Bitfields for PWM: Pulse Width Modulation Controller
const (
	// CLK: PWM Clock Register
	// Position of DIVA field.
	PWM_CLK_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PWM_CLK_DIVA_Msk = 0xff
	// Position of PREA field.
	PWM_CLK_PREA_Pos = 0x8
	// Bit mask of PREA field.
	PWM_CLK_PREA_Msk = 0xf00
	// Position of DIVB field.
	PWM_CLK_DIVB_Pos = 0x10
	// Bit mask of DIVB field.
	PWM_CLK_DIVB_Msk = 0xff0000
	// Position of PREB field.
	PWM_CLK_PREB_Pos = 0x18
	// Bit mask of PREB field.
	PWM_CLK_PREB_Msk = 0xf000000

	// ENA: PWM Enable Register
	// Position of CHID0 field.
	PWM_ENA_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ENA_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ENA_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ENA_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ENA_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ENA_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ENA_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ENA_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ENA_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ENA_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ENA_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ENA_CHID3 = 0x8

	// DIS: PWM Disable Register
	// Position of CHID0 field.
	PWM_DIS_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_DIS_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_DIS_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_DIS_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_DIS_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_DIS_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_DIS_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_DIS_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_DIS_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_DIS_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_DIS_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_DIS_CHID3 = 0x8

	// SR: PWM Status Register
	// Position of CHID0 field.
	PWM_SR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_SR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_SR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_SR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_SR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_SR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_SR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_SR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_SR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_SR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_SR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_SR_CHID3 = 0x8

	// IER1: PWM Interrupt Enable Register 1
	// Position of CHID0 field.
	PWM_IER1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IER1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IER1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IER1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IER1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IER1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IER1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IER1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IER1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IER1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IER1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IER1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_IER1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IER1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IER1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IER1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IER1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IER1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IER1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IER1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IER1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IER1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IER1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IER1_FCHID3 = 0x80000

	// IDR1: PWM Interrupt Disable Register 1
	// Position of CHID0 field.
	PWM_IDR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IDR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IDR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IDR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IDR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IDR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IDR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IDR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IDR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IDR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IDR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IDR1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_IDR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IDR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IDR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IDR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IDR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IDR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IDR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IDR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IDR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IDR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IDR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IDR1_FCHID3 = 0x80000

	// IMR1: PWM Interrupt Mask Register 1
	// Position of CHID0 field.
	PWM_IMR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IMR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IMR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IMR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IMR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IMR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IMR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IMR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IMR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IMR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IMR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IMR1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_IMR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IMR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IMR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IMR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IMR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IMR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IMR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IMR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IMR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IMR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IMR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IMR1_FCHID3 = 0x80000

	// ISR1: PWM Interrupt Status Register 1
	// Position of CHID0 field.
	PWM_ISR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ISR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ISR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ISR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ISR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ISR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ISR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ISR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ISR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ISR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ISR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ISR1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_ISR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_ISR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_ISR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_ISR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_ISR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_ISR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_ISR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_ISR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_ISR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_ISR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_ISR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_ISR1_FCHID3 = 0x80000

	// SCM: PWM Sync Channels Mode Register
	// Position of SYNC0 field.
	PWM_SCM_SYNC0_Pos = 0x0
	// Bit mask of SYNC0 field.
	PWM_SCM_SYNC0_Msk = 0x1
	// Bit SYNC0.
	PWM_SCM_SYNC0 = 0x1
	// Position of SYNC1 field.
	PWM_SCM_SYNC1_Pos = 0x1
	// Bit mask of SYNC1 field.
	PWM_SCM_SYNC1_Msk = 0x2
	// Bit SYNC1.
	PWM_SCM_SYNC1 = 0x2
	// Position of SYNC2 field.
	PWM_SCM_SYNC2_Pos = 0x2
	// Bit mask of SYNC2 field.
	PWM_SCM_SYNC2_Msk = 0x4
	// Bit SYNC2.
	PWM_SCM_SYNC2 = 0x4
	// Position of SYNC3 field.
	PWM_SCM_SYNC3_Pos = 0x3
	// Bit mask of SYNC3 field.
	PWM_SCM_SYNC3_Msk = 0x8
	// Bit SYNC3.
	PWM_SCM_SYNC3 = 0x8
	// Position of UPDM field.
	PWM_SCM_UPDM_Pos = 0x10
	// Bit mask of UPDM field.
	PWM_SCM_UPDM_Msk = 0x30000
	// Manual write of double buffer registers and manual update of synchronous channels
	PWM_SCM_UPDM_MODE0 = 0x0
	// Manual write of double buffer registers and automatic update of synchronous channels
	PWM_SCM_UPDM_MODE1 = 0x1

	// SCUC: PWM Sync Channels Update Control Register
	// Position of UPDULOCK field.
	PWM_SCUC_UPDULOCK_Pos = 0x0
	// Bit mask of UPDULOCK field.
	PWM_SCUC_UPDULOCK_Msk = 0x1
	// Bit UPDULOCK.
	PWM_SCUC_UPDULOCK = 0x1

	// SCUP: PWM Sync Channels Update Period Register
	// Position of UPR field.
	PWM_SCUP_UPR_Pos = 0x0
	// Bit mask of UPR field.
	PWM_SCUP_UPR_Msk = 0xf
	// Position of UPRCNT field.
	PWM_SCUP_UPRCNT_Pos = 0x4
	// Bit mask of UPRCNT field.
	PWM_SCUP_UPRCNT_Msk = 0xf0

	// SCUPUPD: PWM Sync Channels Update Period Update Register
	// Position of UPRUPD field.
	PWM_SCUPUPD_UPRUPD_Pos = 0x0
	// Bit mask of UPRUPD field.
	PWM_SCUPUPD_UPRUPD_Msk = 0xf

	// IER2: PWM Interrupt Enable Register 2
	// Position of WRDY field.
	PWM_IER2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IER2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IER2_WRDY = 0x1
	// Position of UNRE field.
	PWM_IER2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IER2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IER2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IER2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IER2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IER2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IER2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IER2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IER2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IER2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IER2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IER2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IER2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IER2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IER2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IER2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IER2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IER2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IER2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IER2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IER2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IER2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IER2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IER2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IER2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IER2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IER2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IER2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IER2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IER2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IER2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IER2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IER2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IER2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IER2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IER2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IER2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IER2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IER2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IER2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IER2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IER2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IER2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IER2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IER2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IER2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IER2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IER2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IER2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IER2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IER2_CMPU7 = 0x800000

	// IDR2: PWM Interrupt Disable Register 2
	// Position of WRDY field.
	PWM_IDR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IDR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IDR2_WRDY = 0x1
	// Position of UNRE field.
	PWM_IDR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IDR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IDR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IDR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IDR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IDR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IDR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IDR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IDR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IDR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IDR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IDR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IDR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IDR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IDR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IDR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IDR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IDR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IDR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IDR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IDR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IDR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IDR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IDR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IDR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IDR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IDR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IDR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IDR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IDR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IDR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IDR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IDR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IDR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IDR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IDR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IDR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IDR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IDR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IDR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IDR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IDR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IDR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IDR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IDR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IDR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IDR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IDR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IDR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IDR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IDR2_CMPU7 = 0x800000

	// IMR2: PWM Interrupt Mask Register 2
	// Position of WRDY field.
	PWM_IMR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IMR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IMR2_WRDY = 0x1
	// Position of UNRE field.
	PWM_IMR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IMR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IMR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IMR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IMR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IMR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IMR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IMR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IMR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IMR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IMR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IMR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IMR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IMR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IMR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IMR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IMR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IMR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IMR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IMR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IMR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IMR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IMR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IMR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IMR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IMR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IMR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IMR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IMR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IMR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IMR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IMR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IMR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IMR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IMR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IMR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IMR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IMR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IMR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IMR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IMR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IMR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IMR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IMR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IMR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IMR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IMR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IMR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IMR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IMR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IMR2_CMPU7 = 0x800000

	// ISR2: PWM Interrupt Status Register 2
	// Position of WRDY field.
	PWM_ISR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_ISR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_ISR2_WRDY = 0x1
	// Position of UNRE field.
	PWM_ISR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_ISR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_ISR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_ISR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_ISR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_ISR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_ISR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_ISR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_ISR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_ISR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_ISR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_ISR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_ISR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_ISR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_ISR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_ISR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_ISR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_ISR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_ISR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_ISR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_ISR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_ISR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_ISR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_ISR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_ISR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_ISR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_ISR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_ISR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_ISR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_ISR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_ISR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_ISR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_ISR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_ISR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_ISR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_ISR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_ISR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_ISR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_ISR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_ISR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_ISR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_ISR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_ISR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_ISR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_ISR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_ISR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_ISR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_ISR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_ISR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_ISR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_ISR2_CMPU7 = 0x800000

	// OOV: PWM Output Override Value Register
	// Position of OOVH0 field.
	PWM_OOV_OOVH0_Pos = 0x0
	// Bit mask of OOVH0 field.
	PWM_OOV_OOVH0_Msk = 0x1
	// Bit OOVH0.
	PWM_OOV_OOVH0 = 0x1
	// Position of OOVH1 field.
	PWM_OOV_OOVH1_Pos = 0x1
	// Bit mask of OOVH1 field.
	PWM_OOV_OOVH1_Msk = 0x2
	// Bit OOVH1.
	PWM_OOV_OOVH1 = 0x2
	// Position of OOVH2 field.
	PWM_OOV_OOVH2_Pos = 0x2
	// Bit mask of OOVH2 field.
	PWM_OOV_OOVH2_Msk = 0x4
	// Bit OOVH2.
	PWM_OOV_OOVH2 = 0x4
	// Position of OOVH3 field.
	PWM_OOV_OOVH3_Pos = 0x3
	// Bit mask of OOVH3 field.
	PWM_OOV_OOVH3_Msk = 0x8
	// Bit OOVH3.
	PWM_OOV_OOVH3 = 0x8
	// Position of OOVL0 field.
	PWM_OOV_OOVL0_Pos = 0x10
	// Bit mask of OOVL0 field.
	PWM_OOV_OOVL0_Msk = 0x10000
	// Bit OOVL0.
	PWM_OOV_OOVL0 = 0x10000
	// Position of OOVL1 field.
	PWM_OOV_OOVL1_Pos = 0x11
	// Bit mask of OOVL1 field.
	PWM_OOV_OOVL1_Msk = 0x20000
	// Bit OOVL1.
	PWM_OOV_OOVL1 = 0x20000
	// Position of OOVL2 field.
	PWM_OOV_OOVL2_Pos = 0x12
	// Bit mask of OOVL2 field.
	PWM_OOV_OOVL2_Msk = 0x40000
	// Bit OOVL2.
	PWM_OOV_OOVL2 = 0x40000
	// Position of OOVL3 field.
	PWM_OOV_OOVL3_Pos = 0x13
	// Bit mask of OOVL3 field.
	PWM_OOV_OOVL3_Msk = 0x80000
	// Bit OOVL3.
	PWM_OOV_OOVL3 = 0x80000

	// OS: PWM Output Selection Register
	// Position of OSH0 field.
	PWM_OS_OSH0_Pos = 0x0
	// Bit mask of OSH0 field.
	PWM_OS_OSH0_Msk = 0x1
	// Bit OSH0.
	PWM_OS_OSH0 = 0x1
	// Position of OSH1 field.
	PWM_OS_OSH1_Pos = 0x1
	// Bit mask of OSH1 field.
	PWM_OS_OSH1_Msk = 0x2
	// Bit OSH1.
	PWM_OS_OSH1 = 0x2
	// Position of OSH2 field.
	PWM_OS_OSH2_Pos = 0x2
	// Bit mask of OSH2 field.
	PWM_OS_OSH2_Msk = 0x4
	// Bit OSH2.
	PWM_OS_OSH2 = 0x4
	// Position of OSH3 field.
	PWM_OS_OSH3_Pos = 0x3
	// Bit mask of OSH3 field.
	PWM_OS_OSH3_Msk = 0x8
	// Bit OSH3.
	PWM_OS_OSH3 = 0x8
	// Position of OSL0 field.
	PWM_OS_OSL0_Pos = 0x10
	// Bit mask of OSL0 field.
	PWM_OS_OSL0_Msk = 0x10000
	// Bit OSL0.
	PWM_OS_OSL0 = 0x10000
	// Position of OSL1 field.
	PWM_OS_OSL1_Pos = 0x11
	// Bit mask of OSL1 field.
	PWM_OS_OSL1_Msk = 0x20000
	// Bit OSL1.
	PWM_OS_OSL1 = 0x20000
	// Position of OSL2 field.
	PWM_OS_OSL2_Pos = 0x12
	// Bit mask of OSL2 field.
	PWM_OS_OSL2_Msk = 0x40000
	// Bit OSL2.
	PWM_OS_OSL2 = 0x40000
	// Position of OSL3 field.
	PWM_OS_OSL3_Pos = 0x13
	// Bit mask of OSL3 field.
	PWM_OS_OSL3_Msk = 0x80000
	// Bit OSL3.
	PWM_OS_OSL3 = 0x80000

	// OSS: PWM Output Selection Set Register
	// Position of OSSH0 field.
	PWM_OSS_OSSH0_Pos = 0x0
	// Bit mask of OSSH0 field.
	PWM_OSS_OSSH0_Msk = 0x1
	// Bit OSSH0.
	PWM_OSS_OSSH0 = 0x1
	// Position of OSSH1 field.
	PWM_OSS_OSSH1_Pos = 0x1
	// Bit mask of OSSH1 field.
	PWM_OSS_OSSH1_Msk = 0x2
	// Bit OSSH1.
	PWM_OSS_OSSH1 = 0x2
	// Position of OSSH2 field.
	PWM_OSS_OSSH2_Pos = 0x2
	// Bit mask of OSSH2 field.
	PWM_OSS_OSSH2_Msk = 0x4
	// Bit OSSH2.
	PWM_OSS_OSSH2 = 0x4
	// Position of OSSH3 field.
	PWM_OSS_OSSH3_Pos = 0x3
	// Bit mask of OSSH3 field.
	PWM_OSS_OSSH3_Msk = 0x8
	// Bit OSSH3.
	PWM_OSS_OSSH3 = 0x8
	// Position of OSSL0 field.
	PWM_OSS_OSSL0_Pos = 0x10
	// Bit mask of OSSL0 field.
	PWM_OSS_OSSL0_Msk = 0x10000
	// Bit OSSL0.
	PWM_OSS_OSSL0 = 0x10000
	// Position of OSSL1 field.
	PWM_OSS_OSSL1_Pos = 0x11
	// Bit mask of OSSL1 field.
	PWM_OSS_OSSL1_Msk = 0x20000
	// Bit OSSL1.
	PWM_OSS_OSSL1 = 0x20000
	// Position of OSSL2 field.
	PWM_OSS_OSSL2_Pos = 0x12
	// Bit mask of OSSL2 field.
	PWM_OSS_OSSL2_Msk = 0x40000
	// Bit OSSL2.
	PWM_OSS_OSSL2 = 0x40000
	// Position of OSSL3 field.
	PWM_OSS_OSSL3_Pos = 0x13
	// Bit mask of OSSL3 field.
	PWM_OSS_OSSL3_Msk = 0x80000
	// Bit OSSL3.
	PWM_OSS_OSSL3 = 0x80000

	// OSC: PWM Output Selection Clear Register
	// Position of OSCH0 field.
	PWM_OSC_OSCH0_Pos = 0x0
	// Bit mask of OSCH0 field.
	PWM_OSC_OSCH0_Msk = 0x1
	// Bit OSCH0.
	PWM_OSC_OSCH0 = 0x1
	// Position of OSCH1 field.
	PWM_OSC_OSCH1_Pos = 0x1
	// Bit mask of OSCH1 field.
	PWM_OSC_OSCH1_Msk = 0x2
	// Bit OSCH1.
	PWM_OSC_OSCH1 = 0x2
	// Position of OSCH2 field.
	PWM_OSC_OSCH2_Pos = 0x2
	// Bit mask of OSCH2 field.
	PWM_OSC_OSCH2_Msk = 0x4
	// Bit OSCH2.
	PWM_OSC_OSCH2 = 0x4
	// Position of OSCH3 field.
	PWM_OSC_OSCH3_Pos = 0x3
	// Bit mask of OSCH3 field.
	PWM_OSC_OSCH3_Msk = 0x8
	// Bit OSCH3.
	PWM_OSC_OSCH3 = 0x8
	// Position of OSCL0 field.
	PWM_OSC_OSCL0_Pos = 0x10
	// Bit mask of OSCL0 field.
	PWM_OSC_OSCL0_Msk = 0x10000
	// Bit OSCL0.
	PWM_OSC_OSCL0 = 0x10000
	// Position of OSCL1 field.
	PWM_OSC_OSCL1_Pos = 0x11
	// Bit mask of OSCL1 field.
	PWM_OSC_OSCL1_Msk = 0x20000
	// Bit OSCL1.
	PWM_OSC_OSCL1 = 0x20000
	// Position of OSCL2 field.
	PWM_OSC_OSCL2_Pos = 0x12
	// Bit mask of OSCL2 field.
	PWM_OSC_OSCL2_Msk = 0x40000
	// Bit OSCL2.
	PWM_OSC_OSCL2 = 0x40000
	// Position of OSCL3 field.
	PWM_OSC_OSCL3_Pos = 0x13
	// Bit mask of OSCL3 field.
	PWM_OSC_OSCL3_Msk = 0x80000
	// Bit OSCL3.
	PWM_OSC_OSCL3 = 0x80000

	// OSSUPD: PWM Output Selection Set Update Register
	// Position of OSSUPH0 field.
	PWM_OSSUPD_OSSUPH0_Pos = 0x0
	// Bit mask of OSSUPH0 field.
	PWM_OSSUPD_OSSUPH0_Msk = 0x1
	// Bit OSSUPH0.
	PWM_OSSUPD_OSSUPH0 = 0x1
	// Position of OSSUPH1 field.
	PWM_OSSUPD_OSSUPH1_Pos = 0x1
	// Bit mask of OSSUPH1 field.
	PWM_OSSUPD_OSSUPH1_Msk = 0x2
	// Bit OSSUPH1.
	PWM_OSSUPD_OSSUPH1 = 0x2
	// Position of OSSUPH2 field.
	PWM_OSSUPD_OSSUPH2_Pos = 0x2
	// Bit mask of OSSUPH2 field.
	PWM_OSSUPD_OSSUPH2_Msk = 0x4
	// Bit OSSUPH2.
	PWM_OSSUPD_OSSUPH2 = 0x4
	// Position of OSSUPH3 field.
	PWM_OSSUPD_OSSUPH3_Pos = 0x3
	// Bit mask of OSSUPH3 field.
	PWM_OSSUPD_OSSUPH3_Msk = 0x8
	// Bit OSSUPH3.
	PWM_OSSUPD_OSSUPH3 = 0x8
	// Position of OSSUPL0 field.
	PWM_OSSUPD_OSSUPL0_Pos = 0x10
	// Bit mask of OSSUPL0 field.
	PWM_OSSUPD_OSSUPL0_Msk = 0x10000
	// Bit OSSUPL0.
	PWM_OSSUPD_OSSUPL0 = 0x10000
	// Position of OSSUPL1 field.
	PWM_OSSUPD_OSSUPL1_Pos = 0x11
	// Bit mask of OSSUPL1 field.
	PWM_OSSUPD_OSSUPL1_Msk = 0x20000
	// Bit OSSUPL1.
	PWM_OSSUPD_OSSUPL1 = 0x20000
	// Position of OSSUPL2 field.
	PWM_OSSUPD_OSSUPL2_Pos = 0x12
	// Bit mask of OSSUPL2 field.
	PWM_OSSUPD_OSSUPL2_Msk = 0x40000
	// Bit OSSUPL2.
	PWM_OSSUPD_OSSUPL2 = 0x40000
	// Position of OSSUPL3 field.
	PWM_OSSUPD_OSSUPL3_Pos = 0x13
	// Bit mask of OSSUPL3 field.
	PWM_OSSUPD_OSSUPL3_Msk = 0x80000
	// Bit OSSUPL3.
	PWM_OSSUPD_OSSUPL3 = 0x80000

	// OSCUPD: PWM Output Selection Clear Update Register
	// Position of OSCUPH0 field.
	PWM_OSCUPD_OSCUPH0_Pos = 0x0
	// Bit mask of OSCUPH0 field.
	PWM_OSCUPD_OSCUPH0_Msk = 0x1
	// Bit OSCUPH0.
	PWM_OSCUPD_OSCUPH0 = 0x1
	// Position of OSCUPH1 field.
	PWM_OSCUPD_OSCUPH1_Pos = 0x1
	// Bit mask of OSCUPH1 field.
	PWM_OSCUPD_OSCUPH1_Msk = 0x2
	// Bit OSCUPH1.
	PWM_OSCUPD_OSCUPH1 = 0x2
	// Position of OSCUPH2 field.
	PWM_OSCUPD_OSCUPH2_Pos = 0x2
	// Bit mask of OSCUPH2 field.
	PWM_OSCUPD_OSCUPH2_Msk = 0x4
	// Bit OSCUPH2.
	PWM_OSCUPD_OSCUPH2 = 0x4
	// Position of OSCUPH3 field.
	PWM_OSCUPD_OSCUPH3_Pos = 0x3
	// Bit mask of OSCUPH3 field.
	PWM_OSCUPD_OSCUPH3_Msk = 0x8
	// Bit OSCUPH3.
	PWM_OSCUPD_OSCUPH3 = 0x8
	// Position of OSCUPL0 field.
	PWM_OSCUPD_OSCUPL0_Pos = 0x10
	// Bit mask of OSCUPL0 field.
	PWM_OSCUPD_OSCUPL0_Msk = 0x10000
	// Bit OSCUPL0.
	PWM_OSCUPD_OSCUPL0 = 0x10000
	// Position of OSCUPL1 field.
	PWM_OSCUPD_OSCUPL1_Pos = 0x11
	// Bit mask of OSCUPL1 field.
	PWM_OSCUPD_OSCUPL1_Msk = 0x20000
	// Bit OSCUPL1.
	PWM_OSCUPD_OSCUPL1 = 0x20000
	// Position of OSCUPL2 field.
	PWM_OSCUPD_OSCUPL2_Pos = 0x12
	// Bit mask of OSCUPL2 field.
	PWM_OSCUPD_OSCUPL2_Msk = 0x40000
	// Bit OSCUPL2.
	PWM_OSCUPD_OSCUPL2 = 0x40000
	// Position of OSCUPL3 field.
	PWM_OSCUPD_OSCUPL3_Pos = 0x13
	// Bit mask of OSCUPL3 field.
	PWM_OSCUPD_OSCUPL3_Msk = 0x80000
	// Bit OSCUPL3.
	PWM_OSCUPD_OSCUPL3 = 0x80000

	// FMR: PWM Fault Mode Register
	// Position of FPOL field.
	PWM_FMR_FPOL_Pos = 0x0
	// Bit mask of FPOL field.
	PWM_FMR_FPOL_Msk = 0xff
	// Position of FMOD field.
	PWM_FMR_FMOD_Pos = 0x8
	// Bit mask of FMOD field.
	PWM_FMR_FMOD_Msk = 0xff00
	// Position of FFIL field.
	PWM_FMR_FFIL_Pos = 0x10
	// Bit mask of FFIL field.
	PWM_FMR_FFIL_Msk = 0xff0000

	// FSR: PWM Fault Status Register
	// Position of FIV field.
	PWM_FSR_FIV_Pos = 0x0
	// Bit mask of FIV field.
	PWM_FSR_FIV_Msk = 0xff
	// Position of FS field.
	PWM_FSR_FS_Pos = 0x8
	// Bit mask of FS field.
	PWM_FSR_FS_Msk = 0xff00

	// FCR: PWM Fault Clear Register
	// Position of FCLR field.
	PWM_FCR_FCLR_Pos = 0x0
	// Bit mask of FCLR field.
	PWM_FCR_FCLR_Msk = 0xff

	// FPV: PWM Fault Protection Value Register
	// Position of FPVH0 field.
	PWM_FPV_FPVH0_Pos = 0x0
	// Bit mask of FPVH0 field.
	PWM_FPV_FPVH0_Msk = 0x1
	// Bit FPVH0.
	PWM_FPV_FPVH0 = 0x1
	// Position of FPVH1 field.
	PWM_FPV_FPVH1_Pos = 0x1
	// Bit mask of FPVH1 field.
	PWM_FPV_FPVH1_Msk = 0x2
	// Bit FPVH1.
	PWM_FPV_FPVH1 = 0x2
	// Position of FPVH2 field.
	PWM_FPV_FPVH2_Pos = 0x2
	// Bit mask of FPVH2 field.
	PWM_FPV_FPVH2_Msk = 0x4
	// Bit FPVH2.
	PWM_FPV_FPVH2 = 0x4
	// Position of FPVH3 field.
	PWM_FPV_FPVH3_Pos = 0x3
	// Bit mask of FPVH3 field.
	PWM_FPV_FPVH3_Msk = 0x8
	// Bit FPVH3.
	PWM_FPV_FPVH3 = 0x8
	// Position of FPVL0 field.
	PWM_FPV_FPVL0_Pos = 0x10
	// Bit mask of FPVL0 field.
	PWM_FPV_FPVL0_Msk = 0x10000
	// Bit FPVL0.
	PWM_FPV_FPVL0 = 0x10000
	// Position of FPVL1 field.
	PWM_FPV_FPVL1_Pos = 0x11
	// Bit mask of FPVL1 field.
	PWM_FPV_FPVL1_Msk = 0x20000
	// Bit FPVL1.
	PWM_FPV_FPVL1 = 0x20000
	// Position of FPVL2 field.
	PWM_FPV_FPVL2_Pos = 0x12
	// Bit mask of FPVL2 field.
	PWM_FPV_FPVL2_Msk = 0x40000
	// Bit FPVL2.
	PWM_FPV_FPVL2 = 0x40000
	// Position of FPVL3 field.
	PWM_FPV_FPVL3_Pos = 0x13
	// Bit mask of FPVL3 field.
	PWM_FPV_FPVL3_Msk = 0x80000
	// Bit FPVL3.
	PWM_FPV_FPVL3 = 0x80000

	// FPE: PWM Fault Protection Enable Register
	// Position of FPE0 field.
	PWM_FPE_FPE0_Pos = 0x0
	// Bit mask of FPE0 field.
	PWM_FPE_FPE0_Msk = 0xff
	// Position of FPE1 field.
	PWM_FPE_FPE1_Pos = 0x8
	// Bit mask of FPE1 field.
	PWM_FPE_FPE1_Msk = 0xff00
	// Position of FPE2 field.
	PWM_FPE_FPE2_Pos = 0x10
	// Bit mask of FPE2 field.
	PWM_FPE_FPE2_Msk = 0xff0000
	// Position of FPE3 field.
	PWM_FPE_FPE3_Pos = 0x18
	// Bit mask of FPE3 field.
	PWM_FPE_FPE3_Msk = 0xff000000

	// ELMR: PWM Event Line 0 Mode Register
	// Position of CSEL0 field.
	PWM_ELMR_CSEL0_Pos = 0x0
	// Bit mask of CSEL0 field.
	PWM_ELMR_CSEL0_Msk = 0x1
	// Bit CSEL0.
	PWM_ELMR_CSEL0 = 0x1
	// Position of CSEL1 field.
	PWM_ELMR_CSEL1_Pos = 0x1
	// Bit mask of CSEL1 field.
	PWM_ELMR_CSEL1_Msk = 0x2
	// Bit CSEL1.
	PWM_ELMR_CSEL1 = 0x2
	// Position of CSEL2 field.
	PWM_ELMR_CSEL2_Pos = 0x2
	// Bit mask of CSEL2 field.
	PWM_ELMR_CSEL2_Msk = 0x4
	// Bit CSEL2.
	PWM_ELMR_CSEL2 = 0x4
	// Position of CSEL3 field.
	PWM_ELMR_CSEL3_Pos = 0x3
	// Bit mask of CSEL3 field.
	PWM_ELMR_CSEL3_Msk = 0x8
	// Bit CSEL3.
	PWM_ELMR_CSEL3 = 0x8
	// Position of CSEL4 field.
	PWM_ELMR_CSEL4_Pos = 0x4
	// Bit mask of CSEL4 field.
	PWM_ELMR_CSEL4_Msk = 0x10
	// Bit CSEL4.
	PWM_ELMR_CSEL4 = 0x10
	// Position of CSEL5 field.
	PWM_ELMR_CSEL5_Pos = 0x5
	// Bit mask of CSEL5 field.
	PWM_ELMR_CSEL5_Msk = 0x20
	// Bit CSEL5.
	PWM_ELMR_CSEL5 = 0x20
	// Position of CSEL6 field.
	PWM_ELMR_CSEL6_Pos = 0x6
	// Bit mask of CSEL6 field.
	PWM_ELMR_CSEL6_Msk = 0x40
	// Bit CSEL6.
	PWM_ELMR_CSEL6 = 0x40
	// Position of CSEL7 field.
	PWM_ELMR_CSEL7_Pos = 0x7
	// Bit mask of CSEL7 field.
	PWM_ELMR_CSEL7_Msk = 0x80
	// Bit CSEL7.
	PWM_ELMR_CSEL7 = 0x80

	// SMMR: PWM Stepper Motor Mode Register
	// Position of GCEN0 field.
	PWM_SMMR_GCEN0_Pos = 0x0
	// Bit mask of GCEN0 field.
	PWM_SMMR_GCEN0_Msk = 0x1
	// Bit GCEN0.
	PWM_SMMR_GCEN0 = 0x1
	// Position of GCEN1 field.
	PWM_SMMR_GCEN1_Pos = 0x1
	// Bit mask of GCEN1 field.
	PWM_SMMR_GCEN1_Msk = 0x2
	// Bit GCEN1.
	PWM_SMMR_GCEN1 = 0x2
	// Position of DOWN0 field.
	PWM_SMMR_DOWN0_Pos = 0x10
	// Bit mask of DOWN0 field.
	PWM_SMMR_DOWN0_Msk = 0x10000
	// Bit DOWN0.
	PWM_SMMR_DOWN0 = 0x10000
	// Position of DOWN1 field.
	PWM_SMMR_DOWN1_Pos = 0x11
	// Bit mask of DOWN1 field.
	PWM_SMMR_DOWN1_Msk = 0x20000
	// Bit DOWN1.
	PWM_SMMR_DOWN1 = 0x20000

	// WPCR: PWM Write Protect Control Register
	// Position of WPCMD field.
	PWM_WPCR_WPCMD_Pos = 0x0
	// Bit mask of WPCMD field.
	PWM_WPCR_WPCMD_Msk = 0x3
	// Position of WPRG0 field.
	PWM_WPCR_WPRG0_Pos = 0x2
	// Bit mask of WPRG0 field.
	PWM_WPCR_WPRG0_Msk = 0x4
	// Bit WPRG0.
	PWM_WPCR_WPRG0 = 0x4
	// Position of WPRG1 field.
	PWM_WPCR_WPRG1_Pos = 0x3
	// Bit mask of WPRG1 field.
	PWM_WPCR_WPRG1_Msk = 0x8
	// Bit WPRG1.
	PWM_WPCR_WPRG1 = 0x8
	// Position of WPRG2 field.
	PWM_WPCR_WPRG2_Pos = 0x4
	// Bit mask of WPRG2 field.
	PWM_WPCR_WPRG2_Msk = 0x10
	// Bit WPRG2.
	PWM_WPCR_WPRG2 = 0x10
	// Position of WPRG3 field.
	PWM_WPCR_WPRG3_Pos = 0x5
	// Bit mask of WPRG3 field.
	PWM_WPCR_WPRG3_Msk = 0x20
	// Bit WPRG3.
	PWM_WPCR_WPRG3 = 0x20
	// Position of WPRG4 field.
	PWM_WPCR_WPRG4_Pos = 0x6
	// Bit mask of WPRG4 field.
	PWM_WPCR_WPRG4_Msk = 0x40
	// Bit WPRG4.
	PWM_WPCR_WPRG4 = 0x40
	// Position of WPRG5 field.
	PWM_WPCR_WPRG5_Pos = 0x7
	// Bit mask of WPRG5 field.
	PWM_WPCR_WPRG5_Msk = 0x80
	// Bit WPRG5.
	PWM_WPCR_WPRG5 = 0x80
	// Position of WPKEY field.
	PWM_WPCR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PWM_WPCR_WPKEY_Msk = 0xffffff00

	// WPSR: PWM Write Protect Status Register
	// Position of WPSWS0 field.
	PWM_WPSR_WPSWS0_Pos = 0x0
	// Bit mask of WPSWS0 field.
	PWM_WPSR_WPSWS0_Msk = 0x1
	// Bit WPSWS0.
	PWM_WPSR_WPSWS0 = 0x1
	// Position of WPSWS1 field.
	PWM_WPSR_WPSWS1_Pos = 0x1
	// Bit mask of WPSWS1 field.
	PWM_WPSR_WPSWS1_Msk = 0x2
	// Bit WPSWS1.
	PWM_WPSR_WPSWS1 = 0x2
	// Position of WPSWS2 field.
	PWM_WPSR_WPSWS2_Pos = 0x2
	// Bit mask of WPSWS2 field.
	PWM_WPSR_WPSWS2_Msk = 0x4
	// Bit WPSWS2.
	PWM_WPSR_WPSWS2 = 0x4
	// Position of WPSWS3 field.
	PWM_WPSR_WPSWS3_Pos = 0x3
	// Bit mask of WPSWS3 field.
	PWM_WPSR_WPSWS3_Msk = 0x8
	// Bit WPSWS3.
	PWM_WPSR_WPSWS3 = 0x8
	// Position of WPSWS4 field.
	PWM_WPSR_WPSWS4_Pos = 0x4
	// Bit mask of WPSWS4 field.
	PWM_WPSR_WPSWS4_Msk = 0x10
	// Bit WPSWS4.
	PWM_WPSR_WPSWS4 = 0x10
	// Position of WPSWS5 field.
	PWM_WPSR_WPSWS5_Pos = 0x5
	// Bit mask of WPSWS5 field.
	PWM_WPSR_WPSWS5_Msk = 0x20
	// Bit WPSWS5.
	PWM_WPSR_WPSWS5 = 0x20
	// Position of WPVS field.
	PWM_WPSR_WPVS_Pos = 0x7
	// Bit mask of WPVS field.
	PWM_WPSR_WPVS_Msk = 0x80
	// Bit WPVS.
	PWM_WPSR_WPVS = 0x80
	// Position of WPHWS0 field.
	PWM_WPSR_WPHWS0_Pos = 0x8
	// Bit mask of WPHWS0 field.
	PWM_WPSR_WPHWS0_Msk = 0x100
	// Bit WPHWS0.
	PWM_WPSR_WPHWS0 = 0x100
	// Position of WPHWS1 field.
	PWM_WPSR_WPHWS1_Pos = 0x9
	// Bit mask of WPHWS1 field.
	PWM_WPSR_WPHWS1_Msk = 0x200
	// Bit WPHWS1.
	PWM_WPSR_WPHWS1 = 0x200
	// Position of WPHWS2 field.
	PWM_WPSR_WPHWS2_Pos = 0xa
	// Bit mask of WPHWS2 field.
	PWM_WPSR_WPHWS2_Msk = 0x400
	// Bit WPHWS2.
	PWM_WPSR_WPHWS2 = 0x400
	// Position of WPHWS3 field.
	PWM_WPSR_WPHWS3_Pos = 0xb
	// Bit mask of WPHWS3 field.
	PWM_WPSR_WPHWS3_Msk = 0x800
	// Bit WPHWS3.
	PWM_WPSR_WPHWS3 = 0x800
	// Position of WPHWS4 field.
	PWM_WPSR_WPHWS4_Pos = 0xc
	// Bit mask of WPHWS4 field.
	PWM_WPSR_WPHWS4_Msk = 0x1000
	// Bit WPHWS4.
	PWM_WPSR_WPHWS4 = 0x1000
	// Position of WPHWS5 field.
	PWM_WPSR_WPHWS5_Pos = 0xd
	// Bit mask of WPHWS5 field.
	PWM_WPSR_WPHWS5_Msk = 0x2000
	// Bit WPHWS5.
	PWM_WPSR_WPHWS5 = 0x2000
	// Position of WPVSRC field.
	PWM_WPSR_WPVSRC_Pos = 0x10
	// Bit mask of WPVSRC field.
	PWM_WPSR_WPVSRC_Msk = 0xffff0000

	// CMPV0: PWM Comparison 0 Value Register
	// Position of CV field.
	PWM_CMPV0_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV0_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV0_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV0_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV0_CVM = 0x1000000

	// CMPVUPD0: PWM Comparison 0 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD0_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD0_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD0_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD0_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD0_CVMUPD = 0x1000000

	// CMPM0: PWM Comparison 0 Mode Register
	// Position of CEN field.
	PWM_CMPM0_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM0_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM0_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM0_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM0_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM0_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM0_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM0_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM0_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM0_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM0_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM0_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM0_CUPRCNT_Msk = 0xf00000

	// CMPMUPD0: PWM Comparison 0 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD0_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD0_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD0_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD0_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD0_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD0_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD0_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD0_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD0_CUPRUPD_Msk = 0xf0000

	// CMPV1: PWM Comparison 1 Value Register
	// Position of CV field.
	PWM_CMPV1_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV1_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV1_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV1_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV1_CVM = 0x1000000

	// CMPVUPD1: PWM Comparison 1 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD1_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD1_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD1_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD1_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD1_CVMUPD = 0x1000000

	// CMPM1: PWM Comparison 1 Mode Register
	// Position of CEN field.
	PWM_CMPM1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM1_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM1_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM1_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM1_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM1_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM1_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM1_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM1_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM1_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM1_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM1_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM1_CUPRCNT_Msk = 0xf00000

	// CMPMUPD1: PWM Comparison 1 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD1_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD1_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD1_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD1_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD1_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD1_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD1_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD1_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD1_CUPRUPD_Msk = 0xf0000

	// CMPV2: PWM Comparison 2 Value Register
	// Position of CV field.
	PWM_CMPV2_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV2_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV2_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV2_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV2_CVM = 0x1000000

	// CMPVUPD2: PWM Comparison 2 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD2_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD2_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD2_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD2_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD2_CVMUPD = 0x1000000

	// CMPM2: PWM Comparison 2 Mode Register
	// Position of CEN field.
	PWM_CMPM2_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM2_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM2_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM2_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM2_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM2_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM2_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM2_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM2_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM2_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM2_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM2_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM2_CUPRCNT_Msk = 0xf00000

	// CMPMUPD2: PWM Comparison 2 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD2_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD2_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD2_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD2_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD2_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD2_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD2_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD2_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD2_CUPRUPD_Msk = 0xf0000

	// CMPV3: PWM Comparison 3 Value Register
	// Position of CV field.
	PWM_CMPV3_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV3_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV3_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV3_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV3_CVM = 0x1000000

	// CMPVUPD3: PWM Comparison 3 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD3_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD3_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD3_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD3_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD3_CVMUPD = 0x1000000

	// CMPM3: PWM Comparison 3 Mode Register
	// Position of CEN field.
	PWM_CMPM3_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM3_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM3_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM3_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM3_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM3_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM3_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM3_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM3_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM3_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM3_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM3_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM3_CUPRCNT_Msk = 0xf00000

	// CMPMUPD3: PWM Comparison 3 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD3_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD3_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD3_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD3_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD3_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD3_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD3_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD3_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD3_CUPRUPD_Msk = 0xf0000

	// CMPV4: PWM Comparison 4 Value Register
	// Position of CV field.
	PWM_CMPV4_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV4_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV4_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV4_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV4_CVM = 0x1000000

	// CMPVUPD4: PWM Comparison 4 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD4_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD4_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD4_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD4_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD4_CVMUPD = 0x1000000

	// CMPM4: PWM Comparison 4 Mode Register
	// Position of CEN field.
	PWM_CMPM4_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM4_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM4_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM4_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM4_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM4_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM4_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM4_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM4_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM4_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM4_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM4_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM4_CUPRCNT_Msk = 0xf00000

	// CMPMUPD4: PWM Comparison 4 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD4_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD4_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD4_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD4_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD4_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD4_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD4_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD4_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD4_CUPRUPD_Msk = 0xf0000

	// CMPV5: PWM Comparison 5 Value Register
	// Position of CV field.
	PWM_CMPV5_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV5_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV5_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV5_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV5_CVM = 0x1000000

	// CMPVUPD5: PWM Comparison 5 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD5_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD5_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD5_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD5_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD5_CVMUPD = 0x1000000

	// CMPM5: PWM Comparison 5 Mode Register
	// Position of CEN field.
	PWM_CMPM5_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM5_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM5_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM5_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM5_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM5_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM5_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM5_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM5_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM5_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM5_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM5_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM5_CUPRCNT_Msk = 0xf00000

	// CMPMUPD5: PWM Comparison 5 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD5_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD5_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD5_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD5_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD5_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD5_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD5_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD5_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD5_CUPRUPD_Msk = 0xf0000

	// CMPV6: PWM Comparison 6 Value Register
	// Position of CV field.
	PWM_CMPV6_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV6_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV6_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV6_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV6_CVM = 0x1000000

	// CMPVUPD6: PWM Comparison 6 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD6_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD6_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD6_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD6_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD6_CVMUPD = 0x1000000

	// CMPM6: PWM Comparison 6 Mode Register
	// Position of CEN field.
	PWM_CMPM6_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM6_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM6_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM6_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM6_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM6_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM6_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM6_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM6_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM6_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM6_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM6_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM6_CUPRCNT_Msk = 0xf00000

	// CMPMUPD6: PWM Comparison 6 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD6_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD6_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD6_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD6_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD6_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD6_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD6_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD6_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD6_CUPRUPD_Msk = 0xf0000

	// CMPV7: PWM Comparison 7 Value Register
	// Position of CV field.
	PWM_CMPV7_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV7_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV7_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV7_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV7_CVM = 0x1000000

	// CMPVUPD7: PWM Comparison 7 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD7_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD7_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD7_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD7_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD7_CVMUPD = 0x1000000

	// CMPM7: PWM Comparison 7 Mode Register
	// Position of CEN field.
	PWM_CMPM7_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM7_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM7_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM7_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM7_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM7_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM7_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM7_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM7_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM7_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM7_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM7_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM7_CUPRCNT_Msk = 0xf00000

	// CMPMUPD7: PWM Comparison 7 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD7_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD7_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD7_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD7_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD7_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD7_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD7_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD7_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD7_CUPRUPD_Msk = 0xf0000

	// CMR0: PWM Channel Mode Register (ch_num = 0)
	// Position of CPRE field.
	PWM_CMR0_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR0_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR0_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR0_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR0_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR0_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR0_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR0_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR0_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR0_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR0_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR0_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR0_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR0_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR0_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR0_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR0_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR0_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR0_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR0_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR0_CPOL = 0x200
	// Position of CES field.
	PWM_CMR0_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR0_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR0_CES = 0x400
	// Position of DTE field.
	PWM_CMR0_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR0_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR0_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR0_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR0_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR0_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR0_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR0_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR0_DTLI = 0x40000

	// CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
	// Position of CDTY field.
	PWM_CDTY0_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY0_CDTY_Msk = 0xffffff

	// CDTYUPD0: PWM Channel Duty Cycle Update Register (ch_num = 0)
	// Position of CDTYUPD field.
	PWM_CDTYUPD0_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD0_CDTYUPD_Msk = 0xffffff

	// CPRD0: PWM Channel Period Register (ch_num = 0)
	// Position of CPRD field.
	PWM_CPRD0_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD0_CPRD_Msk = 0xffffff

	// CPRDUPD0: PWM Channel Period Update Register (ch_num = 0)
	// Position of CPRDUPD field.
	PWM_CPRDUPD0_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD0_CPRDUPD_Msk = 0xffffff

	// CCNT0: PWM Channel Counter Register (ch_num = 0)
	// Position of CNT field.
	PWM_CCNT0_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT0_CNT_Msk = 0xffffff

	// DT0: PWM Channel Dead Time Register (ch_num = 0)
	// Position of DTH field.
	PWM_DT0_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT0_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT0_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT0_DTL_Msk = 0xffff0000

	// DTUPD0: PWM Channel Dead Time Update Register (ch_num = 0)
	// Position of DTHUPD field.
	PWM_DTUPD0_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD0_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD0_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD0_DTLUPD_Msk = 0xffff0000

	// CMR1: PWM Channel Mode Register (ch_num = 1)
	// Position of CPRE field.
	PWM_CMR1_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR1_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR1_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR1_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR1_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR1_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR1_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR1_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR1_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR1_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR1_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR1_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR1_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR1_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR1_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR1_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR1_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR1_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR1_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR1_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR1_CPOL = 0x200
	// Position of CES field.
	PWM_CMR1_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR1_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR1_CES = 0x400
	// Position of DTE field.
	PWM_CMR1_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR1_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR1_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR1_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR1_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR1_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR1_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR1_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR1_DTLI = 0x40000

	// CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
	// Position of CDTY field.
	PWM_CDTY1_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY1_CDTY_Msk = 0xffffff

	// CDTYUPD1: PWM Channel Duty Cycle Update Register (ch_num = 1)
	// Position of CDTYUPD field.
	PWM_CDTYUPD1_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD1_CDTYUPD_Msk = 0xffffff

	// CPRD1: PWM Channel Period Register (ch_num = 1)
	// Position of CPRD field.
	PWM_CPRD1_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD1_CPRD_Msk = 0xffffff

	// CPRDUPD1: PWM Channel Period Update Register (ch_num = 1)
	// Position of CPRDUPD field.
	PWM_CPRDUPD1_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD1_CPRDUPD_Msk = 0xffffff

	// CCNT1: PWM Channel Counter Register (ch_num = 1)
	// Position of CNT field.
	PWM_CCNT1_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT1_CNT_Msk = 0xffffff

	// DT1: PWM Channel Dead Time Register (ch_num = 1)
	// Position of DTH field.
	PWM_DT1_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT1_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT1_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT1_DTL_Msk = 0xffff0000

	// DTUPD1: PWM Channel Dead Time Update Register (ch_num = 1)
	// Position of DTHUPD field.
	PWM_DTUPD1_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD1_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD1_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD1_DTLUPD_Msk = 0xffff0000

	// CMR2: PWM Channel Mode Register (ch_num = 2)
	// Position of CPRE field.
	PWM_CMR2_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR2_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR2_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR2_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR2_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR2_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR2_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR2_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR2_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR2_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR2_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR2_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR2_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR2_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR2_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR2_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR2_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR2_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR2_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR2_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR2_CPOL = 0x200
	// Position of CES field.
	PWM_CMR2_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR2_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR2_CES = 0x400
	// Position of DTE field.
	PWM_CMR2_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR2_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR2_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR2_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR2_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR2_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR2_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR2_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR2_DTLI = 0x40000

	// CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
	// Position of CDTY field.
	PWM_CDTY2_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY2_CDTY_Msk = 0xffffff

	// CDTYUPD2: PWM Channel Duty Cycle Update Register (ch_num = 2)
	// Position of CDTYUPD field.
	PWM_CDTYUPD2_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD2_CDTYUPD_Msk = 0xffffff

	// CPRD2: PWM Channel Period Register (ch_num = 2)
	// Position of CPRD field.
	PWM_CPRD2_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD2_CPRD_Msk = 0xffffff

	// CPRDUPD2: PWM Channel Period Update Register (ch_num = 2)
	// Position of CPRDUPD field.
	PWM_CPRDUPD2_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD2_CPRDUPD_Msk = 0xffffff

	// CCNT2: PWM Channel Counter Register (ch_num = 2)
	// Position of CNT field.
	PWM_CCNT2_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT2_CNT_Msk = 0xffffff

	// DT2: PWM Channel Dead Time Register (ch_num = 2)
	// Position of DTH field.
	PWM_DT2_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT2_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT2_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT2_DTL_Msk = 0xffff0000

	// DTUPD2: PWM Channel Dead Time Update Register (ch_num = 2)
	// Position of DTHUPD field.
	PWM_DTUPD2_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD2_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD2_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD2_DTLUPD_Msk = 0xffff0000

	// CMR3: PWM Channel Mode Register (ch_num = 3)
	// Position of CPRE field.
	PWM_CMR3_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR3_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR3_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR3_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR3_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR3_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR3_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR3_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR3_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR3_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR3_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR3_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR3_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR3_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR3_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR3_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR3_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR3_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR3_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR3_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR3_CPOL = 0x200
	// Position of CES field.
	PWM_CMR3_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR3_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR3_CES = 0x400
	// Position of DTE field.
	PWM_CMR3_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR3_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR3_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR3_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR3_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR3_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR3_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR3_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR3_DTLI = 0x40000

	// CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
	// Position of CDTY field.
	PWM_CDTY3_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY3_CDTY_Msk = 0xffffff

	// CDTYUPD3: PWM Channel Duty Cycle Update Register (ch_num = 3)
	// Position of CDTYUPD field.
	PWM_CDTYUPD3_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD3_CDTYUPD_Msk = 0xffffff

	// CPRD3: PWM Channel Period Register (ch_num = 3)
	// Position of CPRD field.
	PWM_CPRD3_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD3_CPRD_Msk = 0xffffff

	// CPRDUPD3: PWM Channel Period Update Register (ch_num = 3)
	// Position of CPRDUPD field.
	PWM_CPRDUPD3_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD3_CPRDUPD_Msk = 0xffffff

	// CCNT3: PWM Channel Counter Register (ch_num = 3)
	// Position of CNT field.
	PWM_CCNT3_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT3_CNT_Msk = 0xffffff

	// DT3: PWM Channel Dead Time Register (ch_num = 3)
	// Position of DTH field.
	PWM_DT3_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT3_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT3_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT3_DTL_Msk = 0xffff0000

	// DTUPD3: PWM Channel Dead Time Update Register (ch_num = 3)
	// Position of DTHUPD field.
	PWM_DTUPD3_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD3_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD3_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD3_DTLUPD_Msk = 0xffff0000
)

// Bitfields for LCDC: LCD Controller
const (
	// LCDCFG0: LCD Controller Configuration Register 0
	// Position of CLKPOL field.
	LCDC_LCDCFG0_CLKPOL_Pos = 0x0
	// Bit mask of CLKPOL field.
	LCDC_LCDCFG0_CLKPOL_Msk = 0x1
	// Bit CLKPOL.
	LCDC_LCDCFG0_CLKPOL = 0x1
	// Position of CLKSEL field.
	LCDC_LCDCFG0_CLKSEL_Pos = 0x2
	// Bit mask of CLKSEL field.
	LCDC_LCDCFG0_CLKSEL_Msk = 0x4
	// Bit CLKSEL.
	LCDC_LCDCFG0_CLKSEL = 0x4
	// Position of CLKPWMSEL field.
	LCDC_LCDCFG0_CLKPWMSEL_Pos = 0x3
	// Bit mask of CLKPWMSEL field.
	LCDC_LCDCFG0_CLKPWMSEL_Msk = 0x8
	// Bit CLKPWMSEL.
	LCDC_LCDCFG0_CLKPWMSEL = 0x8
	// Position of CGDISBASE field.
	LCDC_LCDCFG0_CGDISBASE_Pos = 0x8
	// Bit mask of CGDISBASE field.
	LCDC_LCDCFG0_CGDISBASE_Msk = 0x100
	// Bit CGDISBASE.
	LCDC_LCDCFG0_CGDISBASE = 0x100
	// Position of CGDISOVR1 field.
	LCDC_LCDCFG0_CGDISOVR1_Pos = 0x9
	// Bit mask of CGDISOVR1 field.
	LCDC_LCDCFG0_CGDISOVR1_Msk = 0x200
	// Bit CGDISOVR1.
	LCDC_LCDCFG0_CGDISOVR1 = 0x200
	// Position of CGDISOVR2 field.
	LCDC_LCDCFG0_CGDISOVR2_Pos = 0xa
	// Bit mask of CGDISOVR2 field.
	LCDC_LCDCFG0_CGDISOVR2_Msk = 0x400
	// Bit CGDISOVR2.
	LCDC_LCDCFG0_CGDISOVR2 = 0x400
	// Position of CGDISHEO field.
	LCDC_LCDCFG0_CGDISHEO_Pos = 0xb
	// Bit mask of CGDISHEO field.
	LCDC_LCDCFG0_CGDISHEO_Msk = 0x800
	// Bit CGDISHEO.
	LCDC_LCDCFG0_CGDISHEO = 0x800
	// Position of CGDISHCR field.
	LCDC_LCDCFG0_CGDISHCR_Pos = 0xc
	// Bit mask of CGDISHCR field.
	LCDC_LCDCFG0_CGDISHCR_Msk = 0x1000
	// Bit CGDISHCR.
	LCDC_LCDCFG0_CGDISHCR = 0x1000
	// Position of CGDISPP field.
	LCDC_LCDCFG0_CGDISPP_Pos = 0xd
	// Bit mask of CGDISPP field.
	LCDC_LCDCFG0_CGDISPP_Msk = 0x2000
	// Bit CGDISPP.
	LCDC_LCDCFG0_CGDISPP = 0x2000
	// Position of CLKDIV field.
	LCDC_LCDCFG0_CLKDIV_Pos = 0x10
	// Bit mask of CLKDIV field.
	LCDC_LCDCFG0_CLKDIV_Msk = 0xff0000

	// LCDCFG1: LCD Controller Configuration Register 1
	// Position of HSPW field.
	LCDC_LCDCFG1_HSPW_Pos = 0x0
	// Bit mask of HSPW field.
	LCDC_LCDCFG1_HSPW_Msk = 0x3f
	// Position of VSPW field.
	LCDC_LCDCFG1_VSPW_Pos = 0x10
	// Bit mask of VSPW field.
	LCDC_LCDCFG1_VSPW_Msk = 0x3f0000

	// LCDCFG2: LCD Controller Configuration Register 2
	// Position of VFPW field.
	LCDC_LCDCFG2_VFPW_Pos = 0x0
	// Bit mask of VFPW field.
	LCDC_LCDCFG2_VFPW_Msk = 0x3f
	// Position of VBPW field.
	LCDC_LCDCFG2_VBPW_Pos = 0x10
	// Bit mask of VBPW field.
	LCDC_LCDCFG2_VBPW_Msk = 0x3f0000

	// LCDCFG3: LCD Controller Configuration Register 3
	// Position of HFPW field.
	LCDC_LCDCFG3_HFPW_Pos = 0x0
	// Bit mask of HFPW field.
	LCDC_LCDCFG3_HFPW_Msk = 0x1ff
	// Position of HBPW field.
	LCDC_LCDCFG3_HBPW_Pos = 0x10
	// Bit mask of HBPW field.
	LCDC_LCDCFG3_HBPW_Msk = 0x1ff0000

	// LCDCFG4: LCD Controller Configuration Register 4
	// Position of PPL field.
	LCDC_LCDCFG4_PPL_Pos = 0x0
	// Bit mask of PPL field.
	LCDC_LCDCFG4_PPL_Msk = 0x7ff
	// Position of RPF field.
	LCDC_LCDCFG4_RPF_Pos = 0x10
	// Bit mask of RPF field.
	LCDC_LCDCFG4_RPF_Msk = 0x7ff0000

	// LCDCFG5: LCD Controller Configuration Register 5
	// Position of HSPOL field.
	LCDC_LCDCFG5_HSPOL_Pos = 0x0
	// Bit mask of HSPOL field.
	LCDC_LCDCFG5_HSPOL_Msk = 0x1
	// Bit HSPOL.
	LCDC_LCDCFG5_HSPOL = 0x1
	// Position of VSPOL field.
	LCDC_LCDCFG5_VSPOL_Pos = 0x1
	// Bit mask of VSPOL field.
	LCDC_LCDCFG5_VSPOL_Msk = 0x2
	// Bit VSPOL.
	LCDC_LCDCFG5_VSPOL = 0x2
	// Position of VSPDLYS field.
	LCDC_LCDCFG5_VSPDLYS_Pos = 0x2
	// Bit mask of VSPDLYS field.
	LCDC_LCDCFG5_VSPDLYS_Msk = 0x4
	// Bit VSPDLYS.
	LCDC_LCDCFG5_VSPDLYS = 0x4
	// Position of VSPDLYE field.
	LCDC_LCDCFG5_VSPDLYE_Pos = 0x3
	// Bit mask of VSPDLYE field.
	LCDC_LCDCFG5_VSPDLYE_Msk = 0x8
	// Bit VSPDLYE.
	LCDC_LCDCFG5_VSPDLYE = 0x8
	// Position of DISPPOL field.
	LCDC_LCDCFG5_DISPPOL_Pos = 0x4
	// Bit mask of DISPPOL field.
	LCDC_LCDCFG5_DISPPOL_Msk = 0x10
	// Bit DISPPOL.
	LCDC_LCDCFG5_DISPPOL = 0x10
	// Position of DITHER field.
	LCDC_LCDCFG5_DITHER_Pos = 0x6
	// Bit mask of DITHER field.
	LCDC_LCDCFG5_DITHER_Msk = 0x40
	// Bit DITHER.
	LCDC_LCDCFG5_DITHER = 0x40
	// Position of DISPDLY field.
	LCDC_LCDCFG5_DISPDLY_Pos = 0x7
	// Bit mask of DISPDLY field.
	LCDC_LCDCFG5_DISPDLY_Msk = 0x80
	// Bit DISPDLY.
	LCDC_LCDCFG5_DISPDLY = 0x80
	// Position of MODE field.
	LCDC_LCDCFG5_MODE_Pos = 0x8
	// Bit mask of MODE field.
	LCDC_LCDCFG5_MODE_Msk = 0x300
	// LCD output mode is set to 12 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_12BPP = 0x0
	// LCD output mode is set to 16 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_16BPP = 0x1
	// LCD output mode is set to 18 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_18BPP = 0x2
	// LCD output mode is set to 24 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_24BPP = 0x3
	// Position of PP field.
	LCDC_LCDCFG5_PP_Pos = 0xa
	// Bit mask of PP field.
	LCDC_LCDCFG5_PP_Msk = 0x400
	// Bit PP.
	LCDC_LCDCFG5_PP = 0x400
	// Position of VSPSU field.
	LCDC_LCDCFG5_VSPSU_Pos = 0xc
	// Bit mask of VSPSU field.
	LCDC_LCDCFG5_VSPSU_Msk = 0x1000
	// Bit VSPSU.
	LCDC_LCDCFG5_VSPSU = 0x1000
	// Position of VSPHO field.
	LCDC_LCDCFG5_VSPHO_Pos = 0xd
	// Bit mask of VSPHO field.
	LCDC_LCDCFG5_VSPHO_Msk = 0x2000
	// Bit VSPHO.
	LCDC_LCDCFG5_VSPHO = 0x2000
	// Position of GUARDTIME field.
	LCDC_LCDCFG5_GUARDTIME_Pos = 0x10
	// Bit mask of GUARDTIME field.
	LCDC_LCDCFG5_GUARDTIME_Msk = 0x1f0000

	// LCDCFG6: LCD Controller Configuration Register 6
	// Position of PWMPS field.
	LCDC_LCDCFG6_PWMPS_Pos = 0x0
	// Bit mask of PWMPS field.
	LCDC_LCDCFG6_PWMPS_Msk = 0x7
	// Position of PWMPOL field.
	LCDC_LCDCFG6_PWMPOL_Pos = 0x4
	// Bit mask of PWMPOL field.
	LCDC_LCDCFG6_PWMPOL_Msk = 0x10
	// Bit PWMPOL.
	LCDC_LCDCFG6_PWMPOL = 0x10
	// Position of PWMCVAL field.
	LCDC_LCDCFG6_PWMCVAL_Pos = 0x8
	// Bit mask of PWMCVAL field.
	LCDC_LCDCFG6_PWMCVAL_Msk = 0xff00

	// LCDEN: LCD Controller Enable Register
	// Position of CLKEN field.
	LCDC_LCDEN_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	LCDC_LCDEN_CLKEN_Msk = 0x1
	// Bit CLKEN.
	LCDC_LCDEN_CLKEN = 0x1
	// Position of SYNCEN field.
	LCDC_LCDEN_SYNCEN_Pos = 0x1
	// Bit mask of SYNCEN field.
	LCDC_LCDEN_SYNCEN_Msk = 0x2
	// Bit SYNCEN.
	LCDC_LCDEN_SYNCEN = 0x2
	// Position of DISPEN field.
	LCDC_LCDEN_DISPEN_Pos = 0x2
	// Bit mask of DISPEN field.
	LCDC_LCDEN_DISPEN_Msk = 0x4
	// Bit DISPEN.
	LCDC_LCDEN_DISPEN = 0x4
	// Position of PWMEN field.
	LCDC_LCDEN_PWMEN_Pos = 0x3
	// Bit mask of PWMEN field.
	LCDC_LCDEN_PWMEN_Msk = 0x8
	// Bit PWMEN.
	LCDC_LCDEN_PWMEN = 0x8

	// LCDDIS: LCD Controller Disable Register
	// Position of CLKDIS field.
	LCDC_LCDDIS_CLKDIS_Pos = 0x0
	// Bit mask of CLKDIS field.
	LCDC_LCDDIS_CLKDIS_Msk = 0x1
	// Bit CLKDIS.
	LCDC_LCDDIS_CLKDIS = 0x1
	// Position of SYNCDIS field.
	LCDC_LCDDIS_SYNCDIS_Pos = 0x1
	// Bit mask of SYNCDIS field.
	LCDC_LCDDIS_SYNCDIS_Msk = 0x2
	// Bit SYNCDIS.
	LCDC_LCDDIS_SYNCDIS = 0x2
	// Position of DISPDIS field.
	LCDC_LCDDIS_DISPDIS_Pos = 0x2
	// Bit mask of DISPDIS field.
	LCDC_LCDDIS_DISPDIS_Msk = 0x4
	// Bit DISPDIS.
	LCDC_LCDDIS_DISPDIS = 0x4
	// Position of PWMDIS field.
	LCDC_LCDDIS_PWMDIS_Pos = 0x3
	// Bit mask of PWMDIS field.
	LCDC_LCDDIS_PWMDIS_Msk = 0x8
	// Bit PWMDIS.
	LCDC_LCDDIS_PWMDIS = 0x8
	// Position of CLKRST field.
	LCDC_LCDDIS_CLKRST_Pos = 0x8
	// Bit mask of CLKRST field.
	LCDC_LCDDIS_CLKRST_Msk = 0x100
	// Bit CLKRST.
	LCDC_LCDDIS_CLKRST = 0x100
	// Position of SYNCRST field.
	LCDC_LCDDIS_SYNCRST_Pos = 0x9
	// Bit mask of SYNCRST field.
	LCDC_LCDDIS_SYNCRST_Msk = 0x200
	// Bit SYNCRST.
	LCDC_LCDDIS_SYNCRST = 0x200
	// Position of DISPRST field.
	LCDC_LCDDIS_DISPRST_Pos = 0xa
	// Bit mask of DISPRST field.
	LCDC_LCDDIS_DISPRST_Msk = 0x400
	// Bit DISPRST.
	LCDC_LCDDIS_DISPRST = 0x400
	// Position of PWMRST field.
	LCDC_LCDDIS_PWMRST_Pos = 0xb
	// Bit mask of PWMRST field.
	LCDC_LCDDIS_PWMRST_Msk = 0x800
	// Bit PWMRST.
	LCDC_LCDDIS_PWMRST = 0x800

	// LCDSR: LCD Controller Status Register
	// Position of CLKSTS field.
	LCDC_LCDSR_CLKSTS_Pos = 0x0
	// Bit mask of CLKSTS field.
	LCDC_LCDSR_CLKSTS_Msk = 0x1
	// Bit CLKSTS.
	LCDC_LCDSR_CLKSTS = 0x1
	// Position of LCDSTS field.
	LCDC_LCDSR_LCDSTS_Pos = 0x1
	// Bit mask of LCDSTS field.
	LCDC_LCDSR_LCDSTS_Msk = 0x2
	// Bit LCDSTS.
	LCDC_LCDSR_LCDSTS = 0x2
	// Position of DISPSTS field.
	LCDC_LCDSR_DISPSTS_Pos = 0x2
	// Bit mask of DISPSTS field.
	LCDC_LCDSR_DISPSTS_Msk = 0x4
	// Bit DISPSTS.
	LCDC_LCDSR_DISPSTS = 0x4
	// Position of PWMSTS field.
	LCDC_LCDSR_PWMSTS_Pos = 0x3
	// Bit mask of PWMSTS field.
	LCDC_LCDSR_PWMSTS_Msk = 0x8
	// Bit PWMSTS.
	LCDC_LCDSR_PWMSTS = 0x8
	// Position of SIPSTS field.
	LCDC_LCDSR_SIPSTS_Pos = 0x4
	// Bit mask of SIPSTS field.
	LCDC_LCDSR_SIPSTS_Msk = 0x10
	// Bit SIPSTS.
	LCDC_LCDSR_SIPSTS = 0x10

	// LCDIER: LCD Controller Interrupt Enable Register
	// Position of SOFIE field.
	LCDC_LCDIER_SOFIE_Pos = 0x0
	// Bit mask of SOFIE field.
	LCDC_LCDIER_SOFIE_Msk = 0x1
	// Bit SOFIE.
	LCDC_LCDIER_SOFIE = 0x1
	// Position of DISIE field.
	LCDC_LCDIER_DISIE_Pos = 0x1
	// Bit mask of DISIE field.
	LCDC_LCDIER_DISIE_Msk = 0x2
	// Bit DISIE.
	LCDC_LCDIER_DISIE = 0x2
	// Position of DISPIE field.
	LCDC_LCDIER_DISPIE_Pos = 0x2
	// Bit mask of DISPIE field.
	LCDC_LCDIER_DISPIE_Msk = 0x4
	// Bit DISPIE.
	LCDC_LCDIER_DISPIE = 0x4
	// Position of FIFOERRIE field.
	LCDC_LCDIER_FIFOERRIE_Pos = 0x4
	// Bit mask of FIFOERRIE field.
	LCDC_LCDIER_FIFOERRIE_Msk = 0x10
	// Bit FIFOERRIE.
	LCDC_LCDIER_FIFOERRIE = 0x10
	// Position of BASEIE field.
	LCDC_LCDIER_BASEIE_Pos = 0x8
	// Bit mask of BASEIE field.
	LCDC_LCDIER_BASEIE_Msk = 0x100
	// Bit BASEIE.
	LCDC_LCDIER_BASEIE = 0x100
	// Position of OVR1IE field.
	LCDC_LCDIER_OVR1IE_Pos = 0x9
	// Bit mask of OVR1IE field.
	LCDC_LCDIER_OVR1IE_Msk = 0x200
	// Bit OVR1IE.
	LCDC_LCDIER_OVR1IE = 0x200
	// Position of OVR2IE field.
	LCDC_LCDIER_OVR2IE_Pos = 0xa
	// Bit mask of OVR2IE field.
	LCDC_LCDIER_OVR2IE_Msk = 0x400
	// Bit OVR2IE.
	LCDC_LCDIER_OVR2IE = 0x400
	// Position of HEOIE field.
	LCDC_LCDIER_HEOIE_Pos = 0xb
	// Bit mask of HEOIE field.
	LCDC_LCDIER_HEOIE_Msk = 0x800
	// Bit HEOIE.
	LCDC_LCDIER_HEOIE = 0x800
	// Position of HCRIE field.
	LCDC_LCDIER_HCRIE_Pos = 0xc
	// Bit mask of HCRIE field.
	LCDC_LCDIER_HCRIE_Msk = 0x1000
	// Bit HCRIE.
	LCDC_LCDIER_HCRIE = 0x1000
	// Position of PPIE field.
	LCDC_LCDIER_PPIE_Pos = 0xd
	// Bit mask of PPIE field.
	LCDC_LCDIER_PPIE_Msk = 0x2000
	// Bit PPIE.
	LCDC_LCDIER_PPIE = 0x2000

	// LCDIDR: LCD Controller Interrupt Disable Register
	// Position of SOFID field.
	LCDC_LCDIDR_SOFID_Pos = 0x0
	// Bit mask of SOFID field.
	LCDC_LCDIDR_SOFID_Msk = 0x1
	// Bit SOFID.
	LCDC_LCDIDR_SOFID = 0x1
	// Position of DISID field.
	LCDC_LCDIDR_DISID_Pos = 0x1
	// Bit mask of DISID field.
	LCDC_LCDIDR_DISID_Msk = 0x2
	// Bit DISID.
	LCDC_LCDIDR_DISID = 0x2
	// Position of DISPID field.
	LCDC_LCDIDR_DISPID_Pos = 0x2
	// Bit mask of DISPID field.
	LCDC_LCDIDR_DISPID_Msk = 0x4
	// Bit DISPID.
	LCDC_LCDIDR_DISPID = 0x4
	// Position of FIFOERRID field.
	LCDC_LCDIDR_FIFOERRID_Pos = 0x4
	// Bit mask of FIFOERRID field.
	LCDC_LCDIDR_FIFOERRID_Msk = 0x10
	// Bit FIFOERRID.
	LCDC_LCDIDR_FIFOERRID = 0x10
	// Position of BASEID field.
	LCDC_LCDIDR_BASEID_Pos = 0x8
	// Bit mask of BASEID field.
	LCDC_LCDIDR_BASEID_Msk = 0x100
	// Bit BASEID.
	LCDC_LCDIDR_BASEID = 0x100
	// Position of OVR1ID field.
	LCDC_LCDIDR_OVR1ID_Pos = 0x9
	// Bit mask of OVR1ID field.
	LCDC_LCDIDR_OVR1ID_Msk = 0x200
	// Bit OVR1ID.
	LCDC_LCDIDR_OVR1ID = 0x200
	// Position of OVR2ID field.
	LCDC_LCDIDR_OVR2ID_Pos = 0xa
	// Bit mask of OVR2ID field.
	LCDC_LCDIDR_OVR2ID_Msk = 0x400
	// Bit OVR2ID.
	LCDC_LCDIDR_OVR2ID = 0x400
	// Position of HEOID field.
	LCDC_LCDIDR_HEOID_Pos = 0xb
	// Bit mask of HEOID field.
	LCDC_LCDIDR_HEOID_Msk = 0x800
	// Bit HEOID.
	LCDC_LCDIDR_HEOID = 0x800
	// Position of HCRID field.
	LCDC_LCDIDR_HCRID_Pos = 0xc
	// Bit mask of HCRID field.
	LCDC_LCDIDR_HCRID_Msk = 0x1000
	// Bit HCRID.
	LCDC_LCDIDR_HCRID = 0x1000
	// Position of PPID field.
	LCDC_LCDIDR_PPID_Pos = 0xd
	// Bit mask of PPID field.
	LCDC_LCDIDR_PPID_Msk = 0x2000
	// Bit PPID.
	LCDC_LCDIDR_PPID = 0x2000

	// LCDIMR: LCD Controller Interrupt Mask Register
	// Position of SOFIM field.
	LCDC_LCDIMR_SOFIM_Pos = 0x0
	// Bit mask of SOFIM field.
	LCDC_LCDIMR_SOFIM_Msk = 0x1
	// Bit SOFIM.
	LCDC_LCDIMR_SOFIM = 0x1
	// Position of DISIM field.
	LCDC_LCDIMR_DISIM_Pos = 0x1
	// Bit mask of DISIM field.
	LCDC_LCDIMR_DISIM_Msk = 0x2
	// Bit DISIM.
	LCDC_LCDIMR_DISIM = 0x2
	// Position of DISPIM field.
	LCDC_LCDIMR_DISPIM_Pos = 0x2
	// Bit mask of DISPIM field.
	LCDC_LCDIMR_DISPIM_Msk = 0x4
	// Bit DISPIM.
	LCDC_LCDIMR_DISPIM = 0x4
	// Position of FIFOERRIM field.
	LCDC_LCDIMR_FIFOERRIM_Pos = 0x4
	// Bit mask of FIFOERRIM field.
	LCDC_LCDIMR_FIFOERRIM_Msk = 0x10
	// Bit FIFOERRIM.
	LCDC_LCDIMR_FIFOERRIM = 0x10
	// Position of BASEIM field.
	LCDC_LCDIMR_BASEIM_Pos = 0x8
	// Bit mask of BASEIM field.
	LCDC_LCDIMR_BASEIM_Msk = 0x100
	// Bit BASEIM.
	LCDC_LCDIMR_BASEIM = 0x100
	// Position of OVR1IM field.
	LCDC_LCDIMR_OVR1IM_Pos = 0x9
	// Bit mask of OVR1IM field.
	LCDC_LCDIMR_OVR1IM_Msk = 0x200
	// Bit OVR1IM.
	LCDC_LCDIMR_OVR1IM = 0x200
	// Position of OVR2IM field.
	LCDC_LCDIMR_OVR2IM_Pos = 0xa
	// Bit mask of OVR2IM field.
	LCDC_LCDIMR_OVR2IM_Msk = 0x400
	// Bit OVR2IM.
	LCDC_LCDIMR_OVR2IM = 0x400
	// Position of HEOIM field.
	LCDC_LCDIMR_HEOIM_Pos = 0xb
	// Bit mask of HEOIM field.
	LCDC_LCDIMR_HEOIM_Msk = 0x800
	// Bit HEOIM.
	LCDC_LCDIMR_HEOIM = 0x800
	// Position of HCRIM field.
	LCDC_LCDIMR_HCRIM_Pos = 0xc
	// Bit mask of HCRIM field.
	LCDC_LCDIMR_HCRIM_Msk = 0x1000
	// Bit HCRIM.
	LCDC_LCDIMR_HCRIM = 0x1000
	// Position of PPIM field.
	LCDC_LCDIMR_PPIM_Pos = 0xd
	// Bit mask of PPIM field.
	LCDC_LCDIMR_PPIM_Msk = 0x2000
	// Bit PPIM.
	LCDC_LCDIMR_PPIM = 0x2000

	// LCDISR: LCD Controller Interrupt Status Register
	// Position of SOF field.
	LCDC_LCDISR_SOF_Pos = 0x0
	// Bit mask of SOF field.
	LCDC_LCDISR_SOF_Msk = 0x1
	// Bit SOF.
	LCDC_LCDISR_SOF = 0x1
	// Position of DIS field.
	LCDC_LCDISR_DIS_Pos = 0x1
	// Bit mask of DIS field.
	LCDC_LCDISR_DIS_Msk = 0x2
	// Bit DIS.
	LCDC_LCDISR_DIS = 0x2
	// Position of DISP field.
	LCDC_LCDISR_DISP_Pos = 0x2
	// Bit mask of DISP field.
	LCDC_LCDISR_DISP_Msk = 0x4
	// Bit DISP.
	LCDC_LCDISR_DISP = 0x4
	// Position of FIFOERR field.
	LCDC_LCDISR_FIFOERR_Pos = 0x4
	// Bit mask of FIFOERR field.
	LCDC_LCDISR_FIFOERR_Msk = 0x10
	// Bit FIFOERR.
	LCDC_LCDISR_FIFOERR = 0x10
	// Position of BASE field.
	LCDC_LCDISR_BASE_Pos = 0x8
	// Bit mask of BASE field.
	LCDC_LCDISR_BASE_Msk = 0x100
	// Bit BASE.
	LCDC_LCDISR_BASE = 0x100
	// Position of OVR1 field.
	LCDC_LCDISR_OVR1_Pos = 0x9
	// Bit mask of OVR1 field.
	LCDC_LCDISR_OVR1_Msk = 0x200
	// Bit OVR1.
	LCDC_LCDISR_OVR1 = 0x200
	// Position of OVR2 field.
	LCDC_LCDISR_OVR2_Pos = 0xa
	// Bit mask of OVR2 field.
	LCDC_LCDISR_OVR2_Msk = 0x400
	// Bit OVR2.
	LCDC_LCDISR_OVR2 = 0x400
	// Position of HEO field.
	LCDC_LCDISR_HEO_Pos = 0xb
	// Bit mask of HEO field.
	LCDC_LCDISR_HEO_Msk = 0x800
	// Bit HEO.
	LCDC_LCDISR_HEO = 0x800
	// Position of HCR field.
	LCDC_LCDISR_HCR_Pos = 0xc
	// Bit mask of HCR field.
	LCDC_LCDISR_HCR_Msk = 0x1000
	// Bit HCR.
	LCDC_LCDISR_HCR = 0x1000
	// Position of PP field.
	LCDC_LCDISR_PP_Pos = 0xd
	// Bit mask of PP field.
	LCDC_LCDISR_PP_Msk = 0x2000
	// Bit PP.
	LCDC_LCDISR_PP = 0x2000

	// BASECHER: Base Layer Channel Enable Register
	// Position of CHEN field.
	LCDC_BASECHER_CHEN_Pos = 0x0
	// Bit mask of CHEN field.
	LCDC_BASECHER_CHEN_Msk = 0x1
	// Bit CHEN.
	LCDC_BASECHER_CHEN = 0x1
	// Position of UPDATEEN field.
	LCDC_BASECHER_UPDATEEN_Pos = 0x1
	// Bit mask of UPDATEEN field.
	LCDC_BASECHER_UPDATEEN_Msk = 0x2
	// Bit UPDATEEN.
	LCDC_BASECHER_UPDATEEN = 0x2
	// Position of A2QEN field.
	LCDC_BASECHER_A2QEN_Pos = 0x2
	// Bit mask of A2QEN field.
	LCDC_BASECHER_A2QEN_Msk = 0x4
	// Bit A2QEN.
	LCDC_BASECHER_A2QEN = 0x4

	// BASECHDR: Base Layer Channel Disable Register
	// Position of CHDIS field.
	LCDC_BASECHDR_CHDIS_Pos = 0x0
	// Bit mask of CHDIS field.
	LCDC_BASECHDR_CHDIS_Msk = 0x1
	// Bit CHDIS.
	LCDC_BASECHDR_CHDIS = 0x1
	// Position of CHRST field.
	LCDC_BASECHDR_CHRST_Pos = 0x8
	// Bit mask of CHRST field.
	LCDC_BASECHDR_CHRST_Msk = 0x100
	// Bit CHRST.
	LCDC_BASECHDR_CHRST = 0x100

	// BASECHSR: Base Layer Channel Status Register
	// Position of CHSR field.
	LCDC_BASECHSR_CHSR_Pos = 0x0
	// Bit mask of CHSR field.
	LCDC_BASECHSR_CHSR_Msk = 0x1
	// Bit CHSR.
	LCDC_BASECHSR_CHSR = 0x1
	// Position of UPDATESR field.
	LCDC_BASECHSR_UPDATESR_Pos = 0x1
	// Bit mask of UPDATESR field.
	LCDC_BASECHSR_UPDATESR_Msk = 0x2
	// Bit UPDATESR.
	LCDC_BASECHSR_UPDATESR = 0x2
	// Position of A2QSR field.
	LCDC_BASECHSR_A2QSR_Pos = 0x2
	// Bit mask of A2QSR field.
	LCDC_BASECHSR_A2QSR_Msk = 0x4
	// Bit A2QSR.
	LCDC_BASECHSR_A2QSR = 0x4

	// BASEIER: Base Layer Interrupt Enable Register
	// Position of DMA field.
	LCDC_BASEIER_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_BASEIER_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_BASEIER_DMA = 0x4
	// Position of DSCR field.
	LCDC_BASEIER_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_BASEIER_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_BASEIER_DSCR = 0x8
	// Position of ADD field.
	LCDC_BASEIER_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_BASEIER_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_BASEIER_ADD = 0x10
	// Position of DONE field.
	LCDC_BASEIER_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_BASEIER_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_BASEIER_DONE = 0x20
	// Position of OVR field.
	LCDC_BASEIER_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_BASEIER_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_BASEIER_OVR = 0x40

	// BASEIDR: Base Layer Interrupt Disabled Register
	// Position of DMA field.
	LCDC_BASEIDR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_BASEIDR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_BASEIDR_DMA = 0x4
	// Position of DSCR field.
	LCDC_BASEIDR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_BASEIDR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_BASEIDR_DSCR = 0x8
	// Position of ADD field.
	LCDC_BASEIDR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_BASEIDR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_BASEIDR_ADD = 0x10
	// Position of DONE field.
	LCDC_BASEIDR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_BASEIDR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_BASEIDR_DONE = 0x20
	// Position of OVR field.
	LCDC_BASEIDR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_BASEIDR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_BASEIDR_OVR = 0x40

	// BASEIMR: Base Layer Interrupt Mask Register
	// Position of DMA field.
	LCDC_BASEIMR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_BASEIMR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_BASEIMR_DMA = 0x4
	// Position of DSCR field.
	LCDC_BASEIMR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_BASEIMR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_BASEIMR_DSCR = 0x8
	// Position of ADD field.
	LCDC_BASEIMR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_BASEIMR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_BASEIMR_ADD = 0x10
	// Position of DONE field.
	LCDC_BASEIMR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_BASEIMR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_BASEIMR_DONE = 0x20
	// Position of OVR field.
	LCDC_BASEIMR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_BASEIMR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_BASEIMR_OVR = 0x40

	// BASEISR: Base Layer Interrupt status Register
	// Position of DMA field.
	LCDC_BASEISR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_BASEISR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_BASEISR_DMA = 0x4
	// Position of DSCR field.
	LCDC_BASEISR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_BASEISR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_BASEISR_DSCR = 0x8
	// Position of ADD field.
	LCDC_BASEISR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_BASEISR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_BASEISR_ADD = 0x10
	// Position of DONE field.
	LCDC_BASEISR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_BASEISR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_BASEISR_DONE = 0x20
	// Position of OVR field.
	LCDC_BASEISR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_BASEISR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_BASEISR_OVR = 0x40

	// BASEHEAD: Base DMA Head Register
	// Position of HEAD field.
	LCDC_BASEHEAD_HEAD_Pos = 0x2
	// Bit mask of HEAD field.
	LCDC_BASEHEAD_HEAD_Msk = 0xfffffffc

	// BASEADDR: Base DMA Address Register
	// Position of ADDR field.
	LCDC_BASEADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	LCDC_BASEADDR_ADDR_Msk = 0xffffffff

	// BASECTRL: Base DMA Control Register
	// Position of DFETCH field.
	LCDC_BASECTRL_DFETCH_Pos = 0x0
	// Bit mask of DFETCH field.
	LCDC_BASECTRL_DFETCH_Msk = 0x1
	// Bit DFETCH.
	LCDC_BASECTRL_DFETCH = 0x1
	// Position of LFETCH field.
	LCDC_BASECTRL_LFETCH_Pos = 0x1
	// Bit mask of LFETCH field.
	LCDC_BASECTRL_LFETCH_Msk = 0x2
	// Bit LFETCH.
	LCDC_BASECTRL_LFETCH = 0x2
	// Position of DMAIEN field.
	LCDC_BASECTRL_DMAIEN_Pos = 0x2
	// Bit mask of DMAIEN field.
	LCDC_BASECTRL_DMAIEN_Msk = 0x4
	// Bit DMAIEN.
	LCDC_BASECTRL_DMAIEN = 0x4
	// Position of DSCRIEN field.
	LCDC_BASECTRL_DSCRIEN_Pos = 0x3
	// Bit mask of DSCRIEN field.
	LCDC_BASECTRL_DSCRIEN_Msk = 0x8
	// Bit DSCRIEN.
	LCDC_BASECTRL_DSCRIEN = 0x8
	// Position of ADDIEN field.
	LCDC_BASECTRL_ADDIEN_Pos = 0x4
	// Bit mask of ADDIEN field.
	LCDC_BASECTRL_ADDIEN_Msk = 0x10
	// Bit ADDIEN.
	LCDC_BASECTRL_ADDIEN = 0x10
	// Position of DONEIEN field.
	LCDC_BASECTRL_DONEIEN_Pos = 0x5
	// Bit mask of DONEIEN field.
	LCDC_BASECTRL_DONEIEN_Msk = 0x20
	// Bit DONEIEN.
	LCDC_BASECTRL_DONEIEN = 0x20

	// BASENEXT: Base DMA Next Register
	// Position of NEXT field.
	LCDC_BASENEXT_NEXT_Pos = 0x0
	// Bit mask of NEXT field.
	LCDC_BASENEXT_NEXT_Msk = 0xffffffff

	// BASECFG0: Base Configuration register 0
	// Position of SIF field.
	LCDC_BASECFG0_SIF_Pos = 0x0
	// Bit mask of SIF field.
	LCDC_BASECFG0_SIF_Msk = 0x1
	// Bit SIF.
	LCDC_BASECFG0_SIF = 0x1
	// Position of BLEN field.
	LCDC_BASECFG0_BLEN_Pos = 0x4
	// Bit mask of BLEN field.
	LCDC_BASECFG0_BLEN_Msk = 0x30
	// AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_SINGLE = 0x0
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_INCR4 = 0x1
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_INCR8 = 0x2
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_INCR16 = 0x3
	// Position of DLBO field.
	LCDC_BASECFG0_DLBO_Pos = 0x8
	// Bit mask of DLBO field.
	LCDC_BASECFG0_DLBO_Msk = 0x100
	// Bit DLBO.
	LCDC_BASECFG0_DLBO = 0x100

	// BASECFG1: Base Configuration register 1
	// Position of CLUTEN field.
	LCDC_BASECFG1_CLUTEN_Pos = 0x0
	// Bit mask of CLUTEN field.
	LCDC_BASECFG1_CLUTEN_Msk = 0x1
	// Bit CLUTEN.
	LCDC_BASECFG1_CLUTEN = 0x1
	// Position of RGBMODE field.
	LCDC_BASECFG1_RGBMODE_Pos = 0x4
	// Bit mask of RGBMODE field.
	LCDC_BASECFG1_RGBMODE_Msk = 0xf0
	// 12 bpp RGB 444
	LCDC_BASECFG1_RGBMODE_12BPP_RGB_444 = 0x0
	// 16 bpp ARGB 4444
	LCDC_BASECFG1_RGBMODE_16BPP_ARGB_4444 = 0x1
	// 16 bpp RGBA 4444
	LCDC_BASECFG1_RGBMODE_16BPP_RGBA_4444 = 0x2
	// 16 bpp RGB 565
	LCDC_BASECFG1_RGBMODE_16BPP_RGB_565 = 0x3
	// 16 bpp TRGB 1555
	LCDC_BASECFG1_RGBMODE_16BPP_TRGB_1555 = 0x4
	// 18 bpp RGB 666
	LCDC_BASECFG1_RGBMODE_18BPP_RGB_666 = 0x5
	// 18 bpp RGB 666 PACKED
	LCDC_BASECFG1_RGBMODE_18BPP_RGB_666PACKED = 0x6
	// 19 bpp TRGB 1666
	LCDC_BASECFG1_RGBMODE_19BPP_TRGB_1666 = 0x7
	// 19 bpp TRGB 1666 PACKED
	LCDC_BASECFG1_RGBMODE_19BPP_TRGB_PACKED = 0x8
	// 24 bpp RGB 888
	LCDC_BASECFG1_RGBMODE_24BPP_RGB_888 = 0x9
	// 24 bpp RGB 888 PACKED
	LCDC_BASECFG1_RGBMODE_24BPP_RGB_888_PACKED = 0xa
	// 25 bpp TRGB 1888
	LCDC_BASECFG1_RGBMODE_25BPP_TRGB_1888 = 0xb
	// 32 bpp ARGB 8888
	LCDC_BASECFG1_RGBMODE_32BPP_ARGB_8888 = 0xc
	// 32 bpp RGBA 8888
	LCDC_BASECFG1_RGBMODE_32BPP_RGBA_8888 = 0xd
	// Position of CLUTMODE field.
	LCDC_BASECFG1_CLUTMODE_Pos = 0x8
	// Bit mask of CLUTMODE field.
	LCDC_BASECFG1_CLUTMODE_Msk = 0x300
	// color lookup table mode set to 1 bit per pixel
	LCDC_BASECFG1_CLUTMODE_CLUT_1BPP = 0x0
	// color lookup table mode set to 2 bits per pixel
	LCDC_BASECFG1_CLUTMODE_CLUT_2BPP = 0x1
	// color lookup table mode set to 4 bits per pixel
	LCDC_BASECFG1_CLUTMODE_CLUT_4BPP = 0x2
	// color lookup table mode set to 8 bits per pixel
	LCDC_BASECFG1_CLUTMODE_CLUT_8BPP = 0x3

	// BASECFG2: Base Configuration register 2
	// Position of XSTRIDE field.
	LCDC_BASECFG2_XSTRIDE_Pos = 0x0
	// Bit mask of XSTRIDE field.
	LCDC_BASECFG2_XSTRIDE_Msk = 0xffffffff

	// BASECFG3: Base Configuration register 3
	// Position of BDEF field.
	LCDC_BASECFG3_BDEF_Pos = 0x0
	// Bit mask of BDEF field.
	LCDC_BASECFG3_BDEF_Msk = 0xff
	// Position of GDEF field.
	LCDC_BASECFG3_GDEF_Pos = 0x8
	// Bit mask of GDEF field.
	LCDC_BASECFG3_GDEF_Msk = 0xff00
	// Position of RDEF field.
	LCDC_BASECFG3_RDEF_Pos = 0x10
	// Bit mask of RDEF field.
	LCDC_BASECFG3_RDEF_Msk = 0xff0000

	// BASECFG4: Base Configuration register 4
	// Position of DMA field.
	LCDC_BASECFG4_DMA_Pos = 0x8
	// Bit mask of DMA field.
	LCDC_BASECFG4_DMA_Msk = 0x100
	// Bit DMA.
	LCDC_BASECFG4_DMA = 0x100
	// Position of REP field.
	LCDC_BASECFG4_REP_Pos = 0x9
	// Bit mask of REP field.
	LCDC_BASECFG4_REP_Msk = 0x200
	// Bit REP.
	LCDC_BASECFG4_REP = 0x200
	// Position of DISCEN field.
	LCDC_BASECFG4_DISCEN_Pos = 0xb
	// Bit mask of DISCEN field.
	LCDC_BASECFG4_DISCEN_Msk = 0x800
	// Bit DISCEN.
	LCDC_BASECFG4_DISCEN = 0x800

	// BASECFG5: Base Configuration register 5
	// Position of DISCXPOS field.
	LCDC_BASECFG5_DISCXPOS_Pos = 0x0
	// Bit mask of DISCXPOS field.
	LCDC_BASECFG5_DISCXPOS_Msk = 0x7ff
	// Position of DISCYPOS field.
	LCDC_BASECFG5_DISCYPOS_Pos = 0x10
	// Bit mask of DISCYPOS field.
	LCDC_BASECFG5_DISCYPOS_Msk = 0x7ff0000

	// BASECFG6: Base Configuration register 6
	// Position of DISCXSIZE field.
	LCDC_BASECFG6_DISCXSIZE_Pos = 0x0
	// Bit mask of DISCXSIZE field.
	LCDC_BASECFG6_DISCXSIZE_Msk = 0x7ff
	// Position of DISCYSIZE field.
	LCDC_BASECFG6_DISCYSIZE_Pos = 0x10
	// Bit mask of DISCYSIZE field.
	LCDC_BASECFG6_DISCYSIZE_Msk = 0x7ff0000

	// OVR1CHER: Overlay 1 Channel Enable Register
	// Position of CHEN field.
	LCDC_OVR1CHER_CHEN_Pos = 0x0
	// Bit mask of CHEN field.
	LCDC_OVR1CHER_CHEN_Msk = 0x1
	// Bit CHEN.
	LCDC_OVR1CHER_CHEN = 0x1
	// Position of UPDATEEN field.
	LCDC_OVR1CHER_UPDATEEN_Pos = 0x1
	// Bit mask of UPDATEEN field.
	LCDC_OVR1CHER_UPDATEEN_Msk = 0x2
	// Bit UPDATEEN.
	LCDC_OVR1CHER_UPDATEEN = 0x2
	// Position of A2QEN field.
	LCDC_OVR1CHER_A2QEN_Pos = 0x2
	// Bit mask of A2QEN field.
	LCDC_OVR1CHER_A2QEN_Msk = 0x4
	// Bit A2QEN.
	LCDC_OVR1CHER_A2QEN = 0x4

	// OVR1CHDR: Overlay 1 Channel Disable Register
	// Position of CHDIS field.
	LCDC_OVR1CHDR_CHDIS_Pos = 0x0
	// Bit mask of CHDIS field.
	LCDC_OVR1CHDR_CHDIS_Msk = 0x1
	// Bit CHDIS.
	LCDC_OVR1CHDR_CHDIS = 0x1
	// Position of CHRST field.
	LCDC_OVR1CHDR_CHRST_Pos = 0x8
	// Bit mask of CHRST field.
	LCDC_OVR1CHDR_CHRST_Msk = 0x100
	// Bit CHRST.
	LCDC_OVR1CHDR_CHRST = 0x100

	// OVR1CHSR: Overlay 1 Channel Status Register
	// Position of CHSR field.
	LCDC_OVR1CHSR_CHSR_Pos = 0x0
	// Bit mask of CHSR field.
	LCDC_OVR1CHSR_CHSR_Msk = 0x1
	// Bit CHSR.
	LCDC_OVR1CHSR_CHSR = 0x1
	// Position of UPDATESR field.
	LCDC_OVR1CHSR_UPDATESR_Pos = 0x1
	// Bit mask of UPDATESR field.
	LCDC_OVR1CHSR_UPDATESR_Msk = 0x2
	// Bit UPDATESR.
	LCDC_OVR1CHSR_UPDATESR = 0x2
	// Position of A2QSR field.
	LCDC_OVR1CHSR_A2QSR_Pos = 0x2
	// Bit mask of A2QSR field.
	LCDC_OVR1CHSR_A2QSR_Msk = 0x4
	// Bit A2QSR.
	LCDC_OVR1CHSR_A2QSR = 0x4

	// OVR1IER: Overlay 1 Interrupt Enable Register
	// Position of DMA field.
	LCDC_OVR1IER_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_OVR1IER_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_OVR1IER_DMA = 0x4
	// Position of DSCR field.
	LCDC_OVR1IER_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_OVR1IER_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_OVR1IER_DSCR = 0x8
	// Position of ADD field.
	LCDC_OVR1IER_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_OVR1IER_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_OVR1IER_ADD = 0x10
	// Position of DONE field.
	LCDC_OVR1IER_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_OVR1IER_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_OVR1IER_DONE = 0x20
	// Position of OVR field.
	LCDC_OVR1IER_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_OVR1IER_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_OVR1IER_OVR = 0x40

	// OVR1IDR: Overlay 1 Interrupt Disable Register
	// Position of DMA field.
	LCDC_OVR1IDR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_OVR1IDR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_OVR1IDR_DMA = 0x4
	// Position of DSCR field.
	LCDC_OVR1IDR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_OVR1IDR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_OVR1IDR_DSCR = 0x8
	// Position of ADD field.
	LCDC_OVR1IDR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_OVR1IDR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_OVR1IDR_ADD = 0x10
	// Position of DONE field.
	LCDC_OVR1IDR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_OVR1IDR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_OVR1IDR_DONE = 0x20
	// Position of OVR field.
	LCDC_OVR1IDR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_OVR1IDR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_OVR1IDR_OVR = 0x40

	// OVR1IMR: Overlay 1 Interrupt Mask Register
	// Position of DMA field.
	LCDC_OVR1IMR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_OVR1IMR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_OVR1IMR_DMA = 0x4
	// Position of DSCR field.
	LCDC_OVR1IMR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_OVR1IMR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_OVR1IMR_DSCR = 0x8
	// Position of ADD field.
	LCDC_OVR1IMR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_OVR1IMR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_OVR1IMR_ADD = 0x10
	// Position of DONE field.
	LCDC_OVR1IMR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_OVR1IMR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_OVR1IMR_DONE = 0x20
	// Position of OVR field.
	LCDC_OVR1IMR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_OVR1IMR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_OVR1IMR_OVR = 0x40

	// OVR1ISR: Overlay 1 Interrupt Status Register
	// Position of DMA field.
	LCDC_OVR1ISR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_OVR1ISR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_OVR1ISR_DMA = 0x4
	// Position of DSCR field.
	LCDC_OVR1ISR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_OVR1ISR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_OVR1ISR_DSCR = 0x8
	// Position of ADD field.
	LCDC_OVR1ISR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_OVR1ISR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_OVR1ISR_ADD = 0x10
	// Position of DONE field.
	LCDC_OVR1ISR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_OVR1ISR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_OVR1ISR_DONE = 0x20
	// Position of OVR field.
	LCDC_OVR1ISR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_OVR1ISR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_OVR1ISR_OVR = 0x40

	// OVR1HEAD: Overlay 1 DMA Head Register
	// Position of HEAD field.
	LCDC_OVR1HEAD_HEAD_Pos = 0x2
	// Bit mask of HEAD field.
	LCDC_OVR1HEAD_HEAD_Msk = 0xfffffffc

	// OVR1ADDR: Overlay 1 DMA Address Register
	// Position of ADDR field.
	LCDC_OVR1ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	LCDC_OVR1ADDR_ADDR_Msk = 0xffffffff

	// OVR1CTRL: Overlay1 DMA Control Register
	// Position of DFETCH field.
	LCDC_OVR1CTRL_DFETCH_Pos = 0x0
	// Bit mask of DFETCH field.
	LCDC_OVR1CTRL_DFETCH_Msk = 0x1
	// Bit DFETCH.
	LCDC_OVR1CTRL_DFETCH = 0x1
	// Position of LFETCH field.
	LCDC_OVR1CTRL_LFETCH_Pos = 0x1
	// Bit mask of LFETCH field.
	LCDC_OVR1CTRL_LFETCH_Msk = 0x2
	// Bit LFETCH.
	LCDC_OVR1CTRL_LFETCH = 0x2
	// Position of DMAIEN field.
	LCDC_OVR1CTRL_DMAIEN_Pos = 0x2
	// Bit mask of DMAIEN field.
	LCDC_OVR1CTRL_DMAIEN_Msk = 0x4
	// Bit DMAIEN.
	LCDC_OVR1CTRL_DMAIEN = 0x4
	// Position of DSCRIEN field.
	LCDC_OVR1CTRL_DSCRIEN_Pos = 0x3
	// Bit mask of DSCRIEN field.
	LCDC_OVR1CTRL_DSCRIEN_Msk = 0x8
	// Bit DSCRIEN.
	LCDC_OVR1CTRL_DSCRIEN = 0x8
	// Position of ADDIEN field.
	LCDC_OVR1CTRL_ADDIEN_Pos = 0x4
	// Bit mask of ADDIEN field.
	LCDC_OVR1CTRL_ADDIEN_Msk = 0x10
	// Bit ADDIEN.
	LCDC_OVR1CTRL_ADDIEN = 0x10
	// Position of DONEIEN field.
	LCDC_OVR1CTRL_DONEIEN_Pos = 0x5
	// Bit mask of DONEIEN field.
	LCDC_OVR1CTRL_DONEIEN_Msk = 0x20
	// Bit DONEIEN.
	LCDC_OVR1CTRL_DONEIEN = 0x20

	// OVR1NEXT: Overlay1 DMA Next Register
	// Position of NEXT field.
	LCDC_OVR1NEXT_NEXT_Pos = 0x0
	// Bit mask of NEXT field.
	LCDC_OVR1NEXT_NEXT_Msk = 0xffffffff

	// OVR1CFG0: Overlay 1 Configuration 0 Register
	// Position of SIF field.
	LCDC_OVR1CFG0_SIF_Pos = 0x0
	// Bit mask of SIF field.
	LCDC_OVR1CFG0_SIF_Msk = 0x1
	// Bit SIF.
	LCDC_OVR1CFG0_SIF = 0x1
	// Position of BLEN field.
	LCDC_OVR1CFG0_BLEN_Pos = 0x4
	// Bit mask of BLEN field.
	LCDC_OVR1CFG0_BLEN_Msk = 0x30
	// AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR1CFG0_BLEN_AHB_BLEN_SINGLE = 0x0
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR1CFG0_BLEN_AHB_BLEN_INCR4 = 0x1
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR1CFG0_BLEN_AHB_BLEN_INCR8 = 0x2
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR1CFG0_BLEN_AHB_BLEN_INCR16 = 0x3
	// Position of DLBO field.
	LCDC_OVR1CFG0_DLBO_Pos = 0x8
	// Bit mask of DLBO field.
	LCDC_OVR1CFG0_DLBO_Msk = 0x100
	// Bit DLBO.
	LCDC_OVR1CFG0_DLBO = 0x100
	// Position of ROTDIS field.
	LCDC_OVR1CFG0_ROTDIS_Pos = 0xc
	// Bit mask of ROTDIS field.
	LCDC_OVR1CFG0_ROTDIS_Msk = 0x1000
	// Bit ROTDIS.
	LCDC_OVR1CFG0_ROTDIS = 0x1000
	// Position of LOCKDIS field.
	LCDC_OVR1CFG0_LOCKDIS_Pos = 0xd
	// Bit mask of LOCKDIS field.
	LCDC_OVR1CFG0_LOCKDIS_Msk = 0x2000
	// Bit LOCKDIS.
	LCDC_OVR1CFG0_LOCKDIS = 0x2000

	// OVR1CFG1: Overlay 1 Configuration 1 Register
	// Position of CLUTEN field.
	LCDC_OVR1CFG1_CLUTEN_Pos = 0x0
	// Bit mask of CLUTEN field.
	LCDC_OVR1CFG1_CLUTEN_Msk = 0x1
	// Bit CLUTEN.
	LCDC_OVR1CFG1_CLUTEN = 0x1
	// Position of RGBMODE field.
	LCDC_OVR1CFG1_RGBMODE_Pos = 0x4
	// Bit mask of RGBMODE field.
	LCDC_OVR1CFG1_RGBMODE_Msk = 0xf0
	// 12 bpp RGB 444
	LCDC_OVR1CFG1_RGBMODE_12BPP_RGB_444 = 0x0
	// 16 bpp ARGB 4444
	LCDC_OVR1CFG1_RGBMODE_16BPP_ARGB_4444 = 0x1
	// 16 bpp RGBA 4444
	LCDC_OVR1CFG1_RGBMODE_16BPP_RGBA_4444 = 0x2
	// 16 bpp RGB 565
	LCDC_OVR1CFG1_RGBMODE_16BPP_RGB_565 = 0x3
	// 16 bpp TRGB 1555
	LCDC_OVR1CFG1_RGBMODE_16BPP_TRGB_1555 = 0x4
	// 18 bpp RGB 666
	LCDC_OVR1CFG1_RGBMODE_18BPP_RGB_666 = 0x5
	// 18 bpp RGB 666 PACKED
	LCDC_OVR1CFG1_RGBMODE_18BPP_RGB_666PACKED = 0x6
	// 19 bpp TRGB 1666
	LCDC_OVR1CFG1_RGBMODE_19BPP_TRGB_1666 = 0x7
	// 19 bpp TRGB 1666 PACKED
	LCDC_OVR1CFG1_RGBMODE_19BPP_TRGB_PACKED = 0x8
	// 24 bpp RGB 888
	LCDC_OVR1CFG1_RGBMODE_24BPP_RGB_888 = 0x9
	// 24 bpp RGB 888 PACKED
	LCDC_OVR1CFG1_RGBMODE_24BPP_RGB_888_PACKED = 0xa
	// 25 bpp TRGB 1888
	LCDC_OVR1CFG1_RGBMODE_25BPP_TRGB_1888 = 0xb
	// 32 bpp ARGB 8888
	LCDC_OVR1CFG1_RGBMODE_32BPP_ARGB_8888 = 0xc
	// 32 bpp RGBA 8888
	LCDC_OVR1CFG1_RGBMODE_32BPP_RGBA_8888 = 0xd
	// Position of CLUTMODE field.
	LCDC_OVR1CFG1_CLUTMODE_Pos = 0x8
	// Bit mask of CLUTMODE field.
	LCDC_OVR1CFG1_CLUTMODE_Msk = 0x300
	// color lookup table mode set to 1 bit per pixel
	LCDC_OVR1CFG1_CLUTMODE_CLUT_1BPP = 0x0
	// color lookup table mode set to 2 bits per pixel
	LCDC_OVR1CFG1_CLUTMODE_CLUT_2BPP = 0x1
	// color lookup table mode set to 4 bits per pixel
	LCDC_OVR1CFG1_CLUTMODE_CLUT_4BPP = 0x2
	// color lookup table mode set to 8 bits per pixel
	LCDC_OVR1CFG1_CLUTMODE_CLUT_8BPP = 0x3

	// OVR1CFG2: Overlay 1 Configuration 2 Register
	// Position of XPOS field.
	LCDC_OVR1CFG2_XPOS_Pos = 0x0
	// Bit mask of XPOS field.
	LCDC_OVR1CFG2_XPOS_Msk = 0x7ff
	// Position of YPOS field.
	LCDC_OVR1CFG2_YPOS_Pos = 0x10
	// Bit mask of YPOS field.
	LCDC_OVR1CFG2_YPOS_Msk = 0x7ff0000

	// OVR1CFG3: Overlay 1 Configuration 3 Register
	// Position of XSIZE field.
	LCDC_OVR1CFG3_XSIZE_Pos = 0x0
	// Bit mask of XSIZE field.
	LCDC_OVR1CFG3_XSIZE_Msk = 0x7ff
	// Position of YSIZE field.
	LCDC_OVR1CFG3_YSIZE_Pos = 0x10
	// Bit mask of YSIZE field.
	LCDC_OVR1CFG3_YSIZE_Msk = 0x7ff0000

	// OVR1CFG4: Overlay 1 Configuration 4 Register
	// Position of XSTRIDE field.
	LCDC_OVR1CFG4_XSTRIDE_Pos = 0x0
	// Bit mask of XSTRIDE field.
	LCDC_OVR1CFG4_XSTRIDE_Msk = 0xffffffff

	// OVR1CFG5: Overlay 1 Configuration 5 Register
	// Position of PSTRIDE field.
	LCDC_OVR1CFG5_PSTRIDE_Pos = 0x0
	// Bit mask of PSTRIDE field.
	LCDC_OVR1CFG5_PSTRIDE_Msk = 0xffffffff

	// OVR1CFG6: Overlay 1 Configuration 6 Register
	// Position of BDEF field.
	LCDC_OVR1CFG6_BDEF_Pos = 0x0
	// Bit mask of BDEF field.
	LCDC_OVR1CFG6_BDEF_Msk = 0xff
	// Position of GDEF field.
	LCDC_OVR1CFG6_GDEF_Pos = 0x8
	// Bit mask of GDEF field.
	LCDC_OVR1CFG6_GDEF_Msk = 0xff00
	// Position of RDEF field.
	LCDC_OVR1CFG6_RDEF_Pos = 0x10
	// Bit mask of RDEF field.
	LCDC_OVR1CFG6_RDEF_Msk = 0xff0000

	// OVR1CFG7: Overlay 1 Configuration 7 Register
	// Position of BKEY field.
	LCDC_OVR1CFG7_BKEY_Pos = 0x0
	// Bit mask of BKEY field.
	LCDC_OVR1CFG7_BKEY_Msk = 0xff
	// Position of GKEY field.
	LCDC_OVR1CFG7_GKEY_Pos = 0x8
	// Bit mask of GKEY field.
	LCDC_OVR1CFG7_GKEY_Msk = 0xff00
	// Position of RKEY field.
	LCDC_OVR1CFG7_RKEY_Pos = 0x10
	// Bit mask of RKEY field.
	LCDC_OVR1CFG7_RKEY_Msk = 0xff0000

	// OVR1CFG8: Overlay 1 Configuration 8Register
	// Position of BMASK field.
	LCDC_OVR1CFG8_BMASK_Pos = 0x0
	// Bit mask of BMASK field.
	LCDC_OVR1CFG8_BMASK_Msk = 0xff
	// Position of GMASK field.
	LCDC_OVR1CFG8_GMASK_Pos = 0x8
	// Bit mask of GMASK field.
	LCDC_OVR1CFG8_GMASK_Msk = 0xff00
	// Position of RMASK field.
	LCDC_OVR1CFG8_RMASK_Pos = 0x10
	// Bit mask of RMASK field.
	LCDC_OVR1CFG8_RMASK_Msk = 0xff0000

	// OVR1CFG9: Overlay 1 Configuration 9 Register
	// Position of CRKEY field.
	LCDC_OVR1CFG9_CRKEY_Pos = 0x0
	// Bit mask of CRKEY field.
	LCDC_OVR1CFG9_CRKEY_Msk = 0x1
	// Bit CRKEY.
	LCDC_OVR1CFG9_CRKEY = 0x1
	// Position of INV field.
	LCDC_OVR1CFG9_INV_Pos = 0x1
	// Bit mask of INV field.
	LCDC_OVR1CFG9_INV_Msk = 0x2
	// Bit INV.
	LCDC_OVR1CFG9_INV = 0x2
	// Position of ITER2BL field.
	LCDC_OVR1CFG9_ITER2BL_Pos = 0x2
	// Bit mask of ITER2BL field.
	LCDC_OVR1CFG9_ITER2BL_Msk = 0x4
	// Bit ITER2BL.
	LCDC_OVR1CFG9_ITER2BL = 0x4
	// Position of ITER field.
	LCDC_OVR1CFG9_ITER_Pos = 0x3
	// Bit mask of ITER field.
	LCDC_OVR1CFG9_ITER_Msk = 0x8
	// Bit ITER.
	LCDC_OVR1CFG9_ITER = 0x8
	// Position of REVALPHA field.
	LCDC_OVR1CFG9_REVALPHA_Pos = 0x4
	// Bit mask of REVALPHA field.
	LCDC_OVR1CFG9_REVALPHA_Msk = 0x10
	// Bit REVALPHA.
	LCDC_OVR1CFG9_REVALPHA = 0x10
	// Position of GAEN field.
	LCDC_OVR1CFG9_GAEN_Pos = 0x5
	// Bit mask of GAEN field.
	LCDC_OVR1CFG9_GAEN_Msk = 0x20
	// Bit GAEN.
	LCDC_OVR1CFG9_GAEN = 0x20
	// Position of LAEN field.
	LCDC_OVR1CFG9_LAEN_Pos = 0x6
	// Bit mask of LAEN field.
	LCDC_OVR1CFG9_LAEN_Msk = 0x40
	// Bit LAEN.
	LCDC_OVR1CFG9_LAEN = 0x40
	// Position of OVR field.
	LCDC_OVR1CFG9_OVR_Pos = 0x7
	// Bit mask of OVR field.
	LCDC_OVR1CFG9_OVR_Msk = 0x80
	// Bit OVR.
	LCDC_OVR1CFG9_OVR = 0x80
	// Position of DMA field.
	LCDC_OVR1CFG9_DMA_Pos = 0x8
	// Bit mask of DMA field.
	LCDC_OVR1CFG9_DMA_Msk = 0x100
	// Bit DMA.
	LCDC_OVR1CFG9_DMA = 0x100
	// Position of REP field.
	LCDC_OVR1CFG9_REP_Pos = 0x9
	// Bit mask of REP field.
	LCDC_OVR1CFG9_REP_Msk = 0x200
	// Bit REP.
	LCDC_OVR1CFG9_REP = 0x200
	// Position of DSTKEY field.
	LCDC_OVR1CFG9_DSTKEY_Pos = 0xa
	// Bit mask of DSTKEY field.
	LCDC_OVR1CFG9_DSTKEY_Msk = 0x400
	// Bit DSTKEY.
	LCDC_OVR1CFG9_DSTKEY = 0x400
	// Position of GA field.
	LCDC_OVR1CFG9_GA_Pos = 0x10
	// Bit mask of GA field.
	LCDC_OVR1CFG9_GA_Msk = 0xff0000

	// OVR2CHER: Overlay 2 Channel Enable Register
	// Position of CHEN field.
	LCDC_OVR2CHER_CHEN_Pos = 0x0
	// Bit mask of CHEN field.
	LCDC_OVR2CHER_CHEN_Msk = 0x1
	// Bit CHEN.
	LCDC_OVR2CHER_CHEN = 0x1
	// Position of UPDATEEN field.
	LCDC_OVR2CHER_UPDATEEN_Pos = 0x1
	// Bit mask of UPDATEEN field.
	LCDC_OVR2CHER_UPDATEEN_Msk = 0x2
	// Bit UPDATEEN.
	LCDC_OVR2CHER_UPDATEEN = 0x2
	// Position of A2QEN field.
	LCDC_OVR2CHER_A2QEN_Pos = 0x2
	// Bit mask of A2QEN field.
	LCDC_OVR2CHER_A2QEN_Msk = 0x4
	// Bit A2QEN.
	LCDC_OVR2CHER_A2QEN = 0x4

	// OVR2CHDR: Overlay 2 Channel Disable Register
	// Position of CHDIS field.
	LCDC_OVR2CHDR_CHDIS_Pos = 0x0
	// Bit mask of CHDIS field.
	LCDC_OVR2CHDR_CHDIS_Msk = 0x1
	// Bit CHDIS.
	LCDC_OVR2CHDR_CHDIS = 0x1
	// Position of CHRST field.
	LCDC_OVR2CHDR_CHRST_Pos = 0x8
	// Bit mask of CHRST field.
	LCDC_OVR2CHDR_CHRST_Msk = 0x100
	// Bit CHRST.
	LCDC_OVR2CHDR_CHRST = 0x100

	// OVR2CHSR: Overlay 2 Channel Status Register
	// Position of CHSR field.
	LCDC_OVR2CHSR_CHSR_Pos = 0x0
	// Bit mask of CHSR field.
	LCDC_OVR2CHSR_CHSR_Msk = 0x1
	// Bit CHSR.
	LCDC_OVR2CHSR_CHSR = 0x1
	// Position of UPDATESR field.
	LCDC_OVR2CHSR_UPDATESR_Pos = 0x1
	// Bit mask of UPDATESR field.
	LCDC_OVR2CHSR_UPDATESR_Msk = 0x2
	// Bit UPDATESR.
	LCDC_OVR2CHSR_UPDATESR = 0x2
	// Position of A2QSR field.
	LCDC_OVR2CHSR_A2QSR_Pos = 0x2
	// Bit mask of A2QSR field.
	LCDC_OVR2CHSR_A2QSR_Msk = 0x4
	// Bit A2QSR.
	LCDC_OVR2CHSR_A2QSR = 0x4

	// OVR2IER: Overlay 2 Interrupt Enable Register
	// Position of DMA field.
	LCDC_OVR2IER_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_OVR2IER_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_OVR2IER_DMA = 0x4
	// Position of DSCR field.
	LCDC_OVR2IER_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_OVR2IER_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_OVR2IER_DSCR = 0x8
	// Position of ADD field.
	LCDC_OVR2IER_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_OVR2IER_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_OVR2IER_ADD = 0x10
	// Position of DONE field.
	LCDC_OVR2IER_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_OVR2IER_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_OVR2IER_DONE = 0x20
	// Position of OVR field.
	LCDC_OVR2IER_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_OVR2IER_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_OVR2IER_OVR = 0x40

	// OVR2IDR: Overlay 2 Interrupt Disable Register
	// Position of DMA field.
	LCDC_OVR2IDR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_OVR2IDR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_OVR2IDR_DMA = 0x4
	// Position of DSCR field.
	LCDC_OVR2IDR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_OVR2IDR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_OVR2IDR_DSCR = 0x8
	// Position of ADD field.
	LCDC_OVR2IDR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_OVR2IDR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_OVR2IDR_ADD = 0x10
	// Position of DONE field.
	LCDC_OVR2IDR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_OVR2IDR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_OVR2IDR_DONE = 0x20
	// Position of OVR field.
	LCDC_OVR2IDR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_OVR2IDR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_OVR2IDR_OVR = 0x40

	// OVR2IMR: Overlay 2 Interrupt Mask Register
	// Position of DMA field.
	LCDC_OVR2IMR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_OVR2IMR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_OVR2IMR_DMA = 0x4
	// Position of DSCR field.
	LCDC_OVR2IMR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_OVR2IMR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_OVR2IMR_DSCR = 0x8
	// Position of ADD field.
	LCDC_OVR2IMR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_OVR2IMR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_OVR2IMR_ADD = 0x10
	// Position of DONE field.
	LCDC_OVR2IMR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_OVR2IMR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_OVR2IMR_DONE = 0x20
	// Position of OVR field.
	LCDC_OVR2IMR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_OVR2IMR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_OVR2IMR_OVR = 0x40

	// OVR2ISR: Overlay 2 Interrupt status Register
	// Position of DMA field.
	LCDC_OVR2ISR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_OVR2ISR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_OVR2ISR_DMA = 0x4
	// Position of DSCR field.
	LCDC_OVR2ISR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_OVR2ISR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_OVR2ISR_DSCR = 0x8
	// Position of ADD field.
	LCDC_OVR2ISR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_OVR2ISR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_OVR2ISR_ADD = 0x10
	// Position of DONE field.
	LCDC_OVR2ISR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_OVR2ISR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_OVR2ISR_DONE = 0x20
	// Position of OVR field.
	LCDC_OVR2ISR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_OVR2ISR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_OVR2ISR_OVR = 0x40

	// OVR2HEAD: Overlay 2 DMA Head Register
	// Position of HEAD field.
	LCDC_OVR2HEAD_HEAD_Pos = 0x2
	// Bit mask of HEAD field.
	LCDC_OVR2HEAD_HEAD_Msk = 0xfffffffc

	// OVR2ADDR: Overlay 2 DMA Address Register
	// Position of ADDR field.
	LCDC_OVR2ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	LCDC_OVR2ADDR_ADDR_Msk = 0xffffffff

	// OVR2CTRL: Overlay 2 DMA Control Register
	// Position of DFETCH field.
	LCDC_OVR2CTRL_DFETCH_Pos = 0x0
	// Bit mask of DFETCH field.
	LCDC_OVR2CTRL_DFETCH_Msk = 0x1
	// Bit DFETCH.
	LCDC_OVR2CTRL_DFETCH = 0x1
	// Position of LFETCH field.
	LCDC_OVR2CTRL_LFETCH_Pos = 0x1
	// Bit mask of LFETCH field.
	LCDC_OVR2CTRL_LFETCH_Msk = 0x2
	// Bit LFETCH.
	LCDC_OVR2CTRL_LFETCH = 0x2
	// Position of DMAIEN field.
	LCDC_OVR2CTRL_DMAIEN_Pos = 0x2
	// Bit mask of DMAIEN field.
	LCDC_OVR2CTRL_DMAIEN_Msk = 0x4
	// Bit DMAIEN.
	LCDC_OVR2CTRL_DMAIEN = 0x4
	// Position of DSCRIEN field.
	LCDC_OVR2CTRL_DSCRIEN_Pos = 0x3
	// Bit mask of DSCRIEN field.
	LCDC_OVR2CTRL_DSCRIEN_Msk = 0x8
	// Bit DSCRIEN.
	LCDC_OVR2CTRL_DSCRIEN = 0x8
	// Position of ADDIEN field.
	LCDC_OVR2CTRL_ADDIEN_Pos = 0x4
	// Bit mask of ADDIEN field.
	LCDC_OVR2CTRL_ADDIEN_Msk = 0x10
	// Bit ADDIEN.
	LCDC_OVR2CTRL_ADDIEN = 0x10
	// Position of DONEIEN field.
	LCDC_OVR2CTRL_DONEIEN_Pos = 0x5
	// Bit mask of DONEIEN field.
	LCDC_OVR2CTRL_DONEIEN_Msk = 0x20
	// Bit DONEIEN.
	LCDC_OVR2CTRL_DONEIEN = 0x20

	// OVR2NEXT: Overlay 2 DMA Next Register
	// Position of NEXT field.
	LCDC_OVR2NEXT_NEXT_Pos = 0x0
	// Bit mask of NEXT field.
	LCDC_OVR2NEXT_NEXT_Msk = 0xffffffff

	// OVR2CFG0: Overlay 2 Configuration 0 Register
	// Position of BLEN field.
	LCDC_OVR2CFG0_BLEN_Pos = 0x4
	// Bit mask of BLEN field.
	LCDC_OVR2CFG0_BLEN_Msk = 0x30
	// AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR2CFG0_BLEN_AHB_SINGLE = 0x0
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR2CFG0_BLEN_AHB_INCR4 = 0x1
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR2CFG0_BLEN_AHB_INCR8 = 0x2
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR2CFG0_BLEN_AHB_INCR16 = 0x3
	// Position of DLBO field.
	LCDC_OVR2CFG0_DLBO_Pos = 0x8
	// Bit mask of DLBO field.
	LCDC_OVR2CFG0_DLBO_Msk = 0x100
	// Bit DLBO.
	LCDC_OVR2CFG0_DLBO = 0x100
	// Position of ROTDIS field.
	LCDC_OVR2CFG0_ROTDIS_Pos = 0xc
	// Bit mask of ROTDIS field.
	LCDC_OVR2CFG0_ROTDIS_Msk = 0x1000
	// Bit ROTDIS.
	LCDC_OVR2CFG0_ROTDIS = 0x1000
	// Position of LOCKDIS field.
	LCDC_OVR2CFG0_LOCKDIS_Pos = 0xd
	// Bit mask of LOCKDIS field.
	LCDC_OVR2CFG0_LOCKDIS_Msk = 0x2000
	// Bit LOCKDIS.
	LCDC_OVR2CFG0_LOCKDIS = 0x2000

	// OVR2CFG1: Overlay 2 Configuration 1 Register
	// Position of CLUTEN field.
	LCDC_OVR2CFG1_CLUTEN_Pos = 0x0
	// Bit mask of CLUTEN field.
	LCDC_OVR2CFG1_CLUTEN_Msk = 0x1
	// Bit CLUTEN.
	LCDC_OVR2CFG1_CLUTEN = 0x1
	// Position of RGBMODE field.
	LCDC_OVR2CFG1_RGBMODE_Pos = 0x4
	// Bit mask of RGBMODE field.
	LCDC_OVR2CFG1_RGBMODE_Msk = 0xf0
	// 12 bpp RGB 444
	LCDC_OVR2CFG1_RGBMODE_12BPP_RGB_444 = 0x0
	// 16 bpp ARGB 4444
	LCDC_OVR2CFG1_RGBMODE_16BPP_ARGB_4444 = 0x1
	// 16 bpp RGBA 4444
	LCDC_OVR2CFG1_RGBMODE_16BPP_RGBA_4444 = 0x2
	// 16 bpp RGB 565
	LCDC_OVR2CFG1_RGBMODE_16BPP_RGB_565 = 0x3
	// 16 bpp TRGB 1555
	LCDC_OVR2CFG1_RGBMODE_16BPP_TRGB_1555 = 0x4
	// 18 bpp RGB 666
	LCDC_OVR2CFG1_RGBMODE_18BPP_RGB_666 = 0x5
	// 18 bpp RGB 666 PACKED
	LCDC_OVR2CFG1_RGBMODE_18BPP_RGB_666PACKED = 0x6
	// 19 bpp TRGB 1666
	LCDC_OVR2CFG1_RGBMODE_19BPP_TRGB_1666 = 0x7
	// 19 bpp TRGB 1666 PACKED
	LCDC_OVR2CFG1_RGBMODE_19BPP_TRGB_PACKED = 0x8
	// 24 bpp RGB 888
	LCDC_OVR2CFG1_RGBMODE_24BPP_RGB_888 = 0x9
	// 24 bpp RGB 888 PACKED
	LCDC_OVR2CFG1_RGBMODE_24BPP_RGB_888_PACKED = 0xa
	// 25 bpp TRGB 1888
	LCDC_OVR2CFG1_RGBMODE_25BPP_TRGB_1888 = 0xb
	// 32 bpp ARGB 8888
	LCDC_OVR2CFG1_RGBMODE_32BPP_ARGB_8888 = 0xc
	// 32 bpp RGBA 8888
	LCDC_OVR2CFG1_RGBMODE_32BPP_RGBA_8888 = 0xd
	// Position of CLUTMODE field.
	LCDC_OVR2CFG1_CLUTMODE_Pos = 0x8
	// Bit mask of CLUTMODE field.
	LCDC_OVR2CFG1_CLUTMODE_Msk = 0x300
	// color lookup table mode set to 1 bit per pixel
	LCDC_OVR2CFG1_CLUTMODE_CLUT_1BPP = 0x0
	// color lookup table mode set to 2 bits per pixel
	LCDC_OVR2CFG1_CLUTMODE_CLUT_2BPP = 0x1
	// color lookup table mode set to 4 bits per pixel
	LCDC_OVR2CFG1_CLUTMODE_CLUT_4BPP = 0x2
	// color lookup table mode set to 8 bits per pixel
	LCDC_OVR2CFG1_CLUTMODE_CLUT_8BPP = 0x3

	// OVR2CFG2: Overlay 2 Configuration 2 Register
	// Position of XPOS field.
	LCDC_OVR2CFG2_XPOS_Pos = 0x0
	// Bit mask of XPOS field.
	LCDC_OVR2CFG2_XPOS_Msk = 0x7ff
	// Position of YPOS field.
	LCDC_OVR2CFG2_YPOS_Pos = 0x10
	// Bit mask of YPOS field.
	LCDC_OVR2CFG2_YPOS_Msk = 0x7ff0000

	// OVR2CFG3: Overlay 2 Configuration 3 Register
	// Position of XSIZE field.
	LCDC_OVR2CFG3_XSIZE_Pos = 0x0
	// Bit mask of XSIZE field.
	LCDC_OVR2CFG3_XSIZE_Msk = 0x7ff
	// Position of YSIZE field.
	LCDC_OVR2CFG3_YSIZE_Pos = 0x10
	// Bit mask of YSIZE field.
	LCDC_OVR2CFG3_YSIZE_Msk = 0x7ff0000

	// OVR2CFG4: Overlay 2 Configuration 4 Register
	// Position of XSTRIDE field.
	LCDC_OVR2CFG4_XSTRIDE_Pos = 0x0
	// Bit mask of XSTRIDE field.
	LCDC_OVR2CFG4_XSTRIDE_Msk = 0xffffffff

	// OVR2CFG5: Overlay 2 Configuration 5 Register
	// Position of PSTRIDE field.
	LCDC_OVR2CFG5_PSTRIDE_Pos = 0x0
	// Bit mask of PSTRIDE field.
	LCDC_OVR2CFG5_PSTRIDE_Msk = 0xffffffff

	// OVR2CFG6: Overlay 2 Configuration 6 Register
	// Position of BDEF field.
	LCDC_OVR2CFG6_BDEF_Pos = 0x0
	// Bit mask of BDEF field.
	LCDC_OVR2CFG6_BDEF_Msk = 0xff
	// Position of GDEF field.
	LCDC_OVR2CFG6_GDEF_Pos = 0x8
	// Bit mask of GDEF field.
	LCDC_OVR2CFG6_GDEF_Msk = 0xff00
	// Position of RDEF field.
	LCDC_OVR2CFG6_RDEF_Pos = 0x10
	// Bit mask of RDEF field.
	LCDC_OVR2CFG6_RDEF_Msk = 0xff0000

	// OVR2CFG7: Overlay 2 Configuration 7 Register
	// Position of BKEY field.
	LCDC_OVR2CFG7_BKEY_Pos = 0x0
	// Bit mask of BKEY field.
	LCDC_OVR2CFG7_BKEY_Msk = 0xff
	// Position of GKEY field.
	LCDC_OVR2CFG7_GKEY_Pos = 0x8
	// Bit mask of GKEY field.
	LCDC_OVR2CFG7_GKEY_Msk = 0xff00
	// Position of RKEY field.
	LCDC_OVR2CFG7_RKEY_Pos = 0x10
	// Bit mask of RKEY field.
	LCDC_OVR2CFG7_RKEY_Msk = 0xff0000

	// OVR2CFG8: Overlay 2 Configuration 8 Register
	// Position of BMASK field.
	LCDC_OVR2CFG8_BMASK_Pos = 0x0
	// Bit mask of BMASK field.
	LCDC_OVR2CFG8_BMASK_Msk = 0xff
	// Position of GMASK field.
	LCDC_OVR2CFG8_GMASK_Pos = 0x8
	// Bit mask of GMASK field.
	LCDC_OVR2CFG8_GMASK_Msk = 0xff00
	// Position of RMASK field.
	LCDC_OVR2CFG8_RMASK_Pos = 0x10
	// Bit mask of RMASK field.
	LCDC_OVR2CFG8_RMASK_Msk = 0xff0000

	// OVR2CFG9: Overlay 2 Configuration 9 Register
	// Position of CRKEY field.
	LCDC_OVR2CFG9_CRKEY_Pos = 0x0
	// Bit mask of CRKEY field.
	LCDC_OVR2CFG9_CRKEY_Msk = 0x1
	// Bit CRKEY.
	LCDC_OVR2CFG9_CRKEY = 0x1
	// Position of INV field.
	LCDC_OVR2CFG9_INV_Pos = 0x1
	// Bit mask of INV field.
	LCDC_OVR2CFG9_INV_Msk = 0x2
	// Bit INV.
	LCDC_OVR2CFG9_INV = 0x2
	// Position of ITER2BL field.
	LCDC_OVR2CFG9_ITER2BL_Pos = 0x2
	// Bit mask of ITER2BL field.
	LCDC_OVR2CFG9_ITER2BL_Msk = 0x4
	// Bit ITER2BL.
	LCDC_OVR2CFG9_ITER2BL = 0x4
	// Position of ITER field.
	LCDC_OVR2CFG9_ITER_Pos = 0x3
	// Bit mask of ITER field.
	LCDC_OVR2CFG9_ITER_Msk = 0x8
	// Bit ITER.
	LCDC_OVR2CFG9_ITER = 0x8
	// Position of REVALPHA field.
	LCDC_OVR2CFG9_REVALPHA_Pos = 0x4
	// Bit mask of REVALPHA field.
	LCDC_OVR2CFG9_REVALPHA_Msk = 0x10
	// Bit REVALPHA.
	LCDC_OVR2CFG9_REVALPHA = 0x10
	// Position of GAEN field.
	LCDC_OVR2CFG9_GAEN_Pos = 0x5
	// Bit mask of GAEN field.
	LCDC_OVR2CFG9_GAEN_Msk = 0x20
	// Bit GAEN.
	LCDC_OVR2CFG9_GAEN = 0x20
	// Position of LAEN field.
	LCDC_OVR2CFG9_LAEN_Pos = 0x6
	// Bit mask of LAEN field.
	LCDC_OVR2CFG9_LAEN_Msk = 0x40
	// Bit LAEN.
	LCDC_OVR2CFG9_LAEN = 0x40
	// Position of OVR field.
	LCDC_OVR2CFG9_OVR_Pos = 0x7
	// Bit mask of OVR field.
	LCDC_OVR2CFG9_OVR_Msk = 0x80
	// Bit OVR.
	LCDC_OVR2CFG9_OVR = 0x80
	// Position of DMA field.
	LCDC_OVR2CFG9_DMA_Pos = 0x8
	// Bit mask of DMA field.
	LCDC_OVR2CFG9_DMA_Msk = 0x100
	// Bit DMA.
	LCDC_OVR2CFG9_DMA = 0x100
	// Position of REP field.
	LCDC_OVR2CFG9_REP_Pos = 0x9
	// Bit mask of REP field.
	LCDC_OVR2CFG9_REP_Msk = 0x200
	// Bit REP.
	LCDC_OVR2CFG9_REP = 0x200
	// Position of DSTKEY field.
	LCDC_OVR2CFG9_DSTKEY_Pos = 0xa
	// Bit mask of DSTKEY field.
	LCDC_OVR2CFG9_DSTKEY_Msk = 0x400
	// Bit DSTKEY.
	LCDC_OVR2CFG9_DSTKEY = 0x400
	// Position of GA field.
	LCDC_OVR2CFG9_GA_Pos = 0x10
	// Bit mask of GA field.
	LCDC_OVR2CFG9_GA_Msk = 0xff0000

	// HEOCHER: High-End Overlay Channel Enable Register
	// Position of CHEN field.
	LCDC_HEOCHER_CHEN_Pos = 0x0
	// Bit mask of CHEN field.
	LCDC_HEOCHER_CHEN_Msk = 0x1
	// Bit CHEN.
	LCDC_HEOCHER_CHEN = 0x1
	// Position of UPDATEEN field.
	LCDC_HEOCHER_UPDATEEN_Pos = 0x1
	// Bit mask of UPDATEEN field.
	LCDC_HEOCHER_UPDATEEN_Msk = 0x2
	// Bit UPDATEEN.
	LCDC_HEOCHER_UPDATEEN = 0x2
	// Position of A2QEN field.
	LCDC_HEOCHER_A2QEN_Pos = 0x2
	// Bit mask of A2QEN field.
	LCDC_HEOCHER_A2QEN_Msk = 0x4
	// Bit A2QEN.
	LCDC_HEOCHER_A2QEN = 0x4

	// HEOCHDR: High-End Overlay Channel Disable Register
	// Position of CHDIS field.
	LCDC_HEOCHDR_CHDIS_Pos = 0x0
	// Bit mask of CHDIS field.
	LCDC_HEOCHDR_CHDIS_Msk = 0x1
	// Bit CHDIS.
	LCDC_HEOCHDR_CHDIS = 0x1
	// Position of CHRST field.
	LCDC_HEOCHDR_CHRST_Pos = 0x8
	// Bit mask of CHRST field.
	LCDC_HEOCHDR_CHRST_Msk = 0x100
	// Bit CHRST.
	LCDC_HEOCHDR_CHRST = 0x100

	// HEOCHSR: High-End Overlay Channel Status Register
	// Position of CHSR field.
	LCDC_HEOCHSR_CHSR_Pos = 0x0
	// Bit mask of CHSR field.
	LCDC_HEOCHSR_CHSR_Msk = 0x1
	// Bit CHSR.
	LCDC_HEOCHSR_CHSR = 0x1
	// Position of UPDATESR field.
	LCDC_HEOCHSR_UPDATESR_Pos = 0x1
	// Bit mask of UPDATESR field.
	LCDC_HEOCHSR_UPDATESR_Msk = 0x2
	// Bit UPDATESR.
	LCDC_HEOCHSR_UPDATESR = 0x2
	// Position of A2QSR field.
	LCDC_HEOCHSR_A2QSR_Pos = 0x2
	// Bit mask of A2QSR field.
	LCDC_HEOCHSR_A2QSR_Msk = 0x4
	// Bit A2QSR.
	LCDC_HEOCHSR_A2QSR = 0x4

	// HEOIER: High-End Overlay Interrupt Enable Register
	// Position of DMA field.
	LCDC_HEOIER_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_HEOIER_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_HEOIER_DMA = 0x4
	// Position of DSCR field.
	LCDC_HEOIER_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_HEOIER_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_HEOIER_DSCR = 0x8
	// Position of ADD field.
	LCDC_HEOIER_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_HEOIER_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_HEOIER_ADD = 0x10
	// Position of DONE field.
	LCDC_HEOIER_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_HEOIER_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_HEOIER_DONE = 0x20
	// Position of OVR field.
	LCDC_HEOIER_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_HEOIER_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_HEOIER_OVR = 0x40
	// Position of UDMA field.
	LCDC_HEOIER_UDMA_Pos = 0xa
	// Bit mask of UDMA field.
	LCDC_HEOIER_UDMA_Msk = 0x400
	// Bit UDMA.
	LCDC_HEOIER_UDMA = 0x400
	// Position of UDSCR field.
	LCDC_HEOIER_UDSCR_Pos = 0xb
	// Bit mask of UDSCR field.
	LCDC_HEOIER_UDSCR_Msk = 0x800
	// Bit UDSCR.
	LCDC_HEOIER_UDSCR = 0x800
	// Position of UADD field.
	LCDC_HEOIER_UADD_Pos = 0xc
	// Bit mask of UADD field.
	LCDC_HEOIER_UADD_Msk = 0x1000
	// Bit UADD.
	LCDC_HEOIER_UADD = 0x1000
	// Position of UDONE field.
	LCDC_HEOIER_UDONE_Pos = 0xd
	// Bit mask of UDONE field.
	LCDC_HEOIER_UDONE_Msk = 0x2000
	// Bit UDONE.
	LCDC_HEOIER_UDONE = 0x2000
	// Position of UOVR field.
	LCDC_HEOIER_UOVR_Pos = 0xe
	// Bit mask of UOVR field.
	LCDC_HEOIER_UOVR_Msk = 0x4000
	// Bit UOVR.
	LCDC_HEOIER_UOVR = 0x4000
	// Position of VDMA field.
	LCDC_HEOIER_VDMA_Pos = 0x12
	// Bit mask of VDMA field.
	LCDC_HEOIER_VDMA_Msk = 0x40000
	// Bit VDMA.
	LCDC_HEOIER_VDMA = 0x40000
	// Position of VDSCR field.
	LCDC_HEOIER_VDSCR_Pos = 0x13
	// Bit mask of VDSCR field.
	LCDC_HEOIER_VDSCR_Msk = 0x80000
	// Bit VDSCR.
	LCDC_HEOIER_VDSCR = 0x80000
	// Position of VADD field.
	LCDC_HEOIER_VADD_Pos = 0x14
	// Bit mask of VADD field.
	LCDC_HEOIER_VADD_Msk = 0x100000
	// Bit VADD.
	LCDC_HEOIER_VADD = 0x100000
	// Position of VDONE field.
	LCDC_HEOIER_VDONE_Pos = 0x15
	// Bit mask of VDONE field.
	LCDC_HEOIER_VDONE_Msk = 0x200000
	// Bit VDONE.
	LCDC_HEOIER_VDONE = 0x200000
	// Position of VOVR field.
	LCDC_HEOIER_VOVR_Pos = 0x16
	// Bit mask of VOVR field.
	LCDC_HEOIER_VOVR_Msk = 0x400000
	// Bit VOVR.
	LCDC_HEOIER_VOVR = 0x400000

	// HEOIDR: High-End Overlay Interrupt Disable Register
	// Position of DMA field.
	LCDC_HEOIDR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_HEOIDR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_HEOIDR_DMA = 0x4
	// Position of DSCR field.
	LCDC_HEOIDR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_HEOIDR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_HEOIDR_DSCR = 0x8
	// Position of ADD field.
	LCDC_HEOIDR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_HEOIDR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_HEOIDR_ADD = 0x10
	// Position of DONE field.
	LCDC_HEOIDR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_HEOIDR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_HEOIDR_DONE = 0x20
	// Position of OVR field.
	LCDC_HEOIDR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_HEOIDR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_HEOIDR_OVR = 0x40
	// Position of UDMA field.
	LCDC_HEOIDR_UDMA_Pos = 0xa
	// Bit mask of UDMA field.
	LCDC_HEOIDR_UDMA_Msk = 0x400
	// Bit UDMA.
	LCDC_HEOIDR_UDMA = 0x400
	// Position of UDSCR field.
	LCDC_HEOIDR_UDSCR_Pos = 0xb
	// Bit mask of UDSCR field.
	LCDC_HEOIDR_UDSCR_Msk = 0x800
	// Bit UDSCR.
	LCDC_HEOIDR_UDSCR = 0x800
	// Position of UADD field.
	LCDC_HEOIDR_UADD_Pos = 0xc
	// Bit mask of UADD field.
	LCDC_HEOIDR_UADD_Msk = 0x1000
	// Bit UADD.
	LCDC_HEOIDR_UADD = 0x1000
	// Position of UDONE field.
	LCDC_HEOIDR_UDONE_Pos = 0xd
	// Bit mask of UDONE field.
	LCDC_HEOIDR_UDONE_Msk = 0x2000
	// Bit UDONE.
	LCDC_HEOIDR_UDONE = 0x2000
	// Position of UOVR field.
	LCDC_HEOIDR_UOVR_Pos = 0xe
	// Bit mask of UOVR field.
	LCDC_HEOIDR_UOVR_Msk = 0x4000
	// Bit UOVR.
	LCDC_HEOIDR_UOVR = 0x4000
	// Position of VDMA field.
	LCDC_HEOIDR_VDMA_Pos = 0x12
	// Bit mask of VDMA field.
	LCDC_HEOIDR_VDMA_Msk = 0x40000
	// Bit VDMA.
	LCDC_HEOIDR_VDMA = 0x40000
	// Position of VDSCR field.
	LCDC_HEOIDR_VDSCR_Pos = 0x13
	// Bit mask of VDSCR field.
	LCDC_HEOIDR_VDSCR_Msk = 0x80000
	// Bit VDSCR.
	LCDC_HEOIDR_VDSCR = 0x80000
	// Position of VADD field.
	LCDC_HEOIDR_VADD_Pos = 0x14
	// Bit mask of VADD field.
	LCDC_HEOIDR_VADD_Msk = 0x100000
	// Bit VADD.
	LCDC_HEOIDR_VADD = 0x100000
	// Position of VDONE field.
	LCDC_HEOIDR_VDONE_Pos = 0x15
	// Bit mask of VDONE field.
	LCDC_HEOIDR_VDONE_Msk = 0x200000
	// Bit VDONE.
	LCDC_HEOIDR_VDONE = 0x200000
	// Position of VOVR field.
	LCDC_HEOIDR_VOVR_Pos = 0x16
	// Bit mask of VOVR field.
	LCDC_HEOIDR_VOVR_Msk = 0x400000
	// Bit VOVR.
	LCDC_HEOIDR_VOVR = 0x400000

	// HEOIMR: High-End Overlay Interrupt Mask Register
	// Position of DMA field.
	LCDC_HEOIMR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_HEOIMR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_HEOIMR_DMA = 0x4
	// Position of DSCR field.
	LCDC_HEOIMR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_HEOIMR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_HEOIMR_DSCR = 0x8
	// Position of ADD field.
	LCDC_HEOIMR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_HEOIMR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_HEOIMR_ADD = 0x10
	// Position of DONE field.
	LCDC_HEOIMR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_HEOIMR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_HEOIMR_DONE = 0x20
	// Position of OVR field.
	LCDC_HEOIMR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_HEOIMR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_HEOIMR_OVR = 0x40
	// Position of UDMA field.
	LCDC_HEOIMR_UDMA_Pos = 0xa
	// Bit mask of UDMA field.
	LCDC_HEOIMR_UDMA_Msk = 0x400
	// Bit UDMA.
	LCDC_HEOIMR_UDMA = 0x400
	// Position of UDSCR field.
	LCDC_HEOIMR_UDSCR_Pos = 0xb
	// Bit mask of UDSCR field.
	LCDC_HEOIMR_UDSCR_Msk = 0x800
	// Bit UDSCR.
	LCDC_HEOIMR_UDSCR = 0x800
	// Position of UADD field.
	LCDC_HEOIMR_UADD_Pos = 0xc
	// Bit mask of UADD field.
	LCDC_HEOIMR_UADD_Msk = 0x1000
	// Bit UADD.
	LCDC_HEOIMR_UADD = 0x1000
	// Position of UDONE field.
	LCDC_HEOIMR_UDONE_Pos = 0xd
	// Bit mask of UDONE field.
	LCDC_HEOIMR_UDONE_Msk = 0x2000
	// Bit UDONE.
	LCDC_HEOIMR_UDONE = 0x2000
	// Position of UOVR field.
	LCDC_HEOIMR_UOVR_Pos = 0xe
	// Bit mask of UOVR field.
	LCDC_HEOIMR_UOVR_Msk = 0x4000
	// Bit UOVR.
	LCDC_HEOIMR_UOVR = 0x4000
	// Position of VDMA field.
	LCDC_HEOIMR_VDMA_Pos = 0x12
	// Bit mask of VDMA field.
	LCDC_HEOIMR_VDMA_Msk = 0x40000
	// Bit VDMA.
	LCDC_HEOIMR_VDMA = 0x40000
	// Position of VDSCR field.
	LCDC_HEOIMR_VDSCR_Pos = 0x13
	// Bit mask of VDSCR field.
	LCDC_HEOIMR_VDSCR_Msk = 0x80000
	// Bit VDSCR.
	LCDC_HEOIMR_VDSCR = 0x80000
	// Position of VADD field.
	LCDC_HEOIMR_VADD_Pos = 0x14
	// Bit mask of VADD field.
	LCDC_HEOIMR_VADD_Msk = 0x100000
	// Bit VADD.
	LCDC_HEOIMR_VADD = 0x100000
	// Position of VDONE field.
	LCDC_HEOIMR_VDONE_Pos = 0x15
	// Bit mask of VDONE field.
	LCDC_HEOIMR_VDONE_Msk = 0x200000
	// Bit VDONE.
	LCDC_HEOIMR_VDONE = 0x200000
	// Position of VOVR field.
	LCDC_HEOIMR_VOVR_Pos = 0x16
	// Bit mask of VOVR field.
	LCDC_HEOIMR_VOVR_Msk = 0x400000
	// Bit VOVR.
	LCDC_HEOIMR_VOVR = 0x400000

	// HEOISR: High-End Overlay Interrupt Status Register
	// Position of DMA field.
	LCDC_HEOISR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_HEOISR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_HEOISR_DMA = 0x4
	// Position of DSCR field.
	LCDC_HEOISR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_HEOISR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_HEOISR_DSCR = 0x8
	// Position of ADD field.
	LCDC_HEOISR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_HEOISR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_HEOISR_ADD = 0x10
	// Position of DONE field.
	LCDC_HEOISR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_HEOISR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_HEOISR_DONE = 0x20
	// Position of OVR field.
	LCDC_HEOISR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_HEOISR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_HEOISR_OVR = 0x40
	// Position of UDMA field.
	LCDC_HEOISR_UDMA_Pos = 0xa
	// Bit mask of UDMA field.
	LCDC_HEOISR_UDMA_Msk = 0x400
	// Bit UDMA.
	LCDC_HEOISR_UDMA = 0x400
	// Position of UDSCR field.
	LCDC_HEOISR_UDSCR_Pos = 0xb
	// Bit mask of UDSCR field.
	LCDC_HEOISR_UDSCR_Msk = 0x800
	// Bit UDSCR.
	LCDC_HEOISR_UDSCR = 0x800
	// Position of UADD field.
	LCDC_HEOISR_UADD_Pos = 0xc
	// Bit mask of UADD field.
	LCDC_HEOISR_UADD_Msk = 0x1000
	// Bit UADD.
	LCDC_HEOISR_UADD = 0x1000
	// Position of UDONE field.
	LCDC_HEOISR_UDONE_Pos = 0xd
	// Bit mask of UDONE field.
	LCDC_HEOISR_UDONE_Msk = 0x2000
	// Bit UDONE.
	LCDC_HEOISR_UDONE = 0x2000
	// Position of UOVR field.
	LCDC_HEOISR_UOVR_Pos = 0xe
	// Bit mask of UOVR field.
	LCDC_HEOISR_UOVR_Msk = 0x4000
	// Bit UOVR.
	LCDC_HEOISR_UOVR = 0x4000
	// Position of VDMA field.
	LCDC_HEOISR_VDMA_Pos = 0x12
	// Bit mask of VDMA field.
	LCDC_HEOISR_VDMA_Msk = 0x40000
	// Bit VDMA.
	LCDC_HEOISR_VDMA = 0x40000
	// Position of VDSCR field.
	LCDC_HEOISR_VDSCR_Pos = 0x13
	// Bit mask of VDSCR field.
	LCDC_HEOISR_VDSCR_Msk = 0x80000
	// Bit VDSCR.
	LCDC_HEOISR_VDSCR = 0x80000
	// Position of VADD field.
	LCDC_HEOISR_VADD_Pos = 0x14
	// Bit mask of VADD field.
	LCDC_HEOISR_VADD_Msk = 0x100000
	// Bit VADD.
	LCDC_HEOISR_VADD = 0x100000
	// Position of VDONE field.
	LCDC_HEOISR_VDONE_Pos = 0x15
	// Bit mask of VDONE field.
	LCDC_HEOISR_VDONE_Msk = 0x200000
	// Bit VDONE.
	LCDC_HEOISR_VDONE = 0x200000
	// Position of VOVR field.
	LCDC_HEOISR_VOVR_Pos = 0x16
	// Bit mask of VOVR field.
	LCDC_HEOISR_VOVR_Msk = 0x400000
	// Bit VOVR.
	LCDC_HEOISR_VOVR = 0x400000

	// HEOHEAD: High-End Overlay DMA Head Register
	// Position of HEAD field.
	LCDC_HEOHEAD_HEAD_Pos = 0x2
	// Bit mask of HEAD field.
	LCDC_HEOHEAD_HEAD_Msk = 0xfffffffc

	// HEOADDR: High-End Overlay DMA Address Register
	// Position of ADDR field.
	LCDC_HEOADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	LCDC_HEOADDR_ADDR_Msk = 0xffffffff

	// HEOCTRL: High-End Overlay DMA Control Register
	// Position of DFETCH field.
	LCDC_HEOCTRL_DFETCH_Pos = 0x0
	// Bit mask of DFETCH field.
	LCDC_HEOCTRL_DFETCH_Msk = 0x1
	// Bit DFETCH.
	LCDC_HEOCTRL_DFETCH = 0x1
	// Position of LFETCH field.
	LCDC_HEOCTRL_LFETCH_Pos = 0x1
	// Bit mask of LFETCH field.
	LCDC_HEOCTRL_LFETCH_Msk = 0x2
	// Bit LFETCH.
	LCDC_HEOCTRL_LFETCH = 0x2
	// Position of DMAIEN field.
	LCDC_HEOCTRL_DMAIEN_Pos = 0x2
	// Bit mask of DMAIEN field.
	LCDC_HEOCTRL_DMAIEN_Msk = 0x4
	// Bit DMAIEN.
	LCDC_HEOCTRL_DMAIEN = 0x4
	// Position of DSCRIEN field.
	LCDC_HEOCTRL_DSCRIEN_Pos = 0x3
	// Bit mask of DSCRIEN field.
	LCDC_HEOCTRL_DSCRIEN_Msk = 0x8
	// Bit DSCRIEN.
	LCDC_HEOCTRL_DSCRIEN = 0x8
	// Position of ADDIEN field.
	LCDC_HEOCTRL_ADDIEN_Pos = 0x4
	// Bit mask of ADDIEN field.
	LCDC_HEOCTRL_ADDIEN_Msk = 0x10
	// Bit ADDIEN.
	LCDC_HEOCTRL_ADDIEN = 0x10
	// Position of DONEIEN field.
	LCDC_HEOCTRL_DONEIEN_Pos = 0x5
	// Bit mask of DONEIEN field.
	LCDC_HEOCTRL_DONEIEN_Msk = 0x20
	// Bit DONEIEN.
	LCDC_HEOCTRL_DONEIEN = 0x20

	// HEONEXT: High-End Overlay DMA Next Register
	// Position of NEXT field.
	LCDC_HEONEXT_NEXT_Pos = 0x0
	// Bit mask of NEXT field.
	LCDC_HEONEXT_NEXT_Msk = 0xffffffff

	// HEOUHEAD: High-End Overlay U DMA Head Register
	// Position of UHEAD field.
	LCDC_HEOUHEAD_UHEAD_Pos = 0x0
	// Bit mask of UHEAD field.
	LCDC_HEOUHEAD_UHEAD_Msk = 0xffffffff

	// HEOUADDR: High-End Overlay U DMA Address Register
	// Position of UADDR field.
	LCDC_HEOUADDR_UADDR_Pos = 0x0
	// Bit mask of UADDR field.
	LCDC_HEOUADDR_UADDR_Msk = 0xffffffff

	// HEOUCTRL: High-End Overlay U DMA control Register
	// Position of UDFETCH field.
	LCDC_HEOUCTRL_UDFETCH_Pos = 0x0
	// Bit mask of UDFETCH field.
	LCDC_HEOUCTRL_UDFETCH_Msk = 0x1
	// Bit UDFETCH.
	LCDC_HEOUCTRL_UDFETCH = 0x1
	// Position of UDMAIEN field.
	LCDC_HEOUCTRL_UDMAIEN_Pos = 0x2
	// Bit mask of UDMAIEN field.
	LCDC_HEOUCTRL_UDMAIEN_Msk = 0x4
	// Bit UDMAIEN.
	LCDC_HEOUCTRL_UDMAIEN = 0x4
	// Position of UDSCRIEN field.
	LCDC_HEOUCTRL_UDSCRIEN_Pos = 0x3
	// Bit mask of UDSCRIEN field.
	LCDC_HEOUCTRL_UDSCRIEN_Msk = 0x8
	// Bit UDSCRIEN.
	LCDC_HEOUCTRL_UDSCRIEN = 0x8
	// Position of UADDIEN field.
	LCDC_HEOUCTRL_UADDIEN_Pos = 0x4
	// Bit mask of UADDIEN field.
	LCDC_HEOUCTRL_UADDIEN_Msk = 0x10
	// Bit UADDIEN.
	LCDC_HEOUCTRL_UADDIEN = 0x10
	// Position of UDONEIEN field.
	LCDC_HEOUCTRL_UDONEIEN_Pos = 0x5
	// Bit mask of UDONEIEN field.
	LCDC_HEOUCTRL_UDONEIEN_Msk = 0x20
	// Bit UDONEIEN.
	LCDC_HEOUCTRL_UDONEIEN = 0x20

	// HEOUNEXT: High-End Overlay U DMA Next Register
	// Position of UNEXT field.
	LCDC_HEOUNEXT_UNEXT_Pos = 0x0
	// Bit mask of UNEXT field.
	LCDC_HEOUNEXT_UNEXT_Msk = 0xffffffff

	// HEOVHEAD: High-End Overlay V DMA Head Register
	// Position of VHEAD field.
	LCDC_HEOVHEAD_VHEAD_Pos = 0x0
	// Bit mask of VHEAD field.
	LCDC_HEOVHEAD_VHEAD_Msk = 0xffffffff

	// HEOVADDR: High-End Overlay V DMA Address Register
	// Position of VADDR field.
	LCDC_HEOVADDR_VADDR_Pos = 0x0
	// Bit mask of VADDR field.
	LCDC_HEOVADDR_VADDR_Msk = 0xffffffff

	// HEOVCTRL: High-End Overlay V DMA control Register
	// Position of VDFETCH field.
	LCDC_HEOVCTRL_VDFETCH_Pos = 0x0
	// Bit mask of VDFETCH field.
	LCDC_HEOVCTRL_VDFETCH_Msk = 0x1
	// Bit VDFETCH.
	LCDC_HEOVCTRL_VDFETCH = 0x1
	// Position of VDMAIEN field.
	LCDC_HEOVCTRL_VDMAIEN_Pos = 0x2
	// Bit mask of VDMAIEN field.
	LCDC_HEOVCTRL_VDMAIEN_Msk = 0x4
	// Bit VDMAIEN.
	LCDC_HEOVCTRL_VDMAIEN = 0x4
	// Position of VDSCRIEN field.
	LCDC_HEOVCTRL_VDSCRIEN_Pos = 0x3
	// Bit mask of VDSCRIEN field.
	LCDC_HEOVCTRL_VDSCRIEN_Msk = 0x8
	// Bit VDSCRIEN.
	LCDC_HEOVCTRL_VDSCRIEN = 0x8
	// Position of VADDIEN field.
	LCDC_HEOVCTRL_VADDIEN_Pos = 0x4
	// Bit mask of VADDIEN field.
	LCDC_HEOVCTRL_VADDIEN_Msk = 0x10
	// Bit VADDIEN.
	LCDC_HEOVCTRL_VADDIEN = 0x10
	// Position of VDONEIEN field.
	LCDC_HEOVCTRL_VDONEIEN_Pos = 0x5
	// Bit mask of VDONEIEN field.
	LCDC_HEOVCTRL_VDONEIEN_Msk = 0x20
	// Bit VDONEIEN.
	LCDC_HEOVCTRL_VDONEIEN = 0x20

	// HEOVNEXT: High-End Overlay VDMA Next Register
	// Position of VNEXT field.
	LCDC_HEOVNEXT_VNEXT_Pos = 0x0
	// Bit mask of VNEXT field.
	LCDC_HEOVNEXT_VNEXT_Msk = 0xffffffff

	// HEOCFG0: High-End Overlay Configuration Register 0
	// Position of SIF field.
	LCDC_HEOCFG0_SIF_Pos = 0x0
	// Bit mask of SIF field.
	LCDC_HEOCFG0_SIF_Msk = 0x1
	// Bit SIF.
	LCDC_HEOCFG0_SIF = 0x1
	// Position of BLEN field.
	LCDC_HEOCFG0_BLEN_Pos = 0x4
	// Bit mask of BLEN field.
	LCDC_HEOCFG0_BLEN_Msk = 0x30
	// AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLEN_AHB_BLEN_SINGLE = 0x0
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLEN_AHB_BLEN_INCR4 = 0x1
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLEN_AHB_BLEN_INCR8 = 0x2
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLEN_AHB_BLEN_INCR16 = 0x3
	// Position of BLENUV field.
	LCDC_HEOCFG0_BLENUV_Pos = 0x6
	// Bit mask of BLENUV field.
	LCDC_HEOCFG0_BLENUV_Msk = 0xc0
	// AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLENUV_AHB_SINGLE = 0x0
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLENUV_AHB_INCR4 = 0x1
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLENUV_AHB_INCR8 = 0x2
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLENUV_AHB_INCR16 = 0x3
	// Position of DLBO field.
	LCDC_HEOCFG0_DLBO_Pos = 0x8
	// Bit mask of DLBO field.
	LCDC_HEOCFG0_DLBO_Msk = 0x100
	// Bit DLBO.
	LCDC_HEOCFG0_DLBO = 0x100
	// Position of ROTDIS field.
	LCDC_HEOCFG0_ROTDIS_Pos = 0xc
	// Bit mask of ROTDIS field.
	LCDC_HEOCFG0_ROTDIS_Msk = 0x1000
	// Bit ROTDIS.
	LCDC_HEOCFG0_ROTDIS = 0x1000
	// Position of LOCKDIS field.
	LCDC_HEOCFG0_LOCKDIS_Pos = 0xd
	// Bit mask of LOCKDIS field.
	LCDC_HEOCFG0_LOCKDIS_Msk = 0x2000
	// Bit LOCKDIS.
	LCDC_HEOCFG0_LOCKDIS = 0x2000

	// HEOCFG1: High-End Overlay Configuration Register 1
	// Position of CLUTEN field.
	LCDC_HEOCFG1_CLUTEN_Pos = 0x0
	// Bit mask of CLUTEN field.
	LCDC_HEOCFG1_CLUTEN_Msk = 0x1
	// Bit CLUTEN.
	LCDC_HEOCFG1_CLUTEN = 0x1
	// Position of YUVEN field.
	LCDC_HEOCFG1_YUVEN_Pos = 0x1
	// Bit mask of YUVEN field.
	LCDC_HEOCFG1_YUVEN_Msk = 0x2
	// Bit YUVEN.
	LCDC_HEOCFG1_YUVEN = 0x2
	// Position of RGBMODE field.
	LCDC_HEOCFG1_RGBMODE_Pos = 0x4
	// Bit mask of RGBMODE field.
	LCDC_HEOCFG1_RGBMODE_Msk = 0xf0
	// 12 bpp RGB 444
	LCDC_HEOCFG1_RGBMODE_12BPP_RGB_444 = 0x0
	// 16 bpp ARGB 4444
	LCDC_HEOCFG1_RGBMODE_16BPP_ARGB_4444 = 0x1
	// 16 bpp RGBA 4444
	LCDC_HEOCFG1_RGBMODE_16BPP_RGBA_4444 = 0x2
	// 16 bpp RGB 565
	LCDC_HEOCFG1_RGBMODE_16BPP_RGB_565 = 0x3
	// 16 bpp TRGB 1555
	LCDC_HEOCFG1_RGBMODE_16BPP_TRGB_1555 = 0x4
	// 18 bpp RGB 666
	LCDC_HEOCFG1_RGBMODE_18BPP_RGB_666 = 0x5
	// 18 bpp RGB 666 PACKED
	LCDC_HEOCFG1_RGBMODE_18BPP_RGB_666PACKED = 0x6
	// 19 bpp TRGB 1666
	LCDC_HEOCFG1_RGBMODE_19BPP_TRGB_1666 = 0x7
	// 19 bpp TRGB 1666 PACKED
	LCDC_HEOCFG1_RGBMODE_19BPP_TRGB_PACKED = 0x8
	// 24 bpp RGB 888
	LCDC_HEOCFG1_RGBMODE_24BPP_RGB_888 = 0x9
	// 24 bpp RGB 888 PACKED
	LCDC_HEOCFG1_RGBMODE_24BPP_RGB_888_PACKED = 0xa
	// 25 bpp TRGB 1888
	LCDC_HEOCFG1_RGBMODE_25BPP_TRGB_1888 = 0xb
	// 32 bpp ARGB 8888
	LCDC_HEOCFG1_RGBMODE_32BPP_ARGB_8888 = 0xc
	// 32 bpp RGBA 8888
	LCDC_HEOCFG1_RGBMODE_32BPP_RGBA_8888 = 0xd
	// Position of CLUTMODE field.
	LCDC_HEOCFG1_CLUTMODE_Pos = 0x8
	// Bit mask of CLUTMODE field.
	LCDC_HEOCFG1_CLUTMODE_Msk = 0x300
	// color lookup table mode set to 1 bit per pixel
	LCDC_HEOCFG1_CLUTMODE_CLUT_1BPP = 0x0
	// color lookup table mode set to 2 bits per pixel
	LCDC_HEOCFG1_CLUTMODE_CLUT_2BPP = 0x1
	// color lookup table mode set to 4 bits per pixel
	LCDC_HEOCFG1_CLUTMODE_CLUT_4BPP = 0x2
	// color lookup table mode set to 8 bits per pixel
	LCDC_HEOCFG1_CLUTMODE_CLUT_8BPP = 0x3
	// Position of YUVMODE field.
	LCDC_HEOCFG1_YUVMODE_Pos = 0xc
	// Bit mask of YUVMODE field.
	LCDC_HEOCFG1_YUVMODE_Msk = 0xf000
	// 32 bpp AYCbCr 444
	LCDC_HEOCFG1_YUVMODE_32BPP_AYCBCR = 0x0
	// 16 bpp Cr(n)Y(n+1)Cb(n)Y(n) 422
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE0 = 0x1
	// 16 bpp Y(n+1)Cr(n)Y(n)Cb(n) 422
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE1 = 0x2
	// 16 bpp Cb(n)Y(+1)Cr(n)Y(n) 422
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE2 = 0x3
	// 16 bpp Y(n+1)Cb(n)Y(n)Cr(n) 422
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE3 = 0x4
	// 16 bpp Semiplanar 422 YCbCr
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_SEMIPLANAR = 0x5
	// 16 bpp Planar 422 YCbCr
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_PLANAR = 0x6
	// 12 bpp Semiplanar 420 YCbCr
	LCDC_HEOCFG1_YUVMODE_12BPP_YCBCR_SEMIPLANAR = 0x7
	// 12 bpp Planar 420 YCbCr
	LCDC_HEOCFG1_YUVMODE_12BPP_YCBCR_PLANAR = 0x8
	// Position of YUV422ROT field.
	LCDC_HEOCFG1_YUV422ROT_Pos = 0x10
	// Bit mask of YUV422ROT field.
	LCDC_HEOCFG1_YUV422ROT_Msk = 0x10000
	// Bit YUV422ROT.
	LCDC_HEOCFG1_YUV422ROT = 0x10000
	// Position of YUV422SWP field.
	LCDC_HEOCFG1_YUV422SWP_Pos = 0x11
	// Bit mask of YUV422SWP field.
	LCDC_HEOCFG1_YUV422SWP_Msk = 0x20000
	// Bit YUV422SWP.
	LCDC_HEOCFG1_YUV422SWP = 0x20000
	// Position of DSCALEOPT field.
	LCDC_HEOCFG1_DSCALEOPT_Pos = 0x14
	// Bit mask of DSCALEOPT field.
	LCDC_HEOCFG1_DSCALEOPT_Msk = 0x100000
	// Bit DSCALEOPT.
	LCDC_HEOCFG1_DSCALEOPT = 0x100000

	// HEOCFG2: High-End Overlay Configuration Register 2
	// Position of XPOS field.
	LCDC_HEOCFG2_XPOS_Pos = 0x0
	// Bit mask of XPOS field.
	LCDC_HEOCFG2_XPOS_Msk = 0x7ff
	// Position of YPOS field.
	LCDC_HEOCFG2_YPOS_Pos = 0x10
	// Bit mask of YPOS field.
	LCDC_HEOCFG2_YPOS_Msk = 0x7ff0000

	// HEOCFG3: High-End Overlay Configuration Register 3
	// Position of XSIZE field.
	LCDC_HEOCFG3_XSIZE_Pos = 0x0
	// Bit mask of XSIZE field.
	LCDC_HEOCFG3_XSIZE_Msk = 0x7ff
	// Position of YSIZE field.
	LCDC_HEOCFG3_YSIZE_Pos = 0x10
	// Bit mask of YSIZE field.
	LCDC_HEOCFG3_YSIZE_Msk = 0x7ff0000

	// HEOCFG4: High-End Overlay Configuration Register 4
	// Position of XMEMSIZE field.
	LCDC_HEOCFG4_XMEMSIZE_Pos = 0x0
	// Bit mask of XMEMSIZE field.
	LCDC_HEOCFG4_XMEMSIZE_Msk = 0x7ff
	// Position of YMEMSIZE field.
	LCDC_HEOCFG4_YMEMSIZE_Pos = 0x10
	// Bit mask of YMEMSIZE field.
	LCDC_HEOCFG4_YMEMSIZE_Msk = 0x7ff0000

	// HEOCFG5: High-End Overlay Configuration Register 5
	// Position of XSTRIDE field.
	LCDC_HEOCFG5_XSTRIDE_Pos = 0x0
	// Bit mask of XSTRIDE field.
	LCDC_HEOCFG5_XSTRIDE_Msk = 0xffffffff

	// HEOCFG6: High-End Overlay Configuration Register 6
	// Position of PSTRIDE field.
	LCDC_HEOCFG6_PSTRIDE_Pos = 0x0
	// Bit mask of PSTRIDE field.
	LCDC_HEOCFG6_PSTRIDE_Msk = 0xffffffff

	// HEOCFG7: High-End Overlay Configuration Register 7
	// Position of UVXSTRIDE field.
	LCDC_HEOCFG7_UVXSTRIDE_Pos = 0x0
	// Bit mask of UVXSTRIDE field.
	LCDC_HEOCFG7_UVXSTRIDE_Msk = 0xffffffff

	// HEOCFG8: High-End Overlay Configuration Register 8
	// Position of UVPSTRIDE field.
	LCDC_HEOCFG8_UVPSTRIDE_Pos = 0x0
	// Bit mask of UVPSTRIDE field.
	LCDC_HEOCFG8_UVPSTRIDE_Msk = 0xffffffff

	// HEOCFG9: High-End Overlay Configuration Register 9
	// Position of BDEF field.
	LCDC_HEOCFG9_BDEF_Pos = 0x0
	// Bit mask of BDEF field.
	LCDC_HEOCFG9_BDEF_Msk = 0xff
	// Position of GDEF field.
	LCDC_HEOCFG9_GDEF_Pos = 0x8
	// Bit mask of GDEF field.
	LCDC_HEOCFG9_GDEF_Msk = 0xff00
	// Position of RDEF field.
	LCDC_HEOCFG9_RDEF_Pos = 0x10
	// Bit mask of RDEF field.
	LCDC_HEOCFG9_RDEF_Msk = 0xff0000

	// HEOCFG10: High-End Overlay Configuration Register 10
	// Position of BKEY field.
	LCDC_HEOCFG10_BKEY_Pos = 0x0
	// Bit mask of BKEY field.
	LCDC_HEOCFG10_BKEY_Msk = 0xff
	// Position of GKEY field.
	LCDC_HEOCFG10_GKEY_Pos = 0x8
	// Bit mask of GKEY field.
	LCDC_HEOCFG10_GKEY_Msk = 0xff00
	// Position of RKEY field.
	LCDC_HEOCFG10_RKEY_Pos = 0x10
	// Bit mask of RKEY field.
	LCDC_HEOCFG10_RKEY_Msk = 0xff0000

	// HEOCFG11: High-End Overlay Configuration Register 11
	// Position of BMASK field.
	LCDC_HEOCFG11_BMASK_Pos = 0x0
	// Bit mask of BMASK field.
	LCDC_HEOCFG11_BMASK_Msk = 0xff
	// Position of GMASK field.
	LCDC_HEOCFG11_GMASK_Pos = 0x8
	// Bit mask of GMASK field.
	LCDC_HEOCFG11_GMASK_Msk = 0xff00
	// Position of RMASK field.
	LCDC_HEOCFG11_RMASK_Pos = 0x10
	// Bit mask of RMASK field.
	LCDC_HEOCFG11_RMASK_Msk = 0xff0000

	// HEOCFG12: High-End Overlay Configuration Register 12
	// Position of CRKEY field.
	LCDC_HEOCFG12_CRKEY_Pos = 0x0
	// Bit mask of CRKEY field.
	LCDC_HEOCFG12_CRKEY_Msk = 0x1
	// Bit CRKEY.
	LCDC_HEOCFG12_CRKEY = 0x1
	// Position of INV field.
	LCDC_HEOCFG12_INV_Pos = 0x1
	// Bit mask of INV field.
	LCDC_HEOCFG12_INV_Msk = 0x2
	// Bit INV.
	LCDC_HEOCFG12_INV = 0x2
	// Position of ITER2BL field.
	LCDC_HEOCFG12_ITER2BL_Pos = 0x2
	// Bit mask of ITER2BL field.
	LCDC_HEOCFG12_ITER2BL_Msk = 0x4
	// Bit ITER2BL.
	LCDC_HEOCFG12_ITER2BL = 0x4
	// Position of ITER field.
	LCDC_HEOCFG12_ITER_Pos = 0x3
	// Bit mask of ITER field.
	LCDC_HEOCFG12_ITER_Msk = 0x8
	// Bit ITER.
	LCDC_HEOCFG12_ITER = 0x8
	// Position of REVALPHA field.
	LCDC_HEOCFG12_REVALPHA_Pos = 0x4
	// Bit mask of REVALPHA field.
	LCDC_HEOCFG12_REVALPHA_Msk = 0x10
	// Bit REVALPHA.
	LCDC_HEOCFG12_REVALPHA = 0x10
	// Position of GAEN field.
	LCDC_HEOCFG12_GAEN_Pos = 0x5
	// Bit mask of GAEN field.
	LCDC_HEOCFG12_GAEN_Msk = 0x20
	// Bit GAEN.
	LCDC_HEOCFG12_GAEN = 0x20
	// Position of LAEN field.
	LCDC_HEOCFG12_LAEN_Pos = 0x6
	// Bit mask of LAEN field.
	LCDC_HEOCFG12_LAEN_Msk = 0x40
	// Bit LAEN.
	LCDC_HEOCFG12_LAEN = 0x40
	// Position of OVR field.
	LCDC_HEOCFG12_OVR_Pos = 0x7
	// Bit mask of OVR field.
	LCDC_HEOCFG12_OVR_Msk = 0x80
	// Bit OVR.
	LCDC_HEOCFG12_OVR = 0x80
	// Position of DMA field.
	LCDC_HEOCFG12_DMA_Pos = 0x8
	// Bit mask of DMA field.
	LCDC_HEOCFG12_DMA_Msk = 0x100
	// Bit DMA.
	LCDC_HEOCFG12_DMA = 0x100
	// Position of REP field.
	LCDC_HEOCFG12_REP_Pos = 0x9
	// Bit mask of REP field.
	LCDC_HEOCFG12_REP_Msk = 0x200
	// Bit REP.
	LCDC_HEOCFG12_REP = 0x200
	// Position of DSTKEY field.
	LCDC_HEOCFG12_DSTKEY_Pos = 0xa
	// Bit mask of DSTKEY field.
	LCDC_HEOCFG12_DSTKEY_Msk = 0x400
	// Bit DSTKEY.
	LCDC_HEOCFG12_DSTKEY = 0x400
	// Position of VIDPRI field.
	LCDC_HEOCFG12_VIDPRI_Pos = 0xc
	// Bit mask of VIDPRI field.
	LCDC_HEOCFG12_VIDPRI_Msk = 0x1000
	// Bit VIDPRI.
	LCDC_HEOCFG12_VIDPRI = 0x1000
	// Position of GA field.
	LCDC_HEOCFG12_GA_Pos = 0x10
	// Bit mask of GA field.
	LCDC_HEOCFG12_GA_Msk = 0xff0000

	// HEOCFG13: High-End Overlay Configuration Register 13
	// Position of XFACTOR field.
	LCDC_HEOCFG13_XFACTOR_Pos = 0x0
	// Bit mask of XFACTOR field.
	LCDC_HEOCFG13_XFACTOR_Msk = 0x3fff
	// Position of YFACTOR field.
	LCDC_HEOCFG13_YFACTOR_Pos = 0x10
	// Bit mask of YFACTOR field.
	LCDC_HEOCFG13_YFACTOR_Msk = 0x3fff0000
	// Position of SCALEN field.
	LCDC_HEOCFG13_SCALEN_Pos = 0x1f
	// Bit mask of SCALEN field.
	LCDC_HEOCFG13_SCALEN_Msk = 0x80000000
	// Bit SCALEN.
	LCDC_HEOCFG13_SCALEN = 0x80000000

	// HEOCFG14: High-End Overlay Configuration Register 14
	// Position of CSCRY field.
	LCDC_HEOCFG14_CSCRY_Pos = 0x0
	// Bit mask of CSCRY field.
	LCDC_HEOCFG14_CSCRY_Msk = 0x3ff
	// Position of CSCRU field.
	LCDC_HEOCFG14_CSCRU_Pos = 0xa
	// Bit mask of CSCRU field.
	LCDC_HEOCFG14_CSCRU_Msk = 0xffc00
	// Position of CSCRV field.
	LCDC_HEOCFG14_CSCRV_Pos = 0x14
	// Bit mask of CSCRV field.
	LCDC_HEOCFG14_CSCRV_Msk = 0x3ff00000
	// Position of CSCYOFF field.
	LCDC_HEOCFG14_CSCYOFF_Pos = 0x1e
	// Bit mask of CSCYOFF field.
	LCDC_HEOCFG14_CSCYOFF_Msk = 0x40000000
	// Bit CSCYOFF.
	LCDC_HEOCFG14_CSCYOFF = 0x40000000

	// HEOCFG15: High-End Overlay Configuration Register 15
	// Position of CSCGY field.
	LCDC_HEOCFG15_CSCGY_Pos = 0x0
	// Bit mask of CSCGY field.
	LCDC_HEOCFG15_CSCGY_Msk = 0x3ff
	// Position of CSCGU field.
	LCDC_HEOCFG15_CSCGU_Pos = 0xa
	// Bit mask of CSCGU field.
	LCDC_HEOCFG15_CSCGU_Msk = 0xffc00
	// Position of CSCGV field.
	LCDC_HEOCFG15_CSCGV_Pos = 0x14
	// Bit mask of CSCGV field.
	LCDC_HEOCFG15_CSCGV_Msk = 0x3ff00000
	// Position of CSCUOFF field.
	LCDC_HEOCFG15_CSCUOFF_Pos = 0x1e
	// Bit mask of CSCUOFF field.
	LCDC_HEOCFG15_CSCUOFF_Msk = 0x40000000
	// Bit CSCUOFF.
	LCDC_HEOCFG15_CSCUOFF = 0x40000000

	// HEOCFG16: High-End Overlay Configuration Register 16
	// Position of CSCBY field.
	LCDC_HEOCFG16_CSCBY_Pos = 0x0
	// Bit mask of CSCBY field.
	LCDC_HEOCFG16_CSCBY_Msk = 0x3ff
	// Position of CSCBU field.
	LCDC_HEOCFG16_CSCBU_Pos = 0xa
	// Bit mask of CSCBU field.
	LCDC_HEOCFG16_CSCBU_Msk = 0xffc00
	// Position of CSCBV field.
	LCDC_HEOCFG16_CSCBV_Pos = 0x14
	// Bit mask of CSCBV field.
	LCDC_HEOCFG16_CSCBV_Msk = 0x3ff00000
	// Position of CSCVOFF field.
	LCDC_HEOCFG16_CSCVOFF_Pos = 0x1e
	// Bit mask of CSCVOFF field.
	LCDC_HEOCFG16_CSCVOFF_Msk = 0x40000000
	// Bit CSCVOFF.
	LCDC_HEOCFG16_CSCVOFF = 0x40000000

	// HEOCFG17: High-End Overlay Configuration Register 17
	// Position of XPHI0COEFF0 field.
	LCDC_HEOCFG17_XPHI0COEFF0_Pos = 0x0
	// Bit mask of XPHI0COEFF0 field.
	LCDC_HEOCFG17_XPHI0COEFF0_Msk = 0xff
	// Position of XPHI0COEFF1 field.
	LCDC_HEOCFG17_XPHI0COEFF1_Pos = 0x8
	// Bit mask of XPHI0COEFF1 field.
	LCDC_HEOCFG17_XPHI0COEFF1_Msk = 0xff00
	// Position of XPHI0COEFF2 field.
	LCDC_HEOCFG17_XPHI0COEFF2_Pos = 0x10
	// Bit mask of XPHI0COEFF2 field.
	LCDC_HEOCFG17_XPHI0COEFF2_Msk = 0xff0000
	// Position of XPHI0COEFF3 field.
	LCDC_HEOCFG17_XPHI0COEFF3_Pos = 0x18
	// Bit mask of XPHI0COEFF3 field.
	LCDC_HEOCFG17_XPHI0COEFF3_Msk = 0xff000000

	// HEOCFG18: High-End Overlay Configuration Register 18
	// Position of XPHI0COEFF4 field.
	LCDC_HEOCFG18_XPHI0COEFF4_Pos = 0x0
	// Bit mask of XPHI0COEFF4 field.
	LCDC_HEOCFG18_XPHI0COEFF4_Msk = 0xff

	// HEOCFG19: High-End Overlay Configuration Register 19
	// Position of XPHI1COEFF0 field.
	LCDC_HEOCFG19_XPHI1COEFF0_Pos = 0x0
	// Bit mask of XPHI1COEFF0 field.
	LCDC_HEOCFG19_XPHI1COEFF0_Msk = 0xff
	// Position of XPHI1COEFF1 field.
	LCDC_HEOCFG19_XPHI1COEFF1_Pos = 0x8
	// Bit mask of XPHI1COEFF1 field.
	LCDC_HEOCFG19_XPHI1COEFF1_Msk = 0xff00
	// Position of XPHI1COEFF2 field.
	LCDC_HEOCFG19_XPHI1COEFF2_Pos = 0x10
	// Bit mask of XPHI1COEFF2 field.
	LCDC_HEOCFG19_XPHI1COEFF2_Msk = 0xff0000
	// Position of XPHI1COEFF3 field.
	LCDC_HEOCFG19_XPHI1COEFF3_Pos = 0x18
	// Bit mask of XPHI1COEFF3 field.
	LCDC_HEOCFG19_XPHI1COEFF3_Msk = 0xff000000

	// HEOCFG20: High-End Overlay Configuration Register 20
	// Position of XPHI1COEFF4 field.
	LCDC_HEOCFG20_XPHI1COEFF4_Pos = 0x0
	// Bit mask of XPHI1COEFF4 field.
	LCDC_HEOCFG20_XPHI1COEFF4_Msk = 0xff

	// HEOCFG21: High-End Overlay Configuration Register 21
	// Position of XPHI2COEFF0 field.
	LCDC_HEOCFG21_XPHI2COEFF0_Pos = 0x0
	// Bit mask of XPHI2COEFF0 field.
	LCDC_HEOCFG21_XPHI2COEFF0_Msk = 0xff
	// Position of XPHI2COEFF1 field.
	LCDC_HEOCFG21_XPHI2COEFF1_Pos = 0x8
	// Bit mask of XPHI2COEFF1 field.
	LCDC_HEOCFG21_XPHI2COEFF1_Msk = 0xff00
	// Position of XPHI2COEFF2 field.
	LCDC_HEOCFG21_XPHI2COEFF2_Pos = 0x10
	// Bit mask of XPHI2COEFF2 field.
	LCDC_HEOCFG21_XPHI2COEFF2_Msk = 0xff0000
	// Position of XPHI2COEFF3 field.
	LCDC_HEOCFG21_XPHI2COEFF3_Pos = 0x18
	// Bit mask of XPHI2COEFF3 field.
	LCDC_HEOCFG21_XPHI2COEFF3_Msk = 0xff000000

	// HEOCFG22: High-End Overlay Configuration Register 22
	// Position of XPHI2COEFF4 field.
	LCDC_HEOCFG22_XPHI2COEFF4_Pos = 0x0
	// Bit mask of XPHI2COEFF4 field.
	LCDC_HEOCFG22_XPHI2COEFF4_Msk = 0xff

	// HEOCFG23: High-End Overlay Configuration Register 23
	// Position of XPHI3COEFF0 field.
	LCDC_HEOCFG23_XPHI3COEFF0_Pos = 0x0
	// Bit mask of XPHI3COEFF0 field.
	LCDC_HEOCFG23_XPHI3COEFF0_Msk = 0xff
	// Position of XPHI3COEFF1 field.
	LCDC_HEOCFG23_XPHI3COEFF1_Pos = 0x8
	// Bit mask of XPHI3COEFF1 field.
	LCDC_HEOCFG23_XPHI3COEFF1_Msk = 0xff00
	// Position of XPHI3COEFF2 field.
	LCDC_HEOCFG23_XPHI3COEFF2_Pos = 0x10
	// Bit mask of XPHI3COEFF2 field.
	LCDC_HEOCFG23_XPHI3COEFF2_Msk = 0xff0000
	// Position of XPHI3COEFF3 field.
	LCDC_HEOCFG23_XPHI3COEFF3_Pos = 0x18
	// Bit mask of XPHI3COEFF3 field.
	LCDC_HEOCFG23_XPHI3COEFF3_Msk = 0xff000000

	// HEOCFG24: High-End Overlay Configuration Register 24
	// Position of XPHI3COEFF4 field.
	LCDC_HEOCFG24_XPHI3COEFF4_Pos = 0x0
	// Bit mask of XPHI3COEFF4 field.
	LCDC_HEOCFG24_XPHI3COEFF4_Msk = 0xff

	// HEOCFG25: High-End Overlay Configuration Register 25
	// Position of XPHI4COEFF0 field.
	LCDC_HEOCFG25_XPHI4COEFF0_Pos = 0x0
	// Bit mask of XPHI4COEFF0 field.
	LCDC_HEOCFG25_XPHI4COEFF0_Msk = 0xff
	// Position of XPHI4COEFF1 field.
	LCDC_HEOCFG25_XPHI4COEFF1_Pos = 0x8
	// Bit mask of XPHI4COEFF1 field.
	LCDC_HEOCFG25_XPHI4COEFF1_Msk = 0xff00
	// Position of XPHI4COEFF2 field.
	LCDC_HEOCFG25_XPHI4COEFF2_Pos = 0x10
	// Bit mask of XPHI4COEFF2 field.
	LCDC_HEOCFG25_XPHI4COEFF2_Msk = 0xff0000
	// Position of XPHI4COEFF3 field.
	LCDC_HEOCFG25_XPHI4COEFF3_Pos = 0x18
	// Bit mask of XPHI4COEFF3 field.
	LCDC_HEOCFG25_XPHI4COEFF3_Msk = 0xff000000

	// HEOCFG26: High-End Overlay Configuration Register 26
	// Position of XPHI4COEFF4 field.
	LCDC_HEOCFG26_XPHI4COEFF4_Pos = 0x0
	// Bit mask of XPHI4COEFF4 field.
	LCDC_HEOCFG26_XPHI4COEFF4_Msk = 0xff

	// HEOCFG27: High-End Overlay Configuration Register 27
	// Position of XPHI5COEFF0 field.
	LCDC_HEOCFG27_XPHI5COEFF0_Pos = 0x0
	// Bit mask of XPHI5COEFF0 field.
	LCDC_HEOCFG27_XPHI5COEFF0_Msk = 0xff
	// Position of XPHI5COEFF1 field.
	LCDC_HEOCFG27_XPHI5COEFF1_Pos = 0x8
	// Bit mask of XPHI5COEFF1 field.
	LCDC_HEOCFG27_XPHI5COEFF1_Msk = 0xff00
	// Position of XPHI5COEFF2 field.
	LCDC_HEOCFG27_XPHI5COEFF2_Pos = 0x10
	// Bit mask of XPHI5COEFF2 field.
	LCDC_HEOCFG27_XPHI5COEFF2_Msk = 0xff0000
	// Position of XPHI5COEFF3 field.
	LCDC_HEOCFG27_XPHI5COEFF3_Pos = 0x18
	// Bit mask of XPHI5COEFF3 field.
	LCDC_HEOCFG27_XPHI5COEFF3_Msk = 0xff000000

	// HEOCFG28: High-End Overlay Configuration Register 28
	// Position of XPHI5COEFF4 field.
	LCDC_HEOCFG28_XPHI5COEFF4_Pos = 0x0
	// Bit mask of XPHI5COEFF4 field.
	LCDC_HEOCFG28_XPHI5COEFF4_Msk = 0xff

	// HEOCFG29: High-End Overlay Configuration Register 29
	// Position of XPHI6COEFF0 field.
	LCDC_HEOCFG29_XPHI6COEFF0_Pos = 0x0
	// Bit mask of XPHI6COEFF0 field.
	LCDC_HEOCFG29_XPHI6COEFF0_Msk = 0xff
	// Position of XPHI6COEFF1 field.
	LCDC_HEOCFG29_XPHI6COEFF1_Pos = 0x8
	// Bit mask of XPHI6COEFF1 field.
	LCDC_HEOCFG29_XPHI6COEFF1_Msk = 0xff00
	// Position of XPHI6COEFF2 field.
	LCDC_HEOCFG29_XPHI6COEFF2_Pos = 0x10
	// Bit mask of XPHI6COEFF2 field.
	LCDC_HEOCFG29_XPHI6COEFF2_Msk = 0xff0000
	// Position of XPHI6COEFF3 field.
	LCDC_HEOCFG29_XPHI6COEFF3_Pos = 0x18
	// Bit mask of XPHI6COEFF3 field.
	LCDC_HEOCFG29_XPHI6COEFF3_Msk = 0xff000000

	// HEOCFG30: High-End Overlay Configuration Register 30
	// Position of XPHI6COEFF4 field.
	LCDC_HEOCFG30_XPHI6COEFF4_Pos = 0x0
	// Bit mask of XPHI6COEFF4 field.
	LCDC_HEOCFG30_XPHI6COEFF4_Msk = 0xff

	// HEOCFG31: High-End Overlay Configuration Register 31
	// Position of XPHI7COEFF0 field.
	LCDC_HEOCFG31_XPHI7COEFF0_Pos = 0x0
	// Bit mask of XPHI7COEFF0 field.
	LCDC_HEOCFG31_XPHI7COEFF0_Msk = 0xff
	// Position of XPHI7COEFF1 field.
	LCDC_HEOCFG31_XPHI7COEFF1_Pos = 0x8
	// Bit mask of XPHI7COEFF1 field.
	LCDC_HEOCFG31_XPHI7COEFF1_Msk = 0xff00
	// Position of XPHI7COEFF2 field.
	LCDC_HEOCFG31_XPHI7COEFF2_Pos = 0x10
	// Bit mask of XPHI7COEFF2 field.
	LCDC_HEOCFG31_XPHI7COEFF2_Msk = 0xff0000
	// Position of XPHI7COEFF3 field.
	LCDC_HEOCFG31_XPHI7COEFF3_Pos = 0x18
	// Bit mask of XPHI7COEFF3 field.
	LCDC_HEOCFG31_XPHI7COEFF3_Msk = 0xff000000

	// HEOCFG32: High-End Overlay Configuration Register 32
	// Position of XPHI7COEFF4 field.
	LCDC_HEOCFG32_XPHI7COEFF4_Pos = 0x0
	// Bit mask of XPHI7COEFF4 field.
	LCDC_HEOCFG32_XPHI7COEFF4_Msk = 0xff

	// HEOCFG33: High-End Overlay Configuration Register 33
	// Position of YPHI0COEFF0 field.
	LCDC_HEOCFG33_YPHI0COEFF0_Pos = 0x0
	// Bit mask of YPHI0COEFF0 field.
	LCDC_HEOCFG33_YPHI0COEFF0_Msk = 0xff
	// Position of YPHI0COEFF1 field.
	LCDC_HEOCFG33_YPHI0COEFF1_Pos = 0x8
	// Bit mask of YPHI0COEFF1 field.
	LCDC_HEOCFG33_YPHI0COEFF1_Msk = 0xff00
	// Position of YPHI0COEFF2 field.
	LCDC_HEOCFG33_YPHI0COEFF2_Pos = 0x10
	// Bit mask of YPHI0COEFF2 field.
	LCDC_HEOCFG33_YPHI0COEFF2_Msk = 0xff0000

	// HEOCFG34: High-End Overlay Configuration Register 34
	// Position of YPHI1COEFF0 field.
	LCDC_HEOCFG34_YPHI1COEFF0_Pos = 0x0
	// Bit mask of YPHI1COEFF0 field.
	LCDC_HEOCFG34_YPHI1COEFF0_Msk = 0xff
	// Position of YPHI1COEFF1 field.
	LCDC_HEOCFG34_YPHI1COEFF1_Pos = 0x8
	// Bit mask of YPHI1COEFF1 field.
	LCDC_HEOCFG34_YPHI1COEFF1_Msk = 0xff00
	// Position of YPHI1COEFF2 field.
	LCDC_HEOCFG34_YPHI1COEFF2_Pos = 0x10
	// Bit mask of YPHI1COEFF2 field.
	LCDC_HEOCFG34_YPHI1COEFF2_Msk = 0xff0000

	// HEOCFG35: High-End Overlay Configuration Register 35
	// Position of YPHI2COEFF0 field.
	LCDC_HEOCFG35_YPHI2COEFF0_Pos = 0x0
	// Bit mask of YPHI2COEFF0 field.
	LCDC_HEOCFG35_YPHI2COEFF0_Msk = 0xff
	// Position of YPHI2COEFF1 field.
	LCDC_HEOCFG35_YPHI2COEFF1_Pos = 0x8
	// Bit mask of YPHI2COEFF1 field.
	LCDC_HEOCFG35_YPHI2COEFF1_Msk = 0xff00
	// Position of YPHI2COEFF2 field.
	LCDC_HEOCFG35_YPHI2COEFF2_Pos = 0x10
	// Bit mask of YPHI2COEFF2 field.
	LCDC_HEOCFG35_YPHI2COEFF2_Msk = 0xff0000

	// HEOCFG36: High-End Overlay Configuration Register 36
	// Position of YPHI3COEFF0 field.
	LCDC_HEOCFG36_YPHI3COEFF0_Pos = 0x0
	// Bit mask of YPHI3COEFF0 field.
	LCDC_HEOCFG36_YPHI3COEFF0_Msk = 0xff
	// Position of YPHI3COEFF1 field.
	LCDC_HEOCFG36_YPHI3COEFF1_Pos = 0x8
	// Bit mask of YPHI3COEFF1 field.
	LCDC_HEOCFG36_YPHI3COEFF1_Msk = 0xff00
	// Position of YPHI3COEFF2 field.
	LCDC_HEOCFG36_YPHI3COEFF2_Pos = 0x10
	// Bit mask of YPHI3COEFF2 field.
	LCDC_HEOCFG36_YPHI3COEFF2_Msk = 0xff0000

	// HEOCFG37: High-End Overlay Configuration Register 37
	// Position of YPHI4COEFF0 field.
	LCDC_HEOCFG37_YPHI4COEFF0_Pos = 0x0
	// Bit mask of YPHI4COEFF0 field.
	LCDC_HEOCFG37_YPHI4COEFF0_Msk = 0xff
	// Position of YPHI4COEFF1 field.
	LCDC_HEOCFG37_YPHI4COEFF1_Pos = 0x8
	// Bit mask of YPHI4COEFF1 field.
	LCDC_HEOCFG37_YPHI4COEFF1_Msk = 0xff00
	// Position of YPHI4COEFF2 field.
	LCDC_HEOCFG37_YPHI4COEFF2_Pos = 0x10
	// Bit mask of YPHI4COEFF2 field.
	LCDC_HEOCFG37_YPHI4COEFF2_Msk = 0xff0000

	// HEOCFG38: High-End Overlay Configuration Register 38
	// Position of YPHI5COEFF0 field.
	LCDC_HEOCFG38_YPHI5COEFF0_Pos = 0x0
	// Bit mask of YPHI5COEFF0 field.
	LCDC_HEOCFG38_YPHI5COEFF0_Msk = 0xff
	// Position of YPHI5COEFF1 field.
	LCDC_HEOCFG38_YPHI5COEFF1_Pos = 0x8
	// Bit mask of YPHI5COEFF1 field.
	LCDC_HEOCFG38_YPHI5COEFF1_Msk = 0xff00
	// Position of YPHI5COEFF2 field.
	LCDC_HEOCFG38_YPHI5COEFF2_Pos = 0x10
	// Bit mask of YPHI5COEFF2 field.
	LCDC_HEOCFG38_YPHI5COEFF2_Msk = 0xff0000

	// HEOCFG39: High-End Overlay Configuration Register 39
	// Position of YPHI6COEFF0 field.
	LCDC_HEOCFG39_YPHI6COEFF0_Pos = 0x0
	// Bit mask of YPHI6COEFF0 field.
	LCDC_HEOCFG39_YPHI6COEFF0_Msk = 0xff
	// Position of YPHI6COEFF1 field.
	LCDC_HEOCFG39_YPHI6COEFF1_Pos = 0x8
	// Bit mask of YPHI6COEFF1 field.
	LCDC_HEOCFG39_YPHI6COEFF1_Msk = 0xff00
	// Position of YPHI6COEFF2 field.
	LCDC_HEOCFG39_YPHI6COEFF2_Pos = 0x10
	// Bit mask of YPHI6COEFF2 field.
	LCDC_HEOCFG39_YPHI6COEFF2_Msk = 0xff0000

	// HEOCFG40: High-End Overlay Configuration Register 40
	// Position of YPHI7COEFF0 field.
	LCDC_HEOCFG40_YPHI7COEFF0_Pos = 0x0
	// Bit mask of YPHI7COEFF0 field.
	LCDC_HEOCFG40_YPHI7COEFF0_Msk = 0xff
	// Position of YPHI7COEFF1 field.
	LCDC_HEOCFG40_YPHI7COEFF1_Pos = 0x8
	// Bit mask of YPHI7COEFF1 field.
	LCDC_HEOCFG40_YPHI7COEFF1_Msk = 0xff00
	// Position of YPHI7COEFF2 field.
	LCDC_HEOCFG40_YPHI7COEFF2_Pos = 0x10
	// Bit mask of YPHI7COEFF2 field.
	LCDC_HEOCFG40_YPHI7COEFF2_Msk = 0xff0000

	// HEOCFG41: High-End Overlay Configuration Register 41
	// Position of XPHIDEF field.
	LCDC_HEOCFG41_XPHIDEF_Pos = 0x0
	// Bit mask of XPHIDEF field.
	LCDC_HEOCFG41_XPHIDEF_Msk = 0x7
	// Position of YPHIDEF field.
	LCDC_HEOCFG41_YPHIDEF_Pos = 0x10
	// Bit mask of YPHIDEF field.
	LCDC_HEOCFG41_YPHIDEF_Msk = 0x70000

	// HCRCHER: Hardware Cursor Channel Enable Register
	// Position of CHEN field.
	LCDC_HCRCHER_CHEN_Pos = 0x0
	// Bit mask of CHEN field.
	LCDC_HCRCHER_CHEN_Msk = 0x1
	// Bit CHEN.
	LCDC_HCRCHER_CHEN = 0x1
	// Position of UPDATEEN field.
	LCDC_HCRCHER_UPDATEEN_Pos = 0x1
	// Bit mask of UPDATEEN field.
	LCDC_HCRCHER_UPDATEEN_Msk = 0x2
	// Bit UPDATEEN.
	LCDC_HCRCHER_UPDATEEN = 0x2
	// Position of A2QEN field.
	LCDC_HCRCHER_A2QEN_Pos = 0x2
	// Bit mask of A2QEN field.
	LCDC_HCRCHER_A2QEN_Msk = 0x4
	// Bit A2QEN.
	LCDC_HCRCHER_A2QEN = 0x4

	// HCRCHDR: Hardware Cursor Channel disable Register
	// Position of CHDIS field.
	LCDC_HCRCHDR_CHDIS_Pos = 0x0
	// Bit mask of CHDIS field.
	LCDC_HCRCHDR_CHDIS_Msk = 0x1
	// Bit CHDIS.
	LCDC_HCRCHDR_CHDIS = 0x1
	// Position of CHRST field.
	LCDC_HCRCHDR_CHRST_Pos = 0x8
	// Bit mask of CHRST field.
	LCDC_HCRCHDR_CHRST_Msk = 0x100
	// Bit CHRST.
	LCDC_HCRCHDR_CHRST = 0x100

	// HCRCHSR: Hardware Cursor Channel Status Register
	// Position of CHSR field.
	LCDC_HCRCHSR_CHSR_Pos = 0x0
	// Bit mask of CHSR field.
	LCDC_HCRCHSR_CHSR_Msk = 0x1
	// Bit CHSR.
	LCDC_HCRCHSR_CHSR = 0x1
	// Position of UPDATESR field.
	LCDC_HCRCHSR_UPDATESR_Pos = 0x1
	// Bit mask of UPDATESR field.
	LCDC_HCRCHSR_UPDATESR_Msk = 0x2
	// Bit UPDATESR.
	LCDC_HCRCHSR_UPDATESR = 0x2
	// Position of A2QSR field.
	LCDC_HCRCHSR_A2QSR_Pos = 0x2
	// Bit mask of A2QSR field.
	LCDC_HCRCHSR_A2QSR_Msk = 0x4
	// Bit A2QSR.
	LCDC_HCRCHSR_A2QSR = 0x4

	// HCRIER: Hardware Cursor Interrupt Enable Register
	// Position of DMA field.
	LCDC_HCRIER_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_HCRIER_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_HCRIER_DMA = 0x4
	// Position of DSCR field.
	LCDC_HCRIER_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_HCRIER_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_HCRIER_DSCR = 0x8
	// Position of ADD field.
	LCDC_HCRIER_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_HCRIER_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_HCRIER_ADD = 0x10
	// Position of DONE field.
	LCDC_HCRIER_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_HCRIER_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_HCRIER_DONE = 0x20
	// Position of OVR field.
	LCDC_HCRIER_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_HCRIER_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_HCRIER_OVR = 0x40

	// HCRIDR: Hardware Cursor Interrupt Disable Register
	// Position of DMA field.
	LCDC_HCRIDR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_HCRIDR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_HCRIDR_DMA = 0x4
	// Position of DSCR field.
	LCDC_HCRIDR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_HCRIDR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_HCRIDR_DSCR = 0x8
	// Position of ADD field.
	LCDC_HCRIDR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_HCRIDR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_HCRIDR_ADD = 0x10
	// Position of DONE field.
	LCDC_HCRIDR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_HCRIDR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_HCRIDR_DONE = 0x20
	// Position of OVR field.
	LCDC_HCRIDR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_HCRIDR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_HCRIDR_OVR = 0x40

	// HCRIMR: Hardware Cursor Interrupt Mask Register
	// Position of DMA field.
	LCDC_HCRIMR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_HCRIMR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_HCRIMR_DMA = 0x4
	// Position of DSCR field.
	LCDC_HCRIMR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_HCRIMR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_HCRIMR_DSCR = 0x8
	// Position of ADD field.
	LCDC_HCRIMR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_HCRIMR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_HCRIMR_ADD = 0x10
	// Position of DONE field.
	LCDC_HCRIMR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_HCRIMR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_HCRIMR_DONE = 0x20
	// Position of OVR field.
	LCDC_HCRIMR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_HCRIMR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_HCRIMR_OVR = 0x40

	// HCRISR: Hardware Cursor Interrupt Status Register
	// Position of DMA field.
	LCDC_HCRISR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_HCRISR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_HCRISR_DMA = 0x4
	// Position of DSCR field.
	LCDC_HCRISR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_HCRISR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_HCRISR_DSCR = 0x8
	// Position of ADD field.
	LCDC_HCRISR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_HCRISR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_HCRISR_ADD = 0x10
	// Position of DONE field.
	LCDC_HCRISR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_HCRISR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_HCRISR_DONE = 0x20
	// Position of OVR field.
	LCDC_HCRISR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_HCRISR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_HCRISR_OVR = 0x40

	// HCRHEAD: Hardware Cursor DMA Head Register
	// Position of HEAD field.
	LCDC_HCRHEAD_HEAD_Pos = 0x2
	// Bit mask of HEAD field.
	LCDC_HCRHEAD_HEAD_Msk = 0xfffffffc

	// HCRADDR: Hardware cursor DMA Address Register
	// Position of ADDR field.
	LCDC_HCRADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	LCDC_HCRADDR_ADDR_Msk = 0xffffffff

	// HCRCTRL: Hardware Cursor DMA Control Register
	// Position of DFETCH field.
	LCDC_HCRCTRL_DFETCH_Pos = 0x0
	// Bit mask of DFETCH field.
	LCDC_HCRCTRL_DFETCH_Msk = 0x1
	// Bit DFETCH.
	LCDC_HCRCTRL_DFETCH = 0x1
	// Position of LFETCH field.
	LCDC_HCRCTRL_LFETCH_Pos = 0x1
	// Bit mask of LFETCH field.
	LCDC_HCRCTRL_LFETCH_Msk = 0x2
	// Bit LFETCH.
	LCDC_HCRCTRL_LFETCH = 0x2
	// Position of DMAIEN field.
	LCDC_HCRCTRL_DMAIEN_Pos = 0x2
	// Bit mask of DMAIEN field.
	LCDC_HCRCTRL_DMAIEN_Msk = 0x4
	// Bit DMAIEN.
	LCDC_HCRCTRL_DMAIEN = 0x4
	// Position of DSCRIEN field.
	LCDC_HCRCTRL_DSCRIEN_Pos = 0x3
	// Bit mask of DSCRIEN field.
	LCDC_HCRCTRL_DSCRIEN_Msk = 0x8
	// Bit DSCRIEN.
	LCDC_HCRCTRL_DSCRIEN = 0x8
	// Position of ADDIEN field.
	LCDC_HCRCTRL_ADDIEN_Pos = 0x4
	// Bit mask of ADDIEN field.
	LCDC_HCRCTRL_ADDIEN_Msk = 0x10
	// Bit ADDIEN.
	LCDC_HCRCTRL_ADDIEN = 0x10
	// Position of DONEIEN field.
	LCDC_HCRCTRL_DONEIEN_Pos = 0x5
	// Bit mask of DONEIEN field.
	LCDC_HCRCTRL_DONEIEN_Msk = 0x20
	// Bit DONEIEN.
	LCDC_HCRCTRL_DONEIEN = 0x20

	// HCRNEXT: Hardware Cursor DMA NExt Register
	// Position of NEXT field.
	LCDC_HCRNEXT_NEXT_Pos = 0x0
	// Bit mask of NEXT field.
	LCDC_HCRNEXT_NEXT_Msk = 0xffffffff

	// HCRCFG0: Hardware Cursor Configuration 0 Register
	// Position of SIF field.
	LCDC_HCRCFG0_SIF_Pos = 0x0
	// Bit mask of SIF field.
	LCDC_HCRCFG0_SIF_Msk = 0x1
	// Bit SIF.
	LCDC_HCRCFG0_SIF = 0x1
	// Position of BLEN field.
	LCDC_HCRCFG0_BLEN_Pos = 0x4
	// Bit mask of BLEN field.
	LCDC_HCRCFG0_BLEN_Msk = 0x30
	// AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HCRCFG0_BLEN_AHB_BLEN_SINGLE = 0x0
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HCRCFG0_BLEN_AHB_BLEN_INCR4 = 0x1
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HCRCFG0_BLEN_AHB_BLEN_INCR8 = 0x2
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HCRCFG0_BLEN_AHB_BLEN_INCR16 = 0x3
	// Position of DLBO field.
	LCDC_HCRCFG0_DLBO_Pos = 0x8
	// Bit mask of DLBO field.
	LCDC_HCRCFG0_DLBO_Msk = 0x100
	// Bit DLBO.
	LCDC_HCRCFG0_DLBO = 0x100

	// HCRCFG1: Hardware Cursor Configuration 1 Register
	// Position of CLUTEN field.
	LCDC_HCRCFG1_CLUTEN_Pos = 0x0
	// Bit mask of CLUTEN field.
	LCDC_HCRCFG1_CLUTEN_Msk = 0x1
	// Bit CLUTEN.
	LCDC_HCRCFG1_CLUTEN = 0x1
	// Position of RGBMODE field.
	LCDC_HCRCFG1_RGBMODE_Pos = 0x4
	// Bit mask of RGBMODE field.
	LCDC_HCRCFG1_RGBMODE_Msk = 0xf0
	// 12 bpp RGB 444
	LCDC_HCRCFG1_RGBMODE_12BPP_RGB_444 = 0x0
	// 16 bpp ARGB 4444
	LCDC_HCRCFG1_RGBMODE_16BPP_ARGB_4444 = 0x1
	// 16 bpp RGBA 4444
	LCDC_HCRCFG1_RGBMODE_16BPP_RGBA_4444 = 0x2
	// 16 bpp RGB 565
	LCDC_HCRCFG1_RGBMODE_16BPP_RGB_565 = 0x3
	// 16 bpp TRGB 1555
	LCDC_HCRCFG1_RGBMODE_16BPP_TRGB_1555 = 0x4
	// 18 bpp RGB 666
	LCDC_HCRCFG1_RGBMODE_18BPP_RGB_666 = 0x5
	// 18 bpp RGB 666 PACKED
	LCDC_HCRCFG1_RGBMODE_18BPP_RGB_666PACKED = 0x6
	// 19 bpp TRGB 1666
	LCDC_HCRCFG1_RGBMODE_19BPP_TRGB_1666 = 0x7
	// 19 bpp TRGB 1666 PACKED
	LCDC_HCRCFG1_RGBMODE_19BPP_TRGB_PACKED = 0x8
	// 24 bpp RGB 888
	LCDC_HCRCFG1_RGBMODE_24BPP_RGB_888 = 0x9
	// 24 bpp RGB 888 PACKED
	LCDC_HCRCFG1_RGBMODE_24BPP_RGB_888_PACKED = 0xa
	// 25 bpp TRGB 1888
	LCDC_HCRCFG1_RGBMODE_25BPP_TRGB_1888 = 0xb
	// 32 bpp ARGB 8888
	LCDC_HCRCFG1_RGBMODE_32BPP_ARGB_8888 = 0xc
	// 32 bpp RGBA 8888
	LCDC_HCRCFG1_RGBMODE_32BPP_RGBA_8888 = 0xd
	// Position of CLUTMODE field.
	LCDC_HCRCFG1_CLUTMODE_Pos = 0x8
	// Bit mask of CLUTMODE field.
	LCDC_HCRCFG1_CLUTMODE_Msk = 0x300
	// color lookup table mode set to 1 bit per pixel
	LCDC_HCRCFG1_CLUTMODE_CLUT_1BPP = 0x0
	// color lookup table mode set to 2 bits per pixel
	LCDC_HCRCFG1_CLUTMODE_CLUT_2BPP = 0x1
	// color lookup table mode set to 4 bits per pixel
	LCDC_HCRCFG1_CLUTMODE_CLUT_4BPP = 0x2
	// color lookup table mode set to 8 bits per pixel
	LCDC_HCRCFG1_CLUTMODE_CLUT_8BPP = 0x3

	// HCRCFG2: Hardware Cursor Configuration 2 Register
	// Position of XPOS field.
	LCDC_HCRCFG2_XPOS_Pos = 0x0
	// Bit mask of XPOS field.
	LCDC_HCRCFG2_XPOS_Msk = 0x7ff
	// Position of YPOS field.
	LCDC_HCRCFG2_YPOS_Pos = 0x10
	// Bit mask of YPOS field.
	LCDC_HCRCFG2_YPOS_Msk = 0x7ff0000

	// HCRCFG3: Hardware Cursor Configuration 3 Register
	// Position of XSIZE field.
	LCDC_HCRCFG3_XSIZE_Pos = 0x0
	// Bit mask of XSIZE field.
	LCDC_HCRCFG3_XSIZE_Msk = 0x7ff
	// Position of YSIZE field.
	LCDC_HCRCFG3_YSIZE_Pos = 0x10
	// Bit mask of YSIZE field.
	LCDC_HCRCFG3_YSIZE_Msk = 0x7ff0000

	// HCRCFG4: Hardware Cursor Configuration 4 Register
	// Position of XSTRIDE field.
	LCDC_HCRCFG4_XSTRIDE_Pos = 0x0
	// Bit mask of XSTRIDE field.
	LCDC_HCRCFG4_XSTRIDE_Msk = 0xffffffff

	// HCRCFG6: Hardware Cursor Configuration 6 Register
	// Position of BDEF field.
	LCDC_HCRCFG6_BDEF_Pos = 0x0
	// Bit mask of BDEF field.
	LCDC_HCRCFG6_BDEF_Msk = 0xff
	// Position of GDEF field.
	LCDC_HCRCFG6_GDEF_Pos = 0x8
	// Bit mask of GDEF field.
	LCDC_HCRCFG6_GDEF_Msk = 0xff00
	// Position of RDEF field.
	LCDC_HCRCFG6_RDEF_Pos = 0x10
	// Bit mask of RDEF field.
	LCDC_HCRCFG6_RDEF_Msk = 0xff0000

	// HCRCFG7: Hardware Cursor Configuration 7 Register
	// Position of BKEY field.
	LCDC_HCRCFG7_BKEY_Pos = 0x0
	// Bit mask of BKEY field.
	LCDC_HCRCFG7_BKEY_Msk = 0xff
	// Position of GKEY field.
	LCDC_HCRCFG7_GKEY_Pos = 0x8
	// Bit mask of GKEY field.
	LCDC_HCRCFG7_GKEY_Msk = 0xff00
	// Position of RKEY field.
	LCDC_HCRCFG7_RKEY_Pos = 0x10
	// Bit mask of RKEY field.
	LCDC_HCRCFG7_RKEY_Msk = 0xff0000

	// HCRCFG8: Hardware Cursor Configuration 8 Register
	// Position of BMASK field.
	LCDC_HCRCFG8_BMASK_Pos = 0x0
	// Bit mask of BMASK field.
	LCDC_HCRCFG8_BMASK_Msk = 0xff
	// Position of GMASK field.
	LCDC_HCRCFG8_GMASK_Pos = 0x8
	// Bit mask of GMASK field.
	LCDC_HCRCFG8_GMASK_Msk = 0xff00
	// Position of RMASK field.
	LCDC_HCRCFG8_RMASK_Pos = 0x10
	// Bit mask of RMASK field.
	LCDC_HCRCFG8_RMASK_Msk = 0xff0000

	// HCRCFG9: Hardware Cursor Configuration 9 Register
	// Position of CRKEY field.
	LCDC_HCRCFG9_CRKEY_Pos = 0x0
	// Bit mask of CRKEY field.
	LCDC_HCRCFG9_CRKEY_Msk = 0x1
	// Bit CRKEY.
	LCDC_HCRCFG9_CRKEY = 0x1
	// Position of INV field.
	LCDC_HCRCFG9_INV_Pos = 0x1
	// Bit mask of INV field.
	LCDC_HCRCFG9_INV_Msk = 0x2
	// Bit INV.
	LCDC_HCRCFG9_INV = 0x2
	// Position of ITER2BL field.
	LCDC_HCRCFG9_ITER2BL_Pos = 0x2
	// Bit mask of ITER2BL field.
	LCDC_HCRCFG9_ITER2BL_Msk = 0x4
	// Bit ITER2BL.
	LCDC_HCRCFG9_ITER2BL = 0x4
	// Position of ITER field.
	LCDC_HCRCFG9_ITER_Pos = 0x3
	// Bit mask of ITER field.
	LCDC_HCRCFG9_ITER_Msk = 0x8
	// Bit ITER.
	LCDC_HCRCFG9_ITER = 0x8
	// Position of REVALPHA field.
	LCDC_HCRCFG9_REVALPHA_Pos = 0x4
	// Bit mask of REVALPHA field.
	LCDC_HCRCFG9_REVALPHA_Msk = 0x10
	// Bit REVALPHA.
	LCDC_HCRCFG9_REVALPHA = 0x10
	// Position of GAEN field.
	LCDC_HCRCFG9_GAEN_Pos = 0x5
	// Bit mask of GAEN field.
	LCDC_HCRCFG9_GAEN_Msk = 0x20
	// Bit GAEN.
	LCDC_HCRCFG9_GAEN = 0x20
	// Position of LAEN field.
	LCDC_HCRCFG9_LAEN_Pos = 0x6
	// Bit mask of LAEN field.
	LCDC_HCRCFG9_LAEN_Msk = 0x40
	// Bit LAEN.
	LCDC_HCRCFG9_LAEN = 0x40
	// Position of OVR field.
	LCDC_HCRCFG9_OVR_Pos = 0x7
	// Bit mask of OVR field.
	LCDC_HCRCFG9_OVR_Msk = 0x80
	// Bit OVR.
	LCDC_HCRCFG9_OVR = 0x80
	// Position of DMA field.
	LCDC_HCRCFG9_DMA_Pos = 0x8
	// Bit mask of DMA field.
	LCDC_HCRCFG9_DMA_Msk = 0x100
	// Bit DMA.
	LCDC_HCRCFG9_DMA = 0x100
	// Position of REP field.
	LCDC_HCRCFG9_REP_Pos = 0x9
	// Bit mask of REP field.
	LCDC_HCRCFG9_REP_Msk = 0x200
	// Bit REP.
	LCDC_HCRCFG9_REP = 0x200
	// Position of DSTKEY field.
	LCDC_HCRCFG9_DSTKEY_Pos = 0xa
	// Bit mask of DSTKEY field.
	LCDC_HCRCFG9_DSTKEY_Msk = 0x400
	// Bit DSTKEY.
	LCDC_HCRCFG9_DSTKEY = 0x400
	// Position of GA field.
	LCDC_HCRCFG9_GA_Pos = 0x10
	// Bit mask of GA field.
	LCDC_HCRCFG9_GA_Msk = 0xff0000

	// PPCHER: Post Processing Channel Enable Register
	// Position of CHEN field.
	LCDC_PPCHER_CHEN_Pos = 0x0
	// Bit mask of CHEN field.
	LCDC_PPCHER_CHEN_Msk = 0x1
	// Bit CHEN.
	LCDC_PPCHER_CHEN = 0x1
	// Position of UPDATEEN field.
	LCDC_PPCHER_UPDATEEN_Pos = 0x1
	// Bit mask of UPDATEEN field.
	LCDC_PPCHER_UPDATEEN_Msk = 0x2
	// Bit UPDATEEN.
	LCDC_PPCHER_UPDATEEN = 0x2
	// Position of A2QEN field.
	LCDC_PPCHER_A2QEN_Pos = 0x2
	// Bit mask of A2QEN field.
	LCDC_PPCHER_A2QEN_Msk = 0x4
	// Bit A2QEN.
	LCDC_PPCHER_A2QEN = 0x4

	// PPCHDR: Post Processing Channel Disable Register
	// Position of CHDIS field.
	LCDC_PPCHDR_CHDIS_Pos = 0x0
	// Bit mask of CHDIS field.
	LCDC_PPCHDR_CHDIS_Msk = 0x1
	// Bit CHDIS.
	LCDC_PPCHDR_CHDIS = 0x1
	// Position of CHRST field.
	LCDC_PPCHDR_CHRST_Pos = 0x8
	// Bit mask of CHRST field.
	LCDC_PPCHDR_CHRST_Msk = 0x100
	// Bit CHRST.
	LCDC_PPCHDR_CHRST = 0x100

	// PPCHSR: Post Processing Channel Status Register
	// Position of CHSR field.
	LCDC_PPCHSR_CHSR_Pos = 0x0
	// Bit mask of CHSR field.
	LCDC_PPCHSR_CHSR_Msk = 0x1
	// Bit CHSR.
	LCDC_PPCHSR_CHSR = 0x1
	// Position of UPDATESR field.
	LCDC_PPCHSR_UPDATESR_Pos = 0x1
	// Bit mask of UPDATESR field.
	LCDC_PPCHSR_UPDATESR_Msk = 0x2
	// Bit UPDATESR.
	LCDC_PPCHSR_UPDATESR = 0x2
	// Position of A2QSR field.
	LCDC_PPCHSR_A2QSR_Pos = 0x2
	// Bit mask of A2QSR field.
	LCDC_PPCHSR_A2QSR_Msk = 0x4
	// Bit A2QSR.
	LCDC_PPCHSR_A2QSR = 0x4

	// PPIER: Post Processing Interrupt Enable Register
	// Position of DMA field.
	LCDC_PPIER_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_PPIER_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_PPIER_DMA = 0x4
	// Position of DSCR field.
	LCDC_PPIER_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_PPIER_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_PPIER_DSCR = 0x8
	// Position of ADD field.
	LCDC_PPIER_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_PPIER_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_PPIER_ADD = 0x10
	// Position of DONE field.
	LCDC_PPIER_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_PPIER_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_PPIER_DONE = 0x20

	// PPIDR: Post Processing Interrupt Disable Register
	// Position of DMA field.
	LCDC_PPIDR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_PPIDR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_PPIDR_DMA = 0x4
	// Position of DSCR field.
	LCDC_PPIDR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_PPIDR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_PPIDR_DSCR = 0x8
	// Position of ADD field.
	LCDC_PPIDR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_PPIDR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_PPIDR_ADD = 0x10
	// Position of DONE field.
	LCDC_PPIDR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_PPIDR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_PPIDR_DONE = 0x20

	// PPIMR: Post Processing Interrupt Mask Register
	// Position of DMA field.
	LCDC_PPIMR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_PPIMR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_PPIMR_DMA = 0x4
	// Position of DSCR field.
	LCDC_PPIMR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_PPIMR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_PPIMR_DSCR = 0x8
	// Position of ADD field.
	LCDC_PPIMR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_PPIMR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_PPIMR_ADD = 0x10
	// Position of DONE field.
	LCDC_PPIMR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_PPIMR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_PPIMR_DONE = 0x20

	// PPISR: Post Processing Interrupt Status Register
	// Position of DMA field.
	LCDC_PPISR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_PPISR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_PPISR_DMA = 0x4
	// Position of DSCR field.
	LCDC_PPISR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_PPISR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_PPISR_DSCR = 0x8
	// Position of ADD field.
	LCDC_PPISR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_PPISR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_PPISR_ADD = 0x10
	// Position of DONE field.
	LCDC_PPISR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_PPISR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_PPISR_DONE = 0x20

	// PPHEAD: Post Processing Head Register
	// Position of HEAD field.
	LCDC_PPHEAD_HEAD_Pos = 0x2
	// Bit mask of HEAD field.
	LCDC_PPHEAD_HEAD_Msk = 0xfffffffc

	// PPADDR: Post Processing Address Register
	// Position of ADDR field.
	LCDC_PPADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	LCDC_PPADDR_ADDR_Msk = 0xffffffff

	// PPCTRL: Post Processing Control Register
	// Position of DFETCH field.
	LCDC_PPCTRL_DFETCH_Pos = 0x0
	// Bit mask of DFETCH field.
	LCDC_PPCTRL_DFETCH_Msk = 0x1
	// Bit DFETCH.
	LCDC_PPCTRL_DFETCH = 0x1
	// Position of DMAIEN field.
	LCDC_PPCTRL_DMAIEN_Pos = 0x2
	// Bit mask of DMAIEN field.
	LCDC_PPCTRL_DMAIEN_Msk = 0x4
	// Bit DMAIEN.
	LCDC_PPCTRL_DMAIEN = 0x4
	// Position of DSCRIEN field.
	LCDC_PPCTRL_DSCRIEN_Pos = 0x3
	// Bit mask of DSCRIEN field.
	LCDC_PPCTRL_DSCRIEN_Msk = 0x8
	// Bit DSCRIEN.
	LCDC_PPCTRL_DSCRIEN = 0x8
	// Position of ADDIEN field.
	LCDC_PPCTRL_ADDIEN_Pos = 0x4
	// Bit mask of ADDIEN field.
	LCDC_PPCTRL_ADDIEN_Msk = 0x10
	// Bit ADDIEN.
	LCDC_PPCTRL_ADDIEN = 0x10
	// Position of DONEIEN field.
	LCDC_PPCTRL_DONEIEN_Pos = 0x5
	// Bit mask of DONEIEN field.
	LCDC_PPCTRL_DONEIEN_Msk = 0x20
	// Bit DONEIEN.
	LCDC_PPCTRL_DONEIEN = 0x20

	// PPNEXT: Post Processing Next Register
	// Position of NEXT field.
	LCDC_PPNEXT_NEXT_Pos = 0x0
	// Bit mask of NEXT field.
	LCDC_PPNEXT_NEXT_Msk = 0xffffffff

	// PPCFG0: Post Processing Configuration Register 0
	// Position of SIF field.
	LCDC_PPCFG0_SIF_Pos = 0x0
	// Bit mask of SIF field.
	LCDC_PPCFG0_SIF_Msk = 0x1
	// Bit SIF.
	LCDC_PPCFG0_SIF = 0x1
	// Position of BLEN field.
	LCDC_PPCFG0_BLEN_Pos = 0x4
	// Bit mask of BLEN field.
	LCDC_PPCFG0_BLEN_Msk = 0x30
	// AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_PPCFG0_BLEN_AHB_BLEN_SINGLE = 0x0
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 4 data. An AHB INCR4 Burst is used. SINGLE, INCR and INCR4 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_PPCFG0_BLEN_AHB_BLEN_INCR4 = 0x1
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is used. SINGLE, INCR, INCR4 and INCR8 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_PPCFG0_BLEN_AHB_BLEN_INCR8 = 0x2
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 16 data. An AHB INCR16 Burst is used. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are used. INCR is used for a burst of 2 and 3 beats.
	LCDC_PPCFG0_BLEN_AHB_BLEN_INCR16 = 0x3
	// Position of DLBO field.
	LCDC_PPCFG0_DLBO_Pos = 0x8
	// Bit mask of DLBO field.
	LCDC_PPCFG0_DLBO_Msk = 0x100
	// Bit DLBO.
	LCDC_PPCFG0_DLBO = 0x100

	// PPCFG1: Post Processing Configuration Register 1
	// Position of PPMODE field.
	LCDC_PPCFG1_PPMODE_Pos = 0x0
	// Bit mask of PPMODE field.
	LCDC_PPCFG1_PPMODE_Msk = 0x7
	// RGB 16 bpp
	LCDC_PPCFG1_PPMODE_PPMODE_RGB_16BPP = 0x0
	// RGB 24 bpp PACKED
	LCDC_PPCFG1_PPMODE_PPMODE_RGB_24BPP_PACKED = 0x1
	// RGB 24 bpp UNPACKED
	LCDC_PPCFG1_PPMODE_PPMODE_RGB_24BPP_UNPACKED = 0x2
	// YCbCr 422 16 bpp (Mode 0)
	LCDC_PPCFG1_PPMODE_PPMODE_YCBCR_422_MODE0 = 0x3
	// YCbCr 422 16 bpp (Mode 1)
	LCDC_PPCFG1_PPMODE_PPMODE_YCBCR_422_MODE1 = 0x4
	// YCbCr 422 16 bpp (Mode 2)
	LCDC_PPCFG1_PPMODE_PPMODE_YCBCR_422_MODE2 = 0x5
	// YCbCr 422 16 bpp (Mode 3)
	LCDC_PPCFG1_PPMODE_PPMODE_YCBCR_422_MODE3 = 0x6
	// Position of ITUBT601 field.
	LCDC_PPCFG1_ITUBT601_Pos = 0x4
	// Bit mask of ITUBT601 field.
	LCDC_PPCFG1_ITUBT601_Msk = 0x10
	// Bit ITUBT601.
	LCDC_PPCFG1_ITUBT601 = 0x10

	// PPCFG2: Post Processing Configuration Register 2
	// Position of XSTRIDE field.
	LCDC_PPCFG2_XSTRIDE_Pos = 0x0
	// Bit mask of XSTRIDE field.
	LCDC_PPCFG2_XSTRIDE_Msk = 0xffffffff

	// PPCFG3: Post Processing Configuration Register 3
	// Position of CSCYR field.
	LCDC_PPCFG3_CSCYR_Pos = 0x0
	// Bit mask of CSCYR field.
	LCDC_PPCFG3_CSCYR_Msk = 0x3ff
	// Position of CSCYG field.
	LCDC_PPCFG3_CSCYG_Pos = 0xa
	// Bit mask of CSCYG field.
	LCDC_PPCFG3_CSCYG_Msk = 0xffc00
	// Position of CSCYB field.
	LCDC_PPCFG3_CSCYB_Pos = 0x14
	// Bit mask of CSCYB field.
	LCDC_PPCFG3_CSCYB_Msk = 0x3ff00000
	// Position of CSCYOFF field.
	LCDC_PPCFG3_CSCYOFF_Pos = 0x1e
	// Bit mask of CSCYOFF field.
	LCDC_PPCFG3_CSCYOFF_Msk = 0x40000000
	// Bit CSCYOFF.
	LCDC_PPCFG3_CSCYOFF = 0x40000000

	// PPCFG4: Post Processing Configuration Register 4
	// Position of CSCUR field.
	LCDC_PPCFG4_CSCUR_Pos = 0x0
	// Bit mask of CSCUR field.
	LCDC_PPCFG4_CSCUR_Msk = 0x3ff
	// Position of CSCUG field.
	LCDC_PPCFG4_CSCUG_Pos = 0xa
	// Bit mask of CSCUG field.
	LCDC_PPCFG4_CSCUG_Msk = 0xffc00
	// Position of CSCUB field.
	LCDC_PPCFG4_CSCUB_Pos = 0x14
	// Bit mask of CSCUB field.
	LCDC_PPCFG4_CSCUB_Msk = 0x3ff00000
	// Position of CSCUOFF field.
	LCDC_PPCFG4_CSCUOFF_Pos = 0x1e
	// Bit mask of CSCUOFF field.
	LCDC_PPCFG4_CSCUOFF_Msk = 0x40000000
	// Bit CSCUOFF.
	LCDC_PPCFG4_CSCUOFF = 0x40000000

	// PPCFG5: Post Processing Configuration Register 5
	// Position of CSCVR field.
	LCDC_PPCFG5_CSCVR_Pos = 0x0
	// Bit mask of CSCVR field.
	LCDC_PPCFG5_CSCVR_Msk = 0x3ff
	// Position of CSCVG field.
	LCDC_PPCFG5_CSCVG_Pos = 0xa
	// Bit mask of CSCVG field.
	LCDC_PPCFG5_CSCVG_Msk = 0xffc00
	// Position of CSCVB field.
	LCDC_PPCFG5_CSCVB_Pos = 0x14
	// Bit mask of CSCVB field.
	LCDC_PPCFG5_CSCVB_Msk = 0x3ff00000
	// Position of CSCVOFF field.
	LCDC_PPCFG5_CSCVOFF_Pos = 0x1e
	// Bit mask of CSCVOFF field.
	LCDC_PPCFG5_CSCVOFF_Msk = 0x40000000
	// Bit CSCVOFF.
	LCDC_PPCFG5_CSCVOFF = 0x40000000

	// BASECLUT: Base CLUT Register
	// Position of BCLUT field.
	LCDC_BASECLUT_BCLUT_Pos = 0x0
	// Bit mask of BCLUT field.
	LCDC_BASECLUT_BCLUT_Msk = 0xff
	// Position of GCLUT field.
	LCDC_BASECLUT_GCLUT_Pos = 0x8
	// Bit mask of GCLUT field.
	LCDC_BASECLUT_GCLUT_Msk = 0xff00
	// Position of RCLUT field.
	LCDC_BASECLUT_RCLUT_Pos = 0x10
	// Bit mask of RCLUT field.
	LCDC_BASECLUT_RCLUT_Msk = 0xff0000

	// OVR1CLUT: Overlay 1 CLUT Register
	// Position of BCLUT field.
	LCDC_OVR1CLUT_BCLUT_Pos = 0x0
	// Bit mask of BCLUT field.
	LCDC_OVR1CLUT_BCLUT_Msk = 0xff
	// Position of GCLUT field.
	LCDC_OVR1CLUT_GCLUT_Pos = 0x8
	// Bit mask of GCLUT field.
	LCDC_OVR1CLUT_GCLUT_Msk = 0xff00
	// Position of RCLUT field.
	LCDC_OVR1CLUT_RCLUT_Pos = 0x10
	// Bit mask of RCLUT field.
	LCDC_OVR1CLUT_RCLUT_Msk = 0xff0000
	// Position of ACLUT field.
	LCDC_OVR1CLUT_ACLUT_Pos = 0x18
	// Bit mask of ACLUT field.
	LCDC_OVR1CLUT_ACLUT_Msk = 0xff000000

	// OVR2CLUT: Overlay 2 CLUT Register
	// Position of BCLUT field.
	LCDC_OVR2CLUT_BCLUT_Pos = 0x0
	// Bit mask of BCLUT field.
	LCDC_OVR2CLUT_BCLUT_Msk = 0xff
	// Position of GCLUT field.
	LCDC_OVR2CLUT_GCLUT_Pos = 0x8
	// Bit mask of GCLUT field.
	LCDC_OVR2CLUT_GCLUT_Msk = 0xff00
	// Position of RCLUT field.
	LCDC_OVR2CLUT_RCLUT_Pos = 0x10
	// Bit mask of RCLUT field.
	LCDC_OVR2CLUT_RCLUT_Msk = 0xff0000
	// Position of ACLUT field.
	LCDC_OVR2CLUT_ACLUT_Pos = 0x18
	// Bit mask of ACLUT field.
	LCDC_OVR2CLUT_ACLUT_Msk = 0xff000000

	// HEOCLUT: High End Overlay CLUT Register
	// Position of BCLUT field.
	LCDC_HEOCLUT_BCLUT_Pos = 0x0
	// Bit mask of BCLUT field.
	LCDC_HEOCLUT_BCLUT_Msk = 0xff
	// Position of GCLUT field.
	LCDC_HEOCLUT_GCLUT_Pos = 0x8
	// Bit mask of GCLUT field.
	LCDC_HEOCLUT_GCLUT_Msk = 0xff00
	// Position of RCLUT field.
	LCDC_HEOCLUT_RCLUT_Pos = 0x10
	// Bit mask of RCLUT field.
	LCDC_HEOCLUT_RCLUT_Msk = 0xff0000
	// Position of ACLUT field.
	LCDC_HEOCLUT_ACLUT_Pos = 0x18
	// Bit mask of ACLUT field.
	LCDC_HEOCLUT_ACLUT_Msk = 0xff000000

	// HCRCLUT: Hardware Cursor CLUT Register
	// Position of BCLUT field.
	LCDC_HCRCLUT_BCLUT_Pos = 0x0
	// Bit mask of BCLUT field.
	LCDC_HCRCLUT_BCLUT_Msk = 0xff
	// Position of GCLUT field.
	LCDC_HCRCLUT_GCLUT_Pos = 0x8
	// Bit mask of GCLUT field.
	LCDC_HCRCLUT_GCLUT_Msk = 0xff00
	// Position of RCLUT field.
	LCDC_HCRCLUT_RCLUT_Pos = 0x10
	// Bit mask of RCLUT field.
	LCDC_HCRCLUT_RCLUT_Msk = 0xff0000
	// Position of ACLUT field.
	LCDC_HCRCLUT_ACLUT_Pos = 0x18
	// Bit mask of ACLUT field.
	LCDC_HCRCLUT_ACLUT_Msk = 0xff000000
)

// Bitfields for ISI: Image Sensor Interface
const (
	// CFG1: ISI Configuration 1 Register
	// Position of HSYNC_POL field.
	ISI_CFG1_HSYNC_POL_Pos = 0x2
	// Bit mask of HSYNC_POL field.
	ISI_CFG1_HSYNC_POL_Msk = 0x4
	// Bit HSYNC_POL.
	ISI_CFG1_HSYNC_POL = 0x4
	// Position of VSYNC_POL field.
	ISI_CFG1_VSYNC_POL_Pos = 0x3
	// Bit mask of VSYNC_POL field.
	ISI_CFG1_VSYNC_POL_Msk = 0x8
	// Bit VSYNC_POL.
	ISI_CFG1_VSYNC_POL = 0x8
	// Position of PIXCLK_POL field.
	ISI_CFG1_PIXCLK_POL_Pos = 0x4
	// Bit mask of PIXCLK_POL field.
	ISI_CFG1_PIXCLK_POL_Msk = 0x10
	// Bit PIXCLK_POL.
	ISI_CFG1_PIXCLK_POL = 0x10
	// Position of EMB_SYNC field.
	ISI_CFG1_EMB_SYNC_Pos = 0x6
	// Bit mask of EMB_SYNC field.
	ISI_CFG1_EMB_SYNC_Msk = 0x40
	// Bit EMB_SYNC.
	ISI_CFG1_EMB_SYNC = 0x40
	// Position of CRC_SYNC field.
	ISI_CFG1_CRC_SYNC_Pos = 0x7
	// Bit mask of CRC_SYNC field.
	ISI_CFG1_CRC_SYNC_Msk = 0x80
	// Bit CRC_SYNC.
	ISI_CFG1_CRC_SYNC = 0x80
	// Position of FRATE field.
	ISI_CFG1_FRATE_Pos = 0x8
	// Bit mask of FRATE field.
	ISI_CFG1_FRATE_Msk = 0x700
	// Position of DISCR field.
	ISI_CFG1_DISCR_Pos = 0xb
	// Bit mask of DISCR field.
	ISI_CFG1_DISCR_Msk = 0x800
	// Bit DISCR.
	ISI_CFG1_DISCR = 0x800
	// Position of FULL field.
	ISI_CFG1_FULL_Pos = 0xc
	// Bit mask of FULL field.
	ISI_CFG1_FULL_Msk = 0x1000
	// Bit FULL.
	ISI_CFG1_FULL = 0x1000
	// Position of THMASK field.
	ISI_CFG1_THMASK_Pos = 0xd
	// Bit mask of THMASK field.
	ISI_CFG1_THMASK_Msk = 0x6000
	// Only 4 beats AHB burst allowed
	ISI_CFG1_THMASK_BEATS_4 = 0x0
	// Only 4 and 8 beats AHB burst allowed
	ISI_CFG1_THMASK_BEATS_8 = 0x1
	// 4, 8 and 16 beats AHB burst allowed
	ISI_CFG1_THMASK_BEATS_16 = 0x2
	// Position of SLD field.
	ISI_CFG1_SLD_Pos = 0x10
	// Bit mask of SLD field.
	ISI_CFG1_SLD_Msk = 0xff0000
	// Position of SFD field.
	ISI_CFG1_SFD_Pos = 0x18
	// Bit mask of SFD field.
	ISI_CFG1_SFD_Msk = 0xff000000

	// CFG2: ISI Configuration 2 Register
	// Position of IM_VSIZE field.
	ISI_CFG2_IM_VSIZE_Pos = 0x0
	// Bit mask of IM_VSIZE field.
	ISI_CFG2_IM_VSIZE_Msk = 0x7ff
	// Position of GS_MODE field.
	ISI_CFG2_GS_MODE_Pos = 0xb
	// Bit mask of GS_MODE field.
	ISI_CFG2_GS_MODE_Msk = 0x800
	// Bit GS_MODE.
	ISI_CFG2_GS_MODE = 0x800
	// Position of RGB_MODE field.
	ISI_CFG2_RGB_MODE_Pos = 0xc
	// Bit mask of RGB_MODE field.
	ISI_CFG2_RGB_MODE_Msk = 0x1000
	// Bit RGB_MODE.
	ISI_CFG2_RGB_MODE = 0x1000
	// Position of GRAYSCALE field.
	ISI_CFG2_GRAYSCALE_Pos = 0xd
	// Bit mask of GRAYSCALE field.
	ISI_CFG2_GRAYSCALE_Msk = 0x2000
	// Bit GRAYSCALE.
	ISI_CFG2_GRAYSCALE = 0x2000
	// Position of RGB_SWAP field.
	ISI_CFG2_RGB_SWAP_Pos = 0xe
	// Bit mask of RGB_SWAP field.
	ISI_CFG2_RGB_SWAP_Msk = 0x4000
	// Bit RGB_SWAP.
	ISI_CFG2_RGB_SWAP = 0x4000
	// Position of COL_SPACE field.
	ISI_CFG2_COL_SPACE_Pos = 0xf
	// Bit mask of COL_SPACE field.
	ISI_CFG2_COL_SPACE_Msk = 0x8000
	// Bit COL_SPACE.
	ISI_CFG2_COL_SPACE = 0x8000
	// Position of IM_HSIZE field.
	ISI_CFG2_IM_HSIZE_Pos = 0x10
	// Bit mask of IM_HSIZE field.
	ISI_CFG2_IM_HSIZE_Msk = 0x7ff0000
	// Position of YCC_SWAP field.
	ISI_CFG2_YCC_SWAP_Pos = 0x1c
	// Bit mask of YCC_SWAP field.
	ISI_CFG2_YCC_SWAP_Msk = 0x30000000
	// Position of RGB_CFG field.
	ISI_CFG2_RGB_CFG_Pos = 0x1e
	// Bit mask of RGB_CFG field.
	ISI_CFG2_RGB_CFG_Msk = 0xc0000000

	// PSIZE: ISI Preview Size Register
	// Position of PREV_VSIZE field.
	ISI_PSIZE_PREV_VSIZE_Pos = 0x0
	// Bit mask of PREV_VSIZE field.
	ISI_PSIZE_PREV_VSIZE_Msk = 0x3ff
	// Position of PREV_HSIZE field.
	ISI_PSIZE_PREV_HSIZE_Pos = 0x10
	// Bit mask of PREV_HSIZE field.
	ISI_PSIZE_PREV_HSIZE_Msk = 0x3ff0000

	// PDECF: ISI Preview Decimation Factor Register
	// Position of DEC_FACTOR field.
	ISI_PDECF_DEC_FACTOR_Pos = 0x0
	// Bit mask of DEC_FACTOR field.
	ISI_PDECF_DEC_FACTOR_Msk = 0xff

	// Y2R_SET0: ISI CSC YCrCb To RGB Set 0 Register
	// Position of C0 field.
	ISI_Y2R_SET0_C0_Pos = 0x0
	// Bit mask of C0 field.
	ISI_Y2R_SET0_C0_Msk = 0xff
	// Position of C1 field.
	ISI_Y2R_SET0_C1_Pos = 0x8
	// Bit mask of C1 field.
	ISI_Y2R_SET0_C1_Msk = 0xff00
	// Position of C2 field.
	ISI_Y2R_SET0_C2_Pos = 0x10
	// Bit mask of C2 field.
	ISI_Y2R_SET0_C2_Msk = 0xff0000
	// Position of C3 field.
	ISI_Y2R_SET0_C3_Pos = 0x18
	// Bit mask of C3 field.
	ISI_Y2R_SET0_C3_Msk = 0xff000000

	// Y2R_SET1: ISI CSC YCrCb To RGB Set 1 Register
	// Position of C4 field.
	ISI_Y2R_SET1_C4_Pos = 0x0
	// Bit mask of C4 field.
	ISI_Y2R_SET1_C4_Msk = 0x1ff
	// Position of Yoff field.
	ISI_Y2R_SET1_Yoff_Pos = 0xc
	// Bit mask of Yoff field.
	ISI_Y2R_SET1_Yoff_Msk = 0x1000
	// Bit Yoff.
	ISI_Y2R_SET1_Yoff = 0x1000
	// Position of Croff field.
	ISI_Y2R_SET1_Croff_Pos = 0xd
	// Bit mask of Croff field.
	ISI_Y2R_SET1_Croff_Msk = 0x2000
	// Bit Croff.
	ISI_Y2R_SET1_Croff = 0x2000
	// Position of Cboff field.
	ISI_Y2R_SET1_Cboff_Pos = 0xe
	// Bit mask of Cboff field.
	ISI_Y2R_SET1_Cboff_Msk = 0x4000
	// Bit Cboff.
	ISI_Y2R_SET1_Cboff = 0x4000

	// R2Y_SET0: ISI CSC RGB To YCrCb Set 0 Register
	// Position of C0 field.
	ISI_R2Y_SET0_C0_Pos = 0x0
	// Bit mask of C0 field.
	ISI_R2Y_SET0_C0_Msk = 0x7f
	// Position of C1 field.
	ISI_R2Y_SET0_C1_Pos = 0x8
	// Bit mask of C1 field.
	ISI_R2Y_SET0_C1_Msk = 0x7f00
	// Position of C2 field.
	ISI_R2Y_SET0_C2_Pos = 0x10
	// Bit mask of C2 field.
	ISI_R2Y_SET0_C2_Msk = 0x7f0000
	// Position of Roff field.
	ISI_R2Y_SET0_Roff_Pos = 0x18
	// Bit mask of Roff field.
	ISI_R2Y_SET0_Roff_Msk = 0x1000000
	// Bit Roff.
	ISI_R2Y_SET0_Roff = 0x1000000

	// R2Y_SET1: ISI CSC RGB To YCrCb Set 1 Register
	// Position of C3 field.
	ISI_R2Y_SET1_C3_Pos = 0x0
	// Bit mask of C3 field.
	ISI_R2Y_SET1_C3_Msk = 0x7f
	// Position of C4 field.
	ISI_R2Y_SET1_C4_Pos = 0x8
	// Bit mask of C4 field.
	ISI_R2Y_SET1_C4_Msk = 0x7f00
	// Position of C5 field.
	ISI_R2Y_SET1_C5_Pos = 0x10
	// Bit mask of C5 field.
	ISI_R2Y_SET1_C5_Msk = 0x7f0000
	// Position of Goff field.
	ISI_R2Y_SET1_Goff_Pos = 0x18
	// Bit mask of Goff field.
	ISI_R2Y_SET1_Goff_Msk = 0x1000000
	// Bit Goff.
	ISI_R2Y_SET1_Goff = 0x1000000

	// R2Y_SET2: ISI CSC RGB To YCrCb Set 2 Register
	// Position of C6 field.
	ISI_R2Y_SET2_C6_Pos = 0x0
	// Bit mask of C6 field.
	ISI_R2Y_SET2_C6_Msk = 0x7f
	// Position of C7 field.
	ISI_R2Y_SET2_C7_Pos = 0x8
	// Bit mask of C7 field.
	ISI_R2Y_SET2_C7_Msk = 0x7f00
	// Position of C8 field.
	ISI_R2Y_SET2_C8_Pos = 0x10
	// Bit mask of C8 field.
	ISI_R2Y_SET2_C8_Msk = 0x7f0000
	// Position of Boff field.
	ISI_R2Y_SET2_Boff_Pos = 0x18
	// Bit mask of Boff field.
	ISI_R2Y_SET2_Boff_Msk = 0x1000000
	// Bit Boff.
	ISI_R2Y_SET2_Boff = 0x1000000

	// CR: ISI Control Register
	// Position of ISI_EN field.
	ISI_CR_ISI_EN_Pos = 0x0
	// Bit mask of ISI_EN field.
	ISI_CR_ISI_EN_Msk = 0x1
	// Bit ISI_EN.
	ISI_CR_ISI_EN = 0x1
	// Position of ISI_DIS field.
	ISI_CR_ISI_DIS_Pos = 0x1
	// Bit mask of ISI_DIS field.
	ISI_CR_ISI_DIS_Msk = 0x2
	// Bit ISI_DIS.
	ISI_CR_ISI_DIS = 0x2
	// Position of ISI_SRST field.
	ISI_CR_ISI_SRST_Pos = 0x2
	// Bit mask of ISI_SRST field.
	ISI_CR_ISI_SRST_Msk = 0x4
	// Bit ISI_SRST.
	ISI_CR_ISI_SRST = 0x4
	// Position of ISI_CDC field.
	ISI_CR_ISI_CDC_Pos = 0x8
	// Bit mask of ISI_CDC field.
	ISI_CR_ISI_CDC_Msk = 0x100
	// Bit ISI_CDC.
	ISI_CR_ISI_CDC = 0x100

	// SR: ISI Status Register
	// Position of ENABLE field.
	ISI_SR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	ISI_SR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	ISI_SR_ENABLE = 0x1
	// Position of DIS_DONE field.
	ISI_SR_DIS_DONE_Pos = 0x1
	// Bit mask of DIS_DONE field.
	ISI_SR_DIS_DONE_Msk = 0x2
	// Bit DIS_DONE.
	ISI_SR_DIS_DONE = 0x2
	// Position of SRST field.
	ISI_SR_SRST_Pos = 0x2
	// Bit mask of SRST field.
	ISI_SR_SRST_Msk = 0x4
	// Bit SRST.
	ISI_SR_SRST = 0x4
	// Position of CDC_PND field.
	ISI_SR_CDC_PND_Pos = 0x8
	// Bit mask of CDC_PND field.
	ISI_SR_CDC_PND_Msk = 0x100
	// Bit CDC_PND.
	ISI_SR_CDC_PND = 0x100
	// Position of VSYNC field.
	ISI_SR_VSYNC_Pos = 0xa
	// Bit mask of VSYNC field.
	ISI_SR_VSYNC_Msk = 0x400
	// Bit VSYNC.
	ISI_SR_VSYNC = 0x400
	// Position of PXFR_DONE field.
	ISI_SR_PXFR_DONE_Pos = 0x10
	// Bit mask of PXFR_DONE field.
	ISI_SR_PXFR_DONE_Msk = 0x10000
	// Bit PXFR_DONE.
	ISI_SR_PXFR_DONE = 0x10000
	// Position of CXFR_DONE field.
	ISI_SR_CXFR_DONE_Pos = 0x11
	// Bit mask of CXFR_DONE field.
	ISI_SR_CXFR_DONE_Msk = 0x20000
	// Bit CXFR_DONE.
	ISI_SR_CXFR_DONE = 0x20000
	// Position of SIP field.
	ISI_SR_SIP_Pos = 0x13
	// Bit mask of SIP field.
	ISI_SR_SIP_Msk = 0x80000
	// Bit SIP.
	ISI_SR_SIP = 0x80000
	// Position of P_OVR field.
	ISI_SR_P_OVR_Pos = 0x18
	// Bit mask of P_OVR field.
	ISI_SR_P_OVR_Msk = 0x1000000
	// Bit P_OVR.
	ISI_SR_P_OVR = 0x1000000
	// Position of C_OVR field.
	ISI_SR_C_OVR_Pos = 0x19
	// Bit mask of C_OVR field.
	ISI_SR_C_OVR_Msk = 0x2000000
	// Bit C_OVR.
	ISI_SR_C_OVR = 0x2000000
	// Position of CRC_ERR field.
	ISI_SR_CRC_ERR_Pos = 0x1a
	// Bit mask of CRC_ERR field.
	ISI_SR_CRC_ERR_Msk = 0x4000000
	// Bit CRC_ERR.
	ISI_SR_CRC_ERR = 0x4000000
	// Position of FR_OVR field.
	ISI_SR_FR_OVR_Pos = 0x1b
	// Bit mask of FR_OVR field.
	ISI_SR_FR_OVR_Msk = 0x8000000
	// Bit FR_OVR.
	ISI_SR_FR_OVR = 0x8000000

	// IER: ISI Interrupt Enable Register
	// Position of DIS_DONE field.
	ISI_IER_DIS_DONE_Pos = 0x1
	// Bit mask of DIS_DONE field.
	ISI_IER_DIS_DONE_Msk = 0x2
	// Bit DIS_DONE.
	ISI_IER_DIS_DONE = 0x2
	// Position of SRST field.
	ISI_IER_SRST_Pos = 0x2
	// Bit mask of SRST field.
	ISI_IER_SRST_Msk = 0x4
	// Bit SRST.
	ISI_IER_SRST = 0x4
	// Position of VSYNC field.
	ISI_IER_VSYNC_Pos = 0xa
	// Bit mask of VSYNC field.
	ISI_IER_VSYNC_Msk = 0x400
	// Bit VSYNC.
	ISI_IER_VSYNC = 0x400
	// Position of PXFR_DONE field.
	ISI_IER_PXFR_DONE_Pos = 0x10
	// Bit mask of PXFR_DONE field.
	ISI_IER_PXFR_DONE_Msk = 0x10000
	// Bit PXFR_DONE.
	ISI_IER_PXFR_DONE = 0x10000
	// Position of CXFR_DONE field.
	ISI_IER_CXFR_DONE_Pos = 0x11
	// Bit mask of CXFR_DONE field.
	ISI_IER_CXFR_DONE_Msk = 0x20000
	// Bit CXFR_DONE.
	ISI_IER_CXFR_DONE = 0x20000
	// Position of P_OVR field.
	ISI_IER_P_OVR_Pos = 0x18
	// Bit mask of P_OVR field.
	ISI_IER_P_OVR_Msk = 0x1000000
	// Bit P_OVR.
	ISI_IER_P_OVR = 0x1000000
	// Position of C_OVR field.
	ISI_IER_C_OVR_Pos = 0x19
	// Bit mask of C_OVR field.
	ISI_IER_C_OVR_Msk = 0x2000000
	// Bit C_OVR.
	ISI_IER_C_OVR = 0x2000000
	// Position of CRC_ERR field.
	ISI_IER_CRC_ERR_Pos = 0x1a
	// Bit mask of CRC_ERR field.
	ISI_IER_CRC_ERR_Msk = 0x4000000
	// Bit CRC_ERR.
	ISI_IER_CRC_ERR = 0x4000000
	// Position of FR_OVR field.
	ISI_IER_FR_OVR_Pos = 0x1b
	// Bit mask of FR_OVR field.
	ISI_IER_FR_OVR_Msk = 0x8000000
	// Bit FR_OVR.
	ISI_IER_FR_OVR = 0x8000000

	// IDR: ISI Interrupt Disable Register
	// Position of DIS_DONE field.
	ISI_IDR_DIS_DONE_Pos = 0x1
	// Bit mask of DIS_DONE field.
	ISI_IDR_DIS_DONE_Msk = 0x2
	// Bit DIS_DONE.
	ISI_IDR_DIS_DONE = 0x2
	// Position of SRST field.
	ISI_IDR_SRST_Pos = 0x2
	// Bit mask of SRST field.
	ISI_IDR_SRST_Msk = 0x4
	// Bit SRST.
	ISI_IDR_SRST = 0x4
	// Position of VSYNC field.
	ISI_IDR_VSYNC_Pos = 0xa
	// Bit mask of VSYNC field.
	ISI_IDR_VSYNC_Msk = 0x400
	// Bit VSYNC.
	ISI_IDR_VSYNC = 0x400
	// Position of PXFR_DONE field.
	ISI_IDR_PXFR_DONE_Pos = 0x10
	// Bit mask of PXFR_DONE field.
	ISI_IDR_PXFR_DONE_Msk = 0x10000
	// Bit PXFR_DONE.
	ISI_IDR_PXFR_DONE = 0x10000
	// Position of CXFR_DONE field.
	ISI_IDR_CXFR_DONE_Pos = 0x11
	// Bit mask of CXFR_DONE field.
	ISI_IDR_CXFR_DONE_Msk = 0x20000
	// Bit CXFR_DONE.
	ISI_IDR_CXFR_DONE = 0x20000
	// Position of P_OVR field.
	ISI_IDR_P_OVR_Pos = 0x18
	// Bit mask of P_OVR field.
	ISI_IDR_P_OVR_Msk = 0x1000000
	// Bit P_OVR.
	ISI_IDR_P_OVR = 0x1000000
	// Position of C_OVR field.
	ISI_IDR_C_OVR_Pos = 0x19
	// Bit mask of C_OVR field.
	ISI_IDR_C_OVR_Msk = 0x2000000
	// Bit C_OVR.
	ISI_IDR_C_OVR = 0x2000000
	// Position of CRC_ERR field.
	ISI_IDR_CRC_ERR_Pos = 0x1a
	// Bit mask of CRC_ERR field.
	ISI_IDR_CRC_ERR_Msk = 0x4000000
	// Bit CRC_ERR.
	ISI_IDR_CRC_ERR = 0x4000000
	// Position of FR_OVR field.
	ISI_IDR_FR_OVR_Pos = 0x1b
	// Bit mask of FR_OVR field.
	ISI_IDR_FR_OVR_Msk = 0x8000000
	// Bit FR_OVR.
	ISI_IDR_FR_OVR = 0x8000000

	// IMR: ISI Interrupt Mask Register
	// Position of DIS_DONE field.
	ISI_IMR_DIS_DONE_Pos = 0x1
	// Bit mask of DIS_DONE field.
	ISI_IMR_DIS_DONE_Msk = 0x2
	// Bit DIS_DONE.
	ISI_IMR_DIS_DONE = 0x2
	// Position of SRST field.
	ISI_IMR_SRST_Pos = 0x2
	// Bit mask of SRST field.
	ISI_IMR_SRST_Msk = 0x4
	// Bit SRST.
	ISI_IMR_SRST = 0x4
	// Position of VSYNC field.
	ISI_IMR_VSYNC_Pos = 0xa
	// Bit mask of VSYNC field.
	ISI_IMR_VSYNC_Msk = 0x400
	// Bit VSYNC.
	ISI_IMR_VSYNC = 0x400
	// Position of PXFR_DONE field.
	ISI_IMR_PXFR_DONE_Pos = 0x10
	// Bit mask of PXFR_DONE field.
	ISI_IMR_PXFR_DONE_Msk = 0x10000
	// Bit PXFR_DONE.
	ISI_IMR_PXFR_DONE = 0x10000
	// Position of CXFR_DONE field.
	ISI_IMR_CXFR_DONE_Pos = 0x11
	// Bit mask of CXFR_DONE field.
	ISI_IMR_CXFR_DONE_Msk = 0x20000
	// Bit CXFR_DONE.
	ISI_IMR_CXFR_DONE = 0x20000
	// Position of P_OVR field.
	ISI_IMR_P_OVR_Pos = 0x18
	// Bit mask of P_OVR field.
	ISI_IMR_P_OVR_Msk = 0x1000000
	// Bit P_OVR.
	ISI_IMR_P_OVR = 0x1000000
	// Position of C_OVR field.
	ISI_IMR_C_OVR_Pos = 0x19
	// Bit mask of C_OVR field.
	ISI_IMR_C_OVR_Msk = 0x2000000
	// Bit C_OVR.
	ISI_IMR_C_OVR = 0x2000000
	// Position of CRC_ERR field.
	ISI_IMR_CRC_ERR_Pos = 0x1a
	// Bit mask of CRC_ERR field.
	ISI_IMR_CRC_ERR_Msk = 0x4000000
	// Bit CRC_ERR.
	ISI_IMR_CRC_ERR = 0x4000000
	// Position of FR_OVR field.
	ISI_IMR_FR_OVR_Pos = 0x1b
	// Bit mask of FR_OVR field.
	ISI_IMR_FR_OVR_Msk = 0x8000000
	// Bit FR_OVR.
	ISI_IMR_FR_OVR = 0x8000000

	// DMA_CHER: DMA Channel Enable Register
	// Position of P_CH_EN field.
	ISI_DMA_CHER_P_CH_EN_Pos = 0x0
	// Bit mask of P_CH_EN field.
	ISI_DMA_CHER_P_CH_EN_Msk = 0x1
	// Bit P_CH_EN.
	ISI_DMA_CHER_P_CH_EN = 0x1
	// Position of C_CH_EN field.
	ISI_DMA_CHER_C_CH_EN_Pos = 0x1
	// Bit mask of C_CH_EN field.
	ISI_DMA_CHER_C_CH_EN_Msk = 0x2
	// Bit C_CH_EN.
	ISI_DMA_CHER_C_CH_EN = 0x2

	// DMA_CHDR: DMA Channel Disable Register
	// Position of P_CH_DIS field.
	ISI_DMA_CHDR_P_CH_DIS_Pos = 0x0
	// Bit mask of P_CH_DIS field.
	ISI_DMA_CHDR_P_CH_DIS_Msk = 0x1
	// Bit P_CH_DIS.
	ISI_DMA_CHDR_P_CH_DIS = 0x1
	// Position of C_CH_DIS field.
	ISI_DMA_CHDR_C_CH_DIS_Pos = 0x1
	// Bit mask of C_CH_DIS field.
	ISI_DMA_CHDR_C_CH_DIS_Msk = 0x2
	// Bit C_CH_DIS.
	ISI_DMA_CHDR_C_CH_DIS = 0x2

	// DMA_CHSR: DMA Channel Status Register
	// Position of P_CH_S field.
	ISI_DMA_CHSR_P_CH_S_Pos = 0x0
	// Bit mask of P_CH_S field.
	ISI_DMA_CHSR_P_CH_S_Msk = 0x1
	// Bit P_CH_S.
	ISI_DMA_CHSR_P_CH_S = 0x1
	// Position of C_CH_S field.
	ISI_DMA_CHSR_C_CH_S_Pos = 0x1
	// Bit mask of C_CH_S field.
	ISI_DMA_CHSR_C_CH_S_Msk = 0x2
	// Bit C_CH_S.
	ISI_DMA_CHSR_C_CH_S = 0x2

	// DMA_P_ADDR: DMA Preview Base Address Register
	// Position of P_ADDR field.
	ISI_DMA_P_ADDR_P_ADDR_Pos = 0x2
	// Bit mask of P_ADDR field.
	ISI_DMA_P_ADDR_P_ADDR_Msk = 0xfffffffc

	// DMA_P_CTRL: DMA Preview Control Register
	// Position of P_FETCH field.
	ISI_DMA_P_CTRL_P_FETCH_Pos = 0x0
	// Bit mask of P_FETCH field.
	ISI_DMA_P_CTRL_P_FETCH_Msk = 0x1
	// Bit P_FETCH.
	ISI_DMA_P_CTRL_P_FETCH = 0x1
	// Position of P_WB field.
	ISI_DMA_P_CTRL_P_WB_Pos = 0x1
	// Bit mask of P_WB field.
	ISI_DMA_P_CTRL_P_WB_Msk = 0x2
	// Bit P_WB.
	ISI_DMA_P_CTRL_P_WB = 0x2
	// Position of P_IEN field.
	ISI_DMA_P_CTRL_P_IEN_Pos = 0x2
	// Bit mask of P_IEN field.
	ISI_DMA_P_CTRL_P_IEN_Msk = 0x4
	// Bit P_IEN.
	ISI_DMA_P_CTRL_P_IEN = 0x4
	// Position of P_DONE field.
	ISI_DMA_P_CTRL_P_DONE_Pos = 0x3
	// Bit mask of P_DONE field.
	ISI_DMA_P_CTRL_P_DONE_Msk = 0x8
	// Bit P_DONE.
	ISI_DMA_P_CTRL_P_DONE = 0x8

	// DMA_P_DSCR: DMA Preview Descriptor Address Register
	// Position of P_DSCR field.
	ISI_DMA_P_DSCR_P_DSCR_Pos = 0x2
	// Bit mask of P_DSCR field.
	ISI_DMA_P_DSCR_P_DSCR_Msk = 0xfffffffc

	// DMA_C_ADDR: DMA Codec Base Address Register
	// Position of C_ADDR field.
	ISI_DMA_C_ADDR_C_ADDR_Pos = 0x2
	// Bit mask of C_ADDR field.
	ISI_DMA_C_ADDR_C_ADDR_Msk = 0xfffffffc

	// DMA_C_CTRL: DMA Codec Control Register
	// Position of C_FETCH field.
	ISI_DMA_C_CTRL_C_FETCH_Pos = 0x0
	// Bit mask of C_FETCH field.
	ISI_DMA_C_CTRL_C_FETCH_Msk = 0x1
	// Bit C_FETCH.
	ISI_DMA_C_CTRL_C_FETCH = 0x1
	// Position of C_WB field.
	ISI_DMA_C_CTRL_C_WB_Pos = 0x1
	// Bit mask of C_WB field.
	ISI_DMA_C_CTRL_C_WB_Msk = 0x2
	// Bit C_WB.
	ISI_DMA_C_CTRL_C_WB = 0x2
	// Position of C_IEN field.
	ISI_DMA_C_CTRL_C_IEN_Pos = 0x2
	// Bit mask of C_IEN field.
	ISI_DMA_C_CTRL_C_IEN_Msk = 0x4
	// Bit C_IEN.
	ISI_DMA_C_CTRL_C_IEN = 0x4
	// Position of C_DONE field.
	ISI_DMA_C_CTRL_C_DONE_Pos = 0x3
	// Bit mask of C_DONE field.
	ISI_DMA_C_CTRL_C_DONE_Msk = 0x8
	// Bit C_DONE.
	ISI_DMA_C_CTRL_C_DONE = 0x8

	// DMA_C_DSCR: DMA Codec Descriptor Address Register
	// Position of C_DSCR field.
	ISI_DMA_C_DSCR_C_DSCR_Pos = 0x2
	// Bit mask of C_DSCR field.
	ISI_DMA_C_DSCR_C_DSCR_Msk = 0xfffffffc

	// WPCR: Write Protection Control Register
	// Position of WP_EN field.
	ISI_WPCR_WP_EN_Pos = 0x0
	// Bit mask of WP_EN field.
	ISI_WPCR_WP_EN_Msk = 0x1
	// Bit WP_EN.
	ISI_WPCR_WP_EN = 0x1
	// Position of WP_KEY field.
	ISI_WPCR_WP_KEY_Pos = 0x8
	// Bit mask of WP_KEY field.
	ISI_WPCR_WP_KEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of WP_VS field.
	ISI_WPSR_WP_VS_Pos = 0x0
	// Bit mask of WP_VS field.
	ISI_WPSR_WP_VS_Msk = 0xf
	// Position of WP_VSRC field.
	ISI_WPSR_WP_VSRC_Pos = 0x8
	// Bit mask of WP_VSRC field.
	ISI_WPSR_WP_VSRC_Msk = 0xffff00
)

// Bitfields for SFR: Special Function Registers
const (
	// OHCIICR: OHCI Interrupt Configuration Register
	// Position of RES0 field.
	SFR_OHCIICR_RES0_Pos = 0x0
	// Bit mask of RES0 field.
	SFR_OHCIICR_RES0_Msk = 0x1
	// Bit RES0.
	SFR_OHCIICR_RES0 = 0x1
	// Position of RES1 field.
	SFR_OHCIICR_RES1_Pos = 0x1
	// Bit mask of RES1 field.
	SFR_OHCIICR_RES1_Msk = 0x2
	// Bit RES1.
	SFR_OHCIICR_RES1 = 0x2
	// Position of RES2 field.
	SFR_OHCIICR_RES2_Pos = 0x2
	// Bit mask of RES2 field.
	SFR_OHCIICR_RES2_Msk = 0x4
	// Bit RES2.
	SFR_OHCIICR_RES2 = 0x4
	// Position of ARIE field.
	SFR_OHCIICR_ARIE_Pos = 0x4
	// Bit mask of ARIE field.
	SFR_OHCIICR_ARIE_Msk = 0x10
	// Bit ARIE.
	SFR_OHCIICR_ARIE = 0x10
	// Position of APPSTART field.
	SFR_OHCIICR_APPSTART_Pos = 0x5
	// Bit mask of APPSTART field.
	SFR_OHCIICR_APPSTART_Msk = 0x20
	// Bit APPSTART.
	SFR_OHCIICR_APPSTART = 0x20
	// Position of UDPPUDIS field.
	SFR_OHCIICR_UDPPUDIS_Pos = 0x17
	// Bit mask of UDPPUDIS field.
	SFR_OHCIICR_UDPPUDIS_Msk = 0x800000
	// Bit UDPPUDIS.
	SFR_OHCIICR_UDPPUDIS = 0x800000

	// OHCIISR: OHCI Interrupt Status Register
	// Position of RIS0 field.
	SFR_OHCIISR_RIS0_Pos = 0x0
	// Bit mask of RIS0 field.
	SFR_OHCIISR_RIS0_Msk = 0x1
	// Bit RIS0.
	SFR_OHCIISR_RIS0 = 0x1
	// Position of RIS1 field.
	SFR_OHCIISR_RIS1_Pos = 0x1
	// Bit mask of RIS1 field.
	SFR_OHCIISR_RIS1_Msk = 0x2
	// Bit RIS1.
	SFR_OHCIISR_RIS1 = 0x2
	// Position of RIS2 field.
	SFR_OHCIISR_RIS2_Pos = 0x2
	// Bit mask of RIS2 field.
	SFR_OHCIISR_RIS2_Msk = 0x4
	// Bit RIS2.
	SFR_OHCIISR_RIS2 = 0x4

	// AHB: AHB Configuration Register
	// Position of PFETCH10 field.
	SFR_AHB_PFETCH10_Pos = 0xa
	// Bit mask of PFETCH10 field.
	SFR_AHB_PFETCH10_Msk = 0x400
	// Bit PFETCH10.
	SFR_AHB_PFETCH10 = 0x400
	// INCR undefined burst converted to burst of 4 beats.
	SFR_AHB_PFETCH10_INCR4 = 0x0
	// INCR undefined burst converted to burst of 8 beats.
	SFR_AHB_PFETCH10_INCR8 = 0x1
	// Position of PFETCH11 field.
	SFR_AHB_PFETCH11_Pos = 0xb
	// Bit mask of PFETCH11 field.
	SFR_AHB_PFETCH11_Msk = 0x800
	// Bit PFETCH11.
	SFR_AHB_PFETCH11 = 0x800
	// INCR undefined burst converted to burst of 4 beats.
	SFR_AHB_PFETCH11_INCR4 = 0x0
	// INCR undefined burst converted to burst of 8 beats.
	SFR_AHB_PFETCH11_INCR8 = 0x1
	// Position of PFETCH12 field.
	SFR_AHB_PFETCH12_Pos = 0xc
	// Bit mask of PFETCH12 field.
	SFR_AHB_PFETCH12_Msk = 0x1000
	// Bit PFETCH12.
	SFR_AHB_PFETCH12 = 0x1000
	// INCR undefined burst converted to burst of 4 beats.
	SFR_AHB_PFETCH12_INCR4 = 0x0
	// INCR undefined burst converted to burst of 8 beats.
	SFR_AHB_PFETCH12_INCR8 = 0x1
	// Position of PFETCH13 field.
	SFR_AHB_PFETCH13_Pos = 0xd
	// Bit mask of PFETCH13 field.
	SFR_AHB_PFETCH13_Msk = 0x2000
	// Bit PFETCH13.
	SFR_AHB_PFETCH13 = 0x2000
	// INCR undefined burst converted to burst of 4 beats.
	SFR_AHB_PFETCH13_INCR4 = 0x0
	// INCR undefined burst converted to burst of 8 beats.
	SFR_AHB_PFETCH13_INCR8 = 0x1
	// Position of PFETCH14 field.
	SFR_AHB_PFETCH14_Pos = 0xe
	// Bit mask of PFETCH14 field.
	SFR_AHB_PFETCH14_Msk = 0x4000
	// Bit PFETCH14.
	SFR_AHB_PFETCH14 = 0x4000
	// INCR undefined burst converted to burst of 4 beats.
	SFR_AHB_PFETCH14_INCR4 = 0x0
	// INCR undefined burst converted to burst of 8 beats.
	SFR_AHB_PFETCH14_INCR8 = 0x1
	// Position of DLBOPT10 field.
	SFR_AHB_DLBOPT10_Pos = 0x1a
	// Bit mask of DLBOPT10 field.
	SFR_AHB_DLBOPT10_Msk = 0x4000000
	// Bit DLBOPT10.
	SFR_AHB_DLBOPT10 = 0x4000000
	// Position of DLBOPT11 field.
	SFR_AHB_DLBOPT11_Pos = 0x1b
	// Bit mask of DLBOPT11 field.
	SFR_AHB_DLBOPT11_Msk = 0x8000000
	// Bit DLBOPT11.
	SFR_AHB_DLBOPT11 = 0x8000000
	// Position of DLBOPT12 field.
	SFR_AHB_DLBOPT12_Pos = 0x1c
	// Bit mask of DLBOPT12 field.
	SFR_AHB_DLBOPT12_Msk = 0x10000000
	// Bit DLBOPT12.
	SFR_AHB_DLBOPT12 = 0x10000000
	// Position of DLBOPT13 field.
	SFR_AHB_DLBOPT13_Pos = 0x1d
	// Bit mask of DLBOPT13 field.
	SFR_AHB_DLBOPT13_Msk = 0x20000000
	// Bit DLBOPT13.
	SFR_AHB_DLBOPT13 = 0x20000000
	// Position of DLBOPT14 field.
	SFR_AHB_DLBOPT14_Pos = 0x1e
	// Bit mask of DLBOPT14 field.
	SFR_AHB_DLBOPT14_Msk = 0x40000000
	// Bit DLBOPT14.
	SFR_AHB_DLBOPT14 = 0x40000000

	// BRIDGE: Bridge Configuration Register
	// Position of APBTURBO field.
	SFR_BRIDGE_APBTURBO_Pos = 0x0
	// Bit mask of APBTURBO field.
	SFR_BRIDGE_APBTURBO_Msk = 0x1
	// Bit APBTURBO.
	SFR_BRIDGE_APBTURBO = 0x1
	// Position of AXI2AHBSEL field.
	SFR_BRIDGE_AXI2AHBSEL_Pos = 0x8
	// Bit mask of AXI2AHBSEL field.
	SFR_BRIDGE_AXI2AHBSEL_Msk = 0x100
	// Bit AXI2AHBSEL.
	SFR_BRIDGE_AXI2AHBSEL = 0x100
	// use single port bridge.
	SFR_BRIDGE_AXI2AHBSEL_SINGLE = 0x0
	// use dual port bridge.
	SFR_BRIDGE_AXI2AHBSEL_DUAL = 0x1

	// SECURE: Security Configuration Register
	// Position of ROM field.
	SFR_SECURE_ROM_Pos = 0x0
	// Bit mask of ROM field.
	SFR_SECURE_ROM_Msk = 0x1
	// Bit ROM.
	SFR_SECURE_ROM = 0x1
	// Position of FUSE field.
	SFR_SECURE_FUSE_Pos = 0x8
	// Bit mask of FUSE field.
	SFR_SECURE_FUSE_Msk = 0x100
	// Bit FUSE.
	SFR_SECURE_FUSE = 0x100

	// UTMICKTRIM: UTMI Clock Trimming Register
	// Position of FREQ field.
	SFR_UTMICKTRIM_FREQ_Pos = 0x0
	// Bit mask of FREQ field.
	SFR_UTMICKTRIM_FREQ_Msk = 0x3
	// 12 MHz reference clock
	SFR_UTMICKTRIM_FREQ_12 = 0x0
	// 16 MHz reference clock
	SFR_UTMICKTRIM_FREQ_16 = 0x1
	// 24 MHz reference clock
	SFR_UTMICKTRIM_FREQ_24 = 0x2
	// 48 MHz reference clock
	SFR_UTMICKTRIM_FREQ_48 = 0x3
	// Position of VBG field.
	SFR_UTMICKTRIM_VBG_Pos = 0x10
	// Bit mask of VBG field.
	SFR_UTMICKTRIM_VBG_Msk = 0xf0000

	// UTMIHSTRIM: UTMI High Speed Trimming Register
	// Position of SQUELCH field.
	SFR_UTMIHSTRIM_SQUELCH_Pos = 0x0
	// Bit mask of SQUELCH field.
	SFR_UTMIHSTRIM_SQUELCH_Msk = 0x7
	// Position of DISC field.
	SFR_UTMIHSTRIM_DISC_Pos = 0x4
	// Bit mask of DISC field.
	SFR_UTMIHSTRIM_DISC_Msk = 0x70
	// Position of SLOPE0 field.
	SFR_UTMIHSTRIM_SLOPE0_Pos = 0x8
	// Bit mask of SLOPE0 field.
	SFR_UTMIHSTRIM_SLOPE0_Msk = 0x700
	// Position of SLOPE1 field.
	SFR_UTMIHSTRIM_SLOPE1_Pos = 0xc
	// Bit mask of SLOPE1 field.
	SFR_UTMIHSTRIM_SLOPE1_Msk = 0x7000
	// Position of SLOPE2 field.
	SFR_UTMIHSTRIM_SLOPE2_Pos = 0x10
	// Bit mask of SLOPE2 field.
	SFR_UTMIHSTRIM_SLOPE2_Msk = 0x70000

	// UTMIFSTRIM: UTMI Full Speed Trimming Register
	// Position of RISE field.
	SFR_UTMIFSTRIM_RISE_Pos = 0x0
	// Bit mask of RISE field.
	SFR_UTMIFSTRIM_RISE_Msk = 0x7
	// Position of FALL field.
	SFR_UTMIFSTRIM_FALL_Pos = 0x4
	// Bit mask of FALL field.
	SFR_UTMIFSTRIM_FALL_Msk = 0x70
	// Position of XCVR field.
	SFR_UTMIFSTRIM_XCVR_Pos = 0x8
	// Bit mask of XCVR field.
	SFR_UTMIFSTRIM_XCVR_Msk = 0x300
	// Position of ZN field.
	SFR_UTMIFSTRIM_ZN_Pos = 0x10
	// Bit mask of ZN field.
	SFR_UTMIFSTRIM_ZN_Msk = 0x70000
	// Position of ZP field.
	SFR_UTMIFSTRIM_ZP_Pos = 0x14
	// Bit mask of ZP field.
	SFR_UTMIFSTRIM_ZP_Msk = 0x700000

	// UTMISWAP: UTMI DP/DM Pin Swapping Register
	// Position of PORT0 field.
	SFR_UTMISWAP_PORT0_Pos = 0x0
	// Bit mask of PORT0 field.
	SFR_UTMISWAP_PORT0_Msk = 0x1
	// Bit PORT0.
	SFR_UTMISWAP_PORT0 = 0x1
	// DP/DM normal pinout.
	SFR_UTMISWAP_PORT0_NORMAL = 0x0
	// DP/DM swapped pinout.
	SFR_UTMISWAP_PORT0_SWAPPED = 0x1
	// Position of PORT1 field.
	SFR_UTMISWAP_PORT1_Pos = 0x1
	// Bit mask of PORT1 field.
	SFR_UTMISWAP_PORT1_Msk = 0x2
	// Bit PORT1.
	SFR_UTMISWAP_PORT1 = 0x2
	// DP/DM normal pinout.
	SFR_UTMISWAP_PORT1_NORMAL = 0x0
	// DP/DM swapped pinout.
	SFR_UTMISWAP_PORT1_SWAPPED = 0x1
	// Position of PORT2 field.
	SFR_UTMISWAP_PORT2_Pos = 0x2
	// Bit mask of PORT2 field.
	SFR_UTMISWAP_PORT2_Msk = 0x4
	// Bit PORT2.
	SFR_UTMISWAP_PORT2 = 0x4
	// DP/DM normal pinout.
	SFR_UTMISWAP_PORT2_NORMAL = 0x0
	// DP/DM swapped pinout.
	SFR_UTMISWAP_PORT2_SWAPPED = 0x1

	// EBICFG: EBI Configuration Register
	// Position of DRIVE0 field.
	SFR_EBICFG_DRIVE0_Pos = 0x0
	// Bit mask of DRIVE0 field.
	SFR_EBICFG_DRIVE0_Msk = 0x3
	// Low drive level
	SFR_EBICFG_DRIVE0_LOW = 0x0
	// Medium drive level
	SFR_EBICFG_DRIVE0_MEDIUM = 0x2
	// High drive level
	SFR_EBICFG_DRIVE0_HIGH = 0x3
	// Position of PULL0 field.
	SFR_EBICFG_PULL0_Pos = 0x2
	// Bit mask of PULL0 field.
	SFR_EBICFG_PULL0_Msk = 0xc
	// Pull-up
	SFR_EBICFG_PULL0_UP = 0x0
	// No Pull
	SFR_EBICFG_PULL0_NONE = 0x1
	// Pull-down
	SFR_EBICFG_PULL0_DOWN = 0x3
	// Position of SCH0 field.
	SFR_EBICFG_SCH0_Pos = 0x4
	// Bit mask of SCH0 field.
	SFR_EBICFG_SCH0_Msk = 0x10
	// Bit SCH0.
	SFR_EBICFG_SCH0 = 0x10
	// Position of DRIVE1 field.
	SFR_EBICFG_DRIVE1_Pos = 0x8
	// Bit mask of DRIVE1 field.
	SFR_EBICFG_DRIVE1_Msk = 0x300
	// Low drive level
	SFR_EBICFG_DRIVE1_LOW = 0x0
	// Medium drive level
	SFR_EBICFG_DRIVE1_MEDIUM = 0x2
	// High drive level
	SFR_EBICFG_DRIVE1_HIGH = 0x3
	// Position of PULL1 field.
	SFR_EBICFG_PULL1_Pos = 0xa
	// Bit mask of PULL1 field.
	SFR_EBICFG_PULL1_Msk = 0xc00
	// Pull-up
	SFR_EBICFG_PULL1_UP = 0x0
	// No Pull
	SFR_EBICFG_PULL1_NONE = 0x1
	// Pull-down
	SFR_EBICFG_PULL1_DOWN = 0x3
	// Position of SCH1 field.
	SFR_EBICFG_SCH1_Pos = 0xc
	// Bit mask of SCH1 field.
	SFR_EBICFG_SCH1_Msk = 0x1000
	// Bit SCH1.
	SFR_EBICFG_SCH1 = 0x1000
	// Position of BMS field.
	SFR_EBICFG_BMS_Pos = 0x10
	// Bit mask of BMS field.
	SFR_EBICFG_BMS_Msk = 0x10000
	// Bit BMS.
	SFR_EBICFG_BMS = 0x10000
	// Boot on ROM.
	SFR_EBICFG_BMS_ROM = 0x0
	// Boot on EBI.
	SFR_EBICFG_BMS_EBI = 0x1
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// CR: Control Register
	// Position of SWRST field.
	ADC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CR_SWRST = 0x1
	// Position of START field.
	ADC_CR_START_Pos = 0x1
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x2
	// Bit START.
	ADC_CR_START = 0x2
	// Position of TSCALIB field.
	ADC_CR_TSCALIB_Pos = 0x2
	// Bit mask of TSCALIB field.
	ADC_CR_TSCALIB_Msk = 0x4
	// Bit TSCALIB.
	ADC_CR_TSCALIB = 0x4
	// Position of AUTOCAL field.
	ADC_CR_AUTOCAL_Pos = 0x3
	// Bit mask of AUTOCAL field.
	ADC_CR_AUTOCAL_Msk = 0x8
	// Bit AUTOCAL.
	ADC_CR_AUTOCAL = 0x8

	// MR: Mode Register
	// Position of TRGSEL field.
	ADC_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	ADC_MR_TRGSEL_Msk = 0xe
	// ADTRG
	ADC_MR_TRGSEL_ADC_TRIG0 = 0x0
	// TIOA0
	ADC_MR_TRGSEL_ADC_TRIG1 = 0x1
	// TIOA1
	ADC_MR_TRGSEL_ADC_TRIG2 = 0x2
	// TIOA2
	ADC_MR_TRGSEL_ADC_TRIG3 = 0x3
	// PWM event line 0
	ADC_MR_TRGSEL_ADC_TRIG4 = 0x4
	// PWM_even line 1
	ADC_MR_TRGSEL_ADC_TRIG5 = 0x5
	// Position of SLEEP field.
	ADC_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	ADC_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	ADC_MR_SLEEP = 0x20
	// Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions
	ADC_MR_SLEEP_NORMAL = 0x0
	// Sleep Mode: The wake-up time can be modified by programming FWUP bit
	ADC_MR_SLEEP_SLEEP = 0x1
	// Position of FWUP field.
	ADC_MR_FWUP_Pos = 0x6
	// Bit mask of FWUP field.
	ADC_MR_FWUP_Msk = 0x40
	// Bit FWUP.
	ADC_MR_FWUP = 0x40
	// If SLEEP is 1 then both ADC Core and reference voltage circuitry are OFF between conversions
	ADC_MR_FWUP_OFF = 0x0
	// If SLEEP is 1 then Fast Wake-up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF
	ADC_MR_FWUP_ON = 0x1
	// Position of PRESCAL field.
	ADC_MR_PRESCAL_Pos = 0x8
	// Bit mask of PRESCAL field.
	ADC_MR_PRESCAL_Msk = 0xff00
	// Position of STARTUP field.
	ADC_MR_STARTUP_Pos = 0x10
	// Bit mask of STARTUP field.
	ADC_MR_STARTUP_Msk = 0xf0000
	// 0 periods of ADCClock
	ADC_MR_STARTUP_SUT0 = 0x0
	// 8 periods of ADCClock
	ADC_MR_STARTUP_SUT8 = 0x1
	// 16 periods of ADCClock
	ADC_MR_STARTUP_SUT16 = 0x2
	// 24 periods of ADCClock
	ADC_MR_STARTUP_SUT24 = 0x3
	// 64 periods of ADCClock
	ADC_MR_STARTUP_SUT64 = 0x4
	// 80 periods of ADCClock
	ADC_MR_STARTUP_SUT80 = 0x5
	// 96 periods of ADCClock
	ADC_MR_STARTUP_SUT96 = 0x6
	// 112 periods of ADCClock
	ADC_MR_STARTUP_SUT112 = 0x7
	// 512 periods of ADCClock
	ADC_MR_STARTUP_SUT512 = 0x8
	// 576 periods of ADCClock
	ADC_MR_STARTUP_SUT576 = 0x9
	// 640 periods of ADCClock
	ADC_MR_STARTUP_SUT640 = 0xa
	// 704 periods of ADCClock
	ADC_MR_STARTUP_SUT704 = 0xb
	// 768 periods of ADCClock
	ADC_MR_STARTUP_SUT768 = 0xc
	// 832 periods of ADCClock
	ADC_MR_STARTUP_SUT832 = 0xd
	// 896 periods of ADCClock
	ADC_MR_STARTUP_SUT896 = 0xe
	// 960 periods of ADCClock
	ADC_MR_STARTUP_SUT960 = 0xf
	// Position of SETTLING field.
	ADC_MR_SETTLING_Pos = 0x14
	// Bit mask of SETTLING field.
	ADC_MR_SETTLING_Msk = 0x300000
	// 3 periods of ADCClock
	ADC_MR_SETTLING_AST3 = 0x0
	// 5 periods of ADCClock
	ADC_MR_SETTLING_AST5 = 0x1
	// 9 periods of ADCClock
	ADC_MR_SETTLING_AST9 = 0x2
	// 17 periods of ADCClock
	ADC_MR_SETTLING_AST17 = 0x3
	// Position of ANACH field.
	ADC_MR_ANACH_Pos = 0x17
	// Bit mask of ANACH field.
	ADC_MR_ANACH_Msk = 0x800000
	// Bit ANACH.
	ADC_MR_ANACH = 0x800000
	// No analog change on channel switching: DIFF0, GAIN0 and OFF0 are used for all channels
	ADC_MR_ANACH_NONE = 0x0
	// Allows different analog settings for each channel. See ADC_CGR and ADC_COR Registers
	ADC_MR_ANACH_ALLOWED = 0x1
	// Position of TRACKTIM field.
	ADC_MR_TRACKTIM_Pos = 0x18
	// Bit mask of TRACKTIM field.
	ADC_MR_TRACKTIM_Msk = 0xf000000
	// Position of USEQ field.
	ADC_MR_USEQ_Pos = 0x1f
	// Bit mask of USEQ field.
	ADC_MR_USEQ_Msk = 0x80000000
	// Bit USEQ.
	ADC_MR_USEQ = 0x80000000
	// Normal Mode: The controller converts channels in a simple numeric order depending only on the channel index.
	ADC_MR_USEQ_NUM_ORDER = 0x0
	// User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers and can be used to convert several times the same channel.
	ADC_MR_USEQ_REG_ORDER = 0x1

	// SEQR1: Channel Sequence Register 1
	// Position of USCH1 field.
	ADC_SEQR1_USCH1_Pos = 0x0
	// Bit mask of USCH1 field.
	ADC_SEQR1_USCH1_Msk = 0xf
	// Position of USCH2 field.
	ADC_SEQR1_USCH2_Pos = 0x4
	// Bit mask of USCH2 field.
	ADC_SEQR1_USCH2_Msk = 0xf0
	// Position of USCH3 field.
	ADC_SEQR1_USCH3_Pos = 0x8
	// Bit mask of USCH3 field.
	ADC_SEQR1_USCH3_Msk = 0xf00
	// Position of USCH4 field.
	ADC_SEQR1_USCH4_Pos = 0xc
	// Bit mask of USCH4 field.
	ADC_SEQR1_USCH4_Msk = 0xf000
	// Position of USCH5 field.
	ADC_SEQR1_USCH5_Pos = 0x10
	// Bit mask of USCH5 field.
	ADC_SEQR1_USCH5_Msk = 0xf0000
	// Position of USCH6 field.
	ADC_SEQR1_USCH6_Pos = 0x14
	// Bit mask of USCH6 field.
	ADC_SEQR1_USCH6_Msk = 0xf00000
	// Position of USCH7 field.
	ADC_SEQR1_USCH7_Pos = 0x18
	// Bit mask of USCH7 field.
	ADC_SEQR1_USCH7_Msk = 0xf000000
	// Position of USCH8 field.
	ADC_SEQR1_USCH8_Pos = 0x1c
	// Bit mask of USCH8 field.
	ADC_SEQR1_USCH8_Msk = 0xf0000000

	// SEQR2: Channel Sequence Register 2
	// Position of USCH9 field.
	ADC_SEQR2_USCH9_Pos = 0x0
	// Bit mask of USCH9 field.
	ADC_SEQR2_USCH9_Msk = 0xf
	// Position of USCH10 field.
	ADC_SEQR2_USCH10_Pos = 0x4
	// Bit mask of USCH10 field.
	ADC_SEQR2_USCH10_Msk = 0xf0
	// Position of USCH11 field.
	ADC_SEQR2_USCH11_Pos = 0x8
	// Bit mask of USCH11 field.
	ADC_SEQR2_USCH11_Msk = 0xf00

	// CHER: Channel Enable Register
	// Position of CH0 field.
	ADC_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHER_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHER_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHER_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHER_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHER_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHER_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHER_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHER_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHER_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHER_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHER_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHER_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHER_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHER_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHER_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHER_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHER_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHER_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHER_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHER_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHER_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHER_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHER_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHER_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHER_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHER_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHER_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHER_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHER_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHER_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHER_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHER_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHER_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHER_CH11 = 0x800

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	ADC_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHDR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHDR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHDR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHDR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHDR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHDR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHDR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHDR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHDR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHDR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHDR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHDR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHDR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHDR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHDR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHDR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHDR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHDR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHDR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHDR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHDR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHDR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHDR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHDR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHDR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHDR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHDR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHDR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHDR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHDR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHDR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHDR_CH11 = 0x800

	// CHSR: Channel Status Register
	// Position of CH0 field.
	ADC_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHSR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHSR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHSR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHSR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHSR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHSR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHSR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHSR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHSR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHSR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHSR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHSR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHSR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHSR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHSR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHSR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHSR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHSR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHSR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHSR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHSR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHSR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHSR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHSR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHSR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHSR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHSR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHSR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHSR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHSR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHSR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHSR_CH11 = 0x800

	// LCDR: Last Converted Data Register
	// Position of LDATA field.
	ADC_LCDR_LDATA_Pos = 0x0
	// Bit mask of LDATA field.
	ADC_LCDR_LDATA_Msk = 0xfff
	// Position of CHNB field.
	ADC_LCDR_CHNB_Pos = 0xc
	// Bit mask of CHNB field.
	ADC_LCDR_CHNB_Msk = 0xf000

	// IER: Interrupt Enable Register
	// Position of EOC0 field.
	ADC_IER_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IER_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IER_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IER_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IER_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IER_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IER_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IER_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IER_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IER_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IER_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IER_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IER_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IER_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IER_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IER_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IER_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IER_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IER_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IER_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IER_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IER_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IER_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IER_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IER_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IER_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IER_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IER_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IER_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IER_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IER_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IER_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IER_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IER_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IER_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IER_EOC11 = 0x800
	// Position of XRDY field.
	ADC_IER_XRDY_Pos = 0x14
	// Bit mask of XRDY field.
	ADC_IER_XRDY_Msk = 0x100000
	// Bit XRDY.
	ADC_IER_XRDY = 0x100000
	// Position of YRDY field.
	ADC_IER_YRDY_Pos = 0x15
	// Bit mask of YRDY field.
	ADC_IER_YRDY_Msk = 0x200000
	// Bit YRDY.
	ADC_IER_YRDY = 0x200000
	// Position of PRDY field.
	ADC_IER_PRDY_Pos = 0x16
	// Bit mask of PRDY field.
	ADC_IER_PRDY_Msk = 0x400000
	// Bit PRDY.
	ADC_IER_PRDY = 0x400000
	// Position of EOCAL field.
	ADC_IER_EOCAL_Pos = 0x17
	// Bit mask of EOCAL field.
	ADC_IER_EOCAL_Msk = 0x800000
	// Bit EOCAL.
	ADC_IER_EOCAL = 0x800000
	// Position of DRDY field.
	ADC_IER_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IER_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IER_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IER_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IER_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IER_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IER_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IER_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IER_COMPE = 0x4000000
	// Position of PEN field.
	ADC_IER_PEN_Pos = 0x1d
	// Bit mask of PEN field.
	ADC_IER_PEN_Msk = 0x20000000
	// Bit PEN.
	ADC_IER_PEN = 0x20000000
	// Position of NOPEN field.
	ADC_IER_NOPEN_Pos = 0x1e
	// Bit mask of NOPEN field.
	ADC_IER_NOPEN_Msk = 0x40000000
	// Bit NOPEN.
	ADC_IER_NOPEN = 0x40000000

	// IDR: Interrupt Disable Register
	// Position of EOC0 field.
	ADC_IDR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IDR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IDR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IDR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IDR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IDR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IDR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IDR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IDR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IDR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IDR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IDR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IDR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IDR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IDR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IDR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IDR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IDR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IDR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IDR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IDR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IDR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IDR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IDR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IDR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IDR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IDR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IDR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IDR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IDR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IDR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IDR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IDR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IDR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IDR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IDR_EOC11 = 0x800
	// Position of XRDY field.
	ADC_IDR_XRDY_Pos = 0x14
	// Bit mask of XRDY field.
	ADC_IDR_XRDY_Msk = 0x100000
	// Bit XRDY.
	ADC_IDR_XRDY = 0x100000
	// Position of YRDY field.
	ADC_IDR_YRDY_Pos = 0x15
	// Bit mask of YRDY field.
	ADC_IDR_YRDY_Msk = 0x200000
	// Bit YRDY.
	ADC_IDR_YRDY = 0x200000
	// Position of PRDY field.
	ADC_IDR_PRDY_Pos = 0x16
	// Bit mask of PRDY field.
	ADC_IDR_PRDY_Msk = 0x400000
	// Bit PRDY.
	ADC_IDR_PRDY = 0x400000
	// Position of EOCAL field.
	ADC_IDR_EOCAL_Pos = 0x17
	// Bit mask of EOCAL field.
	ADC_IDR_EOCAL_Msk = 0x800000
	// Bit EOCAL.
	ADC_IDR_EOCAL = 0x800000
	// Position of DRDY field.
	ADC_IDR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IDR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IDR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IDR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IDR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IDR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IDR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IDR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IDR_COMPE = 0x4000000
	// Position of PEN field.
	ADC_IDR_PEN_Pos = 0x1d
	// Bit mask of PEN field.
	ADC_IDR_PEN_Msk = 0x20000000
	// Bit PEN.
	ADC_IDR_PEN = 0x20000000
	// Position of NOPEN field.
	ADC_IDR_NOPEN_Pos = 0x1e
	// Bit mask of NOPEN field.
	ADC_IDR_NOPEN_Msk = 0x40000000
	// Bit NOPEN.
	ADC_IDR_NOPEN = 0x40000000

	// IMR: Interrupt Mask Register
	// Position of EOC0 field.
	ADC_IMR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IMR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IMR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IMR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IMR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IMR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IMR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IMR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IMR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IMR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IMR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IMR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IMR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IMR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IMR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IMR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IMR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IMR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IMR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IMR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IMR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IMR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IMR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IMR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IMR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IMR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IMR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IMR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IMR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IMR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IMR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IMR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IMR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IMR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IMR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IMR_EOC11 = 0x800
	// Position of XRDY field.
	ADC_IMR_XRDY_Pos = 0x14
	// Bit mask of XRDY field.
	ADC_IMR_XRDY_Msk = 0x100000
	// Bit XRDY.
	ADC_IMR_XRDY = 0x100000
	// Position of YRDY field.
	ADC_IMR_YRDY_Pos = 0x15
	// Bit mask of YRDY field.
	ADC_IMR_YRDY_Msk = 0x200000
	// Bit YRDY.
	ADC_IMR_YRDY = 0x200000
	// Position of PRDY field.
	ADC_IMR_PRDY_Pos = 0x16
	// Bit mask of PRDY field.
	ADC_IMR_PRDY_Msk = 0x400000
	// Bit PRDY.
	ADC_IMR_PRDY = 0x400000
	// Position of EOCAL field.
	ADC_IMR_EOCAL_Pos = 0x17
	// Bit mask of EOCAL field.
	ADC_IMR_EOCAL_Msk = 0x800000
	// Bit EOCAL.
	ADC_IMR_EOCAL = 0x800000
	// Position of DRDY field.
	ADC_IMR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IMR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IMR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IMR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IMR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IMR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IMR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IMR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IMR_COMPE = 0x4000000
	// Position of PEN field.
	ADC_IMR_PEN_Pos = 0x1d
	// Bit mask of PEN field.
	ADC_IMR_PEN_Msk = 0x20000000
	// Bit PEN.
	ADC_IMR_PEN = 0x20000000
	// Position of NOPEN field.
	ADC_IMR_NOPEN_Pos = 0x1e
	// Bit mask of NOPEN field.
	ADC_IMR_NOPEN_Msk = 0x40000000
	// Bit NOPEN.
	ADC_IMR_NOPEN = 0x40000000

	// ISR: Interrupt Status Register
	// Position of EOC0 field.
	ADC_ISR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_ISR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_ISR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_ISR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_ISR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_ISR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_ISR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_ISR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_ISR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_ISR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_ISR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_ISR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_ISR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_ISR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_ISR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_ISR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_ISR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_ISR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_ISR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_ISR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_ISR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_ISR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_ISR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_ISR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_ISR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_ISR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_ISR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_ISR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_ISR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_ISR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_ISR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_ISR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_ISR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_ISR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_ISR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_ISR_EOC11 = 0x800
	// Position of XRDY field.
	ADC_ISR_XRDY_Pos = 0x14
	// Bit mask of XRDY field.
	ADC_ISR_XRDY_Msk = 0x100000
	// Bit XRDY.
	ADC_ISR_XRDY = 0x100000
	// Position of YRDY field.
	ADC_ISR_YRDY_Pos = 0x15
	// Bit mask of YRDY field.
	ADC_ISR_YRDY_Msk = 0x200000
	// Bit YRDY.
	ADC_ISR_YRDY = 0x200000
	// Position of PRDY field.
	ADC_ISR_PRDY_Pos = 0x16
	// Bit mask of PRDY field.
	ADC_ISR_PRDY_Msk = 0x400000
	// Bit PRDY.
	ADC_ISR_PRDY = 0x400000
	// Position of EOCAL field.
	ADC_ISR_EOCAL_Pos = 0x17
	// Bit mask of EOCAL field.
	ADC_ISR_EOCAL_Msk = 0x800000
	// Bit EOCAL.
	ADC_ISR_EOCAL = 0x800000
	// Position of DRDY field.
	ADC_ISR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_ISR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_ISR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_ISR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_ISR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_ISR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_ISR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_ISR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_ISR_COMPE = 0x4000000
	// Position of PEN field.
	ADC_ISR_PEN_Pos = 0x1d
	// Bit mask of PEN field.
	ADC_ISR_PEN_Msk = 0x20000000
	// Bit PEN.
	ADC_ISR_PEN = 0x20000000
	// Position of NOPEN field.
	ADC_ISR_NOPEN_Pos = 0x1e
	// Bit mask of NOPEN field.
	ADC_ISR_NOPEN_Msk = 0x40000000
	// Bit NOPEN.
	ADC_ISR_NOPEN = 0x40000000
	// Position of PENS field.
	ADC_ISR_PENS_Pos = 0x1f
	// Bit mask of PENS field.
	ADC_ISR_PENS_Msk = 0x80000000
	// Bit PENS.
	ADC_ISR_PENS = 0x80000000

	// OVER: Overrun Status Register
	// Position of OVRE0 field.
	ADC_OVER_OVRE0_Pos = 0x0
	// Bit mask of OVRE0 field.
	ADC_OVER_OVRE0_Msk = 0x1
	// Bit OVRE0.
	ADC_OVER_OVRE0 = 0x1
	// Position of OVRE1 field.
	ADC_OVER_OVRE1_Pos = 0x1
	// Bit mask of OVRE1 field.
	ADC_OVER_OVRE1_Msk = 0x2
	// Bit OVRE1.
	ADC_OVER_OVRE1 = 0x2
	// Position of OVRE2 field.
	ADC_OVER_OVRE2_Pos = 0x2
	// Bit mask of OVRE2 field.
	ADC_OVER_OVRE2_Msk = 0x4
	// Bit OVRE2.
	ADC_OVER_OVRE2 = 0x4
	// Position of OVRE3 field.
	ADC_OVER_OVRE3_Pos = 0x3
	// Bit mask of OVRE3 field.
	ADC_OVER_OVRE3_Msk = 0x8
	// Bit OVRE3.
	ADC_OVER_OVRE3 = 0x8
	// Position of OVRE4 field.
	ADC_OVER_OVRE4_Pos = 0x4
	// Bit mask of OVRE4 field.
	ADC_OVER_OVRE4_Msk = 0x10
	// Bit OVRE4.
	ADC_OVER_OVRE4 = 0x10
	// Position of OVRE5 field.
	ADC_OVER_OVRE5_Pos = 0x5
	// Bit mask of OVRE5 field.
	ADC_OVER_OVRE5_Msk = 0x20
	// Bit OVRE5.
	ADC_OVER_OVRE5 = 0x20
	// Position of OVRE6 field.
	ADC_OVER_OVRE6_Pos = 0x6
	// Bit mask of OVRE6 field.
	ADC_OVER_OVRE6_Msk = 0x40
	// Bit OVRE6.
	ADC_OVER_OVRE6 = 0x40
	// Position of OVRE7 field.
	ADC_OVER_OVRE7_Pos = 0x7
	// Bit mask of OVRE7 field.
	ADC_OVER_OVRE7_Msk = 0x80
	// Bit OVRE7.
	ADC_OVER_OVRE7 = 0x80
	// Position of OVRE8 field.
	ADC_OVER_OVRE8_Pos = 0x8
	// Bit mask of OVRE8 field.
	ADC_OVER_OVRE8_Msk = 0x100
	// Bit OVRE8.
	ADC_OVER_OVRE8 = 0x100
	// Position of OVRE9 field.
	ADC_OVER_OVRE9_Pos = 0x9
	// Bit mask of OVRE9 field.
	ADC_OVER_OVRE9_Msk = 0x200
	// Bit OVRE9.
	ADC_OVER_OVRE9 = 0x200
	// Position of OVRE10 field.
	ADC_OVER_OVRE10_Pos = 0xa
	// Bit mask of OVRE10 field.
	ADC_OVER_OVRE10_Msk = 0x400
	// Bit OVRE10.
	ADC_OVER_OVRE10 = 0x400
	// Position of OVRE11 field.
	ADC_OVER_OVRE11_Pos = 0xb
	// Bit mask of OVRE11 field.
	ADC_OVER_OVRE11_Msk = 0x800
	// Bit OVRE11.
	ADC_OVER_OVRE11 = 0x800

	// EMR: Extended Mode Register
	// Position of CMPMODE field.
	ADC_EMR_CMPMODE_Pos = 0x0
	// Bit mask of CMPMODE field.
	ADC_EMR_CMPMODE_Msk = 0x3
	// Generates an event when the converted data is lower than the low threshold of the window.
	ADC_EMR_CMPMODE_LOW = 0x0
	// Generates an event when the converted data is higher than the high threshold of the window.
	ADC_EMR_CMPMODE_HIGH = 0x1
	// Generates an event when the converted data is in the comparison window.
	ADC_EMR_CMPMODE_IN = 0x2
	// Generates an event when the converted data is out of the comparison window.
	ADC_EMR_CMPMODE_OUT = 0x3
	// Position of CMPSEL field.
	ADC_EMR_CMPSEL_Pos = 0x4
	// Bit mask of CMPSEL field.
	ADC_EMR_CMPSEL_Msk = 0xf0
	// Position of CMPALL field.
	ADC_EMR_CMPALL_Pos = 0x9
	// Bit mask of CMPALL field.
	ADC_EMR_CMPALL_Msk = 0x200
	// Bit CMPALL.
	ADC_EMR_CMPALL = 0x200
	// Position of CMPFILTER field.
	ADC_EMR_CMPFILTER_Pos = 0xc
	// Bit mask of CMPFILTER field.
	ADC_EMR_CMPFILTER_Msk = 0x3000
	// Position of TAG field.
	ADC_EMR_TAG_Pos = 0x18
	// Bit mask of TAG field.
	ADC_EMR_TAG_Msk = 0x1000000
	// Bit TAG.
	ADC_EMR_TAG = 0x1000000

	// CWR: Compare Window Register
	// Position of LOWTHRES field.
	ADC_CWR_LOWTHRES_Pos = 0x0
	// Bit mask of LOWTHRES field.
	ADC_CWR_LOWTHRES_Msk = 0xfff
	// Position of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Pos = 0x10
	// Bit mask of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Msk = 0xfff0000

	// CGR: Channel Gain Register
	// Position of GAIN0 field.
	ADC_CGR_GAIN0_Pos = 0x0
	// Bit mask of GAIN0 field.
	ADC_CGR_GAIN0_Msk = 0x3
	// Position of GAIN1 field.
	ADC_CGR_GAIN1_Pos = 0x2
	// Bit mask of GAIN1 field.
	ADC_CGR_GAIN1_Msk = 0xc
	// Position of GAIN2 field.
	ADC_CGR_GAIN2_Pos = 0x4
	// Bit mask of GAIN2 field.
	ADC_CGR_GAIN2_Msk = 0x30
	// Position of GAIN3 field.
	ADC_CGR_GAIN3_Pos = 0x6
	// Bit mask of GAIN3 field.
	ADC_CGR_GAIN3_Msk = 0xc0
	// Position of GAIN4 field.
	ADC_CGR_GAIN4_Pos = 0x8
	// Bit mask of GAIN4 field.
	ADC_CGR_GAIN4_Msk = 0x300
	// Position of GAIN5 field.
	ADC_CGR_GAIN5_Pos = 0xa
	// Bit mask of GAIN5 field.
	ADC_CGR_GAIN5_Msk = 0xc00
	// Position of GAIN6 field.
	ADC_CGR_GAIN6_Pos = 0xc
	// Bit mask of GAIN6 field.
	ADC_CGR_GAIN6_Msk = 0x3000
	// Position of GAIN7 field.
	ADC_CGR_GAIN7_Pos = 0xe
	// Bit mask of GAIN7 field.
	ADC_CGR_GAIN7_Msk = 0xc000
	// Position of GAIN8 field.
	ADC_CGR_GAIN8_Pos = 0x10
	// Bit mask of GAIN8 field.
	ADC_CGR_GAIN8_Msk = 0x30000
	// Position of GAIN9 field.
	ADC_CGR_GAIN9_Pos = 0x12
	// Bit mask of GAIN9 field.
	ADC_CGR_GAIN9_Msk = 0xc0000
	// Position of GAIN10 field.
	ADC_CGR_GAIN10_Pos = 0x14
	// Bit mask of GAIN10 field.
	ADC_CGR_GAIN10_Msk = 0x300000
	// Position of GAIN11 field.
	ADC_CGR_GAIN11_Pos = 0x16
	// Bit mask of GAIN11 field.
	ADC_CGR_GAIN11_Msk = 0xc00000

	// COR: Channel Offset Register
	// Position of OFF0 field.
	ADC_COR_OFF0_Pos = 0x0
	// Bit mask of OFF0 field.
	ADC_COR_OFF0_Msk = 0x1
	// Bit OFF0.
	ADC_COR_OFF0 = 0x1
	// Position of OFF1 field.
	ADC_COR_OFF1_Pos = 0x1
	// Bit mask of OFF1 field.
	ADC_COR_OFF1_Msk = 0x2
	// Bit OFF1.
	ADC_COR_OFF1 = 0x2
	// Position of OFF2 field.
	ADC_COR_OFF2_Pos = 0x2
	// Bit mask of OFF2 field.
	ADC_COR_OFF2_Msk = 0x4
	// Bit OFF2.
	ADC_COR_OFF2 = 0x4
	// Position of OFF3 field.
	ADC_COR_OFF3_Pos = 0x3
	// Bit mask of OFF3 field.
	ADC_COR_OFF3_Msk = 0x8
	// Bit OFF3.
	ADC_COR_OFF3 = 0x8
	// Position of OFF4 field.
	ADC_COR_OFF4_Pos = 0x4
	// Bit mask of OFF4 field.
	ADC_COR_OFF4_Msk = 0x10
	// Bit OFF4.
	ADC_COR_OFF4 = 0x10
	// Position of OFF5 field.
	ADC_COR_OFF5_Pos = 0x5
	// Bit mask of OFF5 field.
	ADC_COR_OFF5_Msk = 0x20
	// Bit OFF5.
	ADC_COR_OFF5 = 0x20
	// Position of OFF6 field.
	ADC_COR_OFF6_Pos = 0x6
	// Bit mask of OFF6 field.
	ADC_COR_OFF6_Msk = 0x40
	// Bit OFF6.
	ADC_COR_OFF6 = 0x40
	// Position of OFF7 field.
	ADC_COR_OFF7_Pos = 0x7
	// Bit mask of OFF7 field.
	ADC_COR_OFF7_Msk = 0x80
	// Bit OFF7.
	ADC_COR_OFF7 = 0x80
	// Position of OFF8 field.
	ADC_COR_OFF8_Pos = 0x8
	// Bit mask of OFF8 field.
	ADC_COR_OFF8_Msk = 0x100
	// Bit OFF8.
	ADC_COR_OFF8 = 0x100
	// Position of OFF9 field.
	ADC_COR_OFF9_Pos = 0x9
	// Bit mask of OFF9 field.
	ADC_COR_OFF9_Msk = 0x200
	// Bit OFF9.
	ADC_COR_OFF9 = 0x200
	// Position of OFF10 field.
	ADC_COR_OFF10_Pos = 0xa
	// Bit mask of OFF10 field.
	ADC_COR_OFF10_Msk = 0x400
	// Bit OFF10.
	ADC_COR_OFF10 = 0x400
	// Position of OFF11 field.
	ADC_COR_OFF11_Pos = 0xb
	// Bit mask of OFF11 field.
	ADC_COR_OFF11_Msk = 0x800
	// Bit OFF11.
	ADC_COR_OFF11 = 0x800
	// Position of DIFF0 field.
	ADC_COR_DIFF0_Pos = 0x10
	// Bit mask of DIFF0 field.
	ADC_COR_DIFF0_Msk = 0x10000
	// Bit DIFF0.
	ADC_COR_DIFF0 = 0x10000
	// Position of DIFF1 field.
	ADC_COR_DIFF1_Pos = 0x11
	// Bit mask of DIFF1 field.
	ADC_COR_DIFF1_Msk = 0x20000
	// Bit DIFF1.
	ADC_COR_DIFF1 = 0x20000
	// Position of DIFF2 field.
	ADC_COR_DIFF2_Pos = 0x12
	// Bit mask of DIFF2 field.
	ADC_COR_DIFF2_Msk = 0x40000
	// Bit DIFF2.
	ADC_COR_DIFF2 = 0x40000
	// Position of DIFF3 field.
	ADC_COR_DIFF3_Pos = 0x13
	// Bit mask of DIFF3 field.
	ADC_COR_DIFF3_Msk = 0x80000
	// Bit DIFF3.
	ADC_COR_DIFF3 = 0x80000
	// Position of DIFF4 field.
	ADC_COR_DIFF4_Pos = 0x14
	// Bit mask of DIFF4 field.
	ADC_COR_DIFF4_Msk = 0x100000
	// Bit DIFF4.
	ADC_COR_DIFF4 = 0x100000
	// Position of DIFF5 field.
	ADC_COR_DIFF5_Pos = 0x15
	// Bit mask of DIFF5 field.
	ADC_COR_DIFF5_Msk = 0x200000
	// Bit DIFF5.
	ADC_COR_DIFF5 = 0x200000
	// Position of DIFF6 field.
	ADC_COR_DIFF6_Pos = 0x16
	// Bit mask of DIFF6 field.
	ADC_COR_DIFF6_Msk = 0x400000
	// Bit DIFF6.
	ADC_COR_DIFF6 = 0x400000
	// Position of DIFF7 field.
	ADC_COR_DIFF7_Pos = 0x17
	// Bit mask of DIFF7 field.
	ADC_COR_DIFF7_Msk = 0x800000
	// Bit DIFF7.
	ADC_COR_DIFF7 = 0x800000
	// Position of DIFF8 field.
	ADC_COR_DIFF8_Pos = 0x18
	// Bit mask of DIFF8 field.
	ADC_COR_DIFF8_Msk = 0x1000000
	// Bit DIFF8.
	ADC_COR_DIFF8 = 0x1000000
	// Position of DIFF9 field.
	ADC_COR_DIFF9_Pos = 0x19
	// Bit mask of DIFF9 field.
	ADC_COR_DIFF9_Msk = 0x2000000
	// Bit DIFF9.
	ADC_COR_DIFF9 = 0x2000000
	// Position of DIFF10 field.
	ADC_COR_DIFF10_Pos = 0x1a
	// Bit mask of DIFF10 field.
	ADC_COR_DIFF10_Msk = 0x4000000
	// Bit DIFF10.
	ADC_COR_DIFF10 = 0x4000000
	// Position of DIFF11 field.
	ADC_COR_DIFF11_Pos = 0x1b
	// Bit mask of DIFF11 field.
	ADC_COR_DIFF11_Msk = 0x8000000
	// Bit DIFF11.
	ADC_COR_DIFF11 = 0x8000000

	// CDR: Channel Data Register
	// Position of DATA field.
	ADC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_CDR_DATA_Msk = 0xfff

	// ACR: Analog Control Register
	// Position of PENDETSENS field.
	ADC_ACR_PENDETSENS_Pos = 0x0
	// Bit mask of PENDETSENS field.
	ADC_ACR_PENDETSENS_Msk = 0x3

	// TSMR: Touchscreen Mode Register
	// Position of TSMODE field.
	ADC_TSMR_TSMODE_Pos = 0x0
	// Bit mask of TSMODE field.
	ADC_TSMR_TSMODE_Msk = 0x3
	// No Touchscreen
	ADC_TSMR_TSMODE_NONE = 0x0
	// 4-wire Touchscreen without pressure measurement
	ADC_TSMR_TSMODE_4_WIRE_NO_PM = 0x1
	// 4-wire Touchscreen with pressure measurement
	ADC_TSMR_TSMODE_4_WIRE = 0x2
	// 5-wire Touchscreen
	ADC_TSMR_TSMODE_5_WIRE = 0x3
	// Position of TSAV field.
	ADC_TSMR_TSAV_Pos = 0x4
	// Bit mask of TSAV field.
	ADC_TSMR_TSAV_Msk = 0x30
	// No Filtering. Only one ADC conversion per measure
	ADC_TSMR_TSAV_NO_FILTER = 0x0
	// Averages 2 ADC conversions
	ADC_TSMR_TSAV_AVG2CONV = 0x1
	// Averages 4 ADC conversions
	ADC_TSMR_TSAV_AVG4CONV = 0x2
	// Averages 8 ADC conversions
	ADC_TSMR_TSAV_AVG8CONV = 0x3
	// Position of TSFREQ field.
	ADC_TSMR_TSFREQ_Pos = 0x8
	// Bit mask of TSFREQ field.
	ADC_TSMR_TSFREQ_Msk = 0xf00
	// Position of TSSCTIM field.
	ADC_TSMR_TSSCTIM_Pos = 0x10
	// Bit mask of TSSCTIM field.
	ADC_TSMR_TSSCTIM_Msk = 0xf0000
	// Position of NOTSDMA field.
	ADC_TSMR_NOTSDMA_Pos = 0x16
	// Bit mask of NOTSDMA field.
	ADC_TSMR_NOTSDMA_Msk = 0x400000
	// Bit NOTSDMA.
	ADC_TSMR_NOTSDMA = 0x400000
	// Position of PENDET field.
	ADC_TSMR_PENDET_Pos = 0x18
	// Bit mask of PENDET field.
	ADC_TSMR_PENDET_Msk = 0x1000000
	// Bit PENDET.
	ADC_TSMR_PENDET = 0x1000000
	// Position of PENDBC field.
	ADC_TSMR_PENDBC_Pos = 0x1c
	// Bit mask of PENDBC field.
	ADC_TSMR_PENDBC_Msk = 0xf0000000

	// XPOSR: Touchscreen X Position Register
	// Position of XPOS field.
	ADC_XPOSR_XPOS_Pos = 0x0
	// Bit mask of XPOS field.
	ADC_XPOSR_XPOS_Msk = 0xfff
	// Position of XSCALE field.
	ADC_XPOSR_XSCALE_Pos = 0x10
	// Bit mask of XSCALE field.
	ADC_XPOSR_XSCALE_Msk = 0xfff0000

	// YPOSR: Touchscreen Y Position Register
	// Position of YPOS field.
	ADC_YPOSR_YPOS_Pos = 0x0
	// Bit mask of YPOS field.
	ADC_YPOSR_YPOS_Msk = 0xfff
	// Position of YSCALE field.
	ADC_YPOSR_YSCALE_Pos = 0x10
	// Bit mask of YSCALE field.
	ADC_YPOSR_YSCALE_Msk = 0xfff0000

	// PRESSR: Touchscreen Pressure Register
	// Position of Z1 field.
	ADC_PRESSR_Z1_Pos = 0x0
	// Bit mask of Z1 field.
	ADC_PRESSR_Z1_Msk = 0xfff
	// Position of Z2 field.
	ADC_PRESSR_Z2_Pos = 0x10
	// Bit mask of Z2 field.
	ADC_PRESSR_Z2_Msk = 0xfff0000

	// TRGR: Trigger Register
	// Position of TRGMOD field.
	ADC_TRGR_TRGMOD_Pos = 0x0
	// Bit mask of TRGMOD field.
	ADC_TRGR_TRGMOD_Msk = 0x7
	// No trigger, only software trigger can start conversions
	ADC_TRGR_TRGMOD_NO_TRIGGER = 0x0
	// External Trigger Rising Edge
	ADC_TRGR_TRGMOD_EXT_TRIG_RISE = 0x1
	// External Trigger Falling Edge
	ADC_TRGR_TRGMOD_EXT_TRIG_FALL = 0x2
	// External Trigger Any Edge
	ADC_TRGR_TRGMOD_EXT_TRIG_ANY = 0x3
	// Pen Detect Trigger (shall be selected only if PENDET is set and TSAMOD = Touchscreen only mode)
	ADC_TRGR_TRGMOD_PEN_TRIG = 0x4
	// Periodic Trigger (TRGPER shall be initiated appropriately)
	ADC_TRGR_TRGMOD_PERIOD_TRIG = 0x5
	// Continuous Mode
	ADC_TRGR_TRGMOD_CONTINUOUS = 0x6
	// Position of TRGPER field.
	ADC_TRGR_TRGPER_Pos = 0x10
	// Bit mask of TRGPER field.
	ADC_TRGR_TRGPER_Msk = 0xffff0000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	ADC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	ADC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	ADC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	ADC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	ADC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	ADC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	ADC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	ADC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	ADC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	ADC_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for EMAC: Ethernet MAC 10/100
const (
	// NCR: Network Control Register
	// Position of LB field.
	EMAC_NCR_LB_Pos = 0x0
	// Bit mask of LB field.
	EMAC_NCR_LB_Msk = 0x1
	// Bit LB.
	EMAC_NCR_LB = 0x1
	// Position of LLB field.
	EMAC_NCR_LLB_Pos = 0x1
	// Bit mask of LLB field.
	EMAC_NCR_LLB_Msk = 0x2
	// Bit LLB.
	EMAC_NCR_LLB = 0x2
	// Position of RE field.
	EMAC_NCR_RE_Pos = 0x2
	// Bit mask of RE field.
	EMAC_NCR_RE_Msk = 0x4
	// Bit RE.
	EMAC_NCR_RE = 0x4
	// Position of TE field.
	EMAC_NCR_TE_Pos = 0x3
	// Bit mask of TE field.
	EMAC_NCR_TE_Msk = 0x8
	// Bit TE.
	EMAC_NCR_TE = 0x8
	// Position of MPE field.
	EMAC_NCR_MPE_Pos = 0x4
	// Bit mask of MPE field.
	EMAC_NCR_MPE_Msk = 0x10
	// Bit MPE.
	EMAC_NCR_MPE = 0x10
	// Position of CLRSTAT field.
	EMAC_NCR_CLRSTAT_Pos = 0x5
	// Bit mask of CLRSTAT field.
	EMAC_NCR_CLRSTAT_Msk = 0x20
	// Bit CLRSTAT.
	EMAC_NCR_CLRSTAT = 0x20
	// Position of INCSTAT field.
	EMAC_NCR_INCSTAT_Pos = 0x6
	// Bit mask of INCSTAT field.
	EMAC_NCR_INCSTAT_Msk = 0x40
	// Bit INCSTAT.
	EMAC_NCR_INCSTAT = 0x40
	// Position of WESTAT field.
	EMAC_NCR_WESTAT_Pos = 0x7
	// Bit mask of WESTAT field.
	EMAC_NCR_WESTAT_Msk = 0x80
	// Bit WESTAT.
	EMAC_NCR_WESTAT = 0x80
	// Position of BP field.
	EMAC_NCR_BP_Pos = 0x8
	// Bit mask of BP field.
	EMAC_NCR_BP_Msk = 0x100
	// Bit BP.
	EMAC_NCR_BP = 0x100
	// Position of TSTART field.
	EMAC_NCR_TSTART_Pos = 0x9
	// Bit mask of TSTART field.
	EMAC_NCR_TSTART_Msk = 0x200
	// Bit TSTART.
	EMAC_NCR_TSTART = 0x200
	// Position of THALT field.
	EMAC_NCR_THALT_Pos = 0xa
	// Bit mask of THALT field.
	EMAC_NCR_THALT_Msk = 0x400
	// Bit THALT.
	EMAC_NCR_THALT = 0x400

	// NCFGR: Network Configuration Register
	// Position of SPD field.
	EMAC_NCFGR_SPD_Pos = 0x0
	// Bit mask of SPD field.
	EMAC_NCFGR_SPD_Msk = 0x1
	// Bit SPD.
	EMAC_NCFGR_SPD = 0x1
	// Position of FD field.
	EMAC_NCFGR_FD_Pos = 0x1
	// Bit mask of FD field.
	EMAC_NCFGR_FD_Msk = 0x2
	// Bit FD.
	EMAC_NCFGR_FD = 0x2
	// Position of JFRAME field.
	EMAC_NCFGR_JFRAME_Pos = 0x3
	// Bit mask of JFRAME field.
	EMAC_NCFGR_JFRAME_Msk = 0x8
	// Bit JFRAME.
	EMAC_NCFGR_JFRAME = 0x8
	// Position of CAF field.
	EMAC_NCFGR_CAF_Pos = 0x4
	// Bit mask of CAF field.
	EMAC_NCFGR_CAF_Msk = 0x10
	// Bit CAF.
	EMAC_NCFGR_CAF = 0x10
	// Position of NBC field.
	EMAC_NCFGR_NBC_Pos = 0x5
	// Bit mask of NBC field.
	EMAC_NCFGR_NBC_Msk = 0x20
	// Bit NBC.
	EMAC_NCFGR_NBC = 0x20
	// Position of MTI field.
	EMAC_NCFGR_MTI_Pos = 0x6
	// Bit mask of MTI field.
	EMAC_NCFGR_MTI_Msk = 0x40
	// Bit MTI.
	EMAC_NCFGR_MTI = 0x40
	// Position of UNI field.
	EMAC_NCFGR_UNI_Pos = 0x7
	// Bit mask of UNI field.
	EMAC_NCFGR_UNI_Msk = 0x80
	// Bit UNI.
	EMAC_NCFGR_UNI = 0x80
	// Position of BIG field.
	EMAC_NCFGR_BIG_Pos = 0x8
	// Bit mask of BIG field.
	EMAC_NCFGR_BIG_Msk = 0x100
	// Bit BIG.
	EMAC_NCFGR_BIG = 0x100
	// Position of CLK field.
	EMAC_NCFGR_CLK_Pos = 0xa
	// Bit mask of CLK field.
	EMAC_NCFGR_CLK_Msk = 0xc00
	// MCK divided by 8 (MCK up to 20 MHz).
	EMAC_NCFGR_CLK_MCK_8 = 0x0
	// MCK divided by 16 (MCK up to 40 MHz).
	EMAC_NCFGR_CLK_MCK_16 = 0x1
	// MCK divided by 32 (MCK up to 80 MHz).
	EMAC_NCFGR_CLK_MCK_32 = 0x2
	// MCK divided by 64 (MCK up to 160 MHz).
	EMAC_NCFGR_CLK_MCK_64 = 0x3
	// Position of RTY field.
	EMAC_NCFGR_RTY_Pos = 0xc
	// Bit mask of RTY field.
	EMAC_NCFGR_RTY_Msk = 0x1000
	// Bit RTY.
	EMAC_NCFGR_RTY = 0x1000
	// Position of PAE field.
	EMAC_NCFGR_PAE_Pos = 0xd
	// Bit mask of PAE field.
	EMAC_NCFGR_PAE_Msk = 0x2000
	// Bit PAE.
	EMAC_NCFGR_PAE = 0x2000
	// Position of RBOF field.
	EMAC_NCFGR_RBOF_Pos = 0xe
	// Bit mask of RBOF field.
	EMAC_NCFGR_RBOF_Msk = 0xc000
	// No offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_0 = 0x0
	// One-byte offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_1 = 0x1
	// Two-byte offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_2 = 0x2
	// Three-byte offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_3 = 0x3
	// Position of RLCE field.
	EMAC_NCFGR_RLCE_Pos = 0x10
	// Bit mask of RLCE field.
	EMAC_NCFGR_RLCE_Msk = 0x10000
	// Bit RLCE.
	EMAC_NCFGR_RLCE = 0x10000
	// Position of DRFCS field.
	EMAC_NCFGR_DRFCS_Pos = 0x11
	// Bit mask of DRFCS field.
	EMAC_NCFGR_DRFCS_Msk = 0x20000
	// Bit DRFCS.
	EMAC_NCFGR_DRFCS = 0x20000
	// Position of EFRHD field.
	EMAC_NCFGR_EFRHD_Pos = 0x12
	// Bit mask of EFRHD field.
	EMAC_NCFGR_EFRHD_Msk = 0x40000
	// Bit EFRHD.
	EMAC_NCFGR_EFRHD = 0x40000
	// Position of IRXFCS field.
	EMAC_NCFGR_IRXFCS_Pos = 0x13
	// Bit mask of IRXFCS field.
	EMAC_NCFGR_IRXFCS_Msk = 0x80000
	// Bit IRXFCS.
	EMAC_NCFGR_IRXFCS = 0x80000

	// NSR: Network Status Register
	// Position of MDIO field.
	EMAC_NSR_MDIO_Pos = 0x1
	// Bit mask of MDIO field.
	EMAC_NSR_MDIO_Msk = 0x2
	// Bit MDIO.
	EMAC_NSR_MDIO = 0x2
	// Position of IDLE field.
	EMAC_NSR_IDLE_Pos = 0x2
	// Bit mask of IDLE field.
	EMAC_NSR_IDLE_Msk = 0x4
	// Bit IDLE.
	EMAC_NSR_IDLE = 0x4

	// TSR: Transmit Status Register
	// Position of UBR field.
	EMAC_TSR_UBR_Pos = 0x0
	// Bit mask of UBR field.
	EMAC_TSR_UBR_Msk = 0x1
	// Bit UBR.
	EMAC_TSR_UBR = 0x1
	// Position of COL field.
	EMAC_TSR_COL_Pos = 0x1
	// Bit mask of COL field.
	EMAC_TSR_COL_Msk = 0x2
	// Bit COL.
	EMAC_TSR_COL = 0x2
	// Position of RLES field.
	EMAC_TSR_RLES_Pos = 0x2
	// Bit mask of RLES field.
	EMAC_TSR_RLES_Msk = 0x4
	// Bit RLES.
	EMAC_TSR_RLES = 0x4
	// Position of TGO field.
	EMAC_TSR_TGO_Pos = 0x3
	// Bit mask of TGO field.
	EMAC_TSR_TGO_Msk = 0x8
	// Bit TGO.
	EMAC_TSR_TGO = 0x8
	// Position of BEX field.
	EMAC_TSR_BEX_Pos = 0x4
	// Bit mask of BEX field.
	EMAC_TSR_BEX_Msk = 0x10
	// Bit BEX.
	EMAC_TSR_BEX = 0x10
	// Position of COMP field.
	EMAC_TSR_COMP_Pos = 0x5
	// Bit mask of COMP field.
	EMAC_TSR_COMP_Msk = 0x20
	// Bit COMP.
	EMAC_TSR_COMP = 0x20
	// Position of UND field.
	EMAC_TSR_UND_Pos = 0x6
	// Bit mask of UND field.
	EMAC_TSR_UND_Msk = 0x40
	// Bit UND.
	EMAC_TSR_UND = 0x40

	// RBQP: Receive Buffer Queue Pointer Register
	// Position of ADDR field.
	EMAC_RBQP_ADDR_Pos = 0x2
	// Bit mask of ADDR field.
	EMAC_RBQP_ADDR_Msk = 0xfffffffc

	// TBQP: Transmit Buffer Queue Pointer Register
	// Position of ADDR field.
	EMAC_TBQP_ADDR_Pos = 0x2
	// Bit mask of ADDR field.
	EMAC_TBQP_ADDR_Msk = 0xfffffffc

	// RSR: Receive Status Register
	// Position of BNA field.
	EMAC_RSR_BNA_Pos = 0x0
	// Bit mask of BNA field.
	EMAC_RSR_BNA_Msk = 0x1
	// Bit BNA.
	EMAC_RSR_BNA = 0x1
	// Position of REC field.
	EMAC_RSR_REC_Pos = 0x1
	// Bit mask of REC field.
	EMAC_RSR_REC_Msk = 0x2
	// Bit REC.
	EMAC_RSR_REC = 0x2
	// Position of OVR field.
	EMAC_RSR_OVR_Pos = 0x2
	// Bit mask of OVR field.
	EMAC_RSR_OVR_Msk = 0x4
	// Bit OVR.
	EMAC_RSR_OVR = 0x4

	// ISR: Interrupt Status Register
	// Position of MFD field.
	EMAC_ISR_MFD_Pos = 0x0
	// Bit mask of MFD field.
	EMAC_ISR_MFD_Msk = 0x1
	// Bit MFD.
	EMAC_ISR_MFD = 0x1
	// Position of RCOMP field.
	EMAC_ISR_RCOMP_Pos = 0x1
	// Bit mask of RCOMP field.
	EMAC_ISR_RCOMP_Msk = 0x2
	// Bit RCOMP.
	EMAC_ISR_RCOMP = 0x2
	// Position of RXUBR field.
	EMAC_ISR_RXUBR_Pos = 0x2
	// Bit mask of RXUBR field.
	EMAC_ISR_RXUBR_Msk = 0x4
	// Bit RXUBR.
	EMAC_ISR_RXUBR = 0x4
	// Position of TXUBR field.
	EMAC_ISR_TXUBR_Pos = 0x3
	// Bit mask of TXUBR field.
	EMAC_ISR_TXUBR_Msk = 0x8
	// Bit TXUBR.
	EMAC_ISR_TXUBR = 0x8
	// Position of TUND field.
	EMAC_ISR_TUND_Pos = 0x4
	// Bit mask of TUND field.
	EMAC_ISR_TUND_Msk = 0x10
	// Bit TUND.
	EMAC_ISR_TUND = 0x10
	// Position of RLEX field.
	EMAC_ISR_RLEX_Pos = 0x5
	// Bit mask of RLEX field.
	EMAC_ISR_RLEX_Msk = 0x20
	// Bit RLEX.
	EMAC_ISR_RLEX = 0x20
	// Position of TXERR field.
	EMAC_ISR_TXERR_Pos = 0x6
	// Bit mask of TXERR field.
	EMAC_ISR_TXERR_Msk = 0x40
	// Bit TXERR.
	EMAC_ISR_TXERR = 0x40
	// Position of TCOMP field.
	EMAC_ISR_TCOMP_Pos = 0x7
	// Bit mask of TCOMP field.
	EMAC_ISR_TCOMP_Msk = 0x80
	// Bit TCOMP.
	EMAC_ISR_TCOMP = 0x80
	// Position of ROVR field.
	EMAC_ISR_ROVR_Pos = 0xa
	// Bit mask of ROVR field.
	EMAC_ISR_ROVR_Msk = 0x400
	// Bit ROVR.
	EMAC_ISR_ROVR = 0x400
	// Position of HRESP field.
	EMAC_ISR_HRESP_Pos = 0xb
	// Bit mask of HRESP field.
	EMAC_ISR_HRESP_Msk = 0x800
	// Bit HRESP.
	EMAC_ISR_HRESP = 0x800
	// Position of PFRE field.
	EMAC_ISR_PFRE_Pos = 0xc
	// Bit mask of PFRE field.
	EMAC_ISR_PFRE_Msk = 0x1000
	// Bit PFRE.
	EMAC_ISR_PFRE = 0x1000
	// Position of PTZ field.
	EMAC_ISR_PTZ_Pos = 0xd
	// Bit mask of PTZ field.
	EMAC_ISR_PTZ_Msk = 0x2000
	// Bit PTZ.
	EMAC_ISR_PTZ = 0x2000
	// Position of WOL field.
	EMAC_ISR_WOL_Pos = 0xe
	// Bit mask of WOL field.
	EMAC_ISR_WOL_Msk = 0x4000
	// Bit WOL.
	EMAC_ISR_WOL = 0x4000

	// IER: Interrupt Enable Register
	// Position of MFD field.
	EMAC_IER_MFD_Pos = 0x0
	// Bit mask of MFD field.
	EMAC_IER_MFD_Msk = 0x1
	// Bit MFD.
	EMAC_IER_MFD = 0x1
	// Position of RCOMP field.
	EMAC_IER_RCOMP_Pos = 0x1
	// Bit mask of RCOMP field.
	EMAC_IER_RCOMP_Msk = 0x2
	// Bit RCOMP.
	EMAC_IER_RCOMP = 0x2
	// Position of RXUBR field.
	EMAC_IER_RXUBR_Pos = 0x2
	// Bit mask of RXUBR field.
	EMAC_IER_RXUBR_Msk = 0x4
	// Bit RXUBR.
	EMAC_IER_RXUBR = 0x4
	// Position of TXUBR field.
	EMAC_IER_TXUBR_Pos = 0x3
	// Bit mask of TXUBR field.
	EMAC_IER_TXUBR_Msk = 0x8
	// Bit TXUBR.
	EMAC_IER_TXUBR = 0x8
	// Position of TUND field.
	EMAC_IER_TUND_Pos = 0x4
	// Bit mask of TUND field.
	EMAC_IER_TUND_Msk = 0x10
	// Bit TUND.
	EMAC_IER_TUND = 0x10
	// Position of RLE field.
	EMAC_IER_RLE_Pos = 0x5
	// Bit mask of RLE field.
	EMAC_IER_RLE_Msk = 0x20
	// Bit RLE.
	EMAC_IER_RLE = 0x20
	// Position of TXERR field.
	EMAC_IER_TXERR_Pos = 0x6
	// Bit mask of TXERR field.
	EMAC_IER_TXERR_Msk = 0x40
	// Bit TXERR.
	EMAC_IER_TXERR = 0x40
	// Position of TCOMP field.
	EMAC_IER_TCOMP_Pos = 0x7
	// Bit mask of TCOMP field.
	EMAC_IER_TCOMP_Msk = 0x80
	// Bit TCOMP.
	EMAC_IER_TCOMP = 0x80
	// Position of ROVR field.
	EMAC_IER_ROVR_Pos = 0xa
	// Bit mask of ROVR field.
	EMAC_IER_ROVR_Msk = 0x400
	// Bit ROVR.
	EMAC_IER_ROVR = 0x400
	// Position of HRESP field.
	EMAC_IER_HRESP_Pos = 0xb
	// Bit mask of HRESP field.
	EMAC_IER_HRESP_Msk = 0x800
	// Bit HRESP.
	EMAC_IER_HRESP = 0x800
	// Position of PFR field.
	EMAC_IER_PFR_Pos = 0xc
	// Bit mask of PFR field.
	EMAC_IER_PFR_Msk = 0x1000
	// Bit PFR.
	EMAC_IER_PFR = 0x1000
	// Position of PTZ field.
	EMAC_IER_PTZ_Pos = 0xd
	// Bit mask of PTZ field.
	EMAC_IER_PTZ_Msk = 0x2000
	// Bit PTZ.
	EMAC_IER_PTZ = 0x2000
	// Position of WOL field.
	EMAC_IER_WOL_Pos = 0xe
	// Bit mask of WOL field.
	EMAC_IER_WOL_Msk = 0x4000
	// Bit WOL.
	EMAC_IER_WOL = 0x4000

	// IDR: Interrupt Disable Register
	// Position of MFD field.
	EMAC_IDR_MFD_Pos = 0x0
	// Bit mask of MFD field.
	EMAC_IDR_MFD_Msk = 0x1
	// Bit MFD.
	EMAC_IDR_MFD = 0x1
	// Position of RCOMP field.
	EMAC_IDR_RCOMP_Pos = 0x1
	// Bit mask of RCOMP field.
	EMAC_IDR_RCOMP_Msk = 0x2
	// Bit RCOMP.
	EMAC_IDR_RCOMP = 0x2
	// Position of RXUBR field.
	EMAC_IDR_RXUBR_Pos = 0x2
	// Bit mask of RXUBR field.
	EMAC_IDR_RXUBR_Msk = 0x4
	// Bit RXUBR.
	EMAC_IDR_RXUBR = 0x4
	// Position of TXUBR field.
	EMAC_IDR_TXUBR_Pos = 0x3
	// Bit mask of TXUBR field.
	EMAC_IDR_TXUBR_Msk = 0x8
	// Bit TXUBR.
	EMAC_IDR_TXUBR = 0x8
	// Position of TUND field.
	EMAC_IDR_TUND_Pos = 0x4
	// Bit mask of TUND field.
	EMAC_IDR_TUND_Msk = 0x10
	// Bit TUND.
	EMAC_IDR_TUND = 0x10
	// Position of RLE field.
	EMAC_IDR_RLE_Pos = 0x5
	// Bit mask of RLE field.
	EMAC_IDR_RLE_Msk = 0x20
	// Bit RLE.
	EMAC_IDR_RLE = 0x20
	// Position of TXERR field.
	EMAC_IDR_TXERR_Pos = 0x6
	// Bit mask of TXERR field.
	EMAC_IDR_TXERR_Msk = 0x40
	// Bit TXERR.
	EMAC_IDR_TXERR = 0x40
	// Position of TCOMP field.
	EMAC_IDR_TCOMP_Pos = 0x7
	// Bit mask of TCOMP field.
	EMAC_IDR_TCOMP_Msk = 0x80
	// Bit TCOMP.
	EMAC_IDR_TCOMP = 0x80
	// Position of ROVR field.
	EMAC_IDR_ROVR_Pos = 0xa
	// Bit mask of ROVR field.
	EMAC_IDR_ROVR_Msk = 0x400
	// Bit ROVR.
	EMAC_IDR_ROVR = 0x400
	// Position of HRESP field.
	EMAC_IDR_HRESP_Pos = 0xb
	// Bit mask of HRESP field.
	EMAC_IDR_HRESP_Msk = 0x800
	// Bit HRESP.
	EMAC_IDR_HRESP = 0x800
	// Position of PFR field.
	EMAC_IDR_PFR_Pos = 0xc
	// Bit mask of PFR field.
	EMAC_IDR_PFR_Msk = 0x1000
	// Bit PFR.
	EMAC_IDR_PFR = 0x1000
	// Position of PTZ field.
	EMAC_IDR_PTZ_Pos = 0xd
	// Bit mask of PTZ field.
	EMAC_IDR_PTZ_Msk = 0x2000
	// Bit PTZ.
	EMAC_IDR_PTZ = 0x2000
	// Position of WOL field.
	EMAC_IDR_WOL_Pos = 0xe
	// Bit mask of WOL field.
	EMAC_IDR_WOL_Msk = 0x4000
	// Bit WOL.
	EMAC_IDR_WOL = 0x4000

	// IMR: Interrupt Mask Register
	// Position of MFD field.
	EMAC_IMR_MFD_Pos = 0x0
	// Bit mask of MFD field.
	EMAC_IMR_MFD_Msk = 0x1
	// Bit MFD.
	EMAC_IMR_MFD = 0x1
	// Position of RCOMP field.
	EMAC_IMR_RCOMP_Pos = 0x1
	// Bit mask of RCOMP field.
	EMAC_IMR_RCOMP_Msk = 0x2
	// Bit RCOMP.
	EMAC_IMR_RCOMP = 0x2
	// Position of RXUBR field.
	EMAC_IMR_RXUBR_Pos = 0x2
	// Bit mask of RXUBR field.
	EMAC_IMR_RXUBR_Msk = 0x4
	// Bit RXUBR.
	EMAC_IMR_RXUBR = 0x4
	// Position of TXUBR field.
	EMAC_IMR_TXUBR_Pos = 0x3
	// Bit mask of TXUBR field.
	EMAC_IMR_TXUBR_Msk = 0x8
	// Bit TXUBR.
	EMAC_IMR_TXUBR = 0x8
	// Position of TUND field.
	EMAC_IMR_TUND_Pos = 0x4
	// Bit mask of TUND field.
	EMAC_IMR_TUND_Msk = 0x10
	// Bit TUND.
	EMAC_IMR_TUND = 0x10
	// Position of RLE field.
	EMAC_IMR_RLE_Pos = 0x5
	// Bit mask of RLE field.
	EMAC_IMR_RLE_Msk = 0x20
	// Bit RLE.
	EMAC_IMR_RLE = 0x20
	// Position of TXERR field.
	EMAC_IMR_TXERR_Pos = 0x6
	// Bit mask of TXERR field.
	EMAC_IMR_TXERR_Msk = 0x40
	// Bit TXERR.
	EMAC_IMR_TXERR = 0x40
	// Position of TCOMP field.
	EMAC_IMR_TCOMP_Pos = 0x7
	// Bit mask of TCOMP field.
	EMAC_IMR_TCOMP_Msk = 0x80
	// Bit TCOMP.
	EMAC_IMR_TCOMP = 0x80
	// Position of ROVR field.
	EMAC_IMR_ROVR_Pos = 0xa
	// Bit mask of ROVR field.
	EMAC_IMR_ROVR_Msk = 0x400
	// Bit ROVR.
	EMAC_IMR_ROVR = 0x400
	// Position of HRESP field.
	EMAC_IMR_HRESP_Pos = 0xb
	// Bit mask of HRESP field.
	EMAC_IMR_HRESP_Msk = 0x800
	// Bit HRESP.
	EMAC_IMR_HRESP = 0x800
	// Position of PFR field.
	EMAC_IMR_PFR_Pos = 0xc
	// Bit mask of PFR field.
	EMAC_IMR_PFR_Msk = 0x1000
	// Bit PFR.
	EMAC_IMR_PFR = 0x1000
	// Position of PTZ field.
	EMAC_IMR_PTZ_Pos = 0xd
	// Bit mask of PTZ field.
	EMAC_IMR_PTZ_Msk = 0x2000
	// Bit PTZ.
	EMAC_IMR_PTZ = 0x2000
	// Position of WOL field.
	EMAC_IMR_WOL_Pos = 0xe
	// Bit mask of WOL field.
	EMAC_IMR_WOL_Msk = 0x4000
	// Bit WOL.
	EMAC_IMR_WOL = 0x4000

	// MAN: Phy Maintenance Register
	// Position of DATA field.
	EMAC_MAN_DATA_Pos = 0x0
	// Bit mask of DATA field.
	EMAC_MAN_DATA_Msk = 0xffff
	// Position of CODE field.
	EMAC_MAN_CODE_Pos = 0x10
	// Bit mask of CODE field.
	EMAC_MAN_CODE_Msk = 0x30000
	// Position of REGA field.
	EMAC_MAN_REGA_Pos = 0x12
	// Bit mask of REGA field.
	EMAC_MAN_REGA_Msk = 0x7c0000
	// Position of PHYA field.
	EMAC_MAN_PHYA_Pos = 0x17
	// Bit mask of PHYA field.
	EMAC_MAN_PHYA_Msk = 0xf800000
	// Position of RW field.
	EMAC_MAN_RW_Pos = 0x1c
	// Bit mask of RW field.
	EMAC_MAN_RW_Msk = 0x30000000
	// Position of SOF field.
	EMAC_MAN_SOF_Pos = 0x1e
	// Bit mask of SOF field.
	EMAC_MAN_SOF_Msk = 0xc0000000

	// PTR: Pause Time Register
	// Position of PTIME field.
	EMAC_PTR_PTIME_Pos = 0x0
	// Bit mask of PTIME field.
	EMAC_PTR_PTIME_Msk = 0xffff

	// PFR: Pause Frames Received Register
	// Position of FROK field.
	EMAC_PFR_FROK_Pos = 0x0
	// Bit mask of FROK field.
	EMAC_PFR_FROK_Msk = 0xffff

	// FTO: Frames Transmitted Ok Register
	// Position of FTOK field.
	EMAC_FTO_FTOK_Pos = 0x0
	// Bit mask of FTOK field.
	EMAC_FTO_FTOK_Msk = 0xffffff

	// SCF: Single Collision Frames Register
	// Position of SCF field.
	EMAC_SCF_SCF_Pos = 0x0
	// Bit mask of SCF field.
	EMAC_SCF_SCF_Msk = 0xffff

	// MCF: Multiple Collision Frames Register
	// Position of MCF field.
	EMAC_MCF_MCF_Pos = 0x0
	// Bit mask of MCF field.
	EMAC_MCF_MCF_Msk = 0xffff

	// FRO: Frames Received Ok Register
	// Position of FROK field.
	EMAC_FRO_FROK_Pos = 0x0
	// Bit mask of FROK field.
	EMAC_FRO_FROK_Msk = 0xffffff

	// FCSE: Frame Check Sequence Errors Register
	// Position of FCSE field.
	EMAC_FCSE_FCSE_Pos = 0x0
	// Bit mask of FCSE field.
	EMAC_FCSE_FCSE_Msk = 0xff

	// ALE: Alignment Errors Register
	// Position of ALE field.
	EMAC_ALE_ALE_Pos = 0x0
	// Bit mask of ALE field.
	EMAC_ALE_ALE_Msk = 0xff

	// DTF: Deferred Transmission Frames Register
	// Position of DTF field.
	EMAC_DTF_DTF_Pos = 0x0
	// Bit mask of DTF field.
	EMAC_DTF_DTF_Msk = 0xffff

	// LCOL: Late Collisions Register
	// Position of LCOL field.
	EMAC_LCOL_LCOL_Pos = 0x0
	// Bit mask of LCOL field.
	EMAC_LCOL_LCOL_Msk = 0xff

	// ECOL: Excessive Collisions Register
	// Position of EXCOL field.
	EMAC_ECOL_EXCOL_Pos = 0x0
	// Bit mask of EXCOL field.
	EMAC_ECOL_EXCOL_Msk = 0xff

	// TUND: Transmit Underrun Errors Register
	// Position of TUND field.
	EMAC_TUND_TUND_Pos = 0x0
	// Bit mask of TUND field.
	EMAC_TUND_TUND_Msk = 0xff

	// CSE: Carrier Sense Errors Register
	// Position of CSE field.
	EMAC_CSE_CSE_Pos = 0x0
	// Bit mask of CSE field.
	EMAC_CSE_CSE_Msk = 0xff

	// RRE: Receive Resource Errors Register
	// Position of RRE field.
	EMAC_RRE_RRE_Pos = 0x0
	// Bit mask of RRE field.
	EMAC_RRE_RRE_Msk = 0xffff

	// ROV: Receive Overrun Errors Register
	// Position of ROVR field.
	EMAC_ROV_ROVR_Pos = 0x0
	// Bit mask of ROVR field.
	EMAC_ROV_ROVR_Msk = 0xff

	// RSE: Receive Symbol Errors Register
	// Position of RSE field.
	EMAC_RSE_RSE_Pos = 0x0
	// Bit mask of RSE field.
	EMAC_RSE_RSE_Msk = 0xff

	// ELE: Excessive Length Errors Register
	// Position of EXL field.
	EMAC_ELE_EXL_Pos = 0x0
	// Bit mask of EXL field.
	EMAC_ELE_EXL_Msk = 0xff

	// RJA: Receive Jabbers Register
	// Position of RJB field.
	EMAC_RJA_RJB_Pos = 0x0
	// Bit mask of RJB field.
	EMAC_RJA_RJB_Msk = 0xff

	// USF: Undersize Frames Register
	// Position of USF field.
	EMAC_USF_USF_Pos = 0x0
	// Bit mask of USF field.
	EMAC_USF_USF_Msk = 0xff

	// STE: SQE Test Errors Register
	// Position of SQER field.
	EMAC_STE_SQER_Pos = 0x0
	// Bit mask of SQER field.
	EMAC_STE_SQER_Msk = 0xff

	// RLE: Received Length Field Mismatch Register
	// Position of RLFM field.
	EMAC_RLE_RLFM_Pos = 0x0
	// Bit mask of RLFM field.
	EMAC_RLE_RLFM_Msk = 0xff

	// HRB: Hash Register Bottom [31:0] Register
	// Position of ADDR field.
	EMAC_HRB_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_HRB_ADDR_Msk = 0xffffffff

	// HRT: Hash Register Top [63:32] Register
	// Position of ADDR field.
	EMAC_HRT_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_HRT_ADDR_Msk = 0xffffffff

	// SA1B: Specific Address 1 Bottom Register
	// Position of ADDR field.
	EMAC_SA1B_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA1B_ADDR_Msk = 0xffffffff

	// SA1T: Specific Address 1 Top Register
	// Position of ADDR field.
	EMAC_SA1T_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA1T_ADDR_Msk = 0xffff

	// SA2B: Specific Address 2 Bottom Register
	// Position of ADDR field.
	EMAC_SA2B_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA2B_ADDR_Msk = 0xffffffff

	// SA2T: Specific Address 2 Top Register
	// Position of ADDR field.
	EMAC_SA2T_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA2T_ADDR_Msk = 0xffff

	// SA3B: Specific Address 3 Bottom Register
	// Position of ADDR field.
	EMAC_SA3B_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA3B_ADDR_Msk = 0xffffffff

	// SA3T: Specific Address 3 Top Register
	// Position of ADDR field.
	EMAC_SA3T_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA3T_ADDR_Msk = 0xffff

	// SA4B: Specific Address 4 Bottom Register
	// Position of ADDR field.
	EMAC_SA4B_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA4B_ADDR_Msk = 0xffffffff

	// SA4T: Specific Address 4 Top Register
	// Position of ADDR field.
	EMAC_SA4T_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	EMAC_SA4T_ADDR_Msk = 0xffff

	// TID: Type ID Checking Register
	// Position of TID field.
	EMAC_TID_TID_Pos = 0x0
	// Bit mask of TID field.
	EMAC_TID_TID_Msk = 0xffff

	// USRIO: User Input/Output Register
	// Position of RMII field.
	EMAC_USRIO_RMII_Pos = 0x0
	// Bit mask of RMII field.
	EMAC_USRIO_RMII_Msk = 0x1
	// Bit RMII.
	EMAC_USRIO_RMII = 0x1
	// Position of CLKEN field.
	EMAC_USRIO_CLKEN_Pos = 0x1
	// Bit mask of CLKEN field.
	EMAC_USRIO_CLKEN_Msk = 0x2
	// Bit CLKEN.
	EMAC_USRIO_CLKEN = 0x2

	// WOL: Wake on LAN Register
	// Position of IP field.
	EMAC_WOL_IP_Pos = 0x0
	// Bit mask of IP field.
	EMAC_WOL_IP_Msk = 0xffff
	// Position of MAG field.
	EMAC_WOL_MAG_Pos = 0x10
	// Bit mask of MAG field.
	EMAC_WOL_MAG_Msk = 0x10000
	// Bit MAG.
	EMAC_WOL_MAG = 0x10000
	// Position of ARP field.
	EMAC_WOL_ARP_Pos = 0x11
	// Bit mask of ARP field.
	EMAC_WOL_ARP_Msk = 0x20000
	// Bit ARP.
	EMAC_WOL_ARP = 0x20000
	// Position of SA1 field.
	EMAC_WOL_SA1_Pos = 0x12
	// Bit mask of SA1 field.
	EMAC_WOL_SA1_Msk = 0x40000
	// Bit SA1.
	EMAC_WOL_SA1 = 0x40000
	// Position of MTI field.
	EMAC_WOL_MTI_Pos = 0x13
	// Bit mask of MTI field.
	EMAC_WOL_MTI_Msk = 0x80000
	// Bit MTI.
	EMAC_WOL_MTI = 0x80000
)

// Bitfields for UDPHS: USB High Speed Device Port
const (
	// CTRL: UDPHS Control Register
	// Position of DEV_ADDR field.
	UDPHS_CTRL_DEV_ADDR_Pos = 0x0
	// Bit mask of DEV_ADDR field.
	UDPHS_CTRL_DEV_ADDR_Msk = 0x7f
	// Position of FADDR_EN field.
	UDPHS_CTRL_FADDR_EN_Pos = 0x7
	// Bit mask of FADDR_EN field.
	UDPHS_CTRL_FADDR_EN_Msk = 0x80
	// Bit FADDR_EN.
	UDPHS_CTRL_FADDR_EN = 0x80
	// Position of EN_UDPHS field.
	UDPHS_CTRL_EN_UDPHS_Pos = 0x8
	// Bit mask of EN_UDPHS field.
	UDPHS_CTRL_EN_UDPHS_Msk = 0x100
	// Bit EN_UDPHS.
	UDPHS_CTRL_EN_UDPHS = 0x100
	// Position of DETACH field.
	UDPHS_CTRL_DETACH_Pos = 0x9
	// Bit mask of DETACH field.
	UDPHS_CTRL_DETACH_Msk = 0x200
	// Bit DETACH.
	UDPHS_CTRL_DETACH = 0x200
	// Position of REWAKEUP field.
	UDPHS_CTRL_REWAKEUP_Pos = 0xa
	// Bit mask of REWAKEUP field.
	UDPHS_CTRL_REWAKEUP_Msk = 0x400
	// Bit REWAKEUP.
	UDPHS_CTRL_REWAKEUP = 0x400
	// Position of PULLD_DIS field.
	UDPHS_CTRL_PULLD_DIS_Pos = 0xb
	// Bit mask of PULLD_DIS field.
	UDPHS_CTRL_PULLD_DIS_Msk = 0x800
	// Bit PULLD_DIS.
	UDPHS_CTRL_PULLD_DIS = 0x800

	// FNUM: UDPHS Frame Number Register
	// Position of MICRO_FRAME_NUM field.
	UDPHS_FNUM_MICRO_FRAME_NUM_Pos = 0x0
	// Bit mask of MICRO_FRAME_NUM field.
	UDPHS_FNUM_MICRO_FRAME_NUM_Msk = 0x7
	// Position of FRAME_NUMBER field.
	UDPHS_FNUM_FRAME_NUMBER_Pos = 0x3
	// Bit mask of FRAME_NUMBER field.
	UDPHS_FNUM_FRAME_NUMBER_Msk = 0x3ff8
	// Position of FNUM_ERR field.
	UDPHS_FNUM_FNUM_ERR_Pos = 0x1f
	// Bit mask of FNUM_ERR field.
	UDPHS_FNUM_FNUM_ERR_Msk = 0x80000000
	// Bit FNUM_ERR.
	UDPHS_FNUM_FNUM_ERR = 0x80000000

	// IEN: UDPHS Interrupt Enable Register
	// Position of DET_SUSPD field.
	UDPHS_IEN_DET_SUSPD_Pos = 0x1
	// Bit mask of DET_SUSPD field.
	UDPHS_IEN_DET_SUSPD_Msk = 0x2
	// Bit DET_SUSPD.
	UDPHS_IEN_DET_SUSPD = 0x2
	// Position of MICRO_SOF field.
	UDPHS_IEN_MICRO_SOF_Pos = 0x2
	// Bit mask of MICRO_SOF field.
	UDPHS_IEN_MICRO_SOF_Msk = 0x4
	// Bit MICRO_SOF.
	UDPHS_IEN_MICRO_SOF = 0x4
	// Position of INT_SOF field.
	UDPHS_IEN_INT_SOF_Pos = 0x3
	// Bit mask of INT_SOF field.
	UDPHS_IEN_INT_SOF_Msk = 0x8
	// Bit INT_SOF.
	UDPHS_IEN_INT_SOF = 0x8
	// Position of ENDRESET field.
	UDPHS_IEN_ENDRESET_Pos = 0x4
	// Bit mask of ENDRESET field.
	UDPHS_IEN_ENDRESET_Msk = 0x10
	// Bit ENDRESET.
	UDPHS_IEN_ENDRESET = 0x10
	// Position of WAKE_UP field.
	UDPHS_IEN_WAKE_UP_Pos = 0x5
	// Bit mask of WAKE_UP field.
	UDPHS_IEN_WAKE_UP_Msk = 0x20
	// Bit WAKE_UP.
	UDPHS_IEN_WAKE_UP = 0x20
	// Position of ENDOFRSM field.
	UDPHS_IEN_ENDOFRSM_Pos = 0x6
	// Bit mask of ENDOFRSM field.
	UDPHS_IEN_ENDOFRSM_Msk = 0x40
	// Bit ENDOFRSM.
	UDPHS_IEN_ENDOFRSM = 0x40
	// Position of UPSTR_RES field.
	UDPHS_IEN_UPSTR_RES_Pos = 0x7
	// Bit mask of UPSTR_RES field.
	UDPHS_IEN_UPSTR_RES_Msk = 0x80
	// Bit UPSTR_RES.
	UDPHS_IEN_UPSTR_RES = 0x80
	// Position of EPT_0 field.
	UDPHS_IEN_EPT_0_Pos = 0x8
	// Bit mask of EPT_0 field.
	UDPHS_IEN_EPT_0_Msk = 0x100
	// Bit EPT_0.
	UDPHS_IEN_EPT_0 = 0x100
	// Position of EPT_1 field.
	UDPHS_IEN_EPT_1_Pos = 0x9
	// Bit mask of EPT_1 field.
	UDPHS_IEN_EPT_1_Msk = 0x200
	// Bit EPT_1.
	UDPHS_IEN_EPT_1 = 0x200
	// Position of EPT_2 field.
	UDPHS_IEN_EPT_2_Pos = 0xa
	// Bit mask of EPT_2 field.
	UDPHS_IEN_EPT_2_Msk = 0x400
	// Bit EPT_2.
	UDPHS_IEN_EPT_2 = 0x400
	// Position of EPT_3 field.
	UDPHS_IEN_EPT_3_Pos = 0xb
	// Bit mask of EPT_3 field.
	UDPHS_IEN_EPT_3_Msk = 0x800
	// Bit EPT_3.
	UDPHS_IEN_EPT_3 = 0x800
	// Position of EPT_4 field.
	UDPHS_IEN_EPT_4_Pos = 0xc
	// Bit mask of EPT_4 field.
	UDPHS_IEN_EPT_4_Msk = 0x1000
	// Bit EPT_4.
	UDPHS_IEN_EPT_4 = 0x1000
	// Position of EPT_5 field.
	UDPHS_IEN_EPT_5_Pos = 0xd
	// Bit mask of EPT_5 field.
	UDPHS_IEN_EPT_5_Msk = 0x2000
	// Bit EPT_5.
	UDPHS_IEN_EPT_5 = 0x2000
	// Position of EPT_6 field.
	UDPHS_IEN_EPT_6_Pos = 0xe
	// Bit mask of EPT_6 field.
	UDPHS_IEN_EPT_6_Msk = 0x4000
	// Bit EPT_6.
	UDPHS_IEN_EPT_6 = 0x4000
	// Position of EPT_7 field.
	UDPHS_IEN_EPT_7_Pos = 0xf
	// Bit mask of EPT_7 field.
	UDPHS_IEN_EPT_7_Msk = 0x8000
	// Bit EPT_7.
	UDPHS_IEN_EPT_7 = 0x8000
	// Position of EPT_8 field.
	UDPHS_IEN_EPT_8_Pos = 0x10
	// Bit mask of EPT_8 field.
	UDPHS_IEN_EPT_8_Msk = 0x10000
	// Bit EPT_8.
	UDPHS_IEN_EPT_8 = 0x10000
	// Position of EPT_9 field.
	UDPHS_IEN_EPT_9_Pos = 0x11
	// Bit mask of EPT_9 field.
	UDPHS_IEN_EPT_9_Msk = 0x20000
	// Bit EPT_9.
	UDPHS_IEN_EPT_9 = 0x20000
	// Position of EPT_10 field.
	UDPHS_IEN_EPT_10_Pos = 0x12
	// Bit mask of EPT_10 field.
	UDPHS_IEN_EPT_10_Msk = 0x40000
	// Bit EPT_10.
	UDPHS_IEN_EPT_10 = 0x40000
	// Position of EPT_11 field.
	UDPHS_IEN_EPT_11_Pos = 0x13
	// Bit mask of EPT_11 field.
	UDPHS_IEN_EPT_11_Msk = 0x80000
	// Bit EPT_11.
	UDPHS_IEN_EPT_11 = 0x80000
	// Position of EPT_12 field.
	UDPHS_IEN_EPT_12_Pos = 0x14
	// Bit mask of EPT_12 field.
	UDPHS_IEN_EPT_12_Msk = 0x100000
	// Bit EPT_12.
	UDPHS_IEN_EPT_12 = 0x100000
	// Position of EPT_13 field.
	UDPHS_IEN_EPT_13_Pos = 0x15
	// Bit mask of EPT_13 field.
	UDPHS_IEN_EPT_13_Msk = 0x200000
	// Bit EPT_13.
	UDPHS_IEN_EPT_13 = 0x200000
	// Position of EPT_14 field.
	UDPHS_IEN_EPT_14_Pos = 0x16
	// Bit mask of EPT_14 field.
	UDPHS_IEN_EPT_14_Msk = 0x400000
	// Bit EPT_14.
	UDPHS_IEN_EPT_14 = 0x400000
	// Position of EPT_15 field.
	UDPHS_IEN_EPT_15_Pos = 0x17
	// Bit mask of EPT_15 field.
	UDPHS_IEN_EPT_15_Msk = 0x800000
	// Bit EPT_15.
	UDPHS_IEN_EPT_15 = 0x800000
	// Position of DMA_1 field.
	UDPHS_IEN_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UDPHS_IEN_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UDPHS_IEN_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UDPHS_IEN_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UDPHS_IEN_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UDPHS_IEN_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UDPHS_IEN_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UDPHS_IEN_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UDPHS_IEN_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UDPHS_IEN_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UDPHS_IEN_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UDPHS_IEN_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UDPHS_IEN_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UDPHS_IEN_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UDPHS_IEN_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UDPHS_IEN_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UDPHS_IEN_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UDPHS_IEN_DMA_6 = 0x40000000
	// Position of DMA_7 field.
	UDPHS_IEN_DMA_7_Pos = 0x1f
	// Bit mask of DMA_7 field.
	UDPHS_IEN_DMA_7_Msk = 0x80000000
	// Bit DMA_7.
	UDPHS_IEN_DMA_7 = 0x80000000

	// INTSTA: UDPHS Interrupt Status Register
	// Position of SPEED field.
	UDPHS_INTSTA_SPEED_Pos = 0x0
	// Bit mask of SPEED field.
	UDPHS_INTSTA_SPEED_Msk = 0x1
	// Bit SPEED.
	UDPHS_INTSTA_SPEED = 0x1
	// Position of DET_SUSPD field.
	UDPHS_INTSTA_DET_SUSPD_Pos = 0x1
	// Bit mask of DET_SUSPD field.
	UDPHS_INTSTA_DET_SUSPD_Msk = 0x2
	// Bit DET_SUSPD.
	UDPHS_INTSTA_DET_SUSPD = 0x2
	// Position of MICRO_SOF field.
	UDPHS_INTSTA_MICRO_SOF_Pos = 0x2
	// Bit mask of MICRO_SOF field.
	UDPHS_INTSTA_MICRO_SOF_Msk = 0x4
	// Bit MICRO_SOF.
	UDPHS_INTSTA_MICRO_SOF = 0x4
	// Position of INT_SOF field.
	UDPHS_INTSTA_INT_SOF_Pos = 0x3
	// Bit mask of INT_SOF field.
	UDPHS_INTSTA_INT_SOF_Msk = 0x8
	// Bit INT_SOF.
	UDPHS_INTSTA_INT_SOF = 0x8
	// Position of ENDRESET field.
	UDPHS_INTSTA_ENDRESET_Pos = 0x4
	// Bit mask of ENDRESET field.
	UDPHS_INTSTA_ENDRESET_Msk = 0x10
	// Bit ENDRESET.
	UDPHS_INTSTA_ENDRESET = 0x10
	// Position of WAKE_UP field.
	UDPHS_INTSTA_WAKE_UP_Pos = 0x5
	// Bit mask of WAKE_UP field.
	UDPHS_INTSTA_WAKE_UP_Msk = 0x20
	// Bit WAKE_UP.
	UDPHS_INTSTA_WAKE_UP = 0x20
	// Position of ENDOFRSM field.
	UDPHS_INTSTA_ENDOFRSM_Pos = 0x6
	// Bit mask of ENDOFRSM field.
	UDPHS_INTSTA_ENDOFRSM_Msk = 0x40
	// Bit ENDOFRSM.
	UDPHS_INTSTA_ENDOFRSM = 0x40
	// Position of UPSTR_RES field.
	UDPHS_INTSTA_UPSTR_RES_Pos = 0x7
	// Bit mask of UPSTR_RES field.
	UDPHS_INTSTA_UPSTR_RES_Msk = 0x80
	// Bit UPSTR_RES.
	UDPHS_INTSTA_UPSTR_RES = 0x80
	// Position of EPT_0 field.
	UDPHS_INTSTA_EPT_0_Pos = 0x8
	// Bit mask of EPT_0 field.
	UDPHS_INTSTA_EPT_0_Msk = 0x100
	// Bit EPT_0.
	UDPHS_INTSTA_EPT_0 = 0x100
	// Position of EPT_1 field.
	UDPHS_INTSTA_EPT_1_Pos = 0x9
	// Bit mask of EPT_1 field.
	UDPHS_INTSTA_EPT_1_Msk = 0x200
	// Bit EPT_1.
	UDPHS_INTSTA_EPT_1 = 0x200
	// Position of EPT_2 field.
	UDPHS_INTSTA_EPT_2_Pos = 0xa
	// Bit mask of EPT_2 field.
	UDPHS_INTSTA_EPT_2_Msk = 0x400
	// Bit EPT_2.
	UDPHS_INTSTA_EPT_2 = 0x400
	// Position of EPT_3 field.
	UDPHS_INTSTA_EPT_3_Pos = 0xb
	// Bit mask of EPT_3 field.
	UDPHS_INTSTA_EPT_3_Msk = 0x800
	// Bit EPT_3.
	UDPHS_INTSTA_EPT_3 = 0x800
	// Position of EPT_4 field.
	UDPHS_INTSTA_EPT_4_Pos = 0xc
	// Bit mask of EPT_4 field.
	UDPHS_INTSTA_EPT_4_Msk = 0x1000
	// Bit EPT_4.
	UDPHS_INTSTA_EPT_4 = 0x1000
	// Position of EPT_5 field.
	UDPHS_INTSTA_EPT_5_Pos = 0xd
	// Bit mask of EPT_5 field.
	UDPHS_INTSTA_EPT_5_Msk = 0x2000
	// Bit EPT_5.
	UDPHS_INTSTA_EPT_5 = 0x2000
	// Position of EPT_6 field.
	UDPHS_INTSTA_EPT_6_Pos = 0xe
	// Bit mask of EPT_6 field.
	UDPHS_INTSTA_EPT_6_Msk = 0x4000
	// Bit EPT_6.
	UDPHS_INTSTA_EPT_6 = 0x4000
	// Position of EPT_7 field.
	UDPHS_INTSTA_EPT_7_Pos = 0xf
	// Bit mask of EPT_7 field.
	UDPHS_INTSTA_EPT_7_Msk = 0x8000
	// Bit EPT_7.
	UDPHS_INTSTA_EPT_7 = 0x8000
	// Position of EPT_8 field.
	UDPHS_INTSTA_EPT_8_Pos = 0x10
	// Bit mask of EPT_8 field.
	UDPHS_INTSTA_EPT_8_Msk = 0x10000
	// Bit EPT_8.
	UDPHS_INTSTA_EPT_8 = 0x10000
	// Position of EPT_9 field.
	UDPHS_INTSTA_EPT_9_Pos = 0x11
	// Bit mask of EPT_9 field.
	UDPHS_INTSTA_EPT_9_Msk = 0x20000
	// Bit EPT_9.
	UDPHS_INTSTA_EPT_9 = 0x20000
	// Position of EPT_10 field.
	UDPHS_INTSTA_EPT_10_Pos = 0x12
	// Bit mask of EPT_10 field.
	UDPHS_INTSTA_EPT_10_Msk = 0x40000
	// Bit EPT_10.
	UDPHS_INTSTA_EPT_10 = 0x40000
	// Position of EPT_11 field.
	UDPHS_INTSTA_EPT_11_Pos = 0x13
	// Bit mask of EPT_11 field.
	UDPHS_INTSTA_EPT_11_Msk = 0x80000
	// Bit EPT_11.
	UDPHS_INTSTA_EPT_11 = 0x80000
	// Position of EPT_12 field.
	UDPHS_INTSTA_EPT_12_Pos = 0x14
	// Bit mask of EPT_12 field.
	UDPHS_INTSTA_EPT_12_Msk = 0x100000
	// Bit EPT_12.
	UDPHS_INTSTA_EPT_12 = 0x100000
	// Position of EPT_13 field.
	UDPHS_INTSTA_EPT_13_Pos = 0x15
	// Bit mask of EPT_13 field.
	UDPHS_INTSTA_EPT_13_Msk = 0x200000
	// Bit EPT_13.
	UDPHS_INTSTA_EPT_13 = 0x200000
	// Position of EPT_14 field.
	UDPHS_INTSTA_EPT_14_Pos = 0x16
	// Bit mask of EPT_14 field.
	UDPHS_INTSTA_EPT_14_Msk = 0x400000
	// Bit EPT_14.
	UDPHS_INTSTA_EPT_14 = 0x400000
	// Position of EPT_15 field.
	UDPHS_INTSTA_EPT_15_Pos = 0x17
	// Bit mask of EPT_15 field.
	UDPHS_INTSTA_EPT_15_Msk = 0x800000
	// Bit EPT_15.
	UDPHS_INTSTA_EPT_15 = 0x800000
	// Position of DMA_1 field.
	UDPHS_INTSTA_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UDPHS_INTSTA_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UDPHS_INTSTA_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UDPHS_INTSTA_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UDPHS_INTSTA_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UDPHS_INTSTA_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UDPHS_INTSTA_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UDPHS_INTSTA_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UDPHS_INTSTA_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UDPHS_INTSTA_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UDPHS_INTSTA_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UDPHS_INTSTA_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UDPHS_INTSTA_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UDPHS_INTSTA_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UDPHS_INTSTA_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UDPHS_INTSTA_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UDPHS_INTSTA_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UDPHS_INTSTA_DMA_6 = 0x40000000
	// Position of DMA_7 field.
	UDPHS_INTSTA_DMA_7_Pos = 0x1f
	// Bit mask of DMA_7 field.
	UDPHS_INTSTA_DMA_7_Msk = 0x80000000
	// Bit DMA_7.
	UDPHS_INTSTA_DMA_7 = 0x80000000

	// CLRINT: UDPHS Clear Interrupt Register
	// Position of DET_SUSPD field.
	UDPHS_CLRINT_DET_SUSPD_Pos = 0x1
	// Bit mask of DET_SUSPD field.
	UDPHS_CLRINT_DET_SUSPD_Msk = 0x2
	// Bit DET_SUSPD.
	UDPHS_CLRINT_DET_SUSPD = 0x2
	// Position of MICRO_SOF field.
	UDPHS_CLRINT_MICRO_SOF_Pos = 0x2
	// Bit mask of MICRO_SOF field.
	UDPHS_CLRINT_MICRO_SOF_Msk = 0x4
	// Bit MICRO_SOF.
	UDPHS_CLRINT_MICRO_SOF = 0x4
	// Position of INT_SOF field.
	UDPHS_CLRINT_INT_SOF_Pos = 0x3
	// Bit mask of INT_SOF field.
	UDPHS_CLRINT_INT_SOF_Msk = 0x8
	// Bit INT_SOF.
	UDPHS_CLRINT_INT_SOF = 0x8
	// Position of ENDRESET field.
	UDPHS_CLRINT_ENDRESET_Pos = 0x4
	// Bit mask of ENDRESET field.
	UDPHS_CLRINT_ENDRESET_Msk = 0x10
	// Bit ENDRESET.
	UDPHS_CLRINT_ENDRESET = 0x10
	// Position of WAKE_UP field.
	UDPHS_CLRINT_WAKE_UP_Pos = 0x5
	// Bit mask of WAKE_UP field.
	UDPHS_CLRINT_WAKE_UP_Msk = 0x20
	// Bit WAKE_UP.
	UDPHS_CLRINT_WAKE_UP = 0x20
	// Position of ENDOFRSM field.
	UDPHS_CLRINT_ENDOFRSM_Pos = 0x6
	// Bit mask of ENDOFRSM field.
	UDPHS_CLRINT_ENDOFRSM_Msk = 0x40
	// Bit ENDOFRSM.
	UDPHS_CLRINT_ENDOFRSM = 0x40
	// Position of UPSTR_RES field.
	UDPHS_CLRINT_UPSTR_RES_Pos = 0x7
	// Bit mask of UPSTR_RES field.
	UDPHS_CLRINT_UPSTR_RES_Msk = 0x80
	// Bit UPSTR_RES.
	UDPHS_CLRINT_UPSTR_RES = 0x80

	// EPTRST: UDPHS Endpoints Reset Register
	// Position of EPT_0 field.
	UDPHS_EPTRST_EPT_0_Pos = 0x0
	// Bit mask of EPT_0 field.
	UDPHS_EPTRST_EPT_0_Msk = 0x1
	// Bit EPT_0.
	UDPHS_EPTRST_EPT_0 = 0x1
	// Position of EPT_1 field.
	UDPHS_EPTRST_EPT_1_Pos = 0x1
	// Bit mask of EPT_1 field.
	UDPHS_EPTRST_EPT_1_Msk = 0x2
	// Bit EPT_1.
	UDPHS_EPTRST_EPT_1 = 0x2
	// Position of EPT_2 field.
	UDPHS_EPTRST_EPT_2_Pos = 0x2
	// Bit mask of EPT_2 field.
	UDPHS_EPTRST_EPT_2_Msk = 0x4
	// Bit EPT_2.
	UDPHS_EPTRST_EPT_2 = 0x4
	// Position of EPT_3 field.
	UDPHS_EPTRST_EPT_3_Pos = 0x3
	// Bit mask of EPT_3 field.
	UDPHS_EPTRST_EPT_3_Msk = 0x8
	// Bit EPT_3.
	UDPHS_EPTRST_EPT_3 = 0x8
	// Position of EPT_4 field.
	UDPHS_EPTRST_EPT_4_Pos = 0x4
	// Bit mask of EPT_4 field.
	UDPHS_EPTRST_EPT_4_Msk = 0x10
	// Bit EPT_4.
	UDPHS_EPTRST_EPT_4 = 0x10
	// Position of EPT_5 field.
	UDPHS_EPTRST_EPT_5_Pos = 0x5
	// Bit mask of EPT_5 field.
	UDPHS_EPTRST_EPT_5_Msk = 0x20
	// Bit EPT_5.
	UDPHS_EPTRST_EPT_5 = 0x20
	// Position of EPT_6 field.
	UDPHS_EPTRST_EPT_6_Pos = 0x6
	// Bit mask of EPT_6 field.
	UDPHS_EPTRST_EPT_6_Msk = 0x40
	// Bit EPT_6.
	UDPHS_EPTRST_EPT_6 = 0x40
	// Position of EPT_7 field.
	UDPHS_EPTRST_EPT_7_Pos = 0x7
	// Bit mask of EPT_7 field.
	UDPHS_EPTRST_EPT_7_Msk = 0x80
	// Bit EPT_7.
	UDPHS_EPTRST_EPT_7 = 0x80
	// Position of EPT_8 field.
	UDPHS_EPTRST_EPT_8_Pos = 0x8
	// Bit mask of EPT_8 field.
	UDPHS_EPTRST_EPT_8_Msk = 0x100
	// Bit EPT_8.
	UDPHS_EPTRST_EPT_8 = 0x100
	// Position of EPT_9 field.
	UDPHS_EPTRST_EPT_9_Pos = 0x9
	// Bit mask of EPT_9 field.
	UDPHS_EPTRST_EPT_9_Msk = 0x200
	// Bit EPT_9.
	UDPHS_EPTRST_EPT_9 = 0x200
	// Position of EPT_10 field.
	UDPHS_EPTRST_EPT_10_Pos = 0xa
	// Bit mask of EPT_10 field.
	UDPHS_EPTRST_EPT_10_Msk = 0x400
	// Bit EPT_10.
	UDPHS_EPTRST_EPT_10 = 0x400
	// Position of EPT_11 field.
	UDPHS_EPTRST_EPT_11_Pos = 0xb
	// Bit mask of EPT_11 field.
	UDPHS_EPTRST_EPT_11_Msk = 0x800
	// Bit EPT_11.
	UDPHS_EPTRST_EPT_11 = 0x800
	// Position of EPT_12 field.
	UDPHS_EPTRST_EPT_12_Pos = 0xc
	// Bit mask of EPT_12 field.
	UDPHS_EPTRST_EPT_12_Msk = 0x1000
	// Bit EPT_12.
	UDPHS_EPTRST_EPT_12 = 0x1000
	// Position of EPT_13 field.
	UDPHS_EPTRST_EPT_13_Pos = 0xd
	// Bit mask of EPT_13 field.
	UDPHS_EPTRST_EPT_13_Msk = 0x2000
	// Bit EPT_13.
	UDPHS_EPTRST_EPT_13 = 0x2000
	// Position of EPT_14 field.
	UDPHS_EPTRST_EPT_14_Pos = 0xe
	// Bit mask of EPT_14 field.
	UDPHS_EPTRST_EPT_14_Msk = 0x4000
	// Bit EPT_14.
	UDPHS_EPTRST_EPT_14 = 0x4000
	// Position of EPT_15 field.
	UDPHS_EPTRST_EPT_15_Pos = 0xf
	// Bit mask of EPT_15 field.
	UDPHS_EPTRST_EPT_15_Msk = 0x8000
	// Bit EPT_15.
	UDPHS_EPTRST_EPT_15 = 0x8000

	// TST: UDPHS Test Register
	// Position of SPEED_CFG field.
	UDPHS_TST_SPEED_CFG_Pos = 0x0
	// Bit mask of SPEED_CFG field.
	UDPHS_TST_SPEED_CFG_Msk = 0x3
	// Normal Mode: The macro is in Full Speed mode, ready to make a High Speed identification, if the host supports it and then to automatically switch to High Speed mode
	UDPHS_TST_SPEED_CFG_NORMAL = 0x0
	// Force High Speed: Set this value to force the hardware to work in High Speed mode. Only for debug or test purpose.
	UDPHS_TST_SPEED_CFG_HIGH_SPEED = 0x2
	// Force Full Speed: Set this value to force the hardware to work only in Full Speed mode. In this configuration, the macro will not respond to a High Speed reset handshake.
	UDPHS_TST_SPEED_CFG_FULL_SPEED = 0x3
	// Position of TST_J field.
	UDPHS_TST_TST_J_Pos = 0x2
	// Bit mask of TST_J field.
	UDPHS_TST_TST_J_Msk = 0x4
	// Bit TST_J.
	UDPHS_TST_TST_J = 0x4
	// Position of TST_K field.
	UDPHS_TST_TST_K_Pos = 0x3
	// Bit mask of TST_K field.
	UDPHS_TST_TST_K_Msk = 0x8
	// Bit TST_K.
	UDPHS_TST_TST_K = 0x8
	// Position of TST_PKT field.
	UDPHS_TST_TST_PKT_Pos = 0x4
	// Bit mask of TST_PKT field.
	UDPHS_TST_TST_PKT_Msk = 0x10
	// Bit TST_PKT.
	UDPHS_TST_TST_PKT = 0x10
	// Position of OPMODE2 field.
	UDPHS_TST_OPMODE2_Pos = 0x5
	// Bit mask of OPMODE2 field.
	UDPHS_TST_OPMODE2_Msk = 0x20
	// Bit OPMODE2.
	UDPHS_TST_OPMODE2 = 0x20

	// EPTCFG0: UDPHS Endpoint Configuration Register (endpoint = 0)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG0_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG0_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG0_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG0_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG0_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG0_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG0_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG0_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG0_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG0_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG0_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG0_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG0_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG0_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG0_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG0_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG0_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG0_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG0_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG0_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG0_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG0_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG0_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG0_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG0_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG0_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG0_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG0_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG0_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG0_EPT_MAPD = 0x80000000

	// EPTCTLENB0: UDPHS Endpoint Control Enable Register (endpoint = 0)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB0_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB0_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB0_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB0_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB0_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB0_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB0_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB0_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB0_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB0_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB0_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB0_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB0_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB0_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB0_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB0_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB0_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB0_SHRT_PCKT = 0x80000000

	// EPTCTLENB0_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 0)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS0: UDPHS Endpoint Control Disable Register (endpoint = 0)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS0_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS0_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS0_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS0_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS0_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS0_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS0_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS0_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS0_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS0_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS0_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS0_SHRT_PCKT = 0x80000000

	// EPTCTLDIS0_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 0)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL0: UDPHS Endpoint Control Register (endpoint = 0)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL0_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL0_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL0_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL0_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL0_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL0_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL0_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL0_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL0_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL0_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL0_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL0_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL0_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL0_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL0_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL0_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL0_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL0_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL0_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL0_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL0_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL0_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL0_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL0_SHRT_PCKT = 0x80000000

	// EPTCTL0_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 0)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA0: UDPHS Endpoint Set Status Register (endpoint = 0)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA0_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA0_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA0_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA0_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA0_TXRDY = 0x800

	// EPTSETSTA0_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 0)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA0: UDPHS Endpoint Clear Status Register (endpoint = 0)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA0_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA0_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA0_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA0_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA0_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA0_NAK_OUT = 0x8000

	// EPTCLRSTA0_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 0)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA0: UDPHS Endpoint Status Register (endpoint = 0)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA0_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA0_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA0_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA0_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA0_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA0_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA0_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA0_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA0_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA0_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA0_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA0_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA0_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA0_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA0_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA0_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA0_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA0_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA0_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA0_SHRT_PCKT = 0x80000000

	// EPTSTA0_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 0)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA0_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA0_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG1: UDPHS Endpoint Configuration Register (endpoint = 1)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG1_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG1_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG1_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG1_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG1_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG1_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG1_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG1_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG1_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG1_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG1_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG1_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG1_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG1_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG1_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG1_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG1_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG1_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG1_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG1_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG1_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG1_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG1_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG1_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG1_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG1_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG1_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG1_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG1_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG1_EPT_MAPD = 0x80000000

	// EPTCTLENB1: UDPHS Endpoint Control Enable Register (endpoint = 1)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB1_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB1_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB1_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB1_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB1_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB1_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB1_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB1_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB1_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB1_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB1_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB1_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB1_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB1_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB1_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB1_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB1_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB1_SHRT_PCKT = 0x80000000

	// EPTCTLENB1_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 1)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS1: UDPHS Endpoint Control Disable Register (endpoint = 1)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS1_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS1_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS1_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS1_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS1_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS1_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS1_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS1_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS1_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS1_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS1_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS1_SHRT_PCKT = 0x80000000

	// EPTCTLDIS1_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 1)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL1: UDPHS Endpoint Control Register (endpoint = 1)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL1_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL1_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL1_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL1_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL1_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL1_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL1_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL1_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL1_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL1_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL1_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL1_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL1_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL1_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL1_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL1_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL1_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL1_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL1_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL1_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL1_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL1_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL1_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL1_SHRT_PCKT = 0x80000000

	// EPTCTL1_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 1)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA1: UDPHS Endpoint Set Status Register (endpoint = 1)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA1_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA1_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA1_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA1_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA1_TXRDY = 0x800

	// EPTSETSTA1_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 1)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA1: UDPHS Endpoint Clear Status Register (endpoint = 1)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA1_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA1_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA1_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA1_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA1_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA1_NAK_OUT = 0x8000

	// EPTCLRSTA1_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 1)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA1: UDPHS Endpoint Status Register (endpoint = 1)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA1_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA1_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA1_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA1_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA1_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA1_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA1_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA1_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA1_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA1_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA1_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA1_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA1_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA1_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA1_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA1_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA1_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA1_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA1_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA1_SHRT_PCKT = 0x80000000

	// EPTSTA1_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 1)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA1_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA1_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG2: UDPHS Endpoint Configuration Register (endpoint = 2)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG2_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG2_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG2_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG2_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG2_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG2_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG2_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG2_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG2_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG2_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG2_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG2_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG2_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG2_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG2_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG2_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG2_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG2_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG2_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG2_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG2_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG2_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG2_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG2_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG2_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG2_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG2_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG2_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG2_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG2_EPT_MAPD = 0x80000000

	// EPTCTLENB2: UDPHS Endpoint Control Enable Register (endpoint = 2)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB2_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB2_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB2_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB2_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB2_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB2_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB2_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB2_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB2_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB2_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB2_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB2_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB2_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB2_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB2_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB2_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB2_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB2_SHRT_PCKT = 0x80000000

	// EPTCTLENB2_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 2)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS2: UDPHS Endpoint Control Disable Register (endpoint = 2)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS2_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS2_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS2_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS2_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS2_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS2_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS2_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS2_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS2_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS2_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS2_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS2_SHRT_PCKT = 0x80000000

	// EPTCTLDIS2_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 2)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL2: UDPHS Endpoint Control Register (endpoint = 2)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL2_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL2_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL2_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL2_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL2_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL2_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL2_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL2_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL2_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL2_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL2_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL2_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL2_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL2_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL2_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL2_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL2_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL2_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL2_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL2_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL2_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL2_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL2_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL2_SHRT_PCKT = 0x80000000

	// EPTCTL2_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 2)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA2: UDPHS Endpoint Set Status Register (endpoint = 2)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA2_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA2_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA2_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA2_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA2_TXRDY = 0x800

	// EPTSETSTA2_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 2)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA2: UDPHS Endpoint Clear Status Register (endpoint = 2)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA2_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA2_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA2_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA2_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA2_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA2_NAK_OUT = 0x8000

	// EPTCLRSTA2_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 2)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA2: UDPHS Endpoint Status Register (endpoint = 2)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA2_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA2_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA2_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA2_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA2_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA2_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA2_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA2_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA2_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA2_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA2_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA2_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA2_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA2_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA2_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA2_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA2_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA2_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA2_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA2_SHRT_PCKT = 0x80000000

	// EPTSTA2_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 2)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA2_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA2_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG3: UDPHS Endpoint Configuration Register (endpoint = 3)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG3_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG3_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG3_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG3_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG3_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG3_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG3_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG3_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG3_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG3_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG3_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG3_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG3_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG3_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG3_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG3_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG3_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG3_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG3_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG3_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG3_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG3_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG3_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG3_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG3_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG3_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG3_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG3_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG3_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG3_EPT_MAPD = 0x80000000

	// EPTCTLENB3: UDPHS Endpoint Control Enable Register (endpoint = 3)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB3_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB3_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB3_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB3_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB3_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB3_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB3_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB3_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB3_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB3_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB3_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB3_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB3_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB3_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB3_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB3_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB3_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB3_SHRT_PCKT = 0x80000000

	// EPTCTLENB3_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 3)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS3: UDPHS Endpoint Control Disable Register (endpoint = 3)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS3_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS3_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS3_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS3_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS3_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS3_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS3_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS3_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS3_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS3_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS3_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS3_SHRT_PCKT = 0x80000000

	// EPTCTLDIS3_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 3)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL3: UDPHS Endpoint Control Register (endpoint = 3)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL3_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL3_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL3_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL3_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL3_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL3_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL3_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL3_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL3_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL3_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL3_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL3_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL3_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL3_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL3_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL3_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL3_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL3_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL3_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL3_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL3_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL3_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL3_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL3_SHRT_PCKT = 0x80000000

	// EPTCTL3_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 3)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA3: UDPHS Endpoint Set Status Register (endpoint = 3)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA3_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA3_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA3_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA3_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA3_TXRDY = 0x800

	// EPTSETSTA3_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 3)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA3: UDPHS Endpoint Clear Status Register (endpoint = 3)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA3_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA3_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA3_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA3_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA3_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA3_NAK_OUT = 0x8000

	// EPTCLRSTA3_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 3)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA3: UDPHS Endpoint Status Register (endpoint = 3)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA3_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA3_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA3_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA3_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA3_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA3_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA3_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA3_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA3_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA3_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA3_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA3_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA3_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA3_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA3_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA3_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA3_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA3_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA3_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA3_SHRT_PCKT = 0x80000000

	// EPTSTA3_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 3)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA3_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA3_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG4: UDPHS Endpoint Configuration Register (endpoint = 4)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG4_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG4_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG4_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG4_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG4_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG4_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG4_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG4_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG4_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG4_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG4_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG4_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG4_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG4_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG4_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG4_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG4_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG4_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG4_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG4_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG4_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG4_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG4_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG4_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG4_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG4_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG4_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG4_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG4_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG4_EPT_MAPD = 0x80000000

	// EPTCTLENB4: UDPHS Endpoint Control Enable Register (endpoint = 4)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB4_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB4_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB4_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB4_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB4_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB4_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB4_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB4_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB4_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB4_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB4_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB4_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB4_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB4_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB4_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB4_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB4_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB4_SHRT_PCKT = 0x80000000

	// EPTCTLENB4_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 4)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS4: UDPHS Endpoint Control Disable Register (endpoint = 4)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS4_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS4_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS4_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS4_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS4_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS4_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS4_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS4_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS4_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS4_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS4_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS4_SHRT_PCKT = 0x80000000

	// EPTCTLDIS4_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 4)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL4: UDPHS Endpoint Control Register (endpoint = 4)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL4_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL4_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL4_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL4_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL4_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL4_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL4_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL4_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL4_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL4_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL4_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL4_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL4_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL4_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL4_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL4_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL4_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL4_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL4_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL4_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL4_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL4_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL4_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL4_SHRT_PCKT = 0x80000000

	// EPTCTL4_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 4)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA4: UDPHS Endpoint Set Status Register (endpoint = 4)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA4_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA4_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA4_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA4_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA4_TXRDY = 0x800

	// EPTSETSTA4_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 4)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA4: UDPHS Endpoint Clear Status Register (endpoint = 4)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA4_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA4_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA4_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA4_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA4_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA4_NAK_OUT = 0x8000

	// EPTCLRSTA4_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 4)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA4: UDPHS Endpoint Status Register (endpoint = 4)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA4_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA4_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA4_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA4_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA4_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA4_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA4_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA4_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA4_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA4_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA4_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA4_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA4_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA4_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA4_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA4_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA4_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA4_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA4_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA4_SHRT_PCKT = 0x80000000

	// EPTSTA4_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 4)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA4_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA4_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG5: UDPHS Endpoint Configuration Register (endpoint = 5)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG5_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG5_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG5_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG5_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG5_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG5_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG5_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG5_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG5_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG5_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG5_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG5_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG5_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG5_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG5_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG5_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG5_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG5_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG5_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG5_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG5_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG5_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG5_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG5_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG5_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG5_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG5_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG5_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG5_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG5_EPT_MAPD = 0x80000000

	// EPTCTLENB5: UDPHS Endpoint Control Enable Register (endpoint = 5)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB5_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB5_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB5_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB5_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB5_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB5_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB5_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB5_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB5_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB5_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB5_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB5_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB5_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB5_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB5_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB5_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB5_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB5_SHRT_PCKT = 0x80000000

	// EPTCTLENB5_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 5)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS5: UDPHS Endpoint Control Disable Register (endpoint = 5)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS5_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS5_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS5_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS5_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS5_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS5_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS5_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS5_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS5_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS5_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS5_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS5_SHRT_PCKT = 0x80000000

	// EPTCTLDIS5_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 5)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL5: UDPHS Endpoint Control Register (endpoint = 5)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL5_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL5_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL5_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL5_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL5_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL5_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL5_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL5_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL5_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL5_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL5_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL5_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL5_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL5_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL5_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL5_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL5_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL5_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL5_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL5_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL5_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL5_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL5_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL5_SHRT_PCKT = 0x80000000

	// EPTCTL5_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 5)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA5: UDPHS Endpoint Set Status Register (endpoint = 5)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA5_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA5_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA5_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA5_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA5_TXRDY = 0x800

	// EPTSETSTA5_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 5)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA5: UDPHS Endpoint Clear Status Register (endpoint = 5)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA5_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA5_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA5_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA5_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA5_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA5_NAK_OUT = 0x8000

	// EPTCLRSTA5_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 5)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA5: UDPHS Endpoint Status Register (endpoint = 5)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA5_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA5_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA5_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA5_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA5_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA5_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA5_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA5_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA5_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA5_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA5_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA5_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA5_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA5_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA5_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA5_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA5_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA5_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA5_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA5_SHRT_PCKT = 0x80000000

	// EPTSTA5_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 5)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA5_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA5_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG6: UDPHS Endpoint Configuration Register (endpoint = 6)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG6_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG6_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG6_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG6_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG6_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG6_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG6_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG6_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG6_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG6_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG6_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG6_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG6_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG6_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG6_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG6_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG6_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG6_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG6_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG6_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG6_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG6_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG6_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG6_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG6_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG6_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG6_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG6_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG6_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG6_EPT_MAPD = 0x80000000

	// EPTCTLENB6: UDPHS Endpoint Control Enable Register (endpoint = 6)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB6_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB6_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB6_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB6_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB6_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB6_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB6_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB6_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB6_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB6_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB6_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB6_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB6_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB6_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB6_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB6_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB6_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB6_SHRT_PCKT = 0x80000000

	// EPTCTLENB6_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 6)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS6: UDPHS Endpoint Control Disable Register (endpoint = 6)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS6_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS6_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS6_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS6_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS6_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS6_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS6_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS6_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS6_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS6_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS6_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS6_SHRT_PCKT = 0x80000000

	// EPTCTLDIS6_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 6)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL6: UDPHS Endpoint Control Register (endpoint = 6)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL6_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL6_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL6_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL6_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL6_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL6_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL6_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL6_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL6_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL6_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL6_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL6_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL6_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL6_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL6_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL6_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL6_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL6_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL6_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL6_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL6_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL6_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL6_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL6_SHRT_PCKT = 0x80000000

	// EPTCTL6_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 6)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA6: UDPHS Endpoint Set Status Register (endpoint = 6)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA6_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA6_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA6_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA6_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA6_TXRDY = 0x800

	// EPTSETSTA6_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 6)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA6: UDPHS Endpoint Clear Status Register (endpoint = 6)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA6_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA6_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA6_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA6_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA6_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA6_NAK_OUT = 0x8000

	// EPTCLRSTA6_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 6)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA6: UDPHS Endpoint Status Register (endpoint = 6)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA6_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA6_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA6_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA6_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA6_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA6_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA6_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA6_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA6_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA6_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA6_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA6_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA6_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA6_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA6_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA6_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA6_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA6_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA6_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA6_SHRT_PCKT = 0x80000000

	// EPTSTA6_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 6)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA6_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA6_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG7: UDPHS Endpoint Configuration Register (endpoint = 7)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG7_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG7_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG7_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG7_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG7_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG7_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG7_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG7_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG7_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG7_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG7_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG7_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG7_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG7_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG7_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG7_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG7_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG7_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG7_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG7_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG7_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG7_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG7_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG7_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG7_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG7_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG7_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG7_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG7_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG7_EPT_MAPD = 0x80000000

	// EPTCTLENB7: UDPHS Endpoint Control Enable Register (endpoint = 7)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB7_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB7_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB7_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB7_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB7_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB7_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB7_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB7_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB7_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB7_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB7_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB7_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB7_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB7_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB7_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB7_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB7_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB7_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB7_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB7_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB7_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB7_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB7_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB7_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB7_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB7_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB7_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB7_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB7_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB7_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB7_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB7_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB7_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB7_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB7_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB7_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB7_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB7_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB7_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB7_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB7_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB7_SHRT_PCKT = 0x80000000

	// EPTCTLENB7_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 7)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB7_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB7_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB7_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB7_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB7_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB7_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB7_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB7_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB7_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB7_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB7_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB7_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB7_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB7_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB7_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB7_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB7_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB7_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB7_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB7_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB7_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB7_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB7_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB7_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB7_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB7_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB7_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB7_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB7_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB7_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB7_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS7: UDPHS Endpoint Control Disable Register (endpoint = 7)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS7_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS7_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS7_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS7_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS7_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS7_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS7_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS7_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS7_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS7_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS7_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS7_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS7_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS7_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS7_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS7_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS7_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS7_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS7_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS7_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS7_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS7_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS7_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS7_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS7_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS7_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS7_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS7_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS7_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS7_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS7_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS7_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS7_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS7_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS7_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS7_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS7_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS7_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS7_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS7_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS7_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS7_SHRT_PCKT = 0x80000000

	// EPTCTLDIS7_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 7)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS7_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS7_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS7_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS7_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS7_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS7_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS7_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS7_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS7_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS7_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS7_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS7_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS7_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS7_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS7_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS7_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS7_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS7_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS7_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS7_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS7_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS7_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS7_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS7_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS7_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS7_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS7_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS7_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS7_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS7_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS7_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL7: UDPHS Endpoint Control Register (endpoint = 7)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL7_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL7_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL7_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL7_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL7_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL7_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL7_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL7_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL7_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL7_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL7_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL7_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL7_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL7_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL7_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL7_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL7_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL7_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL7_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL7_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL7_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL7_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL7_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL7_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL7_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL7_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL7_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL7_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL7_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL7_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL7_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL7_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL7_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL7_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL7_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL7_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL7_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL7_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL7_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL7_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL7_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL7_SHRT_PCKT = 0x80000000

	// EPTCTL7_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 7)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL7_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL7_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL7_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL7_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL7_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL7_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL7_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL7_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL7_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL7_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL7_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL7_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL7_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL7_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL7_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL7_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL7_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL7_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL7_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL7_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL7_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL7_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL7_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL7_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL7_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL7_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL7_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL7_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL7_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL7_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL7_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL7_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL7_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL7_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL7_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL7_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL7_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL7_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL7_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL7_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL7_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL7_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA7: UDPHS Endpoint Set Status Register (endpoint = 7)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA7_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA7_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA7_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA7_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA7_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA7_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA7_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA7_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA7_TXRDY = 0x800

	// EPTSETSTA7_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 7)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA7_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA7_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA7_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA7_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA7_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA7_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA7: UDPHS Endpoint Clear Status Register (endpoint = 7)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA7_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA7_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA7_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA7_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA7_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA7_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA7_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA7_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA7_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA7_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA7_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA7_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA7_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA7_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA7_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA7_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA7_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA7_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA7_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA7_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA7_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA7_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA7_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA7_NAK_OUT = 0x8000

	// EPTCLRSTA7_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 7)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA7_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA7_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA7_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA7_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA7_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA7_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA7_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA7_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA7_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA7_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA7_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA7_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA7_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA7_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA7_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA7_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA7_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA7_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA7: UDPHS Endpoint Status Register (endpoint = 7)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA7_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA7_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA7_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA7_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA7_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA7_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA7_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA7_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA7_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA7_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA7_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA7_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA7_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA7_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA7_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA7_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA7_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA7_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA7_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA7_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA7_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA7_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA7_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA7_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA7_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA7_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA7_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA7_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA7_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA7_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA7_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA7_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA7_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA7_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA7_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA7_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA7_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA7_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA7_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA7_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA7_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA7_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA7_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA7_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA7_SHRT_PCKT = 0x80000000

	// EPTSTA7_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 7)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA7_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA7_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA7_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA7_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA7_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA7_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA7_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA7_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA7_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA7_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA7_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA7_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA7_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA7_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA7_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA7_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA7_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA7_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA7_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA7_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA7_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA7_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA7_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA7_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA7_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA7_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA7_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA7_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA7_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA7_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA7_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA7_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA7_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA7_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA7_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA7_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA7_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA7_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA7_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA7_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA7_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA7_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG8: UDPHS Endpoint Configuration Register (endpoint = 8)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG8_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG8_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG8_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG8_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG8_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG8_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG8_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG8_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG8_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG8_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG8_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG8_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG8_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG8_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG8_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG8_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG8_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG8_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG8_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG8_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG8_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG8_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG8_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG8_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG8_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG8_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG8_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG8_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG8_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG8_EPT_MAPD = 0x80000000

	// EPTCTLENB8: UDPHS Endpoint Control Enable Register (endpoint = 8)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB8_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB8_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB8_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB8_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB8_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB8_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB8_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB8_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB8_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB8_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB8_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB8_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB8_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB8_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB8_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB8_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB8_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB8_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB8_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB8_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB8_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB8_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB8_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB8_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB8_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB8_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB8_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB8_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB8_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB8_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB8_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB8_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB8_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB8_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB8_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB8_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB8_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB8_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB8_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB8_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB8_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB8_SHRT_PCKT = 0x80000000

	// EPTCTLENB8_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 8)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB8_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB8_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB8_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB8_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB8_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB8_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB8_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB8_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB8_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB8_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB8_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB8_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB8_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB8_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB8_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB8_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB8_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB8_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB8_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB8_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB8_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB8_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB8_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB8_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB8_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB8_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB8_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB8_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB8_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB8_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB8_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS8: UDPHS Endpoint Control Disable Register (endpoint = 8)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS8_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS8_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS8_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS8_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS8_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS8_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS8_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS8_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS8_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS8_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS8_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS8_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS8_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS8_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS8_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS8_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS8_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS8_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS8_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS8_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS8_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS8_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS8_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS8_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS8_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS8_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS8_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS8_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS8_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS8_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS8_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS8_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS8_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS8_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS8_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS8_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS8_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS8_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS8_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS8_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS8_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS8_SHRT_PCKT = 0x80000000

	// EPTCTLDIS8_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 8)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS8_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS8_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS8_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS8_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS8_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS8_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS8_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS8_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS8_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS8_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS8_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS8_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS8_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS8_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS8_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS8_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS8_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS8_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS8_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS8_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS8_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS8_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS8_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS8_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS8_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS8_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS8_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS8_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS8_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS8_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS8_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL8: UDPHS Endpoint Control Register (endpoint = 8)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL8_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL8_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL8_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL8_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL8_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL8_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL8_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL8_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL8_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL8_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL8_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL8_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL8_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL8_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL8_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL8_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL8_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL8_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL8_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL8_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL8_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL8_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL8_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL8_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL8_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL8_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL8_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL8_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL8_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL8_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL8_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL8_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL8_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL8_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL8_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL8_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL8_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL8_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL8_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL8_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL8_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL8_SHRT_PCKT = 0x80000000

	// EPTCTL8_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 8)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL8_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL8_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL8_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL8_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL8_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL8_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL8_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL8_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL8_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL8_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL8_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL8_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL8_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL8_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL8_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL8_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL8_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL8_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL8_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL8_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL8_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL8_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL8_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL8_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL8_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL8_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL8_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL8_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL8_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL8_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL8_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL8_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL8_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL8_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL8_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL8_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL8_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL8_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL8_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL8_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL8_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL8_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA8: UDPHS Endpoint Set Status Register (endpoint = 8)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA8_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA8_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA8_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA8_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA8_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA8_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA8_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA8_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA8_TXRDY = 0x800

	// EPTSETSTA8_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 8)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA8_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA8_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA8_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA8_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA8_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA8_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA8: UDPHS Endpoint Clear Status Register (endpoint = 8)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA8_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA8_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA8_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA8_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA8_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA8_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA8_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA8_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA8_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA8_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA8_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA8_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA8_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA8_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA8_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA8_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA8_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA8_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA8_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA8_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA8_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA8_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA8_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA8_NAK_OUT = 0x8000

	// EPTCLRSTA8_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 8)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA8_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA8_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA8_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA8_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA8_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA8_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA8_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA8_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA8_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA8_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA8_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA8_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA8_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA8_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA8_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA8_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA8_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA8_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA8: UDPHS Endpoint Status Register (endpoint = 8)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA8_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA8_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA8_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA8_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA8_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA8_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA8_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA8_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA8_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA8_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA8_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA8_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA8_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA8_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA8_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA8_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA8_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA8_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA8_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA8_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA8_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA8_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA8_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA8_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA8_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA8_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA8_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA8_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA8_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA8_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA8_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA8_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA8_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA8_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA8_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA8_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA8_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA8_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA8_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA8_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA8_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA8_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA8_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA8_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA8_SHRT_PCKT = 0x80000000

	// EPTSTA8_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 8)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA8_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA8_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA8_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA8_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA8_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA8_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA8_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA8_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA8_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA8_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA8_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA8_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA8_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA8_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA8_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA8_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA8_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA8_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA8_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA8_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA8_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA8_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA8_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA8_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA8_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA8_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA8_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA8_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA8_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA8_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA8_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA8_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA8_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA8_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA8_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA8_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA8_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA8_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA8_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA8_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA8_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA8_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG9: UDPHS Endpoint Configuration Register (endpoint = 9)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG9_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG9_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG9_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG9_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG9_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG9_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG9_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG9_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG9_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG9_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG9_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG9_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG9_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG9_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG9_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG9_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG9_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG9_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG9_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG9_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG9_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG9_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG9_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG9_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG9_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG9_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG9_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG9_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG9_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG9_EPT_MAPD = 0x80000000

	// EPTCTLENB9: UDPHS Endpoint Control Enable Register (endpoint = 9)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB9_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB9_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB9_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB9_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB9_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB9_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB9_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB9_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB9_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB9_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB9_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB9_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB9_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB9_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB9_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB9_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB9_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB9_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB9_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB9_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB9_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB9_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB9_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB9_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB9_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB9_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB9_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB9_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB9_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB9_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB9_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB9_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB9_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB9_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB9_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB9_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB9_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB9_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB9_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB9_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB9_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB9_SHRT_PCKT = 0x80000000

	// EPTCTLENB9_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 9)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB9_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB9_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB9_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB9_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB9_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB9_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB9_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB9_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB9_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB9_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB9_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB9_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB9_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB9_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB9_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB9_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB9_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB9_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB9_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB9_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB9_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB9_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB9_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB9_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB9_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB9_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB9_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB9_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB9_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB9_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB9_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS9: UDPHS Endpoint Control Disable Register (endpoint = 9)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS9_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS9_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS9_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS9_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS9_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS9_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS9_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS9_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS9_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS9_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS9_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS9_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS9_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS9_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS9_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS9_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS9_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS9_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS9_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS9_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS9_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS9_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS9_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS9_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS9_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS9_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS9_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS9_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS9_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS9_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS9_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS9_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS9_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS9_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS9_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS9_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS9_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS9_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS9_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS9_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS9_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS9_SHRT_PCKT = 0x80000000

	// EPTCTLDIS9_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 9)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS9_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS9_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS9_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS9_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS9_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS9_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS9_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS9_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS9_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS9_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS9_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS9_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS9_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS9_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS9_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS9_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS9_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS9_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS9_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS9_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS9_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS9_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS9_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS9_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS9_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS9_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS9_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS9_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS9_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS9_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS9_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL9: UDPHS Endpoint Control Register (endpoint = 9)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL9_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL9_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL9_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL9_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL9_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL9_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL9_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL9_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL9_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL9_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL9_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL9_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL9_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL9_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL9_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL9_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL9_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL9_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL9_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL9_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL9_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL9_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL9_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL9_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL9_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL9_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL9_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL9_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL9_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL9_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL9_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL9_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL9_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL9_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL9_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL9_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL9_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL9_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL9_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL9_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL9_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL9_SHRT_PCKT = 0x80000000

	// EPTCTL9_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 9)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL9_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL9_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL9_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL9_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL9_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL9_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL9_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL9_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL9_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL9_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL9_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL9_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL9_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL9_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL9_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL9_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL9_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL9_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL9_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL9_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL9_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL9_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL9_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL9_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL9_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL9_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL9_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL9_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL9_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL9_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL9_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL9_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL9_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL9_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL9_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL9_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL9_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL9_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL9_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL9_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL9_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL9_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA9: UDPHS Endpoint Set Status Register (endpoint = 9)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA9_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA9_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA9_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA9_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA9_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA9_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA9_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA9_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA9_TXRDY = 0x800

	// EPTSETSTA9_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 9)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA9_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA9_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA9_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA9_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA9_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA9_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA9: UDPHS Endpoint Clear Status Register (endpoint = 9)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA9_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA9_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA9_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA9_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA9_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA9_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA9_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA9_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA9_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA9_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA9_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA9_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA9_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA9_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA9_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA9_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA9_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA9_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA9_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA9_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA9_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA9_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA9_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA9_NAK_OUT = 0x8000

	// EPTCLRSTA9_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 9)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA9_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA9_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA9_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA9_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA9_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA9_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA9_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA9_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA9_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA9_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA9_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA9_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA9_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA9_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA9_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA9_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA9_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA9_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA9: UDPHS Endpoint Status Register (endpoint = 9)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA9_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA9_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA9_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA9_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA9_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA9_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA9_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA9_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA9_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA9_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA9_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA9_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA9_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA9_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA9_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA9_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA9_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA9_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA9_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA9_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA9_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA9_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA9_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA9_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA9_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA9_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA9_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA9_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA9_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA9_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA9_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA9_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA9_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA9_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA9_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA9_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA9_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA9_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA9_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA9_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA9_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA9_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA9_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA9_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA9_SHRT_PCKT = 0x80000000

	// EPTSTA9_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 9)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA9_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA9_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA9_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA9_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA9_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA9_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA9_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA9_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA9_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA9_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA9_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA9_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA9_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA9_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA9_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA9_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA9_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA9_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA9_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA9_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA9_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA9_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA9_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA9_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA9_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA9_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA9_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA9_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA9_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA9_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA9_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA9_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA9_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA9_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA9_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA9_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA9_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA9_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA9_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA9_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA9_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA9_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG10: UDPHS Endpoint Configuration Register (endpoint = 10)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG10_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG10_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG10_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG10_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG10_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG10_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG10_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG10_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG10_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG10_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG10_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG10_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG10_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG10_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG10_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG10_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG10_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG10_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG10_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG10_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG10_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG10_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG10_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG10_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG10_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG10_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG10_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG10_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG10_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG10_EPT_MAPD = 0x80000000

	// EPTCTLENB10: UDPHS Endpoint Control Enable Register (endpoint = 10)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB10_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB10_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB10_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB10_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB10_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB10_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB10_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB10_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB10_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB10_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB10_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB10_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB10_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB10_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB10_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB10_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB10_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB10_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB10_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB10_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB10_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB10_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB10_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB10_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB10_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB10_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB10_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB10_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB10_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB10_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB10_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB10_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB10_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB10_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB10_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB10_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB10_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB10_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB10_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB10_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB10_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB10_SHRT_PCKT = 0x80000000

	// EPTCTLENB10_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 10)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB10_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB10_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB10_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB10_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB10_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB10_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB10_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB10_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB10_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB10_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB10_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB10_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB10_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB10_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB10_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB10_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB10_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB10_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB10_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB10_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB10_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB10_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB10_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB10_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB10_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB10_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB10_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB10_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB10_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB10_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB10_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS10: UDPHS Endpoint Control Disable Register (endpoint = 10)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS10_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS10_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS10_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS10_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS10_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS10_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS10_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS10_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS10_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS10_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS10_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS10_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS10_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS10_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS10_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS10_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS10_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS10_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS10_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS10_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS10_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS10_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS10_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS10_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS10_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS10_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS10_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS10_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS10_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS10_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS10_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS10_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS10_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS10_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS10_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS10_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS10_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS10_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS10_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS10_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS10_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS10_SHRT_PCKT = 0x80000000

	// EPTCTLDIS10_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 10)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS10_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS10_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS10_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS10_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS10_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS10_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS10_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS10_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS10_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS10_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS10_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS10_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS10_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS10_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS10_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS10_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS10_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS10_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS10_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS10_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS10_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS10_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS10_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS10_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS10_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS10_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS10_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS10_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS10_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS10_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS10_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL10: UDPHS Endpoint Control Register (endpoint = 10)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL10_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL10_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL10_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL10_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL10_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL10_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL10_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL10_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL10_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL10_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL10_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL10_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL10_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL10_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL10_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL10_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL10_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL10_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL10_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL10_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL10_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL10_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL10_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL10_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL10_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL10_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL10_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL10_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL10_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL10_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL10_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL10_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL10_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL10_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL10_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL10_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL10_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL10_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL10_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL10_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL10_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL10_SHRT_PCKT = 0x80000000

	// EPTCTL10_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 10)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL10_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL10_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL10_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL10_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL10_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL10_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL10_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL10_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL10_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL10_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL10_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL10_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL10_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL10_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL10_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL10_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL10_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL10_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL10_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL10_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL10_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL10_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL10_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL10_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL10_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL10_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL10_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL10_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL10_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL10_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL10_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL10_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL10_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL10_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL10_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL10_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL10_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL10_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL10_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL10_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL10_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL10_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA10: UDPHS Endpoint Set Status Register (endpoint = 10)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA10_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA10_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA10_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA10_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA10_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA10_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA10_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA10_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA10_TXRDY = 0x800

	// EPTSETSTA10_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 10)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA10_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA10_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA10_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA10_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA10_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA10_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA10: UDPHS Endpoint Clear Status Register (endpoint = 10)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA10_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA10_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA10_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA10_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA10_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA10_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA10_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA10_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA10_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA10_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA10_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA10_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA10_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA10_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA10_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA10_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA10_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA10_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA10_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA10_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA10_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA10_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA10_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA10_NAK_OUT = 0x8000

	// EPTCLRSTA10_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 10)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA10_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA10_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA10_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA10_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA10_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA10_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA10_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA10_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA10_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA10_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA10_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA10_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA10_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA10_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA10_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA10_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA10_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA10_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA10: UDPHS Endpoint Status Register (endpoint = 10)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA10_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA10_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA10_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA10_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA10_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA10_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA10_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA10_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA10_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA10_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA10_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA10_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA10_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA10_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA10_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA10_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA10_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA10_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA10_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA10_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA10_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA10_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA10_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA10_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA10_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA10_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA10_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA10_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA10_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA10_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA10_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA10_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA10_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA10_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA10_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA10_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA10_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA10_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA10_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA10_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA10_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA10_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA10_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA10_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA10_SHRT_PCKT = 0x80000000

	// EPTSTA10_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 10)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA10_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA10_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA10_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA10_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA10_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA10_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA10_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA10_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA10_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA10_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA10_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA10_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA10_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA10_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA10_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA10_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA10_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA10_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA10_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA10_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA10_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA10_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA10_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA10_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA10_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA10_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA10_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA10_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA10_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA10_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA10_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA10_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA10_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA10_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA10_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA10_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA10_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA10_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA10_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA10_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA10_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA10_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG11: UDPHS Endpoint Configuration Register (endpoint = 11)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG11_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG11_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG11_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG11_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG11_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG11_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG11_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG11_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG11_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG11_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG11_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG11_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG11_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG11_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG11_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG11_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG11_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG11_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG11_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG11_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG11_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG11_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG11_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG11_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG11_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG11_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG11_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG11_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG11_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG11_EPT_MAPD = 0x80000000

	// EPTCTLENB11: UDPHS Endpoint Control Enable Register (endpoint = 11)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB11_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB11_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB11_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB11_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB11_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB11_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB11_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB11_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB11_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB11_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB11_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB11_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB11_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB11_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB11_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB11_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB11_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB11_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB11_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB11_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB11_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB11_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB11_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB11_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB11_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB11_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB11_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB11_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB11_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB11_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB11_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB11_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB11_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB11_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB11_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB11_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB11_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB11_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB11_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB11_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB11_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB11_SHRT_PCKT = 0x80000000

	// EPTCTLENB11_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 11)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB11_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB11_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB11_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB11_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB11_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB11_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB11_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB11_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB11_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB11_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB11_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB11_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB11_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB11_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB11_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB11_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB11_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB11_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB11_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB11_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB11_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB11_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB11_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB11_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB11_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB11_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB11_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB11_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB11_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB11_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB11_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS11: UDPHS Endpoint Control Disable Register (endpoint = 11)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS11_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS11_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS11_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS11_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS11_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS11_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS11_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS11_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS11_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS11_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS11_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS11_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS11_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS11_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS11_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS11_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS11_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS11_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS11_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS11_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS11_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS11_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS11_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS11_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS11_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS11_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS11_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS11_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS11_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS11_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS11_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS11_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS11_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS11_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS11_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS11_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS11_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS11_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS11_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS11_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS11_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS11_SHRT_PCKT = 0x80000000

	// EPTCTLDIS11_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 11)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS11_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS11_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS11_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS11_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS11_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS11_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS11_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS11_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS11_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS11_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS11_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS11_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS11_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS11_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS11_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS11_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS11_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS11_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS11_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS11_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS11_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS11_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS11_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS11_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS11_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS11_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS11_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS11_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS11_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS11_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS11_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL11: UDPHS Endpoint Control Register (endpoint = 11)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL11_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL11_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL11_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL11_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL11_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL11_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL11_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL11_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL11_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL11_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL11_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL11_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL11_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL11_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL11_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL11_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL11_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL11_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL11_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL11_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL11_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL11_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL11_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL11_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL11_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL11_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL11_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL11_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL11_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL11_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL11_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL11_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL11_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL11_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL11_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL11_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL11_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL11_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL11_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL11_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL11_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL11_SHRT_PCKT = 0x80000000

	// EPTCTL11_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 11)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL11_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL11_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL11_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL11_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL11_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL11_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL11_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL11_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL11_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL11_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL11_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL11_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL11_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL11_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL11_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL11_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL11_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL11_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL11_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL11_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL11_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL11_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL11_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL11_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL11_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL11_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL11_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL11_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL11_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL11_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL11_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL11_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL11_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL11_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL11_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL11_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL11_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL11_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL11_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL11_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL11_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL11_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA11: UDPHS Endpoint Set Status Register (endpoint = 11)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA11_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA11_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA11_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA11_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA11_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA11_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA11_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA11_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA11_TXRDY = 0x800

	// EPTSETSTA11_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 11)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA11_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA11_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA11_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA11_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA11_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA11_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA11: UDPHS Endpoint Clear Status Register (endpoint = 11)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA11_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA11_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA11_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA11_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA11_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA11_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA11_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA11_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA11_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA11_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA11_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA11_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA11_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA11_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA11_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA11_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA11_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA11_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA11_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA11_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA11_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA11_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA11_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA11_NAK_OUT = 0x8000

	// EPTCLRSTA11_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 11)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA11_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA11_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA11_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA11_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA11_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA11_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA11_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA11_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA11_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA11_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA11_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA11_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA11_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA11_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA11_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA11_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA11_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA11_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA11: UDPHS Endpoint Status Register (endpoint = 11)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA11_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA11_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA11_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA11_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA11_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA11_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA11_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA11_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA11_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA11_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA11_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA11_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA11_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA11_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA11_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA11_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA11_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA11_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA11_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA11_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA11_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA11_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA11_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA11_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA11_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA11_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA11_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA11_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA11_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA11_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA11_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA11_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA11_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA11_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA11_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA11_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA11_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA11_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA11_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA11_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA11_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA11_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA11_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA11_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA11_SHRT_PCKT = 0x80000000

	// EPTSTA11_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 11)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA11_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA11_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA11_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA11_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA11_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA11_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA11_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA11_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA11_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA11_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA11_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA11_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA11_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA11_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA11_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA11_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA11_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA11_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA11_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA11_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA11_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA11_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA11_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA11_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA11_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA11_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA11_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA11_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA11_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA11_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA11_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA11_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA11_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA11_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA11_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA11_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA11_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA11_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA11_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA11_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA11_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA11_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG12: UDPHS Endpoint Configuration Register (endpoint = 12)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG12_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG12_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG12_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG12_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG12_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG12_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG12_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG12_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG12_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG12_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG12_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG12_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG12_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG12_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG12_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG12_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG12_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG12_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG12_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG12_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG12_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG12_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG12_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG12_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG12_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG12_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG12_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG12_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG12_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG12_EPT_MAPD = 0x80000000

	// EPTCTLENB12: UDPHS Endpoint Control Enable Register (endpoint = 12)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB12_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB12_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB12_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB12_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB12_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB12_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB12_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB12_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB12_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB12_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB12_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB12_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB12_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB12_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB12_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB12_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB12_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB12_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB12_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB12_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB12_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB12_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB12_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB12_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB12_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB12_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB12_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB12_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB12_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB12_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB12_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB12_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB12_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB12_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB12_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB12_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB12_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB12_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB12_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB12_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB12_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB12_SHRT_PCKT = 0x80000000

	// EPTCTLENB12_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 12)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB12_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB12_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB12_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB12_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB12_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB12_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB12_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB12_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB12_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB12_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB12_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB12_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB12_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB12_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB12_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB12_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB12_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB12_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB12_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB12_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB12_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB12_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB12_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB12_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB12_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB12_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB12_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB12_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB12_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB12_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB12_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS12: UDPHS Endpoint Control Disable Register (endpoint = 12)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS12_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS12_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS12_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS12_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS12_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS12_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS12_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS12_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS12_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS12_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS12_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS12_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS12_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS12_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS12_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS12_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS12_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS12_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS12_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS12_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS12_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS12_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS12_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS12_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS12_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS12_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS12_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS12_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS12_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS12_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS12_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS12_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS12_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS12_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS12_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS12_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS12_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS12_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS12_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS12_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS12_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS12_SHRT_PCKT = 0x80000000

	// EPTCTLDIS12_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 12)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS12_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS12_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS12_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS12_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS12_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS12_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS12_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS12_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS12_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS12_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS12_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS12_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS12_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS12_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS12_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS12_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS12_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS12_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS12_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS12_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS12_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS12_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS12_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS12_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS12_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS12_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS12_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS12_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS12_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS12_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS12_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL12: UDPHS Endpoint Control Register (endpoint = 12)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL12_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL12_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL12_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL12_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL12_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL12_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL12_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL12_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL12_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL12_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL12_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL12_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL12_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL12_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL12_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL12_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL12_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL12_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL12_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL12_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL12_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL12_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL12_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL12_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL12_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL12_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL12_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL12_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL12_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL12_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL12_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL12_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL12_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL12_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL12_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL12_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL12_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL12_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL12_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL12_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL12_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL12_SHRT_PCKT = 0x80000000

	// EPTCTL12_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 12)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL12_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL12_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL12_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL12_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL12_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL12_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL12_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL12_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL12_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL12_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL12_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL12_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL12_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL12_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL12_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL12_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL12_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL12_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL12_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL12_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL12_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL12_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL12_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL12_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL12_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL12_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL12_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL12_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL12_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL12_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL12_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL12_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL12_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL12_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL12_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL12_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL12_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL12_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL12_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL12_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL12_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL12_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA12: UDPHS Endpoint Set Status Register (endpoint = 12)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA12_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA12_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA12_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA12_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA12_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA12_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA12_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA12_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA12_TXRDY = 0x800

	// EPTSETSTA12_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 12)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA12_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA12_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA12_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA12_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA12_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA12_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA12: UDPHS Endpoint Clear Status Register (endpoint = 12)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA12_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA12_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA12_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA12_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA12_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA12_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA12_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA12_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA12_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA12_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA12_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA12_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA12_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA12_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA12_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA12_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA12_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA12_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA12_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA12_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA12_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA12_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA12_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA12_NAK_OUT = 0x8000

	// EPTCLRSTA12_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 12)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA12_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA12_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA12_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA12_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA12_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA12_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA12_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA12_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA12_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA12_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA12_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA12_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA12_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA12_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA12_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA12_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA12_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA12_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA12: UDPHS Endpoint Status Register (endpoint = 12)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA12_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA12_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA12_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA12_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA12_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA12_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA12_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA12_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA12_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA12_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA12_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA12_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA12_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA12_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA12_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA12_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA12_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA12_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA12_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA12_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA12_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA12_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA12_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA12_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA12_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA12_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA12_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA12_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA12_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA12_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA12_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA12_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA12_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA12_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA12_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA12_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA12_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA12_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA12_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA12_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA12_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA12_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA12_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA12_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA12_SHRT_PCKT = 0x80000000

	// EPTSTA12_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 12)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA12_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA12_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA12_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA12_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA12_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA12_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA12_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA12_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA12_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA12_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA12_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA12_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA12_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA12_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA12_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA12_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA12_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA12_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA12_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA12_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA12_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA12_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA12_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA12_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA12_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA12_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA12_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA12_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA12_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA12_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA12_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA12_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA12_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA12_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA12_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA12_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA12_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA12_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA12_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA12_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA12_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA12_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG13: UDPHS Endpoint Configuration Register (endpoint = 13)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG13_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG13_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG13_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG13_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG13_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG13_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG13_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG13_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG13_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG13_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG13_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG13_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG13_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG13_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG13_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG13_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG13_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG13_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG13_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG13_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG13_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG13_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG13_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG13_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG13_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG13_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG13_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG13_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG13_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG13_EPT_MAPD = 0x80000000

	// EPTCTLENB13: UDPHS Endpoint Control Enable Register (endpoint = 13)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB13_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB13_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB13_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB13_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB13_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB13_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB13_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB13_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB13_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB13_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB13_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB13_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB13_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB13_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB13_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB13_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB13_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB13_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB13_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB13_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB13_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB13_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB13_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB13_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB13_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB13_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB13_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB13_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB13_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB13_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB13_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB13_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB13_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB13_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB13_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB13_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB13_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB13_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB13_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB13_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB13_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB13_SHRT_PCKT = 0x80000000

	// EPTCTLENB13_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 13)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB13_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB13_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB13_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB13_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB13_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB13_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB13_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB13_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB13_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB13_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB13_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB13_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB13_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB13_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB13_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB13_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB13_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB13_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB13_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB13_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB13_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB13_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB13_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB13_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB13_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB13_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB13_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB13_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB13_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB13_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB13_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS13: UDPHS Endpoint Control Disable Register (endpoint = 13)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS13_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS13_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS13_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS13_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS13_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS13_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS13_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS13_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS13_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS13_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS13_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS13_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS13_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS13_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS13_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS13_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS13_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS13_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS13_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS13_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS13_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS13_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS13_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS13_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS13_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS13_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS13_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS13_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS13_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS13_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS13_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS13_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS13_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS13_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS13_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS13_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS13_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS13_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS13_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS13_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS13_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS13_SHRT_PCKT = 0x80000000

	// EPTCTLDIS13_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 13)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS13_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS13_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS13_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS13_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS13_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS13_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS13_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS13_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS13_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS13_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS13_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS13_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS13_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS13_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS13_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS13_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS13_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS13_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS13_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS13_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS13_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS13_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS13_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS13_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS13_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS13_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS13_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS13_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS13_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS13_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS13_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL13: UDPHS Endpoint Control Register (endpoint = 13)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL13_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL13_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL13_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL13_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL13_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL13_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL13_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL13_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL13_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL13_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL13_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL13_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL13_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL13_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL13_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL13_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL13_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL13_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL13_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL13_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL13_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL13_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL13_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL13_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL13_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL13_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL13_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL13_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL13_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL13_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL13_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL13_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL13_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL13_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL13_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL13_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL13_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL13_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL13_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL13_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL13_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL13_SHRT_PCKT = 0x80000000

	// EPTCTL13_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 13)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL13_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL13_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL13_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL13_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL13_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL13_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL13_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL13_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL13_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL13_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL13_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL13_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL13_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL13_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL13_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL13_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL13_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL13_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL13_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL13_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL13_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL13_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL13_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL13_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL13_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL13_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL13_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL13_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL13_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL13_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL13_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL13_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL13_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL13_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL13_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL13_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL13_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL13_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL13_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL13_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL13_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL13_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA13: UDPHS Endpoint Set Status Register (endpoint = 13)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA13_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA13_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA13_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA13_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA13_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA13_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA13_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA13_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA13_TXRDY = 0x800

	// EPTSETSTA13_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 13)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA13_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA13_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA13_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA13_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA13_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA13_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA13: UDPHS Endpoint Clear Status Register (endpoint = 13)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA13_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA13_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA13_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA13_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA13_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA13_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA13_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA13_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA13_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA13_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA13_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA13_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA13_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA13_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA13_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA13_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA13_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA13_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA13_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA13_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA13_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA13_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA13_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA13_NAK_OUT = 0x8000

	// EPTCLRSTA13_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 13)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA13_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA13_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA13_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA13_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA13_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA13_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA13_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA13_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA13_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA13_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA13_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA13_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA13_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA13_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA13_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA13_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA13_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA13_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA13: UDPHS Endpoint Status Register (endpoint = 13)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA13_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA13_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA13_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA13_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA13_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA13_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA13_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA13_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA13_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA13_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA13_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA13_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA13_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA13_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA13_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA13_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA13_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA13_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA13_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA13_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA13_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA13_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA13_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA13_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA13_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA13_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA13_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA13_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA13_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA13_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA13_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA13_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA13_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA13_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA13_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA13_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA13_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA13_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA13_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA13_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA13_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA13_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA13_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA13_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA13_SHRT_PCKT = 0x80000000

	// EPTSTA13_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 13)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA13_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA13_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA13_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA13_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA13_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA13_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA13_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA13_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA13_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA13_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA13_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA13_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA13_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA13_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA13_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA13_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA13_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA13_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA13_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA13_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA13_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA13_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA13_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA13_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA13_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA13_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA13_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA13_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA13_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA13_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA13_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA13_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA13_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA13_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA13_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA13_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA13_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA13_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA13_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA13_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA13_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA13_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG14: UDPHS Endpoint Configuration Register (endpoint = 14)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG14_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG14_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG14_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG14_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG14_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG14_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG14_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG14_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG14_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG14_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG14_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG14_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG14_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG14_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG14_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG14_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG14_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG14_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG14_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG14_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG14_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG14_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG14_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG14_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG14_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG14_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG14_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG14_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG14_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG14_EPT_MAPD = 0x80000000

	// EPTCTLENB14: UDPHS Endpoint Control Enable Register (endpoint = 14)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB14_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB14_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB14_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB14_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB14_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB14_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB14_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB14_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB14_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB14_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB14_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB14_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB14_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB14_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB14_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB14_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB14_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB14_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB14_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB14_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB14_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB14_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB14_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB14_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB14_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB14_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB14_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB14_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB14_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB14_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB14_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB14_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB14_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB14_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB14_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB14_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB14_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB14_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB14_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB14_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB14_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB14_SHRT_PCKT = 0x80000000

	// EPTCTLENB14_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 14)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB14_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB14_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB14_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB14_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB14_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB14_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB14_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB14_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB14_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB14_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB14_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB14_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB14_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB14_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB14_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB14_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB14_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB14_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB14_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB14_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB14_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB14_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB14_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB14_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB14_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB14_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB14_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB14_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB14_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB14_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB14_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS14: UDPHS Endpoint Control Disable Register (endpoint = 14)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS14_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS14_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS14_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS14_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS14_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS14_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS14_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS14_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS14_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS14_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS14_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS14_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS14_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS14_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS14_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS14_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS14_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS14_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS14_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS14_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS14_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS14_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS14_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS14_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS14_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS14_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS14_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS14_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS14_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS14_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS14_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS14_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS14_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS14_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS14_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS14_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS14_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS14_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS14_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS14_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS14_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS14_SHRT_PCKT = 0x80000000

	// EPTCTLDIS14_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 14)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS14_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS14_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS14_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS14_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS14_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS14_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS14_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS14_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS14_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS14_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS14_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS14_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS14_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS14_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS14_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS14_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS14_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS14_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS14_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS14_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS14_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS14_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS14_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS14_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS14_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS14_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS14_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS14_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS14_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS14_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS14_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL14: UDPHS Endpoint Control Register (endpoint = 14)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL14_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL14_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL14_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL14_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL14_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL14_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL14_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL14_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL14_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL14_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL14_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL14_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL14_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL14_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL14_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL14_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL14_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL14_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL14_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL14_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL14_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL14_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL14_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL14_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL14_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL14_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL14_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL14_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL14_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL14_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL14_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL14_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL14_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL14_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL14_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL14_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL14_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL14_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL14_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL14_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL14_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL14_SHRT_PCKT = 0x80000000

	// EPTCTL14_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 14)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL14_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL14_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL14_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL14_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL14_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL14_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL14_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL14_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL14_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL14_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL14_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL14_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL14_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL14_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL14_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL14_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL14_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL14_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL14_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL14_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL14_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL14_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL14_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL14_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL14_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL14_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL14_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL14_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL14_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL14_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL14_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL14_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL14_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL14_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL14_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL14_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL14_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL14_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL14_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL14_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL14_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL14_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA14: UDPHS Endpoint Set Status Register (endpoint = 14)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA14_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA14_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA14_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA14_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA14_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA14_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA14_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA14_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA14_TXRDY = 0x800

	// EPTSETSTA14_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 14)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA14_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA14_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA14_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA14_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA14_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA14_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA14: UDPHS Endpoint Clear Status Register (endpoint = 14)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA14_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA14_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA14_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA14_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA14_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA14_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA14_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA14_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA14_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA14_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA14_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA14_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA14_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA14_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA14_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA14_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA14_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA14_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA14_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA14_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA14_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA14_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA14_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA14_NAK_OUT = 0x8000

	// EPTCLRSTA14_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 14)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA14_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA14_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA14_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA14_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA14_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA14_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA14_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA14_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA14_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA14_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA14_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA14_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA14_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA14_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA14_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA14_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA14_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA14_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA14: UDPHS Endpoint Status Register (endpoint = 14)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA14_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA14_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA14_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA14_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA14_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA14_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA14_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA14_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA14_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA14_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA14_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA14_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA14_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA14_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA14_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA14_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA14_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA14_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA14_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA14_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA14_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA14_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA14_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA14_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA14_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA14_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA14_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA14_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA14_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA14_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA14_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA14_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA14_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA14_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA14_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA14_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA14_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA14_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA14_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA14_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA14_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA14_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA14_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA14_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA14_SHRT_PCKT = 0x80000000

	// EPTSTA14_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 14)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA14_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA14_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA14_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA14_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA14_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA14_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA14_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA14_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA14_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA14_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA14_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA14_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA14_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA14_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA14_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA14_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA14_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA14_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA14_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA14_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA14_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA14_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA14_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA14_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA14_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA14_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA14_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA14_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA14_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA14_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA14_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA14_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA14_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA14_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA14_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA14_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA14_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA14_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA14_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA14_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA14_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA14_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG15: UDPHS Endpoint Configuration Register (endpoint = 15)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG15_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG15_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG15_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG15_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG15_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG15_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG15_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG15_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG15_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG15_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG15_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG15_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG15_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG15_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG15_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG15_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG15_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG15_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG15_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG15_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG15_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG15_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG15_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG15_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG15_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG15_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG15_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG15_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG15_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG15_EPT_MAPD = 0x80000000

	// EPTCTLENB15: UDPHS Endpoint Control Enable Register (endpoint = 15)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB15_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB15_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB15_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB15_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB15_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB15_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB15_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB15_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB15_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB15_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB15_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB15_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB15_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB15_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB15_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB15_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB15_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB15_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB15_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB15_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB15_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB15_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB15_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB15_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB15_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB15_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB15_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB15_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB15_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB15_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB15_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB15_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB15_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB15_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB15_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB15_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB15_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB15_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB15_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB15_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB15_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB15_SHRT_PCKT = 0x80000000

	// EPTCTLENB15_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 15)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB15_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB15_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB15_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB15_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB15_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB15_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB15_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB15_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB15_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB15_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB15_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB15_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB15_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB15_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB15_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB15_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB15_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB15_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB15_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB15_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB15_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB15_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB15_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB15_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB15_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB15_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB15_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB15_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB15_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB15_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB15_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS15: UDPHS Endpoint Control Disable Register (endpoint = 15)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS15_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS15_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS15_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS15_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS15_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS15_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS15_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS15_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS15_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS15_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS15_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS15_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS15_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS15_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS15_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS15_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS15_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS15_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS15_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS15_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS15_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS15_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS15_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS15_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS15_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS15_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS15_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS15_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS15_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS15_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS15_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS15_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS15_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS15_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS15_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS15_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS15_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS15_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS15_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS15_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS15_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS15_SHRT_PCKT = 0x80000000

	// EPTCTLDIS15_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 15)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS15_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS15_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS15_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS15_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS15_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS15_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS15_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS15_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS15_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS15_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS15_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS15_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS15_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS15_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS15_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS15_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS15_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS15_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS15_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS15_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS15_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS15_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS15_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS15_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS15_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS15_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS15_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS15_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS15_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS15_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS15_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL15: UDPHS Endpoint Control Register (endpoint = 15)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL15_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL15_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL15_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL15_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL15_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL15_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL15_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL15_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL15_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL15_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL15_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL15_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL15_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL15_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL15_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL15_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL15_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL15_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL15_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL15_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL15_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL15_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL15_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL15_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL15_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL15_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL15_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL15_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL15_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL15_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL15_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL15_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL15_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL15_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL15_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL15_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL15_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL15_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL15_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL15_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL15_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL15_SHRT_PCKT = 0x80000000

	// EPTCTL15_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 15)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL15_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL15_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL15_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL15_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL15_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL15_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL15_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL15_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL15_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL15_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL15_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL15_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL15_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL15_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL15_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL15_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL15_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL15_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL15_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL15_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL15_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL15_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL15_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL15_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL15_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL15_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL15_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL15_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL15_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL15_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL15_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL15_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL15_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL15_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL15_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL15_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL15_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL15_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL15_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL15_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL15_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL15_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA15: UDPHS Endpoint Set Status Register (endpoint = 15)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA15_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA15_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA15_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA15_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA15_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA15_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA15_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA15_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA15_TXRDY = 0x800

	// EPTSETSTA15_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 15)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA15_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA15_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA15_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA15_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA15_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA15_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA15: UDPHS Endpoint Clear Status Register (endpoint = 15)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA15_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA15_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA15_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA15_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA15_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA15_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA15_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA15_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA15_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA15_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA15_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA15_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA15_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA15_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA15_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA15_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA15_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA15_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA15_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA15_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA15_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA15_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA15_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA15_NAK_OUT = 0x8000

	// EPTCLRSTA15_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 15)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA15_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA15_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA15_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA15_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA15_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA15_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA15_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA15_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA15_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA15_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA15_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA15_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA15_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA15_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA15_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA15_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA15_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA15_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA15: UDPHS Endpoint Status Register (endpoint = 15)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA15_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA15_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA15_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA15_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA15_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA15_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA15_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA15_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA15_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA15_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA15_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA15_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA15_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA15_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA15_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA15_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA15_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA15_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA15_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA15_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA15_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA15_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA15_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA15_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA15_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA15_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA15_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA15_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA15_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA15_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA15_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA15_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA15_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA15_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA15_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA15_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA15_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA15_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA15_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA15_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA15_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA15_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA15_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA15_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA15_SHRT_PCKT = 0x80000000

	// EPTSTA15_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 15)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA15_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA15_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA15_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA15_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA15_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA15_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA15_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA15_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA15_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA15_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA15_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA15_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA15_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA15_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA15_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA15_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA15_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA15_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA15_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA15_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA15_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA15_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA15_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA15_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA15_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA15_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA15_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA15_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA15_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA15_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA15_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA15_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA15_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA15_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA15_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA15_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA15_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA15_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA15_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA15_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA15_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA15_ISOENDPT_SHRT_PCKT = 0x80000000

	// DMANXTDSC0: UDPHS DMA Next Descriptor Address Register (channel = 0)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC0_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC0_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS0: UDPHS DMA Channel Address Register (channel = 0)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS0_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS0_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL0: UDPHS DMA Channel Control Register (channel = 0)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL0_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL0_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL0_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL0_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL0_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL0_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL0_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL0_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL0_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL0_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL0_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL0_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL0_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL0_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL0_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL0_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL0_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL0_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL0_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL0_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL0_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL0_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL0_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL0_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL0_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL0_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS0: UDPHS DMA Channel Status Register (channel = 0)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS0_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS0_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS0_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS0_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS0_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS0_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS0_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS0_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS0_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS0_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS0_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS0_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS0_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS0_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS0_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS0_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS0_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC1: UDPHS DMA Next Descriptor Address Register (channel = 1)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC1_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC1_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS1: UDPHS DMA Channel Address Register (channel = 1)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS1_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS1_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL1: UDPHS DMA Channel Control Register (channel = 1)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL1_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL1_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL1_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL1_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL1_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL1_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL1_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL1_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL1_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL1_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL1_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL1_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL1_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL1_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL1_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL1_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL1_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL1_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL1_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL1_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL1_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL1_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL1_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL1_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL1_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL1_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS1: UDPHS DMA Channel Status Register (channel = 1)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS1_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS1_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS1_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS1_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS1_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS1_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS1_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS1_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS1_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS1_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS1_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS1_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS1_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS1_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS1_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS1_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS1_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC2: UDPHS DMA Next Descriptor Address Register (channel = 2)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC2_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC2_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS2: UDPHS DMA Channel Address Register (channel = 2)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS2_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS2_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL2: UDPHS DMA Channel Control Register (channel = 2)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL2_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL2_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL2_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL2_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL2_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL2_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL2_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL2_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL2_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL2_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL2_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL2_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL2_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL2_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL2_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL2_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL2_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL2_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL2_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL2_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL2_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL2_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL2_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL2_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL2_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL2_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS2: UDPHS DMA Channel Status Register (channel = 2)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS2_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS2_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS2_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS2_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS2_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS2_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS2_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS2_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS2_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS2_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS2_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS2_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS2_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS2_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS2_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS2_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS2_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC3: UDPHS DMA Next Descriptor Address Register (channel = 3)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC3_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC3_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS3: UDPHS DMA Channel Address Register (channel = 3)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS3_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS3_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL3: UDPHS DMA Channel Control Register (channel = 3)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL3_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL3_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL3_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL3_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL3_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL3_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL3_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL3_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL3_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL3_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL3_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL3_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL3_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL3_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL3_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL3_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL3_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL3_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL3_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL3_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL3_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL3_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL3_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL3_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL3_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL3_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS3: UDPHS DMA Channel Status Register (channel = 3)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS3_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS3_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS3_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS3_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS3_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS3_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS3_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS3_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS3_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS3_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS3_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS3_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS3_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS3_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS3_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS3_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS3_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC4: UDPHS DMA Next Descriptor Address Register (channel = 4)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC4_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC4_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS4: UDPHS DMA Channel Address Register (channel = 4)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS4_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS4_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL4: UDPHS DMA Channel Control Register (channel = 4)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL4_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL4_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL4_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL4_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL4_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL4_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL4_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL4_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL4_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL4_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL4_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL4_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL4_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL4_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL4_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL4_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL4_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL4_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL4_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL4_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL4_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL4_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL4_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL4_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL4_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL4_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS4: UDPHS DMA Channel Status Register (channel = 4)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS4_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS4_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS4_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS4_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS4_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS4_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS4_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS4_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS4_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS4_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS4_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS4_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS4_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS4_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS4_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS4_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS4_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC5: UDPHS DMA Next Descriptor Address Register (channel = 5)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC5_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC5_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS5: UDPHS DMA Channel Address Register (channel = 5)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS5_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS5_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL5: UDPHS DMA Channel Control Register (channel = 5)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL5_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL5_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL5_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL5_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL5_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL5_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL5_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL5_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL5_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL5_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL5_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL5_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL5_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL5_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL5_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL5_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL5_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL5_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL5_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL5_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL5_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL5_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL5_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL5_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL5_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL5_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS5: UDPHS DMA Channel Status Register (channel = 5)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS5_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS5_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS5_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS5_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS5_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS5_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS5_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS5_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS5_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS5_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS5_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS5_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS5_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS5_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS5_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS5_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS5_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC6: UDPHS DMA Next Descriptor Address Register (channel = 6)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC6_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC6_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS6: UDPHS DMA Channel Address Register (channel = 6)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS6_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS6_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL6: UDPHS DMA Channel Control Register (channel = 6)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL6_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL6_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL6_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL6_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL6_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL6_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL6_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL6_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL6_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL6_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL6_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL6_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL6_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL6_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL6_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL6_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL6_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL6_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL6_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL6_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL6_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL6_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL6_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL6_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL6_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL6_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS6: UDPHS DMA Channel Status Register (channel = 6)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS6_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS6_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS6_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS6_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS6_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS6_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS6_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS6_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS6_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS6_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS6_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS6_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS6_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS6_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS6_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS6_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS6_BUFF_COUNT_Msk = 0xffff0000
)

// Bitfields for TRNG: True Random Number Generator
const (
	// CR: Control Register
	// Position of ENABLE field.
	TRNG_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TRNG_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	TRNG_CR_ENABLE = 0x1
	// Position of KEY field.
	TRNG_CR_KEY_Pos = 0x8
	// Bit mask of KEY field.
	TRNG_CR_KEY_Msk = 0xffffff00

	// IER: Interrupt Enable Register
	// Position of DATRDY field.
	TRNG_IER_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_IER_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_IER_DATRDY = 0x1

	// IDR: Interrupt Disable Register
	// Position of DATRDY field.
	TRNG_IDR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_IDR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_IDR_DATRDY = 0x1

	// IMR: Interrupt Mask Register
	// Position of DATRDY field.
	TRNG_IMR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_IMR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_IMR_DATRDY = 0x1

	// ISR: Interrupt Status Register
	// Position of DATRDY field.
	TRNG_ISR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_ISR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_ISR_DATRDY = 0x1

	// ODATA: Output Data Register
	// Position of ODATA field.
	TRNG_ODATA_ODATA_Pos = 0x0
	// Bit mask of ODATA field.
	TRNG_ODATA_ODATA_Msk = 0xffffffff
)

// Bitfields for FUSE: Fuse Controller
const (
	// CR: Fuse Control Register
	// Position of WRQ field.
	FUSE_CR_WRQ_Pos = 0x0
	// Bit mask of WRQ field.
	FUSE_CR_WRQ_Msk = 0x1
	// Bit WRQ.
	FUSE_CR_WRQ = 0x1
	// Position of RRQ field.
	FUSE_CR_RRQ_Pos = 0x1
	// Bit mask of RRQ field.
	FUSE_CR_RRQ_Msk = 0x2
	// Bit RRQ.
	FUSE_CR_RRQ = 0x2
	// Position of KEY field.
	FUSE_CR_KEY_Pos = 0x8
	// Bit mask of KEY field.
	FUSE_CR_KEY_Msk = 0xff00
	// valid key.
	FUSE_CR_KEY_VALID = 0xfb

	// MR: Fuse Mode Register
	// Position of MSK field.
	FUSE_MR_MSK_Pos = 0x0
	// Bit mask of MSK field.
	FUSE_MR_MSK_Msk = 0x1
	// Bit MSK.
	FUSE_MR_MSK = 0x1

	// IR: Fuse Index Register
	// Position of WS field.
	FUSE_IR_WS_Pos = 0x0
	// Bit mask of WS field.
	FUSE_IR_WS_Msk = 0x1
	// Bit WS.
	FUSE_IR_WS = 0x1
	// Position of RS field.
	FUSE_IR_RS_Pos = 0x1
	// Bit mask of RS field.
	FUSE_IR_RS_Msk = 0x2
	// Bit RS.
	FUSE_IR_RS = 0x2
	// Position of WSEL field.
	FUSE_IR_WSEL_Pos = 0x8
	// Bit mask of WSEL field.
	FUSE_IR_WSEL_Msk = 0xf00

	// DR: Fuse Data Register
	// Position of DATA field.
	FUSE_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FUSE_DR_DATA_Msk = 0xffffffff

	// SR: Fuse Status Register
	// Position of FUSE field.
	FUSE_SR_FUSE_Pos = 0x0
	// Bit mask of FUSE field.
	FUSE_SR_FUSE_Msk = 0xffffffff
)

// Bitfields for DMAC0: