// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32l4x5.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32l4x5
// +build stm32,stm32l4x5

// STM32L4x5
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32L4x5"
	CPU          = "CM4"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD = 1

	// Real-time clock
	IRQ_TAMP_STAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// Direct memory access controller
	IRQ_DMA1_CH1 = 11

	// Direct memory access controller
	IRQ_DMA1_CH2 = 12

	// Direct memory access controller
	IRQ_DMA1_CH3 = 13

	// Direct memory access controller
	IRQ_DMA1_CH4 = 14

	// Direct memory access controller
	IRQ_DMA1_CH5 = 15

	// Direct memory access controller
	IRQ_DMA1_CH6 = 16

	// Direct memory access controller
	IRQ_DMA1_CH7 = 17

	IRQ_ADC1_2 = 18

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// General purpose timers
	IRQ_TIM15 = 24

	// General purpose timers
	IRQ_TIM16 = 25

	IRQ_TIM1_TRG_COM_TIM17 = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// General-purpose-timers
	IRQ_TIM2 = 28

	// General-purpose-timers
	IRQ_TIM3 = 29

	// General-purpose-timers
	IRQ_TIM4 = 30

	// Inter-integrated circuit
	IRQ_I2C1_EV = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTC_ALARM = 41

	// Digital filter for sigma delta modulators
	IRQ_DFSDM3 = 42

	// Advanced-timers
	IRQ_TIM8_BRK = 43

	// Advanced-timers
	IRQ_TIM8 = 44

	// Advanced-timers
	IRQ_TIM8_TRG_COM = 45

	// Advanced-timers
	IRQ_TIM8_CC = 46

	IRQ_ADC3 = 47

	// Flexible memory controller
	IRQ_FMC = 48

	// Secure digital input/output interface
	IRQ_SDMMC = 49

	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Basic-timers
	IRQ_TIM6_DAC = 54

	IRQ_TIM7 = 55

	IRQ_DMA2_CH1 = 56

	IRQ_DMA2_CH2 = 57

	IRQ_DMA2_CH3 = 58

	IRQ_DMA2_CH4 = 59

	IRQ_DMA2_CH5 = 60

	// Digital filter for sigma delta modulators
	IRQ_DFSDM0 = 61

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1 = 62

	// Digital filter for sigma delta modulators
	IRQ_DFSDM2 = 63

	// Comparator
	IRQ_COMP = 64

	// Low power timer
	IRQ_LPTIM1 = 65

	IRQ_LPTIM2 = 66

	IRQ_DMA2_CH6 = 68

	IRQ_DMA2_CH7 = 69

	// QuadSPI interface
	IRQ_QUADSPI = 71

	IRQ_I2C3_EV = 72

	IRQ_I2C3_ER = 73

	// Serial audio interface
	IRQ_SAI1 = 74

	IRQ_SAI2 = 75

	// Single Wire Protocol Master Interface
	IRQ_SWPMI1 = 76

	// Touch sensing controller
	IRQ_TSC = 77

	// Liquid crystal display controller
	IRQ_LCD = 78

	// Advanced encryption standard hardware accelerator
	IRQ_AES = 79

	// Random number generator
	IRQ_RNG = 80

	// Floting point unit
	IRQ_FPU = 81

	// Highest interrupt number on this device.
	IRQ_max = 81
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export TAMP_STAMP_IRQHandler
func interruptTAMP_STAMP() {
	callHandlers(IRQ_TAMP_STAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_CH1_IRQHandler
func interruptDMA1_CH1() {
	callHandlers(IRQ_DMA1_CH1)
}

//export DMA1_CH2_IRQHandler
func interruptDMA1_CH2() {
	callHandlers(IRQ_DMA1_CH2)
}

//export DMA1_CH3_IRQHandler
func interruptDMA1_CH3() {
	callHandlers(IRQ_DMA1_CH3)
}

//export DMA1_CH4_IRQHandler
func interruptDMA1_CH4() {
	callHandlers(IRQ_DMA1_CH4)
}

//export DMA1_CH5_IRQHandler
func interruptDMA1_CH5() {
	callHandlers(IRQ_DMA1_CH5)
}

//export DMA1_CH6_IRQHandler
func interruptDMA1_CH6() {
	callHandlers(IRQ_DMA1_CH6)
}

//export DMA1_CH7_IRQHandler
func interruptDMA1_CH7() {
	callHandlers(IRQ_DMA1_CH7)
}

//export ADC1_2_IRQHandler
func interruptADC1_2() {
	callHandlers(IRQ_ADC1_2)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM15_IRQHandler
func interruptTIM15() {
	callHandlers(IRQ_TIM15)
}

//export TIM16_IRQHandler
func interruptTIM16() {
	callHandlers(IRQ_TIM16)
}

//export TIM1_TRG_COM_TIM17_IRQHandler
func interruptTIM1_TRG_COM_TIM17() {
	callHandlers(IRQ_TIM1_TRG_COM_TIM17)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_ALARM_IRQHandler
func interruptRTC_ALARM() {
	callHandlers(IRQ_RTC_ALARM)
}

//export DFSDM3_IRQHandler
func interruptDFSDM3() {
	callHandlers(IRQ_DFSDM3)
}

//export TIM8_BRK_IRQHandler
func interruptTIM8_BRK() {
	callHandlers(IRQ_TIM8_BRK)
}

//export TIM8_IRQHandler
func interruptTIM8() {
	callHandlers(IRQ_TIM8)
}

//export TIM8_TRG_COM_IRQHandler
func interruptTIM8_TRG_COM() {
	callHandlers(IRQ_TIM8_TRG_COM)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export ADC3_IRQHandler
func interruptADC3() {
	callHandlers(IRQ_ADC3)
}

//export FMC_IRQHandler
func interruptFMC() {
	callHandlers(IRQ_FMC)
}

//export SDMMC_IRQHandler
func interruptSDMMC() {
	callHandlers(IRQ_SDMMC)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export TIM6_DAC_IRQHandler
func interruptTIM6_DAC() {
	callHandlers(IRQ_TIM6_DAC)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_CH1_IRQHandler
func interruptDMA2_CH1() {
	callHandlers(IRQ_DMA2_CH1)
}

//export DMA2_CH2_IRQHandler
func interruptDMA2_CH2() {
	callHandlers(IRQ_DMA2_CH2)
}

//export DMA2_CH3_IRQHandler
func interruptDMA2_CH3() {
	callHandlers(IRQ_DMA2_CH3)
}

//export DMA2_CH4_IRQHandler
func interruptDMA2_CH4() {
	callHandlers(IRQ_DMA2_CH4)
}

//export DMA2_CH5_IRQHandler
func interruptDMA2_CH5() {
	callHandlers(IRQ_DMA2_CH5)
}

//export DFSDM0_IRQHandler
func interruptDFSDM0() {
	callHandlers(IRQ_DFSDM0)
}

//export DFSDM1_IRQHandler
func interruptDFSDM1() {
	callHandlers(IRQ_DFSDM1)
}

//export DFSDM2_IRQHandler
func interruptDFSDM2() {
	callHandlers(IRQ_DFSDM2)
}

//export COMP_IRQHandler
func interruptCOMP() {
	callHandlers(IRQ_COMP)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export LPTIM2_IRQHandler
func interruptLPTIM2() {
	callHandlers(IRQ_LPTIM2)
}

//export DMA2_CH6_IRQHandler
func interruptDMA2_CH6() {
	callHandlers(IRQ_DMA2_CH6)
}

//export DMA2_CH7_IRQHandler
func interruptDMA2_CH7() {
	callHandlers(IRQ_DMA2_CH7)
}

//export QUADSPI_IRQHandler
func interruptQUADSPI() {
	callHandlers(IRQ_QUADSPI)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export SAI1_IRQHandler
func interruptSAI1() {
	callHandlers(IRQ_SAI1)
}

//export SAI2_IRQHandler
func interruptSAI2() {
	callHandlers(IRQ_SAI2)
}

//export SWPMI1_IRQHandler
func interruptSWPMI1() {
	callHandlers(IRQ_SWPMI1)
}

//export TSC_IRQHandler
func interruptTSC() {
	callHandlers(IRQ_TSC)
}

//export LCD_IRQHandler
func interruptLCD() {
	callHandlers(IRQ_LCD)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

// Peripherals.
var (
	// Digital-to-analog converter
	DAC1 = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Direct memory access controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Liquid crystal display controller
	LCD = (*LCD_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Touch sensing controller
	TSC = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Comparator
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))

	// Firewall
	FIREWALL = (*Firewall_Type)(unsafe.Pointer(uintptr(0x40011c00)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))

	// Advanced encryption standard hardware accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// Analog-to-Digital Converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040000)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))

	// Serial audio interface
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015400)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Basic-timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Secure digital input/output interface
	SDMMC = (*SDIO_Type)(unsafe.Pointer(uintptr(0x40012800)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Voltage reference buffer
	VREFBUF = (*VREF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// Controller area network
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Single Wire Protocol Master Interface
	SWPMI1 = (*SWPMI_Type)(unsafe.Pointer(uintptr(0x40008800)))

	// Operational amplifiers
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Clock recovery system
	CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Universal serial bus full-speed device interface
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x40006c00)))

	// QuadSPI interface
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))

	// Flexible memory controller
	FMC = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// Digital filter for sigma delta modulators
	DFSDM = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Analog-to-Digital Converter
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040300)))

	// Debug support
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// General-purpose-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General-purpose-timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// Direct memory access controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Analog-to-Digital Converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040100)))

	// Analog-to-Digital Converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040200)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001c00)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001400)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001800)))

	// Serial audio interface
	SAI2 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// General-purpose-timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Basic-timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface/Inter-IC sound
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))
)

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
	CCR     volatile.Register32 // 0x38
	MCR     volatile.Register32 // 0x3C
	SHSR1   volatile.Register32 // 0x40
	SHSR2   volatile.Register32 // 0x44
	SHHR    volatile.Register32 // 0x48
	SHRR    volatile.Register32 // 0x4C
}

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
	_      [24]byte
	CSELR  volatile.Register32 // 0xA8
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// Liquid crystal display controller
type LCD_Type struct {
	CR       volatile.Register32 // 0x0
	FCR      volatile.Register32 // 0x4
	SR       volatile.Register32 // 0x8
	CLR      volatile.Register32 // 0xC
	_        [4]byte
	RAM_COM0 volatile.Register32 // 0x14
	_        [4]byte
	RAM_COM1 volatile.Register32 // 0x1C
	_        [4]byte
	RAM_COM2 volatile.Register32 // 0x24
	_        [4]byte
	RAM_COM3 volatile.Register32 // 0x2C
	_        [4]byte
	RAM_COM4 volatile.Register32 // 0x34
	_        [4]byte
	RAM_COM5 volatile.Register32 // 0x3C
	_        [4]byte
	RAM_COM6 volatile.Register32 // 0x44
	_        [4]byte
	RAM_COM7 volatile.Register32 // 0x4C
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
	IOG7CR volatile.Register32 // 0x4C
	IOG8CR volatile.Register32 // 0x50
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Comparator
type COMP_Type struct {
	COMP1_CSR volatile.Register32 // 0x0
	COMP2_CSR volatile.Register32 // 0x4
}

// Firewall
type Firewall_Type struct {
	CSSA   volatile.Register32 // 0x0
	CSL    volatile.Register32 // 0x4
	NVDSSA volatile.Register32 // 0x8
	NVDSL  volatile.Register32 // 0xC
	VDSSA  volatile.Register32 // 0x10
	VDSL   volatile.Register32 // 0x14
	_      [8]byte
	CR     volatile.Register32 // 0x20
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Flash
type Flash_Type struct {
	ACR      volatile.Register32 // 0x0
	PDKEYR   volatile.Register32 // 0x4
	KEYR     volatile.Register32 // 0x8
	OPTKEYR  volatile.Register32 // 0xC
	SR       volatile.Register32 // 0x10
	CR       volatile.Register32 // 0x14
	ECCR     volatile.Register32 // 0x18
	_        [4]byte
	OPTR     volatile.Register32 // 0x20
	PCROP1SR volatile.Register32 // 0x24
	PCROP1ER volatile.Register32 // 0x28
	WRP1AR   volatile.Register32 // 0x2C
	WRP1BR   volatile.Register32 // 0x30
	_        [16]byte
	PCROP2SR volatile.Register32 // 0x44
	PCROP2ER volatile.Register32 // 0x48
	WRP2AR   volatile.Register32 // 0x4C
	WRP2BR   volatile.Register32 // 0x50
}

// Power control
type PWR_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	CR4   volatile.Register32 // 0xC
	SR1   volatile.Register32 // 0x10
	SR2   volatile.Register32 // 0x14
	SCR   volatile.Register32 // 0x18
	_     [4]byte
	PUCRA volatile.Register32 // 0x20
	PDCRA volatile.Register32 // 0x24
	PUCRB volatile.Register32 // 0x28
	PDCRB volatile.Register32 // 0x2C
	PUCRC volatile.Register32 // 0x30
	PDCRC volatile.Register32 // 0x34
	PUCRD volatile.Register32 // 0x38
	PDCRD volatile.Register32 // 0x3C
	PUCRE volatile.Register32 // 0x40
	PDCRE volatile.Register32 // 0x44
	PUCRF volatile.Register32 // 0x48
	PDCRF volatile.Register32 // 0x4C
	PUCRG volatile.Register32 // 0x50
	PDCRG volatile.Register32 // 0x54
	PUCRH volatile.Register32 // 0x58
	PDCRH volatile.Register32 // 0x5C
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	CFGR1   volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	SCSR    volatile.Register32 // 0x18
	CFGR2   volatile.Register32 // 0x1C
	SWPR    volatile.Register32 // 0x20
	SKR     volatile.Register32 // 0x24
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// Advanced encryption standard hardware accelerator
type AES_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	DINR  volatile.Register32 // 0x8
	DOUTR volatile.Register32 // 0xC
	KEYR0 volatile.Register32 // 0x10
	KEYR1 volatile.Register32 // 0x14
	KEYR2 volatile.Register32 // 0x18
	KEYR3 volatile.Register32 // 0x1C
	IVR0  volatile.Register32 // 0x20
	IVR1  volatile.Register32 // 0x24
	IVR2  volatile.Register32 // 0x28
	IVR3  volatile.Register32 // 0x2C
}

// Analog-to-Digital Converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR    volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR1   volatile.Register32 // 0x14
	SMPR2   volatile.Register32 // 0x18
	_       [4]byte
	TR1     volatile.Register32 // 0x20
	TR2     volatile.Register32 // 0x24
	TR3     volatile.Register32 // 0x28
	_       [4]byte
	SQR1    volatile.Register32 // 0x30
	SQR2    volatile.Register32 // 0x34
	SQR3    volatile.Register32 // 0x38
	SQR4    volatile.Register32 // 0x3C
	DR      volatile.Register32 // 0x40
	_       [8]byte
	JSQR    volatile.Register32 // 0x4C
	_       [16]byte
	OFR1    volatile.Register32 // 0x60
	OFR2    volatile.Register32 // 0x64
	OFR3    volatile.Register32 // 0x68
	OFR4    volatile.Register32 // 0x6C
	_       [16]byte
	JDR1    volatile.Register32 // 0x80
	JDR2    volatile.Register32 // 0x84
	JDR3    volatile.Register32 // 0x88
	JDR4    volatile.Register32 // 0x8C
	_       [16]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [8]byte
	DIFSEL  volatile.Register32 // 0xB0
	CALFACT volatile.Register32 // 0xB4
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// Serial audio interface
type SAI_Type struct {
	_  [4]byte
	CH [2]struct {
		CR1   volatile.Register32
		CR2   volatile.Register32
		FRCR  volatile.Register32
		SLOTR volatile.Register32
		IM    volatile.Register32
		SR    volatile.Register32
		CLRFR volatile.Register32
		DR    volatile.Register32
	} // 0x4
}

// General-purpose-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR           volatile.Register32 // 0x50
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	SR     volatile.Register32 // 0x8
	DR     volatile.Register32 // 0xC
	CRCPR  volatile.Register32 // 0x10
	RXCRCR volatile.Register32 // 0x14
	TXCRCR volatile.Register32 // 0x18
}

// Secure digital input/output interface
type SDIO_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR1   volatile.Register32 // 0x0
	EMR1   volatile.Register32 // 0x4
	RTSR1  volatile.Register32 // 0x8
	FTSR1  volatile.Register32 // 0xC
	SWIER1 volatile.Register32 // 0x10
	PR1    volatile.Register32 // 0x14
	_      [8]byte
	IMR2   volatile.Register32 // 0x20
	EMR2   volatile.Register32 // 0x24
	RTSR2  volatile.Register32 // 0x28
	FTSR2  volatile.Register32 // 0x2C
	SWIER2 volatile.Register32 // 0x30
	PR2    volatile.Register32 // 0x34
}

// Voltage reference buffer
type VREF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// Controller area network
type CAN_Type struct {
	MCR  volatile.Register32 // 0x0
	MSR  volatile.Register32 // 0x4
	TSR  volatile.Register32 // 0x8
	RF0R volatile.Register32 // 0xC
	RF1R volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	ESR  volatile.Register32 // 0x18
	BTR  volatile.Register32 // 0x1C
	_    [352]byte
	TX   [3]struct {
		TIR  volatile.Register32
		TDTR volatile.Register32
		TDLR volatile.Register32
		TDHR volatile.Register32
	} // 0x180
	RX [2]struct {
		RIR  volatile.Register32
		RDTR volatile.Register32
		RDLR volatile.Register32
		RDHR volatile.Register32
	} // 0x1B0
	_  [112]byte
	FB [28]struct {
		FR1 volatile.Register32
		FR2 volatile.Register32
	} // 0x240
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// Single Wire Protocol Master Interface
type SWPMI_Type struct {
	CR  volatile.Register32 // 0x0
	BRR volatile.Register32 // 0x4
	_   [4]byte
	ISR volatile.Register32 // 0xC
	ICR volatile.Register32 // 0x10
	IER volatile.Register32 // 0x14
	RFL volatile.Register32 // 0x18
	TDR volatile.Register32 // 0x1C
	RDR volatile.Register32 // 0x20
	OR  volatile.Register32 // 0x24
}

// Operational amplifiers
type OPAMP_Type struct {
	OPAMP1_CSR   volatile.Register32 // 0x0
	OPAMP1_OTR   volatile.Register32 // 0x4
	OPAMP1_LPOTR volatile.Register32 // 0x8
	_            [4]byte
	OPAMP2_CSR   volatile.Register32 // 0x10
	OPAMP2_OTR   volatile.Register32 // 0x14
	OPAMP2_LPOTR volatile.Register32 // 0x18
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
}

// Clock recovery system
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// Universal serial bus full-speed device interface
type USB_Type struct {
	EP0R   volatile.Register32 // 0x0
	EP1R   volatile.Register32 // 0x4
	EP2R   volatile.Register32 // 0x8
	EP3R   volatile.Register32 // 0xC
	EP4R   volatile.Register32 // 0x10
	EP5R   volatile.Register32 // 0x14
	EP6R   volatile.Register32 // 0x18
	EP7R   volatile.Register32 // 0x1C
	_      [32]byte
	CNTR   volatile.Register32 // 0x40
	ISTR   volatile.Register32 // 0x44
	FNR    volatile.Register32 // 0x48
	DADDR  volatile.Register32 // 0x4C
	BTABLE volatile.Register32 // 0x50
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// Flexible memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [96]byte
	PCR   volatile.Register32 // 0x80
	SR    volatile.Register32 // 0x84
	PMEM  volatile.Register32 // 0x88
	PATT  volatile.Register32 // 0x8C
	_     [4]byte
	ECCR  volatile.Register32 // 0x94
	_     [108]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// Digital filter for sigma delta modulators
type DFSDM_Type struct {
	CH [8]struct {
		CFGR1  volatile.Register32
		CFGR2  volatile.Register32
		AWSCDR volatile.Register32
		WDATR  volatile.Register32
		DATINR volatile.Register32
		_      [12]byte
	} // 0x0
	FLT [4]struct {
		CR2     volatile.Register32
		_       [4]byte
		ISR     volatile.Register32
		ICR     volatile.Register32
		JCHGR   volatile.Register32
		FCR     volatile.Register32
		JDATAR  volatile.Register32
		RDATAR  volatile.Register32
		AWHTR   volatile.Register32
		AWLTR   volatile.Register32
		AWSR    volatile.Register32
		AWCFR   volatile.Register32
		EXMAX   volatile.Register32
		EXMIN   volatile.Register32
		CNVTIMR volatile.Register32
		_       [196]byte
	} // 0x100
}

// Reset and clock control
type RCC_Type struct {
	CR          volatile.Register32 // 0x0
	ICSCR       volatile.Register32 // 0x4
	CFGR        volatile.Register32 // 0x8
	PLLCFGR     volatile.Register32 // 0xC
	PLLSAI1CFGR volatile.Register32 // 0x10
	PLLSAI2CFGR volatile.Register32 // 0x14
	CIER        volatile.Register32 // 0x18
	CIFR        volatile.Register32 // 0x1C
	CICR        volatile.Register32 // 0x20
	_           [4]byte
	AHB1RSTR    volatile.Register32 // 0x28
	AHB2RSTR    volatile.Register32 // 0x2C
	AHB3RSTR    volatile.Register32 // 0x30
	_           [4]byte
	APB1RSTR1   volatile.Register32 // 0x38
	APB1RSTR2   volatile.Register32 // 0x3C
	APB2RSTR    volatile.Register32 // 0x40
	_           [4]byte
	AHB1ENR     volatile.Register32 // 0x48
	AHB2ENR     volatile.Register32 // 0x4C
	AHB3ENR     volatile.Register32 // 0x50
	_           [4]byte
	APB1ENR1    volatile.Register32 // 0x58
	APB1ENR2    volatile.Register32 // 0x5C
	APB2ENR     volatile.Register32 // 0x60
	_           [4]byte
	AHB1SMENR   volatile.Register32 // 0x68
	AHB2SMENR   volatile.Register32 // 0x6C
	AHB3SMENR   volatile.Register32 // 0x70
	_           [4]byte
	APB1SMENR1  volatile.Register32 // 0x78
	APB1SMENR2  volatile.Register32 // 0x7C
	APB2SMENR   volatile.Register32 // 0x80
	_           [4]byte
	CCIPR       volatile.Register32 // 0x88
	_           [4]byte
	BDCR        volatile.Register32 // 0x90
	CSR         volatile.Register32 // 0x94
	CRRCR       volatile.Register32 // 0x98
}

// Debug support
type DBGMCU_Type struct {
	IDCODE    volatile.Register32 // 0x0
	CR        volatile.Register32 // 0x4
	APB1_FZR1 volatile.Register32 // 0x8
	APB1_FZR2 volatile.Register32 // 0xC
	APB2_FZR  volatile.Register32 // 0x10
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// Bitfields for DAC1: Digital-to-analog converter
const (
	// CR: control register
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x2
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x4
	// Bit TEN1.
	DAC_CR_TEN1 = 0x4
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x3
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x38
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// Position of CEN1 field.
	DAC_CR_CEN1_Pos = 0xe
	// Bit mask of CEN1 field.
	DAC_CR_CEN1_Msk = 0x4000
	// Bit CEN1.
	DAC_CR_CEN1 = 0x4000
	// Position of EN2 field.
	DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_CR_EN2 = 0x10000
	// Position of TEN2 field.
	DAC_CR_TEN2_Pos = 0x12
	// Bit mask of TEN2 field.
	DAC_CR_TEN2_Msk = 0x40000
	// Bit TEN2.
	DAC_CR_TEN2 = 0x40000
	// Position of TSEL2 field.
	DAC_CR_TSEL2_Pos = 0x13
	// Bit mask of TSEL2 field.
	DAC_CR_TSEL2_Msk = 0x380000
	// Position of WAVE2 field.
	DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_CR_WAVE2_Msk = 0xc00000
	// Position of MAMP2 field.
	DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_CR_MAMP2_Msk = 0xf000000
	// Position of DMAEN2 field.
	DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_CR_DMAEN2 = 0x10000000
	// Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_CR_DMAUDRIE2 = 0x20000000
	// Position of CEN2 field.
	DAC_CR_CEN2_Pos = 0x1e
	// Bit mask of CEN2 field.
	DAC_CR_CEN2_Msk = 0x40000000
	// Bit CEN2.
	DAC_CR_CEN2 = 0x40000000

	// SWTRIGR: software trigger register
	// Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG1 = 0x1
	// Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG2 = 0x2

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: channel2 12-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: channel2 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000

	// DHR12LD: DUAL DAC 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000

	// DHR8RD: DUAL DAC 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00

	// DOR1: channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: channel2 data output register
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: status register
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// Position of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1_Pos = 0xe
	// Bit mask of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1_Msk = 0x4000
	// Bit CAL_FLAG1.
	DAC_SR_CAL_FLAG1 = 0x4000
	// Position of BWST1 field.
	DAC_SR_BWST1_Pos = 0xf
	// Bit mask of BWST1 field.
	DAC_SR_BWST1_Msk = 0x8000
	// Bit BWST1.
	DAC_SR_BWST1 = 0x8000
	// Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_SR_DMAUDR2 = 0x20000000
	// Position of CAL_FLAG2 field.
	DAC_SR_CAL_FLAG2_Pos = 0x1e
	// Bit mask of CAL_FLAG2 field.
	DAC_SR_CAL_FLAG2_Msk = 0x40000000
	// Bit CAL_FLAG2.
	DAC_SR_CAL_FLAG2 = 0x40000000
	// Position of BWST2 field.
	DAC_SR_BWST2_Pos = 0x1f
	// Bit mask of BWST2 field.
	DAC_SR_BWST2_Msk = 0x80000000
	// Bit BWST2.
	DAC_SR_BWST2 = 0x80000000

	// CCR: calibration control register
	// Position of OTRIM1 field.
	DAC_CCR_OTRIM1_Pos = 0x0
	// Bit mask of OTRIM1 field.
	DAC_CCR_OTRIM1_Msk = 0x1f
	// Position of OTRIM2 field.
	DAC_CCR_OTRIM2_Pos = 0x10
	// Bit mask of OTRIM2 field.
	DAC_CCR_OTRIM2_Msk = 0x1f0000

	// MCR: mode control register
	// Position of MODE1 field.
	DAC_MCR_MODE1_Pos = 0x0
	// Bit mask of MODE1 field.
	DAC_MCR_MODE1_Msk = 0x7
	// Position of MODE2 field.
	DAC_MCR_MODE2_Pos = 0x10
	// Bit mask of MODE2 field.
	DAC_MCR_MODE2_Msk = 0x70000

	// SHSR1: Sample and Hold sample time register 1
	// Position of TSAMPLE1 field.
	DAC_SHSR1_TSAMPLE1_Pos = 0x0
	// Bit mask of TSAMPLE1 field.
	DAC_SHSR1_TSAMPLE1_Msk = 0x3ff

	// SHSR2: Sample and Hold sample time register 2
	// Position of TSAMPLE2 field.
	DAC_SHSR2_TSAMPLE2_Pos = 0x0
	// Bit mask of TSAMPLE2 field.
	DAC_SHSR2_TSAMPLE2_Msk = 0x3ff

	// SHHR: Sample and Hold hold time register
	// Position of THOLD1 field.
	DAC_SHHR_THOLD1_Pos = 0x0
	// Bit mask of THOLD1 field.
	DAC_SHHR_THOLD1_Msk = 0x3ff
	// Position of THOLD2 field.
	DAC_SHHR_THOLD2_Pos = 0x10
	// Bit mask of THOLD2 field.
	DAC_SHHR_THOLD2_Msk = 0x3ff0000

	// SHRR: Sample and Hold refresh time register
	// Position of TREFRESH1 field.
	DAC_SHRR_TREFRESH1_Pos = 0x0
	// Bit mask of TREFRESH1 field.
	DAC_SHRR_TREFRESH1_Msk = 0xff
	// Position of TREFRESH2 field.
	DAC_SHRR_TREFRESH2_Pos = 0x10
	// Bit mask of TREFRESH2 field.
	DAC_SHRR_TREFRESH2_Msk = 0xff0000
)

// Bitfields for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// No transfer error
	DMA_ISR_TEIF7_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF7_Error = 0x1
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// No half transfer event
	DMA_ISR_HTIF7_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF7_Half = 0x1
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// No transfer complete event
	DMA_ISR_TCIF7_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF7_Complete = 0x1
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// No transfer error, half event, complete event
	DMA_ISR_GIF7_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF7_Event = 0x1
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// No transfer error
	DMA_ISR_TEIF6_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF6_Error = 0x1
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// No half transfer event
	DMA_ISR_HTIF6_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF6_Half = 0x1
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// No transfer complete event
	DMA_ISR_TCIF6_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF6_Complete = 0x1
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// No transfer error, half event, complete event
	DMA_ISR_GIF6_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF6_Event = 0x1
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// No transfer error
	DMA_ISR_TEIF5_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF5_Error = 0x1
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// No half transfer event
	DMA_ISR_HTIF5_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF5_Half = 0x1
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// No transfer complete event
	DMA_ISR_TCIF5_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF5_Complete = 0x1
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// No transfer error, half event, complete event
	DMA_ISR_GIF5_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF5_Event = 0x1
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// No transfer error
	DMA_ISR_TEIF4_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF4_Error = 0x1
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// No half transfer event
	DMA_ISR_HTIF4_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF4_Half = 0x1
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// No transfer complete event
	DMA_ISR_TCIF4_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF4_Complete = 0x1
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// No transfer error, half event, complete event
	DMA_ISR_GIF4_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF4_Event = 0x1
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// No transfer error
	DMA_ISR_TEIF3_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF3_Error = 0x1
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// No half transfer event
	DMA_ISR_HTIF3_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF3_Half = 0x1
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// No transfer complete event
	DMA_ISR_TCIF3_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF3_Complete = 0x1
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// No transfer error, half event, complete event
	DMA_ISR_GIF3_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF3_Event = 0x1
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// No transfer error
	DMA_ISR_TEIF2_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF2_Error = 0x1
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// No half transfer event
	DMA_ISR_HTIF2_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF2_Half = 0x1
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// No transfer complete event
	DMA_ISR_TCIF2_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF2_Complete = 0x1
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// No transfer error, half event, complete event
	DMA_ISR_GIF2_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF2_Event = 0x1
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// No transfer error
	DMA_ISR_TEIF1_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF1_Error = 0x1
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// No half transfer event
	DMA_ISR_HTIF1_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF1_Half = 0x1
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// No transfer complete event
	DMA_ISR_TCIF1_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF1_Complete = 0x1
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1
	// No transfer error, half event, complete event
	DMA_ISR_GIF1_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF1_Event = 0x1

	// IFCR: interrupt flag clear register
	// Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Pos = 0x1b
	// Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000
	// Bit CTEIF7.
	DMA_IFCR_CTEIF7 = 0x8000000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF7_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_IFCR_CHTIF7 = 0x4000000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF7_Clear = 0x1
	// Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Pos = 0x19
	// Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000
	// Bit CTCIF7.
	DMA_IFCR_CTCIF7 = 0x2000000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF7_Clear = 0x1
	// Position of CGIF7 field.
	DMA_IFCR_CGIF7_Pos = 0x18
	// Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7_Msk = 0x1000000
	// Bit CGIF7.
	DMA_IFCR_CGIF7 = 0x1000000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF7_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Pos = 0x17
	// Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000
	// Bit CTEIF6.
	DMA_IFCR_CTEIF6 = 0x800000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF6_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Pos = 0x16
	// Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000
	// Bit CHTIF6.
	DMA_IFCR_CHTIF6 = 0x400000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF6_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_IFCR_CTCIF6 = 0x200000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF6_Clear = 0x1
	// Position of CGIF6 field.
	DMA_IFCR_CGIF6_Pos = 0x14
	// Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6_Msk = 0x100000
	// Bit CGIF6.
	DMA_IFCR_CGIF6 = 0x100000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF6_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA_IFCR_CTEIF5 = 0x80000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF5_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA_IFCR_CHTIF5 = 0x40000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF5_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA_IFCR_CTCIF5 = 0x20000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF5_Clear = 0x1
	// Position of CGIF5 field.
	DMA_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA_IFCR_CGIF5 = 0x10000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF5_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Pos = 0xf
	// Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000
	// Bit CTEIF4.
	DMA_IFCR_CTEIF4 = 0x8000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF4_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA_IFCR_CHTIF4 = 0x4000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF4_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA_IFCR_CTCIF4 = 0x2000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF4_Clear = 0x1
	// Position of CGIF4 field.
	DMA_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA_IFCR_CGIF4 = 0x1000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF4_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA_IFCR_CTEIF3 = 0x800
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF3_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA_IFCR_CHTIF3 = 0x400
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF3_Clear = 0x1
	// Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA_IFCR_CTCIF3 = 0x200
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF3_Clear = 0x1
	// Position of CGIF3 field.
	DMA_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA_IFCR_CGIF3 = 0x100
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF3_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA_IFCR_CTEIF2 = 0x80
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF2_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA_IFCR_CHTIF2 = 0x40
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF2_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA_IFCR_CTCIF2 = 0x20
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF2_Clear = 0x1
	// Position of CGIF2 field.
	DMA_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA_IFCR_CGIF2 = 0x10
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF2_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA_IFCR_CTEIF1 = 0x8
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF1_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA_IFCR_CHTIF1 = 0x4
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF1_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA_IFCR_CTCIF1 = 0x2
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF1_Clear = 0x1
	// Position of CGIF1 field.
	DMA_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA_IFCR_CGIF1 = 0x1
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF1_Clear = 0x1

	// CCR1: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR1_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CCR1_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CCR1_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR1_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR1_PL_Msk = 0x3000
	// Low priority
	DMA_CCR1_PL_Low = 0x0
	// Medium priority
	DMA_CCR1_PL_Medium = 0x1
	// High priority
	DMA_CCR1_PL_High = 0x2
	// Very high priority
	DMA_CCR1_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR1_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR1_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CCR1_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR1_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR1_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR1_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR1_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CCR1_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR1_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR1_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR1_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR1_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR1_MINC = 0x80
	// Increment mode disabled
	DMA_CCR1_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR1_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR1_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR1_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR1_PINC = 0x40
	// Increment mode disabled
	DMA_CCR1_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR1_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR1_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR1_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR1_CIRC = 0x20
	// Circular buffer disabled
	DMA_CCR1_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CCR1_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR1_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR1_DIR = 0x10
	// Read from peripheral
	DMA_CCR1_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CCR1_DIR_FromMemory = 0x1
	// Position of TEIE field.
	DMA_CCR1_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR1_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR1_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CCR1_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CCR1_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR1_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR1_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR1_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CCR1_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CCR1_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR1_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR1_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR1_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CCR1_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CCR1_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR1_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR1_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR1_EN = 0x1
	// Channel disabled
	DMA_CCR1_EN_Disabled = 0x0
	// Channel enabled
	DMA_CCR1_EN_Enabled = 0x1

	// CNDTR1: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR1_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff

	// CPAR1: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR1_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff

	// CMAR1: channel x memory address register
	// Position of MA field.
	DMA_CMAR1_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff

	// CCR2: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR2_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CCR2_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CCR2_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR2_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR2_PL_Msk = 0x3000
	// Low priority
	DMA_CCR2_PL_Low = 0x0
	// Medium priority
	DMA_CCR2_PL_Medium = 0x1
	// High priority
	DMA_CCR2_PL_High = 0x2
	// Very high priority
	DMA_CCR2_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR2_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR2_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CCR2_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR2_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR2_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR2_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR2_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CCR2_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR2_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR2_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR2_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR2_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR2_MINC = 0x80
	// Increment mode disabled
	DMA_CCR2_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR2_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR2_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR2_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR2_PINC = 0x40
	// Increment mode disabled
	DMA_CCR2_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR2_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR2_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR2_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR2_CIRC = 0x20
	// Circular buffer disabled
	DMA_CCR2_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CCR2_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR2_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR2_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR2_DIR = 0x10
	// Read from peripheral
	DMA_CCR2_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CCR2_DIR_FromMemory = 0x1
	// Position of TEIE field.
	DMA_CCR2_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR2_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR2_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CCR2_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CCR2_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR2_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR2_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR2_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CCR2_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CCR2_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR2_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR2_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR2_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CCR2_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CCR2_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR2_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR2_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR2_EN = 0x1
	// Channel disabled
	DMA_CCR2_EN_Disabled = 0x0
	// Channel enabled
	DMA_CCR2_EN_Enabled = 0x1

	// CNDTR2: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR2_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff

	// CPAR2: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR2_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff

	// CMAR2: channel x memory address register
	// Position of MA field.
	DMA_CMAR2_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff

	// CCR3: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR3_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CCR3_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CCR3_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR3_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR3_PL_Msk = 0x3000
	// Low priority
	DMA_CCR3_PL_Low = 0x0
	// Medium priority
	DMA_CCR3_PL_Medium = 0x1
	// High priority
	DMA_CCR3_PL_High = 0x2
	// Very high priority
	DMA_CCR3_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR3_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR3_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CCR3_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR3_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR3_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR3_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR3_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CCR3_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR3_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR3_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR3_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR3_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR3_MINC = 0x80
	// Increment mode disabled
	DMA_CCR3_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR3_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR3_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR3_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR3_PINC = 0x40
	// Increment mode disabled
	DMA_CCR3_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR3_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR3_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR3_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR3_CIRC = 0x20
	// Circular buffer disabled
	DMA_CCR3_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CCR3_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR3_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR3_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR3_DIR = 0x10
	// Read from peripheral
	DMA_CCR3_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CCR3_DIR_FromMemory = 0x1
	// Position of TEIE field.
	DMA_CCR3_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR3_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR3_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CCR3_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CCR3_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR3_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR3_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR3_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CCR3_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CCR3_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR3_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR3_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR3_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CCR3_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CCR3_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR3_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR3_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR3_EN = 0x1
	// Channel disabled
	DMA_CCR3_EN_Disabled = 0x0
	// Channel enabled
	DMA_CCR3_EN_Enabled = 0x1

	// CNDTR3: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR3_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff

	// CPAR3: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR3_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff

	// CMAR3: channel x memory address register
	// Position of MA field.
	DMA_CMAR3_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff

	// CCR4: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR4_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CCR4_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CCR4_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR4_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR4_PL_Msk = 0x3000
	// Low priority
	DMA_CCR4_PL_Low = 0x0
	// Medium priority
	DMA_CCR4_PL_Medium = 0x1
	// High priority
	DMA_CCR4_PL_High = 0x2
	// Very high priority
	DMA_CCR4_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR4_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR4_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CCR4_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR4_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR4_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR4_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR4_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CCR4_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR4_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR4_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR4_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR4_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR4_MINC = 0x80
	// Increment mode disabled
	DMA_CCR4_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR4_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR4_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR4_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR4_PINC = 0x40
	// Increment mode disabled
	DMA_CCR4_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR4_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR4_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR4_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR4_CIRC = 0x20
	// Circular buffer disabled
	DMA_CCR4_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CCR4_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR4_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR4_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR4_DIR = 0x10
	// Read from peripheral
	DMA_CCR4_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CCR4_DIR_FromMemory = 0x1
	// Position of TEIE field.
	DMA_CCR4_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR4_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR4_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CCR4_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CCR4_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR4_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR4_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR4_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CCR4_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CCR4_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR4_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR4_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR4_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CCR4_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CCR4_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR4_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR4_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR4_EN = 0x1
	// Channel disabled
	DMA_CCR4_EN_Disabled = 0x0
	// Channel enabled
	DMA_CCR4_EN_Enabled = 0x1

	// CNDTR4: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR4_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff

	// CPAR4: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR4_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff

	// CMAR4: channel x memory address register
	// Position of MA field.
	DMA_CMAR4_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff

	// CCR5: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR5_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CCR5_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CCR5_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR5_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR5_PL_Msk = 0x3000
	// Low priority
	DMA_CCR5_PL_Low = 0x0
	// Medium priority
	DMA_CCR5_PL_Medium = 0x1
	// High priority
	DMA_CCR5_PL_High = 0x2
	// Very high priority
	DMA_CCR5_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR5_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR5_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CCR5_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR5_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR5_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR5_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR5_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CCR5_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR5_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR5_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR5_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR5_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR5_MINC = 0x80
	// Increment mode disabled
	DMA_CCR5_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR5_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR5_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR5_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR5_PINC = 0x40
	// Increment mode disabled
	DMA_CCR5_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR5_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR5_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR5_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR5_CIRC = 0x20
	// Circular buffer disabled
	DMA_CCR5_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CCR5_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR5_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR5_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR5_DIR = 0x10
	// Read from peripheral
	DMA_CCR5_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CCR5_DIR_FromMemory = 0x1
	// Position of TEIE field.
	DMA_CCR5_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR5_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR5_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CCR5_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CCR5_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR5_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR5_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR5_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CCR5_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CCR5_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR5_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR5_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR5_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CCR5_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CCR5_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR5_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR5_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR5_EN = 0x1
	// Channel disabled
	DMA_CCR5_EN_Disabled = 0x0
	// Channel enabled
	DMA_CCR5_EN_Enabled = 0x1

	// CNDTR5: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR5_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff

	// CPAR5: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR5_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff

	// CMAR5: channel x memory address register
	// Position of MA field.
	DMA_CMAR5_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff

	// CCR6: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR6_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CCR6_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CCR6_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR6_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR6_PL_Msk = 0x3000
	// Low priority
	DMA_CCR6_PL_Low = 0x0
	// Medium priority
	DMA_CCR6_PL_Medium = 0x1
	// High priority
	DMA_CCR6_PL_High = 0x2
	// Very high priority
	DMA_CCR6_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR6_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR6_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CCR6_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR6_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR6_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR6_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR6_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CCR6_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR6_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR6_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR6_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR6_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR6_MINC = 0x80
	// Increment mode disabled
	DMA_CCR6_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR6_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR6_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR6_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR6_PINC = 0x40
	// Increment mode disabled
	DMA_CCR6_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR6_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR6_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR6_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR6_CIRC = 0x20
	// Circular buffer disabled
	DMA_CCR6_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CCR6_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR6_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR6_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR6_DIR = 0x10
	// Read from peripheral
	DMA_CCR6_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CCR6_DIR_FromMemory = 0x1
	// Position of TEIE field.
	DMA_CCR6_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR6_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR6_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CCR6_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CCR6_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR6_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR6_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR6_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CCR6_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CCR6_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR6_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR6_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR6_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CCR6_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CCR6_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR6_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR6_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR6_EN = 0x1
	// Channel disabled
	DMA_CCR6_EN_Disabled = 0x0
	// Channel enabled
	DMA_CCR6_EN_Enabled = 0x1

	// CNDTR6: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR6_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff

	// CPAR6: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR6_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff

	// CMAR6: channel x memory address register
	// Position of MA field.
	DMA_CMAR6_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff

	// CCR7: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR7_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CCR7_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CCR7_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CCR7_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR7_PL_Msk = 0x3000
	// Low priority
	DMA_CCR7_PL_Low = 0x0
	// Medium priority
	DMA_CCR7_PL_Medium = 0x1
	// High priority
	DMA_CCR7_PL_High = 0x2
	// Very high priority
	DMA_CCR7_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CCR7_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR7_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CCR7_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR7_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR7_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CCR7_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR7_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CCR7_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CCR7_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CCR7_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CCR7_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR7_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR7_MINC = 0x80
	// Increment mode disabled
	DMA_CCR7_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR7_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CCR7_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR7_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR7_PINC = 0x40
	// Increment mode disabled
	DMA_CCR7_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CCR7_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CCR7_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR7_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR7_CIRC = 0x20
	// Circular buffer disabled
	DMA_CCR7_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CCR7_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CCR7_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR7_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR7_DIR = 0x10
	// Read from peripheral
	DMA_CCR7_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CCR7_DIR_FromMemory = 0x1
	// Position of TEIE field.
	DMA_CCR7_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR7_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR7_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CCR7_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CCR7_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CCR7_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR7_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR7_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CCR7_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CCR7_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CCR7_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR7_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR7_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CCR7_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CCR7_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CCR7_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR7_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR7_EN = 0x1
	// Channel disabled
	DMA_CCR7_EN_Disabled = 0x0
	// Channel enabled
	DMA_CCR7_EN_Enabled = 0x1

	// CNDTR7: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR7_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff

	// CPAR7: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR7_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff

	// CMAR7: channel x memory address register
	// Position of MA field.
	DMA_CMAR7_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff

	// CSELR: channel selection register
	// Position of C7S field.
	DMA_CSELR_C7S_Pos = 0x18
	// Bit mask of C7S field.
	DMA_CSELR_C7S_Msk = 0xf000000
	// Default mapping
	DMA_CSELR_C7S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C7S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C7S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C7S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C7S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C7S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C7S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C7S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C7S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C7S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C7S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C7S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C7S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C7S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C7S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C7S_Map15 = 0xf
	// Position of C6S field.
	DMA_CSELR_C6S_Pos = 0x14
	// Bit mask of C6S field.
	DMA_CSELR_C6S_Msk = 0xf00000
	// Default mapping
	DMA_CSELR_C6S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C6S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C6S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C6S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C6S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C6S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C6S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C6S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C6S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C6S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C6S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C6S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C6S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C6S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C6S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C6S_Map15 = 0xf
	// Position of C5S field.
	DMA_CSELR_C5S_Pos = 0x10
	// Bit mask of C5S field.
	DMA_CSELR_C5S_Msk = 0xf0000
	// Default mapping
	DMA_CSELR_C5S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C5S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C5S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C5S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C5S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C5S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C5S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C5S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C5S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C5S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C5S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C5S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C5S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C5S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C5S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C5S_Map15 = 0xf
	// Position of C4S field.
	DMA_CSELR_C4S_Pos = 0xc
	// Bit mask of C4S field.
	DMA_CSELR_C4S_Msk = 0xf000
	// Default mapping
	DMA_CSELR_C4S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C4S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C4S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C4S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C4S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C4S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C4S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C4S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C4S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C4S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C4S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C4S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C4S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C4S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C4S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C4S_Map15 = 0xf
	// Position of C3S field.
	DMA_CSELR_C3S_Pos = 0x8
	// Bit mask of C3S field.
	DMA_CSELR_C3S_Msk = 0xf00
	// Default mapping
	DMA_CSELR_C3S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C3S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C3S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C3S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C3S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C3S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C3S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C3S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C3S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C3S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C3S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C3S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C3S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C3S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C3S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C3S_Map15 = 0xf
	// Position of C2S field.
	DMA_CSELR_C2S_Pos = 0x4
	// Bit mask of C2S field.
	DMA_CSELR_C2S_Msk = 0xf0
	// Default mapping
	DMA_CSELR_C2S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C2S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C2S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C2S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C2S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C2S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C2S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C2S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C2S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C2S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C2S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C2S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C2S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C2S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C2S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C2S_Map15 = 0xf
	// Position of C1S field.
	DMA_CSELR_C1S_Pos = 0x0
	// Bit mask of C1S field.
	DMA_CSELR_C1S_Msk = 0xf
	// Default mapping
	DMA_CSELR_C1S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C1S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C1S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C1S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C1S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C1S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C1S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C1S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C1S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C1S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C1S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C1S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C1S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C1S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C1S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C1S_Map15 = 0xf
)

// Bitfields for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// DR8: Data register - byte sized
	// Position of DR8 field.
	CRC_DR8_DR8_Pos = 0x0
	// Bit mask of DR8 field.
	CRC_DR8_DR8_Msk = 0xff

	// DR16: Data register - half-word sized
	// Position of DR16 field.
	CRC_DR16_DR16_Pos = 0x0
	// Bit mask of DR16 field.
	CRC_DR16_DR16_Msk = 0xffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Bit order not affected
	CRC_CR_REV_OUT_Normal = 0x0
	// Bit reversed output
	CRC_CR_REV_OUT_Reversed = 0x1
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Bit order not affected
	CRC_CR_REV_IN_Normal = 0x0
	// Bit reversal done by byte
	CRC_CR_REV_IN_Byte = 0x1
	// Bit reversal done by half-word
	CRC_CR_REV_IN_HalfWord = 0x2
	// Bit reversal done by word
	CRC_CR_REV_IN_Word = 0x3
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// 32-bit polynomial
	CRC_CR_POLYSIZE_Polysize32 = 0x0
	// 16-bit polynomial
	CRC_CR_POLYSIZE_Polysize16 = 0x1
	// 8-bit polynomial
	CRC_CR_POLYSIZE_Polysize8 = 0x2
	// 7-bit polynomial
	CRC_CR_POLYSIZE_Polysize7 = 0x3
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1

	// INIT: Initial CRC value
	// Position of INIT field.
	CRC_INIT_INIT_Pos = 0x0
	// Bit mask of INIT field.
	CRC_INIT_INIT_Msk = 0xffffffff

	// POL: polynomial
	// Position of Polynomialcoefficients field.
	CRC_POL_Polynomialcoefficients_Pos = 0x0
	// Bit mask of Polynomialcoefficients field.
	CRC_POL_Polynomialcoefficients_Msk = 0xffffffff
)

// Bitfields for LCD: Liquid crystal display controller
const (
	// CR: control register
	// Position of BIAS field.
	LCD_CR_BIAS_Pos = 0x5
	// Bit mask of BIAS field.
	LCD_CR_BIAS_Msk = 0x60
	// Position of DUTY field.
	LCD_CR_DUTY_Pos = 0x2
	// Bit mask of DUTY field.
	LCD_CR_DUTY_Msk = 0x1c
	// Position of VSEL field.
	LCD_CR_VSEL_Pos = 0x1
	// Bit mask of VSEL field.
	LCD_CR_VSEL_Msk = 0x2
	// Bit VSEL.
	LCD_CR_VSEL = 0x2
	// Position of LCDEN field.
	LCD_CR_LCDEN_Pos = 0x0
	// Bit mask of LCDEN field.
	LCD_CR_LCDEN_Msk = 0x1
	// Bit LCDEN.
	LCD_CR_LCDEN = 0x1
	// Position of MUX_SEG field.
	LCD_CR_MUX_SEG_Pos = 0x7
	// Bit mask of MUX_SEG field.
	LCD_CR_MUX_SEG_Msk = 0x80
	// Bit MUX_SEG.
	LCD_CR_MUX_SEG = 0x80
	// Position of BUFEN field.
	LCD_CR_BUFEN_Pos = 0x8
	// Bit mask of BUFEN field.
	LCD_CR_BUFEN_Msk = 0x100
	// Bit BUFEN.
	LCD_CR_BUFEN = 0x100

	// FCR: frame control register
	// Position of PS field.
	LCD_FCR_PS_Pos = 0x16
	// Bit mask of PS field.
	LCD_FCR_PS_Msk = 0x3c00000
	// Position of DIV field.
	LCD_FCR_DIV_Pos = 0x12
	// Bit mask of DIV field.
	LCD_FCR_DIV_Msk = 0x3c0000
	// Position of BLINK field.
	LCD_FCR_BLINK_Pos = 0x10
	// Bit mask of BLINK field.
	LCD_FCR_BLINK_Msk = 0x30000
	// Position of BLINKF field.
	LCD_FCR_BLINKF_Pos = 0xd
	// Bit mask of BLINKF field.
	LCD_FCR_BLINKF_Msk = 0xe000
	// Position of CC field.
	LCD_FCR_CC_Pos = 0xa
	// Bit mask of CC field.
	LCD_FCR_CC_Msk = 0x1c00
	// Position of DEAD field.
	LCD_FCR_DEAD_Pos = 0x7
	// Bit mask of DEAD field.
	LCD_FCR_DEAD_Msk = 0x380
	// Position of PON field.
	LCD_FCR_PON_Pos = 0x4
	// Bit mask of PON field.
	LCD_FCR_PON_Msk = 0x70
	// Position of UDDIE field.
	LCD_FCR_UDDIE_Pos = 0x3
	// Bit mask of UDDIE field.
	LCD_FCR_UDDIE_Msk = 0x8
	// Bit UDDIE.
	LCD_FCR_UDDIE = 0x8
	// Position of SOFIE field.
	LCD_FCR_SOFIE_Pos = 0x1
	// Bit mask of SOFIE field.
	LCD_FCR_SOFIE_Msk = 0x2
	// Bit SOFIE.
	LCD_FCR_SOFIE = 0x2
	// Position of HD field.
	LCD_FCR_HD_Pos = 0x0
	// Bit mask of HD field.
	LCD_FCR_HD_Msk = 0x1
	// Bit HD.
	LCD_FCR_HD = 0x1

	// SR: status register
	// Position of FCRSF field.
	LCD_SR_FCRSF_Pos = 0x5
	// Bit mask of FCRSF field.
	LCD_SR_FCRSF_Msk = 0x20
	// Bit FCRSF.
	LCD_SR_FCRSF = 0x20
	// Position of RDY field.
	LCD_SR_RDY_Pos = 0x4
	// Bit mask of RDY field.
	LCD_SR_RDY_Msk = 0x10
	// Bit RDY.
	LCD_SR_RDY = 0x10
	// Position of UDD field.
	LCD_SR_UDD_Pos = 0x3
	// Bit mask of UDD field.
	LCD_SR_UDD_Msk = 0x8
	// Bit UDD.
	LCD_SR_UDD = 0x8
	// Position of UDR field.
	LCD_SR_UDR_Pos = 0x2
	// Bit mask of UDR field.
	LCD_SR_UDR_Msk = 0x4
	// Bit UDR.
	LCD_SR_UDR = 0x4
	// Position of SOF field.
	LCD_SR_SOF_Pos = 0x1
	// Bit mask of SOF field.
	LCD_SR_SOF_Msk = 0x2
	// Bit SOF.
	LCD_SR_SOF = 0x2
	// Position of ENS field.
	LCD_SR_ENS_Pos = 0x0
	// Bit mask of ENS field.
	LCD_SR_ENS_Msk = 0x1
	// Bit ENS.
	LCD_SR_ENS = 0x1

	// CLR: clear register
	// Position of UDDC field.
	LCD_CLR_UDDC_Pos = 0x3
	// Bit mask of UDDC field.
	LCD_CLR_UDDC_Msk = 0x8
	// Bit UDDC.
	LCD_CLR_UDDC = 0x8
	// Position of SOFC field.
	LCD_CLR_SOFC_Pos = 0x1
	// Bit mask of SOFC field.
	LCD_CLR_SOFC_Msk = 0x2
	// Bit SOFC.
	LCD_CLR_SOFC = 0x2

	// RAM_COM0: display memory
	// Position of S30 field.
	LCD_RAM_COM0_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM0_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM0_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM0_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM0_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM0_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM0_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM0_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM0_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM0_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM0_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM0_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM0_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM0_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM0_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM0_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM0_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM0_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM0_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM0_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM0_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM0_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM0_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM0_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM0_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM0_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM0_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM0_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM0_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM0_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM0_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM0_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM0_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM0_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM0_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM0_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM0_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM0_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM0_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM0_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM0_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM0_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM0_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM0_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM0_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM0_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM0_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM0_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM0_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM0_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM0_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM0_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM0_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM0_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM0_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM0_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM0_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM0_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM0_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM0_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM0_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM0_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM0_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM0_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM0_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM0_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM0_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM0_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM0_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM0_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM0_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM0_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM0_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM0_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM0_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM0_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM0_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM0_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM0_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM0_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM0_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM0_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM0_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM0_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM0_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM0_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM0_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM0_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM0_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM0_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM0_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM0_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM0_S00 = 0x1

	// RAM_COM1: display memory
	// Position of S31 field.
	LCD_RAM_COM1_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM1_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM1_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM1_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM1_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM1_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM1_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM1_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM1_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM1_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM1_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM1_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM1_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM1_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM1_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM1_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM1_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM1_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM1_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM1_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM1_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM1_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM1_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM1_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM1_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM1_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM1_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM1_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM1_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM1_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM1_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM1_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM1_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM1_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM1_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM1_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM1_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM1_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM1_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM1_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM1_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM1_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM1_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM1_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM1_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM1_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM1_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM1_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM1_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM1_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM1_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM1_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM1_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM1_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM1_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM1_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM1_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM1_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM1_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM1_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM1_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM1_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM1_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM1_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM1_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM1_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM1_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM1_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM1_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM1_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM1_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM1_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM1_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM1_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM1_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM1_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM1_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM1_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM1_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM1_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM1_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM1_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM1_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM1_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM1_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM1_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM1_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM1_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM1_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM1_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM1_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM1_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM1_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM1_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM1_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM1_S00 = 0x1

	// RAM_COM2: display memory
	// Position of S31 field.
	LCD_RAM_COM2_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM2_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM2_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM2_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM2_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM2_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM2_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM2_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM2_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM2_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM2_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM2_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM2_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM2_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM2_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM2_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM2_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM2_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM2_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM2_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM2_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM2_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM2_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM2_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM2_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM2_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM2_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM2_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM2_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM2_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM2_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM2_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM2_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM2_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM2_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM2_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM2_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM2_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM2_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM2_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM2_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM2_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM2_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM2_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM2_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM2_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM2_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM2_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM2_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM2_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM2_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM2_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM2_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM2_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM2_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM2_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM2_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM2_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM2_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM2_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM2_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM2_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM2_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM2_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM2_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM2_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM2_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM2_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM2_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM2_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM2_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM2_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM2_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM2_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM2_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM2_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM2_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM2_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM2_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM2_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM2_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM2_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM2_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM2_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM2_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM2_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM2_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM2_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM2_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM2_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM2_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM2_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM2_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM2_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM2_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM2_S00 = 0x1

	// RAM_COM3: display memory
	// Position of S31 field.
	LCD_RAM_COM3_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM3_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM3_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM3_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM3_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM3_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM3_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM3_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM3_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM3_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM3_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM3_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM3_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM3_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM3_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM3_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM3_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM3_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM3_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM3_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM3_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM3_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM3_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM3_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM3_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM3_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM3_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM3_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM3_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM3_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM3_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM3_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM3_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM3_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM3_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM3_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM3_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM3_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM3_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM3_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM3_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM3_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM3_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM3_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM3_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM3_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM3_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM3_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM3_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM3_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM3_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM3_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM3_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM3_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM3_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM3_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM3_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM3_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM3_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM3_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM3_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM3_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM3_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM3_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM3_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM3_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM3_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM3_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM3_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM3_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM3_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM3_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM3_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM3_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM3_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM3_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM3_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM3_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM3_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM3_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM3_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM3_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM3_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM3_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM3_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM3_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM3_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM3_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM3_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM3_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM3_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM3_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM3_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM3_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM3_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM3_S00 = 0x1

	// RAM_COM4: display memory
	// Position of S31 field.
	LCD_RAM_COM4_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM4_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM4_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM4_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM4_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM4_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM4_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM4_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM4_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM4_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM4_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM4_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM4_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM4_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM4_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM4_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM4_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM4_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM4_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM4_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM4_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM4_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM4_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM4_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM4_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM4_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM4_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM4_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM4_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM4_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM4_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM4_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM4_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM4_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM4_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM4_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM4_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM4_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM4_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM4_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM4_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM4_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM4_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM4_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM4_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM4_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM4_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM4_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM4_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM4_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM4_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM4_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM4_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM4_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM4_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM4_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM4_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM4_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM4_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM4_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM4_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM4_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM4_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM4_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM4_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM4_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM4_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM4_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM4_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM4_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM4_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM4_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM4_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM4_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM4_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM4_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM4_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM4_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM4_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM4_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM4_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM4_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM4_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM4_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM4_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM4_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM4_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM4_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM4_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM4_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM4_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM4_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM4_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM4_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM4_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM4_S00 = 0x1

	// RAM_COM5: display memory
	// Position of S31 field.
	LCD_RAM_COM5_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM5_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM5_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM5_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM5_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM5_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM5_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM5_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM5_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM5_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM5_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM5_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM5_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM5_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM5_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM5_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM5_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM5_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM5_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM5_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM5_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM5_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM5_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM5_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM5_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM5_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM5_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM5_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM5_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM5_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM5_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM5_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM5_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM5_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM5_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM5_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM5_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM5_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM5_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM5_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM5_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM5_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM5_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM5_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM5_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM5_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM5_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM5_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM5_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM5_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM5_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM5_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM5_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM5_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM5_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM5_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM5_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM5_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM5_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM5_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM5_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM5_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM5_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM5_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM5_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM5_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM5_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM5_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM5_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM5_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM5_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM5_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM5_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM5_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM5_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM5_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM5_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM5_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM5_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM5_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM5_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM5_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM5_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM5_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM5_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM5_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM5_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM5_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM5_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM5_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM5_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM5_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM5_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM5_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM5_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM5_S00 = 0x1

	// RAM_COM6: display memory
	// Position of S31 field.
	LCD_RAM_COM6_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM6_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM6_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM6_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM6_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM6_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM6_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM6_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM6_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM6_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM6_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM6_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM6_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM6_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM6_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM6_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM6_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM6_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM6_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM6_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM6_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM6_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM6_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM6_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM6_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM6_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM6_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM6_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM6_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM6_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM6_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM6_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM6_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM6_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM6_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM6_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM6_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM6_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM6_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM6_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM6_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM6_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM6_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM6_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM6_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM6_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM6_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM6_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM6_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM6_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM6_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM6_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM6_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM6_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM6_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM6_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM6_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM6_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM6_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM6_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM6_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM6_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM6_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM6_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM6_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM6_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM6_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM6_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM6_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM6_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM6_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM6_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM6_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM6_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM6_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM6_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM6_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM6_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM6_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM6_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM6_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM6_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM6_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM6_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM6_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM6_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM6_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM6_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM6_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM6_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM6_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM6_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM6_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM6_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM6_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM6_S00 = 0x1

	// RAM_COM7: display memory
	// Position of S31 field.
	LCD_RAM_COM7_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM7_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM7_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM7_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM7_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM7_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM7_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM7_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM7_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM7_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM7_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM7_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM7_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM7_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM7_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM7_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM7_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM7_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM7_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM7_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM7_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM7_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM7_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM7_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM7_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM7_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM7_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM7_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM7_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM7_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM7_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM7_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM7_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM7_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM7_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM7_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM7_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM7_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM7_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM7_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM7_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM7_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM7_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM7_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM7_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM7_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM7_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM7_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM7_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM7_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM7_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM7_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM7_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM7_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM7_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM7_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM7_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM7_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM7_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM7_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM7_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM7_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM7_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM7_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM7_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM7_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM7_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM7_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM7_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM7_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM7_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM7_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM7_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM7_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM7_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM7_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM7_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM7_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM7_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM7_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM7_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM7_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM7_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM7_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM7_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM7_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM7_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM7_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM7_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM7_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM7_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM7_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM7_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM7_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM7_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM7_S00 = 0x1
)

// Bitfields for TSC: Touch sensing controller
const (
	// CR: control register
	// Position of CTPH field.
	TSC_CR_CTPH_Pos = 0x1c
	// Bit mask of CTPH field.
	TSC_CR_CTPH_Msk = 0xf0000000
	// Position of CTPL field.
	TSC_CR_CTPL_Pos = 0x18
	// Bit mask of CTPL field.
	TSC_CR_CTPL_Msk = 0xf000000
	// Position of SSD field.
	TSC_CR_SSD_Pos = 0x11
	// Bit mask of SSD field.
	TSC_CR_SSD_Msk = 0xfe0000
	// Position of SSE field.
	TSC_CR_SSE_Pos = 0x10
	// Bit mask of SSE field.
	TSC_CR_SSE_Msk = 0x10000
	// Bit SSE.
	TSC_CR_SSE = 0x10000
	// Position of SSPSC field.
	TSC_CR_SSPSC_Pos = 0xf
	// Bit mask of SSPSC field.
	TSC_CR_SSPSC_Msk = 0x8000
	// Bit SSPSC.
	TSC_CR_SSPSC = 0x8000
	// Position of PGPSC field.
	TSC_CR_PGPSC_Pos = 0xc
	// Bit mask of PGPSC field.
	TSC_CR_PGPSC_Msk = 0x7000
	// Position of MCV field.
	TSC_CR_MCV_Pos = 0x5
	// Bit mask of MCV field.
	TSC_CR_MCV_Msk = 0xe0
	// Position of IODEF field.
	TSC_CR_IODEF_Pos = 0x4
	// Bit mask of IODEF field.
	TSC_CR_IODEF_Msk = 0x10
	// Bit IODEF.
	TSC_CR_IODEF = 0x10
	// Position of SYNCPOL field.
	TSC_CR_SYNCPOL_Pos = 0x3
	// Bit mask of SYNCPOL field.
	TSC_CR_SYNCPOL_Msk = 0x8
	// Bit SYNCPOL.
	TSC_CR_SYNCPOL = 0x8
	// Position of AM field.
	TSC_CR_AM_Pos = 0x2
	// Bit mask of AM field.
	TSC_CR_AM_Msk = 0x4
	// Bit AM.
	TSC_CR_AM = 0x4
	// Position of START field.
	TSC_CR_START_Pos = 0x1
	// Bit mask of START field.
	TSC_CR_START_Msk = 0x2
	// Bit START.
	TSC_CR_START = 0x2
	// Position of TSCE field.
	TSC_CR_TSCE_Pos = 0x0
	// Bit mask of TSCE field.
	TSC_CR_TSCE_Msk = 0x1
	// Bit TSCE.
	TSC_CR_TSCE = 0x1

	// IER: interrupt enable register
	// Position of MCEIE field.
	TSC_IER_MCEIE_Pos = 0x1
	// Bit mask of MCEIE field.
	TSC_IER_MCEIE_Msk = 0x2
	// Bit MCEIE.
	TSC_IER_MCEIE = 0x2
	// Position of EOAIE field.
	TSC_IER_EOAIE_Pos = 0x0
	// Bit mask of EOAIE field.
	TSC_IER_EOAIE_Msk = 0x1
	// Bit EOAIE.
	TSC_IER_EOAIE = 0x1

	// ICR: interrupt clear register
	// Position of MCEIC field.
	TSC_ICR_MCEIC_Pos = 0x1
	// Bit mask of MCEIC field.
	TSC_ICR_MCEIC_Msk = 0x2
	// Bit MCEIC.
	TSC_ICR_MCEIC = 0x2
	// Position of EOAIC field.
	TSC_ICR_EOAIC_Pos = 0x0
	// Bit mask of EOAIC field.
	TSC_ICR_EOAIC_Msk = 0x1
	// Bit EOAIC.
	TSC_ICR_EOAIC = 0x1

	// ISR: interrupt status register
	// Position of MCEF field.
	TSC_ISR_MCEF_Pos = 0x1
	// Bit mask of MCEF field.
	TSC_ISR_MCEF_Msk = 0x2
	// Bit MCEF.
	TSC_ISR_MCEF = 0x2
	// Position of EOAF field.
	TSC_ISR_EOAF_Pos = 0x0
	// Bit mask of EOAF field.
	TSC_ISR_EOAF_Msk = 0x1
	// Bit EOAF.
	TSC_ISR_EOAF = 0x1

	// IOHCR: I/O hysteresis control register
	// Position of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOHCR_G8_IO4 = 0x80000000
	// Position of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOHCR_G8_IO3 = 0x40000000
	// Position of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOHCR_G8_IO2 = 0x20000000
	// Position of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOHCR_G8_IO1 = 0x10000000
	// Position of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOHCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOHCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOHCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOHCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOHCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOHCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOHCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOHCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOHCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOHCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOHCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOHCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOHCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOHCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOHCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOHCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOHCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOHCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOHCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOHCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOHCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOHCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOHCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOHCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOHCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOHCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOHCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOHCR_G1_IO1 = 0x1

	// IOASCR: I/O analog switch control register
	// Position of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOASCR_G8_IO4 = 0x80000000
	// Position of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOASCR_G8_IO3 = 0x40000000
	// Position of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOASCR_G8_IO2 = 0x20000000
	// Position of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOASCR_G8_IO1 = 0x10000000
	// Position of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOASCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOASCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOASCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOASCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOASCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOASCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOASCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOASCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOASCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOASCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOASCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOASCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOASCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOASCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOASCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOASCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOASCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOASCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOASCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOASCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOASCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOASCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOASCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOASCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOASCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOASCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOASCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOASCR_G1_IO1 = 0x1

	// IOSCR: I/O sampling control register
	// Position of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOSCR_G8_IO4 = 0x80000000
	// Position of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOSCR_G8_IO3 = 0x40000000
	// Position of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOSCR_G8_IO2 = 0x20000000
	// Position of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOSCR_G8_IO1 = 0x10000000
	// Position of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOSCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOSCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOSCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOSCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOSCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOSCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOSCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOSCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOSCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOSCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOSCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOSCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOSCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOSCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOSCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOSCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOSCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOSCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOSCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOSCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOSCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOSCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOSCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOSCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOSCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOSCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOSCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOSCR_G1_IO1 = 0x1

	// IOCCR: I/O channel control register
	// Position of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOCCR_G8_IO4 = 0x80000000
	// Position of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOCCR_G8_IO3 = 0x40000000
	// Position of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOCCR_G8_IO2 = 0x20000000
	// Position of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOCCR_G8_IO1 = 0x10000000
	// Position of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOCCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOCCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOCCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOCCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOCCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOCCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOCCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOCCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOCCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOCCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOCCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOCCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOCCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOCCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOCCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOCCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOCCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOCCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOCCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOCCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOCCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOCCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOCCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOCCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOCCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOCCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOCCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOCCR_G1_IO1 = 0x1

	// IOGCSR: I/O group control status register
	// Position of G8S field.
	TSC_IOGCSR_G8S_Pos = 0x17
	// Bit mask of G8S field.
	TSC_IOGCSR_G8S_Msk = 0x800000
	// Bit G8S.
	TSC_IOGCSR_G8S = 0x800000
	// Position of G7S field.
	TSC_IOGCSR_G7S_Pos = 0x16
	// Bit mask of G7S field.
	TSC_IOGCSR_G7S_Msk = 0x400000
	// Bit G7S.
	TSC_IOGCSR_G7S = 0x400000
	// Position of G6S field.
	TSC_IOGCSR_G6S_Pos = 0x15
	// Bit mask of G6S field.
	TSC_IOGCSR_G6S_Msk = 0x200000
	// Bit G6S.
	TSC_IOGCSR_G6S = 0x200000
	// Position of G5S field.
	TSC_IOGCSR_G5S_Pos = 0x14
	// Bit mask of G5S field.
	TSC_IOGCSR_G5S_Msk = 0x100000
	// Bit G5S.
	TSC_IOGCSR_G5S = 0x100000
	// Position of G4S field.
	TSC_IOGCSR_G4S_Pos = 0x13
	// Bit mask of G4S field.
	TSC_IOGCSR_G4S_Msk = 0x80000
	// Bit G4S.
	TSC_IOGCSR_G4S = 0x80000
	// Position of G3S field.
	TSC_IOGCSR_G3S_Pos = 0x12
	// Bit mask of G3S field.
	TSC_IOGCSR_G3S_Msk = 0x40000
	// Bit G3S.
	TSC_IOGCSR_G3S = 0x40000
	// Position of G2S field.
	TSC_IOGCSR_G2S_Pos = 0x11
	// Bit mask of G2S field.
	TSC_IOGCSR_G2S_Msk = 0x20000
	// Bit G2S.
	TSC_IOGCSR_G2S = 0x20000
	// Position of G1S field.
	TSC_IOGCSR_G1S_Pos = 0x10
	// Bit mask of G1S field.
	TSC_IOGCSR_G1S_Msk = 0x10000
	// Bit G1S.
	TSC_IOGCSR_G1S = 0x10000
	// Position of G8E field.
	TSC_IOGCSR_G8E_Pos = 0x7
	// Bit mask of G8E field.
	TSC_IOGCSR_G8E_Msk = 0x80
	// Bit G8E.
	TSC_IOGCSR_G8E = 0x80
	// Position of G7E field.
	TSC_IOGCSR_G7E_Pos = 0x6
	// Bit mask of G7E field.
	TSC_IOGCSR_G7E_Msk = 0x40
	// Bit G7E.
	TSC_IOGCSR_G7E = 0x40
	// Position of G6E field.
	TSC_IOGCSR_G6E_Pos = 0x5
	// Bit mask of G6E field.
	TSC_IOGCSR_G6E_Msk = 0x20
	// Bit G6E.
	TSC_IOGCSR_G6E = 0x20
	// Position of G5E field.
	TSC_IOGCSR_G5E_Pos = 0x4
	// Bit mask of G5E field.
	TSC_IOGCSR_G5E_Msk = 0x10
	// Bit G5E.
	TSC_IOGCSR_G5E = 0x10
	// Position of G4E field.
	TSC_IOGCSR_G4E_Pos = 0x3
	// Bit mask of G4E field.
	TSC_IOGCSR_G4E_Msk = 0x8
	// Bit G4E.
	TSC_IOGCSR_G4E = 0x8
	// Position of G3E field.
	TSC_IOGCSR_G3E_Pos = 0x2
	// Bit mask of G3E field.
	TSC_IOGCSR_G3E_Msk = 0x4
	// Bit G3E.
	TSC_IOGCSR_G3E = 0x4
	// Position of G2E field.
	TSC_IOGCSR_G2E_Pos = 0x1
	// Bit mask of G2E field.
	TSC_IOGCSR_G2E_Msk = 0x2
	// Bit G2E.
	TSC_IOGCSR_G2E = 0x2
	// Position of G1E field.
	TSC_IOGCSR_G1E_Pos = 0x0
	// Bit mask of G1E field.
	TSC_IOGCSR_G1E_Msk = 0x1
	// Bit G1E.
	TSC_IOGCSR_G1E = 0x1

	// IOG1CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOGCR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOGCR_CNT_Msk = 0x3fff
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of WVU field.
	IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_SR_WVU = 0x4
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Bitfields for WWDG: System window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0x7
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Bitfields for COMP: Comparator
const (
	// COMP1_CSR: Comparator 1 control and status register
	// Position of COMP1_EN field.
	COMP_COMP1_CSR_COMP1_EN_Pos = 0x0
	// Bit mask of COMP1_EN field.
	COMP_COMP1_CSR_COMP1_EN_Msk = 0x1
	// Bit COMP1_EN.
	COMP_COMP1_CSR_COMP1_EN = 0x1
	// Position of COMP1_PWRMODE field.
	COMP_COMP1_CSR_COMP1_PWRMODE_Pos = 0x2
	// Bit mask of COMP1_PWRMODE field.
	COMP_COMP1_CSR_COMP1_PWRMODE_Msk = 0xc
	// Position of COMP1_INMSEL field.
	COMP_COMP1_CSR_COMP1_INMSEL_Pos = 0x4
	// Bit mask of COMP1_INMSEL field.
	COMP_COMP1_CSR_COMP1_INMSEL_Msk = 0x70
	// Position of COMP1_INPSEL field.
	COMP_COMP1_CSR_COMP1_INPSEL_Pos = 0x7
	// Bit mask of COMP1_INPSEL field.
	COMP_COMP1_CSR_COMP1_INPSEL_Msk = 0x80
	// Bit COMP1_INPSEL.
	COMP_COMP1_CSR_COMP1_INPSEL = 0x80
	// Position of COMP1_POLARITY field.
	COMP_COMP1_CSR_COMP1_POLARITY_Pos = 0xf
	// Bit mask of COMP1_POLARITY field.
	COMP_COMP1_CSR_COMP1_POLARITY_Msk = 0x8000
	// Bit COMP1_POLARITY.
	COMP_COMP1_CSR_COMP1_POLARITY = 0x8000
	// Position of COMP1_HYST field.
	COMP_COMP1_CSR_COMP1_HYST_Pos = 0x10
	// Bit mask of COMP1_HYST field.
	COMP_COMP1_CSR_COMP1_HYST_Msk = 0x30000
	// Position of COMP1_BLANKING field.
	COMP_COMP1_CSR_COMP1_BLANKING_Pos = 0x12
	// Bit mask of COMP1_BLANKING field.
	COMP_COMP1_CSR_COMP1_BLANKING_Msk = 0x1c0000
	// Position of COMP1_BRGEN field.
	COMP_COMP1_CSR_COMP1_BRGEN_Pos = 0x16
	// Bit mask of COMP1_BRGEN field.
	COMP_COMP1_CSR_COMP1_BRGEN_Msk = 0x400000
	// Bit COMP1_BRGEN.
	COMP_COMP1_CSR_COMP1_BRGEN = 0x400000
	// Position of COMP1_SCALEN field.
	COMP_COMP1_CSR_COMP1_SCALEN_Pos = 0x17
	// Bit mask of COMP1_SCALEN field.
	COMP_COMP1_CSR_COMP1_SCALEN_Msk = 0x800000
	// Bit COMP1_SCALEN.
	COMP_COMP1_CSR_COMP1_SCALEN = 0x800000
	// Position of COMP1_VALUE field.
	COMP_COMP1_CSR_COMP1_VALUE_Pos = 0x1e
	// Bit mask of COMP1_VALUE field.
	COMP_COMP1_CSR_COMP1_VALUE_Msk = 0x40000000
	// Bit COMP1_VALUE.
	COMP_COMP1_CSR_COMP1_VALUE = 0x40000000
	// Position of COMP1_LOCK field.
	COMP_COMP1_CSR_COMP1_LOCK_Pos = 0x1f
	// Bit mask of COMP1_LOCK field.
	COMP_COMP1_CSR_COMP1_LOCK_Msk = 0x80000000
	// Bit COMP1_LOCK.
	COMP_COMP1_CSR_COMP1_LOCK = 0x80000000

	// COMP2_CSR: Comparator 2 control and status register
	// Position of COMP2_EN field.
	COMP_COMP2_CSR_COMP2_EN_Pos = 0x0
	// Bit mask of COMP2_EN field.
	COMP_COMP2_CSR_COMP2_EN_Msk = 0x1
	// Bit COMP2_EN.
	COMP_COMP2_CSR_COMP2_EN = 0x1
	// Position of COMP2_PWRMODE field.
	COMP_COMP2_CSR_COMP2_PWRMODE_Pos = 0x2
	// Bit mask of COMP2_PWRMODE field.
	COMP_COMP2_CSR_COMP2_PWRMODE_Msk = 0xc
	// Position of COMP2_INMSEL field.
	COMP_COMP2_CSR_COMP2_INMSEL_Pos = 0x4
	// Bit mask of COMP2_INMSEL field.
	COMP_COMP2_CSR_COMP2_INMSEL_Msk = 0x70
	// Position of COMP2_INPSEL field.
	COMP_COMP2_CSR_COMP2_INPSEL_Pos = 0x7
	// Bit mask of COMP2_INPSEL field.
	COMP_COMP2_CSR_COMP2_INPSEL_Msk = 0x80
	// Bit COMP2_INPSEL.
	COMP_COMP2_CSR_COMP2_INPSEL = 0x80
	// Position of COMP2_WINMODE field.
	COMP_COMP2_CSR_COMP2_WINMODE_Pos = 0x9
	// Bit mask of COMP2_WINMODE field.
	COMP_COMP2_CSR_COMP2_WINMODE_Msk = 0x200
	// Bit COMP2_WINMODE.
	COMP_COMP2_CSR_COMP2_WINMODE = 0x200
	// Position of COMP2_POLARITY field.
	COMP_COMP2_CSR_COMP2_POLARITY_Pos = 0xf
	// Bit mask of COMP2_POLARITY field.
	COMP_COMP2_CSR_COMP2_POLARITY_Msk = 0x8000
	// Bit COMP2_POLARITY.
	COMP_COMP2_CSR_COMP2_POLARITY = 0x8000
	// Position of COMP2_HYST field.
	COMP_COMP2_CSR_COMP2_HYST_Pos = 0x10
	// Bit mask of COMP2_HYST field.
	COMP_COMP2_CSR_COMP2_HYST_Msk = 0x30000
	// Position of COMP2_BLANKING field.
	COMP_COMP2_CSR_COMP2_BLANKING_Pos = 0x12
	// Bit mask of COMP2_BLANKING field.
	COMP_COMP2_CSR_COMP2_BLANKING_Msk = 0x1c0000
	// Position of COMP2_BRGEN field.
	COMP_COMP2_CSR_COMP2_BRGEN_Pos = 0x16
	// Bit mask of COMP2_BRGEN field.
	COMP_COMP2_CSR_COMP2_BRGEN_Msk = 0x400000
	// Bit COMP2_BRGEN.
	COMP_COMP2_CSR_COMP2_BRGEN = 0x400000
	// Position of COMP2_SCALEN field.
	COMP_COMP2_CSR_COMP2_SCALEN_Pos = 0x17
	// Bit mask of COMP2_SCALEN field.
	COMP_COMP2_CSR_COMP2_SCALEN_Msk = 0x800000
	// Bit COMP2_SCALEN.
	COMP_COMP2_CSR_COMP2_SCALEN = 0x800000
	// Position of COMP2_VALUE field.
	COMP_COMP2_CSR_COMP2_VALUE_Pos = 0x1e
	// Bit mask of COMP2_VALUE field.
	COMP_COMP2_CSR_COMP2_VALUE_Msk = 0x40000000
	// Bit COMP2_VALUE.
	COMP_COMP2_CSR_COMP2_VALUE = 0x40000000
	// Position of COMP2_LOCK field.
	COMP_COMP2_CSR_COMP2_LOCK_Pos = 0x1f
	// Bit mask of COMP2_LOCK field.
	COMP_COMP2_CSR_COMP2_LOCK_Msk = 0x80000000
	// Bit COMP2_LOCK.
	COMP_COMP2_CSR_COMP2_LOCK = 0x80000000
)

// Bitfields for FIREWALL: Firewall
const (
	// CSSA: Code segment start address
	// Position of ADD field.
	Firewall_CSSA_ADD_Pos = 0x8
	// Bit mask of ADD field.
	Firewall_CSSA_ADD_Msk = 0xffff00

	// CSL: Code segment length
	// Position of LENG field.
	Firewall_CSL_LENG_Pos = 0x8
	// Bit mask of LENG field.
	Firewall_CSL_LENG_Msk = 0x3fff00

	// NVDSSA: Non-volatile data segment start address
	// Position of ADD field.
	Firewall_NVDSSA_ADD_Pos = 0x8
	// Bit mask of ADD field.
	Firewall_NVDSSA_ADD_Msk = 0xffff00

	// NVDSL: Non-volatile data segment length
	// Position of LENG field.
	Firewall_NVDSL_LENG_Pos = 0x8
	// Bit mask of LENG field.
	Firewall_NVDSL_LENG_Msk = 0x3fff00

	// VDSSA: Volatile data segment start address
	// Position of ADD field.
	Firewall_VDSSA_ADD_Pos = 0x6
	// Bit mask of ADD field.
	Firewall_VDSSA_ADD_Msk = 0xffc0

	// VDSL: Volatile data segment length
	// Position of LENG field.
	Firewall_VDSL_LENG_Pos = 0x6
	// Bit mask of LENG field.
	Firewall_VDSL_LENG_Msk = 0xffc0

	// CR: Configuration register
	// Position of VDE field.
	Firewall_CR_VDE_Pos = 0x2
	// Bit mask of VDE field.
	Firewall_CR_VDE_Msk = 0x4
	// Bit VDE.
	Firewall_CR_VDE = 0x4
	// Position of VDS field.
	Firewall_CR_VDS_Pos = 0x1
	// Bit mask of VDS field.
	Firewall_CR_VDS_Msk = 0x2
	// Bit VDS.
	Firewall_CR_VDS = 0x2
	// Position of FPA field.
	Firewall_CR_FPA_Pos = 0x0
	// Bit mask of FPA field.
	Firewall_CR_FPA_Msk = 0x1
	// Bit FPA.
	Firewall_CR_FPA = 0x1
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Transmit (TXIS) interrupt disabled
	I2C_CR1_TXIE_Disabled = 0x0
	// Transmit (TXIS) interrupt enabled
	I2C_CR1_TXIE_Enabled = 0x1
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Receive (RXNE) interrupt disabled
	I2C_CR1_RXIE_Disabled = 0x0
	// Receive (RXNE) interrupt enabled
	I2C_CR1_RXIE_Enabled = 0x1
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Address match (ADDR) interrupts disabled
	I2C_CR1_ADDRIE_Disabled = 0x0
	// Address match (ADDR) interrupts enabled
	I2C_CR1_ADDRIE_Enabled = 0x1
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Not acknowledge (NACKF) received interrupts disabled
	I2C_CR1_NACKIE_Disabled = 0x0
	// Not acknowledge (NACKF) received interrupts enabled
	I2C_CR1_NACKIE_Enabled = 0x1
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Stop detection (STOPF) interrupt disabled
	I2C_CR1_STOPIE_Disabled = 0x0
	// Stop detection (STOPF) interrupt enabled
	I2C_CR1_STOPIE_Enabled = 0x1
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Transfer Complete interrupt disabled
	I2C_CR1_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	I2C_CR1_TCIE_Enabled = 0x1
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Error detection interrupts disabled
	I2C_CR1_ERRIE_Disabled = 0x0
	// Error detection interrupts enabled
	I2C_CR1_ERRIE_Enabled = 0x1
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Digital filter disabled
	I2C_CR1_DNF_NoFilter = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_CR1_DNF_Filter1 = 0x1
	// Digital filter enabled and filtering capability up to 2 tI2CCLK
	I2C_CR1_DNF_Filter2 = 0x2
	// Digital filter enabled and filtering capability up to 3 tI2CCLK
	I2C_CR1_DNF_Filter3 = 0x3
	// Digital filter enabled and filtering capability up to 4 tI2CCLK
	I2C_CR1_DNF_Filter4 = 0x4
	// Digital filter enabled and filtering capability up to 5 tI2CCLK
	I2C_CR1_DNF_Filter5 = 0x5
	// Digital filter enabled and filtering capability up to 6 tI2CCLK
	I2C_CR1_DNF_Filter6 = 0x6
	// Digital filter enabled and filtering capability up to 7 tI2CCLK
	I2C_CR1_DNF_Filter7 = 0x7
	// Digital filter enabled and filtering capability up to 8 tI2CCLK
	I2C_CR1_DNF_Filter8 = 0x8
	// Digital filter enabled and filtering capability up to 9 tI2CCLK
	I2C_CR1_DNF_Filter9 = 0x9
	// Digital filter enabled and filtering capability up to 10 tI2CCLK
	I2C_CR1_DNF_Filter10 = 0xa
	// Digital filter enabled and filtering capability up to 11 tI2CCLK
	I2C_CR1_DNF_Filter11 = 0xb
	// Digital filter enabled and filtering capability up to 12 tI2CCLK
	I2C_CR1_DNF_Filter12 = 0xc
	// Digital filter enabled and filtering capability up to 13 tI2CCLK
	I2C_CR1_DNF_Filter13 = 0xd
	// Digital filter enabled and filtering capability up to 14 tI2CCLK
	I2C_CR1_DNF_Filter14 = 0xe
	// Digital filter enabled and filtering capability up to 15 tI2CCLK
	I2C_CR1_DNF_Filter15 = 0xf
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Analog noise filter enabled
	I2C_CR1_ANFOFF_Enabled = 0x0
	// Analog noise filter disabled
	I2C_CR1_ANFOFF_Disabled = 0x1
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// DMA mode disabled for transmission
	I2C_CR1_TXDMAEN_Disabled = 0x0
	// DMA mode enabled for transmission
	I2C_CR1_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// DMA mode disabled for reception
	I2C_CR1_RXDMAEN_Disabled = 0x0
	// DMA mode enabled for reception
	I2C_CR1_RXDMAEN_Enabled = 0x1
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Slave byte control disabled
	I2C_CR1_SBC_Disabled = 0x0
	// Slave byte control enabled
	I2C_CR1_SBC_Enabled = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of WUPEN field.
	I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_CR1_WUPEN = 0x40000
	// Wakeup from Stop mode disabled
	I2C_CR1_WUPEN_Disabled = 0x0
	// Wakeup from Stop mode enabled
	I2C_CR1_WUPEN_Enabled = 0x1
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// General call disabled. Address 0b00000000 is NACKed
	I2C_CR1_GCEN_Disabled = 0x0
	// General call enabled. Address 0b00000000 is ACKed
	I2C_CR1_GCEN_Enabled = 0x1
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Host address disabled. Address 0b0001000x is NACKed
	I2C_CR1_SMBHEN_Disabled = 0x0
	// Host address enabled. Address 0b0001000x is ACKed
	I2C_CR1_SMBHEN_Enabled = 0x1
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Device default address disabled. Address 0b1100001x is NACKed
	I2C_CR1_SMBDEN_Disabled = 0x0
	// Device default address enabled. Address 0b1100001x is ACKed
	I2C_CR1_SMBDEN_Enabled = 0x1
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// In device mode (SMBHEN=Disabled) Releases SMBA pin high and Alert Response Address Header disabled (0001100x) followed by NACK. In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) not supported
	I2C_CR1_ALERTEN_Disabled = 0x0
	// In device mode (SMBHEN=Disabled) Drives SMBA pin low and Alert Response Address Header enabled (0001100x) followed by ACK.In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) supported
	I2C_CR1_ALERTEN_Enabled = 0x1
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000
	// PEC calculation disabled
	I2C_CR1_PECEN_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_PECEN_Enabled = 0x1

	// CR2: Control register 2
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// No PEC transfer
	I2C_CR2_PECBYTE_NoPec = 0x0
	// PEC transmission/reception is requested
	I2C_CR2_PECBYTE_Pec = 0x1
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// Software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low
	I2C_CR2_AUTOEND_Software = 0x0
	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred
	I2C_CR2_AUTOEND_Automatic = 0x1
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// The transfer is completed after the NBYTES data transfer (STOP or RESTART will follow)
	I2C_CR2_RELOAD_Completed = 0x0
	// The transfer is not completed after the NBYTES data transfer (NBYTES will be reloaded)
	I2C_CR2_RELOAD_NotCompleted = 0x1
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// an ACK is sent after current received byte
	I2C_CR2_NACK_Ack = 0x0
	// a NACK is sent after current received byte
	I2C_CR2_NACK_Nack = 0x1
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// No Stop generation
	I2C_CR2_STOP_NoStop = 0x0
	// Stop generation after current byte transfer
	I2C_CR2_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// No Start generation
	I2C_CR2_START_NoStart = 0x0
	// Restart/Start generation
	I2C_CR2_START_Start = 0x1
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// The master sends the complete 10 bit slave address read sequence
	I2C_CR2_HEAD10R_Complete = 0x0
	// The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction
	I2C_CR2_HEAD10R_Partial = 0x1
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// The master operates in 7-bit addressing mode
	I2C_CR2_ADD10_Bit7 = 0x0
	// The master operates in 10-bit addressing mode
	I2C_CR2_ADD10_Bit10 = 0x1
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Master requests a write transfer
	I2C_CR2_RD_WRN_Write = 0x0
	// Master requests a read transfer
	I2C_CR2_RD_WRN_Read = 0x1
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff

	// OAR1: Own address register 1
	// Position of OA1 field.
	I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_OAR1_OA1_Msk = 0x3ff
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Own address 1 is a 7-bit address
	I2C_OAR1_OA1MODE_Bit7 = 0x0
	// Own address 1 is a 10-bit address
	I2C_OAR1_OA1MODE_Bit10 = 0x1
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000
	// Own address 1 disabled. The received slave address OA1 is NACKed
	I2C_OAR1_OA1EN_Disabled = 0x0
	// Own address 1 enabled. The received slave address OA1 is ACKed
	I2C_OAR1_OA1EN_Enabled = 0x1

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// No mask
	I2C_OAR2_OA2MSK_NoMask = 0x0
	// OA2[1] is masked and don’t care. Only OA2[7:2] are compared
	I2C_OAR2_OA2MSK_Mask1 = 0x1
	// OA2[2:1] are masked and don’t care. Only OA2[7:3] are compared
	I2C_OAR2_OA2MSK_Mask2 = 0x2
	// OA2[3:1] are masked and don’t care. Only OA2[7:4] are compared
	I2C_OAR2_OA2MSK_Mask3 = 0x3
	// OA2[4:1] are masked and don’t care. Only OA2[7:5] are compared
	I2C_OAR2_OA2MSK_Mask4 = 0x4
	// OA2[5:1] are masked and don’t care. Only OA2[7:6] are compared
	I2C_OAR2_OA2MSK_Mask5 = 0x5
	// OA2[6:1] are masked and don’t care. Only OA2[7] is compared.
	I2C_OAR2_OA2MSK_Mask6 = 0x6
	// OA2[7:1] are masked and don’t care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged
	I2C_OAR2_OA2MSK_Mask7 = 0x7
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000
	// Own address 2 disabled. The received slave address OA2 is NACKed
	I2C_OAR2_OA2EN_Disabled = 0x0
	// Own address 2 enabled. The received slave address OA2 is ACKed
	I2C_OAR2_OA2EN_Enabled = 0x1

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// TIMEOUTA is used to detect SCL low timeout
	I2C_TIMEOUTR_TIDLE_Disabled = 0x0
	// TIMEOUTA is used to detect both SCL and SDA high timeout (bus idle condition)
	I2C_TIMEOUTR_TIDLE_Enabled = 0x1
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// SCL timeout detection is disabled
	I2C_TIMEOUTR_TIMOUTEN_Disabled = 0x0
	// SCL timeout detection is enabled
	I2C_TIMEOUTR_TIMOUTEN_Enabled = 0x1
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000
	// Extended clock timeout detection is disabled
	I2C_TIMEOUTR_TEXTEN_Disabled = 0x0
	// Extended clock timeout detection is enabled
	I2C_TIMEOUTR_TEXTEN_Enabled = 0x1

	// ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Write transfer, slave enters receiver mode
	I2C_ISR_DIR_Write = 0x0
	// Read transfer, slave enters transmitter mode
	I2C_ISR_DIR_Read = 0x1
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// No communication is in progress on the bus
	I2C_ISR_BUSY_NotBusy = 0x0
	// A communication is in progress on the bus
	I2C_ISR_BUSY_Busy = 0x1
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// SMBA alert is not detected
	I2C_ISR_ALERT_NoAlert = 0x0
	// SMBA alert event is detected on SMBA pin
	I2C_ISR_ALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// No timeout occured
	I2C_ISR_TIMEOUT_NoTimeout = 0x0
	// Timeout occured
	I2C_ISR_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Received PEC does match with PEC register
	I2C_ISR_PECERR_Match = 0x0
	// Received PEC does not match with PEC register
	I2C_ISR_PECERR_NoMatch = 0x1
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// No overrun/underrun error occurs
	I2C_ISR_OVR_NoOverrun = 0x0
	// slave mode with NOSTRETCH=1, when an overrun/underrun error occurs
	I2C_ISR_OVR_Overrun = 0x1
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// No arbitration lost
	I2C_ISR_ARLO_NotLost = 0x0
	// Arbitration lost
	I2C_ISR_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// No bus error
	I2C_ISR_BERR_NoError = 0x0
	// Misplaced Start and Stop condition is detected
	I2C_ISR_BERR_Error = 0x1
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Transfer is not complete
	I2C_ISR_TCR_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TCR_Complete = 0x1
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Transfer is not complete
	I2C_ISR_TC_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TC_Complete = 0x1
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// No Stop condition detected
	I2C_ISR_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_ISR_STOPF_Stop = 0x1
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// No NACK has been received
	I2C_ISR_NACKF_NoNack = 0x0
	// NACK has been received
	I2C_ISR_NACKF_Nack = 0x1
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Adress mismatched or not received
	I2C_ISR_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_ISR_ADDR_Match = 0x1
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// The RXDR register is empty
	I2C_ISR_RXNE_Empty = 0x0
	// Received data is copied into the RXDR register, and is ready to be read
	I2C_ISR_RXNE_NotEmpty = 0x1
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// The TXDR register is not empty
	I2C_ISR_TXIS_NotEmpty = 0x0
	// The TXDR register is empty and the data to be transmitted must be written in the TXDR register
	I2C_ISR_TXIS_Empty = 0x1
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1
	// TXDR register not empty
	I2C_ISR_TXE_NotEmpty = 0x0
	// TXDR register empty
	I2C_ISR_TXE_Empty = 0x1

	// ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Clears the ALERT flag in ISR register
	I2C_ICR_ALERTCF_Clear = 0x1
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Clears the TIMOUT flag in ISR register
	I2C_ICR_TIMOUTCF_Clear = 0x1
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Clears the PEC flag in ISR register
	I2C_ICR_PECCF_Clear = 0x1
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Clears the OVR flag in ISR register
	I2C_ICR_OVRCF_Clear = 0x1
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Clears the ARLO flag in ISR register
	I2C_ICR_ARLOCF_Clear = 0x1
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Clears the BERR flag in ISR register
	I2C_ICR_BERRCF_Clear = 0x1
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Clears the STOP flag in ISR register
	I2C_ICR_STOPCF_Clear = 0x1
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Clears the NACK flag in ISR register
	I2C_ICR_NACKCF_Clear = 0x1
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8
	// Clears the ADDR flag in ISR register
	I2C_ICR_ADDRCF_Clear = 0x1

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Bitfields for FLASH: Flash
const (
	// ACR: Access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7
	// Position of PRFTEN field.
	Flash_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	Flash_ACR_PRFTEN = 0x100
	// Position of ICEN field.
	Flash_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	Flash_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	Flash_ACR_ICEN = 0x200
	// Position of DCEN field.
	Flash_ACR_DCEN_Pos = 0xa
	// Bit mask of DCEN field.
	Flash_ACR_DCEN_Msk = 0x400
	// Bit DCEN.
	Flash_ACR_DCEN = 0x400
	// Position of ICRST field.
	Flash_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	Flash_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	Flash_ACR_ICRST = 0x800
	// Position of DCRST field.
	Flash_ACR_DCRST_Pos = 0xc
	// Bit mask of DCRST field.
	Flash_ACR_DCRST_Msk = 0x1000
	// Bit DCRST.
	Flash_ACR_DCRST = 0x1000
	// Position of RUN_PD field.
	Flash_ACR_RUN_PD_Pos = 0xd
	// Bit mask of RUN_PD field.
	Flash_ACR_RUN_PD_Msk = 0x2000
	// Bit RUN_PD.
	Flash_ACR_RUN_PD = 0x2000
	// Position of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Pos = 0xe
	// Bit mask of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Msk = 0x4000
	// Bit SLEEP_PD.
	Flash_ACR_SLEEP_PD = 0x4000

	// PDKEYR: Power down key register
	// Position of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Pos = 0x0
	// Bit mask of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Msk = 0xffffffff

	// KEYR: Flash key register
	// Position of KEYR field.
	Flash_KEYR_KEYR_Pos = 0x0
	// Bit mask of KEYR field.
	Flash_KEYR_KEYR_Msk = 0xffffffff

	// OPTKEYR: Option byte key register
	// Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x1
	// Bit EOP.
	Flash_SR_EOP = 0x1
	// Position of OPERR field.
	Flash_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	Flash_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	Flash_SR_OPERR = 0x2
	// Position of PROGERR field.
	Flash_SR_PROGERR_Pos = 0x3
	// Bit mask of PROGERR field.
	Flash_SR_PROGERR_Msk = 0x8
	// Bit PROGERR.
	Flash_SR_PROGERR = 0x8
	// Position of WRPERR field.
	Flash_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	Flash_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	Flash_SR_WRPERR = 0x10
	// Position of PGAERR field.
	Flash_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	Flash_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	Flash_SR_PGAERR = 0x20
	// Position of SIZERR field.
	Flash_SR_SIZERR_Pos = 0x6
	// Bit mask of SIZERR field.
	Flash_SR_SIZERR_Msk = 0x40
	// Bit SIZERR.
	Flash_SR_SIZERR = 0x40
	// Position of PGSERR field.
	Flash_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	Flash_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	Flash_SR_PGSERR = 0x80
	// Position of MISERR field.
	Flash_SR_MISERR_Pos = 0x8
	// Bit mask of MISERR field.
	Flash_SR_MISERR_Msk = 0x100
	// Bit MISERR.
	Flash_SR_MISERR = 0x100
	// Position of FASTERR field.
	Flash_SR_FASTERR_Pos = 0x9
	// Bit mask of FASTERR field.
	Flash_SR_FASTERR_Msk = 0x200
	// Bit FASTERR.
	Flash_SR_FASTERR = 0x200
	// Position of RDERR field.
	Flash_SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_SR_RDERR = 0x4000
	// Position of OPTVERR field.
	Flash_SR_OPTVERR_Pos = 0xf
	// Bit mask of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x8000
	// Bit OPTVERR.
	Flash_SR_OPTVERR = 0x8000
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x10000
	// Bit BSY.
	Flash_SR_BSY = 0x10000

	// CR: Flash control register
	// Position of PG field.
	Flash_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_CR_PG_Msk = 0x1
	// Bit PG.
	Flash_CR_PG = 0x1
	// Position of PER field.
	Flash_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_CR_PER_Msk = 0x2
	// Bit PER.
	Flash_CR_PER = 0x2
	// Position of MER1 field.
	Flash_CR_MER1_Pos = 0x2
	// Bit mask of MER1 field.
	Flash_CR_MER1_Msk = 0x4
	// Bit MER1.
	Flash_CR_MER1 = 0x4
	// Position of PNB field.
	Flash_CR_PNB_Pos = 0x3
	// Bit mask of PNB field.
	Flash_CR_PNB_Msk = 0x7f8
	// Position of BKER field.
	Flash_CR_BKER_Pos = 0xb
	// Bit mask of BKER field.
	Flash_CR_BKER_Msk = 0x800
	// Bit BKER.
	Flash_CR_BKER = 0x800
	// Position of MER2 field.
	Flash_CR_MER2_Pos = 0xf
	// Bit mask of MER2 field.
	Flash_CR_MER2_Msk = 0x8000
	// Bit MER2.
	Flash_CR_MER2 = 0x8000
	// Position of START field.
	Flash_CR_START_Pos = 0x10
	// Bit mask of START field.
	Flash_CR_START_Msk = 0x10000
	// Bit START.
	Flash_CR_START = 0x10000
	// Position of OPTSTRT field.
	Flash_CR_OPTSTRT_Pos = 0x11
	// Bit mask of OPTSTRT field.
	Flash_CR_OPTSTRT_Msk = 0x20000
	// Bit OPTSTRT.
	Flash_CR_OPTSTRT = 0x20000
	// Position of FSTPG field.
	Flash_CR_FSTPG_Pos = 0x12
	// Bit mask of FSTPG field.
	Flash_CR_FSTPG_Msk = 0x40000
	// Bit FSTPG.
	Flash_CR_FSTPG = 0x40000
	// Position of EOPIE field.
	Flash_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	Flash_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	Flash_CR_EOPIE = 0x1000000
	// Position of ERRIE field.
	Flash_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	Flash_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	Flash_CR_ERRIE = 0x2000000
	// Position of RDERRIE field.
	Flash_CR_RDERRIE_Pos = 0x1a
	// Bit mask of RDERRIE field.
	Flash_CR_RDERRIE_Msk = 0x4000000
	// Bit RDERRIE.
	Flash_CR_RDERRIE = 0x4000000
	// Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Pos = 0x1b
	// Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x8000000
	// Bit OBL_LAUNCH.
	Flash_CR_OBL_LAUNCH = 0x8000000
	// Position of OPTLOCK field.
	Flash_CR_OPTLOCK_Pos = 0x1e
	// Bit mask of OPTLOCK field.
	Flash_CR_OPTLOCK_Msk = 0x40000000
	// Bit OPTLOCK.
	Flash_CR_OPTLOCK = 0x40000000
	// Position of LOCK field.
	Flash_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	Flash_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	Flash_CR_LOCK = 0x80000000

	// ECCR: Flash ECC register
	// Position of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Pos = 0x0
	// Bit mask of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Msk = 0x7ffff
	// Position of BK_ECC field.
	Flash_ECCR_BK_ECC_Pos = 0x13
	// Bit mask of BK_ECC field.
	Flash_ECCR_BK_ECC_Msk = 0x80000
	// Bit BK_ECC.
	Flash_ECCR_BK_ECC = 0x80000
	// Position of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Pos = 0x14
	// Bit mask of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Msk = 0x100000
	// Bit SYSF_ECC.
	Flash_ECCR_SYSF_ECC = 0x100000
	// Position of ECCIE field.
	Flash_ECCR_ECCIE_Pos = 0x18
	// Bit mask of ECCIE field.
	Flash_ECCR_ECCIE_Msk = 0x1000000
	// Bit ECCIE.
	Flash_ECCR_ECCIE = 0x1000000
	// Position of ECCC field.
	Flash_ECCR_ECCC_Pos = 0x1e
	// Bit mask of ECCC field.
	Flash_ECCR_ECCC_Msk = 0x40000000
	// Bit ECCC.
	Flash_ECCR_ECCC = 0x40000000
	// Position of ECCD field.
	Flash_ECCR_ECCD_Pos = 0x1f
	// Bit mask of ECCD field.
	Flash_ECCR_ECCD_Msk = 0x80000000
	// Bit ECCD.
	Flash_ECCR_ECCD = 0x80000000

	// OPTR: Flash option register
	// Position of RDP field.
	Flash_OPTR_RDP_Pos = 0x0
	// Bit mask of RDP field.
	Flash_OPTR_RDP_Msk = 0xff
	// Position of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Pos = 0x8
	// Bit mask of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Msk = 0x700
	// Position of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Pos = 0xc
	// Bit mask of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Msk = 0x1000
	// Bit NRST_STOP.
	Flash_OPTR_NRST_STOP = 0x1000
	// Position of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Pos = 0xd
	// Bit mask of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Msk = 0x2000
	// Bit NRST_STDBY.
	Flash_OPTR_NRST_STDBY = 0x2000
	// Position of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Pos = 0x10
	// Bit mask of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Msk = 0x10000
	// Bit IDWG_SW.
	Flash_OPTR_IDWG_SW = 0x10000
	// Position of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Pos = 0x11
	// Bit mask of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Msk = 0x20000
	// Bit IWDG_STOP.
	Flash_OPTR_IWDG_STOP = 0x20000
	// Position of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Pos = 0x12
	// Bit mask of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Msk = 0x40000
	// Bit IWDG_STDBY.
	Flash_OPTR_IWDG_STDBY = 0x40000
	// Position of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Pos = 0x13
	// Bit mask of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Msk = 0x80000
	// Bit WWDG_SW.
	Flash_OPTR_WWDG_SW = 0x80000
	// Position of BFB2 field.
	Flash_OPTR_BFB2_Pos = 0x14
	// Bit mask of BFB2 field.
	Flash_OPTR_BFB2_Msk = 0x100000
	// Bit BFB2.
	Flash_OPTR_BFB2 = 0x100000
	// Position of DUALBANK field.
	Flash_OPTR_DUALBANK_Pos = 0x15
	// Bit mask of DUALBANK field.
	Flash_OPTR_DUALBANK_Msk = 0x200000
	// Bit DUALBANK.
	Flash_OPTR_DUALBANK = 0x200000
	// Position of NBOOT1 field.
	Flash_OPTR_NBOOT1_Pos = 0x17
	// Bit mask of NBOOT1 field.
	Flash_OPTR_NBOOT1_Msk = 0x800000
	// Bit NBOOT1.
	Flash_OPTR_NBOOT1 = 0x800000
	// Position of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Pos = 0x18
	// Bit mask of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Msk = 0x1000000
	// Bit SRAM2_PE.
	Flash_OPTR_SRAM2_PE = 0x1000000
	// Position of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST_Pos = 0x19
	// Bit mask of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST_Msk = 0x2000000
	// Bit SRAM2_RST.
	Flash_OPTR_SRAM2_RST = 0x2000000
	// Position of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Pos = 0x1a
	// Bit mask of NSWBOOT0 field.
	Flash_OPTR_NSWBOOT0_Msk = 0x4000000
	// Bit NSWBOOT0.
	Flash_OPTR_NSWBOOT0 = 0x4000000
	// Position of NBOOT0 field.
	Flash_OPTR_NBOOT0_Pos = 0x1b
	// Bit mask of NBOOT0 field.
	Flash_OPTR_NBOOT0_Msk = 0x8000000
	// Bit NBOOT0.
	Flash_OPTR_NBOOT0 = 0x8000000

	// PCROP1SR: Flash Bank 1 PCROP Start address register
	// Position of PCROP1_STRT field.
	Flash_PCROP1SR_PCROP1_STRT_Pos = 0x0
	// Bit mask of PCROP1_STRT field.
	Flash_PCROP1SR_PCROP1_STRT_Msk = 0xffff

	// PCROP1ER: Flash Bank 1 PCROP End address register
	// Position of PCROP1_END field.
	Flash_PCROP1ER_PCROP1_END_Pos = 0x0
	// Bit mask of PCROP1_END field.
	Flash_PCROP1ER_PCROP1_END_Msk = 0xffff
	// Position of PCROP_RDP field.
	Flash_PCROP1ER_PCROP_RDP_Pos = 0x1f
	// Bit mask of PCROP_RDP field.
	Flash_PCROP1ER_PCROP_RDP_Msk = 0x80000000
	// Bit PCROP_RDP.
	Flash_PCROP1ER_PCROP_RDP = 0x80000000

	// WRP1AR: Flash Bank 1 WRP area A address register
	// Position of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Pos = 0x0
	// Bit mask of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Msk = 0xff
	// Position of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Pos = 0x10
	// Bit mask of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Msk = 0xff0000

	// WRP1BR: Flash Bank 1 WRP area B address register
	// Position of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Pos = 0x10
	// Bit mask of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Msk = 0xff0000
	// Position of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Pos = 0x0
	// Bit mask of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Msk = 0xff

	// PCROP2SR: Flash Bank 2 PCROP Start address register
	// Position of PCROP2_STRT field.
	Flash_PCROP2SR_PCROP2_STRT_Pos = 0x0
	// Bit mask of PCROP2_STRT field.
	Flash_PCROP2SR_PCROP2_STRT_Msk = 0xffff

	// PCROP2ER: Flash Bank 2 PCROP End address register
	// Position of PCROP2_END field.
	Flash_PCROP2ER_PCROP2_END_Pos = 0x0
	// Bit mask of PCROP2_END field.
	Flash_PCROP2ER_PCROP2_END_Msk = 0xffff

	// WRP2AR: Flash Bank 2 WRP area A address register
	// Position of WRP2A_STRT field.
	Flash_WRP2AR_WRP2A_STRT_Pos = 0x0
	// Bit mask of WRP2A_STRT field.
	Flash_WRP2AR_WRP2A_STRT_Msk = 0xff
	// Position of WRP2A_END field.
	Flash_WRP2AR_WRP2A_END_Pos = 0x10
	// Bit mask of WRP2A_END field.
	Flash_WRP2AR_WRP2A_END_Msk = 0xff0000

	// WRP2BR: Flash Bank 2 WRP area B address register
	// Position of WRP2B_STRT field.
	Flash_WRP2BR_WRP2B_STRT_Pos = 0x0
	// Bit mask of WRP2B_STRT field.
	Flash_WRP2BR_WRP2B_STRT_Msk = 0xff
	// Position of WRP2B_END field.
	Flash_WRP2BR_WRP2B_END_Pos = 0x10
	// Bit mask of WRP2B_END field.
	Flash_WRP2BR_WRP2B_END_Msk = 0xff0000
)

// Bitfields for PWR: Power control
const (
	// CR1: Power control register 1
	// Position of LPR field.
	PWR_CR1_LPR_Pos = 0xe
	// Bit mask of LPR field.
	PWR_CR1_LPR_Msk = 0x4000
	// Bit LPR.
	PWR_CR1_LPR = 0x4000
	// Position of VOS field.
	PWR_CR1_VOS_Pos = 0x9
	// Bit mask of VOS field.
	PWR_CR1_VOS_Msk = 0x600
	// Position of DBP field.
	PWR_CR1_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR1_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR1_DBP = 0x100
	// Position of LPMS field.
	PWR_CR1_LPMS_Pos = 0x0
	// Bit mask of LPMS field.
	PWR_CR1_LPMS_Msk = 0x7

	// CR2: Power control register 2
	// Position of USV field.
	PWR_CR2_USV_Pos = 0xa
	// Bit mask of USV field.
	PWR_CR2_USV_Msk = 0x400
	// Bit USV.
	PWR_CR2_USV = 0x400
	// Position of IOSV field.
	PWR_CR2_IOSV_Pos = 0x9
	// Bit mask of IOSV field.
	PWR_CR2_IOSV_Msk = 0x200
	// Bit IOSV.
	PWR_CR2_IOSV = 0x200
	// Position of PVME4 field.
	PWR_CR2_PVME4_Pos = 0x7
	// Bit mask of PVME4 field.
	PWR_CR2_PVME4_Msk = 0x80
	// Bit PVME4.
	PWR_CR2_PVME4 = 0x80
	// Position of PVME3 field.
	PWR_CR2_PVME3_Pos = 0x6
	// Bit mask of PVME3 field.
	PWR_CR2_PVME3_Msk = 0x40
	// Bit PVME3.
	PWR_CR2_PVME3 = 0x40
	// Position of PVME2 field.
	PWR_CR2_PVME2_Pos = 0x5
	// Bit mask of PVME2 field.
	PWR_CR2_PVME2_Msk = 0x20
	// Bit PVME2.
	PWR_CR2_PVME2 = 0x20
	// Position of PVME1 field.
	PWR_CR2_PVME1_Pos = 0x4
	// Bit mask of PVME1 field.
	PWR_CR2_PVME1_Msk = 0x10
	// Bit PVME1.
	PWR_CR2_PVME1 = 0x10
	// Position of PLS field.
	PWR_CR2_PLS_Pos = 0x1
	// Bit mask of PLS field.
	PWR_CR2_PLS_Msk = 0xe
	// Position of PVDE field.
	PWR_CR2_PVDE_Pos = 0x0
	// Bit mask of PVDE field.
	PWR_CR2_PVDE_Msk = 0x1
	// Bit PVDE.
	PWR_CR2_PVDE = 0x1

	// CR3: Power control register 3
	// Position of EWF field.
	PWR_CR3_EWF_Pos = 0xf
	// Bit mask of EWF field.
	PWR_CR3_EWF_Msk = 0x8000
	// Bit EWF.
	PWR_CR3_EWF = 0x8000
	// Position of APC field.
	PWR_CR3_APC_Pos = 0xa
	// Bit mask of APC field.
	PWR_CR3_APC_Msk = 0x400
	// Bit APC.
	PWR_CR3_APC = 0x400
	// Position of RRS field.
	PWR_CR3_RRS_Pos = 0x8
	// Bit mask of RRS field.
	PWR_CR3_RRS_Msk = 0x100
	// Bit RRS.
	PWR_CR3_RRS = 0x100
	// Position of EWUP5 field.
	PWR_CR3_EWUP5_Pos = 0x4
	// Bit mask of EWUP5 field.
	PWR_CR3_EWUP5_Msk = 0x10
	// Bit EWUP5.
	PWR_CR3_EWUP5 = 0x10
	// Position of EWUP4 field.
	PWR_CR3_EWUP4_Pos = 0x3
	// Bit mask of EWUP4 field.
	PWR_CR3_EWUP4_Msk = 0x8
	// Bit EWUP4.
	PWR_CR3_EWUP4 = 0x8
	// Position of EWUP3 field.
	PWR_CR3_EWUP3_Pos = 0x2
	// Bit mask of EWUP3 field.
	PWR_CR3_EWUP3_Msk = 0x4
	// Bit EWUP3.
	PWR_CR3_EWUP3 = 0x4
	// Position of EWUP2 field.
	PWR_CR3_EWUP2_Pos = 0x1
	// Bit mask of EWUP2 field.
	PWR_CR3_EWUP2_Msk = 0x2
	// Bit EWUP2.
	PWR_CR3_EWUP2 = 0x2
	// Position of EWUP1 field.
	PWR_CR3_EWUP1_Pos = 0x0
	// Bit mask of EWUP1 field.
	PWR_CR3_EWUP1_Msk = 0x1
	// Bit EWUP1.
	PWR_CR3_EWUP1 = 0x1

	// CR4: Power control register 4
	// Position of VBRS field.
	PWR_CR4_VBRS_Pos = 0x9
	// Bit mask of VBRS field.
	PWR_CR4_VBRS_Msk = 0x200
	// Bit VBRS.
	PWR_CR4_VBRS = 0x200
	// Position of VBE field.
	PWR_CR4_VBE_Pos = 0x8
	// Bit mask of VBE field.
	PWR_CR4_VBE_Msk = 0x100
	// Bit VBE.
	PWR_CR4_VBE = 0x100
	// Position of WP5 field.
	PWR_CR4_WP5_Pos = 0x4
	// Bit mask of WP5 field.
	PWR_CR4_WP5_Msk = 0x10
	// Bit WP5.
	PWR_CR4_WP5 = 0x10
	// Position of WP4 field.
	PWR_CR4_WP4_Pos = 0x3
	// Bit mask of WP4 field.
	PWR_CR4_WP4_Msk = 0x8
	// Bit WP4.
	PWR_CR4_WP4 = 0x8
	// Position of WP3 field.
	PWR_CR4_WP3_Pos = 0x2
	// Bit mask of WP3 field.
	PWR_CR4_WP3_Msk = 0x4
	// Bit WP3.
	PWR_CR4_WP3 = 0x4
	// Position of WP2 field.
	PWR_CR4_WP2_Pos = 0x1
	// Bit mask of WP2 field.
	PWR_CR4_WP2_Msk = 0x2
	// Bit WP2.
	PWR_CR4_WP2 = 0x2
	// Position of WP1 field.
	PWR_CR4_WP1_Pos = 0x0
	// Bit mask of WP1 field.
	PWR_CR4_WP1_Msk = 0x1
	// Bit WP1.
	PWR_CR4_WP1 = 0x1

	// SR1: Power status register 1
	// Position of WUFI field.
	PWR_SR1_WUFI_Pos = 0xf
	// Bit mask of WUFI field.
	PWR_SR1_WUFI_Msk = 0x8000
	// Bit WUFI.
	PWR_SR1_WUFI = 0x8000
	// Position of CSBF field.
	PWR_SR1_CSBF_Pos = 0x8
	// Bit mask of CSBF field.
	PWR_SR1_CSBF_Msk = 0x100
	// Bit CSBF.
	PWR_SR1_CSBF = 0x100
	// Position of CWUF5 field.
	PWR_SR1_CWUF5_Pos = 0x4
	// Bit mask of CWUF5 field.
	PWR_SR1_CWUF5_Msk = 0x10
	// Bit CWUF5.
	PWR_SR1_CWUF5 = 0x10
	// Position of CWUF4 field.
	PWR_SR1_CWUF4_Pos = 0x3
	// Bit mask of CWUF4 field.
	PWR_SR1_CWUF4_Msk = 0x8
	// Bit CWUF4.
	PWR_SR1_CWUF4 = 0x8
	// Position of CWUF3 field.
	PWR_SR1_CWUF3_Pos = 0x2
	// Bit mask of CWUF3 field.
	PWR_SR1_CWUF3_Msk = 0x4
	// Bit CWUF3.
	PWR_SR1_CWUF3 = 0x4
	// Position of CWUF2 field.
	PWR_SR1_CWUF2_Pos = 0x1
	// Bit mask of CWUF2 field.
	PWR_SR1_CWUF2_Msk = 0x2
	// Bit CWUF2.
	PWR_SR1_CWUF2 = 0x2
	// Position of CWUF1 field.
	PWR_SR1_CWUF1_Pos = 0x0
	// Bit mask of CWUF1 field.
	PWR_SR1_CWUF1_Msk = 0x1
	// Bit CWUF1.
	PWR_SR1_CWUF1 = 0x1

	// SR2: Power status register 2
	// Position of PVMO4 field.
	PWR_SR2_PVMO4_Pos = 0xf
	// Bit mask of PVMO4 field.
	PWR_SR2_PVMO4_Msk = 0x8000
	// Bit PVMO4.
	PWR_SR2_PVMO4 = 0x8000
	// Position of PVMO3 field.
	PWR_SR2_PVMO3_Pos = 0xe
	// Bit mask of PVMO3 field.
	PWR_SR2_PVMO3_Msk = 0x4000
	// Bit PVMO3.
	PWR_SR2_PVMO3 = 0x4000
	// Position of PVMO2 field.
	PWR_SR2_PVMO2_Pos = 0xd
	// Bit mask of PVMO2 field.
	PWR_SR2_PVMO2_Msk = 0x2000
	// Bit PVMO2.
	PWR_SR2_PVMO2 = 0x2000
	// Position of PVMO1 field.
	PWR_SR2_PVMO1_Pos = 0xc
	// Bit mask of PVMO1 field.
	PWR_SR2_PVMO1_Msk = 0x1000
	// Bit PVMO1.
	PWR_SR2_PVMO1 = 0x1000
	// Position of PVDO field.
	PWR_SR2_PVDO_Pos = 0xb
	// Bit mask of PVDO field.
	PWR_SR2_PVDO_Msk = 0x800
	// Bit PVDO.
	PWR_SR2_PVDO = 0x800
	// Position of VOSF field.
	PWR_SR2_VOSF_Pos = 0xa
	// Bit mask of VOSF field.
	PWR_SR2_VOSF_Msk = 0x400
	// Bit VOSF.
	PWR_SR2_VOSF = 0x400
	// Position of REGLPF field.
	PWR_SR2_REGLPF_Pos = 0x9
	// Bit mask of REGLPF field.
	PWR_SR2_REGLPF_Msk = 0x200
	// Bit REGLPF.
	PWR_SR2_REGLPF = 0x200
	// Position of REGLPS field.
	PWR_SR2_REGLPS_Pos = 0x8
	// Bit mask of REGLPS field.
	PWR_SR2_REGLPS_Msk = 0x100
	// Bit REGLPS.
	PWR_SR2_REGLPS = 0x100

	// SCR: Power status clear register
	// Position of SBF field.
	PWR_SCR_SBF_Pos = 0x8
	// Bit mask of SBF field.
	PWR_SCR_SBF_Msk = 0x100
	// Bit SBF.
	PWR_SCR_SBF = 0x100
	// Position of WUF5 field.
	PWR_SCR_WUF5_Pos = 0x4
	// Bit mask of WUF5 field.
	PWR_SCR_WUF5_Msk = 0x10
	// Bit WUF5.
	PWR_SCR_WUF5 = 0x10
	// Position of WUF4 field.
	PWR_SCR_WUF4_Pos = 0x3
	// Bit mask of WUF4 field.
	PWR_SCR_WUF4_Msk = 0x8
	// Bit WUF4.
	PWR_SCR_WUF4 = 0x8
	// Position of WUF3 field.
	PWR_SCR_WUF3_Pos = 0x2
	// Bit mask of WUF3 field.
	PWR_SCR_WUF3_Msk = 0x4
	// Bit WUF3.
	PWR_SCR_WUF3 = 0x4
	// Position of WUF2 field.
	PWR_SCR_WUF2_Pos = 0x1
	// Bit mask of WUF2 field.
	PWR_SCR_WUF2_Msk = 0x2
	// Bit WUF2.
	PWR_SCR_WUF2 = 0x2
	// Position of WUF1 field.
	PWR_SCR_WUF1_Pos = 0x0
	// Bit mask of WUF1 field.
	PWR_SCR_WUF1_Msk = 0x1
	// Bit WUF1.
	PWR_SCR_WUF1 = 0x1

	// PUCRA: Power Port A pull-up control register
	// Position of PU15 field.
	PWR_PUCRA_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRA_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRA_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRA_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRA_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRA_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRA_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRA_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRA_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRA_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRA_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRA_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRA_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRA_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRA_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRA_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRA_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRA_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRA_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRA_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRA_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRA_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRA_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRA_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRA_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRA_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRA_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRA_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRA_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRA_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRA_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRA_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRA_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRA_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRA_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRA_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRA_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRA_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRA_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRA_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRA_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRA_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRA_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRA_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRA_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRA_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRA_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRA_PU0 = 0x1

	// PDCRA: Power Port A pull-down control register
	// Position of PD15 field.
	PWR_PDCRA_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRA_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRA_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRA_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRA_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRA_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRA_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRA_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRA_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRA_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRA_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRA_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRA_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRA_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRA_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRA_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRA_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRA_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRA_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRA_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRA_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRA_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRA_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRA_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRA_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRA_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRA_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRA_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRA_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRA_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRA_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRA_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRA_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRA_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRA_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRA_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRA_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRA_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRA_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRA_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRA_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRA_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRA_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRA_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRA_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRA_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRA_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRA_PD0 = 0x1

	// PUCRB: Power Port B pull-up control register
	// Position of PU15 field.
	PWR_PUCRB_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRB_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRB_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRB_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRB_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRB_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRB_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRB_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRB_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRB_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRB_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRB_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRB_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRB_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRB_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRB_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRB_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRB_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRB_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRB_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRB_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRB_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRB_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRB_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRB_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRB_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRB_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRB_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRB_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRB_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRB_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRB_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRB_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRB_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRB_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRB_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRB_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRB_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRB_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRB_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRB_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRB_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRB_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRB_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRB_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRB_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRB_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRB_PU0 = 0x1

	// PDCRB: Power Port B pull-down control register
	// Position of PD15 field.
	PWR_PDCRB_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRB_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRB_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRB_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRB_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRB_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRB_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRB_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRB_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRB_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRB_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRB_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRB_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRB_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRB_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRB_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRB_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRB_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRB_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRB_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRB_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRB_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRB_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRB_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRB_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRB_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRB_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRB_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRB_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRB_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRB_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRB_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRB_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRB_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRB_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRB_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRB_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRB_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRB_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRB_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRB_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRB_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRB_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRB_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRB_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRB_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRB_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRB_PD0 = 0x1

	// PUCRC: Power Port C pull-up control register
	// Position of PU15 field.
	PWR_PUCRC_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRC_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRC_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRC_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRC_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRC_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRC_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRC_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRC_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRC_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRC_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRC_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRC_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRC_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRC_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRC_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRC_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRC_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRC_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRC_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRC_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRC_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRC_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRC_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRC_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRC_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRC_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRC_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRC_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRC_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRC_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRC_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRC_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRC_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRC_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRC_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRC_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRC_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRC_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRC_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRC_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRC_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRC_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRC_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRC_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRC_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRC_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRC_PU0 = 0x1

	// PDCRC: Power Port C pull-down control register
	// Position of PD15 field.
	PWR_PDCRC_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRC_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRC_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRC_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRC_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRC_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRC_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRC_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRC_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRC_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRC_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRC_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRC_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRC_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRC_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRC_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRC_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRC_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRC_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRC_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRC_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRC_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRC_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRC_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRC_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRC_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRC_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRC_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRC_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRC_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRC_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRC_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRC_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRC_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRC_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRC_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRC_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRC_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRC_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRC_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRC_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRC_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRC_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRC_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRC_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRC_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRC_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRC_PD0 = 0x1

	// PUCRD: Power Port D pull-up control register
	// Position of PU15 field.
	PWR_PUCRD_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRD_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRD_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRD_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRD_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRD_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRD_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRD_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRD_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRD_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRD_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRD_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRD_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRD_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRD_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRD_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRD_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRD_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRD_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRD_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRD_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRD_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRD_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRD_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRD_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRD_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRD_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRD_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRD_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRD_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRD_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRD_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRD_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRD_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRD_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRD_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRD_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRD_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRD_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRD_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRD_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRD_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRD_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRD_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRD_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRD_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRD_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRD_PU0 = 0x1

	// PDCRD: Power Port D pull-down control register
	// Position of PD15 field.
	PWR_PDCRD_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRD_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRD_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRD_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRD_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRD_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRD_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRD_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRD_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRD_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRD_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRD_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRD_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRD_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRD_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRD_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRD_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRD_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRD_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRD_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRD_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRD_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRD_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRD_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRD_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRD_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRD_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRD_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRD_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRD_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRD_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRD_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRD_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRD_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRD_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRD_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRD_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRD_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRD_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRD_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRD_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRD_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRD_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRD_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRD_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRD_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRD_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRD_PD0 = 0x1

	// PUCRE: Power Port E pull-up control register
	// Position of PU15 field.
	PWR_PUCRE_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRE_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRE_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRE_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRE_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRE_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRE_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRE_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRE_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRE_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRE_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRE_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRE_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRE_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRE_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRE_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRE_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRE_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRE_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRE_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRE_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRE_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRE_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRE_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRE_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRE_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRE_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRE_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRE_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRE_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRE_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRE_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRE_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRE_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRE_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRE_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRE_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRE_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRE_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRE_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRE_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRE_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRE_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRE_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRE_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRE_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRE_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRE_PU0 = 0x1

	// PDCRE: Power Port E pull-down control register
	// Position of PD15 field.
	PWR_PDCRE_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRE_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRE_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRE_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRE_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRE_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRE_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRE_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRE_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRE_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRE_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRE_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRE_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRE_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRE_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRE_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRE_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRE_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRE_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRE_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRE_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRE_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRE_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRE_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRE_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRE_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRE_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRE_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRE_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRE_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRE_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRE_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRE_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRE_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRE_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRE_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRE_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRE_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRE_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRE_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRE_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRE_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRE_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRE_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRE_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRE_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRE_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRE_PD0 = 0x1

	// PUCRF: Power Port F pull-up control register
	// Position of PU15 field.
	PWR_PUCRF_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRF_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRF_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRF_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRF_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRF_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRF_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRF_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRF_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRF_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRF_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRF_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRF_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRF_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRF_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRF_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRF_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRF_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRF_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRF_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRF_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRF_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRF_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRF_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRF_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRF_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRF_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRF_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRF_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRF_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRF_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRF_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRF_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRF_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRF_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRF_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRF_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRF_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRF_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRF_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRF_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRF_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRF_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRF_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRF_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRF_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRF_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRF_PU0 = 0x1

	// PDCRF: Power Port F pull-down control register
	// Position of PD15 field.
	PWR_PDCRF_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRF_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRF_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRF_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRF_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRF_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRF_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRF_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRF_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRF_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRF_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRF_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRF_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRF_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRF_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRF_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRF_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRF_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRF_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRF_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRF_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRF_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRF_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRF_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRF_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRF_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRF_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRF_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRF_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRF_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRF_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRF_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRF_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRF_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRF_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRF_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRF_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRF_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRF_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRF_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRF_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRF_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRF_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRF_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRF_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRF_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRF_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRF_PD0 = 0x1

	// PUCRG: Power Port G pull-up control register
	// Position of PU15 field.
	PWR_PUCRG_PU15_Pos = 0xf
	// Bit mask of PU15 field.
	PWR_PUCRG_PU15_Msk = 0x8000
	// Bit PU15.
	PWR_PUCRG_PU15 = 0x8000
	// Position of PU14 field.
	PWR_PUCRG_PU14_Pos = 0xe
	// Bit mask of PU14 field.
	PWR_PUCRG_PU14_Msk = 0x4000
	// Bit PU14.
	PWR_PUCRG_PU14 = 0x4000
	// Position of PU13 field.
	PWR_PUCRG_PU13_Pos = 0xd
	// Bit mask of PU13 field.
	PWR_PUCRG_PU13_Msk = 0x2000
	// Bit PU13.
	PWR_PUCRG_PU13 = 0x2000
	// Position of PU12 field.
	PWR_PUCRG_PU12_Pos = 0xc
	// Bit mask of PU12 field.
	PWR_PUCRG_PU12_Msk = 0x1000
	// Bit PU12.
	PWR_PUCRG_PU12 = 0x1000
	// Position of PU11 field.
	PWR_PUCRG_PU11_Pos = 0xb
	// Bit mask of PU11 field.
	PWR_PUCRG_PU11_Msk = 0x800
	// Bit PU11.
	PWR_PUCRG_PU11 = 0x800
	// Position of PU10 field.
	PWR_PUCRG_PU10_Pos = 0xa
	// Bit mask of PU10 field.
	PWR_PUCRG_PU10_Msk = 0x400
	// Bit PU10.
	PWR_PUCRG_PU10 = 0x400
	// Position of PU9 field.
	PWR_PUCRG_PU9_Pos = 0x9
	// Bit mask of PU9 field.
	PWR_PUCRG_PU9_Msk = 0x200
	// Bit PU9.
	PWR_PUCRG_PU9 = 0x200
	// Position of PU8 field.
	PWR_PUCRG_PU8_Pos = 0x8
	// Bit mask of PU8 field.
	PWR_PUCRG_PU8_Msk = 0x100
	// Bit PU8.
	PWR_PUCRG_PU8 = 0x100
	// Position of PU7 field.
	PWR_PUCRG_PU7_Pos = 0x7
	// Bit mask of PU7 field.
	PWR_PUCRG_PU7_Msk = 0x80
	// Bit PU7.
	PWR_PUCRG_PU7 = 0x80
	// Position of PU6 field.
	PWR_PUCRG_PU6_Pos = 0x6
	// Bit mask of PU6 field.
	PWR_PUCRG_PU6_Msk = 0x40
	// Bit PU6.
	PWR_PUCRG_PU6 = 0x40
	// Position of PU5 field.
	PWR_PUCRG_PU5_Pos = 0x5
	// Bit mask of PU5 field.
	PWR_PUCRG_PU5_Msk = 0x20
	// Bit PU5.
	PWR_PUCRG_PU5 = 0x20
	// Position of PU4 field.
	PWR_PUCRG_PU4_Pos = 0x4
	// Bit mask of PU4 field.
	PWR_PUCRG_PU4_Msk = 0x10
	// Bit PU4.
	PWR_PUCRG_PU4 = 0x10
	// Position of PU3 field.
	PWR_PUCRG_PU3_Pos = 0x3
	// Bit mask of PU3 field.
	PWR_PUCRG_PU3_Msk = 0x8
	// Bit PU3.
	PWR_PUCRG_PU3 = 0x8
	// Position of PU2 field.
	PWR_PUCRG_PU2_Pos = 0x2
	// Bit mask of PU2 field.
	PWR_PUCRG_PU2_Msk = 0x4
	// Bit PU2.
	PWR_PUCRG_PU2 = 0x4
	// Position of PU1 field.
	PWR_PUCRG_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRG_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRG_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRG_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRG_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRG_PU0 = 0x1

	// PDCRG: Power Port G pull-down control register
	// Position of PD15 field.
	PWR_PDCRG_PD15_Pos = 0xf
	// Bit mask of PD15 field.
	PWR_PDCRG_PD15_Msk = 0x8000
	// Bit PD15.
	PWR_PDCRG_PD15 = 0x8000
	// Position of PD14 field.
	PWR_PDCRG_PD14_Pos = 0xe
	// Bit mask of PD14 field.
	PWR_PDCRG_PD14_Msk = 0x4000
	// Bit PD14.
	PWR_PDCRG_PD14 = 0x4000
	// Position of PD13 field.
	PWR_PDCRG_PD13_Pos = 0xd
	// Bit mask of PD13 field.
	PWR_PDCRG_PD13_Msk = 0x2000
	// Bit PD13.
	PWR_PDCRG_PD13 = 0x2000
	// Position of PD12 field.
	PWR_PDCRG_PD12_Pos = 0xc
	// Bit mask of PD12 field.
	PWR_PDCRG_PD12_Msk = 0x1000
	// Bit PD12.
	PWR_PDCRG_PD12 = 0x1000
	// Position of PD11 field.
	PWR_PDCRG_PD11_Pos = 0xb
	// Bit mask of PD11 field.
	PWR_PDCRG_PD11_Msk = 0x800
	// Bit PD11.
	PWR_PDCRG_PD11 = 0x800
	// Position of PD10 field.
	PWR_PDCRG_PD10_Pos = 0xa
	// Bit mask of PD10 field.
	PWR_PDCRG_PD10_Msk = 0x400
	// Bit PD10.
	PWR_PDCRG_PD10 = 0x400
	// Position of PD9 field.
	PWR_PDCRG_PD9_Pos = 0x9
	// Bit mask of PD9 field.
	PWR_PDCRG_PD9_Msk = 0x200
	// Bit PD9.
	PWR_PDCRG_PD9 = 0x200
	// Position of PD8 field.
	PWR_PDCRG_PD8_Pos = 0x8
	// Bit mask of PD8 field.
	PWR_PDCRG_PD8_Msk = 0x100
	// Bit PD8.
	PWR_PDCRG_PD8 = 0x100
	// Position of PD7 field.
	PWR_PDCRG_PD7_Pos = 0x7
	// Bit mask of PD7 field.
	PWR_PDCRG_PD7_Msk = 0x80
	// Bit PD7.
	PWR_PDCRG_PD7 = 0x80
	// Position of PD6 field.
	PWR_PDCRG_PD6_Pos = 0x6
	// Bit mask of PD6 field.
	PWR_PDCRG_PD6_Msk = 0x40
	// Bit PD6.
	PWR_PDCRG_PD6 = 0x40
	// Position of PD5 field.
	PWR_PDCRG_PD5_Pos = 0x5
	// Bit mask of PD5 field.
	PWR_PDCRG_PD5_Msk = 0x20
	// Bit PD5.
	PWR_PDCRG_PD5 = 0x20
	// Position of PD4 field.
	PWR_PDCRG_PD4_Pos = 0x4
	// Bit mask of PD4 field.
	PWR_PDCRG_PD4_Msk = 0x10
	// Bit PD4.
	PWR_PDCRG_PD4 = 0x10
	// Position of PD3 field.
	PWR_PDCRG_PD3_Pos = 0x3
	// Bit mask of PD3 field.
	PWR_PDCRG_PD3_Msk = 0x8
	// Bit PD3.
	PWR_PDCRG_PD3 = 0x8
	// Position of PD2 field.
	PWR_PDCRG_PD2_Pos = 0x2
	// Bit mask of PD2 field.
	PWR_PDCRG_PD2_Msk = 0x4
	// Bit PD2.
	PWR_PDCRG_PD2 = 0x4
	// Position of PD1 field.
	PWR_PDCRG_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRG_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRG_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRG_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRG_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRG_PD0 = 0x1

	// PUCRH: Power Port H pull-up control register
	// Position of PU1 field.
	PWR_PUCRH_PU1_Pos = 0x1
	// Bit mask of PU1 field.
	PWR_PUCRH_PU1_Msk = 0x2
	// Bit PU1.
	PWR_PUCRH_PU1 = 0x2
	// Position of PU0 field.
	PWR_PUCRH_PU0_Pos = 0x0
	// Bit mask of PU0 field.
	PWR_PUCRH_PU0_Msk = 0x1
	// Bit PU0.
	PWR_PUCRH_PU0 = 0x1

	// PDCRH: Power Port H pull-down control register
	// Position of PD1 field.
	PWR_PDCRH_PD1_Pos = 0x1
	// Bit mask of PD1 field.
	PWR_PDCRH_PD1_Msk = 0x2
	// Bit PD1.
	PWR_PDCRH_PD1 = 0x2
	// Position of PD0 field.
	PWR_PDCRH_PD0_Pos = 0x0
	// Bit mask of PD0 field.
	PWR_PDCRH_PD0_Msk = 0x1
	// Bit PD0.
	PWR_PDCRH_PD0 = 0x1
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRMP: memory remap register
	// Position of FB_MODE field.
	SYSCFG_MEMRMP_FB_MODE_Pos = 0x8
	// Bit mask of FB_MODE field.
	SYSCFG_MEMRMP_FB_MODE_Msk = 0x100
	// Bit FB_MODE.
	SYSCFG_MEMRMP_FB_MODE = 0x100
	// Position of QFS field.
	SYSCFG_MEMRMP_QFS_Pos = 0x3
	// Bit mask of QFS field.
	SYSCFG_MEMRMP_QFS_Msk = 0x8
	// Bit QFS.
	SYSCFG_MEMRMP_QFS = 0x8
	// Position of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Msk = 0x7

	// CFGR1: configuration register 1
	// Position of FPU_IE field.
	SYSCFG_CFGR1_FPU_IE_Pos = 0x1a
	// Bit mask of FPU_IE field.
	SYSCFG_CFGR1_FPU_IE_Msk = 0xfc000000
	// Position of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP_Pos = 0x16
	// Bit mask of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP_Msk = 0x400000
	// Bit I2C3_FMP.
	SYSCFG_CFGR1_I2C3_FMP = 0x400000
	// Position of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Pos = 0x15
	// Bit mask of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Msk = 0x200000
	// Bit I2C2_FMP.
	SYSCFG_CFGR1_I2C2_FMP = 0x200000
	// Position of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Pos = 0x14
	// Bit mask of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Msk = 0x100000
	// Bit I2C1_FMP.
	SYSCFG_CFGR1_I2C1_FMP = 0x100000
	// Position of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP_Pos = 0x13
	// Bit mask of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP_Msk = 0x80000
	// Bit I2C_PB9_FMP.
	SYSCFG_CFGR1_I2C_PB9_FMP = 0x80000
	// Position of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP_Pos = 0x12
	// Bit mask of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP_Msk = 0x40000
	// Bit I2C_PB8_FMP.
	SYSCFG_CFGR1_I2C_PB8_FMP = 0x40000
	// Position of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP_Pos = 0x11
	// Bit mask of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP_Msk = 0x20000
	// Bit I2C_PB7_FMP.
	SYSCFG_CFGR1_I2C_PB7_FMP = 0x20000
	// Position of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP_Pos = 0x10
	// Bit mask of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP_Msk = 0x10000
	// Bit I2C_PB6_FMP.
	SYSCFG_CFGR1_I2C_PB6_FMP = 0x10000
	// Position of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Pos = 0x8
	// Bit mask of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Msk = 0x100
	// Bit BOOSTEN.
	SYSCFG_CFGR1_BOOSTEN = 0x100
	// Position of FWDIS field.
	SYSCFG_CFGR1_FWDIS_Pos = 0x0
	// Bit mask of FWDIS field.
	SYSCFG_CFGR1_FWDIS_Msk = 0x1
	// Bit FWDIS.
	SYSCFG_CFGR1_FWDIS = 0x1

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0x7000
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0x700
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0x70
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0x7

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0x7000
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0x700
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0x70
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0x7

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0x7000
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0x700
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0x70
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0x7

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0x7000
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0x700
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0x70
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0x7

	// SCSR: SCSR
	// Position of SRAM2BSY field.
	SYSCFG_SCSR_SRAM2BSY_Pos = 0x1
	// Bit mask of SRAM2BSY field.
	SYSCFG_SCSR_SRAM2BSY_Msk = 0x2
	// Bit SRAM2BSY.
	SYSCFG_SCSR_SRAM2BSY = 0x2
	// Position of SRAM2ER field.
	SYSCFG_SCSR_SRAM2ER_Pos = 0x0
	// Bit mask of SRAM2ER field.
	SYSCFG_SCSR_SRAM2ER_Msk = 0x1
	// Bit SRAM2ER.
	SYSCFG_SCSR_SRAM2ER = 0x1

	// CFGR2: CFGR2
	// Position of SPF field.
	SYSCFG_CFGR2_SPF_Pos = 0x8
	// Bit mask of SPF field.
	SYSCFG_CFGR2_SPF_Msk = 0x100
	// Bit SPF.
	SYSCFG_CFGR2_SPF = 0x100
	// Position of ECCL field.
	SYSCFG_CFGR2_ECCL_Pos = 0x3
	// Bit mask of ECCL field.
	SYSCFG_CFGR2_ECCL_Msk = 0x8
	// Bit ECCL.
	SYSCFG_CFGR2_ECCL = 0x8
	// Position of PVDL field.
	SYSCFG_CFGR2_PVDL_Pos = 0x2
	// Bit mask of PVDL field.
	SYSCFG_CFGR2_PVDL_Msk = 0x4
	// Bit PVDL.
	SYSCFG_CFGR2_PVDL = 0x4
	// Position of SPL field.
	SYSCFG_CFGR2_SPL_Pos = 0x1
	// Bit mask of SPL field.
	SYSCFG_CFGR2_SPL_Msk = 0x2
	// Bit SPL.
	SYSCFG_CFGR2_SPL = 0x2
	// Position of CLL field.
	SYSCFG_CFGR2_CLL_Pos = 0x0
	// Bit mask of CLL field.
	SYSCFG_CFGR2_CLL_Msk = 0x1
	// Bit CLL.
	SYSCFG_CFGR2_CLL = 0x1

	// SWPR: SWPR
	// Position of P31WP field.
	SYSCFG_SWPR_P31WP_Pos = 0x1f
	// Bit mask of P31WP field.
	SYSCFG_SWPR_P31WP_Msk = 0x80000000
	// Bit P31WP.
	SYSCFG_SWPR_P31WP = 0x80000000
	// Position of P30WP field.
	SYSCFG_SWPR_P30WP_Pos = 0x1e
	// Bit mask of P30WP field.
	SYSCFG_SWPR_P30WP_Msk = 0x40000000
	// Bit P30WP.
	SYSCFG_SWPR_P30WP = 0x40000000
	// Position of P29WP field.
	SYSCFG_SWPR_P29WP_Pos = 0x1d
	// Bit mask of P29WP field.
	SYSCFG_SWPR_P29WP_Msk = 0x20000000
	// Bit P29WP.
	SYSCFG_SWPR_P29WP = 0x20000000
	// Position of P28WP field.
	SYSCFG_SWPR_P28WP_Pos = 0x1c
	// Bit mask of P28WP field.
	SYSCFG_SWPR_P28WP_Msk = 0x10000000
	// Bit P28WP.
	SYSCFG_SWPR_P28WP = 0x10000000
	// Position of P27WP field.
	SYSCFG_SWPR_P27WP_Pos = 0x1b
	// Bit mask of P27WP field.
	SYSCFG_SWPR_P27WP_Msk = 0x8000000
	// Bit P27WP.
	SYSCFG_SWPR_P27WP = 0x8000000
	// Position of P26WP field.
	SYSCFG_SWPR_P26WP_Pos = 0x1a
	// Bit mask of P26WP field.
	SYSCFG_SWPR_P26WP_Msk = 0x4000000
	// Bit P26WP.
	SYSCFG_SWPR_P26WP = 0x4000000
	// Position of P25WP field.
	SYSCFG_SWPR_P25WP_Pos = 0x19
	// Bit mask of P25WP field.
	SYSCFG_SWPR_P25WP_Msk = 0x2000000
	// Bit P25WP.
	SYSCFG_SWPR_P25WP = 0x2000000
	// Position of P24WP field.
	SYSCFG_SWPR_P24WP_Pos = 0x18
	// Bit mask of P24WP field.
	SYSCFG_SWPR_P24WP_Msk = 0x1000000
	// Bit P24WP.
	SYSCFG_SWPR_P24WP = 0x1000000
	// Position of P23WP field.
	SYSCFG_SWPR_P23WP_Pos = 0x17
	// Bit mask of P23WP field.
	SYSCFG_SWPR_P23WP_Msk = 0x800000
	// Bit P23WP.
	SYSCFG_SWPR_P23WP = 0x800000
	// Position of P22WP field.
	SYSCFG_SWPR_P22WP_Pos = 0x16
	// Bit mask of P22WP field.
	SYSCFG_SWPR_P22WP_Msk = 0x400000
	// Bit P22WP.
	SYSCFG_SWPR_P22WP = 0x400000
	// Position of P21WP field.
	SYSCFG_SWPR_P21WP_Pos = 0x15
	// Bit mask of P21WP field.
	SYSCFG_SWPR_P21WP_Msk = 0x200000
	// Bit P21WP.
	SYSCFG_SWPR_P21WP = 0x200000
	// Position of P20WP field.
	SYSCFG_SWPR_P20WP_Pos = 0x14
	// Bit mask of P20WP field.
	SYSCFG_SWPR_P20WP_Msk = 0x100000
	// Bit P20WP.
	SYSCFG_SWPR_P20WP = 0x100000
	// Position of P19WP field.
	SYSCFG_SWPR_P19WP_Pos = 0x13
	// Bit mask of P19WP field.
	SYSCFG_SWPR_P19WP_Msk = 0x80000
	// Bit P19WP.
	SYSCFG_SWPR_P19WP = 0x80000
	// Position of P18WP field.
	SYSCFG_SWPR_P18WP_Pos = 0x12
	// Bit mask of P18WP field.
	SYSCFG_SWPR_P18WP_Msk = 0x40000
	// Bit P18WP.
	SYSCFG_SWPR_P18WP = 0x40000
	// Position of P17WP field.
	SYSCFG_SWPR_P17WP_Pos = 0x11
	// Bit mask of P17WP field.
	SYSCFG_SWPR_P17WP_Msk = 0x20000
	// Bit P17WP.
	SYSCFG_SWPR_P17WP = 0x20000
	// Position of P16WP field.
	SYSCFG_SWPR_P16WP_Pos = 0x10
	// Bit mask of P16WP field.
	SYSCFG_SWPR_P16WP_Msk = 0x10000
	// Bit P16WP.
	SYSCFG_SWPR_P16WP = 0x10000
	// Position of P15WP field.
	SYSCFG_SWPR_P15WP_Pos = 0xf
	// Bit mask of P15WP field.
	SYSCFG_SWPR_P15WP_Msk = 0x8000
	// Bit P15WP.
	SYSCFG_SWPR_P15WP = 0x8000
	// Position of P14WP field.
	SYSCFG_SWPR_P14WP_Pos = 0xe
	// Bit mask of P14WP field.
	SYSCFG_SWPR_P14WP_Msk = 0x4000
	// Bit P14WP.
	SYSCFG_SWPR_P14WP = 0x4000
	// Position of P13WP field.
	SYSCFG_SWPR_P13WP_Pos = 0xd
	// Bit mask of P13WP field.
	SYSCFG_SWPR_P13WP_Msk = 0x2000
	// Bit P13WP.
	SYSCFG_SWPR_P13WP = 0x2000
	// Position of P12WP field.
	SYSCFG_SWPR_P12WP_Pos = 0xc
	// Bit mask of P12WP field.
	SYSCFG_SWPR_P12WP_Msk = 0x1000
	// Bit P12WP.
	SYSCFG_SWPR_P12WP = 0x1000
	// Position of P11WP field.
	SYSCFG_SWPR_P11WP_Pos = 0xb
	// Bit mask of P11WP field.
	SYSCFG_SWPR_P11WP_Msk = 0x800
	// Bit P11WP.
	SYSCFG_SWPR_P11WP = 0x800
	// Position of P10WP field.
	SYSCFG_SWPR_P10WP_Pos = 0xa
	// Bit mask of P10WP field.
	SYSCFG_SWPR_P10WP_Msk = 0x400
	// Bit P10WP.
	SYSCFG_SWPR_P10WP = 0x400
	// Position of P9WP field.
	SYSCFG_SWPR_P9WP_Pos = 0x9
	// Bit mask of P9WP field.
	SYSCFG_SWPR_P9WP_Msk = 0x200
	// Bit P9WP.
	SYSCFG_SWPR_P9WP = 0x200
	// Position of P8WP field.
	SYSCFG_SWPR_P8WP_Pos = 0x8
	// Bit mask of P8WP field.
	SYSCFG_SWPR_P8WP_Msk = 0x100
	// Bit P8WP.
	SYSCFG_SWPR_P8WP = 0x100
	// Position of P7WP field.
	SYSCFG_SWPR_P7WP_Pos = 0x7
	// Bit mask of P7WP field.
	SYSCFG_SWPR_P7WP_Msk = 0x80
	// Bit P7WP.
	SYSCFG_SWPR_P7WP = 0x80
	// Position of P6WP field.
	SYSCFG_SWPR_P6WP_Pos = 0x6
	// Bit mask of P6WP field.
	SYSCFG_SWPR_P6WP_Msk = 0x40
	// Bit P6WP.
	SYSCFG_SWPR_P6WP = 0x40
	// Position of P5WP field.
	SYSCFG_SWPR_P5WP_Pos = 0x5
	// Bit mask of P5WP field.
	SYSCFG_SWPR_P5WP_Msk = 0x20
	// Bit P5WP.
	SYSCFG_SWPR_P5WP = 0x20
	// Position of P4WP field.
	SYSCFG_SWPR_P4WP_Pos = 0x4
	// Bit mask of P4WP field.
	SYSCFG_SWPR_P4WP_Msk = 0x10
	// Bit P4WP.
	SYSCFG_SWPR_P4WP = 0x10
	// Position of P3WP field.
	SYSCFG_SWPR_P3WP_Pos = 0x3
	// Bit mask of P3WP field.
	SYSCFG_SWPR_P3WP_Msk = 0x8
	// Bit P3WP.
	SYSCFG_SWPR_P3WP = 0x8
	// Position of P2WP field.
	SYSCFG_SWPR_P2WP_Pos = 0x2
	// Bit mask of P2WP field.
	SYSCFG_SWPR_P2WP_Msk = 0x4
	// Bit P2WP.
	SYSCFG_SWPR_P2WP = 0x4
	// Position of P1WP field.
	SYSCFG_SWPR_P1WP_Pos = 0x1
	// Bit mask of P1WP field.
	SYSCFG_SWPR_P1WP_Msk = 0x2
	// Bit P1WP.
	SYSCFG_SWPR_P1WP = 0x2
	// Position of P0WP field.
	SYSCFG_SWPR_P0WP_Pos = 0x0
	// Bit mask of P0WP field.
	SYSCFG_SWPR_P0WP_Msk = 0x1
	// Bit P0WP.
	SYSCFG_SWPR_P0WP = 0x1

	// SKR: SKR
	// Position of KEY field.
	SYSCFG_SKR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	SYSCFG_SKR_KEY_Msk = 0xff
)

// Bitfields for RNG: Random number generator
const (
	// CR: control register
	// Position of IE field.
	RNG_CR_IE_Pos = 0x3
	// Bit mask of IE field.
	RNG_CR_IE_Msk = 0x8
	// Bit IE.
	RNG_CR_IE = 0x8
	// Position of RNGEN field.
	RNG_CR_RNGEN_Pos = 0x2
	// Bit mask of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4
	// Bit RNGEN.
	RNG_CR_RNGEN = 0x4

	// SR: status register
	// Position of SEIS field.
	RNG_SR_SEIS_Pos = 0x6
	// Bit mask of SEIS field.
	RNG_SR_SEIS_Msk = 0x40
	// Bit SEIS.
	RNG_SR_SEIS = 0x40
	// Position of CEIS field.
	RNG_SR_CEIS_Pos = 0x5
	// Bit mask of CEIS field.
	RNG_SR_CEIS_Msk = 0x20
	// Bit CEIS.
	RNG_SR_CEIS = 0x20
	// Position of SECS field.
	RNG_SR_SECS_Pos = 0x2
	// Bit mask of SECS field.
	RNG_SR_SECS_Msk = 0x4
	// Bit SECS.
	RNG_SR_SECS = 0x4
	// Position of CECS field.
	RNG_SR_CECS_Pos = 0x1
	// Bit mask of CECS field.
	RNG_SR_CECS_Msk = 0x2
	// Bit CECS.
	RNG_SR_CECS = 0x2
	// Position of DRDY field.
	RNG_SR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	RNG_SR_DRDY_Msk = 0x1
	// Bit DRDY.
	RNG_SR_DRDY = 0x1

	// DR: data register
	// Position of RNDATA field.
	RNG_DR_RNDATA_Pos = 0x0
	// Bit mask of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff
)

// Bitfields for AES: Advanced encryption standard hardware accelerator
const (
	// CR: control register
	// Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Pos = 0xc
	// Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000
	// Bit DMAOUTEN.
	AES_CR_DMAOUTEN = 0x1000
	// Position of DMAINEN field.
	AES_CR_DMAINEN_Pos = 0xb
	// Bit mask of DMAINEN field.
	AES_CR_DMAINEN_Msk = 0x800
	// Bit DMAINEN.
	AES_CR_DMAINEN = 0x800
	// Position of ERRIE field.
	AES_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	AES_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	AES_CR_ERRIE = 0x400
	// Position of CCFIE field.
	AES_CR_CCFIE_Pos = 0x9
	// Bit mask of CCFIE field.
	AES_CR_CCFIE_Msk = 0x200
	// Bit CCFIE.
	AES_CR_CCFIE = 0x200
	// Position of ERRC field.
	AES_CR_ERRC_Pos = 0x8
	// Bit mask of ERRC field.
	AES_CR_ERRC_Msk = 0x100
	// Bit ERRC.
	AES_CR_ERRC = 0x100
	// Position of CCFC field.
	AES_CR_CCFC_Pos = 0x7
	// Bit mask of CCFC field.
	AES_CR_CCFC_Msk = 0x80
	// Bit CCFC.
	AES_CR_CCFC = 0x80
	// Position of CHMOD field.
	AES_CR_CHMOD_Pos = 0x5
	// Bit mask of CHMOD field.
	AES_CR_CHMOD_Msk = 0x60
	// Position of MODE field.
	AES_CR_MODE_Pos = 0x3
	// Bit mask of MODE field.
	AES_CR_MODE_Msk = 0x18
	// Position of DATATYPE field.
	AES_CR_DATATYPE_Pos = 0x1
	// Bit mask of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6
	// Position of EN field.
	AES_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	AES_CR_EN_Msk = 0x1
	// Bit EN.
	AES_CR_EN = 0x1

	// SR: status register
	// Position of WRERR field.
	AES_SR_WRERR_Pos = 0x2
	// Bit mask of WRERR field.
	AES_SR_WRERR_Msk = 0x4
	// Bit WRERR.
	AES_SR_WRERR = 0x4
	// Position of RDERR field.
	AES_SR_RDERR_Pos = 0x1
	// Bit mask of RDERR field.
	AES_SR_RDERR_Msk = 0x2
	// Bit RDERR.
	AES_SR_RDERR = 0x2
	// Position of CCF field.
	AES_SR_CCF_Pos = 0x0
	// Bit mask of CCF field.
	AES_SR_CCF_Msk = 0x1
	// Bit CCF.
	AES_SR_CCF = 0x1

	// DINR: data input register
	// Position of AES_DINR field.
	AES_DINR_AES_DINR_Pos = 0x0
	// Bit mask of AES_DINR field.
	AES_DINR_AES_DINR_Msk = 0xffffffff

	// DOUTR: data output register
	// Position of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Pos = 0x0
	// Bit mask of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Msk = 0xffffffff

	// KEYR0: key register 0
	// Position of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Pos = 0x0
	// Bit mask of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Msk = 0xffffffff

	// KEYR1: key register 1
	// Position of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Pos = 0x0
	// Bit mask of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Msk = 0xffffffff

	// KEYR2: key register 2
	// Position of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Pos = 0x0
	// Bit mask of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Msk = 0xffffffff

	// KEYR3: key register 3
	// Position of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Pos = 0x0
	// Bit mask of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Msk = 0xffffffff

	// IVR0: initialization vector register 0
	// Position of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Pos = 0x0
	// Bit mask of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Msk = 0xffffffff

	// IVR1: initialization vector register 1
	// Position of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Pos = 0x0
	// Bit mask of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Msk = 0xffffffff

	// IVR2: initialization vector register 2
	// Position of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Pos = 0x0
	// Bit mask of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Msk = 0xffffffff

	// IVR3: initialization vector register 3
	// Position of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Pos = 0x0
	// Bit mask of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Msk = 0xffffffff
)

// Bitfields for ADC1: Analog-to-Digital Converter
const (
	// ISR: interrupt and status register
	// Position of JQOVF field.
	ADC_ISR_JQOVF_Pos = 0xa
	// Bit mask of JQOVF field.
	ADC_ISR_JQOVF_Msk = 0x400
	// Bit JQOVF.
	ADC_ISR_JQOVF = 0x400
	// Position of AWD3 field.
	ADC_ISR_AWD3_Pos = 0x9
	// Bit mask of AWD3 field.
	ADC_ISR_AWD3_Msk = 0x200
	// Bit AWD3.
	ADC_ISR_AWD3 = 0x200
	// Position of AWD2 field.
	ADC_ISR_AWD2_Pos = 0x8
	// Bit mask of AWD2 field.
	ADC_ISR_AWD2_Msk = 0x100
	// Bit AWD2.
	ADC_ISR_AWD2 = 0x100
	// Position of AWD1 field.
	ADC_ISR_AWD1_Pos = 0x7
	// Bit mask of AWD1 field.
	ADC_ISR_AWD1_Msk = 0x80
	// Bit AWD1.
	ADC_ISR_AWD1 = 0x80
	// Position of JEOS field.
	ADC_ISR_JEOS_Pos = 0x6
	// Bit mask of JEOS field.
	ADC_ISR_JEOS_Msk = 0x40
	// Bit JEOS.
	ADC_ISR_JEOS = 0x40
	// Position of JEOC field.
	ADC_ISR_JEOC_Pos = 0x5
	// Bit mask of JEOC field.
	ADC_ISR_JEOC_Msk = 0x20
	// Bit JEOC.
	ADC_ISR_JEOC = 0x20
	// Position of OVR field.
	ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ISR_OVR = 0x10
	// Position of EOS field.
	ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ISR_EOS = 0x8
	// Position of EOC field.
	ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ISR_EOC = 0x4
	// Position of EOSMP field.
	ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ISR_EOSMP = 0x2
	// Position of ADRDY field.
	ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ISR_ADRDY = 0x1

	// IER: interrupt enable register
	// Position of JQOVFIE field.
	ADC_IER_JQOVFIE_Pos = 0xa
	// Bit mask of JQOVFIE field.
	ADC_IER_JQOVFIE_Msk = 0x400
	// Bit JQOVFIE.
	ADC_IER_JQOVFIE = 0x400
	// Position of AWD3IE field.
	ADC_IER_AWD3IE_Pos = 0x9
	// Bit mask of AWD3IE field.
	ADC_IER_AWD3IE_Msk = 0x200
	// Bit AWD3IE.
	ADC_IER_AWD3IE = 0x200
	// Position of AWD2IE field.
	ADC_IER_AWD2IE_Pos = 0x8
	// Bit mask of AWD2IE field.
	ADC_IER_AWD2IE_Msk = 0x100
	// Bit AWD2IE.
	ADC_IER_AWD2IE = 0x100
	// Position of AWD1IE field.
	ADC_IER_AWD1IE_Pos = 0x7
	// Bit mask of AWD1IE field.
	ADC_IER_AWD1IE_Msk = 0x80
	// Bit AWD1IE.
	ADC_IER_AWD1IE = 0x80
	// Position of JEOSIE field.
	ADC_IER_JEOSIE_Pos = 0x6
	// Bit mask of JEOSIE field.
	ADC_IER_JEOSIE_Msk = 0x40
	// Bit JEOSIE.
	ADC_IER_JEOSIE = 0x40
	// Position of JEOCIE field.
	ADC_IER_JEOCIE_Pos = 0x5
	// Bit mask of JEOCIE field.
	ADC_IER_JEOCIE_Msk = 0x20
	// Bit JEOCIE.
	ADC_IER_JEOCIE = 0x20
	// Position of OVRIE field.
	ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_IER_OVRIE = 0x10
	// Position of EOSIE field.
	ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_IER_EOSIE = 0x8
	// Position of EOCIE field.
	ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_IER_EOCIE = 0x4
	// Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_IER_EOSMPIE = 0x2
	// Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_IER_ADRDYIE = 0x1

	// CR: control register
	// Position of ADCAL field.
	ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_CR_ADCAL = 0x80000000
	// Position of ADCALDIF field.
	ADC_CR_ADCALDIF_Pos = 0x1e
	// Bit mask of ADCALDIF field.
	ADC_CR_ADCALDIF_Msk = 0x40000000
	// Bit ADCALDIF.
	ADC_CR_ADCALDIF = 0x40000000
	// Position of DEEPPWD field.
	ADC_CR_DEEPPWD_Pos = 0x1d
	// Bit mask of DEEPPWD field.
	ADC_CR_DEEPPWD_Msk = 0x20000000
	// Bit DEEPPWD.
	ADC_CR_DEEPPWD = 0x20000000
	// Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000
	// Bit ADVREGEN.
	ADC_CR_ADVREGEN = 0x10000000
	// Position of JADSTP field.
	ADC_CR_JADSTP_Pos = 0x5
	// Bit mask of JADSTP field.
	ADC_CR_JADSTP_Msk = 0x20
	// Bit JADSTP.
	ADC_CR_JADSTP = 0x20
	// Position of ADSTP field.
	ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_CR_ADSTP = 0x10
	// Position of JADSTART field.
	ADC_CR_JADSTART_Pos = 0x3
	// Bit mask of JADSTART field.
	ADC_CR_JADSTART_Msk = 0x8
	// Bit JADSTART.
	ADC_CR_JADSTART = 0x8
	// Position of ADSTART field.
	ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_CR_ADSTART = 0x4
	// Position of ADDIS field.
	ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_CR_ADDIS = 0x2
	// Position of ADEN field.
	ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_CR_ADEN = 0x1

	// CFGR: configuration register
	// Position of AWDCH1CH field.
	ADC_CFGR_AWDCH1CH_Pos = 0x1a
	// Bit mask of AWDCH1CH field.
	ADC_CFGR_AWDCH1CH_Msk = 0x7c000000
	// Position of JAUTO field.
	ADC_CFGR_JAUTO_Pos = 0x19
	// Bit mask of JAUTO field.
	ADC_CFGR_JAUTO_Msk = 0x2000000
	// Bit JAUTO.
	ADC_CFGR_JAUTO = 0x2000000
	// Position of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Pos = 0x18
	// Bit mask of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Msk = 0x1000000
	// Bit JAWD1EN.
	ADC_CFGR_JAWD1EN = 0x1000000
	// Position of AWD1EN field.
	ADC_CFGR_AWD1EN_Pos = 0x17
	// Bit mask of AWD1EN field.
	ADC_CFGR_AWD1EN_Msk = 0x800000
	// Bit AWD1EN.
	ADC_CFGR_AWD1EN = 0x800000
	// Position of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Pos = 0x16
	// Bit mask of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Msk = 0x400000
	// Bit AWD1SGL.
	ADC_CFGR_AWD1SGL = 0x400000
	// Position of JQM field.
	ADC_CFGR_JQM_Pos = 0x15
	// Bit mask of JQM field.
	ADC_CFGR_JQM_Msk = 0x200000
	// Bit JQM.
	ADC_CFGR_JQM = 0x200000
	// Position of JDISCEN field.
	ADC_CFGR_JDISCEN_Pos = 0x14
	// Bit mask of JDISCEN field.
	ADC_CFGR_JDISCEN_Msk = 0x100000
	// Bit JDISCEN.
	ADC_CFGR_JDISCEN = 0x100000
	// Position of DISCNUM field.
	ADC_CFGR_DISCNUM_Pos = 0x11
	// Bit mask of DISCNUM field.
	ADC_CFGR_DISCNUM_Msk = 0xe0000
	// Position of DISCEN field.
	ADC_CFGR_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_CFGR_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_CFGR_DISCEN = 0x10000
	// Position of AUTOFF field.
	ADC_CFGR_AUTOFF_Pos = 0xf
	// Bit mask of AUTOFF field.
	ADC_CFGR_AUTOFF_Msk = 0x8000
	// Bit AUTOFF.
	ADC_CFGR_AUTOFF = 0x8000
	// Position of AUTDLY field.
	ADC_CFGR_AUTDLY_Pos = 0xe
	// Bit mask of AUTDLY field.
	ADC_CFGR_AUTDLY_Msk = 0x4000
	// Bit AUTDLY.
	ADC_CFGR_AUTDLY = 0x4000
	// Position of CONT field.
	ADC_CFGR_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_CFGR_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_CFGR_CONT = 0x2000
	// Position of OVRMOD field.
	ADC_CFGR_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_CFGR_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_CFGR_OVRMOD = 0x1000
	// Position of EXTEN field.
	ADC_CFGR_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_CFGR_EXTEN_Msk = 0xc00
	// Position of EXTSEL field.
	ADC_CFGR_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_CFGR_EXTSEL_Msk = 0x3c0
	// Position of ALIGN field.
	ADC_CFGR_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_CFGR_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_CFGR_ALIGN = 0x20
	// Position of RES field.
	ADC_CFGR_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_CFGR_RES_Msk = 0x18
	// Position of DMACFG field.
	ADC_CFGR_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_CFGR_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_CFGR_DMACFG = 0x2
	// Position of DMAEN field.
	ADC_CFGR_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_CFGR_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_CFGR_DMAEN = 0x1

	// CFGR2: configuration register
	// Position of ROVSM field.
	ADC_CFGR2_ROVSM_Pos = 0xa
	// Bit mask of ROVSM field.
	ADC_CFGR2_ROVSM_Msk = 0x400
	// Bit ROVSM.
	ADC_CFGR2_ROVSM = 0x400
	// Position of TOVS field.
	ADC_CFGR2_TOVS_Pos = 0x9
	// Bit mask of TOVS field.
	ADC_CFGR2_TOVS_Msk = 0x200
	// Bit TOVS.
	ADC_CFGR2_TOVS = 0x200
	// Position of OVSS field.
	ADC_CFGR2_OVSS_Pos = 0x5
	// Bit mask of OVSS field.
	ADC_CFGR2_OVSS_Msk = 0x1e0
	// Position of OVSR field.
	ADC_CFGR2_OVSR_Pos = 0x2
	// Bit mask of OVSR field.
	ADC_CFGR2_OVSR_Msk = 0x1c
	// Position of JOVSE field.
	ADC_CFGR2_JOVSE_Pos = 0x1
	// Bit mask of JOVSE field.
	ADC_CFGR2_JOVSE_Msk = 0x2
	// Bit JOVSE.
	ADC_CFGR2_JOVSE = 0x2
	// Position of ROVSE field.
	ADC_CFGR2_ROVSE_Pos = 0x0
	// Bit mask of ROVSE field.
	ADC_CFGR2_ROVSE_Msk = 0x1
	// Bit ROVSE.
	ADC_CFGR2_ROVSE = 0x1

	// SMPR1: sample time register 1
	// Position of SMP9 field.
	ADC_SMPR1_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR1_SMP9_Msk = 0x38000000
	// Position of SMP8 field.
	ADC_SMPR1_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR1_SMP8_Msk = 0x7000000
	// Position of SMP7 field.
	ADC_SMPR1_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR1_SMP7_Msk = 0xe00000
	// Position of SMP6 field.
	ADC_SMPR1_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR1_SMP6_Msk = 0x1c0000
	// Position of SMP5 field.
	ADC_SMPR1_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR1_SMP5_Msk = 0x38000
	// Position of SMP4 field.
	ADC_SMPR1_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR1_SMP4_Msk = 0x7000
	// Position of SMP3 field.
	ADC_SMPR1_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR1_SMP3_Msk = 0xe00
	// Position of SMP2 field.
	ADC_SMPR1_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR1_SMP2_Msk = 0x1c0
	// Position of SMP1 field.
	ADC_SMPR1_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR1_SMP1_Msk = 0x38
	// Position of SMP0 field.
	ADC_SMPR1_SMP0_Pos = 0x0
	// Bit mask of SMP0 field.
	ADC_SMPR1_SMP0_Msk = 0x7

	// SMPR2: sample time register 2
	// Position of SMP18 field.
	ADC_SMPR2_SMP18_Pos = 0x18
	// Bit mask of SMP18 field.
	ADC_SMPR2_SMP18_Msk = 0x7000000
	// Position of SMP17 field.
	ADC_SMPR2_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR2_SMP17_Msk = 0xe00000
	// Position of SMP16 field.
	ADC_SMPR2_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR2_SMP16_Msk = 0x1c0000
	// Position of SMP15 field.
	ADC_SMPR2_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR2_SMP15_Msk = 0x38000
	// Position of SMP14 field.
	ADC_SMPR2_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR2_SMP14_Msk = 0x7000
	// Position of SMP13 field.
	ADC_SMPR2_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR2_SMP13_Msk = 0xe00
	// Position of SMP12 field.
	ADC_SMPR2_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR2_SMP12_Msk = 0x1c0
	// Position of SMP11 field.
	ADC_SMPR2_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR2_SMP11_Msk = 0x38
	// Position of SMP10 field.
	ADC_SMPR2_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR2_SMP10_Msk = 0x7

	// TR1: watchdog threshold register 1
	// Position of HT1 field.
	ADC_TR1_HT1_Pos = 0x10
	// Bit mask of HT1 field.
	ADC_TR1_HT1_Msk = 0xfff0000
	// Position of LT1 field.
	ADC_TR1_LT1_Pos = 0x0
	// Bit mask of LT1 field.
	ADC_TR1_LT1_Msk = 0xfff

	// TR2: watchdog threshold register
	// Position of HT2 field.
	ADC_TR2_HT2_Pos = 0x10
	// Bit mask of HT2 field.
	ADC_TR2_HT2_Msk = 0xff0000
	// Position of LT2 field.
	ADC_TR2_LT2_Pos = 0x0
	// Bit mask of LT2 field.
	ADC_TR2_LT2_Msk = 0xff

	// TR3: watchdog threshold register 3
	// Position of HT3 field.
	ADC_TR3_HT3_Pos = 0x10
	// Bit mask of HT3 field.
	ADC_TR3_HT3_Msk = 0xff0000
	// Position of LT3 field.
	ADC_TR3_LT3_Pos = 0x0
	// Bit mask of LT3 field.
	ADC_TR3_LT3_Msk = 0xff

	// SQR1: regular sequence register 1
	// Position of SQ4 field.
	ADC_SQR1_SQ4_Pos = 0x18
	// Bit mask of SQ4 field.
	ADC_SQR1_SQ4_Msk = 0x1f000000
	// Position of SQ3 field.
	ADC_SQR1_SQ3_Pos = 0x12
	// Bit mask of SQ3 field.
	ADC_SQR1_SQ3_Msk = 0x7c0000
	// Position of SQ2 field.
	ADC_SQR1_SQ2_Pos = 0xc
	// Bit mask of SQ2 field.
	ADC_SQR1_SQ2_Msk = 0x1f000
	// Position of SQ1 field.
	ADC_SQR1_SQ1_Pos = 0x6
	// Bit mask of SQ1 field.
	ADC_SQR1_SQ1_Msk = 0x7c0
	// Position of L field.
	ADC_SQR1_L_Pos = 0x0
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf

	// SQR2: regular sequence register 2
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0x18
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x1f000000
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x12
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x7c0000
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0xc
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f000
	// Position of SQ6 field.
	ADC_SQR2_SQ6_Pos = 0x6
	// Bit mask of SQ6 field.
	ADC_SQR2_SQ6_Msk = 0x7c0
	// Position of SQ5 field.
	ADC_SQR2_SQ5_Pos = 0x0
	// Bit mask of SQ5 field.
	ADC_SQR2_SQ5_Msk = 0x1f

	// SQR3: regular sequence register 3
	// Position of SQ14 field.
	ADC_SQR3_SQ14_Pos = 0x18
	// Bit mask of SQ14 field.
	ADC_SQR3_SQ14_Msk = 0x1f000000
	// Position of SQ13 field.
	ADC_SQR3_SQ13_Pos = 0x12
	// Bit mask of SQ13 field.
	ADC_SQR3_SQ13_Msk = 0x7c0000
	// Position of SQ12 field.
	ADC_SQR3_SQ12_Pos = 0xc
	// Bit mask of SQ12 field.
	ADC_SQR3_SQ12_Msk = 0x1f000
	// Position of SQ11 field.
	ADC_SQR3_SQ11_Pos = 0x6
	// Bit mask of SQ11 field.
	ADC_SQR3_SQ11_Msk = 0x7c0
	// Position of SQ10 field.
	ADC_SQR3_SQ10_Pos = 0x0
	// Bit mask of SQ10 field.
	ADC_SQR3_SQ10_Msk = 0x1f

	// SQR4: regular sequence register 4
	// Position of SQ16 field.
	ADC_SQR4_SQ16_Pos = 0x6
	// Bit mask of SQ16 field.
	ADC_SQR4_SQ16_Msk = 0x7c0
	// Position of SQ15 field.
	ADC_SQR4_SQ15_Pos = 0x0
	// Bit mask of SQ15 field.
	ADC_SQR4_SQ15_Msk = 0x1f

	// DR: regular Data Register
	// Position of REGULARDATA field.
	ADC_DR_REGULARDATA_Pos = 0x0
	// Bit mask of REGULARDATA field.
	ADC_DR_REGULARDATA_Msk = 0xffff

	// JSQR: injected sequence register
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0x1a
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0x7c000000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0x14
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x1f00000
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0xe
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x7c000
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x8
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f00
	// Position of JEXTEN field.
	ADC_JSQR_JEXTEN_Pos = 0x6
	// Bit mask of JEXTEN field.
	ADC_JSQR_JEXTEN_Msk = 0xc0
	// Position of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Pos = 0x2
	// Bit mask of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Msk = 0x3c
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x0
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x3

	// OFR1: offset register 1
	// Position of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Pos = 0x1f
	// Bit mask of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Msk = 0x80000000
	// Bit OFFSET1_EN.
	ADC_OFR1_OFFSET1_EN = 0x80000000
	// Position of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Pos = 0x1a
	// Bit mask of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Msk = 0x7c000000
	// Position of OFFSET1 field.
	ADC_OFR1_OFFSET1_Pos = 0x0
	// Bit mask of OFFSET1 field.
	ADC_OFR1_OFFSET1_Msk = 0xfff

	// OFR2: offset register 2
	// Position of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Pos = 0x1f
	// Bit mask of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Msk = 0x80000000
	// Bit OFFSET2_EN.
	ADC_OFR2_OFFSET2_EN = 0x80000000
	// Position of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Pos = 0x1a
	// Bit mask of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Msk = 0x7c000000
	// Position of OFFSET2 field.
	ADC_OFR2_OFFSET2_Pos = 0x0
	// Bit mask of OFFSET2 field.
	ADC_OFR2_OFFSET2_Msk = 0xfff

	// OFR3: offset register 3
	// Position of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Pos = 0x1f
	// Bit mask of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Msk = 0x80000000
	// Bit OFFSET3_EN.
	ADC_OFR3_OFFSET3_EN = 0x80000000
	// Position of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Pos = 0x1a
	// Bit mask of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Msk = 0x7c000000
	// Position of OFFSET3 field.
	ADC_OFR3_OFFSET3_Pos = 0x0
	// Bit mask of OFFSET3 field.
	ADC_OFR3_OFFSET3_Msk = 0xfff

	// OFR4: offset register 4
	// Position of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Pos = 0x1f
	// Bit mask of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Msk = 0x80000000
	// Bit OFFSET4_EN.
	ADC_OFR4_OFFSET4_EN = 0x80000000
	// Position of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Pos = 0x1a
	// Bit mask of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Msk = 0x7c000000
	// Position of OFFSET4 field.
	ADC_OFR4_OFFSET4_Pos = 0x0
	// Bit mask of OFFSET4 field.
	ADC_OFR4_OFFSET4_Msk = 0xfff

	// JDR1: injected data register 1
	// Position of JDATA1 field.
	ADC_JDR1_JDATA1_Pos = 0x0
	// Bit mask of JDATA1 field.
	ADC_JDR1_JDATA1_Msk = 0xffff

	// JDR2: injected data register 2
	// Position of JDATA2 field.
	ADC_JDR2_JDATA2_Pos = 0x0
	// Bit mask of JDATA2 field.
	ADC_JDR2_JDATA2_Msk = 0xffff

	// JDR3: injected data register 3
	// Position of JDATA3 field.
	ADC_JDR3_JDATA3_Pos = 0x0
	// Bit mask of JDATA3 field.
	ADC_JDR3_JDATA3_Msk = 0xffff

	// JDR4: injected data register 4
	// Position of JDATA4 field.
	ADC_JDR4_JDATA4_Pos = 0x0
	// Bit mask of JDATA4 field.
	ADC_JDR4_JDATA4_Msk = 0xffff

	// AWD2CR: Analog Watchdog 2 Configuration Register
	// Position of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Pos = 0x1
	// Bit mask of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Msk = 0x7fffe

	// AWD3CR: Analog Watchdog 3 Configuration Register
	// Position of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Pos = 0x1
	// Bit mask of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Msk = 0x7fffe

	// DIFSEL: Differential Mode Selection Register 2
	// Position of DIFSEL_1_15 field.
	ADC_DIFSEL_DIFSEL_1_15_Pos = 0x1
	// Bit mask of DIFSEL_1_15 field.
	ADC_DIFSEL_DIFSEL_1_15_Msk = 0xfffe
	// Position of DIFSEL_16_18 field.
	ADC_DIFSEL_DIFSEL_16_18_Pos = 0x10
	// Bit mask of DIFSEL_16_18 field.
	ADC_DIFSEL_DIFSEL_16_18_Msk = 0x70000

	// CALFACT: Calibration Factors
	// Position of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Pos = 0x10
	// Bit mask of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Msk = 0x7f0000
	// Position of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Pos = 0x0
	// Bit mask of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Msk = 0x7f
)

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODER11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER11_Analog = 0x3
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODER10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER10_Analog = 0x3
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODER9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER9_Analog = 0x3
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODER8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER8_Analog = 0x3
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODER7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER7_Analog = 0x3
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODER6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER6_Analog = 0x3
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODER5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER5_Analog = 0x3
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODER4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER4_Analog = 0x3
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODER3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER3_Analog = 0x3
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODER2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER2_Analog = 0x3
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODER1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER1_Analog = 0x3
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODER0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER0_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR15_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR15_VeryHighSpeed = 0x3
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR14_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR14_VeryHighSpeed = 0x3
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR13_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR13_VeryHighSpeed = 0x3
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR12_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR12_VeryHighSpeed = 0x3
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR11_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR11_VeryHighSpeed = 0x3
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR10_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR10_VeryHighSpeed = 0x3
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR9_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR9_VeryHighSpeed = 0x3
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR8_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR8_VeryHighSpeed = 0x3
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR7_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR7_VeryHighSpeed = 0x3
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR6_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR6_VeryHighSpeed = 0x3
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEEDR5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR5_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR5_VeryHighSpeed = 0x3
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEEDR4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR4_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR4_VeryHighSpeed = 0x3
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEEDR3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR3_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR3_VeryHighSpeed = 0x3
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEEDR2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR2_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR2_VeryHighSpeed = 0x3
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEEDR1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR1_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR1_VeryHighSpeed = 0x3
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEEDR0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR0_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR0_VeryHighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR15_PullDown = 0x2
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR14_PullDown = 0x2
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR13_PullDown = 0x2
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR12_PullDown = 0x2
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR11_PullDown = 0x2
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR10_PullDown = 0x2
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR9_PullDown = 0x2
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR8_PullDown = 0x2
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR7_PullDown = 0x2
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR6_PullDown = 0x2
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR5_PullDown = 0x2
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR4_PullDown = 0x2
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR3_PullDown = 0x2
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR2_PullDown = 0x2
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR1_PullDown = 0x2
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFRL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL7_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL7_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL7_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL7_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL7_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL7_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL7_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL7_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL7_AF15 = 0xf
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFRL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL6_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL6_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL6_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL6_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL6_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL6_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL6_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL6_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL6_AF15 = 0xf
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFRL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL5_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL5_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL5_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL5_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL5_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL5_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL5_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL5_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL5_AF15 = 0xf
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFRL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL4_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL4_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL4_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL4_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL4_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL4_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL4_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL4_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL4_AF15 = 0xf
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFRL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL3_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL3_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL3_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL3_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL3_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL3_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL3_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL3_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL3_AF15 = 0xf
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFRL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL2_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL2_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL2_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL2_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL2_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL2_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL2_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL2_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL2_AF15 = 0xf
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFRL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL1_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL1_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL1_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL1_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL1_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL1_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL1_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL1_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL1_AF15 = 0xf
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFRL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL0_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL0_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL0_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL0_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL0_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL0_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL0_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL0_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL0_AF15 = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFRH15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH15_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH15_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH15_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH15_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH15_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH15_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH15_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH15_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH15_AF15 = 0xf
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFRH14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH14_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH14_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH14_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH14_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH14_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH14_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH14_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH14_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH14_AF15 = 0xf
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFRH13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH13_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH13_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH13_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH13_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH13_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH13_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH13_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH13_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH13_AF15 = 0xf
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFRH12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH12_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH12_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH12_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH12_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH12_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH12_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH12_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH12_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH12_AF15 = 0xf
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFRH11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH11_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH11_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH11_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH11_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH11_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH11_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH11_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH11_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH11_AF15 = 0xf
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFRH10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH10_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH10_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH10_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH10_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH10_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH10_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH10_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH10_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH10_AF15 = 0xf
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFRH9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH9_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH9_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH9_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH9_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH9_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH9_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH9_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH9_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH9_AF15 = 0xf
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFRH8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH8_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH8_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH8_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH8_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH8_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH8_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH8_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH8_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH8_AF15 = 0xf
)

// Bitfields for SAI1: Serial audio interface
const (
	// CH.CR1: AConfiguration register 1
	// Position of MCKDIV field.
	SAI_CH_CR1_MCKDIV_Pos = 0x14
	// Bit mask of MCKDIV field.
	SAI_CH_CR1_MCKDIV_Msk = 0xf00000
	// Position of NODIV field.
	SAI_CH_CR1_NODIV_Pos = 0x13
	// Bit mask of NODIV field.
	SAI_CH_CR1_NODIV_Msk = 0x80000
	// Bit NODIV.
	SAI_CH_CR1_NODIV = 0x80000
	// Master clock generator is enabled
	SAI_CH_CR1_NODIV_MasterClock = 0x0
	// No divider used in the clock generator (in this case Master Clock Divider bit has no effect)
	SAI_CH_CR1_NODIV_NoDiv = 0x1
	// Position of DMAEN field.
	SAI_CH_CR1_DMAEN_Pos = 0x11
	// Bit mask of DMAEN field.
	SAI_CH_CR1_DMAEN_Msk = 0x20000
	// Bit DMAEN.
	SAI_CH_CR1_DMAEN = 0x20000
	// DMA disabled
	SAI_CH_CR1_DMAEN_Disabled = 0x0
	// DMA enabled
	SAI_CH_CR1_DMAEN_Enabled = 0x1
	// Position of SAIEN field.
	SAI_CH_CR1_SAIEN_Pos = 0x10
	// Bit mask of SAIEN field.
	SAI_CH_CR1_SAIEN_Msk = 0x10000
	// Bit SAIEN.
	SAI_CH_CR1_SAIEN = 0x10000
	// SAI audio block disabled
	SAI_CH_CR1_SAIEN_Disabled = 0x0
	// SAI audio block enabled
	SAI_CH_CR1_SAIEN_Enabled = 0x1
	// Position of OUTDRIV field.
	SAI_CH_CR1_OUTDRIV_Pos = 0xd
	// Bit mask of OUTDRIV field.
	SAI_CH_CR1_OUTDRIV_Msk = 0x2000
	// Bit OUTDRIV.
	SAI_CH_CR1_OUTDRIV = 0x2000
	// Audio block output driven when SAIEN is set
	SAI_CH_CR1_OUTDRIV_OnStart = 0x0
	// Audio block output driven immediately after the setting of this bit
	SAI_CH_CR1_OUTDRIV_Immediately = 0x1
	// Position of MONO field.
	SAI_CH_CR1_MONO_Pos = 0xc
	// Bit mask of MONO field.
	SAI_CH_CR1_MONO_Msk = 0x1000
	// Bit MONO.
	SAI_CH_CR1_MONO = 0x1000
	// Stereo mode
	SAI_CH_CR1_MONO_Stereo = 0x0
	// Mono mode
	SAI_CH_CR1_MONO_Mono = 0x1
	// Position of SYNCEN field.
	SAI_CH_CR1_SYNCEN_Pos = 0xa
	// Bit mask of SYNCEN field.
	SAI_CH_CR1_SYNCEN_Msk = 0xc00
	// audio sub-block in asynchronous mode
	SAI_CH_CR1_SYNCEN_Asynchronous = 0x0
	// audio sub-block is synchronous with the other internal audio sub-block. In this case, the audio sub-block must be configured in slave mode
	SAI_CH_CR1_SYNCEN_Internal = 0x1
	// audio sub-block is synchronous with an external SAI embedded peripheral. In this case the audio sub-block should be configured in Slave mode
	SAI_CH_CR1_SYNCEN_External = 0x2
	// Position of CKSTR field.
	SAI_CH_CR1_CKSTR_Pos = 0x9
	// Bit mask of CKSTR field.
	SAI_CH_CR1_CKSTR_Msk = 0x200
	// Bit CKSTR.
	SAI_CH_CR1_CKSTR = 0x200
	// Data strobing edge is falling edge of SCK
	SAI_CH_CR1_CKSTR_FallingEdge = 0x0
	// Data strobing edge is rising edge of SCK
	SAI_CH_CR1_CKSTR_RisingEdge = 0x1
	// Position of LSBFIRST field.
	SAI_CH_CR1_LSBFIRST_Pos = 0x8
	// Bit mask of LSBFIRST field.
	SAI_CH_CR1_LSBFIRST_Msk = 0x100
	// Bit LSBFIRST.
	SAI_CH_CR1_LSBFIRST = 0x100
	// Data are transferred with MSB first
	SAI_CH_CR1_LSBFIRST_MsbFirst = 0x0
	// Data are transferred with LSB first
	SAI_CH_CR1_LSBFIRST_LsbFirst = 0x1
	// Position of DS field.
	SAI_CH_CR1_DS_Pos = 0x5
	// Bit mask of DS field.
	SAI_CH_CR1_DS_Msk = 0xe0
	// 8 bits
	SAI_CH_CR1_DS_Bit8 = 0x2
	// 10 bits
	SAI_CH_CR1_DS_Bit10 = 0x3
	// 16 bits
	SAI_CH_CR1_DS_Bit16 = 0x4
	// 20 bits
	SAI_CH_CR1_DS_Bit20 = 0x5
	// 24 bits
	SAI_CH_CR1_DS_Bit24 = 0x6
	// 32 bits
	SAI_CH_CR1_DS_Bit32 = 0x7
	// Position of PRTCFG field.
	SAI_CH_CR1_PRTCFG_Pos = 0x2
	// Bit mask of PRTCFG field.
	SAI_CH_CR1_PRTCFG_Msk = 0xc
	// Free protocol. Free protocol allows to use the powerful configuration of the audio block to address a specific audio protocol
	SAI_CH_CR1_PRTCFG_Free = 0x0
	// SPDIF protocol
	SAI_CH_CR1_PRTCFG_Spdif = 0x1
	// AC’97 protocol
	SAI_CH_CR1_PRTCFG_Ac97 = 0x2
	// Position of MODE field.
	SAI_CH_CR1_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SAI_CH_CR1_MODE_Msk = 0x3
	// Master transmitter
	SAI_CH_CR1_MODE_MasterTx = 0x0
	// Master receiver
	SAI_CH_CR1_MODE_MasterRx = 0x1
	// Slave transmitter
	SAI_CH_CR1_MODE_SlaveTx = 0x2
	// Slave receiver
	SAI_CH_CR1_MODE_SlaveRx = 0x3

	// CH.CR2: AConfiguration register 2
	// Position of COMP field.
	SAI_CH_CR2_COMP_Pos = 0xe
	// Bit mask of COMP field.
	SAI_CH_CR2_COMP_Msk = 0xc000
	// No companding algorithm
	SAI_CH_CR2_COMP_NoCompanding = 0x0
	// μ-Law algorithm
	SAI_CH_CR2_COMP_MuLaw = 0x2
	// A-Law algorithm
	SAI_CH_CR2_COMP_ALaw = 0x3
	// Position of CPL field.
	SAI_CH_CR2_CPL_Pos = 0xd
	// Bit mask of CPL field.
	SAI_CH_CR2_CPL_Msk = 0x2000
	// Bit CPL.
	SAI_CH_CR2_CPL = 0x2000
	// 1’s complement representation
	SAI_CH_CR2_CPL_OnesComplement = 0x0
	// 2’s complement representation
	SAI_CH_CR2_CPL_TwosComplement = 0x1
	// Position of MUTECN field.
	SAI_CH_CR2_MUTECN_Pos = 0x7
	// Bit mask of MUTECN field.
	SAI_CH_CR2_MUTECN_Msk = 0x1f80
	// Position of MUTEVAL field.
	SAI_CH_CR2_MUTEVAL_Pos = 0x6
	// Bit mask of MUTEVAL field.
	SAI_CH_CR2_MUTEVAL_Msk = 0x40
	// Bit MUTEVAL.
	SAI_CH_CR2_MUTEVAL = 0x40
	// Bit value 0 is sent during the mute mode
	SAI_CH_CR2_MUTEVAL_SendZero = 0x0
	// Last values are sent during the mute mode
	SAI_CH_CR2_MUTEVAL_SendLast = 0x1
	// Position of MUTE field.
	SAI_CH_CR2_MUTE_Pos = 0x5
	// Bit mask of MUTE field.
	SAI_CH_CR2_MUTE_Msk = 0x20
	// Bit MUTE.
	SAI_CH_CR2_MUTE = 0x20
	// No mute mode
	SAI_CH_CR2_MUTE_Disabled = 0x0
	// Mute mode enabled
	SAI_CH_CR2_MUTE_Enabled = 0x1
	// Position of TRIS field.
	SAI_CH_CR2_TRIS_Pos = 0x4
	// Bit mask of TRIS field.
	SAI_CH_CR2_TRIS_Msk = 0x10
	// Bit TRIS.
	SAI_CH_CR2_TRIS = 0x10
	// Position of FFLUSH field.
	SAI_CH_CR2_FFLUSH_Pos = 0x3
	// Bit mask of FFLUSH field.
	SAI_CH_CR2_FFLUSH_Msk = 0x8
	// Bit FFLUSH.
	SAI_CH_CR2_FFLUSH = 0x8
	// No FIFO flush
	SAI_CH_CR2_FFLUSH_NoFlush = 0x0
	// FIFO flush. Programming this bit to 1 triggers the FIFO Flush. All the internal FIFO pointers (read and write) are cleared
	SAI_CH_CR2_FFLUSH_Flush = 0x1
	// Position of FTH field.
	SAI_CH_CR2_FTH_Pos = 0x0
	// Bit mask of FTH field.
	SAI_CH_CR2_FTH_Msk = 0x7
	// FIFO empty
	SAI_CH_CR2_FTH_Empty = 0x0
	// 1⁄4 FIFO
	SAI_CH_CR2_FTH_Quarter1 = 0x1
	// 1⁄2 FIFO
	SAI_CH_CR2_FTH_Quarter2 = 0x2
	// 3⁄4 FIFO
	SAI_CH_CR2_FTH_Quarter3 = 0x3
	// FIFO full
	SAI_CH_CR2_FTH_Full = 0x4

	// CH.FRCR: AFRCR
	// Position of FSOFF field.
	SAI_CH_FRCR_FSOFF_Pos = 0x12
	// Bit mask of FSOFF field.
	SAI_CH_FRCR_FSOFF_Msk = 0x40000
	// Bit FSOFF.
	SAI_CH_FRCR_FSOFF = 0x40000
	// FS is asserted on the first bit of the slot 0
	SAI_CH_FRCR_FSOFF_OnFirst = 0x0
	// FS is asserted one bit before the first bit of the slot 0
	SAI_CH_FRCR_FSOFF_BeforeFirst = 0x1
	// Position of FSPOL field.
	SAI_CH_FRCR_FSPOL_Pos = 0x11
	// Bit mask of FSPOL field.
	SAI_CH_FRCR_FSPOL_Msk = 0x20000
	// Bit FSPOL.
	SAI_CH_FRCR_FSPOL = 0x20000
	// FS is active low (falling edge)
	SAI_CH_FRCR_FSPOL_FallingEdge = 0x0
	// FS is active high (rising edge)
	SAI_CH_FRCR_FSPOL_RisingEdge = 0x1
	// Position of FSDEF field.
	SAI_CH_FRCR_FSDEF_Pos = 0x10
	// Bit mask of FSDEF field.
	SAI_CH_FRCR_FSDEF_Msk = 0x10000
	// Bit FSDEF.
	SAI_CH_FRCR_FSDEF = 0x10000
	// Position of FSALL field.
	SAI_CH_FRCR_FSALL_Pos = 0x8
	// Bit mask of FSALL field.
	SAI_CH_FRCR_FSALL_Msk = 0x7f00
	// Position of FRL field.
	SAI_CH_FRCR_FRL_Pos = 0x0
	// Bit mask of FRL field.
	SAI_CH_FRCR_FRL_Msk = 0xff

	// CH.SLOTR: ASlot register
	// Position of SLOTEN field.
	SAI_CH_SLOTR_SLOTEN_Pos = 0x10
	// Bit mask of SLOTEN field.
	SAI_CH_SLOTR_SLOTEN_Msk = 0xffff0000
	// Inactive slot
	SAI_CH_SLOTR_SLOTEN_Inactive = 0x0
	// Active slot
	SAI_CH_SLOTR_SLOTEN_Active = 0x1
	// Position of NBSLOT field.
	SAI_CH_SLOTR_NBSLOT_Pos = 0x8
	// Bit mask of NBSLOT field.
	SAI_CH_SLOTR_NBSLOT_Msk = 0xf00
	// Position of SLOTSZ field.
	SAI_CH_SLOTR_SLOTSZ_Pos = 0x6
	// Bit mask of SLOTSZ field.
	SAI_CH_SLOTR_SLOTSZ_Msk = 0xc0
	// The slot size is equivalent to the data size (specified in DS[3:0] in the SAI_xCR1 register)
	SAI_CH_SLOTR_SLOTSZ_DataSize = 0x0
	// 16-bit
	SAI_CH_SLOTR_SLOTSZ_Bit16 = 0x1
	// 32-bit
	SAI_CH_SLOTR_SLOTSZ_Bit32 = 0x2
	// Position of FBOFF field.
	SAI_CH_SLOTR_FBOFF_Pos = 0x0
	// Bit mask of FBOFF field.
	SAI_CH_SLOTR_FBOFF_Msk = 0x1f

	// CH.IM: AInterrupt mask register2
	// Position of LFSDETIE field.
	SAI_CH_IM_LFSDETIE_Pos = 0x6
	// Bit mask of LFSDETIE field.
	SAI_CH_IM_LFSDETIE_Msk = 0x40
	// Bit LFSDETIE.
	SAI_CH_IM_LFSDETIE = 0x40
	// Interrupt is disabled
	SAI_CH_IM_LFSDETIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_LFSDETIE_Enabled = 0x1
	// Position of AFSDETIE field.
	SAI_CH_IM_AFSDETIE_Pos = 0x5
	// Bit mask of AFSDETIE field.
	SAI_CH_IM_AFSDETIE_Msk = 0x20
	// Bit AFSDETIE.
	SAI_CH_IM_AFSDETIE = 0x20
	// Interrupt is disabled
	SAI_CH_IM_AFSDETIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_AFSDETIE_Enabled = 0x1
	// Position of CNRDYIE field.
	SAI_CH_IM_CNRDYIE_Pos = 0x4
	// Bit mask of CNRDYIE field.
	SAI_CH_IM_CNRDYIE_Msk = 0x10
	// Bit CNRDYIE.
	SAI_CH_IM_CNRDYIE = 0x10
	// Interrupt is disabled
	SAI_CH_IM_CNRDYIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_CNRDYIE_Enabled = 0x1
	// Position of FREQIE field.
	SAI_CH_IM_FREQIE_Pos = 0x3
	// Bit mask of FREQIE field.
	SAI_CH_IM_FREQIE_Msk = 0x8
	// Bit FREQIE.
	SAI_CH_IM_FREQIE = 0x8
	// Interrupt is disabled
	SAI_CH_IM_FREQIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_FREQIE_Enabled = 0x1
	// Position of WCKCFGIE field.
	SAI_CH_IM_WCKCFGIE_Pos = 0x2
	// Bit mask of WCKCFGIE field.
	SAI_CH_IM_WCKCFGIE_Msk = 0x4
	// Bit WCKCFGIE.
	SAI_CH_IM_WCKCFGIE = 0x4
	// Interrupt is disabled
	SAI_CH_IM_WCKCFGIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_WCKCFGIE_Enabled = 0x1
	// Position of MUTEDETIE field.
	SAI_CH_IM_MUTEDETIE_Pos = 0x1
	// Bit mask of MUTEDETIE field.
	SAI_CH_IM_MUTEDETIE_Msk = 0x2
	// Bit MUTEDETIE.
	SAI_CH_IM_MUTEDETIE = 0x2
	// Interrupt is disabled
	SAI_CH_IM_MUTEDETIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_MUTEDETIE_Enabled = 0x1
	// Position of OVRUDRIE field.
	SAI_CH_IM_OVRUDRIE_Pos = 0x0
	// Bit mask of OVRUDRIE field.
	SAI_CH_IM_OVRUDRIE_Msk = 0x1
	// Bit OVRUDRIE.
	SAI_CH_IM_OVRUDRIE = 0x1
	// Interrupt is disabled
	SAI_CH_IM_OVRUDRIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_OVRUDRIE_Enabled = 0x1

	// CH.SR: AStatus register
	// Position of FLVL field.
	SAI_CH_SR_FLVL_Pos = 0x10
	// Bit mask of FLVL field.
	SAI_CH_SR_FLVL_Msk = 0x70000
	// FIFO empty
	SAI_CH_SR_FLVL_Empty = 0x0
	// FIFO <= 1⁄4 but not empty
	SAI_CH_SR_FLVL_Quarter1 = 0x1
	// 1⁄4 < FIFO <= 1⁄2
	SAI_CH_SR_FLVL_Quarter2 = 0x2
	// 1⁄2 < FIFO <= 3⁄4
	SAI_CH_SR_FLVL_Quarter3 = 0x3
	// 3⁄4 < FIFO but not full
	SAI_CH_SR_FLVL_Quarter4 = 0x4
	// FIFO full
	SAI_CH_SR_FLVL_Full = 0x5
	// Position of LFSDET field.
	SAI_CH_SR_LFSDET_Pos = 0x6
	// Bit mask of LFSDET field.
	SAI_CH_SR_LFSDET_Msk = 0x40
	// Bit LFSDET.
	SAI_CH_SR_LFSDET = 0x40
	// No error
	SAI_CH_SR_LFSDET_NoError = 0x0
	// Frame synchronization signal is not present at the right time
	SAI_CH_SR_LFSDET_NoSync = 0x1
	// Position of AFSDET field.
	SAI_CH_SR_AFSDET_Pos = 0x5
	// Bit mask of AFSDET field.
	SAI_CH_SR_AFSDET_Msk = 0x20
	// Bit AFSDET.
	SAI_CH_SR_AFSDET = 0x20
	// No error
	SAI_CH_SR_AFSDET_NoError = 0x0
	// Frame synchronization signal is detected earlier than expected
	SAI_CH_SR_AFSDET_EarlySync = 0x1
	// Position of CNRDY field.
	SAI_CH_SR_CNRDY_Pos = 0x4
	// Bit mask of CNRDY field.
	SAI_CH_SR_CNRDY_Msk = 0x10
	// Bit CNRDY.
	SAI_CH_SR_CNRDY = 0x10
	// External AC’97 Codec is ready
	SAI_CH_SR_CNRDY_Ready = 0x0
	// External AC’97 Codec is not ready
	SAI_CH_SR_CNRDY_NotReady = 0x1
	// Position of FREQ field.
	SAI_CH_SR_FREQ_Pos = 0x3
	// Bit mask of FREQ field.
	SAI_CH_SR_FREQ_Msk = 0x8
	// Bit FREQ.
	SAI_CH_SR_FREQ = 0x8
	// No FIFO request
	SAI_CH_SR_FREQ_NoRequest = 0x0
	// FIFO request to read or to write the SAI_xDR
	SAI_CH_SR_FREQ_Request = 0x1
	// Position of WCKCFG field.
	SAI_CH_SR_WCKCFG_Pos = 0x2
	// Bit mask of WCKCFG field.
	SAI_CH_SR_WCKCFG_Msk = 0x4
	// Bit WCKCFG.
	SAI_CH_SR_WCKCFG = 0x4
	// Clock configuration is correct
	SAI_CH_SR_WCKCFG_Correct = 0x0
	// Clock configuration does not respect the rule concerning the frame length specification
	SAI_CH_SR_WCKCFG_Wrong = 0x1
	// Position of MUTEDET field.
	SAI_CH_SR_MUTEDET_Pos = 0x1
	// Bit mask of MUTEDET field.
	SAI_CH_SR_MUTEDET_Msk = 0x2
	// Bit MUTEDET.
	SAI_CH_SR_MUTEDET = 0x2
	// No MUTE detection on the SD input line
	SAI_CH_SR_MUTEDET_NoMute = 0x0
	// MUTE value detected on the SD input line (0 value) for a specified number of consecutive audio frame
	SAI_CH_SR_MUTEDET_Mute = 0x1
	// Position of OVRUDR field.
	SAI_CH_SR_OVRUDR_Pos = 0x0
	// Bit mask of OVRUDR field.
	SAI_CH_SR_OVRUDR_Msk = 0x1
	// Bit OVRUDR.
	SAI_CH_SR_OVRUDR = 0x1
	// No overrun/underrun error
	SAI_CH_SR_OVRUDR_NoError = 0x0
	// Overrun/underrun error detection
	SAI_CH_SR_OVRUDR_Overrun = 0x1

	// CH.CLRFR: AClear flag register
	// Position of CLFSDET field.
	SAI_CH_CLRFR_CLFSDET_Pos = 0x6
	// Bit mask of CLFSDET field.
	SAI_CH_CLRFR_CLFSDET_Msk = 0x40
	// Bit CLFSDET.
	SAI_CH_CLRFR_CLFSDET = 0x40
	// Clears the LFSDET flag
	SAI_CH_CLRFR_CLFSDET_Clear = 0x1
	// Position of CAFSDET field.
	SAI_CH_CLRFR_CAFSDET_Pos = 0x5
	// Bit mask of CAFSDET field.
	SAI_CH_CLRFR_CAFSDET_Msk = 0x20
	// Bit CAFSDET.
	SAI_CH_CLRFR_CAFSDET = 0x20
	// Clears the AFSDET flag
	SAI_CH_CLRFR_CAFSDET_Clear = 0x1
	// Position of CCNRDY field.
	SAI_CH_CLRFR_CCNRDY_Pos = 0x4
	// Bit mask of CCNRDY field.
	SAI_CH_CLRFR_CCNRDY_Msk = 0x10
	// Bit CCNRDY.
	SAI_CH_CLRFR_CCNRDY = 0x10
	// Clears the CNRDY flag
	SAI_CH_CLRFR_CCNRDY_Clear = 0x1
	// Position of CWCKCFG field.
	SAI_CH_CLRFR_CWCKCFG_Pos = 0x2
	// Bit mask of CWCKCFG field.
	SAI_CH_CLRFR_CWCKCFG_Msk = 0x4
	// Bit CWCKCFG.
	SAI_CH_CLRFR_CWCKCFG = 0x4
	// Clears the WCKCFG flag
	SAI_CH_CLRFR_CWCKCFG_Clear = 0x1
	// Position of CMUTEDET field.
	SAI_CH_CLRFR_CMUTEDET_Pos = 0x1
	// Bit mask of CMUTEDET field.
	SAI_CH_CLRFR_CMUTEDET_Msk = 0x2
	// Bit CMUTEDET.
	SAI_CH_CLRFR_CMUTEDET = 0x2
	// Clears the MUTEDET flag
	SAI_CH_CLRFR_CMUTEDET_Clear = 0x1
	// Position of COVRUDR field.
	SAI_CH_CLRFR_COVRUDR_Pos = 0x0
	// Bit mask of COVRUDR field.
	SAI_CH_CLRFR_COVRUDR_Msk = 0x1
	// Bit COVRUDR.
	SAI_CH_CLRFR_COVRUDR = 0x1
	// Clears the OVRUDR flag
	SAI_CH_CLRFR_COVRUDR_Clear = 0x1

	// CH.DR: AData register
	// Position of DATA field.
	SAI_CH_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SAI_CH_DR_DATA_Msk = 0xffffffff
)

// Bitfields for TIM2: General-purpose-timers
const (
	// CR1: control register 1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1

	// CR2: control register 2
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1

	// SMCR: slave mode control register
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR1_Output_OC2M_OpmMode1 = 0x8
	// Inversely to OpmMode1
	TIM_CCMR1_Output_OC2M_OpmMode2 = 0x9
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_CombinedPwmMode1 = 0xc
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_CombinedPwmMode2 = 0xd
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC2M_AsymmetricPwmMode1 = 0xe
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC2M_AsymmetricPwmMode2 = 0xf
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIM_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR1_Output_OC1M_OpmMode1 = 0x8
	// Inversely to OpmMode1
	TIM_CCMR1_Output_OC1M_OpmMode2 = 0x9
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR1_Output_OC1M_CombinedPwmMode1 = 0xc
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR1_Output_OC1M_CombinedPwmMode2 = 0xd
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC1M_AsymmetricPwmMode1 = 0xe
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC1M_AsymmetricPwmMode2 = 0xf
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIM_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_Output = 0x0

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIM_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIM_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC4M_OpmMode1 = 0x8
	// Inversely to OpmMode1
	TIM_CCMR2_Output_OC4M_OpmMode2 = 0x9
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_CombinedPwmMode1 = 0xc
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_CombinedPwmMode2 = 0xd
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC4M_AsymmetricPwmMode1 = 0xe
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC4M_AsymmetricPwmMode2 = 0xf
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIM_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC3M_OpmMode1 = 0x8
	// Inversely to OpmMode1
	TIM_CCMR2_Output_OC3M_OpmMode2 = 0x9
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_CombinedPwmMode1 = 0xc
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_CombinedPwmMode2 = 0xd
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC3M_AsymmetricPwmMode1 = 0xe
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC3M_AsymmetricPwmMode2 = 0xf
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIM_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_Output = 0x0

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIM_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIM_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC4NP field.
	TIM_CCER_CC4NP_Pos = 0xf
	// Bit mask of CC4NP field.
	TIM_CCER_CC4NP_Msk = 0x8000
	// Bit CC4NP.
	TIM_CCER_CC4NP = 0x8000
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffffffff

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffffffff

	// CCR1: capture/compare register 1
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffffffff

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff

	// OR: TIM2 option register
	// Position of ETR_RMP field.
	TIM_OR_ETR_RMP_Pos = 0x0
	// Bit mask of ETR_RMP field.
	TIM_OR_ETR_RMP_Msk = 0x7
	// Position of TI4_RMP field.
	TIM_OR_TI4_RMP_Pos = 0x3
	// Bit mask of TI4_RMP field.
	TIM_OR_TI4_RMP_Msk = 0x18
)

// Bitfields for LPTIM1: Low power timer
const (
	// ISR: Interrupt and Status Register
	// Position of DOWN field.
	LPTIM_ISR_DOWN_Pos = 0x6
	// Bit mask of DOWN field.
	LPTIM_ISR_DOWN_Msk = 0x40
	// Bit DOWN.
	LPTIM_ISR_DOWN = 0x40
	// Position of UP field.
	LPTIM_ISR_UP_Pos = 0x5
	// Bit mask of UP field.
	LPTIM_ISR_UP_Msk = 0x20
	// Bit UP.
	LPTIM_ISR_UP = 0x20
	// Position of ARROK field.
	LPTIM_ISR_ARROK_Pos = 0x4
	// Bit mask of ARROK field.
	LPTIM_ISR_ARROK_Msk = 0x10
	// Bit ARROK.
	LPTIM_ISR_ARROK = 0x10
	// Position of CMPOK field.
	LPTIM_ISR_CMPOK_Pos = 0x3
	// Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK_Msk = 0x8
	// Bit CMPOK.
	LPTIM_ISR_CMPOK = 0x8
	// Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Pos = 0x2
	// Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4
	// Bit EXTTRIG.
	LPTIM_ISR_EXTTRIG = 0x4
	// Position of ARRM field.
	LPTIM_ISR_ARRM_Pos = 0x1
	// Bit mask of ARRM field.
	LPTIM_ISR_ARRM_Msk = 0x2
	// Bit ARRM.
	LPTIM_ISR_ARRM = 0x2
	// Position of CMPM field.
	LPTIM_ISR_CMPM_Pos = 0x0
	// Bit mask of CMPM field.
	LPTIM_ISR_CMPM_Msk = 0x1
	// Bit CMPM.
	LPTIM_ISR_CMPM = 0x1

	// ICR: Interrupt Clear Register
	// Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Pos = 0x6
	// Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk = 0x40
	// Bit DOWNCF.
	LPTIM_ICR_DOWNCF = 0x40
	// Position of UPCF field.
	LPTIM_ICR_UPCF_Pos = 0x5
	// Bit mask of UPCF field.
	LPTIM_ICR_UPCF_Msk = 0x20
	// Bit UPCF.
	LPTIM_ICR_UPCF = 0x20
	// Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Pos = 0x4
	// Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk = 0x10
	// Bit ARROKCF.
	LPTIM_ICR_ARROKCF = 0x10
	// Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Pos = 0x3
	// Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk = 0x8
	// Bit CMPOKCF.
	LPTIM_ICR_CMPOKCF = 0x8
	// Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2
	// Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4
	// Bit EXTTRIGCF.
	LPTIM_ICR_EXTTRIGCF = 0x4
	// Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Pos = 0x1
	// Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk = 0x2
	// Bit ARRMCF.
	LPTIM_ICR_ARRMCF = 0x2
	// Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Pos = 0x0
	// Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk = 0x1
	// Bit CMPMCF.
	LPTIM_ICR_CMPMCF = 0x1

	// IER: Interrupt Enable Register
	// Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Pos = 0x6
	// Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk = 0x40
	// Bit DOWNIE.
	LPTIM_IER_DOWNIE = 0x40
	// Position of UPIE field.
	LPTIM_IER_UPIE_Pos = 0x5
	// Bit mask of UPIE field.
	LPTIM_IER_UPIE_Msk = 0x20
	// Bit UPIE.
	LPTIM_IER_UPIE = 0x20
	// Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Pos = 0x4
	// Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk = 0x10
	// Bit ARROKIE.
	LPTIM_IER_ARROKIE = 0x10
	// Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Pos = 0x3
	// Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk = 0x8
	// Bit CMPOKIE.
	LPTIM_IER_CMPOKIE = 0x8
	// Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2
	// Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4
	// Bit EXTTRIGIE.
	LPTIM_IER_EXTTRIGIE = 0x4
	// Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Pos = 0x1
	// Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk = 0x2
	// Bit ARRMIE.
	LPTIM_IER_ARRMIE = 0x2
	// Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Pos = 0x0
	// Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk = 0x1
	// Bit CMPMIE.
	LPTIM_IER_CMPMIE = 0x1

	// CFGR: Configuration Register
	// Position of ENC field.
	LPTIM_CFGR_ENC_Pos = 0x18
	// Bit mask of ENC field.
	LPTIM_CFGR_ENC_Msk = 0x1000000
	// Bit ENC.
	LPTIM_CFGR_ENC = 0x1000000
	// Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17
	// Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000
	// Bit COUNTMODE.
	LPTIM_CFGR_COUNTMODE = 0x800000
	// Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Pos = 0x16
	// Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk = 0x400000
	// Bit PRELOAD.
	LPTIM_CFGR_PRELOAD = 0x400000
	// Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Pos = 0x15
	// Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk = 0x200000
	// Bit WAVPOL.
	LPTIM_CFGR_WAVPOL = 0x200000
	// Position of WAVE field.
	LPTIM_CFGR_WAVE_Pos = 0x14
	// Bit mask of WAVE field.
	LPTIM_CFGR_WAVE_Msk = 0x100000
	// Bit WAVE.
	LPTIM_CFGR_WAVE = 0x100000
	// Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Pos = 0x13
	// Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk = 0x80000
	// Bit TIMOUT.
	LPTIM_CFGR_TIMOUT = 0x80000
	// Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Pos = 0x11
	// Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk = 0x60000
	// Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Pos = 0xd
	// Bit mask of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk = 0xe000
	// Position of PRESC field.
	LPTIM_CFGR_PRESC_Pos = 0x9
	// Bit mask of PRESC field.
	LPTIM_CFGR_PRESC_Msk = 0xe00
	// Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Pos = 0x6
	// Bit mask of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk = 0xc0
	// Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Pos = 0x3
	// Bit mask of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk = 0x18
	// Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Pos = 0x1
	// Bit mask of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk = 0x6
	// Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk = 0x1
	// Bit CKSEL.
	LPTIM_CFGR_CKSEL = 0x1

	// CR: Control Register
	// Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Pos = 0x2
	// Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4
	// Bit CNTSTRT.
	LPTIM_CR_CNTSTRT = 0x4
	// Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Pos = 0x1
	// Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2
	// Bit SNGSTRT.
	LPTIM_CR_SNGSTRT = 0x2
	// Position of ENABLE field.
	LPTIM_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPTIM_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	LPTIM_CR_ENABLE = 0x1

	// CMP: Compare Register
	// Position of CMP field.
	LPTIM_CMP_CMP_Pos = 0x0
	// Bit mask of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff

	// ARR: Autoreload Register
	// Position of ARR field.
	LPTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff

	// CNT: Counter Register
	// Position of CNT field.
	LPTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	// Position of M1 field.
	USART_CR1_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_M1 = 0x10000000
	// Use M0 to set the data bits
	USART_CR1_M1_M0 = 0x0
	// 1 start bit, 7 data bits, n stop bits
	USART_CR1_M1_Bit7 = 0x1
	// Position of EOBIE field.
	USART_CR1_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_EOBIE = 0x8000000
	// Interrupt is inhibited
	USART_CR1_EOBIE_Disabled = 0x0
	// A USART interrupt is generated when the EOBF flag is set in the ISR register
	USART_CR1_EOBIE_Enabled = 0x1
	// Position of RTOIE field.
	USART_CR1_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_RTOIE = 0x4000000
	// Interrupt is inhibited
	USART_CR1_RTOIE_Disabled = 0x0
	// An USART interrupt is generated when the RTOF bit is set in the ISR register
	USART_CR1_RTOIE_Enabled = 0x1
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_OVER8_Oversampling16 = 0x0
	// Oversampling by 8
	USART_CR1_OVER8_Oversampling8 = 0x1
	// Position of CMIE field.
	USART_CR1_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_CMIE = 0x4000
	// Interrupt is disabled
	USART_CR1_CMIE_Disabled = 0x0
	// Interrupt is generated when the CMF bit is set in the ISR register
	USART_CR1_CMIE_Enabled = 0x1
	// Position of MME field.
	USART_CR1_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_MME = 0x2000
	// Receiver in active mode permanently
	USART_CR1_MME_Disabled = 0x0
	// Receiver can switch between mute mode and active mode
	USART_CR1_MME_Enabled = 0x1
	// Position of M0 field.
	USART_CR1_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_M0 = 0x1000
	// 1 start bit, 8 data bits, n stop bits
	USART_CR1_M0_Bit8 = 0x0
	// 1 start bit, 9 data bits, n stop bits
	USART_CR1_M0_Bit9 = 0x1
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// Idle line
	USART_CR1_WAKE_Idle = 0x0
	// Address mask
	USART_CR1_WAKE_Address = 0x1
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Parity control disabled
	USART_CR1_PCE_Disabled = 0x0
	// Parity control enabled
	USART_CR1_PCE_Enabled = 0x1
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Even parity
	USART_CR1_PS_Even = 0x0
	// Odd parity
	USART_CR1_PS_Odd = 0x1
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// Interrupt is disabled
	USART_CR1_PEIE_Disabled = 0x0
	// Interrupt is generated whenever PE=1 in the ISR register
	USART_CR1_PEIE_Enabled = 0x1
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// Interrupt is disabled
	USART_CR1_TXEIE_Disabled = 0x0
	// Interrupt is generated whenever TXE=1 in the ISR register
	USART_CR1_TXEIE_Enabled = 0x1
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// Interrupt is disabled
	USART_CR1_TCIE_Disabled = 0x0
	// Interrupt is generated whenever TC=1 in the ISR register
	USART_CR1_TCIE_Enabled = 0x1
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// Interrupt is disabled
	USART_CR1_RXNEIE_Disabled = 0x0
	// Interrupt is generated whenever ORE=1 or RXNE=1 in the ISR register
	USART_CR1_RXNEIE_Enabled = 0x1
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// Interrupt is disabled
	USART_CR1_IDLEIE_Disabled = 0x0
	// Interrupt is generated whenever IDLE=1 in the ISR register
	USART_CR1_IDLEIE_Enabled = 0x1
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Transmitter is disabled
	USART_CR1_TE_Disabled = 0x0
	// Transmitter is enabled
	USART_CR1_TE_Enabled = 0x1
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Receiver is disabled
	USART_CR1_RE_Disabled = 0x0
	// Receiver is enabled
	USART_CR1_RE_Enabled = 0x1
	// Position of UESM field.
	USART_CR1_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_UESM = 0x2
	// USART not able to wake up the MCU from Stop mode
	USART_CR1_UESM_Disabled = 0x0
	// USART able to wake up the MCU from Stop mode
	USART_CR1_UESM_Enabled = 0x1
	// Position of UE field.
	USART_CR1_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_UE = 0x1
	// UART is disabled
	USART_CR1_UE_Disabled = 0x0
	// UART is enabled
	USART_CR1_UE_Enabled = 0x1
	// Position of DEDT field.
	USART_CR1_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_DEDT_Msk = 0x1f0000
	// Position of DEAT field.
	USART_CR1_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_DEAT_Msk = 0x3e00000

	// CR2: Control register 2
	// Position of RTOEN field.
	USART_CR2_RTOEN_Pos = 0x17
	// Bit mask of RTOEN field.
	USART_CR2_RTOEN_Msk = 0x800000
	// Bit RTOEN.
	USART_CR2_RTOEN = 0x800000
	// Receiver timeout feature disabled
	USART_CR2_RTOEN_Disabled = 0x0
	// Receiver timeout feature enabled
	USART_CR2_RTOEN_Enabled = 0x1
	// Position of ABREN field.
	USART_CR2_ABREN_Pos = 0x14
	// Bit mask of ABREN field.
	USART_CR2_ABREN_Msk = 0x100000
	// Bit ABREN.
	USART_CR2_ABREN = 0x100000
	// Auto baud rate detection is disabled
	USART_CR2_ABREN_Disabled = 0x0
	// Auto baud rate detection is enabled
	USART_CR2_ABREN_Enabled = 0x1
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// data is transmitted/received with data bit 0 first, following the start bit
	USART_CR2_MSBFIRST_LSB = 0x0
	// data is transmitted/received with MSB (bit 7/8/9) first, following the start bit
	USART_CR2_MSBFIRST_MSB = 0x1
	// Position of DATAINV field.
	USART_CR2_DATAINV_Pos = 0x12
	// Bit mask of DATAINV field.
	USART_CR2_DATAINV_Msk = 0x40000
	// Bit DATAINV.
	USART_CR2_DATAINV = 0x40000
	// Logical data from the data register are send/received in positive/direct logic
	USART_CR2_DATAINV_Positive = 0x0
	// Logical data from the data register are send/received in negative/inverse logic
	USART_CR2_DATAINV_Negative = 0x1
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// TX pin signal works using the standard logic levels
	USART_CR2_TXINV_Standard = 0x0
	// TX pin signal values are inverted
	USART_CR2_TXINV_Inverted = 0x1
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// RX pin signal works using the standard logic levels
	USART_CR2_RXINV_Standard = 0x0
	// RX pin signal values are inverted
	USART_CR2_RXINV_Inverted = 0x1
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// TX/RX pins are used as defined in standard pinout
	USART_CR2_SWAP_Standard = 0x0
	// The TX and RX pins functions are swapped
	USART_CR2_SWAP_Swapped = 0x1
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_Disabled = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_Enabled = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_Stop1 = 0x0
	// 0.5 stop bit
	USART_CR2_STOP_Stop0p5 = 0x1
	// 2 stop bit
	USART_CR2_STOP_Stop2 = 0x2
	// 1.5 stop bit
	USART_CR2_STOP_Stop1p5 = 0x3
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// CK pin disabled
	USART_CR2_CLKEN_Disabled = 0x0
	// CK pin enabled
	USART_CR2_CLKEN_Enabled = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on CK pin outside transmission window
	USART_CR2_CPOL_Low = 0x0
	// Steady high value on CK pin outside transmission window
	USART_CR2_CPOL_High = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_First = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_Second = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// The clock pulse of the last data bit is not output to the CK pin
	USART_CR2_LBCL_NotOutput = 0x0
	// The clock pulse of the last data bit is output to the CK pin
	USART_CR2_LBCL_Output = 0x1
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Interrupt is inhibited
	USART_CR2_LBDIE_Disabled = 0x0
	// An interrupt is generated whenever LBDF=1 in the ISR register
	USART_CR2_LBDIE_Enabled = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_Bit10 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_Bit11 = 0x1
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10
	// 4-bit address detection
	USART_CR2_ADDM7_Bit4 = 0x0
	// 7-bit address detection
	USART_CR2_ADDM7_Bit7 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x18
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xff000000
	// Position of ABRMOD field.
	USART_CR2_ABRMOD_Pos = 0x15
	// Bit mask of ABRMOD field.
	USART_CR2_ABRMOD_Msk = 0x600000
	// Measurement of the start bit is used to detect the baud rate
	USART_CR2_ABRMOD_Start = 0x0
	// Falling edge to falling edge measurement
	USART_CR2_ABRMOD_Edge = 0x1
	// 0x7F frame detection
	USART_CR2_ABRMOD_Frame7F = 0x2
	// 0x55 frame detection
	USART_CR2_ABRMOD_Frame55 = 0x3

	// CR3: Control register 3
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Interrupt is inhibited
	USART_CR3_WUFIE_Disabled = 0x0
	// An USART interrupt is generated whenever WUF=1 in the ISR register
	USART_CR3_WUFIE_Enabled = 0x1
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// WUF active on address match
	USART_CR3_WUS_Address = 0x0
	// WuF active on Start bit detection
	USART_CR3_WUS_Start = 0x2
	// WUF active on RXNE
	USART_CR3_WUS_RXNE = 0x3
	// Position of SCARCNT field.
	USART_CR3_SCARCNT_Pos = 0x11
	// Bit mask of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// DE signal is active high
	USART_CR3_DEP_High = 0x0
	// DE signal is active low
	USART_CR3_DEP_Low = 0x1
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// DE function is disabled
	USART_CR3_DEM_Disabled = 0x0
	// The DE signal is output on the RTS pin
	USART_CR3_DEM_Enabled = 0x1
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// DMA is not disabled in case of reception error
	USART_CR3_DDRE_NotDisabled = 0x0
	// DMA is disabled following a reception error
	USART_CR3_DDRE_Disabled = 0x1
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Overrun Error Flag, ORE, is set when received data is not read before receiving new data
	USART_CR3_OVRDIS_Enabled = 0x0
	// Overrun functionality is disabled. If new data is received while the RXNE flag is still set the ORE flag is not set and the new received data overwrites the previous content of the RDR register
	USART_CR3_OVRDIS_Disabled = 0x1
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_Sample3 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_Sample1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Interrupt is inhibited
	USART_CR3_CTSIE_Disabled = 0x0
	// An interrupt is generated whenever CTSIF=1 in the ISR register
	USART_CR3_CTSIE_Enabled = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_Disabled = 0x0
	// CTS mode enabled, data is only transmitted when the CTS input is asserted
	USART_CR3_CTSE_Enabled = 0x1
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_Disabled = 0x0
	// RTS output enabled, data is only requested when there is space in the receive buffer
	USART_CR3_RTSE_Enabled = 0x1
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_Disabled = 0x0
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_Enabled = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is disabled for reception
	USART_CR3_DMAR_Disabled = 0x0
	// DMA mode is enabled for reception
	USART_CR3_DMAR_Enabled = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard Mode disabled
	USART_CR3_SCEN_Disabled = 0x0
	// Smartcard Mode enabled
	USART_CR3_SCEN_Enabled = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_Disabled = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_Enabled = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_NotSelected = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_Selected = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_Normal = 0x0
	// Low-power mode
	USART_CR3_IRLP_LowPower = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_Disabled = 0x0
	// IrDA enabled
	USART_CR3_IREN_Enabled = 0x1
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Interrupt is inhibited
	USART_CR3_EIE_Disabled = 0x0
	// An interrupt is generated when FE=1 or ORE=1 or NF=1 in the ISR register
	USART_CR3_EIE_Enabled = 0x1

	// BRR: Baud rate register
	// Position of BRR field.
	USART_BRR_BRR_Pos = 0x0
	// Bit mask of BRR field.
	USART_BRR_BRR_Msk = 0xffff

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff

	// RTOR: Receiver timeout register
	// Position of BLEN field.
	USART_RTOR_BLEN_Pos = 0x18
	// Bit mask of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000
	// Position of RTO field.
	USART_RTOR_RTO_Pos = 0x0
	// Bit mask of RTO field.
	USART_RTOR_RTO_Msk = 0xffffff

	// RQR: Request register
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10
	// Set the TXE flags. This allows to discard the transmit data
	USART_RQR_TXFRQ_Discard = 0x1
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// clears the RXNE flag. This allows to discard the received data without reading it, and avoid an overrun condition
	USART_RQR_RXFRQ_Discard = 0x1
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Puts the USART in mute mode and sets the RWU flag
	USART_RQR_MMRQ_Mute = 0x1
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2
	// sets the SBKF flag and request to send a BREAK on the line, as soon as the transmit machine is available
	USART_RQR_SBKRQ_Break = 0x1
	// Position of ABRRQ field.
	USART_RQR_ABRRQ_Pos = 0x0
	// Bit mask of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1
	// Bit ABRRQ.
	USART_RQR_ABRRQ = 0x1
	// resets the ABRF flag in the USART_ISR and request an automatic baud rate measurement on the next received data frame
	USART_RQR_ABRRQ_Request = 0x1

	// ISR: Interrupt & status register
	// Position of REACK field.
	USART_ISR_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_REACK = 0x400000
	// Position of TEACK field.
	USART_ISR_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_TEACK = 0x200000
	// Position of WUF field.
	USART_ISR_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_WUF = 0x100000
	// Position of RWU field.
	USART_ISR_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_RWU = 0x80000
	// Position of SBKF field.
	USART_ISR_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_SBKF = 0x40000
	// Position of CMF field.
	USART_ISR_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_CMF = 0x20000
	// Position of BUSY field.
	USART_ISR_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_BUSY = 0x10000
	// Position of ABRF field.
	USART_ISR_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_ABRF = 0x8000
	// Position of ABRE field.
	USART_ISR_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_ABRE = 0x4000
	// Position of EOBF field.
	USART_ISR_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_EOBF = 0x1000
	// Position of RTOF field.
	USART_ISR_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_RTOF = 0x800
	// Position of CTS field.
	USART_ISR_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_CTS = 0x400
	// Position of CTSIF field.
	USART_ISR_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_CTSIF = 0x200
	// Position of LBDF field.
	USART_ISR_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_LBDF = 0x100
	// Position of TXE field.
	USART_ISR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_TXE = 0x80
	// Position of TC field.
	USART_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_TC = 0x40
	// Position of RXNE field.
	USART_ISR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_ISR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_ISR_RXNE = 0x20
	// Position of IDLE field.
	USART_ISR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_IDLE = 0x10
	// Position of ORE field.
	USART_ISR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_ORE = 0x8
	// Position of NF field.
	USART_ISR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_ISR_NF_Msk = 0x4
	// Bit NF.
	USART_ISR_NF = 0x4
	// Position of FE field.
	USART_ISR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FE = 0x2
	// Position of PE field.
	USART_ISR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_PE = 0x1

	// ICR: Interrupt flag clear register
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000
	// Clears the WUF flag in the ISR register
	USART_ICR_WUCF_Clear = 0x1
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Clears the CMF flag in the ISR register
	USART_ICR_CMCF_Clear = 0x1
	// Position of EOBCF field.
	USART_ICR_EOBCF_Pos = 0xc
	// Bit mask of EOBCF field.
	USART_ICR_EOBCF_Msk = 0x1000
	// Bit EOBCF.
	USART_ICR_EOBCF = 0x1000
	// Clears the EOBF flag in the ISR register
	USART_ICR_EOBCF_Clear = 0x1
	// Position of RTOCF field.
	USART_ICR_RTOCF_Pos = 0xb
	// Bit mask of RTOCF field.
	USART_ICR_RTOCF_Msk = 0x800
	// Bit RTOCF.
	USART_ICR_RTOCF = 0x800
	// Clears the RTOF flag in the ISR register
	USART_ICR_RTOCF_Clear = 0x1
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Clears the CTSIF flag in the ISR register
	USART_ICR_CTSCF_Clear = 0x1
	// Position of LBDCF field.
	USART_ICR_LBDCF_Pos = 0x8
	// Bit mask of LBDCF field.
	USART_ICR_LBDCF_Msk = 0x100
	// Bit LBDCF.
	USART_ICR_LBDCF = 0x100
	// Clears the LBDF flag in the ISR register
	USART_ICR_LBDCF_Clear = 0x1
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Clears the TC flag in the ISR register
	USART_ICR_TCCF_Clear = 0x1
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Clears the IDLE flag in the ISR register
	USART_ICR_IDLECF_Clear = 0x1
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Clears the ORE flag in the ISR register
	USART_ICR_ORECF_Clear = 0x1
	// Position of NCF field.
	USART_ICR_NCF_Pos = 0x2
	// Bit mask of NCF field.
	USART_ICR_NCF_Msk = 0x4
	// Bit NCF.
	USART_ICR_NCF = 0x4
	// Clears the NF flag in the ISR register
	USART_ICR_NCF_Clear = 0x1
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Clears the FE flag in the ISR register
	USART_ICR_FECF_Clear = 0x1
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1
	// Clears the PE flag in the ISR register
	USART_ICR_PECF_Clear = 0x1

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff
)

// Bitfields for SPI1: Serial peripheral interface/Inter-IC sound
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// 2-line unidirectional data mode selected
	SPI_CR1_BIDIMODE_Unidirectional = 0x0
	// 1-line bidirectional data mode selected
	SPI_CR1_BIDIMODE_Bidirectional = 0x1
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Output disabled (receive-only mode)
	SPI_CR1_BIDIOE_OutputDisabled = 0x0
	// Output enabled (transmit-only mode)
	SPI_CR1_BIDIOE_OutputEnabled = 0x1
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// CRC calculation disabled
	SPI_CR1_CRCEN_Disabled = 0x0
	// CRC calculation enabled
	SPI_CR1_CRCEN_Enabled = 0x1
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Next transmit value is from Tx buffer
	SPI_CR1_CRCNEXT_TxBuffer = 0x0
	// Next transmit value is from Tx CRC register
	SPI_CR1_CRCNEXT_CRC = 0x1
	// Position of CRCL field.
	SPI_CR1_CRCL_Pos = 0xb
	// Bit mask of CRCL field.
	SPI_CR1_CRCL_Msk = 0x800
	// Bit CRCL.
	SPI_CR1_CRCL = 0x800
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Full duplex (Transmit and receive)
	SPI_CR1_RXONLY_FullDuplex = 0x0
	// Output disabled (Receive-only mode)
	SPI_CR1_RXONLY_OutputDisabled = 0x1
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Software slave management disabled
	SPI_CR1_SSM_Disabled = 0x0
	// Software slave management enabled
	SPI_CR1_SSM_Enabled = 0x1
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// 0 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveSelected = 0x0
	// 1 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveNotSelected = 0x1
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Data is transmitted/received with the MSB first
	SPI_CR1_LSBFIRST_MSBFirst = 0x0
	// Data is transmitted/received with the LSB first
	SPI_CR1_LSBFIRST_LSBFirst = 0x1
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Peripheral disabled
	SPI_CR1_SPE_Disabled = 0x0
	// Peripheral enabled
	SPI_CR1_SPE_Enabled = 0x1
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// f_PCLK / 2
	SPI_CR1_BR_Div2 = 0x0
	// f_PCLK / 4
	SPI_CR1_BR_Div4 = 0x1
	// f_PCLK / 8
	SPI_CR1_BR_Div8 = 0x2
	// f_PCLK / 16
	SPI_CR1_BR_Div16 = 0x3
	// f_PCLK / 32
	SPI_CR1_BR_Div32 = 0x4
	// f_PCLK / 64
	SPI_CR1_BR_Div64 = 0x5
	// f_PCLK / 128
	SPI_CR1_BR_Div128 = 0x6
	// f_PCLK / 256
	SPI_CR1_BR_Div256 = 0x7
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Slave configuration
	SPI_CR1_MSTR_Slave = 0x0
	// Master configuration
	SPI_CR1_MSTR_Master = 0x1
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// CK to 0 when idle
	SPI_CR1_CPOL_IdleLow = 0x0
	// CK to 1 when idle
	SPI_CR1_CPOL_IdleHigh = 0x1
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1
	// The first clock transition is the first data capture edge
	SPI_CR1_CPHA_FirstEdge = 0x0
	// The second clock transition is the first data capture edge
	SPI_CR1_CPHA_SecondEdge = 0x1

	// CR2: control register 2
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Rx buffer DMA disabled
	SPI_CR2_RXDMAEN_Disabled = 0x0
	// Rx buffer DMA enabled
	SPI_CR2_RXDMAEN_Enabled = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Tx buffer DMA disabled
	SPI_CR2_TXDMAEN_Disabled = 0x0
	// Tx buffer DMA enabled
	SPI_CR2_TXDMAEN_Enabled = 0x1
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// SS output is disabled in master mode
	SPI_CR2_SSOE_Disabled = 0x0
	// SS output is enabled in master mode
	SPI_CR2_SSOE_Enabled = 0x1
	// Position of NSSP field.
	SPI_CR2_NSSP_Pos = 0x3
	// Bit mask of NSSP field.
	SPI_CR2_NSSP_Msk = 0x8
	// Bit NSSP.
	SPI_CR2_NSSP = 0x8
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Error interrupt masked
	SPI_CR2_ERRIE_Masked = 0x0
	// Error interrupt not masked
	SPI_CR2_ERRIE_NotMasked = 0x1
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// RXE interrupt masked
	SPI_CR2_RXNEIE_Masked = 0x0
	// RXE interrupt not masked
	SPI_CR2_RXNEIE_NotMasked = 0x1
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// TXE interrupt masked
	SPI_CR2_TXEIE_Masked = 0x0
	// TXE interrupt not masked
	SPI_CR2_TXEIE_NotMasked = 0x1
	// Position of DS field.
	SPI_CR2_DS_Pos = 0x8
	// Bit mask of DS field.
	SPI_CR2_DS_Msk = 0xf00
	// Position of FRXTH field.
	SPI_CR2_FRXTH_Pos = 0xc
	// Bit mask of FRXTH field.
	SPI_CR2_FRXTH_Msk = 0x1000
	// Bit FRXTH.
	SPI_CR2_FRXTH = 0x1000
	// Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Pos = 0xd
	// Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000
	// Bit LDMA_RX.
	SPI_CR2_LDMA_RX = 0x2000
	// Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Pos = 0xe
	// Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000
	// Bit LDMA_TX.
	SPI_CR2_LDMA_TX = 0x4000

	// SR: status register
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Rx buffer empty
	SPI_SR_RXNE_Empty = 0x0
	// Rx buffer not empty
	SPI_SR_RXNE_NotEmpty = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Tx buffer not empty
	SPI_SR_TXE_NotEmpty = 0x0
	// Tx buffer empty
	SPI_SR_TXE_Empty = 0x1
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// CRC value received matches the SPIx_RXCRCR value
	SPI_SR_CRCERR_Match = 0x0
	// CRC value received does not match the SPIx_RXCRCR value
	SPI_SR_CRCERR_NoMatch = 0x1
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// No mode fault occurred
	SPI_SR_MODF_NoFault = 0x0
	// Mode fault occurred
	SPI_SR_MODF_Fault = 0x1
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// No overrun occurred
	SPI_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	SPI_SR_OVR_Overrun = 0x1
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// SPI not busy
	SPI_SR_BSY_NotBusy = 0x0
	// SPI busy
	SPI_SR_BSY_Busy = 0x1
	// Position of FRE field.
	SPI_SR_FRE_Pos = 0x8
	// Bit mask of FRE field.
	SPI_SR_FRE_Msk = 0x100
	// Bit FRE.
	SPI_SR_FRE = 0x100
	// Position of FRLVL field.
	SPI_SR_FRLVL_Pos = 0x9
	// Bit mask of FRLVL field.
	SPI_SR_FRLVL_Msk = 0x600
	// Position of FTLVL field.
	SPI_SR_FTLVL_Pos = 0xb
	// Bit mask of FTLVL field.
	SPI_SR_FTLVL_Msk = 0x1800

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff
)

// Bitfields for SDMMC: Secure digital input/output interface
const (
	// POWER: power control register
	// Position of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Pos = 0x0
	// Bit mask of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Msk = 0x3

	// CLKCR: SDI clock control register
	// Position of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Pos = 0xe
	// Bit mask of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Msk = 0x4000
	// Bit HWFC_EN.
	SDIO_CLKCR_HWFC_EN = 0x4000
	// Position of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Pos = 0xd
	// Bit mask of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Msk = 0x2000
	// Bit NEGEDGE.
	SDIO_CLKCR_NEGEDGE = 0x2000
	// Position of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Pos = 0xb
	// Bit mask of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Msk = 0x1800
	// Position of BYPASS field.
	SDIO_CLKCR_BYPASS_Pos = 0xa
	// Bit mask of BYPASS field.
	SDIO_CLKCR_BYPASS_Msk = 0x400
	// Bit BYPASS.
	SDIO_CLKCR_BYPASS = 0x400
	// Position of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Pos = 0x9
	// Bit mask of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Msk = 0x200
	// Bit PWRSAV.
	SDIO_CLKCR_PWRSAV = 0x200
	// Position of CLKEN field.
	SDIO_CLKCR_CLKEN_Pos = 0x8
	// Bit mask of CLKEN field.
	SDIO_CLKCR_CLKEN_Msk = 0x100
	// Bit CLKEN.
	SDIO_CLKCR_CLKEN = 0x100
	// Position of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Msk = 0xff

	// ARG: argument register
	// Position of CMDARG field.
	SDIO_ARG_CMDARG_Pos = 0x0
	// Bit mask of CMDARG field.
	SDIO_ARG_CMDARG_Msk = 0xffffffff

	// CMD: command register
	// Position of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Pos = 0xe
	// Bit mask of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Msk = 0x4000
	// Bit CE_ATACMD.
	SDIO_CMD_CE_ATACMD = 0x4000
	// Position of NIEN field.
	SDIO_CMD_NIEN_Pos = 0xd
	// Bit mask of NIEN field.
	SDIO_CMD_NIEN_Msk = 0x2000
	// Bit NIEN.
	SDIO_CMD_NIEN = 0x2000
	// Position of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Pos = 0xc
	// Bit mask of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Msk = 0x1000
	// Bit ENCMDcompl.
	SDIO_CMD_ENCMDcompl = 0x1000
	// Position of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Pos = 0xb
	// Bit mask of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Msk = 0x800
	// Bit SDIOSuspend.
	SDIO_CMD_SDIOSuspend = 0x800
	// Position of CPSMEN field.
	SDIO_CMD_CPSMEN_Pos = 0xa
	// Bit mask of CPSMEN field.
	SDIO_CMD_CPSMEN_Msk = 0x400
	// Bit CPSMEN.
	SDIO_CMD_CPSMEN = 0x400
	// Position of WAITPEND field.
	SDIO_CMD_WAITPEND_Pos = 0x9
	// Bit mask of WAITPEND field.
	SDIO_CMD_WAITPEND_Msk = 0x200
	// Bit WAITPEND.
	SDIO_CMD_WAITPEND = 0x200
	// Position of WAITINT field.
	SDIO_CMD_WAITINT_Pos = 0x8
	// Bit mask of WAITINT field.
	SDIO_CMD_WAITINT_Msk = 0x100
	// Bit WAITINT.
	SDIO_CMD_WAITINT = 0x100
	// Position of WAITRESP field.
	SDIO_CMD_WAITRESP_Pos = 0x6
	// Bit mask of WAITRESP field.
	SDIO_CMD_WAITRESP_Msk = 0xc0
	// Position of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Pos = 0x0
	// Bit mask of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Msk = 0x3f

	// RESPCMD: command response register
	// Position of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Pos = 0x0
	// Bit mask of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Msk = 0x3f

	// RESP1: response 1..4 register
	// Position of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Pos = 0x0
	// Bit mask of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Msk = 0xffffffff

	// RESP2: response 1..4 register
	// Position of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Pos = 0x0
	// Bit mask of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Msk = 0xffffffff

	// RESP3: response 1..4 register
	// Position of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Pos = 0x0
	// Bit mask of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Msk = 0xffffffff

	// RESP4: response 1..4 register
	// Position of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Pos = 0x0
	// Bit mask of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Msk = 0xffffffff

	// DTIMER: data timer register
	// Position of DATATIME field.
	SDIO_DTIMER_DATATIME_Pos = 0x0
	// Bit mask of DATATIME field.
	SDIO_DTIMER_DATATIME_Msk = 0xffffffff

	// DLEN: data length register
	// Position of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Pos = 0x0
	// Bit mask of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Msk = 0x1ffffff

	// DCTRL: data control register
	// Position of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	SDIO_DCTRL_SDIOEN = 0x800
	// Position of RWMOD field.
	SDIO_DCTRL_RWMOD_Pos = 0xa
	// Bit mask of RWMOD field.
	SDIO_DCTRL_RWMOD_Msk = 0x400
	// Bit RWMOD.
	SDIO_DCTRL_RWMOD = 0x400
	// Position of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Pos = 0x9
	// Bit mask of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Msk = 0x200
	// Bit RWSTOP.
	SDIO_DCTRL_RWSTOP = 0x200
	// Position of RWSTART field.
	SDIO_DCTRL_RWSTART_Pos = 0x8
	// Bit mask of RWSTART field.
	SDIO_DCTRL_RWSTART_Msk = 0x100
	// Bit RWSTART.
	SDIO_DCTRL_RWSTART = 0x100
	// Position of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Pos = 0x4
	// Bit mask of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Msk = 0xf0
	// Position of DMAEN field.
	SDIO_DCTRL_DMAEN_Pos = 0x3
	// Bit mask of DMAEN field.
	SDIO_DCTRL_DMAEN_Msk = 0x8
	// Bit DMAEN.
	SDIO_DCTRL_DMAEN = 0x8
	// Position of DTMODE field.
	SDIO_DCTRL_DTMODE_Pos = 0x2
	// Bit mask of DTMODE field.
	SDIO_DCTRL_DTMODE_Msk = 0x4
	// Bit DTMODE.
	SDIO_DCTRL_DTMODE = 0x4
	// Position of DTDIR field.
	SDIO_DCTRL_DTDIR_Pos = 0x1
	// Bit mask of DTDIR field.
	SDIO_DCTRL_DTDIR_Msk = 0x2
	// Bit DTDIR.
	SDIO_DCTRL_DTDIR = 0x2
	// Position of DTEN field.
	SDIO_DCTRL_DTEN_Pos = 0x0
	// Bit mask of DTEN field.
	SDIO_DCTRL_DTEN_Msk = 0x1
	// Bit DTEN.
	SDIO_DCTRL_DTEN = 0x1

	// DCOUNT: data counter register
	// Position of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Pos = 0x0
	// Bit mask of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Msk = 0x1ffffff

	// STA: status register
	// Position of CEATAEND field.
	SDIO_STA_CEATAEND_Pos = 0x17
	// Bit mask of CEATAEND field.
	SDIO_STA_CEATAEND_Msk = 0x800000
	// Bit CEATAEND.
	SDIO_STA_CEATAEND = 0x800000
	// Position of SDIOIT field.
	SDIO_STA_SDIOIT_Pos = 0x16
	// Bit mask of SDIOIT field.
	SDIO_STA_SDIOIT_Msk = 0x400000
	// Bit SDIOIT.
	SDIO_STA_SDIOIT = 0x400000
	// Position of RXDAVL field.
	SDIO_STA_RXDAVL_Pos = 0x15
	// Bit mask of RXDAVL field.
	SDIO_STA_RXDAVL_Msk = 0x200000
	// Bit RXDAVL.
	SDIO_STA_RXDAVL = 0x200000
	// Position of TXDAVL field.
	SDIO_STA_TXDAVL_Pos = 0x14
	// Bit mask of TXDAVL field.
	SDIO_STA_TXDAVL_Msk = 0x100000
	// Bit TXDAVL.
	SDIO_STA_TXDAVL = 0x100000
	// Position of RXFIFOE field.
	SDIO_STA_RXFIFOE_Pos = 0x13
	// Bit mask of RXFIFOE field.
	SDIO_STA_RXFIFOE_Msk = 0x80000
	// Bit RXFIFOE.
	SDIO_STA_RXFIFOE = 0x80000
	// Position of TXFIFOE field.
	SDIO_STA_TXFIFOE_Pos = 0x12
	// Bit mask of TXFIFOE field.
	SDIO_STA_TXFIFOE_Msk = 0x40000
	// Bit TXFIFOE.
	SDIO_STA_TXFIFOE = 0x40000
	// Position of RXFIFOF field.
	SDIO_STA_RXFIFOF_Pos = 0x11
	// Bit mask of RXFIFOF field.
	SDIO_STA_RXFIFOF_Msk = 0x20000
	// Bit RXFIFOF.
	SDIO_STA_RXFIFOF = 0x20000
	// Position of TXFIFOF field.
	SDIO_STA_TXFIFOF_Pos = 0x10
	// Bit mask of TXFIFOF field.
	SDIO_STA_TXFIFOF_Msk = 0x10000
	// Bit TXFIFOF.
	SDIO_STA_TXFIFOF = 0x10000
	// Position of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Pos = 0xf
	// Bit mask of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Msk = 0x8000
	// Bit RXFIFOHF.
	SDIO_STA_RXFIFOHF = 0x8000
	// Position of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Pos = 0xe
	// Bit mask of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Msk = 0x4000
	// Bit TXFIFOHE.
	SDIO_STA_TXFIFOHE = 0x4000
	// Position of RXACT field.
	SDIO_STA_RXACT_Pos = 0xd
	// Bit mask of RXACT field.
	SDIO_STA_RXACT_Msk = 0x2000
	// Bit RXACT.
	SDIO_STA_RXACT = 0x2000
	// Position of TXACT field.
	SDIO_STA_TXACT_Pos = 0xc
	// Bit mask of TXACT field.
	SDIO_STA_TXACT_Msk = 0x1000
	// Bit TXACT.
	SDIO_STA_TXACT = 0x1000
	// Position of CMDACT field.
	SDIO_STA_CMDACT_Pos = 0xb
	// Bit mask of CMDACT field.
	SDIO_STA_CMDACT_Msk = 0x800
	// Bit CMDACT.
	SDIO_STA_CMDACT = 0x800
	// Position of DBCKEND field.
	SDIO_STA_DBCKEND_Pos = 0xa
	// Bit mask of DBCKEND field.
	SDIO_STA_DBCKEND_Msk = 0x400
	// Bit DBCKEND.
	SDIO_STA_DBCKEND = 0x400
	// Position of STBITERR field.
	SDIO_STA_STBITERR_Pos = 0x9
	// Bit mask of STBITERR field.
	SDIO_STA_STBITERR_Msk = 0x200
	// Bit STBITERR.
	SDIO_STA_STBITERR = 0x200
	// Position of DATAEND field.
	SDIO_STA_DATAEND_Pos = 0x8
	// Bit mask of DATAEND field.
	SDIO_STA_DATAEND_Msk = 0x100
	// Bit DATAEND.
	SDIO_STA_DATAEND = 0x100
	// Position of CMDSENT field.
	SDIO_STA_CMDSENT_Pos = 0x7
	// Bit mask of CMDSENT field.
	SDIO_STA_CMDSENT_Msk = 0x80
	// Bit CMDSENT.
	SDIO_STA_CMDSENT = 0x80
	// Position of CMDREND field.
	SDIO_STA_CMDREND_Pos = 0x6
	// Bit mask of CMDREND field.
	SDIO_STA_CMDREND_Msk = 0x40
	// Bit CMDREND.
	SDIO_STA_CMDREND = 0x40
	// Position of RXOVERR field.
	SDIO_STA_RXOVERR_Pos = 0x5
	// Bit mask of RXOVERR field.
	SDIO_STA_RXOVERR_Msk = 0x20
	// Bit RXOVERR.
	SDIO_STA_RXOVERR = 0x20
	// Position of TXUNDERR field.
	SDIO_STA_TXUNDERR_Pos = 0x4
	// Bit mask of TXUNDERR field.
	SDIO_STA_TXUNDERR_Msk = 0x10
	// Bit TXUNDERR.
	SDIO_STA_TXUNDERR = 0x10
	// Position of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Pos = 0x3
	// Bit mask of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Msk = 0x8
	// Bit DTIMEOUT.
	SDIO_STA_DTIMEOUT = 0x8
	// Position of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Pos = 0x2
	// Bit mask of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Msk = 0x4
	// Bit CTIMEOUT.
	SDIO_STA_CTIMEOUT = 0x4
	// Position of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Pos = 0x1
	// Bit mask of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Msk = 0x2
	// Bit DCRCFAIL.
	SDIO_STA_DCRCFAIL = 0x2
	// Position of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Pos = 0x0
	// Bit mask of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Msk = 0x1
	// Bit CCRCFAIL.
	SDIO_STA_CCRCFAIL = 0x1

	// ICR: interrupt clear register
	// Position of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Pos = 0x17
	// Bit mask of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Msk = 0x800000
	// Bit CEATAENDC.
	SDIO_ICR_CEATAENDC = 0x800000
	// Position of SDIOITC field.
	SDIO_ICR_SDIOITC_Pos = 0x16
	// Bit mask of SDIOITC field.
	SDIO_ICR_SDIOITC_Msk = 0x400000
	// Bit SDIOITC.
	SDIO_ICR_SDIOITC = 0x400000
	// Position of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Pos = 0xa
	// Bit mask of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Msk = 0x400
	// Bit DBCKENDC.
	SDIO_ICR_DBCKENDC = 0x400
	// Position of STBITERRC field.
	SDIO_ICR_STBITERRC_Pos = 0x9
	// Bit mask of STBITERRC field.
	SDIO_ICR_STBITERRC_Msk = 0x200
	// Bit STBITERRC.
	SDIO_ICR_STBITERRC = 0x200
	// Position of DATAENDC field.
	SDIO_ICR_DATAENDC_Pos = 0x8
	// Bit mask of DATAENDC field.
	SDIO_ICR_DATAENDC_Msk = 0x100
	// Bit DATAENDC.
	SDIO_ICR_DATAENDC = 0x100
	// Position of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Pos = 0x7
	// Bit mask of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Msk = 0x80
	// Bit CMDSENTC.
	SDIO_ICR_CMDSENTC = 0x80
	// Position of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Pos = 0x6
	// Bit mask of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Msk = 0x40
	// Bit CMDRENDC.
	SDIO_ICR_CMDRENDC = 0x40
	// Position of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Pos = 0x5
	// Bit mask of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Msk = 0x20
	// Bit RXOVERRC.
	SDIO_ICR_RXOVERRC = 0x20
	// Position of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Pos = 0x4
	// Bit mask of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Msk = 0x10
	// Bit TXUNDERRC.
	SDIO_ICR_TXUNDERRC = 0x10
	// Position of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Pos = 0x3
	// Bit mask of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Msk = 0x8
	// Bit DTIMEOUTC.
	SDIO_ICR_DTIMEOUTC = 0x8
	// Position of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Pos = 0x2
	// Bit mask of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Msk = 0x4
	// Bit CTIMEOUTC.
	SDIO_ICR_CTIMEOUTC = 0x4
	// Position of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Pos = 0x1
	// Bit mask of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Msk = 0x2
	// Bit DCRCFAILC.
	SDIO_ICR_DCRCFAILC = 0x2
	// Position of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Pos = 0x0
	// Bit mask of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Msk = 0x1
	// Bit CCRCFAILC.
	SDIO_ICR_CCRCFAILC = 0x1

	// MASK: mask register
	// Position of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Pos = 0x17
	// Bit mask of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Msk = 0x800000
	// Bit CEATAENDIE.
	SDIO_MASK_CEATAENDIE = 0x800000
	// Position of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Pos = 0x16
	// Bit mask of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Msk = 0x400000
	// Bit SDIOITIE.
	SDIO_MASK_SDIOITIE = 0x400000
	// Position of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Pos = 0x15
	// Bit mask of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Msk = 0x200000
	// Bit RXDAVLIE.
	SDIO_MASK_RXDAVLIE = 0x200000
	// Position of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Pos = 0x14
	// Bit mask of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Msk = 0x100000
	// Bit TXDAVLIE.
	SDIO_MASK_TXDAVLIE = 0x100000
	// Position of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Pos = 0x13
	// Bit mask of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Msk = 0x80000
	// Bit RXFIFOEIE.
	SDIO_MASK_RXFIFOEIE = 0x80000
	// Position of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Pos = 0x12
	// Bit mask of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Msk = 0x40000
	// Bit TXFIFOEIE.
	SDIO_MASK_TXFIFOEIE = 0x40000
	// Position of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Pos = 0x11
	// Bit mask of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Msk = 0x20000
	// Bit RXFIFOFIE.
	SDIO_MASK_RXFIFOFIE = 0x20000
	// Position of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Pos = 0x10
	// Bit mask of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Msk = 0x10000
	// Bit TXFIFOFIE.
	SDIO_MASK_TXFIFOFIE = 0x10000
	// Position of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Pos = 0xf
	// Bit mask of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Msk = 0x8000
	// Bit RXFIFOHFIE.
	SDIO_MASK_RXFIFOHFIE = 0x8000
	// Position of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Pos = 0xe
	// Bit mask of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Msk = 0x4000
	// Bit TXFIFOHEIE.
	SDIO_MASK_TXFIFOHEIE = 0x4000
	// Position of RXACTIE field.
	SDIO_MASK_RXACTIE_Pos = 0xd
	// Bit mask of RXACTIE field.
	SDIO_MASK_RXACTIE_Msk = 0x2000
	// Bit RXACTIE.
	SDIO_MASK_RXACTIE = 0x2000
	// Position of TXACTIE field.
	SDIO_MASK_TXACTIE_Pos = 0xc
	// Bit mask of TXACTIE field.
	SDIO_MASK_TXACTIE_Msk = 0x1000
	// Bit TXACTIE.
	SDIO_MASK_TXACTIE = 0x1000
	// Position of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Pos = 0xb
	// Bit mask of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Msk = 0x800
	// Bit CMDACTIE.
	SDIO_MASK_CMDACTIE = 0x800
	// Position of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Pos = 0xa
	// Bit mask of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Msk = 0x400
	// Bit DBCKENDIE.
	SDIO_MASK_DBCKENDIE = 0x400
	// Position of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Pos = 0x9
	// Bit mask of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Msk = 0x200
	// Bit STBITERRIE.
	SDIO_MASK_STBITERRIE = 0x200
	// Position of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Pos = 0x8
	// Bit mask of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Msk = 0x100
	// Bit DATAENDIE.
	SDIO_MASK_DATAENDIE = 0x100
	// Position of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Pos = 0x7
	// Bit mask of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Msk = 0x80
	// Bit CMDSENTIE.
	SDIO_MASK_CMDSENTIE = 0x80
	// Position of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Pos = 0x6
	// Bit mask of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Msk = 0x40
	// Bit CMDRENDIE.
	SDIO_MASK_CMDRENDIE = 0x40
	// Position of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Pos = 0x5
	// Bit mask of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Msk = 0x20
	// Bit RXOVERRIE.
	SDIO_MASK_RXOVERRIE = 0x20
	// Position of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Pos = 0x4
	// Bit mask of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Msk = 0x10
	// Bit TXUNDERRIE.
	SDIO_MASK_TXUNDERRIE = 0x10
	// Position of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Pos = 0x3
	// Bit mask of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Msk = 0x8
	// Bit DTIMEOUTIE.
	SDIO_MASK_DTIMEOUTIE = 0x8
	// Position of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Pos = 0x2
	// Bit mask of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Msk = 0x4
	// Bit CTIMEOUTIE.
	SDIO_MASK_CTIMEOUTIE = 0x4
	// Position of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Pos = 0x1
	// Bit mask of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Msk = 0x2
	// Bit DCRCFAILIE.
	SDIO_MASK_DCRCFAILIE = 0x2
	// Position of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Pos = 0x0
	// Bit mask of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Msk = 0x1
	// Bit CCRCFAILIE.
	SDIO_MASK_CCRCFAILIE = 0x1

	// FIFOCNT: FIFO counter register
	// Position of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Pos = 0x0
	// Bit mask of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Msk = 0xffffff

	// FIFO: data FIFO register
	// Position of FIFOData field.
	SDIO_FIFO_FIFOData_Pos = 0x0
	// Bit mask of FIFOData field.
	SDIO_FIFO_FIFOData_Msk = 0xffffffff
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR1: Interrupt mask register
	// Position of MR0 field.
	EXTI_IMR1_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_IMR1_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_IMR1_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR1_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_IMR1_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_IMR1_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_IMR1_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR1_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_IMR1_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_IMR1_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_IMR1_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR1_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_IMR1_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_IMR1_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_IMR1_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR1_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_IMR1_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_IMR1_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_IMR1_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR1_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_IMR1_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_IMR1_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_IMR1_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR1_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_IMR1_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_IMR1_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_IMR1_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR1_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_IMR1_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_IMR1_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_IMR1_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR1_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_IMR1_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_IMR1_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_IMR1_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR1_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_IMR1_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_IMR1_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_IMR1_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR1_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_IMR1_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_IMR1_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_IMR1_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR1_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_IMR1_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_IMR1_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_IMR1_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR1_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_IMR1_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_IMR1_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_IMR1_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR1_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_IMR1_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_IMR1_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_IMR1_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR1_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_IMR1_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_IMR1_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_IMR1_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR1_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_IMR1_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_IMR1_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_IMR1_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR1_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_IMR1_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_IMR1_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_IMR1_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR1_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_IMR1_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_IMR1_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_IMR1_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR1_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_IMR1_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_IMR1_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_IMR1_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_IMR1_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_IMR1_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_IMR1_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_IMR1_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR1_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_IMR1_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_IMR1_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_IMR1_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR1_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_IMR1_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_IMR1_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_IMR1_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR1_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_IMR1_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_IMR1_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_IMR1_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR1_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR22_Unmasked = 0x1
	// Position of MR23 field.
	EXTI_IMR1_MR23_Pos = 0x17
	// Bit mask of MR23 field.
	EXTI_IMR1_MR23_Msk = 0x800000
	// Bit MR23.
	EXTI_IMR1_MR23 = 0x800000
	// Interrupt request line is masked
	EXTI_IMR1_MR23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR23_Unmasked = 0x1
	// Position of MR24 field.
	EXTI_IMR1_MR24_Pos = 0x18
	// Bit mask of MR24 field.
	EXTI_IMR1_MR24_Msk = 0x1000000
	// Bit MR24.
	EXTI_IMR1_MR24 = 0x1000000
	// Interrupt request line is masked
	EXTI_IMR1_MR24_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR24_Unmasked = 0x1
	// Position of MR25 field.
	EXTI_IMR1_MR25_Pos = 0x19
	// Bit mask of MR25 field.
	EXTI_IMR1_MR25_Msk = 0x2000000
	// Bit MR25.
	EXTI_IMR1_MR25 = 0x2000000
	// Interrupt request line is masked
	EXTI_IMR1_MR25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR25_Unmasked = 0x1
	// Position of MR26 field.
	EXTI_IMR1_MR26_Pos = 0x1a
	// Bit mask of MR26 field.
	EXTI_IMR1_MR26_Msk = 0x4000000
	// Bit MR26.
	EXTI_IMR1_MR26 = 0x4000000
	// Interrupt request line is masked
	EXTI_IMR1_MR26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR26_Unmasked = 0x1
	// Position of MR27 field.
	EXTI_IMR1_MR27_Pos = 0x1b
	// Bit mask of MR27 field.
	EXTI_IMR1_MR27_Msk = 0x8000000
	// Bit MR27.
	EXTI_IMR1_MR27 = 0x8000000
	// Interrupt request line is masked
	EXTI_IMR1_MR27_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR27_Unmasked = 0x1
	// Position of MR28 field.
	EXTI_IMR1_MR28_Pos = 0x1c
	// Bit mask of MR28 field.
	EXTI_IMR1_MR28_Msk = 0x10000000
	// Bit MR28.
	EXTI_IMR1_MR28 = 0x10000000
	// Interrupt request line is masked
	EXTI_IMR1_MR28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR28_Unmasked = 0x1
	// Position of MR29 field.
	EXTI_IMR1_MR29_Pos = 0x1d
	// Bit mask of MR29 field.
	EXTI_IMR1_MR29_Msk = 0x20000000
	// Bit MR29.
	EXTI_IMR1_MR29 = 0x20000000
	// Interrupt request line is masked
	EXTI_IMR1_MR29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR29_Unmasked = 0x1
	// Position of MR30 field.
	EXTI_IMR1_MR30_Pos = 0x1e
	// Bit mask of MR30 field.
	EXTI_IMR1_MR30_Msk = 0x40000000
	// Bit MR30.
	EXTI_IMR1_MR30 = 0x40000000
	// Interrupt request line is masked
	EXTI_IMR1_MR30_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR30_Unmasked = 0x1
	// Position of MR31 field.
	EXTI_IMR1_MR31_Pos = 0x1f
	// Bit mask of MR31 field.
	EXTI_IMR1_MR31_Msk = 0x80000000
	// Bit MR31.
	EXTI_IMR1_MR31 = 0x80000000
	// Interrupt request line is masked
	EXTI_IMR1_MR31_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR31_Unmasked = 0x1

	// EMR1: Event mask register
	// Position of MR0 field.
	EXTI_EMR1_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_EMR1_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_EMR1_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR1_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_EMR1_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_EMR1_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_EMR1_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR1_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_EMR1_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_EMR1_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_EMR1_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR1_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_EMR1_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_EMR1_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_EMR1_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR1_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_EMR1_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_EMR1_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_EMR1_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR1_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_EMR1_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_EMR1_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_EMR1_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR1_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_EMR1_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_EMR1_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_EMR1_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR1_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_EMR1_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_EMR1_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_EMR1_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR1_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_EMR1_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_EMR1_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_EMR1_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR1_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_EMR1_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_EMR1_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_EMR1_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR1_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_EMR1_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_EMR1_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_EMR1_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR1_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_EMR1_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_EMR1_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_EMR1_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR1_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_EMR1_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_EMR1_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_EMR1_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR1_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_EMR1_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_EMR1_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_EMR1_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR1_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_EMR1_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_EMR1_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_EMR1_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR1_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_EMR1_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_EMR1_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_EMR1_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR1_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_EMR1_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_EMR1_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_EMR1_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR1_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_EMR1_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_EMR1_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_EMR1_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR1_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_EMR1_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_EMR1_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_EMR1_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_EMR1_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_EMR1_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_EMR1_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_EMR1_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR1_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_EMR1_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_EMR1_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_EMR1_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_EMR1_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_EMR1_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_EMR1_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_EMR1_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR1_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_EMR1_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_EMR1_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_EMR1_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_EMR1_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR22_Unmasked = 0x1
	// Position of MR23 field.
	EXTI_EMR1_MR23_Pos = 0x17
	// Bit mask of MR23 field.
	EXTI_EMR1_MR23_Msk = 0x800000
	// Bit MR23.
	EXTI_EMR1_MR23 = 0x800000
	// Interrupt request line is masked
	EXTI_EMR1_MR23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR23_Unmasked = 0x1
	// Position of MR24 field.
	EXTI_EMR1_MR24_Pos = 0x18
	// Bit mask of MR24 field.
	EXTI_EMR1_MR24_Msk = 0x1000000
	// Bit MR24.
	EXTI_EMR1_MR24 = 0x1000000
	// Interrupt request line is masked
	EXTI_EMR1_MR24_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR24_Unmasked = 0x1
	// Position of MR25 field.
	EXTI_EMR1_MR25_Pos = 0x19
	// Bit mask of MR25 field.
	EXTI_EMR1_MR25_Msk = 0x2000000
	// Bit MR25.
	EXTI_EMR1_MR25 = 0x2000000
	// Interrupt request line is masked
	EXTI_EMR1_MR25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR25_Unmasked = 0x1
	// Position of MR26 field.
	EXTI_EMR1_MR26_Pos = 0x1a
	// Bit mask of MR26 field.
	EXTI_EMR1_MR26_Msk = 0x4000000
	// Bit MR26.
	EXTI_EMR1_MR26 = 0x4000000
	// Interrupt request line is masked
	EXTI_EMR1_MR26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR26_Unmasked = 0x1
	// Position of MR27 field.
	EXTI_EMR1_MR27_Pos = 0x1b
	// Bit mask of MR27 field.
	EXTI_EMR1_MR27_Msk = 0x8000000
	// Bit MR27.
	EXTI_EMR1_MR27 = 0x8000000
	// Interrupt request line is masked
	EXTI_EMR1_MR27_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR27_Unmasked = 0x1
	// Position of MR28 field.
	EXTI_EMR1_MR28_Pos = 0x1c
	// Bit mask of MR28 field.
	EXTI_EMR1_MR28_Msk = 0x10000000
	// Bit MR28.
	EXTI_EMR1_MR28 = 0x10000000
	// Interrupt request line is masked
	EXTI_EMR1_MR28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR28_Unmasked = 0x1
	// Position of MR29 field.
	EXTI_EMR1_MR29_Pos = 0x1d
	// Bit mask of MR29 field.
	EXTI_EMR1_MR29_Msk = 0x20000000
	// Bit MR29.
	EXTI_EMR1_MR29 = 0x20000000
	// Interrupt request line is masked
	EXTI_EMR1_MR29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR29_Unmasked = 0x1
	// Position of MR30 field.
	EXTI_EMR1_MR30_Pos = 0x1e
	// Bit mask of MR30 field.
	EXTI_EMR1_MR30_Msk = 0x40000000
	// Bit MR30.
	EXTI_EMR1_MR30 = 0x40000000
	// Interrupt request line is masked
	EXTI_EMR1_MR30_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR30_Unmasked = 0x1
	// Position of MR31 field.
	EXTI_EMR1_MR31_Pos = 0x1f
	// Bit mask of MR31 field.
	EXTI_EMR1_MR31_Msk = 0x80000000
	// Bit MR31.
	EXTI_EMR1_MR31 = 0x80000000
	// Interrupt request line is masked
	EXTI_EMR1_MR31_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR31_Unmasked = 0x1

	// RTSR1: Rising Trigger selection register
	// Position of TR0 field.
	EXTI_RTSR1_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_RTSR1_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_RTSR1_TR0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_RTSR1_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_RTSR1_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_RTSR1_TR1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_RTSR1_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_RTSR1_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_RTSR1_TR2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_RTSR1_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_RTSR1_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_RTSR1_TR3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_RTSR1_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_RTSR1_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_RTSR1_TR4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_RTSR1_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_RTSR1_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_RTSR1_TR5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_RTSR1_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_RTSR1_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_RTSR1_TR6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_RTSR1_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_RTSR1_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_RTSR1_TR7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_RTSR1_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_RTSR1_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_RTSR1_TR8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_RTSR1_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_RTSR1_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_RTSR1_TR9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_RTSR1_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_RTSR1_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_RTSR1_TR10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_RTSR1_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_RTSR1_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_RTSR1_TR11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_RTSR1_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_RTSR1_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_RTSR1_TR12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_RTSR1_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_RTSR1_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_RTSR1_TR13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_RTSR1_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_RTSR1_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_RTSR1_TR14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_RTSR1_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_RTSR1_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_RTSR1_TR15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_RTSR1_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_RTSR1_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_RTSR1_TR16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR16_Enabled = 0x1
	// Position of TR18 field.
	EXTI_RTSR1_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_RTSR1_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_RTSR1_TR18 = 0x40000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR18_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_RTSR1_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_RTSR1_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_RTSR1_TR19 = 0x80000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR19_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_RTSR1_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_RTSR1_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_RTSR1_TR20 = 0x100000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR20_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_RTSR1_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_RTSR1_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_RTSR1_TR21 = 0x200000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR21_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_RTSR1_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_RTSR1_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_RTSR1_TR22 = 0x400000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR22_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR22_Enabled = 0x1

	// FTSR1: Falling Trigger selection register
	// Position of TR0 field.
	EXTI_FTSR1_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_FTSR1_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_FTSR1_TR0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_FTSR1_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_FTSR1_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_FTSR1_TR1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_FTSR1_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_FTSR1_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_FTSR1_TR2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_FTSR1_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_FTSR1_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_FTSR1_TR3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_FTSR1_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_FTSR1_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_FTSR1_TR4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_FTSR1_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_FTSR1_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_FTSR1_TR5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_FTSR1_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_FTSR1_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_FTSR1_TR6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_FTSR1_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_FTSR1_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_FTSR1_TR7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_FTSR1_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_FTSR1_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_FTSR1_TR8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_FTSR1_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_FTSR1_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_FTSR1_TR9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_FTSR1_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_FTSR1_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_FTSR1_TR10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_FTSR1_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_FTSR1_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_FTSR1_TR11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_FTSR1_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_FTSR1_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_FTSR1_TR12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_FTSR1_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_FTSR1_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_FTSR1_TR13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_FTSR1_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_FTSR1_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_FTSR1_TR14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_FTSR1_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_FTSR1_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_FTSR1_TR15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_FTSR1_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_FTSR1_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_FTSR1_TR16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR16_Enabled = 0x1
	// Position of TR18 field.
	EXTI_FTSR1_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_FTSR1_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_FTSR1_TR18 = 0x40000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR18_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_FTSR1_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_FTSR1_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_FTSR1_TR19 = 0x80000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR19_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_FTSR1_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_FTSR1_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_FTSR1_TR20 = 0x100000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR20_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_FTSR1_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_FTSR1_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_FTSR1_TR21 = 0x200000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR21_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_FTSR1_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_FTSR1_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_FTSR1_TR22 = 0x400000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR22_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR22_Enabled = 0x1

	// SWIER1: Software interrupt event register
	// Position of SWIER0 field.
	EXTI_SWIER1_SWIER0_Pos = 0x0
	// Bit mask of SWIER0 field.
	EXTI_SWIER1_SWIER0_Msk = 0x1
	// Bit SWIER0.
	EXTI_SWIER1_SWIER0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER1_SWIER0_Pend = 0x1
	// Position of SWIER1 field.
	EXTI_SWIER1_SWIER1_Pos = 0x1
	// Bit mask of SWIER1 field.
	EXTI_SWIER1_SWIER1_Msk = 0x2
	// Bit SWIER1.
	EXTI_SWIER1_SWIER1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER1_SWIER1_Pend = 0x1
	// Position of SWIER2 field.
	EXTI_SWIER1_SWIER2_Pos = 0x2
	// Bit mask of SWIER2 field.
	EXTI_SWIER1_SWIER2_Msk = 0x4
	// Bit SWIER2.
	EXTI_SWIER1_SWIER2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER1_SWIER2_Pend = 0x1
	// Position of SWIER3 field.
	EXTI_SWIER1_SWIER3_Pos = 0x3
	// Bit mask of SWIER3 field.
	EXTI_SWIER1_SWIER3_Msk = 0x8
	// Bit SWIER3.
	EXTI_SWIER1_SWIER3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER1_SWIER3_Pend = 0x1
	// Position of SWIER4 field.
	EXTI_SWIER1_SWIER4_Pos = 0x4
	// Bit mask of SWIER4 field.
	EXTI_SWIER1_SWIER4_Msk = 0x10
	// Bit SWIER4.
	EXTI_SWIER1_SWIER4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER1_SWIER4_Pend = 0x1
	// Position of SWIER5 field.
	EXTI_SWIER1_SWIER5_Pos = 0x5
	// Bit mask of SWIER5 field.
	EXTI_SWIER1_SWIER5_Msk = 0x20
	// Bit SWIER5.
	EXTI_SWIER1_SWIER5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER1_SWIER5_Pend = 0x1
	// Position of SWIER6 field.
	EXTI_SWIER1_SWIER6_Pos = 0x6
	// Bit mask of SWIER6 field.
	EXTI_SWIER1_SWIER6_Msk = 0x40
	// Bit SWIER6.
	EXTI_SWIER1_SWIER6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER1_SWIER6_Pend = 0x1
	// Position of SWIER7 field.
	EXTI_SWIER1_SWIER7_Pos = 0x7
	// Bit mask of SWIER7 field.
	EXTI_SWIER1_SWIER7_Msk = 0x80
	// Bit SWIER7.
	EXTI_SWIER1_SWIER7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER1_SWIER7_Pend = 0x1
	// Position of SWIER8 field.
	EXTI_SWIER1_SWIER8_Pos = 0x8
	// Bit mask of SWIER8 field.
	EXTI_SWIER1_SWIER8_Msk = 0x100
	// Bit SWIER8.
	EXTI_SWIER1_SWIER8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER1_SWIER8_Pend = 0x1
	// Position of SWIER9 field.
	EXTI_SWIER1_SWIER9_Pos = 0x9
	// Bit mask of SWIER9 field.
	EXTI_SWIER1_SWIER9_Msk = 0x200
	// Bit SWIER9.
	EXTI_SWIER1_SWIER9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER1_SWIER9_Pend = 0x1
	// Position of SWIER10 field.
	EXTI_SWIER1_SWIER10_Pos = 0xa
	// Bit mask of SWIER10 field.
	EXTI_SWIER1_SWIER10_Msk = 0x400
	// Bit SWIER10.
	EXTI_SWIER1_SWIER10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER1_SWIER10_Pend = 0x1
	// Position of SWIER11 field.
	EXTI_SWIER1_SWIER11_Pos = 0xb
	// Bit mask of SWIER11 field.
	EXTI_SWIER1_SWIER11_Msk = 0x800
	// Bit SWIER11.
	EXTI_SWIER1_SWIER11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER1_SWIER11_Pend = 0x1
	// Position of SWIER12 field.
	EXTI_SWIER1_SWIER12_Pos = 0xc
	// Bit mask of SWIER12 field.
	EXTI_SWIER1_SWIER12_Msk = 0x1000
	// Bit SWIER12.
	EXTI_SWIER1_SWIER12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER12_Pend = 0x1
	// Position of SWIER13 field.
	EXTI_SWIER1_SWIER13_Pos = 0xd
	// Bit mask of SWIER13 field.
	EXTI_SWIER1_SWIER13_Msk = 0x2000
	// Bit SWIER13.
	EXTI_SWIER1_SWIER13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER13_Pend = 0x1
	// Position of SWIER14 field.
	EXTI_SWIER1_SWIER14_Pos = 0xe
	// Bit mask of SWIER14 field.
	EXTI_SWIER1_SWIER14_Msk = 0x4000
	// Bit SWIER14.
	EXTI_SWIER1_SWIER14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER14_Pend = 0x1
	// Position of SWIER15 field.
	EXTI_SWIER1_SWIER15_Pos = 0xf
	// Bit mask of SWIER15 field.
	EXTI_SWIER1_SWIER15_Msk = 0x8000
	// Bit SWIER15.
	EXTI_SWIER1_SWIER15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER15_Pend = 0x1
	// Position of SWIER16 field.
	EXTI_SWIER1_SWIER16_Pos = 0x10
	// Bit mask of SWIER16 field.
	EXTI_SWIER1_SWIER16_Msk = 0x10000
	// Bit SWIER16.
	EXTI_SWIER1_SWIER16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER16_Pend = 0x1
	// Position of SWIER18 field.
	EXTI_SWIER1_SWIER18_Pos = 0x12
	// Bit mask of SWIER18 field.
	EXTI_SWIER1_SWIER18_Msk = 0x40000
	// Bit SWIER18.
	EXTI_SWIER1_SWIER18 = 0x40000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER18_Pend = 0x1
	// Position of SWIER19 field.
	EXTI_SWIER1_SWIER19_Pos = 0x13
	// Bit mask of SWIER19 field.
	EXTI_SWIER1_SWIER19_Msk = 0x80000
	// Bit SWIER19.
	EXTI_SWIER1_SWIER19 = 0x80000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER19_Pend = 0x1
	// Position of SWIER20 field.
	EXTI_SWIER1_SWIER20_Pos = 0x14
	// Bit mask of SWIER20 field.
	EXTI_SWIER1_SWIER20_Msk = 0x100000
	// Bit SWIER20.
	EXTI_SWIER1_SWIER20 = 0x100000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER20_Pend = 0x1
	// Position of SWIER21 field.
	EXTI_SWIER1_SWIER21_Pos = 0x15
	// Bit mask of SWIER21 field.
	EXTI_SWIER1_SWIER21_Msk = 0x200000
	// Bit SWIER21.
	EXTI_SWIER1_SWIER21 = 0x200000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER21_Pend = 0x1
	// Position of SWIER22 field.
	EXTI_SWIER1_SWIER22_Pos = 0x16
	// Bit mask of SWIER22 field.
	EXTI_SWIER1_SWIER22_Msk = 0x400000
	// Bit SWIER22.
	EXTI_SWIER1_SWIER22 = 0x400000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER22_Pend = 0x1

	// PR1: Pending register
	// Position of PR0 field.
	EXTI_PR1_PR0_Pos = 0x0
	// Bit mask of PR0 field.
	EXTI_PR1_PR0_Msk = 0x1
	// Bit PR0.
	EXTI_PR1_PR0 = 0x1
	// No trigger request occurred
	EXTI_PR1_PR0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR0_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR0_Clear = 0x1
	// Position of PR1 field.
	EXTI_PR1_PR1_Pos = 0x1
	// Bit mask of PR1 field.
	EXTI_PR1_PR1_Msk = 0x2
	// Bit PR1.
	EXTI_PR1_PR1 = 0x2
	// No trigger request occurred
	EXTI_PR1_PR1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR1_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR1_Clear = 0x1
	// Position of PR2 field.
	EXTI_PR1_PR2_Pos = 0x2
	// Bit mask of PR2 field.
	EXTI_PR1_PR2_Msk = 0x4
	// Bit PR2.
	EXTI_PR1_PR2 = 0x4
	// No trigger request occurred
	EXTI_PR1_PR2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR2_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR2_Clear = 0x1
	// Position of PR3 field.
	EXTI_PR1_PR3_Pos = 0x3
	// Bit mask of PR3 field.
	EXTI_PR1_PR3_Msk = 0x8
	// Bit PR3.
	EXTI_PR1_PR3 = 0x8
	// No trigger request occurred
	EXTI_PR1_PR3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR3_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR3_Clear = 0x1
	// Position of PR4 field.
	EXTI_PR1_PR4_Pos = 0x4
	// Bit mask of PR4 field.
	EXTI_PR1_PR4_Msk = 0x10
	// Bit PR4.
	EXTI_PR1_PR4 = 0x10
	// No trigger request occurred
	EXTI_PR1_PR4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR4_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR4_Clear = 0x1
	// Position of PR5 field.
	EXTI_PR1_PR5_Pos = 0x5
	// Bit mask of PR5 field.
	EXTI_PR1_PR5_Msk = 0x20
	// Bit PR5.
	EXTI_PR1_PR5 = 0x20
	// No trigger request occurred
	EXTI_PR1_PR5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR5_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR5_Clear = 0x1
	// Position of PR6 field.
	EXTI_PR1_PR6_Pos = 0x6
	// Bit mask of PR6 field.
	EXTI_PR1_PR6_Msk = 0x40
	// Bit PR6.
	EXTI_PR1_PR6 = 0x40
	// No trigger request occurred
	EXTI_PR1_PR6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR6_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR6_Clear = 0x1
	// Position of PR7 field.
	EXTI_PR1_PR7_Pos = 0x7
	// Bit mask of PR7 field.
	EXTI_PR1_PR7_Msk = 0x80
	// Bit PR7.
	EXTI_PR1_PR7 = 0x80
	// No trigger request occurred
	EXTI_PR1_PR7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR7_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR7_Clear = 0x1
	// Position of PR8 field.
	EXTI_PR1_PR8_Pos = 0x8
	// Bit mask of PR8 field.
	EXTI_PR1_PR8_Msk = 0x100
	// Bit PR8.
	EXTI_PR1_PR8 = 0x100
	// No trigger request occurred
	EXTI_PR1_PR8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR8_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR8_Clear = 0x1
	// Position of PR9 field.
	EXTI_PR1_PR9_Pos = 0x9
	// Bit mask of PR9 field.
	EXTI_PR1_PR9_Msk = 0x200
	// Bit PR9.
	EXTI_PR1_PR9 = 0x200
	// No trigger request occurred
	EXTI_PR1_PR9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR9_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR9_Clear = 0x1
	// Position of PR10 field.
	EXTI_PR1_PR10_Pos = 0xa
	// Bit mask of PR10 field.
	EXTI_PR1_PR10_Msk = 0x400
	// Bit PR10.
	EXTI_PR1_PR10 = 0x400
	// No trigger request occurred
	EXTI_PR1_PR10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR10_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR10_Clear = 0x1
	// Position of PR11 field.
	EXTI_PR1_PR11_Pos = 0xb
	// Bit mask of PR11 field.
	EXTI_PR1_PR11_Msk = 0x800
	// Bit PR11.
	EXTI_PR1_PR11 = 0x800
	// No trigger request occurred
	EXTI_PR1_PR11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR11_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR11_Clear = 0x1
	// Position of PR12 field.
	EXTI_PR1_PR12_Pos = 0xc
	// Bit mask of PR12 field.
	EXTI_PR1_PR12_Msk = 0x1000
	// Bit PR12.
	EXTI_PR1_PR12 = 0x1000
	// No trigger request occurred
	EXTI_PR1_PR12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR12_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR12_Clear = 0x1
	// Position of PR13 field.
	EXTI_PR1_PR13_Pos = 0xd
	// Bit mask of PR13 field.
	EXTI_PR1_PR13_Msk = 0x2000
	// Bit PR13.
	EXTI_PR1_PR13 = 0x2000
	// No trigger request occurred
	EXTI_PR1_PR13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR13_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR13_Clear = 0x1
	// Position of PR14 field.
	EXTI_PR1_PR14_Pos = 0xe
	// Bit mask of PR14 field.
	EXTI_PR1_PR14_Msk = 0x4000
	// Bit PR14.
	EXTI_PR1_PR14 = 0x4000
	// No trigger request occurred
	EXTI_PR1_PR14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR14_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR14_Clear = 0x1
	// Position of PR15 field.
	EXTI_PR1_PR15_Pos = 0xf
	// Bit mask of PR15 field.
	EXTI_PR1_PR15_Msk = 0x8000
	// Bit PR15.
	EXTI_PR1_PR15 = 0x8000
	// No trigger request occurred
	EXTI_PR1_PR15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR15_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR15_Clear = 0x1
	// Position of PR16 field.
	EXTI_PR1_PR16_Pos = 0x10
	// Bit mask of PR16 field.
	EXTI_PR1_PR16_Msk = 0x10000
	// Bit PR16.
	EXTI_PR1_PR16 = 0x10000
	// No trigger request occurred
	EXTI_PR1_PR16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR16_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR16_Clear = 0x1
	// Position of PR18 field.
	EXTI_PR1_PR18_Pos = 0x12
	// Bit mask of PR18 field.
	EXTI_PR1_PR18_Msk = 0x40000
	// Bit PR18.
	EXTI_PR1_PR18 = 0x40000
	// No trigger request occurred
	EXTI_PR1_PR18_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR18_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR18_Clear = 0x1
	// Position of PR19 field.
	EXTI_PR1_PR19_Pos = 0x13
	// Bit mask of PR19 field.
	EXTI_PR1_PR19_Msk = 0x80000
	// Bit PR19.
	EXTI_PR1_PR19 = 0x80000
	// No trigger request occurred
	EXTI_PR1_PR19_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR19_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR19_Clear = 0x1
	// Position of PR20 field.
	EXTI_PR1_PR20_Pos = 0x14
	// Bit mask of PR20 field.
	EXTI_PR1_PR20_Msk = 0x100000
	// Bit PR20.
	EXTI_PR1_PR20 = 0x100000
	// No trigger request occurred
	EXTI_PR1_PR20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR20_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR20_Clear = 0x1
	// Position of PR21 field.
	EXTI_PR1_PR21_Pos = 0x15
	// Bit mask of PR21 field.
	EXTI_PR1_PR21_Msk = 0x200000
	// Bit PR21.
	EXTI_PR1_PR21 = 0x200000
	// No trigger request occurred
	EXTI_PR1_PR21_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR21_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR21_Clear = 0x1
	// Position of PR22 field.
	EXTI_PR1_PR22_Pos = 0x16
	// Bit mask of PR22 field.
	EXTI_PR1_PR22_Msk = 0x400000
	// Bit PR22.
	EXTI_PR1_PR22 = 0x400000
	// No trigger request occurred
	EXTI_PR1_PR22_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR22_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR22_Clear = 0x1

	// IMR2: Interrupt mask register
	// Position of MR32 field.
	EXTI_IMR2_MR32_Pos = 0x0
	// Bit mask of MR32 field.
	EXTI_IMR2_MR32_Msk = 0x1
	// Bit MR32.
	EXTI_IMR2_MR32 = 0x1
	// Interrupt request line is masked
	EXTI_IMR2_MR32_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR32_Unmasked = 0x1
	// Position of MR33 field.
	EXTI_IMR2_MR33_Pos = 0x1
	// Bit mask of MR33 field.
	EXTI_IMR2_MR33_Msk = 0x2
	// Bit MR33.
	EXTI_IMR2_MR33 = 0x2
	// Interrupt request line is masked
	EXTI_IMR2_MR33_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR33_Unmasked = 0x1
	// Position of MR34 field.
	EXTI_IMR2_MR34_Pos = 0x2
	// Bit mask of MR34 field.
	EXTI_IMR2_MR34_Msk = 0x4
	// Bit MR34.
	EXTI_IMR2_MR34 = 0x4
	// Interrupt request line is masked
	EXTI_IMR2_MR34_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR34_Unmasked = 0x1
	// Position of MR35 field.
	EXTI_IMR2_MR35_Pos = 0x3
	// Bit mask of MR35 field.
	EXTI_IMR2_MR35_Msk = 0x8
	// Bit MR35.
	EXTI_IMR2_MR35 = 0x8
	// Interrupt request line is masked
	EXTI_IMR2_MR35_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR35_Unmasked = 0x1
	// Position of MR36 field.
	EXTI_IMR2_MR36_Pos = 0x4
	// Bit mask of MR36 field.
	EXTI_IMR2_MR36_Msk = 0x10
	// Bit MR36.
	EXTI_IMR2_MR36 = 0x10
	// Interrupt request line is masked
	EXTI_IMR2_MR36_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR36_Unmasked = 0x1
	// Position of MR37 field.
	EXTI_IMR2_MR37_Pos = 0x5
	// Bit mask of MR37 field.
	EXTI_IMR2_MR37_Msk = 0x20
	// Bit MR37.
	EXTI_IMR2_MR37 = 0x20
	// Interrupt request line is masked
	EXTI_IMR2_MR37_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR37_Unmasked = 0x1
	// Position of MR38 field.
	EXTI_IMR2_MR38_Pos = 0x6
	// Bit mask of MR38 field.
	EXTI_IMR2_MR38_Msk = 0x40
	// Bit MR38.
	EXTI_IMR2_MR38 = 0x40
	// Interrupt request line is masked
	EXTI_IMR2_MR38_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR38_Unmasked = 0x1
	// Position of MR39 field.
	EXTI_IMR2_MR39_Pos = 0x7
	// Bit mask of MR39 field.
	EXTI_IMR2_MR39_Msk = 0x80
	// Bit MR39.
	EXTI_IMR2_MR39 = 0x80
	// Interrupt request line is masked
	EXTI_IMR2_MR39_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR39_Unmasked = 0x1

	// EMR2: Event mask register
	// Position of MR32 field.
	EXTI_EMR2_MR32_Pos = 0x0
	// Bit mask of MR32 field.
	EXTI_EMR2_MR32_Msk = 0x1
	// Bit MR32.
	EXTI_EMR2_MR32 = 0x1
	// Interrupt request line is masked
	EXTI_EMR2_MR32_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR32_Unmasked = 0x1
	// Position of MR33 field.
	EXTI_EMR2_MR33_Pos = 0x1
	// Bit mask of MR33 field.
	EXTI_EMR2_MR33_Msk = 0x2
	// Bit MR33.
	EXTI_EMR2_MR33 = 0x2
	// Interrupt request line is masked
	EXTI_EMR2_MR33_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR33_Unmasked = 0x1
	// Position of MR34 field.
	EXTI_EMR2_MR34_Pos = 0x2
	// Bit mask of MR34 field.
	EXTI_EMR2_MR34_Msk = 0x4
	// Bit MR34.
	EXTI_EMR2_MR34 = 0x4
	// Interrupt request line is masked
	EXTI_EMR2_MR34_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR34_Unmasked = 0x1
	// Position of MR35 field.
	EXTI_EMR2_MR35_Pos = 0x3
	// Bit mask of MR35 field.
	EXTI_EMR2_MR35_Msk = 0x8
	// Bit MR35.
	EXTI_EMR2_MR35 = 0x8
	// Interrupt request line is masked
	EXTI_EMR2_MR35_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR35_Unmasked = 0x1
	// Position of MR36 field.
	EXTI_EMR2_MR36_Pos = 0x4
	// Bit mask of MR36 field.
	EXTI_EMR2_MR36_Msk = 0x10
	// Bit MR36.
	EXTI_EMR2_MR36 = 0x10
	// Interrupt request line is masked
	EXTI_EMR2_MR36_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR36_Unmasked = 0x1
	// Position of MR37 field.
	EXTI_EMR2_MR37_Pos = 0x5
	// Bit mask of MR37 field.
	EXTI_EMR2_MR37_Msk = 0x20
	// Bit MR37.
	EXTI_EMR2_MR37 = 0x20
	// Interrupt request line is masked
	EXTI_EMR2_MR37_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR37_Unmasked = 0x1
	// Position of MR38 field.
	EXTI_EMR2_MR38_Pos = 0x6
	// Bit mask of MR38 field.
	EXTI_EMR2_MR38_Msk = 0x40
	// Bit MR38.
	EXTI_EMR2_MR38 = 0x40
	// Interrupt request line is masked
	EXTI_EMR2_MR38_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR38_Unmasked = 0x1
	// Position of MR39 field.
	EXTI_EMR2_MR39_Pos = 0x7
	// Bit mask of MR39 field.
	EXTI_EMR2_MR39_Msk = 0x80
	// Bit MR39.
	EXTI_EMR2_MR39 = 0x80
	// Interrupt request line is masked
	EXTI_EMR2_MR39_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR39_Unmasked = 0x1

	// RTSR2: Rising Trigger selection register
	// Position of RT35 field.
	EXTI_RTSR2_RT35_Pos = 0x3
	// Bit mask of RT35 field.
	EXTI_RTSR2_RT35_Msk = 0x8
	// Bit RT35.
	EXTI_RTSR2_RT35 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR2_RT35_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_RT35_Enabled = 0x1
	// Position of RT36 field.
	EXTI_RTSR2_RT36_Pos = 0x4
	// Bit mask of RT36 field.
	EXTI_RTSR2_RT36_Msk = 0x10
	// Bit RT36.
	EXTI_RTSR2_RT36 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR2_RT36_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_RT36_Enabled = 0x1
	// Position of RT37 field.
	EXTI_RTSR2_RT37_Pos = 0x5
	// Bit mask of RT37 field.
	EXTI_RTSR2_RT37_Msk = 0x20
	// Bit RT37.
	EXTI_RTSR2_RT37 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR2_RT37_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_RT37_Enabled = 0x1
	// Position of RT38 field.
	EXTI_RTSR2_RT38_Pos = 0x6
	// Bit mask of RT38 field.
	EXTI_RTSR2_RT38_Msk = 0x40
	// Bit RT38.
	EXTI_RTSR2_RT38 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR2_RT38_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_RT38_Enabled = 0x1

	// FTSR2: Falling Trigger selection register
	// Position of FT35 field.
	EXTI_FTSR2_FT35_Pos = 0x3
	// Bit mask of FT35 field.
	EXTI_FTSR2_FT35_Msk = 0x8
	// Bit FT35.
	EXTI_FTSR2_FT35 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR2_FT35_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_FT35_Enabled = 0x1
	// Position of FT36 field.
	EXTI_FTSR2_FT36_Pos = 0x4
	// Bit mask of FT36 field.
	EXTI_FTSR2_FT36_Msk = 0x10
	// Bit FT36.
	EXTI_FTSR2_FT36 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR2_FT36_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_FT36_Enabled = 0x1
	// Position of FT37 field.
	EXTI_FTSR2_FT37_Pos = 0x5
	// Bit mask of FT37 field.
	EXTI_FTSR2_FT37_Msk = 0x20
	// Bit FT37.
	EXTI_FTSR2_FT37 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR2_FT37_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_FT37_Enabled = 0x1
	// Position of FT38 field.
	EXTI_FTSR2_FT38_Pos = 0x6
	// Bit mask of FT38 field.
	EXTI_FTSR2_FT38_Msk = 0x40
	// Bit FT38.
	EXTI_FTSR2_FT38 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR2_FT38_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_FT38_Enabled = 0x1

	// SWIER2: Software interrupt event register
	// Position of SWI35 field.
	EXTI_SWIER2_SWI35_Pos = 0x3
	// Bit mask of SWI35 field.
	EXTI_SWIER2_SWI35_Msk = 0x8
	// Bit SWI35.
	EXTI_SWIER2_SWI35 = 0x8
	// Generates an interrupt request
	EXTI_SWIER2_SWI35_Pend = 0x1
	// Position of SWI36 field.
	EXTI_SWIER2_SWI36_Pos = 0x4
	// Bit mask of SWI36 field.
	EXTI_SWIER2_SWI36_Msk = 0x10
	// Bit SWI36.
	EXTI_SWIER2_SWI36 = 0x10
	// Generates an interrupt request
	EXTI_SWIER2_SWI36_Pend = 0x1
	// Position of SWI37 field.
	EXTI_SWIER2_SWI37_Pos = 0x5
	// Bit mask of SWI37 field.
	EXTI_SWIER2_SWI37_Msk = 0x20
	// Bit SWI37.
	EXTI_SWIER2_SWI37 = 0x20
	// Generates an interrupt request
	EXTI_SWIER2_SWI37_Pend = 0x1
	// Position of SWI38 field.
	EXTI_SWIER2_SWI38_Pos = 0x6
	// Bit mask of SWI38 field.
	EXTI_SWIER2_SWI38_Msk = 0x40
	// Bit SWI38.
	EXTI_SWIER2_SWI38 = 0x40
	// Generates an interrupt request
	EXTI_SWIER2_SWI38_Pend = 0x1

	// PR2: Pending register
	// Position of PIF35 field.
	EXTI_PR2_PIF35_Pos = 0x3
	// Bit mask of PIF35 field.
	EXTI_PR2_PIF35_Msk = 0x8
	// Bit PIF35.
	EXTI_PR2_PIF35 = 0x8
	// No trigger request occurred
	EXTI_PR2_PIF35_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PIF35_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PIF35_Clear = 0x1
	// Position of PIF36 field.
	EXTI_PR2_PIF36_Pos = 0x4
	// Bit mask of PIF36 field.
	EXTI_PR2_PIF36_Msk = 0x10
	// Bit PIF36.
	EXTI_PR2_PIF36 = 0x10
	// No trigger request occurred
	EXTI_PR2_PIF36_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PIF36_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PIF36_Clear = 0x1
	// Position of PIF37 field.
	EXTI_PR2_PIF37_Pos = 0x5
	// Bit mask of PIF37 field.
	EXTI_PR2_PIF37_Msk = 0x20
	// Bit PIF37.
	EXTI_PR2_PIF37 = 0x20
	// No trigger request occurred
	EXTI_PR2_PIF37_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PIF37_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PIF37_Clear = 0x1
	// Position of PIF38 field.
	EXTI_PR2_PIF38_Pos = 0x6
	// Bit mask of PIF38 field.
	EXTI_PR2_PIF38_Msk = 0x40
	// Bit PIF38.
	EXTI_PR2_PIF38 = 0x40
	// No trigger request occurred
	EXTI_PR2_PIF38_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PIF38_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PIF38_Clear = 0x1
)

// Bitfields for VREFBUF: Voltage reference buffer
const (
	// CSR: VREF control and status register
	// Position of ENVR field.
	VREF_CSR_ENVR_Pos = 0x0
	// Bit mask of ENVR field.
	VREF_CSR_ENVR_Msk = 0x1
	// Bit ENVR.
	VREF_CSR_ENVR = 0x1
	// Position of HIZ field.
	VREF_CSR_HIZ_Pos = 0x1
	// Bit mask of HIZ field.
	VREF_CSR_HIZ_Msk = 0x2
	// Bit HIZ.
	VREF_CSR_HIZ = 0x2
	// Position of VRS field.
	VREF_CSR_VRS_Pos = 0x2
	// Bit mask of VRS field.
	VREF_CSR_VRS_Msk = 0x4
	// Bit VRS.
	VREF_CSR_VRS = 0x4
	// Position of VRR field.
	VREF_CSR_VRR_Pos = 0x3
	// Bit mask of VRR field.
	VREF_CSR_VRR_Msk = 0x8
	// Bit VRR.
	VREF_CSR_VRR = 0x8

	// CCR: calibration control register
	// Position of TRIM field.
	VREF_CCR_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	VREF_CCR_TRIM_Msk = 0x3f
)

// Bitfields for CAN1: Controller area network
const (
	// MCR: master control register
	// Position of DBF field.
	CAN_MCR_DBF_Pos = 0x10
	// Bit mask of DBF field.
	CAN_MCR_DBF_Msk = 0x10000
	// Bit DBF.
	CAN_MCR_DBF = 0x10000
	// Position of RESET field.
	CAN_MCR_RESET_Pos = 0xf
	// Bit mask of RESET field.
	CAN_MCR_RESET_Msk = 0x8000
	// Bit RESET.
	CAN_MCR_RESET = 0x8000
	// Position of TTCM field.
	CAN_MCR_TTCM_Pos = 0x7
	// Bit mask of TTCM field.
	CAN_MCR_TTCM_Msk = 0x80
	// Bit TTCM.
	CAN_MCR_TTCM = 0x80
	// Position of ABOM field.
	CAN_MCR_ABOM_Pos = 0x6
	// Bit mask of ABOM field.
	CAN_MCR_ABOM_Msk = 0x40
	// Bit ABOM.
	CAN_MCR_ABOM = 0x40
	// Position of AWUM field.
	CAN_MCR_AWUM_Pos = 0x5
	// Bit mask of AWUM field.
	CAN_MCR_AWUM_Msk = 0x20
	// Bit AWUM.
	CAN_MCR_AWUM = 0x20
	// Position of NART field.
	CAN_MCR_NART_Pos = 0x4
	// Bit mask of NART field.
	CAN_MCR_NART_Msk = 0x10
	// Bit NART.
	CAN_MCR_NART = 0x10
	// Position of RFLM field.
	CAN_MCR_RFLM_Pos = 0x3
	// Bit mask of RFLM field.
	CAN_MCR_RFLM_Msk = 0x8
	// Bit RFLM.
	CAN_MCR_RFLM = 0x8
	// Position of TXFP field.
	CAN_MCR_TXFP_Pos = 0x2
	// Bit mask of TXFP field.
	CAN_MCR_TXFP_Msk = 0x4
	// Bit TXFP.
	CAN_MCR_TXFP = 0x4
	// Position of SLEEP field.
	CAN_MCR_SLEEP_Pos = 0x1
	// Bit mask of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2
	// Bit SLEEP.
	CAN_MCR_SLEEP = 0x2
	// Position of INRQ field.
	CAN_MCR_INRQ_Pos = 0x0
	// Bit mask of INRQ field.
	CAN_MCR_INRQ_Msk = 0x1
	// Bit INRQ.
	CAN_MCR_INRQ = 0x1

	// MSR: master status register
	// Position of RX field.
	CAN_MSR_RX_Pos = 0xb
	// Bit mask of RX field.
	CAN_MSR_RX_Msk = 0x800
	// Bit RX.
	CAN_MSR_RX = 0x800
	// Position of SAMP field.
	CAN_MSR_SAMP_Pos = 0xa
	// Bit mask of SAMP field.
	CAN_MSR_SAMP_Msk = 0x400
	// Bit SAMP.
	CAN_MSR_SAMP = 0x400
	// Position of RXM field.
	CAN_MSR_RXM_Pos = 0x9
	// Bit mask of RXM field.
	CAN_MSR_RXM_Msk = 0x200
	// Bit RXM.
	CAN_MSR_RXM = 0x200
	// Position of TXM field.
	CAN_MSR_TXM_Pos = 0x8
	// Bit mask of TXM field.
	CAN_MSR_TXM_Msk = 0x100
	// Bit TXM.
	CAN_MSR_TXM = 0x100
	// Position of SLAKI field.
	CAN_MSR_SLAKI_Pos = 0x4
	// Bit mask of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10
	// Bit SLAKI.
	CAN_MSR_SLAKI = 0x10
	// Position of WKUI field.
	CAN_MSR_WKUI_Pos = 0x3
	// Bit mask of WKUI field.
	CAN_MSR_WKUI_Msk = 0x8
	// Bit WKUI.
	CAN_MSR_WKUI = 0x8
	// Position of ERRI field.
	CAN_MSR_ERRI_Pos = 0x2
	// Bit mask of ERRI field.
	CAN_MSR_ERRI_Msk = 0x4
	// Bit ERRI.
	CAN_MSR_ERRI = 0x4
	// Position of SLAK field.
	CAN_MSR_SLAK_Pos = 0x1
	// Bit mask of SLAK field.
	CAN_MSR_SLAK_Msk = 0x2
	// Bit SLAK.
	CAN_MSR_SLAK = 0x2
	// Position of INAK field.
	CAN_MSR_INAK_Pos = 0x0
	// Bit mask of INAK field.
	CAN_MSR_INAK_Msk = 0x1
	// Bit INAK.
	CAN_MSR_INAK = 0x1

	// TSR: transmit status register
	// Position of LOW2 field.
	CAN_TSR_LOW2_Pos = 0x1f
	// Bit mask of LOW2 field.
	CAN_TSR_LOW2_Msk = 0x80000000
	// Bit LOW2.
	CAN_TSR_LOW2 = 0x80000000
	// Position of LOW1 field.
	CAN_TSR_LOW1_Pos = 0x1e
	// Bit mask of LOW1 field.
	CAN_TSR_LOW1_Msk = 0x40000000
	// Bit LOW1.
	CAN_TSR_LOW1 = 0x40000000
	// Position of LOW0 field.
	CAN_TSR_LOW0_Pos = 0x1d
	// Bit mask of LOW0 field.
	CAN_TSR_LOW0_Msk = 0x20000000
	// Bit LOW0.
	CAN_TSR_LOW0 = 0x20000000
	// Position of TME2 field.
	CAN_TSR_TME2_Pos = 0x1c
	// Bit mask of TME2 field.
	CAN_TSR_TME2_Msk = 0x10000000
	// Bit TME2.
	CAN_TSR_TME2 = 0x10000000
	// Position of TME1 field.
	CAN_TSR_TME1_Pos = 0x1b
	// Bit mask of TME1 field.
	CAN_TSR_TME1_Msk = 0x8000000
	// Bit TME1.
	CAN_TSR_TME1 = 0x8000000
	// Position of TME0 field.
	CAN_TSR_TME0_Pos = 0x1a
	// Bit mask of TME0 field.
	CAN_TSR_TME0_Msk = 0x4000000
	// Bit TME0.
	CAN_TSR_TME0 = 0x4000000
	// Position of CODE field.
	CAN_TSR_CODE_Pos = 0x18
	// Bit mask of CODE field.
	CAN_TSR_CODE_Msk = 0x3000000
	// Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Pos = 0x17
	// Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000
	// Bit ABRQ2.
	CAN_TSR_ABRQ2 = 0x800000
	// Position of TERR2 field.
	CAN_TSR_TERR2_Pos = 0x13
	// Bit mask of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000
	// Bit TERR2.
	CAN_TSR_TERR2 = 0x80000
	// Position of ALST2 field.
	CAN_TSR_ALST2_Pos = 0x12
	// Bit mask of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000
	// Bit ALST2.
	CAN_TSR_ALST2 = 0x40000
	// Position of TXOK2 field.
	CAN_TSR_TXOK2_Pos = 0x11
	// Bit mask of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000
	// Bit TXOK2.
	CAN_TSR_TXOK2 = 0x20000
	// Position of RQCP2 field.
	CAN_TSR_RQCP2_Pos = 0x10
	// Bit mask of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000
	// Bit RQCP2.
	CAN_TSR_RQCP2 = 0x10000
	// Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Pos = 0xf
	// Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000
	// Bit ABRQ1.
	CAN_TSR_ABRQ1 = 0x8000
	// Position of TERR1 field.
	CAN_TSR_TERR1_Pos = 0xb
	// Bit mask of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800
	// Bit TERR1.
	CAN_TSR_TERR1 = 0x800
	// Position of ALST1 field.
	CAN_TSR_ALST1_Pos = 0xa
	// Bit mask of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400
	// Bit ALST1.
	CAN_TSR_ALST1 = 0x400
	// Position of TXOK1 field.
	CAN_TSR_TXOK1_Pos = 0x9
	// Bit mask of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200
	// Bit TXOK1.
	CAN_TSR_TXOK1 = 0x200
	// Position of RQCP1 field.
	CAN_TSR_RQCP1_Pos = 0x8
	// Bit mask of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100
	// Bit RQCP1.
	CAN_TSR_RQCP1 = 0x100
	// Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Pos = 0x7
	// Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80
	// Bit ABRQ0.
	CAN_TSR_ABRQ0 = 0x80
	// Position of TERR0 field.
	CAN_TSR_TERR0_Pos = 0x3
	// Bit mask of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8
	// Bit TERR0.
	CAN_TSR_TERR0 = 0x8
	// Position of ALST0 field.
	CAN_TSR_ALST0_Pos = 0x2
	// Bit mask of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4
	// Bit ALST0.
	CAN_TSR_ALST0 = 0x4
	// Position of TXOK0 field.
	CAN_TSR_TXOK0_Pos = 0x1
	// Bit mask of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2
	// Bit TXOK0.
	CAN_TSR_TXOK0 = 0x2
	// Position of RQCP0 field.
	CAN_TSR_RQCP0_Pos = 0x0
	// Bit mask of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1
	// Bit RQCP0.
	CAN_TSR_RQCP0 = 0x1

	// RF0R: receive FIFO 0 register
	// Position of RFOM field.
	CAN_RFR_RFOM_Pos = 0x5
	// Bit mask of RFOM field.
	CAN_RFR_RFOM_Msk = 0x20
	// Bit RFOM.
	CAN_RFR_RFOM = 0x20
	// Set by software to release the output mailbox of the FIFO
	CAN_RFR_RFOM_Release = 0x1
	// Position of FOVR field.
	CAN_RFR_FOVR_Pos = 0x4
	// Bit mask of FOVR field.
	CAN_RFR_FOVR_Msk = 0x10
	// Bit FOVR.
	CAN_RFR_FOVR = 0x10
	// No FIFO x overrun
	CAN_RFR_FOVR_NoOverrun = 0x0
	// FIFO x overrun
	CAN_RFR_FOVR_Overrun = 0x1
	// Clear flag
	CAN_RFR_FOVR_Clear = 0x1
	// Position of FULL field.
	CAN_RFR_FULL_Pos = 0x3
	// Bit mask of FULL field.
	CAN_RFR_FULL_Msk = 0x8
	// Bit FULL.
	CAN_RFR_FULL = 0x8
	// FIFO x is not full
	CAN_RFR_FULL_NotFull = 0x0
	// FIFO x is full
	CAN_RFR_FULL_Full = 0x1
	// Clear flag
	CAN_RFR_FULL_Clear = 0x1
	// Position of FMP field.
	CAN_RFR_FMP_Pos = 0x0
	// Bit mask of FMP field.
	CAN_RFR_FMP_Msk = 0x3

	// IER: interrupt enable register
	// Position of SLKIE field.
	CAN_IER_SLKIE_Pos = 0x11
	// Bit mask of SLKIE field.
	CAN_IER_SLKIE_Msk = 0x20000
	// Bit SLKIE.
	CAN_IER_SLKIE = 0x20000
	// No interrupt when SLAKI bit is set
	CAN_IER_SLKIE_Disabled = 0x0
	// Interrupt generated when SLAKI bit is set
	CAN_IER_SLKIE_Enabled = 0x1
	// Position of WKUIE field.
	CAN_IER_WKUIE_Pos = 0x10
	// Bit mask of WKUIE field.
	CAN_IER_WKUIE_Msk = 0x10000
	// Bit WKUIE.
	CAN_IER_WKUIE = 0x10000
	// No interrupt when WKUI is set
	CAN_IER_WKUIE_Disabled = 0x0
	// Interrupt generated when WKUI bit is set
	CAN_IER_WKUIE_Enabled = 0x1
	// Position of ERRIE field.
	CAN_IER_ERRIE_Pos = 0xf
	// Bit mask of ERRIE field.
	CAN_IER_ERRIE_Msk = 0x8000
	// Bit ERRIE.
	CAN_IER_ERRIE = 0x8000
	// No interrupt will be generated when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Disabled = 0x0
	// An interrupt will be generation when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Enabled = 0x1
	// Position of LECIE field.
	CAN_IER_LECIE_Pos = 0xb
	// Bit mask of LECIE field.
	CAN_IER_LECIE_Msk = 0x800
	// Bit LECIE.
	CAN_IER_LECIE = 0x800
	// ERRI bit will not be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Disabled = 0x0
	// ERRI bit will be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Enabled = 0x1
	// Position of BOFIE field.
	CAN_IER_BOFIE_Pos = 0xa
	// Bit mask of BOFIE field.
	CAN_IER_BOFIE_Msk = 0x400
	// Bit BOFIE.
	CAN_IER_BOFIE = 0x400
	// ERRI bit will not be set when BOFF is set
	CAN_IER_BOFIE_Disabled = 0x0
	// ERRI bit will be set when BOFF is set
	CAN_IER_BOFIE_Enabled = 0x1
	// Position of EPVIE field.
	CAN_IER_EPVIE_Pos = 0x9
	// Bit mask of EPVIE field.
	CAN_IER_EPVIE_Msk = 0x200
	// Bit EPVIE.
	CAN_IER_EPVIE = 0x200
	// ERRI bit will not be set when EPVF is set
	CAN_IER_EPVIE_Disabled = 0x0
	// ERRI bit will be set when EPVF is set
	CAN_IER_EPVIE_Enabled = 0x1
	// Position of EWGIE field.
	CAN_IER_EWGIE_Pos = 0x8
	// Bit mask of EWGIE field.
	CAN_IER_EWGIE_Msk = 0x100
	// Bit EWGIE.
	CAN_IER_EWGIE = 0x100
	// ERRI bit will not be set when EWGF is set
	CAN_IER_EWGIE_Disabled = 0x0
	// ERRI bit will be set when EWGF is set
	CAN_IER_EWGIE_Enabled = 0x1
	// Position of FOVIE1 field.
	CAN_IER_FOVIE1_Pos = 0x6
	// Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40
	// Bit FOVIE1.
	CAN_IER_FOVIE1 = 0x40
	// No interrupt when FOVR is set
	CAN_IER_FOVIE1_Disabled = 0x0
	// Interrupt generation when FOVR is set
	CAN_IER_FOVIE1_Enabled = 0x1
	// Position of FFIE1 field.
	CAN_IER_FFIE1_Pos = 0x5
	// Bit mask of FFIE1 field.
	CAN_IER_FFIE1_Msk = 0x20
	// Bit FFIE1.
	CAN_IER_FFIE1 = 0x20
	// No interrupt when FULL bit is set
	CAN_IER_FFIE1_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE1_Enabled = 0x1
	// Position of FMPIE1 field.
	CAN_IER_FMPIE1_Pos = 0x4
	// Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10
	// Bit FMPIE1.
	CAN_IER_FMPIE1 = 0x10
	// No interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Enabled = 0x1
	// Position of FOVIE0 field.
	CAN_IER_FOVIE0_Pos = 0x3
	// Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8
	// Bit FOVIE0.
	CAN_IER_FOVIE0 = 0x8
	// No interrupt when FOVR bit is set
	CAN_IER_FOVIE0_Disabled = 0x0
	// Interrupt generated when FOVR bit is set
	CAN_IER_FOVIE0_Enabled = 0x1
	// Position of FFIE0 field.
	CAN_IER_FFIE0_Pos = 0x2
	// Bit mask of FFIE0 field.
	CAN_IER_FFIE0_Msk = 0x4
	// Bit FFIE0.
	CAN_IER_FFIE0 = 0x4
	// No interrupt when FULL bit is set
	CAN_IER_FFIE0_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE0_Enabled = 0x1
	// Position of FMPIE0 field.
	CAN_IER_FMPIE0_Pos = 0x1
	// Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2
	// Bit FMPIE0.
	CAN_IER_FMPIE0 = 0x2
	// No interrupt generated when state of FMP[1:0] bits are not 00
	CAN_IER_FMPIE0_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE0_Enabled = 0x1
	// Position of TMEIE field.
	CAN_IER_TMEIE_Pos = 0x0
	// Bit mask of TMEIE field.
	CAN_IER_TMEIE_Msk = 0x1
	// Bit TMEIE.
	CAN_IER_TMEIE = 0x1
	// No interrupt when RQCPx bit is set
	CAN_IER_TMEIE_Disabled = 0x0
	// Interrupt generated when RQCPx bit is set
	CAN_IER_TMEIE_Enabled = 0x1

	// ESR: interrupt enable register
	// Position of REC field.
	CAN_ESR_REC_Pos = 0x18
	// Bit mask of REC field.
	CAN_ESR_REC_Msk = 0xff000000
	// Position of TEC field.
	CAN_ESR_TEC_Pos = 0x10
	// Bit mask of TEC field.
	CAN_ESR_TEC_Msk = 0xff0000
	// Position of LEC field.
	CAN_ESR_LEC_Pos = 0x4
	// Bit mask of LEC field.
	CAN_ESR_LEC_Msk = 0x70
	// No Error
	CAN_ESR_LEC_NoError = 0x0
	// Stuff Error
	CAN_ESR_LEC_Stuff = 0x1
	// Form Error
	CAN_ESR_LEC_Form = 0x2
	// Acknowledgment Error
	CAN_ESR_LEC_Ack = 0x3
	// Bit recessive Error
	CAN_ESR_LEC_BitRecessive = 0x4
	// Bit dominant Error
	CAN_ESR_LEC_BitDominant = 0x5
	// CRC Error
	CAN_ESR_LEC_Crc = 0x6
	// Set by software
	CAN_ESR_LEC_Custom = 0x7
	// Position of BOFF field.
	CAN_ESR_BOFF_Pos = 0x2
	// Bit mask of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4
	// Bit BOFF.
	CAN_ESR_BOFF = 0x4
	// Position of EPVF field.
	CAN_ESR_EPVF_Pos = 0x1
	// Bit mask of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2
	// Bit EPVF.
	CAN_ESR_EPVF = 0x2
	// Position of EWGF field.
	CAN_ESR_EWGF_Pos = 0x0
	// Bit mask of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1
	// Bit EWGF.
	CAN_ESR_EWGF = 0x1

	// BTR: bit timing register
	// Position of SILM field.
	CAN_BTR_SILM_Pos = 0x1f
	// Bit mask of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000
	// Bit SILM.
	CAN_BTR_SILM = 0x80000000
	// Normal operation
	CAN_BTR_SILM_Normal = 0x0
	// Silent Mode
	CAN_BTR_SILM_Silent = 0x1
	// Position of LBKM field.
	CAN_BTR_LBKM_Pos = 0x1e
	// Bit mask of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000
	// Bit LBKM.
	CAN_BTR_LBKM = 0x40000000
	// Loop Back Mode disabled
	CAN_BTR_LBKM_Disabled = 0x0
	// Loop Back Mode enabled
	CAN_BTR_LBKM_Enabled = 0x1
	// Position of SJW field.
	CAN_BTR_SJW_Pos = 0x18
	// Bit mask of SJW field.
	CAN_BTR_SJW_Msk = 0x3000000
	// Position of TS2 field.
	CAN_BTR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	CAN_BTR_TS2_Msk = 0x700000
	// Position of TS1 field.
	CAN_BTR_TS1_Pos = 0x10
	// Bit mask of TS1 field.
	CAN_BTR_TS1_Msk = 0xf0000
	// Position of BRP field.
	CAN_BTR_BRP_Pos = 0x0
	// Bit mask of BRP field.
	CAN_BTR_BRP_Msk = 0x3ff

	// TX.TIR: TX mailbox identifier register
	// Position of STID field.
	CAN_TX_TIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_TX_TIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_TX_TIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_TX_TIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_TX_TIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_TX_TIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_TX_TIR_IDE = 0x4
	// Standard identifier
	CAN_TX_TIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_TX_TIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_TX_TIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_TX_TIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_TX_TIR_RTR = 0x2
	// Data frame
	CAN_TX_TIR_RTR_Data = 0x0
	// Remote frame
	CAN_TX_TIR_RTR_Remote = 0x1
	// Position of TXRQ field.
	CAN_TX_TIR_TXRQ_Pos = 0x0
	// Bit mask of TXRQ field.
	CAN_TX_TIR_TXRQ_Msk = 0x1
	// Bit TXRQ.
	CAN_TX_TIR_TXRQ = 0x1

	// TX.TDTR: mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_TX_TDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_TX_TDTR_TIME_Msk = 0xffff0000
	// Position of TGT field.
	CAN_TX_TDTR_TGT_Pos = 0x8
	// Bit mask of TGT field.
	CAN_TX_TDTR_TGT_Msk = 0x100
	// Bit TGT.
	CAN_TX_TDTR_TGT = 0x100
	// Position of DLC field.
	CAN_TX_TDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_TX_TDTR_DLC_Msk = 0xf

	// TX.TDLR: mailbox data low register
	// Position of DATA3 field.
	CAN_TX_TDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_TX_TDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_TX_TDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_TX_TDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_TX_TDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_TX_TDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_TX_TDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_TX_TDLR_DATA0_Msk = 0xff

	// TX.TDHR: mailbox data high register
	// Position of DATA7 field.
	CAN_TX_TDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_TX_TDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_TX_TDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_TX_TDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_TX_TDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_TX_TDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_TX_TDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_TX_TDHR_DATA4_Msk = 0xff

	// RX.RIR: receive FIFO mailbox identifier register
	// Position of STID field.
	CAN_RX_RIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_RX_RIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_RX_RIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_RX_RIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_RX_RIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_RX_RIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_RX_RIR_IDE = 0x4
	// Standard identifier
	CAN_RX_RIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_RX_RIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_RX_RIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_RX_RIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_RX_RIR_RTR = 0x2
	// Data frame
	CAN_RX_RIR_RTR_Data = 0x0
	// Remote frame
	CAN_RX_RIR_RTR_Remote = 0x1

	// RX.RDTR: mailbox data high register
	// Position of TIME field.
	CAN_RX_RDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_RX_RDTR_TIME_Msk = 0xffff0000
	// Position of FMI field.
	CAN_RX_RDTR_FMI_Pos = 0x8
	// Bit mask of FMI field.
	CAN_RX_RDTR_FMI_Msk = 0xff00
	// Position of DLC field.
	CAN_RX_RDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_RX_RDTR_DLC_Msk = 0xf

	// RX.RDLR: mailbox data high register
	// Position of DATA3 field.
	CAN_RX_RDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_RX_RDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_RX_RDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_RX_RDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_RX_RDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_RX_RDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_RX_RDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_RX_RDLR_DATA0_Msk = 0xff

	// RX.RDHR: receive FIFO mailbox data high register
	// Position of DATA7 field.
	CAN_RX_RDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_RX_RDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_RX_RDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_RX_RDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_RX_RDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_RX_RDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_RX_RDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_RX_RDHR_DATA4_Msk = 0xff

	// FB.FR1: Filter bank 0 register 1
	// Position of FB field.
	CAN_FB_FR1_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR1_FB_Msk = 0xffffffff

	// FB.FR2: Filter bank 0 register 2
	// Position of FB field.
	CAN_FB_FR2_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR2_FB_Msk = 0xffffffff
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: control register
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Position of ITSE field.
	RTC_CR_ITSE_Pos = 0x18
	// Bit mask of ITSE field.
	RTC_CR_ITSE_Msk = 0x1000000
	// Bit ITSE.
	RTC_CR_ITSE = 0x1000000

	// ISR: initialization and status register
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Position of SHPF field.
	RTC_ISR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ISR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ISR_SHPF = 0x8
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// Position of TAMP2F field.
	RTC_ISR_TAMP2F_Pos = 0xe
	// Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000
	// Bit TAMP2F.
	RTC_ISR_TAMP2F = 0x4000
	// Position of TAMP3F field.
	RTC_ISR_TAMP3F_Pos = 0xf
	// Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F_Msk = 0x8000
	// Bit TAMP3F.
	RTC_ISR_TAMP3F = 0x8000
	// Position of RECALPF field.
	RTC_ISR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ISR_RECALPF = 0x10000

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// SSR: sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// SHIFTR: shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: time stamp time register
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: timestamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// CALR: calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// TAMPCR: tamper configuration register
	// Position of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAMPCR_TAMP1E = 0x1
	// Position of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TAMPCR_TAMP1TRG = 0x2
	// Position of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAMPCR_TAMPIE = 0x4
	// Position of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Pos = 0x3
	// Bit mask of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Msk = 0x8
	// Bit TAMP2E.
	RTC_TAMPCR_TAMP2E = 0x8
	// Position of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Pos = 0x4
	// Bit mask of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Msk = 0x10
	// Bit TAMP2TRG.
	RTC_TAMPCR_TAMP2TRG = 0x10
	// Position of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Pos = 0x5
	// Bit mask of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Msk = 0x20
	// Bit TAMP3E.
	RTC_TAMPCR_TAMP3E = 0x20
	// Position of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Pos = 0x6
	// Bit mask of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Msk = 0x40
	// Bit TAMP3TRG.
	RTC_TAMPCR_TAMP3TRG = 0x40
	// Position of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Pos = 0x7
	// Bit mask of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Msk = 0x80
	// Bit TAMPTS.
	RTC_TAMPCR_TAMPTS = 0x80
	// Position of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Pos = 0x8
	// Bit mask of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Msk = 0x700
	// Position of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Pos = 0xb
	// Bit mask of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Msk = 0x1800
	// Position of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Pos = 0xd
	// Bit mask of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Msk = 0x6000
	// Position of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Pos = 0xf
	// Bit mask of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Msk = 0x8000
	// Bit TAMPPUDIS.
	RTC_TAMPCR_TAMPPUDIS = 0x8000
	// Position of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Pos = 0x10
	// Bit mask of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Msk = 0x10000
	// Bit TAMP1IE.
	RTC_TAMPCR_TAMP1IE = 0x10000
	// Position of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Pos = 0x11
	// Bit mask of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Msk = 0x20000
	// Bit TAMP1NOERASE.
	RTC_TAMPCR_TAMP1NOERASE = 0x20000
	// Position of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Pos = 0x12
	// Bit mask of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Msk = 0x40000
	// Bit TAMP1MF.
	RTC_TAMPCR_TAMP1MF = 0x40000
	// Position of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Pos = 0x13
	// Bit mask of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Msk = 0x80000
	// Bit TAMP2IE.
	RTC_TAMPCR_TAMP2IE = 0x80000
	// Position of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Pos = 0x14
	// Bit mask of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Msk = 0x100000
	// Bit TAMP2NOERASE.
	RTC_TAMPCR_TAMP2NOERASE = 0x100000
	// Position of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Pos = 0x15
	// Bit mask of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Msk = 0x200000
	// Bit TAMP2MF.
	RTC_TAMPCR_TAMP2MF = 0x200000
	// Position of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Pos = 0x16
	// Bit mask of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Msk = 0x400000
	// Bit TAMP3IE.
	RTC_TAMPCR_TAMP3IE = 0x400000
	// Position of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Pos = 0x17
	// Bit mask of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Msk = 0x800000
	// Bit TAMP3NOERASE.
	RTC_TAMPCR_TAMP3NOERASE = 0x800000
	// Position of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Pos = 0x18
	// Bit mask of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Msk = 0x1000000
	// Bit TAMP3MF.
	RTC_TAMPCR_TAMP3MF = 0x1000000

	// ALRMASSR: alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBSSR: alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// OR: option register
	// Position of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Pos = 0x0
	// Bit mask of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Msk = 0x1
	// Bit RTC_ALARM_TYPE.
	RTC_OR_RTC_ALARM_TYPE = 0x1
	// Position of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Pos = 0x1
	// Bit mask of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Msk = 0x2
	// Bit RTC_OUT_RMP.
	RTC_OR_RTC_OUT_RMP = 0x2

	// BKP0R: backup register
	// Position of BKP field.
	RTC_BKPR_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKPR_BKP_Msk = 0xffffffff
)

// Bitfields for SWPMI1: Single Wire Protocol Master Interface
const (
	// CR: SWPMI Configuration/Control register
	// Position of RXDMA field.
	SWPMI_CR_RXDMA_Pos = 0x0
	// Bit mask of RXDMA field.
	SWPMI_CR_RXDMA_Msk = 0x1
	// Bit RXDMA.
	SWPMI_CR_RXDMA = 0x1
	// Position of TXDMA field.
	SWPMI_CR_TXDMA_Pos = 0x1
	// Bit mask of TXDMA field.
	SWPMI_CR_TXDMA_Msk = 0x2
	// Bit TXDMA.
	SWPMI_CR_TXDMA = 0x2
	// Position of RXMODE field.
	SWPMI_CR_RXMODE_Pos = 0x2
	// Bit mask of RXMODE field.
	SWPMI_CR_RXMODE_Msk = 0x4
	// Bit RXMODE.
	SWPMI_CR_RXMODE = 0x4
	// Position of TXMODE field.
	SWPMI_CR_TXMODE_Pos = 0x3
	// Bit mask of TXMODE field.
	SWPMI_CR_TXMODE_Msk = 0x8
	// Bit TXMODE.
	SWPMI_CR_TXMODE = 0x8
	// Position of LPBK field.
	SWPMI_CR_LPBK_Pos = 0x4
	// Bit mask of LPBK field.
	SWPMI_CR_LPBK_Msk = 0x10
	// Bit LPBK.
	SWPMI_CR_LPBK = 0x10
	// Position of SWPME field.
	SWPMI_CR_SWPME_Pos = 0x5
	// Bit mask of SWPME field.
	SWPMI_CR_SWPME_Msk = 0x20
	// Bit SWPME.
	SWPMI_CR_SWPME = 0x20
	// Position of DEACT field.
	SWPMI_CR_DEACT_Pos = 0xa
	// Bit mask of DEACT field.
	SWPMI_CR_DEACT_Msk = 0x400
	// Bit DEACT.
	SWPMI_CR_DEACT = 0x400

	// BRR: SWPMI Bitrate register
	// Position of BR field.
	SWPMI_BRR_BR_Pos = 0x0
	// Bit mask of BR field.
	SWPMI_BRR_BR_Msk = 0x3f

	// ISR: SWPMI Interrupt and Status register
	// Position of RXBFF field.
	SWPMI_ISR_RXBFF_Pos = 0x0
	// Bit mask of RXBFF field.
	SWPMI_ISR_RXBFF_Msk = 0x1
	// Bit RXBFF.
	SWPMI_ISR_RXBFF = 0x1
	// Position of TXBEF field.
	SWPMI_ISR_TXBEF_Pos = 0x1
	// Bit mask of TXBEF field.
	SWPMI_ISR_TXBEF_Msk = 0x2
	// Bit TXBEF.
	SWPMI_ISR_TXBEF = 0x2
	// Position of RXBERF field.
	SWPMI_ISR_RXBERF_Pos = 0x2
	// Bit mask of RXBERF field.
	SWPMI_ISR_RXBERF_Msk = 0x4
	// Bit RXBERF.
	SWPMI_ISR_RXBERF = 0x4
	// Position of RXOVRF field.
	SWPMI_ISR_RXOVRF_Pos = 0x3
	// Bit mask of RXOVRF field.
	SWPMI_ISR_RXOVRF_Msk = 0x8
	// Bit RXOVRF.
	SWPMI_ISR_RXOVRF = 0x8
	// Position of TXUNRF field.
	SWPMI_ISR_TXUNRF_Pos = 0x4
	// Bit mask of TXUNRF field.
	SWPMI_ISR_TXUNRF_Msk = 0x10
	// Bit TXUNRF.
	SWPMI_ISR_TXUNRF = 0x10
	// Position of RXNE field.
	SWPMI_ISR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	SWPMI_ISR_RXNE_Msk = 0x20
	// Bit RXNE.
	SWPMI_ISR_RXNE = 0x20
	// Position of TXE field.
	SWPMI_ISR_TXE_Pos = 0x6
	// Bit mask of TXE field.
	SWPMI_ISR_TXE_Msk = 0x40
	// Bit TXE.
	SWPMI_ISR_TXE = 0x40
	// Position of TCF field.
	SWPMI_ISR_TCF_Pos = 0x7
	// Bit mask of TCF field.
	SWPMI_ISR_TCF_Msk = 0x80
	// Bit TCF.
	SWPMI_ISR_TCF = 0x80
	// Position of SRF field.
	SWPMI_ISR_SRF_Pos = 0x8
	// Bit mask of SRF field.
	SWPMI_ISR_SRF_Msk = 0x100
	// Bit SRF.
	SWPMI_ISR_SRF = 0x100
	// Position of SUSP field.
	SWPMI_ISR_SUSP_Pos = 0x9
	// Bit mask of SUSP field.
	SWPMI_ISR_SUSP_Msk = 0x200
	// Bit SUSP.
	SWPMI_ISR_SUSP = 0x200
	// Position of DEACTF field.
	SWPMI_ISR_DEACTF_Pos = 0xa
	// Bit mask of DEACTF field.
	SWPMI_ISR_DEACTF_Msk = 0x400
	// Bit DEACTF.
	SWPMI_ISR_DEACTF = 0x400

	// ICR: SWPMI Interrupt Flag Clear register
	// Position of CRXBFF field.
	SWPMI_ICR_CRXBFF_Pos = 0x0
	// Bit mask of CRXBFF field.
	SWPMI_ICR_CRXBFF_Msk = 0x1
	// Bit CRXBFF.
	SWPMI_ICR_CRXBFF = 0x1
	// Position of CTXBEF field.
	SWPMI_ICR_CTXBEF_Pos = 0x1
	// Bit mask of CTXBEF field.
	SWPMI_ICR_CTXBEF_Msk = 0x2
	// Bit CTXBEF.
	SWPMI_ICR_CTXBEF = 0x2
	// Position of CRXBERF field.
	SWPMI_ICR_CRXBERF_Pos = 0x2
	// Bit mask of CRXBERF field.
	SWPMI_ICR_CRXBERF_Msk = 0x4
	// Bit CRXBERF.
	SWPMI_ICR_CRXBERF = 0x4
	// Position of CRXOVRF field.
	SWPMI_ICR_CRXOVRF_Pos = 0x3
	// Bit mask of CRXOVRF field.
	SWPMI_ICR_CRXOVRF_Msk = 0x8
	// Bit CRXOVRF.
	SWPMI_ICR_CRXOVRF = 0x8
	// Position of CTXUNRF field.
	SWPMI_ICR_CTXUNRF_Pos = 0x4
	// Bit mask of CTXUNRF field.
	SWPMI_ICR_CTXUNRF_Msk = 0x10
	// Bit CTXUNRF.
	SWPMI_ICR_CTXUNRF = 0x10
	// Position of CTCF field.
	SWPMI_ICR_CTCF_Pos = 0x7
	// Bit mask of CTCF field.
	SWPMI_ICR_CTCF_Msk = 0x80
	// Bit CTCF.
	SWPMI_ICR_CTCF = 0x80
	// Position of CSRF field.
	SWPMI_ICR_CSRF_Pos = 0x8
	// Bit mask of CSRF field.
	SWPMI_ICR_CSRF_Msk = 0x100
	// Bit CSRF.
	SWPMI_ICR_CSRF = 0x100

	// IER: SWPMI Interrupt Enable register
	// Position of RXBFIE field.
	SWPMI_IER_RXBFIE_Pos = 0x0
	// Bit mask of RXBFIE field.
	SWPMI_IER_RXBFIE_Msk = 0x1
	// Bit RXBFIE.
	SWPMI_IER_RXBFIE = 0x1
	// Position of TXBEIE field.
	SWPMI_IER_TXBEIE_Pos = 0x1
	// Bit mask of TXBEIE field.
	SWPMI_IER_TXBEIE_Msk = 0x2
	// Bit TXBEIE.
	SWPMI_IER_TXBEIE = 0x2
	// Position of RXBERIE field.
	SWPMI_IER_RXBERIE_Pos = 0x2
	// Bit mask of RXBERIE field.
	SWPMI_IER_RXBERIE_Msk = 0x4
	// Bit RXBERIE.
	SWPMI_IER_RXBERIE = 0x4
	// Position of RXOVRIE field.
	SWPMI_IER_RXOVRIE_Pos = 0x3
	// Bit mask of RXOVRIE field.
	SWPMI_IER_RXOVRIE_Msk = 0x8
	// Bit RXOVRIE.
	SWPMI_IER_RXOVRIE = 0x8
	// Position of TXUNRIE field.
	SWPMI_IER_TXUNRIE_Pos = 0x4
	// Bit mask of TXUNRIE field.
	SWPMI_IER_TXUNRIE_Msk = 0x10
	// Bit TXUNRIE.
	SWPMI_IER_TXUNRIE = 0x10
	// Position of RIE field.
	SWPMI_IER_RIE_Pos = 0x5
	// Bit mask of RIE field.
	SWPMI_IER_RIE_Msk = 0x20
	// Bit RIE.
	SWPMI_IER_RIE = 0x20
	// Position of TIE field.
	SWPMI_IER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	SWPMI_IER_TIE_Msk = 0x40
	// Bit TIE.
	SWPMI_IER_TIE = 0x40
	// Position of TCIE field.
	SWPMI_IER_TCIE_Pos = 0x7
	// Bit mask of TCIE field.
	SWPMI_IER_TCIE_Msk = 0x80
	// Bit TCIE.
	SWPMI_IER_TCIE = 0x80
	// Position of SRIE field.
	SWPMI_IER_SRIE_Pos = 0x8
	// Bit mask of SRIE field.
	SWPMI_IER_SRIE_Msk = 0x100
	// Bit SRIE.
	SWPMI_IER_SRIE = 0x100

	// RFL: SWPMI Receive Frame Length register
	// Position of RFL field.
	SWPMI_RFL_RFL_Pos = 0x0
	// Bit mask of RFL field.
	SWPMI_RFL_RFL_Msk = 0x1f

	// TDR: SWPMI Transmit data register
	// Position of TD field.
	SWPMI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SWPMI_TDR_TD_Msk = 0xffffffff

	// RDR: SWPMI Receive data register
	// Position of RD field.
	SWPMI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SWPMI_RDR_RD_Msk = 0xffffffff

	// OR: SWPMI Option register
	// Position of SWP_TBYP field.
	SWPMI_OR_SWP_TBYP_Pos = 0x0
	// Bit mask of SWP_TBYP field.
	SWPMI_OR_SWP_TBYP_Msk = 0x1
	// Bit SWP_TBYP.
	SWPMI_OR_SWP_TBYP = 0x1
	// Position of SWP_CLASS field.
	SWPMI_OR_SWP_CLASS_Pos = 0x1
	// Bit mask of SWP_CLASS field.
	SWPMI_OR_SWP_CLASS_Msk = 0x2
	// Bit SWP_CLASS.
	SWPMI_OR_SWP_CLASS = 0x2
)

// Bitfields for OPAMP: Operational amplifiers
const (
	// OPAMP1_CSR: OPAMP1 control/status register
	// Position of OPAEN field.
	OPAMP_OPAMP1_CSR_OPAEN_Pos = 0x0
	// Bit mask of OPAEN field.
	OPAMP_OPAMP1_CSR_OPAEN_Msk = 0x1
	// Bit OPAEN.
	OPAMP_OPAMP1_CSR_OPAEN = 0x1
	// Position of OPALPM field.
	OPAMP_OPAMP1_CSR_OPALPM_Pos = 0x1
	// Bit mask of OPALPM field.
	OPAMP_OPAMP1_CSR_OPALPM_Msk = 0x2
	// Bit OPALPM.
	OPAMP_OPAMP1_CSR_OPALPM = 0x2
	// Position of OPAMODE field.
	OPAMP_OPAMP1_CSR_OPAMODE_Pos = 0x2
	// Bit mask of OPAMODE field.
	OPAMP_OPAMP1_CSR_OPAMODE_Msk = 0xc
	// Position of PGA_GAIN field.
	OPAMP_OPAMP1_CSR_PGA_GAIN_Pos = 0x4
	// Bit mask of PGA_GAIN field.
	OPAMP_OPAMP1_CSR_PGA_GAIN_Msk = 0x30
	// Position of VM_SEL field.
	OPAMP_OPAMP1_CSR_VM_SEL_Pos = 0x8
	// Bit mask of VM_SEL field.
	OPAMP_OPAMP1_CSR_VM_SEL_Msk = 0x300
	// Position of VP_SEL field.
	OPAMP_OPAMP1_CSR_VP_SEL_Pos = 0xa
	// Bit mask of VP_SEL field.
	OPAMP_OPAMP1_CSR_VP_SEL_Msk = 0x400
	// Bit VP_SEL.
	OPAMP_OPAMP1_CSR_VP_SEL = 0x400
	// Position of CALON field.
	OPAMP_OPAMP1_CSR_CALON_Pos = 0xc
	// Bit mask of CALON field.
	OPAMP_OPAMP1_CSR_CALON_Msk = 0x1000
	// Bit CALON.
	OPAMP_OPAMP1_CSR_CALON = 0x1000
	// Position of CALSEL field.
	OPAMP_OPAMP1_CSR_CALSEL_Pos = 0xd
	// Bit mask of CALSEL field.
	OPAMP_OPAMP1_CSR_CALSEL_Msk = 0x2000
	// Bit CALSEL.
	OPAMP_OPAMP1_CSR_CALSEL = 0x2000
	// Position of USERTRIM field.
	OPAMP_OPAMP1_CSR_USERTRIM_Pos = 0xe
	// Bit mask of USERTRIM field.
	OPAMP_OPAMP1_CSR_USERTRIM_Msk = 0x4000
	// Bit USERTRIM.
	OPAMP_OPAMP1_CSR_USERTRIM = 0x4000
	// Position of CALOUT field.
	OPAMP_OPAMP1_CSR_CALOUT_Pos = 0xf
	// Bit mask of CALOUT field.
	OPAMP_OPAMP1_CSR_CALOUT_Msk = 0x8000
	// Bit CALOUT.
	OPAMP_OPAMP1_CSR_CALOUT = 0x8000
	// Position of OPA_RANGE field.
	OPAMP_OPAMP1_CSR_OPA_RANGE_Pos = 0x1f
	// Bit mask of OPA_RANGE field.
	OPAMP_OPAMP1_CSR_OPA_RANGE_Msk = 0x80000000
	// Bit OPA_RANGE.
	OPAMP_OPAMP1_CSR_OPA_RANGE = 0x80000000

	// OPAMP1_OTR: OPAMP1 offset trimming register in normal mode
	// Position of TRIMOFFSETN field.
	OPAMP_OPAMP1_OTR_TRIMOFFSETN_Pos = 0x0
	// Bit mask of TRIMOFFSETN field.
	OPAMP_OPAMP1_OTR_TRIMOFFSETN_Msk = 0x1f
	// Position of TRIMOFFSETP field.
	OPAMP_OPAMP1_OTR_TRIMOFFSETP_Pos = 0x8
	// Bit mask of TRIMOFFSETP field.
	OPAMP_OPAMP1_OTR_TRIMOFFSETP_Msk = 0x1f00

	// OPAMP1_LPOTR: OPAMP1 offset trimming register in low-power mode
	// Position of TRIMLPOFFSETN field.
	OPAMP_OPAMP1_LPOTR_TRIMLPOFFSETN_Pos = 0x0
	// Bit mask of TRIMLPOFFSETN field.
	OPAMP_OPAMP1_LPOTR_TRIMLPOFFSETN_Msk = 0x1f
	// Position of TRIMLPOFFSETP field.
	OPAMP_OPAMP1_LPOTR_TRIMLPOFFSETP_Pos = 0x8
	// Bit mask of TRIMLPOFFSETP field.
	OPAMP_OPAMP1_LPOTR_TRIMLPOFFSETP_Msk = 0x1f00

	// OPAMP2_CSR: OPAMP2 control/status register
	// Position of OPAEN field.
	OPAMP_OPAMP2_CSR_OPAEN_Pos = 0x0
	// Bit mask of OPAEN field.
	OPAMP_OPAMP2_CSR_OPAEN_Msk = 0x1
	// Bit OPAEN.
	OPAMP_OPAMP2_CSR_OPAEN = 0x1
	// Position of OPALPM field.
	OPAMP_OPAMP2_CSR_OPALPM_Pos = 0x1
	// Bit mask of OPALPM field.
	OPAMP_OPAMP2_CSR_OPALPM_Msk = 0x2
	// Bit OPALPM.
	OPAMP_OPAMP2_CSR_OPALPM = 0x2
	// Position of OPAMODE field.
	OPAMP_OPAMP2_CSR_OPAMODE_Pos = 0x2
	// Bit mask of OPAMODE field.
	OPAMP_OPAMP2_CSR_OPAMODE_Msk = 0xc
	// Position of PGA_GAIN field.
	OPAMP_OPAMP2_CSR_PGA_GAIN_Pos = 0x4
	// Bit mask of PGA_GAIN field.
	OPAMP_OPAMP2_CSR_PGA_GAIN_Msk = 0x30
	// Position of VM_SEL field.
	OPAMP_OPAMP2_CSR_VM_SEL_Pos = 0x8
	// Bit mask of VM_SEL field.
	OPAMP_OPAMP2_CSR_VM_SEL_Msk = 0x300
	// Position of VP_SEL field.
	OPAMP_OPAMP2_CSR_VP_SEL_Pos = 0xa
	// Bit mask of VP_SEL field.
	OPAMP_OPAMP2_CSR_VP_SEL_Msk = 0x400
	// Bit VP_SEL.
	OPAMP_OPAMP2_CSR_VP_SEL = 0x400
	// Position of CALON field.
	OPAMP_OPAMP2_CSR_CALON_Pos = 0xc
	// Bit mask of CALON field.
	OPAMP_OPAMP2_CSR_CALON_Msk = 0x1000
	// Bit CALON.
	OPAMP_OPAMP2_CSR_CALON = 0x1000
	// Position of CALSEL field.
	OPAMP_OPAMP2_CSR_CALSEL_Pos = 0xd
	// Bit mask of CALSEL field.
	OPAMP_OPAMP2_CSR_CALSEL_Msk = 0x2000
	// Bit CALSEL.
	OPAMP_OPAMP2_CSR_CALSEL = 0x2000
	// Position of USERTRIM field.
	OPAMP_OPAMP2_CSR_USERTRIM_Pos = 0xe
	// Bit mask of USERTRIM field.
	OPAMP_OPAMP2_CSR_USERTRIM_Msk = 0x4000
	// Bit USERTRIM.
	OPAMP_OPAMP2_CSR_USERTRIM = 0x4000
	// Position of CALOUT field.
	OPAMP_OPAMP2_CSR_CALOUT_Pos = 0xf
	// Bit mask of CALOUT field.
	OPAMP_OPAMP2_CSR_CALOUT_Msk = 0x8000
	// Bit CALOUT.
	OPAMP_OPAMP2_CSR_CALOUT = 0x8000

	// OPAMP2_OTR: OPAMP2 offset trimming register in normal mode
	// Position of TRIMOFFSETN field.
	OPAMP_OPAMP2_OTR_TRIMOFFSETN_Pos = 0x0
	// Bit mask of TRIMOFFSETN field.
	OPAMP_OPAMP2_OTR_TRIMOFFSETN_Msk = 0x1f
	// Position of TRIMOFFSETP field.
	OPAMP_OPAMP2_OTR_TRIMOFFSETP_Pos = 0x8
	// Bit mask of TRIMOFFSETP field.
	OPAMP_OPAMP2_OTR_TRIMOFFSETP_Msk = 0x1f00

	// OPAMP2_LPOTR: OPAMP2 offset trimming register in low-power mode
	// Position of TRIMLPOFFSETN field.
	OPAMP_OPAMP2_LPOTR_TRIMLPOFFSETN_Pos = 0x0
	// Bit mask of TRIMLPOFFSETN field.
	OPAMP_OPAMP2_LPOTR_TRIMLPOFFSETN_Msk = 0x1f
	// Position of TRIMLPOFFSETP field.
	OPAMP_OPAMP2_LPOTR_TRIMLPOFFSETP_Pos = 0x8
	// Bit mask of TRIMLPOFFSETP field.
	OPAMP_OPAMP2_LPOTR_TRIMLPOFFSETP_Msk = 0x1f00
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ISER1: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER1_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff

	// ISER2: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER2_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER2_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ICER1: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER1_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff

	// ICER2: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER2_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER2_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ISPR1: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff

	// ISPR2: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR2_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR2_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// ICPR1: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff

	// ICPR2: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IABR2: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR2_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR2_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000

	// IPR9: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000

	// IPR10: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000

	// IPR11: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000

	// IPR12: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000

	// IPR13: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000

	// IPR14: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000

	// IPR15: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Msk = 0xff000000

	// IPR16: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Msk = 0xff000000

	// IPR17: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Msk = 0xff000000

	// IPR18: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Msk = 0xff000000

	// IPR19: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Msk = 0xff000000

	// IPR20: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR20_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR20_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR20_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR20_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR20_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR20_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR20_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR20_IPR_N3_Msk = 0xff000000
)

// Bitfields for CRS: Clock recovery system
const (
	// CR: control register
	// Position of TRIM field.
	CRS_CR_TRIM_Pos = 0x8
	// Bit mask of TRIM field.
	CRS_CR_TRIM_Msk = 0x3f00
	// Position of SWSYNC field.
	CRS_CR_SWSYNC_Pos = 0x7
	// Bit mask of SWSYNC field.
	CRS_CR_SWSYNC_Msk = 0x80
	// Bit SWSYNC.
	CRS_CR_SWSYNC = 0x80
	// Position of AUTOTRIMEN field.
	CRS_CR_AUTOTRIMEN_Pos = 0x6
	// Bit mask of AUTOTRIMEN field.
	CRS_CR_AUTOTRIMEN_Msk = 0x40
	// Bit AUTOTRIMEN.
	CRS_CR_AUTOTRIMEN = 0x40
	// Position of CEN field.
	CRS_CR_CEN_Pos = 0x5
	// Bit mask of CEN field.
	CRS_CR_CEN_Msk = 0x20
	// Bit CEN.
	CRS_CR_CEN = 0x20
	// Position of ESYNCIE field.
	CRS_CR_ESYNCIE_Pos = 0x3
	// Bit mask of ESYNCIE field.
	CRS_CR_ESYNCIE_Msk = 0x8
	// Bit ESYNCIE.
	CRS_CR_ESYNCIE = 0x8
	// Position of ERRIE field.
	CRS_CR_ERRIE_Pos = 0x2
	// Bit mask of ERRIE field.
	CRS_CR_ERRIE_Msk = 0x4
	// Bit ERRIE.
	CRS_CR_ERRIE = 0x4
	// Position of SYNCWARNIE field.
	CRS_CR_SYNCWARNIE_Pos = 0x1
	// Bit mask of SYNCWARNIE field.
	CRS_CR_SYNCWARNIE_Msk = 0x2
	// Bit SYNCWARNIE.
	CRS_CR_SYNCWARNIE = 0x2
	// Position of SYNCOKIE field.
	CRS_CR_SYNCOKIE_Pos = 0x0
	// Bit mask of SYNCOKIE field.
	CRS_CR_SYNCOKIE_Msk = 0x1
	// Bit SYNCOKIE.
	CRS_CR_SYNCOKIE = 0x1

	// CFGR: configuration register
	// Position of SYNCPOL field.
	CRS_CFGR_SYNCPOL_Pos = 0x1f
	// Bit mask of SYNCPOL field.
	CRS_CFGR_SYNCPOL_Msk = 0x80000000
	// Bit SYNCPOL.
	CRS_CFGR_SYNCPOL = 0x80000000
	// Position of SYNCSRC field.
	CRS_CFGR_SYNCSRC_Pos = 0x1c
	// Bit mask of SYNCSRC field.
	CRS_CFGR_SYNCSRC_Msk = 0x30000000
	// Position of SYNCDIV field.
	CRS_CFGR_SYNCDIV_Pos = 0x18
	// Bit mask of SYNCDIV field.
	CRS_CFGR_SYNCDIV_Msk = 0x7000000
	// Position of FELIM field.
	CRS_CFGR_FELIM_Pos = 0x10
	// Bit mask of FELIM field.
	CRS_CFGR_FELIM_Msk = 0xff0000
	// Position of RELOAD field.
	CRS_CFGR_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	CRS_CFGR_RELOAD_Msk = 0xffff

	// ISR: interrupt and status register
	// Position of FECAP field.
	CRS_ISR_FECAP_Pos = 0x10
	// Bit mask of FECAP field.
	CRS_ISR_FECAP_Msk = 0xffff0000
	// Position of FEDIR field.
	CRS_ISR_FEDIR_Pos = 0xf
	// Bit mask of FEDIR field.
	CRS_ISR_FEDIR_Msk = 0x8000
	// Bit FEDIR.
	CRS_ISR_FEDIR = 0x8000
	// Position of TRIMOVF field.
	CRS_ISR_TRIMOVF_Pos = 0xa
	// Bit mask of TRIMOVF field.
	CRS_ISR_TRIMOVF_Msk = 0x400
	// Bit TRIMOVF.
	CRS_ISR_TRIMOVF = 0x400
	// Position of SYNCMISS field.
	CRS_ISR_SYNCMISS_Pos = 0x9
	// Bit mask of SYNCMISS field.
	CRS_ISR_SYNCMISS_Msk = 0x200
	// Bit SYNCMISS.
	CRS_ISR_SYNCMISS = 0x200
	// Position of SYNCERR field.
	CRS_ISR_SYNCERR_Pos = 0x8
	// Bit mask of SYNCERR field.
	CRS_ISR_SYNCERR_Msk = 0x100
	// Bit SYNCERR.
	CRS_ISR_SYNCERR = 0x100
	// Position of ESYNCF field.
	CRS_ISR_ESYNCF_Pos = 0x3
	// Bit mask of ESYNCF field.
	CRS_ISR_ESYNCF_Msk = 0x8
	// Bit ESYNCF.
	CRS_ISR_ESYNCF = 0x8
	// Position of ERRF field.
	CRS_ISR_ERRF_Pos = 0x2
	// Bit mask of ERRF field.
	CRS_ISR_ERRF_Msk = 0x4
	// Bit ERRF.
	CRS_ISR_ERRF = 0x4
	// Position of SYNCWARNF field.
	CRS_ISR_SYNCWARNF_Pos = 0x1
	// Bit mask of SYNCWARNF field.
	CRS_ISR_SYNCWARNF_Msk = 0x2
	// Bit SYNCWARNF.
	CRS_ISR_SYNCWARNF = 0x2
	// Position of SYNCOKF field.
	CRS_ISR_SYNCOKF_Pos = 0x0
	// Bit mask of SYNCOKF field.
	CRS_ISR_SYNCOKF_Msk = 0x1
	// Bit SYNCOKF.
	CRS_ISR_SYNCOKF = 0x1

	// ICR: interrupt flag clear register
	// Position of ESYNCC field.
	CRS_ICR_ESYNCC_Pos = 0x3
	// Bit mask of ESYNCC field.
	CRS_ICR_ESYNCC_Msk = 0x8
	// Bit ESYNCC.
	CRS_ICR_ESYNCC = 0x8
	// Position of ERRC field.
	CRS_ICR_ERRC_Pos = 0x2
	// Bit mask of ERRC field.
	CRS_ICR_ERRC_Msk = 0x4
	// Bit ERRC.
	CRS_ICR_ERRC = 0x4
	// Position of SYNCWARNC field.
	CRS_ICR_SYNCWARNC_Pos = 0x1
	// Bit mask of SYNCWARNC field.
	CRS_ICR_SYNCWARNC_Msk = 0x2
	// Bit SYNCWARNC.
	CRS_ICR_SYNCWARNC = 0x2
	// Position of SYNCOKC field.
	CRS_ICR_SYNCOKC_Pos = 0x0
	// Bit mask of SYNCOKC field.
	CRS_ICR_SYNCOKC_Msk = 0x1
	// Bit SYNCOKC.
	CRS_ICR_SYNCOKC = 0x1
)

// Bitfields for USB: Universal serial bus full-speed device interface
const (
	// EP0R: endpoint 0 register
	// Position of EA field.
	USB_EP0R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP0R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP0R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP0R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP0R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP0R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP0R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP0R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP0R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP0R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP0R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP0R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP0R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP0R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP0R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP0R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP0R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP0R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP0R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP0R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP0R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP0R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP0R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP0R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP0R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP0R_CTR_RX = 0x8000

	// EP1R: endpoint 1 register
	// Position of EA field.
	USB_EP1R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP1R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP1R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP1R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP1R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP1R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP1R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP1R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP1R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP1R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP1R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP1R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP1R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP1R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP1R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP1R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP1R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP1R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP1R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP1R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP1R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP1R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP1R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP1R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP1R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP1R_CTR_RX = 0x8000

	// EP2R: endpoint 2 register
	// Position of EA field.
	USB_EP2R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP2R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP2R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP2R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP2R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP2R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP2R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP2R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP2R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP2R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP2R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP2R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP2R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP2R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP2R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP2R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP2R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP2R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP2R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP2R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP2R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP2R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP2R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP2R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP2R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP2R_CTR_RX = 0x8000

	// EP3R: endpoint 3 register
	// Position of EA field.
	USB_EP3R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP3R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP3R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP3R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP3R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP3R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP3R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP3R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP3R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP3R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP3R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP3R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP3R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP3R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP3R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP3R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP3R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP3R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP3R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP3R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP3R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP3R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP3R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP3R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP3R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP3R_CTR_RX = 0x8000

	// EP4R: endpoint 4 register
	// Position of EA field.
	USB_EP4R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP4R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP4R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP4R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP4R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP4R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP4R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP4R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP4R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP4R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP4R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP4R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP4R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP4R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP4R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP4R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP4R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP4R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP4R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP4R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP4R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP4R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP4R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP4R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP4R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP4R_CTR_RX = 0x8000

	// EP5R: endpoint 5 register
	// Position of EA field.
	USB_EP5R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP5R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP5R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP5R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP5R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP5R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP5R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP5R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP5R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP5R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP5R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP5R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP5R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP5R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP5R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP5R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP5R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP5R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP5R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP5R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP5R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP5R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP5R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP5R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP5R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP5R_CTR_RX = 0x8000

	// EP6R: endpoint 6 register
	// Position of EA field.
	USB_EP6R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP6R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP6R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP6R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP6R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP6R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP6R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP6R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP6R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP6R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP6R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP6R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP6R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP6R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP6R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP6R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP6R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP6R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP6R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP6R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP6R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP6R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP6R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP6R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP6R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP6R_CTR_RX = 0x8000

	// EP7R: endpoint 7 register
	// Position of EA field.
	USB_EP7R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP7R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP7R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP7R_STAT_TX_Msk = 0x30
	// Position of DTOG_TX field.
	USB_EP7R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP7R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP7R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP7R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP7R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP7R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP7R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP7R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP7R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP7R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP7R_EP_TYPE_Msk = 0x600
	// Position of SETUP field.
	USB_EP7R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP7R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP7R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP7R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP7R_STAT_RX_Msk = 0x3000
	// Position of DTOG_RX field.
	USB_EP7R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP7R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP7R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP7R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP7R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP7R_CTR_RX = 0x8000

	// CNTR: control register
	// Position of FRES field.
	USB_CNTR_FRES_Pos = 0x0
	// Bit mask of FRES field.
	USB_CNTR_FRES_Msk = 0x1
	// Bit FRES.
	USB_CNTR_FRES = 0x1
	// Position of PDWN field.
	USB_CNTR_PDWN_Pos = 0x1
	// Bit mask of PDWN field.
	USB_CNTR_PDWN_Msk = 0x2
	// Bit PDWN.
	USB_CNTR_PDWN = 0x2
	// Position of LPMODE field.
	USB_CNTR_LPMODE_Pos = 0x2
	// Bit mask of LPMODE field.
	USB_CNTR_LPMODE_Msk = 0x4
	// Bit LPMODE.
	USB_CNTR_LPMODE = 0x4
	// Position of FSUSP field.
	USB_CNTR_FSUSP_Pos = 0x3
	// Bit mask of FSUSP field.
	USB_CNTR_FSUSP_Msk = 0x8
	// Bit FSUSP.
	USB_CNTR_FSUSP = 0x8
	// Position of RESUME field.
	USB_CNTR_RESUME_Pos = 0x4
	// Bit mask of RESUME field.
	USB_CNTR_RESUME_Msk = 0x10
	// Bit RESUME.
	USB_CNTR_RESUME = 0x10
	// Position of L1RESUME field.
	USB_CNTR_L1RESUME_Pos = 0x5
	// Bit mask of L1RESUME field.
	USB_CNTR_L1RESUME_Msk = 0x20
	// Bit L1RESUME.
	USB_CNTR_L1RESUME = 0x20
	// Position of L1REQM field.
	USB_CNTR_L1REQM_Pos = 0x7
	// Bit mask of L1REQM field.
	USB_CNTR_L1REQM_Msk = 0x80
	// Bit L1REQM.
	USB_CNTR_L1REQM = 0x80
	// Position of ESOFM field.
	USB_CNTR_ESOFM_Pos = 0x8
	// Bit mask of ESOFM field.
	USB_CNTR_ESOFM_Msk = 0x100
	// Bit ESOFM.
	USB_CNTR_ESOFM = 0x100
	// Position of SOFM field.
	USB_CNTR_SOFM_Pos = 0x9
	// Bit mask of SOFM field.
	USB_CNTR_SOFM_Msk = 0x200
	// Bit SOFM.
	USB_CNTR_SOFM = 0x200
	// Position of RESETM field.
	USB_CNTR_RESETM_Pos = 0xa
	// Bit mask of RESETM field.
	USB_CNTR_RESETM_Msk = 0x400
	// Bit RESETM.
	USB_CNTR_RESETM = 0x400
	// Position of SUSPM field.
	USB_CNTR_SUSPM_Pos = 0xb
	// Bit mask of SUSPM field.
	USB_CNTR_SUSPM_Msk = 0x800
	// Bit SUSPM.
	USB_CNTR_SUSPM = 0x800
	// Position of WKUPM field.
	USB_CNTR_WKUPM_Pos = 0xc
	// Bit mask of WKUPM field.
	USB_CNTR_WKUPM_Msk = 0x1000
	// Bit WKUPM.
	USB_CNTR_WKUPM = 0x1000
	// Position of ERRM field.
	USB_CNTR_ERRM_Pos = 0xd
	// Bit mask of ERRM field.
	USB_CNTR_ERRM_Msk = 0x2000
	// Bit ERRM.
	USB_CNTR_ERRM = 0x2000
	// Position of PMAOVRM field.
	USB_CNTR_PMAOVRM_Pos = 0xe
	// Bit mask of PMAOVRM field.
	USB_CNTR_PMAOVRM_Msk = 0x4000
	// Bit PMAOVRM.
	USB_CNTR_PMAOVRM = 0x4000
	// Position of CTRM field.
	USB_CNTR_CTRM_Pos = 0xf
	// Bit mask of CTRM field.
	USB_CNTR_CTRM_Msk = 0x8000
	// Bit CTRM.
	USB_CNTR_CTRM = 0x8000

	// ISTR: interrupt status register
	// Position of EP_ID field.
	USB_ISTR_EP_ID_Pos = 0x0
	// Bit mask of EP_ID field.
	USB_ISTR_EP_ID_Msk = 0xf
	// Position of DIR field.
	USB_ISTR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	USB_ISTR_DIR_Msk = 0x10
	// Bit DIR.
	USB_ISTR_DIR = 0x10
	// Position of L1REQ field.
	USB_ISTR_L1REQ_Pos = 0x7
	// Bit mask of L1REQ field.
	USB_ISTR_L1REQ_Msk = 0x80
	// Bit L1REQ.
	USB_ISTR_L1REQ = 0x80
	// Position of ESOF field.
	USB_ISTR_ESOF_Pos = 0x8
	// Bit mask of ESOF field.
	USB_ISTR_ESOF_Msk = 0x100
	// Bit ESOF.
	USB_ISTR_ESOF = 0x100
	// Position of SOF field.
	USB_ISTR_SOF_Pos = 0x9
	// Bit mask of SOF field.
	USB_ISTR_SOF_Msk = 0x200
	// Bit SOF.
	USB_ISTR_SOF = 0x200
	// Position of RESET field.
	USB_ISTR_RESET_Pos = 0xa
	// Bit mask of RESET field.
	USB_ISTR_RESET_Msk = 0x400
	// Bit RESET.
	USB_ISTR_RESET = 0x400
	// Position of SUSP field.
	USB_ISTR_SUSP_Pos = 0xb
	// Bit mask of SUSP field.
	USB_ISTR_SUSP_Msk = 0x800
	// Bit SUSP.
	USB_ISTR_SUSP = 0x800
	// Position of WKUP field.
	USB_ISTR_WKUP_Pos = 0xc
	// Bit mask of WKUP field.
	USB_ISTR_WKUP_Msk = 0x1000
	// Bit WKUP.
	USB_ISTR_WKUP = 0x1000
	// Position of ERR field.
	USB_ISTR_ERR_Pos = 0xd
	// Bit mask of ERR field.
	USB_ISTR_ERR_Msk = 0x2000
	// Bit ERR.
	USB_ISTR_ERR = 0x2000
	// Position of PMAOVR field.
	USB_ISTR_PMAOVR_Pos = 0xe
	// Bit mask of PMAOVR field.
	USB_ISTR_PMAOVR_Msk = 0x4000
	// Bit PMAOVR.
	USB_ISTR_PMAOVR = 0x4000
	// Position of CTR field.
	USB_ISTR_CTR_Pos = 0xf
	// Bit mask of CTR field.
	USB_ISTR_CTR_Msk = 0x8000
	// Bit CTR.
	USB_ISTR_CTR = 0x8000

	// FNR: frame number register
	// Position of FN field.
	USB_FNR_FN_Pos = 0x0
	// Bit mask of FN field.
	USB_FNR_FN_Msk = 0x7ff
	// Position of LSOF field.
	USB_FNR_LSOF_Pos = 0xb
	// Bit mask of LSOF field.
	USB_FNR_LSOF_Msk = 0x1800
	// Position of LCK field.
	USB_FNR_LCK_Pos = 0xd
	// Bit mask of LCK field.
	USB_FNR_LCK_Msk = 0x2000
	// Bit LCK.
	USB_FNR_LCK = 0x2000
	// Position of RXDM field.
	USB_FNR_RXDM_Pos = 0xe
	// Bit mask of RXDM field.
	USB_FNR_RXDM_Msk = 0x4000
	// Bit RXDM.
	USB_FNR_RXDM = 0x4000
	// Position of RXDP field.
	USB_FNR_RXDP_Pos = 0xf
	// Bit mask of RXDP field.
	USB_FNR_RXDP_Msk = 0x8000
	// Bit RXDP.
	USB_FNR_RXDP = 0x8000

	// DADDR: device address
	// Position of ADD field.
	USB_DADDR_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USB_DADDR_ADD_Msk = 0x7f
	// Position of EF field.
	USB_DADDR_EF_Pos = 0x7
	// Bit mask of EF field.
	USB_DADDR_EF_Msk = 0x80
	// Bit EF.
	USB_DADDR_EF = 0x80

	// BTABLE: Buffer table address
	// Position of BTABLE field.
	USB_BTABLE_BTABLE_Pos = 0x3
	// Bit mask of BTABLE field.
	USB_BTABLE_BTABLE_Msk = 0xfff8
)

// Bitfields for QUADSPI: QuadSPI interface
const (
	// CR: control register
	// Position of PRESCALER field.
	QUADSPI_CR_PRESCALER_Pos = 0x18
	// Bit mask of PRESCALER field.
	QUADSPI_CR_PRESCALER_Msk = 0xff000000
	// Position of PMM field.
	QUADSPI_CR_PMM_Pos = 0x17
	// Bit mask of PMM field.
	QUADSPI_CR_PMM_Msk = 0x800000
	// Bit PMM.
	QUADSPI_CR_PMM = 0x800000
	// Position of APMS field.
	QUADSPI_CR_APMS_Pos = 0x16
	// Bit mask of APMS field.
	QUADSPI_CR_APMS_Msk = 0x400000
	// Bit APMS.
	QUADSPI_CR_APMS = 0x400000
	// Position of TOIE field.
	QUADSPI_CR_TOIE_Pos = 0x14
	// Bit mask of TOIE field.
	QUADSPI_CR_TOIE_Msk = 0x100000
	// Bit TOIE.
	QUADSPI_CR_TOIE = 0x100000
	// Position of SMIE field.
	QUADSPI_CR_SMIE_Pos = 0x13
	// Bit mask of SMIE field.
	QUADSPI_CR_SMIE_Msk = 0x80000
	// Bit SMIE.
	QUADSPI_CR_SMIE = 0x80000
	// Position of FTIE field.
	QUADSPI_CR_FTIE_Pos = 0x12
	// Bit mask of FTIE field.
	QUADSPI_CR_FTIE_Msk = 0x40000
	// Bit FTIE.
	QUADSPI_CR_FTIE = 0x40000
	// Position of TCIE field.
	QUADSPI_CR_TCIE_Pos = 0x11
	// Bit mask of TCIE field.
	QUADSPI_CR_TCIE_Msk = 0x20000
	// Bit TCIE.
	QUADSPI_CR_TCIE = 0x20000
	// Position of TEIE field.
	QUADSPI_CR_TEIE_Pos = 0x10
	// Bit mask of TEIE field.
	QUADSPI_CR_TEIE_Msk = 0x10000
	// Bit TEIE.
	QUADSPI_CR_TEIE = 0x10000
	// Position of FTHRES field.
	QUADSPI_CR_FTHRES_Pos = 0x8
	// Bit mask of FTHRES field.
	QUADSPI_CR_FTHRES_Msk = 0x1f00
	// Position of FSEL field.
	QUADSPI_CR_FSEL_Pos = 0x7
	// Bit mask of FSEL field.
	QUADSPI_CR_FSEL_Msk = 0x80
	// Bit FSEL.
	QUADSPI_CR_FSEL = 0x80
	// Position of DFM field.
	QUADSPI_CR_DFM_Pos = 0x6
	// Bit mask of DFM field.
	QUADSPI_CR_DFM_Msk = 0x40
	// Bit DFM.
	QUADSPI_CR_DFM = 0x40
	// Position of SSHIFT field.
	QUADSPI_CR_SSHIFT_Pos = 0x4
	// Bit mask of SSHIFT field.
	QUADSPI_CR_SSHIFT_Msk = 0x10
	// Bit SSHIFT.
	QUADSPI_CR_SSHIFT = 0x10
	// Position of TCEN field.
	QUADSPI_CR_TCEN_Pos = 0x3
	// Bit mask of TCEN field.
	QUADSPI_CR_TCEN_Msk = 0x8
	// Bit TCEN.
	QUADSPI_CR_TCEN = 0x8
	// Position of DMAEN field.
	QUADSPI_CR_DMAEN_Pos = 0x2
	// Bit mask of DMAEN field.
	QUADSPI_CR_DMAEN_Msk = 0x4
	// Bit DMAEN.
	QUADSPI_CR_DMAEN = 0x4
	// Position of ABORT field.
	QUADSPI_CR_ABORT_Pos = 0x1
	// Bit mask of ABORT field.
	QUADSPI_CR_ABORT_Msk = 0x2
	// Bit ABORT.
	QUADSPI_CR_ABORT = 0x2
	// Position of EN field.
	QUADSPI_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	QUADSPI_CR_EN_Msk = 0x1
	// Bit EN.
	QUADSPI_CR_EN = 0x1

	// DCR: device configuration register
	// Position of FSIZE field.
	QUADSPI_DCR_FSIZE_Pos = 0x10
	// Bit mask of FSIZE field.
	QUADSPI_DCR_FSIZE_Msk = 0x1f0000
	// Position of CSHT field.
	QUADSPI_DCR_CSHT_Pos = 0x8
	// Bit mask of CSHT field.
	QUADSPI_DCR_CSHT_Msk = 0x700
	// Position of CKMODE field.
	QUADSPI_DCR_CKMODE_Pos = 0x0
	// Bit mask of CKMODE field.
	QUADSPI_DCR_CKMODE_Msk = 0x1
	// Bit CKMODE.
	QUADSPI_DCR_CKMODE = 0x1

	// SR: status register
	// Position of FLEVEL field.
	QUADSPI_SR_FLEVEL_Pos = 0x8
	// Bit mask of FLEVEL field.
	QUADSPI_SR_FLEVEL_Msk = 0x7f00
	// Position of BUSY field.
	QUADSPI_SR_BUSY_Pos = 0x5
	// Bit mask of BUSY field.
	QUADSPI_SR_BUSY_Msk = 0x20
	// Bit BUSY.
	QUADSPI_SR_BUSY = 0x20
	// Position of TOF field.
	QUADSPI_SR_TOF_Pos = 0x4
	// Bit mask of TOF field.
	QUADSPI_SR_TOF_Msk = 0x10
	// Bit TOF.
	QUADSPI_SR_TOF = 0x10
	// Position of SMF field.
	QUADSPI_SR_SMF_Pos = 0x3
	// Bit mask of SMF field.
	QUADSPI_SR_SMF_Msk = 0x8
	// Bit SMF.
	QUADSPI_SR_SMF = 0x8
	// Position of FTF field.
	QUADSPI_SR_FTF_Pos = 0x2
	// Bit mask of FTF field.
	QUADSPI_SR_FTF_Msk = 0x4
	// Bit FTF.
	QUADSPI_SR_FTF = 0x4
	// Position of TCF field.
	QUADSPI_SR_TCF_Pos = 0x1
	// Bit mask of TCF field.
	QUADSPI_SR_TCF_Msk = 0x2
	// Bit TCF.
	QUADSPI_SR_TCF = 0x2
	// Position of TEF field.
	QUADSPI_SR_TEF_Pos = 0x0
	// Bit mask of TEF field.
	QUADSPI_SR_TEF_Msk = 0x1
	// Bit TEF.
	QUADSPI_SR_TEF = 0x1

	// FCR: flag clear register
	// Position of CTOF field.
	QUADSPI_FCR_CTOF_Pos = 0x4
	// Bit mask of CTOF field.
	QUADSPI_FCR_CTOF_Msk = 0x10
	// Bit CTOF.
	QUADSPI_FCR_CTOF = 0x10
	// Position of CSMF field.
	QUADSPI_FCR_CSMF_Pos = 0x3
	// Bit mask of CSMF field.
	QUADSPI_FCR_CSMF_Msk = 0x8
	// Bit CSMF.
	QUADSPI_FCR_CSMF = 0x8
	// Position of CTCF field.
	QUADSPI_FCR_CTCF_Pos = 0x1
	// Bit mask of CTCF field.
	QUADSPI_FCR_CTCF_Msk = 0x2
	// Bit CTCF.
	QUADSPI_FCR_CTCF = 0x2
	// Position of CTEF field.
	QUADSPI_FCR_CTEF_Pos = 0x0
	// Bit mask of CTEF field.
	QUADSPI_FCR_CTEF_Msk = 0x1
	// Bit CTEF.
	QUADSPI_FCR_CTEF = 0x1

	// DLR: data length register
	// Position of DL field.
	QUADSPI_DLR_DL_Pos = 0x0
	// Bit mask of DL field.
	QUADSPI_DLR_DL_Msk = 0xffffffff

	// CCR: communication configuration register
	// Position of DDRM field.
	QUADSPI_CCR_DDRM_Pos = 0x1f
	// Bit mask of DDRM field.
	QUADSPI_CCR_DDRM_Msk = 0x80000000
	// Bit DDRM.
	QUADSPI_CCR_DDRM = 0x80000000
	// Position of DHHC field.
	QUADSPI_CCR_DHHC_Pos = 0x1e
	// Bit mask of DHHC field.
	QUADSPI_CCR_DHHC_Msk = 0x40000000
	// Bit DHHC.
	QUADSPI_CCR_DHHC = 0x40000000
	// Position of SIOO field.
	QUADSPI_CCR_SIOO_Pos = 0x1c
	// Bit mask of SIOO field.
	QUADSPI_CCR_SIOO_Msk = 0x10000000
	// Bit SIOO.
	QUADSPI_CCR_SIOO = 0x10000000
	// Position of FMODE field.
	QUADSPI_CCR_FMODE_Pos = 0x1a
	// Bit mask of FMODE field.
	QUADSPI_CCR_FMODE_Msk = 0xc000000
	// Position of DMODE field.
	QUADSPI_CCR_DMODE_Pos = 0x18
	// Bit mask of DMODE field.
	QUADSPI_CCR_DMODE_Msk = 0x3000000
	// Position of DCYC field.
	QUADSPI_CCR_DCYC_Pos = 0x12
	// Bit mask of DCYC field.
	QUADSPI_CCR_DCYC_Msk = 0x7c0000
	// Position of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Pos = 0x10
	// Bit mask of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Msk = 0x30000
	// Position of ABMODE field.
	QUADSPI_CCR_ABMODE_Pos = 0xe
	// Bit mask of ABMODE field.
	QUADSPI_CCR_ABMODE_Msk = 0xc000
	// Position of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Pos = 0xc
	// Bit mask of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Msk = 0x3000
	// Position of ADMODE field.
	QUADSPI_CCR_ADMODE_Pos = 0xa
	// Bit mask of ADMODE field.
	QUADSPI_CCR_ADMODE_Msk = 0xc00
	// Position of IMODE field.
	QUADSPI_CCR_IMODE_Pos = 0x8
	// Bit mask of IMODE field.
	QUADSPI_CCR_IMODE_Msk = 0x300
	// Position of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Pos = 0x0
	// Bit mask of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Msk = 0xff

	// AR: address register
	// Position of ADDRESS field.
	QUADSPI_AR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	QUADSPI_AR_ADDRESS_Msk = 0xffffffff

	// ABR: ABR
	// Position of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Pos = 0x0
	// Bit mask of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Msk = 0xffffffff

	// DR: data register
	// Position of DATA field.
	QUADSPI_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	QUADSPI_DR_DATA_Msk = 0xffffffff

	// PSMKR: polling status mask register
	// Position of MASK field.
	QUADSPI_PSMKR_MASK_Pos = 0x0
	// Bit mask of MASK field.
	QUADSPI_PSMKR_MASK_Msk = 0xffffffff

	// PSMAR: polling status match register
	// Position of MATCH field.
	QUADSPI_PSMAR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	QUADSPI_PSMAR_MATCH_Msk = 0xffffffff

	// PIR: polling interval register
	// Position of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Pos = 0x0
	// Bit mask of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Msk = 0xffff

	// LPTR: low-power timeout register
	// Position of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Msk = 0xffff
)

// Bitfields for FMC: Flexible memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register 1
	// Position of MBKEN field.
	FSMC_BCR1_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR1_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR1_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR1_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR1_MBKEN_Enabled = 0x1
	// Position of MUXEN field.
	FSMC_BCR1_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR1_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR1_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR1_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR1_MUXEN_Enabled = 0x1
	// Position of MTYP field.
	FSMC_BCR1_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR1_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR1_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR1_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR1_MTYP_Flash = 0x2
	// Position of MWID field.
	FSMC_BCR1_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR1_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR1_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR1_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR1_MWID_Bits32 = 0x2
	// Position of FACCEN field.
	FSMC_BCR1_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR1_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR1_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR1_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR1_FACCEN_Enabled = 0x1
	// Position of BURSTEN field.
	FSMC_BCR1_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR1_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR1_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR1_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR1_BURSTEN_Enabled = 0x1
	// Position of WAITPOL field.
	FSMC_BCR1_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR1_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR1_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR1_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR1_WAITPOL_ActiveHigh = 0x1
	// Position of WAITCFG field.
	FSMC_BCR1_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR1_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR1_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR1_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR1_WAITCFG_DuringWaitState = 0x1
	// Position of WREN field.
	FSMC_BCR1_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR1_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR1_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR1_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR1_WREN_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR1_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR1_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR1_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR1_WAITEN_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR1_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR1_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR1_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR1_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_EXTMOD_Enabled = 0x1
	// Position of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR1_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Enabled = 0x1
	// Position of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR1_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR1_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR1_CBURSTRW_Disabled = 0x0
	// Position of CCLKEN field.
	FSMC_BCR1_CCLKEN_Pos = 0x14
	// Bit mask of CCLKEN field.
	FSMC_BCR1_CCLKEN_Msk = 0x100000
	// Bit CCLKEN.
	FSMC_BCR1_CCLKEN = 0x100000
	// The FMC_CLK is only generated during the synchronous memory access (read/write transaction)
	FSMC_BCR1_CCLKEN_Enabled = 0x1
	// The FMC_CLK is generated continuously during asynchronous and synchronous access. The FMC_CLK clock is activated when the CCLKEN is set
	FSMC_BCR1_CCLKEN_Disabled = 0x0
	// Position of WFDIS field.
	FSMC_BCR1_WFDIS_Pos = 0x15
	// Bit mask of WFDIS field.
	FSMC_BCR1_WFDIS_Msk = 0x200000
	// Bit WFDIS.
	FSMC_BCR1_WFDIS = 0x200000
	// Write FIFO enabled
	FSMC_BCR1_WFDIS_Enabled = 0x0
	// Write FIFO disabled
	FSMC_BCR1_WFDIS_Disabled = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR1_WRAPMOD = 0x400
	// Position of CPSIZE field.
	FSMC_BCR1_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR1_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR1_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes1024 = 0x4

	// BTR1: SRAM/NOR-Flash chip-select timing register 1
	// Position of ACCMOD field.
	FSMC_BTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BTR_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FSMC_BTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BTR_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FSMC_BTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BTR_ADDSET_Msk = 0xf

	// BCR2: SRAM/NOR-Flash chip-select control register 2
	// Position of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR_WAITCFG_DuringWaitState = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FSMC_BCR_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR_MBKEN_Enabled = 0x1
	// Position of WFDIS field.
	FSMC_BCR_WFDIS_Pos = 0x15
	// Bit mask of WFDIS field.
	FSMC_BCR_WFDIS_Msk = 0x200000
	// Bit WFDIS.
	FSMC_BCR_WFDIS = 0x200000
	// Position of CCLKEN field.
	FSMC_BCR_CCLKEN_Pos = 0x14
	// Bit mask of CCLKEN field.
	FSMC_BCR_CCLKEN_Msk = 0x100000
	// Bit CCLKEN.
	FSMC_BCR_CCLKEN = 0x100000
	// Position of CPSIZE field.
	FSMC_BCR_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes1024 = 0x4

	// PCR: PC Card/NAND Flash control register 3
	// Position of ECCPS field.
	FSMC_PCR_ECCPS_Pos = 0x11
	// Bit mask of ECCPS field.
	FSMC_PCR_ECCPS_Msk = 0xe0000
	// ECC page size 256 bytes
	FSMC_PCR_ECCPS_Bytes256 = 0x0
	// ECC page size 512 bytes
	FSMC_PCR_ECCPS_Bytes512 = 0x1
	// ECC page size 1024 bytes
	FSMC_PCR_ECCPS_Bytes1024 = 0x2
	// ECC page size 2048 bytes
	FSMC_PCR_ECCPS_Bytes2048 = 0x3
	// ECC page size 4096 bytes
	FSMC_PCR_ECCPS_Bytes4096 = 0x4
	// ECC page size 8192 bytes
	FSMC_PCR_ECCPS_Bytes8192 = 0x5
	// Position of TAR field.
	FSMC_PCR_TAR_Pos = 0xd
	// Bit mask of TAR field.
	FSMC_PCR_TAR_Msk = 0x1e000
	// Position of TCLR field.
	FSMC_PCR_TCLR_Pos = 0x9
	// Bit mask of TCLR field.
	FSMC_PCR_TCLR_Msk = 0x1e00
	// Position of ECCEN field.
	FSMC_PCR_ECCEN_Pos = 0x6
	// Bit mask of ECCEN field.
	FSMC_PCR_ECCEN_Msk = 0x40
	// Bit ECCEN.
	FSMC_PCR_ECCEN = 0x40
	// ECC logic is disabled and reset
	FSMC_PCR_ECCEN_Disabled = 0x0
	// ECC logic is enabled
	FSMC_PCR_ECCEN_Enabled = 0x1
	// Position of PWID field.
	FSMC_PCR_PWID_Pos = 0x4
	// Bit mask of PWID field.
	FSMC_PCR_PWID_Msk = 0x30
	// External memory device width 8 bits
	FSMC_PCR_PWID_Bits8 = 0x0
	// External memory device width 16 bits
	FSMC_PCR_PWID_Bits16 = 0x1
	// Position of PTYP field.
	FSMC_PCR_PTYP_Pos = 0x3
	// Bit mask of PTYP field.
	FSMC_PCR_PTYP_Msk = 0x8
	// Bit PTYP.
	FSMC_PCR_PTYP = 0x8
	// NAND Flash
	FSMC_PCR_PTYP_NANDFlash = 0x1
	// Position of PBKEN field.
	FSMC_PCR_PBKEN_Pos = 0x2
	// Bit mask of PBKEN field.
	FSMC_PCR_PBKEN_Msk = 0x4
	// Bit PBKEN.
	FSMC_PCR_PBKEN = 0x4
	// Corresponding memory bank is disabled
	FSMC_PCR_PBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_PCR_PBKEN_Enabled = 0x1
	// Position of PWAITEN field.
	FSMC_PCR_PWAITEN_Pos = 0x1
	// Bit mask of PWAITEN field.
	FSMC_PCR_PWAITEN_Msk = 0x2
	// Bit PWAITEN.
	FSMC_PCR_PWAITEN = 0x2
	// Wait feature disabled
	FSMC_PCR_PWAITEN_Disabled = 0x0
	// Wait feature enabled
	FSMC_PCR_PWAITEN_Enabled = 0x1

	// SR: FIFO status and interrupt register 3
	// Position of FEMPT field.
	FSMC_SR_FEMPT_Pos = 0x6
	// Bit mask of FEMPT field.
	FSMC_SR_FEMPT_Msk = 0x40
	// Bit FEMPT.
	FSMC_SR_FEMPT = 0x40
	// FIFO not empty
	FSMC_SR_FEMPT_NotEmpty = 0x0
	// FIFO empty
	FSMC_SR_FEMPT_Empty = 0x1
	// Position of IFEN field.
	FSMC_SR_IFEN_Pos = 0x5
	// Bit mask of IFEN field.
	FSMC_SR_IFEN_Msk = 0x20
	// Bit IFEN.
	FSMC_SR_IFEN = 0x20
	// Interrupt falling edge detection request disabled
	FSMC_SR_IFEN_Disabled = 0x0
	// Interrupt falling edge detection request enabled
	FSMC_SR_IFEN_Enabled = 0x1
	// Position of ILEN field.
	FSMC_SR_ILEN_Pos = 0x4
	// Bit mask of ILEN field.
	FSMC_SR_ILEN_Msk = 0x10
	// Bit ILEN.
	FSMC_SR_ILEN = 0x10
	// Interrupt high-level detection request disabled
	FSMC_SR_ILEN_Disabled = 0x0
	// Interrupt high-level detection request enabled
	FSMC_SR_ILEN_Enabled = 0x1
	// Position of IREN field.
	FSMC_SR_IREN_Pos = 0x3
	// Bit mask of IREN field.
	FSMC_SR_IREN_Msk = 0x8
	// Bit IREN.
	FSMC_SR_IREN = 0x8
	// Interrupt rising edge detection request disabled
	FSMC_SR_IREN_Disabled = 0x0
	// Interrupt rising edge detection request enabled
	FSMC_SR_IREN_Enabled = 0x1
	// Position of IFS field.
	FSMC_SR_IFS_Pos = 0x2
	// Bit mask of IFS field.
	FSMC_SR_IFS_Msk = 0x4
	// Bit IFS.
	FSMC_SR_IFS = 0x4
	// Interrupt falling edge did not occur
	FSMC_SR_IFS_DidNotOccur = 0x0
	// Interrupt falling edge occurred
	FSMC_SR_IFS_Occurred = 0x1
	// Position of ILS field.
	FSMC_SR_ILS_Pos = 0x1
	// Bit mask of ILS field.
	FSMC_SR_ILS_Msk = 0x2
	// Bit ILS.
	FSMC_SR_ILS = 0x2
	// Interrupt high-level did not occur
	FSMC_SR_ILS_DidNotOccur = 0x0
	// Interrupt high-level occurred
	FSMC_SR_ILS_Occurred = 0x1
	// Position of IRS field.
	FSMC_SR_IRS_Pos = 0x0
	// Bit mask of IRS field.
	FSMC_SR_IRS_Msk = 0x1
	// Bit IRS.
	FSMC_SR_IRS = 0x1
	// Interrupt rising edge did not occur
	FSMC_SR_IRS_DidNotOccur = 0x0
	// Interrupt rising edge occurred
	FSMC_SR_IRS_Occurred = 0x1

	// PMEM: Common memory space timing register 3
	// Position of MEMHIZ field.
	FSMC_PMEM_MEMHIZ_Pos = 0x18
	// Bit mask of MEMHIZ field.
	FSMC_PMEM_MEMHIZ_Msk = 0xff000000
	// Position of MEMHOLD field.
	FSMC_PMEM_MEMHOLD_Pos = 0x10
	// Bit mask of MEMHOLD field.
	FSMC_PMEM_MEMHOLD_Msk = 0xff0000
	// Position of MEMWAIT field.
	FSMC_PMEM_MEMWAIT_Pos = 0x8
	// Bit mask of MEMWAIT field.
	FSMC_PMEM_MEMWAIT_Msk = 0xff00
	// Position of MEMSET field.
	FSMC_PMEM_MEMSET_Pos = 0x0
	// Bit mask of MEMSET field.
	FSMC_PMEM_MEMSET_Msk = 0xff

	// PATT: Attribute memory space timing register 3
	// Position of ATTHIZ field.
	FSMC_PATT_ATTHIZ_Pos = 0x18
	// Bit mask of ATTHIZ field.
	FSMC_PATT_ATTHIZ_Msk = 0xff000000
	// Position of ATTHOLD field.
	FSMC_PATT_ATTHOLD_Pos = 0x10
	// Bit mask of ATTHOLD field.
	FSMC_PATT_ATTHOLD_Msk = 0xff0000
	// Position of ATTWAIT field.
	FSMC_PATT_ATTWAIT_Pos = 0x8
	// Bit mask of ATTWAIT field.
	FSMC_PATT_ATTWAIT_Msk = 0xff00
	// Position of ATTSET field.
	FSMC_PATT_ATTSET_Pos = 0x0
	// Bit mask of ATTSET field.
	FSMC_PATT_ATTSET_Msk = 0xff

	// ECCR: ECC result register 3
	// Position of ECC field.
	FSMC_ECCR_ECC_Pos = 0x0
	// Bit mask of ECC field.
	FSMC_ECCR_ECC_Msk = 0xffffffff

	// BWTR1: SRAM/NOR-Flash write timing registers 1
	// Position of ACCMOD field.
	FSMC_BWTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BWTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BWTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BWTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BWTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BWTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BWTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BWTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BWTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BWTR_CLKDIV_Msk = 0xf00000
	// Position of DATAST field.
	FSMC_BWTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BWTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BWTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BWTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BWTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BWTR_ADDSET_Msk = 0xf
	// Position of BUSTURN field.
	FSMC_BWTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BWTR_BUSTURN_Msk = 0xf0000
)

// Bitfields for DFSDM: Digital filter for sigma delta modulators
const (
	// CH.CFGR1: channel configuration y register
	// Position of DFSDMEN field.
	DFSDM_CH_CFGR1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_CH_CFGR1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_CH_CFGR1_DFSDMEN = 0x80000000
	// Position of CKOUTSRC field.
	DFSDM_CH_CFGR1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_CH_CFGR1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_CH_CFGR1_CKOUTSRC = 0x40000000
	// Position of CKOUTDIV field.
	DFSDM_CH_CFGR1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_CH_CFGR1_CKOUTDIV_Msk = 0xff0000
	// Position of DATPACK field.
	DFSDM_CH_CFGR1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_CH_CFGR1_DATPACK_Msk = 0xc000
	// Position of DATMPX field.
	DFSDM_CH_CFGR1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_CH_CFGR1_DATMPX_Msk = 0x3000
	// Position of CHINSEL field.
	DFSDM_CH_CFGR1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_CH_CFGR1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_CH_CFGR1_CHINSEL = 0x100
	// Position of CHEN field.
	DFSDM_CH_CFGR1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_CH_CFGR1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_CH_CFGR1_CHEN = 0x80
	// Position of CKABEN field.
	DFSDM_CH_CFGR1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_CH_CFGR1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_CH_CFGR1_CKABEN = 0x40
	// Position of SCDEN field.
	DFSDM_CH_CFGR1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_CH_CFGR1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_CH_CFGR1_SCDEN = 0x20
	// Position of SPICKSEL field.
	DFSDM_CH_CFGR1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_CH_CFGR1_SPICKSEL_Msk = 0xc
	// Position of SITP field.
	DFSDM_CH_CFGR1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_CH_CFGR1_SITP_Msk = 0x3

	// CH.CFGR2: channel configuration y register
	// Position of OFFSET field.
	DFSDM_CH_CFGR2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_CH_CFGR2_OFFSET_Msk = 0xffffff00
	// Position of DTRBS field.
	DFSDM_CH_CFGR2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_CH_CFGR2_DTRBS_Msk = 0xf8

	// CH.AWSCDR: analog watchdog and short-circuit detector register
	// Position of AWFORD field.
	DFSDM_CH_AWSCDR_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_CH_AWSCDR_AWFORD_Msk = 0xc00000
	// Position of AWFOSR field.
	DFSDM_CH_AWSCDR_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_CH_AWSCDR_AWFOSR_Msk = 0x1f0000
	// Position of BKSCD field.
	DFSDM_CH_AWSCDR_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_CH_AWSCDR_BKSCD_Msk = 0xf000
	// Position of SCDT field.
	DFSDM_CH_AWSCDR_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_CH_AWSCDR_SCDT_Msk = 0xff

	// CH.WDATR: channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_CH_WDATR_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_CH_WDATR_WDATA_Msk = 0xffff

	// CH.DATINR: channel data input register
	// Position of INDAT1 field.
	DFSDM_CH_DATINR_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_CH_DATINR_INDAT1_Msk = 0xffff0000
	// Position of INDAT0 field.
	DFSDM_CH_DATINR_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_CH_DATINR_INDAT0_Msk = 0xffff

	// FLT.CR2: control register 1
	// Position of AWFSEL field.
	DFSDM_FLT_CR2_AWFSEL_Pos = 0x1e
	// Bit mask of AWFSEL field.
	DFSDM_FLT_CR2_AWFSEL_Msk = 0x40000000
	// Bit AWFSEL.
	DFSDM_FLT_CR2_AWFSEL = 0x40000000
	// Position of FAST field.
	DFSDM_FLT_CR2_FAST_Pos = 0x1d
	// Bit mask of FAST field.
	DFSDM_FLT_CR2_FAST_Msk = 0x20000000
	// Bit FAST.
	DFSDM_FLT_CR2_FAST = 0x20000000
	// Position of RCH field.
	DFSDM_FLT_CR2_RCH_Pos = 0x18
	// Bit mask of RCH field.
	DFSDM_FLT_CR2_RCH_Msk = 0x7000000
	// Position of RDMAEN field.
	DFSDM_FLT_CR2_RDMAEN_Pos = 0x15
	// Bit mask of RDMAEN field.
	DFSDM_FLT_CR2_RDMAEN_Msk = 0x200000
	// Bit RDMAEN.
	DFSDM_FLT_CR2_RDMAEN = 0x200000
	// Position of RSYNC field.
	DFSDM_FLT_CR2_RSYNC_Pos = 0x13
	// Bit mask of RSYNC field.
	DFSDM_FLT_CR2_RSYNC_Msk = 0x80000
	// Bit RSYNC.
	DFSDM_FLT_CR2_RSYNC = 0x80000
	// Position of RCONT field.
	DFSDM_FLT_CR2_RCONT_Pos = 0x12
	// Bit mask of RCONT field.
	DFSDM_FLT_CR2_RCONT_Msk = 0x40000
	// Bit RCONT.
	DFSDM_FLT_CR2_RCONT = 0x40000
	// Position of RSWSTART field.
	DFSDM_FLT_CR2_RSWSTART_Pos = 0x11
	// Bit mask of RSWSTART field.
	DFSDM_FLT_CR2_RSWSTART_Msk = 0x20000
	// Bit RSWSTART.
	DFSDM_FLT_CR2_RSWSTART = 0x20000
	// Position of JEXTEN field.
	DFSDM_FLT_CR2_JEXTEN_Pos = 0xd
	// Bit mask of JEXTEN field.
	DFSDM_FLT_CR2_JEXTEN_Msk = 0x6000
	// Position of JEXTSEL field.
	DFSDM_FLT_CR2_JEXTSEL_Pos = 0x8
	// Bit mask of JEXTSEL field.
	DFSDM_FLT_CR2_JEXTSEL_Msk = 0x700
	// Position of JDMAEN field.
	DFSDM_FLT_CR2_JDMAEN_Pos = 0x5
	// Bit mask of JDMAEN field.
	DFSDM_FLT_CR2_JDMAEN_Msk = 0x20
	// Bit JDMAEN.
	DFSDM_FLT_CR2_JDMAEN = 0x20
	// Position of JSCAN field.
	DFSDM_FLT_CR2_JSCAN_Pos = 0x4
	// Bit mask of JSCAN field.
	DFSDM_FLT_CR2_JSCAN_Msk = 0x10
	// Bit JSCAN.
	DFSDM_FLT_CR2_JSCAN = 0x10
	// Position of JSYNC field.
	DFSDM_FLT_CR2_JSYNC_Pos = 0x3
	// Bit mask of JSYNC field.
	DFSDM_FLT_CR2_JSYNC_Msk = 0x8
	// Bit JSYNC.
	DFSDM_FLT_CR2_JSYNC = 0x8
	// Position of JSWSTART field.
	DFSDM_FLT_CR2_JSWSTART_Pos = 0x1
	// Bit mask of JSWSTART field.
	DFSDM_FLT_CR2_JSWSTART_Msk = 0x2
	// Bit JSWSTART.
	DFSDM_FLT_CR2_JSWSTART = 0x2
	// Position of DFEN field.
	DFSDM_FLT_CR2_DFEN_Pos = 0x0
	// Bit mask of DFEN field.
	DFSDM_FLT_CR2_DFEN_Msk = 0x1
	// Bit DFEN.
	DFSDM_FLT_CR2_DFEN = 0x1

	// FLT.ISR: interrupt and status register
	// Position of SCDF field.
	DFSDM_FLT_ISR_SCDF_Pos = 0x18
	// Bit mask of SCDF field.
	DFSDM_FLT_ISR_SCDF_Msk = 0xff000000
	// Position of CKABF field.
	DFSDM_FLT_ISR_CKABF_Pos = 0x10
	// Bit mask of CKABF field.
	DFSDM_FLT_ISR_CKABF_Msk = 0xff0000
	// Position of RCIP field.
	DFSDM_FLT_ISR_RCIP_Pos = 0xe
	// Bit mask of RCIP field.
	DFSDM_FLT_ISR_RCIP_Msk = 0x4000
	// Bit RCIP.
	DFSDM_FLT_ISR_RCIP = 0x4000
	// Position of JCIP field.
	DFSDM_FLT_ISR_JCIP_Pos = 0xd
	// Bit mask of JCIP field.
	DFSDM_FLT_ISR_JCIP_Msk = 0x2000
	// Bit JCIP.
	DFSDM_FLT_ISR_JCIP = 0x2000
	// Position of AWDF field.
	DFSDM_FLT_ISR_AWDF_Pos = 0x4
	// Bit mask of AWDF field.
	DFSDM_FLT_ISR_AWDF_Msk = 0x10
	// Bit AWDF.
	DFSDM_FLT_ISR_AWDF = 0x10
	// Position of ROVRF field.
	DFSDM_FLT_ISR_ROVRF_Pos = 0x3
	// Bit mask of ROVRF field.
	DFSDM_FLT_ISR_ROVRF_Msk = 0x8
	// Bit ROVRF.
	DFSDM_FLT_ISR_ROVRF = 0x8
	// Position of JOVRF field.
	DFSDM_FLT_ISR_JOVRF_Pos = 0x2
	// Bit mask of JOVRF field.
	DFSDM_FLT_ISR_JOVRF_Msk = 0x4
	// Bit JOVRF.
	DFSDM_FLT_ISR_JOVRF = 0x4
	// Position of REOCF field.
	DFSDM_FLT_ISR_REOCF_Pos = 0x1
	// Bit mask of REOCF field.
	DFSDM_FLT_ISR_REOCF_Msk = 0x2
	// Bit REOCF.
	DFSDM_FLT_ISR_REOCF = 0x2
	// Position of JEOCF field.
	DFSDM_FLT_ISR_JEOCF_Pos = 0x0
	// Bit mask of JEOCF field.
	DFSDM_FLT_ISR_JEOCF_Msk = 0x1
	// Bit JEOCF.
	DFSDM_FLT_ISR_JEOCF = 0x1

	// FLT.ICR: interrupt flag clear register
	// Position of CLRSCDF field.
	DFSDM_FLT_ICR_CLRSCDF_Pos = 0x18
	// Bit mask of CLRSCDF field.
	DFSDM_FLT_ICR_CLRSCDF_Msk = 0xff000000
	// Position of CLRCKABF field.
	DFSDM_FLT_ICR_CLRCKABF_Pos = 0x10
	// Bit mask of CLRCKABF field.
	DFSDM_FLT_ICR_CLRCKABF_Msk = 0xff0000
	// Position of CLRROVRF field.
	DFSDM_FLT_ICR_CLRROVRF_Pos = 0x3
	// Bit mask of CLRROVRF field.
	DFSDM_FLT_ICR_CLRROVRF_Msk = 0x8
	// Bit CLRROVRF.
	DFSDM_FLT_ICR_CLRROVRF = 0x8
	// Position of CLRJOVRF field.
	DFSDM_FLT_ICR_CLRJOVRF_Pos = 0x2
	// Bit mask of CLRJOVRF field.
	DFSDM_FLT_ICR_CLRJOVRF_Msk = 0x4
	// Bit CLRJOVRF.
	DFSDM_FLT_ICR_CLRJOVRF = 0x4

	// FLT.JCHGR: injected channel group selection register
	// Position of JCHG field.
	DFSDM_FLT_JCHGR_JCHG_Pos = 0x0
	// Bit mask of JCHG field.
	DFSDM_FLT_JCHGR_JCHG_Msk = 0xff

	// FLT.FCR: filter control register
	// Position of FORD field.
	DFSDM_FLT_FCR_FORD_Pos = 0x1d
	// Bit mask of FORD field.
	DFSDM_FLT_FCR_FORD_Msk = 0xe0000000
	// Position of FOSR field.
	DFSDM_FLT_FCR_FOSR_Pos = 0x10
	// Bit mask of FOSR field.
	DFSDM_FLT_FCR_FOSR_Msk = 0x3ff0000
	// Position of IOSR field.
	DFSDM_FLT_FCR_IOSR_Pos = 0x0
	// Bit mask of IOSR field.
	DFSDM_FLT_FCR_IOSR_Msk = 0xff

	// FLT.JDATAR: data register for injected group
	// Position of JDATA field.
	DFSDM_FLT_JDATAR_JDATA_Pos = 0x8
	// Bit mask of JDATA field.
	DFSDM_FLT_JDATAR_JDATA_Msk = 0xffffff00
	// Position of JDATACH field.
	DFSDM_FLT_JDATAR_JDATACH_Pos = 0x0
	// Bit mask of JDATACH field.
	DFSDM_FLT_JDATAR_JDATACH_Msk = 0x7

	// FLT.RDATAR: data register for the regular channel
	// Position of RDATA field.
	DFSDM_FLT_RDATAR_RDATA_Pos = 0x8
	// Bit mask of RDATA field.
	DFSDM_FLT_RDATAR_RDATA_Msk = 0xffffff00
	// Position of RPEND field.
	DFSDM_FLT_RDATAR_RPEND_Pos = 0x4
	// Bit mask of RPEND field.
	DFSDM_FLT_RDATAR_RPEND_Msk = 0x10
	// Bit RPEND.
	DFSDM_FLT_RDATAR_RPEND = 0x10
	// Position of RDATACH field.
	DFSDM_FLT_RDATAR_RDATACH_Pos = 0x0
	// Bit mask of RDATACH field.
	DFSDM_FLT_RDATAR_RDATACH_Msk = 0x7

	// FLT.AWHTR: analog watchdog high threshold register
	// Position of AWHT field.
	DFSDM_FLT_AWHTR_AWHT_Pos = 0x8
	// Bit mask of AWHT field.
	DFSDM_FLT_AWHTR_AWHT_Msk = 0xffffff00
	// Position of BKAWH field.
	DFSDM_FLT_AWHTR_BKAWH_Pos = 0x0
	// Bit mask of BKAWH field.
	DFSDM_FLT_AWHTR_BKAWH_Msk = 0xf

	// FLT.AWLTR: analog watchdog low threshold register
	// Position of AWLT field.
	DFSDM_FLT_AWLTR_AWLT_Pos = 0x8
	// Bit mask of AWLT field.
	DFSDM_FLT_AWLTR_AWLT_Msk = 0xffffff00
	// Position of BKAWL field.
	DFSDM_FLT_AWLTR_BKAWL_Pos = 0x0
	// Bit mask of BKAWL field.
	DFSDM_FLT_AWLTR_BKAWL_Msk = 0xf

	// FLT.AWSR: analog watchdog status register
	// Position of AWHTF field.
	DFSDM_FLT_AWSR_AWHTF_Pos = 0x8
	// Bit mask of AWHTF field.
	DFSDM_FLT_AWSR_AWHTF_Msk = 0xff00
	// Position of AWLTF field.
	DFSDM_FLT_AWSR_AWLTF_Pos = 0x0
	// Bit mask of AWLTF field.
	DFSDM_FLT_AWSR_AWLTF_Msk = 0xff

	// FLT.AWCFR: analog watchdog clear flag register
	// Position of CLRAWHTF field.
	DFSDM_FLT_AWCFR_CLRAWHTF_Pos = 0x8
	// Bit mask of CLRAWHTF field.
	DFSDM_FLT_AWCFR_CLRAWHTF_Msk = 0xff00
	// Position of CLRAWLTF field.
	DFSDM_FLT_AWCFR_CLRAWLTF_Pos = 0x0
	// Bit mask of CLRAWLTF field.
	DFSDM_FLT_AWCFR_CLRAWLTF_Msk = 0xff

	// FLT.EXMAX: Extremes detector maximum register
	// Position of EXMAX field.
	DFSDM_FLT_EXMAX_EXMAX_Pos = 0x8
	// Bit mask of EXMAX field.
	DFSDM_FLT_EXMAX_EXMAX_Msk = 0xffffff00
	// Position of EXMAXCH field.
	DFSDM_FLT_EXMAX_EXMAXCH_Pos = 0x0
	// Bit mask of EXMAXCH field.
	DFSDM_FLT_EXMAX_EXMAXCH_Msk = 0x7

	// FLT.EXMIN: Extremes detector minimum register
	// Position of EXMIN field.
	DFSDM_FLT_EXMIN_EXMIN_Pos = 0x8
	// Bit mask of EXMIN field.
	DFSDM_FLT_EXMIN_EXMIN_Msk = 0xffffff00
	// Position of EXMINCH field.
	DFSDM_FLT_EXMIN_EXMINCH_Pos = 0x0
	// Bit mask of EXMINCH field.
	DFSDM_FLT_EXMIN_EXMINCH_Msk = 0x7

	// FLT.CNVTIMR: conversion timer register
	// Position of CNVCNT field.
	DFSDM_FLT_CNVTIMR_CNVCNT_Pos = 0x4
	// Bit mask of CNVCNT field.
	DFSDM_FLT_CNVTIMR_CNVCNT_Msk = 0xfffffff0

	// DFSDM0_CR2: control register 2
	// Position of AWDCH field.
	DFSDM_DFSDM0_CR2_AWDCH_Pos = 0x10
	// Bit mask of AWDCH field.
	DFSDM_DFSDM0_CR2_AWDCH_Msk = 0xff0000
	// Position of EXCH field.
	DFSDM_DFSDM0_CR2_EXCH_Pos = 0x8
	// Bit mask of EXCH field.
	DFSDM_DFSDM0_CR2_EXCH_Msk = 0xff00
	// Position of CKABIE field.
	DFSDM_DFSDM0_CR2_CKABIE_Pos = 0x6
	// Bit mask of CKABIE field.
	DFSDM_DFSDM0_CR2_CKABIE_Msk = 0x40
	// Bit CKABIE.
	DFSDM_DFSDM0_CR2_CKABIE = 0x40
	// Position of SCDIE field.
	DFSDM_DFSDM0_CR2_SCDIE_Pos = 0x5
	// Bit mask of SCDIE field.
	DFSDM_DFSDM0_CR2_SCDIE_Msk = 0x20
	// Bit SCDIE.
	DFSDM_DFSDM0_CR2_SCDIE = 0x20
	// Position of AWDIE field.
	DFSDM_DFSDM0_CR2_AWDIE_Pos = 0x4
	// Bit mask of AWDIE field.
	DFSDM_DFSDM0_CR2_AWDIE_Msk = 0x10
	// Bit AWDIE.
	DFSDM_DFSDM0_CR2_AWDIE = 0x10
	// Position of ROVRIE field.
	DFSDM_DFSDM0_CR2_ROVRIE_Pos = 0x3
	// Bit mask of ROVRIE field.
	DFSDM_DFSDM0_CR2_ROVRIE_Msk = 0x8
	// Bit ROVRIE.
	DFSDM_DFSDM0_CR2_ROVRIE = 0x8
	// Position of JOVRIE field.
	DFSDM_DFSDM0_CR2_JOVRIE_Pos = 0x2
	// Bit mask of JOVRIE field.
	DFSDM_DFSDM0_CR2_JOVRIE_Msk = 0x4
	// Bit JOVRIE.
	DFSDM_DFSDM0_CR2_JOVRIE = 0x4
	// Position of REOCIE field.
	DFSDM_DFSDM0_CR2_REOCIE_Pos = 0x1
	// Bit mask of REOCIE field.
	DFSDM_DFSDM0_CR2_REOCIE_Msk = 0x2
	// Bit REOCIE.
	DFSDM_DFSDM0_CR2_REOCIE = 0x2
	// Position of JEOCIE field.
	DFSDM_DFSDM0_CR2_JEOCIE_Pos = 0x0
	// Bit mask of JEOCIE field.
	DFSDM_DFSDM0_CR2_JEOCIE_Msk = 0x1
	// Bit JEOCIE.
	DFSDM_DFSDM0_CR2_JEOCIE = 0x1

	// DFSDM1_CR2: control register 2
	// Position of AWDCH field.
	DFSDM_DFSDM1_CR2_AWDCH_Pos = 0x10
	// Bit mask of AWDCH field.
	DFSDM_DFSDM1_CR2_AWDCH_Msk = 0xff0000
	// Position of EXCH field.
	DFSDM_DFSDM1_CR2_EXCH_Pos = 0x8
	// Bit mask of EXCH field.
	DFSDM_DFSDM1_CR2_EXCH_Msk = 0xff00
	// Position of CKABIE field.
	DFSDM_DFSDM1_CR2_CKABIE_Pos = 0x6
	// Bit mask of CKABIE field.
	DFSDM_DFSDM1_CR2_CKABIE_Msk = 0x40
	// Bit CKABIE.
	DFSDM_DFSDM1_CR2_CKABIE = 0x40
	// Position of SCDIE field.
	DFSDM_DFSDM1_CR2_SCDIE_Pos = 0x5
	// Bit mask of SCDIE field.
	DFSDM_DFSDM1_CR2_SCDIE_Msk = 0x20
	// Bit SCDIE.
	DFSDM_DFSDM1_CR2_SCDIE = 0x20
	// Position of AWDIE field.
	DFSDM_DFSDM1_CR2_AWDIE_Pos = 0x4
	// Bit mask of AWDIE field.
	DFSDM_DFSDM1_CR2_AWDIE_Msk = 0x10
	// Bit AWDIE.
	DFSDM_DFSDM1_CR2_AWDIE = 0x10
	// Position of ROVRIE field.
	DFSDM_DFSDM1_CR2_ROVRIE_Pos = 0x3
	// Bit mask of ROVRIE field.
	DFSDM_DFSDM1_CR2_ROVRIE_Msk = 0x8
	// Bit ROVRIE.
	DFSDM_DFSDM1_CR2_ROVRIE = 0x8
	// Position of JOVRIE field.
	DFSDM_DFSDM1_CR2_JOVRIE_Pos = 0x2
	// Bit mask of JOVRIE field.
	DFSDM_DFSDM1_CR2_JOVRIE_Msk = 0x4
	// Bit JOVRIE.
	DFSDM_DFSDM1_CR2_JOVRIE = 0x4
	// Position of REOCIE field.
	DFSDM_DFSDM1_CR2_REOCIE_Pos = 0x1
	// Bit mask of REOCIE field.
	DFSDM_DFSDM1_CR2_REOCIE_Msk = 0x2
	// Bit REOCIE.
	DFSDM_DFSDM1_CR2_REOCIE = 0x2
	// Position of JEOCIE field.
	DFSDM_DFSDM1_CR2_JEOCIE_Pos = 0x0
	// Bit mask of JEOCIE field.
	DFSDM_DFSDM1_CR2_JEOCIE_Msk = 0x1
	// Bit JEOCIE.
	DFSDM_DFSDM1_CR2_JEOCIE = 0x1

	// DFSDM2_CR2: control register 2
	// Position of AWDCH field.
	DFSDM_DFSDM2_CR2_AWDCH_Pos = 0x10
	// Bit mask of AWDCH field.
	DFSDM_DFSDM2_CR2_AWDCH_Msk = 0xff0000
	// Position of EXCH field.
	DFSDM_DFSDM2_CR2_EXCH_Pos = 0x8
	// Bit mask of EXCH field.
	DFSDM_DFSDM2_CR2_EXCH_Msk = 0xff00
	// Position of CKABIE field.
	DFSDM_DFSDM2_CR2_CKABIE_Pos = 0x6
	// Bit mask of CKABIE field.
	DFSDM_DFSDM2_CR2_CKABIE_Msk = 0x40
	// Bit CKABIE.
	DFSDM_DFSDM2_CR2_CKABIE = 0x40
	// Position of SCDIE field.
	DFSDM_DFSDM2_CR2_SCDIE_Pos = 0x5
	// Bit mask of SCDIE field.
	DFSDM_DFSDM2_CR2_SCDIE_Msk = 0x20
	// Bit SCDIE.
	DFSDM_DFSDM2_CR2_SCDIE = 0x20
	// Position of AWDIE field.
	DFSDM_DFSDM2_CR2_AWDIE_Pos = 0x4
	// Bit mask of AWDIE field.
	DFSDM_DFSDM2_CR2_AWDIE_Msk = 0x10
	// Bit AWDIE.
	DFSDM_DFSDM2_CR2_AWDIE = 0x10
	// Position of ROVRIE field.
	DFSDM_DFSDM2_CR2_ROVRIE_Pos = 0x3
	// Bit mask of ROVRIE field.
	DFSDM_DFSDM2_CR2_ROVRIE_Msk = 0x8
	// Bit ROVRIE.
	DFSDM_DFSDM2_CR2_ROVRIE = 0x8
	// Position of JOVRIE field.
	DFSDM_DFSDM2_CR2_JOVRIE_Pos = 0x2
	// Bit mask of JOVRIE field.
	DFSDM_DFSDM2_CR2_JOVRIE_Msk = 0x4
	// Bit JOVRIE.
	DFSDM_DFSDM2_CR2_JOVRIE = 0x4
	// Position of REOCIE field.
	DFSDM_DFSDM2_CR2_REOCIE_Pos = 0x1
	// Bit mask of REOCIE field.
	DFSDM_DFSDM2_CR2_REOCIE_Msk = 0x2
	// Bit REOCIE.
	DFSDM_DFSDM2_CR2_REOCIE = 0x2
	// Position of JEOCIE field.
	DFSDM_DFSDM2_CR2_JEOCIE_Pos = 0x0
	// Bit mask of JEOCIE field.
	DFSDM_DFSDM2_CR2_JEOCIE_Msk = 0x1
	// Bit JEOCIE.
	DFSDM_DFSDM2_CR2_JEOCIE = 0x1

	// DFSDM3_CR2: control register 2
	// Position of AWDCH field.
	DFSDM_DFSDM3_CR2_AWDCH_Pos = 0x10
	// Bit mask of AWDCH field.
	DFSDM_DFSDM3_CR2_AWDCH_Msk = 0xff0000
	// Position of EXCH field.
	DFSDM_DFSDM3_CR2_EXCH_Pos = 0x8
	// Bit mask of EXCH field.
	DFSDM_DFSDM3_CR2_EXCH_Msk = 0xff00
	// Position of CKABIE field.
	DFSDM_DFSDM3_CR2_CKABIE_Pos = 0x6
	// Bit mask of CKABIE field.
	DFSDM_DFSDM3_CR2_CKABIE_Msk = 0x40
	// Bit CKABIE.
	DFSDM_DFSDM3_CR2_CKABIE = 0x40
	// Position of SCDIE field.
	DFSDM_DFSDM3_CR2_SCDIE_Pos = 0x5
	// Bit mask of SCDIE field.
	DFSDM_DFSDM3_CR2_SCDIE_Msk = 0x20
	// Bit SCDIE.
	DFSDM_DFSDM3_CR2_SCDIE = 0x20
	// Position of AWDIE field.
	DFSDM_DFSDM3_CR2_AWDIE_Pos = 0x4
	// Bit mask of AWDIE field.
	DFSDM_DFSDM3_CR2_AWDIE_Msk = 0x10
	// Bit AWDIE.
	DFSDM_DFSDM3_CR2_AWDIE = 0x10
	// Position of ROVRIE field.
	DFSDM_DFSDM3_CR2_ROVRIE_Pos = 0x3
	// Bit mask of ROVRIE field.
	DFSDM_DFSDM3_CR2_ROVRIE_Msk = 0x8
	// Bit ROVRIE.
	DFSDM_DFSDM3_CR2_ROVRIE = 0x8
	// Position of JOVRIE field.
	DFSDM_DFSDM3_CR2_JOVRIE_Pos = 0x2
	// Bit mask of JOVRIE field.
	DFSDM_DFSDM3_CR2_JOVRIE_Msk = 0x4
	// Bit JOVRIE.
	DFSDM_DFSDM3_CR2_JOVRIE = 0x4
	// Position of REOCIE field.
	DFSDM_DFSDM3_CR2_REOCIE_Pos = 0x1
	// Bit mask of REOCIE field.
	DFSDM_DFSDM3_CR2_REOCIE_Msk = 0x2
	// Bit REOCIE.
	DFSDM_DFSDM3_CR2_REOCIE = 0x2
	// Position of JEOCIE field.
	DFSDM_DFSDM3_CR2_JEOCIE_Pos = 0x0
	// Bit mask of JEOCIE field.
	DFSDM_DFSDM3_CR2_JEOCIE_Msk = 0x1
	// Bit JEOCIE.
	DFSDM_DFSDM3_CR2_JEOCIE = 0x1
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of PLLSAI2RDY field.
	RCC_CR_PLLSAI2RDY_Pos = 0x1d
	// Bit mask of PLLSAI2RDY field.
	RCC_CR_PLLSAI2RDY_Msk = 0x20000000
	// Bit PLLSAI2RDY.
	RCC_CR_PLLSAI2RDY = 0x20000000
	// Position of PLLSAI2ON field.
	RCC_CR_PLLSAI2ON_Pos = 0x1c
	// Bit mask of PLLSAI2ON field.
	RCC_CR_PLLSAI2ON_Msk = 0x10000000
	// Bit PLLSAI2ON.
	RCC_CR_PLLSAI2ON = 0x10000000
	// Position of PLLSAI1RDY field.
	RCC_CR_PLLSAI1RDY_Pos = 0x1b
	// Bit mask of PLLSAI1RDY field.
	RCC_CR_PLLSAI1RDY_Msk = 0x8000000
	// Bit PLLSAI1RDY.
	RCC_CR_PLLSAI1RDY = 0x8000000
	// Position of PLLSAI1ON field.
	RCC_CR_PLLSAI1ON_Pos = 0x1a
	// Bit mask of PLLSAI1ON field.
	RCC_CR_PLLSAI1ON_Msk = 0x4000000
	// Bit PLLSAI1ON.
	RCC_CR_PLLSAI1ON = 0x4000000
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Position of HSIASFS field.
	RCC_CR_HSIASFS_Pos = 0xb
	// Bit mask of HSIASFS field.
	RCC_CR_HSIASFS_Msk = 0x800
	// Bit HSIASFS.
	RCC_CR_HSIASFS = 0x800
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0xa
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x400
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x400
	// Position of HSIKERON field.
	RCC_CR_HSIKERON_Pos = 0x9
	// Bit mask of HSIKERON field.
	RCC_CR_HSIKERON_Msk = 0x200
	// Bit HSIKERON.
	RCC_CR_HSIKERON = 0x200
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x8
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x100
	// Bit HSION.
	RCC_CR_HSION = 0x100
	// Position of MSIRANGE field.
	RCC_CR_MSIRANGE_Pos = 0x4
	// Bit mask of MSIRANGE field.
	RCC_CR_MSIRANGE_Msk = 0xf0
	// range 0 around 100 kHz
	RCC_CR_MSIRANGE_Range100K = 0x0
	// range 1 around 200 kHz
	RCC_CR_MSIRANGE_Range200K = 0x1
	// range 2 around 400 kHz
	RCC_CR_MSIRANGE_Range400K = 0x2
	// range 3 around 800 kHz
	RCC_CR_MSIRANGE_Range800K = 0x3
	// range 4 around 1 MHz
	RCC_CR_MSIRANGE_Range1M = 0x4
	// range 5 around 2 MHz
	RCC_CR_MSIRANGE_Range2M = 0x5
	// range 6 around 4 MHz
	RCC_CR_MSIRANGE_Range4M = 0x6
	// range 7 around 8 MHz
	RCC_CR_MSIRANGE_Range8M = 0x7
	// range 8 around 16 MHz
	RCC_CR_MSIRANGE_Range16M = 0x8
	// range 9 around 24 MHz
	RCC_CR_MSIRANGE_Range24M = 0x9
	// range 10 around 32 MHz
	RCC_CR_MSIRANGE_Range32M = 0xa
	// range 11 around 48 MHz
	RCC_CR_MSIRANGE_Range48M = 0xb
	// Position of MSIRGSEL field.
	RCC_CR_MSIRGSEL_Pos = 0x3
	// Bit mask of MSIRGSEL field.
	RCC_CR_MSIRGSEL_Msk = 0x8
	// Bit MSIRGSEL.
	RCC_CR_MSIRGSEL = 0x8
	// Position of MSIPLLEN field.
	RCC_CR_MSIPLLEN_Pos = 0x2
	// Bit mask of MSIPLLEN field.
	RCC_CR_MSIPLLEN_Msk = 0x4
	// Bit MSIPLLEN.
	RCC_CR_MSIPLLEN = 0x4
	// Position of MSIRDY field.
	RCC_CR_MSIRDY_Pos = 0x1
	// Bit mask of MSIRDY field.
	RCC_CR_MSIRDY_Msk = 0x2
	// Bit MSIRDY.
	RCC_CR_MSIRDY = 0x2
	// Position of MSION field.
	RCC_CR_MSION_Pos = 0x0
	// Bit mask of MSION field.
	RCC_CR_MSION_Msk = 0x1
	// Bit MSION.
	RCC_CR_MSION = 0x1

	// ICSCR: Internal clock sources calibration register
	// Position of HSITRIM field.
	RCC_ICSCR_HSITRIM_Pos = 0x18
	// Bit mask of HSITRIM field.
	RCC_ICSCR_HSITRIM_Msk = 0x1f000000
	// Position of HSICAL field.
	RCC_ICSCR_HSICAL_Pos = 0x10
	// Bit mask of HSICAL field.
	RCC_ICSCR_HSICAL_Msk = 0xff0000
	// Position of MSITRIM field.
	RCC_ICSCR_MSITRIM_Pos = 0x8
	// Bit mask of MSITRIM field.
	RCC_ICSCR_MSITRIM_Msk = 0xff00
	// Position of MSICAL field.
	RCC_ICSCR_MSICAL_Pos = 0x0
	// Bit mask of MSICAL field.
	RCC_ICSCR_MSICAL_Msk = 0xff

	// CFGR: Clock configuration register
	// Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Pos = 0x1c
	// Bit mask of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000
	// Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Pos = 0x18
	// Bit mask of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk = 0x7000000
	// Position of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Pos = 0xf
	// Bit mask of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Msk = 0x8000
	// Bit STOPWUCK.
	RCC_CFGR_STOPWUCK = 0x8000
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xb
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0x3800
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0x8
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x700
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3

	// PLLCFGR: PLL configuration register
	// Position of PLLR field.
	RCC_PLLCFGR_PLLR_Pos = 0x19
	// Bit mask of PLLR field.
	RCC_PLLCFGR_PLLR_Msk = 0x6000000
	// Position of PLLREN field.
	RCC_PLLCFGR_PLLREN_Pos = 0x18
	// Bit mask of PLLREN field.
	RCC_PLLCFGR_PLLREN_Msk = 0x1000000
	// Bit PLLREN.
	RCC_PLLCFGR_PLLREN = 0x1000000
	// Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Pos = 0x15
	// Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk = 0x600000
	// Position of PLLQEN field.
	RCC_PLLCFGR_PLLQEN_Pos = 0x14
	// Bit mask of PLLQEN field.
	RCC_PLLCFGR_PLLQEN_Msk = 0x100000
	// Bit PLLQEN.
	RCC_PLLCFGR_PLLQEN = 0x100000
	// Position of PLLP field.
	RCC_PLLCFGR_PLLP_Pos = 0x11
	// Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP_Msk = 0x20000
	// Bit PLLP.
	RCC_PLLCFGR_PLLP = 0x20000
	// Position of PLLPEN field.
	RCC_PLLCFGR_PLLPEN_Pos = 0x10
	// Bit mask of PLLPEN field.
	RCC_PLLCFGR_PLLPEN_Msk = 0x10000
	// Bit PLLPEN.
	RCC_PLLCFGR_PLLPEN = 0x10000
	// Position of PLLN field.
	RCC_PLLCFGR_PLLN_Pos = 0x8
	// Bit mask of PLLN field.
	RCC_PLLCFGR_PLLN_Msk = 0x7f00
	// Position of PLLM field.
	RCC_PLLCFGR_PLLM_Pos = 0x4
	// Bit mask of PLLM field.
	RCC_PLLCFGR_PLLM_Msk = 0x70
	// Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Pos = 0x0
	// Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x3

	// PLLSAI1CFGR: PLLSAI1 configuration register
	// Position of PLLSAI1R field.
	RCC_PLLSAI1CFGR_PLLSAI1R_Pos = 0x19
	// Bit mask of PLLSAI1R field.
	RCC_PLLSAI1CFGR_PLLSAI1R_Msk = 0x6000000
	// Position of PLLSAI1REN field.
	RCC_PLLSAI1CFGR_PLLSAI1REN_Pos = 0x18
	// Bit mask of PLLSAI1REN field.
	RCC_PLLSAI1CFGR_PLLSAI1REN_Msk = 0x1000000
	// Bit PLLSAI1REN.
	RCC_PLLSAI1CFGR_PLLSAI1REN = 0x1000000
	// Position of PLLSAI1Q field.
	RCC_PLLSAI1CFGR_PLLSAI1Q_Pos = 0x15
	// Bit mask of PLLSAI1Q field.
	RCC_PLLSAI1CFGR_PLLSAI1Q_Msk = 0x600000
	// Position of PLLSAI1QEN field.
	RCC_PLLSAI1CFGR_PLLSAI1QEN_Pos = 0x14
	// Bit mask of PLLSAI1QEN field.
	RCC_PLLSAI1CFGR_PLLSAI1QEN_Msk = 0x100000
	// Bit PLLSAI1QEN.
	RCC_PLLSAI1CFGR_PLLSAI1QEN = 0x100000
	// Position of PLLSAI1P field.
	RCC_PLLSAI1CFGR_PLLSAI1P_Pos = 0x11
	// Bit mask of PLLSAI1P field.
	RCC_PLLSAI1CFGR_PLLSAI1P_Msk = 0x20000
	// Bit PLLSAI1P.
	RCC_PLLSAI1CFGR_PLLSAI1P = 0x20000
	// Position of PLLSAI1PEN field.
	RCC_PLLSAI1CFGR_PLLSAI1PEN_Pos = 0x10
	// Bit mask of PLLSAI1PEN field.
	RCC_PLLSAI1CFGR_PLLSAI1PEN_Msk = 0x10000
	// Bit PLLSAI1PEN.
	RCC_PLLSAI1CFGR_PLLSAI1PEN = 0x10000
	// Position of PLLSAI1N field.
	RCC_PLLSAI1CFGR_PLLSAI1N_Pos = 0x8
	// Bit mask of PLLSAI1N field.
	RCC_PLLSAI1CFGR_PLLSAI1N_Msk = 0x7f00

	// PLLSAI2CFGR: PLLSAI2 configuration register
	// Position of PLLSAI2R field.
	RCC_PLLSAI2CFGR_PLLSAI2R_Pos = 0x19
	// Bit mask of PLLSAI2R field.
	RCC_PLLSAI2CFGR_PLLSAI2R_Msk = 0x6000000
	// Position of PLLSAI2REN field.
	RCC_PLLSAI2CFGR_PLLSAI2REN_Pos = 0x18
	// Bit mask of PLLSAI2REN field.
	RCC_PLLSAI2CFGR_PLLSAI2REN_Msk = 0x1000000
	// Bit PLLSAI2REN.
	RCC_PLLSAI2CFGR_PLLSAI2REN = 0x1000000
	// Position of PLLSAI2P field.
	RCC_PLLSAI2CFGR_PLLSAI2P_Pos = 0x11
	// Bit mask of PLLSAI2P field.
	RCC_PLLSAI2CFGR_PLLSAI2P_Msk = 0x20000
	// Bit PLLSAI2P.
	RCC_PLLSAI2CFGR_PLLSAI2P = 0x20000
	// Position of PLLSAI2PEN field.
	RCC_PLLSAI2CFGR_PLLSAI2PEN_Pos = 0x10
	// Bit mask of PLLSAI2PEN field.
	RCC_PLLSAI2CFGR_PLLSAI2PEN_Msk = 0x10000
	// Bit PLLSAI2PEN.
	RCC_PLLSAI2CFGR_PLLSAI2PEN = 0x10000
	// Position of PLLSAI2N field.
	RCC_PLLSAI2CFGR_PLLSAI2N_Pos = 0x8
	// Bit mask of PLLSAI2N field.
	RCC_PLLSAI2CFGR_PLLSAI2N_Msk = 0x7f00

	// CIER: Clock interrupt enable register
	// Position of LSECSSIE field.
	RCC_CIER_LSECSSIE_Pos = 0x9
	// Bit mask of LSECSSIE field.
	RCC_CIER_LSECSSIE_Msk = 0x200
	// Bit LSECSSIE.
	RCC_CIER_LSECSSIE = 0x200
	// Position of PLLSAI2RDYIE field.
	RCC_CIER_PLLSAI2RDYIE_Pos = 0x7
	// Bit mask of PLLSAI2RDYIE field.
	RCC_CIER_PLLSAI2RDYIE_Msk = 0x80
	// Bit PLLSAI2RDYIE.
	RCC_CIER_PLLSAI2RDYIE = 0x80
	// Position of PLLSAI1RDYIE field.
	RCC_CIER_PLLSAI1RDYIE_Pos = 0x6
	// Bit mask of PLLSAI1RDYIE field.
	RCC_CIER_PLLSAI1RDYIE_Msk = 0x40
	// Bit PLLSAI1RDYIE.
	RCC_CIER_PLLSAI1RDYIE = 0x40
	// Position of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Pos = 0x5
	// Bit mask of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Msk = 0x20
	// Bit PLLRDYIE.
	RCC_CIER_PLLRDYIE = 0x20
	// Position of HSERDYIE field.
	RCC_CIER_HSERDYIE_Pos = 0x4
	// Bit mask of HSERDYIE field.
	RCC_CIER_HSERDYIE_Msk = 0x10
	// Bit HSERDYIE.
	RCC_CIER_HSERDYIE = 0x10
	// Position of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Pos = 0x3
	// Bit mask of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Msk = 0x8
	// Bit HSIRDYIE.
	RCC_CIER_HSIRDYIE = 0x8
	// Position of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Pos = 0x2
	// Bit mask of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Msk = 0x4
	// Bit MSIRDYIE.
	RCC_CIER_MSIRDYIE = 0x4
	// Position of LSERDYIE field.
	RCC_CIER_LSERDYIE_Pos = 0x1
	// Bit mask of LSERDYIE field.
	RCC_CIER_LSERDYIE_Msk = 0x2
	// Bit LSERDYIE.
	RCC_CIER_LSERDYIE = 0x2
	// Position of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Pos = 0x0
	// Bit mask of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Msk = 0x1
	// Bit LSIRDYIE.
	RCC_CIER_LSIRDYIE = 0x1

	// CIFR: Clock interrupt flag register
	// Position of LSECSSF field.
	RCC_CIFR_LSECSSF_Pos = 0x9
	// Bit mask of LSECSSF field.
	RCC_CIFR_LSECSSF_Msk = 0x200
	// Bit LSECSSF.
	RCC_CIFR_LSECSSF = 0x200
	// Position of CSSF field.
	RCC_CIFR_CSSF_Pos = 0x8
	// Bit mask of CSSF field.
	RCC_CIFR_CSSF_Msk = 0x100
	// Bit CSSF.
	RCC_CIFR_CSSF = 0x100
	// Position of PLLSAI2RDYF field.
	RCC_CIFR_PLLSAI2RDYF_Pos = 0x7
	// Bit mask of PLLSAI2RDYF field.
	RCC_CIFR_PLLSAI2RDYF_Msk = 0x80
	// Bit PLLSAI2RDYF.
	RCC_CIFR_PLLSAI2RDYF = 0x80
	// Position of PLLSAI1RDYF field.
	RCC_CIFR_PLLSAI1RDYF_Pos = 0x6
	// Bit mask of PLLSAI1RDYF field.
	RCC_CIFR_PLLSAI1RDYF_Msk = 0x40
	// Bit PLLSAI1RDYF.
	RCC_CIFR_PLLSAI1RDYF = 0x40
	// Position of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Pos = 0x5
	// Bit mask of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Msk = 0x20
	// Bit PLLRDYF.
	RCC_CIFR_PLLRDYF = 0x20
	// Position of HSERDYF field.
	RCC_CIFR_HSERDYF_Pos = 0x4
	// Bit mask of HSERDYF field.
	RCC_CIFR_HSERDYF_Msk = 0x10
	// Bit HSERDYF.
	RCC_CIFR_HSERDYF = 0x10
	// Position of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Pos = 0x3
	// Bit mask of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Msk = 0x8
	// Bit HSIRDYF.
	RCC_CIFR_HSIRDYF = 0x8
	// Position of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Pos = 0x2
	// Bit mask of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Msk = 0x4
	// Bit MSIRDYF.
	RCC_CIFR_MSIRDYF = 0x4
	// Position of LSERDYF field.
	RCC_CIFR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIFR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIFR_LSERDYF = 0x2
	// Position of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIFR_LSIRDYF = 0x1

	// CICR: Clock interrupt clear register
	// Position of LSECSSC field.
	RCC_CICR_LSECSSC_Pos = 0x9
	// Bit mask of LSECSSC field.
	RCC_CICR_LSECSSC_Msk = 0x200
	// Bit LSECSSC.
	RCC_CICR_LSECSSC = 0x200
	// Position of CSSC field.
	RCC_CICR_CSSC_Pos = 0x8
	// Bit mask of CSSC field.
	RCC_CICR_CSSC_Msk = 0x100
	// Bit CSSC.
	RCC_CICR_CSSC = 0x100
	// Position of PLLSAI2RDYC field.
	RCC_CICR_PLLSAI2RDYC_Pos = 0x7
	// Bit mask of PLLSAI2RDYC field.
	RCC_CICR_PLLSAI2RDYC_Msk = 0x80
	// Bit PLLSAI2RDYC.
	RCC_CICR_PLLSAI2RDYC = 0x80
	// Position of PLLSAI1RDYC field.
	RCC_CICR_PLLSAI1RDYC_Pos = 0x6
	// Bit mask of PLLSAI1RDYC field.
	RCC_CICR_PLLSAI1RDYC_Msk = 0x40
	// Bit PLLSAI1RDYC.
	RCC_CICR_PLLSAI1RDYC = 0x40
	// Position of PLLRDYC field.
	RCC_CICR_PLLRDYC_Pos = 0x5
	// Bit mask of PLLRDYC field.
	RCC_CICR_PLLRDYC_Msk = 0x20
	// Bit PLLRDYC.
	RCC_CICR_PLLRDYC = 0x20
	// Position of HSERDYC field.
	RCC_CICR_HSERDYC_Pos = 0x4
	// Bit mask of HSERDYC field.
	RCC_CICR_HSERDYC_Msk = 0x10
	// Bit HSERDYC.
	RCC_CICR_HSERDYC = 0x10
	// Position of HSIRDYC field.
	RCC_CICR_HSIRDYC_Pos = 0x3
	// Bit mask of HSIRDYC field.
	RCC_CICR_HSIRDYC_Msk = 0x8
	// Bit HSIRDYC.
	RCC_CICR_HSIRDYC = 0x8
	// Position of MSIRDYC field.
	RCC_CICR_MSIRDYC_Pos = 0x2
	// Bit mask of MSIRDYC field.
	RCC_CICR_MSIRDYC_Msk = 0x4
	// Bit MSIRDYC.
	RCC_CICR_MSIRDYC = 0x4
	// Position of LSERDYC field.
	RCC_CICR_LSERDYC_Pos = 0x1
	// Bit mask of LSERDYC field.
	RCC_CICR_LSERDYC_Msk = 0x2
	// Bit LSERDYC.
	RCC_CICR_LSERDYC = 0x2
	// Position of LSIRDYC field.
	RCC_CICR_LSIRDYC_Pos = 0x0
	// Bit mask of LSIRDYC field.
	RCC_CICR_LSIRDYC_Msk = 0x1
	// Bit LSIRDYC.
	RCC_CICR_LSIRDYC = 0x1

	// AHB1RSTR: AHB1 peripheral reset register
	// Position of TSCRST field.
	RCC_AHB1RSTR_TSCRST_Pos = 0x10
	// Bit mask of TSCRST field.
	RCC_AHB1RSTR_TSCRST_Msk = 0x10000
	// Bit TSCRST.
	RCC_AHB1RSTR_TSCRST = 0x10000
	// Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Pos = 0xb
	// Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk = 0x800
	// Bit CRCRST.
	RCC_AHB1RSTR_CRCRST = 0x800
	// Position of FLASHRST field.
	RCC_AHB1RSTR_FLASHRST_Pos = 0x8
	// Bit mask of FLASHRST field.
	RCC_AHB1RSTR_FLASHRST_Msk = 0x100
	// Bit FLASHRST.
	RCC_AHB1RSTR_FLASHRST = 0x100
	// Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Pos = 0x1
	// Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk = 0x2
	// Bit DMA2RST.
	RCC_AHB1RSTR_DMA2RST = 0x2
	// Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Pos = 0x0
	// Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk = 0x1
	// Bit DMA1RST.
	RCC_AHB1RSTR_DMA1RST = 0x1

	// AHB2RSTR: AHB2 peripheral reset register
	// Position of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Pos = 0x12
	// Bit mask of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Msk = 0x40000
	// Bit RNGRST.
	RCC_AHB2RSTR_RNGRST = 0x40000
	// Position of AESRST field.
	RCC_AHB2RSTR_AESRST_Pos = 0x10
	// Bit mask of AESRST field.
	RCC_AHB2RSTR_AESRST_Msk = 0x10000
	// Bit AESRST.
	RCC_AHB2RSTR_AESRST = 0x10000
	// Position of ADCRST field.
	RCC_AHB2RSTR_ADCRST_Pos = 0xd
	// Bit mask of ADCRST field.
	RCC_AHB2RSTR_ADCRST_Msk = 0x2000
	// Bit ADCRST.
	RCC_AHB2RSTR_ADCRST = 0x2000
	// Position of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Pos = 0xc
	// Bit mask of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Msk = 0x1000
	// Bit OTGFSRST.
	RCC_AHB2RSTR_OTGFSRST = 0x1000
	// Position of GPIOHRST field.
	RCC_AHB2RSTR_GPIOHRST_Pos = 0x7
	// Bit mask of GPIOHRST field.
	RCC_AHB2RSTR_GPIOHRST_Msk = 0x80
	// Bit GPIOHRST.
	RCC_AHB2RSTR_GPIOHRST = 0x80
	// Position of GPIOGRST field.
	RCC_AHB2RSTR_GPIOGRST_Pos = 0x6
	// Bit mask of GPIOGRST field.
	RCC_AHB2RSTR_GPIOGRST_Msk = 0x40
	// Bit GPIOGRST.
	RCC_AHB2RSTR_GPIOGRST = 0x40
	// Position of GPIOFRST field.
	RCC_AHB2RSTR_GPIOFRST_Pos = 0x5
	// Bit mask of GPIOFRST field.
	RCC_AHB2RSTR_GPIOFRST_Msk = 0x20
	// Bit GPIOFRST.
	RCC_AHB2RSTR_GPIOFRST = 0x20
	// Position of GPIOERST field.
	RCC_AHB2RSTR_GPIOERST_Pos = 0x4
	// Bit mask of GPIOERST field.
	RCC_AHB2RSTR_GPIOERST_Msk = 0x10
	// Bit GPIOERST.
	RCC_AHB2RSTR_GPIOERST = 0x10
	// Position of GPIODRST field.
	RCC_AHB2RSTR_GPIODRST_Pos = 0x3
	// Bit mask of GPIODRST field.
	RCC_AHB2RSTR_GPIODRST_Msk = 0x8
	// Bit GPIODRST.
	RCC_AHB2RSTR_GPIODRST = 0x8
	// Position of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST_Pos = 0x2
	// Bit mask of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST_Msk = 0x4
	// Bit GPIOCRST.
	RCC_AHB2RSTR_GPIOCRST = 0x4
	// Position of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST_Pos = 0x1
	// Bit mask of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST_Msk = 0x2
	// Bit GPIOBRST.
	RCC_AHB2RSTR_GPIOBRST = 0x2
	// Position of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST_Pos = 0x0
	// Bit mask of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST_Msk = 0x1
	// Bit GPIOARST.
	RCC_AHB2RSTR_GPIOARST = 0x1

	// AHB3RSTR: AHB3 peripheral reset register
	// Position of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Pos = 0x8
	// Bit mask of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Msk = 0x100
	// Bit QSPIRST.
	RCC_AHB3RSTR_QSPIRST = 0x100
	// Position of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Pos = 0x0
	// Bit mask of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Msk = 0x1
	// Bit FMCRST.
	RCC_AHB3RSTR_FMCRST = 0x1

	// APB1RSTR1: APB1 peripheral reset register 1
	// Position of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST_Pos = 0x1f
	// Bit mask of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST_Msk = 0x80000000
	// Bit LPTIM1RST.
	RCC_APB1RSTR1_LPTIM1RST = 0x80000000
	// Position of OPAMPRST field.
	RCC_APB1RSTR1_OPAMPRST_Pos = 0x1e
	// Bit mask of OPAMPRST field.
	RCC_APB1RSTR1_OPAMPRST_Msk = 0x40000000
	// Bit OPAMPRST.
	RCC_APB1RSTR1_OPAMPRST = 0x40000000
	// Position of DAC1RST field.
	RCC_APB1RSTR1_DAC1RST_Pos = 0x1d
	// Bit mask of DAC1RST field.
	RCC_APB1RSTR1_DAC1RST_Msk = 0x20000000
	// Bit DAC1RST.
	RCC_APB1RSTR1_DAC1RST = 0x20000000
	// Position of PWRRST field.
	RCC_APB1RSTR1_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR1_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR1_PWRRST = 0x10000000
	// Position of CAN1RST field.
	RCC_APB1RSTR1_CAN1RST_Pos = 0x19
	// Bit mask of CAN1RST field.
	RCC_APB1RSTR1_CAN1RST_Msk = 0x2000000
	// Bit CAN1RST.
	RCC_APB1RSTR1_CAN1RST = 0x2000000
	// Position of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST_Pos = 0x17
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST_Msk = 0x800000
	// Bit I2C3RST.
	RCC_APB1RSTR1_I2C3RST = 0x800000
	// Position of I2C2RST field.
	RCC_APB1RSTR1_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR1_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR1_I2C2RST = 0x400000
	// Position of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR1_I2C1RST = 0x200000
	// Position of UART5RST field.
	RCC_APB1RSTR1_UART5RST_Pos = 0x14
	// Bit mask of UART5RST field.
	RCC_APB1RSTR1_UART5RST_Msk = 0x100000
	// Bit UART5RST.
	RCC_APB1RSTR1_UART5RST = 0x100000
	// Position of UART4RST field.
	RCC_APB1RSTR1_UART4RST_Pos = 0x13
	// Bit mask of UART4RST field.
	RCC_APB1RSTR1_UART4RST_Msk = 0x80000
	// Bit UART4RST.
	RCC_APB1RSTR1_UART4RST = 0x80000
	// Position of USART3RST field.
	RCC_APB1RSTR1_USART3RST_Pos = 0x12
	// Bit mask of USART3RST field.
	RCC_APB1RSTR1_USART3RST_Msk = 0x40000
	// Bit USART3RST.
	RCC_APB1RSTR1_USART3RST = 0x40000
	// Position of USART2RST field.
	RCC_APB1RSTR1_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APB1RSTR1_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APB1RSTR1_USART2RST = 0x20000
	// Position of SPI3RST field.
	RCC_APB1RSTR1_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR1_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR1_SPI3RST = 0x8000
	// Position of SPI2RST field.
	RCC_APB1RSTR1_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR1_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR1_SPI2RST = 0x4000
	// Position of LCDRST field.
	RCC_APB1RSTR1_LCDRST_Pos = 0x9
	// Bit mask of LCDRST field.
	RCC_APB1RSTR1_LCDRST_Msk = 0x200
	// Bit LCDRST.
	RCC_APB1RSTR1_LCDRST = 0x200
	// Position of TIM7RST field.
	RCC_APB1RSTR1_TIM7RST_Pos = 0x5
	// Bit mask of TIM7RST field.
	RCC_APB1RSTR1_TIM7RST_Msk = 0x20
	// Bit TIM7RST.
	RCC_APB1RSTR1_TIM7RST = 0x20
	// Position of TIM6RST field.
	RCC_APB1RSTR1_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR1_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR1_TIM6RST = 0x10
	// Position of TIM5RST field.
	RCC_APB1RSTR1_TIM5RST_Pos = 0x3
	// Bit mask of TIM5RST field.
	RCC_APB1RSTR1_TIM5RST_Msk = 0x8
	// Bit TIM5RST.
	RCC_APB1RSTR1_TIM5RST = 0x8
	// Position of TIM4RST field.
	RCC_APB1RSTR1_TIM4RST_Pos = 0x2
	// Bit mask of TIM4RST field.
	RCC_APB1RSTR1_TIM4RST_Msk = 0x4
	// Bit TIM4RST.
	RCC_APB1RSTR1_TIM4RST = 0x4
	// Position of TIM3RST field.
	RCC_APB1RSTR1_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR1_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR1_TIM3RST = 0x2
	// Position of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR1_TIM2RST = 0x1

	// APB1RSTR2: APB1 peripheral reset register 2
	// Position of LPTIM2RST field.
	RCC_APB1RSTR2_LPTIM2RST_Pos = 0x5
	// Bit mask of LPTIM2RST field.
	RCC_APB1RSTR2_LPTIM2RST_Msk = 0x20
	// Bit LPTIM2RST.
	RCC_APB1RSTR2_LPTIM2RST = 0x20
	// Position of SWPMI1RST field.
	RCC_APB1RSTR2_SWPMI1RST_Pos = 0x2
	// Bit mask of SWPMI1RST field.
	RCC_APB1RSTR2_SWPMI1RST_Msk = 0x4
	// Bit SWPMI1RST.
	RCC_APB1RSTR2_SWPMI1RST = 0x4
	// Position of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST_Pos = 0x0
	// Bit mask of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST_Msk = 0x1
	// Bit LPUART1RST.
	RCC_APB1RSTR2_LPUART1RST = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of DFSDMRST field.
	RCC_APB2RSTR_DFSDMRST_Pos = 0x18
	// Bit mask of DFSDMRST field.
	RCC_APB2RSTR_DFSDMRST_Msk = 0x1000000
	// Bit DFSDMRST.
	RCC_APB2RSTR_DFSDMRST = 0x1000000
	// Position of SAI2RST field.
	RCC_APB2RSTR_SAI2RST_Pos = 0x16
	// Bit mask of SAI2RST field.
	RCC_APB2RSTR_SAI2RST_Msk = 0x400000
	// Bit SAI2RST.
	RCC_APB2RSTR_SAI2RST = 0x400000
	// Position of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Pos = 0x15
	// Bit mask of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Msk = 0x200000
	// Bit SAI1RST.
	RCC_APB2RSTR_SAI1RST = 0x200000
	// Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Pos = 0x12
	// Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk = 0x40000
	// Bit TIM17RST.
	RCC_APB2RSTR_TIM17RST = 0x40000
	// Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Pos = 0x11
	// Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk = 0x20000
	// Bit TIM16RST.
	RCC_APB2RSTR_TIM16RST = 0x20000
	// Position of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Pos = 0x10
	// Bit mask of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Msk = 0x10000
	// Bit TIM15RST.
	RCC_APB2RSTR_TIM15RST = 0x10000
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x4000
	// Position of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Pos = 0xd
	// Bit mask of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Msk = 0x2000
	// Bit TIM8RST.
	RCC_APB2RSTR_TIM8RST = 0x2000
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0xb
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x800
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x800
	// Position of SDMMCRST field.
	RCC_APB2RSTR_SDMMCRST_Pos = 0xa
	// Bit mask of SDMMCRST field.
	RCC_APB2RSTR_SDMMCRST_Msk = 0x400
	// Bit SDMMCRST.
	RCC_APB2RSTR_SDMMCRST = 0x400
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x1

	// AHB1ENR: AHB1 peripheral clock enable register
	// Position of TSCEN field.
	RCC_AHB1ENR_TSCEN_Pos = 0x10
	// Bit mask of TSCEN field.
	RCC_AHB1ENR_TSCEN_Msk = 0x10000
	// Bit TSCEN.
	RCC_AHB1ENR_TSCEN = 0x10000
	// Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Pos = 0xb
	// Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk = 0x800
	// Bit CRCEN.
	RCC_AHB1ENR_CRCEN = 0x800
	// Position of FLASHEN field.
	RCC_AHB1ENR_FLASHEN_Pos = 0x8
	// Bit mask of FLASHEN field.
	RCC_AHB1ENR_FLASHEN_Msk = 0x100
	// Bit FLASHEN.
	RCC_AHB1ENR_FLASHEN = 0x100
	// Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Pos = 0x1
	// Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk = 0x2
	// Bit DMA2EN.
	RCC_AHB1ENR_DMA2EN = 0x2
	// Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Pos = 0x0
	// Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk = 0x1
	// Bit DMA1EN.
	RCC_AHB1ENR_DMA1EN = 0x1

	// AHB2ENR: AHB2 peripheral clock enable register
	// Position of RNGEN field.
	RCC_AHB2ENR_RNGEN_Pos = 0x12
	// Bit mask of RNGEN field.
	RCC_AHB2ENR_RNGEN_Msk = 0x40000
	// Bit RNGEN.
	RCC_AHB2ENR_RNGEN = 0x40000
	// Position of AESEN field.
	RCC_AHB2ENR_AESEN_Pos = 0x10
	// Bit mask of AESEN field.
	RCC_AHB2ENR_AESEN_Msk = 0x10000
	// Bit AESEN.
	RCC_AHB2ENR_AESEN = 0x10000
	// Position of ADCEN field.
	RCC_AHB2ENR_ADCEN_Pos = 0xd
	// Bit mask of ADCEN field.
	RCC_AHB2ENR_ADCEN_Msk = 0x2000
	// Bit ADCEN.
	RCC_AHB2ENR_ADCEN = 0x2000
	// Position of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Pos = 0xc
	// Bit mask of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Msk = 0x1000
	// Bit OTGFSEN.
	RCC_AHB2ENR_OTGFSEN = 0x1000
	// Position of GPIOHEN field.
	RCC_AHB2ENR_GPIOHEN_Pos = 0x7
	// Bit mask of GPIOHEN field.
	RCC_AHB2ENR_GPIOHEN_Msk = 0x80
	// Bit GPIOHEN.
	RCC_AHB2ENR_GPIOHEN = 0x80
	// Position of GPIOGEN field.
	RCC_AHB2ENR_GPIOGEN_Pos = 0x6
	// Bit mask of GPIOGEN field.
	RCC_AHB2ENR_GPIOGEN_Msk = 0x40
	// Bit GPIOGEN.
	RCC_AHB2ENR_GPIOGEN = 0x40
	// Position of GPIOFEN field.
	RCC_AHB2ENR_GPIOFEN_Pos = 0x5
	// Bit mask of GPIOFEN field.
	RCC_AHB2ENR_GPIOFEN_Msk = 0x20
	// Bit GPIOFEN.
	RCC_AHB2ENR_GPIOFEN = 0x20
	// Position of GPIOEEN field.
	RCC_AHB2ENR_GPIOEEN_Pos = 0x4
	// Bit mask of GPIOEEN field.
	RCC_AHB2ENR_GPIOEEN_Msk = 0x10
	// Bit GPIOEEN.
	RCC_AHB2ENR_GPIOEEN = 0x10
	// Position of GPIODEN field.
	RCC_AHB2ENR_GPIODEN_Pos = 0x3
	// Bit mask of GPIODEN field.
	RCC_AHB2ENR_GPIODEN_Msk = 0x8
	// Bit GPIODEN.
	RCC_AHB2ENR_GPIODEN = 0x8
	// Position of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_AHB2ENR_GPIOCEN = 0x4
	// Position of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_AHB2ENR_GPIOBEN = 0x2
	// Position of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_AHB2ENR_GPIOAEN = 0x1

	// AHB3ENR: AHB3 peripheral clock enable register
	// Position of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Pos = 0x8
	// Bit mask of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Msk = 0x100
	// Bit QSPIEN.
	RCC_AHB3ENR_QSPIEN = 0x100
	// Position of FMCEN field.
	RCC_AHB3ENR_FMCEN_Pos = 0x0
	// Bit mask of FMCEN field.
	RCC_AHB3ENR_FMCEN_Msk = 0x1
	// Bit FMCEN.
	RCC_AHB3ENR_FMCEN = 0x1

	// APB1ENR1: APB1ENR1
	// Position of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN_Pos = 0x1f
	// Bit mask of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN_Msk = 0x80000000
	// Bit LPTIM1EN.
	RCC_APB1ENR1_LPTIM1EN = 0x80000000
	// Position of OPAMPEN field.
	RCC_APB1ENR1_OPAMPEN_Pos = 0x1e
	// Bit mask of OPAMPEN field.
	RCC_APB1ENR1_OPAMPEN_Msk = 0x40000000
	// Bit OPAMPEN.
	RCC_APB1ENR1_OPAMPEN = 0x40000000
	// Position of DAC1EN field.
	RCC_APB1ENR1_DAC1EN_Pos = 0x1d
	// Bit mask of DAC1EN field.
	RCC_APB1ENR1_DAC1EN_Msk = 0x20000000
	// Bit DAC1EN.
	RCC_APB1ENR1_DAC1EN = 0x20000000
	// Position of PWREN field.
	RCC_APB1ENR1_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR1_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR1_PWREN = 0x10000000
	// Position of CAN1EN field.
	RCC_APB1ENR1_CAN1EN_Pos = 0x19
	// Bit mask of CAN1EN field.
	RCC_APB1ENR1_CAN1EN_Msk = 0x2000000
	// Bit CAN1EN.
	RCC_APB1ENR1_CAN1EN = 0x2000000
	// Position of I2C3EN field.
	RCC_APB1ENR1_I2C3EN_Pos = 0x17
	// Bit mask of I2C3EN field.
	RCC_APB1ENR1_I2C3EN_Msk = 0x800000
	// Bit I2C3EN.
	RCC_APB1ENR1_I2C3EN = 0x800000
	// Position of I2C2EN field.
	RCC_APB1ENR1_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR1_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR1_I2C2EN = 0x400000
	// Position of I2C1EN field.
	RCC_APB1ENR1_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR1_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR1_I2C1EN = 0x200000
	// Position of UART5EN field.
	RCC_APB1ENR1_UART5EN_Pos = 0x14
	// Bit mask of UART5EN field.
	RCC_APB1ENR1_UART5EN_Msk = 0x100000
	// Bit UART5EN.
	RCC_APB1ENR1_UART5EN = 0x100000
	// Position of UART4EN field.
	RCC_APB1ENR1_UART4EN_Pos = 0x13
	// Bit mask of UART4EN field.
	RCC_APB1ENR1_UART4EN_Msk = 0x80000
	// Bit UART4EN.
	RCC_APB1ENR1_UART4EN = 0x80000
	// Position of USART3EN field.
	RCC_APB1ENR1_USART3EN_Pos = 0x12
	// Bit mask of USART3EN field.
	RCC_APB1ENR1_USART3EN_Msk = 0x40000
	// Bit USART3EN.
	RCC_APB1ENR1_USART3EN = 0x40000
	// Position of USART2EN field.
	RCC_APB1ENR1_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR1_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR1_USART2EN = 0x20000
	// Position of SPI3EN field.
	RCC_APB1ENR1_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR1_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR1_SPI3EN = 0x8000
	// Position of SPI2EN field.
	RCC_APB1ENR1_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR1_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR1_SPI2EN = 0x4000
	// Position of WWDGEN field.
	RCC_APB1ENR1_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR1_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR1_WWDGEN = 0x800
	// Position of LCDEN field.
	RCC_APB1ENR1_LCDEN_Pos = 0x9
	// Bit mask of LCDEN field.
	RCC_APB1ENR1_LCDEN_Msk = 0x200
	// Bit LCDEN.
	RCC_APB1ENR1_LCDEN = 0x200
	// Position of TIM7EN field.
	RCC_APB1ENR1_TIM7EN_Pos = 0x5
	// Bit mask of TIM7EN field.
	RCC_APB1ENR1_TIM7EN_Msk = 0x20
	// Bit TIM7EN.
	RCC_APB1ENR1_TIM7EN = 0x20
	// Position of TIM6EN field.
	RCC_APB1ENR1_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR1_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR1_TIM6EN = 0x10
	// Position of TIM5EN field.
	RCC_APB1ENR1_TIM5EN_Pos = 0x3
	// Bit mask of TIM5EN field.
	RCC_APB1ENR1_TIM5EN_Msk = 0x8
	// Bit TIM5EN.
	RCC_APB1ENR1_TIM5EN = 0x8
	// Position of TIM4EN field.
	RCC_APB1ENR1_TIM4EN_Pos = 0x2
	// Bit mask of TIM4EN field.
	RCC_APB1ENR1_TIM4EN_Msk = 0x4
	// Bit TIM4EN.
	RCC_APB1ENR1_TIM4EN = 0x4
	// Position of TIM3EN field.
	RCC_APB1ENR1_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR1_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR1_TIM3EN = 0x2
	// Position of TIM2EN field.
	RCC_APB1ENR1_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR1_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR1_TIM2EN = 0x1
	// Position of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN_Pos = 0xa
	// Bit mask of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN_Msk = 0x400
	// Bit RTCAPBEN.
	RCC_APB1ENR1_RTCAPBEN = 0x400

	// APB1ENR2: APB1 peripheral clock enable register 2
	// Position of LPTIM2EN field.
	RCC_APB1ENR2_LPTIM2EN_Pos = 0x5
	// Bit mask of LPTIM2EN field.
	RCC_APB1ENR2_LPTIM2EN_Msk = 0x20
	// Bit LPTIM2EN.
	RCC_APB1ENR2_LPTIM2EN = 0x20
	// Position of SWPMI1EN field.
	RCC_APB1ENR2_SWPMI1EN_Pos = 0x2
	// Bit mask of SWPMI1EN field.
	RCC_APB1ENR2_SWPMI1EN_Msk = 0x4
	// Bit SWPMI1EN.
	RCC_APB1ENR2_SWPMI1EN = 0x4
	// Position of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN_Pos = 0x0
	// Bit mask of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN_Msk = 0x1
	// Bit LPUART1EN.
	RCC_APB1ENR2_LPUART1EN = 0x1

	// APB2ENR: APB2ENR
	// Position of DFSDMEN field.
	RCC_APB2ENR_DFSDMEN_Pos = 0x18
	// Bit mask of DFSDMEN field.
	RCC_APB2ENR_DFSDMEN_Msk = 0x1000000
	// Bit DFSDMEN.
	RCC_APB2ENR_DFSDMEN = 0x1000000
	// Position of SAI2EN field.
	RCC_APB2ENR_SAI2EN_Pos = 0x16
	// Bit mask of SAI2EN field.
	RCC_APB2ENR_SAI2EN_Msk = 0x400000
	// Bit SAI2EN.
	RCC_APB2ENR_SAI2EN = 0x400000
	// Position of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Pos = 0x15
	// Bit mask of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Msk = 0x200000
	// Bit SAI1EN.
	RCC_APB2ENR_SAI1EN = 0x200000
	// Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_APB2ENR_TIM17EN = 0x40000
	// Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_APB2ENR_TIM16EN = 0x20000
	// Position of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Pos = 0x10
	// Bit mask of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Msk = 0x10000
	// Bit TIM15EN.
	RCC_APB2ENR_TIM15EN = 0x10000
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x4000
	// Position of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Pos = 0xd
	// Bit mask of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Msk = 0x2000
	// Bit TIM8EN.
	RCC_APB2ENR_TIM8EN = 0x2000
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x800
	// Position of SDMMCEN field.
	RCC_APB2ENR_SDMMCEN_Pos = 0xa
	// Bit mask of SDMMCEN field.
	RCC_APB2ENR_SDMMCEN_Msk = 0x400
	// Bit SDMMCEN.
	RCC_APB2ENR_SDMMCEN = 0x400
	// Position of FIREWALLEN field.
	RCC_APB2ENR_FIREWALLEN_Pos = 0x7
	// Bit mask of FIREWALLEN field.
	RCC_APB2ENR_FIREWALLEN_Msk = 0x80
	// Bit FIREWALLEN.
	RCC_APB2ENR_FIREWALLEN = 0x80
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x1

	// AHB1SMENR: AHB1 peripheral clocks enable in Sleep and Stop modes register
	// Position of TSCSMEN field.
	RCC_AHB1SMENR_TSCSMEN_Pos = 0x10
	// Bit mask of TSCSMEN field.
	RCC_AHB1SMENR_TSCSMEN_Msk = 0x10000
	// Bit TSCSMEN.
	RCC_AHB1SMENR_TSCSMEN = 0x10000
	// Position of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN_Pos = 0xb
	// Bit mask of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN_Msk = 0x800
	// Bit CRCSMEN.
	RCC_AHB1SMENR_CRCSMEN = 0x800
	// Position of SRAM1SMEN field.
	RCC_AHB1SMENR_SRAM1SMEN_Pos = 0x9
	// Bit mask of SRAM1SMEN field.
	RCC_AHB1SMENR_SRAM1SMEN_Msk = 0x200
	// Bit SRAM1SMEN.
	RCC_AHB1SMENR_SRAM1SMEN = 0x200
	// Position of FLASHSMEN field.
	RCC_AHB1SMENR_FLASHSMEN_Pos = 0x8
	// Bit mask of FLASHSMEN field.
	RCC_AHB1SMENR_FLASHSMEN_Msk = 0x100
	// Bit FLASHSMEN.
	RCC_AHB1SMENR_FLASHSMEN = 0x100
	// Position of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN_Pos = 0x1
	// Bit mask of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN_Msk = 0x2
	// Bit DMA2SMEN.
	RCC_AHB1SMENR_DMA2SMEN = 0x2
	// Position of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN_Pos = 0x0
	// Bit mask of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN_Msk = 0x1
	// Bit DMA1SMEN.
	RCC_AHB1SMENR_DMA1SMEN = 0x1

	// AHB2SMENR: AHB2 peripheral clocks enable in Sleep and Stop modes register
	// Position of RNGSMEN field.
	RCC_AHB2SMENR_RNGSMEN_Pos = 0x12
	// Bit mask of RNGSMEN field.
	RCC_AHB2SMENR_RNGSMEN_Msk = 0x40000
	// Bit RNGSMEN.
	RCC_AHB2SMENR_RNGSMEN = 0x40000
	// Position of AESSMEN field.
	RCC_AHB2SMENR_AESSMEN_Pos = 0x10
	// Bit mask of AESSMEN field.
	RCC_AHB2SMENR_AESSMEN_Msk = 0x10000
	// Bit AESSMEN.
	RCC_AHB2SMENR_AESSMEN = 0x10000
	// Position of ADCFSSMEN field.
	RCC_AHB2SMENR_ADCFSSMEN_Pos = 0xd
	// Bit mask of ADCFSSMEN field.
	RCC_AHB2SMENR_ADCFSSMEN_Msk = 0x2000
	// Bit ADCFSSMEN.
	RCC_AHB2SMENR_ADCFSSMEN = 0x2000
	// Position of OTGFSSMEN field.
	RCC_AHB2SMENR_OTGFSSMEN_Pos = 0xc
	// Bit mask of OTGFSSMEN field.
	RCC_AHB2SMENR_OTGFSSMEN_Msk = 0x1000
	// Bit OTGFSSMEN.
	RCC_AHB2SMENR_OTGFSSMEN = 0x1000
	// Position of SRAM2SMEN field.
	RCC_AHB2SMENR_SRAM2SMEN_Pos = 0x9
	// Bit mask of SRAM2SMEN field.
	RCC_AHB2SMENR_SRAM2SMEN_Msk = 0x200
	// Bit SRAM2SMEN.
	RCC_AHB2SMENR_SRAM2SMEN = 0x200
	// Position of GPIOHSMEN field.
	RCC_AHB2SMENR_GPIOHSMEN_Pos = 0x7
	// Bit mask of GPIOHSMEN field.
	RCC_AHB2SMENR_GPIOHSMEN_Msk = 0x80
	// Bit GPIOHSMEN.
	RCC_AHB2SMENR_GPIOHSMEN = 0x80
	// Position of GPIOGSMEN field.
	RCC_AHB2SMENR_GPIOGSMEN_Pos = 0x6
	// Bit mask of GPIOGSMEN field.
	RCC_AHB2SMENR_GPIOGSMEN_Msk = 0x40
	// Bit GPIOGSMEN.
	RCC_AHB2SMENR_GPIOGSMEN = 0x40
	// Position of GPIOFSMEN field.
	RCC_AHB2SMENR_GPIOFSMEN_Pos = 0x5
	// Bit mask of GPIOFSMEN field.
	RCC_AHB2SMENR_GPIOFSMEN_Msk = 0x20
	// Bit GPIOFSMEN.
	RCC_AHB2SMENR_GPIOFSMEN = 0x20
	// Position of GPIOESMEN field.
	RCC_AHB2SMENR_GPIOESMEN_Pos = 0x4
	// Bit mask of GPIOESMEN field.
	RCC_AHB2SMENR_GPIOESMEN_Msk = 0x10
	// Bit GPIOESMEN.
	RCC_AHB2SMENR_GPIOESMEN = 0x10
	// Position of GPIODSMEN field.
	RCC_AHB2SMENR_GPIODSMEN_Pos = 0x3
	// Bit mask of GPIODSMEN field.
	RCC_AHB2SMENR_GPIODSMEN_Msk = 0x8
	// Bit GPIODSMEN.
	RCC_AHB2SMENR_GPIODSMEN = 0x8
	// Position of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN_Pos = 0x2
	// Bit mask of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN_Msk = 0x4
	// Bit GPIOCSMEN.
	RCC_AHB2SMENR_GPIOCSMEN = 0x4
	// Position of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN_Pos = 0x1
	// Bit mask of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN_Msk = 0x2
	// Bit GPIOBSMEN.
	RCC_AHB2SMENR_GPIOBSMEN = 0x2
	// Position of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN_Pos = 0x0
	// Bit mask of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN_Msk = 0x1
	// Bit GPIOASMEN.
	RCC_AHB2SMENR_GPIOASMEN = 0x1

	// AHB3SMENR: AHB3 peripheral clocks enable in Sleep and Stop modes register
	// Position of QSPISMEN field.
	RCC_AHB3SMENR_QSPISMEN_Pos = 0x8
	// Bit mask of QSPISMEN field.
	RCC_AHB3SMENR_QSPISMEN_Msk = 0x100
	// Bit QSPISMEN.
	RCC_AHB3SMENR_QSPISMEN = 0x100
	// Position of FMCSMEN field.
	RCC_AHB3SMENR_FMCSMEN_Pos = 0x0
	// Bit mask of FMCSMEN field.
	RCC_AHB3SMENR_FMCSMEN_Msk = 0x1
	// Bit FMCSMEN.
	RCC_AHB3SMENR_FMCSMEN = 0x1

	// APB1SMENR1: APB1SMENR1
	// Position of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN_Pos = 0x1f
	// Bit mask of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN_Msk = 0x80000000
	// Bit LPTIM1SMEN.
	RCC_APB1SMENR1_LPTIM1SMEN = 0x80000000
	// Position of OPAMPSMEN field.
	RCC_APB1SMENR1_OPAMPSMEN_Pos = 0x1e
	// Bit mask of OPAMPSMEN field.
	RCC_APB1SMENR1_OPAMPSMEN_Msk = 0x40000000
	// Bit OPAMPSMEN.
	RCC_APB1SMENR1_OPAMPSMEN = 0x40000000
	// Position of DAC1SMEN field.
	RCC_APB1SMENR1_DAC1SMEN_Pos = 0x1d
	// Bit mask of DAC1SMEN field.
	RCC_APB1SMENR1_DAC1SMEN_Msk = 0x20000000
	// Bit DAC1SMEN.
	RCC_APB1SMENR1_DAC1SMEN = 0x20000000
	// Position of PWRSMEN field.
	RCC_APB1SMENR1_PWRSMEN_Pos = 0x1c
	// Bit mask of PWRSMEN field.
	RCC_APB1SMENR1_PWRSMEN_Msk = 0x10000000
	// Bit PWRSMEN.
	RCC_APB1SMENR1_PWRSMEN = 0x10000000
	// Position of CAN1SMEN field.
	RCC_APB1SMENR1_CAN1SMEN_Pos = 0x19
	// Bit mask of CAN1SMEN field.
	RCC_APB1SMENR1_CAN1SMEN_Msk = 0x2000000
	// Bit CAN1SMEN.
	RCC_APB1SMENR1_CAN1SMEN = 0x2000000
	// Position of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN_Pos = 0x17
	// Bit mask of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN_Msk = 0x800000
	// Bit I2C3SMEN.
	RCC_APB1SMENR1_I2C3SMEN = 0x800000
	// Position of I2C2SMEN field.
	RCC_APB1SMENR1_I2C2SMEN_Pos = 0x16
	// Bit mask of I2C2SMEN field.
	RCC_APB1SMENR1_I2C2SMEN_Msk = 0x400000
	// Bit I2C2SMEN.
	RCC_APB1SMENR1_I2C2SMEN = 0x400000
	// Position of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN_Pos = 0x15
	// Bit mask of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN_Msk = 0x200000
	// Bit I2C1SMEN.
	RCC_APB1SMENR1_I2C1SMEN = 0x200000
	// Position of UART5SMEN field.
	RCC_APB1SMENR1_UART5SMEN_Pos = 0x14
	// Bit mask of UART5SMEN field.
	RCC_APB1SMENR1_UART5SMEN_Msk = 0x100000
	// Bit UART5SMEN.
	RCC_APB1SMENR1_UART5SMEN = 0x100000
	// Position of UART4SMEN field.
	RCC_APB1SMENR1_UART4SMEN_Pos = 0x13
	// Bit mask of UART4SMEN field.
	RCC_APB1SMENR1_UART4SMEN_Msk = 0x80000
	// Bit UART4SMEN.
	RCC_APB1SMENR1_UART4SMEN = 0x80000
	// Position of USART3SMEN field.
	RCC_APB1SMENR1_USART3SMEN_Pos = 0x12
	// Bit mask of USART3SMEN field.
	RCC_APB1SMENR1_USART3SMEN_Msk = 0x40000
	// Bit USART3SMEN.
	RCC_APB1SMENR1_USART3SMEN = 0x40000
	// Position of USART2SMEN field.
	RCC_APB1SMENR1_USART2SMEN_Pos = 0x11
	// Bit mask of USART2SMEN field.
	RCC_APB1SMENR1_USART2SMEN_Msk = 0x20000
	// Bit USART2SMEN.
	RCC_APB1SMENR1_USART2SMEN = 0x20000
	// Position of SP3SMEN field.
	RCC_APB1SMENR1_SP3SMEN_Pos = 0xf
	// Bit mask of SP3SMEN field.
	RCC_APB1SMENR1_SP3SMEN_Msk = 0x8000
	// Bit SP3SMEN.
	RCC_APB1SMENR1_SP3SMEN = 0x8000
	// Position of SPI2SMEN field.
	RCC_APB1SMENR1_SPI2SMEN_Pos = 0xe
	// Bit mask of SPI2SMEN field.
	RCC_APB1SMENR1_SPI2SMEN_Msk = 0x4000
	// Bit SPI2SMEN.
	RCC_APB1SMENR1_SPI2SMEN = 0x4000
	// Position of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN_Pos = 0xb
	// Bit mask of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN_Msk = 0x800
	// Bit WWDGSMEN.
	RCC_APB1SMENR1_WWDGSMEN = 0x800
	// Position of LCDSMEN field.
	RCC_APB1SMENR1_LCDSMEN_Pos = 0x9
	// Bit mask of LCDSMEN field.
	RCC_APB1SMENR1_LCDSMEN_Msk = 0x200
	// Bit LCDSMEN.
	RCC_APB1SMENR1_LCDSMEN = 0x200
	// Position of TIM7SMEN field.
	RCC_APB1SMENR1_TIM7SMEN_Pos = 0x5
	// Bit mask of TIM7SMEN field.
	RCC_APB1SMENR1_TIM7SMEN_Msk = 0x20
	// Bit TIM7SMEN.
	RCC_APB1SMENR1_TIM7SMEN = 0x20
	// Position of TIM6SMEN field.
	RCC_APB1SMENR1_TIM6SMEN_Pos = 0x4
	// Bit mask of TIM6SMEN field.
	RCC_APB1SMENR1_TIM6SMEN_Msk = 0x10
	// Bit TIM6SMEN.
	RCC_APB1SMENR1_TIM6SMEN = 0x10
	// Position of TIM5SMEN field.
	RCC_APB1SMENR1_TIM5SMEN_Pos = 0x3
	// Bit mask of TIM5SMEN field.
	RCC_APB1SMENR1_TIM5SMEN_Msk = 0x8
	// Bit TIM5SMEN.
	RCC_APB1SMENR1_TIM5SMEN = 0x8
	// Position of TIM4SMEN field.
	RCC_APB1SMENR1_TIM4SMEN_Pos = 0x2
	// Bit mask of TIM4SMEN field.
	RCC_APB1SMENR1_TIM4SMEN_Msk = 0x4
	// Bit TIM4SMEN.
	RCC_APB1SMENR1_TIM4SMEN = 0x4
	// Position of TIM3SMEN field.
	RCC_APB1SMENR1_TIM3SMEN_Pos = 0x1
	// Bit mask of TIM3SMEN field.
	RCC_APB1SMENR1_TIM3SMEN_Msk = 0x2
	// Bit TIM3SMEN.
	RCC_APB1SMENR1_TIM3SMEN = 0x2
	// Position of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN_Pos = 0x0
	// Bit mask of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN_Msk = 0x1
	// Bit TIM2SMEN.
	RCC_APB1SMENR1_TIM2SMEN = 0x1
	// Position of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN_Pos = 0xa
	// Bit mask of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN_Msk = 0x400
	// Bit RTCAPBSMEN.
	RCC_APB1SMENR1_RTCAPBSMEN = 0x400

	// APB1SMENR2: APB1 peripheral clocks enable in Sleep and Stop modes register 2
	// Position of LPTIM2SMEN field.
	RCC_APB1SMENR2_LPTIM2SMEN_Pos = 0x5
	// Bit mask of LPTIM2SMEN field.
	RCC_APB1SMENR2_LPTIM2SMEN_Msk = 0x20
	// Bit LPTIM2SMEN.
	RCC_APB1SMENR2_LPTIM2SMEN = 0x20
	// Position of SWPMI1SMEN field.
	RCC_APB1SMENR2_SWPMI1SMEN_Pos = 0x2
	// Bit mask of SWPMI1SMEN field.
	RCC_APB1SMENR2_SWPMI1SMEN_Msk = 0x4
	// Bit SWPMI1SMEN.
	RCC_APB1SMENR2_SWPMI1SMEN = 0x4
	// Position of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN_Pos = 0x0
	// Bit mask of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN_Msk = 0x1
	// Bit LPUART1SMEN.
	RCC_APB1SMENR2_LPUART1SMEN = 0x1

	// APB2SMENR: APB2SMENR
	// Position of DFSDMSMEN field.
	RCC_APB2SMENR_DFSDMSMEN_Pos = 0x18
	// Bit mask of DFSDMSMEN field.
	RCC_APB2SMENR_DFSDMSMEN_Msk = 0x1000000
	// Bit DFSDMSMEN.
	RCC_APB2SMENR_DFSDMSMEN = 0x1000000
	// Position of SAI2SMEN field.
	RCC_APB2SMENR_SAI2SMEN_Pos = 0x16
	// Bit mask of SAI2SMEN field.
	RCC_APB2SMENR_SAI2SMEN_Msk = 0x400000
	// Bit SAI2SMEN.
	RCC_APB2SMENR_SAI2SMEN = 0x400000
	// Position of SAI1SMEN field.
	RCC_APB2SMENR_SAI1SMEN_Pos = 0x15
	// Bit mask of SAI1SMEN field.
	RCC_APB2SMENR_SAI1SMEN_Msk = 0x200000
	// Bit SAI1SMEN.
	RCC_APB2SMENR_SAI1SMEN = 0x200000
	// Position of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN_Pos = 0x12
	// Bit mask of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN_Msk = 0x40000
	// Bit TIM17SMEN.
	RCC_APB2SMENR_TIM17SMEN = 0x40000
	// Position of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN_Pos = 0x11
	// Bit mask of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN_Msk = 0x20000
	// Bit TIM16SMEN.
	RCC_APB2SMENR_TIM16SMEN = 0x20000
	// Position of TIM15SMEN field.
	RCC_APB2SMENR_TIM15SMEN_Pos = 0x10
	// Bit mask of TIM15SMEN field.
	RCC_APB2SMENR_TIM15SMEN_Msk = 0x10000
	// Bit TIM15SMEN.
	RCC_APB2SMENR_TIM15SMEN = 0x10000
	// Position of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Pos = 0xe
	// Bit mask of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Msk = 0x4000
	// Bit USART1SMEN.
	RCC_APB2SMENR_USART1SMEN = 0x4000
	// Position of TIM8SMEN field.
	RCC_APB2SMENR_TIM8SMEN_Pos = 0xd
	// Bit mask of TIM8SMEN field.
	RCC_APB2SMENR_TIM8SMEN_Msk = 0x2000
	// Bit TIM8SMEN.
	RCC_APB2SMENR_TIM8SMEN = 0x2000
	// Position of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Pos = 0xc
	// Bit mask of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Msk = 0x1000
	// Bit SPI1SMEN.
	RCC_APB2SMENR_SPI1SMEN = 0x1000
	// Position of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN_Pos = 0xb
	// Bit mask of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN_Msk = 0x800
	// Bit TIM1SMEN.
	RCC_APB2SMENR_TIM1SMEN = 0x800
	// Position of SDMMCSMEN field.
	RCC_APB2SMENR_SDMMCSMEN_Pos = 0xa
	// Bit mask of SDMMCSMEN field.
	RCC_APB2SMENR_SDMMCSMEN_Msk = 0x400
	// Bit SDMMCSMEN.
	RCC_APB2SMENR_SDMMCSMEN = 0x400
	// Position of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN_Pos = 0x0
	// Bit mask of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN_Msk = 0x1
	// Bit SYSCFGSMEN.
	RCC_APB2SMENR_SYSCFGSMEN = 0x1

	// CCIPR: CCIPR
	// Position of DFSDMSEL field.
	RCC_CCIPR_DFSDMSEL_Pos = 0x1f
	// Bit mask of DFSDMSEL field.
	RCC_CCIPR_DFSDMSEL_Msk = 0x80000000
	// Bit DFSDMSEL.
	RCC_CCIPR_DFSDMSEL = 0x80000000
	// Position of SWPMI1SEL field.
	RCC_CCIPR_SWPMI1SEL_Pos = 0x1e
	// Bit mask of SWPMI1SEL field.
	RCC_CCIPR_SWPMI1SEL_Msk = 0x40000000
	// Bit SWPMI1SEL.
	RCC_CCIPR_SWPMI1SEL = 0x40000000
	// Position of ADCSEL field.
	RCC_CCIPR_ADCSEL_Pos = 0x1c
	// Bit mask of ADCSEL field.
	RCC_CCIPR_ADCSEL_Msk = 0x30000000
	// Position of CLK48SEL field.
	RCC_CCIPR_CLK48SEL_Pos = 0x1a
	// Bit mask of CLK48SEL field.
	RCC_CCIPR_CLK48SEL_Msk = 0xc000000
	// Position of SAI2SEL field.
	RCC_CCIPR_SAI2SEL_Pos = 0x18
	// Bit mask of SAI2SEL field.
	RCC_CCIPR_SAI2SEL_Msk = 0x3000000
	// Position of SAI1SEL field.
	RCC_CCIPR_SAI1SEL_Pos = 0x16
	// Bit mask of SAI1SEL field.
	RCC_CCIPR_SAI1SEL_Msk = 0xc00000
	// Position of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Pos = 0x14
	// Bit mask of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Msk = 0x300000
	// Position of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Pos = 0x12
	// Bit mask of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Msk = 0xc0000
	// Position of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Pos = 0x10
	// Bit mask of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Msk = 0x30000
	// Position of I2C2SEL field.
	RCC_CCIPR_I2C2SEL_Pos = 0xe
	// Bit mask of I2C2SEL field.
	RCC_CCIPR_I2C2SEL_Msk = 0xc000
	// Position of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Pos = 0xc
	// Bit mask of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Msk = 0x3000
	// Position of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Pos = 0xa
	// Bit mask of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Msk = 0xc00
	// Position of UART5SEL field.
	RCC_CCIPR_UART5SEL_Pos = 0x8
	// Bit mask of UART5SEL field.
	RCC_CCIPR_UART5SEL_Msk = 0x300
	// Position of UART4SEL field.
	RCC_CCIPR_UART4SEL_Pos = 0x6
	// Bit mask of UART4SEL field.
	RCC_CCIPR_UART4SEL_Msk = 0xc0
	// Position of USART3SEL field.
	RCC_CCIPR_USART3SEL_Pos = 0x4
	// Bit mask of USART3SEL field.
	RCC_CCIPR_USART3SEL_Msk = 0x30
	// Position of USART2SEL field.
	RCC_CCIPR_USART2SEL_Pos = 0x2
	// Bit mask of USART2SEL field.
	RCC_CCIPR_USART2SEL_Msk = 0xc
	// Position of USART1SEL field.
	RCC_CCIPR_USART1SEL_Pos = 0x0
	// Bit mask of USART1SEL field.
	RCC_CCIPR_USART1SEL_Msk = 0x3

	// BDCR: BDCR
	// Position of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Pos = 0x19
	// Bit mask of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Msk = 0x2000000
	// Bit LSCOSEL.
	RCC_BDCR_LSCOSEL = 0x2000000
	// Position of LSCOEN field.
	RCC_BDCR_LSCOEN_Pos = 0x18
	// Bit mask of LSCOEN field.
	RCC_BDCR_LSCOEN_Msk = 0x1000000
	// Bit LSCOEN.
	RCC_BDCR_LSCOEN = 0x1000000
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// Position of LSECSSD field.
	RCC_BDCR_LSECSSD_Pos = 0x6
	// Bit mask of LSECSSD field.
	RCC_BDCR_LSECSSD_Msk = 0x40
	// Bit LSECSSD.
	RCC_BDCR_LSECSSD = 0x40
	// Position of LSECSSON field.
	RCC_BDCR_LSECSSON_Pos = 0x5
	// Bit mask of LSECSSON field.
	RCC_BDCR_LSECSSON_Msk = 0x20
	// Bit LSECSSON.
	RCC_BDCR_LSECSSON = 0x20
	// Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Pos = 0x3
	// Bit mask of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1

	// CSR: CSR
	// Position of LPWRSTF field.
	RCC_CSR_LPWRSTF_Pos = 0x1f
	// Bit mask of LPWRSTF field.
	RCC_CSR_LPWRSTF_Msk = 0x80000000
	// Bit LPWRSTF.
	RCC_CSR_LPWRSTF = 0x80000000
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// Position of BORRSTF field.
	RCC_CSR_BORRSTF_Pos = 0x1b
	// Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF_Msk = 0x8000000
	// Bit BORRSTF.
	RCC_CSR_BORRSTF = 0x8000000
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Pos = 0x19
	// Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk = 0x2000000
	// Bit OBLRSTF.
	RCC_CSR_OBLRSTF = 0x2000000
	// Position of FIREWALLRSTF field.
	RCC_CSR_FIREWALLRSTF_Pos = 0x18
	// Bit mask of FIREWALLRSTF field.
	RCC_CSR_FIREWALLRSTF_Msk = 0x1000000
	// Bit FIREWALLRSTF.
	RCC_CSR_FIREWALLRSTF = 0x1000000
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x17
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x800000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x800000
	// Position of MSISRANGE field.
	RCC_CSR_MSISRANGE_Pos = 0x8
	// Bit mask of MSISRANGE field.
	RCC_CSR_MSISRANGE_Msk = 0xf00
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1

	// CRRCR: Clock recovery RC register
	// Position of HSI48CAL field.
	RCC_CRRCR_HSI48CAL_Pos = 0x7
	// Bit mask of HSI48CAL field.
	RCC_CRRCR_HSI48CAL_Msk = 0xff80
	// Position of HSI48RDY field.
	RCC_CRRCR_HSI48RDY_Pos = 0x1
	// Bit mask of HSI48RDY field.
	RCC_CRRCR_HSI48RDY_Msk = 0x2
	// Bit HSI48RDY.
	RCC_CRRCR_HSI48RDY = 0x2
	// Position of HSI48ON field.
	RCC_CRRCR_HSI48ON_Pos = 0x0
	// Bit mask of HSI48ON field.
	RCC_CRRCR_HSI48ON_Msk = 0x1
	// Bit HSI48ON.
	RCC_CRRCR_HSI48ON = 0x1
)

// Bitfields for DBGMCU: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	// Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xffff
	// Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Debug MCU Configuration Register
	// Position of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBGMCU_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBGMCU_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBGMCU_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBGMCU_CR_TRACE_IOEN = 0x20
	// Position of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Pos = 0x6
	// Bit mask of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Msk = 0xc0

	// APB1_FZR1: APB Low Freeze Register 1
	// Position of DBG_TIMER2_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIMER2_STOP_Pos = 0x0
	// Bit mask of DBG_TIMER2_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIMER2_STOP_Msk = 0x1
	// Bit DBG_TIMER2_STOP.
	DBGMCU_APB1_FZR1_DBG_TIMER2_STOP = 0x1
	// Position of DBG_TIM3_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBGMCU_APB1_FZR1_DBG_TIM3_STOP = 0x2
	// Position of DBG_TIM4_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM4_STOP_Pos = 0x2
	// Bit mask of DBG_TIM4_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM4_STOP_Msk = 0x4
	// Bit DBG_TIM4_STOP.
	DBGMCU_APB1_FZR1_DBG_TIM4_STOP = 0x4
	// Position of DBG_TIM5_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM5_STOP_Pos = 0x3
	// Bit mask of DBG_TIM5_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM5_STOP_Msk = 0x8
	// Bit DBG_TIM5_STOP.
	DBGMCU_APB1_FZR1_DBG_TIM5_STOP = 0x8
	// Position of DBG_TIMER6_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIMER6_STOP_Pos = 0x4
	// Bit mask of DBG_TIMER6_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIMER6_STOP_Msk = 0x10
	// Bit DBG_TIMER6_STOP.
	DBGMCU_APB1_FZR1_DBG_TIMER6_STOP = 0x10
	// Position of DBG_TIM7_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM7_STOP_Pos = 0x5
	// Bit mask of DBG_TIM7_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM7_STOP_Msk = 0x20
	// Bit DBG_TIM7_STOP.
	DBGMCU_APB1_FZR1_DBG_TIM7_STOP = 0x20
	// Position of DBG_RTC_STOP field.
	DBGMCU_APB1_FZR1_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBGMCU_APB1_FZR1_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBGMCU_APB1_FZR1_DBG_RTC_STOP = 0x400
	// Position of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZR1_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZR1_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBGMCU_APB1_FZR1_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZR1_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZR1_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBGMCU_APB1_FZR1_DBG_IWDG_STOP = 0x1000
	// Position of DBG_I2C1_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C1_STOP_Pos = 0x15
	// Bit mask of DBG_I2C1_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C1_STOP_Msk = 0x200000
	// Bit DBG_I2C1_STOP.
	DBGMCU_APB1_FZR1_DBG_I2C1_STOP = 0x200000
	// Position of DBG_I2C2_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C2_STOP_Pos = 0x16
	// Bit mask of DBG_I2C2_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C2_STOP_Msk = 0x400000
	// Bit DBG_I2C2_STOP.
	DBGMCU_APB1_FZR1_DBG_I2C2_STOP = 0x400000
	// Position of DBG_I2C3_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C3_STOP_Pos = 0x17
	// Bit mask of DBG_I2C3_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C3_STOP_Msk = 0x800000
	// Bit DBG_I2C3_STOP.
	DBGMCU_APB1_FZR1_DBG_I2C3_STOP = 0x800000
	// Position of DBG_CAN_STOP field.
	DBGMCU_APB1_FZR1_DBG_CAN_STOP_Pos = 0x19
	// Bit mask of DBG_CAN_STOP field.
	DBGMCU_APB1_FZR1_DBG_CAN_STOP_Msk = 0x2000000
	// Bit DBG_CAN_STOP.
	DBGMCU_APB1_FZR1_DBG_CAN_STOP = 0x2000000
	// Position of DBG_LPTIMER_STOP field.
	DBGMCU_APB1_FZR1_DBG_LPTIMER_STOP_Pos = 0x1f
	// Bit mask of DBG_LPTIMER_STOP field.
	DBGMCU_APB1_FZR1_DBG_LPTIMER_STOP_Msk = 0x80000000
	// Bit DBG_LPTIMER_STOP.
	DBGMCU_APB1_FZR1_DBG_LPTIMER_STOP = 0x80000000

	// APB1_FZR2: APB Low Freeze Register 2
	// Position of DBG_LPTIM2_STOP field.
	DBGMCU_APB1_FZR2_DBG_LPTIM2_STOP_Pos = 0x5
	// Bit mask of DBG_LPTIM2_STOP field.
	DBGMCU_APB1_FZR2_DBG_LPTIM2_STOP_Msk = 0x20
	// Bit DBG_LPTIM2_STOP.
	DBGMCU_APB1_FZR2_DBG_LPTIM2_STOP = 0x20

	// APB2_FZR: APB High Freeze Register
	// Position of DBG_TIM1_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM1_STOP_Pos = 0xb
	// Bit mask of DBG_TIM1_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM1_STOP_Msk = 0x800
	// Bit DBG_TIM1_STOP.
	DBGMCU_APB2_FZR_DBG_TIM1_STOP = 0x800
	// Position of DBG_TIM8_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM8_STOP_Pos = 0xd
	// Bit mask of DBG_TIM8_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM8_STOP_Msk = 0x2000
	// Bit DBG_TIM8_STOP.
	DBGMCU_APB2_FZR_DBG_TIM8_STOP = 0x2000
	// Position of DBG_TIM15_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM15_STOP_Pos = 0x10
	// Bit mask of DBG_TIM15_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM15_STOP_Msk = 0x10000
	// Bit DBG_TIM15_STOP.
	DBGMCU_APB2_FZR_DBG_TIM15_STOP = 0x10000
	// Position of DBG_TIM16_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM16_STOP_Pos = 0x11
	// Bit mask of DBG_TIM16_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM16_STOP_Msk = 0x20000
	// Bit DBG_TIM16_STOP.
	DBGMCU_APB2_FZR_DBG_TIM16_STOP = 0x20000
	// Position of DBG_TIM17_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM17_STOP_Pos = 0x12
	// Bit mask of DBG_TIM17_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM17_STOP_Msk = 0x40000
	// Bit DBG_TIM17_STOP.
	DBGMCU_APB2_FZR_DBG_TIM17_STOP = 0x40000
)

// Bitfields for FPU: Floting point unit
const (
	// FPCCR: Floating-point context control register
	// Position of LSPACT field.
	FPU_FPCCR_LSPACT_Pos = 0x0
	// Bit mask of LSPACT field.
	FPU_FPCCR_LSPACT_Msk = 0x1
	// Bit LSPACT.
	FPU_FPCCR_LSPACT = 0x1
	// Position of USER field.
	FPU_FPCCR_USER_Pos = 0x1
	// Bit mask of USER field.
	FPU_FPCCR_USER_Msk = 0x2
	// Bit USER.
	FPU_FPCCR_USER = 0x2
	// Position of THREAD field.
	FPU_FPCCR_THREAD_Pos = 0x3
	// Bit mask of THREAD field.
	FPU_FPCCR_THREAD_Msk = 0x8
	// Bit THREAD.
	FPU_FPCCR_THREAD = 0x8
	// Position of HFRDY field.
	FPU_FPCCR_HFRDY_Pos = 0x4
	// Bit mask of HFRDY field.
	FPU_FPCCR_HFRDY_Msk = 0x10
	// Bit HFRDY.
	FPU_FPCCR_HFRDY = 0x10
	// Position of MMRDY field.
	FPU_FPCCR_MMRDY_Pos = 0x5
	// Bit mask of MMRDY field.
	FPU_FPCCR_MMRDY_Msk = 0x20
	// Bit MMRDY.
	FPU_FPCCR_MMRDY = 0x20
	// Position of BFRDY field.
	FPU_FPCCR_BFRDY_Pos = 0x6
	// Bit mask of BFRDY field.
	FPU_FPCCR_BFRDY_Msk = 0x40
	// Bit BFRDY.
	FPU_FPCCR_BFRDY = 0x40
	// Position of MONRDY field.
	FPU_FPCCR_MONRDY_Pos = 0x8
	// Bit mask of MONRDY field.
	FPU_FPCCR_MONRDY_Msk = 0x100
	// Bit MONRDY.
	FPU_FPCCR_MONRDY = 0x100
	// Position of LSPEN field.
	FPU_FPCCR_LSPEN_Pos = 0x1e
	// Bit mask of LSPEN field.
	FPU_FPCCR_LSPEN_Msk = 0x40000000
	// Bit LSPEN.
	FPU_FPCCR_LSPEN = 0x40000000
	// Position of ASPEN field.
	FPU_FPCCR_ASPEN_Pos = 0x1f
	// Bit mask of ASPEN field.
	FPU_FPCCR_ASPEN_Msk = 0x80000000
	// Bit ASPEN.
	FPU_FPCCR_ASPEN = 0x80000000

	// FPCAR: Floating-point context address register
	// Position of ADDRESS field.
	FPU_FPCAR_ADDRESS_Pos = 0x3
	// Bit mask of ADDRESS field.
	FPU_FPCAR_ADDRESS_Msk = 0xfffffff8

	// FPSCR: Floating-point status control register
	// Position of IOC field.
	FPU_FPSCR_IOC_Pos = 0x0
	// Bit mask of IOC field.
	FPU_FPSCR_IOC_Msk = 0x1
	// Bit IOC.
	FPU_FPSCR_IOC = 0x1
	// Position of DZC field.
	FPU_FPSCR_DZC_Pos = 0x1
	// Bit mask of DZC field.
	FPU_FPSCR_DZC_Msk = 0x2
	// Bit DZC.
	FPU_FPSCR_DZC = 0x2
	// Position of OFC field.
	FPU_FPSCR_OFC_Pos = 0x2
	// Bit mask of OFC field.
	FPU_FPSCR_OFC_Msk = 0x4
	// Bit OFC.
	FPU_FPSCR_OFC = 0x4
	// Position of UFC field.
	FPU_FPSCR_UFC_Pos = 0x3
	// Bit mask of UFC field.
	FPU_FPSCR_UFC_Msk = 0x8
	// Bit UFC.
	FPU_FPSCR_UFC = 0x8
	// Position of IXC field.
	FPU_FPSCR_IXC_Pos = 0x4
	// Bit mask of IXC field.
	FPU_FPSCR_IXC_Msk = 0x10
	// Bit IXC.
	FPU_FPSCR_IXC = 0x10
	// Position of IDC field.
	FPU_FPSCR_IDC_Pos = 0x7
	// Bit mask of IDC field.
	FPU_FPSCR_IDC_Msk = 0x80
	// Bit IDC.
	FPU_FPSCR_IDC = 0x80
	// Position of RMode field.
	FPU_FPSCR_RMode_Pos = 0x16
	// Bit mask of RMode field.
	FPU_FPSCR_RMode_Msk = 0xc00000
	// Position of FZ field.
	FPU_FPSCR_FZ_Pos = 0x18
	// Bit mask of FZ field.
	FPU_FPSCR_FZ_Msk = 0x1000000
	// Bit FZ.
	FPU_FPSCR_FZ = 0x1000000
	// Position of DN field.
	FPU_FPSCR_DN_Pos = 0x19
	// Bit mask of DN field.
	FPU_FPSCR_DN_Msk = 0x2000000
	// Bit DN.
	FPU_FPSCR_DN = 0x2000000
	// Position of AHP field.
	FPU_FPSCR_AHP_Pos = 0x1a
	// Bit mask of AHP field.
	FPU_FPSCR_AHP_Msk = 0x4000000
	// Bit AHP.
	FPU_FPSCR_AHP = 0x4000000
	// Position of V field.
	FPU_FPSCR_V_Pos = 0x1c
	// Bit mask of V field.
	FPU_FPSCR_V_Msk = 0x10000000
	// Bit V.
	FPU_FPSCR_V = 0x10000000
	// Position of C field.
	FPU_FPSCR_C_Pos = 0x1d
	// Bit mask of C field.
	FPU_FPSCR_C_Msk = 0x20000000
	// Bit C.
	FPU_FPSCR_C = 0x20000000
	// Position of Z field.
	FPU_FPSCR_Z_Pos = 0x1e
	// Bit mask of Z field.
	FPU_FPSCR_Z_Msk = 0x40000000
	// Bit Z.
	FPU_FPSCR_Z = 0x40000000
	// Position of N field.
	FPU_FPSCR_N_Pos = 0x1f
	// Bit mask of N field.
	FPU_FPSCR_N_Msk = 0x80000000
	// Bit N.
	FPU_FPSCR_N = 0x80000000
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk = 0xff0000

	// MPU_CTRL: MPU control register
	// Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_MPU_CTRL_PRIVDEFENA = 0x4

	// MPU_RNR: MPU region number register
	// Position of REGION field.
	MPU_MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff

	// MPU_RBAR: MPU region base address register
	// Position of REGION field.
	MPU_MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk = 0xffffffe0

	// MPU_RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_MPU_RASR_XN = 0x10000000
)

// Bitfields for STK: SysTick timer
const (
	// CTRL: SysTick control and status register
	// Position of ENABLE field.
	STK_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CTRL_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CTRL_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CTRL_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CTRL_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CTRL_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CTRL_COUNTFLAG = 0x10000

	// LOAD: SysTick reload value register
	// Position of RELOAD field.
	STK_LOAD_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_LOAD_RELOAD_Msk = 0xffffff

	// VAL: SysTick current value register
	// Position of CURRENT field.
	STK_VAL_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	STK_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	STK_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	STK_CALIB_SKEW = 0x40000000
	// Position of NOREF field.
	STK_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	STK_CALIB_NOREF = 0x80000000
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	// Position of Revision field.
	SCB_CPUID_Revision_Pos = 0x0
	// Bit mask of Revision field.
	SCB_CPUID_Revision_Msk = 0xf
	// Position of PartNo field.
	SCB_CPUID_PartNo_Pos = 0x4
	// Bit mask of PartNo field.
	SCB_CPUID_PartNo_Msk = 0xfff0
	// Position of Constant field.
	SCB_CPUID_Constant_Pos = 0x10
	// Bit mask of Constant field.
	SCB_CPUID_Constant_Msk = 0xf0000
	// Position of Variant field.
	SCB_CPUID_Variant_Pos = 0x14
	// Bit mask of Variant field.
	SCB_CPUID_Variant_Msk = 0xf00000
	// Position of Implementer field.
	SCB_CPUID_Implementer_Pos = 0x18
	// Bit mask of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000

	// ICSR: Interrupt control and state register
	// Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Pos = 0x0
	// Bit mask of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk = 0x1ff
	// Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Pos = 0xb
	// Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk = 0x800
	// Bit RETTOBASE.
	SCB_ICSR_RETTOBASE = 0x800
	// Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000
	// Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Pos = 0x16
	// Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk = 0x400000
	// Bit ISRPENDING.
	SCB_ICSR_ISRPENDING = 0x400000
	// Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR = 0x2000000
	// Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SCB_ICSR_PENDSTSET = 0x4000000
	// Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR = 0x8000000
	// Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SCB_ICSR_PENDSVSET = 0x10000000
	// Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Pos = 0x1f
	// Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk = 0x80000000
	// Bit NMIPENDSET.
	SCB_ICSR_NMIPENDSET = 0x80000000

	// VTOR: Vector table offset register
	// Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Pos = 0x9
	// Bit mask of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0x3ffffe00

	// AIRCR: Application interrupt and reset control register
	// Position of VECTRESET field.
	SCB_AIRCR_VECTRESET_Pos = 0x0
	// Bit mask of VECTRESET field.
	SCB_AIRCR_VECTRESET_Msk = 0x1
	// Bit VECTRESET.
	SCB_AIRCR_VECTRESET = 0x1
	// Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE = 0x2
	// Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ = 0x4
	// Position of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Pos = 0x8
	// Bit mask of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Msk = 0x700
	// Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Pos = 0xf
	// Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk = 0x8000
	// Bit ENDIANESS.
	SCB_AIRCR_ENDIANESS = 0x8000
	// Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Pos = 0x10
	// Bit mask of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk = 0xffff0000

	// SCR: System control register
	// Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT = 0x2
	// Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP = 0x4
	// Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Pos = 0x4
	// Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk = 0x10
	// Bit SEVEONPEND.
	SCB_SCR_SEVEONPEND = 0x10

	// CCR: Configuration and control register
	// Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Pos = 0x0
	// Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1
	// Bit NONBASETHRDENA.
	SCB_CCR_NONBASETHRDENA = 0x1
	// Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Pos = 0x1
	// Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk = 0x2
	// Bit USERSETMPEND.
	SCB_CCR_USERSETMPEND = 0x2
	// Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Pos = 0x3
	// Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk = 0x8
	// Bit UNALIGN__TRP.
	SCB_CCR_UNALIGN__TRP = 0x8
	// Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Pos = 0x4
	// Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk = 0x10
	// Bit DIV_0_TRP.
	SCB_CCR_DIV_0_TRP = 0x10
	// Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Pos = 0x8
	// Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk = 0x100
	// Bit BFHFNMIGN.
	SCB_CCR_BFHFNMIGN = 0x100
	// Position of STKALIGN field.
	SCB_CCR_STKALIGN_Pos = 0x9
	// Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN_Msk = 0x200
	// Bit STKALIGN.
	SCB_CCR_STKALIGN = 0x200

	// SHPR1: System handler priority registers
	// Position of PRI_4 field.
	SCB_SHPR1_PRI_4_Pos = 0x0
	// Bit mask of PRI_4 field.
	SCB_SHPR1_PRI_4_Msk = 0xff
	// Position of PRI_5 field.
	SCB_SHPR1_PRI_5_Pos = 0x8
	// Bit mask of PRI_5 field.
	SCB_SHPR1_PRI_5_Msk = 0xff00
	// Position of PRI_6 field.
	SCB_SHPR1_PRI_6_Pos = 0x10
	// Bit mask of PRI_6 field.
	SCB_SHPR1_PRI_6_Msk = 0xff0000

	// SHPR2: System handler priority registers
	// Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System handler priority registers
	// Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000

	// SHCRS: System handler control and state register
	// Position of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Pos = 0x0
	// Bit mask of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Msk = 0x1
	// Bit MEMFAULTACT.
	SCB_SHCRS_MEMFAULTACT = 0x1
	// Position of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Pos = 0x1
	// Bit mask of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Msk = 0x2
	// Bit BUSFAULTACT.
	SCB_SHCRS_BUSFAULTACT = 0x2
	// Position of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Pos = 0x3
	// Bit mask of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Msk = 0x8
	// Bit USGFAULTACT.
	SCB_SHCRS_USGFAULTACT = 0x8
	// Position of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Pos = 0x7
	// Bit mask of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Msk = 0x80
	// Bit SVCALLACT.
	SCB_SHCRS_SVCALLACT = 0x80
	// Position of MONITORACT field.
	SCB_SHCRS_MONITORACT_Pos = 0x8
	// Bit mask of MONITORACT field.
	SCB_SHCRS_MONITORACT_Msk = 0x100
	// Bit MONITORACT.
	SCB_SHCRS_MONITORACT = 0x100
	// Position of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Pos = 0xa
	// Bit mask of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Msk = 0x400
	// Bit PENDSVACT.
	SCB_SHCRS_PENDSVACT = 0x400
	// Position of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Pos = 0xb
	// Bit mask of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Msk = 0x800
	// Bit SYSTICKACT.
	SCB_SHCRS_SYSTICKACT = 0x800
	// Position of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Pos = 0xc
	// Bit mask of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Msk = 0x1000
	// Bit USGFAULTPENDED.
	SCB_SHCRS_USGFAULTPENDED = 0x1000
	// Position of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Pos = 0xd
	// Bit mask of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Msk = 0x2000
	// Bit MEMFAULTPENDED.
	SCB_SHCRS_MEMFAULTPENDED = 0x2000
	// Position of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Pos = 0xe
	// Bit mask of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Msk = 0x4000
	// Bit BUSFAULTPENDED.
	SCB_SHCRS_BUSFAULTPENDED = 0x4000
	// Position of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Pos = 0xf
	// Bit mask of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Msk = 0x8000
	// Bit SVCALLPENDED.
	SCB_SHCRS_SVCALLPENDED = 0x8000
	// Position of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Pos = 0x10
	// Bit mask of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Msk = 0x10000
	// Bit MEMFAULTENA.
	SCB_SHCRS_MEMFAULTENA = 0x10000
	// Position of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Pos = 0x11
	// Bit mask of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Msk = 0x20000
	// Bit BUSFAULTENA.
	SCB_SHCRS_BUSFAULTENA = 0x20000
	// Position of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Pos = 0x12
	// Bit mask of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Msk = 0x40000
	// Bit USGFAULTENA.
	SCB_SHCRS_USGFAULTENA = 0x40000

	// CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
	// Position of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Pos = 0x1
	// Bit mask of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Msk = 0x2
	// Bit IACCVIOL.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL = 0x2
	// Position of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Pos = 0x3
	// Bit mask of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Msk = 0x8
	// Bit MUNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR = 0x8
	// Position of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Pos = 0x4
	// Bit mask of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Msk = 0x10
	// Bit MSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR = 0x10
	// Position of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Pos = 0x5
	// Bit mask of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Msk = 0x20
	// Bit MLSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR = 0x20
	// Position of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Pos = 0x7
	// Bit mask of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Msk = 0x80
	// Bit MMARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID = 0x80
	// Position of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Pos = 0x8
	// Bit mask of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Msk = 0x100
	// Bit IBUSERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR = 0x100
	// Position of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Pos = 0x9
	// Bit mask of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Msk = 0x200
	// Bit PRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR = 0x200
	// Position of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Pos = 0xa
	// Bit mask of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Msk = 0x400
	// Bit IMPRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR = 0x400
	// Position of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Pos = 0xb
	// Bit mask of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Msk = 0x800
	// Bit UNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR = 0x800
	// Position of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Pos = 0xc
	// Bit mask of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Msk = 0x1000
	// Bit STKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR = 0x1000
	// Position of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Pos = 0xd
	// Bit mask of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Msk = 0x2000
	// Bit LSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR = 0x2000
	// Position of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Pos = 0xf
	// Bit mask of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Msk = 0x8000
	// Bit BFARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID = 0x8000
	// Position of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Pos = 0x10
	// Bit mask of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Msk = 0x10000
	// Bit UNDEFINSTR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR = 0x10000
	// Position of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Pos = 0x11
	// Bit mask of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Msk = 0x20000
	// Bit INVSTATE.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE = 0x20000
	// Position of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Pos = 0x12
	// Bit mask of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Msk = 0x40000
	// Bit INVPC.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC = 0x40000
	// Position of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Pos = 0x13
	// Bit mask of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Msk = 0x80000
	// Bit NOCP.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP = 0x80000
	// Position of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Pos = 0x18
	// Bit mask of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Msk = 0x1000000
	// Bit UNALIGNED.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED = 0x1000000
	// Position of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Pos = 0x19
	// Bit mask of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Msk = 0x2000000
	// Bit DIVBYZERO.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO = 0x2000000

	// HFSR: Hard fault status register
	// Position of VECTTBL field.
	SCB_HFSR_VECTTBL_Pos = 0x1
	// Bit mask of VECTTBL field.
	SCB_HFSR_VECTTBL_Msk = 0x2
	// Bit VECTTBL.
	SCB_HFSR_VECTTBL = 0x2
	// Position of FORCED field.
	SCB_HFSR_FORCED_Pos = 0x1e
	// Bit mask of FORCED field.
	SCB_HFSR_FORCED_Msk = 0x40000000
	// Bit FORCED.
	SCB_HFSR_FORCED = 0x40000000
	// Position of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Pos = 0x1f
	// Bit mask of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Msk = 0x80000000
	// Bit DEBUG_VT.
	SCB_HFSR_DEBUG_VT = 0x80000000

	// MMFAR: Memory management fault address register
	// Position of MMFAR field.
	SCB_MMFAR_MMFAR_Pos = 0x0
	// Bit mask of MMFAR field.
	SCB_MMFAR_MMFAR_Msk = 0xffffffff

	// BFAR: Bus fault address register
	// Position of BFAR field.
	SCB_BFAR_BFAR_Pos = 0x0
	// Bit mask of BFAR field.
	SCB_BFAR_BFAR_Msk = 0xffffffff

	// AFSR: Auxiliary fault status register
	// Position of IMPDEF field.
	SCB_AFSR_IMPDEF_Pos = 0x0
	// Bit mask of IMPDEF field.
	SCB_AFSR_IMPDEF_Msk = 0xffffffff
)
