// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC11E6x_v0.8.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && lpc11e6x
// +build nxp,lpc11e6x

// LPC11E6x ARM cortex-m0+
//

package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC11E6x"
	CPU          = "CM0PLUS"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT0 = 0

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT1 = 1

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT2 = 2

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT3 = 3

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT4 = 4

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT5 = 5

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT6 = 6

	// Pin interrupt and pattern match (PINT)
	IRQ_PIN_INT7 = 7

	// GPIO group interrupt 0
	IRQ_GINT0 = 8

	// GINT1
	IRQ_GINT1 = 9

	// I2C1
	IRQ_I2C1 = 10

	// USART4
	IRQ_USART1_4 = 11

	// USART2
	IRQ_USART2_3 = 12

	// State Configurable Timers (SCTimer/PWM)
	IRQ_SCT0_1 = 13

	// SSP1
	IRQ_SSP1 = 14

	// I2C-bus controller
	IRQ_I2C0 = 15

	// 16-bit counter/timers CT16B0
	IRQ_CT16B0 = 16

	// 16-bit counter/timers CT16B1
	IRQ_CT16B1 = 17

	// 32-bit counter/timers CT32B0
	IRQ_CT32B0 = 18

	// 32-bit counter/timers CT32B1
	IRQ_CT32B1 = 19

	// SSP/SPI
	IRQ_SSP0 = 20

	// USART0
	IRQ_USART = 21

	// 12-bit Analog-to-Digital Converter (ADC)
	IRQ_ADC_A = 24

	// Real-Time Clock (RTC)
	IRQ_RTC = 25

	// System configuration (SYSCON)
	IRQ_BOD_WDT = 26

	// Flash controller
	IRQ_FLASH = 27

	// DMA controller
	IRQ_DMA = 28

	// Highest interrupt number on this device.
	IRQ_max = 28
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PIN_INT0_IRQHandler
func interruptPIN_INT0() {
	callHandlers(IRQ_PIN_INT0)
}

//export PIN_INT1_IRQHandler
func interruptPIN_INT1() {
	callHandlers(IRQ_PIN_INT1)
}

//export PIN_INT2_IRQHandler
func interruptPIN_INT2() {
	callHandlers(IRQ_PIN_INT2)
}

//export PIN_INT3_IRQHandler
func interruptPIN_INT3() {
	callHandlers(IRQ_PIN_INT3)
}

//export PIN_INT4_IRQHandler
func interruptPIN_INT4() {
	callHandlers(IRQ_PIN_INT4)
}

//export PIN_INT5_IRQHandler
func interruptPIN_INT5() {
	callHandlers(IRQ_PIN_INT5)
}

//export PIN_INT6_IRQHandler
func interruptPIN_INT6() {
	callHandlers(IRQ_PIN_INT6)
}

//export PIN_INT7_IRQHandler
func interruptPIN_INT7() {
	callHandlers(IRQ_PIN_INT7)
}

//export GINT0_IRQHandler
func interruptGINT0() {
	callHandlers(IRQ_GINT0)
}

//export GINT1_IRQHandler
func interruptGINT1() {
	callHandlers(IRQ_GINT1)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export USART1_4_IRQHandler
func interruptUSART1_4() {
	callHandlers(IRQ_USART1_4)
}

//export USART2_3_IRQHandler
func interruptUSART2_3() {
	callHandlers(IRQ_USART2_3)
}

//export SCT0_1_IRQHandler
func interruptSCT0_1() {
	callHandlers(IRQ_SCT0_1)
}

//export SSP1_IRQHandler
func interruptSSP1() {
	callHandlers(IRQ_SSP1)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export CT16B0_IRQHandler
func interruptCT16B0() {
	callHandlers(IRQ_CT16B0)
}

//export CT16B1_IRQHandler
func interruptCT16B1() {
	callHandlers(IRQ_CT16B1)
}

//export CT32B0_IRQHandler
func interruptCT32B0() {
	callHandlers(IRQ_CT32B0)
}

//export CT32B1_IRQHandler
func interruptCT32B1() {
	callHandlers(IRQ_CT32B1)
}

//export SSP0_IRQHandler
func interruptSSP0() {
	callHandlers(IRQ_SSP0)
}

//export USART_IRQHandler
func interruptUSART() {
	callHandlers(IRQ_USART)
}

//export ADC_A_IRQHandler
func interruptADC_A() {
	callHandlers(IRQ_ADC_A)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export BOD_WDT_IRQHandler
func interruptBOD_WDT() {
	callHandlers(IRQ_BOD_WDT)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export DMA_IRQHandler
func interruptDMA() {
	callHandlers(IRQ_DMA)
}

// Peripherals.
var (
	// I2C-bus controller
	I2C0 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Windowed Watchdog Timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// USART0
	USART0 = (*USART0_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// 16-bit counter/timers CT16B0
	CT16B0 = (*CT16B0_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// 16-bit counter/timers CT16B1
	CT16B1 = (*CT16B0_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// 32-bit counter/timers CT32B0
	CT32B0 = (*CT32B0_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// 32-bit counter/timers CT32B1
	CT32B1 = (*CT32B0_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// 12-bit Analog-to-Digital Converter (ADC)
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// I2C1
	I2C1 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Real-Time Clock (RTC)
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// DMA controller
	DMATRIGMUX = (*DMATRIGMUX_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Power Management Unit (PMU)
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Flash controller
	FLASHCTRL = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// SSP/SPI
	SSP0 = (*SSP0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// I/O control (IOCON)
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// System configuration (SYSCON)
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// USART4
	USART4 = (*USART4_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// SSP1
	SSP1 = (*SSP0_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// GPIO group interrupt 0
	GINT0 = (*GINT0_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// GINT1
	GINT1 = (*GINT0_Type)(unsafe.Pointer(uintptr(0x40060000)))

	// USART1
	USART1 = (*USART4_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// USART2
	USART2 = (*USART4_Type)(unsafe.Pointer(uintptr(0x40070000)))

	// USART3
	USART3 = (*USART4_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// Cyclic Redundancy Check (CRC) engine
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// DMA controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x50004000)))

	// State Configurable Timers (SCTimer/PWM)
	SCT0 = (*SCT0_Type)(unsafe.Pointer(uintptr(0x5000c000)))

	// SCT1
	SCT1 = (*SCT0_Type)(unsafe.Pointer(uintptr(0x5000e000)))

	// General Purpose I/O (GPIO)
	GPIO_PORT = (*GPIO_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// Pin interrupt and pattern match (PINT)
	PINT = (*PINT_Type)(unsafe.Pointer(uintptr(0xa0004000)))
)

// I2C-bus controller
type I2C0_Type struct {
	CONSET      volatile.Register32 // 0x0
	STAT        volatile.Register32 // 0x4
	DAT         volatile.Register32 // 0x8
	ADR0        volatile.Register32 // 0xC
	SCLH        volatile.Register32 // 0x10
	SCLL        volatile.Register32 // 0x14
	CONCLR      volatile.Register32 // 0x18
	MMCTRL      volatile.Register32 // 0x1C
	ADR1        volatile.Register32 // 0x20
	ADR2        volatile.Register32 // 0x24
	ADR3        volatile.Register32 // 0x28
	DATA_BUFFER volatile.Register32 // 0x2C
	MASK0       volatile.Register32 // 0x30
	MASK1       volatile.Register32 // 0x34
	MASK2       volatile.Register32 // 0x38
	MASK3       volatile.Register32 // 0x3C
}

// Windowed Watchdog Timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	CLKSEL  volatile.Register32 // 0x10
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// USART0
type USART0_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	MCR           volatile.Register32 // 0x10
	LSR           volatile.Register32 // 0x14
	MSR           volatile.Register32 // 0x18
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	ICR           volatile.Register32 // 0x24
	FDR           volatile.Register32 // 0x28
	OSR           volatile.Register32 // 0x2C
	TER           volatile.Register32 // 0x30
	_             [12]byte
	HDEN          volatile.Register32 // 0x40
	_             [4]byte
	SCICTRL       volatile.Register32 // 0x48
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
	SYNCCTRL      volatile.Register32 // 0x58
}

// 16-bit counter/timers CT16B0
type CT16B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	CR2  volatile.Register32 // 0x34
	_    [4]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// 32-bit counter/timers CT32B0
type CT32B0_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	CR2  volatile.Register32 // 0x34
	_    [4]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// 12-bit Analog-to-Digital Converter (ADC)
type ADC_Type struct {
	CTRL        volatile.Register32 // 0x0
	_           [4]byte
	SEQA_CTRL   volatile.Register32 // 0x8
	SEQB_CTRL   volatile.Register32 // 0xC
	SEQA_GDAT   volatile.Register32 // 0x10
	SEQB_GDAT   volatile.Register32 // 0x14
	_           [8]byte
	DAT         [12]volatile.Register32 // 0x20
	THR0_LOW    volatile.Register32     // 0x50
	THR1_LOW    volatile.Register32     // 0x54
	THR0_HIGH   volatile.Register32     // 0x58
	THR1_HIGH   volatile.Register32     // 0x5C
	CHAN_THRSEL volatile.Register32     // 0x60
	INTEN       volatile.Register32     // 0x64
	FLAGS       volatile.Register32     // 0x68
	TRM         volatile.Register32     // 0x6C
}

// Real-Time Clock (RTC)
type RTC_Type struct {
	CTRL  volatile.Register32 // 0x0
	MATCH volatile.Register32 // 0x4
	COUNT volatile.Register32 // 0x8
	WAKE  volatile.Register32 // 0xC
}

// DMA controller
type DMATRIGMUX_Type struct {
	DMA_ITRIG_PINMUX [16]volatile.Register32 // 0x0
}

// Power Management Unit (PMU)
type PMU_Type struct {
	PCON   volatile.Register32 // 0x0
	GPREG0 volatile.Register32 // 0x4
	GPREG1 volatile.Register32 // 0x8
	GPREG2 volatile.Register32 // 0xC
	GPREG3 volatile.Register32 // 0x10
	GPREG4 volatile.Register32 // 0x14
}

// Flash controller
type FLASHCTRL_Type struct {
	_        [16]byte
	FLASHCFG volatile.Register32 // 0x10
	_        [12]byte
	FMSSTART volatile.Register32 // 0x20
	FMSSTOP  volatile.Register32 // 0x24
	_        [4]byte
	FMSW0    volatile.Register32 // 0x2C
}

// SSP/SPI
type SSP0_Type struct {
	CR0  volatile.Register32 // 0x0
	CR1  volatile.Register32 // 0x4
	DR   volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	CPSR volatile.Register32 // 0x10
	IMSC volatile.Register32 // 0x14
	RIS  volatile.Register32 // 0x18
	MIS  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
}

// I/O control (IOCON)
type IOCON_Type struct {
	PIO0_0  volatile.Register32 // 0x0
	PIO0_1  volatile.Register32 // 0x4
	PIO0_2  volatile.Register32 // 0x8
	PIO0_3  volatile.Register32 // 0xC
	PIO0_4  volatile.Register32 // 0x10
	PIO0_5  volatile.Register32 // 0x14
	PIO0_6  volatile.Register32 // 0x18
	PIO0_7  volatile.Register32 // 0x1C
	PIO0_8  volatile.Register32 // 0x20
	PIO0_9  volatile.Register32 // 0x24
	PIO0_10 volatile.Register32 // 0x28
	PIO0_11 volatile.Register32 // 0x2C
	PIO0_12 volatile.Register32 // 0x30
	PIO0_13 volatile.Register32 // 0x34
	PIO0_14 volatile.Register32 // 0x38
	PIO0_15 volatile.Register32 // 0x3C
	PIO0_16 volatile.Register32 // 0x40
	PIO0_17 volatile.Register32 // 0x44
	PIO0_18 volatile.Register32 // 0x48
	PIO0_19 volatile.Register32 // 0x4C
	PIO0_20 volatile.Register32 // 0x50
	PIO0_21 volatile.Register32 // 0x54
	PIO0_22 volatile.Register32 // 0x58
	PIO0_23 volatile.Register32 // 0x5C
	PIO1_0  volatile.Register32 // 0x60
	PIO1_1  volatile.Register32 // 0x64
	PIO1_2  volatile.Register32 // 0x68
	PIO1_3  volatile.Register32 // 0x6C
	PIO1_4  volatile.Register32 // 0x70
	PIO1_5  volatile.Register32 // 0x74
	PIO1_6  volatile.Register32 // 0x78
	PIO1_7  volatile.Register32 // 0x7C
	PIO1_8  volatile.Register32 // 0x80
	PIO1_9  volatile.Register32 // 0x84
	PIO1_10 volatile.Register32 // 0x88
	PIO1_11 volatile.Register32 // 0x8C
	PIO1_12 volatile.Register32 // 0x90
	PIO1_13 volatile.Register32 // 0x94
	PIO1_14 volatile.Register32 // 0x98
	PIO1_15 volatile.Register32 // 0x9C
	PIO1_16 volatile.Register32 // 0xA0
	PIO1_17 volatile.Register32 // 0xA4
	PIO1_18 volatile.Register32 // 0xA8
	PIO1_19 volatile.Register32 // 0xAC
	PIO1_20 volatile.Register32 // 0xB0
	PIO1_21 volatile.Register32 // 0xB4
	PIO1_22 volatile.Register32 // 0xB8
	PIO1_23 volatile.Register32 // 0xBC
	PIO1_24 volatile.Register32 // 0xC0
	PIO1_25 volatile.Register32 // 0xC4
	PIO1_26 volatile.Register32 // 0xC8
	PIO1_27 volatile.Register32 // 0xCC
	PIO1_28 volatile.Register32 // 0xD0
	PIO1_29 volatile.Register32 // 0xD4
	PIO1_30 volatile.Register32 // 0xD8
	PIO1_31 volatile.Register32 // 0xDC
	_       [16]byte
	PIO2_0  volatile.Register32 // 0xF0
	PIO2_1  volatile.Register32 // 0xF4
	_       [4]byte
	PIO2_2  volatile.Register32 // 0xFC
	PIO2_3  volatile.Register32 // 0x100
	PIO2_4  volatile.Register32 // 0x104
	PIO2_5  volatile.Register32 // 0x108
	PIO2_6  volatile.Register32 // 0x10C
	PIO2_7  volatile.Register32 // 0x110
	PIO2_8  volatile.Register32 // 0x114
	PIO2_9  volatile.Register32 // 0x118
	PIO2_10 volatile.Register32 // 0x11C
	PIO2_11 volatile.Register32 // 0x120
	PIO2_12 volatile.Register32 // 0x124
	PIO2_13 volatile.Register32 // 0x128
	PIO2_14 volatile.Register32 // 0x12C
	PIO2_15 volatile.Register32 // 0x130
	PIO2_16 volatile.Register32 // 0x134
	PIO2_17 volatile.Register32 // 0x138
	PIO2_18 volatile.Register32 // 0x13C
	PIO2_19 volatile.Register32 // 0x140
	PIO2_20 volatile.Register32 // 0x144
	PIO2_21 volatile.Register32 // 0x148
	PIO2_22 volatile.Register32 // 0x14C
	PIO2_23 volatile.Register32 // 0x150
}

// System configuration (SYSCON)
type SYSCON_Type struct {
	SYSMEMREMAP   volatile.Register32 // 0x0
	PRESETCTRL    volatile.Register32 // 0x4
	SYSPLLCTRL    volatile.Register32 // 0x8
	SYSPLLSTAT    volatile.Register32 // 0xC
	_             [12]byte
	RTCOSCCTRL    volatile.Register32 // 0x1C
	SYSOSCCTRL    volatile.Register32 // 0x20
	WDTOSCCTRL    volatile.Register32 // 0x24
	IRCCTRL       volatile.Register32 // 0x28
	_             [4]byte
	SYSRSTSTAT    volatile.Register32 // 0x30
	_             [12]byte
	SYSPLLCLKSEL  volatile.Register32 // 0x40
	SYSPLLCLKUEN  volatile.Register32 // 0x44
	_             [40]byte
	MAINCLKSEL    volatile.Register32 // 0x70
	MAINCLKUEN    volatile.Register32 // 0x74
	SYSAHBCLKDIV  volatile.Register32 // 0x78
	_             [4]byte
	SYSAHBCLKCTRL volatile.Register32 // 0x80
	_             [16]byte
	SSP0CLKDIV    volatile.Register32 // 0x94
	USART0CLKDIV  volatile.Register32 // 0x98
	SSP1CLKDIV    volatile.Register32 // 0x9C
	FRGCLKDIV     volatile.Register32 // 0xA0
	_             [60]byte
	CLKOUTSEL     volatile.Register32 // 0xE0
	CLKOUTUEN     volatile.Register32 // 0xE4
	CLKOUTDIV     volatile.Register32 // 0xE8
	_             [4]byte
	UARTFRGDIV    volatile.Register32 // 0xF0
	UARTFRGMULT   volatile.Register32 // 0xF4
	_             [4]byte
	EXTTRACECMD   volatile.Register32 // 0xFC
	PIOPORCAP0    volatile.Register32 // 0x100
	PIOPORCAP1    volatile.Register32 // 0x104
	PIOPORCAP2    volatile.Register32 // 0x108
	_             [40]byte
	IOCONCLKDIV6  volatile.Register32 // 0x134
	IOCONCLKDIV5  volatile.Register32 // 0x138
	IOCONCLKDIV4  volatile.Register32 // 0x13C
	IOCONCLKDIV3  volatile.Register32 // 0x140
	IOCONCLKDIV2  volatile.Register32 // 0x144
	IOCONCLKDIV1  volatile.Register32 // 0x148
	IOCONCLKDIV0  volatile.Register32 // 0x14C
	BODCTRL       volatile.Register32 // 0x150
	SYSTCKCAL     volatile.Register32 // 0x154
	_             [24]byte
	IRQLATENCY    volatile.Register32 // 0x170
	NMISRC        volatile.Register32 // 0x174
	PINTSEL0      volatile.Register32 // 0x178
	PINTSEL1      volatile.Register32 // 0x17C
	PINTSEL2      volatile.Register32 // 0x180
	PINTSEL3      volatile.Register32 // 0x184
	PINTSEL4      volatile.Register32 // 0x188
	PINTSEL5      volatile.Register32 // 0x18C
	PINTSEL6      volatile.Register32 // 0x190
	PINTSEL7      volatile.Register32 // 0x194
	_             [108]byte
	STARTERP0     volatile.Register32 // 0x204
	_             [12]byte
	STARTERP1     volatile.Register32 // 0x214
	_             [24]byte
	PDSLEEPCFG    volatile.Register32 // 0x230
	PDAWAKECFG    volatile.Register32 // 0x234
	PDRUNCFG      volatile.Register32 // 0x238
	_             [440]byte
	DEVICE_ID     volatile.Register32 // 0x3F4
}

// USART4
type USART4_Type struct {
	CFG       volatile.Register32 // 0x0
	CTL       volatile.Register32 // 0x4
	STAT      volatile.Register32 // 0x8
	INTENSET  volatile.Register32 // 0xC
	INTENCLR  volatile.Register32 // 0x10
	RXDAT     volatile.Register32 // 0x14
	RXDATSTAT volatile.Register32 // 0x18
	TXDAT     volatile.Register32 // 0x1C
	BRG       volatile.Register32 // 0x20
	INTSTAT   volatile.Register32 // 0x24
	OSR       volatile.Register32 // 0x28
	ADDR      volatile.Register32 // 0x2C
}

// GPIO group interrupt 0
type GINT0_Type struct {
	CTRL     volatile.Register32 // 0x0
	_        [28]byte
	PORT_POL [3]volatile.Register32 // 0x20
	_        [20]byte
	PORT_ENA [3]volatile.Register32 // 0x40
}

// Cyclic Redundancy Check (CRC) engine
type CRC_Type struct {
	MODE volatile.Register32 // 0x0
	SEED volatile.Register32 // 0x4
	SUM  volatile.Register32 // 0x8
}

// DMA controller
type DMA_Type struct {
	CTRL       volatile.Register32 // 0x0
	INTSTAT    volatile.Register32 // 0x4
	SRAMBASE   volatile.Register32 // 0x8
	_          [20]byte
	ENABLESET0 volatile.Register32 // 0x20
	_          [4]byte
	ENABLECLR0 volatile.Register32 // 0x28
	_          [4]byte
	ACTIVE0    volatile.Register32 // 0x30
	_          [4]byte
	BUSY0      volatile.Register32 // 0x38
	_          [4]byte
	ERRINT0    volatile.Register32 // 0x40
	_          [4]byte
	INTENSET0  volatile.Register32 // 0x48
	_          [4]byte
	INTENCLR0  volatile.Register32 // 0x50
	_          [4]byte
	INTA0      volatile.Register32 // 0x58
	_          [4]byte
	INTB0      volatile.Register32 // 0x60
	_          [4]byte
	SETVALID0  volatile.Register32 // 0x68
	_          [4]byte
	SETTRIG0   volatile.Register32 // 0x70
	_          [4]byte
	ABORT0     volatile.Register32 // 0x78
	_          [900]byte
	CFG0       volatile.Register32 // 0x400
	CTLSTAT0   volatile.Register32 // 0x404
	XFERCFG0   volatile.Register32 // 0x408
	_          [4]byte
	CFG1       volatile.Register32 // 0x410
	CTLSTAT1   volatile.Register32 // 0x414
	XFERCFG1   volatile.Register32 // 0x418
	_          [4]byte
	CFG2       volatile.Register32 // 0x420
	CTLSTAT2   volatile.Register32 // 0x424
	XFERCFG2   volatile.Register32 // 0x428
	_          [4]byte
	CFG3       volatile.Register32 // 0x430
	CTLSTAT3   volatile.Register32 // 0x434
	XFERCFG3   volatile.Register32 // 0x438
	_          [4]byte
	CFG4       volatile.Register32 // 0x440
	CTLSTAT4   volatile.Register32 // 0x444
	XFERCFG4   volatile.Register32 // 0x448
	_          [4]byte
	CFG5       volatile.Register32 // 0x450
	CTLSTAT5   volatile.Register32 // 0x454
	XFERCFG5   volatile.Register32 // 0x458
	_          [4]byte
	CFG6       volatile.Register32 // 0x460
	CTLSTAT6   volatile.Register32 // 0x464
	XFERCFG6   volatile.Register32 // 0x468
	_          [4]byte
	CFG7       volatile.Register32 // 0x470
	CTLSTAT7   volatile.Register32 // 0x474
	XFERCFG7   volatile.Register32 // 0x478
	_          [4]byte
	CFG8       volatile.Register32 // 0x480
	CTLSTAT8   volatile.Register32 // 0x484
	XFERCFG8   volatile.Register32 // 0x488
	_          [4]byte
	CFG9       volatile.Register32 // 0x490
	CTLSTAT9   volatile.Register32 // 0x494
	XFERCFG9   volatile.Register32 // 0x498
	_          [4]byte
	CFG10      volatile.Register32 // 0x4A0
	CTLSTAT10  volatile.Register32 // 0x4A4
	XFERCFG10  volatile.Register32 // 0x4A8
	_          [4]byte
	CFG11      volatile.Register32 // 0x4B0
	CTLSTAT11  volatile.Register32 // 0x4B4
	XFERCFG11  volatile.Register32 // 0x4B8
	_          [4]byte
	CFG12      volatile.Register32 // 0x4C0
	CTLSTAT12  volatile.Register32 // 0x4C4
	XFERCFG12  volatile.Register32 // 0x4C8
	_          [4]byte
	CFG13      volatile.Register32 // 0x4D0
	CTLSTAT13  volatile.Register32 // 0x4D4
	XFERCFG13  volatile.Register32 // 0x4D8
	_          [4]byte
	CFG14      volatile.Register32 // 0x4E0
	CTLSTAT14  volatile.Register32 // 0x4E4
	XFERCFG14  volatile.Register32 // 0x4E8
	_          [4]byte
	CFG15      volatile.Register32 // 0x4F0
	CTLSTAT15  volatile.Register32 // 0x4F4
	XFERCFG15  volatile.Register32 // 0x4F8
}

// State Configurable Timers (SCTimer/PWM)
type SCT0_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	_             [40]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	DMAREQ0       volatile.Register32 // 0x5C
	DMAREQ1       volatile.Register32 // 0x60
	_             [140]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	_             [236]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	_             [236]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	_             [464]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
}

// General Purpose I/O (GPIO)
type GPIO_Type struct {
	B    [88]volatile.Register8 // 0x0
	_    [4008]byte
	W    [88]volatile.Register32 // 0x1000
	_    [3744]byte
	DIR  [3]volatile.Register32 // 0x2000
	_    [116]byte
	MASK [3]volatile.Register32 // 0x2080
	_    [116]byte
	PIN  [3]volatile.Register32 // 0x2100
	_    [116]byte
	MPIN [3]volatile.Register32 // 0x2180
	_    [116]byte
	SET  [3]volatile.Register32 // 0x2200
	_    [116]byte
	CLR  [3]volatile.Register32 // 0x2280
	_    [116]byte
	NOT  [3]volatile.Register32 // 0x2300
}

// Pin interrupt and pattern match (PINT)
type PINT_Type struct {
	ISEL   volatile.Register32 // 0x0
	IENR   volatile.Register32 // 0x4
	SIENR  volatile.Register32 // 0x8
	CIENR  volatile.Register32 // 0xC
	IENF   volatile.Register32 // 0x10
	SIENF  volatile.Register32 // 0x14
	CIENF  volatile.Register32 // 0x18
	RISE   volatile.Register32 // 0x1C
	FALL   volatile.Register32 // 0x20
	IST    volatile.Register32 // 0x24
	PMCTRL volatile.Register32 // 0x28
	PMSRC  volatile.Register32 // 0x2C
	PMCFG  volatile.Register32 // 0x30
}

// Bitfields for I2C0: I2C-bus controller
const (
	// CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C0_CONSET_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C0_CONSET_RESERVED_Msk = 0x3
	// Position of AA field.
	I2C0_CONSET_AA_Pos = 0x2
	// Bit mask of AA field.
	I2C0_CONSET_AA_Msk = 0x4
	// Bit AA.
	I2C0_CONSET_AA = 0x4
	// Position of SI field.
	I2C0_CONSET_SI_Pos = 0x3
	// Bit mask of SI field.
	I2C0_CONSET_SI_Msk = 0x8
	// Bit SI.
	I2C0_CONSET_SI = 0x8
	// Position of STO field.
	I2C0_CONSET_STO_Pos = 0x4
	// Bit mask of STO field.
	I2C0_CONSET_STO_Msk = 0x10
	// Bit STO.
	I2C0_CONSET_STO = 0x10
	// Position of STA field.
	I2C0_CONSET_STA_Pos = 0x5
	// Bit mask of STA field.
	I2C0_CONSET_STA_Msk = 0x20
	// Bit STA.
	I2C0_CONSET_STA = 0x20
	// Position of I2EN field.
	I2C0_CONSET_I2EN_Pos = 0x6
	// Bit mask of I2EN field.
	I2C0_CONSET_I2EN_Msk = 0x40
	// Bit I2EN.
	I2C0_CONSET_I2EN = 0x40
	// Position of RESERVED field.
	I2C0_CONSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_CONSET_RESERVED_Msk = 0xffffff80

	// STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0x7
	// Position of Status field.
	I2C0_STAT_Status_Pos = 0x3
	// Bit mask of Status field.
	I2C0_STAT_Status_Msk = 0xf8
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0xffffff00

	// DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
	// Position of Data field.
	I2C0_DAT_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C0_DAT_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C0_DAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_DAT_RESERVED_Msk = 0xffffff00

	// ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C0_ADR0_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C0_ADR0_GC_Msk = 0x1
	// Bit GC.
	I2C0_ADR0_GC = 0x1
	// Position of Address field.
	I2C0_ADR0_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C0_ADR0_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_ADR0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_ADR0_RESERVED_Msk = 0xffffff00

	// SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
	// Position of SCLH field.
	I2C0_SCLH_SCLH_Pos = 0x0
	// Bit mask of SCLH field.
	I2C0_SCLH_SCLH_Msk = 0xffff
	// Position of RESERVED field.
	I2C0_SCLH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C0_SCLH_RESERVED_Msk = 0xffff0000

	// SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. I2nSCLL and I2nSCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
	// Position of SCLL field.
	I2C0_SCLL_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C0_SCLL_SCLL_Msk = 0xffff
	// Position of RESERVED field.
	I2C0_SCLL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C0_SCLL_RESERVED_Msk = 0xffff0000

	// CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C0_CONCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C0_CONCLR_RESERVED_Msk = 0x3
	// Position of AAC field.
	I2C0_CONCLR_AAC_Pos = 0x2
	// Bit mask of AAC field.
	I2C0_CONCLR_AAC_Msk = 0x4
	// Bit AAC.
	I2C0_CONCLR_AAC = 0x4
	// Position of SIC field.
	I2C0_CONCLR_SIC_Pos = 0x3
	// Bit mask of SIC field.
	I2C0_CONCLR_SIC_Msk = 0x8
	// Bit SIC.
	I2C0_CONCLR_SIC = 0x8
	// Position of RESERVED field.
	I2C0_CONCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	I2C0_CONCLR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	I2C0_CONCLR_RESERVED = 0x10
	// Position of STAC field.
	I2C0_CONCLR_STAC_Pos = 0x5
	// Bit mask of STAC field.
	I2C0_CONCLR_STAC_Msk = 0x20
	// Bit STAC.
	I2C0_CONCLR_STAC = 0x20
	// Position of I2ENC field.
	I2C0_CONCLR_I2ENC_Pos = 0x6
	// Bit mask of I2ENC field.
	I2C0_CONCLR_I2ENC_Msk = 0x40
	// Bit I2ENC.
	I2C0_CONCLR_I2ENC = 0x40
	// Position of RESERVED field.
	I2C0_CONCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_CONCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_CONCLR_RESERVED = 0x80
	// Position of RESERVED field.
	I2C0_CONCLR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_CONCLR_RESERVED_Msk = 0xffffff00

	// MMCTRL: Monitor mode control register.
	// Position of MM_ENA field.
	I2C0_MMCTRL_MM_ENA_Pos = 0x0
	// Bit mask of MM_ENA field.
	I2C0_MMCTRL_MM_ENA_Msk = 0x1
	// Bit MM_ENA.
	I2C0_MMCTRL_MM_ENA = 0x1
	// Monitor mode disabled.
	I2C0_MMCTRL_MM_ENA_MONITOR_MODE_DISABLE = 0x0
	// The I2C module will enter monitor mode. In this mode the SDA output will be forced high. This will prevent the I2C module from outputting data of any kind (including ACK) onto the I 2C data bus. Depending on the state of the ENA_SCL bit, the output may be also forced high, preventing the module from having control over the I2C clock line.
	I2C0_MMCTRL_MM_ENA_THE_I2C_MODULE_WILL_ = 0x1
	// Position of ENA_SCL field.
	I2C0_MMCTRL_ENA_SCL_Pos = 0x1
	// Bit mask of ENA_SCL field.
	I2C0_MMCTRL_ENA_SCL_Msk = 0x2
	// Bit ENA_SCL.
	I2C0_MMCTRL_ENA_SCL = 0x2
	// When this bit is cleared to 0, the SCL output will be forced high when the module is in monitor mode. As described above, this will prevent the module from having any control over the I2C clock line.
	I2C0_MMCTRL_ENA_SCL_HIGH = 0x0
	// When this bit is set, the I2C module may exercise the same control over the clock line that it would in normal operation. This means that, acting as a slave peripheral, the I2C module can stretch the clock line (hold it low) until it has had time to respond to an I2C interrupt.[1]
	I2C0_MMCTRL_ENA_SCL_NORMAL = 0x1
	// Position of MATCH_ALL field.
	I2C0_MMCTRL_MATCH_ALL_Pos = 0x2
	// Bit mask of MATCH_ALL field.
	I2C0_MMCTRL_MATCH_ALL_Msk = 0x4
	// Bit MATCH_ALL.
	I2C0_MMCTRL_MATCH_ALL = 0x4
	// When this bit is cleared, an interrupt will only be generated when a match occurs to one of the (up-to) four address registers described above. That is, the module will respond as a normal slave as far as address-recognition is concerned.
	I2C0_MMCTRL_MATCH_ALL_MATCH = 0x0
	// When this bit is set to 1 and the I2C is in monitor mode, an interrupt will be generated on ANY address received. This will enable the part to monitor all traffic on the bus.
	I2C0_MMCTRL_MATCH_ALL_ANYADDRESS = 0x1
	// Position of RESERVED field.
	I2C0_MMCTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	I2C0_MMCTRL_RESERVED_Msk = 0xfffffff8

	// ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C0_ADR_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C0_ADR_GC_Msk = 0x1
	// Bit GC.
	I2C0_ADR_GC = 0x1
	// Position of Address field.
	I2C0_ADR_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C0_ADR_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_ADR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_ADR_RESERVED_Msk = 0xffffff00

	// DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the I2DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
	// Position of Data field.
	I2C0_DATA_BUFFER_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C0_DATA_BUFFER_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C0_DATA_BUFFER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_DATA_BUFFER_RESERVED_Msk = 0xffffff00

	// MASK0: I2C Slave address mask register. This mask register is associated with I2ADR0 to determine an address match. The mask register has no effect when comparing to the General Call address (0000000).
	// Position of RESERVED field.
	I2C0_MASK_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C0_MASK_RESERVED_Msk = 0x1
	// Bit RESERVED.
	I2C0_MASK_RESERVED = 0x1
	// Position of MASK field.
	I2C0_MASK_MASK_Pos = 0x1
	// Bit mask of MASK field.
	I2C0_MASK_MASK_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_MASK_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_MASK_RESERVED_Msk = 0xffffff00
)

// Bitfields for WWDT: Windowed Watchdog Timer (WWDT)
const (
	// MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_MOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_MOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_MOD_WDEN = 0x1
	// The watchdog timer is stopped.
	WWDT_MOD_WDEN_STOPPED = 0x0
	// The watchdog timer is running.
	WWDT_MOD_WDEN_RUNNING = 0x1
	// Position of WDRESET field.
	WWDT_MOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_MOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_MOD_WDRESET = 0x2
	// A watchdog timeout will not cause a chip reset.
	WWDT_MOD_WDRESET_INTERRUPT = 0x0
	// Position of WDTOF field.
	WWDT_MOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_MOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_MOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_MOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_MOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_MOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_MOD_WDPROTECT = 0x10
	// The watchdog time-out value (TC) can be changed at any time.
	WWDT_MOD_WDPROTECT_NOT_LOCKED = 0x0
	// The watchdog time-out value (TC) can be changed only after the counter is below the value of WDWARNINT and WDWINDOW.
	WWDT_MOD_WDPROTECT_LOCKED = 0x1
	// Position of LOCK field.
	WWDT_MOD_LOCK_Pos = 0x5
	// Bit mask of LOCK field.
	WWDT_MOD_LOCK_Msk = 0x20
	// Bit LOCK.
	WWDT_MOD_LOCK = 0x20
	// Position of RESERVED field.
	WWDT_MOD_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	WWDT_MOD_RESERVED_Msk = 0xffffffc0

	// TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
	// Position of COUNT field.
	WWDT_TC_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TC_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TC_RESERVED_Msk = 0xff000000

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of FEED field.
	WWDT_FEED_FEED_Pos = 0x0
	// Bit mask of FEED field.
	WWDT_FEED_FEED_Msk = 0xff
	// Position of RESERVED field.
	WWDT_FEED_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	WWDT_FEED_RESERVED_Msk = 0xffffff00

	// TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
	// Position of COUNT field.
	WWDT_TV_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TV_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TV_RESERVED_Msk = 0xff000000

	// CLKSEL: Watchdog clock select register.
	// Position of CLKSEL field.
	WWDT_CLKSEL_CLKSEL_Pos = 0x0
	// Bit mask of CLKSEL field.
	WWDT_CLKSEL_CLKSEL_Msk = 0x1
	// Bit CLKSEL.
	WWDT_CLKSEL_CLKSEL = 0x1
	// IRC
	WWDT_CLKSEL_CLKSEL_IRC = 0x0
	// Watchdog oscillator (WDOSC)
	WWDT_CLKSEL_CLKSEL_WATCHDOG_OSCILLATOR_ = 0x1
	// Position of RESERVED field.
	WWDT_CLKSEL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	WWDT_CLKSEL_RESERVED_Msk = 0x7ffffffe
	// Position of LOCK field.
	WWDT_CLKSEL_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	WWDT_CLKSEL_LOCK_Msk = 0x80000000
	// Bit LOCK.
	WWDT_CLKSEL_LOCK = 0x80000000

	// WARNINT: Watchdog Warning Interrupt compare value.
	// Position of WARNINT field.
	WWDT_WARNINT_WARNINT_Pos = 0x0
	// Bit mask of WARNINT field.
	WWDT_WARNINT_WARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WARNINT_RESERVED_Msk = 0xfffffc00

	// WINDOW: Watchdog Window compare value.
	// Position of WINDOW field.
	WWDT_WINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	WWDT_WINDOW_WINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WINDOW_RESERVED_Msk = 0xff000000
)

// Bitfields for USART0: USART0
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read. (DLAB=0)
	// Position of RBR field.
	USART0_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	USART0_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	USART0_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_RBR_RESERVED_Msk = 0xffffff00

	// THR: Transmit Holding Register. The next character to be transmitted is written here. (DLAB=0)
	// Position of THR field.
	USART0_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	USART0_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	USART0_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_THR_RESERVED_Msk = 0xffffff00

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLLSB field.
	USART0_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	USART0_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	USART0_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_DLL_RESERVED_Msk = 0xffffff00

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider. (DLAB=1)
	// Position of DLMSB field.
	USART0_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	USART0_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	USART0_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_DLM_RESERVED_Msk = 0xffffff00

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential USART interrupts. (DLAB=0)
	// Position of RBRINTEN field.
	USART0_IER_RBRINTEN_Pos = 0x0
	// Bit mask of RBRINTEN field.
	USART0_IER_RBRINTEN_Msk = 0x1
	// Bit RBRINTEN.
	USART0_IER_RBRINTEN = 0x1
	// Disable the RDA interrupt.
	USART0_IER_RBRINTEN_DISABLE_THE_RDA_INTE = 0x0
	// Enable the RDA interrupt.
	USART0_IER_RBRINTEN_ENABLE_THE_RDA_INTER = 0x1
	// Position of THREINTEN field.
	USART0_IER_THREINTEN_Pos = 0x1
	// Bit mask of THREINTEN field.
	USART0_IER_THREINTEN_Msk = 0x2
	// Bit THREINTEN.
	USART0_IER_THREINTEN = 0x2
	// Disable the THRE interrupt.
	USART0_IER_THREINTEN_DISABLE_THE_THRE_INT = 0x0
	// Enable the THRE interrupt.
	USART0_IER_THREINTEN_ENABLE_THE_THRE_INTE = 0x1
	// Position of RLSINTEN field.
	USART0_IER_RLSINTEN_Pos = 0x2
	// Bit mask of RLSINTEN field.
	USART0_IER_RLSINTEN_Msk = 0x4
	// Bit RLSINTEN.
	USART0_IER_RLSINTEN = 0x4
	// Disable the RLS interrupt.
	USART0_IER_RLSINTEN_DISABLE_THE_RLS_INTE = 0x0
	// Enable the RLS interrupt.
	USART0_IER_RLSINTEN_ENABLE_THE_RLS_INTER = 0x1
	// Position of MSINTEN field.
	USART0_IER_MSINTEN_Pos = 0x3
	// Bit mask of MSINTEN field.
	USART0_IER_MSINTEN_Msk = 0x8
	// Bit MSINTEN.
	USART0_IER_MSINTEN = 0x8
	// Disable the MS interrupt.
	USART0_IER_MSINTEN_DISABLE_THE_MS_INTER = 0x0
	// Enable the MS interrupt.
	USART0_IER_MSINTEN_ENABLE_THE_MS_INTERR = 0x1
	// Position of RESERVED field.
	USART0_IER_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_IER_RESERVED_Msk = 0xf0
	// Position of ABEOINTEN field.
	USART0_IER_ABEOINTEN_Pos = 0x8
	// Bit mask of ABEOINTEN field.
	USART0_IER_ABEOINTEN_Msk = 0x100
	// Bit ABEOINTEN.
	USART0_IER_ABEOINTEN = 0x100
	// Disable end of auto-baud Interrupt.
	USART0_IER_ABEOINTEN_DISABLE_END_OF_AUTO_ = 0x0
	// Enable end of auto-baud Interrupt.
	USART0_IER_ABEOINTEN_ENABLE_END_OF_AUTO_B = 0x1
	// Position of ABTOINTEN field.
	USART0_IER_ABTOINTEN_Pos = 0x9
	// Bit mask of ABTOINTEN field.
	USART0_IER_ABTOINTEN_Msk = 0x200
	// Bit ABTOINTEN.
	USART0_IER_ABTOINTEN = 0x200
	// Disable auto-baud time-out Interrupt.
	USART0_IER_ABTOINTEN_DISABLE_AUTO_BAUD_TI = 0x0
	// Enable auto-baud time-out Interrupt.
	USART0_IER_ABTOINTEN_ENABLE_AUTO_BAUD_TIM = 0x1
	// Position of RESERVED field.
	USART0_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	USART0_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	USART0_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	USART0_IIR_INTSTATUS = 0x1
	// At least one interrupt is pending.
	USART0_IIR_INTSTATUS_AT_LEAST_ONE_INTERRU = 0x0
	// No interrupt is pending.
	USART0_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1
	// Position of INTID field.
	USART0_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	USART0_IIR_INTID_Msk = 0xe
	// 1 - Receive Line Status (RLS).
	USART0_IIR_INTID_1_RECEIVE_LINE_S = 0x3
	// 2a - Receive Data Available (RDA).
	USART0_IIR_INTID_2A__RECEIVE_DATA_AV = 0x2
	// 2b - Character Time-out Indicator (CTI).
	USART0_IIR_INTID_2B__CHARACTER_TIME_ = 0x6
	// 3 - THRE Interrupt.
	USART0_IIR_INTID_3_THRE_INTERRUPT = 0x1
	// 4 - Modem status
	USART0_IIR_INTID_4_MODEM_STATUS = 0x0
	// Position of RESERVED field.
	USART0_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_IIR_RESERVED_Msk = 0x30
	// Position of FIFOEN field.
	USART0_IIR_FIFOEN_Pos = 0x6
	// Bit mask of FIFOEN field.
	USART0_IIR_FIFOEN_Msk = 0xc0
	// Position of ABEOINT field.
	USART0_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	USART0_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	USART0_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	USART0_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	USART0_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	USART0_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	USART0_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls USART FIFO usage and modes.
	// Position of FIFOEN field.
	USART0_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	USART0_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	USART0_FCR_FIFOEN = 0x1
	// USART FIFOs are disabled. Must not be used in the application.
	USART0_FCR_FIFOEN_DISABLED = 0x0
	// Active high enable for both USART Rx and TX FIFOs and FCR[7:1] access. This bit must be set for proper USART operation. Any transition on this bit will automatically clear the USART FIFOs.
	USART0_FCR_FIFOEN_ENABLED = 0x1
	// Position of RXFIFORES field.
	USART0_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	USART0_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	USART0_FCR_RXFIFORES = 0x2
	// No impact on either of USART FIFOs.
	USART0_FCR_RXFIFORES_NO_IMPACT = 0x0
	// Writing a logic 1 to FCR[1] will clear all bytes in USART Rx FIFO, reset the pointer logic. This bit is self-clearing.
	USART0_FCR_RXFIFORES_CLEAR = 0x1
	// Position of TXFIFORES field.
	USART0_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	USART0_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	USART0_FCR_TXFIFORES = 0x4
	// No impact on either of USART FIFOs.
	USART0_FCR_TXFIFORES_NO_IMPACT = 0x0
	// Writing a logic 1 to FCR[2] will clear all bytes in USART TX FIFO, reset the pointer logic. This bit is self-clearing.
	USART0_FCR_TXFIFORES_CLEAR = 0x1
	// Position of RESERVED field.
	USART0_FCR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART0_FCR_RESERVED_Msk = 0x8
	// Bit RESERVED.
	USART0_FCR_RESERVED = 0x8
	// Position of RESERVED field.
	USART0_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_FCR_RESERVED_Msk = 0x30
	// Position of RXTL field.
	USART0_FCR_RXTL_Pos = 0x6
	// Bit mask of RXTL field.
	USART0_FCR_RXTL_Msk = 0xc0
	// Trigger level 0 (1 character or 0x01).
	USART0_FCR_RXTL_TRIGGER_LEVEL_0_1_C = 0x0
	// Trigger level 1 (4 characters or 0x04).
	USART0_FCR_RXTL_TRIGGER_LEVEL_1_4_C = 0x1
	// Trigger level 2 (8 characters or 0x08).
	USART0_FCR_RXTL_TRIGGER_LEVEL_2_8_C = 0x2
	// Trigger level 3 (14 characters or 0x0E).
	USART0_FCR_RXTL_TRIGGER_LEVEL_3_14_ = 0x3
	// Position of RESERVED field.
	USART0_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	USART0_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	USART0_LCR_WLS_Msk = 0x3
	// 5-bit character length.
	USART0_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length.
	USART0_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length.
	USART0_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length.
	USART0_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	USART0_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	USART0_LCR_SBS_Msk = 0x4
	// Bit SBS.
	USART0_LCR_SBS = 0x4
	// 1 stop bit.
	USART0_LCR_SBS_1_STOP_BIT_ = 0x0
	// 2 stop bits (1.5 if LCR[1:0]=00).
	USART0_LCR_SBS_2_STOP_BITS_1_5_IF_ = 0x1
	// Position of PE field.
	USART0_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	USART0_LCR_PE_Msk = 0x8
	// Bit PE.
	USART0_LCR_PE = 0x8
	// Disable parity generation and checking.
	USART0_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	USART0_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	USART0_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	USART0_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	USART0_LCR_PS_ODD_PARITY_NUMBER_O = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	USART0_LCR_PS_EVEN_PARITY_NUMBER_ = 0x1
	// Forced 1 stick parity.
	USART0_LCR_PS_FORCED_1_STICK_PARIT = 0x2
	// Forced 0 stick parity.
	USART0_LCR_PS_FORCED_0_STICK_PARIT = 0x3
	// Position of BC field.
	USART0_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	USART0_LCR_BC_Msk = 0x40
	// Bit BC.
	USART0_LCR_BC = 0x40
	// Disable break transmission.
	USART0_LCR_BC_DISABLE_BREAK_TRANSM = 0x0
	// Enable break transmission. Output pin USART TXD is forced to logic 0 when LCR[6] is active high.
	USART0_LCR_BC_ENABLE_BREAK_TRANSMI = 0x1
	// Position of DLAB field.
	USART0_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	USART0_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	USART0_LCR_DLAB = 0x80
	// Disable access to Divisor Latches.
	USART0_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0
	// Enable access to Divisor Latches.
	USART0_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1
	// Position of RESERVED field.
	USART0_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_LCR_RESERVED_Msk = 0xffffff00

	// MCR: Modem Control Register.
	// Position of DTRCTRL field.
	USART0_MCR_DTRCTRL_Pos = 0x0
	// Bit mask of DTRCTRL field.
	USART0_MCR_DTRCTRL_Msk = 0x1
	// Bit DTRCTRL.
	USART0_MCR_DTRCTRL = 0x1
	// Position of RTSCTRL field.
	USART0_MCR_RTSCTRL_Pos = 0x1
	// Bit mask of RTSCTRL field.
	USART0_MCR_RTSCTRL_Msk = 0x2
	// Bit RTSCTRL.
	USART0_MCR_RTSCTRL = 0x2
	// Position of RESERVED field.
	USART0_MCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	USART0_MCR_RESERVED_Msk = 0xc
	// Position of LMS field.
	USART0_MCR_LMS_Pos = 0x4
	// Bit mask of LMS field.
	USART0_MCR_LMS_Msk = 0x10
	// Bit LMS.
	USART0_MCR_LMS = 0x10
	// Disable modem loopback mode.
	USART0_MCR_LMS_DISABLE_MODEM_LOOPBA = 0x0
	// Enable modem loopback mode.
	USART0_MCR_LMS_ENABLE_MODEM_LOOPBAC = 0x1
	// Position of RESERVED field.
	USART0_MCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USART0_MCR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	USART0_MCR_RESERVED = 0x20
	// Position of RTSEN field.
	USART0_MCR_RTSEN_Pos = 0x6
	// Bit mask of RTSEN field.
	USART0_MCR_RTSEN_Msk = 0x40
	// Bit RTSEN.
	USART0_MCR_RTSEN = 0x40
	// Disable auto-rts flow control.
	USART0_MCR_RTSEN_DISABLE_AUTO_RTS_FLO = 0x0
	// Enable auto-rts flow control.
	USART0_MCR_RTSEN_ENABLE_AUTO_RTS_FLOW = 0x1
	// Position of CTSEN field.
	USART0_MCR_CTSEN_Pos = 0x7
	// Bit mask of CTSEN field.
	USART0_MCR_CTSEN_Msk = 0x80
	// Bit CTSEN.
	USART0_MCR_CTSEN = 0x80
	// Disable auto-cts flow control.
	USART0_MCR_CTSEN_DISABLE_AUTO_CTS_FLO = 0x0
	// Enable auto-cts flow control.
	USART0_MCR_CTSEN_ENABLE_AUTO_CTS_FLOW = 0x1
	// Position of RESERVED field.
	USART0_MCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_MCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	USART0_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART0_LSR_RDR_Msk = 0x1
	// Bit RDR.
	USART0_LSR_RDR = 0x1
	// RBR is empty.
	USART0_LSR_RDR_RBR_IS_EMPTY_ = 0x0
	// RBR contains valid data.
	USART0_LSR_RDR_RBR_CONTAINS_VALID_D = 0x1
	// Position of OE field.
	USART0_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	USART0_LSR_OE_Msk = 0x2
	// Bit OE.
	USART0_LSR_OE = 0x2
	// Overrun error status is inactive.
	USART0_LSR_OE_INACTIVE = 0x0
	// Overrun error status is active.
	USART0_LSR_OE_ACTIVE = 0x1
	// Position of PE field.
	USART0_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	USART0_LSR_PE_Msk = 0x4
	// Bit PE.
	USART0_LSR_PE = 0x4
	// Parity error status is inactive.
	USART0_LSR_PE_INACTIVE = 0x0
	// Parity error status is active.
	USART0_LSR_PE_ACTIVE = 0x1
	// Position of FE field.
	USART0_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	USART0_LSR_FE_Msk = 0x8
	// Bit FE.
	USART0_LSR_FE = 0x8
	// Framing error status is inactive.
	USART0_LSR_FE_INACTIVE = 0x0
	// Framing error status is active.
	USART0_LSR_FE_ACTIVE = 0x1
	// Position of BI field.
	USART0_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	USART0_LSR_BI_Msk = 0x10
	// Bit BI.
	USART0_LSR_BI = 0x10
	// Break interrupt status is inactive.
	USART0_LSR_BI_INACTIVE = 0x0
	// Break interrupt status is active.
	USART0_LSR_BI_ACTIVE = 0x1
	// Position of THRE field.
	USART0_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	USART0_LSR_THRE_Msk = 0x20
	// Bit THRE.
	USART0_LSR_THRE = 0x20
	// THR contains valid data.
	USART0_LSR_THRE_THR_CONTAINS_VALID_D = 0x0
	// THR is empty.
	USART0_LSR_THRE_THR_IS_EMPTY_ = 0x1
	// Position of TEMT field.
	USART0_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	USART0_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	USART0_LSR_TEMT = 0x40
	// THR and/or the TSR contains valid data.
	USART0_LSR_TEMT_VALID_D = 0x0
	// THR and the TSR are empty.
	USART0_LSR_TEMT_EMPTY = 0x1
	// Position of RXFE field.
	USART0_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	USART0_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	USART0_LSR_RXFE = 0x80
	// RBR contains no USART RX errors or FCR[0]=0.
	USART0_LSR_RXFE_NO_ERROR = 0x0
	// USART RBR contains at least one USART RX error.
	USART0_LSR_RXFE_ERRO = 0x1
	// Position of TXERR field.
	USART0_LSR_TXERR_Pos = 0x8
	// Bit mask of TXERR field.
	USART0_LSR_TXERR_Msk = 0x100
	// Bit TXERR.
	USART0_LSR_TXERR = 0x100
	// Position of RESERVED field.
	USART0_LSR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_LSR_RESERVED_Msk = 0xfffffe00

	// MSR: Modem Status Register.
	// Position of DCTS field.
	USART0_MSR_DCTS_Pos = 0x0
	// Bit mask of DCTS field.
	USART0_MSR_DCTS_Msk = 0x1
	// Bit DCTS.
	USART0_MSR_DCTS = 0x1
	// No change detected on modem input, CTS.
	USART0_MSR_DCTS_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, CTS.
	USART0_MSR_DCTS_STATE_CHANGE_DETECTE = 0x1
	// Position of DDSR field.
	USART0_MSR_DDSR_Pos = 0x1
	// Bit mask of DDSR field.
	USART0_MSR_DDSR_Msk = 0x2
	// Bit DDSR.
	USART0_MSR_DDSR = 0x2
	// No change detected on modem input, DSR.
	USART0_MSR_DDSR_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DSR.
	USART0_MSR_DDSR_STATE_CHANGE_DETECTE = 0x1
	// Position of TERI field.
	USART0_MSR_TERI_Pos = 0x2
	// Bit mask of TERI field.
	USART0_MSR_TERI_Msk = 0x4
	// Bit TERI.
	USART0_MSR_TERI = 0x4
	// No change detected on modem input, RI.
	USART0_MSR_TERI_NO_CHANGE_DETECTED_O = 0x0
	// Low-to-high transition detected on RI.
	USART0_MSR_TERI_LOW_TO_HIGH_TRANSITI = 0x1
	// Position of DDCD field.
	USART0_MSR_DDCD_Pos = 0x3
	// Bit mask of DDCD field.
	USART0_MSR_DDCD_Msk = 0x8
	// Bit DDCD.
	USART0_MSR_DDCD = 0x8
	// No change detected on modem input, DCD.
	USART0_MSR_DDCD_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DCD.
	USART0_MSR_DDCD_STATE_CHANGE_DETECTE = 0x1
	// Position of CTS field.
	USART0_MSR_CTS_Pos = 0x4
	// Bit mask of CTS field.
	USART0_MSR_CTS_Msk = 0x10
	// Bit CTS.
	USART0_MSR_CTS = 0x10
	// Position of DSR field.
	USART0_MSR_DSR_Pos = 0x5
	// Bit mask of DSR field.
	USART0_MSR_DSR_Msk = 0x20
	// Bit DSR.
	USART0_MSR_DSR = 0x20
	// Position of RI field.
	USART0_MSR_RI_Pos = 0x6
	// Bit mask of RI field.
	USART0_MSR_RI_Msk = 0x40
	// Bit RI.
	USART0_MSR_RI = 0x40
	// Position of DCD field.
	USART0_MSR_DCD_Pos = 0x7
	// Bit mask of DCD field.
	USART0_MSR_DCD_Msk = 0x80
	// Bit DCD.
	USART0_MSR_DCD = 0x80
	// Position of RESERVED field.
	USART0_MSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_MSR_RESERVED_Msk = 0xffffff00

	// SCR: Scratch Pad Register. Eight-bit temporary storage for software.
	// Position of PAD field.
	USART0_SCR_PAD_Pos = 0x0
	// Bit mask of PAD field.
	USART0_SCR_PAD_Msk = 0xff
	// Position of RESERVED field.
	USART0_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	USART0_ACR_START_Pos = 0x0
	// Bit mask of START field.
	USART0_ACR_START_Msk = 0x1
	// Bit START.
	USART0_ACR_START = 0x1
	// Auto-baud stop (auto-baud is not running).
	USART0_ACR_START_AUTO_BAUD_STOP_AUTO = 0x0
	// Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	USART0_ACR_START_AUTO_BAUD_START_AUT = 0x1
	// Position of MODE field.
	USART0_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	USART0_ACR_MODE_Msk = 0x2
	// Bit MODE.
	USART0_ACR_MODE = 0x2
	// Mode 0.
	USART0_ACR_MODE_MODE_0_ = 0x0
	// Mode 1.
	USART0_ACR_MODE_MODE_1_ = 0x1
	// Position of AUTORESTART field.
	USART0_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	USART0_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	USART0_ACR_AUTORESTART = 0x4
	// No restart
	USART0_ACR_AUTORESTART_NO_RESTART = 0x0
	// Restart in case of time-out (counter restarts at next USART Rx falling edge)
	USART0_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1
	// Position of RESERVED field.
	USART0_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART0_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	USART0_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	USART0_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	USART0_ACR_ABEOINTCLR = 0x100
	// Writing a 0 has no impact.
	USART0_ACR_ABEOINTCLR_NO_IMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	USART0_ACR_ABEOINTCLR_CLEAR = 0x1
	// Position of ABTOINTCLR field.
	USART0_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	USART0_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	USART0_ACR_ABTOINTCLR = 0x200
	// Writing a 0 has no impact.
	USART0_ACR_ABTOINTCLR_NO_IMPACT = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	USART0_ACR_ABTOINTCLR_CLEAR = 0x1
	// Position of RESERVED field.
	USART0_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_ACR_RESERVED_Msk = 0xfffffc00

	// ICR: IrDA Control Register. Enables and configures the IrDA (remote control) mode.
	// Position of IRDAEN field.
	USART0_ICR_IRDAEN_Pos = 0x0
	// Bit mask of IRDAEN field.
	USART0_ICR_IRDAEN_Msk = 0x1
	// Bit IRDAEN.
	USART0_ICR_IRDAEN = 0x1
	// IrDA mode is disabled, USARTn acts as a standard USART.
	USART0_ICR_IRDAEN_IRDA_MODE_IS_DISABLE = 0x0
	// IrDA mode is enabled.
	USART0_ICR_IRDAEN_IRDA_MODE_IS_ENABLED = 0x1
	// Position of IRDAINV field.
	USART0_ICR_IRDAINV_Pos = 0x1
	// Bit mask of IRDAINV field.
	USART0_ICR_IRDAINV_Msk = 0x2
	// Bit IRDAINV.
	USART0_ICR_IRDAINV = 0x2
	// The serial input is not inverted.
	USART0_ICR_IRDAINV_INVERTED = 0x0
	// The serial input is inverted. This has no effect on the serial output.
	USART0_ICR_IRDAINV_NOT_INVERTED = 0x1
	// Position of FIXPULSEEN field.
	USART0_ICR_FIXPULSEEN_Pos = 0x2
	// Bit mask of FIXPULSEEN field.
	USART0_ICR_FIXPULSEEN_Msk = 0x4
	// Bit FIXPULSEEN.
	USART0_ICR_FIXPULSEEN = 0x4
	// IrDA fixed pulse width mode disabled.
	USART0_ICR_FIXPULSEEN_DISABLED = 0x0
	// IrDA fixed pulse width mode enabled.
	USART0_ICR_FIXPULSEEN_ENABLED = 0x1
	// Position of PULSEDIV field.
	USART0_ICR_PULSEDIV_Pos = 0x3
	// Bit mask of PULSEDIV field.
	USART0_ICR_PULSEDIV_Msk = 0x38
	// 3 / (16 x baud rate)
	USART0_ICR_PULSEDIV_3_DIV_16_X_BAUD_RATE = 0x0
	// 2 x TPCLK
	USART0_ICR_PULSEDIV_2_X_TPCLK = 0x1
	// 4 x TPCLK
	USART0_ICR_PULSEDIV_4_X_TPCLK = 0x2
	// 8 x TPCLK
	USART0_ICR_PULSEDIV_8_X_TPCLK = 0x3
	// 16 x TPCLK
	USART0_ICR_PULSEDIV_16_X_TPCLK = 0x4
	// 32 x TPCLK
	USART0_ICR_PULSEDIV_32_X_TPCLK = 0x5
	// 64 x TPCLK
	USART0_ICR_PULSEDIV_64_X_TPCLK = 0x6
	// 128 x TPCLK
	USART0_ICR_PULSEDIV_128_X_TPCLK = 0x7
	// Position of RESERVED field.
	USART0_ICR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART0_ICR_RESERVED_Msk = 0xffffffc0

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	USART0_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	USART0_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	USART0_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	USART0_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	USART0_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_FDR_RESERVED_Msk = 0xffffff00

	// OSR: Oversampling Register. Controls the degree of oversampling during each bit time.
	// Position of RESERVED field.
	USART0_OSR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART0_OSR_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART0_OSR_RESERVED = 0x1
	// Position of OSFRAC field.
	USART0_OSR_OSFRAC_Pos = 0x1
	// Bit mask of OSFRAC field.
	USART0_OSR_OSFRAC_Msk = 0xe
	// Position of OSINT field.
	USART0_OSR_OSINT_Pos = 0x4
	// Bit mask of OSINT field.
	USART0_OSR_OSINT_Msk = 0xf0
	// Position of FDINT field.
	USART0_OSR_FDINT_Pos = 0x8
	// Bit mask of FDINT field.
	USART0_OSR_FDINT_Msk = 0x7f00
	// Position of RESERVED field.
	USART0_OSR_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	USART0_OSR_RESERVED_Msk = 0xffff8000

	// TER: Transmit Enable Register. Turns off USART transmitter for use with software flow control.
	// Position of RESERVED field.
	USART0_TER_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART0_TER_RESERVED_Msk = 0x7f
	// Position of TXEN field.
	USART0_TER_TXEN_Pos = 0x7
	// Bit mask of TXEN field.
	USART0_TER_TXEN_Msk = 0x80
	// Bit TXEN.
	USART0_TER_TXEN = 0x80
	// Position of RESERVED field.
	USART0_TER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_TER_RESERVED_Msk = 0xffffff00

	// HDEN: Half duplex enable register.
	// Position of HDEN field.
	USART0_HDEN_HDEN_Pos = 0x0
	// Bit mask of HDEN field.
	USART0_HDEN_HDEN_Msk = 0x1
	// Bit HDEN.
	USART0_HDEN_HDEN = 0x1
	// Disable half-duplex mode.
	USART0_HDEN_HDEN_DISABLE_HALF_DUPLEX_ = 0x0
	// Enable half-duplex mode.
	USART0_HDEN_HDEN_ENABLE_HALF_DUPLEX_M = 0x1
	// Position of RESERVED field.
	USART0_HDEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_HDEN_RESERVED_Msk = 0xfffffffe

	// SCICTRL: Smart Card Interface Control register. Enables and configures the Smart Card Interface feature.
	// Position of SCIEN field.
	USART0_SCICTRL_SCIEN_Pos = 0x0
	// Bit mask of SCIEN field.
	USART0_SCICTRL_SCIEN_Msk = 0x1
	// Bit SCIEN.
	USART0_SCICTRL_SCIEN = 0x1
	// Smart card interface disabled.
	USART0_SCICTRL_SCIEN_SMART_CARD_INTERFACE = 0x0
	// Asynchronous half duplex smart card interface is enabled.
	USART0_SCICTRL_SCIEN_ASYNCHRONOUS_HALF_DU = 0x1
	// Position of NACKDIS field.
	USART0_SCICTRL_NACKDIS_Pos = 0x1
	// Bit mask of NACKDIS field.
	USART0_SCICTRL_NACKDIS_Msk = 0x2
	// Bit NACKDIS.
	USART0_SCICTRL_NACKDIS = 0x2
	// A NACK response is enabled.
	USART0_SCICTRL_NACKDIS_ENABLED = 0x0
	// A NACK response is inhibited.
	USART0_SCICTRL_NACKDIS_DISABLED = 0x1
	// Position of PROTSEL field.
	USART0_SCICTRL_PROTSEL_Pos = 0x2
	// Bit mask of PROTSEL field.
	USART0_SCICTRL_PROTSEL_Msk = 0x4
	// Bit PROTSEL.
	USART0_SCICTRL_PROTSEL = 0x4
	// T = 0
	USART0_SCICTRL_PROTSEL_T_EQ_0 = 0x0
	// T = 1
	USART0_SCICTRL_PROTSEL_T_EQ_1 = 0x1
	// Position of RESERVED field.
	USART0_SCICTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART0_SCICTRL_RESERVED_Msk = 0x18
	// Position of TXRETRY field.
	USART0_SCICTRL_TXRETRY_Pos = 0x5
	// Bit mask of TXRETRY field.
	USART0_SCICTRL_TXRETRY_Msk = 0xe0
	// Position of XTRAGUARD field.
	USART0_SCICTRL_XTRAGUARD_Pos = 0x8
	// Bit mask of XTRAGUARD field.
	USART0_SCICTRL_XTRAGUARD_Msk = 0xff00
	// Position of RESERVED field.
	USART0_SCICTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART0_SCICTRL_RESERVED_Msk = 0xffff0000

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	USART0_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	USART0_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	USART0_RS485CTRL_NMMEN = 0x1
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	USART0_RS485CTRL_NMMEN_DISABLED = 0x0
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte causes the USART to set the parity error and generate an interrupt.
	USART0_RS485CTRL_NMMEN_ENABLED = 0x1
	// Position of RXDIS field.
	USART0_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	USART0_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	USART0_RS485CTRL_RXDIS = 0x2
	// The receiver is enabled.
	USART0_RS485CTRL_RXDIS_THE_RECEIVER_IS_ENAB = 0x0
	// The receiver is disabled.
	USART0_RS485CTRL_RXDIS_THE_RECEIVER_IS_DISA = 0x1
	// Position of AADEN field.
	USART0_RS485CTRL_AADEN_Pos = 0x2
	// Bit mask of AADEN field.
	USART0_RS485CTRL_AADEN_Msk = 0x4
	// Bit AADEN.
	USART0_RS485CTRL_AADEN = 0x4
	// Position of SEL field.
	USART0_RS485CTRL_SEL_Pos = 0x3
	// Bit mask of SEL field.
	USART0_RS485CTRL_SEL_Msk = 0x8
	// Bit SEL.
	USART0_RS485CTRL_SEL = 0x8
	// If direction control is enabled (bit DCTRL = 1), pin RTS is used for direction control.
	USART0_RS485CTRL_SEL_RTS = 0x0
	// If direction control is enabled (bit DCTRL = 1), pin DTR is used for direction control.
	USART0_RS485CTRL_SEL_DTR = 0x1
	// Position of DCTRL field.
	USART0_RS485CTRL_DCTRL_Pos = 0x4
	// Bit mask of DCTRL field.
	USART0_RS485CTRL_DCTRL_Msk = 0x10
	// Bit DCTRL.
	USART0_RS485CTRL_DCTRL = 0x10
	// Disable Auto Direction Control.
	USART0_RS485CTRL_DCTRL_DISABLE_AUTO_DIRECTI = 0x0
	// Enable Auto Direction Control.
	USART0_RS485CTRL_DCTRL_ENABLE_AUTO_DIRECTIO = 0x1
	// Position of OINV field.
	USART0_RS485CTRL_OINV_Pos = 0x5
	// Bit mask of OINV field.
	USART0_RS485CTRL_OINV_Msk = 0x20
	// Bit OINV.
	USART0_RS485CTRL_OINV = 0x20
	// The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	USART0_RS485CTRL_OINV_LOW = 0x0
	// The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	USART0_RS485CTRL_OINV_HIGH = 0x1
	// Position of RESERVED field.
	USART0_RS485CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USART0_RS485CTRL_RESERVED_Msk = 0xffffffc0

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	// Position of ADRMATCH field.
	USART0_RS485ADRMATCH_ADRMATCH_Pos = 0x0
	// Bit mask of ADRMATCH field.
	USART0_RS485ADRMATCH_ADRMATCH_Msk = 0xff
	// Position of RESERVED field.
	USART0_RS485ADRMATCH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_RS485ADRMATCH_RESERVED_Msk = 0xffffff00

	// RS485DLY: RS-485/EIA-485 direction control delay.
	// Position of DLY field.
	USART0_RS485DLY_DLY_Pos = 0x0
	// Bit mask of DLY field.
	USART0_RS485DLY_DLY_Msk = 0xff
	// Position of RESERVED field.
	USART0_RS485DLY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_RS485DLY_RESERVED_Msk = 0xffffff00

	// SYNCCTRL: Synchronous mode control register.
	// Position of SYNC field.
	USART0_SYNCCTRL_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	USART0_SYNCCTRL_SYNC_Msk = 0x1
	// Bit SYNC.
	USART0_SYNCCTRL_SYNC = 0x1
	// Disabled
	USART0_SYNCCTRL_SYNC_DISABLED = 0x0
	// Enabled
	USART0_SYNCCTRL_SYNC_ENABLED = 0x1
	// Position of CSRC field.
	USART0_SYNCCTRL_CSRC_Pos = 0x1
	// Bit mask of CSRC field.
	USART0_SYNCCTRL_CSRC_Msk = 0x2
	// Bit CSRC.
	USART0_SYNCCTRL_CSRC = 0x2
	// Synchronous slave mode (SCLK in)
	USART0_SYNCCTRL_CSRC_SYNCHRONOUS_SLAVE_MO = 0x0
	// Synchronous master mode (SCLK out)
	USART0_SYNCCTRL_CSRC_SYNCHRONOUS_MASTER_M = 0x1
	// Position of FES field.
	USART0_SYNCCTRL_FES_Pos = 0x2
	// Bit mask of FES field.
	USART0_SYNCCTRL_FES_Msk = 0x4
	// Bit FES.
	USART0_SYNCCTRL_FES = 0x4
	// RxD is sampled on the rising edge of SCLK
	USART0_SYNCCTRL_FES_RISING = 0x0
	// RxD is sampled on the falling edge of SCLK
	USART0_SYNCCTRL_FES_FALLING = 0x1
	// Position of TSBYPASS field.
	USART0_SYNCCTRL_TSBYPASS_Pos = 0x3
	// Bit mask of TSBYPASS field.
	USART0_SYNCCTRL_TSBYPASS_Msk = 0x8
	// Bit TSBYPASS.
	USART0_SYNCCTRL_TSBYPASS = 0x8
	// The input clock is synchronized prior to being used in clock edge detection logic
	USART0_SYNCCTRL_TSBYPASS_SYNC = 0x0
	// The input clock is not synchronized prior to being used in clock edge detection logic. This allows for a high er input clock rate at the expense of potential metastability.
	USART0_SYNCCTRL_TSBYPASS_NOSYNC = 0x1
	// Position of CSCEN field.
	USART0_SYNCCTRL_CSCEN_Pos = 0x4
	// Bit mask of CSCEN field.
	USART0_SYNCCTRL_CSCEN_Msk = 0x10
	// Bit CSCEN.
	USART0_SYNCCTRL_CSCEN = 0x10
	// SCLK cycles only when characters are being sent on TxD
	USART0_SYNCCTRL_CSCEN_SCLK_CYCLES_ONLY_WHE = 0x0
	// SCLK runs continuously (characters can be received on RxD independently from transmission on TxD)
	USART0_SYNCCTRL_CSCEN_SCLK_RUNS_CONTINUOUS = 0x1
	// Position of SSDIS field.
	USART0_SYNCCTRL_SSDIS_Pos = 0x5
	// Bit mask of SSDIS field.
	USART0_SYNCCTRL_SSDIS_Msk = 0x20
	// Bit SSDIS.
	USART0_SYNCCTRL_SSDIS = 0x20
	// Send start and stop bits as in other modes.
	USART0_SYNCCTRL_SSDIS_SEND_START_AND_STOP_ = 0x0
	// Do not send start/stop bits.
	USART0_SYNCCTRL_SSDIS_DO_NOT_SEND_STARTSTOP = 0x1
	// Position of CCCLR field.
	USART0_SYNCCTRL_CCCLR_Pos = 0x6
	// Bit mask of CCCLR field.
	USART0_SYNCCTRL_CCCLR_Msk = 0x40
	// Bit CCCLR.
	USART0_SYNCCTRL_CCCLR = 0x40
	// CSCEN is under software control.
	USART0_SYNCCTRL_CCCLR_CSCEN_IS_UNDER_SOFTW = 0x0
	// Hardware clears CSCEN after each character is received.
	USART0_SYNCCTRL_CCCLR_HARDWARE_CLEARS_CSCE = 0x1
	// Position of RESERVED field.
	USART0_SYNCCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_SYNCCTRL_RESERVED_Msk = 0xffffff80
)

// Bitfields for CT16B0: 16-bit counter/timers CT16B0
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT16B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT16B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT16B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT16B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT16B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT16B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT16B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT16B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT16B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT16B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT16B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT16B0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT16B0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT16B0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT16B0_IR_CR0INT = 0x10
	// Position of CR1INT field.
	CT16B0_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	CT16B0_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	CT16B0_IR_CR1INT = 0x20
	// Position of CR2INT field.
	CT16B0_IR_CR2INT_Pos = 0x6
	// Bit mask of CR2INT field.
	CT16B0_IR_CR2INT_Msk = 0x40
	// Bit CR2INT.
	CT16B0_IR_CR2INT = 0x40
	// Position of RESERVED field.
	CT16B0_IR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CT16B0_IR_RESERVED_Msk = 0xffffff80

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT16B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT16B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT16B0_TCR_CEN = 0x1
	// The counters are disabled.
	CT16B0_TCR_CEN_DISABLED = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT16B0_TCR_CEN_ENABLED = 0x1
	// Position of CRST field.
	CT16B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT16B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT16B0_TCR_CRST = 0x2
	// Do nothing.
	CT16B0_TCR_CRST_NOP = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT16B0_TCR_CRST_RESET = 0x1
	// Position of RESERVED field.
	CT16B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT16B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 16-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TCVAL field.
	CT16B0_TC_TCVAL_Pos = 0x0
	// Bit mask of TCVAL field.
	CT16B0_TC_TCVAL_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_TC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_TC_RESERVED_Msk = 0xffff0000

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT16B0_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT16B0_PR_PCVAL_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PR_RESERVED_Msk = 0xffff0000

	// PC: Prescale Counter. The 16-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT16B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT16B0_PC_PC_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_PC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_PC_RESERVED_Msk = 0xffff0000

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT16B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT16B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT16B0_MCR_MR0I = 0x1
	// Enabled
	CT16B0_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT16B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT16B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT16B0_MCR_MR0R = 0x2
	// Enabled
	CT16B0_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT16B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT16B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT16B0_MCR_MR0S = 0x4
	// Enabled
	CT16B0_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT16B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT16B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT16B0_MCR_MR1I = 0x8
	// Enabled
	CT16B0_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT16B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT16B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT16B0_MCR_MR1R = 0x10
	// Enabled
	CT16B0_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT16B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT16B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT16B0_MCR_MR1S = 0x20
	// Enabled
	CT16B0_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT16B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT16B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT16B0_MCR_MR2I = 0x40
	// Enabled
	CT16B0_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT16B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT16B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT16B0_MCR_MR2R = 0x80
	// Enabled
	CT16B0_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT16B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT16B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT16B0_MCR_MR2S = 0x100
	// Enabled
	CT16B0_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT16B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT16B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT16B0_MCR_MR3I = 0x200
	// Enabled
	CT16B0_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT16B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT16B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT16B0_MCR_MR3R = 0x400
	// Enabled
	CT16B0_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT16B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT16B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT16B0_MCR_MR3S = 0x800
	// Enabled
	CT16B0_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT16B0_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT16B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	CT16B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT16B0_MR_MATCH_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_MR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_MR_RESERVED_Msk = 0xffff0000

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT16B0_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT16B0_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT16B0_CCR_CAP0RE = 0x1
	// Enabled.
	CT16B0_CCR_CAP0RE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP0RE_DISABLED = 0x0
	// Position of CAP0FE field.
	CT16B0_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT16B0_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT16B0_CCR_CAP0FE = 0x2
	// Enabled.
	CT16B0_CCR_CAP0FE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP0FE_DISABLED = 0x0
	// Position of CAP0I field.
	CT16B0_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT16B0_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT16B0_CCR_CAP0I = 0x4
	// Enabled.
	CT16B0_CCR_CAP0I_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP0I_DISABLED = 0x0
	// Position of CAP1RE field.
	CT16B0_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	CT16B0_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	CT16B0_CCR_CAP1RE = 0x8
	// Enabled.
	CT16B0_CCR_CAP1RE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP1RE_DISABLED = 0x0
	// Position of CAP1FE field.
	CT16B0_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	CT16B0_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	CT16B0_CCR_CAP1FE = 0x10
	// Enabled.
	CT16B0_CCR_CAP1FE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP1FE_DISABLED = 0x0
	// Position of CAP1I field.
	CT16B0_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	CT16B0_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	CT16B0_CCR_CAP1I = 0x20
	// Enabled.
	CT16B0_CCR_CAP1I_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP1I_DISABLED = 0x0
	// Position of CAP2RE field.
	CT16B0_CCR_CAP2RE_Pos = 0x6
	// Bit mask of CAP2RE field.
	CT16B0_CCR_CAP2RE_Msk = 0x40
	// Bit CAP2RE.
	CT16B0_CCR_CAP2RE = 0x40
	// Enabled.
	CT16B0_CCR_CAP2RE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP2RE_DISABLED = 0x0
	// Position of CAP2FE field.
	CT16B0_CCR_CAP2FE_Pos = 0x7
	// Bit mask of CAP2FE field.
	CT16B0_CCR_CAP2FE_Msk = 0x80
	// Bit CAP2FE.
	CT16B0_CCR_CAP2FE = 0x80
	// Enabled.
	CT16B0_CCR_CAP2FE_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP2FE_DISABLED = 0x0
	// Position of CAP2I field.
	CT16B0_CCR_CAP2I_Pos = 0x8
	// Bit mask of CAP2I field.
	CT16B0_CCR_CAP2I_Msk = 0x100
	// Bit CAP2I.
	CT16B0_CCR_CAP2I = 0x100
	// Enabled.
	CT16B0_CCR_CAP2I_ENABLED = 0x1
	// Disabled.
	CT16B0_CCR_CAP2I_DISABLED = 0x0
	// Position of RESERVED field.
	CT16B0_CCR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	CT16B0_CCR_RESERVED_Msk = 0xfffffe00

	// CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
	// Position of CAP field.
	CT16B0_CR_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT16B0_CR_CAP_Msk = 0xffff
	// Position of RESERVED field.
	CT16B0_CR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	CT16B0_CR_RESERVED_Msk = 0xffff0000

	// EMR: External Match Register. The EMR controls the match function and the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
	// Position of EM0 field.
	CT16B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT16B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT16B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT16B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT16B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT16B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT16B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT16B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT16B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT16B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT16B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT16B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT16B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT16B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT16B0_EMR_EMC0_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC0_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC0_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC0_TOGGLE = 0x3
	// Position of EMC1 field.
	CT16B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT16B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT16B0_EMR_EMC1_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC1_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC1_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC1_TOGGLE = 0x3
	// Position of EMC2 field.
	CT16B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT16B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT16B0_EMR_EMC2_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC2_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC2_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC2_TOGGLE = 0x3
	// Position of EMC3 field.
	CT16B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT16B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT16B0_EMR_EMC3_NOP = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (CT16Bn_MAT0 pin is LOW if pinned out).
	CT16B0_EMR_EMC3_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (CT16Bn_MAT0 pin is HIGH if pinned out).
	CT16B0_EMR_EMC3_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT16B0_EMR_EMC3_TOGGLE = 0x3
	// Position of RESERVED field.
	CT16B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT16B0_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT16B0_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT16B0_CTCR_CTM_Msk = 0x3
	// Timer Mode. Increments every rising PCLK edge
	CT16B0_CTCR_CTM_TIMER_MODE = 0x0
	// Counter Moderising edge. . TC is incremented on rising edges on the CAP input selected by bits 3:2.
	CT16B0_CTCR_CTM_RISING = 0x1
	// Counter Mode falling edge: TC is incremented on falling edges on the CAP input selected by bits 3:2.
	CT16B0_CTCR_CTM_FALLING = 0x2
	// Counter Mode dual edge: TC is incremented on both edges on the CAP input selected by bits 3:2.
	CT16B0_CTCR_CTM_DUAL = 0x3
	// Position of CIS field.
	CT16B0_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT16B0_CTCR_CIS_Msk = 0xc
	// Capture channel 0.
	CT16B0_CTCR_CIS_CAPTURE_CHANNEL_0 = 0x0
	// Capture channel 1.
	CT16B0_CTCR_CIS_CAPTURE_CHANNEL_1 = 0x1
	// Capture channel 2.
	CT16B0_CTCR_CIS_CAPTURE_CHANNEL_2 = 0x2
	// Position of ENCC field.
	CT16B0_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT16B0_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT16B0_CTCR_ENCC = 0x10
	// Position of SELCC field.
	CT16B0_CTCR_SELCC_Pos = 0x5
	// Bit mask of SELCC field.
	CT16B0_CTCR_SELCC_Msk = 0xe0
	// Rising Edge of thesignal on capture channel 0 clears the timer (if bit 4 is set).
	CT16B0_CTCR_SELCC_CAP0RISING = 0x0
	// Falling Edge of thesignal on capture channel 0 clears the timer (if bit 4 is set).
	CT16B0_CTCR_SELCC_CAP0FALLING = 0x1
	// Rising Edge of thesignal on capture channel 1 clears the timer (if bit 4 is set).
	CT16B0_CTCR_SELCC_CAP1RISING = 0x2
	// Rising Edge of thesignal on capture channel 2 clears the timer (if bit 4 is set).
	CT16B0_CTCR_SELCC_CAP2RISING = 0x4
	// Position of RESERVED field.
	CT16B0_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT16B0_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT16B0_MAT[1:0] and CT16B1_MAT[1:0].
	// Position of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT16B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT16B0_PWMC_PWMEN0 = 0x1
	// CT16Bn_MAT0 is controlled by EM0.
	CT16B0_PWMC_PWMEN0_EM0 = 0x0
	// PWM mode is enabled for CT16Bn_MAT0.
	CT16B0_PWMC_PWMEN0_PWM = 0x1
	// Position of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT16B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT16B0_PWMC_PWMEN1 = 0x2
	// CT16Bn_MAT01 is controlled by EM1.
	CT16B0_PWMC_PWMEN1_EM1 = 0x0
	// PWM mode is enabled for CT16Bn_MAT1.
	CT16B0_PWMC_PWMEN1_PWM = 0x1
	// Position of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT16B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT16B0_PWMC_PWMEN2 = 0x4
	// CT16Bn_MAT2 is controlled by EM2.
	CT16B0_PWMC_PWMEN2_EM2 = 0x0
	// PWM mode is enabled for CT16Bn_MAT2.
	CT16B0_PWMC_PWMEN2_PWM = 0x1
	// Position of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT16B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT16B0_PWMC_PWMEN3 = 0x8
	// CT16Bn_MAT3 is controlled by EM3.
	CT16B0_PWMC_PWMEN3_EM3 = 0x0
	// PWM mode is enabled for CT16Bn_MAT3.
	CT16B0_PWMC_PWMEN3_PWM = 0x1
	// Position of RESERVED field.
	CT16B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT16B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for CT32B0: 32-bit counter/timers CT32B0
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT32B0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT32B0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT32B0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT32B0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT32B0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT32B0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT32B0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT32B0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT32B0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT32B0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT32B0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT32B0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT32B0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT32B0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT32B0_IR_CR0INT = 0x10
	// Position of CR1INT field.
	CT32B0_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	CT32B0_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	CT32B0_IR_CR1INT = 0x20
	// Position of CR2INT field.
	CT32B0_IR_CR2INT_Pos = 0x6
	// Bit mask of CR2INT field.
	CT32B0_IR_CR2INT_Msk = 0x40
	// Bit CR2INT.
	CT32B0_IR_CR2INT = 0x40
	// Position of RESERVED field.
	CT32B0_IR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CT32B0_IR_RESERVED_Msk = 0xffffff80

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT32B0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT32B0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT32B0_TCR_CEN = 0x1
	// The counters are disabled.
	CT32B0_TCR_CEN_DISABLED = 0x0
	// The Timer Counter and Prescale Counter are enabled for counting.
	CT32B0_TCR_CEN_ENABLED = 0x1
	// Position of CRST field.
	CT32B0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT32B0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT32B0_TCR_CRST = 0x2
	// Do nothing.
	CT32B0_TCR_CRST_NOP = 0x0
	// The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT32B0_TCR_CRST_RESET = 0x1
	// Position of RESERVED field.
	CT32B0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT32B0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 32-bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TCVAL field.
	CT32B0_TC_TCVAL_Pos = 0x0
	// Bit mask of TCVAL field.
	CT32B0_TC_TCVAL_Msk = 0xffffffff

	// PR: Prescale Register. When the Prescale Counter (below) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PCVAL field.
	CT32B0_PR_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT32B0_PR_PCVAL_Msk = 0xffffffff

	// PC: Prescale Counter. The 32-bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	CT32B0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	CT32B0_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT32B0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT32B0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT32B0_MCR_MR0I = 0x1
	// Enabled
	CT32B0_MCR_MR0I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0I_DISABLED = 0x0
	// Position of MR0R field.
	CT32B0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT32B0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT32B0_MCR_MR0R = 0x2
	// Enabled
	CT32B0_MCR_MR0R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0R_DISABLED = 0x0
	// Position of MR0S field.
	CT32B0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT32B0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT32B0_MCR_MR0S = 0x4
	// Enabled
	CT32B0_MCR_MR0S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR0S_DISABLED = 0x0
	// Position of MR1I field.
	CT32B0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT32B0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT32B0_MCR_MR1I = 0x8
	// Enabled
	CT32B0_MCR_MR1I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1I_DISABLED = 0x0
	// Position of MR1R field.
	CT32B0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT32B0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT32B0_MCR_MR1R = 0x10
	// Enabled
	CT32B0_MCR_MR1R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1R_DISABLED = 0x0
	// Position of MR1S field.
	CT32B0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT32B0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT32B0_MCR_MR1S = 0x20
	// Enabled
	CT32B0_MCR_MR1S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR1S_DISABLED = 0x0
	// Position of MR2I field.
	CT32B0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT32B0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT32B0_MCR_MR2I = 0x40
	// Enabled
	CT32B0_MCR_MR2I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2I_DISABLED = 0x0
	// Position of MR2R field.
	CT32B0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT32B0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT32B0_MCR_MR2R = 0x80
	// Enabled
	CT32B0_MCR_MR2R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2R_DISABLED = 0x0
	// Position of MR2S field.
	CT32B0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT32B0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT32B0_MCR_MR2S = 0x100
	// Enabled
	CT32B0_MCR_MR2S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR2S_DISABLED = 0x0
	// Position of MR3I field.
	CT32B0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT32B0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT32B0_MCR_MR3I = 0x200
	// Enabled
	CT32B0_MCR_MR3I_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3I_DISABLED = 0x0
	// Position of MR3R field.
	CT32B0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT32B0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT32B0_MCR_MR3R = 0x400
	// Enabled
	CT32B0_MCR_MR3R_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3R_DISABLED = 0x0
	// Position of MR3S field.
	CT32B0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT32B0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT32B0_MCR_MR3S = 0x800
	// Enabled
	CT32B0_MCR_MR3S_ENABLED = 0x1
	// Disabled
	CT32B0_MCR_MR3S_DISABLED = 0x0
	// Position of RESERVED field.
	CT32B0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register. MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	CT32B0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT32B0_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT32B0_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT32B0_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT32B0_CCR_CAP0RE = 0x1
	// Enabled.
	CT32B0_CCR_CAP0RE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP0RE_DISABLED = 0x0
	// Position of CAP0FE field.
	CT32B0_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT32B0_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT32B0_CCR_CAP0FE = 0x2
	// Enabled.
	CT32B0_CCR_CAP0FE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP0FE_DISABLED = 0x0
	// Position of CAP0I field.
	CT32B0_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT32B0_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT32B0_CCR_CAP0I = 0x4
	// Enabled.
	CT32B0_CCR_CAP0I_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP0I_DISABLED = 0x0
	// Position of CAP1RE field.
	CT32B0_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	CT32B0_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	CT32B0_CCR_CAP1RE = 0x8
	// Enabled.
	CT32B0_CCR_CAP1RE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP1RE_DISABLED = 0x0
	// Position of CAP1FE field.
	CT32B0_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	CT32B0_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	CT32B0_CCR_CAP1FE = 0x10
	// Enabled.
	CT32B0_CCR_CAP1FE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP1FE_DISABLED = 0x0
	// Position of CAP1I field.
	CT32B0_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	CT32B0_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	CT32B0_CCR_CAP1I = 0x20
	// Enabled.
	CT32B0_CCR_CAP1I_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP1I_DISABLED = 0x0
	// Position of CAP2RE field.
	CT32B0_CCR_CAP2RE_Pos = 0x6
	// Bit mask of CAP2RE field.
	CT32B0_CCR_CAP2RE_Msk = 0x40
	// Bit CAP2RE.
	CT32B0_CCR_CAP2RE = 0x40
	// Enabled.
	CT32B0_CCR_CAP2RE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP2RE_DISABLED = 0x0
	// Position of CAP2FE field.
	CT32B0_CCR_CAP2FE_Pos = 0x7
	// Bit mask of CAP2FE field.
	CT32B0_CCR_CAP2FE_Msk = 0x80
	// Bit CAP2FE.
	CT32B0_CCR_CAP2FE = 0x80
	// Enabled.
	CT32B0_CCR_CAP2FE_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP2FE_DISABLED = 0x0
	// Position of CAP2I field.
	CT32B0_CCR_CAP2I_Pos = 0x8
	// Bit mask of CAP2I field.
	CT32B0_CCR_CAP2I_Msk = 0x100
	// Bit CAP2I.
	CT32B0_CCR_CAP2I = 0x100
	// Enabled.
	CT32B0_CCR_CAP2I_ENABLED = 0x1
	// Disabled.
	CT32B0_CCR_CAP2I_DISABLED = 0x0
	// Position of RESERVED field.
	CT32B0_CCR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	CT32B0_CCR_RESERVED_Msk = 0xfffffe00

	// CR0: Capture Register. CR is loaded with the value of TC when there is an event on the CAP input.
	// Position of CAP field.
	CT32B0_CR_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT32B0_CR_CAP_Msk = 0xffffffff

	// EMR: External Match Register. The EMR controls the match function and the external match pins CT32Bn_MAT[3:0].
	// Position of EM0 field.
	CT32B0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT32B0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT32B0_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT32B0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT32B0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT32B0_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT32B0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT32B0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT32B0_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT32B0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT32B0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT32B0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT32B0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT32B0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT32B0_EMR_EMC0_NOP = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC0_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC0_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC0_TOGGLE = 0x3
	// Position of EMC1 field.
	CT32B0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT32B0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT32B0_EMR_EMC1_NOP = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC1_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC1_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC1_TOGGLE = 0x3
	// Position of EMC2 field.
	CT32B0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT32B0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT32B0_EMR_EMC2_NOP = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC2_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC2_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC2_TOGGLE = 0x3
	// Position of EMC3 field.
	CT32B0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT32B0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT32B0_EMR_EMC3_NOP = 0x0
	// Clear the corresponding External Match bit/output to 0 (CT32Bi_MAT0 pin is LOW if pinned out).
	CT32B0_EMR_EMC3_CLEAR = 0x1
	// Set the corresponding External Match bit/output to 1 (CT32Bi_MAT0 pin is HIGH if pinned out).
	CT32B0_EMR_EMC3_SET = 0x2
	// Toggle the corresponding External Match bit/output.
	CT32B0_EMR_EMC3_TOGGLE = 0x3
	// Position of RESERVED field.
	CT32B0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B0_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTM field.
	CT32B0_CTCR_CTM_Pos = 0x0
	// Bit mask of CTM field.
	CT32B0_CTCR_CTM_Msk = 0x3
	// Timer Mode. Increments every rising PCLK edge
	CT32B0_CTCR_CTM_TIMER_MODE = 0x0
	// Counter Mode rising edge. TC is incremented on rising edges on the CAP input selected by bits 3:2.
	CT32B0_CTCR_CTM_COUNTER_MODE_RISING = 0x1
	// Counter Mode falling edge. TC is incremented on falling edges on the CAP input selected by bits 3:2.
	CT32B0_CTCR_CTM_COUNTER_MODE_FALLING = 0x2
	// Counter Mode dual edge. TC is incremented on both edges on the CAP input selected by bits 3:2.
	CT32B0_CTCR_CTM_COUNTER_MODE_DUAL_ED = 0x3
	// Position of CIS field.
	CT32B0_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	CT32B0_CTCR_CIS_Msk = 0xc
	// Capture channel 0.
	CT32B0_CTCR_CIS_CAPTURE_CHANNEL_0 = 0x0
	// Capture channel 1.
	CT32B0_CTCR_CIS_CAPTURE_CHANNEL_1 = 0x1
	// Capture channel 2.
	CT32B0_CTCR_CIS_CAPTURE_CHANNEL_2 = 0x2
	// Position of ENCC field.
	CT32B0_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT32B0_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT32B0_CTCR_ENCC = 0x10
	// Position of SELCC field.
	CT32B0_CTCR_SELCC_Pos = 0x5
	// Bit mask of SELCC field.
	CT32B0_CTCR_SELCC_Msk = 0xe0
	// Rising Edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP0RISING = 0x0
	// Falling Edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP0FALLING = 0x1
	// Rising Edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP1RISING = 0x2
	// Falling Edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP1FALLING = 0x3
	// Rising Edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP2RISING = 0x4
	// Falling Edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
	CT32B0_CTCR_SELCC_CAP2FALLING = 0x5
	// Position of RESERVED field.
	CT32B0_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT32B0_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins CT32Bn_MAT[3:0].
	// Position of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT32B0_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT32B0_PWMC_PWMEN0 = 0x1
	// CT32Bn_MAT0 is controlled by EM0.
	CT32B0_PWMC_PWMEN0_EM0 = 0x0
	// PWM mode is enabled for CT32Bn_MAT0.
	CT32B0_PWMC_PWMEN0_PWM = 0x1
	// Position of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT32B0_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT32B0_PWMC_PWMEN1 = 0x2
	// CT32Bn_MAT01 is controlled by EM1.
	CT32B0_PWMC_PWMEN1_EM1 = 0x0
	// PWM mode is enabled for CT32Bn_MAT1.
	CT32B0_PWMC_PWMEN1_PWM = 0x1
	// Position of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT32B0_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT32B0_PWMC_PWMEN2 = 0x4
	// CT32Bn_MAT2 is controlled by EM2.
	CT32B0_PWMC_PWMEN2_EM2 = 0x0
	// PWM mode is enabled for CT32Bn_MAT2.
	CT32B0_PWMC_PWMEN2_PWM = 0x1
	// Position of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT32B0_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT32B0_PWMC_PWMEN3 = 0x8
	// CT32Bn_MAT3 is controlled by EM3.
	CT32B0_PWMC_PWMEN3_EM3 = 0x0
	// PWM mode is enabled for CT132Bn_MAT3.
	CT32B0_PWMC_PWMEN3_PWM = 0x1
	// Position of RESERVED field.
	CT32B0_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT32B0_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for ADC: 12-bit Analog-to-Digital Converter (ADC)
const (
	// CTRL: A/D Control Register. Contains the clock divide value, enable bits for each sequence and the A/D power-down bit.
	// Position of CLKDIV field.
	ADC_CTRL_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	ADC_CTRL_CLKDIV_Msk = 0xff
	// Position of RESERVED field.
	ADC_CTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ADC_CTRL_RESERVED_Msk = 0x300
	// Position of LPWRMODE field.
	ADC_CTRL_LPWRMODE_Pos = 0xa
	// Bit mask of LPWRMODE field.
	ADC_CTRL_LPWRMODE_Msk = 0x400
	// Bit LPWRMODE.
	ADC_CTRL_LPWRMODE = 0x400
	// Disabled. The low-power ADC mode is disabled. The analog circuitry remains activated even when no conversions are requested.
	ADC_CTRL_LPWRMODE_DISABLED = 0x0
	// Enabled. The low-power ADC mode is enabled.
	ADC_CTRL_LPWRMODE_ENABLED = 0x1
	// Position of CAL_MODE field.
	ADC_CTRL_CAL_MODE_Pos = 0x1e
	// Bit mask of CAL_MODE field.
	ADC_CTRL_CAL_MODE_Msk = 0x40000000
	// Bit CAL_MODE.
	ADC_CTRL_CAL_MODE = 0x40000000
	// Position of RESERVED field.
	ADC_CTRL_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	ADC_CTRL_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	ADC_CTRL_RESERVED = 0x80000000

	// SEQA_CTRL: A/D Conversion Sequence-A control Register: Controls triggering and channel selection for conversion sequence-A. Also specifies interrupt mode for sequence-A.
	// Position of CHANNELS field.
	ADC_SEQA_CTRL_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	ADC_SEQA_CTRL_CHANNELS_Msk = 0xfff
	// Position of TRIGGER field.
	ADC_SEQA_CTRL_TRIGGER_Pos = 0xc
	// Bit mask of TRIGGER field.
	ADC_SEQA_CTRL_TRIGGER_Msk = 0x7000
	// Position of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Msk = 0x38000
	// Position of TRIGPOL field.
	ADC_SEQA_CTRL_TRIGPOL_Pos = 0x12
	// Bit mask of TRIGPOL field.
	ADC_SEQA_CTRL_TRIGPOL_Msk = 0x40000
	// Bit TRIGPOL.
	ADC_SEQA_CTRL_TRIGPOL = 0x40000
	// Negative edge. A negative edge launches the conversion sequence on the selected trigger input.
	ADC_SEQA_CTRL_TRIGPOL_NEGATIVE_EDGE = 0x0
	// Positive edge. A positive edge launches the conversion sequence on the selected trigger input.
	ADC_SEQA_CTRL_TRIGPOL_POSITIVE_EDGE = 0x1
	// Position of SYNCBYPASS field.
	ADC_SEQA_CTRL_SYNCBYPASS_Pos = 0x13
	// Bit mask of SYNCBYPASS field.
	ADC_SEQA_CTRL_SYNCBYPASS_Msk = 0x80000
	// Bit SYNCBYPASS.
	ADC_SEQA_CTRL_SYNCBYPASS = 0x80000
	// Enable synchronization. The hardware trigger bypass is not enabled.
	ADC_SEQA_CTRL_SYNCBYPASS_ENABLE_SYNCHRONIZATI = 0x0
	// Bypass synchronization. The hardware trigger bypass is enabled.
	ADC_SEQA_CTRL_SYNCBYPASS_BYPASS_SYNCHRONIZATI = 0x1
	// Position of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQA_CTRL_RESERVED_Msk = 0x3f00000
	// Position of START field.
	ADC_SEQA_CTRL_START_Pos = 0x1a
	// Bit mask of START field.
	ADC_SEQA_CTRL_START_Msk = 0x4000000
	// Bit START.
	ADC_SEQA_CTRL_START = 0x4000000
	// Position of BURST field.
	ADC_SEQA_CTRL_BURST_Pos = 0x1b
	// Bit mask of BURST field.
	ADC_SEQA_CTRL_BURST_Msk = 0x8000000
	// Bit BURST.
	ADC_SEQA_CTRL_BURST = 0x8000000
	// Position of SINGLESTEP field.
	ADC_SEQA_CTRL_SINGLESTEP_Pos = 0x1c
	// Bit mask of SINGLESTEP field.
	ADC_SEQA_CTRL_SINGLESTEP_Msk = 0x10000000
	// Bit SINGLESTEP.
	ADC_SEQA_CTRL_SINGLESTEP = 0x10000000
	// Position of LOWPRIO field.
	ADC_SEQA_CTRL_LOWPRIO_Pos = 0x1d
	// Bit mask of LOWPRIO field.
	ADC_SEQA_CTRL_LOWPRIO_Msk = 0x20000000
	// Bit LOWPRIO.
	ADC_SEQA_CTRL_LOWPRIO = 0x20000000
	// Low priority. Any B trigger which occurs while an A conversion sequence is active will be ignored and lost.
	ADC_SEQA_CTRL_LOWPRIO_LOW_PRIORITY = 0x0
	// High priority. Setting this bit to a 1 will permit any enabled B sequence trigger (including a B sequence software start) to immediately interrupt this sequence and launch a B sequence in it's place. The conversion currently in progress will be terminated. The A sequence that was interrupted will automatically resume after the B sequence completes. The channel whose conversion was terminated will be re-sampled and the conversion sequence will resume from that point.
	ADC_SEQA_CTRL_LOWPRIO_HIGH_PRIORITY = 0x1
	// Position of MODE field.
	ADC_SEQA_CTRL_MODE_Pos = 0x1e
	// Bit mask of MODE field.
	ADC_SEQA_CTRL_MODE_Msk = 0x40000000
	// Bit MODE.
	ADC_SEQA_CTRL_MODE = 0x40000000
	// End of conversion. The sequence A interrupt/DMA flag will be set at the end of each individual A/D conversion performed under sequence A. This flag will mirror the DATAVALID bit in the SEQA_GDAT register. The OVERRUN bit in the SEQA_GDAT register will contribute to generation of an overrun interrupt/DMA request if enabled.
	ADC_SEQA_CTRL_MODE_END_OF_CONVERSION = 0x0
	// End of sequence. The sequence A interrupt/DMA flag will be set when the entire set of sequence-A conversions completes. This flag will need to be explicitly cleared by software or by the DMA-clear signal in this mode. The OVERRUN bit in the SEQA_GDAT register will NOT contribute to generation of an overrun interrupt/DMA request since it is assumed this register may not be utilized in this mode.
	ADC_SEQA_CTRL_MODE_END_OF_SEQUENCE = 0x1
	// Position of SEQA_ENA field.
	ADC_SEQA_CTRL_SEQA_ENA_Pos = 0x1f
	// Bit mask of SEQA_ENA field.
	ADC_SEQA_CTRL_SEQA_ENA_Msk = 0x80000000
	// Bit SEQA_ENA.
	ADC_SEQA_CTRL_SEQA_ENA = 0x80000000
	// Disabled. Sequence A is disabled. Sequence A triggers are ignored. If this bit is cleared while sequence A is in progress, the sequence will be halted at the end of the current conversion. After the sequence is re-enabled, a new trigger will be required to restart the sequence beginning with the next enabled channel.
	ADC_SEQA_CTRL_SEQA_ENA_DISABLED = 0x0
	// Enabled. Sequence A is enabled.
	ADC_SEQA_CTRL_SEQA_ENA_ENABLED = 0x1

	// SEQB_CTRL: A/D Conversion Sequence-B Control Register: Controls triggering and channel selection for conversion sequence-B. Also specifies interrupt mode for sequence-B.
	// Position of CHANNELS field.
	ADC_SEQB_CTRL_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	ADC_SEQB_CTRL_CHANNELS_Msk = 0xfff
	// Position of TRIGGER field.
	ADC_SEQB_CTRL_TRIGGER_Pos = 0xc
	// Bit mask of TRIGGER field.
	ADC_SEQB_CTRL_TRIGGER_Msk = 0x7000
	// Position of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Msk = 0x38000
	// Position of TRIGPOL field.
	ADC_SEQB_CTRL_TRIGPOL_Pos = 0x12
	// Bit mask of TRIGPOL field.
	ADC_SEQB_CTRL_TRIGPOL_Msk = 0x40000
	// Bit TRIGPOL.
	ADC_SEQB_CTRL_TRIGPOL = 0x40000
	// Negative edge. A negative edge launches the conversion sequence on the selected trigger input.
	ADC_SEQB_CTRL_TRIGPOL_NEGATIVE_EDGE = 0x0
	// Positive edge. A positive edge launches the conversion sequence on the selected trigger input.
	ADC_SEQB_CTRL_TRIGPOL_POSITIVE_EDGE = 0x1
	// Position of SYNCBYPASS field.
	ADC_SEQB_CTRL_SYNCBYPASS_Pos = 0x13
	// Bit mask of SYNCBYPASS field.
	ADC_SEQB_CTRL_SYNCBYPASS_Msk = 0x80000
	// Bit SYNCBYPASS.
	ADC_SEQB_CTRL_SYNCBYPASS = 0x80000
	// Enable synchronization. The hardware trigger bypass is not enabled.
	ADC_SEQB_CTRL_SYNCBYPASS_ENABLE_SYNCHRONIZATI = 0x0
	// Bypass synchronization. The hardware trigger bypass is enabled.
	ADC_SEQB_CTRL_SYNCBYPASS_BYPASS_SYNCHRONIZATI = 0x1
	// Position of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Msk = 0x3f00000
	// Position of START field.
	ADC_SEQB_CTRL_START_Pos = 0x1a
	// Bit mask of START field.
	ADC_SEQB_CTRL_START_Msk = 0x4000000
	// Bit START.
	ADC_SEQB_CTRL_START = 0x4000000
	// Position of BURST field.
	ADC_SEQB_CTRL_BURST_Pos = 0x1b
	// Bit mask of BURST field.
	ADC_SEQB_CTRL_BURST_Msk = 0x8000000
	// Bit BURST.
	ADC_SEQB_CTRL_BURST = 0x8000000
	// Position of SINGLESTEP field.
	ADC_SEQB_CTRL_SINGLESTEP_Pos = 0x1c
	// Bit mask of SINGLESTEP field.
	ADC_SEQB_CTRL_SINGLESTEP_Msk = 0x10000000
	// Bit SINGLESTEP.
	ADC_SEQB_CTRL_SINGLESTEP = 0x10000000
	// Position of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	ADC_SEQB_CTRL_RESERVED_Msk = 0x20000000
	// Bit RESERVED.
	ADC_SEQB_CTRL_RESERVED = 0x20000000
	// Position of MODE field.
	ADC_SEQB_CTRL_MODE_Pos = 0x1e
	// Bit mask of MODE field.
	ADC_SEQB_CTRL_MODE_Msk = 0x40000000
	// Bit MODE.
	ADC_SEQB_CTRL_MODE = 0x40000000
	// End of conversion. The sequence B interrupt/DMA flag will be set at the end of each individual A/D conversion performed under sequence B. This flag will mirror the DATAVALID bit in the SEQB_GDAT register. The OVERRUN bit in the SEQB_GDAT register will contribute to generation of an overrun interrupt/DMA request if enabled.
	ADC_SEQB_CTRL_MODE_END_OF_CONVERSION = 0x0
	// End of sequence. The sequence B interrupt/DMA flag will be set when the entire set of sequence B conversions completes. This flag will need to be explicitly cleared by software or by the DMA-clear signal in this mode. The OVERRUN bit in the SEQB_GDAT register will NOT contribute to generation of an overrun interrupt/DMA request since it is assumed this register will not be utilized in this mode.
	ADC_SEQB_CTRL_MODE_END_OF_SEQUENCE = 0x1
	// Position of SEQB_ENA field.
	ADC_SEQB_CTRL_SEQB_ENA_Pos = 0x1f
	// Bit mask of SEQB_ENA field.
	ADC_SEQB_CTRL_SEQB_ENA_Msk = 0x80000000
	// Bit SEQB_ENA.
	ADC_SEQB_CTRL_SEQB_ENA = 0x80000000
	// Disabled. Sequence B is disabled. Sequence B triggers are ignored. If this bit is cleared while sequence B is in progress, the sequence will be halted at the end of the current conversion. After the sequence is re-enabled, a new trigger will be required to restart the sequence beginning with the next enabled channel.
	ADC_SEQB_CTRL_SEQB_ENA_DISABLED = 0x0
	// Enabled. Sequence B is enabled.
	ADC_SEQB_CTRL_SEQB_ENA_ENABLED = 0x1

	// SEQA_GDAT: A/D Sequence-A Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-A
	// Position of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_SEQA_GDAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_SEQA_GDAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC_SEQA_GDAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC_SEQA_GDAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC_SEQA_GDAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC_SEQA_GDAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQA_GDAT_RESERVED_Msk = 0x3f00000
	// Position of CHN field.
	ADC_SEQA_GDAT_CHN_Pos = 0x1a
	// Bit mask of CHN field.
	ADC_SEQA_GDAT_CHN_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC_SEQA_GDAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_SEQA_GDAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_SEQA_GDAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC_SEQA_GDAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC_SEQA_GDAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC_SEQA_GDAT_DATAVALID = 0x80000000

	// SEQB_GDAT: A/D Sequence-B Global Data Register. This register contains the result of the most recent A/D conversion performed under sequence-B
	// Position of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_SEQB_GDAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_SEQB_GDAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC_SEQB_GDAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC_SEQB_GDAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC_SEQB_GDAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC_SEQB_GDAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_SEQB_GDAT_RESERVED_Msk = 0x3f00000
	// Position of CHN field.
	ADC_SEQB_GDAT_CHN_Pos = 0x1a
	// Bit mask of CHN field.
	ADC_SEQB_GDAT_CHN_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC_SEQB_GDAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_SEQB_GDAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_SEQB_GDAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC_SEQB_GDAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC_SEQB_GDAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC_SEQB_GDAT_DATAVALID = 0x80000000

	// DAT: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0.
	// Position of RESERVED field.
	ADC_DAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_DAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_DAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_DAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC_DAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC_DAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC_DAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC_DAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC_DAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC_DAT_RESERVED_Msk = 0x3f00000
	// Position of CHANNEL field.
	ADC_DAT_CHANNEL_Pos = 0x1a
	// Bit mask of CHANNEL field.
	ADC_DAT_CHANNEL_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC_DAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_DAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_DAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC_DAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC_DAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC_DAT_DATAVALID = 0x80000000

	// THR0_LOW: A/D Low Compare Threshold Register 0 : Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
	// Position of THRLOW field.
	ADC_THR0_LOW_THRLOW_Pos = 0x4
	// Bit mask of THRLOW field.
	ADC_THR0_LOW_THRLOW_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR0_LOW_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR0_LOW_RESERVED_Msk = 0xffff0000

	// THR1_LOW: A/D Low Compare Threshold Register 1: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
	// Position of THRLOW field.
	ADC_THR1_LOW_THRLOW_Pos = 0x4
	// Bit mask of THRLOW field.
	ADC_THR1_LOW_THRLOW_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR1_LOW_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR1_LOW_RESERVED_Msk = 0xffff0000

	// THR0_HIGH: A/D High Compare Threshold Register 0: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
	// Position of THRHIGH field.
	ADC_THR0_HIGH_THRHIGH_Pos = 0x4
	// Bit mask of THRHIGH field.
	ADC_THR0_HIGH_THRHIGH_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR0_HIGH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR0_HIGH_RESERVED_Msk = 0xffff0000

	// THR1_HIGH: A/D High Compare Threshold Register 1: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
	// Position of THRHIGH field.
	ADC_THR1_HIGH_THRHIGH_Pos = 0x4
	// Bit mask of THRHIGH field.
	ADC_THR1_HIGH_THRHIGH_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_THR1_HIGH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_THR1_HIGH_RESERVED_Msk = 0xffff0000

	// CHAN_THRSEL: A/D Channel-Threshold Select Register. Specifies which set of threshold compare registers are to be used for each channel
	// Position of CH0_THRSEL field.
	ADC_CHAN_THRSEL_CH0_THRSEL_Pos = 0x0
	// Bit mask of CH0_THRSEL field.
	ADC_CHAN_THRSEL_CH0_THRSEL_Msk = 0x1
	// Bit CH0_THRSEL.
	ADC_CHAN_THRSEL_CH0_THRSEL = 0x1
	// Threshold 0. Channel 0 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH0_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 0 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH0_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH1_THRSEL field.
	ADC_CHAN_THRSEL_CH1_THRSEL_Pos = 0x1
	// Bit mask of CH1_THRSEL field.
	ADC_CHAN_THRSEL_CH1_THRSEL_Msk = 0x2
	// Bit CH1_THRSEL.
	ADC_CHAN_THRSEL_CH1_THRSEL = 0x2
	// Threshold 0. Channel 1 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH1_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 1 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH1_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH2_THRSEL field.
	ADC_CHAN_THRSEL_CH2_THRSEL_Pos = 0x2
	// Bit mask of CH2_THRSEL field.
	ADC_CHAN_THRSEL_CH2_THRSEL_Msk = 0x4
	// Bit CH2_THRSEL.
	ADC_CHAN_THRSEL_CH2_THRSEL = 0x4
	// Threshold 0. Channel 2 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH2_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 2 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH2_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH3_THRSEL field.
	ADC_CHAN_THRSEL_CH3_THRSEL_Pos = 0x3
	// Bit mask of CH3_THRSEL field.
	ADC_CHAN_THRSEL_CH3_THRSEL_Msk = 0x8
	// Bit CH3_THRSEL.
	ADC_CHAN_THRSEL_CH3_THRSEL = 0x8
	// Threshold 0. Channel 3 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH3_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 3 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH3_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH4_THRSEL field.
	ADC_CHAN_THRSEL_CH4_THRSEL_Pos = 0x4
	// Bit mask of CH4_THRSEL field.
	ADC_CHAN_THRSEL_CH4_THRSEL_Msk = 0x10
	// Bit CH4_THRSEL.
	ADC_CHAN_THRSEL_CH4_THRSEL = 0x10
	// Threshold 0. Channel 4 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH4_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 4 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH4_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH5_THRSEL field.
	ADC_CHAN_THRSEL_CH5_THRSEL_Pos = 0x5
	// Bit mask of CH5_THRSEL field.
	ADC_CHAN_THRSEL_CH5_THRSEL_Msk = 0x20
	// Bit CH5_THRSEL.
	ADC_CHAN_THRSEL_CH5_THRSEL = 0x20
	// Threshold 0. Channel 5 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH5_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 5 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH5_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH6_THRSEL field.
	ADC_CHAN_THRSEL_CH6_THRSEL_Pos = 0x6
	// Bit mask of CH6_THRSEL field.
	ADC_CHAN_THRSEL_CH6_THRSEL_Msk = 0x40
	// Bit CH6_THRSEL.
	ADC_CHAN_THRSEL_CH6_THRSEL = 0x40
	// Threshold 0. Channel 6 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH6_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 6 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH6_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH7_THRSEL field.
	ADC_CHAN_THRSEL_CH7_THRSEL_Pos = 0x7
	// Bit mask of CH7_THRSEL field.
	ADC_CHAN_THRSEL_CH7_THRSEL_Msk = 0x80
	// Bit CH7_THRSEL.
	ADC_CHAN_THRSEL_CH7_THRSEL = 0x80
	// Threshold 0. Channel 7 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH7_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 7 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH7_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH8_THRSEL field.
	ADC_CHAN_THRSEL_CH8_THRSEL_Pos = 0x8
	// Bit mask of CH8_THRSEL field.
	ADC_CHAN_THRSEL_CH8_THRSEL_Msk = 0x100
	// Bit CH8_THRSEL.
	ADC_CHAN_THRSEL_CH8_THRSEL = 0x100
	// Threshold 0. Channel 8 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH8_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 8 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH8_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH9_THRSEL field.
	ADC_CHAN_THRSEL_CH9_THRSEL_Pos = 0x9
	// Bit mask of CH9_THRSEL field.
	ADC_CHAN_THRSEL_CH9_THRSEL_Msk = 0x200
	// Bit CH9_THRSEL.
	ADC_CHAN_THRSEL_CH9_THRSEL = 0x200
	// Threshold 0. Channel 9 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH9_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 9 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH9_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH10_THRSEL field.
	ADC_CHAN_THRSEL_CH10_THRSEL_Pos = 0xa
	// Bit mask of CH10_THRSEL field.
	ADC_CHAN_THRSEL_CH10_THRSEL_Msk = 0x400
	// Bit CH10_THRSEL.
	ADC_CHAN_THRSEL_CH10_THRSEL = 0x400
	// Threshold 0. Channel 10 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH10_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 10 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH10_THRSEL_THRESHOLD_1 = 0x1
	// Position of CH11_THRSEL field.
	ADC_CHAN_THRSEL_CH11_THRSEL_Pos = 0xb
	// Bit mask of CH11_THRSEL field.
	ADC_CHAN_THRSEL_CH11_THRSEL_Msk = 0x800
	// Bit CH11_THRSEL.
	ADC_CHAN_THRSEL_CH11_THRSEL = 0x800
	// Threshold 0. Channel 11 results will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers
	ADC_CHAN_THRSEL_CH11_THRSEL_THRESHOLD_0 = 0x0
	// Threshold 1. Channel 11 results will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers
	ADC_CHAN_THRSEL_CH11_THRSEL_THRESHOLD_1 = 0x1

	// INTEN: A/D Interrupt Enable Register. This register contains enable bits that enable the sequence-A, sequence-B, threshold compare and data overrun interrupts to be generated.
	// Position of SEQA_INTEN field.
	ADC_INTEN_SEQA_INTEN_Pos = 0x0
	// Bit mask of SEQA_INTEN field.
	ADC_INTEN_SEQA_INTEN_Msk = 0x1
	// Bit SEQA_INTEN.
	ADC_INTEN_SEQA_INTEN = 0x1
	// Disabled. The sequence A interrupt/DMA request is disabled.
	ADC_INTEN_SEQA_INTEN_DISABLED = 0x0
	// Enabled. The sequence A interrupt/DMA request is enabled and will be asserted either upon completion of each individual conversion performed as part of sequence A, or upon completion of the entire A sequence of conversions, depending on the MODE bit in the SEQA_CTRL register.
	ADC_INTEN_SEQA_INTEN_ENABLED = 0x1
	// Position of SEQB_INTEN field.
	ADC_INTEN_SEQB_INTEN_Pos = 0x1
	// Bit mask of SEQB_INTEN field.
	ADC_INTEN_SEQB_INTEN_Msk = 0x2
	// Bit SEQB_INTEN.
	ADC_INTEN_SEQB_INTEN = 0x2
	// Disabled. The sequence B interrupt/DMA request is disabled.
	ADC_INTEN_SEQB_INTEN_DISABLED = 0x0
	// Enabled. The sequence B interrupt/DMA request is enabled and will be asserted either upon completion of each individual conversion performed as part of sequence B, or upon completion of the entire B sequence of conversions, depending on the MODE bit in the SEQB_CTRL register.
	ADC_INTEN_SEQB_INTEN_ENABLED = 0x1
	// Position of OVR_INTEN field.
	ADC_INTEN_OVR_INTEN_Pos = 0x2
	// Bit mask of OVR_INTEN field.
	ADC_INTEN_OVR_INTEN_Msk = 0x4
	// Bit OVR_INTEN.
	ADC_INTEN_OVR_INTEN = 0x4
	// Disabled. The overrun interrupt is disabled.
	ADC_INTEN_OVR_INTEN_DISABLED = 0x0
	// Enabled. The overrun interrupt is enabled. Detection of an overrun condition on any of the 12 channel data registers will cause an overrun interrupt request. In addition, if the MODE bit for a particular sequence is 0, then an overrun in the global data register for that sequence will also cause this interrupt request to be asserted.
	ADC_INTEN_OVR_INTEN_ENABLED = 0x1
	// Position of ADCMPINTEN0 field.
	ADC_INTEN_ADCMPINTEN0_Pos = 0x3
	// Bit mask of ADCMPINTEN0 field.
	ADC_INTEN_ADCMPINTEN0_Msk = 0x18
	// Disabled.
	ADC_INTEN_ADCMPINTEN0_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN0_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN0_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN1 field.
	ADC_INTEN_ADCMPINTEN1_Pos = 0x5
	// Bit mask of ADCMPINTEN1 field.
	ADC_INTEN_ADCMPINTEN1_Msk = 0x60
	// Disabled.
	ADC_INTEN_ADCMPINTEN1_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN1_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN1_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN2 field.
	ADC_INTEN_ADCMPINTEN2_Pos = 0x7
	// Bit mask of ADCMPINTEN2 field.
	ADC_INTEN_ADCMPINTEN2_Msk = 0x180
	// Disabled.
	ADC_INTEN_ADCMPINTEN2_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN2_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN2_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN3 field.
	ADC_INTEN_ADCMPINTEN3_Pos = 0x9
	// Bit mask of ADCMPINTEN3 field.
	ADC_INTEN_ADCMPINTEN3_Msk = 0x600
	// Disabled.
	ADC_INTEN_ADCMPINTEN3_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN3_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN3_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN4 field.
	ADC_INTEN_ADCMPINTEN4_Pos = 0xb
	// Bit mask of ADCMPINTEN4 field.
	ADC_INTEN_ADCMPINTEN4_Msk = 0x1800
	// Disabled.
	ADC_INTEN_ADCMPINTEN4_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN4_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN4_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN5 field.
	ADC_INTEN_ADCMPINTEN5_Pos = 0xd
	// Bit mask of ADCMPINTEN5 field.
	ADC_INTEN_ADCMPINTEN5_Msk = 0x6000
	// Disabled.
	ADC_INTEN_ADCMPINTEN5_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN5_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN5_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN6 field.
	ADC_INTEN_ADCMPINTEN6_Pos = 0xf
	// Bit mask of ADCMPINTEN6 field.
	ADC_INTEN_ADCMPINTEN6_Msk = 0x18000
	// Disabled.
	ADC_INTEN_ADCMPINTEN6_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN6_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN6_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN7 field.
	ADC_INTEN_ADCMPINTEN7_Pos = 0x11
	// Bit mask of ADCMPINTEN7 field.
	ADC_INTEN_ADCMPINTEN7_Msk = 0x60000
	// Disabled.
	ADC_INTEN_ADCMPINTEN7_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN7_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN7_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN8 field.
	ADC_INTEN_ADCMPINTEN8_Pos = 0x13
	// Bit mask of ADCMPINTEN8 field.
	ADC_INTEN_ADCMPINTEN8_Msk = 0x180000
	// Disabled.
	ADC_INTEN_ADCMPINTEN8_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN8_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN8_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN9 field.
	ADC_INTEN_ADCMPINTEN9_Pos = 0x15
	// Bit mask of ADCMPINTEN9 field.
	ADC_INTEN_ADCMPINTEN9_Msk = 0x600000
	// Disabled.
	ADC_INTEN_ADCMPINTEN9_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN9_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN9_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN10 field.
	ADC_INTEN_ADCMPINTEN10_Pos = 0x17
	// Bit mask of ADCMPINTEN10 field.
	ADC_INTEN_ADCMPINTEN10_Msk = 0x1800000
	// Disabled.
	ADC_INTEN_ADCMPINTEN10_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN10_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN10_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN11 field.
	ADC_INTEN_ADCMPINTEN11_Pos = 0x19
	// Bit mask of ADCMPINTEN11 field.
	ADC_INTEN_ADCMPINTEN11_Msk = 0x6000000
	// Disabled.
	ADC_INTEN_ADCMPINTEN11_DISABLED = 0x0
	// Outside threshold.
	ADC_INTEN_ADCMPINTEN11_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC_INTEN_ADCMPINTEN11_CROSSING_THRESHOLD = 0x2
	// Position of RESERVED field.
	ADC_INTEN_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	ADC_INTEN_RESERVED_Msk = 0xf8000000

	// FLAGS: A/D Flags Register. Contains the four interrupt request flags and the individual component overrun and threshold-compare flags. (The overrun bits replicate information stored in the result registers).
	// Position of THCMP0 field.
	ADC_FLAGS_THCMP0_Pos = 0x0
	// Bit mask of THCMP0 field.
	ADC_FLAGS_THCMP0_Msk = 0x1
	// Bit THCMP0.
	ADC_FLAGS_THCMP0 = 0x1
	// Position of THCMP1 field.
	ADC_FLAGS_THCMP1_Pos = 0x1
	// Bit mask of THCMP1 field.
	ADC_FLAGS_THCMP1_Msk = 0x2
	// Bit THCMP1.
	ADC_FLAGS_THCMP1 = 0x2
	// Position of THCMP2 field.
	ADC_FLAGS_THCMP2_Pos = 0x2
	// Bit mask of THCMP2 field.
	ADC_FLAGS_THCMP2_Msk = 0x4
	// Bit THCMP2.
	ADC_FLAGS_THCMP2 = 0x4
	// Position of THCMP3 field.
	ADC_FLAGS_THCMP3_Pos = 0x3
	// Bit mask of THCMP3 field.
	ADC_FLAGS_THCMP3_Msk = 0x8
	// Bit THCMP3.
	ADC_FLAGS_THCMP3 = 0x8
	// Position of THCMP4 field.
	ADC_FLAGS_THCMP4_Pos = 0x4
	// Bit mask of THCMP4 field.
	ADC_FLAGS_THCMP4_Msk = 0x10
	// Bit THCMP4.
	ADC_FLAGS_THCMP4 = 0x10
	// Position of THCMP5 field.
	ADC_FLAGS_THCMP5_Pos = 0x5
	// Bit mask of THCMP5 field.
	ADC_FLAGS_THCMP5_Msk = 0x20
	// Bit THCMP5.
	ADC_FLAGS_THCMP5 = 0x20
	// Position of THCMP6 field.
	ADC_FLAGS_THCMP6_Pos = 0x6
	// Bit mask of THCMP6 field.
	ADC_FLAGS_THCMP6_Msk = 0x40
	// Bit THCMP6.
	ADC_FLAGS_THCMP6 = 0x40
	// Position of THCMP7 field.
	ADC_FLAGS_THCMP7_Pos = 0x7
	// Bit mask of THCMP7 field.
	ADC_FLAGS_THCMP7_Msk = 0x80
	// Bit THCMP7.
	ADC_FLAGS_THCMP7 = 0x80
	// Position of THCMP8 field.
	ADC_FLAGS_THCMP8_Pos = 0x8
	// Bit mask of THCMP8 field.
	ADC_FLAGS_THCMP8_Msk = 0x100
	// Bit THCMP8.
	ADC_FLAGS_THCMP8 = 0x100
	// Position of THCMP9 field.
	ADC_FLAGS_THCMP9_Pos = 0x9
	// Bit mask of THCMP9 field.
	ADC_FLAGS_THCMP9_Msk = 0x200
	// Bit THCMP9.
	ADC_FLAGS_THCMP9 = 0x200
	// Position of THCMP10 field.
	ADC_FLAGS_THCMP10_Pos = 0xa
	// Bit mask of THCMP10 field.
	ADC_FLAGS_THCMP10_Msk = 0x400
	// Bit THCMP10.
	ADC_FLAGS_THCMP10 = 0x400
	// Position of THCMP11 field.
	ADC_FLAGS_THCMP11_Pos = 0xb
	// Bit mask of THCMP11 field.
	ADC_FLAGS_THCMP11_Msk = 0x800
	// Bit THCMP11.
	ADC_FLAGS_THCMP11 = 0x800
	// Position of OVERRUN0 field.
	ADC_FLAGS_OVERRUN0_Pos = 0xc
	// Bit mask of OVERRUN0 field.
	ADC_FLAGS_OVERRUN0_Msk = 0x1000
	// Bit OVERRUN0.
	ADC_FLAGS_OVERRUN0 = 0x1000
	// Position of OVERRUN1 field.
	ADC_FLAGS_OVERRUN1_Pos = 0xd
	// Bit mask of OVERRUN1 field.
	ADC_FLAGS_OVERRUN1_Msk = 0x2000
	// Bit OVERRUN1.
	ADC_FLAGS_OVERRUN1 = 0x2000
	// Position of OVERRUN2 field.
	ADC_FLAGS_OVERRUN2_Pos = 0xe
	// Bit mask of OVERRUN2 field.
	ADC_FLAGS_OVERRUN2_Msk = 0x4000
	// Bit OVERRUN2.
	ADC_FLAGS_OVERRUN2 = 0x4000
	// Position of OVERRUN3 field.
	ADC_FLAGS_OVERRUN3_Pos = 0xf
	// Bit mask of OVERRUN3 field.
	ADC_FLAGS_OVERRUN3_Msk = 0x8000
	// Bit OVERRUN3.
	ADC_FLAGS_OVERRUN3 = 0x8000
	// Position of OVERRUN4 field.
	ADC_FLAGS_OVERRUN4_Pos = 0x10
	// Bit mask of OVERRUN4 field.
	ADC_FLAGS_OVERRUN4_Msk = 0x10000
	// Bit OVERRUN4.
	ADC_FLAGS_OVERRUN4 = 0x10000
	// Position of OVERRUN5 field.
	ADC_FLAGS_OVERRUN5_Pos = 0x11
	// Bit mask of OVERRUN5 field.
	ADC_FLAGS_OVERRUN5_Msk = 0x20000
	// Bit OVERRUN5.
	ADC_FLAGS_OVERRUN5 = 0x20000
	// Position of OVERRUN6 field.
	ADC_FLAGS_OVERRUN6_Pos = 0x12
	// Bit mask of OVERRUN6 field.
	ADC_FLAGS_OVERRUN6_Msk = 0x40000
	// Bit OVERRUN6.
	ADC_FLAGS_OVERRUN6 = 0x40000
	// Position of OVERRUN7 field.
	ADC_FLAGS_OVERRUN7_Pos = 0x13
	// Bit mask of OVERRUN7 field.
	ADC_FLAGS_OVERRUN7_Msk = 0x80000
	// Bit OVERRUN7.
	ADC_FLAGS_OVERRUN7 = 0x80000
	// Position of OVERRUN8 field.
	ADC_FLAGS_OVERRUN8_Pos = 0x14
	// Bit mask of OVERRUN8 field.
	ADC_FLAGS_OVERRUN8_Msk = 0x100000
	// Bit OVERRUN8.
	ADC_FLAGS_OVERRUN8 = 0x100000
	// Position of OVERRUN9 field.
	ADC_FLAGS_OVERRUN9_Pos = 0x15
	// Bit mask of OVERRUN9 field.
	ADC_FLAGS_OVERRUN9_Msk = 0x200000
	// Bit OVERRUN9.
	ADC_FLAGS_OVERRUN9 = 0x200000
	// Position of OVERRUN10 field.
	ADC_FLAGS_OVERRUN10_Pos = 0x16
	// Bit mask of OVERRUN10 field.
	ADC_FLAGS_OVERRUN10_Msk = 0x400000
	// Bit OVERRUN10.
	ADC_FLAGS_OVERRUN10 = 0x400000
	// Position of OVERRUN11 field.
	ADC_FLAGS_OVERRUN11_Pos = 0x17
	// Bit mask of OVERRUN11 field.
	ADC_FLAGS_OVERRUN11_Msk = 0x800000
	// Bit OVERRUN11.
	ADC_FLAGS_OVERRUN11 = 0x800000
	// Position of SEQA_OVR field.
	ADC_FLAGS_SEQA_OVR_Pos = 0x18
	// Bit mask of SEQA_OVR field.
	ADC_FLAGS_SEQA_OVR_Msk = 0x1000000
	// Bit SEQA_OVR.
	ADC_FLAGS_SEQA_OVR = 0x1000000
	// Position of SEQB_OVR field.
	ADC_FLAGS_SEQB_OVR_Pos = 0x19
	// Bit mask of SEQB_OVR field.
	ADC_FLAGS_SEQB_OVR_Msk = 0x2000000
	// Bit SEQB_OVR.
	ADC_FLAGS_SEQB_OVR = 0x2000000
	// Position of RESERVED field.
	ADC_FLAGS_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	ADC_FLAGS_RESERVED_Msk = 0xc000000
	// Position of SEQA_INT field.
	ADC_FLAGS_SEQA_INT_Pos = 0x1c
	// Bit mask of SEQA_INT field.
	ADC_FLAGS_SEQA_INT_Msk = 0x10000000
	// Bit SEQA_INT.
	ADC_FLAGS_SEQA_INT = 0x10000000
	// Position of SEQB_INT field.
	ADC_FLAGS_SEQB_INT_Pos = 0x1d
	// Bit mask of SEQB_INT field.
	ADC_FLAGS_SEQB_INT_Msk = 0x20000000
	// Bit SEQB_INT.
	ADC_FLAGS_SEQB_INT = 0x20000000
	// Position of THCMP_INT field.
	ADC_FLAGS_THCMP_INT_Pos = 0x1e
	// Bit mask of THCMP_INT field.
	ADC_FLAGS_THCMP_INT_Msk = 0x40000000
	// Bit THCMP_INT.
	ADC_FLAGS_THCMP_INT = 0x40000000
	// Position of OVR_INT field.
	ADC_FLAGS_OVR_INT_Pos = 0x1f
	// Bit mask of OVR_INT field.
	ADC_FLAGS_OVR_INT_Msk = 0x80000000
	// Bit OVR_INT.
	ADC_FLAGS_OVR_INT = 0x80000000

	// TRM: ADC trim register.
	// Position of RESERVED field.
	ADC_TRM_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0x1f
	// Position of VRANGE field.
	ADC_TRM_VRANGE_Pos = 0x5
	// Bit mask of VRANGE field.
	ADC_TRM_VRANGE_Msk = 0x20
	// Bit VRANGE.
	ADC_TRM_VRANGE = 0x20
	// High voltage. VDDA = 2.7 V to 3.6 V.
	ADC_TRM_VRANGE_HIGH_VOLTAGE = 0x0
	// Low voltage. VDDA = 1.8 V to 2.7 V.
	ADC_TRM_VRANGE_LOW_VOLTAGE = 0x1
	// Position of RESERVED field.
	ADC_TRM_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0xffffffc0
)

// Bitfields for RTC: Real-Time Clock (RTC)
const (
	// CTRL: RTC control register
	// Position of SWRESET field.
	RTC_CTRL_SWRESET_Pos = 0x0
	// Bit mask of SWRESET field.
	RTC_CTRL_SWRESET_Msk = 0x1
	// Bit SWRESET.
	RTC_CTRL_SWRESET = 0x1
	// Not in reset. The RTC is not held in reset. This bit must be cleared prior to configuring or initiating any operation of the RTC.
	RTC_CTRL_SWRESET_NOT_IN_RESET = 0x0
	// In reset. The RTC is held in reset. All register bits within the RTC will be forced to their reset value except the OFD bit. This bit must be cleared before writing to any register in the RTC - including writes to set any of the other bits within this register. Do not attempt to write to any bits of this register at the same time that the reset bit is being cleared. This bit may also serve as a Power Fail Detect flag for the always-on voltage domain.
	RTC_CTRL_SWRESET_IN_RESET = 0x1
	// Position of OFD field.
	RTC_CTRL_OFD_Pos = 0x1
	// Bit mask of OFD field.
	RTC_CTRL_OFD_Msk = 0x2
	// Bit OFD.
	RTC_CTRL_OFD = 0x2
	// Run. The RTC oscillator is running properly. Writing a 0 has no effect.
	RTC_CTRL_OFD_RUN = 0x0
	// Fail. RTC oscillator fail detected. Clear this flag after the following power-up. Writing a 1 clears this bit.
	RTC_CTRL_OFD_FAIL = 0x1
	// Position of ALARM1HZ field.
	RTC_CTRL_ALARM1HZ_Pos = 0x2
	// Bit mask of ALARM1HZ field.
	RTC_CTRL_ALARM1HZ_Msk = 0x4
	// Bit ALARM1HZ.
	RTC_CTRL_ALARM1HZ = 0x4
	// No match. No match has occurred on the 1 Hz RTC timer. Writing a 0 has no effect.
	RTC_CTRL_ALARM1HZ_NO_MATCH = 0x0
	// Match. A match condition has occurred on the 1 Hz RTC timer. This flag generates an RTC alarm interrupt request RTC_ALARM which can also wake up the part from any low power mode. Writing a 1 clears this bit.
	RTC_CTRL_ALARM1HZ_MATCH = 0x1
	// Position of WAKE1KHZ field.
	RTC_CTRL_WAKE1KHZ_Pos = 0x3
	// Bit mask of WAKE1KHZ field.
	RTC_CTRL_WAKE1KHZ_Msk = 0x8
	// Bit WAKE1KHZ.
	RTC_CTRL_WAKE1KHZ = 0x8
	// Run. The RTC 1 kHz timer is running. Writing a 0 has no effect.
	RTC_CTRL_WAKE1KHZ_RUN = 0x0
	// Time-out. The 1 kHz high-resolution/wake-up timer has timed out. This flag generates an RTC wake-up interrupt request RTC-WAKE which can also wake up the part from any low power mode. Writing a 1 clears this bit.
	RTC_CTRL_WAKE1KHZ_TIME_OUT = 0x1
	// Position of ALARMDPD_EN field.
	RTC_CTRL_ALARMDPD_EN_Pos = 0x4
	// Bit mask of ALARMDPD_EN field.
	RTC_CTRL_ALARMDPD_EN_Msk = 0x10
	// Bit ALARMDPD_EN.
	RTC_CTRL_ALARMDPD_EN = 0x10
	// Disable. A match on the 1 Hz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_ALARMDPD_EN_DISABLE = 0x0
	// Enable. A match on the 1 Hz RTC timer bring the part out of Deep power-down mode.
	RTC_CTRL_ALARMDPD_EN_ENABLE = 0x1
	// Position of WAKEDPD_EN field.
	RTC_CTRL_WAKEDPD_EN_Pos = 0x5
	// Bit mask of WAKEDPD_EN field.
	RTC_CTRL_WAKEDPD_EN_Msk = 0x20
	// Bit WAKEDPD_EN.
	RTC_CTRL_WAKEDPD_EN = 0x20
	// Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_WAKEDPD_EN_DISABLE = 0x0
	// Enable. A match on the 1 kHz RTC timer bring the part out of Deep power-down mode.
	RTC_CTRL_WAKEDPD_EN_ENABLE = 0x1
	// Position of RTC1KHZ_EN field.
	RTC_CTRL_RTC1KHZ_EN_Pos = 0x6
	// Bit mask of RTC1KHZ_EN field.
	RTC_CTRL_RTC1KHZ_EN_Msk = 0x40
	// Bit RTC1KHZ_EN.
	RTC_CTRL_RTC1KHZ_EN = 0x40
	// Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_RTC1KHZ_EN_DISABLE = 0x0
	// Enable. The 1 kHz RTC timer is enabled.
	RTC_CTRL_RTC1KHZ_EN_ENABLE = 0x1
	// Position of RTC_EN field.
	RTC_CTRL_RTC_EN_Pos = 0x7
	// Bit mask of RTC_EN field.
	RTC_CTRL_RTC_EN_Msk = 0x80
	// Bit RTC_EN.
	RTC_CTRL_RTC_EN = 0x80
	// Disable. The RTC 1 Hz and 1 kHz clocks are shut down and the RTC operation is disabled. This bit should be 0 when writing to load a value in the RTC counter register.
	RTC_CTRL_RTC_EN_DISABLE = 0x0
	// Enable. The 1 Hz RTC clock is running and RTC operation is enabled. You must set this bit to initiate operation of the RTC. The first clock to the RTC counter occurs 1 s after this bit is set. To also enable the high-resolution, 1 kHz clock, set bit 6 in this register.
	RTC_CTRL_RTC_EN_ENABLE = 0x1
	// Position of RESERVED field.
	RTC_CTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	RTC_CTRL_RESERVED_Msk = 0xffffff00

	// MATCH: RTC match register
	// Position of MATVAL field.
	RTC_MATCH_MATVAL_Pos = 0x0
	// Bit mask of MATVAL field.
	RTC_MATCH_MATVAL_Msk = 0xffffffff

	// COUNT: RTC counter register
	// Position of VAL field.
	RTC_COUNT_VAL_Pos = 0x0
	// Bit mask of VAL field.
	RTC_COUNT_VAL_Msk = 0xffffffff

	// WAKE: RTC high-resolution/wake-up timer control register
	// Position of VAL field.
	RTC_WAKE_VAL_Pos = 0x0
	// Bit mask of VAL field.
	RTC_WAKE_VAL_Msk = 0xffff
	// Position of RESERVED field.
	RTC_WAKE_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RTC_WAKE_RESERVED_Msk = 0xffff0000
)

// Bitfields for DMATRIGMUX: DMA controller
const (
	// DMA_ITRIG_PINMUX: Trigger input select register for DMA channel 0.
	// Position of INP_N field.
	DMATRIGMUX_DMA_ITRIG_PINMUX_INP_N_Pos = 0x0
	// Bit mask of INP_N field.
	DMATRIGMUX_DMA_ITRIG_PINMUX_INP_N_Msk = 0x1f
	// Position of RESERVED field.
	DMATRIGMUX_DMA_ITRIG_PINMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	DMATRIGMUX_DMA_ITRIG_PINMUX_RESERVED_Msk = 0xffffffe0
)

// Bitfields for PMU: Power Management Unit (PMU)
const (
	// PCON: Power control register
	// Position of PM field.
	PMU_PCON_PM_Pos = 0x0
	// Bit mask of PM field.
	PMU_PCON_PM_Msk = 0x7
	// Default. The part is in active or sleep mode.
	PMU_PCON_PM_DEFAULT = 0x0
	// Deep-sleep. ARM WFI will enter Deep-sleep mode.
	PMU_PCON_PM_DEEP_SLEEP = 0x1
	// Power-down. ARM WFI will enter Power-down mode.
	PMU_PCON_PM_POWER_DOWN = 0x2
	// Deep power-down. ARM WFI will enter Deep-power down mode (ARM Cortex-M0+ core powered-down).
	PMU_PCON_PM_DEEP_POWER_DOWN = 0x3
	// Position of NODPD field.
	PMU_PCON_NODPD_Pos = 0x3
	// Bit mask of NODPD field.
	PMU_PCON_NODPD_Msk = 0x8
	// Bit NODPD.
	PMU_PCON_NODPD = 0x8
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xf0
	// Position of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Pos = 0x8
	// Bit mask of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Msk = 0x100
	// Bit SLEEPFLAG.
	PMU_PCON_SLEEPFLAG = 0x100
	// Active mode. Read: No power-down mode entered. Part is in Active mode. Write: No effect.
	PMU_PCON_SLEEPFLAG_ACTIVE_MODE = 0x0
	// Low power mode. Read: Sleep/Deep-sleep or Deep power-down mode entered. Write: Writing a 1 clears the SLEEPFLAG bit to 0.
	PMU_PCON_SLEEPFLAG_LOW_POWER_MODE = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0x600
	// Position of DPDFLAG field.
	PMU_PCON_DPDFLAG_Pos = 0xb
	// Bit mask of DPDFLAG field.
	PMU_PCON_DPDFLAG_Msk = 0x800
	// Bit DPDFLAG.
	PMU_PCON_DPDFLAG = 0x800
	// Not Deep power-down. Read: Deep power-down mode not entered. Write: No effect.
	PMU_PCON_DPDFLAG_NOT_DEEP_POWER_DOWN = 0x0
	// Deep power-down. Read: Deep power-down mode entered. Write: Clear the Deep power-down flag.
	PMU_PCON_DPDFLAG_DEEP_POWER_DOWN = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xfffff000

	// GPREG0: General purpose register 0
	// Position of GPDATA field.
	PMU_GPREG_GPDATA_Pos = 0x0
	// Bit mask of GPDATA field.
	PMU_GPREG_GPDATA_Msk = 0xffffffff

	// GPREG4: Deep power down control register
	// Position of RESERVED field.
	PMU_GPREG4_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	PMU_GPREG4_RESERVED_Msk = 0x3ff
	// Position of WAKEUPHYS field.
	PMU_GPREG4_WAKEUPHYS_Pos = 0xa
	// Bit mask of WAKEUPHYS field.
	PMU_GPREG4_WAKEUPHYS_Msk = 0x400
	// Bit WAKEUPHYS.
	PMU_GPREG4_WAKEUPHYS = 0x400
	// Disable Hysteresis for WAKUP pin disabled.
	PMU_GPREG4_WAKEUPHYS_DISABLE_HYSTERESIS_F = 0x0
	// Enable. Hysteresis for WAKEUP pin enabled.
	PMU_GPREG4_WAKEUPHYS_ENABLE = 0x1
	// Position of WAKEPAD_DISABLE field.
	PMU_GPREG4_WAKEPAD_DISABLE_Pos = 0xb
	// Bit mask of WAKEPAD_DISABLE field.
	PMU_GPREG4_WAKEPAD_DISABLE_Msk = 0x800
	// Bit WAKEPAD_DISABLE.
	PMU_GPREG4_WAKEPAD_DISABLE = 0x800
	// Enable. The wake-up function is enabled on pin PIO0_16.
	PMU_GPREG4_WAKEPAD_DISABLE_ENABLE = 0x0
	// Disable. Setting this bit disables the wake-up function on pin PIO0_16.
	PMU_GPREG4_WAKEPAD_DISABLE_DISABLE = 0x1
	// Position of GPDATA field.
	PMU_GPREG4_GPDATA_Pos = 0xc
	// Bit mask of GPDATA field.
	PMU_GPREG4_GPDATA_Msk = 0xfffff000
)

// Bitfields for FLASHCTRL: Flash controller
const (
	// FLASHCFG: Flash configuration register
	// Position of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Pos = 0x0
	// Bit mask of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Msk = 0x3
	// 1 system clock flash access time (for system clock frequencies of up to 20 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_1_SYSTEM_CLOCK_FLASH = 0x0
	// 2 system clocks flash access time (for system clock frequencies of up to 30 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_2_SYSTEM_CLOCKS_FLAS = 0x1
	// Position of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Msk = 0xfffffffc

	// FMSSTART: Signature start address register
	// Position of START field.
	FLASHCTRL_FMSSTART_START_Pos = 0x0
	// Bit mask of START field.
	FLASHCTRL_FMSSTART_START_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Msk = 0xfffe0000

	// FMSSTOP: Signature stop-address register
	// Position of STOPA field.
	FLASHCTRL_FMSSTOP_STOPA_Pos = 0x0
	// Bit mask of STOPA field.
	FLASHCTRL_FMSSTOP_STOPA_Msk = 0x1ffff
	// Position of STRTBIST field.
	FLASHCTRL_FMSSTOP_STRTBIST_Pos = 0x11
	// Bit mask of STRTBIST field.
	FLASHCTRL_FMSSTOP_STRTBIST_Msk = 0x20000
	// Bit STRTBIST.
	FLASHCTRL_FMSSTOP_STRTBIST = 0x20000
	// Position of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Msk = 0xfffc0000

	// FMSW0: Signature Word
	// Position of SIG field.
	FLASHCTRL_FMSW0_SIG_Pos = 0x0
	// Bit mask of SIG field.
	FLASHCTRL_FMSW0_SIG_Msk = 0xffffffff
)

// Bitfields for SSP0: SSP/SPI
const (
	// CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
	// Position of DSS field.
	SSP0_CR0_DSS_Pos = 0x0
	// Bit mask of DSS field.
	SSP0_CR0_DSS_Msk = 0xf
	// 4-bit transfer
	SSP0_CR0_DSS_4_BIT_TRANSFER = 0x3
	// 5-bit transfer
	SSP0_CR0_DSS_5_BIT_TRANSFER = 0x4
	// 6-bit transfer
	SSP0_CR0_DSS_6_BIT_TRANSFER = 0x5
	// 7-bit transfer
	SSP0_CR0_DSS_7_BIT_TRANSFER = 0x6
	// 8-bit transfer
	SSP0_CR0_DSS_8_BIT_TRANSFER = 0x7
	// 9-bit transfer
	SSP0_CR0_DSS_9_BIT_TRANSFER = 0x8
	// 10-bit transfer
	SSP0_CR0_DSS_10_BIT_TRANSFER = 0x9
	// 11-bit transfer
	SSP0_CR0_DSS_11_BIT_TRANSFER = 0xa
	// 12-bit transfer
	SSP0_CR0_DSS_12_BIT_TRANSFER = 0xb
	// 13-bit transfer
	SSP0_CR0_DSS_13_BIT_TRANSFER = 0xc
	// 14-bit transfer
	SSP0_CR0_DSS_14_BIT_TRANSFER = 0xd
	// 15-bit transfer
	SSP0_CR0_DSS_15_BIT_TRANSFER = 0xe
	// 16-bit transfer
	SSP0_CR0_DSS_16_BIT_TRANSFER = 0xf
	// Position of FRF field.
	SSP0_CR0_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SSP0_CR0_FRF_Msk = 0x30
	// SPI
	SSP0_CR0_FRF_SPI = 0x0
	// TI
	SSP0_CR0_FRF_TI = 0x1
	// Microwire
	SSP0_CR0_FRF_MICROWIRE = 0x2
	// Position of CPOL field.
	SSP0_CR0_CPOL_Pos = 0x6
	// Bit mask of CPOL field.
	SSP0_CR0_CPOL_Msk = 0x40
	// Bit CPOL.
	SSP0_CR0_CPOL = 0x40
	// SPI controller maintains the bus clock low between frames.
	SSP0_CR0_CPOL_LOW = 0x0
	// SPI controller maintains the bus clock high between frames.
	SSP0_CR0_CPOL_HIGH = 0x1
	// Position of CPHA field.
	SSP0_CR0_CPHA_Pos = 0x7
	// Bit mask of CPHA field.
	SSP0_CR0_CPHA_Msk = 0x80
	// Bit CPHA.
	SSP0_CR0_CPHA = 0x80
	// SPI controller captures serial data on the first clock transition of the frame, that is, the transition away from the inter-frame state of the clock line.
	SSP0_CR0_CPHA_FIRSTCLOCK = 0x0
	// SPI controller captures serial data on the second clock transition of the frame, that is, the transition back to the inter-frame state of the clock line.
	SSP0_CR0_CPHA_SECONDCLOCK = 0x1
	// Position of SCR field.
	SSP0_CR0_SCR_Pos = 0x8
	// Bit mask of SCR field.
	SSP0_CR0_SCR_Msk = 0xff00
	// Position of RESERVED field.
	SSP0_CR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP0_CR0_RESERVED_Msk = 0xffff0000

	// CR1: Control Register 1. Selects master/slave and other modes.
	// Position of LBM field.
	SSP0_CR1_LBM_Pos = 0x0
	// Bit mask of LBM field.
	SSP0_CR1_LBM_Msk = 0x1
	// Bit LBM.
	SSP0_CR1_LBM = 0x1
	// During normal operation.
	SSP0_CR1_LBM_DURING_NORMAL_OPERAT = 0x0
	// Serial input is taken from the serial output (MOSI or MISO) rather than the serial input pin (MISO or MOSI respectively).
	SSP0_CR1_LBM_SERIAL_INPUT_IS_TAKE = 0x1
	// Position of SSE field.
	SSP0_CR1_SSE_Pos = 0x1
	// Bit mask of SSE field.
	SSP0_CR1_SSE_Msk = 0x2
	// Bit SSE.
	SSP0_CR1_SSE = 0x2
	// The SPI controller is disabled.
	SSP0_CR1_SSE_DISABLED = 0x0
	// The SPI controller will interact with other devices on the serial bus. Software should write the appropriate control information to the other SSP/SPI registers and interrupt controller registers, before setting this bit.
	SSP0_CR1_SSE_ENABLED = 0x1
	// Position of MS field.
	SSP0_CR1_MS_Pos = 0x2
	// Bit mask of MS field.
	SSP0_CR1_MS_Msk = 0x4
	// Bit MS.
	SSP0_CR1_MS = 0x4
	// The SPI controller acts as a master on the bus, driving the SCLK, MOSI, and SSEL lines and receiving the MISO line.
	SSP0_CR1_MS_MASTER = 0x0
	// The SPI controller acts as a slave on the bus, driving MISO line and receiving SCLK, MOSI, and SSEL lines.
	SSP0_CR1_MS_SLAVE = 0x1
	// Position of SOD field.
	SSP0_CR1_SOD_Pos = 0x3
	// Bit mask of SOD field.
	SSP0_CR1_SOD_Msk = 0x8
	// Bit SOD.
	SSP0_CR1_SOD = 0x8
	// Position of RESERVED field.
	SSP0_CR1_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_CR1_RESERVED_Msk = 0xfffffff0

	// DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
	// Position of DATA field.
	SSP0_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SSP0_DR_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SSP0_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP0_DR_RESERVED_Msk = 0xffff0000

	// SR: Status Register
	// Position of TFE field.
	SSP0_SR_TFE_Pos = 0x0
	// Bit mask of TFE field.
	SSP0_SR_TFE_Msk = 0x1
	// Bit TFE.
	SSP0_SR_TFE = 0x1
	// Position of TNF field.
	SSP0_SR_TNF_Pos = 0x1
	// Bit mask of TNF field.
	SSP0_SR_TNF_Msk = 0x2
	// Bit TNF.
	SSP0_SR_TNF = 0x2
	// Position of RNE field.
	SSP0_SR_RNE_Pos = 0x2
	// Bit mask of RNE field.
	SSP0_SR_RNE_Msk = 0x4
	// Bit RNE.
	SSP0_SR_RNE = 0x4
	// Position of RFF field.
	SSP0_SR_RFF_Pos = 0x3
	// Bit mask of RFF field.
	SSP0_SR_RFF_Msk = 0x8
	// Bit RFF.
	SSP0_SR_RFF = 0x8
	// Position of BSY field.
	SSP0_SR_BSY_Pos = 0x4
	// Bit mask of BSY field.
	SSP0_SR_BSY_Msk = 0x10
	// Bit BSY.
	SSP0_SR_BSY = 0x10
	// Position of RESERVED field.
	SSP0_SR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SSP0_SR_RESERVED_Msk = 0xffffffe0

	// CPSR: Clock Prescale Register
	// Position of CPSDVSR field.
	SSP0_CPSR_CPSDVSR_Pos = 0x0
	// Bit mask of CPSDVSR field.
	SSP0_CPSR_CPSDVSR_Msk = 0xff
	// Position of RESERVED field.
	SSP0_CPSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SSP0_CPSR_RESERVED_Msk = 0xffffff00

	// IMSC: Interrupt Mask Set and Clear Register
	// Position of RORIM field.
	SSP0_IMSC_RORIM_Pos = 0x0
	// Bit mask of RORIM field.
	SSP0_IMSC_RORIM_Msk = 0x1
	// Bit RORIM.
	SSP0_IMSC_RORIM = 0x1
	// Position of RTIM field.
	SSP0_IMSC_RTIM_Pos = 0x1
	// Bit mask of RTIM field.
	SSP0_IMSC_RTIM_Msk = 0x2
	// Bit RTIM.
	SSP0_IMSC_RTIM = 0x2
	// Position of RXIM field.
	SSP0_IMSC_RXIM_Pos = 0x2
	// Bit mask of RXIM field.
	SSP0_IMSC_RXIM_Msk = 0x4
	// Bit RXIM.
	SSP0_IMSC_RXIM = 0x4
	// Position of TXIM field.
	SSP0_IMSC_TXIM_Pos = 0x3
	// Bit mask of TXIM field.
	SSP0_IMSC_TXIM_Msk = 0x8
	// Bit TXIM.
	SSP0_IMSC_TXIM = 0x8
	// Position of RESERVED field.
	SSP0_IMSC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_IMSC_RESERVED_Msk = 0xfffffff0

	// RIS: Raw Interrupt Status Register
	// Position of RORRIS field.
	SSP0_RIS_RORRIS_Pos = 0x0
	// Bit mask of RORRIS field.
	SSP0_RIS_RORRIS_Msk = 0x1
	// Bit RORRIS.
	SSP0_RIS_RORRIS = 0x1
	// Position of RTRIS field.
	SSP0_RIS_RTRIS_Pos = 0x1
	// Bit mask of RTRIS field.
	SSP0_RIS_RTRIS_Msk = 0x2
	// Bit RTRIS.
	SSP0_RIS_RTRIS = 0x2
	// Position of RXRIS field.
	SSP0_RIS_RXRIS_Pos = 0x2
	// Bit mask of RXRIS field.
	SSP0_RIS_RXRIS_Msk = 0x4
	// Bit RXRIS.
	SSP0_RIS_RXRIS = 0x4
	// Position of TXRIS field.
	SSP0_RIS_TXRIS_Pos = 0x3
	// Bit mask of TXRIS field.
	SSP0_RIS_TXRIS_Msk = 0x8
	// Bit TXRIS.
	SSP0_RIS_TXRIS = 0x8
	// Position of RESERVED field.
	SSP0_RIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_RIS_RESERVED_Msk = 0xfffffff0

	// MIS: Masked Interrupt Status Register
	// Position of RORMIS field.
	SSP0_MIS_RORMIS_Pos = 0x0
	// Bit mask of RORMIS field.
	SSP0_MIS_RORMIS_Msk = 0x1
	// Bit RORMIS.
	SSP0_MIS_RORMIS = 0x1
	// Position of RTMIS field.
	SSP0_MIS_RTMIS_Pos = 0x1
	// Bit mask of RTMIS field.
	SSP0_MIS_RTMIS_Msk = 0x2
	// Bit RTMIS.
	SSP0_MIS_RTMIS = 0x2
	// Position of RXMIS field.
	SSP0_MIS_RXMIS_Pos = 0x2
	// Bit mask of RXMIS field.
	SSP0_MIS_RXMIS_Msk = 0x4
	// Bit RXMIS.
	SSP0_MIS_RXMIS = 0x4
	// Position of TXMIS field.
	SSP0_MIS_TXMIS_Pos = 0x3
	// Bit mask of TXMIS field.
	SSP0_MIS_TXMIS_Msk = 0x8
	// Bit TXMIS.
	SSP0_MIS_TXMIS = 0x8
	// Position of RESERVED field.
	SSP0_MIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP0_MIS_RESERVED_Msk = 0xfffffff0

	// ICR: SSPICR Interrupt Clear Register
	// Position of RORIC field.
	SSP0_ICR_RORIC_Pos = 0x0
	// Bit mask of RORIC field.
	SSP0_ICR_RORIC_Msk = 0x1
	// Bit RORIC.
	SSP0_ICR_RORIC = 0x1
	// Position of RTIC field.
	SSP0_ICR_RTIC_Pos = 0x1
	// Bit mask of RTIC field.
	SSP0_ICR_RTIC_Msk = 0x2
	// Bit RTIC.
	SSP0_ICR_RTIC = 0x2
	// Position of RESERVED field.
	SSP0_ICR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SSP0_ICR_RESERVED_Msk = 0xfffffffc
)

// Bitfields for IOCON: I/O control (IOCON)
const (
	// PIO0_0: I/O configuration for port PIO0
	// Position of FUNC field.
	IOCON_PIO0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_HYS = 0x20
	// Disable.
	IOCON_PIO0_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO0_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Disable.
	IOCON_PIO0_OD_DISABLE = 0x0
	// Enable. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_OD_ENABLE = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO0_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO0_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xffff0000

	// PIO0_4: I/O configuration for open-drain pin PIO0_4
	// Position of FUNC field.
	IOCON_PIO0_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_4_FUNC_Msk = 0x7
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0xf8
	// Position of I2CMODE field.
	IOCON_PIO0_4_I2CMODE_Pos = 0x8
	// Bit mask of I2CMODE field.
	IOCON_PIO0_4_I2CMODE_Msk = 0x300
	// Standard mode/ Fast-mode I2C.
	IOCON_PIO0_4_I2CMODE_STANDARD_MODE_FAST = 0x0
	// Standard I/O functionality
	IOCON_PIO0_4_I2CMODE_STANDARD_IO_FUNCTIO = 0x1
	// Fast-mode Plus I2C
	IOCON_PIO0_4_I2CMODE_FAST_MODE_PLUS_I2C = 0x2
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0xfffffc00

	// PIO0_5: I/O configuration for open-drain pin PIO0_5
	// Position of FUNC field.
	IOCON_PIO0_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_5_FUNC_Msk = 0x7
	// Position of RESERVED field.
	IOCON_PIO0_5_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_PIO0_5_RESERVED_Msk = 0xf8
	// Position of I2CMODE field.
	IOCON_PIO0_5_I2CMODE_Pos = 0x8
	// Bit mask of I2CMODE field.
	IOCON_PIO0_5_I2CMODE_Msk = 0x300
	// Standard mode/ Fast-mode I2C.
	IOCON_PIO0_5_I2CMODE_STANDARD_MODE_FAST = 0x0
	// Standard I/O functionality
	IOCON_PIO0_5_I2CMODE_STANDARD_IO_FUNCTIO = 0x1
	// Fast-mode Plus I2C
	IOCON_PIO0_5_I2CMODE_FAST_MODE_PLUS_I2C = 0x2
	// Position of RESERVED field.
	IOCON_PIO0_5_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_5_RESERVED_Msk = 0xfffffc00

	// PIO0_6: I/O configuration for port PIO0
	// Position of FUNC field.
	IOCON_PIO0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_HYS = 0x20
	// Disable.
	IOCON_PIO0_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO0_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Disable.
	IOCON_PIO0_OD_DISABLE = 0x0
	// Enable. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_OD_ENABLE = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO0_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO0_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO0_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xffff0000

	// PIO1_0: I/O configuration for port PIO1
	// Position of FUNC field.
	IOCON_PIO1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO1_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO1_HYS = 0x20
	// Disable.
	IOCON_PIO1_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO1_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO1_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO1_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_OD = 0x400
	// Disable.
	IOCON_PIO1_OD_DISABLE = 0x0
	// Enabled. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO1_OD_ENABLED = 0x1
	// Position of S_MODE field.
	IOCON_PIO1_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO1_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO1_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO1_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO1_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO1_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO1_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO1_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO1_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0xffff0000

	// PIO2_0: I/O configuration for port PIO2
	// Position of FUNC field.
	IOCON_PIO2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO2_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO2_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO2_HYS = 0x20
	// Disable.
	IOCON_PIO2_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO2_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO2_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO2_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO2_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO2_OD = 0x400
	// Disable.
	IOCON_PIO2_OD_DISABLE = 0x0
	// Enabled. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO2_OD_ENABLED = 0x1
	// Position of S_MODE field.
	IOCON_PIO2_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO2_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO2_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO2_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO2_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO2_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO2_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO2_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0xffff0000

	// PIO2_2: I/O configuration for port PIO2
	// Position of FUNC field.
	IOCON_PIO2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO2_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO2_MODE_REPEATER_MODE = 0x3
	// Position of HYS field.
	IOCON_PIO2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO2_HYS = 0x20
	// Disable.
	IOCON_PIO2_HYS_DISABLE = 0x0
	// Enable.
	IOCON_PIO2_HYS_ENABLE = 0x1
	// Position of INV field.
	IOCON_PIO2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO2_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO2_INV_INPUT_NOT_INVERTED = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO2_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO2_OD = 0x400
	// Disable.
	IOCON_PIO2_OD_DISABLE = 0x0
	// Enabled. Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO2_OD_ENABLED = 0x1
	// Position of S_MODE field.
	IOCON_PIO2_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO2_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO2_S_MODE_BYPASS_INPUT_FILTER = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO2_S_MODE_1_CLOCK_CYCLE = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO2_S_MODE_2_CLOCK_CYCLES = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO2_S_MODE_3_CLOCK_CYCLES = 0x3
	// Position of CLKDIV field.
	IOCON_PIO2_CLKDIV_Pos = 0xd
	// Bit mask of CLKDIV field.
	IOCON_PIO2_CLKDIV_Msk = 0xe000
	// IOCONCLKDIV0. Use IOCON clock divider 0.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV0 = 0x0
	// IOCONCLKDIV1. Use IOCON clock divider 1.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV1 = 0x1
	// IOCONCLKDIV2 Use IOCON clock divider 2.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV2 = 0x2
	// IOCONCLKDIV3. Use IOCON clock divider 3.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV3 = 0x3
	// IOCONCLKDIV4. Use IOCON clock divider 4.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV4 = 0x4
	// IOCONCLKDIV5. Use IOCON clock divider 5.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV5 = 0x5
	// IOCONCLKDIV6. Use IOCON clock divider 6.
	IOCON_PIO2_CLKDIV_IOCONCLKDIV6 = 0x6
	// Position of RESERVED field.
	IOCON_PIO2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO2_RESERVED_Msk = 0xffff0000
)

// Bitfields for SYSCON: System configuration (SYSCON)
const (
	// SYSMEMREMAP: System memory remap
	// Position of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Pos = 0x0
	// Bit mask of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Msk = 0x3
	// Boot Loader Mode. Interrupt vectors are re-mapped to Boot ROM.
	SYSCON_SYSMEMREMAP_MAP_BOOT_LOADER_MODE = 0x0
	// User RAM Mode. Interrupt vectors are re-mapped to Static RAM.
	SYSCON_SYSMEMREMAP_MAP_USER_RAM_MODE = 0x1
	// User Flash Mode. Interrupt vectors are not re-mapped and reside in Flash.
	SYSCON_SYSMEMREMAP_MAP_USER_FLASH_MODE = 0x2
	// Position of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Msk = 0xfffffffc

	// PRESETCTRL: Peripheral reset control
	// Position of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Pos = 0x0
	// Bit mask of SSP0_RST_N field.
	SYSCON_PRESETCTRL_SSP0_RST_N_Msk = 0x1
	// Bit SSP0_RST_N.
	SYSCON_PRESETCTRL_SSP0_RST_N = 0x1
	// Reset. Resets the SSP0 peripheral.
	SYSCON_PRESETCTRL_SSP0_RST_N_RESET = 0x0
	// Clear reset. SSP0 reset de-asserted.
	SYSCON_PRESETCTRL_SSP0_RST_N_CLEAR_RESET = 0x1
	// Position of I2C0_RST_N field.
	SYSCON_PRESETCTRL_I2C0_RST_N_Pos = 0x1
	// Bit mask of I2C0_RST_N field.
	SYSCON_PRESETCTRL_I2C0_RST_N_Msk = 0x2
	// Bit I2C0_RST_N.
	SYSCON_PRESETCTRL_I2C0_RST_N = 0x2
	// Reset. Resets the I2C0 peripheral.
	SYSCON_PRESETCTRL_I2C0_RST_N_RESET = 0x0
	// Clear reset. I2C0 reset de-asserted.
	SYSCON_PRESETCTRL_I2C0_RST_N_CLEAR_RESET = 0x1
	// Position of SSP1_RST_N field.
	SYSCON_PRESETCTRL_SSP1_RST_N_Pos = 0x2
	// Bit mask of SSP1_RST_N field.
	SYSCON_PRESETCTRL_SSP1_RST_N_Msk = 0x4
	// Bit SSP1_RST_N.
	SYSCON_PRESETCTRL_SSP1_RST_N = 0x4
	// Reset. Resets the SSP1 peripheral.
	SYSCON_PRESETCTRL_SSP1_RST_N_RESET = 0x0
	// Clear reset. SSP1 reset de-asserted.
	SYSCON_PRESETCTRL_SSP1_RST_N_CLEAR_RESET = 0x1
	// Position of I2C1_RST_N field.
	SYSCON_PRESETCTRL_I2C1_RST_N_Pos = 0x3
	// Bit mask of I2C1_RST_N field.
	SYSCON_PRESETCTRL_I2C1_RST_N_Msk = 0x8
	// Bit I2C1_RST_N.
	SYSCON_PRESETCTRL_I2C1_RST_N = 0x8
	// Reset. Resets the I2C1 peripheral.
	SYSCON_PRESETCTRL_I2C1_RST_N_RESET = 0x0
	// Clear reset. I2C1 reset de-asserted.
	SYSCON_PRESETCTRL_I2C1_RST_N_CLEAR_RESET = 0x1
	// Position of FRG_RST_N field.
	SYSCON_PRESETCTRL_FRG_RST_N_Pos = 0x4
	// Bit mask of FRG_RST_N field.
	SYSCON_PRESETCTRL_FRG_RST_N_Msk = 0x10
	// Bit FRG_RST_N.
	SYSCON_PRESETCTRL_FRG_RST_N = 0x10
	// Reset. Resets the FRG peripheral.
	SYSCON_PRESETCTRL_FRG_RST_N_RESET = 0x0
	// Clear reset. FRG reset de-asserted.
	SYSCON_PRESETCTRL_FRG_RST_N_CLEAR_RESET = 0x1
	// Position of USART1_RST_N field.
	SYSCON_PRESETCTRL_USART1_RST_N_Pos = 0x5
	// Bit mask of USART1_RST_N field.
	SYSCON_PRESETCTRL_USART1_RST_N_Msk = 0x20
	// Bit USART1_RST_N.
	SYSCON_PRESETCTRL_USART1_RST_N = 0x20
	// Reset. Resets the USART1 peripheral.
	SYSCON_PRESETCTRL_USART1_RST_N_RESET = 0x0
	// Clear reset. USART1 reset de-asserted.
	SYSCON_PRESETCTRL_USART1_RST_N_CLEAR_RESET = 0x1
	// Position of USART2_RST_N field.
	SYSCON_PRESETCTRL_USART2_RST_N_Pos = 0x6
	// Bit mask of USART2_RST_N field.
	SYSCON_PRESETCTRL_USART2_RST_N_Msk = 0x40
	// Bit USART2_RST_N.
	SYSCON_PRESETCTRL_USART2_RST_N = 0x40
	// Reset. Resets the USART2 peripheral.
	SYSCON_PRESETCTRL_USART2_RST_N_RESET = 0x0
	// Clear reset. USART2 reset de-asserted.
	SYSCON_PRESETCTRL_USART2_RST_N_CLEAR_RESET = 0x1
	// Position of USART3_RST_N field.
	SYSCON_PRESETCTRL_USART3_RST_N_Pos = 0x7
	// Bit mask of USART3_RST_N field.
	SYSCON_PRESETCTRL_USART3_RST_N_Msk = 0x80
	// Bit USART3_RST_N.
	SYSCON_PRESETCTRL_USART3_RST_N = 0x80
	// Reset. Resets the USART3 peripheral.
	SYSCON_PRESETCTRL_USART3_RST_N_RESET = 0x0
	// Clear reset. USART3 reset de-asserted.
	SYSCON_PRESETCTRL_USART3_RST_N_CLEAR_RESET = 0x1
	// Position of USART4_RST_N field.
	SYSCON_PRESETCTRL_USART4_RST_N_Pos = 0x8
	// Bit mask of USART4_RST_N field.
	SYSCON_PRESETCTRL_USART4_RST_N_Msk = 0x100
	// Bit USART4_RST_N.
	SYSCON_PRESETCTRL_USART4_RST_N = 0x100
	// Reset. Resets the USART4 peripheral.
	SYSCON_PRESETCTRL_USART4_RST_N_RESET = 0x0
	// Clear reset. USART4 reset de-asserted.
	SYSCON_PRESETCTRL_USART4_RST_N_CLEAR_RESET = 0x1
	// Position of SCT0_RST_N field.
	SYSCON_PRESETCTRL_SCT0_RST_N_Pos = 0x9
	// Bit mask of SCT0_RST_N field.
	SYSCON_PRESETCTRL_SCT0_RST_N_Msk = 0x200
	// Bit SCT0_RST_N.
	SYSCON_PRESETCTRL_SCT0_RST_N = 0x200
	// Reset. Resets the SCT0 peripheral.
	SYSCON_PRESETCTRL_SCT0_RST_N_RESET = 0x0
	// Clear reset. SCT0 reset de-asserted.
	SYSCON_PRESETCTRL_SCT0_RST_N_CLEAR_RESET = 0x1
	// Position of SCT1_RST_N field.
	SYSCON_PRESETCTRL_SCT1_RST_N_Pos = 0xa
	// Bit mask of SCT1_RST_N field.
	SYSCON_PRESETCTRL_SCT1_RST_N_Msk = 0x400
	// Bit SCT1_RST_N.
	SYSCON_PRESETCTRL_SCT1_RST_N = 0x400
	// Reset. Resets the SCT1 peripheral.
	SYSCON_PRESETCTRL_SCT1_RST_N_RESET = 0x0
	// Clear reset. SCT1 reset de-asserted.
	SYSCON_PRESETCTRL_SCT1_RST_N_CLEAR_RESET = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Msk = 0xfffff800

	// SYSPLLCTRL: System PLL control
	// Position of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Msk = 0x1f
	// Position of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Pos = 0x5
	// Bit mask of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Msk = 0x60
	// P = 1
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Msk = 0xffffff80

	// SYSPLLSTAT: System PLL status
	// Position of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_SYSPLLSTAT_LOCK = 0x1
	// No lock. PLL not locked
	SYSCON_SYSPLLSTAT_LOCK_NO_LOCK = 0x0
	// Lock. PLL locked
	SYSCON_SYSPLLSTAT_LOCK_LOCK = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Msk = 0xfffffffe

	// RTCOSCCTRL: RTC oscillator 32 kHz output control
	// Position of RTCOSCEN field.
	SYSCON_RTCOSCCTRL_RTCOSCEN_Pos = 0x0
	// Bit mask of RTCOSCEN field.
	SYSCON_RTCOSCCTRL_RTCOSCEN_Msk = 0x1
	// Bit RTCOSCEN.
	SYSCON_RTCOSCCTRL_RTCOSCEN = 0x1
	// Disabled. 32 kHz output disabled.
	SYSCON_RTCOSCCTRL_RTCOSCEN_DISABLED = 0x0
	// Enabled. 32 kHz output enabled.
	SYSCON_RTCOSCCTRL_RTCOSCEN_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_RTCOSCCTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_RTCOSCCTRL_RESERVED_Msk = 0xfffffffe

	// SYSOSCCTRL: System oscillator control
	// Position of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Pos = 0x0
	// Bit mask of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Msk = 0x1
	// Bit BYPASS.
	SYSCON_SYSOSCCTRL_BYPASS = 0x1
	// Oscillator is not bypassed.
	SYSCON_SYSOSCCTRL_BYPASS_OSCILLATOR_IS_NOT_BY = 0x0
	// Bypass enabled. PLL input (sys_osc_clk) is fed directly from the XTALIN pin bypassing the oscillator. Use this mode when using an external clock source instead of the crystal oscillator.
	SYSCON_SYSOSCCTRL_BYPASS_BYPASS_ENABLED = 0x1
	// Position of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Pos = 0x1
	// Bit mask of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Msk = 0x2
	// Bit FREQRANGE.
	SYSCON_SYSOSCCTRL_FREQRANGE = 0x2
	// Low. 1 - 20 MHz frequency range.
	SYSCON_SYSOSCCTRL_FREQRANGE_LOW = 0x0
	// High. 15 - 25 MHz frequency range.
	SYSCON_SYSOSCCTRL_FREQRANGE_HIGH = 0x1
	// Position of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Msk = 0xfffffffc

	// WDTOSCCTRL: Watchdog oscillator control
	// Position of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Pos = 0x0
	// Bit mask of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Msk = 0x1f
	// Position of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Pos = 0x5
	// Bit mask of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Msk = 0x1e0
	// 0.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_0 = 0x1
	// Position of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Msk = 0xfffffe00

	// IRCCTRL: IRC control
	// Position of TRIM field.
	SYSCON_IRCCTRL_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	SYSCON_IRCCTRL_TRIM_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Msk = 0xffffff00

	// SYSRSTSTAT: System reset status register
	// Position of POR field.
	SYSCON_SYSRSTSTAT_POR_Pos = 0x0
	// Bit mask of POR field.
	SYSCON_SYSRSTSTAT_POR_Msk = 0x1
	// Bit POR.
	SYSCON_SYSRSTSTAT_POR = 0x1
	// No POR detected
	SYSCON_SYSRSTSTAT_POR_NO_POR_DETECTED = 0x0
	// POR detected
	SYSCON_SYSRSTSTAT_POR_POR_DETECTED = 0x1
	// Position of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Pos = 0x1
	// Bit mask of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Msk = 0x2
	// Bit EXTRST.
	SYSCON_SYSRSTSTAT_EXTRST = 0x2
	// No reset event detected
	SYSCON_SYSRSTSTAT_EXTRST_NO_RESET_EVENT_DETEC = 0x0
	// Reset detected
	SYSCON_SYSRSTSTAT_EXTRST_RESET_DETECTED = 0x1
	// Position of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Pos = 0x2
	// Bit mask of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Msk = 0x4
	// Bit WDT.
	SYSCON_SYSRSTSTAT_WDT = 0x4
	// No WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_NO_WDT_RESET_DETECTE = 0x0
	// WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_WDT_RESET_DETECTED = 0x1
	// Position of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Pos = 0x3
	// Bit mask of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Msk = 0x8
	// Bit BOD.
	SYSCON_SYSRSTSTAT_BOD = 0x8
	// No BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_NO_BOD_RESET_DETECTE = 0x0
	// BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_BOD_RESET_DETECTED = 0x1
	// Position of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Pos = 0x4
	// Bit mask of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Msk = 0x10
	// Bit SYSRST.
	SYSCON_SYSRSTSTAT_SYSRST = 0x10
	// No System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_NO_SYSTEM_RESET_DETE = 0x0
	// System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_SYSTEM_RESET_DETECTE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Msk = 0xffffffe0

	// SYSPLLCLKSEL: System PLL clock source select
	// Position of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Msk = 0x3
	// IRC
	SYSCON_SYSPLLCLKSEL_SEL_IRC = 0x0
	// System oscillator. Crystal Oscillator (SYSOSC)
	SYSCON_SYSPLLCLKSEL_SEL_SYSTEM_OSCILLATOR = 0x1
	// 32 kHz clock.Select this option when the 32 kHz clock is the clock source for the main clock and select the pll input in the MAINCLKSEL register. Do not use the 32 kHz clock with the PLL.
	SYSCON_SYSPLLCLKSEL_SEL_32_KHZ_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// SYSPLLCLKUEN: System PLL clock source update enable
	// Position of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_SYSPLLCLKUEN_ENA = 0x1
	// No change
	SYSCON_SYSPLLCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_SYSPLLCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Msk = 0xfffffffe

	// MAINCLKSEL: Main clock source select
	// Position of SEL field.
	SYSCON_MAINCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSEL_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_MAINCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// PLL input
	SYSCON_MAINCLKSEL_SEL_PLL_INPUT = 0x1
	// Watchdog oscillator
	SYSCON_MAINCLKSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// PLL output
	SYSCON_MAINCLKSEL_SEL_PLL_OUTPUT = 0x3
	// Position of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Msk = 0xfffffffc

	// MAINCLKUEN: Main clock source update enable
	// Position of ENA field.
	SYSCON_MAINCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_MAINCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_MAINCLKUEN_ENA = 0x1
	// No change
	SYSCON_MAINCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_MAINCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Msk = 0xfffffffe

	// SYSAHBCLKDIV: System clock divider
	// Position of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Msk = 0xffffff00

	// SYSAHBCLKCTRL: System clock control
	// Position of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Pos = 0x0
	// Bit mask of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Msk = 0x1
	// Bit SYS.
	SYSCON_SYSAHBCLKCTRL_SYS = 0x1
	// Position of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Pos = 0x1
	// Bit mask of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Msk = 0x2
	// Bit ROM.
	SYSCON_SYSAHBCLKCTRL_ROM = 0x2
	// Disable
	SYSCON_SYSAHBCLKCTRL_ROM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ROM_ENABLE = 0x1
	// Position of RAM0 field.
	SYSCON_SYSAHBCLKCTRL_RAM0_Pos = 0x2
	// Bit mask of RAM0 field.
	SYSCON_SYSAHBCLKCTRL_RAM0_Msk = 0x4
	// Bit RAM0.
	SYSCON_SYSAHBCLKCTRL_RAM0 = 0x4
	// Disable
	SYSCON_SYSAHBCLKCTRL_RAM0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RAM0_ENABLE = 0x1
	// Position of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Pos = 0x3
	// Bit mask of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Msk = 0x8
	// Bit FLASHREG.
	SYSCON_SYSAHBCLKCTRL_FLASHREG = 0x8
	// Disabled
	SYSCON_SYSAHBCLKCTRL_FLASHREG_DISABLED = 0x0
	// Enabled
	SYSCON_SYSAHBCLKCTRL_FLASHREG_ENABLED = 0x1
	// Position of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Pos = 0x4
	// Bit mask of FLASHARRAY field.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_Msk = 0x10
	// Bit FLASHARRAY.
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY = 0x10
	// Disabled
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_DISABLED = 0x0
	// Enabled
	SYSCON_SYSAHBCLKCTRL_FLASHARRAY_ENABLED = 0x1
	// Position of I2C0 field.
	SYSCON_SYSAHBCLKCTRL_I2C0_Pos = 0x5
	// Bit mask of I2C0 field.
	SYSCON_SYSAHBCLKCTRL_I2C0_Msk = 0x20
	// Bit I2C0.
	SYSCON_SYSAHBCLKCTRL_I2C0 = 0x20
	// Disable
	SYSCON_SYSAHBCLKCTRL_I2C0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_I2C0_ENABLE = 0x1
	// Position of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Pos = 0x6
	// Bit mask of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Msk = 0x40
	// Bit GPIO.
	SYSCON_SYSAHBCLKCTRL_GPIO = 0x40
	// Disable
	SYSCON_SYSAHBCLKCTRL_GPIO_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GPIO_ENABLE = 0x1
	// Position of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Pos = 0x7
	// Bit mask of CT16B0 field.
	SYSCON_SYSAHBCLKCTRL_CT16B0_Msk = 0x80
	// Bit CT16B0.
	SYSCON_SYSAHBCLKCTRL_CT16B0 = 0x80
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B0_ENABLE = 0x1
	// Position of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Pos = 0x8
	// Bit mask of CT16B1 field.
	SYSCON_SYSAHBCLKCTRL_CT16B1_Msk = 0x100
	// Bit CT16B1.
	SYSCON_SYSAHBCLKCTRL_CT16B1 = 0x100
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT16B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT16B1_ENABLE = 0x1
	// Position of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Pos = 0x9
	// Bit mask of CT32B0 field.
	SYSCON_SYSAHBCLKCTRL_CT32B0_Msk = 0x200
	// Bit CT32B0.
	SYSCON_SYSAHBCLKCTRL_CT32B0 = 0x200
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B0_ENABLE = 0x1
	// Position of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Pos = 0xa
	// Bit mask of CT32B1 field.
	SYSCON_SYSAHBCLKCTRL_CT32B1_Msk = 0x400
	// Bit CT32B1.
	SYSCON_SYSAHBCLKCTRL_CT32B1 = 0x400
	// Disable
	SYSCON_SYSAHBCLKCTRL_CT32B1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CT32B1_ENABLE = 0x1
	// Position of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Pos = 0xb
	// Bit mask of SSP0 field.
	SYSCON_SYSAHBCLKCTRL_SSP0_Msk = 0x800
	// Bit SSP0.
	SYSCON_SYSAHBCLKCTRL_SSP0 = 0x800
	// Disable
	SYSCON_SYSAHBCLKCTRL_SSP0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SSP0_ENABLE = 0x1
	// Position of USART0 field.
	SYSCON_SYSAHBCLKCTRL_USART0_Pos = 0xc
	// Bit mask of USART0 field.
	SYSCON_SYSAHBCLKCTRL_USART0_Msk = 0x1000
	// Bit USART0.
	SYSCON_SYSAHBCLKCTRL_USART0 = 0x1000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USART0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USART0_ENABLE = 0x1
	// Position of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Pos = 0xd
	// Bit mask of ADC field.
	SYSCON_SYSAHBCLKCTRL_ADC_Msk = 0x2000
	// Bit ADC.
	SYSCON_SYSAHBCLKCTRL_ADC = 0x2000
	// Disable
	SYSCON_SYSAHBCLKCTRL_ADC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ADC_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x4000
	// Position of WWDT field.
	SYSCON_SYSAHBCLKCTRL_WWDT_Pos = 0xf
	// Bit mask of WWDT field.
	SYSCON_SYSAHBCLKCTRL_WWDT_Msk = 0x8000
	// Bit WWDT.
	SYSCON_SYSAHBCLKCTRL_WWDT = 0x8000
	// Disable
	SYSCON_SYSAHBCLKCTRL_WWDT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_WWDT_ENABLE = 0x1
	// Position of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Pos = 0x10
	// Bit mask of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Msk = 0x10000
	// Bit IOCON.
	SYSCON_SYSAHBCLKCTRL_IOCON = 0x10000
	// Disable
	SYSCON_SYSAHBCLKCTRL_IOCON_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_IOCON_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	SYSCON_SYSAHBCLKCTRL_RESERVED = 0x20000
	// Position of SSP1 field.
	SYSCON_SYSAHBCLKCTRL_SSP1_Pos = 0x12
	// Bit mask of SSP1 field.
	SYSCON_SYSAHBCLKCTRL_SSP1_Msk = 0x40000
	// Bit SSP1.
	SYSCON_SYSAHBCLKCTRL_SSP1 = 0x40000
	// Disable
	SYSCON_SYSAHBCLKCTRL_SSP1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SSP1_ENABLE = 0x1
	// Position of PINT field.
	SYSCON_SYSAHBCLKCTRL_PINT_Pos = 0x13
	// Bit mask of PINT field.
	SYSCON_SYSAHBCLKCTRL_PINT_Msk = 0x80000
	// Bit PINT.
	SYSCON_SYSAHBCLKCTRL_PINT = 0x80000
	// Disable
	SYSCON_SYSAHBCLKCTRL_PINT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_PINT_ENABLE = 0x1
	// Position of USART1 field.
	SYSCON_SYSAHBCLKCTRL_USART1_Pos = 0x14
	// Bit mask of USART1 field.
	SYSCON_SYSAHBCLKCTRL_USART1_Msk = 0x100000
	// Bit USART1.
	SYSCON_SYSAHBCLKCTRL_USART1 = 0x100000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USART1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USART1_ENABLE = 0x1
	// Position of USART2 field.
	SYSCON_SYSAHBCLKCTRL_USART2_Pos = 0x15
	// Bit mask of USART2 field.
	SYSCON_SYSAHBCLKCTRL_USART2_Msk = 0x200000
	// Bit USART2.
	SYSCON_SYSAHBCLKCTRL_USART2 = 0x200000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USART2_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USART2_ENABLE = 0x1
	// Position of USART3_4 field.
	SYSCON_SYSAHBCLKCTRL_USART3_4_Pos = 0x16
	// Bit mask of USART3_4 field.
	SYSCON_SYSAHBCLKCTRL_USART3_4_Msk = 0x400000
	// Bit USART3_4.
	SYSCON_SYSAHBCLKCTRL_USART3_4 = 0x400000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USART3_4_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USART3_4_ENABLE = 0x1
	// Position of GROUP0INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_Pos = 0x17
	// Bit mask of GROUP0INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_Msk = 0x800000
	// Bit GROUP0INT.
	SYSCON_SYSAHBCLKCTRL_GROUP0INT = 0x800000
	// Disable
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GROUP0INT_ENABLE = 0x1
	// Position of GROUP1INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_Pos = 0x18
	// Bit mask of GROUP1INT field.
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_Msk = 0x1000000
	// Bit GROUP1INT.
	SYSCON_SYSAHBCLKCTRL_GROUP1INT = 0x1000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GROUP1INT_ENABLE = 0x1
	// Position of I2C1 field.
	SYSCON_SYSAHBCLKCTRL_I2C1_Pos = 0x19
	// Bit mask of I2C1 field.
	SYSCON_SYSAHBCLKCTRL_I2C1_Msk = 0x2000000
	// Bit I2C1.
	SYSCON_SYSAHBCLKCTRL_I2C1 = 0x2000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_I2C1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_I2C1_ENABLE = 0x1
	// Position of RAM1 field.
	SYSCON_SYSAHBCLKCTRL_RAM1_Pos = 0x1a
	// Bit mask of RAM1 field.
	SYSCON_SYSAHBCLKCTRL_RAM1_Msk = 0x4000000
	// Bit RAM1.
	SYSCON_SYSAHBCLKCTRL_RAM1 = 0x4000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_RAM1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RAM1_ENABLE = 0x1
	// Position of USBSRAM field.
	SYSCON_SYSAHBCLKCTRL_USBSRAM_Pos = 0x1b
	// Bit mask of USBSRAM field.
	SYSCON_SYSAHBCLKCTRL_USBSRAM_Msk = 0x8000000
	// Bit USBSRAM.
	SYSCON_SYSAHBCLKCTRL_USBSRAM = 0x8000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_USBSRAM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_USBSRAM_ENABLE = 0x1
	// Position of CRC field.
	SYSCON_SYSAHBCLKCTRL_CRC_Pos = 0x1c
	// Bit mask of CRC field.
	SYSCON_SYSAHBCLKCTRL_CRC_Msk = 0x10000000
	// Bit CRC.
	SYSCON_SYSAHBCLKCTRL_CRC = 0x10000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_CRC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CRC_ENABLE = 0x1
	// Position of DMA field.
	SYSCON_SYSAHBCLKCTRL_DMA_Pos = 0x1d
	// Bit mask of DMA field.
	SYSCON_SYSAHBCLKCTRL_DMA_Msk = 0x20000000
	// Bit DMA.
	SYSCON_SYSAHBCLKCTRL_DMA = 0x20000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_DMA_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_DMA_ENABLE = 0x1
	// Position of RTC field.
	SYSCON_SYSAHBCLKCTRL_RTC_Pos = 0x1e
	// Bit mask of RTC field.
	SYSCON_SYSAHBCLKCTRL_RTC_Msk = 0x40000000
	// Bit RTC.
	SYSCON_SYSAHBCLKCTRL_RTC = 0x40000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_RTC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RTC_ENABLE = 0x1
	// Position of SCT0_1 field.
	SYSCON_SYSAHBCLKCTRL_SCT0_1_Pos = 0x1f
	// Bit mask of SCT0_1 field.
	SYSCON_SYSAHBCLKCTRL_SCT0_1_Msk = 0x80000000
	// Bit SCT0_1.
	SYSCON_SYSAHBCLKCTRL_SCT0_1 = 0x80000000
	// Disable
	SYSCON_SYSAHBCLKCTRL_SCT0_1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SCT0_1_ENABLE = 0x1

	// SSP0CLKDIV: SSP0 clock divider
	// Position of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SSP0CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SSP0CLKDIV_RESERVED_Msk = 0xffffff00

	// USART0CLKDIV: USART0 clock divider
	// Position of DIV field.
	SYSCON_USART0CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_USART0CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_USART0CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_USART0CLKDIV_RESERVED_Msk = 0xffffff00

	// SSP1CLKDIV: SSP1 clock divider
	// Position of DIV field.
	SYSCON_SSP1CLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SSP1CLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SSP1CLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SSP1CLKDIV_RESERVED_Msk = 0xffffff00

	// FRGCLKDIV: Clock divider for the common fractional baud rate generator of USART1, USART2, USART3, USART4
	// Position of DIV field.
	SYSCON_FRGCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_FRGCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_FRGCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_FRGCLKDIV_RESERVED_Msk = 0xffffff00

	// CLKOUTSEL: CLKOUT clock source select
	// Position of SEL field.
	SYSCON_CLKOUTSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTSEL_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_CLKOUTSEL_SEL_IRC_OSCILLATOR = 0x0
	// Crystal oscillator (SYSOSC)
	SYSCON_CLKOUTSEL_SEL_CRYSTAL_OSCILLATOR = 0x1
	// Watchdog oscillator
	SYSCON_CLKOUTSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// Main clock
	SYSCON_CLKOUTSEL_SEL_MAIN_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Msk = 0xfffffffc

	// CLKOUTUEN: CLKOUT clock source update enable
	// Position of ENA field.
	SYSCON_CLKOUTUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_CLKOUTUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_CLKOUTUEN_ENA = 0x1
	// No change
	SYSCON_CLKOUTUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_CLKOUTUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Msk = 0xfffffffe

	// CLKOUTDIV: CLKOUT clock divider
	// Position of DIV field.
	SYSCON_CLKOUTDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_CLKOUTDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Msk = 0xffffff00

	// UARTFRGDIV: USART fractional generator divider value
	// Position of DIV field.
	SYSCON_UARTFRGDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_UARTFRGDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTFRGDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTFRGDIV_RESERVED_Msk = 0xffffff00

	// UARTFRGMULT: USART fractional generator multiplier value
	// Position of MULT field.
	SYSCON_UARTFRGMULT_MULT_Pos = 0x0
	// Bit mask of MULT field.
	SYSCON_UARTFRGMULT_MULT_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTFRGMULT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTFRGMULT_RESERVED_Msk = 0xffffff00

	// EXTTRACECMD: External trace buffer command register
	// Position of START field.
	SYSCON_EXTTRACECMD_START_Pos = 0x0
	// Bit mask of START field.
	SYSCON_EXTTRACECMD_START_Msk = 0x1
	// Bit START.
	SYSCON_EXTTRACECMD_START = 0x1
	// Position of STOP field.
	SYSCON_EXTTRACECMD_STOP_Pos = 0x1
	// Bit mask of STOP field.
	SYSCON_EXTTRACECMD_STOP_Msk = 0x2
	// Bit STOP.
	SYSCON_EXTTRACECMD_STOP = 0x2
	// Position of RESERVED field.
	SYSCON_EXTTRACECMD_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_EXTTRACECMD_RESERVED_Msk = 0xfffffffc

	// PIOPORCAP0: POR captured PIO status 0
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Msk = 0xffffff
	// Position of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Msk = 0xff000000

	// PIOPORCAP1: POR captured PIO status 1
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP1_PIOSTAT_Msk = 0xffffffff

	// PIOPORCAP2: POR captured PIO status 1
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP2_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP2_PIOSTAT_Msk = 0xffffff

	// IOCONCLKDIV6: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV6_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV6_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV6_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV6_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV5: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV5_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV5_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV5_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV5_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV4: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV4_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV4_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV4_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV4_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV3: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV3_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV3_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV3_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV3_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV2: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV2_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV2_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV2_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV2_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV1: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV1_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV1_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV1_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV1_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV0: Peripheral clock to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV0_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV0_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV0_RESERVED_Msk = 0xffffff00

	// BODCTRL: Brown-Out Detect
	// Position of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Pos = 0x0
	// Bit mask of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Msk = 0x3
	// Level 0.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_0 = 0x0
	// Level 1.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_1 = 0x1
	// Level 2.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_2 = 0x2
	// Level 3.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_3 = 0x3
	// Position of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Pos = 0x2
	// Bit mask of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Msk = 0xc
	// Level 2.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_2 = 0x2
	// Level 3.
	SYSCON_BODCTRL_BODINTVAL_LEVEL_3 = 0x3
	// Position of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Pos = 0x4
	// Bit mask of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Msk = 0x10
	// Bit BODRSTENA.
	SYSCON_BODCTRL_BODRSTENA = 0x10
	// Disable reset function.
	SYSCON_BODCTRL_BODRSTENA_DISABLE_RESET_FUNCTI = 0x0
	// Enable reset function.
	SYSCON_BODCTRL_BODRSTENA_ENABLE_RESET_FUNCTIO = 0x1
	// Position of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Msk = 0xffffffe0

	// SYSTCKCAL: System tick counter calibration
	// Position of CAL field.
	SYSCON_SYSTCKCAL_CAL_Pos = 0x0
	// Bit mask of CAL field.
	SYSCON_SYSTCKCAL_CAL_Msk = 0x3ffffff
	// Position of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Msk = 0xfc000000

	// IRQLATENCY: IRQ delay. Allows trade-off between interrupt latency and determinism.
	// Position of LATENCY field.
	SYSCON_IRQLATENCY_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	SYSCON_IRQLATENCY_LATENCY_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IRQLATENCY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IRQLATENCY_RESERVED_Msk = 0xffffff00

	// NMISRC: NMI Source Control
	// Position of IRQN field.
	SYSCON_NMISRC_IRQN_Pos = 0x0
	// Bit mask of IRQN field.
	SYSCON_NMISRC_IRQN_Msk = 0x1f
	// Position of RESERVED field.
	SYSCON_NMISRC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_NMISRC_RESERVED_Msk = 0x7fffffe0
	// Position of NMIEN field.
	SYSCON_NMISRC_NMIEN_Pos = 0x1f
	// Bit mask of NMIEN field.
	SYSCON_NMISRC_NMIEN_Msk = 0x80000000
	// Bit NMIEN.
	SYSCON_NMISRC_NMIEN = 0x80000000

	// PINTSEL0: GPIO Pin Interrupt Select register 0
	// Position of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Pos = 0x0
	// Bit mask of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Msk = 0x3f
	// Position of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Msk = 0xffffffc0

	// STARTERP0: Start logic 0 interrupt wake-up enable register 0
	// Position of PINT0 field.
	SYSCON_STARTERP0_PINT0_Pos = 0x0
	// Bit mask of PINT0 field.
	SYSCON_STARTERP0_PINT0_Msk = 0x1
	// Bit PINT0.
	SYSCON_STARTERP0_PINT0 = 0x1
	// Disabled
	SYSCON_STARTERP0_PINT0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT0_ENABLED = 0x1
	// Position of PINT1 field.
	SYSCON_STARTERP0_PINT1_Pos = 0x1
	// Bit mask of PINT1 field.
	SYSCON_STARTERP0_PINT1_Msk = 0x2
	// Bit PINT1.
	SYSCON_STARTERP0_PINT1 = 0x2
	// Disabled
	SYSCON_STARTERP0_PINT1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT1_ENABLED = 0x1
	// Position of PINT2 field.
	SYSCON_STARTERP0_PINT2_Pos = 0x2
	// Bit mask of PINT2 field.
	SYSCON_STARTERP0_PINT2_Msk = 0x4
	// Bit PINT2.
	SYSCON_STARTERP0_PINT2 = 0x4
	// Disabled
	SYSCON_STARTERP0_PINT2_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT2_ENABLED = 0x1
	// Position of PINT3 field.
	SYSCON_STARTERP0_PINT3_Pos = 0x3
	// Bit mask of PINT3 field.
	SYSCON_STARTERP0_PINT3_Msk = 0x8
	// Bit PINT3.
	SYSCON_STARTERP0_PINT3 = 0x8
	// Disabled
	SYSCON_STARTERP0_PINT3_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT3_ENABLED = 0x1
	// Position of PINT4 field.
	SYSCON_STARTERP0_PINT4_Pos = 0x4
	// Bit mask of PINT4 field.
	SYSCON_STARTERP0_PINT4_Msk = 0x10
	// Bit PINT4.
	SYSCON_STARTERP0_PINT4 = 0x10
	// Disabled
	SYSCON_STARTERP0_PINT4_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT4_ENABLED = 0x1
	// Position of PINT5 field.
	SYSCON_STARTERP0_PINT5_Pos = 0x5
	// Bit mask of PINT5 field.
	SYSCON_STARTERP0_PINT5_Msk = 0x20
	// Bit PINT5.
	SYSCON_STARTERP0_PINT5 = 0x20
	// Disabled
	SYSCON_STARTERP0_PINT5_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT5_ENABLED = 0x1
	// Position of PINT6 field.
	SYSCON_STARTERP0_PINT6_Pos = 0x6
	// Bit mask of PINT6 field.
	SYSCON_STARTERP0_PINT6_Msk = 0x40
	// Bit PINT6.
	SYSCON_STARTERP0_PINT6 = 0x40
	// Disabled
	SYSCON_STARTERP0_PINT6_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT6_ENABLED = 0x1
	// Position of PINT7 field.
	SYSCON_STARTERP0_PINT7_Pos = 0x7
	// Bit mask of PINT7 field.
	SYSCON_STARTERP0_PINT7_Msk = 0x80
	// Bit PINT7.
	SYSCON_STARTERP0_PINT7 = 0x80
	// Disabled
	SYSCON_STARTERP0_PINT7_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT7_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0xffffff00

	// STARTERP1: Start logic 1 interrupt wake-up enable register 1
	// Position of RTCINT field.
	SYSCON_STARTERP1_RTCINT_Pos = 0xc
	// Bit mask of RTCINT field.
	SYSCON_STARTERP1_RTCINT_Msk = 0x1000
	// Bit RTCINT.
	SYSCON_STARTERP1_RTCINT = 0x1000
	// Disabled
	SYSCON_STARTERP1_RTCINT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_RTCINT_ENABLED = 0x1
	// Position of WWDT_BODINT field.
	SYSCON_STARTERP1_WWDT_BODINT_Pos = 0xd
	// Bit mask of WWDT_BODINT field.
	SYSCON_STARTERP1_WWDT_BODINT_Msk = 0x2000
	// Bit WWDT_BODINT.
	SYSCON_STARTERP1_WWDT_BODINT = 0x2000
	// Disabled
	SYSCON_STARTERP1_WWDT_BODINT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_WWDT_BODINT_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0x7c000
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0x80000
	// Bit RESERVED.
	SYSCON_STARTERP1_RESERVED = 0x80000
	// Position of GROUP0INT field.
	SYSCON_STARTERP1_GROUP0INT_Pos = 0x14
	// Bit mask of GROUP0INT field.
	SYSCON_STARTERP1_GROUP0INT_Msk = 0x100000
	// Bit GROUP0INT.
	SYSCON_STARTERP1_GROUP0INT = 0x100000
	// Disabled
	SYSCON_STARTERP1_GROUP0INT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_GROUP0INT_ENABLED = 0x1
	// Position of GROUP1INT field.
	SYSCON_STARTERP1_GROUP1INT_Pos = 0x15
	// Bit mask of GROUP1INT field.
	SYSCON_STARTERP1_GROUP1INT_Msk = 0x200000
	// Bit GROUP1INT.
	SYSCON_STARTERP1_GROUP1INT = 0x200000
	// Disabled
	SYSCON_STARTERP1_GROUP1INT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_GROUP1INT_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0x400000
	// Bit RESERVED.
	SYSCON_STARTERP1_RESERVED = 0x400000
	// Position of USART1_4 field.
	SYSCON_STARTERP1_USART1_4_Pos = 0x17
	// Bit mask of USART1_4 field.
	SYSCON_STARTERP1_USART1_4_Msk = 0x800000
	// Bit USART1_4.
	SYSCON_STARTERP1_USART1_4 = 0x800000
	// Disabled
	SYSCON_STARTERP1_USART1_4_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_USART1_4_ENABLED = 0x1
	// Position of USART2_3 field.
	SYSCON_STARTERP1_USART2_3_Pos = 0x18
	// Bit mask of USART2_3 field.
	SYSCON_STARTERP1_USART2_3_Msk = 0x1000000
	// Bit USART2_3.
	SYSCON_STARTERP1_USART2_3 = 0x1000000
	// Disabled
	SYSCON_STARTERP1_USART2_3_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_USART2_3_ENABLED = 0x1

	// PDSLEEPCFG: Power-down states in deep-sleep mode
	// Position of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDSLEEPCFG_BOD_PD = 0x8
	// Powered down
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED = 0x0
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0x30
	// Position of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDSLEEPCFG_WDTOSC_PD = 0x40
	// Powered down
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED = 0x0
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0xffffff80

	// PDAWAKECFG: Power-down states for wake-up from deep-sleep
	// Position of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDAWAKECFG_IRCOUT_PD = 0x1
	// Powered down
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED = 0x0
	// Position of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDAWAKECFG_IRC_PD = 0x2
	// Powered down
	SYSCON_PDAWAKECFG_IRC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_IRC_PD_POWERED = 0x0
	// Position of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDAWAKECFG_FLASH_PD = 0x4
	// Powered down
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED = 0x0
	// Position of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDAWAKECFG_BOD_PD = 0x8
	// Powered down
	SYSCON_PDAWAKECFG_BOD_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_BOD_PD_POWERED = 0x0
	// Position of ADC_PD field.
	SYSCON_PDAWAKECFG_ADC_PD_Pos = 0x4
	// Bit mask of ADC_PD field.
	SYSCON_PDAWAKECFG_ADC_PD_Msk = 0x10
	// Bit ADC_PD.
	SYSCON_PDAWAKECFG_ADC_PD = 0x10
	// Powered down
	SYSCON_PDAWAKECFG_ADC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_ADC_PD_POWERED = 0x0
	// Position of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDAWAKECFG_SYSOSC_PD = 0x20
	// Powered down
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED = 0x0
	// Position of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDAWAKECFG_WDTOSC_PD = 0x40
	// Powered down
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED = 0x0
	// Position of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDAWAKECFG_SYSPLL_PD = 0x80
	// Powered down
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Powered
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED = 0x0
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x100
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x200
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x400
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x800
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x800
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x1000
	// Position of TEMPSENSE_PD field.
	SYSCON_PDAWAKECFG_TEMPSENSE_PD_Pos = 0xd
	// Bit mask of TEMPSENSE_PD field.
	SYSCON_PDAWAKECFG_TEMPSENSE_PD_Msk = 0x2000
	// Bit TEMPSENSE_PD.
	SYSCON_PDAWAKECFG_TEMPSENSE_PD = 0x2000
	// Powered
	SYSCON_PDAWAKECFG_TEMPSENSE_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_TEMPSENSE_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0xffffc000

	// PDRUNCFG: Power configuration register
	// Position of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDRUNCFG_IRCOUT_PD = 0x1
	// Powered
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDRUNCFG_IRC_PD = 0x2
	// Powered
	SYSCON_PDRUNCFG_IRC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRC_PD_POWERED_DOWN = 0x1
	// Position of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDRUNCFG_FLASH_PD = 0x4
	// Powered
	SYSCON_PDRUNCFG_FLASH_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_FLASH_PD_POWERED_DOWN = 0x1
	// Position of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDRUNCFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDRUNCFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Pos = 0x4
	// Bit mask of ADC_PD field.
	SYSCON_PDRUNCFG_ADC_PD_Msk = 0x10
	// Bit ADC_PD.
	SYSCON_PDRUNCFG_ADC_PD = 0x10
	// Powered
	SYSCON_PDRUNCFG_ADC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ADC_PD_POWERED_DOWN = 0x1
	// Position of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDRUNCFG_SYSOSC_PD = 0x20
	// Powered
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDRUNCFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDRUNCFG_SYSPLL_PD = 0x80
	// Powered
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x100
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x200
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x400
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x800
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x800
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x1000
	// Position of TEMPSENSE_PD field.
	SYSCON_PDRUNCFG_TEMPSENSE_PD_Pos = 0xd
	// Bit mask of TEMPSENSE_PD field.
	SYSCON_PDRUNCFG_TEMPSENSE_PD_Msk = 0x2000
	// Bit TEMPSENSE_PD.
	SYSCON_PDRUNCFG_TEMPSENSE_PD = 0x2000
	// Powered
	SYSCON_PDRUNCFG_TEMPSENSE_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_TEMPSENSE_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xc000
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xffff0000

	// DEVICE_ID: Device ID
	// Position of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Msk = 0xffffffff
)

// Bitfields for USART4: USART4
const (
	// CFG: USART Configuration register. Basic USART configuration settings that typically are not changed during operation.
	// Position of ENABLE field.
	USART4_CFG_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	USART4_CFG_ENABLE_Msk = 0x1
	// Bit ENABLE.
	USART4_CFG_ENABLE = 0x1
	// Disabled. The USART is disabled and the internal state machine and counters are reset. While Enable = 0, all USART interrupts and DMA transfers are disabled. When Enable is set again, CFG and most other control bits remain unchanged. For instance, when re-enabled, the USART will immediately generate a TxRdy interrupt (if enabled in the INTENSET register) or a DMA transfer request because the transmitter has been reset and is therefore available.
	USART4_CFG_ENABLE_DISABLED = 0x0
	// Enabled. The USART is enabled for operation.
	USART4_CFG_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART4_CFG_RESERVED = 0x2
	// Position of DATALEN field.
	USART4_CFG_DATALEN_Pos = 0x2
	// Bit mask of DATALEN field.
	USART4_CFG_DATALEN_Msk = 0xc
	// 7 bit Data length.
	USART4_CFG_DATALEN_7_BIT_DATA_LENGTH = 0x0
	// 8 bit Data length.
	USART4_CFG_DATALEN_8_BIT_DATA_LENGTH = 0x1
	// 9 bit data length. The 9th bit is commonly used for addressing in multidrop mode. See the ADDRDET bit in the CTL register.
	USART4_CFG_DATALEN_9_BIT_DATA_LENGTH = 0x2
	// Position of PARITYSEL field.
	USART4_CFG_PARITYSEL_Pos = 0x4
	// Bit mask of PARITYSEL field.
	USART4_CFG_PARITYSEL_Msk = 0x30
	// No parity.
	USART4_CFG_PARITYSEL_NO_PARITY = 0x0
	// Even parity. Adds a bit to each character such that the number of 1s in a transmitted character is even, and the number of 1s in a received character is expected to be even.
	USART4_CFG_PARITYSEL_EVEN_PARITY = 0x2
	// Odd parity. Adds a bit to each character such that the number of 1s in a transmitted character is odd, and the number of 1s in a received character is expected to be odd.
	USART4_CFG_PARITYSEL_ODD_PARITY = 0x3
	// Position of STOPLEN field.
	USART4_CFG_STOPLEN_Pos = 0x6
	// Bit mask of STOPLEN field.
	USART4_CFG_STOPLEN_Msk = 0x40
	// Bit STOPLEN.
	USART4_CFG_STOPLEN = 0x40
	// 1 stop bit.
	USART4_CFG_STOPLEN_1_STOP_BIT = 0x0
	// 2 stop bits. This setting should only be used for asynchronous communication.
	USART4_CFG_STOPLEN_2_STOP_BITS = 0x1
	// Position of MODE32K field.
	USART4_CFG_MODE32K_Pos = 0x7
	// Bit mask of MODE32K field.
	USART4_CFG_MODE32K_Msk = 0x80
	// Bit MODE32K.
	USART4_CFG_MODE32K = 0x80
	// UART uses standard clocking.
	USART4_CFG_MODE32K_STANDARD = 0x0
	// UART uses the 32 kHz clock from the RTC oscillator as the clock source to the BRG, and uses a special bit clocking scheme.
	USART4_CFG_MODE32K_32KHZ = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	USART4_CFG_RESERVED = 0x100
	// Position of CTSEN field.
	USART4_CFG_CTSEN_Pos = 0x9
	// Bit mask of CTSEN field.
	USART4_CFG_CTSEN_Msk = 0x200
	// Bit CTSEN.
	USART4_CFG_CTSEN = 0x200
	// No flow control. The transmitter does not receive any automatic flow control signal.
	USART4_CFG_CTSEN_NO_FLOW_CONTROL = 0x0
	// Flow control enabled. The transmitter uses the CTS input (or RTS output in loopback mode) for flow control purposes.
	USART4_CFG_CTSEN_FLOW_CONTROL_ENABLED = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USART4_CFG_RESERVED = 0x400
	// Position of SYNCEN field.
	USART4_CFG_SYNCEN_Pos = 0xb
	// Bit mask of SYNCEN field.
	USART4_CFG_SYNCEN_Msk = 0x800
	// Bit SYNCEN.
	USART4_CFG_SYNCEN = 0x800
	// Asynchronous mode is selected.
	USART4_CFG_SYNCEN_ASYNCHRONOUS = 0x0
	// Synchronous mode is selected.
	USART4_CFG_SYNCEN_SYNCHRONOUS = 0x1
	// Position of CLKPOL field.
	USART4_CFG_CLKPOL_Pos = 0xc
	// Bit mask of CLKPOL field.
	USART4_CFG_CLKPOL_Msk = 0x1000
	// Bit CLKPOL.
	USART4_CFG_CLKPOL = 0x1000
	// Falling edge. Un_RXD is sampled on the falling edge of SCLK.
	USART4_CFG_CLKPOL_FALLING_EDGE = 0x0
	// Rising edge. Un_RXD is sampled on the rising edge of SCLK.
	USART4_CFG_CLKPOL_RISING_EDGE = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USART4_CFG_RESERVED = 0x2000
	// Position of SYNCMST field.
	USART4_CFG_SYNCMST_Pos = 0xe
	// Bit mask of SYNCMST field.
	USART4_CFG_SYNCMST_Msk = 0x4000
	// Bit SYNCMST.
	USART4_CFG_SYNCMST = 0x4000
	// Slave. When synchronous mode is enabled, the USART is a slave.
	USART4_CFG_SYNCMST_SLAVE = 0x0
	// Master. When synchronous mode is enabled, the USART is a master.
	USART4_CFG_SYNCMST_MASTER = 0x1
	// Position of LOOP field.
	USART4_CFG_LOOP_Pos = 0xf
	// Bit mask of LOOP field.
	USART4_CFG_LOOP_Msk = 0x8000
	// Bit LOOP.
	USART4_CFG_LOOP = 0x8000
	// Normal operation.
	USART4_CFG_LOOP_NORMAL_OPERATION = 0x0
	// Loopback mode. This provides a mechanism to perform diagnostic loopback testing for USART data. Serial data from the transmitter (Un_TXD) is connected internally to serial input of the receive (Un_RXD). Un_TXD and Un_RTS activity will also appear on external pins if these functions are configured to appear on device pins. The receiver RTS signal is also looped back to CTS and performs flow control if enabled by CTSEN.
	USART4_CFG_LOOP_LOOPBACK_MODE = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0x30000
	// Position of OETA field.
	USART4_CFG_OETA_Pos = 0x12
	// Bit mask of OETA field.
	USART4_CFG_OETA_Msk = 0x40000
	// Bit OETA.
	USART4_CFG_OETA = 0x40000
	// Deasserted. If selected by OESEL, the Output Enable signal deasserted at the end of the last stop bit of a transmission.
	USART4_CFG_OETA_DEASSERTED = 0x0
	// Asserted. If selected by OESEL, the Output Enable signal remains asserted for 1 character time after then end the last stop bit of a transmission. OE will also remain asserted if another transmit begins before it is deasserted.
	USART4_CFG_OETA_ASSERTED = 0x1
	// Position of AUTOADDR field.
	USART4_CFG_AUTOADDR_Pos = 0x13
	// Bit mask of AUTOADDR field.
	USART4_CFG_AUTOADDR_Msk = 0x80000
	// Bit AUTOADDR.
	USART4_CFG_AUTOADDR = 0x80000
	// Disabled. When addressing is enabled by ADDRDET, address matching is done by software. This provides the possibility of versatile addressing (e.g. respond to more than one address).
	USART4_CFG_AUTOADDR_DISABLED = 0x0
	// Enabled. When addressing is enabled by ADDRDET, address matching is done by hardware, using the value in the ADDR register as the address to match.
	USART4_CFG_AUTOADDR_ENABLED = 0x1
	// Position of OESEL field.
	USART4_CFG_OESEL_Pos = 0x14
	// Bit mask of OESEL field.
	USART4_CFG_OESEL_Msk = 0x100000
	// Bit OESEL.
	USART4_CFG_OESEL = 0x100000
	// Flow control. The RTS signal is used as the standard flow control function.
	USART4_CFG_OESEL_FLOW_CONTROL = 0x0
	// Output enable. The RTS signal is taken over in order to provide an output enable signal to control an RS-485 transceiver.
	USART4_CFG_OESEL_OUTPUT_ENABLE = 0x1
	// Position of OEPOL field.
	USART4_CFG_OEPOL_Pos = 0x15
	// Bit mask of OEPOL field.
	USART4_CFG_OEPOL_Msk = 0x200000
	// Bit OEPOL.
	USART4_CFG_OEPOL = 0x200000
	// Low. If selected by OESEL, the output enable is active low.
	USART4_CFG_OEPOL_LOW = 0x0
	// High. If selected by OESEL, the output enable is active high.
	USART4_CFG_OEPOL_HIGH = 0x1
	// Position of RXPOL field.
	USART4_CFG_RXPOL_Pos = 0x16
	// Bit mask of RXPOL field.
	USART4_CFG_RXPOL_Msk = 0x400000
	// Bit RXPOL.
	USART4_CFG_RXPOL = 0x400000
	// Not changed. The RX signal is used as it arrives from the pin. This means that the RX rest value is 1, start bit is 0, data is not inverted, and the stop bit is 1.
	USART4_CFG_RXPOL_NOT_CHANGED = 0x0
	// Inverted. The RX signal is inverted before being used by the UART. This means that the RX rest value is 0, start bit is 1, data is inverted, and the stop bit is 0.
	USART4_CFG_RXPOL_INVERTED = 0x1
	// Position of TXPOL field.
	USART4_CFG_TXPOL_Pos = 0x17
	// Bit mask of TXPOL field.
	USART4_CFG_TXPOL_Msk = 0x800000
	// Bit TXPOL.
	USART4_CFG_TXPOL = 0x800000
	// Not changed. The TX signal is sent out without change. This means that the TX rest value is 1, start bit is 0, data is not inverted, and the stop bit is 1.
	USART4_CFG_TXPOL_NOT_CHANGED = 0x0
	// Inverted. The TX signal is inverted by the UART before being sent out. This means that the TX rest value is 0, start bit is 1, data is inverted, and the stop bit is 0.
	USART4_CFG_TXPOL_INVERTED = 0x1
	// Position of RESERVED field.
	USART4_CFG_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USART4_CFG_RESERVED_Msk = 0xff000000

	// CTL: USART Control register. USART control settings that are more likely to change during operation.
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART4_CTL_RESERVED = 0x1
	// Position of TXBRKEN field.
	USART4_CTL_TXBRKEN_Pos = 0x1
	// Bit mask of TXBRKEN field.
	USART4_CTL_TXBRKEN_Msk = 0x2
	// Bit TXBRKEN.
	USART4_CTL_TXBRKEN = 0x2
	// Normal operation.
	USART4_CTL_TXBRKEN_NORMAL_OPERATION = 0x0
	// Continuous break is sent immediately when this bit is set, and remains until this bit is cleared. A break may be sent without danger of corrupting any currently transmitting character if the transmitter is first disabled (TXDIS in CTL is set) and then waiting for the transmitter to be disabled (TXDISINT in STAT = 1) before writing 1 to TXBRKEN.
	USART4_CTL_TXBRKEN_CONTINUOUS_BREAK_IS = 0x1
	// Position of ADDRDET field.
	USART4_CTL_ADDRDET_Pos = 0x2
	// Bit mask of ADDRDET field.
	USART4_CTL_ADDRDET_Msk = 0x4
	// Bit ADDRDET.
	USART4_CTL_ADDRDET = 0x4
	// Disabled. The USART presents all incoming data.
	USART4_CTL_ADDRDET_DISABLED = 0x0
	// Enabled. The USART receiver ignores incoming data that does not have the most significant bit of the data (typically the 9th bit) = 1. When the data MSB bit = 1, the receiver treats the incoming data normally, generating a received data interrupt. Software can then check the data to see if this is an address that should be handled. If it is, the ADDRDET bit is cleared by software and further incoming data is handled normally.
	USART4_CTL_ADDRDET_ENABLED = 0x1
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0x38
	// Position of TXDIS field.
	USART4_CTL_TXDIS_Pos = 0x6
	// Bit mask of TXDIS field.
	USART4_CTL_TXDIS_Msk = 0x40
	// Bit TXDIS.
	USART4_CTL_TXDIS = 0x40
	// Not disabled. USART transmitter is not disabled.
	USART4_CTL_TXDIS_NOT_DISABLED = 0x0
	// Disabled. USART transmitter is disabled after any character currently being transmitted is complete. This feature can be used to facilitate software flow control.
	USART4_CTL_TXDIS_DISABLED = 0x1
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_CTL_RESERVED = 0x80
	// Position of CC field.
	USART4_CTL_CC_Pos = 0x8
	// Bit mask of CC field.
	USART4_CTL_CC_Msk = 0x100
	// Bit CC.
	USART4_CTL_CC = 0x100
	// Clock on character. In synchronous mode, SCLK cycles only when characters are being sent on Un_TXD or to complete a character that is being received.
	USART4_CTL_CC_CLOCK_ON_CHARACTER = 0x0
	// Continuous clock. SCLK runs continuously in synchronous mode, allowing characters to be received on Un_RxD independently from transmission on Un_TXD).
	USART4_CTL_CC_CONTINUOUS_CLOCK = 0x1
	// Position of CLRCCONRX field.
	USART4_CTL_CLRCCONRX_Pos = 0x9
	// Bit mask of CLRCCONRX field.
	USART4_CTL_CLRCCONRX_Msk = 0x200
	// Bit CLRCCONRX.
	USART4_CTL_CLRCCONRX = 0x200
	// No effect on the CC bit.
	USART4_CTL_CLRCCONRX_NO_EFFECT = 0x0
	// Auto-clear. The CC bit is automatically cleared when a complete character has been received. This bit is cleared at the same time.
	USART4_CTL_CLRCCONRX_AUTO_CLEAR = 0x1
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0xfc00
	// Position of AUTOBAUD field.
	USART4_CTL_AUTOBAUD_Pos = 0x10
	// Bit mask of AUTOBAUD field.
	USART4_CTL_AUTOBAUD_Msk = 0x10000
	// Bit AUTOBAUD.
	USART4_CTL_AUTOBAUD = 0x10000
	// Disabled. UART is in normal operating mode.
	USART4_CTL_AUTOBAUD_DISABLED = 0x0
	// Enabled. UART is in autobaud mode. This bit should only be set when the UART receiver is idle. The first start bit of RX is measured and used the update the BRG register to match the received data rate. AUTOBAUD is cleared once this process is complete, or if there is an AERR. This bit can be cleared by software when set, but only when the UART receiver is idle.
	USART4_CTL_AUTOBAUD_ENABLED = 0x1
	// Position of RESERVED field.
	USART4_CTL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_CTL_RESERVED_Msk = 0xfffe0000

	// STAT: USART Status register. The complete status value can be read here. Writing ones clears some bits in the register. Some bits can be cleared by writing a 1 to them.
	// Position of RXRDY field.
	USART4_STAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART4_STAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART4_STAT_RXRDY = 0x1
	// Position of RXIDLE field.
	USART4_STAT_RXIDLE_Pos = 0x1
	// Bit mask of RXIDLE field.
	USART4_STAT_RXIDLE_Msk = 0x2
	// Bit RXIDLE.
	USART4_STAT_RXIDLE = 0x2
	// Position of TXRDY field.
	USART4_STAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART4_STAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART4_STAT_TXRDY = 0x4
	// Position of TXIDLE field.
	USART4_STAT_TXIDLE_Pos = 0x3
	// Bit mask of TXIDLE field.
	USART4_STAT_TXIDLE_Msk = 0x8
	// Bit TXIDLE.
	USART4_STAT_TXIDLE = 0x8
	// Position of CTS field.
	USART4_STAT_CTS_Pos = 0x4
	// Bit mask of CTS field.
	USART4_STAT_CTS_Msk = 0x10
	// Bit CTS.
	USART4_STAT_CTS = 0x10
	// Position of DELTACTS field.
	USART4_STAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART4_STAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART4_STAT_DELTACTS = 0x20
	// Position of TXDISSTAT field.
	USART4_STAT_TXDISSTAT_Pos = 0x6
	// Bit mask of TXDISSTAT field.
	USART4_STAT_TXDISSTAT_Msk = 0x40
	// Bit TXDISSTAT.
	USART4_STAT_TXDISSTAT = 0x40
	// Position of RESERVED field.
	USART4_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_STAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_STAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART4_STAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART4_STAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART4_STAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART4_STAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_STAT_RESERVED_Msk = 0x200
	// Bit RESERVED.
	USART4_STAT_RESERVED = 0x200
	// Position of RXBRK field.
	USART4_STAT_RXBRK_Pos = 0xa
	// Bit mask of RXBRK field.
	USART4_STAT_RXBRK_Msk = 0x400
	// Bit RXBRK.
	USART4_STAT_RXBRK = 0x400
	// Position of DELTARXBRK field.
	USART4_STAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART4_STAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART4_STAT_DELTARXBRK = 0x800
	// Position of START field.
	USART4_STAT_START_Pos = 0xc
	// Bit mask of START field.
	USART4_STAT_START_Msk = 0x1000
	// Bit START.
	USART4_STAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART4_STAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART4_STAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART4_STAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART4_STAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART4_STAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART4_STAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART4_STAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART4_STAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART4_STAT_RXNOISEINT = 0x8000
	// Position of ABERR field.
	USART4_STAT_ABERR_Pos = 0x10
	// Bit mask of ABERR field.
	USART4_STAT_ABERR_Msk = 0x10000
	// Bit ABERR.
	USART4_STAT_ABERR = 0x10000
	// Position of RESERVED field.
	USART4_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_STAT_RESERVED_Msk = 0xfffe0000

	// INTENSET: Interrupt Enable read and Set register. Contains an individual interrupt enable bit for each potential USART interrupt. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXRDYEN field.
	USART4_INTENSET_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	USART4_INTENSET_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	USART4_INTENSET_RXRDYEN = 0x1
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART4_INTENSET_RESERVED = 0x2
	// Position of TXRDYEN field.
	USART4_INTENSET_TXRDYEN_Pos = 0x2
	// Bit mask of TXRDYEN field.
	USART4_INTENSET_TXRDYEN_Msk = 0x4
	// Bit TXRDYEN.
	USART4_INTENSET_TXRDYEN = 0x4
	// Position of TXIDLEEN field.
	USART4_INTENSET_TXIDLEEN_Pos = 0x3
	// Bit mask of TXIDLEEN field.
	USART4_INTENSET_TXIDLEEN_Msk = 0x8
	// Bit TXIDLEEN.
	USART4_INTENSET_TXIDLEEN = 0x8
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART4_INTENSET_RESERVED = 0x10
	// Position of DELTACTSEN field.
	USART4_INTENSET_DELTACTSEN_Pos = 0x5
	// Bit mask of DELTACTSEN field.
	USART4_INTENSET_DELTACTSEN_Msk = 0x20
	// Bit DELTACTSEN.
	USART4_INTENSET_DELTACTSEN = 0x20
	// Position of TXDISEN field.
	USART4_INTENSET_TXDISEN_Pos = 0x6
	// Bit mask of TXDISEN field.
	USART4_INTENSET_TXDISEN_Msk = 0x40
	// Bit TXDISEN.
	USART4_INTENSET_TXDISEN = 0x40
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_INTENSET_RESERVED = 0x80
	// Position of OVERRUNEN field.
	USART4_INTENSET_OVERRUNEN_Pos = 0x8
	// Bit mask of OVERRUNEN field.
	USART4_INTENSET_OVERRUNEN_Msk = 0x100
	// Bit OVERRUNEN.
	USART4_INTENSET_OVERRUNEN = 0x100
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0x600
	// Position of DELTARXBRKEN field.
	USART4_INTENSET_DELTARXBRKEN_Pos = 0xb
	// Bit mask of DELTARXBRKEN field.
	USART4_INTENSET_DELTARXBRKEN_Msk = 0x800
	// Bit DELTARXBRKEN.
	USART4_INTENSET_DELTARXBRKEN = 0x800
	// Position of STARTEN field.
	USART4_INTENSET_STARTEN_Pos = 0xc
	// Bit mask of STARTEN field.
	USART4_INTENSET_STARTEN_Msk = 0x1000
	// Bit STARTEN.
	USART4_INTENSET_STARTEN = 0x1000
	// Position of FRAMERREN field.
	USART4_INTENSET_FRAMERREN_Pos = 0xd
	// Bit mask of FRAMERREN field.
	USART4_INTENSET_FRAMERREN_Msk = 0x2000
	// Bit FRAMERREN.
	USART4_INTENSET_FRAMERREN = 0x2000
	// Position of PARITYERREN field.
	USART4_INTENSET_PARITYERREN_Pos = 0xe
	// Bit mask of PARITYERREN field.
	USART4_INTENSET_PARITYERREN_Msk = 0x4000
	// Bit PARITYERREN.
	USART4_INTENSET_PARITYERREN = 0x4000
	// Position of RXNOISEEN field.
	USART4_INTENSET_RXNOISEEN_Pos = 0xf
	// Bit mask of RXNOISEEN field.
	USART4_INTENSET_RXNOISEEN_Msk = 0x8000
	// Bit RXNOISEEN.
	USART4_INTENSET_RXNOISEEN = 0x8000
	// Position of ABERREN field.
	USART4_INTENSET_ABERREN_Pos = 0x10
	// Bit mask of ABERREN field.
	USART4_INTENSET_ABERREN_Msk = 0x10000
	// Bit ABERREN.
	USART4_INTENSET_ABERREN = 0x10000
	// Position of RESERVED field.
	USART4_INTENSET_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_INTENSET_RESERVED_Msk = 0xfffe0000

	// INTENCLR: Interrupt Enable Clear register. Allows clearing any combination of bits in the INTENSET register. Writing a 1 to any implemented bit position causes the corresponding bit to be cleared.
	// Position of RXRDYCLR field.
	USART4_INTENCLR_RXRDYCLR_Pos = 0x0
	// Bit mask of RXRDYCLR field.
	USART4_INTENCLR_RXRDYCLR_Msk = 0x1
	// Bit RXRDYCLR.
	USART4_INTENCLR_RXRDYCLR = 0x1
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART4_INTENCLR_RESERVED = 0x2
	// Position of TXRDYCLR field.
	USART4_INTENCLR_TXRDYCLR_Pos = 0x2
	// Bit mask of TXRDYCLR field.
	USART4_INTENCLR_TXRDYCLR_Msk = 0x4
	// Bit TXRDYCLR.
	USART4_INTENCLR_TXRDYCLR = 0x4
	// Position of TXIDLECLR field.
	USART4_INTENCLR_TXIDLECLR_Pos = 0x3
	// Bit mask of TXIDLECLR field.
	USART4_INTENCLR_TXIDLECLR_Msk = 0x8
	// Bit TXIDLECLR.
	USART4_INTENCLR_TXIDLECLR = 0x8
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART4_INTENCLR_RESERVED = 0x10
	// Position of DELTACTSCLR field.
	USART4_INTENCLR_DELTACTSCLR_Pos = 0x5
	// Bit mask of DELTACTSCLR field.
	USART4_INTENCLR_DELTACTSCLR_Msk = 0x20
	// Bit DELTACTSCLR.
	USART4_INTENCLR_DELTACTSCLR = 0x20
	// Position of TXDISINTCLR field.
	USART4_INTENCLR_TXDISINTCLR_Pos = 0x6
	// Bit mask of TXDISINTCLR field.
	USART4_INTENCLR_TXDISINTCLR_Msk = 0x40
	// Bit TXDISINTCLR.
	USART4_INTENCLR_TXDISINTCLR = 0x40
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_INTENCLR_RESERVED = 0x80
	// Position of OVERRUNCLR field.
	USART4_INTENCLR_OVERRUNCLR_Pos = 0x8
	// Bit mask of OVERRUNCLR field.
	USART4_INTENCLR_OVERRUNCLR_Msk = 0x100
	// Bit OVERRUNCLR.
	USART4_INTENCLR_OVERRUNCLR = 0x100
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0x600
	// Position of DELTARXBRKCLR field.
	USART4_INTENCLR_DELTARXBRKCLR_Pos = 0xb
	// Bit mask of DELTARXBRKCLR field.
	USART4_INTENCLR_DELTARXBRKCLR_Msk = 0x800
	// Bit DELTARXBRKCLR.
	USART4_INTENCLR_DELTARXBRKCLR = 0x800
	// Position of STARTCLR field.
	USART4_INTENCLR_STARTCLR_Pos = 0xc
	// Bit mask of STARTCLR field.
	USART4_INTENCLR_STARTCLR_Msk = 0x1000
	// Bit STARTCLR.
	USART4_INTENCLR_STARTCLR = 0x1000
	// Position of FRAMERRCLR field.
	USART4_INTENCLR_FRAMERRCLR_Pos = 0xd
	// Bit mask of FRAMERRCLR field.
	USART4_INTENCLR_FRAMERRCLR_Msk = 0x2000
	// Bit FRAMERRCLR.
	USART4_INTENCLR_FRAMERRCLR = 0x2000
	// Position of PARITYERRCLR field.
	USART4_INTENCLR_PARITYERRCLR_Pos = 0xe
	// Bit mask of PARITYERRCLR field.
	USART4_INTENCLR_PARITYERRCLR_Msk = 0x4000
	// Bit PARITYERRCLR.
	USART4_INTENCLR_PARITYERRCLR = 0x4000
	// Position of RXNOISECLR field.
	USART4_INTENCLR_RXNOISECLR_Pos = 0xf
	// Bit mask of RXNOISECLR field.
	USART4_INTENCLR_RXNOISECLR_Msk = 0x8000
	// Bit RXNOISECLR.
	USART4_INTENCLR_RXNOISECLR = 0x8000
	// Position of ABERRCLR field.
	USART4_INTENCLR_ABERRCLR_Pos = 0x10
	// Bit mask of ABERRCLR field.
	USART4_INTENCLR_ABERRCLR_Msk = 0x10000
	// Bit ABERRCLR.
	USART4_INTENCLR_ABERRCLR = 0x10000
	// Position of RESERVED field.
	USART4_INTENCLR_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_INTENCLR_RESERVED_Msk = 0xfffe0000

	// RXDAT: Receiver Data register. Contains the last character received.
	// Position of RXDAT field.
	USART4_RXDAT_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	USART4_RXDAT_RXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	USART4_RXDAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_RXDAT_RESERVED_Msk = 0xfffffe00

	// RXDATSTAT: Receiver Data with Status register. Combines the last character received with the current USART receive status. Allows DMA or software to recover incoming data and status together.
	// Position of RXDAT field.
	USART4_RXDATSTAT_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	USART4_RXDATSTAT_RXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	USART4_RXDATSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_RXDATSTAT_RESERVED_Msk = 0x1e00
	// Position of FRAMERR field.
	USART4_RXDATSTAT_FRAMERR_Pos = 0xd
	// Bit mask of FRAMERR field.
	USART4_RXDATSTAT_FRAMERR_Msk = 0x2000
	// Bit FRAMERR.
	USART4_RXDATSTAT_FRAMERR = 0x2000
	// Position of PARITYERR field.
	USART4_RXDATSTAT_PARITYERR_Pos = 0xe
	// Bit mask of PARITYERR field.
	USART4_RXDATSTAT_PARITYERR_Msk = 0x4000
	// Bit PARITYERR.
	USART4_RXDATSTAT_PARITYERR = 0x4000
	// Position of RXNOISE field.
	USART4_RXDATSTAT_RXNOISE_Pos = 0xf
	// Bit mask of RXNOISE field.
	USART4_RXDATSTAT_RXNOISE_Msk = 0x8000
	// Bit RXNOISE.
	USART4_RXDATSTAT_RXNOISE = 0x8000
	// Position of RESERVED field.
	USART4_RXDATSTAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART4_RXDATSTAT_RESERVED_Msk = 0xffff0000

	// TXDAT: Transmit Data register. Data to be transmitted is written here.
	// Position of TXDAT field.
	USART4_TXDAT_TXDAT_Pos = 0x0
	// Bit mask of TXDAT field.
	USART4_TXDAT_TXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	USART4_TXDAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_TXDAT_RESERVED_Msk = 0xfffffe00

	// BRG: Baud Rate Generator register. 16-bit integer baud rate divisor value.
	// Position of BRGVAL field.
	USART4_BRG_BRGVAL_Pos = 0x0
	// Bit mask of BRGVAL field.
	USART4_BRG_BRGVAL_Msk = 0xffff
	// Position of RESERVED field.
	USART4_BRG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART4_BRG_RESERVED_Msk = 0xffff0000

	// INTSTAT: Interrupt status register. Reflects interrupts that are currently enabled.
	// Position of RXRDY field.
	USART4_INTSTAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART4_INTSTAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART4_INTSTAT_RXRDY = 0x1
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART4_INTSTAT_RESERVED = 0x2
	// Position of TXRDY field.
	USART4_INTSTAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART4_INTSTAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART4_INTSTAT_TXRDY = 0x4
	// Position of TXIDLE field.
	USART4_INTSTAT_TXIDLE_Pos = 0x3
	// Bit mask of TXIDLE field.
	USART4_INTSTAT_TXIDLE_Msk = 0x8
	// Bit TXIDLE.
	USART4_INTSTAT_TXIDLE = 0x8
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART4_INTSTAT_RESERVED = 0x10
	// Position of DELTACTS field.
	USART4_INTSTAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART4_INTSTAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART4_INTSTAT_DELTACTS = 0x20
	// Position of TXDISINT field.
	USART4_INTSTAT_TXDISINT_Pos = 0x6
	// Bit mask of TXDISINT field.
	USART4_INTSTAT_TXDISINT_Msk = 0x40
	// Bit TXDISINT.
	USART4_INTSTAT_TXDISINT = 0x40
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART4_INTSTAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART4_INTSTAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART4_INTSTAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART4_INTSTAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0x600
	// Position of DELTARXBRK field.
	USART4_INTSTAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART4_INTSTAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART4_INTSTAT_DELTARXBRK = 0x800
	// Position of START field.
	USART4_INTSTAT_START_Pos = 0xc
	// Bit mask of START field.
	USART4_INTSTAT_START_Msk = 0x1000
	// Bit START.
	USART4_INTSTAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART4_INTSTAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART4_INTSTAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART4_INTSTAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART4_INTSTAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART4_INTSTAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART4_INTSTAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART4_INTSTAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART4_INTSTAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART4_INTSTAT_RXNOISEINT = 0x8000
	// Position of ABERR field.
	USART4_INTSTAT_ABERR_Pos = 0x10
	// Bit mask of ABERR field.
	USART4_INTSTAT_ABERR_Msk = 0x10000
	// Bit ABERR.
	USART4_INTSTAT_ABERR = 0x10000
	// Position of RESERVED field.
	USART4_INTSTAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART4_INTSTAT_RESERVED_Msk = 0xfffe0000

	// OSR: Oversample selection register for asynchronous communication.
	// Position of OSRVAL field.
	USART4_OSR_OSRVAL_Pos = 0x0
	// Bit mask of OSRVAL field.
	USART4_OSR_OSRVAL_Msk = 0xf
	// Position of RESERVED field.
	USART4_OSR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART4_OSR_RESERVED_Msk = 0xfffffff0

	// ADDR: Address register for automatic address matching.
	// Position of ADDRESS field.
	USART4_ADDR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USART4_ADDR_ADDRESS_Msk = 0xff
	// Position of RESERVED field.
	USART4_ADDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART4_ADDR_RESERVED_Msk = 0xffffff00
)

// Bitfields for GINT0: GPIO group interrupt 0
const (
	// CTRL: GPIO grouped interrupt control register
	// Position of INT field.
	GINT0_CTRL_INT_Pos = 0x0
	// Bit mask of INT field.
	GINT0_CTRL_INT_Msk = 0x1
	// Bit INT.
	GINT0_CTRL_INT = 0x1
	// No interrupt request is pending.
	GINT0_CTRL_INT_NO_INTERRUPT_REQUEST = 0x0
	// Interrupt request is active.
	GINT0_CTRL_INT_INTERRUPT_REQUEST_IS = 0x1
	// Position of COMB field.
	GINT0_CTRL_COMB_Pos = 0x1
	// Bit mask of COMB field.
	GINT0_CTRL_COMB_Msk = 0x2
	// Bit COMB.
	GINT0_CTRL_COMB = 0x2
	// OR functionality: A grouped interrupt is generated when any one of the enabled inputs is active (based on its programmed polarity).
	GINT0_CTRL_COMB_OR_FUNCTIONALITY_A_ = 0x0
	// AND functionality: An interrupt is generated when all enabled bits are active (based on their programmed polarity).
	GINT0_CTRL_COMB_AND_FUNCTIONALITY_A = 0x1
	// Position of TRIG field.
	GINT0_CTRL_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	GINT0_CTRL_TRIG_Msk = 0x4
	// Bit TRIG.
	GINT0_CTRL_TRIG = 0x4
	// Edge-triggered
	GINT0_CTRL_TRIG_EDGE_TRIGGERED = 0x0
	// Level-triggered
	GINT0_CTRL_TRIG_LEVEL_TRIGGERED = 0x1
	// Position of RESERVED field.
	GINT0_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	GINT0_CTRL_RESERVED_Msk = 0xfffffff8

	// PORT_POL: GPIO grouped interrupt port 0 polarity register
	// Position of POL0 field.
	GINT0_PORT_POL_POL0_Pos = 0x0
	// Bit mask of POL0 field.
	GINT0_PORT_POL_POL0_Msk = 0x1
	// Bit POL0.
	GINT0_PORT_POL_POL0 = 0x1
	// Position of POL1 field.
	GINT0_PORT_POL_POL1_Pos = 0x1
	// Bit mask of POL1 field.
	GINT0_PORT_POL_POL1_Msk = 0x2
	// Bit POL1.
	GINT0_PORT_POL_POL1 = 0x2
	// Position of POL2 field.
	GINT0_PORT_POL_POL2_Pos = 0x2
	// Bit mask of POL2 field.
	GINT0_PORT_POL_POL2_Msk = 0x4
	// Bit POL2.
	GINT0_PORT_POL_POL2 = 0x4
	// Position of POL3 field.
	GINT0_PORT_POL_POL3_Pos = 0x3
	// Bit mask of POL3 field.
	GINT0_PORT_POL_POL3_Msk = 0x8
	// Bit POL3.
	GINT0_PORT_POL_POL3 = 0x8
	// Position of POL4 field.
	GINT0_PORT_POL_POL4_Pos = 0x4
	// Bit mask of POL4 field.
	GINT0_PORT_POL_POL4_Msk = 0x10
	// Bit POL4.
	GINT0_PORT_POL_POL4 = 0x10
	// Position of POL5 field.
	GINT0_PORT_POL_POL5_Pos = 0x5
	// Bit mask of POL5 field.
	GINT0_PORT_POL_POL5_Msk = 0x20
	// Bit POL5.
	GINT0_PORT_POL_POL5 = 0x20
	// Position of POL6 field.
	GINT0_PORT_POL_POL6_Pos = 0x6
	// Bit mask of POL6 field.
	GINT0_PORT_POL_POL6_Msk = 0x40
	// Bit POL6.
	GINT0_PORT_POL_POL6 = 0x40
	// Position of POL7 field.
	GINT0_PORT_POL_POL7_Pos = 0x7
	// Bit mask of POL7 field.
	GINT0_PORT_POL_POL7_Msk = 0x80
	// Bit POL7.
	GINT0_PORT_POL_POL7 = 0x80
	// Position of POL8 field.
	GINT0_PORT_POL_POL8_Pos = 0x8
	// Bit mask of POL8 field.
	GINT0_PORT_POL_POL8_Msk = 0x100
	// Bit POL8.
	GINT0_PORT_POL_POL8 = 0x100
	// Position of POL9 field.
	GINT0_PORT_POL_POL9_Pos = 0x9
	// Bit mask of POL9 field.
	GINT0_PORT_POL_POL9_Msk = 0x200
	// Bit POL9.
	GINT0_PORT_POL_POL9 = 0x200
	// Position of POL10 field.
	GINT0_PORT_POL_POL10_Pos = 0xa
	// Bit mask of POL10 field.
	GINT0_PORT_POL_POL10_Msk = 0x400
	// Bit POL10.
	GINT0_PORT_POL_POL10 = 0x400
	// Position of POL11 field.
	GINT0_PORT_POL_POL11_Pos = 0xb
	// Bit mask of POL11 field.
	GINT0_PORT_POL_POL11_Msk = 0x800
	// Bit POL11.
	GINT0_PORT_POL_POL11 = 0x800
	// Position of POL12 field.
	GINT0_PORT_POL_POL12_Pos = 0xc
	// Bit mask of POL12 field.
	GINT0_PORT_POL_POL12_Msk = 0x1000
	// Bit POL12.
	GINT0_PORT_POL_POL12 = 0x1000
	// Position of POL13 field.
	GINT0_PORT_POL_POL13_Pos = 0xd
	// Bit mask of POL13 field.
	GINT0_PORT_POL_POL13_Msk = 0x2000
	// Bit POL13.
	GINT0_PORT_POL_POL13 = 0x2000
	// Position of POL14 field.
	GINT0_PORT_POL_POL14_Pos = 0xe
	// Bit mask of POL14 field.
	GINT0_PORT_POL_POL14_Msk = 0x4000
	// Bit POL14.
	GINT0_PORT_POL_POL14 = 0x4000
	// Position of POL15 field.
	GINT0_PORT_POL_POL15_Pos = 0xf
	// Bit mask of POL15 field.
	GINT0_PORT_POL_POL15_Msk = 0x8000
	// Bit POL15.
	GINT0_PORT_POL_POL15 = 0x8000
	// Position of POL16 field.
	GINT0_PORT_POL_POL16_Pos = 0x10
	// Bit mask of POL16 field.
	GINT0_PORT_POL_POL16_Msk = 0x10000
	// Bit POL16.
	GINT0_PORT_POL_POL16 = 0x10000
	// Position of POL17 field.
	GINT0_PORT_POL_POL17_Pos = 0x11
	// Bit mask of POL17 field.
	GINT0_PORT_POL_POL17_Msk = 0x20000
	// Bit POL17.
	GINT0_PORT_POL_POL17 = 0x20000
	// Position of POL18 field.
	GINT0_PORT_POL_POL18_Pos = 0x12
	// Bit mask of POL18 field.
	GINT0_PORT_POL_POL18_Msk = 0x40000
	// Bit POL18.
	GINT0_PORT_POL_POL18 = 0x40000
	// Position of POL19 field.
	GINT0_PORT_POL_POL19_Pos = 0x13
	// Bit mask of POL19 field.
	GINT0_PORT_POL_POL19_Msk = 0x80000
	// Bit POL19.
	GINT0_PORT_POL_POL19 = 0x80000
	// Position of POL20 field.
	GINT0_PORT_POL_POL20_Pos = 0x14
	// Bit mask of POL20 field.
	GINT0_PORT_POL_POL20_Msk = 0x100000
	// Bit POL20.
	GINT0_PORT_POL_POL20 = 0x100000
	// Position of POL21 field.
	GINT0_PORT_POL_POL21_Pos = 0x15
	// Bit mask of POL21 field.
	GINT0_PORT_POL_POL21_Msk = 0x200000
	// Bit POL21.
	GINT0_PORT_POL_POL21 = 0x200000
	// Position of POL22 field.
	GINT0_PORT_POL_POL22_Pos = 0x16
	// Bit mask of POL22 field.
	GINT0_PORT_POL_POL22_Msk = 0x400000
	// Bit POL22.
	GINT0_PORT_POL_POL22 = 0x400000
	// Position of POL23 field.
	GINT0_PORT_POL_POL23_Pos = 0x17
	// Bit mask of POL23 field.
	GINT0_PORT_POL_POL23_Msk = 0x800000
	// Bit POL23.
	GINT0_PORT_POL_POL23 = 0x800000
	// Position of POL24 field.
	GINT0_PORT_POL_POL24_Pos = 0x18
	// Bit mask of POL24 field.
	GINT0_PORT_POL_POL24_Msk = 0x1000000
	// Bit POL24.
	GINT0_PORT_POL_POL24 = 0x1000000
	// Position of POL25 field.
	GINT0_PORT_POL_POL25_Pos = 0x19
	// Bit mask of POL25 field.
	GINT0_PORT_POL_POL25_Msk = 0x2000000
	// Bit POL25.
	GINT0_PORT_POL_POL25 = 0x2000000
	// Position of POL26 field.
	GINT0_PORT_POL_POL26_Pos = 0x1a
	// Bit mask of POL26 field.
	GINT0_PORT_POL_POL26_Msk = 0x4000000
	// Bit POL26.
	GINT0_PORT_POL_POL26 = 0x4000000
	// Position of POL27 field.
	GINT0_PORT_POL_POL27_Pos = 0x1b
	// Bit mask of POL27 field.
	GINT0_PORT_POL_POL27_Msk = 0x8000000
	// Bit POL27.
	GINT0_PORT_POL_POL27 = 0x8000000
	// Position of POL28 field.
	GINT0_PORT_POL_POL28_Pos = 0x1c
	// Bit mask of POL28 field.
	GINT0_PORT_POL_POL28_Msk = 0x10000000
	// Bit POL28.
	GINT0_PORT_POL_POL28 = 0x10000000
	// Position of POL29 field.
	GINT0_PORT_POL_POL29_Pos = 0x1d
	// Bit mask of POL29 field.
	GINT0_PORT_POL_POL29_Msk = 0x20000000
	// Bit POL29.
	GINT0_PORT_POL_POL29 = 0x20000000
	// Position of POL30 field.
	GINT0_PORT_POL_POL30_Pos = 0x1e
	// Bit mask of POL30 field.
	GINT0_PORT_POL_POL30_Msk = 0x40000000
	// Bit POL30.
	GINT0_PORT_POL_POL30 = 0x40000000
	// Position of POL31 field.
	GINT0_PORT_POL_POL31_Pos = 0x1f
	// Bit mask of POL31 field.
	GINT0_PORT_POL_POL31_Msk = 0x80000000
	// Bit POL31.
	GINT0_PORT_POL_POL31 = 0x80000000

	// PORT_ENA: GPIO grouped interrupt port enable register
	// Position of ENA0 field.
	GINT0_PORT_ENA_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	GINT0_PORT_ENA_ENA0_Msk = 0x1
	// Bit ENA0.
	GINT0_PORT_ENA_ENA0 = 0x1
	// Position of ENA1 field.
	GINT0_PORT_ENA_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	GINT0_PORT_ENA_ENA1_Msk = 0x2
	// Bit ENA1.
	GINT0_PORT_ENA_ENA1 = 0x2
	// Position of ENA2 field.
	GINT0_PORT_ENA_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	GINT0_PORT_ENA_ENA2_Msk = 0x4
	// Bit ENA2.
	GINT0_PORT_ENA_ENA2 = 0x4
	// Position of ENA3 field.
	GINT0_PORT_ENA_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	GINT0_PORT_ENA_ENA3_Msk = 0x8
	// Bit ENA3.
	GINT0_PORT_ENA_ENA3 = 0x8
	// Position of ENA4 field.
	GINT0_PORT_ENA_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	GINT0_PORT_ENA_ENA4_Msk = 0x10
	// Bit ENA4.
	GINT0_PORT_ENA_ENA4 = 0x10
	// Position of ENA5 field.
	GINT0_PORT_ENA_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	GINT0_PORT_ENA_ENA5_Msk = 0x20
	// Bit ENA5.
	GINT0_PORT_ENA_ENA5 = 0x20
	// Position of ENA6 field.
	GINT0_PORT_ENA_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	GINT0_PORT_ENA_ENA6_Msk = 0x40
	// Bit ENA6.
	GINT0_PORT_ENA_ENA6 = 0x40
	// Position of ENA7 field.
	GINT0_PORT_ENA_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	GINT0_PORT_ENA_ENA7_Msk = 0x80
	// Bit ENA7.
	GINT0_PORT_ENA_ENA7 = 0x80
	// Position of ENA8 field.
	GINT0_PORT_ENA_ENA8_Pos = 0x8
	// Bit mask of ENA8 field.
	GINT0_PORT_ENA_ENA8_Msk = 0x100
	// Bit ENA8.
	GINT0_PORT_ENA_ENA8 = 0x100
	// Position of ENA9 field.
	GINT0_PORT_ENA_ENA9_Pos = 0x9
	// Bit mask of ENA9 field.
	GINT0_PORT_ENA_ENA9_Msk = 0x200
	// Bit ENA9.
	GINT0_PORT_ENA_ENA9 = 0x200
	// Position of ENA10 field.
	GINT0_PORT_ENA_ENA10_Pos = 0xa
	// Bit mask of ENA10 field.
	GINT0_PORT_ENA_ENA10_Msk = 0x400
	// Bit ENA10.
	GINT0_PORT_ENA_ENA10 = 0x400
	// Position of ENA11 field.
	GINT0_PORT_ENA_ENA11_Pos = 0xb
	// Bit mask of ENA11 field.
	GINT0_PORT_ENA_ENA11_Msk = 0x800
	// Bit ENA11.
	GINT0_PORT_ENA_ENA11 = 0x800
	// Position of ENA12 field.
	GINT0_PORT_ENA_ENA12_Pos = 0xc
	// Bit mask of ENA12 field.
	GINT0_PORT_ENA_ENA12_Msk = 0x1000
	// Bit ENA12.
	GINT0_PORT_ENA_ENA12 = 0x1000
	// Position of ENA13 field.
	GINT0_PORT_ENA_ENA13_Pos = 0xd
	// Bit mask of ENA13 field.
	GINT0_PORT_ENA_ENA13_Msk = 0x2000
	// Bit ENA13.
	GINT0_PORT_ENA_ENA13 = 0x2000
	// Position of ENA14 field.
	GINT0_PORT_ENA_ENA14_Pos = 0xe
	// Bit mask of ENA14 field.
	GINT0_PORT_ENA_ENA14_Msk = 0x4000
	// Bit ENA14.
	GINT0_PORT_ENA_ENA14 = 0x4000
	// Position of ENA15 field.
	GINT0_PORT_ENA_ENA15_Pos = 0xf
	// Bit mask of ENA15 field.
	GINT0_PORT_ENA_ENA15_Msk = 0x8000
	// Bit ENA15.
	GINT0_PORT_ENA_ENA15 = 0x8000
	// Position of ENA16 field.
	GINT0_PORT_ENA_ENA16_Pos = 0x10
	// Bit mask of ENA16 field.
	GINT0_PORT_ENA_ENA16_Msk = 0x10000
	// Bit ENA16.
	GINT0_PORT_ENA_ENA16 = 0x10000
	// Position of ENA17 field.
	GINT0_PORT_ENA_ENA17_Pos = 0x11
	// Bit mask of ENA17 field.
	GINT0_PORT_ENA_ENA17_Msk = 0x20000
	// Bit ENA17.
	GINT0_PORT_ENA_ENA17 = 0x20000
	// Position of ENA18 field.
	GINT0_PORT_ENA_ENA18_Pos = 0x12
	// Bit mask of ENA18 field.
	GINT0_PORT_ENA_ENA18_Msk = 0x40000
	// Bit ENA18.
	GINT0_PORT_ENA_ENA18 = 0x40000
	// Position of ENA19 field.
	GINT0_PORT_ENA_ENA19_Pos = 0x13
	// Bit mask of ENA19 field.
	GINT0_PORT_ENA_ENA19_Msk = 0x80000
	// Bit ENA19.
	GINT0_PORT_ENA_ENA19 = 0x80000
	// Position of ENA20 field.
	GINT0_PORT_ENA_ENA20_Pos = 0x14
	// Bit mask of ENA20 field.
	GINT0_PORT_ENA_ENA20_Msk = 0x100000
	// Bit ENA20.
	GINT0_PORT_ENA_ENA20 = 0x100000
	// Position of ENA21 field.
	GINT0_PORT_ENA_ENA21_Pos = 0x15
	// Bit mask of ENA21 field.
	GINT0_PORT_ENA_ENA21_Msk = 0x200000
	// Bit ENA21.
	GINT0_PORT_ENA_ENA21 = 0x200000
	// Position of ENA22 field.
	GINT0_PORT_ENA_ENA22_Pos = 0x16
	// Bit mask of ENA22 field.
	GINT0_PORT_ENA_ENA22_Msk = 0x400000
	// Bit ENA22.
	GINT0_PORT_ENA_ENA22 = 0x400000
	// Position of ENA23 field.
	GINT0_PORT_ENA_ENA23_Pos = 0x17
	// Bit mask of ENA23 field.
	GINT0_PORT_ENA_ENA23_Msk = 0x800000
	// Bit ENA23.
	GINT0_PORT_ENA_ENA23 = 0x800000
	// Position of ENA24 field.
	GINT0_PORT_ENA_ENA24_Pos = 0x18
	// Bit mask of ENA24 field.
	GINT0_PORT_ENA_ENA24_Msk = 0x1000000
	// Bit ENA24.
	GINT0_PORT_ENA_ENA24 = 0x1000000
	// Position of ENA25 field.
	GINT0_PORT_ENA_ENA25_Pos = 0x19
	// Bit mask of ENA25 field.
	GINT0_PORT_ENA_ENA25_Msk = 0x2000000
	// Bit ENA25.
	GINT0_PORT_ENA_ENA25 = 0x2000000
	// Position of ENA26 field.
	GINT0_PORT_ENA_ENA26_Pos = 0x1a
	// Bit mask of ENA26 field.
	GINT0_PORT_ENA_ENA26_Msk = 0x4000000
	// Bit ENA26.
	GINT0_PORT_ENA_ENA26 = 0x4000000
	// Position of ENA27 field.
	GINT0_PORT_ENA_ENA27_Pos = 0x1b
	// Bit mask of ENA27 field.
	GINT0_PORT_ENA_ENA27_Msk = 0x8000000
	// Bit ENA27.
	GINT0_PORT_ENA_ENA27 = 0x8000000
	// Position of ENA28 field.
	GINT0_PORT_ENA_ENA28_Pos = 0x1c
	// Bit mask of ENA28 field.
	GINT0_PORT_ENA_ENA28_Msk = 0x10000000
	// Bit ENA28.
	GINT0_PORT_ENA_ENA28 = 0x10000000
	// Position of ENA29 field.
	GINT0_PORT_ENA_ENA29_Pos = 0x1d
	// Bit mask of ENA29 field.
	GINT0_PORT_ENA_ENA29_Msk = 0x20000000
	// Bit ENA29.
	GINT0_PORT_ENA_ENA29 = 0x20000000
	// Position of ENA30 field.
	GINT0_PORT_ENA_ENA30_Pos = 0x1e
	// Bit mask of ENA30 field.
	GINT0_PORT_ENA_ENA30_Msk = 0x40000000
	// Bit ENA30.
	GINT0_PORT_ENA_ENA30 = 0x40000000
	// Position of ENA31 field.
	GINT0_PORT_ENA_ENA31_Pos = 0x1f
	// Bit mask of ENA31 field.
	GINT0_PORT_ENA_ENA31_Msk = 0x80000000
	// Bit ENA31.
	GINT0_PORT_ENA_ENA31 = 0x80000000
)

// Bitfields for CRC: Cyclic Redundancy Check (CRC) engine
const (
	// MODE: CRC mode register
	// Position of CRC_POLY field.
	CRC_MODE_CRC_POLY_Pos = 0x0
	// Bit mask of CRC_POLY field.
	CRC_MODE_CRC_POLY_Msk = 0x3
	// Position of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Pos = 0x2
	// Bit mask of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Msk = 0x4
	// Bit BIT_RVS_WR.
	CRC_MODE_BIT_RVS_WR = 0x4
	// Position of CMPL_WR field.
	CRC_MODE_CMPL_WR_Pos = 0x3
	// Bit mask of CMPL_WR field.
	CRC_MODE_CMPL_WR_Msk = 0x8
	// Bit CMPL_WR.
	CRC_MODE_CMPL_WR = 0x8
	// Position of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Pos = 0x4
	// Bit mask of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Msk = 0x10
	// Bit BIT_RVS_SUM.
	CRC_MODE_BIT_RVS_SUM = 0x10
	// Position of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Pos = 0x5
	// Bit mask of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Msk = 0x20
	// Bit CMPL_SUM.
	CRC_MODE_CMPL_SUM = 0x20
	// Position of Reserved field.
	CRC_MODE_Reserved_Pos = 0x6
	// Bit mask of Reserved field.
	CRC_MODE_Reserved_Msk = 0xffffffc0

	// SEED: CRC seed register
	// Position of CRC_SEED field.
	CRC_SEED_CRC_SEED_Pos = 0x0
	// Bit mask of CRC_SEED field.
	CRC_SEED_CRC_SEED_Msk = 0xffffffff

	// SUM: CRC checksum register
	// Position of CRC_SUM field.
	CRC_SUM_CRC_SUM_Pos = 0x0
	// Bit mask of CRC_SUM field.
	CRC_SUM_CRC_SUM_Msk = 0xffffffff

	// WR_DATA: CRC data register
	// Position of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Pos = 0x0
	// Bit mask of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Msk = 0xffffffff
)

// Bitfields for DMA: DMA controller
const (
	// CTRL: DMA control.
	// Position of ENABLE field.
	DMA_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	DMA_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	DMA_CTRL_ENABLE = 0x1
	// Disabled. The DMA controller is disabled. This clears any triggers that were asserted at the point when disabled, but does not prevent re-triggering when the DMA controller is re-enabled.
	DMA_CTRL_ENABLE_DISABLED = 0x0
	// Enabled. The DMA controller is enabled.
	DMA_CTRL_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	DMA_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	DMA_CTRL_RESERVED_Msk = 0xfffffffe

	// INTSTAT: Interrupt status.
	// Position of RESERVED field.
	DMA_INTSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DMA_INTSTAT_RESERVED_Msk = 0x1
	// Bit RESERVED.
	DMA_INTSTAT_RESERVED = 0x1
	// Position of ACTIVEINT field.
	DMA_INTSTAT_ACTIVEINT_Pos = 0x1
	// Bit mask of ACTIVEINT field.
	DMA_INTSTAT_ACTIVEINT_Msk = 0x2
	// Bit ACTIVEINT.
	DMA_INTSTAT_ACTIVEINT = 0x2
	// Not pending. No enabled interrupts are pending.
	DMA_INTSTAT_ACTIVEINT_NOT_PENDING = 0x0
	// Pending. At least one enabled interrupt is pending.
	DMA_INTSTAT_ACTIVEINT_PENDING = 0x1
	// Position of ACTIVEERRINT field.
	DMA_INTSTAT_ACTIVEERRINT_Pos = 0x2
	// Bit mask of ACTIVEERRINT field.
	DMA_INTSTAT_ACTIVEERRINT_Msk = 0x4
	// Bit ACTIVEERRINT.
	DMA_INTSTAT_ACTIVEERRINT = 0x4
	// Not pending. No error interrupts are pending.
	DMA_INTSTAT_ACTIVEERRINT_NOT_PENDING = 0x0
	// Pending. At least one error interrupt is pending.
	DMA_INTSTAT_ACTIVEERRINT_PENDING = 0x1
	// Position of RESERVED field.
	DMA_INTSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	DMA_INTSTAT_RESERVED_Msk = 0xfffffff8

	// SRAMBASE: SRAM address of the channel configuration table.
	// Position of RESERVED field.
	DMA_SRAMBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DMA_SRAMBASE_RESERVED_Msk = 0x3ff
	// Position of OFFSET field.
	DMA_SRAMBASE_OFFSET_Pos = 0xa
	// Bit mask of OFFSET field.
	DMA_SRAMBASE_OFFSET_Msk = 0xfffffc00

	// ENABLESET0: Channel Enable read and Set for all DMA channels.
	// Position of ENA field.
	DMA_ENABLESET0_ENA_Pos = 0x0
	// Bit mask of ENA field.
	DMA_ENABLESET0_ENA_Msk = 0xffff
	// Position of RESERVED field.
	DMA_ENABLESET0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_ENABLESET0_RESERVED_Msk = 0xffff0000

	// ENABLECLR0: Channel Enable Clear for all DMA channels.
	// Position of CLR field.
	DMA_ENABLECLR0_CLR_Pos = 0x0
	// Bit mask of CLR field.
	DMA_ENABLECLR0_CLR_Msk = 0xffff

	// ACTIVE0: Channel Active status for all DMA channels.
	// Position of ACT field.
	DMA_ACTIVE0_ACT_Pos = 0x0
	// Bit mask of ACT field.
	DMA_ACTIVE0_ACT_Msk = 0xffff
	// Position of RESERVED field.
	DMA_ACTIVE0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_ACTIVE0_RESERVED_Msk = 0xffff0000

	// BUSY0: Channel Busy status for all DMA channels.
	// Position of BSY field.
	DMA_BUSY0_BSY_Pos = 0x0
	// Bit mask of BSY field.
	DMA_BUSY0_BSY_Msk = 0xffff
	// Position of RESERVED field.
	DMA_BUSY0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_BUSY0_RESERVED_Msk = 0xffff0000

	// ERRINT0: Error Interrupt status for all DMA channels.
	// Position of ERR field.
	DMA_ERRINT0_ERR_Pos = 0x0
	// Bit mask of ERR field.
	DMA_ERRINT0_ERR_Msk = 0xffff
	// Position of RESERVED field.
	DMA_ERRINT0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_ERRINT0_RESERVED_Msk = 0xfffc0000

	// INTENSET0: Interrupt Enable read and Set for all DMA channels.
	// Position of INTEN field.
	DMA_INTENSET0_INTEN_Pos = 0x0
	// Bit mask of INTEN field.
	DMA_INTENSET0_INTEN_Msk = 0xffff
	// Position of RESERVED field.
	DMA_INTENSET0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_INTENSET0_RESERVED_Msk = 0xffff0000

	// INTENCLR0: Interrupt Enable Clear for all DMA channels.
	// Position of CLR field.
	DMA_INTENCLR0_CLR_Pos = 0x0
	// Bit mask of CLR field.
	DMA_INTENCLR0_CLR_Msk = 0xffff
	// Position of RESERVED field.
	DMA_INTENCLR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_INTENCLR0_RESERVED_Msk = 0xffff0000

	// INTA0: Interrupt A status for all DMA channels.
	// Position of IA field.
	DMA_INTA0_IA_Pos = 0x0
	// Bit mask of IA field.
	DMA_INTA0_IA_Msk = 0xffff
	// Position of RESERVED field.
	DMA_INTA0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_INTA0_RESERVED_Msk = 0xffff0000

	// INTB0: Interrupt B status for all DMA channels.
	// Position of IB field.
	DMA_INTB0_IB_Pos = 0x0
	// Bit mask of IB field.
	DMA_INTB0_IB_Msk = 0xffff
	// Position of RESERVED field.
	DMA_INTB0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_INTB0_RESERVED_Msk = 0xffff0000

	// SETVALID0: Set ValidPending control bits for all DMA channels.
	// Position of SV field.
	DMA_SETVALID0_SV_Pos = 0x0
	// Bit mask of SV field.
	DMA_SETVALID0_SV_Msk = 0xffff
	// Position of RESERVED field.
	DMA_SETVALID0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_SETVALID0_RESERVED_Msk = 0xffff0000

	// SETTRIG0: Set Trigger control bits for all DMA channels.
	// Position of TRIG field.
	DMA_SETTRIG0_TRIG_Pos = 0x0
	// Bit mask of TRIG field.
	DMA_SETTRIG0_TRIG_Msk = 0xffff
	// Position of RESERVED field.
	DMA_SETTRIG0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_SETTRIG0_RESERVED_Msk = 0xffff0000

	// ABORT0: Channel Abort control for all DMA channels.
	// Position of AORTCTRL field.
	DMA_ABORT0_AORTCTRL_Pos = 0x0
	// Bit mask of AORTCTRL field.
	DMA_ABORT0_AORTCTRL_Msk = 0xffff
	// Position of RESERVED field.
	DMA_ABORT0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DMA_ABORT0_RESERVED_Msk = 0xffff0000

	// CFG0: Configuration register for DMA channel 0.
	// Position of PERIPHREQEN field.
	DMA_CFG_PERIPHREQEN_Pos = 0x0
	// Bit mask of PERIPHREQEN field.
	DMA_CFG_PERIPHREQEN_Msk = 0x1
	// Bit PERIPHREQEN.
	DMA_CFG_PERIPHREQEN = 0x1
	// Disabled. Peripheral DMA requests are disabled.
	DMA_CFG_PERIPHREQEN_DISABLED = 0x0
	// Enabled. Peripheral DMA requests are enabled.
	DMA_CFG_PERIPHREQEN_ENABLED = 0x1
	// Position of HWTRIGEN field.
	DMA_CFG_HWTRIGEN_Pos = 0x1
	// Bit mask of HWTRIGEN field.
	DMA_CFG_HWTRIGEN_Msk = 0x2
	// Bit HWTRIGEN.
	DMA_CFG_HWTRIGEN = 0x2
	// Disabled. Hardware triggering is not used.
	DMA_CFG_HWTRIGEN_DISABLED = 0x0
	// Enabled. Use hardware triggering.
	DMA_CFG_HWTRIGEN_ENABLED = 0x1
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0xc
	// Position of TRIGPOL field.
	DMA_CFG_TRIGPOL_Pos = 0x4
	// Bit mask of TRIGPOL field.
	DMA_CFG_TRIGPOL_Msk = 0x10
	// Bit TRIGPOL.
	DMA_CFG_TRIGPOL = 0x10
	// Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
	DMA_CFG_TRIGPOL_ACTIVE_LOW__FALLING = 0x0
	// Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
	DMA_CFG_TRIGPOL_ACTIVE_HIGH__RISING = 0x1
	// Position of TRIGTYPE field.
	DMA_CFG_TRIGTYPE_Pos = 0x5
	// Bit mask of TRIGTYPE field.
	DMA_CFG_TRIGTYPE_Msk = 0x20
	// Bit TRIGTYPE.
	DMA_CFG_TRIGTYPE = 0x20
	// Edge. Hardware trigger is edge triggered.
	DMA_CFG_TRIGTYPE_EDGE = 0x0
	// Level. Hardware trigger is level triggered. Note that when level triggering without burst (BURSTPOWER = 0) is selected, only hardware triggers should be used on that channel.
	DMA_CFG_TRIGTYPE_LEVEL = 0x1
	// Position of TRIGBURST field.
	DMA_CFG_TRIGBURST_Pos = 0x6
	// Bit mask of TRIGBURST field.
	DMA_CFG_TRIGBURST_Msk = 0x40
	// Bit TRIGBURST.
	DMA_CFG_TRIGBURST = 0x40
	// Single transfer. Hardware trigger causes a single transfer.
	DMA_CFG_TRIGBURST_SINGLE_TRANSFER = 0x0
	// Burst transfer. When the trigger for this channel is set to edge triggered, a hardware trigger causes a burst transfer, as defined by BURSTPOWER. When the trigger for this channel is set to level triggered, a hardware trigger causes transfers to continue as long as the trigger is asserted, unless the transfer is complete.
	DMA_CFG_TRIGBURST_BURST_TRANSFER = 0x1
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	DMA_CFG_RESERVED = 0x80
	// Position of BURSTPOWER field.
	DMA_CFG_BURSTPOWER_Pos = 0x8
	// Bit mask of BURSTPOWER field.
	DMA_CFG_BURSTPOWER_Msk = 0xf00
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0x3000
	// Position of SRCBURSTWRAP field.
	DMA_CFG_SRCBURSTWRAP_Pos = 0xe
	// Bit mask of SRCBURSTWRAP field.
	DMA_CFG_SRCBURSTWRAP_Msk = 0x4000
	// Bit SRCBURSTWRAP.
	DMA_CFG_SRCBURSTWRAP = 0x4000
	// Disabled. Source burst wrapping is not enabled for this DMA channel.
	DMA_CFG_SRCBURSTWRAP_DISABLED = 0x0
	// Enabled. Source burst wrapping is enabled for this DMA channel.
	DMA_CFG_SRCBURSTWRAP_ENABLED = 0x1
	// Position of DSTBURSTWRAP field.
	DMA_CFG_DSTBURSTWRAP_Pos = 0xf
	// Bit mask of DSTBURSTWRAP field.
	DMA_CFG_DSTBURSTWRAP_Msk = 0x8000
	// Bit DSTBURSTWRAP.
	DMA_CFG_DSTBURSTWRAP = 0x8000
	// Disabled. Destination burst wrapping is not enabled for this DMA channel.
	DMA_CFG_DSTBURSTWRAP_DISABLED = 0x0
	// Enabled. Destination burst wrapping is enabled for this DMA channel.
	DMA_CFG_DSTBURSTWRAP_ENABLED = 0x1
	// Position of CHPRIORITY field.
	DMA_CFG_CHPRIORITY_Pos = 0x10
	// Bit mask of CHPRIORITY field.
	DMA_CFG_CHPRIORITY_Msk = 0x30000
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0xfffc0000

	// CTLSTAT0: Control and status register for DMA channel 0.
	// Position of VALIDPENDING field.
	DMA_CTLSTAT_VALIDPENDING_Pos = 0x0
	// Bit mask of VALIDPENDING field.
	DMA_CTLSTAT_VALIDPENDING_Msk = 0x1
	// Bit VALIDPENDING.
	DMA_CTLSTAT_VALIDPENDING = 0x1
	// No effect on DMA operation.
	DMA_CTLSTAT_VALIDPENDING_NO_EFFECT_ON_DMA_OPE = 0x0
	// Valid pending.
	DMA_CTLSTAT_VALIDPENDING_VALID_PENDING = 0x1
	// Position of RESERVED field.
	DMA_CTLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	DMA_CTLSTAT_RESERVED_Msk = 0x2
	// Bit RESERVED.
	DMA_CTLSTAT_RESERVED = 0x2
	// Position of TRIG field.
	DMA_CTLSTAT_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	DMA_CTLSTAT_TRIG_Msk = 0x4
	// Bit TRIG.
	DMA_CTLSTAT_TRIG = 0x4
	// Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
	DMA_CTLSTAT_TRIG_NOT_TRIGGERED = 0x0
	// Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
	DMA_CTLSTAT_TRIG_TRIGGERED = 0x1
	// Position of RESERVED field.
	DMA_CTLSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	DMA_CTLSTAT_RESERVED_Msk = 0xfffffff8

	// XFERCFG0: Transfer configuration register for DMA channel 0.
	// Position of CFGVALID field.
	DMA_XFERCFG_CFGVALID_Pos = 0x0
	// Bit mask of CFGVALID field.
	DMA_XFERCFG_CFGVALID_Msk = 0x1
	// Bit CFGVALID.
	DMA_XFERCFG_CFGVALID = 0x1
	// Not valid. The current channel descriptor is not considered valid.
	DMA_XFERCFG_CFGVALID_NOT_VALID = 0x0
	// Valid. The current channel descriptor is considered valid.
	DMA_XFERCFG_CFGVALID_VALID = 0x1
	// Position of RELOAD field.
	DMA_XFERCFG_RELOAD_Pos = 0x1
	// Bit mask of RELOAD field.
	DMA_XFERCFG_RELOAD_Msk = 0x2
	// Bit RELOAD.
	DMA_XFERCFG_RELOAD = 0x2
	// Disabled. Do not reload the channels' control structure when the current descriptor is exhausted.
	DMA_XFERCFG_RELOAD_DISABLED = 0x0
	// Enabled. Reload the channels' control structure when the current descriptor is exhausted.
	DMA_XFERCFG_RELOAD_ENABLED = 0x1
	// Position of SWTRIG field.
	DMA_XFERCFG_SWTRIG_Pos = 0x2
	// Bit mask of SWTRIG field.
	DMA_XFERCFG_SWTRIG_Msk = 0x4
	// Bit SWTRIG.
	DMA_XFERCFG_SWTRIG = 0x4
	// Position of CLRTRIG field.
	DMA_XFERCFG_CLRTRIG_Pos = 0x3
	// Bit mask of CLRTRIG field.
	DMA_XFERCFG_CLRTRIG_Msk = 0x8
	// Bit CLRTRIG.
	DMA_XFERCFG_CLRTRIG = 0x8
	// Not cleared. The trigger is not cleared when this descriptor is exhausted. If there is a reload, the next descriptor will be started.
	DMA_XFERCFG_CLRTRIG_NOT_CLEARED = 0x0
	// Cleared. The trigger is cleared when this descriptor is exhausted.
	DMA_XFERCFG_CLRTRIG_CLEARED = 0x1
	// Position of SETINTA field.
	DMA_XFERCFG_SETINTA_Pos = 0x4
	// Bit mask of SETINTA field.
	DMA_XFERCFG_SETINTA_Msk = 0x10
	// Bit SETINTA.
	DMA_XFERCFG_SETINTA = 0x10
	// No effect.
	DMA_XFERCFG_SETINTA_NO_EFFECT = 0x0
	// Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
	DMA_XFERCFG_SETINTA_SET = 0x1
	// Position of SETINTB field.
	DMA_XFERCFG_SETINTB_Pos = 0x5
	// Bit mask of SETINTB field.
	DMA_XFERCFG_SETINTB_Msk = 0x20
	// Bit SETINTB.
	DMA_XFERCFG_SETINTB = 0x20
	// No effect.
	DMA_XFERCFG_SETINTB_NO_EFFECT = 0x0
	// Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
	DMA_XFERCFG_SETINTB_SET = 0x1
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xc0
	// Position of WIDTH field.
	DMA_XFERCFG_WIDTH_Pos = 0x8
	// Bit mask of WIDTH field.
	DMA_XFERCFG_WIDTH_Msk = 0x300
	// 8-bit transfers are performed (8-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_8_BIT_TRANSFERS = 0x0
	// 16-bit transfers are performed (16-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_16_BIT_TRANSFERS = 0x1
	// 32-bit transfers are performed (32-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_32_BIT_TRANSFERS = 0x2
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xc00
	// Position of SRCINC field.
	DMA_XFERCFG_SRCINC_Pos = 0xc
	// Bit mask of SRCINC field.
	DMA_XFERCFG_SRCINC_Msk = 0x3000
	// No increment. The source address is not incremented for each transfer. This is the usual case when the source is a peripheral device.
	DMA_XFERCFG_SRCINC_NO_INCREMENT = 0x0
	// 1 x width. The source address is incremented by the amount specified by Width for each transfer. This is the usual case when the source is memory.
	DMA_XFERCFG_SRCINC_1_X_WIDTH = 0x1
	// 2 x width. The source address is incremented by 2 times the amount specified by Width for each transfer.
	DMA_XFERCFG_SRCINC_2_X_WIDTH = 0x2
	// 4 x width. The source address is incremented by 4 times the amount specified by Width for each transfer.
	DMA_XFERCFG_SRCINC_4_X_WIDTH = 0x3
	// Position of DSTINC field.
	DMA_XFERCFG_DSTINC_Pos = 0xe
	// Bit mask of DSTINC field.
	DMA_XFERCFG_DSTINC_Msk = 0xc000
	// No increment. The destination address is not incremented for each transfer. This is the usual case when the destination is a peripheral device.
	DMA_XFERCFG_DSTINC_NO_INCREMENT = 0x0
	// 1 x width. The destination address is incremented by the amount specified by Width for each transfer. This is the usual case when the destination is memory.
	DMA_XFERCFG_DSTINC_1_X_WIDTH = 0x1
	// 2 x width. The destination address is incremented by 2 times the amount specified by Width for each transfer.
	DMA_XFERCFG_DSTINC_2_X_WIDTH = 0x2
	// 4 x width. The destination address is incremented by 4 times the amount specified by Width for each transfer.
	DMA_XFERCFG_DSTINC_4_X_WIDTH = 0x3
	// Position of XFERCOUNT field.
	DMA_XFERCFG_XFERCOUNT_Pos = 0x10
	// Bit mask of XFERCOUNT field.
	DMA_XFERCFG_XFERCOUNT_Msk = 0x3ff0000
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xfc000000
)

// Bitfields for SCT0: State Configurable Timers (SCTimer/PWM)
const (
	// CONFIG: SCT configuration register
	// Position of UNIFY field.
	SCT0_CONFIG_UNIFY_Pos = 0x0
	// Bit mask of UNIFY field.
	SCT0_CONFIG_UNIFY_Msk = 0x1
	// Bit UNIFY.
	SCT0_CONFIG_UNIFY = 0x1
	// Position of CLKMODE field.
	SCT0_CONFIG_CLKMODE_Pos = 0x1
	// Bit mask of CLKMODE field.
	SCT0_CONFIG_CLKMODE_Msk = 0x6
	// The bus clock clocks the SCT and prescalers.
	SCT0_CONFIG_CLKMODE_THE_BUS_CLOCK_CLOCKS = 0x0
	// The SCT clock is the bus clock, but the prescalers are enabled to count only when sampling of the input selected by the CKSEL field finds the selected edge. The minimum pulse width on the clock input is 1 bus clock period. This mode is the high-performance sampled-clock mode.
	SCT0_CONFIG_CLKMODE_THE_SCT_CLOCK_IS_THE = 0x1
	// The input selected by CKSEL clocks the SCT and prescalers. The input is synchronized to the bus clock and possibly inverted. The minimum pulse width on the clock input is 1 bus clock period. This mode is the low-power sampled-clock mode.
	SCT0_CONFIG_CLKMODE_THE_INPUT_SELECTED_B = 0x2
	// Prescaled SCT input. The SCT and prescalers are clocked by the input edge selected by the CKSEL field. In this mode, most of the SCT is clocked by the (selected polarity of the) input. The outputs are switched synchronously to the input clock. The input clock rate must be at least half the system clock rate and can the same or faster than the system clock.
	SCT0_CONFIG_CLKMODE_PRESCALED_SCT_INPUT = 0x3
	// Position of CKSEL field.
	SCT0_CONFIG_CKSEL_Pos = 0x3
	// Bit mask of CKSEL field.
	SCT0_CONFIG_CKSEL_Msk = 0x78
	// Position of NORELAOD_L field.
	SCT0_CONFIG_NORELAOD_L_Pos = 0x7
	// Bit mask of NORELAOD_L field.
	SCT0_CONFIG_NORELAOD_L_Msk = 0x80
	// Bit NORELAOD_L.
	SCT0_CONFIG_NORELAOD_L = 0x80
	// Position of NORELOAD_H field.
	SCT0_CONFIG_NORELOAD_H_Pos = 0x8
	// Bit mask of NORELOAD_H field.
	SCT0_CONFIG_NORELOAD_H_Msk = 0x100
	// Bit NORELOAD_H.
	SCT0_CONFIG_NORELOAD_H = 0x100
	// Position of INSYNC field.
	SCT0_CONFIG_INSYNC_Pos = 0x9
	// Bit mask of INSYNC field.
	SCT0_CONFIG_INSYNC_Msk = 0x1fe00
	// Position of AUTOLIMIT_L field.
	SCT0_CONFIG_AUTOLIMIT_L_Pos = 0x11
	// Bit mask of AUTOLIMIT_L field.
	SCT0_CONFIG_AUTOLIMIT_L_Msk = 0x20000
	// Bit AUTOLIMIT_L.
	SCT0_CONFIG_AUTOLIMIT_L = 0x20000
	// Position of AUTOLIMIT_H field.
	SCT0_CONFIG_AUTOLIMIT_H_Pos = 0x12
	// Bit mask of AUTOLIMIT_H field.
	SCT0_CONFIG_AUTOLIMIT_H_Msk = 0x40000
	// Bit AUTOLIMIT_H.
	SCT0_CONFIG_AUTOLIMIT_H = 0x40000
	// Position of RESERVED field.
	SCT0_CONFIG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SCT0_CONFIG_RESERVED_Msk = 0xfff80000

	// CTRL: SCT control register
	// Position of DOWN_L field.
	SCT0_CTRL_DOWN_L_Pos = 0x0
	// Bit mask of DOWN_L field.
	SCT0_CTRL_DOWN_L_Msk = 0x1
	// Bit DOWN_L.
	SCT0_CTRL_DOWN_L = 0x1
	// Position of STOP_L field.
	SCT0_CTRL_STOP_L_Pos = 0x1
	// Bit mask of STOP_L field.
	SCT0_CTRL_STOP_L_Msk = 0x2
	// Bit STOP_L.
	SCT0_CTRL_STOP_L = 0x2
	// Position of HALT_L field.
	SCT0_CTRL_HALT_L_Pos = 0x2
	// Bit mask of HALT_L field.
	SCT0_CTRL_HALT_L_Msk = 0x4
	// Bit HALT_L.
	SCT0_CTRL_HALT_L = 0x4
	// Position of CLRCTR_L field.
	SCT0_CTRL_CLRCTR_L_Pos = 0x3
	// Bit mask of CLRCTR_L field.
	SCT0_CTRL_CLRCTR_L_Msk = 0x8
	// Bit CLRCTR_L.
	SCT0_CTRL_CLRCTR_L = 0x8
	// Position of BIDIR_L field.
	SCT0_CTRL_BIDIR_L_Pos = 0x4
	// Bit mask of BIDIR_L field.
	SCT0_CTRL_BIDIR_L_Msk = 0x10
	// Bit BIDIR_L.
	SCT0_CTRL_BIDIR_L = 0x10
	// Position of PRE_L field.
	SCT0_CTRL_PRE_L_Pos = 0x5
	// Bit mask of PRE_L field.
	SCT0_CTRL_PRE_L_Msk = 0x1fe0
	// Position of RESERVED field.
	SCT0_CTRL_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SCT0_CTRL_RESERVED_Msk = 0xe000
	// Position of DOWN_H field.
	SCT0_CTRL_DOWN_H_Pos = 0x10
	// Bit mask of DOWN_H field.
	SCT0_CTRL_DOWN_H_Msk = 0x10000
	// Bit DOWN_H.
	SCT0_CTRL_DOWN_H = 0x10000
	// Position of STOP_H field.
	SCT0_CTRL_STOP_H_Pos = 0x11
	// Bit mask of STOP_H field.
	SCT0_CTRL_STOP_H_Msk = 0x20000
	// Bit STOP_H.
	SCT0_CTRL_STOP_H = 0x20000
	// Position of HALT_H field.
	SCT0_CTRL_HALT_H_Pos = 0x12
	// Bit mask of HALT_H field.
	SCT0_CTRL_HALT_H_Msk = 0x40000
	// Bit HALT_H.
	SCT0_CTRL_HALT_H = 0x40000
	// Position of CLRCTR_H field.
	SCT0_CTRL_CLRCTR_H_Pos = 0x13
	// Bit mask of CLRCTR_H field.
	SCT0_CTRL_CLRCTR_H_Msk = 0x80000
	// Bit CLRCTR_H.
	SCT0_CTRL_CLRCTR_H = 0x80000
	// Position of BIDIR_H field.
	SCT0_CTRL_BIDIR_H_Pos = 0x14
	// Bit mask of BIDIR_H field.
	SCT0_CTRL_BIDIR_H_Msk = 0x100000
	// Bit BIDIR_H.
	SCT0_CTRL_BIDIR_H = 0x100000
	// Position of PRE_H field.
	SCT0_CTRL_PRE_H_Pos = 0x15
	// Bit mask of PRE_H field.
	SCT0_CTRL_PRE_H_Msk = 0x1fe00000
	// Position of RESERVED field.
	SCT0_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	SCT0_CTRL_RESERVED_Msk = 0xe0000000

	// LIMIT: SCT limit register
	// Position of LIMMSK_L field.
	SCT0_LIMIT_LIMMSK_L_Pos = 0x0
	// Bit mask of LIMMSK_L field.
	SCT0_LIMIT_LIMMSK_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_LIMIT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_LIMIT_RESERVED_Msk = 0xffc0
	// Position of LIMMSK_H field.
	SCT0_LIMIT_LIMMSK_H_Pos = 0x10
	// Bit mask of LIMMSK_H field.
	SCT0_LIMIT_LIMMSK_H_Msk = 0x3f0000
	// Position of RESERVED field.
	SCT0_LIMIT_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SCT0_LIMIT_RESERVED_Msk = 0xffc00000

	// HALT: SCT halt condition register
	// Position of HALTMSK_L field.
	SCT0_HALT_HALTMSK_L_Pos = 0x0
	// Bit mask of HALTMSK_L field.
	SCT0_HALT_HALTMSK_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_HALT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_HALT_RESERVED_Msk = 0xffc0
	// Position of HALTMSK_H field.
	SCT0_HALT_HALTMSK_H_Pos = 0x10
	// Bit mask of HALTMSK_H field.
	SCT0_HALT_HALTMSK_H_Msk = 0x3f0000
	// Position of RESERVED field.
	SCT0_HALT_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SCT0_HALT_RESERVED_Msk = 0xffc00000

	// STOP: SCT stop condition register
	// Position of STOPMSK_L field.
	SCT0_STOP_STOPMSK_L_Pos = 0x0
	// Bit mask of STOPMSK_L field.
	SCT0_STOP_STOPMSK_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_STOP_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_STOP_RESERVED_Msk = 0xffc0
	// Position of STOPMSK_H field.
	SCT0_STOP_STOPMSK_H_Pos = 0x10
	// Bit mask of STOPMSK_H field.
	SCT0_STOP_STOPMSK_H_Msk = 0x3f0000
	// Position of RESERVED field.
	SCT0_STOP_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SCT0_STOP_RESERVED_Msk = 0xffc00000

	// START: SCT start condition register
	// Position of STARTMSK_L field.
	SCT0_START_STARTMSK_L_Pos = 0x0
	// Bit mask of STARTMSK_L field.
	SCT0_START_STARTMSK_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_START_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_START_RESERVED_Msk = 0xffc0
	// Position of STARTMSK_H field.
	SCT0_START_STARTMSK_H_Pos = 0x10
	// Bit mask of STARTMSK_H field.
	SCT0_START_STARTMSK_H_Msk = 0x3f0000
	// Position of RESERVED field.
	SCT0_START_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SCT0_START_RESERVED_Msk = 0xffc00000

	// COUNT: SCT counter register
	// Position of CTR_L field.
	SCT0_COUNT_CTR_L_Pos = 0x0
	// Bit mask of CTR_L field.
	SCT0_COUNT_CTR_L_Msk = 0xffff
	// Position of CTR_H field.
	SCT0_COUNT_CTR_H_Pos = 0x10
	// Bit mask of CTR_H field.
	SCT0_COUNT_CTR_H_Msk = 0xffff0000

	// STATE: SCT state register
	// Position of STATE_L field.
	SCT0_STATE_STATE_L_Pos = 0x0
	// Bit mask of STATE_L field.
	SCT0_STATE_STATE_L_Msk = 0x1f
	// Position of RESERVED field.
	SCT0_STATE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCT0_STATE_RESERVED_Msk = 0xffe0
	// Position of STATE_H field.
	SCT0_STATE_STATE_H_Pos = 0x10
	// Bit mask of STATE_H field.
	SCT0_STATE_STATE_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT0_STATE_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT0_STATE_RESERVED_Msk = 0xffe00000

	// INPUT: SCT input register
	// Position of AIN0 field.
	SCT0_INPUT_AIN0_Pos = 0x0
	// Bit mask of AIN0 field.
	SCT0_INPUT_AIN0_Msk = 0x1
	// Bit AIN0.
	SCT0_INPUT_AIN0 = 0x1
	// Position of AIN1 field.
	SCT0_INPUT_AIN1_Pos = 0x1
	// Bit mask of AIN1 field.
	SCT0_INPUT_AIN1_Msk = 0x2
	// Bit AIN1.
	SCT0_INPUT_AIN1 = 0x2
	// Position of AIN2 field.
	SCT0_INPUT_AIN2_Pos = 0x2
	// Bit mask of AIN2 field.
	SCT0_INPUT_AIN2_Msk = 0x4
	// Bit AIN2.
	SCT0_INPUT_AIN2 = 0x4
	// Position of AIN3 field.
	SCT0_INPUT_AIN3_Pos = 0x3
	// Bit mask of AIN3 field.
	SCT0_INPUT_AIN3_Msk = 0x8
	// Bit AIN3.
	SCT0_INPUT_AIN3 = 0x8
	// Position of RESERVED field.
	SCT0_INPUT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT0_INPUT_RESERVED_Msk = 0xfff0
	// Position of SIN0 field.
	SCT0_INPUT_SIN0_Pos = 0x10
	// Bit mask of SIN0 field.
	SCT0_INPUT_SIN0_Msk = 0x10000
	// Bit SIN0.
	SCT0_INPUT_SIN0 = 0x10000
	// Position of SIN1 field.
	SCT0_INPUT_SIN1_Pos = 0x11
	// Bit mask of SIN1 field.
	SCT0_INPUT_SIN1_Msk = 0x20000
	// Bit SIN1.
	SCT0_INPUT_SIN1 = 0x20000
	// Position of SIN2 field.
	SCT0_INPUT_SIN2_Pos = 0x12
	// Bit mask of SIN2 field.
	SCT0_INPUT_SIN2_Msk = 0x40000
	// Bit SIN2.
	SCT0_INPUT_SIN2 = 0x40000
	// Position of SIN3 field.
	SCT0_INPUT_SIN3_Pos = 0x13
	// Bit mask of SIN3 field.
	SCT0_INPUT_SIN3_Msk = 0x80000
	// Bit SIN3.
	SCT0_INPUT_SIN3 = 0x80000
	// Position of RESERVED field.
	SCT0_INPUT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT0_INPUT_RESERVED_Msk = 0xfff00000

	// REGMODE: SCT match/capture registers mode register
	// Position of REGMOD_L field.
	SCT0_REGMODE_REGMOD_L_Pos = 0x0
	// Bit mask of REGMOD_L field.
	SCT0_REGMODE_REGMOD_L_Msk = 0x1f
	// Position of RESERVED field.
	SCT0_REGMODE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCT0_REGMODE_RESERVED_Msk = 0xffe0
	// Position of REGMOD_H field.
	SCT0_REGMODE_REGMOD_H_Pos = 0x10
	// Bit mask of REGMOD_H field.
	SCT0_REGMODE_REGMOD_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT0_REGMODE_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT0_REGMODE_RESERVED_Msk = 0xffe00000

	// OUTPUT: SCT output register
	// Position of OUT field.
	SCT0_OUTPUT_OUT_Pos = 0x0
	// Bit mask of OUT field.
	SCT0_OUTPUT_OUT_Msk = 0xf
	// Position of RESERVED field.
	SCT0_OUTPUT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT0_OUTPUT_RESERVED_Msk = 0xfffffff0

	// OUTPUTDIRCTRL: SCT output counter direction control register
	// Position of SETCLR0 field.
	SCT0_OUTPUTDIRCTRL_SETCLR0_Pos = 0x0
	// Bit mask of SETCLR0 field.
	SCT0_OUTPUTDIRCTRL_SETCLR0_Msk = 0x3
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR0_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR1 field.
	SCT0_OUTPUTDIRCTRL_SETCLR1_Pos = 0x2
	// Bit mask of SETCLR1 field.
	SCT0_OUTPUTDIRCTRL_SETCLR1_Msk = 0xc
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR1_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR2 field.
	SCT0_OUTPUTDIRCTRL_SETCLR2_Pos = 0x4
	// Bit mask of SETCLR2 field.
	SCT0_OUTPUTDIRCTRL_SETCLR2_Msk = 0x30
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR2_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR3 field.
	SCT0_OUTPUTDIRCTRL_SETCLR3_Pos = 0x6
	// Bit mask of SETCLR3 field.
	SCT0_OUTPUTDIRCTRL_SETCLR3_Msk = 0xc0
	// Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR3_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of RESERVED field.
	SCT0_OUTPUTDIRCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCT0_OUTPUTDIRCTRL_RESERVED_Msk = 0xffffff00

	// RES: SCT conflict resolution register
	// Position of O0RES field.
	SCT0_RES_O0RES_Pos = 0x0
	// Bit mask of O0RES field.
	SCT0_RES_O0RES_Msk = 0x3
	// No change.
	SCT0_RES_O0RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR0 field).
	SCT0_RES_O0RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR0 field).
	SCT0_RES_O0RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O0RES_TOGGLE_OUTPUT = 0x3
	// Position of O1RES field.
	SCT0_RES_O1RES_Pos = 0x2
	// Bit mask of O1RES field.
	SCT0_RES_O1RES_Msk = 0xc
	// No change.
	SCT0_RES_O1RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR1 field).
	SCT0_RES_O1RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR1 field).
	SCT0_RES_O1RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O1RES_TOGGLE_OUTPUT = 0x3
	// Position of O2RES field.
	SCT0_RES_O2RES_Pos = 0x4
	// Bit mask of O2RES field.
	SCT0_RES_O2RES_Msk = 0x30
	// No change.
	SCT0_RES_O2RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR2 field).
	SCT0_RES_O2RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output n (or set based on the SETCLR2 field).
	SCT0_RES_O2RES_CLEAR_OUTPUT_N_OR_S = 0x2
	// Toggle output.
	SCT0_RES_O2RES_TOGGLE_OUTPUT = 0x3
	// Position of O3RES field.
	SCT0_RES_O3RES_Pos = 0x6
	// Bit mask of O3RES field.
	SCT0_RES_O3RES_Msk = 0xc0
	// No change.
	SCT0_RES_O3RES_NO_CHANGE = 0x0
	// Set output (or clear based on the SETCLR3 field).
	SCT0_RES_O3RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR3 field).
	SCT0_RES_O3RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT0_RES_O3RES_TOGGLE_OUTPUT = 0x3
	// Position of RESERVED field.
	SCT0_RES_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCT0_RES_RESERVED_Msk = 0xffffff00

	// DMAREQ0: SCT DMA request 0 register
	// Position of DEV_0 field.
	SCT0_DMAREQ0_DEV_0_Pos = 0x0
	// Bit mask of DEV_0 field.
	SCT0_DMAREQ0_DEV_0_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_DMAREQ0_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_DMAREQ0_RESERVED_Msk = 0x3fffffc0
	// Position of DRL0 field.
	SCT0_DMAREQ0_DRL0_Pos = 0x1e
	// Bit mask of DRL0 field.
	SCT0_DMAREQ0_DRL0_Msk = 0x40000000
	// Bit DRL0.
	SCT0_DMAREQ0_DRL0 = 0x40000000
	// Position of DRQ0 field.
	SCT0_DMAREQ0_DRQ0_Pos = 0x1f
	// Bit mask of DRQ0 field.
	SCT0_DMAREQ0_DRQ0_Msk = 0x80000000
	// Bit DRQ0.
	SCT0_DMAREQ0_DRQ0 = 0x80000000

	// DMAREQ1: SCT DMA request 1 register
	// Position of DEV_1 field.
	SCT0_DMAREQ1_DEV_1_Pos = 0x0
	// Bit mask of DEV_1 field.
	SCT0_DMAREQ1_DEV_1_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_DMAREQ1_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_DMAREQ1_RESERVED_Msk = 0x3fffffc0
	// Position of DRL1 field.
	SCT0_DMAREQ1_DRL1_Pos = 0x1e
	// Bit mask of DRL1 field.
	SCT0_DMAREQ1_DRL1_Msk = 0x40000000
	// Bit DRL1.
	SCT0_DMAREQ1_DRL1 = 0x40000000
	// Position of DRQ1 field.
	SCT0_DMAREQ1_DRQ1_Pos = 0x1f
	// Bit mask of DRQ1 field.
	SCT0_DMAREQ1_DRQ1_Msk = 0x80000000
	// Bit DRQ1.
	SCT0_DMAREQ1_DRQ1 = 0x80000000

	// EVEN: SCT event enable register
	// Position of IEN field.
	SCT0_EVEN_IEN_Pos = 0x0
	// Bit mask of IEN field.
	SCT0_EVEN_IEN_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_EVEN_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_EVEN_RESERVED_Msk = 0xffffffc0

	// EVFLAG: SCT event flag register
	// Position of FLAG field.
	SCT0_EVFLAG_FLAG_Pos = 0x0
	// Bit mask of FLAG field.
	SCT0_EVFLAG_FLAG_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_EVFLAG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_EVFLAG_RESERVED_Msk = 0xffffffc0

	// CONEN: SCT conflict enable register
	// Position of NCEN field.
	SCT0_CONEN_NCEN_Pos = 0x0
	// Bit mask of NCEN field.
	SCT0_CONEN_NCEN_Msk = 0xf
	// Position of RESERVED field.
	SCT0_CONEN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT0_CONEN_RESERVED_Msk = 0xfffffff0

	// CONFLAG: SCT conflict flag register
	// Position of NCFLAG field.
	SCT0_CONFLAG_NCFLAG_Pos = 0x0
	// Bit mask of NCFLAG field.
	SCT0_CONFLAG_NCFLAG_Msk = 0xf
	// Position of RESERVED field.
	SCT0_CONFLAG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT0_CONFLAG_RESERVED_Msk = 0x3ffffff0
	// Position of BUSERRL field.
	SCT0_CONFLAG_BUSERRL_Pos = 0x1e
	// Bit mask of BUSERRL field.
	SCT0_CONFLAG_BUSERRL_Msk = 0x40000000
	// Bit BUSERRL.
	SCT0_CONFLAG_BUSERRL = 0x40000000
	// Position of BUSERRH field.
	SCT0_CONFLAG_BUSERRH_Pos = 0x1f
	// Bit mask of BUSERRH field.
	SCT0_CONFLAG_BUSERRH_Msk = 0x80000000
	// Bit BUSERRH.
	SCT0_CONFLAG_BUSERRH = 0x80000000

	// MATCH0: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
	// Position of MATCHn_L field.
	SCT0_MATCH_MATCHn_L_Pos = 0x0
	// Bit mask of MATCHn_L field.
	SCT0_MATCH_MATCHn_L_Msk = 0xffff
	// Position of MATCHn_H field.
	SCT0_MATCH_MATCHn_H_Pos = 0x10
	// Bit mask of MATCHn_H field.
	SCT0_MATCH_MATCHn_H_Msk = 0xffff0000

	// CAP0: SCT capture register of capture channel 0 to 4; REGMOD0 to REGMODE4 = 1
	// Position of CAPn_L field.
	SCT0_CAP_CAPn_L_Pos = 0x0
	// Bit mask of CAPn_L field.
	SCT0_CAP_CAPn_L_Msk = 0xffff
	// Position of CAPn_H field.
	SCT0_CAP_CAPn_H_Pos = 0x10
	// Bit mask of CAPn_H field.
	SCT0_CAP_CAPn_H_Msk = 0xffff0000

	// MATCHREL0: SCT match reload value register 0 to 4; REGMOD0 = 0 to REGMODE4 = 0
	// Position of RELOADn_L field.
	SCT0_MATCHREL_RELOADn_L_Pos = 0x0
	// Bit mask of RELOADn_L field.
	SCT0_MATCHREL_RELOADn_L_Msk = 0xffff
	// Position of RELOADn_H field.
	SCT0_MATCHREL_RELOADn_H_Pos = 0x10
	// Bit mask of RELOADn_H field.
	SCT0_MATCHREL_RELOADn_H_Msk = 0xffff0000

	// CAPCTRL0: SCT capture control register 0 to 4; REGMOD0 = 1 to REGMODE4 = 1
	// Position of CAPCONn_L field.
	SCT0_CAPCTRL_CAPCONn_L_Pos = 0x0
	// Bit mask of CAPCONn_L field.
	SCT0_CAPCTRL_CAPCONn_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_CAPCTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_CAPCTRL_RESERVED_Msk = 0xffc0
	// Position of CAPCONn_H field.
	SCT0_CAPCTRL_CAPCONn_H_Pos = 0x10
	// Bit mask of CAPCONn_H field.
	SCT0_CAPCTRL_CAPCONn_H_Msk = 0x3f0000
	// Position of RESERVED field.
	SCT0_CAPCTRL_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SCT0_CAPCTRL_RESERVED_Msk = 0xffc00000

	// EV0_STATE: SCT event state register 0
	// Position of STATEMSKn field.
	SCT0_EV_STATE_STATEMSKn_Pos = 0x0
	// Bit mask of STATEMSKn field.
	SCT0_EV_STATE_STATEMSKn_Msk = 0xff
	// Position of RESERVED field.
	SCT0_EV_STATE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCT0_EV_STATE_RESERVED_Msk = 0xffffff00

	// EV0_CTRL: SCT event control register 0
	// Position of MATCHSEL field.
	SCT0_EV_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT0_EV_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT0_EV_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT0_EV_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT0_EV_CTRL_HEVENT = 0x10
	// Selects the L state and the L match register selected by MATCHSEL.
	SCT0_EV_CTRL_HEVENT_SELECTS_THE_L_STATE = 0x0
	// Selects the H state and the H match register selected by MATCHSEL.
	SCT0_EV_CTRL_HEVENT_SELECTS_THE_H_STATE = 0x1
	// Position of OUTSEL field.
	SCT0_EV_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT0_EV_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT0_EV_CTRL_OUTSEL = 0x20
	// Selects the inputs elected by IOSEL.
	SCT0_EV_CTRL_OUTSEL_SELECTS_THE_INPUTS_E = 0x0
	// Selects the outputs selected by IOSEL.
	SCT0_EV_CTRL_OUTSEL_SELECTS_THE_OUTPUTS = 0x1
	// Position of IOSEL field.
	SCT0_EV_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT0_EV_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT0_EV_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT0_EV_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT0_EV_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT0_EV_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT0_EV_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT0_EV_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT0_EV_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT0_EV_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT0_EV_CTRL_COMBMODE_OR = 0x0
	// MATCH. Uses the specified match only.
	SCT0_EV_CTRL_COMBMODE_MATCH = 0x1
	// IO. Uses the specified I/O condition only.
	SCT0_EV_CTRL_COMBMODE_IO = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT0_EV_CTRL_COMBMODE_AND = 0x3
	// Position of STATELD field.
	SCT0_EV_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT0_EV_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT0_EV_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT0_EV_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT0_EV_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT0_EV_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT0_EV_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT0_EV_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT0_EV_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT0_EV_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT0_EV_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT0_EV_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT0_EV_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT0_EV_CTRL_DIRECTION_COUNTING_UP = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT0_EV_CTRL_DIRECTION_COUNTING_DOWN = 0x2
	// Position of RESERVED field.
	SCT0_EV_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT0_EV_CTRL_RESERVED_Msk = 0xff800000

	// OUT0_SET: SCT output 0 set register
	// Position of SET field.
	SCT0_OUT_SET_SET_Pos = 0x0
	// Bit mask of SET field.
	SCT0_OUT_SET_SET_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_OUT_SET_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_OUT_SET_RESERVED_Msk = 0xffffffc0

	// OUT0_CLR: SCT output 0 clear register
	// Position of CLR field.
	SCT0_OUT_CLR_CLR_Pos = 0x0
	// Bit mask of CLR field.
	SCT0_OUT_CLR_CLR_Msk = 0x3f
	// Position of RESERVED field.
	SCT0_OUT_CLR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_OUT_CLR_RESERVED_Msk = 0xffffffc0
)

// Bitfields for GPIO_PORT: General Purpose I/O (GPIO)
const (
	// B: Byte pin registers
	// Position of PBYTE field.
	GPIO_B_PBYTE_Pos = 0x0
	// Bit mask of PBYTE field.
	GPIO_B_PBYTE_Msk = 0x1
	// Bit PBYTE.
	GPIO_B_PBYTE = 0x1

	// W: Word pin registers
	// Position of PWORD field.
	GPIO_W_PWORD_Pos = 0x0
	// Bit mask of PWORD field.
	GPIO_W_PWORD_Msk = 0xffffffff

	// DIR: Port Direction registers
	// Position of DIRP0 field.
	GPIO_DIR_DIRP0_Pos = 0x0
	// Bit mask of DIRP0 field.
	GPIO_DIR_DIRP0_Msk = 0x1
	// Bit DIRP0.
	GPIO_DIR_DIRP0 = 0x1
	// Position of DIRP1 field.
	GPIO_DIR_DIRP1_Pos = 0x1
	// Bit mask of DIRP1 field.
	GPIO_DIR_DIRP1_Msk = 0x2
	// Bit DIRP1.
	GPIO_DIR_DIRP1 = 0x2
	// Position of DIRP2 field.
	GPIO_DIR_DIRP2_Pos = 0x2
	// Bit mask of DIRP2 field.
	GPIO_DIR_DIRP2_Msk = 0x4
	// Bit DIRP2.
	GPIO_DIR_DIRP2 = 0x4
	// Position of DIRP3 field.
	GPIO_DIR_DIRP3_Pos = 0x3
	// Bit mask of DIRP3 field.
	GPIO_DIR_DIRP3_Msk = 0x8
	// Bit DIRP3.
	GPIO_DIR_DIRP3 = 0x8
	// Position of DIRP4 field.
	GPIO_DIR_DIRP4_Pos = 0x4
	// Bit mask of DIRP4 field.
	GPIO_DIR_DIRP4_Msk = 0x10
	// Bit DIRP4.
	GPIO_DIR_DIRP4 = 0x10
	// Position of DIRP5 field.
	GPIO_DIR_DIRP5_Pos = 0x5
	// Bit mask of DIRP5 field.
	GPIO_DIR_DIRP5_Msk = 0x20
	// Bit DIRP5.
	GPIO_DIR_DIRP5 = 0x20
	// Position of DIRP6 field.
	GPIO_DIR_DIRP6_Pos = 0x6
	// Bit mask of DIRP6 field.
	GPIO_DIR_DIRP6_Msk = 0x40
	// Bit DIRP6.
	GPIO_DIR_DIRP6 = 0x40
	// Position of DIRP7 field.
	GPIO_DIR_DIRP7_Pos = 0x7
	// Bit mask of DIRP7 field.
	GPIO_DIR_DIRP7_Msk = 0x80
	// Bit DIRP7.
	GPIO_DIR_DIRP7 = 0x80
	// Position of DIRP8 field.
	GPIO_DIR_DIRP8_Pos = 0x8
	// Bit mask of DIRP8 field.
	GPIO_DIR_DIRP8_Msk = 0x100
	// Bit DIRP8.
	GPIO_DIR_DIRP8 = 0x100
	// Position of DIRP9 field.
	GPIO_DIR_DIRP9_Pos = 0x9
	// Bit mask of DIRP9 field.
	GPIO_DIR_DIRP9_Msk = 0x200
	// Bit DIRP9.
	GPIO_DIR_DIRP9 = 0x200
	// Position of DIRP10 field.
	GPIO_DIR_DIRP10_Pos = 0xa
	// Bit mask of DIRP10 field.
	GPIO_DIR_DIRP10_Msk = 0x400
	// Bit DIRP10.
	GPIO_DIR_DIRP10 = 0x400
	// Position of DIRP11 field.
	GPIO_DIR_DIRP11_Pos = 0xb
	// Bit mask of DIRP11 field.
	GPIO_DIR_DIRP11_Msk = 0x800
	// Bit DIRP11.
	GPIO_DIR_DIRP11 = 0x800
	// Position of DIRP12 field.
	GPIO_DIR_DIRP12_Pos = 0xc
	// Bit mask of DIRP12 field.
	GPIO_DIR_DIRP12_Msk = 0x1000
	// Bit DIRP12.
	GPIO_DIR_DIRP12 = 0x1000
	// Position of DIRP13 field.
	GPIO_DIR_DIRP13_Pos = 0xd
	// Bit mask of DIRP13 field.
	GPIO_DIR_DIRP13_Msk = 0x2000
	// Bit DIRP13.
	GPIO_DIR_DIRP13 = 0x2000
	// Position of DIRP14 field.
	GPIO_DIR_DIRP14_Pos = 0xe
	// Bit mask of DIRP14 field.
	GPIO_DIR_DIRP14_Msk = 0x4000
	// Bit DIRP14.
	GPIO_DIR_DIRP14 = 0x4000
	// Position of DIRP15 field.
	GPIO_DIR_DIRP15_Pos = 0xf
	// Bit mask of DIRP15 field.
	GPIO_DIR_DIRP15_Msk = 0x8000
	// Bit DIRP15.
	GPIO_DIR_DIRP15 = 0x8000
	// Position of DIRP16 field.
	GPIO_DIR_DIRP16_Pos = 0x10
	// Bit mask of DIRP16 field.
	GPIO_DIR_DIRP16_Msk = 0x10000
	// Bit DIRP16.
	GPIO_DIR_DIRP16 = 0x10000
	// Position of DIRP17 field.
	GPIO_DIR_DIRP17_Pos = 0x11
	// Bit mask of DIRP17 field.
	GPIO_DIR_DIRP17_Msk = 0x20000
	// Bit DIRP17.
	GPIO_DIR_DIRP17 = 0x20000
	// Position of DIRP18 field.
	GPIO_DIR_DIRP18_Pos = 0x12
	// Bit mask of DIRP18 field.
	GPIO_DIR_DIRP18_Msk = 0x40000
	// Bit DIRP18.
	GPIO_DIR_DIRP18 = 0x40000
	// Position of DIRP19 field.
	GPIO_DIR_DIRP19_Pos = 0x13
	// Bit mask of DIRP19 field.
	GPIO_DIR_DIRP19_Msk = 0x80000
	// Bit DIRP19.
	GPIO_DIR_DIRP19 = 0x80000
	// Position of DIRP20 field.
	GPIO_DIR_DIRP20_Pos = 0x14
	// Bit mask of DIRP20 field.
	GPIO_DIR_DIRP20_Msk = 0x100000
	// Bit DIRP20.
	GPIO_DIR_DIRP20 = 0x100000
	// Position of DIRP21 field.
	GPIO_DIR_DIRP21_Pos = 0x15
	// Bit mask of DIRP21 field.
	GPIO_DIR_DIRP21_Msk = 0x200000
	// Bit DIRP21.
	GPIO_DIR_DIRP21 = 0x200000
	// Position of DIRP22 field.
	GPIO_DIR_DIRP22_Pos = 0x16
	// Bit mask of DIRP22 field.
	GPIO_DIR_DIRP22_Msk = 0x400000
	// Bit DIRP22.
	GPIO_DIR_DIRP22 = 0x400000
	// Position of DIRP23 field.
	GPIO_DIR_DIRP23_Pos = 0x17
	// Bit mask of DIRP23 field.
	GPIO_DIR_DIRP23_Msk = 0x800000
	// Bit DIRP23.
	GPIO_DIR_DIRP23 = 0x800000
	// Position of DIRP24 field.
	GPIO_DIR_DIRP24_Pos = 0x18
	// Bit mask of DIRP24 field.
	GPIO_DIR_DIRP24_Msk = 0x1000000
	// Bit DIRP24.
	GPIO_DIR_DIRP24 = 0x1000000
	// Position of DIRP25 field.
	GPIO_DIR_DIRP25_Pos = 0x19
	// Bit mask of DIRP25 field.
	GPIO_DIR_DIRP25_Msk = 0x2000000
	// Bit DIRP25.
	GPIO_DIR_DIRP25 = 0x2000000
	// Position of DIRP26 field.
	GPIO_DIR_DIRP26_Pos = 0x1a
	// Bit mask of DIRP26 field.
	GPIO_DIR_DIRP26_Msk = 0x4000000
	// Bit DIRP26.
	GPIO_DIR_DIRP26 = 0x4000000
	// Position of DIRP27 field.
	GPIO_DIR_DIRP27_Pos = 0x1b
	// Bit mask of DIRP27 field.
	GPIO_DIR_DIRP27_Msk = 0x8000000
	// Bit DIRP27.
	GPIO_DIR_DIRP27 = 0x8000000
	// Position of DIRP28 field.
	GPIO_DIR_DIRP28_Pos = 0x1c
	// Bit mask of DIRP28 field.
	GPIO_DIR_DIRP28_Msk = 0x10000000
	// Bit DIRP28.
	GPIO_DIR_DIRP28 = 0x10000000
	// Position of DIRP29 field.
	GPIO_DIR_DIRP29_Pos = 0x1d
	// Bit mask of DIRP29 field.
	GPIO_DIR_DIRP29_Msk = 0x20000000
	// Bit DIRP29.
	GPIO_DIR_DIRP29 = 0x20000000
	// Position of DIRP30 field.
	GPIO_DIR_DIRP30_Pos = 0x1e
	// Bit mask of DIRP30 field.
	GPIO_DIR_DIRP30_Msk = 0x40000000
	// Bit DIRP30.
	GPIO_DIR_DIRP30 = 0x40000000
	// Position of DIRP31 field.
	GPIO_DIR_DIRP31_Pos = 0x1f
	// Bit mask of DIRP31 field.
	GPIO_DIR_DIRP31_Msk = 0x80000000
	// Bit DIRP31.
	GPIO_DIR_DIRP31 = 0x80000000

	// MASK: Port Mask register
	// Position of MASKP0 field.
	GPIO_MASK_MASKP0_Pos = 0x0
	// Bit mask of MASKP0 field.
	GPIO_MASK_MASKP0_Msk = 0x1
	// Bit MASKP0.
	GPIO_MASK_MASKP0 = 0x1
	// Position of MASKP1 field.
	GPIO_MASK_MASKP1_Pos = 0x1
	// Bit mask of MASKP1 field.
	GPIO_MASK_MASKP1_Msk = 0x2
	// Bit MASKP1.
	GPIO_MASK_MASKP1 = 0x2
	// Position of MASKP2 field.
	GPIO_MASK_MASKP2_Pos = 0x2
	// Bit mask of MASKP2 field.
	GPIO_MASK_MASKP2_Msk = 0x4
	// Bit MASKP2.
	GPIO_MASK_MASKP2 = 0x4
	// Position of MASKP3 field.
	GPIO_MASK_MASKP3_Pos = 0x3
	// Bit mask of MASKP3 field.
	GPIO_MASK_MASKP3_Msk = 0x8
	// Bit MASKP3.
	GPIO_MASK_MASKP3 = 0x8
	// Position of MASKP4 field.
	GPIO_MASK_MASKP4_Pos = 0x4
	// Bit mask of MASKP4 field.
	GPIO_MASK_MASKP4_Msk = 0x10
	// Bit MASKP4.
	GPIO_MASK_MASKP4 = 0x10
	// Position of MASKP5 field.
	GPIO_MASK_MASKP5_Pos = 0x5
	// Bit mask of MASKP5 field.
	GPIO_MASK_MASKP5_Msk = 0x20
	// Bit MASKP5.
	GPIO_MASK_MASKP5 = 0x20
	// Position of MASKP6 field.
	GPIO_MASK_MASKP6_Pos = 0x6
	// Bit mask of MASKP6 field.
	GPIO_MASK_MASKP6_Msk = 0x40
	// Bit MASKP6.
	GPIO_MASK_MASKP6 = 0x40
	// Position of MASKP7 field.
	GPIO_MASK_MASKP7_Pos = 0x7
	// Bit mask of MASKP7 field.
	GPIO_MASK_MASKP7_Msk = 0x80
	// Bit MASKP7.
	GPIO_MASK_MASKP7 = 0x80
	// Position of MASKP8 field.
	GPIO_MASK_MASKP8_Pos = 0x8
	// Bit mask of MASKP8 field.
	GPIO_MASK_MASKP8_Msk = 0x100
	// Bit MASKP8.
	GPIO_MASK_MASKP8 = 0x100
	// Position of MASKP9 field.
	GPIO_MASK_MASKP9_Pos = 0x9
	// Bit mask of MASKP9 field.
	GPIO_MASK_MASKP9_Msk = 0x200
	// Bit MASKP9.
	GPIO_MASK_MASKP9 = 0x200
	// Position of MASKP10 field.
	GPIO_MASK_MASKP10_Pos = 0xa
	// Bit mask of MASKP10 field.
	GPIO_MASK_MASKP10_Msk = 0x400
	// Bit MASKP10.
	GPIO_MASK_MASKP10 = 0x400
	// Position of MASKP11 field.
	GPIO_MASK_MASKP11_Pos = 0xb
	// Bit mask of MASKP11 field.
	GPIO_MASK_MASKP11_Msk = 0x800
	// Bit MASKP11.
	GPIO_MASK_MASKP11 = 0x800
	// Position of MASKP12 field.
	GPIO_MASK_MASKP12_Pos = 0xc
	// Bit mask of MASKP12 field.
	GPIO_MASK_MASKP12_Msk = 0x1000
	// Bit MASKP12.
	GPIO_MASK_MASKP12 = 0x1000
	// Position of MASKP13 field.
	GPIO_MASK_MASKP13_Pos = 0xd
	// Bit mask of MASKP13 field.
	GPIO_MASK_MASKP13_Msk = 0x2000
	// Bit MASKP13.
	GPIO_MASK_MASKP13 = 0x2000
	// Position of MASKP14 field.
	GPIO_MASK_MASKP14_Pos = 0xe
	// Bit mask of MASKP14 field.
	GPIO_MASK_MASKP14_Msk = 0x4000
	// Bit MASKP14.
	GPIO_MASK_MASKP14 = 0x4000
	// Position of MASKP15 field.
	GPIO_MASK_MASKP15_Pos = 0xf
	// Bit mask of MASKP15 field.
	GPIO_MASK_MASKP15_Msk = 0x8000
	// Bit MASKP15.
	GPIO_MASK_MASKP15 = 0x8000
	// Position of MASKP16 field.
	GPIO_MASK_MASKP16_Pos = 0x10
	// Bit mask of MASKP16 field.
	GPIO_MASK_MASKP16_Msk = 0x10000
	// Bit MASKP16.
	GPIO_MASK_MASKP16 = 0x10000
	// Position of MASKP17 field.
	GPIO_MASK_MASKP17_Pos = 0x11
	// Bit mask of MASKP17 field.
	GPIO_MASK_MASKP17_Msk = 0x20000
	// Bit MASKP17.
	GPIO_MASK_MASKP17 = 0x20000
	// Position of MASKP18 field.
	GPIO_MASK_MASKP18_Pos = 0x12
	// Bit mask of MASKP18 field.
	GPIO_MASK_MASKP18_Msk = 0x40000
	// Bit MASKP18.
	GPIO_MASK_MASKP18 = 0x40000
	// Position of MASKP19 field.
	GPIO_MASK_MASKP19_Pos = 0x13
	// Bit mask of MASKP19 field.
	GPIO_MASK_MASKP19_Msk = 0x80000
	// Bit MASKP19.
	GPIO_MASK_MASKP19 = 0x80000
	// Position of MASKP20 field.
	GPIO_MASK_MASKP20_Pos = 0x14
	// Bit mask of MASKP20 field.
	GPIO_MASK_MASKP20_Msk = 0x100000
	// Bit MASKP20.
	GPIO_MASK_MASKP20 = 0x100000
	// Position of MASKP21 field.
	GPIO_MASK_MASKP21_Pos = 0x15
	// Bit mask of MASKP21 field.
	GPIO_MASK_MASKP21_Msk = 0x200000
	// Bit MASKP21.
	GPIO_MASK_MASKP21 = 0x200000
	// Position of MASKP22 field.
	GPIO_MASK_MASKP22_Pos = 0x16
	// Bit mask of MASKP22 field.
	GPIO_MASK_MASKP22_Msk = 0x400000
	// Bit MASKP22.
	GPIO_MASK_MASKP22 = 0x400000
	// Position of MASKP23 field.
	GPIO_MASK_MASKP23_Pos = 0x17
	// Bit mask of MASKP23 field.
	GPIO_MASK_MASKP23_Msk = 0x800000
	// Bit MASKP23.
	GPIO_MASK_MASKP23 = 0x800000
	// Position of MASKP24 field.
	GPIO_MASK_MASKP24_Pos = 0x18
	// Bit mask of MASKP24 field.
	GPIO_MASK_MASKP24_Msk = 0x1000000
	// Bit MASKP24.
	GPIO_MASK_MASKP24 = 0x1000000
	// Position of MASKP25 field.
	GPIO_MASK_MASKP25_Pos = 0x19
	// Bit mask of MASKP25 field.
	GPIO_MASK_MASKP25_Msk = 0x2000000
	// Bit MASKP25.
	GPIO_MASK_MASKP25 = 0x2000000
	// Position of MASKP26 field.
	GPIO_MASK_MASKP26_Pos = 0x1a
	// Bit mask of MASKP26 field.
	GPIO_MASK_MASKP26_Msk = 0x4000000
	// Bit MASKP26.
	GPIO_MASK_MASKP26 = 0x4000000
	// Position of MASKP27 field.
	GPIO_MASK_MASKP27_Pos = 0x1b
	// Bit mask of MASKP27 field.
	GPIO_MASK_MASKP27_Msk = 0x8000000
	// Bit MASKP27.
	GPIO_MASK_MASKP27 = 0x8000000
	// Position of MASKP28 field.
	GPIO_MASK_MASKP28_Pos = 0x1c
	// Bit mask of MASKP28 field.
	GPIO_MASK_MASKP28_Msk = 0x10000000
	// Bit MASKP28.
	GPIO_MASK_MASKP28 = 0x10000000
	// Position of MASKP29 field.
	GPIO_MASK_MASKP29_Pos = 0x1d
	// Bit mask of MASKP29 field.
	GPIO_MASK_MASKP29_Msk = 0x20000000
	// Bit MASKP29.
	GPIO_MASK_MASKP29 = 0x20000000
	// Position of MASKP30 field.
	GPIO_MASK_MASKP30_Pos = 0x1e
	// Bit mask of MASKP30 field.
	GPIO_MASK_MASKP30_Msk = 0x40000000
	// Bit MASKP30.
	GPIO_MASK_MASKP30 = 0x40000000
	// Position of MASKP31 field.
	GPIO_MASK_MASKP31_Pos = 0x1f
	// Bit mask of MASKP31 field.
	GPIO_MASK_MASKP31_Msk = 0x80000000
	// Bit MASKP31.
	GPIO_MASK_MASKP31 = 0x80000000

	// PIN: Port pin register
	// Position of PORT0 field.
	GPIO_PIN_PORT0_Pos = 0x0
	// Bit mask of PORT0 field.
	GPIO_PIN_PORT0_Msk = 0x1
	// Bit PORT0.
	GPIO_PIN_PORT0 = 0x1
	// Position of PORT1 field.
	GPIO_PIN_PORT1_Pos = 0x1
	// Bit mask of PORT1 field.
	GPIO_PIN_PORT1_Msk = 0x2
	// Bit PORT1.
	GPIO_PIN_PORT1 = 0x2
	// Position of PORT2 field.
	GPIO_PIN_PORT2_Pos = 0x2
	// Bit mask of PORT2 field.
	GPIO_PIN_PORT2_Msk = 0x4
	// Bit PORT2.
	GPIO_PIN_PORT2 = 0x4
	// Position of PORT3 field.
	GPIO_PIN_PORT3_Pos = 0x3
	// Bit mask of PORT3 field.
	GPIO_PIN_PORT3_Msk = 0x8
	// Bit PORT3.
	GPIO_PIN_PORT3 = 0x8
	// Position of PORT4 field.
	GPIO_PIN_PORT4_Pos = 0x4
	// Bit mask of PORT4 field.
	GPIO_PIN_PORT4_Msk = 0x10
	// Bit PORT4.
	GPIO_PIN_PORT4 = 0x10
	// Position of PORT5 field.
	GPIO_PIN_PORT5_Pos = 0x5
	// Bit mask of PORT5 field.
	GPIO_PIN_PORT5_Msk = 0x20
	// Bit PORT5.
	GPIO_PIN_PORT5 = 0x20
	// Position of PORT6 field.
	GPIO_PIN_PORT6_Pos = 0x6
	// Bit mask of PORT6 field.
	GPIO_PIN_PORT6_Msk = 0x40
	// Bit PORT6.
	GPIO_PIN_PORT6 = 0x40
	// Position of PORT7 field.
	GPIO_PIN_PORT7_Pos = 0x7
	// Bit mask of PORT7 field.
	GPIO_PIN_PORT7_Msk = 0x80
	// Bit PORT7.
	GPIO_PIN_PORT7 = 0x80
	// Position of PORT8 field.
	GPIO_PIN_PORT8_Pos = 0x8
	// Bit mask of PORT8 field.
	GPIO_PIN_PORT8_Msk = 0x100
	// Bit PORT8.
	GPIO_PIN_PORT8 = 0x100
	// Position of PORT9 field.
	GPIO_PIN_PORT9_Pos = 0x9
	// Bit mask of PORT9 field.
	GPIO_PIN_PORT9_Msk = 0x200
	// Bit PORT9.
	GPIO_PIN_PORT9 = 0x200
	// Position of PORT10 field.
	GPIO_PIN_PORT10_Pos = 0xa
	// Bit mask of PORT10 field.
	GPIO_PIN_PORT10_Msk = 0x400
	// Bit PORT10.
	GPIO_PIN_PORT10 = 0x400
	// Position of PORT11 field.
	GPIO_PIN_PORT11_Pos = 0xb
	// Bit mask of PORT11 field.
	GPIO_PIN_PORT11_Msk = 0x800
	// Bit PORT11.
	GPIO_PIN_PORT11 = 0x800
	// Position of PORT12 field.
	GPIO_PIN_PORT12_Pos = 0xc
	// Bit mask of PORT12 field.
	GPIO_PIN_PORT12_Msk = 0x1000
	// Bit PORT12.
	GPIO_PIN_PORT12 = 0x1000
	// Position of PORT13 field.
	GPIO_PIN_PORT13_Pos = 0xd
	// Bit mask of PORT13 field.
	GPIO_PIN_PORT13_Msk = 0x2000
	// Bit PORT13.
	GPIO_PIN_PORT13 = 0x2000
	// Position of PORT14 field.
	GPIO_PIN_PORT14_Pos = 0xe
	// Bit mask of PORT14 field.
	GPIO_PIN_PORT14_Msk = 0x4000
	// Bit PORT14.
	GPIO_PIN_PORT14 = 0x4000
	// Position of PORT15 field.
	GPIO_PIN_PORT15_Pos = 0xf
	// Bit mask of PORT15 field.
	GPIO_PIN_PORT15_Msk = 0x8000
	// Bit PORT15.
	GPIO_PIN_PORT15 = 0x8000
	// Position of PORT16 field.
	GPIO_PIN_PORT16_Pos = 0x10
	// Bit mask of PORT16 field.
	GPIO_PIN_PORT16_Msk = 0x10000
	// Bit PORT16.
	GPIO_PIN_PORT16 = 0x10000
	// Position of PORT17 field.
	GPIO_PIN_PORT17_Pos = 0x11
	// Bit mask of PORT17 field.
	GPIO_PIN_PORT17_Msk = 0x20000
	// Bit PORT17.
	GPIO_PIN_PORT17 = 0x20000
	// Position of PORT18 field.
	GPIO_PIN_PORT18_Pos = 0x12
	// Bit mask of PORT18 field.
	GPIO_PIN_PORT18_Msk = 0x40000
	// Bit PORT18.
	GPIO_PIN_PORT18 = 0x40000
	// Position of PORT19 field.
	GPIO_PIN_PORT19_Pos = 0x13
	// Bit mask of PORT19 field.
	GPIO_PIN_PORT19_Msk = 0x80000
	// Bit PORT19.
	GPIO_PIN_PORT19 = 0x80000
	// Position of PORT20 field.
	GPIO_PIN_PORT20_Pos = 0x14
	// Bit mask of PORT20 field.
	GPIO_PIN_PORT20_Msk = 0x100000
	// Bit PORT20.
	GPIO_PIN_PORT20 = 0x100000
	// Position of PORT21 field.
	GPIO_PIN_PORT21_Pos = 0x15
	// Bit mask of PORT21 field.
	GPIO_PIN_PORT21_Msk = 0x200000
	// Bit PORT21.
	GPIO_PIN_PORT21 = 0x200000
	// Position of PORT22 field.
	GPIO_PIN_PORT22_Pos = 0x16
	// Bit mask of PORT22 field.
	GPIO_PIN_PORT22_Msk = 0x400000
	// Bit PORT22.
	GPIO_PIN_PORT22 = 0x400000
	// Position of PORT23 field.
	GPIO_PIN_PORT23_Pos = 0x17
	// Bit mask of PORT23 field.
	GPIO_PIN_PORT23_Msk = 0x800000
	// Bit PORT23.
	GPIO_PIN_PORT23 = 0x800000
	// Position of PORT24 field.
	GPIO_PIN_PORT24_Pos = 0x18
	// Bit mask of PORT24 field.
	GPIO_PIN_PORT24_Msk = 0x1000000
	// Bit PORT24.
	GPIO_PIN_PORT24 = 0x1000000
	// Position of PORT25 field.
	GPIO_PIN_PORT25_Pos = 0x19
	// Bit mask of PORT25 field.
	GPIO_PIN_PORT25_Msk = 0x2000000
	// Bit PORT25.
	GPIO_PIN_PORT25 = 0x2000000
	// Position of PORT26 field.
	GPIO_PIN_PORT26_Pos = 0x1a
	// Bit mask of PORT26 field.
	GPIO_PIN_PORT26_Msk = 0x4000000
	// Bit PORT26.
	GPIO_PIN_PORT26 = 0x4000000
	// Position of PORT27 field.
	GPIO_PIN_PORT27_Pos = 0x1b
	// Bit mask of PORT27 field.
	GPIO_PIN_PORT27_Msk = 0x8000000
	// Bit PORT27.
	GPIO_PIN_PORT27 = 0x8000000
	// Position of PORT28 field.
	GPIO_PIN_PORT28_Pos = 0x1c
	// Bit mask of PORT28 field.
	GPIO_PIN_PORT28_Msk = 0x10000000
	// Bit PORT28.
	GPIO_PIN_PORT28 = 0x10000000
	// Position of PORT29 field.
	GPIO_PIN_PORT29_Pos = 0x1d
	// Bit mask of PORT29 field.
	GPIO_PIN_PORT29_Msk = 0x20000000
	// Bit PORT29.
	GPIO_PIN_PORT29 = 0x20000000
	// Position of PORT30 field.
	GPIO_PIN_PORT30_Pos = 0x1e
	// Bit mask of PORT30 field.
	GPIO_PIN_PORT30_Msk = 0x40000000
	// Bit PORT30.
	GPIO_PIN_PORT30 = 0x40000000
	// Position of PORT31 field.
	GPIO_PIN_PORT31_Pos = 0x1f
	// Bit mask of PORT31 field.
	GPIO_PIN_PORT31_Msk = 0x80000000
	// Bit PORT31.
	GPIO_PIN_PORT31 = 0x80000000

	// MPIN: Masked port register
	// Position of MPORTP0 field.
	GPIO_MPIN_MPORTP0_Pos = 0x0
	// Bit mask of MPORTP0 field.
	GPIO_MPIN_MPORTP0_Msk = 0x1
	// Bit MPORTP0.
	GPIO_MPIN_MPORTP0 = 0x1
	// Position of MPORTP1 field.
	GPIO_MPIN_MPORTP1_Pos = 0x1
	// Bit mask of MPORTP1 field.
	GPIO_MPIN_MPORTP1_Msk = 0x2
	// Bit MPORTP1.
	GPIO_MPIN_MPORTP1 = 0x2
	// Position of MPORTP2 field.
	GPIO_MPIN_MPORTP2_Pos = 0x2
	// Bit mask of MPORTP2 field.
	GPIO_MPIN_MPORTP2_Msk = 0x4
	// Bit MPORTP2.
	GPIO_MPIN_MPORTP2 = 0x4
	// Position of MPORTP3 field.
	GPIO_MPIN_MPORTP3_Pos = 0x3
	// Bit mask of MPORTP3 field.
	GPIO_MPIN_MPORTP3_Msk = 0x8
	// Bit MPORTP3.
	GPIO_MPIN_MPORTP3 = 0x8
	// Position of MPORTP4 field.
	GPIO_MPIN_MPORTP4_Pos = 0x4
	// Bit mask of MPORTP4 field.
	GPIO_MPIN_MPORTP4_Msk = 0x10
	// Bit MPORTP4.
	GPIO_MPIN_MPORTP4 = 0x10
	// Position of MPORTP5 field.
	GPIO_MPIN_MPORTP5_Pos = 0x5
	// Bit mask of MPORTP5 field.
	GPIO_MPIN_MPORTP5_Msk = 0x20
	// Bit MPORTP5.
	GPIO_MPIN_MPORTP5 = 0x20
	// Position of MPORTP6 field.
	GPIO_MPIN_MPORTP6_Pos = 0x6
	// Bit mask of MPORTP6 field.
	GPIO_MPIN_MPORTP6_Msk = 0x40
	// Bit MPORTP6.
	GPIO_MPIN_MPORTP6 = 0x40
	// Position of MPORTP7 field.
	GPIO_MPIN_MPORTP7_Pos = 0x7
	// Bit mask of MPORTP7 field.
	GPIO_MPIN_MPORTP7_Msk = 0x80
	// Bit MPORTP7.
	GPIO_MPIN_MPORTP7 = 0x80
	// Position of MPORTP8 field.
	GPIO_MPIN_MPORTP8_Pos = 0x8
	// Bit mask of MPORTP8 field.
	GPIO_MPIN_MPORTP8_Msk = 0x100
	// Bit MPORTP8.
	GPIO_MPIN_MPORTP8 = 0x100
	// Position of MPORTP9 field.
	GPIO_MPIN_MPORTP9_Pos = 0x9
	// Bit mask of MPORTP9 field.
	GPIO_MPIN_MPORTP9_Msk = 0x200
	// Bit MPORTP9.
	GPIO_MPIN_MPORTP9 = 0x200
	// Position of MPORTP10 field.
	GPIO_MPIN_MPORTP10_Pos = 0xa
	// Bit mask of MPORTP10 field.
	GPIO_MPIN_MPORTP10_Msk = 0x400
	// Bit MPORTP10.
	GPIO_MPIN_MPORTP10 = 0x400
	// Position of MPORTP11 field.
	GPIO_MPIN_MPORTP11_Pos = 0xb
	// Bit mask of MPORTP11 field.
	GPIO_MPIN_MPORTP11_Msk = 0x800
	// Bit MPORTP11.
	GPIO_MPIN_MPORTP11 = 0x800
	// Position of MPORTP12 field.
	GPIO_MPIN_MPORTP12_Pos = 0xc
	// Bit mask of MPORTP12 field.
	GPIO_MPIN_MPORTP12_Msk = 0x1000
	// Bit MPORTP12.
	GPIO_MPIN_MPORTP12 = 0x1000
	// Position of MPORTP13 field.
	GPIO_MPIN_MPORTP13_Pos = 0xd
	// Bit mask of MPORTP13 field.
	GPIO_MPIN_MPORTP13_Msk = 0x2000
	// Bit MPORTP13.
	GPIO_MPIN_MPORTP13 = 0x2000
	// Position of MPORTP14 field.
	GPIO_MPIN_MPORTP14_Pos = 0xe
	// Bit mask of MPORTP14 field.
	GPIO_MPIN_MPORTP14_Msk = 0x4000
	// Bit MPORTP14.
	GPIO_MPIN_MPORTP14 = 0x4000
	// Position of MPORTP15 field.
	GPIO_MPIN_MPORTP15_Pos = 0xf
	// Bit mask of MPORTP15 field.
	GPIO_MPIN_MPORTP15_Msk = 0x8000
	// Bit MPORTP15.
	GPIO_MPIN_MPORTP15 = 0x8000
	// Position of MPORTP16 field.
	GPIO_MPIN_MPORTP16_Pos = 0x10
	// Bit mask of MPORTP16 field.
	GPIO_MPIN_MPORTP16_Msk = 0x10000
	// Bit MPORTP16.
	GPIO_MPIN_MPORTP16 = 0x10000
	// Position of MPORTP17 field.
	GPIO_MPIN_MPORTP17_Pos = 0x11
	// Bit mask of MPORTP17 field.
	GPIO_MPIN_MPORTP17_Msk = 0x20000
	// Bit MPORTP17.
	GPIO_MPIN_MPORTP17 = 0x20000
	// Position of MPORTP18 field.
	GPIO_MPIN_MPORTP18_Pos = 0x12
	// Bit mask of MPORTP18 field.
	GPIO_MPIN_MPORTP18_Msk = 0x40000
	// Bit MPORTP18.
	GPIO_MPIN_MPORTP18 = 0x40000
	// Position of MPORTP19 field.
	GPIO_MPIN_MPORTP19_Pos = 0x13
	// Bit mask of MPORTP19 field.
	GPIO_MPIN_MPORTP19_Msk = 0x80000
	// Bit MPORTP19.
	GPIO_MPIN_MPORTP19 = 0x80000
	// Position of MPORTP20 field.
	GPIO_MPIN_MPORTP20_Pos = 0x14
	// Bit mask of MPORTP20 field.
	GPIO_MPIN_MPORTP20_Msk = 0x100000
	// Bit MPORTP20.
	GPIO_MPIN_MPORTP20 = 0x100000
	// Position of MPORTP21 field.
	GPIO_MPIN_MPORTP21_Pos = 0x15
	// Bit mask of MPORTP21 field.
	GPIO_MPIN_MPORTP21_Msk = 0x200000
	// Bit MPORTP21.
	GPIO_MPIN_MPORTP21 = 0x200000
	// Position of MPORTP22 field.
	GPIO_MPIN_MPORTP22_Pos = 0x16
	// Bit mask of MPORTP22 field.
	GPIO_MPIN_MPORTP22_Msk = 0x400000
	// Bit MPORTP22.
	GPIO_MPIN_MPORTP22 = 0x400000
	// Position of MPORTP23 field.
	GPIO_MPIN_MPORTP23_Pos = 0x17
	// Bit mask of MPORTP23 field.
	GPIO_MPIN_MPORTP23_Msk = 0x800000
	// Bit MPORTP23.
	GPIO_MPIN_MPORTP23 = 0x800000
	// Position of MPORTP24 field.
	GPIO_MPIN_MPORTP24_Pos = 0x18
	// Bit mask of MPORTP24 field.
	GPIO_MPIN_MPORTP24_Msk = 0x1000000
	// Bit MPORTP24.
	GPIO_MPIN_MPORTP24 = 0x1000000
	// Position of MPORTP25 field.
	GPIO_MPIN_MPORTP25_Pos = 0x19
	// Bit mask of MPORTP25 field.
	GPIO_MPIN_MPORTP25_Msk = 0x2000000
	// Bit MPORTP25.
	GPIO_MPIN_MPORTP25 = 0x2000000
	// Position of MPORTP26 field.
	GPIO_MPIN_MPORTP26_Pos = 0x1a
	// Bit mask of MPORTP26 field.
	GPIO_MPIN_MPORTP26_Msk = 0x4000000
	// Bit MPORTP26.
	GPIO_MPIN_MPORTP26 = 0x4000000
	// Position of MPORTP27 field.
	GPIO_MPIN_MPORTP27_Pos = 0x1b
	// Bit mask of MPORTP27 field.
	GPIO_MPIN_MPORTP27_Msk = 0x8000000
	// Bit MPORTP27.
	GPIO_MPIN_MPORTP27 = 0x8000000
	// Position of MPORTP28 field.
	GPIO_MPIN_MPORTP28_Pos = 0x1c
	// Bit mask of MPORTP28 field.
	GPIO_MPIN_MPORTP28_Msk = 0x10000000
	// Bit MPORTP28.
	GPIO_MPIN_MPORTP28 = 0x10000000
	// Position of MPORTP29 field.
	GPIO_MPIN_MPORTP29_Pos = 0x1d
	// Bit mask of MPORTP29 field.
	GPIO_MPIN_MPORTP29_Msk = 0x20000000
	// Bit MPORTP29.
	GPIO_MPIN_MPORTP29 = 0x20000000
	// Position of MPORTP30 field.
	GPIO_MPIN_MPORTP30_Pos = 0x1e
	// Bit mask of MPORTP30 field.
	GPIO_MPIN_MPORTP30_Msk = 0x40000000
	// Bit MPORTP30.
	GPIO_MPIN_MPORTP30 = 0x40000000
	// Position of MPORTP31 field.
	GPIO_MPIN_MPORTP31_Pos = 0x1f
	// Bit mask of MPORTP31 field.
	GPIO_MPIN_MPORTP31_Msk = 0x80000000
	// Bit MPORTP31.
	GPIO_MPIN_MPORTP31 = 0x80000000

	// SET: Write: Set port register Read: port output bits
	// Position of SETP00 field.
	GPIO_SET_SETP00_Pos = 0x0
	// Bit mask of SETP00 field.
	GPIO_SET_SETP00_Msk = 0x1
	// Bit SETP00.
	GPIO_SET_SETP00 = 0x1
	// Position of SETP01 field.
	GPIO_SET_SETP01_Pos = 0x1
	// Bit mask of SETP01 field.
	GPIO_SET_SETP01_Msk = 0x2
	// Bit SETP01.
	GPIO_SET_SETP01 = 0x2
	// Position of SETP02 field.
	GPIO_SET_SETP02_Pos = 0x2
	// Bit mask of SETP02 field.
	GPIO_SET_SETP02_Msk = 0x4
	// Bit SETP02.
	GPIO_SET_SETP02 = 0x4
	// Position of SETP03 field.
	GPIO_SET_SETP03_Pos = 0x3
	// Bit mask of SETP03 field.
	GPIO_SET_SETP03_Msk = 0x8
	// Bit SETP03.
	GPIO_SET_SETP03 = 0x8
	// Position of SETP04 field.
	GPIO_SET_SETP04_Pos = 0x4
	// Bit mask of SETP04 field.
	GPIO_SET_SETP04_Msk = 0x10
	// Bit SETP04.
	GPIO_SET_SETP04 = 0x10
	// Position of SETP05 field.
	GPIO_SET_SETP05_Pos = 0x5
	// Bit mask of SETP05 field.
	GPIO_SET_SETP05_Msk = 0x20
	// Bit SETP05.
	GPIO_SET_SETP05 = 0x20
	// Position of SETP06 field.
	GPIO_SET_SETP06_Pos = 0x6
	// Bit mask of SETP06 field.
	GPIO_SET_SETP06_Msk = 0x40
	// Bit SETP06.
	GPIO_SET_SETP06 = 0x40
	// Position of SETP07 field.
	GPIO_SET_SETP07_Pos = 0x7
	// Bit mask of SETP07 field.
	GPIO_SET_SETP07_Msk = 0x80
	// Bit SETP07.
	GPIO_SET_SETP07 = 0x80
	// Position of SETP08 field.
	GPIO_SET_SETP08_Pos = 0x8
	// Bit mask of SETP08 field.
	GPIO_SET_SETP08_Msk = 0x100
	// Bit SETP08.
	GPIO_SET_SETP08 = 0x100
	// Position of SETP09 field.
	GPIO_SET_SETP09_Pos = 0x9
	// Bit mask of SETP09 field.
	GPIO_SET_SETP09_Msk = 0x200
	// Bit SETP09.
	GPIO_SET_SETP09 = 0x200
	// Position of SETP010 field.
	GPIO_SET_SETP010_Pos = 0xa
	// Bit mask of SETP010 field.
	GPIO_SET_SETP010_Msk = 0x400
	// Bit SETP010.
	GPIO_SET_SETP010 = 0x400
	// Position of SETP011 field.
	GPIO_SET_SETP011_Pos = 0xb
	// Bit mask of SETP011 field.
	GPIO_SET_SETP011_Msk = 0x800
	// Bit SETP011.
	GPIO_SET_SETP011 = 0x800
	// Position of SETP012 field.
	GPIO_SET_SETP012_Pos = 0xc
	// Bit mask of SETP012 field.
	GPIO_SET_SETP012_Msk = 0x1000
	// Bit SETP012.
	GPIO_SET_SETP012 = 0x1000
	// Position of SETP013 field.
	GPIO_SET_SETP013_Pos = 0xd
	// Bit mask of SETP013 field.
	GPIO_SET_SETP013_Msk = 0x2000
	// Bit SETP013.
	GPIO_SET_SETP013 = 0x2000
	// Position of SETP014 field.
	GPIO_SET_SETP014_Pos = 0xe
	// Bit mask of SETP014 field.
	GPIO_SET_SETP014_Msk = 0x4000
	// Bit SETP014.
	GPIO_SET_SETP014 = 0x4000
	// Position of SETP015 field.
	GPIO_SET_SETP015_Pos = 0xf
	// Bit mask of SETP015 field.
	GPIO_SET_SETP015_Msk = 0x8000
	// Bit SETP015.
	GPIO_SET_SETP015 = 0x8000
	// Position of SETP016 field.
	GPIO_SET_SETP016_Pos = 0x10
	// Bit mask of SETP016 field.
	GPIO_SET_SETP016_Msk = 0x10000
	// Bit SETP016.
	GPIO_SET_SETP016 = 0x10000
	// Position of SETP017 field.
	GPIO_SET_SETP017_Pos = 0x11
	// Bit mask of SETP017 field.
	GPIO_SET_SETP017_Msk = 0x20000
	// Bit SETP017.
	GPIO_SET_SETP017 = 0x20000
	// Position of SETP018 field.
	GPIO_SET_SETP018_Pos = 0x12
	// Bit mask of SETP018 field.
	GPIO_SET_SETP018_Msk = 0x40000
	// Bit SETP018.
	GPIO_SET_SETP018 = 0x40000
	// Position of SETP019 field.
	GPIO_SET_SETP019_Pos = 0x13
	// Bit mask of SETP019 field.
	GPIO_SET_SETP019_Msk = 0x80000
	// Bit SETP019.
	GPIO_SET_SETP019 = 0x80000
	// Position of SETP020 field.
	GPIO_SET_SETP020_Pos = 0x14
	// Bit mask of SETP020 field.
	GPIO_SET_SETP020_Msk = 0x100000
	// Bit SETP020.
	GPIO_SET_SETP020 = 0x100000
	// Position of SETP021 field.
	GPIO_SET_SETP021_Pos = 0x15
	// Bit mask of SETP021 field.
	GPIO_SET_SETP021_Msk = 0x200000
	// Bit SETP021.
	GPIO_SET_SETP021 = 0x200000
	// Position of SETP022 field.
	GPIO_SET_SETP022_Pos = 0x16
	// Bit mask of SETP022 field.
	GPIO_SET_SETP022_Msk = 0x400000
	// Bit SETP022.
	GPIO_SET_SETP022 = 0x400000
	// Position of SETP023 field.
	GPIO_SET_SETP023_Pos = 0x17
	// Bit mask of SETP023 field.
	GPIO_SET_SETP023_Msk = 0x800000
	// Bit SETP023.
	GPIO_SET_SETP023 = 0x800000
	// Position of SETP024 field.
	GPIO_SET_SETP024_Pos = 0x18
	// Bit mask of SETP024 field.
	GPIO_SET_SETP024_Msk = 0x1000000
	// Bit SETP024.
	GPIO_SET_SETP024 = 0x1000000
	// Position of SETP025 field.
	GPIO_SET_SETP025_Pos = 0x19
	// Bit mask of SETP025 field.
	GPIO_SET_SETP025_Msk = 0x2000000
	// Bit SETP025.
	GPIO_SET_SETP025 = 0x2000000
	// Position of SETP026 field.
	GPIO_SET_SETP026_Pos = 0x1a
	// Bit mask of SETP026 field.
	GPIO_SET_SETP026_Msk = 0x4000000
	// Bit SETP026.
	GPIO_SET_SETP026 = 0x4000000
	// Position of SETP027 field.
	GPIO_SET_SETP027_Pos = 0x1b
	// Bit mask of SETP027 field.
	GPIO_SET_SETP027_Msk = 0x8000000
	// Bit SETP027.
	GPIO_SET_SETP027 = 0x8000000
	// Position of SETP028 field.
	GPIO_SET_SETP028_Pos = 0x1c
	// Bit mask of SETP028 field.
	GPIO_SET_SETP028_Msk = 0x10000000
	// Bit SETP028.
	GPIO_SET_SETP028 = 0x10000000
	// Position of SETP029 field.
	GPIO_SET_SETP029_Pos = 0x1d
	// Bit mask of SETP029 field.
	GPIO_SET_SETP029_Msk = 0x20000000
	// Bit SETP029.
	GPIO_SET_SETP029 = 0x20000000
	// Position of SETP030 field.
	GPIO_SET_SETP030_Pos = 0x1e
	// Bit mask of SETP030 field.
	GPIO_SET_SETP030_Msk = 0x40000000
	// Bit SETP030.
	GPIO_SET_SETP030 = 0x40000000
	// Position of SETP031 field.
	GPIO_SET_SETP031_Pos = 0x1f
	// Bit mask of SETP031 field.
	GPIO_SET_SETP031_Msk = 0x80000000
	// Bit SETP031.
	GPIO_SET_SETP031 = 0x80000000

	// CLR: Clear port
	// Position of CLRP00 field.
	GPIO_CLR_CLRP00_Pos = 0x0
	// Bit mask of CLRP00 field.
	GPIO_CLR_CLRP00_Msk = 0x1
	// Bit CLRP00.
	GPIO_CLR_CLRP00 = 0x1
	// Position of CLRP01 field.
	GPIO_CLR_CLRP01_Pos = 0x1
	// Bit mask of CLRP01 field.
	GPIO_CLR_CLRP01_Msk = 0x2
	// Bit CLRP01.
	GPIO_CLR_CLRP01 = 0x2
	// Position of CLRP02 field.
	GPIO_CLR_CLRP02_Pos = 0x2
	// Bit mask of CLRP02 field.
	GPIO_CLR_CLRP02_Msk = 0x4
	// Bit CLRP02.
	GPIO_CLR_CLRP02 = 0x4
	// Position of CLRP03 field.
	GPIO_CLR_CLRP03_Pos = 0x3
	// Bit mask of CLRP03 field.
	GPIO_CLR_CLRP03_Msk = 0x8
	// Bit CLRP03.
	GPIO_CLR_CLRP03 = 0x8
	// Position of CLRP04 field.
	GPIO_CLR_CLRP04_Pos = 0x4
	// Bit mask of CLRP04 field.
	GPIO_CLR_CLRP04_Msk = 0x10
	// Bit CLRP04.
	GPIO_CLR_CLRP04 = 0x10
	// Position of CLRP05 field.
	GPIO_CLR_CLRP05_Pos = 0x5
	// Bit mask of CLRP05 field.
	GPIO_CLR_CLRP05_Msk = 0x20
	// Bit CLRP05.
	GPIO_CLR_CLRP05 = 0x20
	// Position of CLRP06 field.
	GPIO_CLR_CLRP06_Pos = 0x6
	// Bit mask of CLRP06 field.
	GPIO_CLR_CLRP06_Msk = 0x40
	// Bit CLRP06.
	GPIO_CLR_CLRP06 = 0x40
	// Position of CLRP07 field.
	GPIO_CLR_CLRP07_Pos = 0x7
	// Bit mask of CLRP07 field.
	GPIO_CLR_CLRP07_Msk = 0x80
	// Bit CLRP07.
	GPIO_CLR_CLRP07 = 0x80
	// Position of CLRP08 field.
	GPIO_CLR_CLRP08_Pos = 0x8
	// Bit mask of CLRP08 field.
	GPIO_CLR_CLRP08_Msk = 0x100
	// Bit CLRP08.
	GPIO_CLR_CLRP08 = 0x100
	// Position of CLRP09 field.
	GPIO_CLR_CLRP09_Pos = 0x9
	// Bit mask of CLRP09 field.
	GPIO_CLR_CLRP09_Msk = 0x200
	// Bit CLRP09.
	GPIO_CLR_CLRP09 = 0x200
	// Position of CLRP010 field.
	GPIO_CLR_CLRP010_Pos = 0xa
	// Bit mask of CLRP010 field.
	GPIO_CLR_CLRP010_Msk = 0x400
	// Bit CLRP010.
	GPIO_CLR_CLRP010 = 0x400
	// Position of CLRP011 field.
	GPIO_CLR_CLRP011_Pos = 0xb
	// Bit mask of CLRP011 field.
	GPIO_CLR_CLRP011_Msk = 0x800
	// Bit CLRP011.
	GPIO_CLR_CLRP011 = 0x800
	// Position of CLRP012 field.
	GPIO_CLR_CLRP012_Pos = 0xc
	// Bit mask of CLRP012 field.
	GPIO_CLR_CLRP012_Msk = 0x1000
	// Bit CLRP012.
	GPIO_CLR_CLRP012 = 0x1000
	// Position of CLRP013 field.
	GPIO_CLR_CLRP013_Pos = 0xd
	// Bit mask of CLRP013 field.
	GPIO_CLR_CLRP013_Msk = 0x2000
	// Bit CLRP013.
	GPIO_CLR_CLRP013 = 0x2000
	// Position of CLRP014 field.
	GPIO_CLR_CLRP014_Pos = 0xe
	// Bit mask of CLRP014 field.
	GPIO_CLR_CLRP014_Msk = 0x4000
	// Bit CLRP014.
	GPIO_CLR_CLRP014 = 0x4000
	// Position of CLRP015 field.
	GPIO_CLR_CLRP015_Pos = 0xf
	// Bit mask of CLRP015 field.
	GPIO_CLR_CLRP015_Msk = 0x8000
	// Bit CLRP015.
	GPIO_CLR_CLRP015 = 0x8000
	// Position of CLRP016 field.
	GPIO_CLR_CLRP016_Pos = 0x10
	// Bit mask of CLRP016 field.
	GPIO_CLR_CLRP016_Msk = 0x10000
	// Bit CLRP016.
	GPIO_CLR_CLRP016 = 0x10000
	// Position of CLRP017 field.
	GPIO_CLR_CLRP017_Pos = 0x11
	// Bit mask of CLRP017 field.
	GPIO_CLR_CLRP017_Msk = 0x20000
	// Bit CLRP017.
	GPIO_CLR_CLRP017 = 0x20000
	// Position of CLRP018 field.
	GPIO_CLR_CLRP018_Pos = 0x12
	// Bit mask of CLRP018 field.
	GPIO_CLR_CLRP018_Msk = 0x40000
	// Bit CLRP018.
	GPIO_CLR_CLRP018 = 0x40000
	// Position of CLRP019 field.
	GPIO_CLR_CLRP019_Pos = 0x13
	// Bit mask of CLRP019 field.
	GPIO_CLR_CLRP019_Msk = 0x80000
	// Bit CLRP019.
	GPIO_CLR_CLRP019 = 0x80000
	// Position of CLRP020 field.
	GPIO_CLR_CLRP020_Pos = 0x14
	// Bit mask of CLRP020 field.
	GPIO_CLR_CLRP020_Msk = 0x100000
	// Bit CLRP020.
	GPIO_CLR_CLRP020 = 0x100000
	// Position of CLRP021 field.
	GPIO_CLR_CLRP021_Pos = 0x15
	// Bit mask of CLRP021 field.
	GPIO_CLR_CLRP021_Msk = 0x200000
	// Bit CLRP021.
	GPIO_CLR_CLRP021 = 0x200000
	// Position of CLRP022 field.
	GPIO_CLR_CLRP022_Pos = 0x16
	// Bit mask of CLRP022 field.
	GPIO_CLR_CLRP022_Msk = 0x400000
	// Bit CLRP022.
	GPIO_CLR_CLRP022 = 0x400000
	// Position of CLRP023 field.
	GPIO_CLR_CLRP023_Pos = 0x17
	// Bit mask of CLRP023 field.
	GPIO_CLR_CLRP023_Msk = 0x800000
	// Bit CLRP023.
	GPIO_CLR_CLRP023 = 0x800000
	// Position of CLRP024 field.
	GPIO_CLR_CLRP024_Pos = 0x18
	// Bit mask of CLRP024 field.
	GPIO_CLR_CLRP024_Msk = 0x1000000
	// Bit CLRP024.
	GPIO_CLR_CLRP024 = 0x1000000
	// Position of CLRP025 field.
	GPIO_CLR_CLRP025_Pos = 0x19
	// Bit mask of CLRP025 field.
	GPIO_CLR_CLRP025_Msk = 0x2000000
	// Bit CLRP025.
	GPIO_CLR_CLRP025 = 0x2000000
	// Position of CLRP026 field.
	GPIO_CLR_CLRP026_Pos = 0x1a
	// Bit mask of CLRP026 field.
	GPIO_CLR_CLRP026_Msk = 0x4000000
	// Bit CLRP026.
	GPIO_CLR_CLRP026 = 0x4000000
	// Position of CLRP027 field.
	GPIO_CLR_CLRP027_Pos = 0x1b
	// Bit mask of CLRP027 field.
	GPIO_CLR_CLRP027_Msk = 0x8000000
	// Bit CLRP027.
	GPIO_CLR_CLRP027 = 0x8000000
	// Position of CLRP028 field.
	GPIO_CLR_CLRP028_Pos = 0x1c
	// Bit mask of CLRP028 field.
	GPIO_CLR_CLRP028_Msk = 0x10000000
	// Bit CLRP028.
	GPIO_CLR_CLRP028 = 0x10000000
	// Position of CLRP029 field.
	GPIO_CLR_CLRP029_Pos = 0x1d
	// Bit mask of CLRP029 field.
	GPIO_CLR_CLRP029_Msk = 0x20000000
	// Bit CLRP029.
	GPIO_CLR_CLRP029 = 0x20000000
	// Position of CLRP030 field.
	GPIO_CLR_CLRP030_Pos = 0x1e
	// Bit mask of CLRP030 field.
	GPIO_CLR_CLRP030_Msk = 0x40000000
	// Bit CLRP030.
	GPIO_CLR_CLRP030 = 0x40000000
	// Position of CLRP031 field.
	GPIO_CLR_CLRP031_Pos = 0x1f
	// Bit mask of CLRP031 field.
	GPIO_CLR_CLRP031_Msk = 0x80000000
	// Bit CLRP031.
	GPIO_CLR_CLRP031 = 0x80000000

	// NOT: Toggle port
	// Position of NOTP00 field.
	GPIO_NOT_NOTP00_Pos = 0x0
	// Bit mask of NOTP00 field.
	GPIO_NOT_NOTP00_Msk = 0x1
	// Bit NOTP00.
	GPIO_NOT_NOTP00 = 0x1
	// Position of NOTP01 field.
	GPIO_NOT_NOTP01_Pos = 0x1
	// Bit mask of NOTP01 field.
	GPIO_NOT_NOTP01_Msk = 0x2
	// Bit NOTP01.
	GPIO_NOT_NOTP01 = 0x2
	// Position of NOTP02 field.
	GPIO_NOT_NOTP02_Pos = 0x2
	// Bit mask of NOTP02 field.
	GPIO_NOT_NOTP02_Msk = 0x4
	// Bit NOTP02.
	GPIO_NOT_NOTP02 = 0x4
	// Position of NOTP03 field.
	GPIO_NOT_NOTP03_Pos = 0x3
	// Bit mask of NOTP03 field.
	GPIO_NOT_NOTP03_Msk = 0x8
	// Bit NOTP03.
	GPIO_NOT_NOTP03 = 0x8
	// Position of NOTP04 field.
	GPIO_NOT_NOTP04_Pos = 0x4
	// Bit mask of NOTP04 field.
	GPIO_NOT_NOTP04_Msk = 0x10
	// Bit NOTP04.
	GPIO_NOT_NOTP04 = 0x10
	// Position of NOTP05 field.
	GPIO_NOT_NOTP05_Pos = 0x5
	// Bit mask of NOTP05 field.
	GPIO_NOT_NOTP05_Msk = 0x20
	// Bit NOTP05.
	GPIO_NOT_NOTP05 = 0x20
	// Position of NOTP06 field.
	GPIO_NOT_NOTP06_Pos = 0x6
	// Bit mask of NOTP06 field.
	GPIO_NOT_NOTP06_Msk = 0x40
	// Bit NOTP06.
	GPIO_NOT_NOTP06 = 0x40
	// Position of NOTP07 field.
	GPIO_NOT_NOTP07_Pos = 0x7
	// Bit mask of NOTP07 field.
	GPIO_NOT_NOTP07_Msk = 0x80
	// Bit NOTP07.
	GPIO_NOT_NOTP07 = 0x80
	// Position of NOTP08 field.
	GPIO_NOT_NOTP08_Pos = 0x8
	// Bit mask of NOTP08 field.
	GPIO_NOT_NOTP08_Msk = 0x100
	// Bit NOTP08.
	GPIO_NOT_NOTP08 = 0x100
	// Position of NOTP09 field.
	GPIO_NOT_NOTP09_Pos = 0x9
	// Bit mask of NOTP09 field.
	GPIO_NOT_NOTP09_Msk = 0x200
	// Bit NOTP09.
	GPIO_NOT_NOTP09 = 0x200
	// Position of NOTP010 field.
	GPIO_NOT_NOTP010_Pos = 0xa
	// Bit mask of NOTP010 field.
	GPIO_NOT_NOTP010_Msk = 0x400
	// Bit NOTP010.
	GPIO_NOT_NOTP010 = 0x400
	// Position of NOTP011 field.
	GPIO_NOT_NOTP011_Pos = 0xb
	// Bit mask of NOTP011 field.
	GPIO_NOT_NOTP011_Msk = 0x800
	// Bit NOTP011.
	GPIO_NOT_NOTP011 = 0x800
	// Position of NOTP012 field.
	GPIO_NOT_NOTP012_Pos = 0xc
	// Bit mask of NOTP012 field.
	GPIO_NOT_NOTP012_Msk = 0x1000
	// Bit NOTP012.
	GPIO_NOT_NOTP012 = 0x1000
	// Position of NOTP013 field.
	GPIO_NOT_NOTP013_Pos = 0xd
	// Bit mask of NOTP013 field.
	GPIO_NOT_NOTP013_Msk = 0x2000
	// Bit NOTP013.
	GPIO_NOT_NOTP013 = 0x2000
	// Position of NOTP014 field.
	GPIO_NOT_NOTP014_Pos = 0xe
	// Bit mask of NOTP014 field.
	GPIO_NOT_NOTP014_Msk = 0x4000
	// Bit NOTP014.
	GPIO_NOT_NOTP014 = 0x4000
	// Position of NOTP015 field.
	GPIO_NOT_NOTP015_Pos = 0xf
	// Bit mask of NOTP015 field.
	GPIO_NOT_NOTP015_Msk = 0x8000
	// Bit NOTP015.
	GPIO_NOT_NOTP015 = 0x8000
	// Position of NOTP016 field.
	GPIO_NOT_NOTP016_Pos = 0x10
	// Bit mask of NOTP016 field.
	GPIO_NOT_NOTP016_Msk = 0x10000
	// Bit NOTP016.
	GPIO_NOT_NOTP016 = 0x10000
	// Position of NOTP017 field.
	GPIO_NOT_NOTP017_Pos = 0x11
	// Bit mask of NOTP017 field.
	GPIO_NOT_NOTP017_Msk = 0x20000
	// Bit NOTP017.
	GPIO_NOT_NOTP017 = 0x20000
	// Position of NOTP018 field.
	GPIO_NOT_NOTP018_Pos = 0x12
	// Bit mask of NOTP018 field.
	GPIO_NOT_NOTP018_Msk = 0x40000
	// Bit NOTP018.
	GPIO_NOT_NOTP018 = 0x40000
	// Position of NOTP019 field.
	GPIO_NOT_NOTP019_Pos = 0x13
	// Bit mask of NOTP019 field.
	GPIO_NOT_NOTP019_Msk = 0x80000
	// Bit NOTP019.
	GPIO_NOT_NOTP019 = 0x80000
	// Position of NOTP020 field.
	GPIO_NOT_NOTP020_Pos = 0x14
	// Bit mask of NOTP020 field.
	GPIO_NOT_NOTP020_Msk = 0x100000
	// Bit NOTP020.
	GPIO_NOT_NOTP020 = 0x100000
	// Position of NOTP021 field.
	GPIO_NOT_NOTP021_Pos = 0x15
	// Bit mask of NOTP021 field.
	GPIO_NOT_NOTP021_Msk = 0x200000
	// Bit NOTP021.
	GPIO_NOT_NOTP021 = 0x200000
	// Position of NOTP022 field.
	GPIO_NOT_NOTP022_Pos = 0x16
	// Bit mask of NOTP022 field.
	GPIO_NOT_NOTP022_Msk = 0x400000
	// Bit NOTP022.
	GPIO_NOT_NOTP022 = 0x400000
	// Position of NOTP023 field.
	GPIO_NOT_NOTP023_Pos = 0x17
	// Bit mask of NOTP023 field.
	GPIO_NOT_NOTP023_Msk = 0x800000
	// Bit NOTP023.
	GPIO_NOT_NOTP023 = 0x800000
	// Position of NOTP024 field.
	GPIO_NOT_NOTP024_Pos = 0x18
	// Bit mask of NOTP024 field.
	GPIO_NOT_NOTP024_Msk = 0x1000000
	// Bit NOTP024.
	GPIO_NOT_NOTP024 = 0x1000000
	// Position of NOTP025 field.
	GPIO_NOT_NOTP025_Pos = 0x19
	// Bit mask of NOTP025 field.
	GPIO_NOT_NOTP025_Msk = 0x2000000
	// Bit NOTP025.
	GPIO_NOT_NOTP025 = 0x2000000
	// Position of NOTP026 field.
	GPIO_NOT_NOTP026_Pos = 0x1a
	// Bit mask of NOTP026 field.
	GPIO_NOT_NOTP026_Msk = 0x4000000
	// Bit NOTP026.
	GPIO_NOT_NOTP026 = 0x4000000
	// Position of NOTP027 field.
	GPIO_NOT_NOTP027_Pos = 0x1b
	// Bit mask of NOTP027 field.
	GPIO_NOT_NOTP027_Msk = 0x8000000
	// Bit NOTP027.
	GPIO_NOT_NOTP027 = 0x8000000
	// Position of NOTP028 field.
	GPIO_NOT_NOTP028_Pos = 0x1c
	// Bit mask of NOTP028 field.
	GPIO_NOT_NOTP028_Msk = 0x10000000
	// Bit NOTP028.
	GPIO_NOT_NOTP028 = 0x10000000
	// Position of NOTP029 field.
	GPIO_NOT_NOTP029_Pos = 0x1d
	// Bit mask of NOTP029 field.
	GPIO_NOT_NOTP029_Msk = 0x20000000
	// Bit NOTP029.
	GPIO_NOT_NOTP029 = 0x20000000
	// Position of NOTP030 field.
	GPIO_NOT_NOTP030_Pos = 0x1e
	// Bit mask of NOTP030 field.
	GPIO_NOT_NOTP030_Msk = 0x40000000
	// Bit NOTP030.
	GPIO_NOT_NOTP030 = 0x40000000
	// Position of NOTP031 field.
	GPIO_NOT_NOTP031_Pos = 0x1f
	// Bit mask of NOTP031 field.
	GPIO_NOT_NOTP031_Msk = 0x80000000
	// Bit NOTP031.
	GPIO_NOT_NOTP031 = 0x80000000
)

// Bitfields for PINT: Pin interrupt and pattern match (PINT)
const (
	// ISEL: Pin Interrupt Mode register
	// Position of PMODE0 field.
	PINT_ISEL_PMODE0_Pos = 0x0
	// Bit mask of PMODE0 field.
	PINT_ISEL_PMODE0_Msk = 0x1
	// Bit PMODE0.
	PINT_ISEL_PMODE0 = 0x1
	// Position of PMODE1 field.
	PINT_ISEL_PMODE1_Pos = 0x1
	// Bit mask of PMODE1 field.
	PINT_ISEL_PMODE1_Msk = 0x2
	// Bit PMODE1.
	PINT_ISEL_PMODE1 = 0x2
	// Position of PMODE2 field.
	PINT_ISEL_PMODE2_Pos = 0x2
	// Bit mask of PMODE2 field.
	PINT_ISEL_PMODE2_Msk = 0x4
	// Bit PMODE2.
	PINT_ISEL_PMODE2 = 0x4
	// Position of PMODE3 field.
	PINT_ISEL_PMODE3_Pos = 0x3
	// Bit mask of PMODE3 field.
	PINT_ISEL_PMODE3_Msk = 0x8
	// Bit PMODE3.
	PINT_ISEL_PMODE3 = 0x8
	// Position of PMODE4 field.
	PINT_ISEL_PMODE4_Pos = 0x4
	// Bit mask of PMODE4 field.
	PINT_ISEL_PMODE4_Msk = 0x10
	// Bit PMODE4.
	PINT_ISEL_PMODE4 = 0x10
	// Position of PMODE5 field.
	PINT_ISEL_PMODE5_Pos = 0x5
	// Bit mask of PMODE5 field.
	PINT_ISEL_PMODE5_Msk = 0x20
	// Bit PMODE5.
	PINT_ISEL_PMODE5 = 0x20
	// Position of PMODE6 field.
	PINT_ISEL_PMODE6_Pos = 0x6
	// Bit mask of PMODE6 field.
	PINT_ISEL_PMODE6_Msk = 0x40
	// Bit PMODE6.
	PINT_ISEL_PMODE6 = 0x40
	// Position of PMODE7 field.
	PINT_ISEL_PMODE7_Pos = 0x7
	// Bit mask of PMODE7 field.
	PINT_ISEL_PMODE7_Msk = 0x80
	// Bit PMODE7.
	PINT_ISEL_PMODE7 = 0x80
	// Position of RESERVED field.
	PINT_ISEL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_ISEL_RESERVED_Msk = 0xffffff00

	// IENR: Pin interrupt level or rising edge interrupt enable register
	// Position of ENRL0 field.
	PINT_IENR_ENRL0_Pos = 0x0
	// Bit mask of ENRL0 field.
	PINT_IENR_ENRL0_Msk = 0x1
	// Bit ENRL0.
	PINT_IENR_ENRL0 = 0x1
	// Position of ENRL1 field.
	PINT_IENR_ENRL1_Pos = 0x1
	// Bit mask of ENRL1 field.
	PINT_IENR_ENRL1_Msk = 0x2
	// Bit ENRL1.
	PINT_IENR_ENRL1 = 0x2
	// Position of ENRL2 field.
	PINT_IENR_ENRL2_Pos = 0x2
	// Bit mask of ENRL2 field.
	PINT_IENR_ENRL2_Msk = 0x4
	// Bit ENRL2.
	PINT_IENR_ENRL2 = 0x4
	// Position of ENRL3 field.
	PINT_IENR_ENRL3_Pos = 0x3
	// Bit mask of ENRL3 field.
	PINT_IENR_ENRL3_Msk = 0x8
	// Bit ENRL3.
	PINT_IENR_ENRL3 = 0x8
	// Position of ENRL4 field.
	PINT_IENR_ENRL4_Pos = 0x4
	// Bit mask of ENRL4 field.
	PINT_IENR_ENRL4_Msk = 0x10
	// Bit ENRL4.
	PINT_IENR_ENRL4 = 0x10
	// Position of ENRL5 field.
	PINT_IENR_ENRL5_Pos = 0x5
	// Bit mask of ENRL5 field.
	PINT_IENR_ENRL5_Msk = 0x20
	// Bit ENRL5.
	PINT_IENR_ENRL5 = 0x20
	// Position of ENRL6 field.
	PINT_IENR_ENRL6_Pos = 0x6
	// Bit mask of ENRL6 field.
	PINT_IENR_ENRL6_Msk = 0x40
	// Bit ENRL6.
	PINT_IENR_ENRL6 = 0x40
	// Position of ENRL7 field.
	PINT_IENR_ENRL7_Pos = 0x7
	// Bit mask of ENRL7 field.
	PINT_IENR_ENRL7_Msk = 0x80
	// Bit ENRL7.
	PINT_IENR_ENRL7 = 0x80
	// Position of RESERVED field.
	PINT_IENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_IENR_RESERVED_Msk = 0xffffff00

	// SIENR: Pin interrupt level or rising edge interrupt set register
	// Position of SETENRL0 field.
	PINT_SIENR_SETENRL0_Pos = 0x0
	// Bit mask of SETENRL0 field.
	PINT_SIENR_SETENRL0_Msk = 0x1
	// Bit SETENRL0.
	PINT_SIENR_SETENRL0 = 0x1
	// Position of SETENRL1 field.
	PINT_SIENR_SETENRL1_Pos = 0x1
	// Bit mask of SETENRL1 field.
	PINT_SIENR_SETENRL1_Msk = 0x2
	// Bit SETENRL1.
	PINT_SIENR_SETENRL1 = 0x2
	// Position of SETENRL2 field.
	PINT_SIENR_SETENRL2_Pos = 0x2
	// Bit mask of SETENRL2 field.
	PINT_SIENR_SETENRL2_Msk = 0x4
	// Bit SETENRL2.
	PINT_SIENR_SETENRL2 = 0x4
	// Position of SETENRL3 field.
	PINT_SIENR_SETENRL3_Pos = 0x3
	// Bit mask of SETENRL3 field.
	PINT_SIENR_SETENRL3_Msk = 0x8
	// Bit SETENRL3.
	PINT_SIENR_SETENRL3 = 0x8
	// Position of SETENRL4 field.
	PINT_SIENR_SETENRL4_Pos = 0x4
	// Bit mask of SETENRL4 field.
	PINT_SIENR_SETENRL4_Msk = 0x10
	// Bit SETENRL4.
	PINT_SIENR_SETENRL4 = 0x10
	// Position of SETENRL5 field.
	PINT_SIENR_SETENRL5_Pos = 0x5
	// Bit mask of SETENRL5 field.
	PINT_SIENR_SETENRL5_Msk = 0x20
	// Bit SETENRL5.
	PINT_SIENR_SETENRL5 = 0x20
	// Position of SETENRL6 field.
	PINT_SIENR_SETENRL6_Pos = 0x6
	// Bit mask of SETENRL6 field.
	PINT_SIENR_SETENRL6_Msk = 0x40
	// Bit SETENRL6.
	PINT_SIENR_SETENRL6 = 0x40
	// Position of SETENRL7 field.
	PINT_SIENR_SETENRL7_Pos = 0x7
	// Bit mask of SETENRL7 field.
	PINT_SIENR_SETENRL7_Msk = 0x80
	// Bit SETENRL7.
	PINT_SIENR_SETENRL7 = 0x80
	// Position of RESERVED field.
	PINT_SIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_SIENR_RESERVED_Msk = 0xffffff00

	// CIENR: Pin interrupt level (rising edge interrupt) clear register
	// Position of CENRL0 field.
	PINT_CIENR_CENRL0_Pos = 0x0
	// Bit mask of CENRL0 field.
	PINT_CIENR_CENRL0_Msk = 0x1
	// Bit CENRL0.
	PINT_CIENR_CENRL0 = 0x1
	// Position of CENRL1 field.
	PINT_CIENR_CENRL1_Pos = 0x1
	// Bit mask of CENRL1 field.
	PINT_CIENR_CENRL1_Msk = 0x2
	// Bit CENRL1.
	PINT_CIENR_CENRL1 = 0x2
	// Position of CENRL2 field.
	PINT_CIENR_CENRL2_Pos = 0x2
	// Bit mask of CENRL2 field.
	PINT_CIENR_CENRL2_Msk = 0x4
	// Bit CENRL2.
	PINT_CIENR_CENRL2 = 0x4
	// Position of CENRL3 field.
	PINT_CIENR_CENRL3_Pos = 0x3
	// Bit mask of CENRL3 field.
	PINT_CIENR_CENRL3_Msk = 0x8
	// Bit CENRL3.
	PINT_CIENR_CENRL3 = 0x8
	// Position of CENRL4 field.
	PINT_CIENR_CENRL4_Pos = 0x4
	// Bit mask of CENRL4 field.
	PINT_CIENR_CENRL4_Msk = 0x10
	// Bit CENRL4.
	PINT_CIENR_CENRL4 = 0x10
	// Position of CENRL5 field.
	PINT_CIENR_CENRL5_Pos = 0x5
	// Bit mask of CENRL5 field.
	PINT_CIENR_CENRL5_Msk = 0x20
	// Bit CENRL5.
	PINT_CIENR_CENRL5 = 0x20
	// Position of CENRL6 field.
	PINT_CIENR_CENRL6_Pos = 0x6
	// Bit mask of CENRL6 field.
	PINT_CIENR_CENRL6_Msk = 0x40
	// Bit CENRL6.
	PINT_CIENR_CENRL6 = 0x40
	// Position of CENRL7 field.
	PINT_CIENR_CENRL7_Pos = 0x7
	// Bit mask of CENRL7 field.
	PINT_CIENR_CENRL7_Msk = 0x80
	// Bit CENRL7.
	PINT_CIENR_CENRL7 = 0x80
	// Position of RESERVED field.
	PINT_CIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_CIENR_RESERVED_Msk = 0xffffff00

	// IENF: Pin interrupt active level or falling edge interrupt enable register
	// Position of ENAF0 field.
	PINT_IENF_ENAF0_Pos = 0x0
	// Bit mask of ENAF0 field.
	PINT_IENF_ENAF0_Msk = 0x1
	// Bit ENAF0.
	PINT_IENF_ENAF0 = 0x1
	// Position of ENAF1 field.
	PINT_IENF_ENAF1_Pos = 0x1
	// Bit mask of ENAF1 field.
	PINT_IENF_ENAF1_Msk = 0x2
	// Bit ENAF1.
	PINT_IENF_ENAF1 = 0x2
	// Position of ENAF2 field.
	PINT_IENF_ENAF2_Pos = 0x2
	// Bit mask of ENAF2 field.
	PINT_IENF_ENAF2_Msk = 0x4
	// Bit ENAF2.
	PINT_IENF_ENAF2 = 0x4
	// Position of ENAF3 field.
	PINT_IENF_ENAF3_Pos = 0x3
	// Bit mask of ENAF3 field.
	PINT_IENF_ENAF3_Msk = 0x8
	// Bit ENAF3.
	PINT_IENF_ENAF3 = 0x8
	// Position of ENAF4 field.
	PINT_IENF_ENAF4_Pos = 0x4
	// Bit mask of ENAF4 field.
	PINT_IENF_ENAF4_Msk = 0x10
	// Bit ENAF4.
	PINT_IENF_ENAF4 = 0x10
	// Position of ENAF5 field.
	PINT_IENF_ENAF5_Pos = 0x5
	// Bit mask of ENAF5 field.
	PINT_IENF_ENAF5_Msk = 0x20
	// Bit ENAF5.
	PINT_IENF_ENAF5 = 0x20
	// Position of ENAF6 field.
	PINT_IENF_ENAF6_Pos = 0x6
	// Bit mask of ENAF6 field.
	PINT_IENF_ENAF6_Msk = 0x40
	// Bit ENAF6.
	PINT_IENF_ENAF6 = 0x40
	// Position of ENAF7 field.
	PINT_IENF_ENAF7_Pos = 0x7
	// Bit mask of ENAF7 field.
	PINT_IENF_ENAF7_Msk = 0x80
	// Bit ENAF7.
	PINT_IENF_ENAF7 = 0x80
	// Position of RESERVED field.
	PINT_IENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_IENF_RESERVED_Msk = 0xffffff00

	// SIENF: Pin interrupt active level or falling edge interrupt set register
	// Position of SETENAF0 field.
	PINT_SIENF_SETENAF0_Pos = 0x0
	// Bit mask of SETENAF0 field.
	PINT_SIENF_SETENAF0_Msk = 0x1
	// Bit SETENAF0.
	PINT_SIENF_SETENAF0 = 0x1
	// Position of SETENAF1 field.
	PINT_SIENF_SETENAF1_Pos = 0x1
	// Bit mask of SETENAF1 field.
	PINT_SIENF_SETENAF1_Msk = 0x2
	// Bit SETENAF1.
	PINT_SIENF_SETENAF1 = 0x2
	// Position of SETENAF2 field.
	PINT_SIENF_SETENAF2_Pos = 0x2
	// Bit mask of SETENAF2 field.
	PINT_SIENF_SETENAF2_Msk = 0x4
	// Bit SETENAF2.
	PINT_SIENF_SETENAF2 = 0x4
	// Position of SETENAF3 field.
	PINT_SIENF_SETENAF3_Pos = 0x3
	// Bit mask of SETENAF3 field.
	PINT_SIENF_SETENAF3_Msk = 0x8
	// Bit SETENAF3.
	PINT_SIENF_SETENAF3 = 0x8
	// Position of SETENAF4 field.
	PINT_SIENF_SETENAF4_Pos = 0x4
	// Bit mask of SETENAF4 field.
	PINT_SIENF_SETENAF4_Msk = 0x10
	// Bit SETENAF4.
	PINT_SIENF_SETENAF4 = 0x10
	// Position of SETENAF5 field.
	PINT_SIENF_SETENAF5_Pos = 0x5
	// Bit mask of SETENAF5 field.
	PINT_SIENF_SETENAF5_Msk = 0x20
	// Bit SETENAF5.
	PINT_SIENF_SETENAF5 = 0x20
	// Position of SETENAF6 field.
	PINT_SIENF_SETENAF6_Pos = 0x6
	// Bit mask of SETENAF6 field.
	PINT_SIENF_SETENAF6_Msk = 0x40
	// Bit SETENAF6.
	PINT_SIENF_SETENAF6 = 0x40
	// Position of SETENAF7 field.
	PINT_SIENF_SETENAF7_Pos = 0x7
	// Bit mask of SETENAF7 field.
	PINT_SIENF_SETENAF7_Msk = 0x80
	// Bit SETENAF7.
	PINT_SIENF_SETENAF7 = 0x80
	// Position of RESERVED field.
	PINT_SIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_SIENF_RESERVED_Msk = 0xffffff00

	// CIENF: Pin interrupt active level or falling edge interrupt clear register
	// Position of CENAF0 field.
	PINT_CIENF_CENAF0_Pos = 0x0
	// Bit mask of CENAF0 field.
	PINT_CIENF_CENAF0_Msk = 0x1
	// Bit CENAF0.
	PINT_CIENF_CENAF0 = 0x1
	// Position of CENAF1 field.
	PINT_CIENF_CENAF1_Pos = 0x1
	// Bit mask of CENAF1 field.
	PINT_CIENF_CENAF1_Msk = 0x2
	// Bit CENAF1.
	PINT_CIENF_CENAF1 = 0x2
	// Position of CENAF2 field.
	PINT_CIENF_CENAF2_Pos = 0x2
	// Bit mask of CENAF2 field.
	PINT_CIENF_CENAF2_Msk = 0x4
	// Bit CENAF2.
	PINT_CIENF_CENAF2 = 0x4
	// Position of CENAF3 field.
	PINT_CIENF_CENAF3_Pos = 0x3
	// Bit mask of CENAF3 field.
	PINT_CIENF_CENAF3_Msk = 0x8
	// Bit CENAF3.
	PINT_CIENF_CENAF3 = 0x8
	// Position of CENAF4 field.
	PINT_CIENF_CENAF4_Pos = 0x4
	// Bit mask of CENAF4 field.
	PINT_CIENF_CENAF4_Msk = 0x10
	// Bit CENAF4.
	PINT_CIENF_CENAF4 = 0x10
	// Position of CENAF5 field.
	PINT_CIENF_CENAF5_Pos = 0x5
	// Bit mask of CENAF5 field.
	PINT_CIENF_CENAF5_Msk = 0x20
	// Bit CENAF5.
	PINT_CIENF_CENAF5 = 0x20
	// Position of CENAF6 field.
	PINT_CIENF_CENAF6_Pos = 0x6
	// Bit mask of CENAF6 field.
	PINT_CIENF_CENAF6_Msk = 0x40
	// Bit CENAF6.
	PINT_CIENF_CENAF6 = 0x40
	// Position of CENAF7 field.
	PINT_CIENF_CENAF7_Pos = 0x7
	// Bit mask of CENAF7 field.
	PINT_CIENF_CENAF7_Msk = 0x80
	// Bit CENAF7.
	PINT_CIENF_CENAF7 = 0x80
	// Position of RESERVED field.
	PINT_CIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_CIENF_RESERVED_Msk = 0xffffff00

	// RISE: Pin interrupt rising edge register
	// Position of RDET0 field.
	PINT_RISE_RDET0_Pos = 0x0
	// Bit mask of RDET0 field.
	PINT_RISE_RDET0_Msk = 0x1
	// Bit RDET0.
	PINT_RISE_RDET0 = 0x1
	// Position of RDET1 field.
	PINT_RISE_RDET1_Pos = 0x1
	// Bit mask of RDET1 field.
	PINT_RISE_RDET1_Msk = 0x2
	// Bit RDET1.
	PINT_RISE_RDET1 = 0x2
	// Position of RDET2 field.
	PINT_RISE_RDET2_Pos = 0x2
	// Bit mask of RDET2 field.
	PINT_RISE_RDET2_Msk = 0x4
	// Bit RDET2.
	PINT_RISE_RDET2 = 0x4
	// Position of RDET3 field.
	PINT_RISE_RDET3_Pos = 0x3
	// Bit mask of RDET3 field.
	PINT_RISE_RDET3_Msk = 0x8
	// Bit RDET3.
	PINT_RISE_RDET3 = 0x8
	// Position of RDET4 field.
	PINT_RISE_RDET4_Pos = 0x4
	// Bit mask of RDET4 field.
	PINT_RISE_RDET4_Msk = 0x10
	// Bit RDET4.
	PINT_RISE_RDET4 = 0x10
	// Position of RDET5 field.
	PINT_RISE_RDET5_Pos = 0x5
	// Bit mask of RDET5 field.
	PINT_RISE_RDET5_Msk = 0x20
	// Bit RDET5.
	PINT_RISE_RDET5 = 0x20
	// Position of RDET6 field.
	PINT_RISE_RDET6_Pos = 0x6
	// Bit mask of RDET6 field.
	PINT_RISE_RDET6_Msk = 0x40
	// Bit RDET6.
	PINT_RISE_RDET6 = 0x40
	// Position of RDET7 field.
	PINT_RISE_RDET7_Pos = 0x7
	// Bit mask of RDET7 field.
	PINT_RISE_RDET7_Msk = 0x80
	// Bit RDET7.
	PINT_RISE_RDET7 = 0x80
	// Position of RESERVED field.
	PINT_RISE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_RISE_RESERVED_Msk = 0xffffff00

	// FALL: Pin interrupt falling edge register
	// Position of FDET0 field.
	PINT_FALL_FDET0_Pos = 0x0
	// Bit mask of FDET0 field.
	PINT_FALL_FDET0_Msk = 0x1
	// Bit FDET0.
	PINT_FALL_FDET0 = 0x1
	// Position of FDET1 field.
	PINT_FALL_FDET1_Pos = 0x1
	// Bit mask of FDET1 field.
	PINT_FALL_FDET1_Msk = 0x2
	// Bit FDET1.
	PINT_FALL_FDET1 = 0x2
	// Position of FDET2 field.
	PINT_FALL_FDET2_Pos = 0x2
	// Bit mask of FDET2 field.
	PINT_FALL_FDET2_Msk = 0x4
	// Bit FDET2.
	PINT_FALL_FDET2 = 0x4
	// Position of FDET3 field.
	PINT_FALL_FDET3_Pos = 0x3
	// Bit mask of FDET3 field.
	PINT_FALL_FDET3_Msk = 0x8
	// Bit FDET3.
	PINT_FALL_FDET3 = 0x8
	// Position of FDET4 field.
	PINT_FALL_FDET4_Pos = 0x4
	// Bit mask of FDET4 field.
	PINT_FALL_FDET4_Msk = 0x10
	// Bit FDET4.
	PINT_FALL_FDET4 = 0x10
	// Position of FDET5 field.
	PINT_FALL_FDET5_Pos = 0x5
	// Bit mask of FDET5 field.
	PINT_FALL_FDET5_Msk = 0x20
	// Bit FDET5.
	PINT_FALL_FDET5 = 0x20
	// Position of FDET6 field.
	PINT_FALL_FDET6_Pos = 0x6
	// Bit mask of FDET6 field.
	PINT_FALL_FDET6_Msk = 0x40
	// Bit FDET6.
	PINT_FALL_FDET6 = 0x40
	// Position of FDET7 field.
	PINT_FALL_FDET7_Pos = 0x7
	// Bit mask of FDET7 field.
	PINT_FALL_FDET7_Msk = 0x80
	// Bit FDET7.
	PINT_FALL_FDET7 = 0x80
	// Position of RESERVED field.
	PINT_FALL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_FALL_RESERVED_Msk = 0xffffff00

	// IST: Pin interrupt status register
	// Position of PSTAT0 field.
	PINT_IST_PSTAT0_Pos = 0x0
	// Bit mask of PSTAT0 field.
	PINT_IST_PSTAT0_Msk = 0x1
	// Bit PSTAT0.
	PINT_IST_PSTAT0 = 0x1
	// Position of PSTAT1 field.
	PINT_IST_PSTAT1_Pos = 0x1
	// Bit mask of PSTAT1 field.
	PINT_IST_PSTAT1_Msk = 0x2
	// Bit PSTAT1.
	PINT_IST_PSTAT1 = 0x2
	// Position of PSTAT2 field.
	PINT_IST_PSTAT2_Pos = 0x2
	// Bit mask of PSTAT2 field.
	PINT_IST_PSTAT2_Msk = 0x4
	// Bit PSTAT2.
	PINT_IST_PSTAT2 = 0x4
	// Position of PSTAT3 field.
	PINT_IST_PSTAT3_Pos = 0x3
	// Bit mask of PSTAT3 field.
	PINT_IST_PSTAT3_Msk = 0x8
	// Bit PSTAT3.
	PINT_IST_PSTAT3 = 0x8
	// Position of PSTAT4 field.
	PINT_IST_PSTAT4_Pos = 0x4
	// Bit mask of PSTAT4 field.
	PINT_IST_PSTAT4_Msk = 0x10
	// Bit PSTAT4.
	PINT_IST_PSTAT4 = 0x10
	// Position of PSTAT5 field.
	PINT_IST_PSTAT5_Pos = 0x5
	// Bit mask of PSTAT5 field.
	PINT_IST_PSTAT5_Msk = 0x20
	// Bit PSTAT5.
	PINT_IST_PSTAT5 = 0x20
	// Position of PSTAT6 field.
	PINT_IST_PSTAT6_Pos = 0x6
	// Bit mask of PSTAT6 field.
	PINT_IST_PSTAT6_Msk = 0x40
	// Bit PSTAT6.
	PINT_IST_PSTAT6 = 0x40
	// Position of PSTAT7 field.
	PINT_IST_PSTAT7_Pos = 0x7
	// Bit mask of PSTAT7 field.
	PINT_IST_PSTAT7_Msk = 0x80
	// Bit PSTAT7.
	PINT_IST_PSTAT7 = 0x80
	// Position of RESERVED field.
	PINT_IST_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_IST_RESERVED_Msk = 0xffffff00

	// PMCTRL: Pattern match interrupt control register
	// Position of SEL_PMATCH field.
	PINT_PMCTRL_SEL_PMATCH_Pos = 0x0
	// Bit mask of SEL_PMATCH field.
	PINT_PMCTRL_SEL_PMATCH_Msk = 0x1
	// Bit SEL_PMATCH.
	PINT_PMCTRL_SEL_PMATCH = 0x1
	// Pin interrupt. Interrupts are driven in response to the standard pin interrupt function
	PINT_PMCTRL_SEL_PMATCH_PIN_INTERRUPT_INTER = 0x0
	// Pattern match. Interrupts are driven in response to pattern matches.
	PINT_PMCTRL_SEL_PMATCH_PATTERN_MATCH_INTER = 0x1
	// Position of ENA_RXEV field.
	PINT_PMCTRL_ENA_RXEV_Pos = 0x1
	// Bit mask of ENA_RXEV field.
	PINT_PMCTRL_ENA_RXEV_Msk = 0x2
	// Bit ENA_RXEV.
	PINT_PMCTRL_ENA_RXEV = 0x2
	// Disabled. RXEV output to the cpu is disabled.
	PINT_PMCTRL_ENA_RXEV_DISABLED_RXEV_OUTPU = 0x0
	// Enabled. RXEV output to the cpu is enabled.
	PINT_PMCTRL_ENA_RXEV_ENABLED_RXEV_OUTPUT = 0x1
	// Position of RESERVED field.
	PINT_PMCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	PINT_PMCTRL_RESERVED_Msk = 0xfffffc
	// Position of PMAT field.
	PINT_PMCTRL_PMAT_Pos = 0x18
	// Bit mask of PMAT field.
	PINT_PMCTRL_PMAT_Msk = 0xff000000

	// PMSRC: Pattern match interrupt bit-slice source register
	// Position of Reserved field.
	PINT_PMSRC_Reserved_Pos = 0x0
	// Bit mask of Reserved field.
	PINT_PMSRC_Reserved_Msk = 0xff
	// Position of SRC0 field.
	PINT_PMSRC_SRC0_Pos = 0x8
	// Bit mask of SRC0 field.
	PINT_PMSRC_SRC0_Msk = 0x700
	// Input 0. Selects the output of pin interrupt select register 0 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects the output of pin interrupt select register 1 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects the output of pin interrupt select register 2 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects the output of pin interrupt select register 3 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects the output of pin interrupt select register 4 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects the output of pin interrupt select register 5 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects the output of pin interrupt select register 6 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects the output of pin interrupt select register 7 as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC1 field.
	PINT_PMSRC_SRC1_Pos = 0xb
	// Bit mask of SRC1 field.
	PINT_PMSRC_SRC1_Msk = 0x3800
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC2 field.
	PINT_PMSRC_SRC2_Pos = 0xe
	// Bit mask of SRC2 field.
	PINT_PMSRC_SRC2_Msk = 0x1c000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC3 field.
	PINT_PMSRC_SRC3_Pos = 0x11
	// Bit mask of SRC3 field.
	PINT_PMSRC_SRC3_Msk = 0xe0000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC4 field.
	PINT_PMSRC_SRC4_Pos = 0x14
	// Bit mask of SRC4 field.
	PINT_PMSRC_SRC4_Msk = 0x700000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC5 field.
	PINT_PMSRC_SRC5_Pos = 0x17
	// Bit mask of SRC5 field.
	PINT_PMSRC_SRC5_Msk = 0x3800000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC6 field.
	PINT_PMSRC_SRC6_Pos = 0x1a
	// Bit mask of SRC6 field.
	PINT_PMSRC_SRC6_Msk = 0x1c000000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC7 field.
	PINT_PMSRC_SRC7_Pos = 0x1d
	// Bit mask of SRC7 field.
	PINT_PMSRC_SRC7_Msk = 0xe0000000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_7_SELECTS_PIN = 0x7

	// PMCFG: Pattern match interrupt bit slice configuration register
	// Position of PROD_ENDPTS field.
	PINT_PMCFG_PROD_ENDPTS_Pos = 0x0
	// Bit mask of PROD_ENDPTS field.
	PINT_PMCFG_PROD_ENDPTS_Msk = 0x7f
	// Position of RESERVED field.
	PINT_PMCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	PINT_PMCFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	PINT_PMCFG_RESERVED = 0x80
	// Position of CFG0 field.
	PINT_PMCFG_CFG0_Pos = 0x8
	// Bit mask of CFG0 field.
	PINT_PMCFG_CFG0_Msk = 0x700
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG0_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG0_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG0_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG0_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG0_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG0_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG0_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG0_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG1 field.
	PINT_PMCFG_CFG1_Pos = 0xb
	// Bit mask of CFG1 field.
	PINT_PMCFG_CFG1_Msk = 0x3800
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG1_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG1_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG1_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG1_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG1_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG1_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG1_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG1_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG2 field.
	PINT_PMCFG_CFG2_Pos = 0xe
	// Bit mask of CFG2 field.
	PINT_PMCFG_CFG2_Msk = 0x1c000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG2_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG2_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG2_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG2_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG2_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG2_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG2_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG2_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG3 field.
	PINT_PMCFG_CFG3_Pos = 0x11
	// Bit mask of CFG3 field.
	PINT_PMCFG_CFG3_Msk = 0xe0000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG3_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG3_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG3_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG3_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG3_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG3_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG3_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG3_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG4 field.
	PINT_PMCFG_CFG4_Pos = 0x14
	// Bit mask of CFG4 field.
	PINT_PMCFG_CFG4_Msk = 0x700000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG4_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG4_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG4_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG4_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG4_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG4_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG4_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG4_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG5 field.
	PINT_PMCFG_CFG5_Pos = 0x17
	// Bit mask of CFG5 field.
	PINT_PMCFG_CFG5_Msk = 0x3800000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG5_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG5_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG5_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG5_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG5_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG5_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG5_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG5_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG6 field.
	PINT_PMCFG_CFG6_Pos = 0x1a
	// Bit mask of CFG6 field.
	PINT_PMCFG_CFG6_Msk = 0x1c000000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG6_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG6_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG6_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG6_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG6_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG6_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG6_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG6_EVENT_NON_STICKY_RI = 0x7
	// Position of CFG7 field.
	PINT_PMCFG_CFG7_Pos = 0x1d
	// Bit mask of CFG7 field.
	PINT_PMCFG_CFG7_Msk = 0xe0000000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG7_CONSTANT_HIGH_THIS_ = 0x0
	// Sticky rising edgeMatch occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG7_STICKY_RISING_EDGEMA = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG7_STICKY_FALLING_EDGE_ = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG7_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG7_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG7_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG7_CONSTANT_0_THIS_BIT = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG7_EVENT_NON_STICKY_RI = 0x7
)
