// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from rp2040.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/RaspberryPi

//go:build rp && rp2040
// +build rp,rp2040

//
//
//     Copyright (c) 2020 Raspberry Pi (Trading) Ltd.
//
//     SPDX-License-Identifier: BSD-3-Clause
package rp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "RP2040"
	CPU          = "CM0PLUS"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	IRQ_TIMER_IRQ_0 = 0

	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	IRQ_TIMER_IRQ_1 = 1

	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	IRQ_TIMER_IRQ_2 = 2

	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	IRQ_TIMER_IRQ_3 = 3

	// Simple PWM
	IRQ_PWM_IRQ_WRAP = 4

	// USB FS/LS controller device registers
	IRQ_USBCTRL_IRQ = 5

	// QSPI flash execute-in-place block
	IRQ_XIP_IRQ = 6

	// Programmable IO block
	IRQ_PIO0_IRQ_0 = 7

	// Programmable IO block
	IRQ_PIO0_IRQ_1 = 8

	IRQ_PIO1_IRQ_0 = 9

	IRQ_PIO1_IRQ_1 = 10

	// DMA with separate read and write masters
	IRQ_DMA_IRQ_0 = 11

	// DMA with separate read and write masters
	IRQ_DMA_IRQ_1 = 12

	IRQ_IO_IRQ_BANK0 = 13

	IRQ_IO_IRQ_QSPI = 14

	// Single-cycle IO block
	// Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	IRQ_SIO_IRQ_PROC0 = 15

	// Single-cycle IO block
	// Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	IRQ_SIO_IRQ_PROC1 = 16

	IRQ_CLOCKS_IRQ = 17

	IRQ_SPI0_IRQ = 18

	IRQ_SPI1_IRQ = 19

	IRQ_UART0_IRQ = 20

	IRQ_UART1_IRQ = 21

	// Control and data interface to SAR ADC
	IRQ_ADC_IRQ_FIFO = 22

	// DW_apb_i2c address block
	IRQ_I2C0_IRQ = 23

	IRQ_I2C1_IRQ = 24

	// Register block to control RTC
	IRQ_RTC_IRQ = 25

	// Highest interrupt number on this device.
	IRQ_max = 25
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export TIMER_IRQ_0_IRQHandler
func interruptTIMER_IRQ_0() {
	callHandlers(IRQ_TIMER_IRQ_0)
}

//export TIMER_IRQ_1_IRQHandler
func interruptTIMER_IRQ_1() {
	callHandlers(IRQ_TIMER_IRQ_1)
}

//export TIMER_IRQ_2_IRQHandler
func interruptTIMER_IRQ_2() {
	callHandlers(IRQ_TIMER_IRQ_2)
}

//export TIMER_IRQ_3_IRQHandler
func interruptTIMER_IRQ_3() {
	callHandlers(IRQ_TIMER_IRQ_3)
}

//export PWM_IRQ_WRAP_IRQHandler
func interruptPWM_IRQ_WRAP() {
	callHandlers(IRQ_PWM_IRQ_WRAP)
}

//export USBCTRL_IRQ_IRQHandler
func interruptUSBCTRL_IRQ() {
	callHandlers(IRQ_USBCTRL_IRQ)
}

//export XIP_IRQ_IRQHandler
func interruptXIP_IRQ() {
	callHandlers(IRQ_XIP_IRQ)
}

//export PIO0_IRQ_0_IRQHandler
func interruptPIO0_IRQ_0() {
	callHandlers(IRQ_PIO0_IRQ_0)
}

//export PIO0_IRQ_1_IRQHandler
func interruptPIO0_IRQ_1() {
	callHandlers(IRQ_PIO0_IRQ_1)
}

//export PIO1_IRQ_0_IRQHandler
func interruptPIO1_IRQ_0() {
	callHandlers(IRQ_PIO1_IRQ_0)
}

//export PIO1_IRQ_1_IRQHandler
func interruptPIO1_IRQ_1() {
	callHandlers(IRQ_PIO1_IRQ_1)
}

//export DMA_IRQ_0_IRQHandler
func interruptDMA_IRQ_0() {
	callHandlers(IRQ_DMA_IRQ_0)
}

//export DMA_IRQ_1_IRQHandler
func interruptDMA_IRQ_1() {
	callHandlers(IRQ_DMA_IRQ_1)
}

//export IO_IRQ_BANK0_IRQHandler
func interruptIO_IRQ_BANK0() {
	callHandlers(IRQ_IO_IRQ_BANK0)
}

//export IO_IRQ_QSPI_IRQHandler
func interruptIO_IRQ_QSPI() {
	callHandlers(IRQ_IO_IRQ_QSPI)
}

//export SIO_IRQ_PROC0_IRQHandler
func interruptSIO_IRQ_PROC0() {
	callHandlers(IRQ_SIO_IRQ_PROC0)
}

//export SIO_IRQ_PROC1_IRQHandler
func interruptSIO_IRQ_PROC1() {
	callHandlers(IRQ_SIO_IRQ_PROC1)
}

//export CLOCKS_IRQ_IRQHandler
func interruptCLOCKS_IRQ() {
	callHandlers(IRQ_CLOCKS_IRQ)
}

//export SPI0_IRQ_IRQHandler
func interruptSPI0_IRQ() {
	callHandlers(IRQ_SPI0_IRQ)
}

//export SPI1_IRQ_IRQHandler
func interruptSPI1_IRQ() {
	callHandlers(IRQ_SPI1_IRQ)
}

//export UART0_IRQ_IRQHandler
func interruptUART0_IRQ() {
	callHandlers(IRQ_UART0_IRQ)
}

//export UART1_IRQ_IRQHandler
func interruptUART1_IRQ() {
	callHandlers(IRQ_UART1_IRQ)
}

//export ADC_IRQ_FIFO_IRQHandler
func interruptADC_IRQ_FIFO() {
	callHandlers(IRQ_ADC_IRQ_FIFO)
}

//export I2C0_IRQ_IRQHandler
func interruptI2C0_IRQ() {
	callHandlers(IRQ_I2C0_IRQ)
}

//export I2C1_IRQ_IRQHandler
func interruptI2C1_IRQ() {
	callHandlers(IRQ_I2C1_IRQ)
}

//export RTC_IRQ_IRQHandler
func interruptRTC_IRQ() {
	callHandlers(IRQ_RTC_IRQ)
}

// Peripherals.
var (
	// QSPI flash execute-in-place block
	XIP_CTRL = (*XIP_CTRL_Type)(unsafe.Pointer(uintptr(0x14000000)))

	// DW_apb_ssi has the following features:
	// * APB interface – Allows for easy integration into a DesignWare Synthesizable Components for AMBA 2 implementation.
	// * APB3 and APB4 protocol support.
	// * Scalable APB data bus width – Supports APB data bus widths of 8, 16, and 32 bits.
	// * Serial-master or serial-slave operation – Enables serial communication with serial-master or serial-slave peripheral devices.
	// * Programmable Dual/Quad/Octal SPI support in Master Mode.
	// * Dual Data Rate (DDR) and Read Data Strobe (RDS) Support - Enables the DW_apb_ssi master to perform operations with the device in DDR and RDS modes when working in Dual/Quad/Octal mode of operation.
	// * Data Mask Support - Enables the DW_apb_ssi to selectively update the bytes in the device. This feature is applicable only in enhanced SPI modes.
	// * eXecute-In-Place (XIP) support - Enables the DW_apb_ssi master to behave as a memory mapped I/O and fetches the data from the device based on the APB read request. This feature is applicable only in enhanced SPI modes.
	// * DMA Controller Interface – Enables the DW_apb_ssi to interface to a DMA controller over the bus using a handshaking interface for transfer requests.
	// * Independent masking of interrupts – Master collision, transmit FIFO overflow, transmit FIFO empty, receive FIFO full, receive FIFO underflow, and receive FIFO overflow interrupts can all be masked independently.
	// * Multi-master contention detection – Informs the processor of multiple serial-master accesses on the serial bus.
	// * Bypass of meta-stability flip-flops for synchronous clocks – When the APB clock (pclk) and the DW_apb_ssi serial clock (ssi_clk) are synchronous, meta-stable flip-flops are not used when transferring control signals across these clock domains.
	// * Programmable delay on the sample time of the received serial data bit (rxd); enables programmable control of routing delays resulting in higher serial data-bit rates.
	// * Programmable features:
	// - Serial interface operation – Choice of Motorola SPI, Texas Instruments Synchronous Serial Protocol or National Semiconductor Microwire.
	// - Clock bit-rate – Dynamic control of the serial bit rate of the data transfer; used in only serial-master mode of operation.
	// - Data Item size (4 to 32 bits) – Item size of each data transfer under the control of the programmer.
	// * Configured features:
	// - FIFO depth – 16 words deep. The FIFO width is fixed at 32 bits.
	// - 1 slave select output.
	// - Hardware slave-select – Dedicated hardware slave-select line.
	// - Combined interrupt line - one combined interrupt line from the DW_apb_ssi to the interrupt controller.
	// - Interrupt polarity – active high interrupt lines.
	// - Serial clock polarity – low serial-clock polarity directly after reset.
	// - Serial clock phase – capture on first edge of serial-clock directly after reset.
	XIP_SSI = (*XIP_SSI_Type)(unsafe.Pointer(uintptr(0x18000000)))

	SYSINFO = (*SYSINFO_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Register block for various chip control signals
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40004000)))

	CLOCKS = (*CLOCKS_Type)(unsafe.Pointer(uintptr(0x40008000)))

	RESETS = (*RESETS_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	PSM = (*PSM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	IO_BANK0 = (*IO_BANK0_Type)(unsafe.Pointer(uintptr(0x40014000)))

	IO_QSPI = (*IO_QSPI_Type)(unsafe.Pointer(uintptr(0x40018000)))

	PADS_BANK0 = (*PADS_BANK0_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	PADS_QSPI = (*PADS_QSPI_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Controls the crystal oscillator
	XOSC = (*XOSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	PLL_SYS = (*PLL_SYS_Type)(unsafe.Pointer(uintptr(0x40028000)))

	PLL_USB = (*PLL_SYS_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Register block for busfabric control signals and performance counters
	BUSCTRL = (*BUSCTRL_Type)(unsafe.Pointer(uintptr(0x40030000)))

	UART0 = (*UART0_Type)(unsafe.Pointer(uintptr(0x40034000)))

	UART1 = (*UART0_Type)(unsafe.Pointer(uintptr(0x40038000)))

	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	SPI1 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// DW_apb_i2c address block
	I2C0 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// DW_apb_i2c address block
	I2C1 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// Control and data interface to SAR ADC
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// Simple PWM
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	TIMER = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40054000)))

	WATCHDOG = (*WATCHDOG_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// Register block to control RTC
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	ROSC = (*ROSC_Type)(unsafe.Pointer(uintptr(0x40060000)))

	// control and status for on-chip voltage regulator and chip level reset subsystem
	VREG_AND_CHIP_RESET = (*VREG_AND_CHIP_RESET_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Testbench manager. Allows the programmer to know what platform their software is running on.
	TBMAN = (*TBMAN_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// DMA with separate read and write masters
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// USB FS/LS controller device registers
	USBCTRL_REGS = (*USBCTRL_REGS_Type)(unsafe.Pointer(uintptr(0x50110000)))

	// Programmable IO block
	PIO0 = (*PIO0_Type)(unsafe.Pointer(uintptr(0x50200000)))

	// Programmable IO block
	PIO1 = (*PIO0_Type)(unsafe.Pointer(uintptr(0x50300000)))

	// Single-cycle IO block
	// Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	SIO = (*SIO_Type)(unsafe.Pointer(uintptr(0xd0000000)))

	PPB = (*PPB_Type)(unsafe.Pointer(uintptr(0xe0000000)))
)

// QSPI flash execute-in-place block
type XIP_CTRL_Type struct {
	CTRL        volatile.Register32 // 0x0
	FLUSH       volatile.Register32 // 0x4
	STAT        volatile.Register32 // 0x8
	CTR_HIT     volatile.Register32 // 0xC
	CTR_ACC     volatile.Register32 // 0x10
	STREAM_ADDR volatile.Register32 // 0x14
	STREAM_CTR  volatile.Register32 // 0x18
	STREAM_FIFO volatile.Register32 // 0x1C
}

// DW_apb_ssi has the following features:
// * APB interface – Allows for easy integration into a DesignWare Synthesizable Components for AMBA 2 implementation.
// * APB3 and APB4 protocol support.
// * Scalable APB data bus width – Supports APB data bus widths of 8, 16, and 32 bits.
// * Serial-master or serial-slave operation – Enables serial communication with serial-master or serial-slave peripheral devices.
// * Programmable Dual/Quad/Octal SPI support in Master Mode.
// * Dual Data Rate (DDR) and Read Data Strobe (RDS) Support - Enables the DW_apb_ssi master to perform operations with the device in DDR and RDS modes when working in Dual/Quad/Octal mode of operation.
// * Data Mask Support - Enables the DW_apb_ssi to selectively update the bytes in the device. This feature is applicable only in enhanced SPI modes.
// * eXecute-In-Place (XIP) support - Enables the DW_apb_ssi master to behave as a memory mapped I/O and fetches the data from the device based on the APB read request. This feature is applicable only in enhanced SPI modes.
// * DMA Controller Interface – Enables the DW_apb_ssi to interface to a DMA controller over the bus using a handshaking interface for transfer requests.
// * Independent masking of interrupts – Master collision, transmit FIFO overflow, transmit FIFO empty, receive FIFO full, receive FIFO underflow, and receive FIFO overflow interrupts can all be masked independently.
// * Multi-master contention detection – Informs the processor of multiple serial-master accesses on the serial bus.
// * Bypass of meta-stability flip-flops for synchronous clocks – When the APB clock (pclk) and the DW_apb_ssi serial clock (ssi_clk) are synchronous, meta-stable flip-flops are not used when transferring control signals across these clock domains.
// * Programmable delay on the sample time of the received serial data bit (rxd); enables programmable control of routing delays resulting in higher serial data-bit rates.
// * Programmable features:
// - Serial interface operation – Choice of Motorola SPI, Texas Instruments Synchronous Serial Protocol or National Semiconductor Microwire.
// - Clock bit-rate – Dynamic control of the serial bit rate of the data transfer; used in only serial-master mode of operation.
// - Data Item size (4 to 32 bits) – Item size of each data transfer under the control of the programmer.
// * Configured features:
// - FIFO depth – 16 words deep. The FIFO width is fixed at 32 bits.
// - 1 slave select output.
// - Hardware slave-select – Dedicated hardware slave-select line.
// - Combined interrupt line - one combined interrupt line from the DW_apb_ssi to the interrupt controller.
// - Interrupt polarity – active high interrupt lines.
// - Serial clock polarity – low serial-clock polarity directly after reset.
// - Serial clock phase – capture on first edge of serial-clock directly after reset.
type XIP_SSI_Type struct {
	CTRLR0         volatile.Register32 // 0x0
	CTRLR1         volatile.Register32 // 0x4
	SSIENR         volatile.Register32 // 0x8
	MWCR           volatile.Register32 // 0xC
	SER            volatile.Register32 // 0x10
	BAUDR          volatile.Register32 // 0x14
	TXFTLR         volatile.Register32 // 0x18
	RXFTLR         volatile.Register32 // 0x1C
	TXFLR          volatile.Register32 // 0x20
	RXFLR          volatile.Register32 // 0x24
	SR             volatile.Register32 // 0x28
	IMR            volatile.Register32 // 0x2C
	ISR            volatile.Register32 // 0x30
	RISR           volatile.Register32 // 0x34
	TXOICR         volatile.Register32 // 0x38
	RXOICR         volatile.Register32 // 0x3C
	RXUICR         volatile.Register32 // 0x40
	MSTICR         volatile.Register32 // 0x44
	ICR            volatile.Register32 // 0x48
	DMACR          volatile.Register32 // 0x4C
	DMATDLR        volatile.Register32 // 0x50
	DMARDLR        volatile.Register32 // 0x54
	IDR            volatile.Register32 // 0x58
	SSI_VERSION_ID volatile.Register32 // 0x5C
	DR0            volatile.Register32 // 0x60
	_              [140]byte
	RX_SAMPLE_DLY  volatile.Register32 // 0xF0
	SPI_CTRLR0     volatile.Register32 // 0xF4
	TXD_DRIVE_EDGE volatile.Register32 // 0xF8
}

type SYSINFO_Type struct {
	CHIP_ID       volatile.Register32 // 0x0
	PLATFORM      volatile.Register32 // 0x4
	_             [56]byte
	GITREF_RP2040 volatile.Register32 // 0x40
}

// Register block for various chip control signals
type SYSCFG_Type struct {
	PROC0_NMI_MASK         volatile.Register32 // 0x0
	PROC1_NMI_MASK         volatile.Register32 // 0x4
	PROC_CONFIG            volatile.Register32 // 0x8
	PROC_IN_SYNC_BYPASS    volatile.Register32 // 0xC
	PROC_IN_SYNC_BYPASS_HI volatile.Register32 // 0x10
	DBGFORCE               volatile.Register32 // 0x14
	MEMPOWERDOWN           volatile.Register32 // 0x18
}

type CLOCKS_Type struct {
	CLK_GPOUT0_CTRL      volatile.Register32 // 0x0
	CLK_GPOUT0_DIV       volatile.Register32 // 0x4
	CLK_GPOUT0_SELECTED  volatile.Register32 // 0x8
	CLK_GPOUT1_CTRL      volatile.Register32 // 0xC
	CLK_GPOUT1_DIV       volatile.Register32 // 0x10
	CLK_GPOUT1_SELECTED  volatile.Register32 // 0x14
	CLK_GPOUT2_CTRL      volatile.Register32 // 0x18
	CLK_GPOUT2_DIV       volatile.Register32 // 0x1C
	CLK_GPOUT2_SELECTED  volatile.Register32 // 0x20
	CLK_GPOUT3_CTRL      volatile.Register32 // 0x24
	CLK_GPOUT3_DIV       volatile.Register32 // 0x28
	CLK_GPOUT3_SELECTED  volatile.Register32 // 0x2C
	CLK_REF_CTRL         volatile.Register32 // 0x30
	CLK_REF_DIV          volatile.Register32 // 0x34
	CLK_REF_SELECTED     volatile.Register32 // 0x38
	CLK_SYS_CTRL         volatile.Register32 // 0x3C
	CLK_SYS_DIV          volatile.Register32 // 0x40
	CLK_SYS_SELECTED     volatile.Register32 // 0x44
	CLK_PERI_CTRL        volatile.Register32 // 0x48
	_                    [4]byte
	CLK_PERI_SELECTED    volatile.Register32 // 0x50
	CLK_USB_CTRL         volatile.Register32 // 0x54
	CLK_USB_DIV          volatile.Register32 // 0x58
	CLK_USB_SELECTED     volatile.Register32 // 0x5C
	CLK_ADC_CTRL         volatile.Register32 // 0x60
	CLK_ADC_DIV          volatile.Register32 // 0x64
	CLK_ADC_SELECTED     volatile.Register32 // 0x68
	CLK_RTC_CTRL         volatile.Register32 // 0x6C
	CLK_RTC_DIV          volatile.Register32 // 0x70
	CLK_RTC_SELECTED     volatile.Register32 // 0x74
	CLK_SYS_RESUS_CTRL   volatile.Register32 // 0x78
	CLK_SYS_RESUS_STATUS volatile.Register32 // 0x7C
	FC0_REF_KHZ          volatile.Register32 // 0x80
	FC0_MIN_KHZ          volatile.Register32 // 0x84
	FC0_MAX_KHZ          volatile.Register32 // 0x88
	FC0_DELAY            volatile.Register32 // 0x8C
	FC0_INTERVAL         volatile.Register32 // 0x90
	FC0_SRC              volatile.Register32 // 0x94
	FC0_STATUS           volatile.Register32 // 0x98
	FC0_RESULT           volatile.Register32 // 0x9C
	WAKE_EN0             volatile.Register32 // 0xA0
	WAKE_EN1             volatile.Register32 // 0xA4
	SLEEP_EN0            volatile.Register32 // 0xA8
	SLEEP_EN1            volatile.Register32 // 0xAC
	ENABLED0             volatile.Register32 // 0xB0
	ENABLED1             volatile.Register32 // 0xB4
	INTR                 volatile.Register32 // 0xB8
	INTE                 volatile.Register32 // 0xBC
	INTF                 volatile.Register32 // 0xC0
	INTS                 volatile.Register32 // 0xC4
}

type RESETS_Type struct {
	RESET      volatile.Register32 // 0x0
	WDSEL      volatile.Register32 // 0x4
	RESET_DONE volatile.Register32 // 0x8
}

type PSM_Type struct {
	FRCE_ON  volatile.Register32 // 0x0
	FRCE_OFF volatile.Register32 // 0x4
	WDSEL    volatile.Register32 // 0x8
	DONE     volatile.Register32 // 0xC
}

type IO_BANK0_Type struct {
	GPIO0_STATUS       volatile.Register32 // 0x0
	GPIO0_CTRL         volatile.Register32 // 0x4
	GPIO1_STATUS       volatile.Register32 // 0x8
	GPIO1_CTRL         volatile.Register32 // 0xC
	GPIO2_STATUS       volatile.Register32 // 0x10
	GPIO2_CTRL         volatile.Register32 // 0x14
	GPIO3_STATUS       volatile.Register32 // 0x18
	GPIO3_CTRL         volatile.Register32 // 0x1C
	GPIO4_STATUS       volatile.Register32 // 0x20
	GPIO4_CTRL         volatile.Register32 // 0x24
	GPIO5_STATUS       volatile.Register32 // 0x28
	GPIO5_CTRL         volatile.Register32 // 0x2C
	GPIO6_STATUS       volatile.Register32 // 0x30
	GPIO6_CTRL         volatile.Register32 // 0x34
	GPIO7_STATUS       volatile.Register32 // 0x38
	GPIO7_CTRL         volatile.Register32 // 0x3C
	GPIO8_STATUS       volatile.Register32 // 0x40
	GPIO8_CTRL         volatile.Register32 // 0x44
	GPIO9_STATUS       volatile.Register32 // 0x48
	GPIO9_CTRL         volatile.Register32 // 0x4C
	GPIO10_STATUS      volatile.Register32 // 0x50
	GPIO10_CTRL        volatile.Register32 // 0x54
	GPIO11_STATUS      volatile.Register32 // 0x58
	GPIO11_CTRL        volatile.Register32 // 0x5C
	GPIO12_STATUS      volatile.Register32 // 0x60
	GPIO12_CTRL        volatile.Register32 // 0x64
	GPIO13_STATUS      volatile.Register32 // 0x68
	GPIO13_CTRL        volatile.Register32 // 0x6C
	GPIO14_STATUS      volatile.Register32 // 0x70
	GPIO14_CTRL        volatile.Register32 // 0x74
	GPIO15_STATUS      volatile.Register32 // 0x78
	GPIO15_CTRL        volatile.Register32 // 0x7C
	GPIO16_STATUS      volatile.Register32 // 0x80
	GPIO16_CTRL        volatile.Register32 // 0x84
	GPIO17_STATUS      volatile.Register32 // 0x88
	GPIO17_CTRL        volatile.Register32 // 0x8C
	GPIO18_STATUS      volatile.Register32 // 0x90
	GPIO18_CTRL        volatile.Register32 // 0x94
	GPIO19_STATUS      volatile.Register32 // 0x98
	GPIO19_CTRL        volatile.Register32 // 0x9C
	GPIO20_STATUS      volatile.Register32 // 0xA0
	GPIO20_CTRL        volatile.Register32 // 0xA4
	GPIO21_STATUS      volatile.Register32 // 0xA8
	GPIO21_CTRL        volatile.Register32 // 0xAC
	GPIO22_STATUS      volatile.Register32 // 0xB0
	GPIO22_CTRL        volatile.Register32 // 0xB4
	GPIO23_STATUS      volatile.Register32 // 0xB8
	GPIO23_CTRL        volatile.Register32 // 0xBC
	GPIO24_STATUS      volatile.Register32 // 0xC0
	GPIO24_CTRL        volatile.Register32 // 0xC4
	GPIO25_STATUS      volatile.Register32 // 0xC8
	GPIO25_CTRL        volatile.Register32 // 0xCC
	GPIO26_STATUS      volatile.Register32 // 0xD0
	GPIO26_CTRL        volatile.Register32 // 0xD4
	GPIO27_STATUS      volatile.Register32 // 0xD8
	GPIO27_CTRL        volatile.Register32 // 0xDC
	GPIO28_STATUS      volatile.Register32 // 0xE0
	GPIO28_CTRL        volatile.Register32 // 0xE4
	GPIO29_STATUS      volatile.Register32 // 0xE8
	GPIO29_CTRL        volatile.Register32 // 0xEC
	INTR0              volatile.Register32 // 0xF0
	INTR1              volatile.Register32 // 0xF4
	INTR2              volatile.Register32 // 0xF8
	INTR3              volatile.Register32 // 0xFC
	PROC0_INTE0        volatile.Register32 // 0x100
	PROC0_INTE1        volatile.Register32 // 0x104
	PROC0_INTE2        volatile.Register32 // 0x108
	PROC0_INTE3        volatile.Register32 // 0x10C
	PROC0_INTF0        volatile.Register32 // 0x110
	PROC0_INTF1        volatile.Register32 // 0x114
	PROC0_INTF2        volatile.Register32 // 0x118
	PROC0_INTF3        volatile.Register32 // 0x11C
	PROC0_INTS0        volatile.Register32 // 0x120
	PROC0_INTS1        volatile.Register32 // 0x124
	PROC0_INTS2        volatile.Register32 // 0x128
	PROC0_INTS3        volatile.Register32 // 0x12C
	PROC1_INTE0        volatile.Register32 // 0x130
	PROC1_INTE1        volatile.Register32 // 0x134
	PROC1_INTE2        volatile.Register32 // 0x138
	PROC1_INTE3        volatile.Register32 // 0x13C
	PROC1_INTF0        volatile.Register32 // 0x140
	PROC1_INTF1        volatile.Register32 // 0x144
	PROC1_INTF2        volatile.Register32 // 0x148
	PROC1_INTF3        volatile.Register32 // 0x14C
	PROC1_INTS0        volatile.Register32 // 0x150
	PROC1_INTS1        volatile.Register32 // 0x154
	PROC1_INTS2        volatile.Register32 // 0x158
	PROC1_INTS3        volatile.Register32 // 0x15C
	DORMANT_WAKE_INTE0 volatile.Register32 // 0x160
	DORMANT_WAKE_INTE1 volatile.Register32 // 0x164
	DORMANT_WAKE_INTE2 volatile.Register32 // 0x168
	DORMANT_WAKE_INTE3 volatile.Register32 // 0x16C
	DORMANT_WAKE_INTF0 volatile.Register32 // 0x170
	DORMANT_WAKE_INTF1 volatile.Register32 // 0x174
	DORMANT_WAKE_INTF2 volatile.Register32 // 0x178
	DORMANT_WAKE_INTF3 volatile.Register32 // 0x17C
	DORMANT_WAKE_INTS0 volatile.Register32 // 0x180
	DORMANT_WAKE_INTS1 volatile.Register32 // 0x184
	DORMANT_WAKE_INTS2 volatile.Register32 // 0x188
	DORMANT_WAKE_INTS3 volatile.Register32 // 0x18C
}

type IO_QSPI_Type struct {
	GPIO_QSPI_SCLK_STATUS volatile.Register32 // 0x0
	GPIO_QSPI_SCLK_CTRL   volatile.Register32 // 0x4
	GPIO_QSPI_SS_STATUS   volatile.Register32 // 0x8
	GPIO_QSPI_SS_CTRL     volatile.Register32 // 0xC
	GPIO_QSPI_SD0_STATUS  volatile.Register32 // 0x10
	GPIO_QSPI_SD0_CTRL    volatile.Register32 // 0x14
	GPIO_QSPI_SD1_STATUS  volatile.Register32 // 0x18
	GPIO_QSPI_SD1_CTRL    volatile.Register32 // 0x1C
	GPIO_QSPI_SD2_STATUS  volatile.Register32 // 0x20
	GPIO_QSPI_SD2_CTRL    volatile.Register32 // 0x24
	GPIO_QSPI_SD3_STATUS  volatile.Register32 // 0x28
	GPIO_QSPI_SD3_CTRL    volatile.Register32 // 0x2C
	INTR                  volatile.Register32 // 0x30
	PROC0_INTE            volatile.Register32 // 0x34
	PROC0_INTF            volatile.Register32 // 0x38
	PROC0_INTS            volatile.Register32 // 0x3C
	PROC1_INTE            volatile.Register32 // 0x40
	PROC1_INTF            volatile.Register32 // 0x44
	PROC1_INTS            volatile.Register32 // 0x48
	DORMANT_WAKE_INTE     volatile.Register32 // 0x4C
	DORMANT_WAKE_INTF     volatile.Register32 // 0x50
	DORMANT_WAKE_INTS     volatile.Register32 // 0x54
}

type PADS_BANK0_Type struct {
	VOLTAGE_SELECT volatile.Register32 // 0x0
	GPIO0          volatile.Register32 // 0x4
	GPIO1          volatile.Register32 // 0x8
	GPIO2          volatile.Register32 // 0xC
	GPIO3          volatile.Register32 // 0x10
	GPIO4          volatile.Register32 // 0x14
	GPIO5          volatile.Register32 // 0x18
	GPIO6          volatile.Register32 // 0x1C
	GPIO7          volatile.Register32 // 0x20
	GPIO8          volatile.Register32 // 0x24
	GPIO9          volatile.Register32 // 0x28
	GPIO10         volatile.Register32 // 0x2C
	GPIO11         volatile.Register32 // 0x30
	GPIO12         volatile.Register32 // 0x34
	GPIO13         volatile.Register32 // 0x38
	GPIO14         volatile.Register32 // 0x3C
	GPIO15         volatile.Register32 // 0x40
	GPIO16         volatile.Register32 // 0x44
	GPIO17         volatile.Register32 // 0x48
	GPIO18         volatile.Register32 // 0x4C
	GPIO19         volatile.Register32 // 0x50
	GPIO20         volatile.Register32 // 0x54
	GPIO21         volatile.Register32 // 0x58
	GPIO22         volatile.Register32 // 0x5C
	GPIO23         volatile.Register32 // 0x60
	GPIO24         volatile.Register32 // 0x64
	GPIO25         volatile.Register32 // 0x68
	GPIO26         volatile.Register32 // 0x6C
	GPIO27         volatile.Register32 // 0x70
	GPIO28         volatile.Register32 // 0x74
	GPIO29         volatile.Register32 // 0x78
	SWCLK          volatile.Register32 // 0x7C
	SWD            volatile.Register32 // 0x80
}

type PADS_QSPI_Type struct {
	VOLTAGE_SELECT volatile.Register32 // 0x0
	GPIO_QSPI_SCLK volatile.Register32 // 0x4
	GPIO_QSPI_SD0  volatile.Register32 // 0x8
	GPIO_QSPI_SD1  volatile.Register32 // 0xC
	GPIO_QSPI_SD2  volatile.Register32 // 0x10
	GPIO_QSPI_SD3  volatile.Register32 // 0x14
	GPIO_QSPI_SS   volatile.Register32 // 0x18
}

// Controls the crystal oscillator
type XOSC_Type struct {
	CTRL    volatile.Register32 // 0x0
	STATUS  volatile.Register32 // 0x4
	DORMANT volatile.Register32 // 0x8
	STARTUP volatile.Register32 // 0xC
	_       [12]byte
	COUNT   volatile.Register32 // 0x1C
}

type PLL_SYS_Type struct {
	CS        volatile.Register32 // 0x0
	PWR       volatile.Register32 // 0x4
	FBDIV_INT volatile.Register32 // 0x8
	PRIM      volatile.Register32 // 0xC
}

// Register block for busfabric control signals and performance counters
type BUSCTRL_Type struct {
	BUS_PRIORITY     volatile.Register32 // 0x0
	BUS_PRIORITY_ACK volatile.Register32 // 0x4
	PERFCTR0         volatile.Register32 // 0x8
	PERFSEL0         volatile.Register32 // 0xC
	PERFCTR1         volatile.Register32 // 0x10
	PERFSEL1         volatile.Register32 // 0x14
	PERFCTR2         volatile.Register32 // 0x18
	PERFSEL2         volatile.Register32 // 0x1C
	PERFCTR3         volatile.Register32 // 0x20
	PERFSEL3         volatile.Register32 // 0x24
}

type UART0_Type struct {
	UARTDR        volatile.Register32 // 0x0
	UARTRSR       volatile.Register32 // 0x4
	_             [16]byte
	UARTFR        volatile.Register32 // 0x18
	_             [4]byte
	UARTILPR      volatile.Register32 // 0x20
	UARTIBRD      volatile.Register32 // 0x24
	UARTFBRD      volatile.Register32 // 0x28
	UARTLCR_H     volatile.Register32 // 0x2C
	UARTCR        volatile.Register32 // 0x30
	UARTIFLS      volatile.Register32 // 0x34
	UARTIMSC      volatile.Register32 // 0x38
	UARTRIS       volatile.Register32 // 0x3C
	UARTMIS       volatile.Register32 // 0x40
	UARTICR       volatile.Register32 // 0x44
	UARTDMACR     volatile.Register32 // 0x48
	_             [3988]byte
	UARTPERIPHID0 volatile.Register32 // 0xFE0
	UARTPERIPHID1 volatile.Register32 // 0xFE4
	UARTPERIPHID2 volatile.Register32 // 0xFE8
	UARTPERIPHID3 volatile.Register32 // 0xFEC
	UARTPCELLID0  volatile.Register32 // 0xFF0
	UARTPCELLID1  volatile.Register32 // 0xFF4
	UARTPCELLID2  volatile.Register32 // 0xFF8
	UARTPCELLID3  volatile.Register32 // 0xFFC
}

type SPI0_Type struct {
	SSPCR0       volatile.Register32 // 0x0
	SSPCR1       volatile.Register32 // 0x4
	SSPDR        volatile.Register32 // 0x8
	SSPSR        volatile.Register32 // 0xC
	SSPCPSR      volatile.Register32 // 0x10
	SSPIMSC      volatile.Register32 // 0x14
	SSPRIS       volatile.Register32 // 0x18
	SSPMIS       volatile.Register32 // 0x1C
	SSPICR       volatile.Register32 // 0x20
	SSPDMACR     volatile.Register32 // 0x24
	_            [4024]byte
	SSPPERIPHID0 volatile.Register32 // 0xFE0
	SSPPERIPHID1 volatile.Register32 // 0xFE4
	SSPPERIPHID2 volatile.Register32 // 0xFE8
	SSPPERIPHID3 volatile.Register32 // 0xFEC
	SSPPCELLID0  volatile.Register32 // 0xFF0
	SSPPCELLID1  volatile.Register32 // 0xFF4
	SSPPCELLID2  volatile.Register32 // 0xFF8
	SSPPCELLID3  volatile.Register32 // 0xFFC
}

// DW_apb_i2c address block
type I2C0_Type struct {
	IC_CON                volatile.Register32 // 0x0
	IC_TAR                volatile.Register32 // 0x4
	IC_SAR                volatile.Register32 // 0x8
	_                     [4]byte
	IC_DATA_CMD           volatile.Register32 // 0x10
	IC_SS_SCL_HCNT        volatile.Register32 // 0x14
	IC_SS_SCL_LCNT        volatile.Register32 // 0x18
	IC_FS_SCL_HCNT        volatile.Register32 // 0x1C
	IC_FS_SCL_LCNT        volatile.Register32 // 0x20
	_                     [8]byte
	IC_INTR_STAT          volatile.Register32 // 0x2C
	IC_INTR_MASK          volatile.Register32 // 0x30
	IC_RAW_INTR_STAT      volatile.Register32 // 0x34
	IC_RX_TL              volatile.Register32 // 0x38
	IC_TX_TL              volatile.Register32 // 0x3C
	IC_CLR_INTR           volatile.Register32 // 0x40
	IC_CLR_RX_UNDER       volatile.Register32 // 0x44
	IC_CLR_RX_OVER        volatile.Register32 // 0x48
	IC_CLR_TX_OVER        volatile.Register32 // 0x4C
	IC_CLR_RD_REQ         volatile.Register32 // 0x50
	IC_CLR_TX_ABRT        volatile.Register32 // 0x54
	IC_CLR_RX_DONE        volatile.Register32 // 0x58
	IC_CLR_ACTIVITY       volatile.Register32 // 0x5C
	IC_CLR_STOP_DET       volatile.Register32 // 0x60
	IC_CLR_START_DET      volatile.Register32 // 0x64
	IC_CLR_GEN_CALL       volatile.Register32 // 0x68
	IC_ENABLE             volatile.Register32 // 0x6C
	IC_STATUS             volatile.Register32 // 0x70
	IC_TXFLR              volatile.Register32 // 0x74
	IC_RXFLR              volatile.Register32 // 0x78
	IC_SDA_HOLD           volatile.Register32 // 0x7C
	IC_TX_ABRT_SOURCE     volatile.Register32 // 0x80
	IC_SLV_DATA_NACK_ONLY volatile.Register32 // 0x84
	IC_DMA_CR             volatile.Register32 // 0x88
	IC_DMA_TDLR           volatile.Register32 // 0x8C
	IC_DMA_RDLR           volatile.Register32 // 0x90
	IC_SDA_SETUP          volatile.Register32 // 0x94
	IC_ACK_GENERAL_CALL   volatile.Register32 // 0x98
	IC_ENABLE_STATUS      volatile.Register32 // 0x9C
	IC_FS_SPKLEN          volatile.Register32 // 0xA0
	_                     [4]byte
	IC_CLR_RESTART_DET    volatile.Register32 // 0xA8
	_                     [72]byte
	IC_COMP_PARAM_1       volatile.Register32 // 0xF4
	IC_COMP_VERSION       volatile.Register32 // 0xF8
	IC_COMP_TYPE          volatile.Register32 // 0xFC
}

// Control and data interface to SAR ADC
type ADC_Type struct {
	CS     volatile.Register32 // 0x0
	RESULT volatile.Register32 // 0x4
	FCS    volatile.Register32 // 0x8
	FIFO   volatile.Register32 // 0xC
	DIV    volatile.Register32 // 0x10
	INTR   volatile.Register32 // 0x14
	INTE   volatile.Register32 // 0x18
	INTF   volatile.Register32 // 0x1C
	INTS   volatile.Register32 // 0x20
}

// Simple PWM
type PWM_Type struct {
	CH0_CSR volatile.Register32 // 0x0
	CH0_DIV volatile.Register32 // 0x4
	CH0_CTR volatile.Register32 // 0x8
	CH0_CC  volatile.Register32 // 0xC
	CH0_TOP volatile.Register32 // 0x10
	CH1_CSR volatile.Register32 // 0x14
	CH1_DIV volatile.Register32 // 0x18
	CH1_CTR volatile.Register32 // 0x1C
	CH1_CC  volatile.Register32 // 0x20
	CH1_TOP volatile.Register32 // 0x24
	CH2_CSR volatile.Register32 // 0x28
	CH2_DIV volatile.Register32 // 0x2C
	CH2_CTR volatile.Register32 // 0x30
	CH2_CC  volatile.Register32 // 0x34
	CH2_TOP volatile.Register32 // 0x38
	CH3_CSR volatile.Register32 // 0x3C
	CH3_DIV volatile.Register32 // 0x40
	CH3_CTR volatile.Register32 // 0x44
	CH3_CC  volatile.Register32 // 0x48
	CH3_TOP volatile.Register32 // 0x4C
	CH4_CSR volatile.Register32 // 0x50
	CH4_DIV volatile.Register32 // 0x54
	CH4_CTR volatile.Register32 // 0x58
	CH4_CC  volatile.Register32 // 0x5C
	CH4_TOP volatile.Register32 // 0x60
	CH5_CSR volatile.Register32 // 0x64
	CH5_DIV volatile.Register32 // 0x68
	CH5_CTR volatile.Register32 // 0x6C
	CH5_CC  volatile.Register32 // 0x70
	CH5_TOP volatile.Register32 // 0x74
	CH6_CSR volatile.Register32 // 0x78
	CH6_DIV volatile.Register32 // 0x7C
	CH6_CTR volatile.Register32 // 0x80
	CH6_CC  volatile.Register32 // 0x84
	CH6_TOP volatile.Register32 // 0x88
	CH7_CSR volatile.Register32 // 0x8C
	CH7_DIV volatile.Register32 // 0x90
	CH7_CTR volatile.Register32 // 0x94
	CH7_CC  volatile.Register32 // 0x98
	CH7_TOP volatile.Register32 // 0x9C
	EN      volatile.Register32 // 0xA0
	INTR    volatile.Register32 // 0xA4
	INTE    volatile.Register32 // 0xA8
	INTF    volatile.Register32 // 0xAC
	INTS    volatile.Register32 // 0xB0
}

// Controls time and alarms
// time is a 64 bit value indicating the time in usec since power-on
// timeh is the top 32 bits of time & timel is the bottom 32 bits
// to change time write to timelw before timehw
// to read time read from timelr before timehr
// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
// When an alarm is pending, the corresponding alarm_running signal will be high
// An alarm can be cancelled before it has finished by clearing the alarm_enable
// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
// To clear the interrupt write a 1 to the corresponding alarm_irq
type TIMER_Type struct {
	TIMEHW   volatile.Register32 // 0x0
	TIMELW   volatile.Register32 // 0x4
	TIMEHR   volatile.Register32 // 0x8
	TIMELR   volatile.Register32 // 0xC
	ALARM0   volatile.Register32 // 0x10
	ALARM1   volatile.Register32 // 0x14
	ALARM2   volatile.Register32 // 0x18
	ALARM3   volatile.Register32 // 0x1C
	ARMED    volatile.Register32 // 0x20
	TIMERAWH volatile.Register32 // 0x24
	TIMERAWL volatile.Register32 // 0x28
	DBGPAUSE volatile.Register32 // 0x2C
	PAUSE    volatile.Register32 // 0x30
	INTR     volatile.Register32 // 0x34
	INTE     volatile.Register32 // 0x38
	INTF     volatile.Register32 // 0x3C
	INTS     volatile.Register32 // 0x40
}

type WATCHDOG_Type struct {
	CTRL     volatile.Register32 // 0x0
	LOAD     volatile.Register32 // 0x4
	REASON   volatile.Register32 // 0x8
	SCRATCH0 volatile.Register32 // 0xC
	SCRATCH1 volatile.Register32 // 0x10
	SCRATCH2 volatile.Register32 // 0x14
	SCRATCH3 volatile.Register32 // 0x18
	SCRATCH4 volatile.Register32 // 0x1C
	SCRATCH5 volatile.Register32 // 0x20
	SCRATCH6 volatile.Register32 // 0x24
	SCRATCH7 volatile.Register32 // 0x28
	TICK     volatile.Register32 // 0x2C
}

// Register block to control RTC
type RTC_Type struct {
	CLKDIV_M1   volatile.Register32 // 0x0
	SETUP_0     volatile.Register32 // 0x4
	SETUP_1     volatile.Register32 // 0x8
	CTRL        volatile.Register32 // 0xC
	IRQ_SETUP_0 volatile.Register32 // 0x10
	IRQ_SETUP_1 volatile.Register32 // 0x14
	RTC_1       volatile.Register32 // 0x18
	RTC_0       volatile.Register32 // 0x1C
	INTR        volatile.Register32 // 0x20
	INTE        volatile.Register32 // 0x24
	INTF        volatile.Register32 // 0x28
	INTS        volatile.Register32 // 0x2C
}

type ROSC_Type struct {
	CTRL      volatile.Register32 // 0x0
	FREQA     volatile.Register32 // 0x4
	FREQB     volatile.Register32 // 0x8
	DORMANT   volatile.Register32 // 0xC
	DIV       volatile.Register32 // 0x10
	PHASE     volatile.Register32 // 0x14
	STATUS    volatile.Register32 // 0x18
	RANDOMBIT volatile.Register32 // 0x1C
	COUNT     volatile.Register32 // 0x20
}

// control and status for on-chip voltage regulator and chip level reset subsystem
type VREG_AND_CHIP_RESET_Type struct {
	VREG       volatile.Register32 // 0x0
	BOD        volatile.Register32 // 0x4
	CHIP_RESET volatile.Register32 // 0x8
}

// Testbench manager. Allows the programmer to know what platform their software is running on.
type TBMAN_Type struct {
	PLATFORM volatile.Register32 // 0x0
}

// DMA with separate read and write masters
type DMA_Type struct {
	CH0_READ_ADDR             volatile.Register32 // 0x0
	CH0_WRITE_ADDR            volatile.Register32 // 0x4
	CH0_TRANS_COUNT           volatile.Register32 // 0x8
	CH0_CTRL_TRIG             volatile.Register32 // 0xC
	CH0_AL1_CTRL              volatile.Register32 // 0x10
	CH0_AL1_READ_ADDR         volatile.Register32 // 0x14
	CH0_AL1_WRITE_ADDR        volatile.Register32 // 0x18
	CH0_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0x1C
	CH0_AL2_CTRL              volatile.Register32 // 0x20
	CH0_AL2_TRANS_COUNT       volatile.Register32 // 0x24
	CH0_AL2_READ_ADDR         volatile.Register32 // 0x28
	CH0_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0x2C
	CH0_AL3_CTRL              volatile.Register32 // 0x30
	CH0_AL3_WRITE_ADDR        volatile.Register32 // 0x34
	CH0_AL3_TRANS_COUNT       volatile.Register32 // 0x38
	CH0_AL3_READ_ADDR_TRIG    volatile.Register32 // 0x3C
	CH1_READ_ADDR             volatile.Register32 // 0x40
	CH1_WRITE_ADDR            volatile.Register32 // 0x44
	CH1_TRANS_COUNT           volatile.Register32 // 0x48
	CH1_CTRL_TRIG             volatile.Register32 // 0x4C
	CH1_AL1_CTRL              volatile.Register32 // 0x50
	CH1_AL1_READ_ADDR         volatile.Register32 // 0x54
	CH1_AL1_WRITE_ADDR        volatile.Register32 // 0x58
	CH1_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0x5C
	CH1_AL2_CTRL              volatile.Register32 // 0x60
	CH1_AL2_TRANS_COUNT       volatile.Register32 // 0x64
	CH1_AL2_READ_ADDR         volatile.Register32 // 0x68
	CH1_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0x6C
	CH1_AL3_CTRL              volatile.Register32 // 0x70
	CH1_AL3_WRITE_ADDR        volatile.Register32 // 0x74
	CH1_AL3_TRANS_COUNT       volatile.Register32 // 0x78
	CH1_AL3_READ_ADDR_TRIG    volatile.Register32 // 0x7C
	CH2_READ_ADDR             volatile.Register32 // 0x80
	CH2_WRITE_ADDR            volatile.Register32 // 0x84
	CH2_TRANS_COUNT           volatile.Register32 // 0x88
	CH2_CTRL_TRIG             volatile.Register32 // 0x8C
	CH2_AL1_CTRL              volatile.Register32 // 0x90
	CH2_AL1_READ_ADDR         volatile.Register32 // 0x94
	CH2_AL1_WRITE_ADDR        volatile.Register32 // 0x98
	CH2_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0x9C
	CH2_AL2_CTRL              volatile.Register32 // 0xA0
	CH2_AL2_TRANS_COUNT       volatile.Register32 // 0xA4
	CH2_AL2_READ_ADDR         volatile.Register32 // 0xA8
	CH2_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0xAC
	CH2_AL3_CTRL              volatile.Register32 // 0xB0
	CH2_AL3_WRITE_ADDR        volatile.Register32 // 0xB4
	CH2_AL3_TRANS_COUNT       volatile.Register32 // 0xB8
	CH2_AL3_READ_ADDR_TRIG    volatile.Register32 // 0xBC
	CH3_READ_ADDR             volatile.Register32 // 0xC0
	CH3_WRITE_ADDR            volatile.Register32 // 0xC4
	CH3_TRANS_COUNT           volatile.Register32 // 0xC8
	CH3_CTRL_TRIG             volatile.Register32 // 0xCC
	CH3_AL1_CTRL              volatile.Register32 // 0xD0
	CH3_AL1_READ_ADDR         volatile.Register32 // 0xD4
	CH3_AL1_WRITE_ADDR        volatile.Register32 // 0xD8
	CH3_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0xDC
	CH3_AL2_CTRL              volatile.Register32 // 0xE0
	CH3_AL2_TRANS_COUNT       volatile.Register32 // 0xE4
	CH3_AL2_READ_ADDR         volatile.Register32 // 0xE8
	CH3_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0xEC
	CH3_AL3_CTRL              volatile.Register32 // 0xF0
	CH3_AL3_WRITE_ADDR        volatile.Register32 // 0xF4
	CH3_AL3_TRANS_COUNT       volatile.Register32 // 0xF8
	CH3_AL3_READ_ADDR_TRIG    volatile.Register32 // 0xFC
	CH4_READ_ADDR             volatile.Register32 // 0x100
	CH4_WRITE_ADDR            volatile.Register32 // 0x104
	CH4_TRANS_COUNT           volatile.Register32 // 0x108
	CH4_CTRL_TRIG             volatile.Register32 // 0x10C
	CH4_AL1_CTRL              volatile.Register32 // 0x110
	CH4_AL1_READ_ADDR         volatile.Register32 // 0x114
	CH4_AL1_WRITE_ADDR        volatile.Register32 // 0x118
	CH4_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0x11C
	CH4_AL2_CTRL              volatile.Register32 // 0x120
	CH4_AL2_TRANS_COUNT       volatile.Register32 // 0x124
	CH4_AL2_READ_ADDR         volatile.Register32 // 0x128
	CH4_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0x12C
	CH4_AL3_CTRL              volatile.Register32 // 0x130
	CH4_AL3_WRITE_ADDR        volatile.Register32 // 0x134
	CH4_AL3_TRANS_COUNT       volatile.Register32 // 0x138
	CH4_AL3_READ_ADDR_TRIG    volatile.Register32 // 0x13C
	CH5_READ_ADDR             volatile.Register32 // 0x140
	CH5_WRITE_ADDR            volatile.Register32 // 0x144
	CH5_TRANS_COUNT           volatile.Register32 // 0x148
	CH5_CTRL_TRIG             volatile.Register32 // 0x14C
	CH5_AL1_CTRL              volatile.Register32 // 0x150
	CH5_AL1_READ_ADDR         volatile.Register32 // 0x154
	CH5_AL1_WRITE_ADDR        volatile.Register32 // 0x158
	CH5_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0x15C
	CH5_AL2_CTRL              volatile.Register32 // 0x160
	CH5_AL2_TRANS_COUNT       volatile.Register32 // 0x164
	CH5_AL2_READ_ADDR         volatile.Register32 // 0x168
	CH5_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0x16C
	CH5_AL3_CTRL              volatile.Register32 // 0x170
	CH5_AL3_WRITE_ADDR        volatile.Register32 // 0x174
	CH5_AL3_TRANS_COUNT       volatile.Register32 // 0x178
	CH5_AL3_READ_ADDR_TRIG    volatile.Register32 // 0x17C
	CH6_READ_ADDR             volatile.Register32 // 0x180
	CH6_WRITE_ADDR            volatile.Register32 // 0x184
	CH6_TRANS_COUNT           volatile.Register32 // 0x188
	CH6_CTRL_TRIG             volatile.Register32 // 0x18C
	CH6_AL1_CTRL              volatile.Register32 // 0x190
	CH6_AL1_READ_ADDR         volatile.Register32 // 0x194
	CH6_AL1_WRITE_ADDR        volatile.Register32 // 0x198
	CH6_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0x19C
	CH6_AL2_CTRL              volatile.Register32 // 0x1A0
	CH6_AL2_TRANS_COUNT       volatile.Register32 // 0x1A4
	CH6_AL2_READ_ADDR         volatile.Register32 // 0x1A8
	CH6_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0x1AC
	CH6_AL3_CTRL              volatile.Register32 // 0x1B0
	CH6_AL3_WRITE_ADDR        volatile.Register32 // 0x1B4
	CH6_AL3_TRANS_COUNT       volatile.Register32 // 0x1B8
	CH6_AL3_READ_ADDR_TRIG    volatile.Register32 // 0x1BC
	CH7_READ_ADDR             volatile.Register32 // 0x1C0
	CH7_WRITE_ADDR            volatile.Register32 // 0x1C4
	CH7_TRANS_COUNT           volatile.Register32 // 0x1C8
	CH7_CTRL_TRIG             volatile.Register32 // 0x1CC
	CH7_AL1_CTRL              volatile.Register32 // 0x1D0
	CH7_AL1_READ_ADDR         volatile.Register32 // 0x1D4
	CH7_AL1_WRITE_ADDR        volatile.Register32 // 0x1D8
	CH7_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0x1DC
	CH7_AL2_CTRL              volatile.Register32 // 0x1E0
	CH7_AL2_TRANS_COUNT       volatile.Register32 // 0x1E4
	CH7_AL2_READ_ADDR         volatile.Register32 // 0x1E8
	CH7_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0x1EC
	CH7_AL3_CTRL              volatile.Register32 // 0x1F0
	CH7_AL3_WRITE_ADDR        volatile.Register32 // 0x1F4
	CH7_AL3_TRANS_COUNT       volatile.Register32 // 0x1F8
	CH7_AL3_READ_ADDR_TRIG    volatile.Register32 // 0x1FC
	CH8_READ_ADDR             volatile.Register32 // 0x200
	CH8_WRITE_ADDR            volatile.Register32 // 0x204
	CH8_TRANS_COUNT           volatile.Register32 // 0x208
	CH8_CTRL_TRIG             volatile.Register32 // 0x20C
	CH8_AL1_CTRL              volatile.Register32 // 0x210
	CH8_AL1_READ_ADDR         volatile.Register32 // 0x214
	CH8_AL1_WRITE_ADDR        volatile.Register32 // 0x218
	CH8_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0x21C
	CH8_AL2_CTRL              volatile.Register32 // 0x220
	CH8_AL2_TRANS_COUNT       volatile.Register32 // 0x224
	CH8_AL2_READ_ADDR         volatile.Register32 // 0x228
	CH8_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0x22C
	CH8_AL3_CTRL              volatile.Register32 // 0x230
	CH8_AL3_WRITE_ADDR        volatile.Register32 // 0x234
	CH8_AL3_TRANS_COUNT       volatile.Register32 // 0x238
	CH8_AL3_READ_ADDR_TRIG    volatile.Register32 // 0x23C
	CH9_READ_ADDR             volatile.Register32 // 0x240
	CH9_WRITE_ADDR            volatile.Register32 // 0x244
	CH9_TRANS_COUNT           volatile.Register32 // 0x248
	CH9_CTRL_TRIG             volatile.Register32 // 0x24C
	CH9_AL1_CTRL              volatile.Register32 // 0x250
	CH9_AL1_READ_ADDR         volatile.Register32 // 0x254
	CH9_AL1_WRITE_ADDR        volatile.Register32 // 0x258
	CH9_AL1_TRANS_COUNT_TRIG  volatile.Register32 // 0x25C
	CH9_AL2_CTRL              volatile.Register32 // 0x260
	CH9_AL2_TRANS_COUNT       volatile.Register32 // 0x264
	CH9_AL2_READ_ADDR         volatile.Register32 // 0x268
	CH9_AL2_WRITE_ADDR_TRIG   volatile.Register32 // 0x26C
	CH9_AL3_CTRL              volatile.Register32 // 0x270
	CH9_AL3_WRITE_ADDR        volatile.Register32 // 0x274
	CH9_AL3_TRANS_COUNT       volatile.Register32 // 0x278
	CH9_AL3_READ_ADDR_TRIG    volatile.Register32 // 0x27C
	CH10_READ_ADDR            volatile.Register32 // 0x280
	CH10_WRITE_ADDR           volatile.Register32 // 0x284
	CH10_TRANS_COUNT          volatile.Register32 // 0x288
	CH10_CTRL_TRIG            volatile.Register32 // 0x28C
	CH10_AL1_CTRL             volatile.Register32 // 0x290
	CH10_AL1_READ_ADDR        volatile.Register32 // 0x294
	CH10_AL1_WRITE_ADDR       volatile.Register32 // 0x298
	CH10_AL1_TRANS_COUNT_TRIG volatile.Register32 // 0x29C
	CH10_AL2_CTRL             volatile.Register32 // 0x2A0
	CH10_AL2_TRANS_COUNT      volatile.Register32 // 0x2A4
	CH10_AL2_READ_ADDR        volatile.Register32 // 0x2A8
	CH10_AL2_WRITE_ADDR_TRIG  volatile.Register32 // 0x2AC
	CH10_AL3_CTRL             volatile.Register32 // 0x2B0
	CH10_AL3_WRITE_ADDR       volatile.Register32 // 0x2B4
	CH10_AL3_TRANS_COUNT      volatile.Register32 // 0x2B8
	CH10_AL3_READ_ADDR_TRIG   volatile.Register32 // 0x2BC
	CH11_READ_ADDR            volatile.Register32 // 0x2C0
	CH11_WRITE_ADDR           volatile.Register32 // 0x2C4
	CH11_TRANS_COUNT          volatile.Register32 // 0x2C8
	CH11_CTRL_TRIG            volatile.Register32 // 0x2CC
	CH11_AL1_CTRL             volatile.Register32 // 0x2D0
	CH11_AL1_READ_ADDR        volatile.Register32 // 0x2D4
	CH11_AL1_WRITE_ADDR       volatile.Register32 // 0x2D8
	CH11_AL1_TRANS_COUNT_TRIG volatile.Register32 // 0x2DC
	CH11_AL2_CTRL             volatile.Register32 // 0x2E0
	CH11_AL2_TRANS_COUNT      volatile.Register32 // 0x2E4
	CH11_AL2_READ_ADDR        volatile.Register32 // 0x2E8
	CH11_AL2_WRITE_ADDR_TRIG  volatile.Register32 // 0x2EC
	CH11_AL3_CTRL             volatile.Register32 // 0x2F0
	CH11_AL3_WRITE_ADDR       volatile.Register32 // 0x2F4
	CH11_AL3_TRANS_COUNT      volatile.Register32 // 0x2F8
	CH11_AL3_READ_ADDR_TRIG   volatile.Register32 // 0x2FC
	_                         [256]byte
	INTR                      volatile.Register32 // 0x400
	INTE0                     volatile.Register32 // 0x404
	INTF0                     volatile.Register32 // 0x408
	INTS0                     volatile.Register32 // 0x40C
	_                         [4]byte
	INTE1                     volatile.Register32 // 0x414
	INTF1                     volatile.Register32 // 0x418
	INTS1                     volatile.Register32 // 0x41C
	TIMER0                    volatile.Register32 // 0x420
	TIMER1                    volatile.Register32 // 0x424
	_                         [8]byte
	MULTI_CHAN_TRIGGER        volatile.Register32 // 0x430
	SNIFF_CTRL                volatile.Register32 // 0x434
	SNIFF_DATA                volatile.Register32 // 0x438
	_                         [4]byte
	FIFO_LEVELS               volatile.Register32 // 0x440
	CHAN_ABORT                volatile.Register32 // 0x444
	N_CHANNELS                volatile.Register32 // 0x448
	_                         [948]byte
	CH0_DBG_CTDREQ            volatile.Register32 // 0x800
	CH0_DBG_TCR               volatile.Register32 // 0x804
	_                         [56]byte
	CH1_DBG_CTDREQ            volatile.Register32 // 0x840
	CH1_DBG_TCR               volatile.Register32 // 0x844
	_                         [56]byte
	CH2_DBG_CTDREQ            volatile.Register32 // 0x880
	CH2_DBG_TCR               volatile.Register32 // 0x884
	_                         [56]byte
	CH3_DBG_CTDREQ            volatile.Register32 // 0x8C0
	CH3_DBG_TCR               volatile.Register32 // 0x8C4
	_                         [56]byte
	CH4_DBG_CTDREQ            volatile.Register32 // 0x900
	CH4_DBG_TCR               volatile.Register32 // 0x904
	_                         [56]byte
	CH5_DBG_CTDREQ            volatile.Register32 // 0x940
	CH5_DBG_TCR               volatile.Register32 // 0x944
	_                         [56]byte
	CH6_DBG_CTDREQ            volatile.Register32 // 0x980
	CH6_DBG_TCR               volatile.Register32 // 0x984
	_                         [56]byte
	CH7_DBG_CTDREQ            volatile.Register32 // 0x9C0
	CH7_DBG_TCR               volatile.Register32 // 0x9C4
	_                         [56]byte
	CH8_DBG_CTDREQ            volatile.Register32 // 0xA00
	CH8_DBG_TCR               volatile.Register32 // 0xA04
	_                         [56]byte
	CH9_DBG_CTDREQ            volatile.Register32 // 0xA40
	CH9_DBG_TCR               volatile.Register32 // 0xA44
	_                         [56]byte
	CH10_DBG_CTDREQ           volatile.Register32 // 0xA80
	CH10_DBG_TCR              volatile.Register32 // 0xA84
	_                         [56]byte
	CH11_DBG_CTDREQ           volatile.Register32 // 0xAC0
	CH11_DBG_TCR              volatile.Register32 // 0xAC4
}

// USB FS/LS controller device registers
type USBCTRL_REGS_Type struct {
	ADDR_ENDP              volatile.Register32 // 0x0
	ADDR_ENDP1             volatile.Register32 // 0x4
	ADDR_ENDP2             volatile.Register32 // 0x8
	ADDR_ENDP3             volatile.Register32 // 0xC
	ADDR_ENDP4             volatile.Register32 // 0x10
	ADDR_ENDP5             volatile.Register32 // 0x14
	ADDR_ENDP6             volatile.Register32 // 0x18
	ADDR_ENDP7             volatile.Register32 // 0x1C
	ADDR_ENDP8             volatile.Register32 // 0x20
	ADDR_ENDP9             volatile.Register32 // 0x24
	ADDR_ENDP10            volatile.Register32 // 0x28
	ADDR_ENDP11            volatile.Register32 // 0x2C
	ADDR_ENDP12            volatile.Register32 // 0x30
	ADDR_ENDP13            volatile.Register32 // 0x34
	ADDR_ENDP14            volatile.Register32 // 0x38
	ADDR_ENDP15            volatile.Register32 // 0x3C
	MAIN_CTRL              volatile.Register32 // 0x40
	SOF_WR                 volatile.Register32 // 0x44
	SOF_RD                 volatile.Register32 // 0x48
	SIE_CTRL               volatile.Register32 // 0x4C
	SIE_STATUS             volatile.Register32 // 0x50
	INT_EP_CTRL            volatile.Register32 // 0x54
	BUFF_STATUS            volatile.Register32 // 0x58
	BUFF_CPU_SHOULD_HANDLE volatile.Register32 // 0x5C
	EP_ABORT               volatile.Register32 // 0x60
	EP_ABORT_DONE          volatile.Register32 // 0x64
	EP_STALL_ARM           volatile.Register32 // 0x68
	NAK_POLL               volatile.Register32 // 0x6C
	EP_STATUS_STALL_NAK    volatile.Register32 // 0x70
	USB_MUXING             volatile.Register32 // 0x74
	USB_PWR                volatile.Register32 // 0x78
	USBPHY_DIRECT          volatile.Register32 // 0x7C
	USBPHY_DIRECT_OVERRIDE volatile.Register32 // 0x80
	USBPHY_TRIM            volatile.Register32 // 0x84
	_                      [4]byte
	INTR                   volatile.Register32 // 0x8C
	INTE                   volatile.Register32 // 0x90
	INTF                   volatile.Register32 // 0x94
	INTS                   volatile.Register32 // 0x98
}

// Programmable IO block
type PIO0_Type struct {
	CTRL              volatile.Register32 // 0x0
	FSTAT             volatile.Register32 // 0x4
	FDEBUG            volatile.Register32 // 0x8
	FLEVEL            volatile.Register32 // 0xC
	TXF0              volatile.Register32 // 0x10
	TXF1              volatile.Register32 // 0x14
	TXF2              volatile.Register32 // 0x18
	TXF3              volatile.Register32 // 0x1C
	RXF0              volatile.Register32 // 0x20
	RXF1              volatile.Register32 // 0x24
	RXF2              volatile.Register32 // 0x28
	RXF3              volatile.Register32 // 0x2C
	IRQ               volatile.Register32 // 0x30
	IRQ_FORCE         volatile.Register32 // 0x34
	INPUT_SYNC_BYPASS volatile.Register32 // 0x38
	DBG_PADOUT        volatile.Register32 // 0x3C
	DBG_PADOE         volatile.Register32 // 0x40
	DBG_CFGINFO       volatile.Register32 // 0x44
	INSTR_MEM0        volatile.Register32 // 0x48
	INSTR_MEM1        volatile.Register32 // 0x4C
	INSTR_MEM2        volatile.Register32 // 0x50
	INSTR_MEM3        volatile.Register32 // 0x54
	INSTR_MEM4        volatile.Register32 // 0x58
	INSTR_MEM5        volatile.Register32 // 0x5C
	INSTR_MEM6        volatile.Register32 // 0x60
	INSTR_MEM7        volatile.Register32 // 0x64
	INSTR_MEM8        volatile.Register32 // 0x68
	INSTR_MEM9        volatile.Register32 // 0x6C
	INSTR_MEM10       volatile.Register32 // 0x70
	INSTR_MEM11       volatile.Register32 // 0x74
	INSTR_MEM12       volatile.Register32 // 0x78
	INSTR_MEM13       volatile.Register32 // 0x7C
	INSTR_MEM14       volatile.Register32 // 0x80
	INSTR_MEM15       volatile.Register32 // 0x84
	INSTR_MEM16       volatile.Register32 // 0x88
	INSTR_MEM17       volatile.Register32 // 0x8C
	INSTR_MEM18       volatile.Register32 // 0x90
	INSTR_MEM19       volatile.Register32 // 0x94
	INSTR_MEM20       volatile.Register32 // 0x98
	INSTR_MEM21       volatile.Register32 // 0x9C
	INSTR_MEM22       volatile.Register32 // 0xA0
	INSTR_MEM23       volatile.Register32 // 0xA4
	INSTR_MEM24       volatile.Register32 // 0xA8
	INSTR_MEM25       volatile.Register32 // 0xAC
	INSTR_MEM26       volatile.Register32 // 0xB0
	INSTR_MEM27       volatile.Register32 // 0xB4
	INSTR_MEM28       volatile.Register32 // 0xB8
	INSTR_MEM29       volatile.Register32 // 0xBC
	INSTR_MEM30       volatile.Register32 // 0xC0
	INSTR_MEM31       volatile.Register32 // 0xC4
	SM0_CLKDIV        volatile.Register32 // 0xC8
	SM0_EXECCTRL      volatile.Register32 // 0xCC
	SM0_SHIFTCTRL     volatile.Register32 // 0xD0
	SM0_ADDR          volatile.Register32 // 0xD4
	SM0_INSTR         volatile.Register32 // 0xD8
	SM0_PINCTRL       volatile.Register32 // 0xDC
	SM1_CLKDIV        volatile.Register32 // 0xE0
	SM1_EXECCTRL      volatile.Register32 // 0xE4
	SM1_SHIFTCTRL     volatile.Register32 // 0xE8
	SM1_ADDR          volatile.Register32 // 0xEC
	SM1_INSTR         volatile.Register32 // 0xF0
	SM1_PINCTRL       volatile.Register32 // 0xF4
	SM2_CLKDIV        volatile.Register32 // 0xF8
	SM2_EXECCTRL      volatile.Register32 // 0xFC
	SM2_SHIFTCTRL     volatile.Register32 // 0x100
	SM2_ADDR          volatile.Register32 // 0x104
	SM2_INSTR         volatile.Register32 // 0x108
	SM2_PINCTRL       volatile.Register32 // 0x10C
	SM3_CLKDIV        volatile.Register32 // 0x110
	SM3_EXECCTRL      volatile.Register32 // 0x114
	SM3_SHIFTCTRL     volatile.Register32 // 0x118
	SM3_ADDR          volatile.Register32 // 0x11C
	SM3_INSTR         volatile.Register32 // 0x120
	SM3_PINCTRL       volatile.Register32 // 0x124
	INTR              volatile.Register32 // 0x128
	IRQ0_INTE         volatile.Register32 // 0x12C
	IRQ0_INTF         volatile.Register32 // 0x130
	IRQ0_INTS         volatile.Register32 // 0x134
	IRQ1_INTE         volatile.Register32 // 0x138
	IRQ1_INTF         volatile.Register32 // 0x13C
	IRQ1_INTS         volatile.Register32 // 0x140
}

// Single-cycle IO block
// Provides core-local and inter-core hardware for the two processors, with single-cycle access.
type SIO_Type struct {
	CPUID              volatile.Register32 // 0x0
	GPIO_IN            volatile.Register32 // 0x4
	GPIO_HI_IN         volatile.Register32 // 0x8
	_                  [4]byte
	GPIO_OUT           volatile.Register32 // 0x10
	GPIO_OUT_SET       volatile.Register32 // 0x14
	GPIO_OUT_CLR       volatile.Register32 // 0x18
	GPIO_OUT_XOR       volatile.Register32 // 0x1C
	GPIO_OE            volatile.Register32 // 0x20
	GPIO_OE_SET        volatile.Register32 // 0x24
	GPIO_OE_CLR        volatile.Register32 // 0x28
	GPIO_OE_XOR        volatile.Register32 // 0x2C
	GPIO_HI_OUT        volatile.Register32 // 0x30
	GPIO_HI_OUT_SET    volatile.Register32 // 0x34
	GPIO_HI_OUT_CLR    volatile.Register32 // 0x38
	GPIO_HI_OUT_XOR    volatile.Register32 // 0x3C
	GPIO_HI_OE         volatile.Register32 // 0x40
	GPIO_HI_OE_SET     volatile.Register32 // 0x44
	GPIO_HI_OE_CLR     volatile.Register32 // 0x48
	GPIO_HI_OE_XOR     volatile.Register32 // 0x4C
	FIFO_ST            volatile.Register32 // 0x50
	FIFO_WR            volatile.Register32 // 0x54
	FIFO_RD            volatile.Register32 // 0x58
	SPINLOCK_ST        volatile.Register32 // 0x5C
	DIV_UDIVIDEND      volatile.Register32 // 0x60
	DIV_UDIVISOR       volatile.Register32 // 0x64
	DIV_SDIVIDEND      volatile.Register32 // 0x68
	DIV_SDIVISOR       volatile.Register32 // 0x6C
	DIV_QUOTIENT       volatile.Register32 // 0x70
	DIV_REMAINDER      volatile.Register32 // 0x74
	DIV_CSR            volatile.Register32 // 0x78
	_                  [4]byte
	INTERP0_ACCUM0     volatile.Register32 // 0x80
	INTERP0_ACCUM1     volatile.Register32 // 0x84
	INTERP0_BASE0      volatile.Register32 // 0x88
	INTERP0_BASE1      volatile.Register32 // 0x8C
	INTERP0_BASE2      volatile.Register32 // 0x90
	INTERP0_POP_LANE0  volatile.Register32 // 0x94
	INTERP0_POP_LANE1  volatile.Register32 // 0x98
	INTERP0_POP_FULL   volatile.Register32 // 0x9C
	INTERP0_PEEK_LANE0 volatile.Register32 // 0xA0
	INTERP0_PEEK_LANE1 volatile.Register32 // 0xA4
	INTERP0_PEEK_FULL  volatile.Register32 // 0xA8
	INTERP0_CTRL_LANE0 volatile.Register32 // 0xAC
	INTERP0_CTRL_LANE1 volatile.Register32 // 0xB0
	INTERP0_ACCUM0_ADD volatile.Register32 // 0xB4
	INTERP0_ACCUM1_ADD volatile.Register32 // 0xB8
	INTERP0_BASE_1AND0 volatile.Register32 // 0xBC
	INTERP1_ACCUM0     volatile.Register32 // 0xC0
	INTERP1_ACCUM1     volatile.Register32 // 0xC4
	INTERP1_BASE0      volatile.Register32 // 0xC8
	INTERP1_BASE1      volatile.Register32 // 0xCC
	INTERP1_BASE2      volatile.Register32 // 0xD0
	INTERP1_POP_LANE0  volatile.Register32 // 0xD4
	INTERP1_POP_LANE1  volatile.Register32 // 0xD8
	INTERP1_POP_FULL   volatile.Register32 // 0xDC
	INTERP1_PEEK_LANE0 volatile.Register32 // 0xE0
	INTERP1_PEEK_LANE1 volatile.Register32 // 0xE4
	INTERP1_PEEK_FULL  volatile.Register32 // 0xE8
	INTERP1_CTRL_LANE0 volatile.Register32 // 0xEC
	INTERP1_CTRL_LANE1 volatile.Register32 // 0xF0
	INTERP1_ACCUM0_ADD volatile.Register32 // 0xF4
	INTERP1_ACCUM1_ADD volatile.Register32 // 0xF8
	INTERP1_BASE_1AND0 volatile.Register32 // 0xFC
	SPINLOCK0          volatile.Register32 // 0x100
	SPINLOCK1          volatile.Register32 // 0x104
	SPINLOCK2          volatile.Register32 // 0x108
	SPINLOCK3          volatile.Register32 // 0x10C
	SPINLOCK4          volatile.Register32 // 0x110
	SPINLOCK5          volatile.Register32 // 0x114
	SPINLOCK6          volatile.Register32 // 0x118
	SPINLOCK7          volatile.Register32 // 0x11C
	SPINLOCK8          volatile.Register32 // 0x120
	SPINLOCK9          volatile.Register32 // 0x124
	SPINLOCK10         volatile.Register32 // 0x128
	SPINLOCK11         volatile.Register32 // 0x12C
	SPINLOCK12         volatile.Register32 // 0x130
	SPINLOCK13         volatile.Register32 // 0x134
	SPINLOCK14         volatile.Register32 // 0x138
	SPINLOCK15         volatile.Register32 // 0x13C
	SPINLOCK16         volatile.Register32 // 0x140
	SPINLOCK17         volatile.Register32 // 0x144
	SPINLOCK18         volatile.Register32 // 0x148
	SPINLOCK19         volatile.Register32 // 0x14C
	SPINLOCK20         volatile.Register32 // 0x150
	SPINLOCK21         volatile.Register32 // 0x154
	SPINLOCK22         volatile.Register32 // 0x158
	SPINLOCK23         volatile.Register32 // 0x15C
	SPINLOCK24         volatile.Register32 // 0x160
	SPINLOCK25         volatile.Register32 // 0x164
	SPINLOCK26         volatile.Register32 // 0x168
	SPINLOCK27         volatile.Register32 // 0x16C
	SPINLOCK28         volatile.Register32 // 0x170
	SPINLOCK29         volatile.Register32 // 0x174
	SPINLOCK30         volatile.Register32 // 0x178
	SPINLOCK31         volatile.Register32 // 0x17C
}

type PPB_Type struct {
	_          [57360]byte
	SYST_CSR   volatile.Register32 // 0xE010
	SYST_RVR   volatile.Register32 // 0xE014
	SYST_CVR   volatile.Register32 // 0xE018
	SYST_CALIB volatile.Register32 // 0xE01C
	_          [224]byte
	NVIC_ISER  volatile.Register32 // 0xE100
	_          [124]byte
	NVIC_ICER  volatile.Register32 // 0xE180
	_          [124]byte
	NVIC_ISPR  volatile.Register32 // 0xE200
	_          [124]byte
	NVIC_ICPR  volatile.Register32 // 0xE280
	_          [380]byte
	NVIC_IPR0  volatile.Register32 // 0xE400
	NVIC_IPR1  volatile.Register32 // 0xE404
	NVIC_IPR2  volatile.Register32 // 0xE408
	NVIC_IPR3  volatile.Register32 // 0xE40C
	NVIC_IPR4  volatile.Register32 // 0xE410
	NVIC_IPR5  volatile.Register32 // 0xE414
	NVIC_IPR6  volatile.Register32 // 0xE418
	NVIC_IPR7  volatile.Register32 // 0xE41C
	_          [2272]byte
	CPUID      volatile.Register32 // 0xED00
	ICSR       volatile.Register32 // 0xED04
	VTOR       volatile.Register32 // 0xED08
	AIRCR      volatile.Register32 // 0xED0C
	SCR        volatile.Register32 // 0xED10
	CCR        volatile.Register32 // 0xED14
	_          [4]byte
	SHPR2      volatile.Register32 // 0xED1C
	SHPR3      volatile.Register32 // 0xED20
	SHCSR      volatile.Register32 // 0xED24
	_          [104]byte
	MPU_TYPE   volatile.Register32 // 0xED90
	MPU_CTRL   volatile.Register32 // 0xED94
	MPU_RNR    volatile.Register32 // 0xED98
	MPU_RBAR   volatile.Register32 // 0xED9C
	MPU_RASR   volatile.Register32 // 0xEDA0
}

// Bitfields for XIP_CTRL: QSPI flash execute-in-place block
const (
	// CTRL: Cache control
	// Position of POWER_DOWN field.
	XIP_CTRL_CTRL_POWER_DOWN_Pos = 0x3
	// Bit mask of POWER_DOWN field.
	XIP_CTRL_CTRL_POWER_DOWN_Msk = 0x8
	// Bit POWER_DOWN.
	XIP_CTRL_CTRL_POWER_DOWN = 0x8
	// Position of ERR_BADWRITE field.
	XIP_CTRL_CTRL_ERR_BADWRITE_Pos = 0x1
	// Bit mask of ERR_BADWRITE field.
	XIP_CTRL_CTRL_ERR_BADWRITE_Msk = 0x2
	// Bit ERR_BADWRITE.
	XIP_CTRL_CTRL_ERR_BADWRITE = 0x2
	// Position of EN field.
	XIP_CTRL_CTRL_EN_Pos = 0x0
	// Bit mask of EN field.
	XIP_CTRL_CTRL_EN_Msk = 0x1
	// Bit EN.
	XIP_CTRL_CTRL_EN = 0x1

	// FLUSH: Cache Flush control
	// Position of FLUSH field.
	XIP_CTRL_FLUSH_FLUSH_Pos = 0x0
	// Bit mask of FLUSH field.
	XIP_CTRL_FLUSH_FLUSH_Msk = 0x1
	// Bit FLUSH.
	XIP_CTRL_FLUSH_FLUSH = 0x1

	// STAT: Cache Status
	// Position of FIFO_FULL field.
	XIP_CTRL_STAT_FIFO_FULL_Pos = 0x2
	// Bit mask of FIFO_FULL field.
	XIP_CTRL_STAT_FIFO_FULL_Msk = 0x4
	// Bit FIFO_FULL.
	XIP_CTRL_STAT_FIFO_FULL = 0x4
	// Position of FIFO_EMPTY field.
	XIP_CTRL_STAT_FIFO_EMPTY_Pos = 0x1
	// Bit mask of FIFO_EMPTY field.
	XIP_CTRL_STAT_FIFO_EMPTY_Msk = 0x2
	// Bit FIFO_EMPTY.
	XIP_CTRL_STAT_FIFO_EMPTY = 0x2
	// Position of FLUSH_READY field.
	XIP_CTRL_STAT_FLUSH_READY_Pos = 0x0
	// Bit mask of FLUSH_READY field.
	XIP_CTRL_STAT_FLUSH_READY_Msk = 0x1
	// Bit FLUSH_READY.
	XIP_CTRL_STAT_FLUSH_READY = 0x1

	// STREAM_ADDR: FIFO stream address
	// Position of STREAM_ADDR field.
	XIP_CTRL_STREAM_ADDR_STREAM_ADDR_Pos = 0x2
	// Bit mask of STREAM_ADDR field.
	XIP_CTRL_STREAM_ADDR_STREAM_ADDR_Msk = 0xfffffffc

	// STREAM_CTR: FIFO stream control
	// Position of STREAM_CTR field.
	XIP_CTRL_STREAM_CTR_STREAM_CTR_Pos = 0x0
	// Bit mask of STREAM_CTR field.
	XIP_CTRL_STREAM_CTR_STREAM_CTR_Msk = 0x3fffff
)

// Bitfields for XIP_SSI
// DW_apb_ssi has the following features:
// * APB interface – Allows for easy integration into a DesignWare Synthesizable Components for AMBA 2 implementation.
// * APB3 and APB4 protocol support.
// * Scalable APB data bus width – Supports APB data bus widths of 8, 16, and 32 bits.
// * Serial-master or serial-slave operation – Enables serial communication with serial-master or serial-slave peripheral devices.
// * Programmable Dual/Quad/Octal SPI support in Master Mode.
// * Dual Data Rate (DDR) and Read Data Strobe (RDS) Support - Enables the DW_apb_ssi master to perform operations with the device in DDR and RDS modes when working in Dual/Quad/Octal mode of operation.
// * Data Mask Support - Enables the DW_apb_ssi to selectively update the bytes in the device. This feature is applicable only in enhanced SPI modes.
// * eXecute-In-Place (XIP) support - Enables the DW_apb_ssi master to behave as a memory mapped I/O and fetches the data from the device based on the APB read request. This feature is applicable only in enhanced SPI modes.
// * DMA Controller Interface – Enables the DW_apb_ssi to interface to a DMA controller over the bus using a handshaking interface for transfer requests.
// * Independent masking of interrupts – Master collision, transmit FIFO overflow, transmit FIFO empty, receive FIFO full, receive FIFO underflow, and receive FIFO overflow interrupts can all be masked independently.
// * Multi-master contention detection – Informs the processor of multiple serial-master accesses on the serial bus.
// * Bypass of meta-stability flip-flops for synchronous clocks – When the APB clock (pclk) and the DW_apb_ssi serial clock (ssi_clk) are synchronous, meta-stable flip-flops are not used when transferring control signals across these clock domains.
// * Programmable delay on the sample time of the received serial data bit (rxd); enables programmable control of routing delays resulting in higher serial data-bit rates.
// * Programmable features:
// - Serial interface operation – Choice of Motorola SPI, Texas Instruments Synchronous Serial Protocol or National Semiconductor Microwire.
// - Clock bit-rate – Dynamic control of the serial bit rate of the data transfer; used in only serial-master mode of operation.
// - Data Item size (4 to 32 bits) – Item size of each data transfer under the control of the programmer.
// * Configured features:
// - FIFO depth – 16 words deep. The FIFO width is fixed at 32 bits.
// - 1 slave select output.
// - Hardware slave-select – Dedicated hardware slave-select line.
// - Combined interrupt line - one combined interrupt line from the DW_apb_ssi to the interrupt controller.
// - Interrupt polarity – active high interrupt lines.
// - Serial clock polarity – low serial-clock polarity directly after reset.
// - Serial clock phase – capture on first edge of serial-clock directly after reset.
const (
	// CTRLR0: Control register 0
	// Position of SSTE field.
	XIP_SSI_CTRLR0_SSTE_Pos = 0x18
	// Bit mask of SSTE field.
	XIP_SSI_CTRLR0_SSTE_Msk = 0x1000000
	// Bit SSTE.
	XIP_SSI_CTRLR0_SSTE = 0x1000000
	// Position of SPI_FRF field.
	XIP_SSI_CTRLR0_SPI_FRF_Pos = 0x15
	// Bit mask of SPI_FRF field.
	XIP_SSI_CTRLR0_SPI_FRF_Msk = 0x600000
	// Standard 1-bit SPI frame format; 1 bit per SCK, full-duplex
	XIP_SSI_CTRLR0_SPI_FRF_STD = 0x0
	// Dual-SPI frame format; two bits per SCK, half-duplex
	XIP_SSI_CTRLR0_SPI_FRF_DUAL = 0x1
	// Quad-SPI frame format; four bits per SCK, half-duplex
	XIP_SSI_CTRLR0_SPI_FRF_QUAD = 0x2
	// Position of DFS_32 field.
	XIP_SSI_CTRLR0_DFS_32_Pos = 0x10
	// Bit mask of DFS_32 field.
	XIP_SSI_CTRLR0_DFS_32_Msk = 0x1f0000
	// Position of CFS field.
	XIP_SSI_CTRLR0_CFS_Pos = 0xc
	// Bit mask of CFS field.
	XIP_SSI_CTRLR0_CFS_Msk = 0xf000
	// Position of SRL field.
	XIP_SSI_CTRLR0_SRL_Pos = 0xb
	// Bit mask of SRL field.
	XIP_SSI_CTRLR0_SRL_Msk = 0x800
	// Bit SRL.
	XIP_SSI_CTRLR0_SRL = 0x800
	// Position of SLV_OE field.
	XIP_SSI_CTRLR0_SLV_OE_Pos = 0xa
	// Bit mask of SLV_OE field.
	XIP_SSI_CTRLR0_SLV_OE_Msk = 0x400
	// Bit SLV_OE.
	XIP_SSI_CTRLR0_SLV_OE = 0x400
	// Position of TMOD field.
	XIP_SSI_CTRLR0_TMOD_Pos = 0x8
	// Bit mask of TMOD field.
	XIP_SSI_CTRLR0_TMOD_Msk = 0x300
	// Both transmit and receive
	XIP_SSI_CTRLR0_TMOD_TX_AND_RX = 0x0
	// Transmit only (not for FRF == 0, standard SPI mode)
	XIP_SSI_CTRLR0_TMOD_TX_ONLY = 0x1
	// Receive only (not for FRF == 0, standard SPI mode)
	XIP_SSI_CTRLR0_TMOD_RX_ONLY = 0x2
	// EEPROM read mode (TX then RX; RX starts after control data TX'd)
	XIP_SSI_CTRLR0_TMOD_EEPROM_READ = 0x3
	// Position of SCPOL field.
	XIP_SSI_CTRLR0_SCPOL_Pos = 0x7
	// Bit mask of SCPOL field.
	XIP_SSI_CTRLR0_SCPOL_Msk = 0x80
	// Bit SCPOL.
	XIP_SSI_CTRLR0_SCPOL = 0x80
	// Position of SCPH field.
	XIP_SSI_CTRLR0_SCPH_Pos = 0x6
	// Bit mask of SCPH field.
	XIP_SSI_CTRLR0_SCPH_Msk = 0x40
	// Bit SCPH.
	XIP_SSI_CTRLR0_SCPH = 0x40
	// Position of FRF field.
	XIP_SSI_CTRLR0_FRF_Pos = 0x4
	// Bit mask of FRF field.
	XIP_SSI_CTRLR0_FRF_Msk = 0x30
	// Position of DFS field.
	XIP_SSI_CTRLR0_DFS_Pos = 0x0
	// Bit mask of DFS field.
	XIP_SSI_CTRLR0_DFS_Msk = 0xf

	// CTRLR1: Master Control register 1
	// Position of NDF field.
	XIP_SSI_CTRLR1_NDF_Pos = 0x0
	// Bit mask of NDF field.
	XIP_SSI_CTRLR1_NDF_Msk = 0xffff

	// SSIENR: SSI Enable
	// Position of SSI_EN field.
	XIP_SSI_SSIENR_SSI_EN_Pos = 0x0
	// Bit mask of SSI_EN field.
	XIP_SSI_SSIENR_SSI_EN_Msk = 0x1
	// Bit SSI_EN.
	XIP_SSI_SSIENR_SSI_EN = 0x1

	// MWCR: Microwire Control
	// Position of MHS field.
	XIP_SSI_MWCR_MHS_Pos = 0x2
	// Bit mask of MHS field.
	XIP_SSI_MWCR_MHS_Msk = 0x4
	// Bit MHS.
	XIP_SSI_MWCR_MHS = 0x4
	// Position of MDD field.
	XIP_SSI_MWCR_MDD_Pos = 0x1
	// Bit mask of MDD field.
	XIP_SSI_MWCR_MDD_Msk = 0x2
	// Bit MDD.
	XIP_SSI_MWCR_MDD = 0x2
	// Position of MWMOD field.
	XIP_SSI_MWCR_MWMOD_Pos = 0x0
	// Bit mask of MWMOD field.
	XIP_SSI_MWCR_MWMOD_Msk = 0x1
	// Bit MWMOD.
	XIP_SSI_MWCR_MWMOD = 0x1

	// SER: Slave enable
	// Position of SER field.
	XIP_SSI_SER_SER_Pos = 0x0
	// Bit mask of SER field.
	XIP_SSI_SER_SER_Msk = 0x1
	// Bit SER.
	XIP_SSI_SER_SER = 0x1

	// BAUDR: Baud rate
	// Position of SCKDV field.
	XIP_SSI_BAUDR_SCKDV_Pos = 0x0
	// Bit mask of SCKDV field.
	XIP_SSI_BAUDR_SCKDV_Msk = 0xffff

	// TXFTLR: TX FIFO threshold level
	// Position of TFT field.
	XIP_SSI_TXFTLR_TFT_Pos = 0x0
	// Bit mask of TFT field.
	XIP_SSI_TXFTLR_TFT_Msk = 0xff

	// RXFTLR: RX FIFO threshold level
	// Position of RFT field.
	XIP_SSI_RXFTLR_RFT_Pos = 0x0
	// Bit mask of RFT field.
	XIP_SSI_RXFTLR_RFT_Msk = 0xff

	// TXFLR: TX FIFO level
	// Position of TFTFL field.
	XIP_SSI_TXFLR_TFTFL_Pos = 0x0
	// Bit mask of TFTFL field.
	XIP_SSI_TXFLR_TFTFL_Msk = 0xff

	// RXFLR: RX FIFO level
	// Position of RXTFL field.
	XIP_SSI_RXFLR_RXTFL_Pos = 0x0
	// Bit mask of RXTFL field.
	XIP_SSI_RXFLR_RXTFL_Msk = 0xff

	// SR: Status register
	// Position of DCOL field.
	XIP_SSI_SR_DCOL_Pos = 0x6
	// Bit mask of DCOL field.
	XIP_SSI_SR_DCOL_Msk = 0x40
	// Bit DCOL.
	XIP_SSI_SR_DCOL = 0x40
	// Position of TXE field.
	XIP_SSI_SR_TXE_Pos = 0x5
	// Bit mask of TXE field.
	XIP_SSI_SR_TXE_Msk = 0x20
	// Bit TXE.
	XIP_SSI_SR_TXE = 0x20
	// Position of RFF field.
	XIP_SSI_SR_RFF_Pos = 0x4
	// Bit mask of RFF field.
	XIP_SSI_SR_RFF_Msk = 0x10
	// Bit RFF.
	XIP_SSI_SR_RFF = 0x10
	// Position of RFNE field.
	XIP_SSI_SR_RFNE_Pos = 0x3
	// Bit mask of RFNE field.
	XIP_SSI_SR_RFNE_Msk = 0x8
	// Bit RFNE.
	XIP_SSI_SR_RFNE = 0x8
	// Position of TFE field.
	XIP_SSI_SR_TFE_Pos = 0x2
	// Bit mask of TFE field.
	XIP_SSI_SR_TFE_Msk = 0x4
	// Bit TFE.
	XIP_SSI_SR_TFE = 0x4
	// Position of TFNF field.
	XIP_SSI_SR_TFNF_Pos = 0x1
	// Bit mask of TFNF field.
	XIP_SSI_SR_TFNF_Msk = 0x2
	// Bit TFNF.
	XIP_SSI_SR_TFNF = 0x2
	// Position of BUSY field.
	XIP_SSI_SR_BUSY_Pos = 0x0
	// Bit mask of BUSY field.
	XIP_SSI_SR_BUSY_Msk = 0x1
	// Bit BUSY.
	XIP_SSI_SR_BUSY = 0x1

	// IMR: Interrupt mask
	// Position of MSTIM field.
	XIP_SSI_IMR_MSTIM_Pos = 0x5
	// Bit mask of MSTIM field.
	XIP_SSI_IMR_MSTIM_Msk = 0x20
	// Bit MSTIM.
	XIP_SSI_IMR_MSTIM = 0x20
	// Position of RXFIM field.
	XIP_SSI_IMR_RXFIM_Pos = 0x4
	// Bit mask of RXFIM field.
	XIP_SSI_IMR_RXFIM_Msk = 0x10
	// Bit RXFIM.
	XIP_SSI_IMR_RXFIM = 0x10
	// Position of RXOIM field.
	XIP_SSI_IMR_RXOIM_Pos = 0x3
	// Bit mask of RXOIM field.
	XIP_SSI_IMR_RXOIM_Msk = 0x8
	// Bit RXOIM.
	XIP_SSI_IMR_RXOIM = 0x8
	// Position of RXUIM field.
	XIP_SSI_IMR_RXUIM_Pos = 0x2
	// Bit mask of RXUIM field.
	XIP_SSI_IMR_RXUIM_Msk = 0x4
	// Bit RXUIM.
	XIP_SSI_IMR_RXUIM = 0x4
	// Position of TXOIM field.
	XIP_SSI_IMR_TXOIM_Pos = 0x1
	// Bit mask of TXOIM field.
	XIP_SSI_IMR_TXOIM_Msk = 0x2
	// Bit TXOIM.
	XIP_SSI_IMR_TXOIM = 0x2
	// Position of TXEIM field.
	XIP_SSI_IMR_TXEIM_Pos = 0x0
	// Bit mask of TXEIM field.
	XIP_SSI_IMR_TXEIM_Msk = 0x1
	// Bit TXEIM.
	XIP_SSI_IMR_TXEIM = 0x1

	// ISR: Interrupt status
	// Position of MSTIS field.
	XIP_SSI_ISR_MSTIS_Pos = 0x5
	// Bit mask of MSTIS field.
	XIP_SSI_ISR_MSTIS_Msk = 0x20
	// Bit MSTIS.
	XIP_SSI_ISR_MSTIS = 0x20
	// Position of RXFIS field.
	XIP_SSI_ISR_RXFIS_Pos = 0x4
	// Bit mask of RXFIS field.
	XIP_SSI_ISR_RXFIS_Msk = 0x10
	// Bit RXFIS.
	XIP_SSI_ISR_RXFIS = 0x10
	// Position of RXOIS field.
	XIP_SSI_ISR_RXOIS_Pos = 0x3
	// Bit mask of RXOIS field.
	XIP_SSI_ISR_RXOIS_Msk = 0x8
	// Bit RXOIS.
	XIP_SSI_ISR_RXOIS = 0x8
	// Position of RXUIS field.
	XIP_SSI_ISR_RXUIS_Pos = 0x2
	// Bit mask of RXUIS field.
	XIP_SSI_ISR_RXUIS_Msk = 0x4
	// Bit RXUIS.
	XIP_SSI_ISR_RXUIS = 0x4
	// Position of TXOIS field.
	XIP_SSI_ISR_TXOIS_Pos = 0x1
	// Bit mask of TXOIS field.
	XIP_SSI_ISR_TXOIS_Msk = 0x2
	// Bit TXOIS.
	XIP_SSI_ISR_TXOIS = 0x2
	// Position of TXEIS field.
	XIP_SSI_ISR_TXEIS_Pos = 0x0
	// Bit mask of TXEIS field.
	XIP_SSI_ISR_TXEIS_Msk = 0x1
	// Bit TXEIS.
	XIP_SSI_ISR_TXEIS = 0x1

	// RISR: Raw interrupt status
	// Position of MSTIR field.
	XIP_SSI_RISR_MSTIR_Pos = 0x5
	// Bit mask of MSTIR field.
	XIP_SSI_RISR_MSTIR_Msk = 0x20
	// Bit MSTIR.
	XIP_SSI_RISR_MSTIR = 0x20
	// Position of RXFIR field.
	XIP_SSI_RISR_RXFIR_Pos = 0x4
	// Bit mask of RXFIR field.
	XIP_SSI_RISR_RXFIR_Msk = 0x10
	// Bit RXFIR.
	XIP_SSI_RISR_RXFIR = 0x10
	// Position of RXOIR field.
	XIP_SSI_RISR_RXOIR_Pos = 0x3
	// Bit mask of RXOIR field.
	XIP_SSI_RISR_RXOIR_Msk = 0x8
	// Bit RXOIR.
	XIP_SSI_RISR_RXOIR = 0x8
	// Position of RXUIR field.
	XIP_SSI_RISR_RXUIR_Pos = 0x2
	// Bit mask of RXUIR field.
	XIP_SSI_RISR_RXUIR_Msk = 0x4
	// Bit RXUIR.
	XIP_SSI_RISR_RXUIR = 0x4
	// Position of TXOIR field.
	XIP_SSI_RISR_TXOIR_Pos = 0x1
	// Bit mask of TXOIR field.
	XIP_SSI_RISR_TXOIR_Msk = 0x2
	// Bit TXOIR.
	XIP_SSI_RISR_TXOIR = 0x2
	// Position of TXEIR field.
	XIP_SSI_RISR_TXEIR_Pos = 0x0
	// Bit mask of TXEIR field.
	XIP_SSI_RISR_TXEIR_Msk = 0x1
	// Bit TXEIR.
	XIP_SSI_RISR_TXEIR = 0x1

	// TXOICR: TX FIFO overflow interrupt clear
	// Position of TXOICR field.
	XIP_SSI_TXOICR_TXOICR_Pos = 0x0
	// Bit mask of TXOICR field.
	XIP_SSI_TXOICR_TXOICR_Msk = 0x1
	// Bit TXOICR.
	XIP_SSI_TXOICR_TXOICR = 0x1

	// RXOICR: RX FIFO overflow interrupt clear
	// Position of RXOICR field.
	XIP_SSI_RXOICR_RXOICR_Pos = 0x0
	// Bit mask of RXOICR field.
	XIP_SSI_RXOICR_RXOICR_Msk = 0x1
	// Bit RXOICR.
	XIP_SSI_RXOICR_RXOICR = 0x1

	// RXUICR: RX FIFO underflow interrupt clear
	// Position of RXUICR field.
	XIP_SSI_RXUICR_RXUICR_Pos = 0x0
	// Bit mask of RXUICR field.
	XIP_SSI_RXUICR_RXUICR_Msk = 0x1
	// Bit RXUICR.
	XIP_SSI_RXUICR_RXUICR = 0x1

	// MSTICR: Multi-master interrupt clear
	// Position of MSTICR field.
	XIP_SSI_MSTICR_MSTICR_Pos = 0x0
	// Bit mask of MSTICR field.
	XIP_SSI_MSTICR_MSTICR_Msk = 0x1
	// Bit MSTICR.
	XIP_SSI_MSTICR_MSTICR = 0x1

	// ICR: Interrupt clear
	// Position of ICR field.
	XIP_SSI_ICR_ICR_Pos = 0x0
	// Bit mask of ICR field.
	XIP_SSI_ICR_ICR_Msk = 0x1
	// Bit ICR.
	XIP_SSI_ICR_ICR = 0x1

	// DMACR: DMA control
	// Position of TDMAE field.
	XIP_SSI_DMACR_TDMAE_Pos = 0x1
	// Bit mask of TDMAE field.
	XIP_SSI_DMACR_TDMAE_Msk = 0x2
	// Bit TDMAE.
	XIP_SSI_DMACR_TDMAE = 0x2
	// Position of RDMAE field.
	XIP_SSI_DMACR_RDMAE_Pos = 0x0
	// Bit mask of RDMAE field.
	XIP_SSI_DMACR_RDMAE_Msk = 0x1
	// Bit RDMAE.
	XIP_SSI_DMACR_RDMAE = 0x1

	// DMATDLR: DMA TX data level
	// Position of DMATDL field.
	XIP_SSI_DMATDLR_DMATDL_Pos = 0x0
	// Bit mask of DMATDL field.
	XIP_SSI_DMATDLR_DMATDL_Msk = 0xff

	// DMARDLR: DMA RX data level
	// Position of DMARDL field.
	XIP_SSI_DMARDLR_DMARDL_Pos = 0x0
	// Bit mask of DMARDL field.
	XIP_SSI_DMARDLR_DMARDL_Msk = 0xff

	// IDR: Identification register
	// Position of IDCODE field.
	XIP_SSI_IDR_IDCODE_Pos = 0x0
	// Bit mask of IDCODE field.
	XIP_SSI_IDR_IDCODE_Msk = 0xffffffff

	// SSI_VERSION_ID: Version ID
	// Position of SSI_COMP_VERSION field.
	XIP_SSI_SSI_VERSION_ID_SSI_COMP_VERSION_Pos = 0x0
	// Bit mask of SSI_COMP_VERSION field.
	XIP_SSI_SSI_VERSION_ID_SSI_COMP_VERSION_Msk = 0xffffffff

	// DR0: Data Register 0 (of 36)
	// Position of DR field.
	XIP_SSI_DR0_DR_Pos = 0x0
	// Bit mask of DR field.
	XIP_SSI_DR0_DR_Msk = 0xffffffff

	// RX_SAMPLE_DLY: RX sample delay
	// Position of RSD field.
	XIP_SSI_RX_SAMPLE_DLY_RSD_Pos = 0x0
	// Bit mask of RSD field.
	XIP_SSI_RX_SAMPLE_DLY_RSD_Msk = 0xff

	// SPI_CTRLR0: SPI control
	// Position of XIP_CMD field.
	XIP_SSI_SPI_CTRLR0_XIP_CMD_Pos = 0x18
	// Bit mask of XIP_CMD field.
	XIP_SSI_SPI_CTRLR0_XIP_CMD_Msk = 0xff000000
	// Position of SPI_RXDS_EN field.
	XIP_SSI_SPI_CTRLR0_SPI_RXDS_EN_Pos = 0x12
	// Bit mask of SPI_RXDS_EN field.
	XIP_SSI_SPI_CTRLR0_SPI_RXDS_EN_Msk = 0x40000
	// Bit SPI_RXDS_EN.
	XIP_SSI_SPI_CTRLR0_SPI_RXDS_EN = 0x40000
	// Position of INST_DDR_EN field.
	XIP_SSI_SPI_CTRLR0_INST_DDR_EN_Pos = 0x11
	// Bit mask of INST_DDR_EN field.
	XIP_SSI_SPI_CTRLR0_INST_DDR_EN_Msk = 0x20000
	// Bit INST_DDR_EN.
	XIP_SSI_SPI_CTRLR0_INST_DDR_EN = 0x20000
	// Position of SPI_DDR_EN field.
	XIP_SSI_SPI_CTRLR0_SPI_DDR_EN_Pos = 0x10
	// Bit mask of SPI_DDR_EN field.
	XIP_SSI_SPI_CTRLR0_SPI_DDR_EN_Msk = 0x10000
	// Bit SPI_DDR_EN.
	XIP_SSI_SPI_CTRLR0_SPI_DDR_EN = 0x10000
	// Position of WAIT_CYCLES field.
	XIP_SSI_SPI_CTRLR0_WAIT_CYCLES_Pos = 0xb
	// Bit mask of WAIT_CYCLES field.
	XIP_SSI_SPI_CTRLR0_WAIT_CYCLES_Msk = 0xf800
	// Position of INST_L field.
	XIP_SSI_SPI_CTRLR0_INST_L_Pos = 0x8
	// Bit mask of INST_L field.
	XIP_SSI_SPI_CTRLR0_INST_L_Msk = 0x300
	// No instruction
	XIP_SSI_SPI_CTRLR0_INST_L_NONE = 0x0
	// 4-bit instruction
	XIP_SSI_SPI_CTRLR0_INST_L_4B = 0x1
	// 8-bit instruction
	XIP_SSI_SPI_CTRLR0_INST_L_8B = 0x2
	// 16-bit instruction
	XIP_SSI_SPI_CTRLR0_INST_L_16B = 0x3
	// Position of ADDR_L field.
	XIP_SSI_SPI_CTRLR0_ADDR_L_Pos = 0x2
	// Bit mask of ADDR_L field.
	XIP_SSI_SPI_CTRLR0_ADDR_L_Msk = 0x3c
	// Position of TRANS_TYPE field.
	XIP_SSI_SPI_CTRLR0_TRANS_TYPE_Pos = 0x0
	// Bit mask of TRANS_TYPE field.
	XIP_SSI_SPI_CTRLR0_TRANS_TYPE_Msk = 0x3
	// Command and address both in standard SPI frame format
	XIP_SSI_SPI_CTRLR0_TRANS_TYPE_1C1A = 0x0
	// Command in standard SPI format, address in format specified by FRF
	XIP_SSI_SPI_CTRLR0_TRANS_TYPE_1C2A = 0x1
	// Command and address both in format specified by FRF (e.g. Dual-SPI)
	XIP_SSI_SPI_CTRLR0_TRANS_TYPE_2C2A = 0x2

	// TXD_DRIVE_EDGE: TX drive edge
	// Position of TDE field.
	XIP_SSI_TXD_DRIVE_EDGE_TDE_Pos = 0x0
	// Bit mask of TDE field.
	XIP_SSI_TXD_DRIVE_EDGE_TDE_Msk = 0xff
)

// Bitfields for SYSINFO
const (
	// CHIP_ID: JEDEC JEP-106 compliant chip identifier.
	// Position of REVISION field.
	SYSINFO_CHIP_ID_REVISION_Pos = 0x1c
	// Bit mask of REVISION field.
	SYSINFO_CHIP_ID_REVISION_Msk = 0xf0000000
	// Position of PART field.
	SYSINFO_CHIP_ID_PART_Pos = 0xc
	// Bit mask of PART field.
	SYSINFO_CHIP_ID_PART_Msk = 0xffff000
	// Position of MANUFACTURER field.
	SYSINFO_CHIP_ID_MANUFACTURER_Pos = 0x0
	// Bit mask of MANUFACTURER field.
	SYSINFO_CHIP_ID_MANUFACTURER_Msk = 0xfff

	// PLATFORM: Platform register. Allows software to know what environment it is running in.
	// Position of ASIC field.
	SYSINFO_PLATFORM_ASIC_Pos = 0x1
	// Bit mask of ASIC field.
	SYSINFO_PLATFORM_ASIC_Msk = 0x2
	// Bit ASIC.
	SYSINFO_PLATFORM_ASIC = 0x2
	// Position of FPGA field.
	SYSINFO_PLATFORM_FPGA_Pos = 0x0
	// Bit mask of FPGA field.
	SYSINFO_PLATFORM_FPGA_Msk = 0x1
	// Bit FPGA.
	SYSINFO_PLATFORM_FPGA = 0x1
)

// Bitfields for SYSCFG: Register block for various chip control signals
const (
	// PROC_CONFIG: Configuration for processors
	// Position of PROC1_DAP_INSTID field.
	SYSCFG_PROC_CONFIG_PROC1_DAP_INSTID_Pos = 0x1c
	// Bit mask of PROC1_DAP_INSTID field.
	SYSCFG_PROC_CONFIG_PROC1_DAP_INSTID_Msk = 0xf0000000
	// Position of PROC0_DAP_INSTID field.
	SYSCFG_PROC_CONFIG_PROC0_DAP_INSTID_Pos = 0x18
	// Bit mask of PROC0_DAP_INSTID field.
	SYSCFG_PROC_CONFIG_PROC0_DAP_INSTID_Msk = 0xf000000
	// Position of PROC1_HALTED field.
	SYSCFG_PROC_CONFIG_PROC1_HALTED_Pos = 0x1
	// Bit mask of PROC1_HALTED field.
	SYSCFG_PROC_CONFIG_PROC1_HALTED_Msk = 0x2
	// Bit PROC1_HALTED.
	SYSCFG_PROC_CONFIG_PROC1_HALTED = 0x2
	// Position of PROC0_HALTED field.
	SYSCFG_PROC_CONFIG_PROC0_HALTED_Pos = 0x0
	// Bit mask of PROC0_HALTED field.
	SYSCFG_PROC_CONFIG_PROC0_HALTED_Msk = 0x1
	// Bit PROC0_HALTED.
	SYSCFG_PROC_CONFIG_PROC0_HALTED = 0x1

	// PROC_IN_SYNC_BYPASS
	// For each bit, if 1, bypass the input synchronizer between that GPIO
	// and the GPIO input register in the SIO. The input synchronizers should
	// generally be unbypassed, to avoid injecting metastabilities into processors.
	// If you're feeling brave, you can bypass to save two cycles of input
	// latency. This register applies to GPIO 0...29.
	// Position of PROC_IN_SYNC_BYPASS field.
	SYSCFG_PROC_IN_SYNC_BYPASS_PROC_IN_SYNC_BYPASS_Pos = 0x0
	// Bit mask of PROC_IN_SYNC_BYPASS field.
	SYSCFG_PROC_IN_SYNC_BYPASS_PROC_IN_SYNC_BYPASS_Msk = 0x3fffffff

	// PROC_IN_SYNC_BYPASS_HI
	// For each bit, if 1, bypass the input synchronizer between that GPIO
	// and the GPIO input register in the SIO. The input synchronizers should
	// generally be unbypassed, to avoid injecting metastabilities into processors.
	// If you're feeling brave, you can bypass to save two cycles of input
	// latency. This register applies to GPIO 30...35 (the QSPI IOs).
	// Position of PROC_IN_SYNC_BYPASS_HI field.
	SYSCFG_PROC_IN_SYNC_BYPASS_HI_PROC_IN_SYNC_BYPASS_HI_Pos = 0x0
	// Bit mask of PROC_IN_SYNC_BYPASS_HI field.
	SYSCFG_PROC_IN_SYNC_BYPASS_HI_PROC_IN_SYNC_BYPASS_HI_Msk = 0x3f

	// DBGFORCE: Directly control the SWD debug port of either processor
	// Position of PROC1_ATTACH field.
	SYSCFG_DBGFORCE_PROC1_ATTACH_Pos = 0x7
	// Bit mask of PROC1_ATTACH field.
	SYSCFG_DBGFORCE_PROC1_ATTACH_Msk = 0x80
	// Bit PROC1_ATTACH.
	SYSCFG_DBGFORCE_PROC1_ATTACH = 0x80
	// Position of PROC1_SWCLK field.
	SYSCFG_DBGFORCE_PROC1_SWCLK_Pos = 0x6
	// Bit mask of PROC1_SWCLK field.
	SYSCFG_DBGFORCE_PROC1_SWCLK_Msk = 0x40
	// Bit PROC1_SWCLK.
	SYSCFG_DBGFORCE_PROC1_SWCLK = 0x40
	// Position of PROC1_SWDI field.
	SYSCFG_DBGFORCE_PROC1_SWDI_Pos = 0x5
	// Bit mask of PROC1_SWDI field.
	SYSCFG_DBGFORCE_PROC1_SWDI_Msk = 0x20
	// Bit PROC1_SWDI.
	SYSCFG_DBGFORCE_PROC1_SWDI = 0x20
	// Position of PROC1_SWDO field.
	SYSCFG_DBGFORCE_PROC1_SWDO_Pos = 0x4
	// Bit mask of PROC1_SWDO field.
	SYSCFG_DBGFORCE_PROC1_SWDO_Msk = 0x10
	// Bit PROC1_SWDO.
	SYSCFG_DBGFORCE_PROC1_SWDO = 0x10
	// Position of PROC0_ATTACH field.
	SYSCFG_DBGFORCE_PROC0_ATTACH_Pos = 0x3
	// Bit mask of PROC0_ATTACH field.
	SYSCFG_DBGFORCE_PROC0_ATTACH_Msk = 0x8
	// Bit PROC0_ATTACH.
	SYSCFG_DBGFORCE_PROC0_ATTACH = 0x8
	// Position of PROC0_SWCLK field.
	SYSCFG_DBGFORCE_PROC0_SWCLK_Pos = 0x2
	// Bit mask of PROC0_SWCLK field.
	SYSCFG_DBGFORCE_PROC0_SWCLK_Msk = 0x4
	// Bit PROC0_SWCLK.
	SYSCFG_DBGFORCE_PROC0_SWCLK = 0x4
	// Position of PROC0_SWDI field.
	SYSCFG_DBGFORCE_PROC0_SWDI_Pos = 0x1
	// Bit mask of PROC0_SWDI field.
	SYSCFG_DBGFORCE_PROC0_SWDI_Msk = 0x2
	// Bit PROC0_SWDI.
	SYSCFG_DBGFORCE_PROC0_SWDI = 0x2
	// Position of PROC0_SWDO field.
	SYSCFG_DBGFORCE_PROC0_SWDO_Pos = 0x0
	// Bit mask of PROC0_SWDO field.
	SYSCFG_DBGFORCE_PROC0_SWDO_Msk = 0x1
	// Bit PROC0_SWDO.
	SYSCFG_DBGFORCE_PROC0_SWDO = 0x1

	// MEMPOWERDOWN
	// Control power downs to memories. Set high to power down memories.
	// Use with extreme caution
	// Position of ROM field.
	SYSCFG_MEMPOWERDOWN_ROM_Pos = 0x7
	// Bit mask of ROM field.
	SYSCFG_MEMPOWERDOWN_ROM_Msk = 0x80
	// Bit ROM.
	SYSCFG_MEMPOWERDOWN_ROM = 0x80
	// Position of USB field.
	SYSCFG_MEMPOWERDOWN_USB_Pos = 0x6
	// Bit mask of USB field.
	SYSCFG_MEMPOWERDOWN_USB_Msk = 0x40
	// Bit USB.
	SYSCFG_MEMPOWERDOWN_USB = 0x40
	// Position of SRAM5 field.
	SYSCFG_MEMPOWERDOWN_SRAM5_Pos = 0x5
	// Bit mask of SRAM5 field.
	SYSCFG_MEMPOWERDOWN_SRAM5_Msk = 0x20
	// Bit SRAM5.
	SYSCFG_MEMPOWERDOWN_SRAM5 = 0x20
	// Position of SRAM4 field.
	SYSCFG_MEMPOWERDOWN_SRAM4_Pos = 0x4
	// Bit mask of SRAM4 field.
	SYSCFG_MEMPOWERDOWN_SRAM4_Msk = 0x10
	// Bit SRAM4.
	SYSCFG_MEMPOWERDOWN_SRAM4 = 0x10
	// Position of SRAM3 field.
	SYSCFG_MEMPOWERDOWN_SRAM3_Pos = 0x3
	// Bit mask of SRAM3 field.
	SYSCFG_MEMPOWERDOWN_SRAM3_Msk = 0x8
	// Bit SRAM3.
	SYSCFG_MEMPOWERDOWN_SRAM3 = 0x8
	// Position of SRAM2 field.
	SYSCFG_MEMPOWERDOWN_SRAM2_Pos = 0x2
	// Bit mask of SRAM2 field.
	SYSCFG_MEMPOWERDOWN_SRAM2_Msk = 0x4
	// Bit SRAM2.
	SYSCFG_MEMPOWERDOWN_SRAM2 = 0x4
	// Position of SRAM1 field.
	SYSCFG_MEMPOWERDOWN_SRAM1_Pos = 0x1
	// Bit mask of SRAM1 field.
	SYSCFG_MEMPOWERDOWN_SRAM1_Msk = 0x2
	// Bit SRAM1.
	SYSCFG_MEMPOWERDOWN_SRAM1 = 0x2
	// Position of SRAM0 field.
	SYSCFG_MEMPOWERDOWN_SRAM0_Pos = 0x0
	// Bit mask of SRAM0 field.
	SYSCFG_MEMPOWERDOWN_SRAM0_Msk = 0x1
	// Bit SRAM0.
	SYSCFG_MEMPOWERDOWN_SRAM0 = 0x1
)

// Bitfields for CLOCKS
const (
	// CLK_GPOUT0_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of NUDGE field.
	CLOCKS_CLK_GPOUT0_CTRL_NUDGE_Pos = 0x14
	// Bit mask of NUDGE field.
	CLOCKS_CLK_GPOUT0_CTRL_NUDGE_Msk = 0x100000
	// Bit NUDGE.
	CLOCKS_CLK_GPOUT0_CTRL_NUDGE = 0x100000
	// Position of PHASE field.
	CLOCKS_CLK_GPOUT0_CTRL_PHASE_Pos = 0x10
	// Bit mask of PHASE field.
	CLOCKS_CLK_GPOUT0_CTRL_PHASE_Msk = 0x30000
	// Position of DC50 field.
	CLOCKS_CLK_GPOUT0_CTRL_DC50_Pos = 0xc
	// Bit mask of DC50 field.
	CLOCKS_CLK_GPOUT0_CTRL_DC50_Msk = 0x1000
	// Bit DC50.
	CLOCKS_CLK_GPOUT0_CTRL_DC50 = 0x1000
	// Position of ENABLE field.
	CLOCKS_CLK_GPOUT0_CTRL_ENABLE_Pos = 0xb
	// Bit mask of ENABLE field.
	CLOCKS_CLK_GPOUT0_CTRL_ENABLE_Msk = 0x800
	// Bit ENABLE.
	CLOCKS_CLK_GPOUT0_CTRL_ENABLE = 0x800
	// Position of KILL field.
	CLOCKS_CLK_GPOUT0_CTRL_KILL_Pos = 0xa
	// Bit mask of KILL field.
	CLOCKS_CLK_GPOUT0_CTRL_KILL_Msk = 0x400
	// Bit KILL.
	CLOCKS_CLK_GPOUT0_CTRL_KILL = 0x400
	// Position of AUXSRC field.
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_Msk            = 0x1e0
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_CLKSRC_PLL_SYS = 0x0
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x1
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x2
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x3
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_ROSC_CLKSRC    = 0x4
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_XOSC_CLKSRC    = 0x5
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_CLK_SYS        = 0x6
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_CLK_USB        = 0x7
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_CLK_ADC        = 0x8
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_CLK_RTC        = 0x9
	CLOCKS_CLK_GPOUT0_CTRL_AUXSRC_CLK_REF        = 0xa

	// CLK_GPOUT0_DIV: Clock divisor, can be changed on-the-fly
	// Position of INT field.
	CLOCKS_CLK_GPOUT0_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	CLOCKS_CLK_GPOUT0_DIV_INT_Msk = 0xffffff00
	// Position of FRAC field.
	CLOCKS_CLK_GPOUT0_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	CLOCKS_CLK_GPOUT0_DIV_FRAC_Msk = 0xff

	// CLK_GPOUT1_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of NUDGE field.
	CLOCKS_CLK_GPOUT1_CTRL_NUDGE_Pos = 0x14
	// Bit mask of NUDGE field.
	CLOCKS_CLK_GPOUT1_CTRL_NUDGE_Msk = 0x100000
	// Bit NUDGE.
	CLOCKS_CLK_GPOUT1_CTRL_NUDGE = 0x100000
	// Position of PHASE field.
	CLOCKS_CLK_GPOUT1_CTRL_PHASE_Pos = 0x10
	// Bit mask of PHASE field.
	CLOCKS_CLK_GPOUT1_CTRL_PHASE_Msk = 0x30000
	// Position of DC50 field.
	CLOCKS_CLK_GPOUT1_CTRL_DC50_Pos = 0xc
	// Bit mask of DC50 field.
	CLOCKS_CLK_GPOUT1_CTRL_DC50_Msk = 0x1000
	// Bit DC50.
	CLOCKS_CLK_GPOUT1_CTRL_DC50 = 0x1000
	// Position of ENABLE field.
	CLOCKS_CLK_GPOUT1_CTRL_ENABLE_Pos = 0xb
	// Bit mask of ENABLE field.
	CLOCKS_CLK_GPOUT1_CTRL_ENABLE_Msk = 0x800
	// Bit ENABLE.
	CLOCKS_CLK_GPOUT1_CTRL_ENABLE = 0x800
	// Position of KILL field.
	CLOCKS_CLK_GPOUT1_CTRL_KILL_Pos = 0xa
	// Bit mask of KILL field.
	CLOCKS_CLK_GPOUT1_CTRL_KILL_Msk = 0x400
	// Bit KILL.
	CLOCKS_CLK_GPOUT1_CTRL_KILL = 0x400
	// Position of AUXSRC field.
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_Msk            = 0x1e0
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_CLKSRC_PLL_SYS = 0x0
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x1
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x2
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x3
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_ROSC_CLKSRC    = 0x4
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_XOSC_CLKSRC    = 0x5
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_CLK_SYS        = 0x6
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_CLK_USB        = 0x7
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_CLK_ADC        = 0x8
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_CLK_RTC        = 0x9
	CLOCKS_CLK_GPOUT1_CTRL_AUXSRC_CLK_REF        = 0xa

	// CLK_GPOUT1_DIV: Clock divisor, can be changed on-the-fly
	// Position of INT field.
	CLOCKS_CLK_GPOUT1_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	CLOCKS_CLK_GPOUT1_DIV_INT_Msk = 0xffffff00
	// Position of FRAC field.
	CLOCKS_CLK_GPOUT1_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	CLOCKS_CLK_GPOUT1_DIV_FRAC_Msk = 0xff

	// CLK_GPOUT2_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of NUDGE field.
	CLOCKS_CLK_GPOUT2_CTRL_NUDGE_Pos = 0x14
	// Bit mask of NUDGE field.
	CLOCKS_CLK_GPOUT2_CTRL_NUDGE_Msk = 0x100000
	// Bit NUDGE.
	CLOCKS_CLK_GPOUT2_CTRL_NUDGE = 0x100000
	// Position of PHASE field.
	CLOCKS_CLK_GPOUT2_CTRL_PHASE_Pos = 0x10
	// Bit mask of PHASE field.
	CLOCKS_CLK_GPOUT2_CTRL_PHASE_Msk = 0x30000
	// Position of DC50 field.
	CLOCKS_CLK_GPOUT2_CTRL_DC50_Pos = 0xc
	// Bit mask of DC50 field.
	CLOCKS_CLK_GPOUT2_CTRL_DC50_Msk = 0x1000
	// Bit DC50.
	CLOCKS_CLK_GPOUT2_CTRL_DC50 = 0x1000
	// Position of ENABLE field.
	CLOCKS_CLK_GPOUT2_CTRL_ENABLE_Pos = 0xb
	// Bit mask of ENABLE field.
	CLOCKS_CLK_GPOUT2_CTRL_ENABLE_Msk = 0x800
	// Bit ENABLE.
	CLOCKS_CLK_GPOUT2_CTRL_ENABLE = 0x800
	// Position of KILL field.
	CLOCKS_CLK_GPOUT2_CTRL_KILL_Pos = 0xa
	// Bit mask of KILL field.
	CLOCKS_CLK_GPOUT2_CTRL_KILL_Msk = 0x400
	// Bit KILL.
	CLOCKS_CLK_GPOUT2_CTRL_KILL = 0x400
	// Position of AUXSRC field.
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_Msk            = 0x1e0
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_CLKSRC_PLL_SYS = 0x0
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x1
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x2
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x3
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_ROSC_CLKSRC_PH = 0x4
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_XOSC_CLKSRC    = 0x5
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_CLK_SYS        = 0x6
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_CLK_USB        = 0x7
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_CLK_ADC        = 0x8
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_CLK_RTC        = 0x9
	CLOCKS_CLK_GPOUT2_CTRL_AUXSRC_CLK_REF        = 0xa

	// CLK_GPOUT2_DIV: Clock divisor, can be changed on-the-fly
	// Position of INT field.
	CLOCKS_CLK_GPOUT2_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	CLOCKS_CLK_GPOUT2_DIV_INT_Msk = 0xffffff00
	// Position of FRAC field.
	CLOCKS_CLK_GPOUT2_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	CLOCKS_CLK_GPOUT2_DIV_FRAC_Msk = 0xff

	// CLK_GPOUT3_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of NUDGE field.
	CLOCKS_CLK_GPOUT3_CTRL_NUDGE_Pos = 0x14
	// Bit mask of NUDGE field.
	CLOCKS_CLK_GPOUT3_CTRL_NUDGE_Msk = 0x100000
	// Bit NUDGE.
	CLOCKS_CLK_GPOUT3_CTRL_NUDGE = 0x100000
	// Position of PHASE field.
	CLOCKS_CLK_GPOUT3_CTRL_PHASE_Pos = 0x10
	// Bit mask of PHASE field.
	CLOCKS_CLK_GPOUT3_CTRL_PHASE_Msk = 0x30000
	// Position of DC50 field.
	CLOCKS_CLK_GPOUT3_CTRL_DC50_Pos = 0xc
	// Bit mask of DC50 field.
	CLOCKS_CLK_GPOUT3_CTRL_DC50_Msk = 0x1000
	// Bit DC50.
	CLOCKS_CLK_GPOUT3_CTRL_DC50 = 0x1000
	// Position of ENABLE field.
	CLOCKS_CLK_GPOUT3_CTRL_ENABLE_Pos = 0xb
	// Bit mask of ENABLE field.
	CLOCKS_CLK_GPOUT3_CTRL_ENABLE_Msk = 0x800
	// Bit ENABLE.
	CLOCKS_CLK_GPOUT3_CTRL_ENABLE = 0x800
	// Position of KILL field.
	CLOCKS_CLK_GPOUT3_CTRL_KILL_Pos = 0xa
	// Bit mask of KILL field.
	CLOCKS_CLK_GPOUT3_CTRL_KILL_Msk = 0x400
	// Bit KILL.
	CLOCKS_CLK_GPOUT3_CTRL_KILL = 0x400
	// Position of AUXSRC field.
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_Msk            = 0x1e0
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_CLKSRC_PLL_SYS = 0x0
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x1
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x2
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x3
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_ROSC_CLKSRC_PH = 0x4
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_XOSC_CLKSRC    = 0x5
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_CLK_SYS        = 0x6
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_CLK_USB        = 0x7
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_CLK_ADC        = 0x8
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_CLK_RTC        = 0x9
	CLOCKS_CLK_GPOUT3_CTRL_AUXSRC_CLK_REF        = 0xa

	// CLK_GPOUT3_DIV: Clock divisor, can be changed on-the-fly
	// Position of INT field.
	CLOCKS_CLK_GPOUT3_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	CLOCKS_CLK_GPOUT3_DIV_INT_Msk = 0xffffff00
	// Position of FRAC field.
	CLOCKS_CLK_GPOUT3_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	CLOCKS_CLK_GPOUT3_DIV_FRAC_Msk = 0xff

	// CLK_REF_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of AUXSRC field.
	CLOCKS_CLK_REF_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_REF_CTRL_AUXSRC_Msk            = 0x60
	CLOCKS_CLK_REF_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x0
	CLOCKS_CLK_REF_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x1
	CLOCKS_CLK_REF_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x2
	// Position of SRC field.
	CLOCKS_CLK_REF_CTRL_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCKS_CLK_REF_CTRL_SRC_Msk                = 0x3
	CLOCKS_CLK_REF_CTRL_SRC_ROSC_CLKSRC_PH     = 0x0
	CLOCKS_CLK_REF_CTRL_SRC_CLKSRC_CLK_REF_AUX = 0x1
	CLOCKS_CLK_REF_CTRL_SRC_XOSC_CLKSRC        = 0x2

	// CLK_REF_DIV: Clock divisor, can be changed on-the-fly
	// Position of INT field.
	CLOCKS_CLK_REF_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	CLOCKS_CLK_REF_DIV_INT_Msk = 0x300

	// CLK_SYS_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of AUXSRC field.
	CLOCKS_CLK_SYS_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_SYS_CTRL_AUXSRC_Msk            = 0xe0
	CLOCKS_CLK_SYS_CTRL_AUXSRC_CLKSRC_PLL_SYS = 0x0
	CLOCKS_CLK_SYS_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x1
	CLOCKS_CLK_SYS_CTRL_AUXSRC_ROSC_CLKSRC    = 0x2
	CLOCKS_CLK_SYS_CTRL_AUXSRC_XOSC_CLKSRC    = 0x3
	CLOCKS_CLK_SYS_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x4
	CLOCKS_CLK_SYS_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x5
	// Position of SRC field.
	CLOCKS_CLK_SYS_CTRL_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCKS_CLK_SYS_CTRL_SRC_Msk = 0x1
	// Bit SRC.
	CLOCKS_CLK_SYS_CTRL_SRC                    = 0x1
	CLOCKS_CLK_SYS_CTRL_SRC_CLK_REF            = 0x0
	CLOCKS_CLK_SYS_CTRL_SRC_CLKSRC_CLK_SYS_AUX = 0x1

	// CLK_SYS_DIV: Clock divisor, can be changed on-the-fly
	// Position of INT field.
	CLOCKS_CLK_SYS_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	CLOCKS_CLK_SYS_DIV_INT_Msk = 0xffffff00
	// Position of FRAC field.
	CLOCKS_CLK_SYS_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	CLOCKS_CLK_SYS_DIV_FRAC_Msk = 0xff

	// CLK_PERI_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of ENABLE field.
	CLOCKS_CLK_PERI_CTRL_ENABLE_Pos = 0xb
	// Bit mask of ENABLE field.
	CLOCKS_CLK_PERI_CTRL_ENABLE_Msk = 0x800
	// Bit ENABLE.
	CLOCKS_CLK_PERI_CTRL_ENABLE = 0x800
	// Position of KILL field.
	CLOCKS_CLK_PERI_CTRL_KILL_Pos = 0xa
	// Bit mask of KILL field.
	CLOCKS_CLK_PERI_CTRL_KILL_Msk = 0x400
	// Bit KILL.
	CLOCKS_CLK_PERI_CTRL_KILL = 0x400
	// Position of AUXSRC field.
	CLOCKS_CLK_PERI_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_PERI_CTRL_AUXSRC_Msk            = 0xe0
	CLOCKS_CLK_PERI_CTRL_AUXSRC_CLK_SYS        = 0x0
	CLOCKS_CLK_PERI_CTRL_AUXSRC_CLKSRC_PLL_SYS = 0x1
	CLOCKS_CLK_PERI_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x2
	CLOCKS_CLK_PERI_CTRL_AUXSRC_ROSC_CLKSRC_PH = 0x3
	CLOCKS_CLK_PERI_CTRL_AUXSRC_XOSC_CLKSRC    = 0x4
	CLOCKS_CLK_PERI_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x5
	CLOCKS_CLK_PERI_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x6

	// CLK_USB_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of NUDGE field.
	CLOCKS_CLK_USB_CTRL_NUDGE_Pos = 0x14
	// Bit mask of NUDGE field.
	CLOCKS_CLK_USB_CTRL_NUDGE_Msk = 0x100000
	// Bit NUDGE.
	CLOCKS_CLK_USB_CTRL_NUDGE = 0x100000
	// Position of PHASE field.
	CLOCKS_CLK_USB_CTRL_PHASE_Pos = 0x10
	// Bit mask of PHASE field.
	CLOCKS_CLK_USB_CTRL_PHASE_Msk = 0x30000
	// Position of ENABLE field.
	CLOCKS_CLK_USB_CTRL_ENABLE_Pos = 0xb
	// Bit mask of ENABLE field.
	CLOCKS_CLK_USB_CTRL_ENABLE_Msk = 0x800
	// Bit ENABLE.
	CLOCKS_CLK_USB_CTRL_ENABLE = 0x800
	// Position of KILL field.
	CLOCKS_CLK_USB_CTRL_KILL_Pos = 0xa
	// Bit mask of KILL field.
	CLOCKS_CLK_USB_CTRL_KILL_Msk = 0x400
	// Bit KILL.
	CLOCKS_CLK_USB_CTRL_KILL = 0x400
	// Position of AUXSRC field.
	CLOCKS_CLK_USB_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_USB_CTRL_AUXSRC_Msk            = 0xe0
	CLOCKS_CLK_USB_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x0
	CLOCKS_CLK_USB_CTRL_AUXSRC_CLKSRC_PLL_SYS = 0x1
	CLOCKS_CLK_USB_CTRL_AUXSRC_ROSC_CLKSRC_PH = 0x2
	CLOCKS_CLK_USB_CTRL_AUXSRC_XOSC_CLKSRC    = 0x3
	CLOCKS_CLK_USB_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x4
	CLOCKS_CLK_USB_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x5

	// CLK_USB_DIV: Clock divisor, can be changed on-the-fly
	// Position of INT field.
	CLOCKS_CLK_USB_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	CLOCKS_CLK_USB_DIV_INT_Msk = 0x300

	// CLK_ADC_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of NUDGE field.
	CLOCKS_CLK_ADC_CTRL_NUDGE_Pos = 0x14
	// Bit mask of NUDGE field.
	CLOCKS_CLK_ADC_CTRL_NUDGE_Msk = 0x100000
	// Bit NUDGE.
	CLOCKS_CLK_ADC_CTRL_NUDGE = 0x100000
	// Position of PHASE field.
	CLOCKS_CLK_ADC_CTRL_PHASE_Pos = 0x10
	// Bit mask of PHASE field.
	CLOCKS_CLK_ADC_CTRL_PHASE_Msk = 0x30000
	// Position of ENABLE field.
	CLOCKS_CLK_ADC_CTRL_ENABLE_Pos = 0xb
	// Bit mask of ENABLE field.
	CLOCKS_CLK_ADC_CTRL_ENABLE_Msk = 0x800
	// Bit ENABLE.
	CLOCKS_CLK_ADC_CTRL_ENABLE = 0x800
	// Position of KILL field.
	CLOCKS_CLK_ADC_CTRL_KILL_Pos = 0xa
	// Bit mask of KILL field.
	CLOCKS_CLK_ADC_CTRL_KILL_Msk = 0x400
	// Bit KILL.
	CLOCKS_CLK_ADC_CTRL_KILL = 0x400
	// Position of AUXSRC field.
	CLOCKS_CLK_ADC_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_ADC_CTRL_AUXSRC_Msk            = 0xe0
	CLOCKS_CLK_ADC_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x0
	CLOCKS_CLK_ADC_CTRL_AUXSRC_CLKSRC_PLL_SYS = 0x1
	CLOCKS_CLK_ADC_CTRL_AUXSRC_ROSC_CLKSRC_PH = 0x2
	CLOCKS_CLK_ADC_CTRL_AUXSRC_XOSC_CLKSRC    = 0x3
	CLOCKS_CLK_ADC_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x4
	CLOCKS_CLK_ADC_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x5

	// CLK_ADC_DIV: Clock divisor, can be changed on-the-fly
	// Position of INT field.
	CLOCKS_CLK_ADC_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	CLOCKS_CLK_ADC_DIV_INT_Msk = 0x300

	// CLK_RTC_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
	// Position of NUDGE field.
	CLOCKS_CLK_RTC_CTRL_NUDGE_Pos = 0x14
	// Bit mask of NUDGE field.
	CLOCKS_CLK_RTC_CTRL_NUDGE_Msk = 0x100000
	// Bit NUDGE.
	CLOCKS_CLK_RTC_CTRL_NUDGE = 0x100000
	// Position of PHASE field.
	CLOCKS_CLK_RTC_CTRL_PHASE_Pos = 0x10
	// Bit mask of PHASE field.
	CLOCKS_CLK_RTC_CTRL_PHASE_Msk = 0x30000
	// Position of ENABLE field.
	CLOCKS_CLK_RTC_CTRL_ENABLE_Pos = 0xb
	// Bit mask of ENABLE field.
	CLOCKS_CLK_RTC_CTRL_ENABLE_Msk = 0x800
	// Bit ENABLE.
	CLOCKS_CLK_RTC_CTRL_ENABLE = 0x800
	// Position of KILL field.
	CLOCKS_CLK_RTC_CTRL_KILL_Pos = 0xa
	// Bit mask of KILL field.
	CLOCKS_CLK_RTC_CTRL_KILL_Msk = 0x400
	// Bit KILL.
	CLOCKS_CLK_RTC_CTRL_KILL = 0x400
	// Position of AUXSRC field.
	CLOCKS_CLK_RTC_CTRL_AUXSRC_Pos = 0x5
	// Bit mask of AUXSRC field.
	CLOCKS_CLK_RTC_CTRL_AUXSRC_Msk            = 0xe0
	CLOCKS_CLK_RTC_CTRL_AUXSRC_CLKSRC_PLL_USB = 0x0
	CLOCKS_CLK_RTC_CTRL_AUXSRC_CLKSRC_PLL_SYS = 0x1
	CLOCKS_CLK_RTC_CTRL_AUXSRC_ROSC_CLKSRC_PH = 0x2
	CLOCKS_CLK_RTC_CTRL_AUXSRC_XOSC_CLKSRC    = 0x3
	CLOCKS_CLK_RTC_CTRL_AUXSRC_CLKSRC_GPIN0   = 0x4
	CLOCKS_CLK_RTC_CTRL_AUXSRC_CLKSRC_GPIN1   = 0x5

	// CLK_RTC_DIV: Clock divisor, can be changed on-the-fly
	// Position of INT field.
	CLOCKS_CLK_RTC_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	CLOCKS_CLK_RTC_DIV_INT_Msk = 0xffffff00
	// Position of FRAC field.
	CLOCKS_CLK_RTC_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	CLOCKS_CLK_RTC_DIV_FRAC_Msk = 0xff

	// CLK_SYS_RESUS_CTRL
	// Position of CLEAR field.
	CLOCKS_CLK_SYS_RESUS_CTRL_CLEAR_Pos = 0x10
	// Bit mask of CLEAR field.
	CLOCKS_CLK_SYS_RESUS_CTRL_CLEAR_Msk = 0x10000
	// Bit CLEAR.
	CLOCKS_CLK_SYS_RESUS_CTRL_CLEAR = 0x10000
	// Position of FRCE field.
	CLOCKS_CLK_SYS_RESUS_CTRL_FRCE_Pos = 0xc
	// Bit mask of FRCE field.
	CLOCKS_CLK_SYS_RESUS_CTRL_FRCE_Msk = 0x1000
	// Bit FRCE.
	CLOCKS_CLK_SYS_RESUS_CTRL_FRCE = 0x1000
	// Position of ENABLE field.
	CLOCKS_CLK_SYS_RESUS_CTRL_ENABLE_Pos = 0x8
	// Bit mask of ENABLE field.
	CLOCKS_CLK_SYS_RESUS_CTRL_ENABLE_Msk = 0x100
	// Bit ENABLE.
	CLOCKS_CLK_SYS_RESUS_CTRL_ENABLE = 0x100
	// Position of TIMEOUT field.
	CLOCKS_CLK_SYS_RESUS_CTRL_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	CLOCKS_CLK_SYS_RESUS_CTRL_TIMEOUT_Msk = 0xff

	// CLK_SYS_RESUS_STATUS
	// Position of RESUSSED field.
	CLOCKS_CLK_SYS_RESUS_STATUS_RESUSSED_Pos = 0x0
	// Bit mask of RESUSSED field.
	CLOCKS_CLK_SYS_RESUS_STATUS_RESUSSED_Msk = 0x1
	// Bit RESUSSED.
	CLOCKS_CLK_SYS_RESUS_STATUS_RESUSSED = 0x1

	// FC0_REF_KHZ: Reference clock frequency in kHz
	// Position of FC0_REF_KHZ field.
	CLOCKS_FC0_REF_KHZ_FC0_REF_KHZ_Pos = 0x0
	// Bit mask of FC0_REF_KHZ field.
	CLOCKS_FC0_REF_KHZ_FC0_REF_KHZ_Msk = 0xfffff

	// FC0_MIN_KHZ: Minimum pass frequency in kHz. This is optional. Set to 0 if you are not using the pass/fail flags
	// Position of FC0_MIN_KHZ field.
	CLOCKS_FC0_MIN_KHZ_FC0_MIN_KHZ_Pos = 0x0
	// Bit mask of FC0_MIN_KHZ field.
	CLOCKS_FC0_MIN_KHZ_FC0_MIN_KHZ_Msk = 0x1ffffff

	// FC0_MAX_KHZ: Maximum pass frequency in kHz. This is optional. Set to 0x1ffffff if you are not using the pass/fail flags
	// Position of FC0_MAX_KHZ field.
	CLOCKS_FC0_MAX_KHZ_FC0_MAX_KHZ_Pos = 0x0
	// Bit mask of FC0_MAX_KHZ field.
	CLOCKS_FC0_MAX_KHZ_FC0_MAX_KHZ_Msk = 0x1ffffff

	// FC0_DELAY
	// Delays the start of frequency counting to allow the mux to settle
	// Delay is measured in multiples of the reference clock period
	// Position of FC0_DELAY field.
	CLOCKS_FC0_DELAY_FC0_DELAY_Pos = 0x0
	// Bit mask of FC0_DELAY field.
	CLOCKS_FC0_DELAY_FC0_DELAY_Msk = 0x7

	// FC0_INTERVAL
	// The test interval is 0.98us * 2**interval, but let's call it 1us * 2**interval
	// The default gives a test interval of 250us
	// Position of FC0_INTERVAL field.
	CLOCKS_FC0_INTERVAL_FC0_INTERVAL_Pos = 0x0
	// Bit mask of FC0_INTERVAL field.
	CLOCKS_FC0_INTERVAL_FC0_INTERVAL_Msk = 0xf

	// FC0_SRC
	// Clock sent to frequency counter, set to 0 when not required
	// Writing to this register initiates the frequency count
	// Position of FC0_SRC field.
	CLOCKS_FC0_SRC_FC0_SRC_Pos = 0x0
	// Bit mask of FC0_SRC field.
	CLOCKS_FC0_SRC_FC0_SRC_Msk                    = 0xff
	CLOCKS_FC0_SRC_FC0_SRC_NULL                   = 0x0
	CLOCKS_FC0_SRC_FC0_SRC_PLL_SYS_CLKSRC_PRIMARY = 0x1
	CLOCKS_FC0_SRC_FC0_SRC_PLL_USB_CLKSRC_PRIMARY = 0x2
	CLOCKS_FC0_SRC_FC0_SRC_ROSC_CLKSRC            = 0x3
	CLOCKS_FC0_SRC_FC0_SRC_ROSC_CLKSRC_PH         = 0x4
	CLOCKS_FC0_SRC_FC0_SRC_XOSC_CLKSRC            = 0x5
	CLOCKS_FC0_SRC_FC0_SRC_CLKSRC_GPIN0           = 0x6
	CLOCKS_FC0_SRC_FC0_SRC_CLKSRC_GPIN1           = 0x7
	CLOCKS_FC0_SRC_FC0_SRC_CLK_REF                = 0x8
	CLOCKS_FC0_SRC_FC0_SRC_CLK_SYS                = 0x9
	CLOCKS_FC0_SRC_FC0_SRC_CLK_PERI               = 0xa
	CLOCKS_FC0_SRC_FC0_SRC_CLK_USB                = 0xb
	CLOCKS_FC0_SRC_FC0_SRC_CLK_ADC                = 0xc
	CLOCKS_FC0_SRC_FC0_SRC_CLK_RTC                = 0xd

	// FC0_STATUS: Frequency counter status
	// Position of DIED field.
	CLOCKS_FC0_STATUS_DIED_Pos = 0x1c
	// Bit mask of DIED field.
	CLOCKS_FC0_STATUS_DIED_Msk = 0x10000000
	// Bit DIED.
	CLOCKS_FC0_STATUS_DIED = 0x10000000
	// Position of FAST field.
	CLOCKS_FC0_STATUS_FAST_Pos = 0x18
	// Bit mask of FAST field.
	CLOCKS_FC0_STATUS_FAST_Msk = 0x1000000
	// Bit FAST.
	CLOCKS_FC0_STATUS_FAST = 0x1000000
	// Position of SLOW field.
	CLOCKS_FC0_STATUS_SLOW_Pos = 0x14
	// Bit mask of SLOW field.
	CLOCKS_FC0_STATUS_SLOW_Msk = 0x100000
	// Bit SLOW.
	CLOCKS_FC0_STATUS_SLOW = 0x100000
	// Position of FAIL field.
	CLOCKS_FC0_STATUS_FAIL_Pos = 0x10
	// Bit mask of FAIL field.
	CLOCKS_FC0_STATUS_FAIL_Msk = 0x10000
	// Bit FAIL.
	CLOCKS_FC0_STATUS_FAIL = 0x10000
	// Position of WAITING field.
	CLOCKS_FC0_STATUS_WAITING_Pos = 0xc
	// Bit mask of WAITING field.
	CLOCKS_FC0_STATUS_WAITING_Msk = 0x1000
	// Bit WAITING.
	CLOCKS_FC0_STATUS_WAITING = 0x1000
	// Position of RUNNING field.
	CLOCKS_FC0_STATUS_RUNNING_Pos = 0x8
	// Bit mask of RUNNING field.
	CLOCKS_FC0_STATUS_RUNNING_Msk = 0x100
	// Bit RUNNING.
	CLOCKS_FC0_STATUS_RUNNING = 0x100
	// Position of DONE field.
	CLOCKS_FC0_STATUS_DONE_Pos = 0x4
	// Bit mask of DONE field.
	CLOCKS_FC0_STATUS_DONE_Msk = 0x10
	// Bit DONE.
	CLOCKS_FC0_STATUS_DONE = 0x10
	// Position of PASS field.
	CLOCKS_FC0_STATUS_PASS_Pos = 0x0
	// Bit mask of PASS field.
	CLOCKS_FC0_STATUS_PASS_Msk = 0x1
	// Bit PASS.
	CLOCKS_FC0_STATUS_PASS = 0x1

	// FC0_RESULT: Result of frequency measurement, only valid when status_done=1
	// Position of KHZ field.
	CLOCKS_FC0_RESULT_KHZ_Pos = 0x5
	// Bit mask of KHZ field.
	CLOCKS_FC0_RESULT_KHZ_Msk = 0x3fffffe0
	// Position of FRAC field.
	CLOCKS_FC0_RESULT_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	CLOCKS_FC0_RESULT_FRAC_Msk = 0x1f

	// WAKE_EN0: enable clock in wake mode
	// Position of CLK_SYS_SRAM3 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM3_Pos = 0x1f
	// Bit mask of CLK_SYS_SRAM3 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM3_Msk = 0x80000000
	// Bit CLK_SYS_SRAM3.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM3 = 0x80000000
	// Position of CLK_SYS_SRAM2 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM2_Pos = 0x1e
	// Bit mask of CLK_SYS_SRAM2 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM2_Msk = 0x40000000
	// Bit CLK_SYS_SRAM2.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM2 = 0x40000000
	// Position of CLK_SYS_SRAM1 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM1_Pos = 0x1d
	// Bit mask of CLK_SYS_SRAM1 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM1_Msk = 0x20000000
	// Bit CLK_SYS_SRAM1.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM1 = 0x20000000
	// Position of CLK_SYS_SRAM0 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM0_Pos = 0x1c
	// Bit mask of CLK_SYS_SRAM0 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM0_Msk = 0x10000000
	// Bit CLK_SYS_SRAM0.
	CLOCKS_WAKE_EN0_CLK_SYS_SRAM0 = 0x10000000
	// Position of CLK_SYS_SPI1 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SPI1_Pos = 0x1b
	// Bit mask of CLK_SYS_SPI1 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SPI1_Msk = 0x8000000
	// Bit CLK_SYS_SPI1.
	CLOCKS_WAKE_EN0_CLK_SYS_SPI1 = 0x8000000
	// Position of CLK_PERI_SPI1 field.
	CLOCKS_WAKE_EN0_CLK_PERI_SPI1_Pos = 0x1a
	// Bit mask of CLK_PERI_SPI1 field.
	CLOCKS_WAKE_EN0_CLK_PERI_SPI1_Msk = 0x4000000
	// Bit CLK_PERI_SPI1.
	CLOCKS_WAKE_EN0_CLK_PERI_SPI1 = 0x4000000
	// Position of CLK_SYS_SPI0 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SPI0_Pos = 0x19
	// Bit mask of CLK_SYS_SPI0 field.
	CLOCKS_WAKE_EN0_CLK_SYS_SPI0_Msk = 0x2000000
	// Bit CLK_SYS_SPI0.
	CLOCKS_WAKE_EN0_CLK_SYS_SPI0 = 0x2000000
	// Position of CLK_PERI_SPI0 field.
	CLOCKS_WAKE_EN0_CLK_PERI_SPI0_Pos = 0x18
	// Bit mask of CLK_PERI_SPI0 field.
	CLOCKS_WAKE_EN0_CLK_PERI_SPI0_Msk = 0x1000000
	// Bit CLK_PERI_SPI0.
	CLOCKS_WAKE_EN0_CLK_PERI_SPI0 = 0x1000000
	// Position of CLK_SYS_SIO field.
	CLOCKS_WAKE_EN0_CLK_SYS_SIO_Pos = 0x17
	// Bit mask of CLK_SYS_SIO field.
	CLOCKS_WAKE_EN0_CLK_SYS_SIO_Msk = 0x800000
	// Bit CLK_SYS_SIO.
	CLOCKS_WAKE_EN0_CLK_SYS_SIO = 0x800000
	// Position of CLK_SYS_RTC field.
	CLOCKS_WAKE_EN0_CLK_SYS_RTC_Pos = 0x16
	// Bit mask of CLK_SYS_RTC field.
	CLOCKS_WAKE_EN0_CLK_SYS_RTC_Msk = 0x400000
	// Bit CLK_SYS_RTC.
	CLOCKS_WAKE_EN0_CLK_SYS_RTC = 0x400000
	// Position of CLK_RTC_RTC field.
	CLOCKS_WAKE_EN0_CLK_RTC_RTC_Pos = 0x15
	// Bit mask of CLK_RTC_RTC field.
	CLOCKS_WAKE_EN0_CLK_RTC_RTC_Msk = 0x200000
	// Bit CLK_RTC_RTC.
	CLOCKS_WAKE_EN0_CLK_RTC_RTC = 0x200000
	// Position of CLK_SYS_ROSC field.
	CLOCKS_WAKE_EN0_CLK_SYS_ROSC_Pos = 0x14
	// Bit mask of CLK_SYS_ROSC field.
	CLOCKS_WAKE_EN0_CLK_SYS_ROSC_Msk = 0x100000
	// Bit CLK_SYS_ROSC.
	CLOCKS_WAKE_EN0_CLK_SYS_ROSC = 0x100000
	// Position of CLK_SYS_ROM field.
	CLOCKS_WAKE_EN0_CLK_SYS_ROM_Pos = 0x13
	// Bit mask of CLK_SYS_ROM field.
	CLOCKS_WAKE_EN0_CLK_SYS_ROM_Msk = 0x80000
	// Bit CLK_SYS_ROM.
	CLOCKS_WAKE_EN0_CLK_SYS_ROM = 0x80000
	// Position of CLK_SYS_RESETS field.
	CLOCKS_WAKE_EN0_CLK_SYS_RESETS_Pos = 0x12
	// Bit mask of CLK_SYS_RESETS field.
	CLOCKS_WAKE_EN0_CLK_SYS_RESETS_Msk = 0x40000
	// Bit CLK_SYS_RESETS.
	CLOCKS_WAKE_EN0_CLK_SYS_RESETS = 0x40000
	// Position of CLK_SYS_PWM field.
	CLOCKS_WAKE_EN0_CLK_SYS_PWM_Pos = 0x11
	// Bit mask of CLK_SYS_PWM field.
	CLOCKS_WAKE_EN0_CLK_SYS_PWM_Msk = 0x20000
	// Bit CLK_SYS_PWM.
	CLOCKS_WAKE_EN0_CLK_SYS_PWM = 0x20000
	// Position of CLK_SYS_PSM field.
	CLOCKS_WAKE_EN0_CLK_SYS_PSM_Pos = 0x10
	// Bit mask of CLK_SYS_PSM field.
	CLOCKS_WAKE_EN0_CLK_SYS_PSM_Msk = 0x10000
	// Bit CLK_SYS_PSM.
	CLOCKS_WAKE_EN0_CLK_SYS_PSM = 0x10000
	// Position of CLK_SYS_PLL_USB field.
	CLOCKS_WAKE_EN0_CLK_SYS_PLL_USB_Pos = 0xf
	// Bit mask of CLK_SYS_PLL_USB field.
	CLOCKS_WAKE_EN0_CLK_SYS_PLL_USB_Msk = 0x8000
	// Bit CLK_SYS_PLL_USB.
	CLOCKS_WAKE_EN0_CLK_SYS_PLL_USB = 0x8000
	// Position of CLK_SYS_PLL_SYS field.
	CLOCKS_WAKE_EN0_CLK_SYS_PLL_SYS_Pos = 0xe
	// Bit mask of CLK_SYS_PLL_SYS field.
	CLOCKS_WAKE_EN0_CLK_SYS_PLL_SYS_Msk = 0x4000
	// Bit CLK_SYS_PLL_SYS.
	CLOCKS_WAKE_EN0_CLK_SYS_PLL_SYS = 0x4000
	// Position of CLK_SYS_PIO1 field.
	CLOCKS_WAKE_EN0_CLK_SYS_PIO1_Pos = 0xd
	// Bit mask of CLK_SYS_PIO1 field.
	CLOCKS_WAKE_EN0_CLK_SYS_PIO1_Msk = 0x2000
	// Bit CLK_SYS_PIO1.
	CLOCKS_WAKE_EN0_CLK_SYS_PIO1 = 0x2000
	// Position of CLK_SYS_PIO0 field.
	CLOCKS_WAKE_EN0_CLK_SYS_PIO0_Pos = 0xc
	// Bit mask of CLK_SYS_PIO0 field.
	CLOCKS_WAKE_EN0_CLK_SYS_PIO0_Msk = 0x1000
	// Bit CLK_SYS_PIO0.
	CLOCKS_WAKE_EN0_CLK_SYS_PIO0 = 0x1000
	// Position of CLK_SYS_PADS field.
	CLOCKS_WAKE_EN0_CLK_SYS_PADS_Pos = 0xb
	// Bit mask of CLK_SYS_PADS field.
	CLOCKS_WAKE_EN0_CLK_SYS_PADS_Msk = 0x800
	// Bit CLK_SYS_PADS.
	CLOCKS_WAKE_EN0_CLK_SYS_PADS = 0x800
	// Position of CLK_SYS_VREG_AND_CHIP_RESET field.
	CLOCKS_WAKE_EN0_CLK_SYS_VREG_AND_CHIP_RESET_Pos = 0xa
	// Bit mask of CLK_SYS_VREG_AND_CHIP_RESET field.
	CLOCKS_WAKE_EN0_CLK_SYS_VREG_AND_CHIP_RESET_Msk = 0x400
	// Bit CLK_SYS_VREG_AND_CHIP_RESET.
	CLOCKS_WAKE_EN0_CLK_SYS_VREG_AND_CHIP_RESET = 0x400
	// Position of CLK_SYS_JTAG field.
	CLOCKS_WAKE_EN0_CLK_SYS_JTAG_Pos = 0x9
	// Bit mask of CLK_SYS_JTAG field.
	CLOCKS_WAKE_EN0_CLK_SYS_JTAG_Msk = 0x200
	// Bit CLK_SYS_JTAG.
	CLOCKS_WAKE_EN0_CLK_SYS_JTAG = 0x200
	// Position of CLK_SYS_IO field.
	CLOCKS_WAKE_EN0_CLK_SYS_IO_Pos = 0x8
	// Bit mask of CLK_SYS_IO field.
	CLOCKS_WAKE_EN0_CLK_SYS_IO_Msk = 0x100
	// Bit CLK_SYS_IO.
	CLOCKS_WAKE_EN0_CLK_SYS_IO = 0x100
	// Position of CLK_SYS_I2C1 field.
	CLOCKS_WAKE_EN0_CLK_SYS_I2C1_Pos = 0x7
	// Bit mask of CLK_SYS_I2C1 field.
	CLOCKS_WAKE_EN0_CLK_SYS_I2C1_Msk = 0x80
	// Bit CLK_SYS_I2C1.
	CLOCKS_WAKE_EN0_CLK_SYS_I2C1 = 0x80
	// Position of CLK_SYS_I2C0 field.
	CLOCKS_WAKE_EN0_CLK_SYS_I2C0_Pos = 0x6
	// Bit mask of CLK_SYS_I2C0 field.
	CLOCKS_WAKE_EN0_CLK_SYS_I2C0_Msk = 0x40
	// Bit CLK_SYS_I2C0.
	CLOCKS_WAKE_EN0_CLK_SYS_I2C0 = 0x40
	// Position of CLK_SYS_DMA field.
	CLOCKS_WAKE_EN0_CLK_SYS_DMA_Pos = 0x5
	// Bit mask of CLK_SYS_DMA field.
	CLOCKS_WAKE_EN0_CLK_SYS_DMA_Msk = 0x20
	// Bit CLK_SYS_DMA.
	CLOCKS_WAKE_EN0_CLK_SYS_DMA = 0x20
	// Position of CLK_SYS_BUSFABRIC field.
	CLOCKS_WAKE_EN0_CLK_SYS_BUSFABRIC_Pos = 0x4
	// Bit mask of CLK_SYS_BUSFABRIC field.
	CLOCKS_WAKE_EN0_CLK_SYS_BUSFABRIC_Msk = 0x10
	// Bit CLK_SYS_BUSFABRIC.
	CLOCKS_WAKE_EN0_CLK_SYS_BUSFABRIC = 0x10
	// Position of CLK_SYS_BUSCTRL field.
	CLOCKS_WAKE_EN0_CLK_SYS_BUSCTRL_Pos = 0x3
	// Bit mask of CLK_SYS_BUSCTRL field.
	CLOCKS_WAKE_EN0_CLK_SYS_BUSCTRL_Msk = 0x8
	// Bit CLK_SYS_BUSCTRL.
	CLOCKS_WAKE_EN0_CLK_SYS_BUSCTRL = 0x8
	// Position of CLK_SYS_ADC field.
	CLOCKS_WAKE_EN0_CLK_SYS_ADC_Pos = 0x2
	// Bit mask of CLK_SYS_ADC field.
	CLOCKS_WAKE_EN0_CLK_SYS_ADC_Msk = 0x4
	// Bit CLK_SYS_ADC.
	CLOCKS_WAKE_EN0_CLK_SYS_ADC = 0x4
	// Position of CLK_ADC_ADC field.
	CLOCKS_WAKE_EN0_CLK_ADC_ADC_Pos = 0x1
	// Bit mask of CLK_ADC_ADC field.
	CLOCKS_WAKE_EN0_CLK_ADC_ADC_Msk = 0x2
	// Bit CLK_ADC_ADC.
	CLOCKS_WAKE_EN0_CLK_ADC_ADC = 0x2
	// Position of CLK_SYS_CLOCKS field.
	CLOCKS_WAKE_EN0_CLK_SYS_CLOCKS_Pos = 0x0
	// Bit mask of CLK_SYS_CLOCKS field.
	CLOCKS_WAKE_EN0_CLK_SYS_CLOCKS_Msk = 0x1
	// Bit CLK_SYS_CLOCKS.
	CLOCKS_WAKE_EN0_CLK_SYS_CLOCKS = 0x1

	// WAKE_EN1: enable clock in wake mode
	// Position of CLK_SYS_XOSC field.
	CLOCKS_WAKE_EN1_CLK_SYS_XOSC_Pos = 0xe
	// Bit mask of CLK_SYS_XOSC field.
	CLOCKS_WAKE_EN1_CLK_SYS_XOSC_Msk = 0x4000
	// Bit CLK_SYS_XOSC.
	CLOCKS_WAKE_EN1_CLK_SYS_XOSC = 0x4000
	// Position of CLK_SYS_XIP field.
	CLOCKS_WAKE_EN1_CLK_SYS_XIP_Pos = 0xd
	// Bit mask of CLK_SYS_XIP field.
	CLOCKS_WAKE_EN1_CLK_SYS_XIP_Msk = 0x2000
	// Bit CLK_SYS_XIP.
	CLOCKS_WAKE_EN1_CLK_SYS_XIP = 0x2000
	// Position of CLK_SYS_WATCHDOG field.
	CLOCKS_WAKE_EN1_CLK_SYS_WATCHDOG_Pos = 0xc
	// Bit mask of CLK_SYS_WATCHDOG field.
	CLOCKS_WAKE_EN1_CLK_SYS_WATCHDOG_Msk = 0x1000
	// Bit CLK_SYS_WATCHDOG.
	CLOCKS_WAKE_EN1_CLK_SYS_WATCHDOG = 0x1000
	// Position of CLK_USB_USBCTRL field.
	CLOCKS_WAKE_EN1_CLK_USB_USBCTRL_Pos = 0xb
	// Bit mask of CLK_USB_USBCTRL field.
	CLOCKS_WAKE_EN1_CLK_USB_USBCTRL_Msk = 0x800
	// Bit CLK_USB_USBCTRL.
	CLOCKS_WAKE_EN1_CLK_USB_USBCTRL = 0x800
	// Position of CLK_SYS_USBCTRL field.
	CLOCKS_WAKE_EN1_CLK_SYS_USBCTRL_Pos = 0xa
	// Bit mask of CLK_SYS_USBCTRL field.
	CLOCKS_WAKE_EN1_CLK_SYS_USBCTRL_Msk = 0x400
	// Bit CLK_SYS_USBCTRL.
	CLOCKS_WAKE_EN1_CLK_SYS_USBCTRL = 0x400
	// Position of CLK_SYS_UART1 field.
	CLOCKS_WAKE_EN1_CLK_SYS_UART1_Pos = 0x9
	// Bit mask of CLK_SYS_UART1 field.
	CLOCKS_WAKE_EN1_CLK_SYS_UART1_Msk = 0x200
	// Bit CLK_SYS_UART1.
	CLOCKS_WAKE_EN1_CLK_SYS_UART1 = 0x200
	// Position of CLK_PERI_UART1 field.
	CLOCKS_WAKE_EN1_CLK_PERI_UART1_Pos = 0x8
	// Bit mask of CLK_PERI_UART1 field.
	CLOCKS_WAKE_EN1_CLK_PERI_UART1_Msk = 0x100
	// Bit CLK_PERI_UART1.
	CLOCKS_WAKE_EN1_CLK_PERI_UART1 = 0x100
	// Position of CLK_SYS_UART0 field.
	CLOCKS_WAKE_EN1_CLK_SYS_UART0_Pos = 0x7
	// Bit mask of CLK_SYS_UART0 field.
	CLOCKS_WAKE_EN1_CLK_SYS_UART0_Msk = 0x80
	// Bit CLK_SYS_UART0.
	CLOCKS_WAKE_EN1_CLK_SYS_UART0 = 0x80
	// Position of CLK_PERI_UART0 field.
	CLOCKS_WAKE_EN1_CLK_PERI_UART0_Pos = 0x6
	// Bit mask of CLK_PERI_UART0 field.
	CLOCKS_WAKE_EN1_CLK_PERI_UART0_Msk = 0x40
	// Bit CLK_PERI_UART0.
	CLOCKS_WAKE_EN1_CLK_PERI_UART0 = 0x40
	// Position of CLK_SYS_TIMER field.
	CLOCKS_WAKE_EN1_CLK_SYS_TIMER_Pos = 0x5
	// Bit mask of CLK_SYS_TIMER field.
	CLOCKS_WAKE_EN1_CLK_SYS_TIMER_Msk = 0x20
	// Bit CLK_SYS_TIMER.
	CLOCKS_WAKE_EN1_CLK_SYS_TIMER = 0x20
	// Position of CLK_SYS_TBMAN field.
	CLOCKS_WAKE_EN1_CLK_SYS_TBMAN_Pos = 0x4
	// Bit mask of CLK_SYS_TBMAN field.
	CLOCKS_WAKE_EN1_CLK_SYS_TBMAN_Msk = 0x10
	// Bit CLK_SYS_TBMAN.
	CLOCKS_WAKE_EN1_CLK_SYS_TBMAN = 0x10
	// Position of CLK_SYS_SYSINFO field.
	CLOCKS_WAKE_EN1_CLK_SYS_SYSINFO_Pos = 0x3
	// Bit mask of CLK_SYS_SYSINFO field.
	CLOCKS_WAKE_EN1_CLK_SYS_SYSINFO_Msk = 0x8
	// Bit CLK_SYS_SYSINFO.
	CLOCKS_WAKE_EN1_CLK_SYS_SYSINFO = 0x8
	// Position of CLK_SYS_SYSCFG field.
	CLOCKS_WAKE_EN1_CLK_SYS_SYSCFG_Pos = 0x2
	// Bit mask of CLK_SYS_SYSCFG field.
	CLOCKS_WAKE_EN1_CLK_SYS_SYSCFG_Msk = 0x4
	// Bit CLK_SYS_SYSCFG.
	CLOCKS_WAKE_EN1_CLK_SYS_SYSCFG = 0x4
	// Position of CLK_SYS_SRAM5 field.
	CLOCKS_WAKE_EN1_CLK_SYS_SRAM5_Pos = 0x1
	// Bit mask of CLK_SYS_SRAM5 field.
	CLOCKS_WAKE_EN1_CLK_SYS_SRAM5_Msk = 0x2
	// Bit CLK_SYS_SRAM5.
	CLOCKS_WAKE_EN1_CLK_SYS_SRAM5 = 0x2
	// Position of CLK_SYS_SRAM4 field.
	CLOCKS_WAKE_EN1_CLK_SYS_SRAM4_Pos = 0x0
	// Bit mask of CLK_SYS_SRAM4 field.
	CLOCKS_WAKE_EN1_CLK_SYS_SRAM4_Msk = 0x1
	// Bit CLK_SYS_SRAM4.
	CLOCKS_WAKE_EN1_CLK_SYS_SRAM4 = 0x1

	// SLEEP_EN0: enable clock in sleep mode
	// Position of CLK_SYS_SRAM3 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM3_Pos = 0x1f
	// Bit mask of CLK_SYS_SRAM3 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM3_Msk = 0x80000000
	// Bit CLK_SYS_SRAM3.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM3 = 0x80000000
	// Position of CLK_SYS_SRAM2 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM2_Pos = 0x1e
	// Bit mask of CLK_SYS_SRAM2 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM2_Msk = 0x40000000
	// Bit CLK_SYS_SRAM2.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM2 = 0x40000000
	// Position of CLK_SYS_SRAM1 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM1_Pos = 0x1d
	// Bit mask of CLK_SYS_SRAM1 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM1_Msk = 0x20000000
	// Bit CLK_SYS_SRAM1.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM1 = 0x20000000
	// Position of CLK_SYS_SRAM0 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM0_Pos = 0x1c
	// Bit mask of CLK_SYS_SRAM0 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM0_Msk = 0x10000000
	// Bit CLK_SYS_SRAM0.
	CLOCKS_SLEEP_EN0_CLK_SYS_SRAM0 = 0x10000000
	// Position of CLK_SYS_SPI1 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SPI1_Pos = 0x1b
	// Bit mask of CLK_SYS_SPI1 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SPI1_Msk = 0x8000000
	// Bit CLK_SYS_SPI1.
	CLOCKS_SLEEP_EN0_CLK_SYS_SPI1 = 0x8000000
	// Position of CLK_PERI_SPI1 field.
	CLOCKS_SLEEP_EN0_CLK_PERI_SPI1_Pos = 0x1a
	// Bit mask of CLK_PERI_SPI1 field.
	CLOCKS_SLEEP_EN0_CLK_PERI_SPI1_Msk = 0x4000000
	// Bit CLK_PERI_SPI1.
	CLOCKS_SLEEP_EN0_CLK_PERI_SPI1 = 0x4000000
	// Position of CLK_SYS_SPI0 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SPI0_Pos = 0x19
	// Bit mask of CLK_SYS_SPI0 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SPI0_Msk = 0x2000000
	// Bit CLK_SYS_SPI0.
	CLOCKS_SLEEP_EN0_CLK_SYS_SPI0 = 0x2000000
	// Position of CLK_PERI_SPI0 field.
	CLOCKS_SLEEP_EN0_CLK_PERI_SPI0_Pos = 0x18
	// Bit mask of CLK_PERI_SPI0 field.
	CLOCKS_SLEEP_EN0_CLK_PERI_SPI0_Msk = 0x1000000
	// Bit CLK_PERI_SPI0.
	CLOCKS_SLEEP_EN0_CLK_PERI_SPI0 = 0x1000000
	// Position of CLK_SYS_SIO field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SIO_Pos = 0x17
	// Bit mask of CLK_SYS_SIO field.
	CLOCKS_SLEEP_EN0_CLK_SYS_SIO_Msk = 0x800000
	// Bit CLK_SYS_SIO.
	CLOCKS_SLEEP_EN0_CLK_SYS_SIO = 0x800000
	// Position of CLK_SYS_RTC field.
	CLOCKS_SLEEP_EN0_CLK_SYS_RTC_Pos = 0x16
	// Bit mask of CLK_SYS_RTC field.
	CLOCKS_SLEEP_EN0_CLK_SYS_RTC_Msk = 0x400000
	// Bit CLK_SYS_RTC.
	CLOCKS_SLEEP_EN0_CLK_SYS_RTC = 0x400000
	// Position of CLK_RTC_RTC field.
	CLOCKS_SLEEP_EN0_CLK_RTC_RTC_Pos = 0x15
	// Bit mask of CLK_RTC_RTC field.
	CLOCKS_SLEEP_EN0_CLK_RTC_RTC_Msk = 0x200000
	// Bit CLK_RTC_RTC.
	CLOCKS_SLEEP_EN0_CLK_RTC_RTC = 0x200000
	// Position of CLK_SYS_ROSC field.
	CLOCKS_SLEEP_EN0_CLK_SYS_ROSC_Pos = 0x14
	// Bit mask of CLK_SYS_ROSC field.
	CLOCKS_SLEEP_EN0_CLK_SYS_ROSC_Msk = 0x100000
	// Bit CLK_SYS_ROSC.
	CLOCKS_SLEEP_EN0_CLK_SYS_ROSC = 0x100000
	// Position of CLK_SYS_ROM field.
	CLOCKS_SLEEP_EN0_CLK_SYS_ROM_Pos = 0x13
	// Bit mask of CLK_SYS_ROM field.
	CLOCKS_SLEEP_EN0_CLK_SYS_ROM_Msk = 0x80000
	// Bit CLK_SYS_ROM.
	CLOCKS_SLEEP_EN0_CLK_SYS_ROM = 0x80000
	// Position of CLK_SYS_RESETS field.
	CLOCKS_SLEEP_EN0_CLK_SYS_RESETS_Pos = 0x12
	// Bit mask of CLK_SYS_RESETS field.
	CLOCKS_SLEEP_EN0_CLK_SYS_RESETS_Msk = 0x40000
	// Bit CLK_SYS_RESETS.
	CLOCKS_SLEEP_EN0_CLK_SYS_RESETS = 0x40000
	// Position of CLK_SYS_PWM field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PWM_Pos = 0x11
	// Bit mask of CLK_SYS_PWM field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PWM_Msk = 0x20000
	// Bit CLK_SYS_PWM.
	CLOCKS_SLEEP_EN0_CLK_SYS_PWM = 0x20000
	// Position of CLK_SYS_PSM field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PSM_Pos = 0x10
	// Bit mask of CLK_SYS_PSM field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PSM_Msk = 0x10000
	// Bit CLK_SYS_PSM.
	CLOCKS_SLEEP_EN0_CLK_SYS_PSM = 0x10000
	// Position of CLK_SYS_PLL_USB field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PLL_USB_Pos = 0xf
	// Bit mask of CLK_SYS_PLL_USB field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PLL_USB_Msk = 0x8000
	// Bit CLK_SYS_PLL_USB.
	CLOCKS_SLEEP_EN0_CLK_SYS_PLL_USB = 0x8000
	// Position of CLK_SYS_PLL_SYS field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PLL_SYS_Pos = 0xe
	// Bit mask of CLK_SYS_PLL_SYS field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PLL_SYS_Msk = 0x4000
	// Bit CLK_SYS_PLL_SYS.
	CLOCKS_SLEEP_EN0_CLK_SYS_PLL_SYS = 0x4000
	// Position of CLK_SYS_PIO1 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PIO1_Pos = 0xd
	// Bit mask of CLK_SYS_PIO1 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PIO1_Msk = 0x2000
	// Bit CLK_SYS_PIO1.
	CLOCKS_SLEEP_EN0_CLK_SYS_PIO1 = 0x2000
	// Position of CLK_SYS_PIO0 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PIO0_Pos = 0xc
	// Bit mask of CLK_SYS_PIO0 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PIO0_Msk = 0x1000
	// Bit CLK_SYS_PIO0.
	CLOCKS_SLEEP_EN0_CLK_SYS_PIO0 = 0x1000
	// Position of CLK_SYS_PADS field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PADS_Pos = 0xb
	// Bit mask of CLK_SYS_PADS field.
	CLOCKS_SLEEP_EN0_CLK_SYS_PADS_Msk = 0x800
	// Bit CLK_SYS_PADS.
	CLOCKS_SLEEP_EN0_CLK_SYS_PADS = 0x800
	// Position of CLK_SYS_VREG_AND_CHIP_RESET field.
	CLOCKS_SLEEP_EN0_CLK_SYS_VREG_AND_CHIP_RESET_Pos = 0xa
	// Bit mask of CLK_SYS_VREG_AND_CHIP_RESET field.
	CLOCKS_SLEEP_EN0_CLK_SYS_VREG_AND_CHIP_RESET_Msk = 0x400
	// Bit CLK_SYS_VREG_AND_CHIP_RESET.
	CLOCKS_SLEEP_EN0_CLK_SYS_VREG_AND_CHIP_RESET = 0x400
	// Position of CLK_SYS_JTAG field.
	CLOCKS_SLEEP_EN0_CLK_SYS_JTAG_Pos = 0x9
	// Bit mask of CLK_SYS_JTAG field.
	CLOCKS_SLEEP_EN0_CLK_SYS_JTAG_Msk = 0x200
	// Bit CLK_SYS_JTAG.
	CLOCKS_SLEEP_EN0_CLK_SYS_JTAG = 0x200
	// Position of CLK_SYS_IO field.
	CLOCKS_SLEEP_EN0_CLK_SYS_IO_Pos = 0x8
	// Bit mask of CLK_SYS_IO field.
	CLOCKS_SLEEP_EN0_CLK_SYS_IO_Msk = 0x100
	// Bit CLK_SYS_IO.
	CLOCKS_SLEEP_EN0_CLK_SYS_IO = 0x100
	// Position of CLK_SYS_I2C1 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_I2C1_Pos = 0x7
	// Bit mask of CLK_SYS_I2C1 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_I2C1_Msk = 0x80
	// Bit CLK_SYS_I2C1.
	CLOCKS_SLEEP_EN0_CLK_SYS_I2C1 = 0x80
	// Position of CLK_SYS_I2C0 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_I2C0_Pos = 0x6
	// Bit mask of CLK_SYS_I2C0 field.
	CLOCKS_SLEEP_EN0_CLK_SYS_I2C0_Msk = 0x40
	// Bit CLK_SYS_I2C0.
	CLOCKS_SLEEP_EN0_CLK_SYS_I2C0 = 0x40
	// Position of CLK_SYS_DMA field.
	CLOCKS_SLEEP_EN0_CLK_SYS_DMA_Pos = 0x5
	// Bit mask of CLK_SYS_DMA field.
	CLOCKS_SLEEP_EN0_CLK_SYS_DMA_Msk = 0x20
	// Bit CLK_SYS_DMA.
	CLOCKS_SLEEP_EN0_CLK_SYS_DMA = 0x20
	// Position of CLK_SYS_BUSFABRIC field.
	CLOCKS_SLEEP_EN0_CLK_SYS_BUSFABRIC_Pos = 0x4
	// Bit mask of CLK_SYS_BUSFABRIC field.
	CLOCKS_SLEEP_EN0_CLK_SYS_BUSFABRIC_Msk = 0x10
	// Bit CLK_SYS_BUSFABRIC.
	CLOCKS_SLEEP_EN0_CLK_SYS_BUSFABRIC = 0x10
	// Position of CLK_SYS_BUSCTRL field.
	CLOCKS_SLEEP_EN0_CLK_SYS_BUSCTRL_Pos = 0x3
	// Bit mask of CLK_SYS_BUSCTRL field.
	CLOCKS_SLEEP_EN0_CLK_SYS_BUSCTRL_Msk = 0x8
	// Bit CLK_SYS_BUSCTRL.
	CLOCKS_SLEEP_EN0_CLK_SYS_BUSCTRL = 0x8
	// Position of CLK_SYS_ADC field.
	CLOCKS_SLEEP_EN0_CLK_SYS_ADC_Pos = 0x2
	// Bit mask of CLK_SYS_ADC field.
	CLOCKS_SLEEP_EN0_CLK_SYS_ADC_Msk = 0x4
	// Bit CLK_SYS_ADC.
	CLOCKS_SLEEP_EN0_CLK_SYS_ADC = 0x4
	// Position of CLK_ADC_ADC field.
	CLOCKS_SLEEP_EN0_CLK_ADC_ADC_Pos = 0x1
	// Bit mask of CLK_ADC_ADC field.
	CLOCKS_SLEEP_EN0_CLK_ADC_ADC_Msk = 0x2
	// Bit CLK_ADC_ADC.
	CLOCKS_SLEEP_EN0_CLK_ADC_ADC = 0x2
	// Position of CLK_SYS_CLOCKS field.
	CLOCKS_SLEEP_EN0_CLK_SYS_CLOCKS_Pos = 0x0
	// Bit mask of CLK_SYS_CLOCKS field.
	CLOCKS_SLEEP_EN0_CLK_SYS_CLOCKS_Msk = 0x1
	// Bit CLK_SYS_CLOCKS.
	CLOCKS_SLEEP_EN0_CLK_SYS_CLOCKS = 0x1

	// SLEEP_EN1: enable clock in sleep mode
	// Position of CLK_SYS_XOSC field.
	CLOCKS_SLEEP_EN1_CLK_SYS_XOSC_Pos = 0xe
	// Bit mask of CLK_SYS_XOSC field.
	CLOCKS_SLEEP_EN1_CLK_SYS_XOSC_Msk = 0x4000
	// Bit CLK_SYS_XOSC.
	CLOCKS_SLEEP_EN1_CLK_SYS_XOSC = 0x4000
	// Position of CLK_SYS_XIP field.
	CLOCKS_SLEEP_EN1_CLK_SYS_XIP_Pos = 0xd
	// Bit mask of CLK_SYS_XIP field.
	CLOCKS_SLEEP_EN1_CLK_SYS_XIP_Msk = 0x2000
	// Bit CLK_SYS_XIP.
	CLOCKS_SLEEP_EN1_CLK_SYS_XIP = 0x2000
	// Position of CLK_SYS_WATCHDOG field.
	CLOCKS_SLEEP_EN1_CLK_SYS_WATCHDOG_Pos = 0xc
	// Bit mask of CLK_SYS_WATCHDOG field.
	CLOCKS_SLEEP_EN1_CLK_SYS_WATCHDOG_Msk = 0x1000
	// Bit CLK_SYS_WATCHDOG.
	CLOCKS_SLEEP_EN1_CLK_SYS_WATCHDOG = 0x1000
	// Position of CLK_USB_USBCTRL field.
	CLOCKS_SLEEP_EN1_CLK_USB_USBCTRL_Pos = 0xb
	// Bit mask of CLK_USB_USBCTRL field.
	CLOCKS_SLEEP_EN1_CLK_USB_USBCTRL_Msk = 0x800
	// Bit CLK_USB_USBCTRL.
	CLOCKS_SLEEP_EN1_CLK_USB_USBCTRL = 0x800
	// Position of CLK_SYS_USBCTRL field.
	CLOCKS_SLEEP_EN1_CLK_SYS_USBCTRL_Pos = 0xa
	// Bit mask of CLK_SYS_USBCTRL field.
	CLOCKS_SLEEP_EN1_CLK_SYS_USBCTRL_Msk = 0x400
	// Bit CLK_SYS_USBCTRL.
	CLOCKS_SLEEP_EN1_CLK_SYS_USBCTRL = 0x400
	// Position of CLK_SYS_UART1 field.
	CLOCKS_SLEEP_EN1_CLK_SYS_UART1_Pos = 0x9
	// Bit mask of CLK_SYS_UART1 field.
	CLOCKS_SLEEP_EN1_CLK_SYS_UART1_Msk = 0x200
	// Bit CLK_SYS_UART1.
	CLOCKS_SLEEP_EN1_CLK_SYS_UART1 = 0x200
	// Position of CLK_PERI_UART1 field.
	CLOCKS_SLEEP_EN1_CLK_PERI_UART1_Pos = 0x8
	// Bit mask of CLK_PERI_UART1 field.
	CLOCKS_SLEEP_EN1_CLK_PERI_UART1_Msk = 0x100
	// Bit CLK_PERI_UART1.
	CLOCKS_SLEEP_EN1_CLK_PERI_UART1 = 0x100
	// Position of CLK_SYS_UART0 field.
	CLOCKS_SLEEP_EN1_CLK_SYS_UART0_Pos = 0x7
	// Bit mask of CLK_SYS_UART0 field.
	CLOCKS_SLEEP_EN1_CLK_SYS_UART0_Msk = 0x80
	// Bit CLK_SYS_UART0.
	CLOCKS_SLEEP_EN1_CLK_SYS_UART0 = 0x80
	// Position of CLK_PERI_UART0 field.
	CLOCKS_SLEEP_EN1_CLK_PERI_UART0_Pos = 0x6
	// Bit mask of CLK_PERI_UART0 field.
	CLOCKS_SLEEP_EN1_CLK_PERI_UART0_Msk = 0x40
	// Bit CLK_PERI_UART0.
	CLOCKS_SLEEP_EN1_CLK_PERI_UART0 = 0x40
	// Position of CLK_SYS_TIMER field.
	CLOCKS_SLEEP_EN1_CLK_SYS_TIMER_Pos = 0x5
	// Bit mask of CLK_SYS_TIMER field.
	CLOCKS_SLEEP_EN1_CLK_SYS_TIMER_Msk = 0x20
	// Bit CLK_SYS_TIMER.
	CLOCKS_SLEEP_EN1_CLK_SYS_TIMER = 0x20
	// Position of CLK_SYS_TBMAN field.
	CLOCKS_SLEEP_EN1_CLK_SYS_TBMAN_Pos = 0x4
	// Bit mask of CLK_SYS_TBMAN field.
	CLOCKS_SLEEP_EN1_CLK_SYS_TBMAN_Msk = 0x10
	// Bit CLK_SYS_TBMAN.
	CLOCKS_SLEEP_EN1_CLK_SYS_TBMAN = 0x10
	// Position of CLK_SYS_SYSINFO field.
	CLOCKS_SLEEP_EN1_CLK_SYS_SYSINFO_Pos = 0x3
	// Bit mask of CLK_SYS_SYSINFO field.
	CLOCKS_SLEEP_EN1_CLK_SYS_SYSINFO_Msk = 0x8
	// Bit CLK_SYS_SYSINFO.
	CLOCKS_SLEEP_EN1_CLK_SYS_SYSINFO = 0x8
	// Position of CLK_SYS_SYSCFG field.
	CLOCKS_SLEEP_EN1_CLK_SYS_SYSCFG_Pos = 0x2
	// Bit mask of CLK_SYS_SYSCFG field.
	CLOCKS_SLEEP_EN1_CLK_SYS_SYSCFG_Msk = 0x4
	// Bit CLK_SYS_SYSCFG.
	CLOCKS_SLEEP_EN1_CLK_SYS_SYSCFG = 0x4
	// Position of CLK_SYS_SRAM5 field.
	CLOCKS_SLEEP_EN1_CLK_SYS_SRAM5_Pos = 0x1
	// Bit mask of CLK_SYS_SRAM5 field.
	CLOCKS_SLEEP_EN1_CLK_SYS_SRAM5_Msk = 0x2
	// Bit CLK_SYS_SRAM5.
	CLOCKS_SLEEP_EN1_CLK_SYS_SRAM5 = 0x2
	// Position of CLK_SYS_SRAM4 field.
	CLOCKS_SLEEP_EN1_CLK_SYS_SRAM4_Pos = 0x0
	// Bit mask of CLK_SYS_SRAM4 field.
	CLOCKS_SLEEP_EN1_CLK_SYS_SRAM4_Msk = 0x1
	// Bit CLK_SYS_SRAM4.
	CLOCKS_SLEEP_EN1_CLK_SYS_SRAM4 = 0x1

	// ENABLED0: indicates the state of the clock enable
	// Position of CLK_SYS_SRAM3 field.
	CLOCKS_ENABLED0_CLK_SYS_SRAM3_Pos = 0x1f
	// Bit mask of CLK_SYS_SRAM3 field.
	CLOCKS_ENABLED0_CLK_SYS_SRAM3_Msk = 0x80000000
	// Bit CLK_SYS_SRAM3.
	CLOCKS_ENABLED0_CLK_SYS_SRAM3 = 0x80000000
	// Position of CLK_SYS_SRAM2 field.
	CLOCKS_ENABLED0_CLK_SYS_SRAM2_Pos = 0x1e
	// Bit mask of CLK_SYS_SRAM2 field.
	CLOCKS_ENABLED0_CLK_SYS_SRAM2_Msk = 0x40000000
	// Bit CLK_SYS_SRAM2.
	CLOCKS_ENABLED0_CLK_SYS_SRAM2 = 0x40000000
	// Position of CLK_SYS_SRAM1 field.
	CLOCKS_ENABLED0_CLK_SYS_SRAM1_Pos = 0x1d
	// Bit mask of CLK_SYS_SRAM1 field.
	CLOCKS_ENABLED0_CLK_SYS_SRAM1_Msk = 0x20000000
	// Bit CLK_SYS_SRAM1.
	CLOCKS_ENABLED0_CLK_SYS_SRAM1 = 0x20000000
	// Position of CLK_SYS_SRAM0 field.
	CLOCKS_ENABLED0_CLK_SYS_SRAM0_Pos = 0x1c
	// Bit mask of CLK_SYS_SRAM0 field.
	CLOCKS_ENABLED0_CLK_SYS_SRAM0_Msk = 0x10000000
	// Bit CLK_SYS_SRAM0.
	CLOCKS_ENABLED0_CLK_SYS_SRAM0 = 0x10000000
	// Position of CLK_SYS_SPI1 field.
	CLOCKS_ENABLED0_CLK_SYS_SPI1_Pos = 0x1b
	// Bit mask of CLK_SYS_SPI1 field.
	CLOCKS_ENABLED0_CLK_SYS_SPI1_Msk = 0x8000000
	// Bit CLK_SYS_SPI1.
	CLOCKS_ENABLED0_CLK_SYS_SPI1 = 0x8000000
	// Position of CLK_PERI_SPI1 field.
	CLOCKS_ENABLED0_CLK_PERI_SPI1_Pos = 0x1a
	// Bit mask of CLK_PERI_SPI1 field.
	CLOCKS_ENABLED0_CLK_PERI_SPI1_Msk = 0x4000000
	// Bit CLK_PERI_SPI1.
	CLOCKS_ENABLED0_CLK_PERI_SPI1 = 0x4000000
	// Position of CLK_SYS_SPI0 field.
	CLOCKS_ENABLED0_CLK_SYS_SPI0_Pos = 0x19
	// Bit mask of CLK_SYS_SPI0 field.
	CLOCKS_ENABLED0_CLK_SYS_SPI0_Msk = 0x2000000
	// Bit CLK_SYS_SPI0.
	CLOCKS_ENABLED0_CLK_SYS_SPI0 = 0x2000000
	// Position of CLK_PERI_SPI0 field.
	CLOCKS_ENABLED0_CLK_PERI_SPI0_Pos = 0x18
	// Bit mask of CLK_PERI_SPI0 field.
	CLOCKS_ENABLED0_CLK_PERI_SPI0_Msk = 0x1000000
	// Bit CLK_PERI_SPI0.
	CLOCKS_ENABLED0_CLK_PERI_SPI0 = 0x1000000
	// Position of CLK_SYS_SIO field.
	CLOCKS_ENABLED0_CLK_SYS_SIO_Pos = 0x17
	// Bit mask of CLK_SYS_SIO field.
	CLOCKS_ENABLED0_CLK_SYS_SIO_Msk = 0x800000
	// Bit CLK_SYS_SIO.
	CLOCKS_ENABLED0_CLK_SYS_SIO = 0x800000
	// Position of CLK_SYS_RTC field.
	CLOCKS_ENABLED0_CLK_SYS_RTC_Pos = 0x16
	// Bit mask of CLK_SYS_RTC field.
	CLOCKS_ENABLED0_CLK_SYS_RTC_Msk = 0x400000
	// Bit CLK_SYS_RTC.
	CLOCKS_ENABLED0_CLK_SYS_RTC = 0x400000
	// Position of CLK_RTC_RTC field.
	CLOCKS_ENABLED0_CLK_RTC_RTC_Pos = 0x15
	// Bit mask of CLK_RTC_RTC field.
	CLOCKS_ENABLED0_CLK_RTC_RTC_Msk = 0x200000
	// Bit CLK_RTC_RTC.
	CLOCKS_ENABLED0_CLK_RTC_RTC = 0x200000
	// Position of CLK_SYS_ROSC field.
	CLOCKS_ENABLED0_CLK_SYS_ROSC_Pos = 0x14
	// Bit mask of CLK_SYS_ROSC field.
	CLOCKS_ENABLED0_CLK_SYS_ROSC_Msk = 0x100000
	// Bit CLK_SYS_ROSC.
	CLOCKS_ENABLED0_CLK_SYS_ROSC = 0x100000
	// Position of CLK_SYS_ROM field.
	CLOCKS_ENABLED0_CLK_SYS_ROM_Pos = 0x13
	// Bit mask of CLK_SYS_ROM field.
	CLOCKS_ENABLED0_CLK_SYS_ROM_Msk = 0x80000
	// Bit CLK_SYS_ROM.
	CLOCKS_ENABLED0_CLK_SYS_ROM = 0x80000
	// Position of CLK_SYS_RESETS field.
	CLOCKS_ENABLED0_CLK_SYS_RESETS_Pos = 0x12
	// Bit mask of CLK_SYS_RESETS field.
	CLOCKS_ENABLED0_CLK_SYS_RESETS_Msk = 0x40000
	// Bit CLK_SYS_RESETS.
	CLOCKS_ENABLED0_CLK_SYS_RESETS = 0x40000
	// Position of CLK_SYS_PWM field.
	CLOCKS_ENABLED0_CLK_SYS_PWM_Pos = 0x11
	// Bit mask of CLK_SYS_PWM field.
	CLOCKS_ENABLED0_CLK_SYS_PWM_Msk = 0x20000
	// Bit CLK_SYS_PWM.
	CLOCKS_ENABLED0_CLK_SYS_PWM = 0x20000
	// Position of CLK_SYS_PSM field.
	CLOCKS_ENABLED0_CLK_SYS_PSM_Pos = 0x10
	// Bit mask of CLK_SYS_PSM field.
	CLOCKS_ENABLED0_CLK_SYS_PSM_Msk = 0x10000
	// Bit CLK_SYS_PSM.
	CLOCKS_ENABLED0_CLK_SYS_PSM = 0x10000
	// Position of CLK_SYS_PLL_USB field.
	CLOCKS_ENABLED0_CLK_SYS_PLL_USB_Pos = 0xf
	// Bit mask of CLK_SYS_PLL_USB field.
	CLOCKS_ENABLED0_CLK_SYS_PLL_USB_Msk = 0x8000
	// Bit CLK_SYS_PLL_USB.
	CLOCKS_ENABLED0_CLK_SYS_PLL_USB = 0x8000
	// Position of CLK_SYS_PLL_SYS field.
	CLOCKS_ENABLED0_CLK_SYS_PLL_SYS_Pos = 0xe
	// Bit mask of CLK_SYS_PLL_SYS field.
	CLOCKS_ENABLED0_CLK_SYS_PLL_SYS_Msk = 0x4000
	// Bit CLK_SYS_PLL_SYS.
	CLOCKS_ENABLED0_CLK_SYS_PLL_SYS = 0x4000
	// Position of CLK_SYS_PIO1 field.
	CLOCKS_ENABLED0_CLK_SYS_PIO1_Pos = 0xd
	// Bit mask of CLK_SYS_PIO1 field.
	CLOCKS_ENABLED0_CLK_SYS_PIO1_Msk = 0x2000
	// Bit CLK_SYS_PIO1.
	CLOCKS_ENABLED0_CLK_SYS_PIO1 = 0x2000
	// Position of CLK_SYS_PIO0 field.
	CLOCKS_ENABLED0_CLK_SYS_PIO0_Pos = 0xc
	// Bit mask of CLK_SYS_PIO0 field.
	CLOCKS_ENABLED0_CLK_SYS_PIO0_Msk = 0x1000
	// Bit CLK_SYS_PIO0.
	CLOCKS_ENABLED0_CLK_SYS_PIO0 = 0x1000
	// Position of CLK_SYS_PADS field.
	CLOCKS_ENABLED0_CLK_SYS_PADS_Pos = 0xb
	// Bit mask of CLK_SYS_PADS field.
	CLOCKS_ENABLED0_CLK_SYS_PADS_Msk = 0x800
	// Bit CLK_SYS_PADS.
	CLOCKS_ENABLED0_CLK_SYS_PADS = 0x800
	// Position of CLK_SYS_VREG_AND_CHIP_RESET field.
	CLOCKS_ENABLED0_CLK_SYS_VREG_AND_CHIP_RESET_Pos = 0xa
	// Bit mask of CLK_SYS_VREG_AND_CHIP_RESET field.
	CLOCKS_ENABLED0_CLK_SYS_VREG_AND_CHIP_RESET_Msk = 0x400
	// Bit CLK_SYS_VREG_AND_CHIP_RESET.
	CLOCKS_ENABLED0_CLK_SYS_VREG_AND_CHIP_RESET = 0x400
	// Position of CLK_SYS_JTAG field.
	CLOCKS_ENABLED0_CLK_SYS_JTAG_Pos = 0x9
	// Bit mask of CLK_SYS_JTAG field.
	CLOCKS_ENABLED0_CLK_SYS_JTAG_Msk = 0x200
	// Bit CLK_SYS_JTAG.
	CLOCKS_ENABLED0_CLK_SYS_JTAG = 0x200
	// Position of CLK_SYS_IO field.
	CLOCKS_ENABLED0_CLK_SYS_IO_Pos = 0x8
	// Bit mask of CLK_SYS_IO field.
	CLOCKS_ENABLED0_CLK_SYS_IO_Msk = 0x100
	// Bit CLK_SYS_IO.
	CLOCKS_ENABLED0_CLK_SYS_IO = 0x100
	// Position of CLK_SYS_I2C1 field.
	CLOCKS_ENABLED0_CLK_SYS_I2C1_Pos = 0x7
	// Bit mask of CLK_SYS_I2C1 field.
	CLOCKS_ENABLED0_CLK_SYS_I2C1_Msk = 0x80
	// Bit CLK_SYS_I2C1.
	CLOCKS_ENABLED0_CLK_SYS_I2C1 = 0x80
	// Position of CLK_SYS_I2C0 field.
	CLOCKS_ENABLED0_CLK_SYS_I2C0_Pos = 0x6
	// Bit mask of CLK_SYS_I2C0 field.
	CLOCKS_ENABLED0_CLK_SYS_I2C0_Msk = 0x40
	// Bit CLK_SYS_I2C0.
	CLOCKS_ENABLED0_CLK_SYS_I2C0 = 0x40
	// Position of CLK_SYS_DMA field.
	CLOCKS_ENABLED0_CLK_SYS_DMA_Pos = 0x5
	// Bit mask of CLK_SYS_DMA field.
	CLOCKS_ENABLED0_CLK_SYS_DMA_Msk = 0x20
	// Bit CLK_SYS_DMA.
	CLOCKS_ENABLED0_CLK_SYS_DMA = 0x20
	// Position of CLK_SYS_BUSFABRIC field.
	CLOCKS_ENABLED0_CLK_SYS_BUSFABRIC_Pos = 0x4
	// Bit mask of CLK_SYS_BUSFABRIC field.
	CLOCKS_ENABLED0_CLK_SYS_BUSFABRIC_Msk = 0x10
	// Bit CLK_SYS_BUSFABRIC.
	CLOCKS_ENABLED0_CLK_SYS_BUSFABRIC = 0x10
	// Position of CLK_SYS_BUSCTRL field.
	CLOCKS_ENABLED0_CLK_SYS_BUSCTRL_Pos = 0x3
	// Bit mask of CLK_SYS_BUSCTRL field.
	CLOCKS_ENABLED0_CLK_SYS_BUSCTRL_Msk = 0x8
	// Bit CLK_SYS_BUSCTRL.
	CLOCKS_ENABLED0_CLK_SYS_BUSCTRL = 0x8
	// Position of CLK_SYS_ADC field.
	CLOCKS_ENABLED0_CLK_SYS_ADC_Pos = 0x2
	// Bit mask of CLK_SYS_ADC field.
	CLOCKS_ENABLED0_CLK_SYS_ADC_Msk = 0x4
	// Bit CLK_SYS_ADC.
	CLOCKS_ENABLED0_CLK_SYS_ADC = 0x4
	// Position of CLK_ADC_ADC field.
	CLOCKS_ENABLED0_CLK_ADC_ADC_Pos = 0x1
	// Bit mask of CLK_ADC_ADC field.
	CLOCKS_ENABLED0_CLK_ADC_ADC_Msk = 0x2
	// Bit CLK_ADC_ADC.
	CLOCKS_ENABLED0_CLK_ADC_ADC = 0x2
	// Position of CLK_SYS_CLOCKS field.
	CLOCKS_ENABLED0_CLK_SYS_CLOCKS_Pos = 0x0
	// Bit mask of CLK_SYS_CLOCKS field.
	CLOCKS_ENABLED0_CLK_SYS_CLOCKS_Msk = 0x1
	// Bit CLK_SYS_CLOCKS.
	CLOCKS_ENABLED0_CLK_SYS_CLOCKS = 0x1

	// ENABLED1: indicates the state of the clock enable
	// Position of CLK_SYS_XOSC field.
	CLOCKS_ENABLED1_CLK_SYS_XOSC_Pos = 0xe
	// Bit mask of CLK_SYS_XOSC field.
	CLOCKS_ENABLED1_CLK_SYS_XOSC_Msk = 0x4000
	// Bit CLK_SYS_XOSC.
	CLOCKS_ENABLED1_CLK_SYS_XOSC = 0x4000
	// Position of CLK_SYS_XIP field.
	CLOCKS_ENABLED1_CLK_SYS_XIP_Pos = 0xd
	// Bit mask of CLK_SYS_XIP field.
	CLOCKS_ENABLED1_CLK_SYS_XIP_Msk = 0x2000
	// Bit CLK_SYS_XIP.
	CLOCKS_ENABLED1_CLK_SYS_XIP = 0x2000
	// Position of CLK_SYS_WATCHDOG field.
	CLOCKS_ENABLED1_CLK_SYS_WATCHDOG_Pos = 0xc
	// Bit mask of CLK_SYS_WATCHDOG field.
	CLOCKS_ENABLED1_CLK_SYS_WATCHDOG_Msk = 0x1000
	// Bit CLK_SYS_WATCHDOG.
	CLOCKS_ENABLED1_CLK_SYS_WATCHDOG = 0x1000
	// Position of CLK_USB_USBCTRL field.
	CLOCKS_ENABLED1_CLK_USB_USBCTRL_Pos = 0xb
	// Bit mask of CLK_USB_USBCTRL field.
	CLOCKS_ENABLED1_CLK_USB_USBCTRL_Msk = 0x800
	// Bit CLK_USB_USBCTRL.
	CLOCKS_ENABLED1_CLK_USB_USBCTRL = 0x800
	// Position of CLK_SYS_USBCTRL field.
	CLOCKS_ENABLED1_CLK_SYS_USBCTRL_Pos = 0xa
	// Bit mask of CLK_SYS_USBCTRL field.
	CLOCKS_ENABLED1_CLK_SYS_USBCTRL_Msk = 0x400
	// Bit CLK_SYS_USBCTRL.
	CLOCKS_ENABLED1_CLK_SYS_USBCTRL = 0x400
	// Position of CLK_SYS_UART1 field.
	CLOCKS_ENABLED1_CLK_SYS_UART1_Pos = 0x9
	// Bit mask of CLK_SYS_UART1 field.
	CLOCKS_ENABLED1_CLK_SYS_UART1_Msk = 0x200
	// Bit CLK_SYS_UART1.
	CLOCKS_ENABLED1_CLK_SYS_UART1 = 0x200
	// Position of CLK_PERI_UART1 field.
	CLOCKS_ENABLED1_CLK_PERI_UART1_Pos = 0x8
	// Bit mask of CLK_PERI_UART1 field.
	CLOCKS_ENABLED1_CLK_PERI_UART1_Msk = 0x100
	// Bit CLK_PERI_UART1.
	CLOCKS_ENABLED1_CLK_PERI_UART1 = 0x100
	// Position of CLK_SYS_UART0 field.
	CLOCKS_ENABLED1_CLK_SYS_UART0_Pos = 0x7
	// Bit mask of CLK_SYS_UART0 field.
	CLOCKS_ENABLED1_CLK_SYS_UART0_Msk = 0x80
	// Bit CLK_SYS_UART0.
	CLOCKS_ENABLED1_CLK_SYS_UART0 = 0x80
	// Position of CLK_PERI_UART0 field.
	CLOCKS_ENABLED1_CLK_PERI_UART0_Pos = 0x6
	// Bit mask of CLK_PERI_UART0 field.
	CLOCKS_ENABLED1_CLK_PERI_UART0_Msk = 0x40
	// Bit CLK_PERI_UART0.
	CLOCKS_ENABLED1_CLK_PERI_UART0 = 0x40
	// Position of CLK_SYS_TIMER field.
	CLOCKS_ENABLED1_CLK_SYS_TIMER_Pos = 0x5
	// Bit mask of CLK_SYS_TIMER field.
	CLOCKS_ENABLED1_CLK_SYS_TIMER_Msk = 0x20
	// Bit CLK_SYS_TIMER.
	CLOCKS_ENABLED1_CLK_SYS_TIMER = 0x20
	// Position of CLK_SYS_TBMAN field.
	CLOCKS_ENABLED1_CLK_SYS_TBMAN_Pos = 0x4
	// Bit mask of CLK_SYS_TBMAN field.
	CLOCKS_ENABLED1_CLK_SYS_TBMAN_Msk = 0x10
	// Bit CLK_SYS_TBMAN.
	CLOCKS_ENABLED1_CLK_SYS_TBMAN = 0x10
	// Position of CLK_SYS_SYSINFO field.
	CLOCKS_ENABLED1_CLK_SYS_SYSINFO_Pos = 0x3
	// Bit mask of CLK_SYS_SYSINFO field.
	CLOCKS_ENABLED1_CLK_SYS_SYSINFO_Msk = 0x8
	// Bit CLK_SYS_SYSINFO.
	CLOCKS_ENABLED1_CLK_SYS_SYSINFO = 0x8
	// Position of CLK_SYS_SYSCFG field.
	CLOCKS_ENABLED1_CLK_SYS_SYSCFG_Pos = 0x2
	// Bit mask of CLK_SYS_SYSCFG field.
	CLOCKS_ENABLED1_CLK_SYS_SYSCFG_Msk = 0x4
	// Bit CLK_SYS_SYSCFG.
	CLOCKS_ENABLED1_CLK_SYS_SYSCFG = 0x4
	// Position of CLK_SYS_SRAM5 field.
	CLOCKS_ENABLED1_CLK_SYS_SRAM5_Pos = 0x1
	// Bit mask of CLK_SYS_SRAM5 field.
	CLOCKS_ENABLED1_CLK_SYS_SRAM5_Msk = 0x2
	// Bit CLK_SYS_SRAM5.
	CLOCKS_ENABLED1_CLK_SYS_SRAM5 = 0x2
	// Position of CLK_SYS_SRAM4 field.
	CLOCKS_ENABLED1_CLK_SYS_SRAM4_Pos = 0x0
	// Bit mask of CLK_SYS_SRAM4 field.
	CLOCKS_ENABLED1_CLK_SYS_SRAM4_Msk = 0x1
	// Bit CLK_SYS_SRAM4.
	CLOCKS_ENABLED1_CLK_SYS_SRAM4 = 0x1

	// INTR: Raw Interrupts
	// Position of CLK_SYS_RESUS field.
	CLOCKS_INTR_CLK_SYS_RESUS_Pos = 0x0
	// Bit mask of CLK_SYS_RESUS field.
	CLOCKS_INTR_CLK_SYS_RESUS_Msk = 0x1
	// Bit CLK_SYS_RESUS.
	CLOCKS_INTR_CLK_SYS_RESUS = 0x1

	// INTE: Interrupt Enable
	// Position of CLK_SYS_RESUS field.
	CLOCKS_INTE_CLK_SYS_RESUS_Pos = 0x0
	// Bit mask of CLK_SYS_RESUS field.
	CLOCKS_INTE_CLK_SYS_RESUS_Msk = 0x1
	// Bit CLK_SYS_RESUS.
	CLOCKS_INTE_CLK_SYS_RESUS = 0x1

	// INTF: Interrupt Force
	// Position of CLK_SYS_RESUS field.
	CLOCKS_INTF_CLK_SYS_RESUS_Pos = 0x0
	// Bit mask of CLK_SYS_RESUS field.
	CLOCKS_INTF_CLK_SYS_RESUS_Msk = 0x1
	// Bit CLK_SYS_RESUS.
	CLOCKS_INTF_CLK_SYS_RESUS = 0x1

	// INTS: Interrupt status after masking & forcing
	// Position of CLK_SYS_RESUS field.
	CLOCKS_INTS_CLK_SYS_RESUS_Pos = 0x0
	// Bit mask of CLK_SYS_RESUS field.
	CLOCKS_INTS_CLK_SYS_RESUS_Msk = 0x1
	// Bit CLK_SYS_RESUS.
	CLOCKS_INTS_CLK_SYS_RESUS = 0x1
)

// Bitfields for RESETS
const (
	// RESET: Reset control. If a bit is set it means the peripheral is in reset. 0 means the peripheral's reset is deasserted.
	// Position of USBCTRL field.
	RESETS_RESET_USBCTRL_Pos = 0x18
	// Bit mask of USBCTRL field.
	RESETS_RESET_USBCTRL_Msk = 0x1000000
	// Bit USBCTRL.
	RESETS_RESET_USBCTRL = 0x1000000
	// Position of UART1 field.
	RESETS_RESET_UART1_Pos = 0x17
	// Bit mask of UART1 field.
	RESETS_RESET_UART1_Msk = 0x800000
	// Bit UART1.
	RESETS_RESET_UART1 = 0x800000
	// Position of UART0 field.
	RESETS_RESET_UART0_Pos = 0x16
	// Bit mask of UART0 field.
	RESETS_RESET_UART0_Msk = 0x400000
	// Bit UART0.
	RESETS_RESET_UART0 = 0x400000
	// Position of TIMER field.
	RESETS_RESET_TIMER_Pos = 0x15
	// Bit mask of TIMER field.
	RESETS_RESET_TIMER_Msk = 0x200000
	// Bit TIMER.
	RESETS_RESET_TIMER = 0x200000
	// Position of TBMAN field.
	RESETS_RESET_TBMAN_Pos = 0x14
	// Bit mask of TBMAN field.
	RESETS_RESET_TBMAN_Msk = 0x100000
	// Bit TBMAN.
	RESETS_RESET_TBMAN = 0x100000
	// Position of SYSINFO field.
	RESETS_RESET_SYSINFO_Pos = 0x13
	// Bit mask of SYSINFO field.
	RESETS_RESET_SYSINFO_Msk = 0x80000
	// Bit SYSINFO.
	RESETS_RESET_SYSINFO = 0x80000
	// Position of SYSCFG field.
	RESETS_RESET_SYSCFG_Pos = 0x12
	// Bit mask of SYSCFG field.
	RESETS_RESET_SYSCFG_Msk = 0x40000
	// Bit SYSCFG.
	RESETS_RESET_SYSCFG = 0x40000
	// Position of SPI1 field.
	RESETS_RESET_SPI1_Pos = 0x11
	// Bit mask of SPI1 field.
	RESETS_RESET_SPI1_Msk = 0x20000
	// Bit SPI1.
	RESETS_RESET_SPI1 = 0x20000
	// Position of SPI0 field.
	RESETS_RESET_SPI0_Pos = 0x10
	// Bit mask of SPI0 field.
	RESETS_RESET_SPI0_Msk = 0x10000
	// Bit SPI0.
	RESETS_RESET_SPI0 = 0x10000
	// Position of RTC field.
	RESETS_RESET_RTC_Pos = 0xf
	// Bit mask of RTC field.
	RESETS_RESET_RTC_Msk = 0x8000
	// Bit RTC.
	RESETS_RESET_RTC = 0x8000
	// Position of PWM field.
	RESETS_RESET_PWM_Pos = 0xe
	// Bit mask of PWM field.
	RESETS_RESET_PWM_Msk = 0x4000
	// Bit PWM.
	RESETS_RESET_PWM = 0x4000
	// Position of PLL_USB field.
	RESETS_RESET_PLL_USB_Pos = 0xd
	// Bit mask of PLL_USB field.
	RESETS_RESET_PLL_USB_Msk = 0x2000
	// Bit PLL_USB.
	RESETS_RESET_PLL_USB = 0x2000
	// Position of PLL_SYS field.
	RESETS_RESET_PLL_SYS_Pos = 0xc
	// Bit mask of PLL_SYS field.
	RESETS_RESET_PLL_SYS_Msk = 0x1000
	// Bit PLL_SYS.
	RESETS_RESET_PLL_SYS = 0x1000
	// Position of PIO1 field.
	RESETS_RESET_PIO1_Pos = 0xb
	// Bit mask of PIO1 field.
	RESETS_RESET_PIO1_Msk = 0x800
	// Bit PIO1.
	RESETS_RESET_PIO1 = 0x800
	// Position of PIO0 field.
	RESETS_RESET_PIO0_Pos = 0xa
	// Bit mask of PIO0 field.
	RESETS_RESET_PIO0_Msk = 0x400
	// Bit PIO0.
	RESETS_RESET_PIO0 = 0x400
	// Position of PADS_QSPI field.
	RESETS_RESET_PADS_QSPI_Pos = 0x9
	// Bit mask of PADS_QSPI field.
	RESETS_RESET_PADS_QSPI_Msk = 0x200
	// Bit PADS_QSPI.
	RESETS_RESET_PADS_QSPI = 0x200
	// Position of PADS_BANK0 field.
	RESETS_RESET_PADS_BANK0_Pos = 0x8
	// Bit mask of PADS_BANK0 field.
	RESETS_RESET_PADS_BANK0_Msk = 0x100
	// Bit PADS_BANK0.
	RESETS_RESET_PADS_BANK0 = 0x100
	// Position of JTAG field.
	RESETS_RESET_JTAG_Pos = 0x7
	// Bit mask of JTAG field.
	RESETS_RESET_JTAG_Msk = 0x80
	// Bit JTAG.
	RESETS_RESET_JTAG = 0x80
	// Position of IO_QSPI field.
	RESETS_RESET_IO_QSPI_Pos = 0x6
	// Bit mask of IO_QSPI field.
	RESETS_RESET_IO_QSPI_Msk = 0x40
	// Bit IO_QSPI.
	RESETS_RESET_IO_QSPI = 0x40
	// Position of IO_BANK0 field.
	RESETS_RESET_IO_BANK0_Pos = 0x5
	// Bit mask of IO_BANK0 field.
	RESETS_RESET_IO_BANK0_Msk = 0x20
	// Bit IO_BANK0.
	RESETS_RESET_IO_BANK0 = 0x20
	// Position of I2C1 field.
	RESETS_RESET_I2C1_Pos = 0x4
	// Bit mask of I2C1 field.
	RESETS_RESET_I2C1_Msk = 0x10
	// Bit I2C1.
	RESETS_RESET_I2C1 = 0x10
	// Position of I2C0 field.
	RESETS_RESET_I2C0_Pos = 0x3
	// Bit mask of I2C0 field.
	RESETS_RESET_I2C0_Msk = 0x8
	// Bit I2C0.
	RESETS_RESET_I2C0 = 0x8
	// Position of DMA field.
	RESETS_RESET_DMA_Pos = 0x2
	// Bit mask of DMA field.
	RESETS_RESET_DMA_Msk = 0x4
	// Bit DMA.
	RESETS_RESET_DMA = 0x4
	// Position of BUSCTRL field.
	RESETS_RESET_BUSCTRL_Pos = 0x1
	// Bit mask of BUSCTRL field.
	RESETS_RESET_BUSCTRL_Msk = 0x2
	// Bit BUSCTRL.
	RESETS_RESET_BUSCTRL = 0x2
	// Position of ADC field.
	RESETS_RESET_ADC_Pos = 0x0
	// Bit mask of ADC field.
	RESETS_RESET_ADC_Msk = 0x1
	// Bit ADC.
	RESETS_RESET_ADC = 0x1

	// WDSEL: Watchdog select. If a bit is set then the watchdog will reset this peripheral when the watchdog fires.
	// Position of USBCTRL field.
	RESETS_WDSEL_USBCTRL_Pos = 0x18
	// Bit mask of USBCTRL field.
	RESETS_WDSEL_USBCTRL_Msk = 0x1000000
	// Bit USBCTRL.
	RESETS_WDSEL_USBCTRL = 0x1000000
	// Position of UART1 field.
	RESETS_WDSEL_UART1_Pos = 0x17
	// Bit mask of UART1 field.
	RESETS_WDSEL_UART1_Msk = 0x800000
	// Bit UART1.
	RESETS_WDSEL_UART1 = 0x800000
	// Position of UART0 field.
	RESETS_WDSEL_UART0_Pos = 0x16
	// Bit mask of UART0 field.
	RESETS_WDSEL_UART0_Msk = 0x400000
	// Bit UART0.
	RESETS_WDSEL_UART0 = 0x400000
	// Position of TIMER field.
	RESETS_WDSEL_TIMER_Pos = 0x15
	// Bit mask of TIMER field.
	RESETS_WDSEL_TIMER_Msk = 0x200000
	// Bit TIMER.
	RESETS_WDSEL_TIMER = 0x200000
	// Position of TBMAN field.
	RESETS_WDSEL_TBMAN_Pos = 0x14
	// Bit mask of TBMAN field.
	RESETS_WDSEL_TBMAN_Msk = 0x100000
	// Bit TBMAN.
	RESETS_WDSEL_TBMAN = 0x100000
	// Position of SYSINFO field.
	RESETS_WDSEL_SYSINFO_Pos = 0x13
	// Bit mask of SYSINFO field.
	RESETS_WDSEL_SYSINFO_Msk = 0x80000
	// Bit SYSINFO.
	RESETS_WDSEL_SYSINFO = 0x80000
	// Position of SYSCFG field.
	RESETS_WDSEL_SYSCFG_Pos = 0x12
	// Bit mask of SYSCFG field.
	RESETS_WDSEL_SYSCFG_Msk = 0x40000
	// Bit SYSCFG.
	RESETS_WDSEL_SYSCFG = 0x40000
	// Position of SPI1 field.
	RESETS_WDSEL_SPI1_Pos = 0x11
	// Bit mask of SPI1 field.
	RESETS_WDSEL_SPI1_Msk = 0x20000
	// Bit SPI1.
	RESETS_WDSEL_SPI1 = 0x20000
	// Position of SPI0 field.
	RESETS_WDSEL_SPI0_Pos = 0x10
	// Bit mask of SPI0 field.
	RESETS_WDSEL_SPI0_Msk = 0x10000
	// Bit SPI0.
	RESETS_WDSEL_SPI0 = 0x10000
	// Position of RTC field.
	RESETS_WDSEL_RTC_Pos = 0xf
	// Bit mask of RTC field.
	RESETS_WDSEL_RTC_Msk = 0x8000
	// Bit RTC.
	RESETS_WDSEL_RTC = 0x8000
	// Position of PWM field.
	RESETS_WDSEL_PWM_Pos = 0xe
	// Bit mask of PWM field.
	RESETS_WDSEL_PWM_Msk = 0x4000
	// Bit PWM.
	RESETS_WDSEL_PWM = 0x4000
	// Position of PLL_USB field.
	RESETS_WDSEL_PLL_USB_Pos = 0xd
	// Bit mask of PLL_USB field.
	RESETS_WDSEL_PLL_USB_Msk = 0x2000
	// Bit PLL_USB.
	RESETS_WDSEL_PLL_USB = 0x2000
	// Position of PLL_SYS field.
	RESETS_WDSEL_PLL_SYS_Pos = 0xc
	// Bit mask of PLL_SYS field.
	RESETS_WDSEL_PLL_SYS_Msk = 0x1000
	// Bit PLL_SYS.
	RESETS_WDSEL_PLL_SYS = 0x1000
	// Position of PIO1 field.
	RESETS_WDSEL_PIO1_Pos = 0xb
	// Bit mask of PIO1 field.
	RESETS_WDSEL_PIO1_Msk = 0x800
	// Bit PIO1.
	RESETS_WDSEL_PIO1 = 0x800
	// Position of PIO0 field.
	RESETS_WDSEL_PIO0_Pos = 0xa
	// Bit mask of PIO0 field.
	RESETS_WDSEL_PIO0_Msk = 0x400
	// Bit PIO0.
	RESETS_WDSEL_PIO0 = 0x400
	// Position of PADS_QSPI field.
	RESETS_WDSEL_PADS_QSPI_Pos = 0x9
	// Bit mask of PADS_QSPI field.
	RESETS_WDSEL_PADS_QSPI_Msk = 0x200
	// Bit PADS_QSPI.
	RESETS_WDSEL_PADS_QSPI = 0x200
	// Position of PADS_BANK0 field.
	RESETS_WDSEL_PADS_BANK0_Pos = 0x8
	// Bit mask of PADS_BANK0 field.
	RESETS_WDSEL_PADS_BANK0_Msk = 0x100
	// Bit PADS_BANK0.
	RESETS_WDSEL_PADS_BANK0 = 0x100
	// Position of JTAG field.
	RESETS_WDSEL_JTAG_Pos = 0x7
	// Bit mask of JTAG field.
	RESETS_WDSEL_JTAG_Msk = 0x80
	// Bit JTAG.
	RESETS_WDSEL_JTAG = 0x80
	// Position of IO_QSPI field.
	RESETS_WDSEL_IO_QSPI_Pos = 0x6
	// Bit mask of IO_QSPI field.
	RESETS_WDSEL_IO_QSPI_Msk = 0x40
	// Bit IO_QSPI.
	RESETS_WDSEL_IO_QSPI = 0x40
	// Position of IO_BANK0 field.
	RESETS_WDSEL_IO_BANK0_Pos = 0x5
	// Bit mask of IO_BANK0 field.
	RESETS_WDSEL_IO_BANK0_Msk = 0x20
	// Bit IO_BANK0.
	RESETS_WDSEL_IO_BANK0 = 0x20
	// Position of I2C1 field.
	RESETS_WDSEL_I2C1_Pos = 0x4
	// Bit mask of I2C1 field.
	RESETS_WDSEL_I2C1_Msk = 0x10
	// Bit I2C1.
	RESETS_WDSEL_I2C1 = 0x10
	// Position of I2C0 field.
	RESETS_WDSEL_I2C0_Pos = 0x3
	// Bit mask of I2C0 field.
	RESETS_WDSEL_I2C0_Msk = 0x8
	// Bit I2C0.
	RESETS_WDSEL_I2C0 = 0x8
	// Position of DMA field.
	RESETS_WDSEL_DMA_Pos = 0x2
	// Bit mask of DMA field.
	RESETS_WDSEL_DMA_Msk = 0x4
	// Bit DMA.
	RESETS_WDSEL_DMA = 0x4
	// Position of BUSCTRL field.
	RESETS_WDSEL_BUSCTRL_Pos = 0x1
	// Bit mask of BUSCTRL field.
	RESETS_WDSEL_BUSCTRL_Msk = 0x2
	// Bit BUSCTRL.
	RESETS_WDSEL_BUSCTRL = 0x2
	// Position of ADC field.
	RESETS_WDSEL_ADC_Pos = 0x0
	// Bit mask of ADC field.
	RESETS_WDSEL_ADC_Msk = 0x1
	// Bit ADC.
	RESETS_WDSEL_ADC = 0x1

	// RESET_DONE: Reset done. If a bit is set then a reset done signal has been returned by the peripheral. This indicates that the peripheral's registers are ready to be accessed.
	// Position of USBCTRL field.
	RESETS_RESET_DONE_USBCTRL_Pos = 0x18
	// Bit mask of USBCTRL field.
	RESETS_RESET_DONE_USBCTRL_Msk = 0x1000000
	// Bit USBCTRL.
	RESETS_RESET_DONE_USBCTRL = 0x1000000
	// Position of UART1 field.
	RESETS_RESET_DONE_UART1_Pos = 0x17
	// Bit mask of UART1 field.
	RESETS_RESET_DONE_UART1_Msk = 0x800000
	// Bit UART1.
	RESETS_RESET_DONE_UART1 = 0x800000
	// Position of UART0 field.
	RESETS_RESET_DONE_UART0_Pos = 0x16
	// Bit mask of UART0 field.
	RESETS_RESET_DONE_UART0_Msk = 0x400000
	// Bit UART0.
	RESETS_RESET_DONE_UART0 = 0x400000
	// Position of TIMER field.
	RESETS_RESET_DONE_TIMER_Pos = 0x15
	// Bit mask of TIMER field.
	RESETS_RESET_DONE_TIMER_Msk = 0x200000
	// Bit TIMER.
	RESETS_RESET_DONE_TIMER = 0x200000
	// Position of TBMAN field.
	RESETS_RESET_DONE_TBMAN_Pos = 0x14
	// Bit mask of TBMAN field.
	RESETS_RESET_DONE_TBMAN_Msk = 0x100000
	// Bit TBMAN.
	RESETS_RESET_DONE_TBMAN = 0x100000
	// Position of SYSINFO field.
	RESETS_RESET_DONE_SYSINFO_Pos = 0x13
	// Bit mask of SYSINFO field.
	RESETS_RESET_DONE_SYSINFO_Msk = 0x80000
	// Bit SYSINFO.
	RESETS_RESET_DONE_SYSINFO = 0x80000
	// Position of SYSCFG field.
	RESETS_RESET_DONE_SYSCFG_Pos = 0x12
	// Bit mask of SYSCFG field.
	RESETS_RESET_DONE_SYSCFG_Msk = 0x40000
	// Bit SYSCFG.
	RESETS_RESET_DONE_SYSCFG = 0x40000
	// Position of SPI1 field.
	RESETS_RESET_DONE_SPI1_Pos = 0x11
	// Bit mask of SPI1 field.
	RESETS_RESET_DONE_SPI1_Msk = 0x20000
	// Bit SPI1.
	RESETS_RESET_DONE_SPI1 = 0x20000
	// Position of SPI0 field.
	RESETS_RESET_DONE_SPI0_Pos = 0x10
	// Bit mask of SPI0 field.
	RESETS_RESET_DONE_SPI0_Msk = 0x10000
	// Bit SPI0.
	RESETS_RESET_DONE_SPI0 = 0x10000
	// Position of RTC field.
	RESETS_RESET_DONE_RTC_Pos = 0xf
	// Bit mask of RTC field.
	RESETS_RESET_DONE_RTC_Msk = 0x8000
	// Bit RTC.
	RESETS_RESET_DONE_RTC = 0x8000
	// Position of PWM field.
	RESETS_RESET_DONE_PWM_Pos = 0xe
	// Bit mask of PWM field.
	RESETS_RESET_DONE_PWM_Msk = 0x4000
	// Bit PWM.
	RESETS_RESET_DONE_PWM = 0x4000
	// Position of PLL_USB field.
	RESETS_RESET_DONE_PLL_USB_Pos = 0xd
	// Bit mask of PLL_USB field.
	RESETS_RESET_DONE_PLL_USB_Msk = 0x2000
	// Bit PLL_USB.
	RESETS_RESET_DONE_PLL_USB = 0x2000
	// Position of PLL_SYS field.
	RESETS_RESET_DONE_PLL_SYS_Pos = 0xc
	// Bit mask of PLL_SYS field.
	RESETS_RESET_DONE_PLL_SYS_Msk = 0x1000
	// Bit PLL_SYS.
	RESETS_RESET_DONE_PLL_SYS = 0x1000
	// Position of PIO1 field.
	RESETS_RESET_DONE_PIO1_Pos = 0xb
	// Bit mask of PIO1 field.
	RESETS_RESET_DONE_PIO1_Msk = 0x800
	// Bit PIO1.
	RESETS_RESET_DONE_PIO1 = 0x800
	// Position of PIO0 field.
	RESETS_RESET_DONE_PIO0_Pos = 0xa
	// Bit mask of PIO0 field.
	RESETS_RESET_DONE_PIO0_Msk = 0x400
	// Bit PIO0.
	RESETS_RESET_DONE_PIO0 = 0x400
	// Position of PADS_QSPI field.
	RESETS_RESET_DONE_PADS_QSPI_Pos = 0x9
	// Bit mask of PADS_QSPI field.
	RESETS_RESET_DONE_PADS_QSPI_Msk = 0x200
	// Bit PADS_QSPI.
	RESETS_RESET_DONE_PADS_QSPI = 0x200
	// Position of PADS_BANK0 field.
	RESETS_RESET_DONE_PADS_BANK0_Pos = 0x8
	// Bit mask of PADS_BANK0 field.
	RESETS_RESET_DONE_PADS_BANK0_Msk = 0x100
	// Bit PADS_BANK0.
	RESETS_RESET_DONE_PADS_BANK0 = 0x100
	// Position of JTAG field.
	RESETS_RESET_DONE_JTAG_Pos = 0x7
	// Bit mask of JTAG field.
	RESETS_RESET_DONE_JTAG_Msk = 0x80
	// Bit JTAG.
	RESETS_RESET_DONE_JTAG = 0x80
	// Position of IO_QSPI field.
	RESETS_RESET_DONE_IO_QSPI_Pos = 0x6
	// Bit mask of IO_QSPI field.
	RESETS_RESET_DONE_IO_QSPI_Msk = 0x40
	// Bit IO_QSPI.
	RESETS_RESET_DONE_IO_QSPI = 0x40
	// Position of IO_BANK0 field.
	RESETS_RESET_DONE_IO_BANK0_Pos = 0x5
	// Bit mask of IO_BANK0 field.
	RESETS_RESET_DONE_IO_BANK0_Msk = 0x20
	// Bit IO_BANK0.
	RESETS_RESET_DONE_IO_BANK0 = 0x20
	// Position of I2C1 field.
	RESETS_RESET_DONE_I2C1_Pos = 0x4
	// Bit mask of I2C1 field.
	RESETS_RESET_DONE_I2C1_Msk = 0x10
	// Bit I2C1.
	RESETS_RESET_DONE_I2C1 = 0x10
	// Position of I2C0 field.
	RESETS_RESET_DONE_I2C0_Pos = 0x3
	// Bit mask of I2C0 field.
	RESETS_RESET_DONE_I2C0_Msk = 0x8
	// Bit I2C0.
	RESETS_RESET_DONE_I2C0 = 0x8
	// Position of DMA field.
	RESETS_RESET_DONE_DMA_Pos = 0x2
	// Bit mask of DMA field.
	RESETS_RESET_DONE_DMA_Msk = 0x4
	// Bit DMA.
	RESETS_RESET_DONE_DMA = 0x4
	// Position of BUSCTRL field.
	RESETS_RESET_DONE_BUSCTRL_Pos = 0x1
	// Bit mask of BUSCTRL field.
	RESETS_RESET_DONE_BUSCTRL_Msk = 0x2
	// Bit BUSCTRL.
	RESETS_RESET_DONE_BUSCTRL = 0x2
	// Position of ADC field.
	RESETS_RESET_DONE_ADC_Pos = 0x0
	// Bit mask of ADC field.
	RESETS_RESET_DONE_ADC_Msk = 0x1
	// Bit ADC.
	RESETS_RESET_DONE_ADC = 0x1
)

// Bitfields for PSM
const (
	// FRCE_ON: Force block out of reset (i.e. power it on)
	// Position of PROC1 field.
	PSM_FRCE_ON_PROC1_Pos = 0x10
	// Bit mask of PROC1 field.
	PSM_FRCE_ON_PROC1_Msk = 0x10000
	// Bit PROC1.
	PSM_FRCE_ON_PROC1 = 0x10000
	// Position of PROC0 field.
	PSM_FRCE_ON_PROC0_Pos = 0xf
	// Bit mask of PROC0 field.
	PSM_FRCE_ON_PROC0_Msk = 0x8000
	// Bit PROC0.
	PSM_FRCE_ON_PROC0 = 0x8000
	// Position of SIO field.
	PSM_FRCE_ON_SIO_Pos = 0xe
	// Bit mask of SIO field.
	PSM_FRCE_ON_SIO_Msk = 0x4000
	// Bit SIO.
	PSM_FRCE_ON_SIO = 0x4000
	// Position of VREG_AND_CHIP_RESET field.
	PSM_FRCE_ON_VREG_AND_CHIP_RESET_Pos = 0xd
	// Bit mask of VREG_AND_CHIP_RESET field.
	PSM_FRCE_ON_VREG_AND_CHIP_RESET_Msk = 0x2000
	// Bit VREG_AND_CHIP_RESET.
	PSM_FRCE_ON_VREG_AND_CHIP_RESET = 0x2000
	// Position of XIP field.
	PSM_FRCE_ON_XIP_Pos = 0xc
	// Bit mask of XIP field.
	PSM_FRCE_ON_XIP_Msk = 0x1000
	// Bit XIP.
	PSM_FRCE_ON_XIP = 0x1000
	// Position of SRAM5 field.
	PSM_FRCE_ON_SRAM5_Pos = 0xb
	// Bit mask of SRAM5 field.
	PSM_FRCE_ON_SRAM5_Msk = 0x800
	// Bit SRAM5.
	PSM_FRCE_ON_SRAM5 = 0x800
	// Position of SRAM4 field.
	PSM_FRCE_ON_SRAM4_Pos = 0xa
	// Bit mask of SRAM4 field.
	PSM_FRCE_ON_SRAM4_Msk = 0x400
	// Bit SRAM4.
	PSM_FRCE_ON_SRAM4 = 0x400
	// Position of SRAM3 field.
	PSM_FRCE_ON_SRAM3_Pos = 0x9
	// Bit mask of SRAM3 field.
	PSM_FRCE_ON_SRAM3_Msk = 0x200
	// Bit SRAM3.
	PSM_FRCE_ON_SRAM3 = 0x200
	// Position of SRAM2 field.
	PSM_FRCE_ON_SRAM2_Pos = 0x8
	// Bit mask of SRAM2 field.
	PSM_FRCE_ON_SRAM2_Msk = 0x100
	// Bit SRAM2.
	PSM_FRCE_ON_SRAM2 = 0x100
	// Position of SRAM1 field.
	PSM_FRCE_ON_SRAM1_Pos = 0x7
	// Bit mask of SRAM1 field.
	PSM_FRCE_ON_SRAM1_Msk = 0x80
	// Bit SRAM1.
	PSM_FRCE_ON_SRAM1 = 0x80
	// Position of SRAM0 field.
	PSM_FRCE_ON_SRAM0_Pos = 0x6
	// Bit mask of SRAM0 field.
	PSM_FRCE_ON_SRAM0_Msk = 0x40
	// Bit SRAM0.
	PSM_FRCE_ON_SRAM0 = 0x40
	// Position of ROM field.
	PSM_FRCE_ON_ROM_Pos = 0x5
	// Bit mask of ROM field.
	PSM_FRCE_ON_ROM_Msk = 0x20
	// Bit ROM.
	PSM_FRCE_ON_ROM = 0x20
	// Position of BUSFABRIC field.
	PSM_FRCE_ON_BUSFABRIC_Pos = 0x4
	// Bit mask of BUSFABRIC field.
	PSM_FRCE_ON_BUSFABRIC_Msk = 0x10
	// Bit BUSFABRIC.
	PSM_FRCE_ON_BUSFABRIC = 0x10
	// Position of RESETS field.
	PSM_FRCE_ON_RESETS_Pos = 0x3
	// Bit mask of RESETS field.
	PSM_FRCE_ON_RESETS_Msk = 0x8
	// Bit RESETS.
	PSM_FRCE_ON_RESETS = 0x8
	// Position of CLOCKS field.
	PSM_FRCE_ON_CLOCKS_Pos = 0x2
	// Bit mask of CLOCKS field.
	PSM_FRCE_ON_CLOCKS_Msk = 0x4
	// Bit CLOCKS.
	PSM_FRCE_ON_CLOCKS = 0x4
	// Position of XOSC field.
	PSM_FRCE_ON_XOSC_Pos = 0x1
	// Bit mask of XOSC field.
	PSM_FRCE_ON_XOSC_Msk = 0x2
	// Bit XOSC.
	PSM_FRCE_ON_XOSC = 0x2
	// Position of ROSC field.
	PSM_FRCE_ON_ROSC_Pos = 0x0
	// Bit mask of ROSC field.
	PSM_FRCE_ON_ROSC_Msk = 0x1
	// Bit ROSC.
	PSM_FRCE_ON_ROSC = 0x1

	// FRCE_OFF: Force into reset (i.e. power it off)
	// Position of PROC1 field.
	PSM_FRCE_OFF_PROC1_Pos = 0x10
	// Bit mask of PROC1 field.
	PSM_FRCE_OFF_PROC1_Msk = 0x10000
	// Bit PROC1.
	PSM_FRCE_OFF_PROC1 = 0x10000
	// Position of PROC0 field.
	PSM_FRCE_OFF_PROC0_Pos = 0xf
	// Bit mask of PROC0 field.
	PSM_FRCE_OFF_PROC0_Msk = 0x8000
	// Bit PROC0.
	PSM_FRCE_OFF_PROC0 = 0x8000
	// Position of SIO field.
	PSM_FRCE_OFF_SIO_Pos = 0xe
	// Bit mask of SIO field.
	PSM_FRCE_OFF_SIO_Msk = 0x4000
	// Bit SIO.
	PSM_FRCE_OFF_SIO = 0x4000
	// Position of VREG_AND_CHIP_RESET field.
	PSM_FRCE_OFF_VREG_AND_CHIP_RESET_Pos = 0xd
	// Bit mask of VREG_AND_CHIP_RESET field.
	PSM_FRCE_OFF_VREG_AND_CHIP_RESET_Msk = 0x2000
	// Bit VREG_AND_CHIP_RESET.
	PSM_FRCE_OFF_VREG_AND_CHIP_RESET = 0x2000
	// Position of XIP field.
	PSM_FRCE_OFF_XIP_Pos = 0xc
	// Bit mask of XIP field.
	PSM_FRCE_OFF_XIP_Msk = 0x1000
	// Bit XIP.
	PSM_FRCE_OFF_XIP = 0x1000
	// Position of SRAM5 field.
	PSM_FRCE_OFF_SRAM5_Pos = 0xb
	// Bit mask of SRAM5 field.
	PSM_FRCE_OFF_SRAM5_Msk = 0x800
	// Bit SRAM5.
	PSM_FRCE_OFF_SRAM5 = 0x800
	// Position of SRAM4 field.
	PSM_FRCE_OFF_SRAM4_Pos = 0xa
	// Bit mask of SRAM4 field.
	PSM_FRCE_OFF_SRAM4_Msk = 0x400
	// Bit SRAM4.
	PSM_FRCE_OFF_SRAM4 = 0x400
	// Position of SRAM3 field.
	PSM_FRCE_OFF_SRAM3_Pos = 0x9
	// Bit mask of SRAM3 field.
	PSM_FRCE_OFF_SRAM3_Msk = 0x200
	// Bit SRAM3.
	PSM_FRCE_OFF_SRAM3 = 0x200
	// Position of SRAM2 field.
	PSM_FRCE_OFF_SRAM2_Pos = 0x8
	// Bit mask of SRAM2 field.
	PSM_FRCE_OFF_SRAM2_Msk = 0x100
	// Bit SRAM2.
	PSM_FRCE_OFF_SRAM2 = 0x100
	// Position of SRAM1 field.
	PSM_FRCE_OFF_SRAM1_Pos = 0x7
	// Bit mask of SRAM1 field.
	PSM_FRCE_OFF_SRAM1_Msk = 0x80
	// Bit SRAM1.
	PSM_FRCE_OFF_SRAM1 = 0x80
	// Position of SRAM0 field.
	PSM_FRCE_OFF_SRAM0_Pos = 0x6
	// Bit mask of SRAM0 field.
	PSM_FRCE_OFF_SRAM0_Msk = 0x40
	// Bit SRAM0.
	PSM_FRCE_OFF_SRAM0 = 0x40
	// Position of ROM field.
	PSM_FRCE_OFF_ROM_Pos = 0x5
	// Bit mask of ROM field.
	PSM_FRCE_OFF_ROM_Msk = 0x20
	// Bit ROM.
	PSM_FRCE_OFF_ROM = 0x20
	// Position of BUSFABRIC field.
	PSM_FRCE_OFF_BUSFABRIC_Pos = 0x4
	// Bit mask of BUSFABRIC field.
	PSM_FRCE_OFF_BUSFABRIC_Msk = 0x10
	// Bit BUSFABRIC.
	PSM_FRCE_OFF_BUSFABRIC = 0x10
	// Position of RESETS field.
	PSM_FRCE_OFF_RESETS_Pos = 0x3
	// Bit mask of RESETS field.
	PSM_FRCE_OFF_RESETS_Msk = 0x8
	// Bit RESETS.
	PSM_FRCE_OFF_RESETS = 0x8
	// Position of CLOCKS field.
	PSM_FRCE_OFF_CLOCKS_Pos = 0x2
	// Bit mask of CLOCKS field.
	PSM_FRCE_OFF_CLOCKS_Msk = 0x4
	// Bit CLOCKS.
	PSM_FRCE_OFF_CLOCKS = 0x4
	// Position of XOSC field.
	PSM_FRCE_OFF_XOSC_Pos = 0x1
	// Bit mask of XOSC field.
	PSM_FRCE_OFF_XOSC_Msk = 0x2
	// Bit XOSC.
	PSM_FRCE_OFF_XOSC = 0x2
	// Position of ROSC field.
	PSM_FRCE_OFF_ROSC_Pos = 0x0
	// Bit mask of ROSC field.
	PSM_FRCE_OFF_ROSC_Msk = 0x1
	// Bit ROSC.
	PSM_FRCE_OFF_ROSC = 0x1

	// WDSEL: Set to 1 if this peripheral should be reset when the watchdog fires.
	// Position of PROC1 field.
	PSM_WDSEL_PROC1_Pos = 0x10
	// Bit mask of PROC1 field.
	PSM_WDSEL_PROC1_Msk = 0x10000
	// Bit PROC1.
	PSM_WDSEL_PROC1 = 0x10000
	// Position of PROC0 field.
	PSM_WDSEL_PROC0_Pos = 0xf
	// Bit mask of PROC0 field.
	PSM_WDSEL_PROC0_Msk = 0x8000
	// Bit PROC0.
	PSM_WDSEL_PROC0 = 0x8000
	// Position of SIO field.
	PSM_WDSEL_SIO_Pos = 0xe
	// Bit mask of SIO field.
	PSM_WDSEL_SIO_Msk = 0x4000
	// Bit SIO.
	PSM_WDSEL_SIO = 0x4000
	// Position of VREG_AND_CHIP_RESET field.
	PSM_WDSEL_VREG_AND_CHIP_RESET_Pos = 0xd
	// Bit mask of VREG_AND_CHIP_RESET field.
	PSM_WDSEL_VREG_AND_CHIP_RESET_Msk = 0x2000
	// Bit VREG_AND_CHIP_RESET.
	PSM_WDSEL_VREG_AND_CHIP_RESET = 0x2000
	// Position of XIP field.
	PSM_WDSEL_XIP_Pos = 0xc
	// Bit mask of XIP field.
	PSM_WDSEL_XIP_Msk = 0x1000
	// Bit XIP.
	PSM_WDSEL_XIP = 0x1000
	// Position of SRAM5 field.
	PSM_WDSEL_SRAM5_Pos = 0xb
	// Bit mask of SRAM5 field.
	PSM_WDSEL_SRAM5_Msk = 0x800
	// Bit SRAM5.
	PSM_WDSEL_SRAM5 = 0x800
	// Position of SRAM4 field.
	PSM_WDSEL_SRAM4_Pos = 0xa
	// Bit mask of SRAM4 field.
	PSM_WDSEL_SRAM4_Msk = 0x400
	// Bit SRAM4.
	PSM_WDSEL_SRAM4 = 0x400
	// Position of SRAM3 field.
	PSM_WDSEL_SRAM3_Pos = 0x9
	// Bit mask of SRAM3 field.
	PSM_WDSEL_SRAM3_Msk = 0x200
	// Bit SRAM3.
	PSM_WDSEL_SRAM3 = 0x200
	// Position of SRAM2 field.
	PSM_WDSEL_SRAM2_Pos = 0x8
	// Bit mask of SRAM2 field.
	PSM_WDSEL_SRAM2_Msk = 0x100
	// Bit SRAM2.
	PSM_WDSEL_SRAM2 = 0x100
	// Position of SRAM1 field.
	PSM_WDSEL_SRAM1_Pos = 0x7
	// Bit mask of SRAM1 field.
	PSM_WDSEL_SRAM1_Msk = 0x80
	// Bit SRAM1.
	PSM_WDSEL_SRAM1 = 0x80
	// Position of SRAM0 field.
	PSM_WDSEL_SRAM0_Pos = 0x6
	// Bit mask of SRAM0 field.
	PSM_WDSEL_SRAM0_Msk = 0x40
	// Bit SRAM0.
	PSM_WDSEL_SRAM0 = 0x40
	// Position of ROM field.
	PSM_WDSEL_ROM_Pos = 0x5
	// Bit mask of ROM field.
	PSM_WDSEL_ROM_Msk = 0x20
	// Bit ROM.
	PSM_WDSEL_ROM = 0x20
	// Position of BUSFABRIC field.
	PSM_WDSEL_BUSFABRIC_Pos = 0x4
	// Bit mask of BUSFABRIC field.
	PSM_WDSEL_BUSFABRIC_Msk = 0x10
	// Bit BUSFABRIC.
	PSM_WDSEL_BUSFABRIC = 0x10
	// Position of RESETS field.
	PSM_WDSEL_RESETS_Pos = 0x3
	// Bit mask of RESETS field.
	PSM_WDSEL_RESETS_Msk = 0x8
	// Bit RESETS.
	PSM_WDSEL_RESETS = 0x8
	// Position of CLOCKS field.
	PSM_WDSEL_CLOCKS_Pos = 0x2
	// Bit mask of CLOCKS field.
	PSM_WDSEL_CLOCKS_Msk = 0x4
	// Bit CLOCKS.
	PSM_WDSEL_CLOCKS = 0x4
	// Position of XOSC field.
	PSM_WDSEL_XOSC_Pos = 0x1
	// Bit mask of XOSC field.
	PSM_WDSEL_XOSC_Msk = 0x2
	// Bit XOSC.
	PSM_WDSEL_XOSC = 0x2
	// Position of ROSC field.
	PSM_WDSEL_ROSC_Pos = 0x0
	// Bit mask of ROSC field.
	PSM_WDSEL_ROSC_Msk = 0x1
	// Bit ROSC.
	PSM_WDSEL_ROSC = 0x1

	// DONE: Indicates the peripheral's registers are ready to access.
	// Position of PROC1 field.
	PSM_DONE_PROC1_Pos = 0x10
	// Bit mask of PROC1 field.
	PSM_DONE_PROC1_Msk = 0x10000
	// Bit PROC1.
	PSM_DONE_PROC1 = 0x10000
	// Position of PROC0 field.
	PSM_DONE_PROC0_Pos = 0xf
	// Bit mask of PROC0 field.
	PSM_DONE_PROC0_Msk = 0x8000
	// Bit PROC0.
	PSM_DONE_PROC0 = 0x8000
	// Position of SIO field.
	PSM_DONE_SIO_Pos = 0xe
	// Bit mask of SIO field.
	PSM_DONE_SIO_Msk = 0x4000
	// Bit SIO.
	PSM_DONE_SIO = 0x4000
	// Position of VREG_AND_CHIP_RESET field.
	PSM_DONE_VREG_AND_CHIP_RESET_Pos = 0xd
	// Bit mask of VREG_AND_CHIP_RESET field.
	PSM_DONE_VREG_AND_CHIP_RESET_Msk = 0x2000
	// Bit VREG_AND_CHIP_RESET.
	PSM_DONE_VREG_AND_CHIP_RESET = 0x2000
	// Position of XIP field.
	PSM_DONE_XIP_Pos = 0xc
	// Bit mask of XIP field.
	PSM_DONE_XIP_Msk = 0x1000
	// Bit XIP.
	PSM_DONE_XIP = 0x1000
	// Position of SRAM5 field.
	PSM_DONE_SRAM5_Pos = 0xb
	// Bit mask of SRAM5 field.
	PSM_DONE_SRAM5_Msk = 0x800
	// Bit SRAM5.
	PSM_DONE_SRAM5 = 0x800
	// Position of SRAM4 field.
	PSM_DONE_SRAM4_Pos = 0xa
	// Bit mask of SRAM4 field.
	PSM_DONE_SRAM4_Msk = 0x400
	// Bit SRAM4.
	PSM_DONE_SRAM4 = 0x400
	// Position of SRAM3 field.
	PSM_DONE_SRAM3_Pos = 0x9
	// Bit mask of SRAM3 field.
	PSM_DONE_SRAM3_Msk = 0x200
	// Bit SRAM3.
	PSM_DONE_SRAM3 = 0x200
	// Position of SRAM2 field.
	PSM_DONE_SRAM2_Pos = 0x8
	// Bit mask of SRAM2 field.
	PSM_DONE_SRAM2_Msk = 0x100
	// Bit SRAM2.
	PSM_DONE_SRAM2 = 0x100
	// Position of SRAM1 field.
	PSM_DONE_SRAM1_Pos = 0x7
	// Bit mask of SRAM1 field.
	PSM_DONE_SRAM1_Msk = 0x80
	// Bit SRAM1.
	PSM_DONE_SRAM1 = 0x80
	// Position of SRAM0 field.
	PSM_DONE_SRAM0_Pos = 0x6
	// Bit mask of SRAM0 field.
	PSM_DONE_SRAM0_Msk = 0x40
	// Bit SRAM0.
	PSM_DONE_SRAM0 = 0x40
	// Position of ROM field.
	PSM_DONE_ROM_Pos = 0x5
	// Bit mask of ROM field.
	PSM_DONE_ROM_Msk = 0x20
	// Bit ROM.
	PSM_DONE_ROM = 0x20
	// Position of BUSFABRIC field.
	PSM_DONE_BUSFABRIC_Pos = 0x4
	// Bit mask of BUSFABRIC field.
	PSM_DONE_BUSFABRIC_Msk = 0x10
	// Bit BUSFABRIC.
	PSM_DONE_BUSFABRIC = 0x10
	// Position of RESETS field.
	PSM_DONE_RESETS_Pos = 0x3
	// Bit mask of RESETS field.
	PSM_DONE_RESETS_Msk = 0x8
	// Bit RESETS.
	PSM_DONE_RESETS = 0x8
	// Position of CLOCKS field.
	PSM_DONE_CLOCKS_Pos = 0x2
	// Bit mask of CLOCKS field.
	PSM_DONE_CLOCKS_Msk = 0x4
	// Bit CLOCKS.
	PSM_DONE_CLOCKS = 0x4
	// Position of XOSC field.
	PSM_DONE_XOSC_Pos = 0x1
	// Bit mask of XOSC field.
	PSM_DONE_XOSC_Msk = 0x2
	// Bit XOSC.
	PSM_DONE_XOSC = 0x2
	// Position of ROSC field.
	PSM_DONE_ROSC_Pos = 0x0
	// Bit mask of ROSC field.
	PSM_DONE_ROSC_Msk = 0x1
	// Bit ROSC.
	PSM_DONE_ROSC = 0x1
)

// Bitfields for IO_BANK0
const (
	// GPIO0_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO0_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO0_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO0_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO0_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO0_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO0_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO0_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO0_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO0_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO0_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO0_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO0_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO0_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO0_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO0_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO0_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO0_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO0_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO0_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO0_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO0_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO0_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO0_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO0_STATUS_OUTFROMPERI = 0x100

	// GPIO0_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO0_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO0_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO0_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO0_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO0_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO0_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO0_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO0_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO0_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO0_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO0_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO0_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO0_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO0_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO0_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO0_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO0_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO0_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO0_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO0_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO0_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO0_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO0_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO0_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO0_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO0_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO0_CTRL_FUNCSEL_JTAG_TCK                   = 0x0
	IO_BANK0_GPIO0_CTRL_FUNCSEL_SPI0_RX                    = 0x1
	IO_BANK0_GPIO0_CTRL_FUNCSEL_UART0_TX                   = 0x2
	IO_BANK0_GPIO0_CTRL_FUNCSEL_I2C0_SDA                   = 0x3
	IO_BANK0_GPIO0_CTRL_FUNCSEL_PWM_A_0                    = 0x4
	IO_BANK0_GPIO0_CTRL_FUNCSEL_SIO_0                      = 0x5
	IO_BANK0_GPIO0_CTRL_FUNCSEL_PIO0_0                     = 0x6
	IO_BANK0_GPIO0_CTRL_FUNCSEL_PIO1_0                     = 0x7
	IO_BANK0_GPIO0_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO0_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO1_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO1_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO1_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO1_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO1_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO1_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO1_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO1_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO1_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO1_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO1_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO1_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO1_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO1_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO1_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO1_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO1_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO1_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO1_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO1_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO1_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO1_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO1_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO1_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO1_STATUS_OUTFROMPERI = 0x100

	// GPIO1_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO1_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO1_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO1_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO1_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO1_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO1_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO1_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO1_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO1_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO1_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO1_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO1_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO1_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO1_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO1_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO1_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO1_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO1_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO1_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO1_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO1_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO1_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO1_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO1_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO1_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO1_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO1_CTRL_FUNCSEL_JTAG_TMS               = 0x0
	IO_BANK0_GPIO1_CTRL_FUNCSEL_SPI0_SS_N              = 0x1
	IO_BANK0_GPIO1_CTRL_FUNCSEL_UART0_RX               = 0x2
	IO_BANK0_GPIO1_CTRL_FUNCSEL_I2C0_SCL               = 0x3
	IO_BANK0_GPIO1_CTRL_FUNCSEL_PWM_B_0                = 0x4
	IO_BANK0_GPIO1_CTRL_FUNCSEL_SIO_1                  = 0x5
	IO_BANK0_GPIO1_CTRL_FUNCSEL_PIO0_1                 = 0x6
	IO_BANK0_GPIO1_CTRL_FUNCSEL_PIO1_1                 = 0x7
	IO_BANK0_GPIO1_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO1_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO2_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO2_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO2_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO2_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO2_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO2_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO2_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO2_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO2_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO2_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO2_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO2_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO2_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO2_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO2_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO2_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO2_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO2_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO2_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO2_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO2_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO2_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO2_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO2_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO2_STATUS_OUTFROMPERI = 0x100

	// GPIO2_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO2_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO2_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO2_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO2_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO2_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO2_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO2_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO2_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO2_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO2_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO2_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO2_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO2_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO2_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO2_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO2_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO2_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO2_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO2_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO2_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO2_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO2_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO2_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO2_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO2_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO2_CTRL_FUNCSEL_Msk                = 0x1f
	IO_BANK0_GPIO2_CTRL_FUNCSEL_JTAG_TDI           = 0x0
	IO_BANK0_GPIO2_CTRL_FUNCSEL_SPI0_SCLK          = 0x1
	IO_BANK0_GPIO2_CTRL_FUNCSEL_UART0_CTS          = 0x2
	IO_BANK0_GPIO2_CTRL_FUNCSEL_I2C1_SDA           = 0x3
	IO_BANK0_GPIO2_CTRL_FUNCSEL_PWM_A_1            = 0x4
	IO_BANK0_GPIO2_CTRL_FUNCSEL_SIO_2              = 0x5
	IO_BANK0_GPIO2_CTRL_FUNCSEL_PIO0_2             = 0x6
	IO_BANK0_GPIO2_CTRL_FUNCSEL_PIO1_2             = 0x7
	IO_BANK0_GPIO2_CTRL_FUNCSEL_USB_MUXING_VBUS_EN = 0x9
	IO_BANK0_GPIO2_CTRL_FUNCSEL_NULL               = 0x1f

	// GPIO3_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO3_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO3_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO3_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO3_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO3_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO3_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO3_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO3_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO3_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO3_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO3_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO3_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO3_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO3_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO3_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO3_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO3_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO3_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO3_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO3_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO3_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO3_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO3_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO3_STATUS_OUTFROMPERI = 0x100

	// GPIO3_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO3_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO3_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO3_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO3_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO3_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO3_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO3_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO3_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO3_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO3_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO3_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO3_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO3_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO3_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO3_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO3_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO3_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO3_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO3_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO3_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO3_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO3_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO3_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO3_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO3_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO3_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO3_CTRL_FUNCSEL_JTAG_TDO                   = 0x0
	IO_BANK0_GPIO3_CTRL_FUNCSEL_SPI0_TX                    = 0x1
	IO_BANK0_GPIO3_CTRL_FUNCSEL_UART0_RTS                  = 0x2
	IO_BANK0_GPIO3_CTRL_FUNCSEL_I2C1_SCL                   = 0x3
	IO_BANK0_GPIO3_CTRL_FUNCSEL_PWM_B_1                    = 0x4
	IO_BANK0_GPIO3_CTRL_FUNCSEL_SIO_3                      = 0x5
	IO_BANK0_GPIO3_CTRL_FUNCSEL_PIO0_3                     = 0x6
	IO_BANK0_GPIO3_CTRL_FUNCSEL_PIO1_3                     = 0x7
	IO_BANK0_GPIO3_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO3_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO4_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO4_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO4_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO4_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO4_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO4_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO4_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO4_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO4_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO4_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO4_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO4_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO4_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO4_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO4_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO4_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO4_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO4_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO4_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO4_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO4_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO4_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO4_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO4_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO4_STATUS_OUTFROMPERI = 0x100

	// GPIO4_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO4_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO4_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO4_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO4_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO4_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO4_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO4_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO4_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO4_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO4_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO4_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO4_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO4_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO4_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO4_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO4_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO4_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO4_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO4_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO4_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO4_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO4_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO4_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO4_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO4_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO4_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO4_CTRL_FUNCSEL_SPI0_RX                = 0x1
	IO_BANK0_GPIO4_CTRL_FUNCSEL_UART1_TX               = 0x2
	IO_BANK0_GPIO4_CTRL_FUNCSEL_I2C0_SDA               = 0x3
	IO_BANK0_GPIO4_CTRL_FUNCSEL_PWM_A_2                = 0x4
	IO_BANK0_GPIO4_CTRL_FUNCSEL_SIO_4                  = 0x5
	IO_BANK0_GPIO4_CTRL_FUNCSEL_PIO0_4                 = 0x6
	IO_BANK0_GPIO4_CTRL_FUNCSEL_PIO1_4                 = 0x7
	IO_BANK0_GPIO4_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO4_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO5_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO5_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO5_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO5_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO5_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO5_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO5_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO5_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO5_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO5_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO5_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO5_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO5_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO5_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO5_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO5_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO5_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO5_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO5_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO5_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO5_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO5_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO5_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO5_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO5_STATUS_OUTFROMPERI = 0x100

	// GPIO5_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO5_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO5_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO5_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO5_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO5_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO5_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO5_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO5_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO5_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO5_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO5_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO5_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO5_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO5_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO5_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO5_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO5_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO5_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO5_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO5_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO5_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO5_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO5_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO5_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO5_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO5_CTRL_FUNCSEL_Msk                = 0x1f
	IO_BANK0_GPIO5_CTRL_FUNCSEL_SPI0_SS_N          = 0x1
	IO_BANK0_GPIO5_CTRL_FUNCSEL_UART1_RX           = 0x2
	IO_BANK0_GPIO5_CTRL_FUNCSEL_I2C0_SCL           = 0x3
	IO_BANK0_GPIO5_CTRL_FUNCSEL_PWM_B_2            = 0x4
	IO_BANK0_GPIO5_CTRL_FUNCSEL_SIO_5              = 0x5
	IO_BANK0_GPIO5_CTRL_FUNCSEL_PIO0_5             = 0x6
	IO_BANK0_GPIO5_CTRL_FUNCSEL_PIO1_5             = 0x7
	IO_BANK0_GPIO5_CTRL_FUNCSEL_USB_MUXING_VBUS_EN = 0x9
	IO_BANK0_GPIO5_CTRL_FUNCSEL_NULL               = 0x1f

	// GPIO6_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO6_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO6_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO6_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO6_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO6_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO6_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO6_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO6_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO6_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO6_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO6_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO6_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO6_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO6_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO6_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO6_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO6_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO6_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO6_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO6_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO6_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO6_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO6_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO6_STATUS_OUTFROMPERI = 0x100

	// GPIO6_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO6_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO6_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO6_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO6_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO6_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO6_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO6_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO6_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO6_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO6_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO6_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO6_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO6_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO6_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO6_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO6_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO6_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO6_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO6_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO6_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO6_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO6_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO6_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO6_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO6_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO6_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO6_CTRL_FUNCSEL_SPI0_SCLK                  = 0x1
	IO_BANK0_GPIO6_CTRL_FUNCSEL_UART1_CTS                  = 0x2
	IO_BANK0_GPIO6_CTRL_FUNCSEL_I2C1_SDA                   = 0x3
	IO_BANK0_GPIO6_CTRL_FUNCSEL_PWM_A_3                    = 0x4
	IO_BANK0_GPIO6_CTRL_FUNCSEL_SIO_6                      = 0x5
	IO_BANK0_GPIO6_CTRL_FUNCSEL_PIO0_6                     = 0x6
	IO_BANK0_GPIO6_CTRL_FUNCSEL_PIO1_6                     = 0x7
	IO_BANK0_GPIO6_CTRL_FUNCSEL_USB_MUXING_EXTPHY_SOFTCON  = 0x8
	IO_BANK0_GPIO6_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO6_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO7_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO7_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO7_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO7_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO7_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO7_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO7_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO7_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO7_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO7_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO7_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO7_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO7_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO7_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO7_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO7_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO7_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO7_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO7_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO7_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO7_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO7_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO7_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO7_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO7_STATUS_OUTFROMPERI = 0x100

	// GPIO7_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO7_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO7_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO7_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO7_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO7_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO7_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO7_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO7_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO7_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO7_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO7_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO7_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO7_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO7_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO7_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO7_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO7_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO7_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO7_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO7_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO7_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO7_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO7_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO7_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO7_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO7_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO7_CTRL_FUNCSEL_SPI0_TX                = 0x1
	IO_BANK0_GPIO7_CTRL_FUNCSEL_UART1_RTS              = 0x2
	IO_BANK0_GPIO7_CTRL_FUNCSEL_I2C1_SCL               = 0x3
	IO_BANK0_GPIO7_CTRL_FUNCSEL_PWM_B_3                = 0x4
	IO_BANK0_GPIO7_CTRL_FUNCSEL_SIO_7                  = 0x5
	IO_BANK0_GPIO7_CTRL_FUNCSEL_PIO0_7                 = 0x6
	IO_BANK0_GPIO7_CTRL_FUNCSEL_PIO1_7                 = 0x7
	IO_BANK0_GPIO7_CTRL_FUNCSEL_USB_MUXING_EXTPHY_OE_N = 0x8
	IO_BANK0_GPIO7_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO7_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO8_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO8_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO8_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO8_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO8_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO8_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO8_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO8_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO8_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO8_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO8_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO8_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO8_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO8_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO8_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO8_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO8_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO8_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO8_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO8_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO8_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO8_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO8_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO8_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO8_STATUS_OUTFROMPERI = 0x100

	// GPIO8_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO8_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO8_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO8_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO8_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO8_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO8_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO8_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO8_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO8_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO8_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO8_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO8_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO8_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO8_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO8_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO8_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO8_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO8_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO8_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO8_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO8_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO8_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO8_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO8_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO8_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO8_CTRL_FUNCSEL_Msk                   = 0x1f
	IO_BANK0_GPIO8_CTRL_FUNCSEL_SPI1_RX               = 0x1
	IO_BANK0_GPIO8_CTRL_FUNCSEL_UART1_TX              = 0x2
	IO_BANK0_GPIO8_CTRL_FUNCSEL_I2C0_SDA              = 0x3
	IO_BANK0_GPIO8_CTRL_FUNCSEL_PWM_A_4               = 0x4
	IO_BANK0_GPIO8_CTRL_FUNCSEL_SIO_8                 = 0x5
	IO_BANK0_GPIO8_CTRL_FUNCSEL_PIO0_8                = 0x6
	IO_BANK0_GPIO8_CTRL_FUNCSEL_PIO1_8                = 0x7
	IO_BANK0_GPIO8_CTRL_FUNCSEL_USB_MUXING_EXTPHY_RCV = 0x8
	IO_BANK0_GPIO8_CTRL_FUNCSEL_USB_MUXING_VBUS_EN    = 0x9
	IO_BANK0_GPIO8_CTRL_FUNCSEL_NULL                  = 0x1f

	// GPIO9_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO9_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO9_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO9_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO9_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO9_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO9_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO9_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO9_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO9_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO9_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO9_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO9_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO9_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO9_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO9_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO9_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO9_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO9_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO9_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO9_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO9_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO9_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO9_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO9_STATUS_OUTFROMPERI = 0x100

	// GPIO9_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO9_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO9_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO9_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO9_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO9_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO9_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO9_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO9_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO9_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO9_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO9_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO9_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO9_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO9_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO9_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO9_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO9_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO9_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO9_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO9_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO9_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO9_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO9_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO9_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO9_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO9_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO9_CTRL_FUNCSEL_SPI1_SS_N                  = 0x1
	IO_BANK0_GPIO9_CTRL_FUNCSEL_UART1_RX                   = 0x2
	IO_BANK0_GPIO9_CTRL_FUNCSEL_I2C0_SCL                   = 0x3
	IO_BANK0_GPIO9_CTRL_FUNCSEL_PWM_B_4                    = 0x4
	IO_BANK0_GPIO9_CTRL_FUNCSEL_SIO_9                      = 0x5
	IO_BANK0_GPIO9_CTRL_FUNCSEL_PIO0_9                     = 0x6
	IO_BANK0_GPIO9_CTRL_FUNCSEL_PIO1_9                     = 0x7
	IO_BANK0_GPIO9_CTRL_FUNCSEL_USB_MUXING_EXTPHY_VP       = 0x8
	IO_BANK0_GPIO9_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO9_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO10_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO10_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO10_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO10_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO10_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO10_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO10_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO10_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO10_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO10_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO10_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO10_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO10_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO10_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO10_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO10_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO10_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO10_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO10_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO10_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO10_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO10_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO10_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO10_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO10_STATUS_OUTFROMPERI = 0x100

	// GPIO10_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO10_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO10_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO10_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO10_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO10_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO10_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO10_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO10_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO10_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO10_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO10_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO10_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO10_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO10_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO10_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO10_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO10_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO10_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO10_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO10_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO10_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO10_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO10_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO10_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO10_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO10_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO10_CTRL_FUNCSEL_SPI1_SCLK              = 0x1
	IO_BANK0_GPIO10_CTRL_FUNCSEL_UART1_CTS              = 0x2
	IO_BANK0_GPIO10_CTRL_FUNCSEL_I2C1_SDA               = 0x3
	IO_BANK0_GPIO10_CTRL_FUNCSEL_PWM_A_5                = 0x4
	IO_BANK0_GPIO10_CTRL_FUNCSEL_SIO_10                 = 0x5
	IO_BANK0_GPIO10_CTRL_FUNCSEL_PIO0_10                = 0x6
	IO_BANK0_GPIO10_CTRL_FUNCSEL_PIO1_10                = 0x7
	IO_BANK0_GPIO10_CTRL_FUNCSEL_USB_MUXING_EXTPHY_VM   = 0x8
	IO_BANK0_GPIO10_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO10_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO11_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO11_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO11_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO11_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO11_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO11_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO11_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO11_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO11_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO11_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO11_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO11_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO11_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO11_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO11_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO11_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO11_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO11_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO11_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO11_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO11_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO11_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO11_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO11_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO11_STATUS_OUTFROMPERI = 0x100

	// GPIO11_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO11_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO11_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO11_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO11_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO11_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO11_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO11_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO11_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO11_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO11_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO11_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO11_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO11_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO11_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO11_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO11_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO11_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO11_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO11_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO11_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO11_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO11_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO11_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO11_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO11_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO11_CTRL_FUNCSEL_Msk                      = 0x1f
	IO_BANK0_GPIO11_CTRL_FUNCSEL_SPI1_TX                  = 0x1
	IO_BANK0_GPIO11_CTRL_FUNCSEL_UART1_RTS                = 0x2
	IO_BANK0_GPIO11_CTRL_FUNCSEL_I2C1_SCL                 = 0x3
	IO_BANK0_GPIO11_CTRL_FUNCSEL_PWM_B_5                  = 0x4
	IO_BANK0_GPIO11_CTRL_FUNCSEL_SIO_11                   = 0x5
	IO_BANK0_GPIO11_CTRL_FUNCSEL_PIO0_11                  = 0x6
	IO_BANK0_GPIO11_CTRL_FUNCSEL_PIO1_11                  = 0x7
	IO_BANK0_GPIO11_CTRL_FUNCSEL_USB_MUXING_EXTPHY_SUSPND = 0x8
	IO_BANK0_GPIO11_CTRL_FUNCSEL_USB_MUXING_VBUS_EN       = 0x9
	IO_BANK0_GPIO11_CTRL_FUNCSEL_NULL                     = 0x1f

	// GPIO12_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO12_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO12_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO12_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO12_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO12_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO12_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO12_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO12_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO12_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO12_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO12_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO12_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO12_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO12_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO12_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO12_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO12_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO12_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO12_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO12_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO12_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO12_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO12_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO12_STATUS_OUTFROMPERI = 0x100

	// GPIO12_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO12_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO12_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO12_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO12_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO12_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO12_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO12_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO12_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO12_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO12_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO12_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO12_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO12_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO12_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO12_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO12_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO12_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO12_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO12_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO12_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO12_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO12_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO12_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO12_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO12_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO12_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO12_CTRL_FUNCSEL_SPI1_RX                    = 0x1
	IO_BANK0_GPIO12_CTRL_FUNCSEL_UART0_TX                   = 0x2
	IO_BANK0_GPIO12_CTRL_FUNCSEL_I2C0_SDA                   = 0x3
	IO_BANK0_GPIO12_CTRL_FUNCSEL_PWM_A_6                    = 0x4
	IO_BANK0_GPIO12_CTRL_FUNCSEL_SIO_12                     = 0x5
	IO_BANK0_GPIO12_CTRL_FUNCSEL_PIO0_12                    = 0x6
	IO_BANK0_GPIO12_CTRL_FUNCSEL_PIO1_12                    = 0x7
	IO_BANK0_GPIO12_CTRL_FUNCSEL_USB_MUXING_EXTPHY_SPEED    = 0x8
	IO_BANK0_GPIO12_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO12_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO13_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO13_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO13_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO13_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO13_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO13_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO13_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO13_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO13_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO13_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO13_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO13_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO13_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO13_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO13_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO13_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO13_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO13_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO13_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO13_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO13_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO13_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO13_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO13_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO13_STATUS_OUTFROMPERI = 0x100

	// GPIO13_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO13_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO13_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO13_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO13_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO13_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO13_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO13_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO13_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO13_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO13_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO13_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO13_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO13_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO13_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO13_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO13_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO13_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO13_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO13_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO13_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO13_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO13_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO13_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO13_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO13_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO13_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO13_CTRL_FUNCSEL_SPI1_SS_N              = 0x1
	IO_BANK0_GPIO13_CTRL_FUNCSEL_UART0_RX               = 0x2
	IO_BANK0_GPIO13_CTRL_FUNCSEL_I2C0_SCL               = 0x3
	IO_BANK0_GPIO13_CTRL_FUNCSEL_PWM_B_6                = 0x4
	IO_BANK0_GPIO13_CTRL_FUNCSEL_SIO_13                 = 0x5
	IO_BANK0_GPIO13_CTRL_FUNCSEL_PIO0_13                = 0x6
	IO_BANK0_GPIO13_CTRL_FUNCSEL_PIO1_13                = 0x7
	IO_BANK0_GPIO13_CTRL_FUNCSEL_USB_MUXING_EXTPHY_VPO  = 0x8
	IO_BANK0_GPIO13_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO13_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO14_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO14_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO14_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO14_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO14_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO14_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO14_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO14_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO14_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO14_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO14_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO14_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO14_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO14_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO14_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO14_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO14_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO14_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO14_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO14_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO14_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO14_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO14_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO14_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO14_STATUS_OUTFROMPERI = 0x100

	// GPIO14_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO14_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO14_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO14_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO14_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO14_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO14_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO14_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO14_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO14_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO14_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO14_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO14_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO14_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO14_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO14_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO14_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO14_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO14_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO14_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO14_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO14_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO14_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO14_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO14_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO14_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO14_CTRL_FUNCSEL_Msk                   = 0x1f
	IO_BANK0_GPIO14_CTRL_FUNCSEL_SPI1_SCLK             = 0x1
	IO_BANK0_GPIO14_CTRL_FUNCSEL_UART0_CTS             = 0x2
	IO_BANK0_GPIO14_CTRL_FUNCSEL_I2C1_SDA              = 0x3
	IO_BANK0_GPIO14_CTRL_FUNCSEL_PWM_A_7               = 0x4
	IO_BANK0_GPIO14_CTRL_FUNCSEL_SIO_14                = 0x5
	IO_BANK0_GPIO14_CTRL_FUNCSEL_PIO0_14               = 0x6
	IO_BANK0_GPIO14_CTRL_FUNCSEL_PIO1_14               = 0x7
	IO_BANK0_GPIO14_CTRL_FUNCSEL_USB_MUXING_EXTPHY_VMO = 0x8
	IO_BANK0_GPIO14_CTRL_FUNCSEL_USB_MUXING_VBUS_EN    = 0x9
	IO_BANK0_GPIO14_CTRL_FUNCSEL_NULL                  = 0x1f

	// GPIO15_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO15_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO15_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO15_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO15_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO15_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO15_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO15_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO15_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO15_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO15_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO15_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO15_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO15_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO15_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO15_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO15_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO15_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO15_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO15_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO15_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO15_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO15_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO15_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO15_STATUS_OUTFROMPERI = 0x100

	// GPIO15_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO15_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO15_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO15_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO15_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO15_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO15_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO15_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO15_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO15_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO15_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO15_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO15_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO15_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO15_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO15_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO15_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO15_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO15_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO15_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO15_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO15_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO15_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO15_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO15_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO15_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO15_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO15_CTRL_FUNCSEL_SPI1_TX                    = 0x1
	IO_BANK0_GPIO15_CTRL_FUNCSEL_UART0_RTS                  = 0x2
	IO_BANK0_GPIO15_CTRL_FUNCSEL_I2C1_SCL                   = 0x3
	IO_BANK0_GPIO15_CTRL_FUNCSEL_PWM_B_7                    = 0x4
	IO_BANK0_GPIO15_CTRL_FUNCSEL_SIO_15                     = 0x5
	IO_BANK0_GPIO15_CTRL_FUNCSEL_PIO0_15                    = 0x6
	IO_BANK0_GPIO15_CTRL_FUNCSEL_PIO1_15                    = 0x7
	IO_BANK0_GPIO15_CTRL_FUNCSEL_USB_MUXING_DIGITAL_DP      = 0x8
	IO_BANK0_GPIO15_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO15_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO16_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO16_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO16_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO16_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO16_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO16_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO16_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO16_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO16_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO16_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO16_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO16_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO16_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO16_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO16_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO16_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO16_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO16_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO16_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO16_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO16_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO16_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO16_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO16_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO16_STATUS_OUTFROMPERI = 0x100

	// GPIO16_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO16_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO16_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO16_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO16_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO16_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO16_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO16_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO16_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO16_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO16_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO16_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO16_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO16_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO16_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO16_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO16_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO16_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO16_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO16_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO16_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO16_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO16_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO16_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO16_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO16_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO16_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO16_CTRL_FUNCSEL_SPI0_RX                = 0x1
	IO_BANK0_GPIO16_CTRL_FUNCSEL_UART0_TX               = 0x2
	IO_BANK0_GPIO16_CTRL_FUNCSEL_I2C0_SDA               = 0x3
	IO_BANK0_GPIO16_CTRL_FUNCSEL_PWM_A_0                = 0x4
	IO_BANK0_GPIO16_CTRL_FUNCSEL_SIO_16                 = 0x5
	IO_BANK0_GPIO16_CTRL_FUNCSEL_PIO0_16                = 0x6
	IO_BANK0_GPIO16_CTRL_FUNCSEL_PIO1_16                = 0x7
	IO_BANK0_GPIO16_CTRL_FUNCSEL_USB_MUXING_DIGITAL_DM  = 0x8
	IO_BANK0_GPIO16_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO16_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO17_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO17_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO17_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO17_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO17_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO17_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO17_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO17_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO17_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO17_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO17_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO17_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO17_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO17_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO17_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO17_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO17_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO17_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO17_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO17_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO17_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO17_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO17_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO17_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO17_STATUS_OUTFROMPERI = 0x100

	// GPIO17_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO17_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO17_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO17_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO17_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO17_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO17_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO17_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO17_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO17_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO17_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO17_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO17_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO17_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO17_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO17_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO17_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO17_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO17_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO17_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO17_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO17_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO17_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO17_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO17_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO17_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO17_CTRL_FUNCSEL_Msk                = 0x1f
	IO_BANK0_GPIO17_CTRL_FUNCSEL_SPI0_SS_N          = 0x1
	IO_BANK0_GPIO17_CTRL_FUNCSEL_UART0_RX           = 0x2
	IO_BANK0_GPIO17_CTRL_FUNCSEL_I2C0_SCL           = 0x3
	IO_BANK0_GPIO17_CTRL_FUNCSEL_PWM_B_0            = 0x4
	IO_BANK0_GPIO17_CTRL_FUNCSEL_SIO_17             = 0x5
	IO_BANK0_GPIO17_CTRL_FUNCSEL_PIO0_17            = 0x6
	IO_BANK0_GPIO17_CTRL_FUNCSEL_PIO1_17            = 0x7
	IO_BANK0_GPIO17_CTRL_FUNCSEL_USB_MUXING_VBUS_EN = 0x9
	IO_BANK0_GPIO17_CTRL_FUNCSEL_NULL               = 0x1f

	// GPIO18_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO18_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO18_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO18_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO18_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO18_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO18_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO18_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO18_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO18_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO18_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO18_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO18_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO18_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO18_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO18_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO18_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO18_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO18_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO18_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO18_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO18_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO18_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO18_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO18_STATUS_OUTFROMPERI = 0x100

	// GPIO18_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO18_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO18_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO18_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO18_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO18_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO18_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO18_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO18_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO18_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO18_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO18_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO18_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO18_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO18_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO18_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO18_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO18_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO18_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO18_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO18_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO18_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO18_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO18_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO18_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO18_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO18_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO18_CTRL_FUNCSEL_SPI0_SCLK                  = 0x1
	IO_BANK0_GPIO18_CTRL_FUNCSEL_UART0_CTS                  = 0x2
	IO_BANK0_GPIO18_CTRL_FUNCSEL_I2C1_SDA                   = 0x3
	IO_BANK0_GPIO18_CTRL_FUNCSEL_PWM_A_1                    = 0x4
	IO_BANK0_GPIO18_CTRL_FUNCSEL_SIO_18                     = 0x5
	IO_BANK0_GPIO18_CTRL_FUNCSEL_PIO0_18                    = 0x6
	IO_BANK0_GPIO18_CTRL_FUNCSEL_PIO1_18                    = 0x7
	IO_BANK0_GPIO18_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO18_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO19_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO19_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO19_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO19_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO19_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO19_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO19_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO19_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO19_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO19_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO19_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO19_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO19_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO19_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO19_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO19_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO19_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO19_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO19_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO19_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO19_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO19_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO19_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO19_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO19_STATUS_OUTFROMPERI = 0x100

	// GPIO19_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO19_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO19_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO19_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO19_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO19_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO19_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO19_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO19_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO19_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO19_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO19_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO19_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO19_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO19_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO19_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO19_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO19_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO19_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO19_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO19_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO19_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO19_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO19_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO19_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO19_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO19_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO19_CTRL_FUNCSEL_SPI0_TX                = 0x1
	IO_BANK0_GPIO19_CTRL_FUNCSEL_UART0_RTS              = 0x2
	IO_BANK0_GPIO19_CTRL_FUNCSEL_I2C1_SCL               = 0x3
	IO_BANK0_GPIO19_CTRL_FUNCSEL_PWM_B_1                = 0x4
	IO_BANK0_GPIO19_CTRL_FUNCSEL_SIO_19                 = 0x5
	IO_BANK0_GPIO19_CTRL_FUNCSEL_PIO0_19                = 0x6
	IO_BANK0_GPIO19_CTRL_FUNCSEL_PIO1_19                = 0x7
	IO_BANK0_GPIO19_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO19_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO20_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO20_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO20_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO20_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO20_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO20_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO20_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO20_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO20_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO20_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO20_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO20_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO20_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO20_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO20_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO20_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO20_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO20_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO20_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO20_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO20_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO20_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO20_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO20_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO20_STATUS_OUTFROMPERI = 0x100

	// GPIO20_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO20_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO20_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO20_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO20_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO20_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO20_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO20_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO20_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO20_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO20_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO20_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO20_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO20_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO20_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO20_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO20_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO20_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO20_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO20_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO20_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO20_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO20_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO20_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO20_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO20_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO20_CTRL_FUNCSEL_Msk                = 0x1f
	IO_BANK0_GPIO20_CTRL_FUNCSEL_SPI0_RX            = 0x1
	IO_BANK0_GPIO20_CTRL_FUNCSEL_UART1_TX           = 0x2
	IO_BANK0_GPIO20_CTRL_FUNCSEL_I2C0_SDA           = 0x3
	IO_BANK0_GPIO20_CTRL_FUNCSEL_PWM_A_2            = 0x4
	IO_BANK0_GPIO20_CTRL_FUNCSEL_SIO_20             = 0x5
	IO_BANK0_GPIO20_CTRL_FUNCSEL_PIO0_20            = 0x6
	IO_BANK0_GPIO20_CTRL_FUNCSEL_PIO1_20            = 0x7
	IO_BANK0_GPIO20_CTRL_FUNCSEL_CLOCKS_GPIN_0      = 0x8
	IO_BANK0_GPIO20_CTRL_FUNCSEL_USB_MUXING_VBUS_EN = 0x9
	IO_BANK0_GPIO20_CTRL_FUNCSEL_NULL               = 0x1f

	// GPIO21_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO21_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO21_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO21_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO21_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO21_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO21_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO21_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO21_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO21_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO21_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO21_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO21_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO21_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO21_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO21_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO21_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO21_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO21_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO21_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO21_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO21_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO21_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO21_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO21_STATUS_OUTFROMPERI = 0x100

	// GPIO21_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO21_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO21_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO21_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO21_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO21_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO21_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO21_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO21_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO21_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO21_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO21_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO21_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO21_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO21_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO21_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO21_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO21_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO21_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO21_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO21_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO21_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO21_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO21_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO21_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO21_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO21_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO21_CTRL_FUNCSEL_SPI0_SS_N                  = 0x1
	IO_BANK0_GPIO21_CTRL_FUNCSEL_UART1_RX                   = 0x2
	IO_BANK0_GPIO21_CTRL_FUNCSEL_I2C0_SCL                   = 0x3
	IO_BANK0_GPIO21_CTRL_FUNCSEL_PWM_B_2                    = 0x4
	IO_BANK0_GPIO21_CTRL_FUNCSEL_SIO_21                     = 0x5
	IO_BANK0_GPIO21_CTRL_FUNCSEL_PIO0_21                    = 0x6
	IO_BANK0_GPIO21_CTRL_FUNCSEL_PIO1_21                    = 0x7
	IO_BANK0_GPIO21_CTRL_FUNCSEL_CLOCKS_GPOUT_0             = 0x8
	IO_BANK0_GPIO21_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO21_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO22_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO22_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO22_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO22_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO22_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO22_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO22_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO22_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO22_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO22_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO22_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO22_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO22_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO22_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO22_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO22_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO22_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO22_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO22_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO22_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO22_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO22_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO22_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO22_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO22_STATUS_OUTFROMPERI = 0x100

	// GPIO22_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO22_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO22_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO22_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO22_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO22_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO22_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO22_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO22_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO22_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO22_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO22_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO22_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO22_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO22_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO22_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO22_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO22_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO22_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO22_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO22_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO22_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO22_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO22_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO22_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO22_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO22_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO22_CTRL_FUNCSEL_SPI0_SCLK              = 0x1
	IO_BANK0_GPIO22_CTRL_FUNCSEL_UART1_CTS              = 0x2
	IO_BANK0_GPIO22_CTRL_FUNCSEL_I2C1_SDA               = 0x3
	IO_BANK0_GPIO22_CTRL_FUNCSEL_PWM_A_3                = 0x4
	IO_BANK0_GPIO22_CTRL_FUNCSEL_SIO_22                 = 0x5
	IO_BANK0_GPIO22_CTRL_FUNCSEL_PIO0_22                = 0x6
	IO_BANK0_GPIO22_CTRL_FUNCSEL_PIO1_22                = 0x7
	IO_BANK0_GPIO22_CTRL_FUNCSEL_CLOCKS_GPIN_1          = 0x8
	IO_BANK0_GPIO22_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO22_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO23_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO23_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO23_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO23_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO23_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO23_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO23_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO23_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO23_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO23_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO23_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO23_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO23_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO23_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO23_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO23_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO23_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO23_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO23_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO23_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO23_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO23_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO23_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO23_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO23_STATUS_OUTFROMPERI = 0x100

	// GPIO23_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO23_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO23_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO23_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO23_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO23_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO23_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO23_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO23_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO23_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO23_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO23_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO23_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO23_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO23_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO23_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO23_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO23_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO23_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO23_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO23_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO23_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO23_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO23_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO23_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO23_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO23_CTRL_FUNCSEL_Msk                = 0x1f
	IO_BANK0_GPIO23_CTRL_FUNCSEL_SPI0_TX            = 0x1
	IO_BANK0_GPIO23_CTRL_FUNCSEL_UART1_RTS          = 0x2
	IO_BANK0_GPIO23_CTRL_FUNCSEL_I2C1_SCL           = 0x3
	IO_BANK0_GPIO23_CTRL_FUNCSEL_PWM_B_3            = 0x4
	IO_BANK0_GPIO23_CTRL_FUNCSEL_SIO_23             = 0x5
	IO_BANK0_GPIO23_CTRL_FUNCSEL_PIO0_23            = 0x6
	IO_BANK0_GPIO23_CTRL_FUNCSEL_PIO1_23            = 0x7
	IO_BANK0_GPIO23_CTRL_FUNCSEL_CLOCKS_GPOUT_1     = 0x8
	IO_BANK0_GPIO23_CTRL_FUNCSEL_USB_MUXING_VBUS_EN = 0x9
	IO_BANK0_GPIO23_CTRL_FUNCSEL_NULL               = 0x1f

	// GPIO24_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO24_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO24_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO24_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO24_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO24_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO24_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO24_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO24_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO24_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO24_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO24_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO24_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO24_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO24_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO24_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO24_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO24_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO24_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO24_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO24_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO24_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO24_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO24_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO24_STATUS_OUTFROMPERI = 0x100

	// GPIO24_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO24_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO24_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO24_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO24_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO24_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO24_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO24_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO24_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO24_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO24_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO24_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO24_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO24_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO24_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO24_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO24_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO24_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO24_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO24_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO24_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO24_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO24_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO24_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO24_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO24_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO24_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO24_CTRL_FUNCSEL_SPI1_RX                    = 0x1
	IO_BANK0_GPIO24_CTRL_FUNCSEL_UART1_TX                   = 0x2
	IO_BANK0_GPIO24_CTRL_FUNCSEL_I2C0_SDA                   = 0x3
	IO_BANK0_GPIO24_CTRL_FUNCSEL_PWM_A_4                    = 0x4
	IO_BANK0_GPIO24_CTRL_FUNCSEL_SIO_24                     = 0x5
	IO_BANK0_GPIO24_CTRL_FUNCSEL_PIO0_24                    = 0x6
	IO_BANK0_GPIO24_CTRL_FUNCSEL_PIO1_24                    = 0x7
	IO_BANK0_GPIO24_CTRL_FUNCSEL_CLOCKS_GPOUT_2             = 0x8
	IO_BANK0_GPIO24_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO24_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO25_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO25_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO25_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO25_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO25_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO25_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO25_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO25_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO25_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO25_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO25_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO25_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO25_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO25_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO25_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO25_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO25_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO25_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO25_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO25_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO25_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO25_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO25_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO25_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO25_STATUS_OUTFROMPERI = 0x100

	// GPIO25_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO25_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO25_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO25_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO25_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO25_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO25_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO25_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO25_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO25_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO25_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO25_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO25_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO25_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO25_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO25_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO25_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO25_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO25_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO25_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO25_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO25_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO25_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO25_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO25_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO25_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO25_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO25_CTRL_FUNCSEL_SPI1_SS_N              = 0x1
	IO_BANK0_GPIO25_CTRL_FUNCSEL_UART1_RX               = 0x2
	IO_BANK0_GPIO25_CTRL_FUNCSEL_I2C0_SCL               = 0x3
	IO_BANK0_GPIO25_CTRL_FUNCSEL_PWM_B_4                = 0x4
	IO_BANK0_GPIO25_CTRL_FUNCSEL_SIO_25                 = 0x5
	IO_BANK0_GPIO25_CTRL_FUNCSEL_PIO0_25                = 0x6
	IO_BANK0_GPIO25_CTRL_FUNCSEL_PIO1_25                = 0x7
	IO_BANK0_GPIO25_CTRL_FUNCSEL_CLOCKS_GPOUT_3         = 0x8
	IO_BANK0_GPIO25_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO25_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO26_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO26_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO26_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO26_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO26_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO26_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO26_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO26_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO26_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO26_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO26_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO26_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO26_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO26_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO26_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO26_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO26_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO26_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO26_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO26_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO26_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO26_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO26_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO26_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO26_STATUS_OUTFROMPERI = 0x100

	// GPIO26_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO26_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO26_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO26_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO26_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO26_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO26_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO26_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO26_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO26_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO26_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO26_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO26_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO26_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO26_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO26_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO26_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO26_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO26_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO26_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO26_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO26_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO26_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO26_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO26_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO26_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO26_CTRL_FUNCSEL_Msk                = 0x1f
	IO_BANK0_GPIO26_CTRL_FUNCSEL_SPI1_SCLK          = 0x1
	IO_BANK0_GPIO26_CTRL_FUNCSEL_UART1_CTS          = 0x2
	IO_BANK0_GPIO26_CTRL_FUNCSEL_I2C1_SDA           = 0x3
	IO_BANK0_GPIO26_CTRL_FUNCSEL_PWM_A_5            = 0x4
	IO_BANK0_GPIO26_CTRL_FUNCSEL_SIO_26             = 0x5
	IO_BANK0_GPIO26_CTRL_FUNCSEL_PIO0_26            = 0x6
	IO_BANK0_GPIO26_CTRL_FUNCSEL_PIO1_26            = 0x7
	IO_BANK0_GPIO26_CTRL_FUNCSEL_USB_MUXING_VBUS_EN = 0x9
	IO_BANK0_GPIO26_CTRL_FUNCSEL_NULL               = 0x1f

	// GPIO27_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO27_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO27_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO27_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO27_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO27_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO27_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO27_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO27_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO27_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO27_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO27_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO27_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO27_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO27_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO27_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO27_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO27_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO27_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO27_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO27_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO27_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO27_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO27_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO27_STATUS_OUTFROMPERI = 0x100

	// GPIO27_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO27_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO27_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO27_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO27_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO27_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO27_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO27_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO27_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO27_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO27_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO27_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO27_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO27_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO27_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO27_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO27_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO27_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO27_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO27_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO27_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO27_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO27_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO27_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO27_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO27_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO27_CTRL_FUNCSEL_Msk                        = 0x1f
	IO_BANK0_GPIO27_CTRL_FUNCSEL_SPI1_TX                    = 0x1
	IO_BANK0_GPIO27_CTRL_FUNCSEL_UART1_RTS                  = 0x2
	IO_BANK0_GPIO27_CTRL_FUNCSEL_I2C1_SCL                   = 0x3
	IO_BANK0_GPIO27_CTRL_FUNCSEL_PWM_B_5                    = 0x4
	IO_BANK0_GPIO27_CTRL_FUNCSEL_SIO_27                     = 0x5
	IO_BANK0_GPIO27_CTRL_FUNCSEL_PIO0_27                    = 0x6
	IO_BANK0_GPIO27_CTRL_FUNCSEL_PIO1_27                    = 0x7
	IO_BANK0_GPIO27_CTRL_FUNCSEL_USB_MUXING_OVERCURR_DETECT = 0x9
	IO_BANK0_GPIO27_CTRL_FUNCSEL_NULL                       = 0x1f

	// GPIO28_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO28_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO28_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO28_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO28_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO28_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO28_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO28_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO28_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO28_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO28_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO28_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO28_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO28_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO28_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO28_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO28_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO28_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO28_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO28_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO28_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO28_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO28_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO28_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO28_STATUS_OUTFROMPERI = 0x100

	// GPIO28_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO28_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO28_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO28_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO28_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO28_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO28_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO28_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO28_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO28_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO28_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO28_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO28_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO28_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO28_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO28_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO28_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO28_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO28_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO28_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO28_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO28_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO28_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO28_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO28_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO28_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO28_CTRL_FUNCSEL_Msk                    = 0x1f
	IO_BANK0_GPIO28_CTRL_FUNCSEL_SPI1_RX                = 0x1
	IO_BANK0_GPIO28_CTRL_FUNCSEL_UART0_TX               = 0x2
	IO_BANK0_GPIO28_CTRL_FUNCSEL_I2C0_SDA               = 0x3
	IO_BANK0_GPIO28_CTRL_FUNCSEL_PWM_A_6                = 0x4
	IO_BANK0_GPIO28_CTRL_FUNCSEL_SIO_28                 = 0x5
	IO_BANK0_GPIO28_CTRL_FUNCSEL_PIO0_28                = 0x6
	IO_BANK0_GPIO28_CTRL_FUNCSEL_PIO1_28                = 0x7
	IO_BANK0_GPIO28_CTRL_FUNCSEL_USB_MUXING_VBUS_DETECT = 0x9
	IO_BANK0_GPIO28_CTRL_FUNCSEL_NULL                   = 0x1f

	// GPIO29_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_BANK0_GPIO29_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_BANK0_GPIO29_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_BANK0_GPIO29_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_BANK0_GPIO29_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_BANK0_GPIO29_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_BANK0_GPIO29_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_BANK0_GPIO29_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_BANK0_GPIO29_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_BANK0_GPIO29_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_BANK0_GPIO29_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_BANK0_GPIO29_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_BANK0_GPIO29_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_BANK0_GPIO29_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_BANK0_GPIO29_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_BANK0_GPIO29_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_BANK0_GPIO29_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_BANK0_GPIO29_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_BANK0_GPIO29_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_BANK0_GPIO29_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_BANK0_GPIO29_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_BANK0_GPIO29_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_BANK0_GPIO29_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_BANK0_GPIO29_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_BANK0_GPIO29_STATUS_OUTFROMPERI = 0x100

	// GPIO29_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_BANK0_GPIO29_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_BANK0_GPIO29_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_BANK0_GPIO29_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_BANK0_GPIO29_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_BANK0_GPIO29_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_BANK0_GPIO29_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_BANK0_GPIO29_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_BANK0_GPIO29_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_BANK0_GPIO29_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_BANK0_GPIO29_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_BANK0_GPIO29_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_BANK0_GPIO29_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_BANK0_GPIO29_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_BANK0_GPIO29_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_BANK0_GPIO29_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO29_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_BANK0_GPIO29_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_BANK0_GPIO29_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_BANK0_GPIO29_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_BANK0_GPIO29_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_BANK0_GPIO29_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_BANK0_GPIO29_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_BANK0_GPIO29_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_BANK0_GPIO29_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_BANK0_GPIO29_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_BANK0_GPIO29_CTRL_FUNCSEL_Msk                = 0x1f
	IO_BANK0_GPIO29_CTRL_FUNCSEL_SPI1_SS_N          = 0x1
	IO_BANK0_GPIO29_CTRL_FUNCSEL_UART0_RX           = 0x2
	IO_BANK0_GPIO29_CTRL_FUNCSEL_I2C0_SCL           = 0x3
	IO_BANK0_GPIO29_CTRL_FUNCSEL_PWM_B_6            = 0x4
	IO_BANK0_GPIO29_CTRL_FUNCSEL_SIO_29             = 0x5
	IO_BANK0_GPIO29_CTRL_FUNCSEL_PIO0_29            = 0x6
	IO_BANK0_GPIO29_CTRL_FUNCSEL_PIO1_29            = 0x7
	IO_BANK0_GPIO29_CTRL_FUNCSEL_USB_MUXING_VBUS_EN = 0x9
	IO_BANK0_GPIO29_CTRL_FUNCSEL_NULL               = 0x1f

	// INTR0: Raw Interrupts
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_INTR0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_INTR0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_INTR0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_INTR0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_INTR0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_INTR0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_INTR0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_INTR0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_INTR0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_INTR0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_INTR0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_INTR0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_INTR0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_INTR0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_INTR0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_INTR0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_INTR0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_INTR0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_INTR0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_INTR0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_INTR0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_INTR0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_INTR0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_INTR0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_INTR0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_INTR0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_INTR0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_INTR0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_INTR0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_INTR0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_INTR0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_INTR0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_INTR0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_INTR0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_INTR0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_INTR0_GPIO0_LEVEL_LOW = 0x1

	// INTR1: Raw Interrupts
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_INTR1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_INTR1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_INTR1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_INTR1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_INTR1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_INTR1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_INTR1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_INTR1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_INTR1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_INTR1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_INTR1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_INTR1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_INTR1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_INTR1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_INTR1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_INTR1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_INTR1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_INTR1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_INTR1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_INTR1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_INTR1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_INTR1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_INTR1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_INTR1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_INTR1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_INTR1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_INTR1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_INTR1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_INTR1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_INTR1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_INTR1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_INTR1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_INTR1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_INTR1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_INTR1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_INTR1_GPIO8_LEVEL_LOW = 0x1

	// INTR2: Raw Interrupts
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_INTR2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_INTR2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_INTR2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_INTR2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_INTR2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_INTR2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_INTR2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_INTR2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_INTR2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_INTR2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_INTR2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_INTR2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_INTR2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_INTR2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_INTR2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_INTR2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_INTR2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_INTR2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_INTR2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_INTR2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_INTR2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_INTR2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_INTR2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_INTR2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_INTR2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_INTR2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_INTR2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_INTR2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_INTR2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_INTR2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_INTR2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_INTR2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_INTR2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_INTR2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_INTR2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_INTR2_GPIO16_LEVEL_LOW = 0x1

	// INTR3: Raw Interrupts
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_INTR3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_INTR3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_INTR3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_INTR3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_INTR3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_INTR3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_INTR3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_INTR3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_INTR3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_INTR3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_INTR3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_INTR3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_INTR3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_INTR3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_INTR3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_INTR3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_INTR3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_INTR3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_INTR3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_INTR3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_INTR3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_INTR3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_INTR3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_INTR3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_INTR3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_INTR3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_INTR3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_INTR3_GPIO24_LEVEL_LOW = 0x1

	// PROC0_INTE0: Interrupt Enable for proc0
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_PROC0_INTE0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_PROC0_INTE0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_PROC0_INTE0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_PROC0_INTE0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_PROC0_INTE0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_PROC0_INTE0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_PROC0_INTE0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_PROC0_INTE0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_PROC0_INTE0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_PROC0_INTE0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_PROC0_INTE0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_PROC0_INTE0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_PROC0_INTE0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_PROC0_INTE0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_PROC0_INTE0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_PROC0_INTE0_GPIO0_LEVEL_LOW = 0x1

	// PROC0_INTE1: Interrupt Enable for proc0
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_PROC0_INTE1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_PROC0_INTE1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_PROC0_INTE1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_PROC0_INTE1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_PROC0_INTE1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_PROC0_INTE1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_PROC0_INTE1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_PROC0_INTE1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_PROC0_INTE1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_PROC0_INTE1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_PROC0_INTE1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_PROC0_INTE1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_PROC0_INTE1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_PROC0_INTE1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_PROC0_INTE1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_PROC0_INTE1_GPIO8_LEVEL_LOW = 0x1

	// PROC0_INTE2: Interrupt Enable for proc0
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_PROC0_INTE2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_PROC0_INTE2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_PROC0_INTE2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_PROC0_INTE2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_PROC0_INTE2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_PROC0_INTE2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_PROC0_INTE2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_PROC0_INTE2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_PROC0_INTE2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_PROC0_INTE2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_PROC0_INTE2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_PROC0_INTE2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_PROC0_INTE2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_PROC0_INTE2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_PROC0_INTE2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_PROC0_INTE2_GPIO16_LEVEL_LOW = 0x1

	// PROC0_INTE3: Interrupt Enable for proc0
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_PROC0_INTE3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_PROC0_INTE3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_PROC0_INTE3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_PROC0_INTE3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_PROC0_INTE3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_PROC0_INTE3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_PROC0_INTE3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_PROC0_INTE3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_PROC0_INTE3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_PROC0_INTE3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_PROC0_INTE3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTE3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_PROC0_INTE3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC0_INTE3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_PROC0_INTE3_GPIO24_LEVEL_LOW = 0x1

	// PROC0_INTF0: Interrupt Force for proc0
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_PROC0_INTF0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_PROC0_INTF0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_PROC0_INTF0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_PROC0_INTF0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_PROC0_INTF0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_PROC0_INTF0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_PROC0_INTF0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_PROC0_INTF0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_PROC0_INTF0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_PROC0_INTF0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_PROC0_INTF0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_PROC0_INTF0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_PROC0_INTF0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_PROC0_INTF0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_PROC0_INTF0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_PROC0_INTF0_GPIO0_LEVEL_LOW = 0x1

	// PROC0_INTF1: Interrupt Force for proc0
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_PROC0_INTF1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_PROC0_INTF1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_PROC0_INTF1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_PROC0_INTF1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_PROC0_INTF1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_PROC0_INTF1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_PROC0_INTF1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_PROC0_INTF1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_PROC0_INTF1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_PROC0_INTF1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_PROC0_INTF1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_PROC0_INTF1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_PROC0_INTF1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_PROC0_INTF1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_PROC0_INTF1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_PROC0_INTF1_GPIO8_LEVEL_LOW = 0x1

	// PROC0_INTF2: Interrupt Force for proc0
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_PROC0_INTF2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_PROC0_INTF2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_PROC0_INTF2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_PROC0_INTF2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_PROC0_INTF2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_PROC0_INTF2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_PROC0_INTF2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_PROC0_INTF2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_PROC0_INTF2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_PROC0_INTF2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_PROC0_INTF2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_PROC0_INTF2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_PROC0_INTF2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_PROC0_INTF2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_PROC0_INTF2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_PROC0_INTF2_GPIO16_LEVEL_LOW = 0x1

	// PROC0_INTF3: Interrupt Force for proc0
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_PROC0_INTF3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_PROC0_INTF3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_PROC0_INTF3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_PROC0_INTF3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_PROC0_INTF3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_PROC0_INTF3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_PROC0_INTF3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_PROC0_INTF3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_PROC0_INTF3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_PROC0_INTF3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_PROC0_INTF3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTF3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_PROC0_INTF3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC0_INTF3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_PROC0_INTF3_GPIO24_LEVEL_LOW = 0x1

	// PROC0_INTS0: Interrupt status after masking & forcing for proc0
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_PROC0_INTS0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_PROC0_INTS0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_PROC0_INTS0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_PROC0_INTS0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_PROC0_INTS0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_PROC0_INTS0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_PROC0_INTS0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_PROC0_INTS0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_PROC0_INTS0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_PROC0_INTS0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_PROC0_INTS0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_PROC0_INTS0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_PROC0_INTS0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_PROC0_INTS0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_PROC0_INTS0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_PROC0_INTS0_GPIO0_LEVEL_LOW = 0x1

	// PROC0_INTS1: Interrupt status after masking & forcing for proc0
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_PROC0_INTS1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_PROC0_INTS1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_PROC0_INTS1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_PROC0_INTS1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_PROC0_INTS1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_PROC0_INTS1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_PROC0_INTS1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_PROC0_INTS1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_PROC0_INTS1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_PROC0_INTS1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_PROC0_INTS1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_PROC0_INTS1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_PROC0_INTS1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_PROC0_INTS1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_PROC0_INTS1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_PROC0_INTS1_GPIO8_LEVEL_LOW = 0x1

	// PROC0_INTS2: Interrupt status after masking & forcing for proc0
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_PROC0_INTS2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_PROC0_INTS2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_PROC0_INTS2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_PROC0_INTS2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_PROC0_INTS2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_PROC0_INTS2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_PROC0_INTS2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_PROC0_INTS2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_PROC0_INTS2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_PROC0_INTS2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_PROC0_INTS2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_PROC0_INTS2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_PROC0_INTS2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_PROC0_INTS2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_PROC0_INTS2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_PROC0_INTS2_GPIO16_LEVEL_LOW = 0x1

	// PROC0_INTS3: Interrupt status after masking & forcing for proc0
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_PROC0_INTS3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_PROC0_INTS3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_PROC0_INTS3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_PROC0_INTS3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_PROC0_INTS3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_PROC0_INTS3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_PROC0_INTS3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_PROC0_INTS3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_PROC0_INTS3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_PROC0_INTS3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_PROC0_INTS3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC0_INTS3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_PROC0_INTS3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC0_INTS3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_PROC0_INTS3_GPIO24_LEVEL_LOW = 0x1

	// PROC1_INTE0: Interrupt Enable for proc1
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_PROC1_INTE0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_PROC1_INTE0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_PROC1_INTE0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_PROC1_INTE0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_PROC1_INTE0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_PROC1_INTE0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_PROC1_INTE0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_PROC1_INTE0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_PROC1_INTE0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_PROC1_INTE0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_PROC1_INTE0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_PROC1_INTE0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_PROC1_INTE0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_PROC1_INTE0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_PROC1_INTE0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_PROC1_INTE0_GPIO0_LEVEL_LOW = 0x1

	// PROC1_INTE1: Interrupt Enable for proc1
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_PROC1_INTE1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_PROC1_INTE1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_PROC1_INTE1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_PROC1_INTE1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_PROC1_INTE1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_PROC1_INTE1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_PROC1_INTE1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_PROC1_INTE1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_PROC1_INTE1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_PROC1_INTE1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_PROC1_INTE1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_PROC1_INTE1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_PROC1_INTE1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_PROC1_INTE1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_PROC1_INTE1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_PROC1_INTE1_GPIO8_LEVEL_LOW = 0x1

	// PROC1_INTE2: Interrupt Enable for proc1
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_PROC1_INTE2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_PROC1_INTE2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_PROC1_INTE2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_PROC1_INTE2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_PROC1_INTE2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_PROC1_INTE2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_PROC1_INTE2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_PROC1_INTE2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_PROC1_INTE2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_PROC1_INTE2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_PROC1_INTE2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_PROC1_INTE2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_PROC1_INTE2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_PROC1_INTE2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_PROC1_INTE2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_PROC1_INTE2_GPIO16_LEVEL_LOW = 0x1

	// PROC1_INTE3: Interrupt Enable for proc1
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_PROC1_INTE3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_PROC1_INTE3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_PROC1_INTE3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_PROC1_INTE3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_PROC1_INTE3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_PROC1_INTE3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_PROC1_INTE3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_PROC1_INTE3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_PROC1_INTE3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_PROC1_INTE3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_PROC1_INTE3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTE3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_PROC1_INTE3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC1_INTE3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_PROC1_INTE3_GPIO24_LEVEL_LOW = 0x1

	// PROC1_INTF0: Interrupt Force for proc1
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_PROC1_INTF0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_PROC1_INTF0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_PROC1_INTF0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_PROC1_INTF0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_PROC1_INTF0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_PROC1_INTF0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_PROC1_INTF0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_PROC1_INTF0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_PROC1_INTF0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_PROC1_INTF0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_PROC1_INTF0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_PROC1_INTF0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_PROC1_INTF0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_PROC1_INTF0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_PROC1_INTF0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_PROC1_INTF0_GPIO0_LEVEL_LOW = 0x1

	// PROC1_INTF1: Interrupt Force for proc1
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_PROC1_INTF1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_PROC1_INTF1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_PROC1_INTF1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_PROC1_INTF1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_PROC1_INTF1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_PROC1_INTF1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_PROC1_INTF1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_PROC1_INTF1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_PROC1_INTF1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_PROC1_INTF1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_PROC1_INTF1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_PROC1_INTF1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_PROC1_INTF1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_PROC1_INTF1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_PROC1_INTF1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_PROC1_INTF1_GPIO8_LEVEL_LOW = 0x1

	// PROC1_INTF2: Interrupt Force for proc1
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_PROC1_INTF2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_PROC1_INTF2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_PROC1_INTF2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_PROC1_INTF2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_PROC1_INTF2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_PROC1_INTF2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_PROC1_INTF2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_PROC1_INTF2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_PROC1_INTF2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_PROC1_INTF2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_PROC1_INTF2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_PROC1_INTF2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_PROC1_INTF2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_PROC1_INTF2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_PROC1_INTF2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_PROC1_INTF2_GPIO16_LEVEL_LOW = 0x1

	// PROC1_INTF3: Interrupt Force for proc1
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_PROC1_INTF3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_PROC1_INTF3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_PROC1_INTF3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_PROC1_INTF3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_PROC1_INTF3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_PROC1_INTF3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_PROC1_INTF3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_PROC1_INTF3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_PROC1_INTF3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_PROC1_INTF3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_PROC1_INTF3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTF3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_PROC1_INTF3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC1_INTF3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_PROC1_INTF3_GPIO24_LEVEL_LOW = 0x1

	// PROC1_INTS0: Interrupt status after masking & forcing for proc1
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_PROC1_INTS0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_PROC1_INTS0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_PROC1_INTS0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_PROC1_INTS0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_PROC1_INTS0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_PROC1_INTS0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_PROC1_INTS0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_PROC1_INTS0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_PROC1_INTS0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_PROC1_INTS0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_PROC1_INTS0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_PROC1_INTS0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_PROC1_INTS0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_PROC1_INTS0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_PROC1_INTS0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_PROC1_INTS0_GPIO0_LEVEL_LOW = 0x1

	// PROC1_INTS1: Interrupt status after masking & forcing for proc1
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_PROC1_INTS1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_PROC1_INTS1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_PROC1_INTS1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_PROC1_INTS1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_PROC1_INTS1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_PROC1_INTS1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_PROC1_INTS1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_PROC1_INTS1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_PROC1_INTS1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_PROC1_INTS1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_PROC1_INTS1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_PROC1_INTS1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_PROC1_INTS1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_PROC1_INTS1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_PROC1_INTS1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_PROC1_INTS1_GPIO8_LEVEL_LOW = 0x1

	// PROC1_INTS2: Interrupt status after masking & forcing for proc1
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_PROC1_INTS2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_PROC1_INTS2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_PROC1_INTS2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_PROC1_INTS2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_PROC1_INTS2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_PROC1_INTS2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_PROC1_INTS2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_PROC1_INTS2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_PROC1_INTS2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_PROC1_INTS2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_PROC1_INTS2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_PROC1_INTS2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_PROC1_INTS2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_PROC1_INTS2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_PROC1_INTS2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_PROC1_INTS2_GPIO16_LEVEL_LOW = 0x1

	// PROC1_INTS3: Interrupt status after masking & forcing for proc1
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_PROC1_INTS3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_PROC1_INTS3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_PROC1_INTS3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_PROC1_INTS3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_PROC1_INTS3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_PROC1_INTS3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_PROC1_INTS3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_PROC1_INTS3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_PROC1_INTS3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_PROC1_INTS3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_PROC1_INTS3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_PROC1_INTS3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_PROC1_INTS3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_PROC1_INTS3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_PROC1_INTS3_GPIO24_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTE0: Interrupt Enable for dormant_wake
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE0_GPIO0_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTE1: Interrupt Enable for dormant_wake
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE1_GPIO8_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTE2: Interrupt Enable for dormant_wake
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE2_GPIO16_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTE3: Interrupt Enable for dormant_wake
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTE3_GPIO24_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTF0: Interrupt Force for dormant_wake
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF0_GPIO0_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTF1: Interrupt Force for dormant_wake
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF1_GPIO8_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTF2: Interrupt Force for dormant_wake
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF2_GPIO16_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTF3: Interrupt Force for dormant_wake
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTF3_GPIO24_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTS0: Interrupt status after masking & forcing for dormant_wake
	// Position of GPIO7_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO7_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO7_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_EDGE_HIGH = 0x80000000
	// Position of GPIO7_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO7_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO7_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_EDGE_LOW = 0x40000000
	// Position of GPIO7_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO7_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO7_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_LEVEL_HIGH = 0x20000000
	// Position of GPIO7_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO7_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO7_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO7_LEVEL_LOW = 0x10000000
	// Position of GPIO6_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO6_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO6_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_EDGE_HIGH = 0x8000000
	// Position of GPIO6_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO6_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO6_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_EDGE_LOW = 0x4000000
	// Position of GPIO6_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO6_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO6_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_LEVEL_HIGH = 0x2000000
	// Position of GPIO6_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO6_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO6_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO6_LEVEL_LOW = 0x1000000
	// Position of GPIO5_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO5_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO5_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_EDGE_HIGH = 0x800000
	// Position of GPIO5_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO5_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_EDGE_LOW_Msk = 0x400000
	// Bit GPIO5_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_EDGE_LOW = 0x400000
	// Position of GPIO5_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO5_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO5_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_LEVEL_HIGH = 0x200000
	// Position of GPIO5_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO5_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO5_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO5_LEVEL_LOW = 0x100000
	// Position of GPIO4_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO4_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO4_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_EDGE_HIGH = 0x80000
	// Position of GPIO4_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO4_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_EDGE_LOW_Msk = 0x40000
	// Bit GPIO4_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_EDGE_LOW = 0x40000
	// Position of GPIO4_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO4_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO4_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_LEVEL_HIGH = 0x20000
	// Position of GPIO4_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO4_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO4_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO4_LEVEL_LOW = 0x10000
	// Position of GPIO3_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO3_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO3_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_EDGE_HIGH = 0x8000
	// Position of GPIO3_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO3_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_EDGE_LOW_Msk = 0x4000
	// Bit GPIO3_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_EDGE_LOW = 0x4000
	// Position of GPIO3_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO3_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO3_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_LEVEL_HIGH = 0x2000
	// Position of GPIO3_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO3_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO3_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO3_LEVEL_LOW = 0x1000
	// Position of GPIO2_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO2_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_EDGE_HIGH_Msk = 0x800
	// Bit GPIO2_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_EDGE_HIGH = 0x800
	// Position of GPIO2_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO2_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_EDGE_LOW_Msk = 0x400
	// Bit GPIO2_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_EDGE_LOW = 0x400
	// Position of GPIO2_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO2_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO2_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_LEVEL_HIGH = 0x200
	// Position of GPIO2_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO2_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_LEVEL_LOW_Msk = 0x100
	// Bit GPIO2_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO2_LEVEL_LOW = 0x100
	// Position of GPIO1_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO1_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_EDGE_HIGH_Msk = 0x80
	// Bit GPIO1_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_EDGE_HIGH = 0x80
	// Position of GPIO1_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO1_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_EDGE_LOW_Msk = 0x40
	// Bit GPIO1_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_EDGE_LOW = 0x40
	// Position of GPIO1_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO1_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO1_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_LEVEL_HIGH = 0x20
	// Position of GPIO1_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO1_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_LEVEL_LOW_Msk = 0x10
	// Bit GPIO1_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO1_LEVEL_LOW = 0x10
	// Position of GPIO0_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO0_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_EDGE_HIGH_Msk = 0x8
	// Bit GPIO0_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_EDGE_HIGH = 0x8
	// Position of GPIO0_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO0_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_EDGE_LOW_Msk = 0x4
	// Bit GPIO0_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_EDGE_LOW = 0x4
	// Position of GPIO0_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO0_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO0_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_LEVEL_HIGH = 0x2
	// Position of GPIO0_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO0_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_LEVEL_LOW_Msk = 0x1
	// Bit GPIO0_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS0_GPIO0_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTS1: Interrupt status after masking & forcing for dormant_wake
	// Position of GPIO15_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO15_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO15_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_EDGE_HIGH = 0x80000000
	// Position of GPIO15_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO15_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO15_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_EDGE_LOW = 0x40000000
	// Position of GPIO15_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO15_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO15_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_LEVEL_HIGH = 0x20000000
	// Position of GPIO15_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO15_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO15_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO15_LEVEL_LOW = 0x10000000
	// Position of GPIO14_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO14_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO14_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_EDGE_HIGH = 0x8000000
	// Position of GPIO14_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO14_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO14_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_EDGE_LOW = 0x4000000
	// Position of GPIO14_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO14_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO14_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_LEVEL_HIGH = 0x2000000
	// Position of GPIO14_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO14_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO14_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO14_LEVEL_LOW = 0x1000000
	// Position of GPIO13_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO13_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO13_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_EDGE_HIGH = 0x800000
	// Position of GPIO13_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO13_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_EDGE_LOW_Msk = 0x400000
	// Bit GPIO13_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_EDGE_LOW = 0x400000
	// Position of GPIO13_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO13_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO13_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_LEVEL_HIGH = 0x200000
	// Position of GPIO13_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO13_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO13_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO13_LEVEL_LOW = 0x100000
	// Position of GPIO12_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO12_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO12_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_EDGE_HIGH = 0x80000
	// Position of GPIO12_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO12_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_EDGE_LOW_Msk = 0x40000
	// Bit GPIO12_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_EDGE_LOW = 0x40000
	// Position of GPIO12_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO12_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO12_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_LEVEL_HIGH = 0x20000
	// Position of GPIO12_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO12_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO12_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO12_LEVEL_LOW = 0x10000
	// Position of GPIO11_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO11_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO11_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_EDGE_HIGH = 0x8000
	// Position of GPIO11_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO11_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_EDGE_LOW_Msk = 0x4000
	// Bit GPIO11_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_EDGE_LOW = 0x4000
	// Position of GPIO11_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO11_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO11_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_LEVEL_HIGH = 0x2000
	// Position of GPIO11_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO11_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO11_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO11_LEVEL_LOW = 0x1000
	// Position of GPIO10_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO10_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_EDGE_HIGH_Msk = 0x800
	// Bit GPIO10_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_EDGE_HIGH = 0x800
	// Position of GPIO10_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO10_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_EDGE_LOW_Msk = 0x400
	// Bit GPIO10_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_EDGE_LOW = 0x400
	// Position of GPIO10_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO10_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO10_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_LEVEL_HIGH = 0x200
	// Position of GPIO10_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO10_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_LEVEL_LOW_Msk = 0x100
	// Bit GPIO10_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO10_LEVEL_LOW = 0x100
	// Position of GPIO9_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO9_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_EDGE_HIGH_Msk = 0x80
	// Bit GPIO9_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_EDGE_HIGH = 0x80
	// Position of GPIO9_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO9_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_EDGE_LOW_Msk = 0x40
	// Bit GPIO9_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_EDGE_LOW = 0x40
	// Position of GPIO9_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO9_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO9_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_LEVEL_HIGH = 0x20
	// Position of GPIO9_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO9_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_LEVEL_LOW_Msk = 0x10
	// Bit GPIO9_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO9_LEVEL_LOW = 0x10
	// Position of GPIO8_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO8_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_EDGE_HIGH_Msk = 0x8
	// Bit GPIO8_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_EDGE_HIGH = 0x8
	// Position of GPIO8_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO8_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_EDGE_LOW_Msk = 0x4
	// Bit GPIO8_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_EDGE_LOW = 0x4
	// Position of GPIO8_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO8_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO8_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_LEVEL_HIGH = 0x2
	// Position of GPIO8_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO8_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_LEVEL_LOW_Msk = 0x1
	// Bit GPIO8_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS1_GPIO8_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTS2: Interrupt status after masking & forcing for dormant_wake
	// Position of GPIO23_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_EDGE_HIGH_Pos = 0x1f
	// Bit mask of GPIO23_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_EDGE_HIGH_Msk = 0x80000000
	// Bit GPIO23_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_EDGE_HIGH = 0x80000000
	// Position of GPIO23_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_EDGE_LOW_Pos = 0x1e
	// Bit mask of GPIO23_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_EDGE_LOW_Msk = 0x40000000
	// Bit GPIO23_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_EDGE_LOW = 0x40000000
	// Position of GPIO23_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_LEVEL_HIGH_Pos = 0x1d
	// Bit mask of GPIO23_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_LEVEL_HIGH_Msk = 0x20000000
	// Bit GPIO23_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_LEVEL_HIGH = 0x20000000
	// Position of GPIO23_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_LEVEL_LOW_Pos = 0x1c
	// Bit mask of GPIO23_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_LEVEL_LOW_Msk = 0x10000000
	// Bit GPIO23_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO23_LEVEL_LOW = 0x10000000
	// Position of GPIO22_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_EDGE_HIGH_Pos = 0x1b
	// Bit mask of GPIO22_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_EDGE_HIGH_Msk = 0x8000000
	// Bit GPIO22_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_EDGE_HIGH = 0x8000000
	// Position of GPIO22_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_EDGE_LOW_Pos = 0x1a
	// Bit mask of GPIO22_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_EDGE_LOW_Msk = 0x4000000
	// Bit GPIO22_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_EDGE_LOW = 0x4000000
	// Position of GPIO22_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_LEVEL_HIGH_Pos = 0x19
	// Bit mask of GPIO22_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_LEVEL_HIGH_Msk = 0x2000000
	// Bit GPIO22_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_LEVEL_HIGH = 0x2000000
	// Position of GPIO22_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_LEVEL_LOW_Pos = 0x18
	// Bit mask of GPIO22_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_LEVEL_LOW_Msk = 0x1000000
	// Bit GPIO22_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO22_LEVEL_LOW = 0x1000000
	// Position of GPIO21_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO21_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO21_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_EDGE_HIGH = 0x800000
	// Position of GPIO21_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO21_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_EDGE_LOW_Msk = 0x400000
	// Bit GPIO21_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_EDGE_LOW = 0x400000
	// Position of GPIO21_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO21_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO21_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_LEVEL_HIGH = 0x200000
	// Position of GPIO21_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO21_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO21_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO21_LEVEL_LOW = 0x100000
	// Position of GPIO20_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO20_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO20_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_EDGE_HIGH = 0x80000
	// Position of GPIO20_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO20_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_EDGE_LOW_Msk = 0x40000
	// Bit GPIO20_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_EDGE_LOW = 0x40000
	// Position of GPIO20_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO20_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO20_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_LEVEL_HIGH = 0x20000
	// Position of GPIO20_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO20_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO20_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO20_LEVEL_LOW = 0x10000
	// Position of GPIO19_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO19_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO19_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_EDGE_HIGH = 0x8000
	// Position of GPIO19_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO19_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_EDGE_LOW_Msk = 0x4000
	// Bit GPIO19_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_EDGE_LOW = 0x4000
	// Position of GPIO19_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO19_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO19_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_LEVEL_HIGH = 0x2000
	// Position of GPIO19_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO19_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO19_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO19_LEVEL_LOW = 0x1000
	// Position of GPIO18_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO18_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_EDGE_HIGH_Msk = 0x800
	// Bit GPIO18_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_EDGE_HIGH = 0x800
	// Position of GPIO18_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO18_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_EDGE_LOW_Msk = 0x400
	// Bit GPIO18_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_EDGE_LOW = 0x400
	// Position of GPIO18_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO18_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO18_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_LEVEL_HIGH = 0x200
	// Position of GPIO18_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO18_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_LEVEL_LOW_Msk = 0x100
	// Bit GPIO18_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO18_LEVEL_LOW = 0x100
	// Position of GPIO17_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO17_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_EDGE_HIGH_Msk = 0x80
	// Bit GPIO17_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_EDGE_HIGH = 0x80
	// Position of GPIO17_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO17_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_EDGE_LOW_Msk = 0x40
	// Bit GPIO17_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_EDGE_LOW = 0x40
	// Position of GPIO17_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO17_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO17_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_LEVEL_HIGH = 0x20
	// Position of GPIO17_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO17_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_LEVEL_LOW_Msk = 0x10
	// Bit GPIO17_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO17_LEVEL_LOW = 0x10
	// Position of GPIO16_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO16_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_EDGE_HIGH_Msk = 0x8
	// Bit GPIO16_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_EDGE_HIGH = 0x8
	// Position of GPIO16_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO16_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_EDGE_LOW_Msk = 0x4
	// Bit GPIO16_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_EDGE_LOW = 0x4
	// Position of GPIO16_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO16_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO16_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_LEVEL_HIGH = 0x2
	// Position of GPIO16_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO16_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_LEVEL_LOW_Msk = 0x1
	// Bit GPIO16_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS2_GPIO16_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTS3: Interrupt status after masking & forcing for dormant_wake
	// Position of GPIO29_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO29_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO29_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_EDGE_HIGH = 0x800000
	// Position of GPIO29_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO29_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_EDGE_LOW_Msk = 0x400000
	// Bit GPIO29_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_EDGE_LOW = 0x400000
	// Position of GPIO29_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO29_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO29_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_LEVEL_HIGH = 0x200000
	// Position of GPIO29_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO29_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO29_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO29_LEVEL_LOW = 0x100000
	// Position of GPIO28_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO28_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO28_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_EDGE_HIGH = 0x80000
	// Position of GPIO28_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO28_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_EDGE_LOW_Msk = 0x40000
	// Bit GPIO28_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_EDGE_LOW = 0x40000
	// Position of GPIO28_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO28_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO28_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_LEVEL_HIGH = 0x20000
	// Position of GPIO28_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO28_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO28_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO28_LEVEL_LOW = 0x10000
	// Position of GPIO27_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO27_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO27_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_EDGE_HIGH = 0x8000
	// Position of GPIO27_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO27_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_EDGE_LOW_Msk = 0x4000
	// Bit GPIO27_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_EDGE_LOW = 0x4000
	// Position of GPIO27_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO27_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO27_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_LEVEL_HIGH = 0x2000
	// Position of GPIO27_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO27_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO27_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO27_LEVEL_LOW = 0x1000
	// Position of GPIO26_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO26_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_EDGE_HIGH_Msk = 0x800
	// Bit GPIO26_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_EDGE_HIGH = 0x800
	// Position of GPIO26_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO26_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_EDGE_LOW_Msk = 0x400
	// Bit GPIO26_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_EDGE_LOW = 0x400
	// Position of GPIO26_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO26_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO26_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_LEVEL_HIGH = 0x200
	// Position of GPIO26_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO26_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_LEVEL_LOW_Msk = 0x100
	// Bit GPIO26_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO26_LEVEL_LOW = 0x100
	// Position of GPIO25_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO25_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_EDGE_HIGH_Msk = 0x80
	// Bit GPIO25_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_EDGE_HIGH = 0x80
	// Position of GPIO25_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO25_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_EDGE_LOW_Msk = 0x40
	// Bit GPIO25_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_EDGE_LOW = 0x40
	// Position of GPIO25_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO25_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO25_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_LEVEL_HIGH = 0x20
	// Position of GPIO25_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO25_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_LEVEL_LOW_Msk = 0x10
	// Bit GPIO25_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO25_LEVEL_LOW = 0x10
	// Position of GPIO24_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO24_EDGE_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_EDGE_HIGH_Msk = 0x8
	// Bit GPIO24_EDGE_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_EDGE_HIGH = 0x8
	// Position of GPIO24_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO24_EDGE_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_EDGE_LOW_Msk = 0x4
	// Bit GPIO24_EDGE_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_EDGE_LOW = 0x4
	// Position of GPIO24_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO24_LEVEL_HIGH field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO24_LEVEL_HIGH.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_LEVEL_HIGH = 0x2
	// Position of GPIO24_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO24_LEVEL_LOW field.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_LEVEL_LOW_Msk = 0x1
	// Bit GPIO24_LEVEL_LOW.
	IO_BANK0_DORMANT_WAKE_INTS3_GPIO24_LEVEL_LOW = 0x1
)

// Bitfields for IO_QSPI
const (
	// GPIO_QSPI_SCLK_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_QSPI_GPIO_QSPI_SCLK_STATUS_OUTFROMPERI = 0x100

	// GPIO_QSPI_SCLK_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_FUNCSEL_Msk      = 0x1f
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_FUNCSEL_XIP_SCLK = 0x0
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_FUNCSEL_SIO_30   = 0x5
	IO_QSPI_GPIO_QSPI_SCLK_CTRL_FUNCSEL_NULL     = 0x1f

	// GPIO_QSPI_SS_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_QSPI_GPIO_QSPI_SS_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_QSPI_GPIO_QSPI_SS_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_QSPI_GPIO_QSPI_SS_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_QSPI_GPIO_QSPI_SS_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_QSPI_GPIO_QSPI_SS_STATUS_OUTFROMPERI = 0x100

	// GPIO_QSPI_SS_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_QSPI_GPIO_QSPI_SS_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_QSPI_GPIO_QSPI_SS_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_QSPI_GPIO_QSPI_SS_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_QSPI_GPIO_QSPI_SS_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_QSPI_GPIO_QSPI_SS_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_QSPI_GPIO_QSPI_SS_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_QSPI_GPIO_QSPI_SS_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_QSPI_GPIO_QSPI_SS_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SS_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SS_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_QSPI_GPIO_QSPI_SS_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_QSPI_GPIO_QSPI_SS_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SS_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SS_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_QSPI_GPIO_QSPI_SS_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_QSPI_GPIO_QSPI_SS_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SS_CTRL_FUNCSEL_Msk      = 0x1f
	IO_QSPI_GPIO_QSPI_SS_CTRL_FUNCSEL_XIP_SS_N = 0x0
	IO_QSPI_GPIO_QSPI_SS_CTRL_FUNCSEL_SIO_31   = 0x5
	IO_QSPI_GPIO_QSPI_SS_CTRL_FUNCSEL_NULL     = 0x1f

	// GPIO_QSPI_SD0_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_QSPI_GPIO_QSPI_SD0_STATUS_OUTFROMPERI = 0x100

	// GPIO_QSPI_SD0_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_QSPI_GPIO_QSPI_SD0_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_QSPI_GPIO_QSPI_SD0_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_QSPI_GPIO_QSPI_SD0_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_QSPI_GPIO_QSPI_SD0_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_QSPI_GPIO_QSPI_SD0_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_QSPI_GPIO_QSPI_SD0_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_QSPI_GPIO_QSPI_SD0_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_QSPI_GPIO_QSPI_SD0_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_QSPI_GPIO_QSPI_SD0_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SD0_CTRL_FUNCSEL_Msk     = 0x1f
	IO_QSPI_GPIO_QSPI_SD0_CTRL_FUNCSEL_XIP_SD0 = 0x0
	IO_QSPI_GPIO_QSPI_SD0_CTRL_FUNCSEL_SIO_32  = 0x5
	IO_QSPI_GPIO_QSPI_SD0_CTRL_FUNCSEL_NULL    = 0x1f

	// GPIO_QSPI_SD1_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_QSPI_GPIO_QSPI_SD1_STATUS_OUTFROMPERI = 0x100

	// GPIO_QSPI_SD1_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_QSPI_GPIO_QSPI_SD1_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_QSPI_GPIO_QSPI_SD1_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_QSPI_GPIO_QSPI_SD1_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_QSPI_GPIO_QSPI_SD1_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_QSPI_GPIO_QSPI_SD1_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_QSPI_GPIO_QSPI_SD1_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_QSPI_GPIO_QSPI_SD1_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_QSPI_GPIO_QSPI_SD1_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_QSPI_GPIO_QSPI_SD1_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SD1_CTRL_FUNCSEL_Msk     = 0x1f
	IO_QSPI_GPIO_QSPI_SD1_CTRL_FUNCSEL_XIP_SD1 = 0x0
	IO_QSPI_GPIO_QSPI_SD1_CTRL_FUNCSEL_SIO_33  = 0x5
	IO_QSPI_GPIO_QSPI_SD1_CTRL_FUNCSEL_NULL    = 0x1f

	// GPIO_QSPI_SD2_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_QSPI_GPIO_QSPI_SD2_STATUS_OUTFROMPERI = 0x100

	// GPIO_QSPI_SD2_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_QSPI_GPIO_QSPI_SD2_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_QSPI_GPIO_QSPI_SD2_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_QSPI_GPIO_QSPI_SD2_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_QSPI_GPIO_QSPI_SD2_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_QSPI_GPIO_QSPI_SD2_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_QSPI_GPIO_QSPI_SD2_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_QSPI_GPIO_QSPI_SD2_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_QSPI_GPIO_QSPI_SD2_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_QSPI_GPIO_QSPI_SD2_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SD2_CTRL_FUNCSEL_Msk     = 0x1f
	IO_QSPI_GPIO_QSPI_SD2_CTRL_FUNCSEL_XIP_SD2 = 0x0
	IO_QSPI_GPIO_QSPI_SD2_CTRL_FUNCSEL_SIO_34  = 0x5
	IO_QSPI_GPIO_QSPI_SD2_CTRL_FUNCSEL_NULL    = 0x1f

	// GPIO_QSPI_SD3_STATUS: GPIO status
	// Position of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_IRQTOPROC_Pos = 0x1a
	// Bit mask of IRQTOPROC field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_IRQTOPROC_Msk = 0x4000000
	// Bit IRQTOPROC.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_IRQTOPROC = 0x4000000
	// Position of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_IRQFROMPAD_Pos = 0x18
	// Bit mask of IRQFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_IRQFROMPAD_Msk = 0x1000000
	// Bit IRQFROMPAD.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_IRQFROMPAD = 0x1000000
	// Position of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_INTOPERI_Pos = 0x13
	// Bit mask of INTOPERI field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_INTOPERI_Msk = 0x80000
	// Bit INTOPERI.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_INTOPERI = 0x80000
	// Position of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_INFROMPAD_Pos = 0x11
	// Bit mask of INFROMPAD field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_INFROMPAD_Msk = 0x20000
	// Bit INFROMPAD.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_INFROMPAD = 0x20000
	// Position of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OETOPAD_Pos = 0xd
	// Bit mask of OETOPAD field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OETOPAD_Msk = 0x2000
	// Bit OETOPAD.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OETOPAD = 0x2000
	// Position of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OEFROMPERI_Pos = 0xc
	// Bit mask of OEFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OEFROMPERI_Msk = 0x1000
	// Bit OEFROMPERI.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OEFROMPERI = 0x1000
	// Position of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OUTTOPAD_Pos = 0x9
	// Bit mask of OUTTOPAD field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OUTTOPAD_Msk = 0x200
	// Bit OUTTOPAD.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OUTTOPAD = 0x200
	// Position of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OUTFROMPERI_Pos = 0x8
	// Bit mask of OUTFROMPERI field.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OUTFROMPERI_Msk = 0x100
	// Bit OUTFROMPERI.
	IO_QSPI_GPIO_QSPI_SD3_STATUS_OUTFROMPERI = 0x100

	// GPIO_QSPI_SD3_CTRL: GPIO control including function select and overrides.
	// Position of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_IRQOVER_Pos = 0x1c
	// Bit mask of IRQOVER field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_IRQOVER_Msk = 0x30000000
	// don't invert the interrupt
	IO_QSPI_GPIO_QSPI_SD3_CTRL_IRQOVER_NORMAL = 0x0
	// invert the interrupt
	IO_QSPI_GPIO_QSPI_SD3_CTRL_IRQOVER_INVERT = 0x1
	// drive interrupt low
	IO_QSPI_GPIO_QSPI_SD3_CTRL_IRQOVER_LOW = 0x2
	// drive interrupt high
	IO_QSPI_GPIO_QSPI_SD3_CTRL_IRQOVER_HIGH = 0x3
	// Position of INOVER field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_INOVER_Pos = 0x10
	// Bit mask of INOVER field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_INOVER_Msk = 0x30000
	// don't invert the peri input
	IO_QSPI_GPIO_QSPI_SD3_CTRL_INOVER_NORMAL = 0x0
	// invert the peri input
	IO_QSPI_GPIO_QSPI_SD3_CTRL_INOVER_INVERT = 0x1
	// drive peri input low
	IO_QSPI_GPIO_QSPI_SD3_CTRL_INOVER_LOW = 0x2
	// drive peri input high
	IO_QSPI_GPIO_QSPI_SD3_CTRL_INOVER_HIGH = 0x3
	// Position of OEOVER field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OEOVER_Pos = 0xc
	// Bit mask of OEOVER field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OEOVER_Msk = 0x3000
	// drive output enable from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OEOVER_NORMAL = 0x0
	// drive output enable from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OEOVER_INVERT = 0x1
	// disable output
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OEOVER_DISABLE = 0x2
	// enable output
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OEOVER_ENABLE = 0x3
	// Position of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OUTOVER_Pos = 0x8
	// Bit mask of OUTOVER field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OUTOVER_Msk = 0x300
	// drive output from peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OUTOVER_NORMAL = 0x0
	// drive output from inverse of peripheral signal selected by funcsel
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OUTOVER_INVERT = 0x1
	// drive output low
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OUTOVER_LOW = 0x2
	// drive output high
	IO_QSPI_GPIO_QSPI_SD3_CTRL_OUTOVER_HIGH = 0x3
	// Position of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_FUNCSEL_Pos = 0x0
	// Bit mask of FUNCSEL field.
	IO_QSPI_GPIO_QSPI_SD3_CTRL_FUNCSEL_Msk     = 0x1f
	IO_QSPI_GPIO_QSPI_SD3_CTRL_FUNCSEL_XIP_SD3 = 0x0
	IO_QSPI_GPIO_QSPI_SD3_CTRL_FUNCSEL_SIO_35  = 0x5
	IO_QSPI_GPIO_QSPI_SD3_CTRL_FUNCSEL_NULL    = 0x1f

	// INTR: Raw Interrupts
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_INTR_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1

	// PROC0_INTE: Interrupt Enable for proc0
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_PROC0_INTE_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1

	// PROC0_INTF: Interrupt Force for proc0
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_PROC0_INTF_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1

	// PROC0_INTS: Interrupt status after masking & forcing for proc0
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_PROC0_INTS_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1

	// PROC1_INTE: Interrupt Enable for proc1
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_PROC1_INTE_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1

	// PROC1_INTF: Interrupt Force for proc1
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_PROC1_INTF_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1

	// PROC1_INTS: Interrupt status after masking & forcing for proc1
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_PROC1_INTS_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTE: Interrupt Enable for dormant_wake
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTF: Interrupt Force for dormant_wake
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1

	// DORMANT_WAKE_INTS: Interrupt status after masking & forcing for dormant_wake
	// Position of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_HIGH_Pos = 0x17
	// Bit mask of GPIO_QSPI_SD3_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_HIGH_Msk = 0x800000
	// Bit GPIO_QSPI_SD3_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_HIGH = 0x800000
	// Position of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_LOW_Pos = 0x16
	// Bit mask of GPIO_QSPI_SD3_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_LOW_Msk = 0x400000
	// Bit GPIO_QSPI_SD3_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_LOW = 0x400000
	// Position of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_HIGH_Pos = 0x15
	// Bit mask of GPIO_QSPI_SD3_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_HIGH_Msk = 0x200000
	// Bit GPIO_QSPI_SD3_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_HIGH = 0x200000
	// Position of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_LOW_Pos = 0x14
	// Bit mask of GPIO_QSPI_SD3_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_LOW_Msk = 0x100000
	// Bit GPIO_QSPI_SD3_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_LOW = 0x100000
	// Position of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_HIGH_Pos = 0x13
	// Bit mask of GPIO_QSPI_SD2_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_HIGH_Msk = 0x80000
	// Bit GPIO_QSPI_SD2_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_HIGH = 0x80000
	// Position of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_LOW_Pos = 0x12
	// Bit mask of GPIO_QSPI_SD2_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_LOW_Msk = 0x40000
	// Bit GPIO_QSPI_SD2_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_LOW = 0x40000
	// Position of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_HIGH_Pos = 0x11
	// Bit mask of GPIO_QSPI_SD2_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_HIGH_Msk = 0x20000
	// Bit GPIO_QSPI_SD2_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_HIGH = 0x20000
	// Position of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_LOW_Pos = 0x10
	// Bit mask of GPIO_QSPI_SD2_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_LOW_Msk = 0x10000
	// Bit GPIO_QSPI_SD2_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_LOW = 0x10000
	// Position of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_HIGH_Pos = 0xf
	// Bit mask of GPIO_QSPI_SD1_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_HIGH_Msk = 0x8000
	// Bit GPIO_QSPI_SD1_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_HIGH = 0x8000
	// Position of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_LOW_Pos = 0xe
	// Bit mask of GPIO_QSPI_SD1_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_LOW_Msk = 0x4000
	// Bit GPIO_QSPI_SD1_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_LOW = 0x4000
	// Position of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_HIGH_Pos = 0xd
	// Bit mask of GPIO_QSPI_SD1_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_HIGH_Msk = 0x2000
	// Bit GPIO_QSPI_SD1_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_HIGH = 0x2000
	// Position of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_LOW_Pos = 0xc
	// Bit mask of GPIO_QSPI_SD1_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_LOW_Msk = 0x1000
	// Bit GPIO_QSPI_SD1_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_LOW = 0x1000
	// Position of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_HIGH_Pos = 0xb
	// Bit mask of GPIO_QSPI_SD0_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_HIGH_Msk = 0x800
	// Bit GPIO_QSPI_SD0_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_HIGH = 0x800
	// Position of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_LOW_Pos = 0xa
	// Bit mask of GPIO_QSPI_SD0_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_LOW_Msk = 0x400
	// Bit GPIO_QSPI_SD0_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_LOW = 0x400
	// Position of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_HIGH_Pos = 0x9
	// Bit mask of GPIO_QSPI_SD0_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_HIGH_Msk = 0x200
	// Bit GPIO_QSPI_SD0_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_HIGH = 0x200
	// Position of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_LOW_Pos = 0x8
	// Bit mask of GPIO_QSPI_SD0_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_LOW_Msk = 0x100
	// Bit GPIO_QSPI_SD0_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_LOW = 0x100
	// Position of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_HIGH_Pos = 0x7
	// Bit mask of GPIO_QSPI_SS_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_HIGH_Msk = 0x80
	// Bit GPIO_QSPI_SS_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_HIGH = 0x80
	// Position of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_LOW_Pos = 0x6
	// Bit mask of GPIO_QSPI_SS_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_LOW_Msk = 0x40
	// Bit GPIO_QSPI_SS_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_LOW = 0x40
	// Position of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_HIGH_Pos = 0x5
	// Bit mask of GPIO_QSPI_SS_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_HIGH_Msk = 0x20
	// Bit GPIO_QSPI_SS_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_HIGH = 0x20
	// Position of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_LOW_Pos = 0x4
	// Bit mask of GPIO_QSPI_SS_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_LOW_Msk = 0x10
	// Bit GPIO_QSPI_SS_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_LOW = 0x10
	// Position of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_HIGH_Pos = 0x3
	// Bit mask of GPIO_QSPI_SCLK_EDGE_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_HIGH_Msk = 0x8
	// Bit GPIO_QSPI_SCLK_EDGE_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_HIGH = 0x8
	// Position of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_LOW_Pos = 0x2
	// Bit mask of GPIO_QSPI_SCLK_EDGE_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_LOW_Msk = 0x4
	// Bit GPIO_QSPI_SCLK_EDGE_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_LOW = 0x4
	// Position of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH_Pos = 0x1
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_HIGH field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH_Msk = 0x2
	// Bit GPIO_QSPI_SCLK_LEVEL_HIGH.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH = 0x2
	// Position of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_LOW_Pos = 0x0
	// Bit mask of GPIO_QSPI_SCLK_LEVEL_LOW field.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_LOW_Msk = 0x1
	// Bit GPIO_QSPI_SCLK_LEVEL_LOW.
	IO_QSPI_DORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_LOW = 0x1
)

// Bitfields for PADS_BANK0
const (
	// VOLTAGE_SELECT: Voltage select. Per bank control
	// Position of VOLTAGE_SELECT field.
	PADS_BANK0_VOLTAGE_SELECT_VOLTAGE_SELECT_Pos = 0x0
	// Bit mask of VOLTAGE_SELECT field.
	PADS_BANK0_VOLTAGE_SELECT_VOLTAGE_SELECT_Msk = 0x1
	// Bit VOLTAGE_SELECT.
	PADS_BANK0_VOLTAGE_SELECT_VOLTAGE_SELECT = 0x1
	// Set voltage to 3.3V (DVDD >= 2V5)
	PADS_BANK0_VOLTAGE_SELECT_VOLTAGE_SELECT_3v3 = 0x0
	// Set voltage to 1.8V (DVDD <= 1V8)
	PADS_BANK0_VOLTAGE_SELECT_VOLTAGE_SELECT_1v8 = 0x1

	// GPIO0: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO0_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO0_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO0_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO0_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO0_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO0_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO0_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO0_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO0_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO0_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO0_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO0_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO0_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO0_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO0_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO0_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO0_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO0_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO0_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO0_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO0_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO0_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO0_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO0_SLEWFAST = 0x1

	// GPIO1: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO1_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO1_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO1_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO1_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO1_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO1_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO1_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO1_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO1_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO1_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO1_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO1_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO1_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO1_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO1_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO1_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO1_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO1_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO1_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO1_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO1_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO1_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO1_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO1_SLEWFAST = 0x1

	// GPIO2: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO2_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO2_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO2_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO2_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO2_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO2_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO2_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO2_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO2_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO2_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO2_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO2_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO2_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO2_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO2_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO2_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO2_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO2_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO2_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO2_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO2_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO2_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO2_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO2_SLEWFAST = 0x1

	// GPIO3: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO3_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO3_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO3_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO3_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO3_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO3_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO3_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO3_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO3_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO3_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO3_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO3_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO3_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO3_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO3_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO3_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO3_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO3_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO3_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO3_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO3_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO3_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO3_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO3_SLEWFAST = 0x1

	// GPIO4: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO4_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO4_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO4_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO4_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO4_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO4_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO4_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO4_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO4_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO4_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO4_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO4_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO4_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO4_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO4_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO4_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO4_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO4_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO4_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO4_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO4_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO4_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO4_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO4_SLEWFAST = 0x1

	// GPIO5: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO5_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO5_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO5_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO5_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO5_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO5_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO5_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO5_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO5_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO5_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO5_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO5_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO5_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO5_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO5_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO5_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO5_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO5_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO5_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO5_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO5_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO5_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO5_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO5_SLEWFAST = 0x1

	// GPIO6: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO6_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO6_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO6_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO6_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO6_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO6_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO6_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO6_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO6_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO6_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO6_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO6_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO6_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO6_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO6_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO6_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO6_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO6_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO6_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO6_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO6_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO6_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO6_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO6_SLEWFAST = 0x1

	// GPIO7: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO7_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO7_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO7_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO7_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO7_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO7_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO7_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO7_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO7_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO7_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO7_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO7_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO7_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO7_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO7_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO7_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO7_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO7_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO7_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO7_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO7_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO7_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO7_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO7_SLEWFAST = 0x1

	// GPIO8: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO8_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO8_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO8_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO8_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO8_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO8_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO8_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO8_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO8_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO8_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO8_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO8_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO8_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO8_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO8_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO8_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO8_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO8_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO8_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO8_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO8_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO8_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO8_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO8_SLEWFAST = 0x1

	// GPIO9: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO9_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO9_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO9_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO9_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO9_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO9_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO9_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO9_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO9_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO9_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO9_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO9_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO9_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO9_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO9_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO9_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO9_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO9_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO9_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO9_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO9_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO9_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO9_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO9_SLEWFAST = 0x1

	// GPIO10: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO10_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO10_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO10_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO10_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO10_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO10_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO10_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO10_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO10_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO10_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO10_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO10_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO10_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO10_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO10_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO10_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO10_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO10_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO10_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO10_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO10_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO10_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO10_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO10_SLEWFAST = 0x1

	// GPIO11: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO11_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO11_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO11_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO11_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO11_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO11_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO11_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO11_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO11_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO11_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO11_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO11_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO11_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO11_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO11_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO11_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO11_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO11_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO11_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO11_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO11_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO11_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO11_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO11_SLEWFAST = 0x1

	// GPIO12: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO12_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO12_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO12_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO12_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO12_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO12_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO12_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO12_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO12_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO12_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO12_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO12_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO12_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO12_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO12_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO12_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO12_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO12_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO12_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO12_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO12_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO12_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO12_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO12_SLEWFAST = 0x1

	// GPIO13: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO13_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO13_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO13_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO13_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO13_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO13_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO13_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO13_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO13_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO13_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO13_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO13_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO13_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO13_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO13_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO13_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO13_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO13_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO13_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO13_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO13_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO13_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO13_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO13_SLEWFAST = 0x1

	// GPIO14: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO14_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO14_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO14_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO14_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO14_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO14_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO14_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO14_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO14_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO14_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO14_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO14_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO14_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO14_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO14_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO14_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO14_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO14_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO14_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO14_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO14_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO14_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO14_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO14_SLEWFAST = 0x1

	// GPIO15: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO15_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO15_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO15_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO15_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO15_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO15_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO15_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO15_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO15_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO15_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO15_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO15_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO15_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO15_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO15_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO15_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO15_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO15_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO15_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO15_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO15_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO15_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO15_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO15_SLEWFAST = 0x1

	// GPIO16: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO16_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO16_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO16_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO16_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO16_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO16_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO16_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO16_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO16_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO16_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO16_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO16_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO16_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO16_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO16_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO16_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO16_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO16_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO16_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO16_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO16_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO16_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO16_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO16_SLEWFAST = 0x1

	// GPIO17: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO17_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO17_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO17_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO17_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO17_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO17_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO17_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO17_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO17_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO17_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO17_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO17_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO17_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO17_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO17_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO17_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO17_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO17_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO17_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO17_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO17_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO17_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO17_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO17_SLEWFAST = 0x1

	// GPIO18: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO18_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO18_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO18_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO18_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO18_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO18_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO18_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO18_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO18_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO18_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO18_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO18_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO18_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO18_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO18_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO18_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO18_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO18_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO18_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO18_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO18_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO18_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO18_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO18_SLEWFAST = 0x1

	// GPIO19: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO19_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO19_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO19_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO19_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO19_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO19_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO19_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO19_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO19_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO19_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO19_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO19_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO19_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO19_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO19_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO19_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO19_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO19_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO19_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO19_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO19_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO19_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO19_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO19_SLEWFAST = 0x1

	// GPIO20: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO20_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO20_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO20_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO20_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO20_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO20_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO20_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO20_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO20_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO20_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO20_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO20_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO20_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO20_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO20_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO20_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO20_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO20_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO20_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO20_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO20_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO20_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO20_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO20_SLEWFAST = 0x1

	// GPIO21: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO21_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO21_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO21_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO21_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO21_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO21_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO21_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO21_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO21_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO21_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO21_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO21_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO21_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO21_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO21_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO21_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO21_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO21_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO21_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO21_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO21_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO21_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO21_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO21_SLEWFAST = 0x1

	// GPIO22: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO22_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO22_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO22_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO22_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO22_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO22_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO22_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO22_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO22_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO22_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO22_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO22_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO22_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO22_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO22_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO22_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO22_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO22_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO22_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO22_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO22_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO22_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO22_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO22_SLEWFAST = 0x1

	// GPIO23: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO23_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO23_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO23_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO23_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO23_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO23_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO23_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO23_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO23_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO23_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO23_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO23_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO23_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO23_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO23_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO23_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO23_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO23_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO23_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO23_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO23_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO23_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO23_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO23_SLEWFAST = 0x1

	// GPIO24: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO24_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO24_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO24_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO24_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO24_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO24_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO24_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO24_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO24_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO24_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO24_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO24_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO24_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO24_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO24_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO24_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO24_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO24_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO24_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO24_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO24_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO24_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO24_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO24_SLEWFAST = 0x1

	// GPIO25: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO25_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO25_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO25_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO25_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO25_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO25_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO25_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO25_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO25_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO25_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO25_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO25_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO25_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO25_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO25_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO25_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO25_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO25_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO25_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO25_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO25_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO25_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO25_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO25_SLEWFAST = 0x1

	// GPIO26: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO26_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO26_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO26_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO26_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO26_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO26_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO26_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO26_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO26_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO26_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO26_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO26_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO26_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO26_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO26_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO26_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO26_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO26_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO26_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO26_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO26_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO26_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO26_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO26_SLEWFAST = 0x1

	// GPIO27: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO27_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO27_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO27_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO27_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO27_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO27_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO27_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO27_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO27_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO27_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO27_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO27_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO27_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO27_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO27_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO27_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO27_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO27_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO27_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO27_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO27_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO27_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO27_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO27_SLEWFAST = 0x1

	// GPIO28: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO28_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO28_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO28_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO28_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO28_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO28_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO28_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO28_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO28_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO28_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO28_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO28_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO28_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO28_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO28_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO28_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO28_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO28_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO28_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO28_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO28_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO28_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO28_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO28_SLEWFAST = 0x1

	// GPIO29: Pad control register
	// Position of OD field.
	PADS_BANK0_GPIO29_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_GPIO29_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_GPIO29_OD = 0x80
	// Position of IE field.
	PADS_BANK0_GPIO29_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_GPIO29_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_GPIO29_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_GPIO29_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_GPIO29_DRIVE_Msk  = 0x30
	PADS_BANK0_GPIO29_DRIVE_2mA  = 0x0
	PADS_BANK0_GPIO29_DRIVE_4mA  = 0x1
	PADS_BANK0_GPIO29_DRIVE_8mA  = 0x2
	PADS_BANK0_GPIO29_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_GPIO29_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_GPIO29_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_GPIO29_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_GPIO29_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_GPIO29_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_GPIO29_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_GPIO29_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_GPIO29_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_GPIO29_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_GPIO29_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_GPIO29_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_GPIO29_SLEWFAST = 0x1

	// SWCLK: Pad control register
	// Position of OD field.
	PADS_BANK0_SWCLK_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_SWCLK_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_SWCLK_OD = 0x80
	// Position of IE field.
	PADS_BANK0_SWCLK_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_SWCLK_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_SWCLK_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_SWCLK_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_SWCLK_DRIVE_Msk  = 0x30
	PADS_BANK0_SWCLK_DRIVE_2mA  = 0x0
	PADS_BANK0_SWCLK_DRIVE_4mA  = 0x1
	PADS_BANK0_SWCLK_DRIVE_8mA  = 0x2
	PADS_BANK0_SWCLK_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_SWCLK_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_SWCLK_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_SWCLK_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_SWCLK_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_SWCLK_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_SWCLK_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_SWCLK_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_SWCLK_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_SWCLK_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_SWCLK_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_SWCLK_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_SWCLK_SLEWFAST = 0x1

	// SWD: Pad control register
	// Position of OD field.
	PADS_BANK0_SWD_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_BANK0_SWD_OD_Msk = 0x80
	// Bit OD.
	PADS_BANK0_SWD_OD = 0x80
	// Position of IE field.
	PADS_BANK0_SWD_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_BANK0_SWD_IE_Msk = 0x40
	// Bit IE.
	PADS_BANK0_SWD_IE = 0x40
	// Position of DRIVE field.
	PADS_BANK0_SWD_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_BANK0_SWD_DRIVE_Msk  = 0x30
	PADS_BANK0_SWD_DRIVE_2mA  = 0x0
	PADS_BANK0_SWD_DRIVE_4mA  = 0x1
	PADS_BANK0_SWD_DRIVE_8mA  = 0x2
	PADS_BANK0_SWD_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_BANK0_SWD_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_BANK0_SWD_PUE_Msk = 0x8
	// Bit PUE.
	PADS_BANK0_SWD_PUE = 0x8
	// Position of PDE field.
	PADS_BANK0_SWD_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_BANK0_SWD_PDE_Msk = 0x4
	// Bit PDE.
	PADS_BANK0_SWD_PDE = 0x4
	// Position of SCHMITT field.
	PADS_BANK0_SWD_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_BANK0_SWD_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_BANK0_SWD_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_BANK0_SWD_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_BANK0_SWD_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_BANK0_SWD_SLEWFAST = 0x1
)

// Bitfields for PADS_QSPI
const (
	// VOLTAGE_SELECT: Voltage select. Per bank control
	// Position of VOLTAGE_SELECT field.
	PADS_QSPI_VOLTAGE_SELECT_VOLTAGE_SELECT_Pos = 0x0
	// Bit mask of VOLTAGE_SELECT field.
	PADS_QSPI_VOLTAGE_SELECT_VOLTAGE_SELECT_Msk = 0x1
	// Bit VOLTAGE_SELECT.
	PADS_QSPI_VOLTAGE_SELECT_VOLTAGE_SELECT = 0x1
	// Set voltage to 3.3V (DVDD >= 2V5)
	PADS_QSPI_VOLTAGE_SELECT_VOLTAGE_SELECT_3v3 = 0x0
	// Set voltage to 1.8V (DVDD <= 1V8)
	PADS_QSPI_VOLTAGE_SELECT_VOLTAGE_SELECT_1v8 = 0x1

	// GPIO_QSPI_SCLK: Pad control register
	// Position of OD field.
	PADS_QSPI_GPIO_QSPI_SCLK_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_QSPI_GPIO_QSPI_SCLK_OD_Msk = 0x80
	// Bit OD.
	PADS_QSPI_GPIO_QSPI_SCLK_OD = 0x80
	// Position of IE field.
	PADS_QSPI_GPIO_QSPI_SCLK_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_QSPI_GPIO_QSPI_SCLK_IE_Msk = 0x40
	// Bit IE.
	PADS_QSPI_GPIO_QSPI_SCLK_IE = 0x40
	// Position of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SCLK_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SCLK_DRIVE_Msk  = 0x30
	PADS_QSPI_GPIO_QSPI_SCLK_DRIVE_2mA  = 0x0
	PADS_QSPI_GPIO_QSPI_SCLK_DRIVE_4mA  = 0x1
	PADS_QSPI_GPIO_QSPI_SCLK_DRIVE_8mA  = 0x2
	PADS_QSPI_GPIO_QSPI_SCLK_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_QSPI_GPIO_QSPI_SCLK_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_QSPI_GPIO_QSPI_SCLK_PUE_Msk = 0x8
	// Bit PUE.
	PADS_QSPI_GPIO_QSPI_SCLK_PUE = 0x8
	// Position of PDE field.
	PADS_QSPI_GPIO_QSPI_SCLK_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_QSPI_GPIO_QSPI_SCLK_PDE_Msk = 0x4
	// Bit PDE.
	PADS_QSPI_GPIO_QSPI_SCLK_PDE = 0x4
	// Position of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SCLK_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SCLK_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_QSPI_GPIO_QSPI_SCLK_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SCLK_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SCLK_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_QSPI_GPIO_QSPI_SCLK_SLEWFAST = 0x1

	// GPIO_QSPI_SD0: Pad control register
	// Position of OD field.
	PADS_QSPI_GPIO_QSPI_SD0_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_QSPI_GPIO_QSPI_SD0_OD_Msk = 0x80
	// Bit OD.
	PADS_QSPI_GPIO_QSPI_SD0_OD = 0x80
	// Position of IE field.
	PADS_QSPI_GPIO_QSPI_SD0_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_QSPI_GPIO_QSPI_SD0_IE_Msk = 0x40
	// Bit IE.
	PADS_QSPI_GPIO_QSPI_SD0_IE = 0x40
	// Position of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SD0_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SD0_DRIVE_Msk  = 0x30
	PADS_QSPI_GPIO_QSPI_SD0_DRIVE_2mA  = 0x0
	PADS_QSPI_GPIO_QSPI_SD0_DRIVE_4mA  = 0x1
	PADS_QSPI_GPIO_QSPI_SD0_DRIVE_8mA  = 0x2
	PADS_QSPI_GPIO_QSPI_SD0_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_QSPI_GPIO_QSPI_SD0_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_QSPI_GPIO_QSPI_SD0_PUE_Msk = 0x8
	// Bit PUE.
	PADS_QSPI_GPIO_QSPI_SD0_PUE = 0x8
	// Position of PDE field.
	PADS_QSPI_GPIO_QSPI_SD0_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_QSPI_GPIO_QSPI_SD0_PDE_Msk = 0x4
	// Bit PDE.
	PADS_QSPI_GPIO_QSPI_SD0_PDE = 0x4
	// Position of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SD0_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SD0_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_QSPI_GPIO_QSPI_SD0_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SD0_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SD0_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_QSPI_GPIO_QSPI_SD0_SLEWFAST = 0x1

	// GPIO_QSPI_SD1: Pad control register
	// Position of OD field.
	PADS_QSPI_GPIO_QSPI_SD1_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_QSPI_GPIO_QSPI_SD1_OD_Msk = 0x80
	// Bit OD.
	PADS_QSPI_GPIO_QSPI_SD1_OD = 0x80
	// Position of IE field.
	PADS_QSPI_GPIO_QSPI_SD1_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_QSPI_GPIO_QSPI_SD1_IE_Msk = 0x40
	// Bit IE.
	PADS_QSPI_GPIO_QSPI_SD1_IE = 0x40
	// Position of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SD1_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SD1_DRIVE_Msk  = 0x30
	PADS_QSPI_GPIO_QSPI_SD1_DRIVE_2mA  = 0x0
	PADS_QSPI_GPIO_QSPI_SD1_DRIVE_4mA  = 0x1
	PADS_QSPI_GPIO_QSPI_SD1_DRIVE_8mA  = 0x2
	PADS_QSPI_GPIO_QSPI_SD1_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_QSPI_GPIO_QSPI_SD1_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_QSPI_GPIO_QSPI_SD1_PUE_Msk = 0x8
	// Bit PUE.
	PADS_QSPI_GPIO_QSPI_SD1_PUE = 0x8
	// Position of PDE field.
	PADS_QSPI_GPIO_QSPI_SD1_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_QSPI_GPIO_QSPI_SD1_PDE_Msk = 0x4
	// Bit PDE.
	PADS_QSPI_GPIO_QSPI_SD1_PDE = 0x4
	// Position of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SD1_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SD1_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_QSPI_GPIO_QSPI_SD1_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SD1_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SD1_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_QSPI_GPIO_QSPI_SD1_SLEWFAST = 0x1

	// GPIO_QSPI_SD2: Pad control register
	// Position of OD field.
	PADS_QSPI_GPIO_QSPI_SD2_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_QSPI_GPIO_QSPI_SD2_OD_Msk = 0x80
	// Bit OD.
	PADS_QSPI_GPIO_QSPI_SD2_OD = 0x80
	// Position of IE field.
	PADS_QSPI_GPIO_QSPI_SD2_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_QSPI_GPIO_QSPI_SD2_IE_Msk = 0x40
	// Bit IE.
	PADS_QSPI_GPIO_QSPI_SD2_IE = 0x40
	// Position of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SD2_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SD2_DRIVE_Msk  = 0x30
	PADS_QSPI_GPIO_QSPI_SD2_DRIVE_2mA  = 0x0
	PADS_QSPI_GPIO_QSPI_SD2_DRIVE_4mA  = 0x1
	PADS_QSPI_GPIO_QSPI_SD2_DRIVE_8mA  = 0x2
	PADS_QSPI_GPIO_QSPI_SD2_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_QSPI_GPIO_QSPI_SD2_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_QSPI_GPIO_QSPI_SD2_PUE_Msk = 0x8
	// Bit PUE.
	PADS_QSPI_GPIO_QSPI_SD2_PUE = 0x8
	// Position of PDE field.
	PADS_QSPI_GPIO_QSPI_SD2_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_QSPI_GPIO_QSPI_SD2_PDE_Msk = 0x4
	// Bit PDE.
	PADS_QSPI_GPIO_QSPI_SD2_PDE = 0x4
	// Position of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SD2_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SD2_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_QSPI_GPIO_QSPI_SD2_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SD2_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SD2_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_QSPI_GPIO_QSPI_SD2_SLEWFAST = 0x1

	// GPIO_QSPI_SD3: Pad control register
	// Position of OD field.
	PADS_QSPI_GPIO_QSPI_SD3_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_QSPI_GPIO_QSPI_SD3_OD_Msk = 0x80
	// Bit OD.
	PADS_QSPI_GPIO_QSPI_SD3_OD = 0x80
	// Position of IE field.
	PADS_QSPI_GPIO_QSPI_SD3_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_QSPI_GPIO_QSPI_SD3_IE_Msk = 0x40
	// Bit IE.
	PADS_QSPI_GPIO_QSPI_SD3_IE = 0x40
	// Position of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SD3_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SD3_DRIVE_Msk  = 0x30
	PADS_QSPI_GPIO_QSPI_SD3_DRIVE_2mA  = 0x0
	PADS_QSPI_GPIO_QSPI_SD3_DRIVE_4mA  = 0x1
	PADS_QSPI_GPIO_QSPI_SD3_DRIVE_8mA  = 0x2
	PADS_QSPI_GPIO_QSPI_SD3_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_QSPI_GPIO_QSPI_SD3_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_QSPI_GPIO_QSPI_SD3_PUE_Msk = 0x8
	// Bit PUE.
	PADS_QSPI_GPIO_QSPI_SD3_PUE = 0x8
	// Position of PDE field.
	PADS_QSPI_GPIO_QSPI_SD3_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_QSPI_GPIO_QSPI_SD3_PDE_Msk = 0x4
	// Bit PDE.
	PADS_QSPI_GPIO_QSPI_SD3_PDE = 0x4
	// Position of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SD3_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SD3_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_QSPI_GPIO_QSPI_SD3_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SD3_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SD3_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_QSPI_GPIO_QSPI_SD3_SLEWFAST = 0x1

	// GPIO_QSPI_SS: Pad control register
	// Position of OD field.
	PADS_QSPI_GPIO_QSPI_SS_OD_Pos = 0x7
	// Bit mask of OD field.
	PADS_QSPI_GPIO_QSPI_SS_OD_Msk = 0x80
	// Bit OD.
	PADS_QSPI_GPIO_QSPI_SS_OD = 0x80
	// Position of IE field.
	PADS_QSPI_GPIO_QSPI_SS_IE_Pos = 0x6
	// Bit mask of IE field.
	PADS_QSPI_GPIO_QSPI_SS_IE_Msk = 0x40
	// Bit IE.
	PADS_QSPI_GPIO_QSPI_SS_IE = 0x40
	// Position of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SS_DRIVE_Pos = 0x4
	// Bit mask of DRIVE field.
	PADS_QSPI_GPIO_QSPI_SS_DRIVE_Msk  = 0x30
	PADS_QSPI_GPIO_QSPI_SS_DRIVE_2mA  = 0x0
	PADS_QSPI_GPIO_QSPI_SS_DRIVE_4mA  = 0x1
	PADS_QSPI_GPIO_QSPI_SS_DRIVE_8mA  = 0x2
	PADS_QSPI_GPIO_QSPI_SS_DRIVE_12mA = 0x3
	// Position of PUE field.
	PADS_QSPI_GPIO_QSPI_SS_PUE_Pos = 0x3
	// Bit mask of PUE field.
	PADS_QSPI_GPIO_QSPI_SS_PUE_Msk = 0x8
	// Bit PUE.
	PADS_QSPI_GPIO_QSPI_SS_PUE = 0x8
	// Position of PDE field.
	PADS_QSPI_GPIO_QSPI_SS_PDE_Pos = 0x2
	// Bit mask of PDE field.
	PADS_QSPI_GPIO_QSPI_SS_PDE_Msk = 0x4
	// Bit PDE.
	PADS_QSPI_GPIO_QSPI_SS_PDE = 0x4
	// Position of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SS_SCHMITT_Pos = 0x1
	// Bit mask of SCHMITT field.
	PADS_QSPI_GPIO_QSPI_SS_SCHMITT_Msk = 0x2
	// Bit SCHMITT.
	PADS_QSPI_GPIO_QSPI_SS_SCHMITT = 0x2
	// Position of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SS_SLEWFAST_Pos = 0x0
	// Bit mask of SLEWFAST field.
	PADS_QSPI_GPIO_QSPI_SS_SLEWFAST_Msk = 0x1
	// Bit SLEWFAST.
	PADS_QSPI_GPIO_QSPI_SS_SLEWFAST = 0x1
)

// Bitfields for XOSC: Controls the crystal oscillator
const (
	// CTRL: Crystal Oscillator Control
	// Position of ENABLE field.
	XOSC_CTRL_ENABLE_Pos = 0xc
	// Bit mask of ENABLE field.
	XOSC_CTRL_ENABLE_Msk     = 0xfff000
	XOSC_CTRL_ENABLE_DISABLE = 0xd1e
	XOSC_CTRL_ENABLE_ENABLE  = 0xfab
	// Position of FREQ_RANGE field.
	XOSC_CTRL_FREQ_RANGE_Pos = 0x0
	// Bit mask of FREQ_RANGE field.
	XOSC_CTRL_FREQ_RANGE_Msk        = 0xfff
	XOSC_CTRL_FREQ_RANGE_1_15MHZ    = 0xaa0
	XOSC_CTRL_FREQ_RANGE_RESERVED_1 = 0xaa1
	XOSC_CTRL_FREQ_RANGE_RESERVED_2 = 0xaa2
	XOSC_CTRL_FREQ_RANGE_RESERVED_3 = 0xaa3

	// STATUS: Crystal Oscillator Status
	// Position of STABLE field.
	XOSC_STATUS_STABLE_Pos = 0x1f
	// Bit mask of STABLE field.
	XOSC_STATUS_STABLE_Msk = 0x80000000
	// Bit STABLE.
	XOSC_STATUS_STABLE = 0x80000000
	// Position of BADWRITE field.
	XOSC_STATUS_BADWRITE_Pos = 0x18
	// Bit mask of BADWRITE field.
	XOSC_STATUS_BADWRITE_Msk = 0x1000000
	// Bit BADWRITE.
	XOSC_STATUS_BADWRITE = 0x1000000
	// Position of ENABLED field.
	XOSC_STATUS_ENABLED_Pos = 0xc
	// Bit mask of ENABLED field.
	XOSC_STATUS_ENABLED_Msk = 0x1000
	// Bit ENABLED.
	XOSC_STATUS_ENABLED = 0x1000
	// Position of FREQ_RANGE field.
	XOSC_STATUS_FREQ_RANGE_Pos = 0x0
	// Bit mask of FREQ_RANGE field.
	XOSC_STATUS_FREQ_RANGE_Msk        = 0x3
	XOSC_STATUS_FREQ_RANGE_1_15MHZ    = 0x0
	XOSC_STATUS_FREQ_RANGE_RESERVED_1 = 0x1
	XOSC_STATUS_FREQ_RANGE_RESERVED_2 = 0x2
	XOSC_STATUS_FREQ_RANGE_RESERVED_3 = 0x3

	// STARTUP: Controls the startup delay
	// Position of X4 field.
	XOSC_STARTUP_X4_Pos = 0x14
	// Bit mask of X4 field.
	XOSC_STARTUP_X4_Msk = 0x100000
	// Bit X4.
	XOSC_STARTUP_X4 = 0x100000
	// Position of DELAY field.
	XOSC_STARTUP_DELAY_Pos = 0x0
	// Bit mask of DELAY field.
	XOSC_STARTUP_DELAY_Msk = 0x3fff

	// COUNT
	// A down counter running at the xosc frequency which counts to zero and stops.
	// To start the counter write a non-zero value.
	// Can be used for short software pauses when setting up time sensitive hardware.
	// Position of COUNT field.
	XOSC_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	XOSC_COUNT_COUNT_Msk = 0xff
)

// Bitfields for PLL_SYS
const (
	// CS
	// Control and Status
	// GENERAL CONSTRAINTS:
	// Reference clock frequency min=5MHz, max=800MHz
	// Feedback divider min=16, max=320
	// VCO frequency min=400MHz, max=1600MHz
	// Position of LOCK field.
	PLL_SYS_CS_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	PLL_SYS_CS_LOCK_Msk = 0x80000000
	// Bit LOCK.
	PLL_SYS_CS_LOCK = 0x80000000
	// Position of BYPASS field.
	PLL_SYS_CS_BYPASS_Pos = 0x8
	// Bit mask of BYPASS field.
	PLL_SYS_CS_BYPASS_Msk = 0x100
	// Bit BYPASS.
	PLL_SYS_CS_BYPASS = 0x100
	// Position of REFDIV field.
	PLL_SYS_CS_REFDIV_Pos = 0x0
	// Bit mask of REFDIV field.
	PLL_SYS_CS_REFDIV_Msk = 0x3f

	// PWR: Controls the PLL power modes.
	// Position of VCOPD field.
	PLL_SYS_PWR_VCOPD_Pos = 0x5
	// Bit mask of VCOPD field.
	PLL_SYS_PWR_VCOPD_Msk = 0x20
	// Bit VCOPD.
	PLL_SYS_PWR_VCOPD = 0x20
	// Position of POSTDIVPD field.
	PLL_SYS_PWR_POSTDIVPD_Pos = 0x3
	// Bit mask of POSTDIVPD field.
	PLL_SYS_PWR_POSTDIVPD_Msk = 0x8
	// Bit POSTDIVPD.
	PLL_SYS_PWR_POSTDIVPD = 0x8
	// Position of DSMPD field.
	PLL_SYS_PWR_DSMPD_Pos = 0x2
	// Bit mask of DSMPD field.
	PLL_SYS_PWR_DSMPD_Msk = 0x4
	// Bit DSMPD.
	PLL_SYS_PWR_DSMPD = 0x4
	// Position of PD field.
	PLL_SYS_PWR_PD_Pos = 0x0
	// Bit mask of PD field.
	PLL_SYS_PWR_PD_Msk = 0x1
	// Bit PD.
	PLL_SYS_PWR_PD = 0x1

	// FBDIV_INT
	// Feedback divisor
	// (note: this PLL does not support fractional division)
	// Position of FBDIV_INT field.
	PLL_SYS_FBDIV_INT_FBDIV_INT_Pos = 0x0
	// Bit mask of FBDIV_INT field.
	PLL_SYS_FBDIV_INT_FBDIV_INT_Msk = 0xfff

	// PRIM
	// Controls the PLL post dividers for the primary output
	// (note: this PLL does not have a secondary output)
	// the primary output is driven from VCO divided by postdiv1*postdiv2
	// Position of POSTDIV1 field.
	PLL_SYS_PRIM_POSTDIV1_Pos = 0x10
	// Bit mask of POSTDIV1 field.
	PLL_SYS_PRIM_POSTDIV1_Msk = 0x70000
	// Position of POSTDIV2 field.
	PLL_SYS_PRIM_POSTDIV2_Pos = 0xc
	// Bit mask of POSTDIV2 field.
	PLL_SYS_PRIM_POSTDIV2_Msk = 0x7000
)

// Bitfields for BUSCTRL: Register block for busfabric control signals and performance counters
const (
	// BUS_PRIORITY: Set the priority of each master for bus arbitration.
	// Position of DMA_W field.
	BUSCTRL_BUS_PRIORITY_DMA_W_Pos = 0xc
	// Bit mask of DMA_W field.
	BUSCTRL_BUS_PRIORITY_DMA_W_Msk = 0x1000
	// Bit DMA_W.
	BUSCTRL_BUS_PRIORITY_DMA_W = 0x1000
	// Position of DMA_R field.
	BUSCTRL_BUS_PRIORITY_DMA_R_Pos = 0x8
	// Bit mask of DMA_R field.
	BUSCTRL_BUS_PRIORITY_DMA_R_Msk = 0x100
	// Bit DMA_R.
	BUSCTRL_BUS_PRIORITY_DMA_R = 0x100
	// Position of PROC1 field.
	BUSCTRL_BUS_PRIORITY_PROC1_Pos = 0x4
	// Bit mask of PROC1 field.
	BUSCTRL_BUS_PRIORITY_PROC1_Msk = 0x10
	// Bit PROC1.
	BUSCTRL_BUS_PRIORITY_PROC1 = 0x10
	// Position of PROC0 field.
	BUSCTRL_BUS_PRIORITY_PROC0_Pos = 0x0
	// Bit mask of PROC0 field.
	BUSCTRL_BUS_PRIORITY_PROC0_Msk = 0x1
	// Bit PROC0.
	BUSCTRL_BUS_PRIORITY_PROC0 = 0x1

	// BUS_PRIORITY_ACK: Bus priority acknowledge
	// Position of BUS_PRIORITY_ACK field.
	BUSCTRL_BUS_PRIORITY_ACK_BUS_PRIORITY_ACK_Pos = 0x0
	// Bit mask of BUS_PRIORITY_ACK field.
	BUSCTRL_BUS_PRIORITY_ACK_BUS_PRIORITY_ACK_Msk = 0x1
	// Bit BUS_PRIORITY_ACK.
	BUSCTRL_BUS_PRIORITY_ACK_BUS_PRIORITY_ACK = 0x1

	// PERFCTR0: Bus fabric performance counter 0
	// Position of PERFCTR0 field.
	BUSCTRL_PERFCTR0_PERFCTR0_Pos = 0x0
	// Bit mask of PERFCTR0 field.
	BUSCTRL_PERFCTR0_PERFCTR0_Msk = 0xffffff

	// PERFSEL0: Bus fabric performance event select for PERFCTR0
	// Position of PERFSEL0 field.
	BUSCTRL_PERFSEL0_PERFSEL0_Pos = 0x0
	// Bit mask of PERFSEL0 field.
	BUSCTRL_PERFSEL0_PERFSEL0_Msk = 0x1f

	// PERFCTR1: Bus fabric performance counter 1
	// Position of PERFCTR1 field.
	BUSCTRL_PERFCTR1_PERFCTR1_Pos = 0x0
	// Bit mask of PERFCTR1 field.
	BUSCTRL_PERFCTR1_PERFCTR1_Msk = 0xffffff

	// PERFSEL1: Bus fabric performance event select for PERFCTR1
	// Position of PERFSEL1 field.
	BUSCTRL_PERFSEL1_PERFSEL1_Pos = 0x0
	// Bit mask of PERFSEL1 field.
	BUSCTRL_PERFSEL1_PERFSEL1_Msk = 0x1f

	// PERFCTR2: Bus fabric performance counter 2
	// Position of PERFCTR2 field.
	BUSCTRL_PERFCTR2_PERFCTR2_Pos = 0x0
	// Bit mask of PERFCTR2 field.
	BUSCTRL_PERFCTR2_PERFCTR2_Msk = 0xffffff

	// PERFSEL2: Bus fabric performance event select for PERFCTR2
	// Position of PERFSEL2 field.
	BUSCTRL_PERFSEL2_PERFSEL2_Pos = 0x0
	// Bit mask of PERFSEL2 field.
	BUSCTRL_PERFSEL2_PERFSEL2_Msk = 0x1f

	// PERFCTR3: Bus fabric performance counter 3
	// Position of PERFCTR3 field.
	BUSCTRL_PERFCTR3_PERFCTR3_Pos = 0x0
	// Bit mask of PERFCTR3 field.
	BUSCTRL_PERFCTR3_PERFCTR3_Msk = 0xffffff

	// PERFSEL3: Bus fabric performance event select for PERFCTR3
	// Position of PERFSEL3 field.
	BUSCTRL_PERFSEL3_PERFSEL3_Pos = 0x0
	// Bit mask of PERFSEL3 field.
	BUSCTRL_PERFSEL3_PERFSEL3_Msk = 0x1f
)

// Bitfields for UART0
const (
	// UARTDR: Data Register, UARTDR
	// Position of OE field.
	UART0_UARTDR_OE_Pos = 0xb
	// Bit mask of OE field.
	UART0_UARTDR_OE_Msk = 0x800
	// Bit OE.
	UART0_UARTDR_OE = 0x800
	// Position of BE field.
	UART0_UARTDR_BE_Pos = 0xa
	// Bit mask of BE field.
	UART0_UARTDR_BE_Msk = 0x400
	// Bit BE.
	UART0_UARTDR_BE = 0x400
	// Position of PE field.
	UART0_UARTDR_PE_Pos = 0x9
	// Bit mask of PE field.
	UART0_UARTDR_PE_Msk = 0x200
	// Bit PE.
	UART0_UARTDR_PE = 0x200
	// Position of FE field.
	UART0_UARTDR_FE_Pos = 0x8
	// Bit mask of FE field.
	UART0_UARTDR_FE_Msk = 0x100
	// Bit FE.
	UART0_UARTDR_FE = 0x100
	// Position of DATA field.
	UART0_UARTDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	UART0_UARTDR_DATA_Msk = 0xff

	// UARTRSR: Receive Status Register/Error Clear Register, UARTRSR/UARTECR
	// Position of OE field.
	UART0_UARTRSR_OE_Pos = 0x3
	// Bit mask of OE field.
	UART0_UARTRSR_OE_Msk = 0x8
	// Bit OE.
	UART0_UARTRSR_OE = 0x8
	// Position of BE field.
	UART0_UARTRSR_BE_Pos = 0x2
	// Bit mask of BE field.
	UART0_UARTRSR_BE_Msk = 0x4
	// Bit BE.
	UART0_UARTRSR_BE = 0x4
	// Position of PE field.
	UART0_UARTRSR_PE_Pos = 0x1
	// Bit mask of PE field.
	UART0_UARTRSR_PE_Msk = 0x2
	// Bit PE.
	UART0_UARTRSR_PE = 0x2
	// Position of FE field.
	UART0_UARTRSR_FE_Pos = 0x0
	// Bit mask of FE field.
	UART0_UARTRSR_FE_Msk = 0x1
	// Bit FE.
	UART0_UARTRSR_FE = 0x1

	// UARTFR: Flag Register, UARTFR
	// Position of RI field.
	UART0_UARTFR_RI_Pos = 0x8
	// Bit mask of RI field.
	UART0_UARTFR_RI_Msk = 0x100
	// Bit RI.
	UART0_UARTFR_RI = 0x100
	// Position of TXFE field.
	UART0_UARTFR_TXFE_Pos = 0x7
	// Bit mask of TXFE field.
	UART0_UARTFR_TXFE_Msk = 0x80
	// Bit TXFE.
	UART0_UARTFR_TXFE = 0x80
	// Position of RXFF field.
	UART0_UARTFR_RXFF_Pos = 0x6
	// Bit mask of RXFF field.
	UART0_UARTFR_RXFF_Msk = 0x40
	// Bit RXFF.
	UART0_UARTFR_RXFF = 0x40
	// Position of TXFF field.
	UART0_UARTFR_TXFF_Pos = 0x5
	// Bit mask of TXFF field.
	UART0_UARTFR_TXFF_Msk = 0x20
	// Bit TXFF.
	UART0_UARTFR_TXFF = 0x20
	// Position of RXFE field.
	UART0_UARTFR_RXFE_Pos = 0x4
	// Bit mask of RXFE field.
	UART0_UARTFR_RXFE_Msk = 0x10
	// Bit RXFE.
	UART0_UARTFR_RXFE = 0x10
	// Position of BUSY field.
	UART0_UARTFR_BUSY_Pos = 0x3
	// Bit mask of BUSY field.
	UART0_UARTFR_BUSY_Msk = 0x8
	// Bit BUSY.
	UART0_UARTFR_BUSY = 0x8
	// Position of DCD field.
	UART0_UARTFR_DCD_Pos = 0x2
	// Bit mask of DCD field.
	UART0_UARTFR_DCD_Msk = 0x4
	// Bit DCD.
	UART0_UARTFR_DCD = 0x4
	// Position of DSR field.
	UART0_UARTFR_DSR_Pos = 0x1
	// Bit mask of DSR field.
	UART0_UARTFR_DSR_Msk = 0x2
	// Bit DSR.
	UART0_UARTFR_DSR = 0x2
	// Position of CTS field.
	UART0_UARTFR_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UART0_UARTFR_CTS_Msk = 0x1
	// Bit CTS.
	UART0_UARTFR_CTS = 0x1

	// UARTILPR: IrDA Low-Power Counter Register, UARTILPR
	// Position of ILPDVSR field.
	UART0_UARTILPR_ILPDVSR_Pos = 0x0
	// Bit mask of ILPDVSR field.
	UART0_UARTILPR_ILPDVSR_Msk = 0xff

	// UARTIBRD: Integer Baud Rate Register, UARTIBRD
	// Position of BAUD_DIVINT field.
	UART0_UARTIBRD_BAUD_DIVINT_Pos = 0x0
	// Bit mask of BAUD_DIVINT field.
	UART0_UARTIBRD_BAUD_DIVINT_Msk = 0xffff

	// UARTFBRD: Fractional Baud Rate Register, UARTFBRD
	// Position of BAUD_DIVFRAC field.
	UART0_UARTFBRD_BAUD_DIVFRAC_Pos = 0x0
	// Bit mask of BAUD_DIVFRAC field.
	UART0_UARTFBRD_BAUD_DIVFRAC_Msk = 0x3f

	// UARTLCR_H: Line Control Register, UARTLCR_H
	// Position of SPS field.
	UART0_UARTLCR_H_SPS_Pos = 0x7
	// Bit mask of SPS field.
	UART0_UARTLCR_H_SPS_Msk = 0x80
	// Bit SPS.
	UART0_UARTLCR_H_SPS = 0x80
	// Position of WLEN field.
	UART0_UARTLCR_H_WLEN_Pos = 0x5
	// Bit mask of WLEN field.
	UART0_UARTLCR_H_WLEN_Msk = 0x60
	// Position of FEN field.
	UART0_UARTLCR_H_FEN_Pos = 0x4
	// Bit mask of FEN field.
	UART0_UARTLCR_H_FEN_Msk = 0x10
	// Bit FEN.
	UART0_UARTLCR_H_FEN = 0x10
	// Position of STP2 field.
	UART0_UARTLCR_H_STP2_Pos = 0x3
	// Bit mask of STP2 field.
	UART0_UARTLCR_H_STP2_Msk = 0x8
	// Bit STP2.
	UART0_UARTLCR_H_STP2 = 0x8
	// Position of EPS field.
	UART0_UARTLCR_H_EPS_Pos = 0x2
	// Bit mask of EPS field.
	UART0_UARTLCR_H_EPS_Msk = 0x4
	// Bit EPS.
	UART0_UARTLCR_H_EPS = 0x4
	// Position of PEN field.
	UART0_UARTLCR_H_PEN_Pos = 0x1
	// Bit mask of PEN field.
	UART0_UARTLCR_H_PEN_Msk = 0x2
	// Bit PEN.
	UART0_UARTLCR_H_PEN = 0x2
	// Position of BRK field.
	UART0_UARTLCR_H_BRK_Pos = 0x0
	// Bit mask of BRK field.
	UART0_UARTLCR_H_BRK_Msk = 0x1
	// Bit BRK.
	UART0_UARTLCR_H_BRK = 0x1

	// UARTCR: Control Register, UARTCR
	// Position of CTSEN field.
	UART0_UARTCR_CTSEN_Pos = 0xf
	// Bit mask of CTSEN field.
	UART0_UARTCR_CTSEN_Msk = 0x8000
	// Bit CTSEN.
	UART0_UARTCR_CTSEN = 0x8000
	// Position of RTSEN field.
	UART0_UARTCR_RTSEN_Pos = 0xe
	// Bit mask of RTSEN field.
	UART0_UARTCR_RTSEN_Msk = 0x4000
	// Bit RTSEN.
	UART0_UARTCR_RTSEN = 0x4000
	// Position of OUT2 field.
	UART0_UARTCR_OUT2_Pos = 0xd
	// Bit mask of OUT2 field.
	UART0_UARTCR_OUT2_Msk = 0x2000
	// Bit OUT2.
	UART0_UARTCR_OUT2 = 0x2000
	// Position of OUT1 field.
	UART0_UARTCR_OUT1_Pos = 0xc
	// Bit mask of OUT1 field.
	UART0_UARTCR_OUT1_Msk = 0x1000
	// Bit OUT1.
	UART0_UARTCR_OUT1 = 0x1000
	// Position of RTS field.
	UART0_UARTCR_RTS_Pos = 0xb
	// Bit mask of RTS field.
	UART0_UARTCR_RTS_Msk = 0x800
	// Bit RTS.
	UART0_UARTCR_RTS = 0x800
	// Position of DTR field.
	UART0_UARTCR_DTR_Pos = 0xa
	// Bit mask of DTR field.
	UART0_UARTCR_DTR_Msk = 0x400
	// Bit DTR.
	UART0_UARTCR_DTR = 0x400
	// Position of RXE field.
	UART0_UARTCR_RXE_Pos = 0x9
	// Bit mask of RXE field.
	UART0_UARTCR_RXE_Msk = 0x200
	// Bit RXE.
	UART0_UARTCR_RXE = 0x200
	// Position of TXE field.
	UART0_UARTCR_TXE_Pos = 0x8
	// Bit mask of TXE field.
	UART0_UARTCR_TXE_Msk = 0x100
	// Bit TXE.
	UART0_UARTCR_TXE = 0x100
	// Position of LBE field.
	UART0_UARTCR_LBE_Pos = 0x7
	// Bit mask of LBE field.
	UART0_UARTCR_LBE_Msk = 0x80
	// Bit LBE.
	UART0_UARTCR_LBE = 0x80
	// Position of SIRLP field.
	UART0_UARTCR_SIRLP_Pos = 0x2
	// Bit mask of SIRLP field.
	UART0_UARTCR_SIRLP_Msk = 0x4
	// Bit SIRLP.
	UART0_UARTCR_SIRLP = 0x4
	// Position of SIREN field.
	UART0_UARTCR_SIREN_Pos = 0x1
	// Bit mask of SIREN field.
	UART0_UARTCR_SIREN_Msk = 0x2
	// Bit SIREN.
	UART0_UARTCR_SIREN = 0x2
	// Position of UARTEN field.
	UART0_UARTCR_UARTEN_Pos = 0x0
	// Bit mask of UARTEN field.
	UART0_UARTCR_UARTEN_Msk = 0x1
	// Bit UARTEN.
	UART0_UARTCR_UARTEN = 0x1

	// UARTIFLS: Interrupt FIFO Level Select Register, UARTIFLS
	// Position of RXIFLSEL field.
	UART0_UARTIFLS_RXIFLSEL_Pos = 0x3
	// Bit mask of RXIFLSEL field.
	UART0_UARTIFLS_RXIFLSEL_Msk = 0x38
	// Position of TXIFLSEL field.
	UART0_UARTIFLS_TXIFLSEL_Pos = 0x0
	// Bit mask of TXIFLSEL field.
	UART0_UARTIFLS_TXIFLSEL_Msk = 0x7

	// UARTIMSC: Interrupt Mask Set/Clear Register, UARTIMSC
	// Position of OEIM field.
	UART0_UARTIMSC_OEIM_Pos = 0xa
	// Bit mask of OEIM field.
	UART0_UARTIMSC_OEIM_Msk = 0x400
	// Bit OEIM.
	UART0_UARTIMSC_OEIM = 0x400
	// Position of BEIM field.
	UART0_UARTIMSC_BEIM_Pos = 0x9
	// Bit mask of BEIM field.
	UART0_UARTIMSC_BEIM_Msk = 0x200
	// Bit BEIM.
	UART0_UARTIMSC_BEIM = 0x200
	// Position of PEIM field.
	UART0_UARTIMSC_PEIM_Pos = 0x8
	// Bit mask of PEIM field.
	UART0_UARTIMSC_PEIM_Msk = 0x100
	// Bit PEIM.
	UART0_UARTIMSC_PEIM = 0x100
	// Position of FEIM field.
	UART0_UARTIMSC_FEIM_Pos = 0x7
	// Bit mask of FEIM field.
	UART0_UARTIMSC_FEIM_Msk = 0x80
	// Bit FEIM.
	UART0_UARTIMSC_FEIM = 0x80
	// Position of RTIM field.
	UART0_UARTIMSC_RTIM_Pos = 0x6
	// Bit mask of RTIM field.
	UART0_UARTIMSC_RTIM_Msk = 0x40
	// Bit RTIM.
	UART0_UARTIMSC_RTIM = 0x40
	// Position of TXIM field.
	UART0_UARTIMSC_TXIM_Pos = 0x5
	// Bit mask of TXIM field.
	UART0_UARTIMSC_TXIM_Msk = 0x20
	// Bit TXIM.
	UART0_UARTIMSC_TXIM = 0x20
	// Position of RXIM field.
	UART0_UARTIMSC_RXIM_Pos = 0x4
	// Bit mask of RXIM field.
	UART0_UARTIMSC_RXIM_Msk = 0x10
	// Bit RXIM.
	UART0_UARTIMSC_RXIM = 0x10
	// Position of DSRMIM field.
	UART0_UARTIMSC_DSRMIM_Pos = 0x3
	// Bit mask of DSRMIM field.
	UART0_UARTIMSC_DSRMIM_Msk = 0x8
	// Bit DSRMIM.
	UART0_UARTIMSC_DSRMIM = 0x8
	// Position of DCDMIM field.
	UART0_UARTIMSC_DCDMIM_Pos = 0x2
	// Bit mask of DCDMIM field.
	UART0_UARTIMSC_DCDMIM_Msk = 0x4
	// Bit DCDMIM.
	UART0_UARTIMSC_DCDMIM = 0x4
	// Position of CTSMIM field.
	UART0_UARTIMSC_CTSMIM_Pos = 0x1
	// Bit mask of CTSMIM field.
	UART0_UARTIMSC_CTSMIM_Msk = 0x2
	// Bit CTSMIM.
	UART0_UARTIMSC_CTSMIM = 0x2
	// Position of RIMIM field.
	UART0_UARTIMSC_RIMIM_Pos = 0x0
	// Bit mask of RIMIM field.
	UART0_UARTIMSC_RIMIM_Msk = 0x1
	// Bit RIMIM.
	UART0_UARTIMSC_RIMIM = 0x1

	// UARTRIS: Raw Interrupt Status Register, UARTRIS
	// Position of OERIS field.
	UART0_UARTRIS_OERIS_Pos = 0xa
	// Bit mask of OERIS field.
	UART0_UARTRIS_OERIS_Msk = 0x400
	// Bit OERIS.
	UART0_UARTRIS_OERIS = 0x400
	// Position of BERIS field.
	UART0_UARTRIS_BERIS_Pos = 0x9
	// Bit mask of BERIS field.
	UART0_UARTRIS_BERIS_Msk = 0x200
	// Bit BERIS.
	UART0_UARTRIS_BERIS = 0x200
	// Position of PERIS field.
	UART0_UARTRIS_PERIS_Pos = 0x8
	// Bit mask of PERIS field.
	UART0_UARTRIS_PERIS_Msk = 0x100
	// Bit PERIS.
	UART0_UARTRIS_PERIS = 0x100
	// Position of FERIS field.
	UART0_UARTRIS_FERIS_Pos = 0x7
	// Bit mask of FERIS field.
	UART0_UARTRIS_FERIS_Msk = 0x80
	// Bit FERIS.
	UART0_UARTRIS_FERIS = 0x80
	// Position of RTRIS field.
	UART0_UARTRIS_RTRIS_Pos = 0x6
	// Bit mask of RTRIS field.
	UART0_UARTRIS_RTRIS_Msk = 0x40
	// Bit RTRIS.
	UART0_UARTRIS_RTRIS = 0x40
	// Position of TXRIS field.
	UART0_UARTRIS_TXRIS_Pos = 0x5
	// Bit mask of TXRIS field.
	UART0_UARTRIS_TXRIS_Msk = 0x20
	// Bit TXRIS.
	UART0_UARTRIS_TXRIS = 0x20
	// Position of RXRIS field.
	UART0_UARTRIS_RXRIS_Pos = 0x4
	// Bit mask of RXRIS field.
	UART0_UARTRIS_RXRIS_Msk = 0x10
	// Bit RXRIS.
	UART0_UARTRIS_RXRIS = 0x10
	// Position of DSRRMIS field.
	UART0_UARTRIS_DSRRMIS_Pos = 0x3
	// Bit mask of DSRRMIS field.
	UART0_UARTRIS_DSRRMIS_Msk = 0x8
	// Bit DSRRMIS.
	UART0_UARTRIS_DSRRMIS = 0x8
	// Position of DCDRMIS field.
	UART0_UARTRIS_DCDRMIS_Pos = 0x2
	// Bit mask of DCDRMIS field.
	UART0_UARTRIS_DCDRMIS_Msk = 0x4
	// Bit DCDRMIS.
	UART0_UARTRIS_DCDRMIS = 0x4
	// Position of CTSRMIS field.
	UART0_UARTRIS_CTSRMIS_Pos = 0x1
	// Bit mask of CTSRMIS field.
	UART0_UARTRIS_CTSRMIS_Msk = 0x2
	// Bit CTSRMIS.
	UART0_UARTRIS_CTSRMIS = 0x2
	// Position of RIRMIS field.
	UART0_UARTRIS_RIRMIS_Pos = 0x0
	// Bit mask of RIRMIS field.
	UART0_UARTRIS_RIRMIS_Msk = 0x1
	// Bit RIRMIS.
	UART0_UARTRIS_RIRMIS = 0x1

	// UARTMIS: Masked Interrupt Status Register, UARTMIS
	// Position of OEMIS field.
	UART0_UARTMIS_OEMIS_Pos = 0xa
	// Bit mask of OEMIS field.
	UART0_UARTMIS_OEMIS_Msk = 0x400
	// Bit OEMIS.
	UART0_UARTMIS_OEMIS = 0x400
	// Position of BEMIS field.
	UART0_UARTMIS_BEMIS_Pos = 0x9
	// Bit mask of BEMIS field.
	UART0_UARTMIS_BEMIS_Msk = 0x200
	// Bit BEMIS.
	UART0_UARTMIS_BEMIS = 0x200
	// Position of PEMIS field.
	UART0_UARTMIS_PEMIS_Pos = 0x8
	// Bit mask of PEMIS field.
	UART0_UARTMIS_PEMIS_Msk = 0x100
	// Bit PEMIS.
	UART0_UARTMIS_PEMIS = 0x100
	// Position of FEMIS field.
	UART0_UARTMIS_FEMIS_Pos = 0x7
	// Bit mask of FEMIS field.
	UART0_UARTMIS_FEMIS_Msk = 0x80
	// Bit FEMIS.
	UART0_UARTMIS_FEMIS = 0x80
	// Position of RTMIS field.
	UART0_UARTMIS_RTMIS_Pos = 0x6
	// Bit mask of RTMIS field.
	UART0_UARTMIS_RTMIS_Msk = 0x40
	// Bit RTMIS.
	UART0_UARTMIS_RTMIS = 0x40
	// Position of TXMIS field.
	UART0_UARTMIS_TXMIS_Pos = 0x5
	// Bit mask of TXMIS field.
	UART0_UARTMIS_TXMIS_Msk = 0x20
	// Bit TXMIS.
	UART0_UARTMIS_TXMIS = 0x20
	// Position of RXMIS field.
	UART0_UARTMIS_RXMIS_Pos = 0x4
	// Bit mask of RXMIS field.
	UART0_UARTMIS_RXMIS_Msk = 0x10
	// Bit RXMIS.
	UART0_UARTMIS_RXMIS = 0x10
	// Position of DSRMMIS field.
	UART0_UARTMIS_DSRMMIS_Pos = 0x3
	// Bit mask of DSRMMIS field.
	UART0_UARTMIS_DSRMMIS_Msk = 0x8
	// Bit DSRMMIS.
	UART0_UARTMIS_DSRMMIS = 0x8
	// Position of DCDMMIS field.
	UART0_UARTMIS_DCDMMIS_Pos = 0x2
	// Bit mask of DCDMMIS field.
	UART0_UARTMIS_DCDMMIS_Msk = 0x4
	// Bit DCDMMIS.
	UART0_UARTMIS_DCDMMIS = 0x4
	// Position of CTSMMIS field.
	UART0_UARTMIS_CTSMMIS_Pos = 0x1
	// Bit mask of CTSMMIS field.
	UART0_UARTMIS_CTSMMIS_Msk = 0x2
	// Bit CTSMMIS.
	UART0_UARTMIS_CTSMMIS = 0x2
	// Position of RIMMIS field.
	UART0_UARTMIS_RIMMIS_Pos = 0x0
	// Bit mask of RIMMIS field.
	UART0_UARTMIS_RIMMIS_Msk = 0x1
	// Bit RIMMIS.
	UART0_UARTMIS_RIMMIS = 0x1

	// UARTICR: Interrupt Clear Register, UARTICR
	// Position of OEIC field.
	UART0_UARTICR_OEIC_Pos = 0xa
	// Bit mask of OEIC field.
	UART0_UARTICR_OEIC_Msk = 0x400
	// Bit OEIC.
	UART0_UARTICR_OEIC = 0x400
	// Position of BEIC field.
	UART0_UARTICR_BEIC_Pos = 0x9
	// Bit mask of BEIC field.
	UART0_UARTICR_BEIC_Msk = 0x200
	// Bit BEIC.
	UART0_UARTICR_BEIC = 0x200
	// Position of PEIC field.
	UART0_UARTICR_PEIC_Pos = 0x8
	// Bit mask of PEIC field.
	UART0_UARTICR_PEIC_Msk = 0x100
	// Bit PEIC.
	UART0_UARTICR_PEIC = 0x100
	// Position of FEIC field.
	UART0_UARTICR_FEIC_Pos = 0x7
	// Bit mask of FEIC field.
	UART0_UARTICR_FEIC_Msk = 0x80
	// Bit FEIC.
	UART0_UARTICR_FEIC = 0x80
	// Position of RTIC field.
	UART0_UARTICR_RTIC_Pos = 0x6
	// Bit mask of RTIC field.
	UART0_UARTICR_RTIC_Msk = 0x40
	// Bit RTIC.
	UART0_UARTICR_RTIC = 0x40
	// Position of TXIC field.
	UART0_UARTICR_TXIC_Pos = 0x5
	// Bit mask of TXIC field.
	UART0_UARTICR_TXIC_Msk = 0x20
	// Bit TXIC.
	UART0_UARTICR_TXIC = 0x20
	// Position of RXIC field.
	UART0_UARTICR_RXIC_Pos = 0x4
	// Bit mask of RXIC field.
	UART0_UARTICR_RXIC_Msk = 0x10
	// Bit RXIC.
	UART0_UARTICR_RXIC = 0x10
	// Position of DSRMIC field.
	UART0_UARTICR_DSRMIC_Pos = 0x3
	// Bit mask of DSRMIC field.
	UART0_UARTICR_DSRMIC_Msk = 0x8
	// Bit DSRMIC.
	UART0_UARTICR_DSRMIC = 0x8
	// Position of DCDMIC field.
	UART0_UARTICR_DCDMIC_Pos = 0x2
	// Bit mask of DCDMIC field.
	UART0_UARTICR_DCDMIC_Msk = 0x4
	// Bit DCDMIC.
	UART0_UARTICR_DCDMIC = 0x4
	// Position of CTSMIC field.
	UART0_UARTICR_CTSMIC_Pos = 0x1
	// Bit mask of CTSMIC field.
	UART0_UARTICR_CTSMIC_Msk = 0x2
	// Bit CTSMIC.
	UART0_UARTICR_CTSMIC = 0x2
	// Position of RIMIC field.
	UART0_UARTICR_RIMIC_Pos = 0x0
	// Bit mask of RIMIC field.
	UART0_UARTICR_RIMIC_Msk = 0x1
	// Bit RIMIC.
	UART0_UARTICR_RIMIC = 0x1

	// UARTDMACR: DMA Control Register, UARTDMACR
	// Position of DMAONERR field.
	UART0_UARTDMACR_DMAONERR_Pos = 0x2
	// Bit mask of DMAONERR field.
	UART0_UARTDMACR_DMAONERR_Msk = 0x4
	// Bit DMAONERR.
	UART0_UARTDMACR_DMAONERR = 0x4
	// Position of TXDMAE field.
	UART0_UARTDMACR_TXDMAE_Pos = 0x1
	// Bit mask of TXDMAE field.
	UART0_UARTDMACR_TXDMAE_Msk = 0x2
	// Bit TXDMAE.
	UART0_UARTDMACR_TXDMAE = 0x2
	// Position of RXDMAE field.
	UART0_UARTDMACR_RXDMAE_Pos = 0x0
	// Bit mask of RXDMAE field.
	UART0_UARTDMACR_RXDMAE_Msk = 0x1
	// Bit RXDMAE.
	UART0_UARTDMACR_RXDMAE = 0x1

	// UARTPERIPHID0: UARTPeriphID0 Register
	// Position of PARTNUMBER0 field.
	UART0_UARTPERIPHID0_PARTNUMBER0_Pos = 0x0
	// Bit mask of PARTNUMBER0 field.
	UART0_UARTPERIPHID0_PARTNUMBER0_Msk = 0xff

	// UARTPERIPHID1: UARTPeriphID1 Register
	// Position of DESIGNER0 field.
	UART0_UARTPERIPHID1_DESIGNER0_Pos = 0x4
	// Bit mask of DESIGNER0 field.
	UART0_UARTPERIPHID1_DESIGNER0_Msk = 0xf0
	// Position of PARTNUMBER1 field.
	UART0_UARTPERIPHID1_PARTNUMBER1_Pos = 0x0
	// Bit mask of PARTNUMBER1 field.
	UART0_UARTPERIPHID1_PARTNUMBER1_Msk = 0xf

	// UARTPERIPHID2: UARTPeriphID2 Register
	// Position of REVISION field.
	UART0_UARTPERIPHID2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	UART0_UARTPERIPHID2_REVISION_Msk = 0xf0
	// Position of DESIGNER1 field.
	UART0_UARTPERIPHID2_DESIGNER1_Pos = 0x0
	// Bit mask of DESIGNER1 field.
	UART0_UARTPERIPHID2_DESIGNER1_Msk = 0xf

	// UARTPERIPHID3: UARTPeriphID3 Register
	// Position of CONFIGURATION field.
	UART0_UARTPERIPHID3_CONFIGURATION_Pos = 0x0
	// Bit mask of CONFIGURATION field.
	UART0_UARTPERIPHID3_CONFIGURATION_Msk = 0xff

	// UARTPCELLID0: UARTPCellID0 Register
	// Position of UARTPCELLID0 field.
	UART0_UARTPCELLID0_UARTPCELLID0_Pos = 0x0
	// Bit mask of UARTPCELLID0 field.
	UART0_UARTPCELLID0_UARTPCELLID0_Msk = 0xff

	// UARTPCELLID1: UARTPCellID1 Register
	// Position of UARTPCELLID1 field.
	UART0_UARTPCELLID1_UARTPCELLID1_Pos = 0x0
	// Bit mask of UARTPCELLID1 field.
	UART0_UARTPCELLID1_UARTPCELLID1_Msk = 0xff

	// UARTPCELLID2: UARTPCellID2 Register
	// Position of UARTPCELLID2 field.
	UART0_UARTPCELLID2_UARTPCELLID2_Pos = 0x0
	// Bit mask of UARTPCELLID2 field.
	UART0_UARTPCELLID2_UARTPCELLID2_Msk = 0xff

	// UARTPCELLID3: UARTPCellID3 Register
	// Position of UARTPCELLID3 field.
	UART0_UARTPCELLID3_UARTPCELLID3_Pos = 0x0
	// Bit mask of UARTPCELLID3 field.
	UART0_UARTPCELLID3_UARTPCELLID3_Msk = 0xff
)

// Bitfields for SPI0
const (
	// SSPCR0: Control register 0, SSPCR0 on page 3-4
	// Position of SCR field.
	SPI0_SSPCR0_SCR_Pos = 0x8
	// Bit mask of SCR field.
	SPI0_SSPCR0_SCR_Msk = 0xff00
	// Position of SPH field.
	SPI0_SSPCR0_SPH_Pos = 0x7
	// Bit mask of SPH field.
	SPI0_SSPCR0_SPH_Msk = 0x80
	// Bit SPH.
	SPI0_SSPCR0_SPH = 0x80
	// Position of SPO field.
	SPI0_SSPCR0_SPO_Pos = 0x6
	// Bit mask of SPO field.
	SPI0_SSPCR0_SPO_Msk = 0x40
	// Bit SPO.
	SPI0_SSPCR0_SPO = 0x40
	// Position of FRF field.
	SPI0_SSPCR0_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI0_SSPCR0_FRF_Msk = 0x30
	// Position of DSS field.
	SPI0_SSPCR0_DSS_Pos = 0x0
	// Bit mask of DSS field.
	SPI0_SSPCR0_DSS_Msk = 0xf

	// SSPCR1: Control register 1, SSPCR1 on page 3-5
	// Position of SOD field.
	SPI0_SSPCR1_SOD_Pos = 0x3
	// Bit mask of SOD field.
	SPI0_SSPCR1_SOD_Msk = 0x8
	// Bit SOD.
	SPI0_SSPCR1_SOD = 0x8
	// Position of MS field.
	SPI0_SSPCR1_MS_Pos = 0x2
	// Bit mask of MS field.
	SPI0_SSPCR1_MS_Msk = 0x4
	// Bit MS.
	SPI0_SSPCR1_MS = 0x4
	// Position of SSE field.
	SPI0_SSPCR1_SSE_Pos = 0x1
	// Bit mask of SSE field.
	SPI0_SSPCR1_SSE_Msk = 0x2
	// Bit SSE.
	SPI0_SSPCR1_SSE = 0x2
	// Position of LBM field.
	SPI0_SSPCR1_LBM_Pos = 0x0
	// Bit mask of LBM field.
	SPI0_SSPCR1_LBM_Msk = 0x1
	// Bit LBM.
	SPI0_SSPCR1_LBM = 0x1

	// SSPDR: Data register, SSPDR on page 3-6
	// Position of DATA field.
	SPI0_SSPDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SPI0_SSPDR_DATA_Msk = 0xffff

	// SSPSR: Status register, SSPSR on page 3-7
	// Position of BSY field.
	SPI0_SSPSR_BSY_Pos = 0x4
	// Bit mask of BSY field.
	SPI0_SSPSR_BSY_Msk = 0x10
	// Bit BSY.
	SPI0_SSPSR_BSY = 0x10
	// Position of RFF field.
	SPI0_SSPSR_RFF_Pos = 0x3
	// Bit mask of RFF field.
	SPI0_SSPSR_RFF_Msk = 0x8
	// Bit RFF.
	SPI0_SSPSR_RFF = 0x8
	// Position of RNE field.
	SPI0_SSPSR_RNE_Pos = 0x2
	// Bit mask of RNE field.
	SPI0_SSPSR_RNE_Msk = 0x4
	// Bit RNE.
	SPI0_SSPSR_RNE = 0x4
	// Position of TNF field.
	SPI0_SSPSR_TNF_Pos = 0x1
	// Bit mask of TNF field.
	SPI0_SSPSR_TNF_Msk = 0x2
	// Bit TNF.
	SPI0_SSPSR_TNF = 0x2
	// Position of TFE field.
	SPI0_SSPSR_TFE_Pos = 0x0
	// Bit mask of TFE field.
	SPI0_SSPSR_TFE_Msk = 0x1
	// Bit TFE.
	SPI0_SSPSR_TFE = 0x1

	// SSPCPSR: Clock prescale register, SSPCPSR on page 3-8
	// Position of CPSDVSR field.
	SPI0_SSPCPSR_CPSDVSR_Pos = 0x0
	// Bit mask of CPSDVSR field.
	SPI0_SSPCPSR_CPSDVSR_Msk = 0xff

	// SSPIMSC: Interrupt mask set or clear register, SSPIMSC on page 3-9
	// Position of TXIM field.
	SPI0_SSPIMSC_TXIM_Pos = 0x3
	// Bit mask of TXIM field.
	SPI0_SSPIMSC_TXIM_Msk = 0x8
	// Bit TXIM.
	SPI0_SSPIMSC_TXIM = 0x8
	// Position of RXIM field.
	SPI0_SSPIMSC_RXIM_Pos = 0x2
	// Bit mask of RXIM field.
	SPI0_SSPIMSC_RXIM_Msk = 0x4
	// Bit RXIM.
	SPI0_SSPIMSC_RXIM = 0x4
	// Position of RTIM field.
	SPI0_SSPIMSC_RTIM_Pos = 0x1
	// Bit mask of RTIM field.
	SPI0_SSPIMSC_RTIM_Msk = 0x2
	// Bit RTIM.
	SPI0_SSPIMSC_RTIM = 0x2
	// Position of RORIM field.
	SPI0_SSPIMSC_RORIM_Pos = 0x0
	// Bit mask of RORIM field.
	SPI0_SSPIMSC_RORIM_Msk = 0x1
	// Bit RORIM.
	SPI0_SSPIMSC_RORIM = 0x1

	// SSPRIS: Raw interrupt status register, SSPRIS on page 3-10
	// Position of TXRIS field.
	SPI0_SSPRIS_TXRIS_Pos = 0x3
	// Bit mask of TXRIS field.
	SPI0_SSPRIS_TXRIS_Msk = 0x8
	// Bit TXRIS.
	SPI0_SSPRIS_TXRIS = 0x8
	// Position of RXRIS field.
	SPI0_SSPRIS_RXRIS_Pos = 0x2
	// Bit mask of RXRIS field.
	SPI0_SSPRIS_RXRIS_Msk = 0x4
	// Bit RXRIS.
	SPI0_SSPRIS_RXRIS = 0x4
	// Position of RTRIS field.
	SPI0_SSPRIS_RTRIS_Pos = 0x1
	// Bit mask of RTRIS field.
	SPI0_SSPRIS_RTRIS_Msk = 0x2
	// Bit RTRIS.
	SPI0_SSPRIS_RTRIS = 0x2
	// Position of RORRIS field.
	SPI0_SSPRIS_RORRIS_Pos = 0x0
	// Bit mask of RORRIS field.
	SPI0_SSPRIS_RORRIS_Msk = 0x1
	// Bit RORRIS.
	SPI0_SSPRIS_RORRIS = 0x1

	// SSPMIS: Masked interrupt status register, SSPMIS on page 3-11
	// Position of TXMIS field.
	SPI0_SSPMIS_TXMIS_Pos = 0x3
	// Bit mask of TXMIS field.
	SPI0_SSPMIS_TXMIS_Msk = 0x8
	// Bit TXMIS.
	SPI0_SSPMIS_TXMIS = 0x8
	// Position of RXMIS field.
	SPI0_SSPMIS_RXMIS_Pos = 0x2
	// Bit mask of RXMIS field.
	SPI0_SSPMIS_RXMIS_Msk = 0x4
	// Bit RXMIS.
	SPI0_SSPMIS_RXMIS = 0x4
	// Position of RTMIS field.
	SPI0_SSPMIS_RTMIS_Pos = 0x1
	// Bit mask of RTMIS field.
	SPI0_SSPMIS_RTMIS_Msk = 0x2
	// Bit RTMIS.
	SPI0_SSPMIS_RTMIS = 0x2
	// Position of RORMIS field.
	SPI0_SSPMIS_RORMIS_Pos = 0x0
	// Bit mask of RORMIS field.
	SPI0_SSPMIS_RORMIS_Msk = 0x1
	// Bit RORMIS.
	SPI0_SSPMIS_RORMIS = 0x1

	// SSPICR: Interrupt clear register, SSPICR on page 3-11
	// Position of RTIC field.
	SPI0_SSPICR_RTIC_Pos = 0x1
	// Bit mask of RTIC field.
	SPI0_SSPICR_RTIC_Msk = 0x2
	// Bit RTIC.
	SPI0_SSPICR_RTIC = 0x2
	// Position of RORIC field.
	SPI0_SSPICR_RORIC_Pos = 0x0
	// Bit mask of RORIC field.
	SPI0_SSPICR_RORIC_Msk = 0x1
	// Bit RORIC.
	SPI0_SSPICR_RORIC = 0x1

	// SSPDMACR: DMA control register, SSPDMACR on page 3-12
	// Position of TXDMAE field.
	SPI0_SSPDMACR_TXDMAE_Pos = 0x1
	// Bit mask of TXDMAE field.
	SPI0_SSPDMACR_TXDMAE_Msk = 0x2
	// Bit TXDMAE.
	SPI0_SSPDMACR_TXDMAE = 0x2
	// Position of RXDMAE field.
	SPI0_SSPDMACR_RXDMAE_Pos = 0x0
	// Bit mask of RXDMAE field.
	SPI0_SSPDMACR_RXDMAE_Msk = 0x1
	// Bit RXDMAE.
	SPI0_SSPDMACR_RXDMAE = 0x1

	// SSPPERIPHID0: Peripheral identification registers, SSPPeriphID0-3 on page 3-13
	// Position of PARTNUMBER0 field.
	SPI0_SSPPERIPHID0_PARTNUMBER0_Pos = 0x0
	// Bit mask of PARTNUMBER0 field.
	SPI0_SSPPERIPHID0_PARTNUMBER0_Msk = 0xff

	// SSPPERIPHID1: Peripheral identification registers, SSPPeriphID0-3 on page 3-13
	// Position of DESIGNER0 field.
	SPI0_SSPPERIPHID1_DESIGNER0_Pos = 0x4
	// Bit mask of DESIGNER0 field.
	SPI0_SSPPERIPHID1_DESIGNER0_Msk = 0xf0
	// Position of PARTNUMBER1 field.
	SPI0_SSPPERIPHID1_PARTNUMBER1_Pos = 0x0
	// Bit mask of PARTNUMBER1 field.
	SPI0_SSPPERIPHID1_PARTNUMBER1_Msk = 0xf

	// SSPPERIPHID2: Peripheral identification registers, SSPPeriphID0-3 on page 3-13
	// Position of REVISION field.
	SPI0_SSPPERIPHID2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	SPI0_SSPPERIPHID2_REVISION_Msk = 0xf0
	// Position of DESIGNER1 field.
	SPI0_SSPPERIPHID2_DESIGNER1_Pos = 0x0
	// Bit mask of DESIGNER1 field.
	SPI0_SSPPERIPHID2_DESIGNER1_Msk = 0xf

	// SSPPERIPHID3: Peripheral identification registers, SSPPeriphID0-3 on page 3-13
	// Position of CONFIGURATION field.
	SPI0_SSPPERIPHID3_CONFIGURATION_Pos = 0x0
	// Bit mask of CONFIGURATION field.
	SPI0_SSPPERIPHID3_CONFIGURATION_Msk = 0xff

	// SSPPCELLID0: PrimeCell identification registers, SSPPCellID0-3 on page 3-16
	// Position of SSPPCELLID0 field.
	SPI0_SSPPCELLID0_SSPPCELLID0_Pos = 0x0
	// Bit mask of SSPPCELLID0 field.
	SPI0_SSPPCELLID0_SSPPCELLID0_Msk = 0xff

	// SSPPCELLID1: PrimeCell identification registers, SSPPCellID0-3 on page 3-16
	// Position of SSPPCELLID1 field.
	SPI0_SSPPCELLID1_SSPPCELLID1_Pos = 0x0
	// Bit mask of SSPPCELLID1 field.
	SPI0_SSPPCELLID1_SSPPCELLID1_Msk = 0xff

	// SSPPCELLID2: PrimeCell identification registers, SSPPCellID0-3 on page 3-16
	// Position of SSPPCELLID2 field.
	SPI0_SSPPCELLID2_SSPPCELLID2_Pos = 0x0
	// Bit mask of SSPPCELLID2 field.
	SPI0_SSPPCELLID2_SSPPCELLID2_Msk = 0xff

	// SSPPCELLID3: PrimeCell identification registers, SSPPCellID0-3 on page 3-16
	// Position of SSPPCELLID3 field.
	SPI0_SSPPCELLID3_SSPPCELLID3_Pos = 0x0
	// Bit mask of SSPPCELLID3 field.
	SPI0_SSPPCELLID3_SSPPCELLID3_Msk = 0xff
)

// Bitfields for I2C0: DW_apb_i2c address block
const (
	// IC_CON
	// I2C Control Register. This register can be written only when the DW_apb_i2c is disabled, which corresponds to the IC_ENABLE[0] register being set to 0. Writes at other times have no effect.\n
	// Read/Write Access: - bit 10 is read only. - bit 11 is read only - bit 16 is read only - bit 17 is read only - bits 18 and 19 are read only.
	// Position of STOP_DET_IF_MASTER_ACTIVE field.
	I2C0_IC_CON_STOP_DET_IF_MASTER_ACTIVE_Pos = 0xa
	// Bit mask of STOP_DET_IF_MASTER_ACTIVE field.
	I2C0_IC_CON_STOP_DET_IF_MASTER_ACTIVE_Msk = 0x400
	// Bit STOP_DET_IF_MASTER_ACTIVE.
	I2C0_IC_CON_STOP_DET_IF_MASTER_ACTIVE = 0x400
	// Position of RX_FIFO_FULL_HLD_CTRL field.
	I2C0_IC_CON_RX_FIFO_FULL_HLD_CTRL_Pos = 0x9
	// Bit mask of RX_FIFO_FULL_HLD_CTRL field.
	I2C0_IC_CON_RX_FIFO_FULL_HLD_CTRL_Msk = 0x200
	// Bit RX_FIFO_FULL_HLD_CTRL.
	I2C0_IC_CON_RX_FIFO_FULL_HLD_CTRL = 0x200
	// Overflow when RX_FIFO is full
	I2C0_IC_CON_RX_FIFO_FULL_HLD_CTRL_DISABLED = 0x0
	// Hold bus when RX_FIFO is full
	I2C0_IC_CON_RX_FIFO_FULL_HLD_CTRL_ENABLED = 0x1
	// Position of TX_EMPTY_CTRL field.
	I2C0_IC_CON_TX_EMPTY_CTRL_Pos = 0x8
	// Bit mask of TX_EMPTY_CTRL field.
	I2C0_IC_CON_TX_EMPTY_CTRL_Msk = 0x100
	// Bit TX_EMPTY_CTRL.
	I2C0_IC_CON_TX_EMPTY_CTRL = 0x100
	// Default behaviour of TX_EMPTY interrupt
	I2C0_IC_CON_TX_EMPTY_CTRL_DISABLED = 0x0
	// Controlled generation of TX_EMPTY interrupt
	I2C0_IC_CON_TX_EMPTY_CTRL_ENABLED = 0x1
	// Position of STOP_DET_IFADDRESSED field.
	I2C0_IC_CON_STOP_DET_IFADDRESSED_Pos = 0x7
	// Bit mask of STOP_DET_IFADDRESSED field.
	I2C0_IC_CON_STOP_DET_IFADDRESSED_Msk = 0x80
	// Bit STOP_DET_IFADDRESSED.
	I2C0_IC_CON_STOP_DET_IFADDRESSED = 0x80
	// slave issues STOP_DET intr always
	I2C0_IC_CON_STOP_DET_IFADDRESSED_DISABLED = 0x0
	// slave issues STOP_DET intr only if addressed
	I2C0_IC_CON_STOP_DET_IFADDRESSED_ENABLED = 0x1
	// Position of IC_SLAVE_DISABLE field.
	I2C0_IC_CON_IC_SLAVE_DISABLE_Pos = 0x6
	// Bit mask of IC_SLAVE_DISABLE field.
	I2C0_IC_CON_IC_SLAVE_DISABLE_Msk = 0x40
	// Bit IC_SLAVE_DISABLE.
	I2C0_IC_CON_IC_SLAVE_DISABLE = 0x40
	// Slave mode is enabled
	I2C0_IC_CON_IC_SLAVE_DISABLE_SLAVE_ENABLED = 0x0
	// Slave mode is disabled
	I2C0_IC_CON_IC_SLAVE_DISABLE_SLAVE_DISABLED = 0x1
	// Position of IC_RESTART_EN field.
	I2C0_IC_CON_IC_RESTART_EN_Pos = 0x5
	// Bit mask of IC_RESTART_EN field.
	I2C0_IC_CON_IC_RESTART_EN_Msk = 0x20
	// Bit IC_RESTART_EN.
	I2C0_IC_CON_IC_RESTART_EN = 0x20
	// Master restart disabled
	I2C0_IC_CON_IC_RESTART_EN_DISABLED = 0x0
	// Master restart enabled
	I2C0_IC_CON_IC_RESTART_EN_ENABLED = 0x1
	// Position of IC_10BITADDR_MASTER field.
	I2C0_IC_CON_IC_10BITADDR_MASTER_Pos = 0x4
	// Bit mask of IC_10BITADDR_MASTER field.
	I2C0_IC_CON_IC_10BITADDR_MASTER_Msk = 0x10
	// Bit IC_10BITADDR_MASTER.
	I2C0_IC_CON_IC_10BITADDR_MASTER = 0x10
	// Master 7Bit addressing mode
	I2C0_IC_CON_IC_10BITADDR_MASTER_ADDR_7BITS = 0x0
	// Master 10Bit addressing mode
	I2C0_IC_CON_IC_10BITADDR_MASTER_ADDR_10BITS = 0x1
	// Position of IC_10BITADDR_SLAVE field.
	I2C0_IC_CON_IC_10BITADDR_SLAVE_Pos = 0x3
	// Bit mask of IC_10BITADDR_SLAVE field.
	I2C0_IC_CON_IC_10BITADDR_SLAVE_Msk = 0x8
	// Bit IC_10BITADDR_SLAVE.
	I2C0_IC_CON_IC_10BITADDR_SLAVE = 0x8
	// Slave 7Bit addressing
	I2C0_IC_CON_IC_10BITADDR_SLAVE_ADDR_7BITS = 0x0
	// Slave 10Bit addressing
	I2C0_IC_CON_IC_10BITADDR_SLAVE_ADDR_10BITS = 0x1
	// Position of SPEED field.
	I2C0_IC_CON_SPEED_Pos = 0x1
	// Bit mask of SPEED field.
	I2C0_IC_CON_SPEED_Msk = 0x6
	// Standard Speed mode of operation
	I2C0_IC_CON_SPEED_STANDARD = 0x1
	// Fast or Fast Plus mode of operation
	I2C0_IC_CON_SPEED_FAST = 0x2
	// High Speed mode of operation
	I2C0_IC_CON_SPEED_HIGH = 0x3
	// Position of MASTER_MODE field.
	I2C0_IC_CON_MASTER_MODE_Pos = 0x0
	// Bit mask of MASTER_MODE field.
	I2C0_IC_CON_MASTER_MODE_Msk = 0x1
	// Bit MASTER_MODE.
	I2C0_IC_CON_MASTER_MODE = 0x1
	// Master mode is disabled
	I2C0_IC_CON_MASTER_MODE_DISABLED = 0x0
	// Master mode is enabled
	I2C0_IC_CON_MASTER_MODE_ENABLED = 0x1

	// IC_TAR
	// I2C Target Address Register\n
	// This register is 12 bits wide, and bits 31:12 are reserved. This register can be written to only when IC_ENABLE[0] is set to 0.\n
	// Note: If the software or application is aware that the DW_apb_i2c is not using the TAR address for the pending commands in the Tx FIFO, then it is possible to update the TAR address even while the Tx FIFO has entries (IC_STATUS[2]= 0). - It is not necessary to perform any write to this register if DW_apb_i2c is enabled as an I2C slave only.
	// Position of SPECIAL field.
	I2C0_IC_TAR_SPECIAL_Pos = 0xb
	// Bit mask of SPECIAL field.
	I2C0_IC_TAR_SPECIAL_Msk = 0x800
	// Bit SPECIAL.
	I2C0_IC_TAR_SPECIAL = 0x800
	// Disables programming of GENERAL_CALL or START_BYTE transmission
	I2C0_IC_TAR_SPECIAL_DISABLED = 0x0
	// Enables programming of GENERAL_CALL or START_BYTE transmission
	I2C0_IC_TAR_SPECIAL_ENABLED = 0x1
	// Position of GC_OR_START field.
	I2C0_IC_TAR_GC_OR_START_Pos = 0xa
	// Bit mask of GC_OR_START field.
	I2C0_IC_TAR_GC_OR_START_Msk = 0x400
	// Bit GC_OR_START.
	I2C0_IC_TAR_GC_OR_START = 0x400
	// GENERAL_CALL byte transmission
	I2C0_IC_TAR_GC_OR_START_GENERAL_CALL = 0x0
	// START byte transmission
	I2C0_IC_TAR_GC_OR_START_START_BYTE = 0x1
	// Position of IC_TAR field.
	I2C0_IC_TAR_IC_TAR_Pos = 0x0
	// Bit mask of IC_TAR field.
	I2C0_IC_TAR_IC_TAR_Msk = 0x3ff

	// IC_SAR: I2C Slave Address Register
	// Position of IC_SAR field.
	I2C0_IC_SAR_IC_SAR_Pos = 0x0
	// Bit mask of IC_SAR field.
	I2C0_IC_SAR_IC_SAR_Msk = 0x3ff

	// IC_DATA_CMD
	// I2C Rx/Tx Data Buffer and Command Register; this is the register the CPU writes to when filling the TX FIFO and the CPU reads from when retrieving bytes from RX FIFO.\n
	// The size of the register changes as follows:\n
	// Write: - 11 bits when IC_EMPTYFIFO_HOLD_MASTER_EN=1 - 9 bits when IC_EMPTYFIFO_HOLD_MASTER_EN=0 Read: - 12 bits when IC_FIRST_DATA_BYTE_STATUS = 1 - 8 bits when IC_FIRST_DATA_BYTE_STATUS = 0 Note: In order for the DW_apb_i2c to continue acknowledging reads, a read command should be written for every byte that is to be received; otherwise the DW_apb_i2c will stop acknowledging.
	// Position of FIRST_DATA_BYTE field.
	I2C0_IC_DATA_CMD_FIRST_DATA_BYTE_Pos = 0xb
	// Bit mask of FIRST_DATA_BYTE field.
	I2C0_IC_DATA_CMD_FIRST_DATA_BYTE_Msk = 0x800
	// Bit FIRST_DATA_BYTE.
	I2C0_IC_DATA_CMD_FIRST_DATA_BYTE = 0x800
	// Sequential data byte received
	I2C0_IC_DATA_CMD_FIRST_DATA_BYTE_INACTIVE = 0x0
	// Non sequential data byte received
	I2C0_IC_DATA_CMD_FIRST_DATA_BYTE_ACTIVE = 0x1
	// Position of RESTART field.
	I2C0_IC_DATA_CMD_RESTART_Pos = 0xa
	// Bit mask of RESTART field.
	I2C0_IC_DATA_CMD_RESTART_Msk = 0x400
	// Bit RESTART.
	I2C0_IC_DATA_CMD_RESTART = 0x400
	// Don't Issue RESTART before this command
	I2C0_IC_DATA_CMD_RESTART_DISABLE = 0x0
	// Issue RESTART before this command
	I2C0_IC_DATA_CMD_RESTART_ENABLE = 0x1
	// Position of STOP field.
	I2C0_IC_DATA_CMD_STOP_Pos = 0x9
	// Bit mask of STOP field.
	I2C0_IC_DATA_CMD_STOP_Msk = 0x200
	// Bit STOP.
	I2C0_IC_DATA_CMD_STOP = 0x200
	// Don't Issue STOP after this command
	I2C0_IC_DATA_CMD_STOP_DISABLE = 0x0
	// Issue STOP after this command
	I2C0_IC_DATA_CMD_STOP_ENABLE = 0x1
	// Position of CMD field.
	I2C0_IC_DATA_CMD_CMD_Pos = 0x8
	// Bit mask of CMD field.
	I2C0_IC_DATA_CMD_CMD_Msk = 0x100
	// Bit CMD.
	I2C0_IC_DATA_CMD_CMD = 0x100
	// Master Write Command
	I2C0_IC_DATA_CMD_CMD_WRITE = 0x0
	// Master Read Command
	I2C0_IC_DATA_CMD_CMD_READ = 0x1
	// Position of DAT field.
	I2C0_IC_DATA_CMD_DAT_Pos = 0x0
	// Bit mask of DAT field.
	I2C0_IC_DATA_CMD_DAT_Msk = 0xff

	// IC_SS_SCL_HCNT: Standard Speed I2C Clock SCL High Count Register
	// Position of IC_SS_SCL_HCNT field.
	I2C0_IC_SS_SCL_HCNT_IC_SS_SCL_HCNT_Pos = 0x0
	// Bit mask of IC_SS_SCL_HCNT field.
	I2C0_IC_SS_SCL_HCNT_IC_SS_SCL_HCNT_Msk = 0xffff

	// IC_SS_SCL_LCNT: Standard Speed I2C Clock SCL Low Count Register
	// Position of IC_SS_SCL_LCNT field.
	I2C0_IC_SS_SCL_LCNT_IC_SS_SCL_LCNT_Pos = 0x0
	// Bit mask of IC_SS_SCL_LCNT field.
	I2C0_IC_SS_SCL_LCNT_IC_SS_SCL_LCNT_Msk = 0xffff

	// IC_FS_SCL_HCNT: Fast Mode or Fast Mode Plus I2C Clock SCL High Count Register
	// Position of IC_FS_SCL_HCNT field.
	I2C0_IC_FS_SCL_HCNT_IC_FS_SCL_HCNT_Pos = 0x0
	// Bit mask of IC_FS_SCL_HCNT field.
	I2C0_IC_FS_SCL_HCNT_IC_FS_SCL_HCNT_Msk = 0xffff

	// IC_FS_SCL_LCNT: Fast Mode or Fast Mode Plus I2C Clock SCL Low Count Register
	// Position of IC_FS_SCL_LCNT field.
	I2C0_IC_FS_SCL_LCNT_IC_FS_SCL_LCNT_Pos = 0x0
	// Bit mask of IC_FS_SCL_LCNT field.
	I2C0_IC_FS_SCL_LCNT_IC_FS_SCL_LCNT_Msk = 0xffff

	// IC_INTR_STAT
	// I2C Interrupt Status Register\n
	// Each bit in this register has a corresponding mask bit in the IC_INTR_MASK register. These bits are cleared by reading the matching interrupt clear register. The unmasked raw versions of these bits are available in the IC_RAW_INTR_STAT register.
	// Position of R_MASTER_ON_HOLD field.
	I2C0_IC_INTR_STAT_R_MASTER_ON_HOLD_Pos = 0xd
	// Bit mask of R_MASTER_ON_HOLD field.
	I2C0_IC_INTR_STAT_R_MASTER_ON_HOLD_Msk = 0x2000
	// Bit R_MASTER_ON_HOLD.
	I2C0_IC_INTR_STAT_R_MASTER_ON_HOLD = 0x2000
	// R_MASTER_ON_HOLD interrupt is inactive
	I2C0_IC_INTR_STAT_R_MASTER_ON_HOLD_INACTIVE = 0x0
	// R_MASTER_ON_HOLD interrupt is active
	I2C0_IC_INTR_STAT_R_MASTER_ON_HOLD_ACTIVE = 0x1
	// Position of R_RESTART_DET field.
	I2C0_IC_INTR_STAT_R_RESTART_DET_Pos = 0xc
	// Bit mask of R_RESTART_DET field.
	I2C0_IC_INTR_STAT_R_RESTART_DET_Msk = 0x1000
	// Bit R_RESTART_DET.
	I2C0_IC_INTR_STAT_R_RESTART_DET = 0x1000
	// R_RESTART_DET interrupt is inactive
	I2C0_IC_INTR_STAT_R_RESTART_DET_INACTIVE = 0x0
	// R_RESTART_DET interrupt is active
	I2C0_IC_INTR_STAT_R_RESTART_DET_ACTIVE = 0x1
	// Position of R_GEN_CALL field.
	I2C0_IC_INTR_STAT_R_GEN_CALL_Pos = 0xb
	// Bit mask of R_GEN_CALL field.
	I2C0_IC_INTR_STAT_R_GEN_CALL_Msk = 0x800
	// Bit R_GEN_CALL.
	I2C0_IC_INTR_STAT_R_GEN_CALL = 0x800
	// R_GEN_CALL interrupt is inactive
	I2C0_IC_INTR_STAT_R_GEN_CALL_INACTIVE = 0x0
	// R_GEN_CALL interrupt is active
	I2C0_IC_INTR_STAT_R_GEN_CALL_ACTIVE = 0x1
	// Position of R_START_DET field.
	I2C0_IC_INTR_STAT_R_START_DET_Pos = 0xa
	// Bit mask of R_START_DET field.
	I2C0_IC_INTR_STAT_R_START_DET_Msk = 0x400
	// Bit R_START_DET.
	I2C0_IC_INTR_STAT_R_START_DET = 0x400
	// R_START_DET interrupt is inactive
	I2C0_IC_INTR_STAT_R_START_DET_INACTIVE = 0x0
	// R_START_DET interrupt is active
	I2C0_IC_INTR_STAT_R_START_DET_ACTIVE = 0x1
	// Position of R_STOP_DET field.
	I2C0_IC_INTR_STAT_R_STOP_DET_Pos = 0x9
	// Bit mask of R_STOP_DET field.
	I2C0_IC_INTR_STAT_R_STOP_DET_Msk = 0x200
	// Bit R_STOP_DET.
	I2C0_IC_INTR_STAT_R_STOP_DET = 0x200
	// R_STOP_DET interrupt is inactive
	I2C0_IC_INTR_STAT_R_STOP_DET_INACTIVE = 0x0
	// R_STOP_DET interrupt is active
	I2C0_IC_INTR_STAT_R_STOP_DET_ACTIVE = 0x1
	// Position of R_ACTIVITY field.
	I2C0_IC_INTR_STAT_R_ACTIVITY_Pos = 0x8
	// Bit mask of R_ACTIVITY field.
	I2C0_IC_INTR_STAT_R_ACTIVITY_Msk = 0x100
	// Bit R_ACTIVITY.
	I2C0_IC_INTR_STAT_R_ACTIVITY = 0x100
	// R_ACTIVITY interrupt is inactive
	I2C0_IC_INTR_STAT_R_ACTIVITY_INACTIVE = 0x0
	// R_ACTIVITY interrupt is active
	I2C0_IC_INTR_STAT_R_ACTIVITY_ACTIVE = 0x1
	// Position of R_RX_DONE field.
	I2C0_IC_INTR_STAT_R_RX_DONE_Pos = 0x7
	// Bit mask of R_RX_DONE field.
	I2C0_IC_INTR_STAT_R_RX_DONE_Msk = 0x80
	// Bit R_RX_DONE.
	I2C0_IC_INTR_STAT_R_RX_DONE = 0x80
	// R_RX_DONE interrupt is inactive
	I2C0_IC_INTR_STAT_R_RX_DONE_INACTIVE = 0x0
	// R_RX_DONE interrupt is active
	I2C0_IC_INTR_STAT_R_RX_DONE_ACTIVE = 0x1
	// Position of R_TX_ABRT field.
	I2C0_IC_INTR_STAT_R_TX_ABRT_Pos = 0x6
	// Bit mask of R_TX_ABRT field.
	I2C0_IC_INTR_STAT_R_TX_ABRT_Msk = 0x40
	// Bit R_TX_ABRT.
	I2C0_IC_INTR_STAT_R_TX_ABRT = 0x40
	// R_TX_ABRT interrupt is inactive
	I2C0_IC_INTR_STAT_R_TX_ABRT_INACTIVE = 0x0
	// R_TX_ABRT interrupt is active
	I2C0_IC_INTR_STAT_R_TX_ABRT_ACTIVE = 0x1
	// Position of R_RD_REQ field.
	I2C0_IC_INTR_STAT_R_RD_REQ_Pos = 0x5
	// Bit mask of R_RD_REQ field.
	I2C0_IC_INTR_STAT_R_RD_REQ_Msk = 0x20
	// Bit R_RD_REQ.
	I2C0_IC_INTR_STAT_R_RD_REQ = 0x20
	// R_RD_REQ interrupt is inactive
	I2C0_IC_INTR_STAT_R_RD_REQ_INACTIVE = 0x0
	// R_RD_REQ interrupt is active
	I2C0_IC_INTR_STAT_R_RD_REQ_ACTIVE = 0x1
	// Position of R_TX_EMPTY field.
	I2C0_IC_INTR_STAT_R_TX_EMPTY_Pos = 0x4
	// Bit mask of R_TX_EMPTY field.
	I2C0_IC_INTR_STAT_R_TX_EMPTY_Msk = 0x10
	// Bit R_TX_EMPTY.
	I2C0_IC_INTR_STAT_R_TX_EMPTY = 0x10
	// R_TX_EMPTY interrupt is inactive
	I2C0_IC_INTR_STAT_R_TX_EMPTY_INACTIVE = 0x0
	// R_TX_EMPTY interrupt is active
	I2C0_IC_INTR_STAT_R_TX_EMPTY_ACTIVE = 0x1
	// Position of R_TX_OVER field.
	I2C0_IC_INTR_STAT_R_TX_OVER_Pos = 0x3
	// Bit mask of R_TX_OVER field.
	I2C0_IC_INTR_STAT_R_TX_OVER_Msk = 0x8
	// Bit R_TX_OVER.
	I2C0_IC_INTR_STAT_R_TX_OVER = 0x8
	// R_TX_OVER interrupt is inactive
	I2C0_IC_INTR_STAT_R_TX_OVER_INACTIVE = 0x0
	// R_TX_OVER interrupt is active
	I2C0_IC_INTR_STAT_R_TX_OVER_ACTIVE = 0x1
	// Position of R_RX_FULL field.
	I2C0_IC_INTR_STAT_R_RX_FULL_Pos = 0x2
	// Bit mask of R_RX_FULL field.
	I2C0_IC_INTR_STAT_R_RX_FULL_Msk = 0x4
	// Bit R_RX_FULL.
	I2C0_IC_INTR_STAT_R_RX_FULL = 0x4
	// R_RX_FULL interrupt is inactive
	I2C0_IC_INTR_STAT_R_RX_FULL_INACTIVE = 0x0
	// R_RX_FULL interrupt is active
	I2C0_IC_INTR_STAT_R_RX_FULL_ACTIVE = 0x1
	// Position of R_RX_OVER field.
	I2C0_IC_INTR_STAT_R_RX_OVER_Pos = 0x1
	// Bit mask of R_RX_OVER field.
	I2C0_IC_INTR_STAT_R_RX_OVER_Msk = 0x2
	// Bit R_RX_OVER.
	I2C0_IC_INTR_STAT_R_RX_OVER = 0x2
	// R_RX_OVER interrupt is inactive
	I2C0_IC_INTR_STAT_R_RX_OVER_INACTIVE = 0x0
	// R_RX_OVER interrupt is active
	I2C0_IC_INTR_STAT_R_RX_OVER_ACTIVE = 0x1
	// Position of R_RX_UNDER field.
	I2C0_IC_INTR_STAT_R_RX_UNDER_Pos = 0x0
	// Bit mask of R_RX_UNDER field.
	I2C0_IC_INTR_STAT_R_RX_UNDER_Msk = 0x1
	// Bit R_RX_UNDER.
	I2C0_IC_INTR_STAT_R_RX_UNDER = 0x1
	// RX_UNDER interrupt is inactive
	I2C0_IC_INTR_STAT_R_RX_UNDER_INACTIVE = 0x0
	// RX_UNDER interrupt is active
	I2C0_IC_INTR_STAT_R_RX_UNDER_ACTIVE = 0x1

	// IC_INTR_MASK
	// I2C Interrupt Mask Register.\n
	// These bits mask their corresponding interrupt status bits. This register is active low; a value of 0 masks the interrupt, whereas a value of 1 unmasks the interrupt.
	// Position of M_MASTER_ON_HOLD_READ_ONLY field.
	I2C0_IC_INTR_MASK_M_MASTER_ON_HOLD_READ_ONLY_Pos = 0xd
	// Bit mask of M_MASTER_ON_HOLD_READ_ONLY field.
	I2C0_IC_INTR_MASK_M_MASTER_ON_HOLD_READ_ONLY_Msk = 0x2000
	// Bit M_MASTER_ON_HOLD_READ_ONLY.
	I2C0_IC_INTR_MASK_M_MASTER_ON_HOLD_READ_ONLY = 0x2000
	// MASTER_ON_HOLD interrupt is masked
	I2C0_IC_INTR_MASK_M_MASTER_ON_HOLD_READ_ONLY_ENABLED = 0x0
	// MASTER_ON_HOLD interrupt is unmasked
	I2C0_IC_INTR_MASK_M_MASTER_ON_HOLD_READ_ONLY_DISABLED = 0x1
	// Position of M_RESTART_DET field.
	I2C0_IC_INTR_MASK_M_RESTART_DET_Pos = 0xc
	// Bit mask of M_RESTART_DET field.
	I2C0_IC_INTR_MASK_M_RESTART_DET_Msk = 0x1000
	// Bit M_RESTART_DET.
	I2C0_IC_INTR_MASK_M_RESTART_DET = 0x1000
	// RESTART_DET interrupt is masked
	I2C0_IC_INTR_MASK_M_RESTART_DET_ENABLED = 0x0
	// RESTART_DET interrupt is unmasked
	I2C0_IC_INTR_MASK_M_RESTART_DET_DISABLED = 0x1
	// Position of M_GEN_CALL field.
	I2C0_IC_INTR_MASK_M_GEN_CALL_Pos = 0xb
	// Bit mask of M_GEN_CALL field.
	I2C0_IC_INTR_MASK_M_GEN_CALL_Msk = 0x800
	// Bit M_GEN_CALL.
	I2C0_IC_INTR_MASK_M_GEN_CALL = 0x800
	// GEN_CALL interrupt is masked
	I2C0_IC_INTR_MASK_M_GEN_CALL_ENABLED = 0x0
	// GEN_CALL interrupt is unmasked
	I2C0_IC_INTR_MASK_M_GEN_CALL_DISABLED = 0x1
	// Position of M_START_DET field.
	I2C0_IC_INTR_MASK_M_START_DET_Pos = 0xa
	// Bit mask of M_START_DET field.
	I2C0_IC_INTR_MASK_M_START_DET_Msk = 0x400
	// Bit M_START_DET.
	I2C0_IC_INTR_MASK_M_START_DET = 0x400
	// START_DET interrupt is masked
	I2C0_IC_INTR_MASK_M_START_DET_ENABLED = 0x0
	// START_DET interrupt is unmasked
	I2C0_IC_INTR_MASK_M_START_DET_DISABLED = 0x1
	// Position of M_STOP_DET field.
	I2C0_IC_INTR_MASK_M_STOP_DET_Pos = 0x9
	// Bit mask of M_STOP_DET field.
	I2C0_IC_INTR_MASK_M_STOP_DET_Msk = 0x200
	// Bit M_STOP_DET.
	I2C0_IC_INTR_MASK_M_STOP_DET = 0x200
	// STOP_DET interrupt is masked
	I2C0_IC_INTR_MASK_M_STOP_DET_ENABLED = 0x0
	// STOP_DET interrupt is unmasked
	I2C0_IC_INTR_MASK_M_STOP_DET_DISABLED = 0x1
	// Position of M_ACTIVITY field.
	I2C0_IC_INTR_MASK_M_ACTIVITY_Pos = 0x8
	// Bit mask of M_ACTIVITY field.
	I2C0_IC_INTR_MASK_M_ACTIVITY_Msk = 0x100
	// Bit M_ACTIVITY.
	I2C0_IC_INTR_MASK_M_ACTIVITY = 0x100
	// ACTIVITY interrupt is masked
	I2C0_IC_INTR_MASK_M_ACTIVITY_ENABLED = 0x0
	// ACTIVITY interrupt is unmasked
	I2C0_IC_INTR_MASK_M_ACTIVITY_DISABLED = 0x1
	// Position of M_RX_DONE field.
	I2C0_IC_INTR_MASK_M_RX_DONE_Pos = 0x7
	// Bit mask of M_RX_DONE field.
	I2C0_IC_INTR_MASK_M_RX_DONE_Msk = 0x80
	// Bit M_RX_DONE.
	I2C0_IC_INTR_MASK_M_RX_DONE = 0x80
	// RX_DONE interrupt is masked
	I2C0_IC_INTR_MASK_M_RX_DONE_ENABLED = 0x0
	// RX_DONE interrupt is unmasked
	I2C0_IC_INTR_MASK_M_RX_DONE_DISABLED = 0x1
	// Position of M_TX_ABRT field.
	I2C0_IC_INTR_MASK_M_TX_ABRT_Pos = 0x6
	// Bit mask of M_TX_ABRT field.
	I2C0_IC_INTR_MASK_M_TX_ABRT_Msk = 0x40
	// Bit M_TX_ABRT.
	I2C0_IC_INTR_MASK_M_TX_ABRT = 0x40
	// TX_ABORT interrupt is masked
	I2C0_IC_INTR_MASK_M_TX_ABRT_ENABLED = 0x0
	// TX_ABORT interrupt is unmasked
	I2C0_IC_INTR_MASK_M_TX_ABRT_DISABLED = 0x1
	// Position of M_RD_REQ field.
	I2C0_IC_INTR_MASK_M_RD_REQ_Pos = 0x5
	// Bit mask of M_RD_REQ field.
	I2C0_IC_INTR_MASK_M_RD_REQ_Msk = 0x20
	// Bit M_RD_REQ.
	I2C0_IC_INTR_MASK_M_RD_REQ = 0x20
	// RD_REQ interrupt is masked
	I2C0_IC_INTR_MASK_M_RD_REQ_ENABLED = 0x0
	// RD_REQ interrupt is unmasked
	I2C0_IC_INTR_MASK_M_RD_REQ_DISABLED = 0x1
	// Position of M_TX_EMPTY field.
	I2C0_IC_INTR_MASK_M_TX_EMPTY_Pos = 0x4
	// Bit mask of M_TX_EMPTY field.
	I2C0_IC_INTR_MASK_M_TX_EMPTY_Msk = 0x10
	// Bit M_TX_EMPTY.
	I2C0_IC_INTR_MASK_M_TX_EMPTY = 0x10
	// TX_EMPTY interrupt is masked
	I2C0_IC_INTR_MASK_M_TX_EMPTY_ENABLED = 0x0
	// TX_EMPTY interrupt is unmasked
	I2C0_IC_INTR_MASK_M_TX_EMPTY_DISABLED = 0x1
	// Position of M_TX_OVER field.
	I2C0_IC_INTR_MASK_M_TX_OVER_Pos = 0x3
	// Bit mask of M_TX_OVER field.
	I2C0_IC_INTR_MASK_M_TX_OVER_Msk = 0x8
	// Bit M_TX_OVER.
	I2C0_IC_INTR_MASK_M_TX_OVER = 0x8
	// TX_OVER interrupt is masked
	I2C0_IC_INTR_MASK_M_TX_OVER_ENABLED = 0x0
	// TX_OVER interrupt is unmasked
	I2C0_IC_INTR_MASK_M_TX_OVER_DISABLED = 0x1
	// Position of M_RX_FULL field.
	I2C0_IC_INTR_MASK_M_RX_FULL_Pos = 0x2
	// Bit mask of M_RX_FULL field.
	I2C0_IC_INTR_MASK_M_RX_FULL_Msk = 0x4
	// Bit M_RX_FULL.
	I2C0_IC_INTR_MASK_M_RX_FULL = 0x4
	// RX_FULL interrupt is masked
	I2C0_IC_INTR_MASK_M_RX_FULL_ENABLED = 0x0
	// RX_FULL interrupt is unmasked
	I2C0_IC_INTR_MASK_M_RX_FULL_DISABLED = 0x1
	// Position of M_RX_OVER field.
	I2C0_IC_INTR_MASK_M_RX_OVER_Pos = 0x1
	// Bit mask of M_RX_OVER field.
	I2C0_IC_INTR_MASK_M_RX_OVER_Msk = 0x2
	// Bit M_RX_OVER.
	I2C0_IC_INTR_MASK_M_RX_OVER = 0x2
	// RX_OVER interrupt is masked
	I2C0_IC_INTR_MASK_M_RX_OVER_ENABLED = 0x0
	// RX_OVER interrupt is unmasked
	I2C0_IC_INTR_MASK_M_RX_OVER_DISABLED = 0x1
	// Position of M_RX_UNDER field.
	I2C0_IC_INTR_MASK_M_RX_UNDER_Pos = 0x0
	// Bit mask of M_RX_UNDER field.
	I2C0_IC_INTR_MASK_M_RX_UNDER_Msk = 0x1
	// Bit M_RX_UNDER.
	I2C0_IC_INTR_MASK_M_RX_UNDER = 0x1
	// RX_UNDER interrupt is masked
	I2C0_IC_INTR_MASK_M_RX_UNDER_ENABLED = 0x0
	// RX_UNDER interrupt is unmasked
	I2C0_IC_INTR_MASK_M_RX_UNDER_DISABLED = 0x1

	// IC_RAW_INTR_STAT
	// I2C Raw Interrupt Status Register\n
	// Unlike the IC_INTR_STAT register, these bits are not masked so they always show the true status of the DW_apb_i2c.
	// Position of MASTER_ON_HOLD field.
	I2C0_IC_RAW_INTR_STAT_MASTER_ON_HOLD_Pos = 0xd
	// Bit mask of MASTER_ON_HOLD field.
	I2C0_IC_RAW_INTR_STAT_MASTER_ON_HOLD_Msk = 0x2000
	// Bit MASTER_ON_HOLD.
	I2C0_IC_RAW_INTR_STAT_MASTER_ON_HOLD = 0x2000
	// MASTER_ON_HOLD interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_MASTER_ON_HOLD_INACTIVE = 0x0
	// MASTER_ON_HOLD interrupt is active
	I2C0_IC_RAW_INTR_STAT_MASTER_ON_HOLD_ACTIVE = 0x1
	// Position of RESTART_DET field.
	I2C0_IC_RAW_INTR_STAT_RESTART_DET_Pos = 0xc
	// Bit mask of RESTART_DET field.
	I2C0_IC_RAW_INTR_STAT_RESTART_DET_Msk = 0x1000
	// Bit RESTART_DET.
	I2C0_IC_RAW_INTR_STAT_RESTART_DET = 0x1000
	// RESTART_DET interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_RESTART_DET_INACTIVE = 0x0
	// RESTART_DET interrupt is active
	I2C0_IC_RAW_INTR_STAT_RESTART_DET_ACTIVE = 0x1
	// Position of GEN_CALL field.
	I2C0_IC_RAW_INTR_STAT_GEN_CALL_Pos = 0xb
	// Bit mask of GEN_CALL field.
	I2C0_IC_RAW_INTR_STAT_GEN_CALL_Msk = 0x800
	// Bit GEN_CALL.
	I2C0_IC_RAW_INTR_STAT_GEN_CALL = 0x800
	// GEN_CALL interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_GEN_CALL_INACTIVE = 0x0
	// GEN_CALL interrupt is active
	I2C0_IC_RAW_INTR_STAT_GEN_CALL_ACTIVE = 0x1
	// Position of START_DET field.
	I2C0_IC_RAW_INTR_STAT_START_DET_Pos = 0xa
	// Bit mask of START_DET field.
	I2C0_IC_RAW_INTR_STAT_START_DET_Msk = 0x400
	// Bit START_DET.
	I2C0_IC_RAW_INTR_STAT_START_DET = 0x400
	// START_DET interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_START_DET_INACTIVE = 0x0
	// START_DET interrupt is active
	I2C0_IC_RAW_INTR_STAT_START_DET_ACTIVE = 0x1
	// Position of STOP_DET field.
	I2C0_IC_RAW_INTR_STAT_STOP_DET_Pos = 0x9
	// Bit mask of STOP_DET field.
	I2C0_IC_RAW_INTR_STAT_STOP_DET_Msk = 0x200
	// Bit STOP_DET.
	I2C0_IC_RAW_INTR_STAT_STOP_DET = 0x200
	// STOP_DET interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_STOP_DET_INACTIVE = 0x0
	// STOP_DET interrupt is active
	I2C0_IC_RAW_INTR_STAT_STOP_DET_ACTIVE = 0x1
	// Position of ACTIVITY field.
	I2C0_IC_RAW_INTR_STAT_ACTIVITY_Pos = 0x8
	// Bit mask of ACTIVITY field.
	I2C0_IC_RAW_INTR_STAT_ACTIVITY_Msk = 0x100
	// Bit ACTIVITY.
	I2C0_IC_RAW_INTR_STAT_ACTIVITY = 0x100
	// RAW_INTR_ACTIVITY interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_ACTIVITY_INACTIVE = 0x0
	// RAW_INTR_ACTIVITY interrupt is active
	I2C0_IC_RAW_INTR_STAT_ACTIVITY_ACTIVE = 0x1
	// Position of RX_DONE field.
	I2C0_IC_RAW_INTR_STAT_RX_DONE_Pos = 0x7
	// Bit mask of RX_DONE field.
	I2C0_IC_RAW_INTR_STAT_RX_DONE_Msk = 0x80
	// Bit RX_DONE.
	I2C0_IC_RAW_INTR_STAT_RX_DONE = 0x80
	// RX_DONE interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_RX_DONE_INACTIVE = 0x0
	// RX_DONE interrupt is active
	I2C0_IC_RAW_INTR_STAT_RX_DONE_ACTIVE = 0x1
	// Position of TX_ABRT field.
	I2C0_IC_RAW_INTR_STAT_TX_ABRT_Pos = 0x6
	// Bit mask of TX_ABRT field.
	I2C0_IC_RAW_INTR_STAT_TX_ABRT_Msk = 0x40
	// Bit TX_ABRT.
	I2C0_IC_RAW_INTR_STAT_TX_ABRT = 0x40
	// TX_ABRT interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_TX_ABRT_INACTIVE = 0x0
	// TX_ABRT interrupt is active
	I2C0_IC_RAW_INTR_STAT_TX_ABRT_ACTIVE = 0x1
	// Position of RD_REQ field.
	I2C0_IC_RAW_INTR_STAT_RD_REQ_Pos = 0x5
	// Bit mask of RD_REQ field.
	I2C0_IC_RAW_INTR_STAT_RD_REQ_Msk = 0x20
	// Bit RD_REQ.
	I2C0_IC_RAW_INTR_STAT_RD_REQ = 0x20
	// RD_REQ interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_RD_REQ_INACTIVE = 0x0
	// RD_REQ interrupt is active
	I2C0_IC_RAW_INTR_STAT_RD_REQ_ACTIVE = 0x1
	// Position of TX_EMPTY field.
	I2C0_IC_RAW_INTR_STAT_TX_EMPTY_Pos = 0x4
	// Bit mask of TX_EMPTY field.
	I2C0_IC_RAW_INTR_STAT_TX_EMPTY_Msk = 0x10
	// Bit TX_EMPTY.
	I2C0_IC_RAW_INTR_STAT_TX_EMPTY = 0x10
	// TX_EMPTY interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_TX_EMPTY_INACTIVE = 0x0
	// TX_EMPTY interrupt is active
	I2C0_IC_RAW_INTR_STAT_TX_EMPTY_ACTIVE = 0x1
	// Position of TX_OVER field.
	I2C0_IC_RAW_INTR_STAT_TX_OVER_Pos = 0x3
	// Bit mask of TX_OVER field.
	I2C0_IC_RAW_INTR_STAT_TX_OVER_Msk = 0x8
	// Bit TX_OVER.
	I2C0_IC_RAW_INTR_STAT_TX_OVER = 0x8
	// TX_OVER interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_TX_OVER_INACTIVE = 0x0
	// TX_OVER interrupt is active
	I2C0_IC_RAW_INTR_STAT_TX_OVER_ACTIVE = 0x1
	// Position of RX_FULL field.
	I2C0_IC_RAW_INTR_STAT_RX_FULL_Pos = 0x2
	// Bit mask of RX_FULL field.
	I2C0_IC_RAW_INTR_STAT_RX_FULL_Msk = 0x4
	// Bit RX_FULL.
	I2C0_IC_RAW_INTR_STAT_RX_FULL = 0x4
	// RX_FULL interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_RX_FULL_INACTIVE = 0x0
	// RX_FULL interrupt is active
	I2C0_IC_RAW_INTR_STAT_RX_FULL_ACTIVE = 0x1
	// Position of RX_OVER field.
	I2C0_IC_RAW_INTR_STAT_RX_OVER_Pos = 0x1
	// Bit mask of RX_OVER field.
	I2C0_IC_RAW_INTR_STAT_RX_OVER_Msk = 0x2
	// Bit RX_OVER.
	I2C0_IC_RAW_INTR_STAT_RX_OVER = 0x2
	// RX_OVER interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_RX_OVER_INACTIVE = 0x0
	// RX_OVER interrupt is active
	I2C0_IC_RAW_INTR_STAT_RX_OVER_ACTIVE = 0x1
	// Position of RX_UNDER field.
	I2C0_IC_RAW_INTR_STAT_RX_UNDER_Pos = 0x0
	// Bit mask of RX_UNDER field.
	I2C0_IC_RAW_INTR_STAT_RX_UNDER_Msk = 0x1
	// Bit RX_UNDER.
	I2C0_IC_RAW_INTR_STAT_RX_UNDER = 0x1
	// RX_UNDER interrupt is inactive
	I2C0_IC_RAW_INTR_STAT_RX_UNDER_INACTIVE = 0x0
	// RX_UNDER interrupt is active
	I2C0_IC_RAW_INTR_STAT_RX_UNDER_ACTIVE = 0x1

	// IC_RX_TL: I2C Receive FIFO Threshold Register
	// Position of RX_TL field.
	I2C0_IC_RX_TL_RX_TL_Pos = 0x0
	// Bit mask of RX_TL field.
	I2C0_IC_RX_TL_RX_TL_Msk = 0xff

	// IC_TX_TL: I2C Transmit FIFO Threshold Register
	// Position of TX_TL field.
	I2C0_IC_TX_TL_TX_TL_Pos = 0x0
	// Bit mask of TX_TL field.
	I2C0_IC_TX_TL_TX_TL_Msk = 0xff

	// IC_CLR_INTR: Clear Combined and Individual Interrupt Register
	// Position of CLR_INTR field.
	I2C0_IC_CLR_INTR_CLR_INTR_Pos = 0x0
	// Bit mask of CLR_INTR field.
	I2C0_IC_CLR_INTR_CLR_INTR_Msk = 0x1
	// Bit CLR_INTR.
	I2C0_IC_CLR_INTR_CLR_INTR = 0x1

	// IC_CLR_RX_UNDER: Clear RX_UNDER Interrupt Register
	// Position of CLR_RX_UNDER field.
	I2C0_IC_CLR_RX_UNDER_CLR_RX_UNDER_Pos = 0x0
	// Bit mask of CLR_RX_UNDER field.
	I2C0_IC_CLR_RX_UNDER_CLR_RX_UNDER_Msk = 0x1
	// Bit CLR_RX_UNDER.
	I2C0_IC_CLR_RX_UNDER_CLR_RX_UNDER = 0x1

	// IC_CLR_RX_OVER: Clear RX_OVER Interrupt Register
	// Position of CLR_RX_OVER field.
	I2C0_IC_CLR_RX_OVER_CLR_RX_OVER_Pos = 0x0
	// Bit mask of CLR_RX_OVER field.
	I2C0_IC_CLR_RX_OVER_CLR_RX_OVER_Msk = 0x1
	// Bit CLR_RX_OVER.
	I2C0_IC_CLR_RX_OVER_CLR_RX_OVER = 0x1

	// IC_CLR_TX_OVER: Clear TX_OVER Interrupt Register
	// Position of CLR_TX_OVER field.
	I2C0_IC_CLR_TX_OVER_CLR_TX_OVER_Pos = 0x0
	// Bit mask of CLR_TX_OVER field.
	I2C0_IC_CLR_TX_OVER_CLR_TX_OVER_Msk = 0x1
	// Bit CLR_TX_OVER.
	I2C0_IC_CLR_TX_OVER_CLR_TX_OVER = 0x1

	// IC_CLR_RD_REQ: Clear RD_REQ Interrupt Register
	// Position of CLR_RD_REQ field.
	I2C0_IC_CLR_RD_REQ_CLR_RD_REQ_Pos = 0x0
	// Bit mask of CLR_RD_REQ field.
	I2C0_IC_CLR_RD_REQ_CLR_RD_REQ_Msk = 0x1
	// Bit CLR_RD_REQ.
	I2C0_IC_CLR_RD_REQ_CLR_RD_REQ = 0x1

	// IC_CLR_TX_ABRT: Clear TX_ABRT Interrupt Register
	// Position of CLR_TX_ABRT field.
	I2C0_IC_CLR_TX_ABRT_CLR_TX_ABRT_Pos = 0x0
	// Bit mask of CLR_TX_ABRT field.
	I2C0_IC_CLR_TX_ABRT_CLR_TX_ABRT_Msk = 0x1
	// Bit CLR_TX_ABRT.
	I2C0_IC_CLR_TX_ABRT_CLR_TX_ABRT = 0x1

	// IC_CLR_RX_DONE: Clear RX_DONE Interrupt Register
	// Position of CLR_RX_DONE field.
	I2C0_IC_CLR_RX_DONE_CLR_RX_DONE_Pos = 0x0
	// Bit mask of CLR_RX_DONE field.
	I2C0_IC_CLR_RX_DONE_CLR_RX_DONE_Msk = 0x1
	// Bit CLR_RX_DONE.
	I2C0_IC_CLR_RX_DONE_CLR_RX_DONE = 0x1

	// IC_CLR_ACTIVITY: Clear ACTIVITY Interrupt Register
	// Position of CLR_ACTIVITY field.
	I2C0_IC_CLR_ACTIVITY_CLR_ACTIVITY_Pos = 0x0
	// Bit mask of CLR_ACTIVITY field.
	I2C0_IC_CLR_ACTIVITY_CLR_ACTIVITY_Msk = 0x1
	// Bit CLR_ACTIVITY.
	I2C0_IC_CLR_ACTIVITY_CLR_ACTIVITY = 0x1

	// IC_CLR_STOP_DET: Clear STOP_DET Interrupt Register
	// Position of CLR_STOP_DET field.
	I2C0_IC_CLR_STOP_DET_CLR_STOP_DET_Pos = 0x0
	// Bit mask of CLR_STOP_DET field.
	I2C0_IC_CLR_STOP_DET_CLR_STOP_DET_Msk = 0x1
	// Bit CLR_STOP_DET.
	I2C0_IC_CLR_STOP_DET_CLR_STOP_DET = 0x1

	// IC_CLR_START_DET: Clear START_DET Interrupt Register
	// Position of CLR_START_DET field.
	I2C0_IC_CLR_START_DET_CLR_START_DET_Pos = 0x0
	// Bit mask of CLR_START_DET field.
	I2C0_IC_CLR_START_DET_CLR_START_DET_Msk = 0x1
	// Bit CLR_START_DET.
	I2C0_IC_CLR_START_DET_CLR_START_DET = 0x1

	// IC_CLR_GEN_CALL: Clear GEN_CALL Interrupt Register
	// Position of CLR_GEN_CALL field.
	I2C0_IC_CLR_GEN_CALL_CLR_GEN_CALL_Pos = 0x0
	// Bit mask of CLR_GEN_CALL field.
	I2C0_IC_CLR_GEN_CALL_CLR_GEN_CALL_Msk = 0x1
	// Bit CLR_GEN_CALL.
	I2C0_IC_CLR_GEN_CALL_CLR_GEN_CALL = 0x1

	// IC_ENABLE: I2C Enable Register
	// Position of TX_CMD_BLOCK field.
	I2C0_IC_ENABLE_TX_CMD_BLOCK_Pos = 0x2
	// Bit mask of TX_CMD_BLOCK field.
	I2C0_IC_ENABLE_TX_CMD_BLOCK_Msk = 0x4
	// Bit TX_CMD_BLOCK.
	I2C0_IC_ENABLE_TX_CMD_BLOCK = 0x4
	// Tx Command execution not blocked
	I2C0_IC_ENABLE_TX_CMD_BLOCK_NOT_BLOCKED = 0x0
	// Tx Command execution blocked
	I2C0_IC_ENABLE_TX_CMD_BLOCK_BLOCKED = 0x1
	// Position of ABORT field.
	I2C0_IC_ENABLE_ABORT_Pos = 0x1
	// Bit mask of ABORT field.
	I2C0_IC_ENABLE_ABORT_Msk = 0x2
	// Bit ABORT.
	I2C0_IC_ENABLE_ABORT = 0x2
	// ABORT operation not in progress
	I2C0_IC_ENABLE_ABORT_DISABLE = 0x0
	// ABORT operation in progress
	I2C0_IC_ENABLE_ABORT_ENABLED = 0x1
	// Position of ENABLE field.
	I2C0_IC_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	I2C0_IC_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	I2C0_IC_ENABLE_ENABLE = 0x1
	// I2C is disabled
	I2C0_IC_ENABLE_ENABLE_DISABLED = 0x0
	// I2C is enabled
	I2C0_IC_ENABLE_ENABLE_ENABLED = 0x1

	// IC_STATUS
	// I2C Status Register\n
	// This is a read-only register used to indicate the current transfer status and FIFO status. The status register may be read at any time. None of the bits in this register request an interrupt.\n
	// When the I2C is disabled by writing 0 in bit 0 of the IC_ENABLE register: - Bits 1 and 2 are set to 1 - Bits 3 and 10 are set to 0 When the master or slave state machines goes to idle and ic_en=0: - Bits 5 and 6 are set to 0
	// Position of SLV_ACTIVITY field.
	I2C0_IC_STATUS_SLV_ACTIVITY_Pos = 0x6
	// Bit mask of SLV_ACTIVITY field.
	I2C0_IC_STATUS_SLV_ACTIVITY_Msk = 0x40
	// Bit SLV_ACTIVITY.
	I2C0_IC_STATUS_SLV_ACTIVITY = 0x40
	// Slave is idle
	I2C0_IC_STATUS_SLV_ACTIVITY_IDLE = 0x0
	// Slave not idle
	I2C0_IC_STATUS_SLV_ACTIVITY_ACTIVE = 0x1
	// Position of MST_ACTIVITY field.
	I2C0_IC_STATUS_MST_ACTIVITY_Pos = 0x5
	// Bit mask of MST_ACTIVITY field.
	I2C0_IC_STATUS_MST_ACTIVITY_Msk = 0x20
	// Bit MST_ACTIVITY.
	I2C0_IC_STATUS_MST_ACTIVITY = 0x20
	// Master is idle
	I2C0_IC_STATUS_MST_ACTIVITY_IDLE = 0x0
	// Master not idle
	I2C0_IC_STATUS_MST_ACTIVITY_ACTIVE = 0x1
	// Position of RFF field.
	I2C0_IC_STATUS_RFF_Pos = 0x4
	// Bit mask of RFF field.
	I2C0_IC_STATUS_RFF_Msk = 0x10
	// Bit RFF.
	I2C0_IC_STATUS_RFF = 0x10
	// Rx FIFO not full
	I2C0_IC_STATUS_RFF_NOT_FULL = 0x0
	// Rx FIFO is full
	I2C0_IC_STATUS_RFF_FULL = 0x1
	// Position of RFNE field.
	I2C0_IC_STATUS_RFNE_Pos = 0x3
	// Bit mask of RFNE field.
	I2C0_IC_STATUS_RFNE_Msk = 0x8
	// Bit RFNE.
	I2C0_IC_STATUS_RFNE = 0x8
	// Rx FIFO is empty
	I2C0_IC_STATUS_RFNE_EMPTY = 0x0
	// Rx FIFO not empty
	I2C0_IC_STATUS_RFNE_NOT_EMPTY = 0x1
	// Position of TFE field.
	I2C0_IC_STATUS_TFE_Pos = 0x2
	// Bit mask of TFE field.
	I2C0_IC_STATUS_TFE_Msk = 0x4
	// Bit TFE.
	I2C0_IC_STATUS_TFE = 0x4
	// Tx FIFO not empty
	I2C0_IC_STATUS_TFE_NON_EMPTY = 0x0
	// Tx FIFO is empty
	I2C0_IC_STATUS_TFE_EMPTY = 0x1
	// Position of TFNF field.
	I2C0_IC_STATUS_TFNF_Pos = 0x1
	// Bit mask of TFNF field.
	I2C0_IC_STATUS_TFNF_Msk = 0x2
	// Bit TFNF.
	I2C0_IC_STATUS_TFNF = 0x2
	// Tx FIFO is full
	I2C0_IC_STATUS_TFNF_FULL = 0x0
	// Tx FIFO not full
	I2C0_IC_STATUS_TFNF_NOT_FULL = 0x1
	// Position of ACTIVITY field.
	I2C0_IC_STATUS_ACTIVITY_Pos = 0x0
	// Bit mask of ACTIVITY field.
	I2C0_IC_STATUS_ACTIVITY_Msk = 0x1
	// Bit ACTIVITY.
	I2C0_IC_STATUS_ACTIVITY = 0x1
	// I2C is idle
	I2C0_IC_STATUS_ACTIVITY_INACTIVE = 0x0
	// I2C is active
	I2C0_IC_STATUS_ACTIVITY_ACTIVE = 0x1

	// IC_TXFLR: I2C Transmit FIFO Level Register This register contains the number of valid data entries in the transmit FIFO buffer. It is cleared whenever: - The I2C is disabled - There is a transmit abort - that is, TX_ABRT bit is set in the IC_RAW_INTR_STAT register - The slave bulk transmit mode is aborted The register increments whenever data is placed into the transmit FIFO and decrements when data is taken from the transmit FIFO.
	// Position of TXFLR field.
	I2C0_IC_TXFLR_TXFLR_Pos = 0x0
	// Bit mask of TXFLR field.
	I2C0_IC_TXFLR_TXFLR_Msk = 0x1f

	// IC_RXFLR: I2C Receive FIFO Level Register This register contains the number of valid data entries in the receive FIFO buffer. It is cleared whenever: - The I2C is disabled - Whenever there is a transmit abort caused by any of the events tracked in IC_TX_ABRT_SOURCE The register increments whenever data is placed into the receive FIFO and decrements when data is taken from the receive FIFO.
	// Position of RXFLR field.
	I2C0_IC_RXFLR_RXFLR_Pos = 0x0
	// Bit mask of RXFLR field.
	I2C0_IC_RXFLR_RXFLR_Msk = 0x1f

	// IC_SDA_HOLD
	// I2C SDA Hold Time Length Register\n
	// The bits [15:0] of this register are used to control the hold time of SDA during transmit in both slave and master mode (after SCL goes from HIGH to LOW).\n
	// The bits [23:16] of this register are used to extend the SDA transition (if any) whenever SCL is HIGH in the receiver in either master or slave mode.\n
	// Writes to this register succeed only when IC_ENABLE[0]=0.\n
	// The values in this register are in units of ic_clk period. The value programmed in IC_SDA_TX_HOLD must be greater than the minimum hold time in each mode one cycle in master mode, seven cycles in slave mode for the value to be implemented.\n
	// The programmed SDA hold time during transmit (IC_SDA_TX_HOLD) cannot exceed at any time the duration of the low part of scl. Therefore the programmed value cannot be larger than N_SCL_LOW-2, where N_SCL_LOW is the duration of the low part of the scl period measured in ic_clk cycles.
	// Position of IC_SDA_RX_HOLD field.
	I2C0_IC_SDA_HOLD_IC_SDA_RX_HOLD_Pos = 0x10
	// Bit mask of IC_SDA_RX_HOLD field.
	I2C0_IC_SDA_HOLD_IC_SDA_RX_HOLD_Msk = 0xff0000
	// Position of IC_SDA_TX_HOLD field.
	I2C0_IC_SDA_HOLD_IC_SDA_TX_HOLD_Pos = 0x0
	// Bit mask of IC_SDA_TX_HOLD field.
	I2C0_IC_SDA_HOLD_IC_SDA_TX_HOLD_Msk = 0xffff

	// IC_TX_ABRT_SOURCE
	// I2C Transmit Abort Source Register\n
	// This register has 32 bits that indicate the source of the TX_ABRT bit. Except for Bit 9, this register is cleared whenever the IC_CLR_TX_ABRT register or the IC_CLR_INTR register is read. To clear Bit 9, the source of the ABRT_SBYTE_NORSTRT must be fixed first; RESTART must be enabled (IC_CON[5]=1), the SPECIAL bit must be cleared (IC_TAR[11]), or the GC_OR_START bit must be cleared (IC_TAR[10]).\n
	// Once the source of the ABRT_SBYTE_NORSTRT is fixed, then this bit can be cleared in the same manner as other bits in this register. If the source of the ABRT_SBYTE_NORSTRT is not fixed before attempting to clear this bit, Bit 9 clears for one cycle and is then re-asserted.
	// Position of TX_FLUSH_CNT field.
	I2C0_IC_TX_ABRT_SOURCE_TX_FLUSH_CNT_Pos = 0x17
	// Bit mask of TX_FLUSH_CNT field.
	I2C0_IC_TX_ABRT_SOURCE_TX_FLUSH_CNT_Msk = 0xff800000
	// Position of ABRT_USER_ABRT field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_USER_ABRT_Pos = 0x10
	// Bit mask of ABRT_USER_ABRT field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_USER_ABRT_Msk = 0x10000
	// Bit ABRT_USER_ABRT.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_USER_ABRT = 0x10000
	// Transfer abort detected by master- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_USER_ABRT_ABRT_USER_ABRT_VOID = 0x0
	// Transfer abort detected by master
	I2C0_IC_TX_ABRT_SOURCE_ABRT_USER_ABRT_ABRT_USER_ABRT_GENERATED = 0x1
	// Position of ABRT_SLVRD_INTX field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX_Pos = 0xf
	// Bit mask of ABRT_SLVRD_INTX field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX_Msk = 0x8000
	// Bit ABRT_SLVRD_INTX.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX = 0x8000
	// Slave trying to transmit to remote master in read mode- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX_ABRT_SLVRD_INTX_VOID = 0x0
	// Slave trying to transmit to remote master in read mode
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX_ABRT_SLVRD_INTX_GENERATED = 0x1
	// Position of ABRT_SLV_ARBLOST field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST_Pos = 0xe
	// Bit mask of ABRT_SLV_ARBLOST field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST_Msk = 0x4000
	// Bit ABRT_SLV_ARBLOST.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST = 0x4000
	// Slave lost arbitration to remote master- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST_ABRT_SLV_ARBLOST_VOID = 0x0
	// Slave lost arbitration to remote master
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST_ABRT_SLV_ARBLOST_GENERATED = 0x1
	// Position of ABRT_SLVFLUSH_TXFIFO field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO_Pos = 0xd
	// Bit mask of ABRT_SLVFLUSH_TXFIFO field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO_Msk = 0x2000
	// Bit ABRT_SLVFLUSH_TXFIFO.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO = 0x2000
	// Slave flushes existing data in TX-FIFO upon getting read command- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO_ABRT_SLVFLUSH_TXFIFO_VOID = 0x0
	// Slave flushes existing data in TX-FIFO upon getting read command
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO_ABRT_SLVFLUSH_TXFIFO_GENERATED = 0x1
	// Position of ARB_LOST field.
	I2C0_IC_TX_ABRT_SOURCE_ARB_LOST_Pos = 0xc
	// Bit mask of ARB_LOST field.
	I2C0_IC_TX_ABRT_SOURCE_ARB_LOST_Msk = 0x1000
	// Bit ARB_LOST.
	I2C0_IC_TX_ABRT_SOURCE_ARB_LOST = 0x1000
	// Master or Slave-Transmitter lost arbitration- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ARB_LOST_ABRT_LOST_VOID = 0x0
	// Master or Slave-Transmitter lost arbitration
	I2C0_IC_TX_ABRT_SOURCE_ARB_LOST_ABRT_LOST_GENERATED = 0x1
	// Position of ABRT_MASTER_DIS field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS_Pos = 0xb
	// Bit mask of ABRT_MASTER_DIS field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS_Msk = 0x800
	// Bit ABRT_MASTER_DIS.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS = 0x800
	// User initiating master operation when MASTER disabled- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS_ABRT_MASTER_DIS_VOID = 0x0
	// User initiating master operation when MASTER disabled
	I2C0_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS_ABRT_MASTER_DIS_GENERATED = 0x1
	// Position of ABRT_10B_RD_NORSTRT field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT_Pos = 0xa
	// Bit mask of ABRT_10B_RD_NORSTRT field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT_Msk = 0x400
	// Bit ABRT_10B_RD_NORSTRT.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT = 0x400
	// Master not trying to read in 10Bit addressing mode when RESTART disabled
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT_ABRT_10B_RD_VOID = 0x0
	// Master trying to read in 10Bit addressing mode when RESTART disabled
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT_ABRT_10B_RD_GENERATED = 0x1
	// Position of ABRT_SBYTE_NORSTRT field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT_Pos = 0x9
	// Bit mask of ABRT_SBYTE_NORSTRT field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT_Msk = 0x200
	// Bit ABRT_SBYTE_NORSTRT.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT = 0x200
	// User trying to send START byte when RESTART disabled- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT_ABRT_SBYTE_NORSTRT_VOID = 0x0
	// User trying to send START byte when RESTART disabled
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT_ABRT_SBYTE_NORSTRT_GENERATED = 0x1
	// Position of ABRT_HS_NORSTRT field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT_Pos = 0x8
	// Bit mask of ABRT_HS_NORSTRT field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT_Msk = 0x100
	// Bit ABRT_HS_NORSTRT.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT = 0x100
	// User trying to switch Master to HS mode when RESTART disabled- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT_ABRT_HS_NORSTRT_VOID = 0x0
	// User trying to switch Master to HS mode when RESTART disabled
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT_ABRT_HS_NORSTRT_GENERATED = 0x1
	// Position of ABRT_SBYTE_ACKDET field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET_Pos = 0x7
	// Bit mask of ABRT_SBYTE_ACKDET field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET_Msk = 0x80
	// Bit ABRT_SBYTE_ACKDET.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET = 0x80
	// ACK detected for START byte- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET_ABRT_SBYTE_ACKDET_VOID = 0x0
	// ACK detected for START byte
	I2C0_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET_ABRT_SBYTE_ACKDET_GENERATED = 0x1
	// Position of ABRT_HS_ACKDET field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET_Pos = 0x6
	// Bit mask of ABRT_HS_ACKDET field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET_Msk = 0x40
	// Bit ABRT_HS_ACKDET.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET = 0x40
	// HS Master code ACKed in HS Mode- scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET_ABRT_HS_ACK_VOID = 0x0
	// HS Master code ACKed in HS Mode
	I2C0_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET_ABRT_HS_ACK_GENERATED = 0x1
	// Position of ABRT_GCALL_READ field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ_Pos = 0x5
	// Bit mask of ABRT_GCALL_READ field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ_Msk = 0x20
	// Bit ABRT_GCALL_READ.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ = 0x20
	// GCALL is followed by read from bus-scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ_ABRT_GCALL_READ_VOID = 0x0
	// GCALL is followed by read from bus
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ_ABRT_GCALL_READ_GENERATED = 0x1
	// Position of ABRT_GCALL_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK_Pos = 0x4
	// Bit mask of ABRT_GCALL_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK_Msk = 0x10
	// Bit ABRT_GCALL_NOACK.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK = 0x10
	// GCALL not ACKed by any slave-scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK_ABRT_GCALL_NOACK_VOID = 0x0
	// GCALL not ACKed by any slave
	I2C0_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK_ABRT_GCALL_NOACK_GENERATED = 0x1
	// Position of ABRT_TXDATA_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK_Pos = 0x3
	// Bit mask of ABRT_TXDATA_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK_Msk = 0x8
	// Bit ABRT_TXDATA_NOACK.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK = 0x8
	// Transmitted data non-ACKed by addressed slave-scenario not present
	I2C0_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK_ABRT_TXDATA_NOACK_VOID = 0x0
	// Transmitted data not ACKed by addressed slave
	I2C0_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK_ABRT_TXDATA_NOACK_GENERATED = 0x1
	// Position of ABRT_10ADDR2_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK_Pos = 0x2
	// Bit mask of ABRT_10ADDR2_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK_Msk = 0x4
	// Bit ABRT_10ADDR2_NOACK.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK = 0x4
	// This abort is not generated
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK_INACTIVE = 0x0
	// Byte 2 of 10Bit Address not ACKed by any slave
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK_ACTIVE = 0x1
	// Position of ABRT_10ADDR1_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK_Pos = 0x1
	// Bit mask of ABRT_10ADDR1_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK_Msk = 0x2
	// Bit ABRT_10ADDR1_NOACK.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK = 0x2
	// This abort is not generated
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK_INACTIVE = 0x0
	// Byte 1 of 10Bit Address not ACKed by any slave
	I2C0_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK_ACTIVE = 0x1
	// Position of ABRT_7B_ADDR_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK_Pos = 0x0
	// Bit mask of ABRT_7B_ADDR_NOACK field.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK_Msk = 0x1
	// Bit ABRT_7B_ADDR_NOACK.
	I2C0_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK = 0x1
	// This abort is not generated
	I2C0_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK_INACTIVE = 0x0
	// This abort is generated because of NOACK for 7-bit address
	I2C0_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK_ACTIVE = 0x1

	// IC_SLV_DATA_NACK_ONLY
	// Generate Slave Data NACK Register\n
	// The register is used to generate a NACK for the data part of a transfer when DW_apb_i2c is acting as a slave-receiver. This register only exists when the IC_SLV_DATA_NACK_ONLY parameter is set to 1. When this parameter disabled, this register does not exist and writing to the register's address has no effect.\n
	// A write can occur on this register if both of the following conditions are met: - DW_apb_i2c is disabled (IC_ENABLE[0] = 0) - Slave part is inactive (IC_STATUS[6] = 0) Note: The IC_STATUS[6] is a register read-back location for the internal slv_activity signal; the user should poll this before writing the ic_slv_data_nack_only bit.
	// Position of NACK field.
	I2C0_IC_SLV_DATA_NACK_ONLY_NACK_Pos = 0x0
	// Bit mask of NACK field.
	I2C0_IC_SLV_DATA_NACK_ONLY_NACK_Msk = 0x1
	// Bit NACK.
	I2C0_IC_SLV_DATA_NACK_ONLY_NACK = 0x1
	// Slave receiver generates NACK normally
	I2C0_IC_SLV_DATA_NACK_ONLY_NACK_DISABLED = 0x0
	// Slave receiver generates NACK upon data reception only
	I2C0_IC_SLV_DATA_NACK_ONLY_NACK_ENABLED = 0x1

	// IC_DMA_CR
	// DMA Control Register\n
	// The register is used to enable the DMA Controller interface operation. There is a separate bit for transmit and receive. This can be programmed regardless of the state of IC_ENABLE.
	// Position of TDMAE field.
	I2C0_IC_DMA_CR_TDMAE_Pos = 0x1
	// Bit mask of TDMAE field.
	I2C0_IC_DMA_CR_TDMAE_Msk = 0x2
	// Bit TDMAE.
	I2C0_IC_DMA_CR_TDMAE = 0x2
	// transmit FIFO DMA channel disabled
	I2C0_IC_DMA_CR_TDMAE_DISABLED = 0x0
	// Transmit FIFO DMA channel enabled
	I2C0_IC_DMA_CR_TDMAE_ENABLED = 0x1
	// Position of RDMAE field.
	I2C0_IC_DMA_CR_RDMAE_Pos = 0x0
	// Bit mask of RDMAE field.
	I2C0_IC_DMA_CR_RDMAE_Msk = 0x1
	// Bit RDMAE.
	I2C0_IC_DMA_CR_RDMAE = 0x1
	// Receive FIFO DMA channel disabled
	I2C0_IC_DMA_CR_RDMAE_DISABLED = 0x0
	// Receive FIFO DMA channel enabled
	I2C0_IC_DMA_CR_RDMAE_ENABLED = 0x1

	// IC_DMA_TDLR: DMA Transmit Data Level Register
	// Position of DMATDL field.
	I2C0_IC_DMA_TDLR_DMATDL_Pos = 0x0
	// Bit mask of DMATDL field.
	I2C0_IC_DMA_TDLR_DMATDL_Msk = 0xf

	// IC_DMA_RDLR: I2C Receive Data Level Register
	// Position of DMARDL field.
	I2C0_IC_DMA_RDLR_DMARDL_Pos = 0x0
	// Bit mask of DMARDL field.
	I2C0_IC_DMA_RDLR_DMARDL_Msk = 0xf

	// IC_SDA_SETUP
	// I2C SDA Setup Register\n
	// This register controls the amount of time delay (in terms of number of ic_clk clock periods) introduced in the rising edge of SCL - relative to SDA changing - when DW_apb_i2c services a read request in a slave-transmitter operation. The relevant I2C requirement is tSU:DAT (note 4) as detailed in the I2C Bus Specification. This register must be programmed with a value equal to or greater than 2.\n
	// Writes to this register succeed only when IC_ENABLE[0] = 0.\n
	// Note: The length of setup time is calculated using [(IC_SDA_SETUP - 1) * (ic_clk_period)], so if the user requires 10 ic_clk periods of setup time, they should program a value of 11. The IC_SDA_SETUP register is only used by the DW_apb_i2c when operating as a slave transmitter.
	// Position of SDA_SETUP field.
	I2C0_IC_SDA_SETUP_SDA_SETUP_Pos = 0x0
	// Bit mask of SDA_SETUP field.
	I2C0_IC_SDA_SETUP_SDA_SETUP_Msk = 0xff

	// IC_ACK_GENERAL_CALL
	// I2C ACK General Call Register\n
	// The register controls whether DW_apb_i2c responds with a ACK or NACK when it receives an I2C General Call address.\n
	// This register is applicable only when the DW_apb_i2c is in slave mode.
	// Position of ACK_GEN_CALL field.
	I2C0_IC_ACK_GENERAL_CALL_ACK_GEN_CALL_Pos = 0x0
	// Bit mask of ACK_GEN_CALL field.
	I2C0_IC_ACK_GENERAL_CALL_ACK_GEN_CALL_Msk = 0x1
	// Bit ACK_GEN_CALL.
	I2C0_IC_ACK_GENERAL_CALL_ACK_GEN_CALL = 0x1
	// Generate NACK for a General Call
	I2C0_IC_ACK_GENERAL_CALL_ACK_GEN_CALL_DISABLED = 0x0
	// Generate ACK for a General Call
	I2C0_IC_ACK_GENERAL_CALL_ACK_GEN_CALL_ENABLED = 0x1

	// IC_ENABLE_STATUS
	// I2C Enable Status Register\n
	// The register is used to report the DW_apb_i2c hardware status when the IC_ENABLE[0] register is set from 1 to 0; that is, when DW_apb_i2c is disabled.\n
	// If IC_ENABLE[0] has been set to 1, bits 2:1 are forced to 0, and bit 0 is forced to 1.\n
	// If IC_ENABLE[0] has been set to 0, bits 2:1 is only be valid as soon as bit 0 is read as '0'.\n
	// Note: When IC_ENABLE[0] has been set to 0, a delay occurs for bit 0 to be read as 0 because disabling the DW_apb_i2c depends on I2C bus activities.
	// Position of SLV_RX_DATA_LOST field.
	I2C0_IC_ENABLE_STATUS_SLV_RX_DATA_LOST_Pos = 0x2
	// Bit mask of SLV_RX_DATA_LOST field.
	I2C0_IC_ENABLE_STATUS_SLV_RX_DATA_LOST_Msk = 0x4
	// Bit SLV_RX_DATA_LOST.
	I2C0_IC_ENABLE_STATUS_SLV_RX_DATA_LOST = 0x4
	// Slave RX Data is not lost
	I2C0_IC_ENABLE_STATUS_SLV_RX_DATA_LOST_INACTIVE = 0x0
	// Slave RX Data is lost
	I2C0_IC_ENABLE_STATUS_SLV_RX_DATA_LOST_ACTIVE = 0x1
	// Position of SLV_DISABLED_WHILE_BUSY field.
	I2C0_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY_Pos = 0x1
	// Bit mask of SLV_DISABLED_WHILE_BUSY field.
	I2C0_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY_Msk = 0x2
	// Bit SLV_DISABLED_WHILE_BUSY.
	I2C0_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY = 0x2
	// Slave is disabled when it is idle
	I2C0_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY_INACTIVE = 0x0
	// Slave is disabled when it is active
	I2C0_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY_ACTIVE = 0x1
	// Position of IC_EN field.
	I2C0_IC_ENABLE_STATUS_IC_EN_Pos = 0x0
	// Bit mask of IC_EN field.
	I2C0_IC_ENABLE_STATUS_IC_EN_Msk = 0x1
	// Bit IC_EN.
	I2C0_IC_ENABLE_STATUS_IC_EN = 0x1
	// I2C disabled
	I2C0_IC_ENABLE_STATUS_IC_EN_DISABLED = 0x0
	// I2C enabled
	I2C0_IC_ENABLE_STATUS_IC_EN_ENABLED = 0x1

	// IC_FS_SPKLEN
	// I2C SS, FS or FM+ spike suppression limit\n
	// This register is used to store the duration, measured in ic_clk cycles, of the longest spike that is filtered out by the spike suppression logic when the component is operating in SS, FS or FM+ modes. The relevant I2C requirement is tSP (table 4) as detailed in the I2C Bus Specification. This register must be programmed with a minimum value of 1.
	// Position of IC_FS_SPKLEN field.
	I2C0_IC_FS_SPKLEN_IC_FS_SPKLEN_Pos = 0x0
	// Bit mask of IC_FS_SPKLEN field.
	I2C0_IC_FS_SPKLEN_IC_FS_SPKLEN_Msk = 0xff

	// IC_CLR_RESTART_DET: Clear RESTART_DET Interrupt Register
	// Position of CLR_RESTART_DET field.
	I2C0_IC_CLR_RESTART_DET_CLR_RESTART_DET_Pos = 0x0
	// Bit mask of CLR_RESTART_DET field.
	I2C0_IC_CLR_RESTART_DET_CLR_RESTART_DET_Msk = 0x1
	// Bit CLR_RESTART_DET.
	I2C0_IC_CLR_RESTART_DET_CLR_RESTART_DET = 0x1

	// IC_COMP_PARAM_1
	// Component Parameter Register 1\n
	// Note This register is not implemented and therefore reads as 0. If it was implemented it would be a constant read-only register that contains encoded information about the component's parameter settings. Fields shown below are the settings for those parameters
	// Position of TX_BUFFER_DEPTH field.
	I2C0_IC_COMP_PARAM_1_TX_BUFFER_DEPTH_Pos = 0x10
	// Bit mask of TX_BUFFER_DEPTH field.
	I2C0_IC_COMP_PARAM_1_TX_BUFFER_DEPTH_Msk = 0xff0000
	// Position of RX_BUFFER_DEPTH field.
	I2C0_IC_COMP_PARAM_1_RX_BUFFER_DEPTH_Pos = 0x8
	// Bit mask of RX_BUFFER_DEPTH field.
	I2C0_IC_COMP_PARAM_1_RX_BUFFER_DEPTH_Msk = 0xff00
	// Position of ADD_ENCODED_PARAMS field.
	I2C0_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS_Pos = 0x7
	// Bit mask of ADD_ENCODED_PARAMS field.
	I2C0_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS_Msk = 0x80
	// Bit ADD_ENCODED_PARAMS.
	I2C0_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS = 0x80
	// Position of HAS_DMA field.
	I2C0_IC_COMP_PARAM_1_HAS_DMA_Pos = 0x6
	// Bit mask of HAS_DMA field.
	I2C0_IC_COMP_PARAM_1_HAS_DMA_Msk = 0x40
	// Bit HAS_DMA.
	I2C0_IC_COMP_PARAM_1_HAS_DMA = 0x40
	// Position of INTR_IO field.
	I2C0_IC_COMP_PARAM_1_INTR_IO_Pos = 0x5
	// Bit mask of INTR_IO field.
	I2C0_IC_COMP_PARAM_1_INTR_IO_Msk = 0x20
	// Bit INTR_IO.
	I2C0_IC_COMP_PARAM_1_INTR_IO = 0x20
	// Position of HC_COUNT_VALUES field.
	I2C0_IC_COMP_PARAM_1_HC_COUNT_VALUES_Pos = 0x4
	// Bit mask of HC_COUNT_VALUES field.
	I2C0_IC_COMP_PARAM_1_HC_COUNT_VALUES_Msk = 0x10
	// Bit HC_COUNT_VALUES.
	I2C0_IC_COMP_PARAM_1_HC_COUNT_VALUES = 0x10
	// Position of MAX_SPEED_MODE field.
	I2C0_IC_COMP_PARAM_1_MAX_SPEED_MODE_Pos = 0x2
	// Bit mask of MAX_SPEED_MODE field.
	I2C0_IC_COMP_PARAM_1_MAX_SPEED_MODE_Msk = 0xc
	// Position of APB_DATA_WIDTH field.
	I2C0_IC_COMP_PARAM_1_APB_DATA_WIDTH_Pos = 0x0
	// Bit mask of APB_DATA_WIDTH field.
	I2C0_IC_COMP_PARAM_1_APB_DATA_WIDTH_Msk = 0x3

	// IC_COMP_VERSION: I2C Component Version Register
	// Position of IC_COMP_VERSION field.
	I2C0_IC_COMP_VERSION_IC_COMP_VERSION_Pos = 0x0
	// Bit mask of IC_COMP_VERSION field.
	I2C0_IC_COMP_VERSION_IC_COMP_VERSION_Msk = 0xffffffff

	// IC_COMP_TYPE: I2C Component Type Register
	// Position of IC_COMP_TYPE field.
	I2C0_IC_COMP_TYPE_IC_COMP_TYPE_Pos = 0x0
	// Bit mask of IC_COMP_TYPE field.
	I2C0_IC_COMP_TYPE_IC_COMP_TYPE_Msk = 0xffffffff
)

// Bitfields for ADC: Control and data interface to SAR ADC
const (
	// CS: ADC Control and Status
	// Position of RROBIN field.
	ADC_CS_RROBIN_Pos = 0x10
	// Bit mask of RROBIN field.
	ADC_CS_RROBIN_Msk = 0x1f0000
	// Position of AINSEL field.
	ADC_CS_AINSEL_Pos = 0xc
	// Bit mask of AINSEL field.
	ADC_CS_AINSEL_Msk = 0x7000
	// Position of ERR_STICKY field.
	ADC_CS_ERR_STICKY_Pos = 0xa
	// Bit mask of ERR_STICKY field.
	ADC_CS_ERR_STICKY_Msk = 0x400
	// Bit ERR_STICKY.
	ADC_CS_ERR_STICKY = 0x400
	// Position of ERR field.
	ADC_CS_ERR_Pos = 0x9
	// Bit mask of ERR field.
	ADC_CS_ERR_Msk = 0x200
	// Bit ERR.
	ADC_CS_ERR = 0x200
	// Position of READY field.
	ADC_CS_READY_Pos = 0x8
	// Bit mask of READY field.
	ADC_CS_READY_Msk = 0x100
	// Bit READY.
	ADC_CS_READY = 0x100
	// Position of START_MANY field.
	ADC_CS_START_MANY_Pos = 0x3
	// Bit mask of START_MANY field.
	ADC_CS_START_MANY_Msk = 0x8
	// Bit START_MANY.
	ADC_CS_START_MANY = 0x8
	// Position of START_ONCE field.
	ADC_CS_START_ONCE_Pos = 0x2
	// Bit mask of START_ONCE field.
	ADC_CS_START_ONCE_Msk = 0x4
	// Bit START_ONCE.
	ADC_CS_START_ONCE = 0x4
	// Position of TS_EN field.
	ADC_CS_TS_EN_Pos = 0x1
	// Bit mask of TS_EN field.
	ADC_CS_TS_EN_Msk = 0x2
	// Bit TS_EN.
	ADC_CS_TS_EN = 0x2
	// Position of EN field.
	ADC_CS_EN_Pos = 0x0
	// Bit mask of EN field.
	ADC_CS_EN_Msk = 0x1
	// Bit EN.
	ADC_CS_EN = 0x1

	// RESULT: Result of most recent ADC conversion
	// Position of RESULT field.
	ADC_RESULT_RESULT_Pos = 0x0
	// Bit mask of RESULT field.
	ADC_RESULT_RESULT_Msk = 0xfff

	// FCS: FIFO control and status
	// Position of THRESH field.
	ADC_FCS_THRESH_Pos = 0x18
	// Bit mask of THRESH field.
	ADC_FCS_THRESH_Msk = 0xf000000
	// Position of LEVEL field.
	ADC_FCS_LEVEL_Pos = 0x10
	// Bit mask of LEVEL field.
	ADC_FCS_LEVEL_Msk = 0xf0000
	// Position of OVER field.
	ADC_FCS_OVER_Pos = 0xb
	// Bit mask of OVER field.
	ADC_FCS_OVER_Msk = 0x800
	// Bit OVER.
	ADC_FCS_OVER = 0x800
	// Position of UNDER field.
	ADC_FCS_UNDER_Pos = 0xa
	// Bit mask of UNDER field.
	ADC_FCS_UNDER_Msk = 0x400
	// Bit UNDER.
	ADC_FCS_UNDER = 0x400
	// Position of FULL field.
	ADC_FCS_FULL_Pos = 0x9
	// Bit mask of FULL field.
	ADC_FCS_FULL_Msk = 0x200
	// Bit FULL.
	ADC_FCS_FULL = 0x200
	// Position of EMPTY field.
	ADC_FCS_EMPTY_Pos = 0x8
	// Bit mask of EMPTY field.
	ADC_FCS_EMPTY_Msk = 0x100
	// Bit EMPTY.
	ADC_FCS_EMPTY = 0x100
	// Position of DREQ_EN field.
	ADC_FCS_DREQ_EN_Pos = 0x3
	// Bit mask of DREQ_EN field.
	ADC_FCS_DREQ_EN_Msk = 0x8
	// Bit DREQ_EN.
	ADC_FCS_DREQ_EN = 0x8
	// Position of ERR field.
	ADC_FCS_ERR_Pos = 0x2
	// Bit mask of ERR field.
	ADC_FCS_ERR_Msk = 0x4
	// Bit ERR.
	ADC_FCS_ERR = 0x4
	// Position of SHIFT field.
	ADC_FCS_SHIFT_Pos = 0x1
	// Bit mask of SHIFT field.
	ADC_FCS_SHIFT_Msk = 0x2
	// Bit SHIFT.
	ADC_FCS_SHIFT = 0x2
	// Position of EN field.
	ADC_FCS_EN_Pos = 0x0
	// Bit mask of EN field.
	ADC_FCS_EN_Msk = 0x1
	// Bit EN.
	ADC_FCS_EN = 0x1

	// FIFO: Conversion result FIFO
	// Position of ERR field.
	ADC_FIFO_ERR_Pos = 0xf
	// Bit mask of ERR field.
	ADC_FIFO_ERR_Msk = 0x8000
	// Bit ERR.
	ADC_FIFO_ERR = 0x8000
	// Position of VAL field.
	ADC_FIFO_VAL_Pos = 0x0
	// Bit mask of VAL field.
	ADC_FIFO_VAL_Msk = 0xfff

	// DIV
	// Clock divider. If non-zero, CS_START_MANY will start conversions
	// at regular intervals rather than back-to-back.
	// The divider is reset when either of these fields are written.
	// Total period is 1 + INT + FRAC / 256
	// Position of INT field.
	ADC_DIV_INT_Pos = 0x8
	// Bit mask of INT field.
	ADC_DIV_INT_Msk = 0xffff00
	// Position of FRAC field.
	ADC_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	ADC_DIV_FRAC_Msk = 0xff

	// INTR: Raw Interrupts
	// Position of FIFO field.
	ADC_INTR_FIFO_Pos = 0x0
	// Bit mask of FIFO field.
	ADC_INTR_FIFO_Msk = 0x1
	// Bit FIFO.
	ADC_INTR_FIFO = 0x1

	// INTE: Interrupt Enable
	// Position of FIFO field.
	ADC_INTE_FIFO_Pos = 0x0
	// Bit mask of FIFO field.
	ADC_INTE_FIFO_Msk = 0x1
	// Bit FIFO.
	ADC_INTE_FIFO = 0x1

	// INTF: Interrupt Force
	// Position of FIFO field.
	ADC_INTF_FIFO_Pos = 0x0
	// Bit mask of FIFO field.
	ADC_INTF_FIFO_Msk = 0x1
	// Bit FIFO.
	ADC_INTF_FIFO = 0x1

	// INTS: Interrupt status after masking & forcing
	// Position of FIFO field.
	ADC_INTS_FIFO_Pos = 0x0
	// Bit mask of FIFO field.
	ADC_INTS_FIFO_Msk = 0x1
	// Bit FIFO.
	ADC_INTS_FIFO = 0x1
)

// Bitfields for PWM: Simple PWM
const (
	// CH0_CSR: Control and status register
	// Position of PH_ADV field.
	PWM_CH0_CSR_PH_ADV_Pos = 0x7
	// Bit mask of PH_ADV field.
	PWM_CH0_CSR_PH_ADV_Msk = 0x80
	// Bit PH_ADV.
	PWM_CH0_CSR_PH_ADV = 0x80
	// Position of PH_RET field.
	PWM_CH0_CSR_PH_RET_Pos = 0x6
	// Bit mask of PH_RET field.
	PWM_CH0_CSR_PH_RET_Msk = 0x40
	// Bit PH_RET.
	PWM_CH0_CSR_PH_RET = 0x40
	// Position of DIVMODE field.
	PWM_CH0_CSR_DIVMODE_Pos = 0x4
	// Bit mask of DIVMODE field.
	PWM_CH0_CSR_DIVMODE_Msk = 0x30
	// Free-running counting at rate dictated by fractional divider
	PWM_CH0_CSR_DIVMODE_DIV = 0x0
	// Fractional divider operation is gated by the PWM B pin.
	PWM_CH0_CSR_DIVMODE_LEVEL = 0x1
	// Counter advances with each rising edge of the PWM B pin.
	PWM_CH0_CSR_DIVMODE_RISE = 0x2
	// Counter advances with each falling edge of the PWM B pin.
	PWM_CH0_CSR_DIVMODE_FALL = 0x3
	// Position of B_INV field.
	PWM_CH0_CSR_B_INV_Pos = 0x3
	// Bit mask of B_INV field.
	PWM_CH0_CSR_B_INV_Msk = 0x8
	// Bit B_INV.
	PWM_CH0_CSR_B_INV = 0x8
	// Position of A_INV field.
	PWM_CH0_CSR_A_INV_Pos = 0x2
	// Bit mask of A_INV field.
	PWM_CH0_CSR_A_INV_Msk = 0x4
	// Bit A_INV.
	PWM_CH0_CSR_A_INV = 0x4
	// Position of PH_CORRECT field.
	PWM_CH0_CSR_PH_CORRECT_Pos = 0x1
	// Bit mask of PH_CORRECT field.
	PWM_CH0_CSR_PH_CORRECT_Msk = 0x2
	// Bit PH_CORRECT.
	PWM_CH0_CSR_PH_CORRECT = 0x2
	// Position of EN field.
	PWM_CH0_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	PWM_CH0_CSR_EN_Msk = 0x1
	// Bit EN.
	PWM_CH0_CSR_EN = 0x1

	// CH0_DIV
	// INT and FRAC form a fixed-point fractional number.
	// Counting rate is system clock frequency divided by this number.
	// Fractional division uses simple 1st-order sigma-delta.
	// Position of INT field.
	PWM_CH0_DIV_INT_Pos = 0x4
	// Bit mask of INT field.
	PWM_CH0_DIV_INT_Msk = 0xff0
	// Position of FRAC field.
	PWM_CH0_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	PWM_CH0_DIV_FRAC_Msk = 0xf

	// CH0_CTR: Direct access to the PWM counter
	// Position of CH0_CTR field.
	PWM_CH0_CTR_CH0_CTR_Pos = 0x0
	// Bit mask of CH0_CTR field.
	PWM_CH0_CTR_CH0_CTR_Msk = 0xffff

	// CH0_CC: Counter compare values
	// Position of B field.
	PWM_CH0_CC_B_Pos = 0x10
	// Bit mask of B field.
	PWM_CH0_CC_B_Msk = 0xffff0000
	// Position of A field.
	PWM_CH0_CC_A_Pos = 0x0
	// Bit mask of A field.
	PWM_CH0_CC_A_Msk = 0xffff

	// CH0_TOP: Counter wrap value
	// Position of CH0_TOP field.
	PWM_CH0_TOP_CH0_TOP_Pos = 0x0
	// Bit mask of CH0_TOP field.
	PWM_CH0_TOP_CH0_TOP_Msk = 0xffff

	// CH1_CSR: Control and status register
	// Position of PH_ADV field.
	PWM_CH1_CSR_PH_ADV_Pos = 0x7
	// Bit mask of PH_ADV field.
	PWM_CH1_CSR_PH_ADV_Msk = 0x80
	// Bit PH_ADV.
	PWM_CH1_CSR_PH_ADV = 0x80
	// Position of PH_RET field.
	PWM_CH1_CSR_PH_RET_Pos = 0x6
	// Bit mask of PH_RET field.
	PWM_CH1_CSR_PH_RET_Msk = 0x40
	// Bit PH_RET.
	PWM_CH1_CSR_PH_RET = 0x40
	// Position of DIVMODE field.
	PWM_CH1_CSR_DIVMODE_Pos = 0x4
	// Bit mask of DIVMODE field.
	PWM_CH1_CSR_DIVMODE_Msk = 0x30
	// Free-running counting at rate dictated by fractional divider
	PWM_CH1_CSR_DIVMODE_DIV = 0x0
	// Fractional divider operation is gated by the PWM B pin.
	PWM_CH1_CSR_DIVMODE_LEVEL = 0x1
	// Counter advances with each rising edge of the PWM B pin.
	PWM_CH1_CSR_DIVMODE_RISE = 0x2
	// Counter advances with each falling edge of the PWM B pin.
	PWM_CH1_CSR_DIVMODE_FALL = 0x3
	// Position of B_INV field.
	PWM_CH1_CSR_B_INV_Pos = 0x3
	// Bit mask of B_INV field.
	PWM_CH1_CSR_B_INV_Msk = 0x8
	// Bit B_INV.
	PWM_CH1_CSR_B_INV = 0x8
	// Position of A_INV field.
	PWM_CH1_CSR_A_INV_Pos = 0x2
	// Bit mask of A_INV field.
	PWM_CH1_CSR_A_INV_Msk = 0x4
	// Bit A_INV.
	PWM_CH1_CSR_A_INV = 0x4
	// Position of PH_CORRECT field.
	PWM_CH1_CSR_PH_CORRECT_Pos = 0x1
	// Bit mask of PH_CORRECT field.
	PWM_CH1_CSR_PH_CORRECT_Msk = 0x2
	// Bit PH_CORRECT.
	PWM_CH1_CSR_PH_CORRECT = 0x2
	// Position of EN field.
	PWM_CH1_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	PWM_CH1_CSR_EN_Msk = 0x1
	// Bit EN.
	PWM_CH1_CSR_EN = 0x1

	// CH1_DIV
	// INT and FRAC form a fixed-point fractional number.
	// Counting rate is system clock frequency divided by this number.
	// Fractional division uses simple 1st-order sigma-delta.
	// Position of INT field.
	PWM_CH1_DIV_INT_Pos = 0x4
	// Bit mask of INT field.
	PWM_CH1_DIV_INT_Msk = 0xff0
	// Position of FRAC field.
	PWM_CH1_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	PWM_CH1_DIV_FRAC_Msk = 0xf

	// CH1_CTR: Direct access to the PWM counter
	// Position of CH1_CTR field.
	PWM_CH1_CTR_CH1_CTR_Pos = 0x0
	// Bit mask of CH1_CTR field.
	PWM_CH1_CTR_CH1_CTR_Msk = 0xffff

	// CH1_CC: Counter compare values
	// Position of B field.
	PWM_CH1_CC_B_Pos = 0x10
	// Bit mask of B field.
	PWM_CH1_CC_B_Msk = 0xffff0000
	// Position of A field.
	PWM_CH1_CC_A_Pos = 0x0
	// Bit mask of A field.
	PWM_CH1_CC_A_Msk = 0xffff

	// CH1_TOP: Counter wrap value
	// Position of CH1_TOP field.
	PWM_CH1_TOP_CH1_TOP_Pos = 0x0
	// Bit mask of CH1_TOP field.
	PWM_CH1_TOP_CH1_TOP_Msk = 0xffff

	// CH2_CSR: Control and status register
	// Position of PH_ADV field.
	PWM_CH2_CSR_PH_ADV_Pos = 0x7
	// Bit mask of PH_ADV field.
	PWM_CH2_CSR_PH_ADV_Msk = 0x80
	// Bit PH_ADV.
	PWM_CH2_CSR_PH_ADV = 0x80
	// Position of PH_RET field.
	PWM_CH2_CSR_PH_RET_Pos = 0x6
	// Bit mask of PH_RET field.
	PWM_CH2_CSR_PH_RET_Msk = 0x40
	// Bit PH_RET.
	PWM_CH2_CSR_PH_RET = 0x40
	// Position of DIVMODE field.
	PWM_CH2_CSR_DIVMODE_Pos = 0x4
	// Bit mask of DIVMODE field.
	PWM_CH2_CSR_DIVMODE_Msk = 0x30
	// Free-running counting at rate dictated by fractional divider
	PWM_CH2_CSR_DIVMODE_DIV = 0x0
	// Fractional divider operation is gated by the PWM B pin.
	PWM_CH2_CSR_DIVMODE_LEVEL = 0x1
	// Counter advances with each rising edge of the PWM B pin.
	PWM_CH2_CSR_DIVMODE_RISE = 0x2
	// Counter advances with each falling edge of the PWM B pin.
	PWM_CH2_CSR_DIVMODE_FALL = 0x3
	// Position of B_INV field.
	PWM_CH2_CSR_B_INV_Pos = 0x3
	// Bit mask of B_INV field.
	PWM_CH2_CSR_B_INV_Msk = 0x8
	// Bit B_INV.
	PWM_CH2_CSR_B_INV = 0x8
	// Position of A_INV field.
	PWM_CH2_CSR_A_INV_Pos = 0x2
	// Bit mask of A_INV field.
	PWM_CH2_CSR_A_INV_Msk = 0x4
	// Bit A_INV.
	PWM_CH2_CSR_A_INV = 0x4
	// Position of PH_CORRECT field.
	PWM_CH2_CSR_PH_CORRECT_Pos = 0x1
	// Bit mask of PH_CORRECT field.
	PWM_CH2_CSR_PH_CORRECT_Msk = 0x2
	// Bit PH_CORRECT.
	PWM_CH2_CSR_PH_CORRECT = 0x2
	// Position of EN field.
	PWM_CH2_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	PWM_CH2_CSR_EN_Msk = 0x1
	// Bit EN.
	PWM_CH2_CSR_EN = 0x1

	// CH2_DIV
	// INT and FRAC form a fixed-point fractional number.
	// Counting rate is system clock frequency divided by this number.
	// Fractional division uses simple 1st-order sigma-delta.
	// Position of INT field.
	PWM_CH2_DIV_INT_Pos = 0x4
	// Bit mask of INT field.
	PWM_CH2_DIV_INT_Msk = 0xff0
	// Position of FRAC field.
	PWM_CH2_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	PWM_CH2_DIV_FRAC_Msk = 0xf

	// CH2_CTR: Direct access to the PWM counter
	// Position of CH2_CTR field.
	PWM_CH2_CTR_CH2_CTR_Pos = 0x0
	// Bit mask of CH2_CTR field.
	PWM_CH2_CTR_CH2_CTR_Msk = 0xffff

	// CH2_CC: Counter compare values
	// Position of B field.
	PWM_CH2_CC_B_Pos = 0x10
	// Bit mask of B field.
	PWM_CH2_CC_B_Msk = 0xffff0000
	// Position of A field.
	PWM_CH2_CC_A_Pos = 0x0
	// Bit mask of A field.
	PWM_CH2_CC_A_Msk = 0xffff

	// CH2_TOP: Counter wrap value
	// Position of CH2_TOP field.
	PWM_CH2_TOP_CH2_TOP_Pos = 0x0
	// Bit mask of CH2_TOP field.
	PWM_CH2_TOP_CH2_TOP_Msk = 0xffff

	// CH3_CSR: Control and status register
	// Position of PH_ADV field.
	PWM_CH3_CSR_PH_ADV_Pos = 0x7
	// Bit mask of PH_ADV field.
	PWM_CH3_CSR_PH_ADV_Msk = 0x80
	// Bit PH_ADV.
	PWM_CH3_CSR_PH_ADV = 0x80
	// Position of PH_RET field.
	PWM_CH3_CSR_PH_RET_Pos = 0x6
	// Bit mask of PH_RET field.
	PWM_CH3_CSR_PH_RET_Msk = 0x40
	// Bit PH_RET.
	PWM_CH3_CSR_PH_RET = 0x40
	// Position of DIVMODE field.
	PWM_CH3_CSR_DIVMODE_Pos = 0x4
	// Bit mask of DIVMODE field.
	PWM_CH3_CSR_DIVMODE_Msk = 0x30
	// Free-running counting at rate dictated by fractional divider
	PWM_CH3_CSR_DIVMODE_DIV = 0x0
	// Fractional divider operation is gated by the PWM B pin.
	PWM_CH3_CSR_DIVMODE_LEVEL = 0x1
	// Counter advances with each rising edge of the PWM B pin.
	PWM_CH3_CSR_DIVMODE_RISE = 0x2
	// Counter advances with each falling edge of the PWM B pin.
	PWM_CH3_CSR_DIVMODE_FALL = 0x3
	// Position of B_INV field.
	PWM_CH3_CSR_B_INV_Pos = 0x3
	// Bit mask of B_INV field.
	PWM_CH3_CSR_B_INV_Msk = 0x8
	// Bit B_INV.
	PWM_CH3_CSR_B_INV = 0x8
	// Position of A_INV field.
	PWM_CH3_CSR_A_INV_Pos = 0x2
	// Bit mask of A_INV field.
	PWM_CH3_CSR_A_INV_Msk = 0x4
	// Bit A_INV.
	PWM_CH3_CSR_A_INV = 0x4
	// Position of PH_CORRECT field.
	PWM_CH3_CSR_PH_CORRECT_Pos = 0x1
	// Bit mask of PH_CORRECT field.
	PWM_CH3_CSR_PH_CORRECT_Msk = 0x2
	// Bit PH_CORRECT.
	PWM_CH3_CSR_PH_CORRECT = 0x2
	// Position of EN field.
	PWM_CH3_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	PWM_CH3_CSR_EN_Msk = 0x1
	// Bit EN.
	PWM_CH3_CSR_EN = 0x1

	// CH3_DIV
	// INT and FRAC form a fixed-point fractional number.
	// Counting rate is system clock frequency divided by this number.
	// Fractional division uses simple 1st-order sigma-delta.
	// Position of INT field.
	PWM_CH3_DIV_INT_Pos = 0x4
	// Bit mask of INT field.
	PWM_CH3_DIV_INT_Msk = 0xff0
	// Position of FRAC field.
	PWM_CH3_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	PWM_CH3_DIV_FRAC_Msk = 0xf

	// CH3_CTR: Direct access to the PWM counter
	// Position of CH3_CTR field.
	PWM_CH3_CTR_CH3_CTR_Pos = 0x0
	// Bit mask of CH3_CTR field.
	PWM_CH3_CTR_CH3_CTR_Msk = 0xffff

	// CH3_CC: Counter compare values
	// Position of B field.
	PWM_CH3_CC_B_Pos = 0x10
	// Bit mask of B field.
	PWM_CH3_CC_B_Msk = 0xffff0000
	// Position of A field.
	PWM_CH3_CC_A_Pos = 0x0
	// Bit mask of A field.
	PWM_CH3_CC_A_Msk = 0xffff

	// CH3_TOP: Counter wrap value
	// Position of CH3_TOP field.
	PWM_CH3_TOP_CH3_TOP_Pos = 0x0
	// Bit mask of CH3_TOP field.
	PWM_CH3_TOP_CH3_TOP_Msk = 0xffff

	// CH4_CSR: Control and status register
	// Position of PH_ADV field.
	PWM_CH4_CSR_PH_ADV_Pos = 0x7
	// Bit mask of PH_ADV field.
	PWM_CH4_CSR_PH_ADV_Msk = 0x80
	// Bit PH_ADV.
	PWM_CH4_CSR_PH_ADV = 0x80
	// Position of PH_RET field.
	PWM_CH4_CSR_PH_RET_Pos = 0x6
	// Bit mask of PH_RET field.
	PWM_CH4_CSR_PH_RET_Msk = 0x40
	// Bit PH_RET.
	PWM_CH4_CSR_PH_RET = 0x40
	// Position of DIVMODE field.
	PWM_CH4_CSR_DIVMODE_Pos = 0x4
	// Bit mask of DIVMODE field.
	PWM_CH4_CSR_DIVMODE_Msk = 0x30
	// Free-running counting at rate dictated by fractional divider
	PWM_CH4_CSR_DIVMODE_DIV = 0x0
	// Fractional divider operation is gated by the PWM B pin.
	PWM_CH4_CSR_DIVMODE_LEVEL = 0x1
	// Counter advances with each rising edge of the PWM B pin.
	PWM_CH4_CSR_DIVMODE_RISE = 0x2
	// Counter advances with each falling edge of the PWM B pin.
	PWM_CH4_CSR_DIVMODE_FALL = 0x3
	// Position of B_INV field.
	PWM_CH4_CSR_B_INV_Pos = 0x3
	// Bit mask of B_INV field.
	PWM_CH4_CSR_B_INV_Msk = 0x8
	// Bit B_INV.
	PWM_CH4_CSR_B_INV = 0x8
	// Position of A_INV field.
	PWM_CH4_CSR_A_INV_Pos = 0x2
	// Bit mask of A_INV field.
	PWM_CH4_CSR_A_INV_Msk = 0x4
	// Bit A_INV.
	PWM_CH4_CSR_A_INV = 0x4
	// Position of PH_CORRECT field.
	PWM_CH4_CSR_PH_CORRECT_Pos = 0x1
	// Bit mask of PH_CORRECT field.
	PWM_CH4_CSR_PH_CORRECT_Msk = 0x2
	// Bit PH_CORRECT.
	PWM_CH4_CSR_PH_CORRECT = 0x2
	// Position of EN field.
	PWM_CH4_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	PWM_CH4_CSR_EN_Msk = 0x1
	// Bit EN.
	PWM_CH4_CSR_EN = 0x1

	// CH4_DIV
	// INT and FRAC form a fixed-point fractional number.
	// Counting rate is system clock frequency divided by this number.
	// Fractional division uses simple 1st-order sigma-delta.
	// Position of INT field.
	PWM_CH4_DIV_INT_Pos = 0x4
	// Bit mask of INT field.
	PWM_CH4_DIV_INT_Msk = 0xff0
	// Position of FRAC field.
	PWM_CH4_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	PWM_CH4_DIV_FRAC_Msk = 0xf

	// CH4_CTR: Direct access to the PWM counter
	// Position of CH4_CTR field.
	PWM_CH4_CTR_CH4_CTR_Pos = 0x0
	// Bit mask of CH4_CTR field.
	PWM_CH4_CTR_CH4_CTR_Msk = 0xffff

	// CH4_CC: Counter compare values
	// Position of B field.
	PWM_CH4_CC_B_Pos = 0x10
	// Bit mask of B field.
	PWM_CH4_CC_B_Msk = 0xffff0000
	// Position of A field.
	PWM_CH4_CC_A_Pos = 0x0
	// Bit mask of A field.
	PWM_CH4_CC_A_Msk = 0xffff

	// CH4_TOP: Counter wrap value
	// Position of CH4_TOP field.
	PWM_CH4_TOP_CH4_TOP_Pos = 0x0
	// Bit mask of CH4_TOP field.
	PWM_CH4_TOP_CH4_TOP_Msk = 0xffff

	// CH5_CSR: Control and status register
	// Position of PH_ADV field.
	PWM_CH5_CSR_PH_ADV_Pos = 0x7
	// Bit mask of PH_ADV field.
	PWM_CH5_CSR_PH_ADV_Msk = 0x80
	// Bit PH_ADV.
	PWM_CH5_CSR_PH_ADV = 0x80
	// Position of PH_RET field.
	PWM_CH5_CSR_PH_RET_Pos = 0x6
	// Bit mask of PH_RET field.
	PWM_CH5_CSR_PH_RET_Msk = 0x40
	// Bit PH_RET.
	PWM_CH5_CSR_PH_RET = 0x40
	// Position of DIVMODE field.
	PWM_CH5_CSR_DIVMODE_Pos = 0x4
	// Bit mask of DIVMODE field.
	PWM_CH5_CSR_DIVMODE_Msk = 0x30
	// Free-running counting at rate dictated by fractional divider
	PWM_CH5_CSR_DIVMODE_DIV = 0x0
	// Fractional divider operation is gated by the PWM B pin.
	PWM_CH5_CSR_DIVMODE_LEVEL = 0x1
	// Counter advances with each rising edge of the PWM B pin.
	PWM_CH5_CSR_DIVMODE_RISE = 0x2
	// Counter advances with each falling edge of the PWM B pin.
	PWM_CH5_CSR_DIVMODE_FALL = 0x3
	// Position of B_INV field.
	PWM_CH5_CSR_B_INV_Pos = 0x3
	// Bit mask of B_INV field.
	PWM_CH5_CSR_B_INV_Msk = 0x8
	// Bit B_INV.
	PWM_CH5_CSR_B_INV = 0x8
	// Position of A_INV field.
	PWM_CH5_CSR_A_INV_Pos = 0x2
	// Bit mask of A_INV field.
	PWM_CH5_CSR_A_INV_Msk = 0x4
	// Bit A_INV.
	PWM_CH5_CSR_A_INV = 0x4
	// Position of PH_CORRECT field.
	PWM_CH5_CSR_PH_CORRECT_Pos = 0x1
	// Bit mask of PH_CORRECT field.
	PWM_CH5_CSR_PH_CORRECT_Msk = 0x2
	// Bit PH_CORRECT.
	PWM_CH5_CSR_PH_CORRECT = 0x2
	// Position of EN field.
	PWM_CH5_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	PWM_CH5_CSR_EN_Msk = 0x1
	// Bit EN.
	PWM_CH5_CSR_EN = 0x1

	// CH5_DIV
	// INT and FRAC form a fixed-point fractional number.
	// Counting rate is system clock frequency divided by this number.
	// Fractional division uses simple 1st-order sigma-delta.
	// Position of INT field.
	PWM_CH5_DIV_INT_Pos = 0x4
	// Bit mask of INT field.
	PWM_CH5_DIV_INT_Msk = 0xff0
	// Position of FRAC field.
	PWM_CH5_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	PWM_CH5_DIV_FRAC_Msk = 0xf

	// CH5_CTR: Direct access to the PWM counter
	// Position of CH5_CTR field.
	PWM_CH5_CTR_CH5_CTR_Pos = 0x0
	// Bit mask of CH5_CTR field.
	PWM_CH5_CTR_CH5_CTR_Msk = 0xffff

	// CH5_CC: Counter compare values
	// Position of B field.
	PWM_CH5_CC_B_Pos = 0x10
	// Bit mask of B field.
	PWM_CH5_CC_B_Msk = 0xffff0000
	// Position of A field.
	PWM_CH5_CC_A_Pos = 0x0
	// Bit mask of A field.
	PWM_CH5_CC_A_Msk = 0xffff

	// CH5_TOP: Counter wrap value
	// Position of CH5_TOP field.
	PWM_CH5_TOP_CH5_TOP_Pos = 0x0
	// Bit mask of CH5_TOP field.
	PWM_CH5_TOP_CH5_TOP_Msk = 0xffff

	// CH6_CSR: Control and status register
	// Position of PH_ADV field.
	PWM_CH6_CSR_PH_ADV_Pos = 0x7
	// Bit mask of PH_ADV field.
	PWM_CH6_CSR_PH_ADV_Msk = 0x80
	// Bit PH_ADV.
	PWM_CH6_CSR_PH_ADV = 0x80
	// Position of PH_RET field.
	PWM_CH6_CSR_PH_RET_Pos = 0x6
	// Bit mask of PH_RET field.
	PWM_CH6_CSR_PH_RET_Msk = 0x40
	// Bit PH_RET.
	PWM_CH6_CSR_PH_RET = 0x40
	// Position of DIVMODE field.
	PWM_CH6_CSR_DIVMODE_Pos = 0x4
	// Bit mask of DIVMODE field.
	PWM_CH6_CSR_DIVMODE_Msk = 0x30
	// Free-running counting at rate dictated by fractional divider
	PWM_CH6_CSR_DIVMODE_DIV = 0x0
	// Fractional divider operation is gated by the PWM B pin.
	PWM_CH6_CSR_DIVMODE_LEVEL = 0x1
	// Counter advances with each rising edge of the PWM B pin.
	PWM_CH6_CSR_DIVMODE_RISE = 0x2
	// Counter advances with each falling edge of the PWM B pin.
	PWM_CH6_CSR_DIVMODE_FALL = 0x3
	// Position of B_INV field.
	PWM_CH6_CSR_B_INV_Pos = 0x3
	// Bit mask of B_INV field.
	PWM_CH6_CSR_B_INV_Msk = 0x8
	// Bit B_INV.
	PWM_CH6_CSR_B_INV = 0x8
	// Position of A_INV field.
	PWM_CH6_CSR_A_INV_Pos = 0x2
	// Bit mask of A_INV field.
	PWM_CH6_CSR_A_INV_Msk = 0x4
	// Bit A_INV.
	PWM_CH6_CSR_A_INV = 0x4
	// Position of PH_CORRECT field.
	PWM_CH6_CSR_PH_CORRECT_Pos = 0x1
	// Bit mask of PH_CORRECT field.
	PWM_CH6_CSR_PH_CORRECT_Msk = 0x2
	// Bit PH_CORRECT.
	PWM_CH6_CSR_PH_CORRECT = 0x2
	// Position of EN field.
	PWM_CH6_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	PWM_CH6_CSR_EN_Msk = 0x1
	// Bit EN.
	PWM_CH6_CSR_EN = 0x1

	// CH6_DIV
	// INT and FRAC form a fixed-point fractional number.
	// Counting rate is system clock frequency divided by this number.
	// Fractional division uses simple 1st-order sigma-delta.
	// Position of INT field.
	PWM_CH6_DIV_INT_Pos = 0x4
	// Bit mask of INT field.
	PWM_CH6_DIV_INT_Msk = 0xff0
	// Position of FRAC field.
	PWM_CH6_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	PWM_CH6_DIV_FRAC_Msk = 0xf

	// CH6_CTR: Direct access to the PWM counter
	// Position of CH6_CTR field.
	PWM_CH6_CTR_CH6_CTR_Pos = 0x0
	// Bit mask of CH6_CTR field.
	PWM_CH6_CTR_CH6_CTR_Msk = 0xffff

	// CH6_CC: Counter compare values
	// Position of B field.
	PWM_CH6_CC_B_Pos = 0x10
	// Bit mask of B field.
	PWM_CH6_CC_B_Msk = 0xffff0000
	// Position of A field.
	PWM_CH6_CC_A_Pos = 0x0
	// Bit mask of A field.
	PWM_CH6_CC_A_Msk = 0xffff

	// CH6_TOP: Counter wrap value
	// Position of CH6_TOP field.
	PWM_CH6_TOP_CH6_TOP_Pos = 0x0
	// Bit mask of CH6_TOP field.
	PWM_CH6_TOP_CH6_TOP_Msk = 0xffff

	// CH7_CSR: Control and status register
	// Position of PH_ADV field.
	PWM_CH7_CSR_PH_ADV_Pos = 0x7
	// Bit mask of PH_ADV field.
	PWM_CH7_CSR_PH_ADV_Msk = 0x80
	// Bit PH_ADV.
	PWM_CH7_CSR_PH_ADV = 0x80
	// Position of PH_RET field.
	PWM_CH7_CSR_PH_RET_Pos = 0x6
	// Bit mask of PH_RET field.
	PWM_CH7_CSR_PH_RET_Msk = 0x40
	// Bit PH_RET.
	PWM_CH7_CSR_PH_RET = 0x40
	// Position of DIVMODE field.
	PWM_CH7_CSR_DIVMODE_Pos = 0x4
	// Bit mask of DIVMODE field.
	PWM_CH7_CSR_DIVMODE_Msk = 0x30
	// Free-running counting at rate dictated by fractional divider
	PWM_CH7_CSR_DIVMODE_DIV = 0x0
	// Fractional divider operation is gated by the PWM B pin.
	PWM_CH7_CSR_DIVMODE_LEVEL = 0x1
	// Counter advances with each rising edge of the PWM B pin.
	PWM_CH7_CSR_DIVMODE_RISE = 0x2
	// Counter advances with each falling edge of the PWM B pin.
	PWM_CH7_CSR_DIVMODE_FALL = 0x3
	// Position of B_INV field.
	PWM_CH7_CSR_B_INV_Pos = 0x3
	// Bit mask of B_INV field.
	PWM_CH7_CSR_B_INV_Msk = 0x8
	// Bit B_INV.
	PWM_CH7_CSR_B_INV = 0x8
	// Position of A_INV field.
	PWM_CH7_CSR_A_INV_Pos = 0x2
	// Bit mask of A_INV field.
	PWM_CH7_CSR_A_INV_Msk = 0x4
	// Bit A_INV.
	PWM_CH7_CSR_A_INV = 0x4
	// Position of PH_CORRECT field.
	PWM_CH7_CSR_PH_CORRECT_Pos = 0x1
	// Bit mask of PH_CORRECT field.
	PWM_CH7_CSR_PH_CORRECT_Msk = 0x2
	// Bit PH_CORRECT.
	PWM_CH7_CSR_PH_CORRECT = 0x2
	// Position of EN field.
	PWM_CH7_CSR_EN_Pos = 0x0
	// Bit mask of EN field.
	PWM_CH7_CSR_EN_Msk = 0x1
	// Bit EN.
	PWM_CH7_CSR_EN = 0x1

	// CH7_DIV
	// INT and FRAC form a fixed-point fractional number.
	// Counting rate is system clock frequency divided by this number.
	// Fractional division uses simple 1st-order sigma-delta.
	// Position of INT field.
	PWM_CH7_DIV_INT_Pos = 0x4
	// Bit mask of INT field.
	PWM_CH7_DIV_INT_Msk = 0xff0
	// Position of FRAC field.
	PWM_CH7_DIV_FRAC_Pos = 0x0
	// Bit mask of FRAC field.
	PWM_CH7_DIV_FRAC_Msk = 0xf

	// CH7_CTR: Direct access to the PWM counter
	// Position of CH7_CTR field.
	PWM_CH7_CTR_CH7_CTR_Pos = 0x0
	// Bit mask of CH7_CTR field.
	PWM_CH7_CTR_CH7_CTR_Msk = 0xffff

	// CH7_CC: Counter compare values
	// Position of B field.
	PWM_CH7_CC_B_Pos = 0x10
	// Bit mask of B field.
	PWM_CH7_CC_B_Msk = 0xffff0000
	// Position of A field.
	PWM_CH7_CC_A_Pos = 0x0
	// Bit mask of A field.
	PWM_CH7_CC_A_Msk = 0xffff

	// CH7_TOP: Counter wrap value
	// Position of CH7_TOP field.
	PWM_CH7_TOP_CH7_TOP_Pos = 0x0
	// Bit mask of CH7_TOP field.
	PWM_CH7_TOP_CH7_TOP_Msk = 0xffff

	// EN
	// This register aliases the CSR_EN bits for all channels.
	// Writing to this register allows multiple channels to be enabled
	// or disabled simultaneously, so they can run in perfect sync.
	// For each channel, there is only one physical EN register bit,
	// which can be accessed through here or CHx_CSR.
	// Position of CH7 field.
	PWM_EN_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PWM_EN_CH7_Msk = 0x80
	// Bit CH7.
	PWM_EN_CH7 = 0x80
	// Position of CH6 field.
	PWM_EN_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PWM_EN_CH6_Msk = 0x40
	// Bit CH6.
	PWM_EN_CH6 = 0x40
	// Position of CH5 field.
	PWM_EN_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PWM_EN_CH5_Msk = 0x20
	// Bit CH5.
	PWM_EN_CH5 = 0x20
	// Position of CH4 field.
	PWM_EN_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PWM_EN_CH4_Msk = 0x10
	// Bit CH4.
	PWM_EN_CH4 = 0x10
	// Position of CH3 field.
	PWM_EN_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PWM_EN_CH3_Msk = 0x8
	// Bit CH3.
	PWM_EN_CH3 = 0x8
	// Position of CH2 field.
	PWM_EN_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PWM_EN_CH2_Msk = 0x4
	// Bit CH2.
	PWM_EN_CH2 = 0x4
	// Position of CH1 field.
	PWM_EN_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PWM_EN_CH1_Msk = 0x2
	// Bit CH1.
	PWM_EN_CH1 = 0x2
	// Position of CH0 field.
	PWM_EN_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PWM_EN_CH0_Msk = 0x1
	// Bit CH0.
	PWM_EN_CH0 = 0x1

	// INTR: Raw Interrupts
	// Position of CH7 field.
	PWM_INTR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PWM_INTR_CH7_Msk = 0x80
	// Bit CH7.
	PWM_INTR_CH7 = 0x80
	// Position of CH6 field.
	PWM_INTR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PWM_INTR_CH6_Msk = 0x40
	// Bit CH6.
	PWM_INTR_CH6 = 0x40
	// Position of CH5 field.
	PWM_INTR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PWM_INTR_CH5_Msk = 0x20
	// Bit CH5.
	PWM_INTR_CH5 = 0x20
	// Position of CH4 field.
	PWM_INTR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PWM_INTR_CH4_Msk = 0x10
	// Bit CH4.
	PWM_INTR_CH4 = 0x10
	// Position of CH3 field.
	PWM_INTR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PWM_INTR_CH3_Msk = 0x8
	// Bit CH3.
	PWM_INTR_CH3 = 0x8
	// Position of CH2 field.
	PWM_INTR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PWM_INTR_CH2_Msk = 0x4
	// Bit CH2.
	PWM_INTR_CH2 = 0x4
	// Position of CH1 field.
	PWM_INTR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PWM_INTR_CH1_Msk = 0x2
	// Bit CH1.
	PWM_INTR_CH1 = 0x2
	// Position of CH0 field.
	PWM_INTR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PWM_INTR_CH0_Msk = 0x1
	// Bit CH0.
	PWM_INTR_CH0 = 0x1

	// INTE: Interrupt Enable
	// Position of CH7 field.
	PWM_INTE_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PWM_INTE_CH7_Msk = 0x80
	// Bit CH7.
	PWM_INTE_CH7 = 0x80
	// Position of CH6 field.
	PWM_INTE_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PWM_INTE_CH6_Msk = 0x40
	// Bit CH6.
	PWM_INTE_CH6 = 0x40
	// Position of CH5 field.
	PWM_INTE_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PWM_INTE_CH5_Msk = 0x20
	// Bit CH5.
	PWM_INTE_CH5 = 0x20
	// Position of CH4 field.
	PWM_INTE_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PWM_INTE_CH4_Msk = 0x10
	// Bit CH4.
	PWM_INTE_CH4 = 0x10
	// Position of CH3 field.
	PWM_INTE_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PWM_INTE_CH3_Msk = 0x8
	// Bit CH3.
	PWM_INTE_CH3 = 0x8
	// Position of CH2 field.
	PWM_INTE_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PWM_INTE_CH2_Msk = 0x4
	// Bit CH2.
	PWM_INTE_CH2 = 0x4
	// Position of CH1 field.
	PWM_INTE_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PWM_INTE_CH1_Msk = 0x2
	// Bit CH1.
	PWM_INTE_CH1 = 0x2
	// Position of CH0 field.
	PWM_INTE_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PWM_INTE_CH0_Msk = 0x1
	// Bit CH0.
	PWM_INTE_CH0 = 0x1

	// INTF: Interrupt Force
	// Position of CH7 field.
	PWM_INTF_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PWM_INTF_CH7_Msk = 0x80
	// Bit CH7.
	PWM_INTF_CH7 = 0x80
	// Position of CH6 field.
	PWM_INTF_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PWM_INTF_CH6_Msk = 0x40
	// Bit CH6.
	PWM_INTF_CH6 = 0x40
	// Position of CH5 field.
	PWM_INTF_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PWM_INTF_CH5_Msk = 0x20
	// Bit CH5.
	PWM_INTF_CH5 = 0x20
	// Position of CH4 field.
	PWM_INTF_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PWM_INTF_CH4_Msk = 0x10
	// Bit CH4.
	PWM_INTF_CH4 = 0x10
	// Position of CH3 field.
	PWM_INTF_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PWM_INTF_CH3_Msk = 0x8
	// Bit CH3.
	PWM_INTF_CH3 = 0x8
	// Position of CH2 field.
	PWM_INTF_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PWM_INTF_CH2_Msk = 0x4
	// Bit CH2.
	PWM_INTF_CH2 = 0x4
	// Position of CH1 field.
	PWM_INTF_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PWM_INTF_CH1_Msk = 0x2
	// Bit CH1.
	PWM_INTF_CH1 = 0x2
	// Position of CH0 field.
	PWM_INTF_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PWM_INTF_CH0_Msk = 0x1
	// Bit CH0.
	PWM_INTF_CH0 = 0x1

	// INTS: Interrupt status after masking & forcing
	// Position of CH7 field.
	PWM_INTS_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PWM_INTS_CH7_Msk = 0x80
	// Bit CH7.
	PWM_INTS_CH7 = 0x80
	// Position of CH6 field.
	PWM_INTS_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PWM_INTS_CH6_Msk = 0x40
	// Bit CH6.
	PWM_INTS_CH6 = 0x40
	// Position of CH5 field.
	PWM_INTS_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PWM_INTS_CH5_Msk = 0x20
	// Bit CH5.
	PWM_INTS_CH5 = 0x20
	// Position of CH4 field.
	PWM_INTS_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PWM_INTS_CH4_Msk = 0x10
	// Bit CH4.
	PWM_INTS_CH4 = 0x10
	// Position of CH3 field.
	PWM_INTS_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PWM_INTS_CH3_Msk = 0x8
	// Bit CH3.
	PWM_INTS_CH3 = 0x8
	// Position of CH2 field.
	PWM_INTS_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PWM_INTS_CH2_Msk = 0x4
	// Bit CH2.
	PWM_INTS_CH2 = 0x4
	// Position of CH1 field.
	PWM_INTS_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PWM_INTS_CH1_Msk = 0x2
	// Bit CH1.
	PWM_INTS_CH1 = 0x2
	// Position of CH0 field.
	PWM_INTS_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PWM_INTS_CH0_Msk = 0x1
	// Bit CH0.
	PWM_INTS_CH0 = 0x1
)

// Bitfields for TIMER
// Controls time and alarms
// time is a 64 bit value indicating the time in usec since power-on
// timeh is the top 32 bits of time & timel is the bottom 32 bits
// to change time write to timelw before timehw
// to read time read from timelr before timehr
// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
// When an alarm is pending, the corresponding alarm_running signal will be high
// An alarm can be cancelled before it has finished by clearing the alarm_enable
// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
// To clear the interrupt write a 1 to the corresponding alarm_irq
const (
	// ARMED
	// Indicates the armed/disarmed status of each alarm.
	// A write to the corresponding ALARMx register arms the alarm.
	// Alarms automatically disarm upon firing, but writing ones here
	// will disarm immediately without waiting to fire.
	// Position of ARMED field.
	TIMER_ARMED_ARMED_Pos = 0x0
	// Bit mask of ARMED field.
	TIMER_ARMED_ARMED_Msk = 0xf

	// DBGPAUSE: Set bits high to enable pause when the corresponding debug ports are active
	// Position of DBG1 field.
	TIMER_DBGPAUSE_DBG1_Pos = 0x2
	// Bit mask of DBG1 field.
	TIMER_DBGPAUSE_DBG1_Msk = 0x4
	// Bit DBG1.
	TIMER_DBGPAUSE_DBG1 = 0x4
	// Position of DBG0 field.
	TIMER_DBGPAUSE_DBG0_Pos = 0x1
	// Bit mask of DBG0 field.
	TIMER_DBGPAUSE_DBG0_Msk = 0x2
	// Bit DBG0.
	TIMER_DBGPAUSE_DBG0 = 0x2

	// PAUSE: Set high to pause the timer
	// Position of PAUSE field.
	TIMER_PAUSE_PAUSE_Pos = 0x0
	// Bit mask of PAUSE field.
	TIMER_PAUSE_PAUSE_Msk = 0x1
	// Bit PAUSE.
	TIMER_PAUSE_PAUSE = 0x1

	// INTR: Raw Interrupts
	// Position of ALARM_3 field.
	TIMER_INTR_ALARM_3_Pos = 0x3
	// Bit mask of ALARM_3 field.
	TIMER_INTR_ALARM_3_Msk = 0x8
	// Bit ALARM_3.
	TIMER_INTR_ALARM_3 = 0x8
	// Position of ALARM_2 field.
	TIMER_INTR_ALARM_2_Pos = 0x2
	// Bit mask of ALARM_2 field.
	TIMER_INTR_ALARM_2_Msk = 0x4
	// Bit ALARM_2.
	TIMER_INTR_ALARM_2 = 0x4
	// Position of ALARM_1 field.
	TIMER_INTR_ALARM_1_Pos = 0x1
	// Bit mask of ALARM_1 field.
	TIMER_INTR_ALARM_1_Msk = 0x2
	// Bit ALARM_1.
	TIMER_INTR_ALARM_1 = 0x2
	// Position of ALARM_0 field.
	TIMER_INTR_ALARM_0_Pos = 0x0
	// Bit mask of ALARM_0 field.
	TIMER_INTR_ALARM_0_Msk = 0x1
	// Bit ALARM_0.
	TIMER_INTR_ALARM_0 = 0x1

	// INTE: Interrupt Enable
	// Position of ALARM_3 field.
	TIMER_INTE_ALARM_3_Pos = 0x3
	// Bit mask of ALARM_3 field.
	TIMER_INTE_ALARM_3_Msk = 0x8
	// Bit ALARM_3.
	TIMER_INTE_ALARM_3 = 0x8
	// Position of ALARM_2 field.
	TIMER_INTE_ALARM_2_Pos = 0x2
	// Bit mask of ALARM_2 field.
	TIMER_INTE_ALARM_2_Msk = 0x4
	// Bit ALARM_2.
	TIMER_INTE_ALARM_2 = 0x4
	// Position of ALARM_1 field.
	TIMER_INTE_ALARM_1_Pos = 0x1
	// Bit mask of ALARM_1 field.
	TIMER_INTE_ALARM_1_Msk = 0x2
	// Bit ALARM_1.
	TIMER_INTE_ALARM_1 = 0x2
	// Position of ALARM_0 field.
	TIMER_INTE_ALARM_0_Pos = 0x0
	// Bit mask of ALARM_0 field.
	TIMER_INTE_ALARM_0_Msk = 0x1
	// Bit ALARM_0.
	TIMER_INTE_ALARM_0 = 0x1

	// INTF: Interrupt Force
	// Position of ALARM_3 field.
	TIMER_INTF_ALARM_3_Pos = 0x3
	// Bit mask of ALARM_3 field.
	TIMER_INTF_ALARM_3_Msk = 0x8
	// Bit ALARM_3.
	TIMER_INTF_ALARM_3 = 0x8
	// Position of ALARM_2 field.
	TIMER_INTF_ALARM_2_Pos = 0x2
	// Bit mask of ALARM_2 field.
	TIMER_INTF_ALARM_2_Msk = 0x4
	// Bit ALARM_2.
	TIMER_INTF_ALARM_2 = 0x4
	// Position of ALARM_1 field.
	TIMER_INTF_ALARM_1_Pos = 0x1
	// Bit mask of ALARM_1 field.
	TIMER_INTF_ALARM_1_Msk = 0x2
	// Bit ALARM_1.
	TIMER_INTF_ALARM_1 = 0x2
	// Position of ALARM_0 field.
	TIMER_INTF_ALARM_0_Pos = 0x0
	// Bit mask of ALARM_0 field.
	TIMER_INTF_ALARM_0_Msk = 0x1
	// Bit ALARM_0.
	TIMER_INTF_ALARM_0 = 0x1

	// INTS: Interrupt status after masking & forcing
	// Position of ALARM_3 field.
	TIMER_INTS_ALARM_3_Pos = 0x3
	// Bit mask of ALARM_3 field.
	TIMER_INTS_ALARM_3_Msk = 0x8
	// Bit ALARM_3.
	TIMER_INTS_ALARM_3 = 0x8
	// Position of ALARM_2 field.
	TIMER_INTS_ALARM_2_Pos = 0x2
	// Bit mask of ALARM_2 field.
	TIMER_INTS_ALARM_2_Msk = 0x4
	// Bit ALARM_2.
	TIMER_INTS_ALARM_2 = 0x4
	// Position of ALARM_1 field.
	TIMER_INTS_ALARM_1_Pos = 0x1
	// Bit mask of ALARM_1 field.
	TIMER_INTS_ALARM_1_Msk = 0x2
	// Bit ALARM_1.
	TIMER_INTS_ALARM_1 = 0x2
	// Position of ALARM_0 field.
	TIMER_INTS_ALARM_0_Pos = 0x0
	// Bit mask of ALARM_0 field.
	TIMER_INTS_ALARM_0_Msk = 0x1
	// Bit ALARM_0.
	TIMER_INTS_ALARM_0 = 0x1
)

// Bitfields for WATCHDOG
const (
	// CTRL
	// Watchdog control
	// The rst_wdsel register determines which subsystems are reset when the watchdog is triggered.
	// The watchdog can be triggered in software.
	// Position of TRIGGER field.
	WATCHDOG_CTRL_TRIGGER_Pos = 0x1f
	// Bit mask of TRIGGER field.
	WATCHDOG_CTRL_TRIGGER_Msk = 0x80000000
	// Bit TRIGGER.
	WATCHDOG_CTRL_TRIGGER = 0x80000000
	// Position of ENABLE field.
	WATCHDOG_CTRL_ENABLE_Pos = 0x1e
	// Bit mask of ENABLE field.
	WATCHDOG_CTRL_ENABLE_Msk = 0x40000000
	// Bit ENABLE.
	WATCHDOG_CTRL_ENABLE = 0x40000000
	// Position of PAUSE_DBG1 field.
	WATCHDOG_CTRL_PAUSE_DBG1_Pos = 0x1a
	// Bit mask of PAUSE_DBG1 field.
	WATCHDOG_CTRL_PAUSE_DBG1_Msk = 0x4000000
	// Bit PAUSE_DBG1.
	WATCHDOG_CTRL_PAUSE_DBG1 = 0x4000000
	// Position of PAUSE_DBG0 field.
	WATCHDOG_CTRL_PAUSE_DBG0_Pos = 0x19
	// Bit mask of PAUSE_DBG0 field.
	WATCHDOG_CTRL_PAUSE_DBG0_Msk = 0x2000000
	// Bit PAUSE_DBG0.
	WATCHDOG_CTRL_PAUSE_DBG0 = 0x2000000
	// Position of PAUSE_JTAG field.
	WATCHDOG_CTRL_PAUSE_JTAG_Pos = 0x18
	// Bit mask of PAUSE_JTAG field.
	WATCHDOG_CTRL_PAUSE_JTAG_Msk = 0x1000000
	// Bit PAUSE_JTAG.
	WATCHDOG_CTRL_PAUSE_JTAG = 0x1000000
	// Position of TIME field.
	WATCHDOG_CTRL_TIME_Pos = 0x0
	// Bit mask of TIME field.
	WATCHDOG_CTRL_TIME_Msk = 0xffffff

	// LOAD: Load the watchdog timer. The maximum setting is 0xffffff which corresponds to 0xffffff / 2 ticks before triggering a watchdog reset (see errata RP2040-E1).
	// Position of LOAD field.
	WATCHDOG_LOAD_LOAD_Pos = 0x0
	// Bit mask of LOAD field.
	WATCHDOG_LOAD_LOAD_Msk = 0xffffff

	// REASON: Logs the reason for the last reset. Both bits are zero for the case of a hardware reset.
	// Position of FORCE field.
	WATCHDOG_REASON_FORCE_Pos = 0x1
	// Bit mask of FORCE field.
	WATCHDOG_REASON_FORCE_Msk = 0x2
	// Bit FORCE.
	WATCHDOG_REASON_FORCE = 0x2
	// Position of TIMER field.
	WATCHDOG_REASON_TIMER_Pos = 0x0
	// Bit mask of TIMER field.
	WATCHDOG_REASON_TIMER_Msk = 0x1
	// Bit TIMER.
	WATCHDOG_REASON_TIMER = 0x1

	// TICK: Controls the tick generator
	// Position of COUNT field.
	WATCHDOG_TICK_COUNT_Pos = 0xb
	// Bit mask of COUNT field.
	WATCHDOG_TICK_COUNT_Msk = 0xff800
	// Position of RUNNING field.
	WATCHDOG_TICK_RUNNING_Pos = 0xa
	// Bit mask of RUNNING field.
	WATCHDOG_TICK_RUNNING_Msk = 0x400
	// Bit RUNNING.
	WATCHDOG_TICK_RUNNING = 0x400
	// Position of ENABLE field.
	WATCHDOG_TICK_ENABLE_Pos = 0x9
	// Bit mask of ENABLE field.
	WATCHDOG_TICK_ENABLE_Msk = 0x200
	// Bit ENABLE.
	WATCHDOG_TICK_ENABLE = 0x200
	// Position of CYCLES field.
	WATCHDOG_TICK_CYCLES_Pos = 0x0
	// Bit mask of CYCLES field.
	WATCHDOG_TICK_CYCLES_Msk = 0x1ff
)

// Bitfields for RTC: Register block to control RTC
const (
	// CLKDIV_M1: Divider minus 1 for the 1 second counter. Safe to change the value when RTC is not enabled.
	// Position of CLKDIV_M1 field.
	RTC_CLKDIV_M1_CLKDIV_M1_Pos = 0x0
	// Bit mask of CLKDIV_M1 field.
	RTC_CLKDIV_M1_CLKDIV_M1_Msk = 0xffff

	// SETUP_0: RTC setup register 0
	// Position of YEAR field.
	RTC_SETUP_0_YEAR_Pos = 0xc
	// Bit mask of YEAR field.
	RTC_SETUP_0_YEAR_Msk = 0xfff000
	// Position of MONTH field.
	RTC_SETUP_0_MONTH_Pos = 0x8
	// Bit mask of MONTH field.
	RTC_SETUP_0_MONTH_Msk = 0xf00
	// Position of DAY field.
	RTC_SETUP_0_DAY_Pos = 0x0
	// Bit mask of DAY field.
	RTC_SETUP_0_DAY_Msk = 0x1f

	// SETUP_1: RTC setup register 1
	// Position of DOTW field.
	RTC_SETUP_1_DOTW_Pos = 0x18
	// Bit mask of DOTW field.
	RTC_SETUP_1_DOTW_Msk = 0x7000000
	// Position of HOUR field.
	RTC_SETUP_1_HOUR_Pos = 0x10
	// Bit mask of HOUR field.
	RTC_SETUP_1_HOUR_Msk = 0x1f0000
	// Position of MIN field.
	RTC_SETUP_1_MIN_Pos = 0x8
	// Bit mask of MIN field.
	RTC_SETUP_1_MIN_Msk = 0x3f00
	// Position of SEC field.
	RTC_SETUP_1_SEC_Pos = 0x0
	// Bit mask of SEC field.
	RTC_SETUP_1_SEC_Msk = 0x3f

	// CTRL: RTC Control and status
	// Position of FORCE_NOTLEAPYEAR field.
	RTC_CTRL_FORCE_NOTLEAPYEAR_Pos = 0x8
	// Bit mask of FORCE_NOTLEAPYEAR field.
	RTC_CTRL_FORCE_NOTLEAPYEAR_Msk = 0x100
	// Bit FORCE_NOTLEAPYEAR.
	RTC_CTRL_FORCE_NOTLEAPYEAR = 0x100
	// Position of LOAD field.
	RTC_CTRL_LOAD_Pos = 0x4
	// Bit mask of LOAD field.
	RTC_CTRL_LOAD_Msk = 0x10
	// Bit LOAD.
	RTC_CTRL_LOAD = 0x10
	// Position of RTC_ACTIVE field.
	RTC_CTRL_RTC_ACTIVE_Pos = 0x1
	// Bit mask of RTC_ACTIVE field.
	RTC_CTRL_RTC_ACTIVE_Msk = 0x2
	// Bit RTC_ACTIVE.
	RTC_CTRL_RTC_ACTIVE = 0x2
	// Position of RTC_ENABLE field.
	RTC_CTRL_RTC_ENABLE_Pos = 0x0
	// Bit mask of RTC_ENABLE field.
	RTC_CTRL_RTC_ENABLE_Msk = 0x1
	// Bit RTC_ENABLE.
	RTC_CTRL_RTC_ENABLE = 0x1

	// IRQ_SETUP_0: Interrupt setup register 0
	// Position of MATCH_ACTIVE field.
	RTC_IRQ_SETUP_0_MATCH_ACTIVE_Pos = 0x1d
	// Bit mask of MATCH_ACTIVE field.
	RTC_IRQ_SETUP_0_MATCH_ACTIVE_Msk = 0x20000000
	// Bit MATCH_ACTIVE.
	RTC_IRQ_SETUP_0_MATCH_ACTIVE = 0x20000000
	// Position of MATCH_ENA field.
	RTC_IRQ_SETUP_0_MATCH_ENA_Pos = 0x1c
	// Bit mask of MATCH_ENA field.
	RTC_IRQ_SETUP_0_MATCH_ENA_Msk = 0x10000000
	// Bit MATCH_ENA.
	RTC_IRQ_SETUP_0_MATCH_ENA = 0x10000000
	// Position of YEAR_ENA field.
	RTC_IRQ_SETUP_0_YEAR_ENA_Pos = 0x1a
	// Bit mask of YEAR_ENA field.
	RTC_IRQ_SETUP_0_YEAR_ENA_Msk = 0x4000000
	// Bit YEAR_ENA.
	RTC_IRQ_SETUP_0_YEAR_ENA = 0x4000000
	// Position of MONTH_ENA field.
	RTC_IRQ_SETUP_0_MONTH_ENA_Pos = 0x19
	// Bit mask of MONTH_ENA field.
	RTC_IRQ_SETUP_0_MONTH_ENA_Msk = 0x2000000
	// Bit MONTH_ENA.
	RTC_IRQ_SETUP_0_MONTH_ENA = 0x2000000
	// Position of DAY_ENA field.
	RTC_IRQ_SETUP_0_DAY_ENA_Pos = 0x18
	// Bit mask of DAY_ENA field.
	RTC_IRQ_SETUP_0_DAY_ENA_Msk = 0x1000000
	// Bit DAY_ENA.
	RTC_IRQ_SETUP_0_DAY_ENA = 0x1000000
	// Position of YEAR field.
	RTC_IRQ_SETUP_0_YEAR_Pos = 0xc
	// Bit mask of YEAR field.
	RTC_IRQ_SETUP_0_YEAR_Msk = 0xfff000
	// Position of MONTH field.
	RTC_IRQ_SETUP_0_MONTH_Pos = 0x8
	// Bit mask of MONTH field.
	RTC_IRQ_SETUP_0_MONTH_Msk = 0xf00
	// Position of DAY field.
	RTC_IRQ_SETUP_0_DAY_Pos = 0x0
	// Bit mask of DAY field.
	RTC_IRQ_SETUP_0_DAY_Msk = 0x1f

	// IRQ_SETUP_1: Interrupt setup register 1
	// Position of DOTW_ENA field.
	RTC_IRQ_SETUP_1_DOTW_ENA_Pos = 0x1f
	// Bit mask of DOTW_ENA field.
	RTC_IRQ_SETUP_1_DOTW_ENA_Msk = 0x80000000
	// Bit DOTW_ENA.
	RTC_IRQ_SETUP_1_DOTW_ENA = 0x80000000
	// Position of HOUR_ENA field.
	RTC_IRQ_SETUP_1_HOUR_ENA_Pos = 0x1e
	// Bit mask of HOUR_ENA field.
	RTC_IRQ_SETUP_1_HOUR_ENA_Msk = 0x40000000
	// Bit HOUR_ENA.
	RTC_IRQ_SETUP_1_HOUR_ENA = 0x40000000
	// Position of MIN_ENA field.
	RTC_IRQ_SETUP_1_MIN_ENA_Pos = 0x1d
	// Bit mask of MIN_ENA field.
	RTC_IRQ_SETUP_1_MIN_ENA_Msk = 0x20000000
	// Bit MIN_ENA.
	RTC_IRQ_SETUP_1_MIN_ENA = 0x20000000
	// Position of SEC_ENA field.
	RTC_IRQ_SETUP_1_SEC_ENA_Pos = 0x1c
	// Bit mask of SEC_ENA field.
	RTC_IRQ_SETUP_1_SEC_ENA_Msk = 0x10000000
	// Bit SEC_ENA.
	RTC_IRQ_SETUP_1_SEC_ENA = 0x10000000
	// Position of DOTW field.
	RTC_IRQ_SETUP_1_DOTW_Pos = 0x18
	// Bit mask of DOTW field.
	RTC_IRQ_SETUP_1_DOTW_Msk = 0x7000000
	// Position of HOUR field.
	RTC_IRQ_SETUP_1_HOUR_Pos = 0x10
	// Bit mask of HOUR field.
	RTC_IRQ_SETUP_1_HOUR_Msk = 0x1f0000
	// Position of MIN field.
	RTC_IRQ_SETUP_1_MIN_Pos = 0x8
	// Bit mask of MIN field.
	RTC_IRQ_SETUP_1_MIN_Msk = 0x3f00
	// Position of SEC field.
	RTC_IRQ_SETUP_1_SEC_Pos = 0x0
	// Bit mask of SEC field.
	RTC_IRQ_SETUP_1_SEC_Msk = 0x3f

	// RTC_1: RTC register 1.
	// Position of YEAR field.
	RTC_RTC_1_YEAR_Pos = 0xc
	// Bit mask of YEAR field.
	RTC_RTC_1_YEAR_Msk = 0xfff000
	// Position of MONTH field.
	RTC_RTC_1_MONTH_Pos = 0x8
	// Bit mask of MONTH field.
	RTC_RTC_1_MONTH_Msk = 0xf00
	// Position of DAY field.
	RTC_RTC_1_DAY_Pos = 0x0
	// Bit mask of DAY field.
	RTC_RTC_1_DAY_Msk = 0x1f

	// RTC_0
	// RTC register 0
	// Read this before RTC 1!
	// Position of DOTW field.
	RTC_RTC_0_DOTW_Pos = 0x18
	// Bit mask of DOTW field.
	RTC_RTC_0_DOTW_Msk = 0x7000000
	// Position of HOUR field.
	RTC_RTC_0_HOUR_Pos = 0x10
	// Bit mask of HOUR field.
	RTC_RTC_0_HOUR_Msk = 0x1f0000
	// Position of MIN field.
	RTC_RTC_0_MIN_Pos = 0x8
	// Bit mask of MIN field.
	RTC_RTC_0_MIN_Msk = 0x3f00
	// Position of SEC field.
	RTC_RTC_0_SEC_Pos = 0x0
	// Bit mask of SEC field.
	RTC_RTC_0_SEC_Msk = 0x3f

	// INTR: Raw Interrupts
	// Position of RTC field.
	RTC_INTR_RTC_Pos = 0x0
	// Bit mask of RTC field.
	RTC_INTR_RTC_Msk = 0x1
	// Bit RTC.
	RTC_INTR_RTC = 0x1

	// INTE: Interrupt Enable
	// Position of RTC field.
	RTC_INTE_RTC_Pos = 0x0
	// Bit mask of RTC field.
	RTC_INTE_RTC_Msk = 0x1
	// Bit RTC.
	RTC_INTE_RTC = 0x1

	// INTF: Interrupt Force
	// Position of RTC field.
	RTC_INTF_RTC_Pos = 0x0
	// Bit mask of RTC field.
	RTC_INTF_RTC_Msk = 0x1
	// Bit RTC.
	RTC_INTF_RTC = 0x1

	// INTS: Interrupt status after masking & forcing
	// Position of RTC field.
	RTC_INTS_RTC_Pos = 0x0
	// Bit mask of RTC field.
	RTC_INTS_RTC_Msk = 0x1
	// Bit RTC.
	RTC_INTS_RTC = 0x1
)

// Bitfields for ROSC
const (
	// CTRL: Ring Oscillator control
	// Position of ENABLE field.
	ROSC_CTRL_ENABLE_Pos = 0xc
	// Bit mask of ENABLE field.
	ROSC_CTRL_ENABLE_Msk     = 0xfff000
	ROSC_CTRL_ENABLE_DISABLE = 0xd1e
	ROSC_CTRL_ENABLE_ENABLE  = 0xfab
	// Position of FREQ_RANGE field.
	ROSC_CTRL_FREQ_RANGE_Pos = 0x0
	// Bit mask of FREQ_RANGE field.
	ROSC_CTRL_FREQ_RANGE_Msk     = 0xfff
	ROSC_CTRL_FREQ_RANGE_LOW     = 0xfa4
	ROSC_CTRL_FREQ_RANGE_MEDIUM  = 0xfa5
	ROSC_CTRL_FREQ_RANGE_HIGH    = 0xfa7
	ROSC_CTRL_FREQ_RANGE_TOOHIGH = 0xfa6

	// FREQA
	// The FREQA & FREQB registers control the frequency by controlling the drive strength of each stage
	// The drive strength has 4 levels determined by the number of bits set
	// Increasing the number of bits set increases the drive strength and increases the oscillation frequency
	// 0 bits set is the default drive strength
	// 1 bit set doubles the drive strength
	// 2 bits set triples drive strength
	// 3 bits set quadruples drive strength
	// Position of PASSWD field.
	ROSC_FREQA_PASSWD_Pos = 0x10
	// Bit mask of PASSWD field.
	ROSC_FREQA_PASSWD_Msk  = 0xffff0000
	ROSC_FREQA_PASSWD_PASS = 0x9696
	// Position of DS3 field.
	ROSC_FREQA_DS3_Pos = 0xc
	// Bit mask of DS3 field.
	ROSC_FREQA_DS3_Msk = 0x7000
	// Position of DS2 field.
	ROSC_FREQA_DS2_Pos = 0x8
	// Bit mask of DS2 field.
	ROSC_FREQA_DS2_Msk = 0x700
	// Position of DS1 field.
	ROSC_FREQA_DS1_Pos = 0x4
	// Bit mask of DS1 field.
	ROSC_FREQA_DS1_Msk = 0x70
	// Position of DS0 field.
	ROSC_FREQA_DS0_Pos = 0x0
	// Bit mask of DS0 field.
	ROSC_FREQA_DS0_Msk = 0x7

	// FREQB: For a detailed description see freqa register
	// Position of PASSWD field.
	ROSC_FREQB_PASSWD_Pos = 0x10
	// Bit mask of PASSWD field.
	ROSC_FREQB_PASSWD_Msk  = 0xffff0000
	ROSC_FREQB_PASSWD_PASS = 0x9696
	// Position of DS7 field.
	ROSC_FREQB_DS7_Pos = 0xc
	// Bit mask of DS7 field.
	ROSC_FREQB_DS7_Msk = 0x7000
	// Position of DS6 field.
	ROSC_FREQB_DS6_Pos = 0x8
	// Bit mask of DS6 field.
	ROSC_FREQB_DS6_Msk = 0x700
	// Position of DS5 field.
	ROSC_FREQB_DS5_Pos = 0x4
	// Bit mask of DS5 field.
	ROSC_FREQB_DS5_Msk = 0x70
	// Position of DS4 field.
	ROSC_FREQB_DS4_Pos = 0x0
	// Bit mask of DS4 field.
	ROSC_FREQB_DS4_Msk = 0x7

	// DIV: Controls the output divider
	// Position of DIV field.
	ROSC_DIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	ROSC_DIV_DIV_Msk  = 0xfff
	ROSC_DIV_DIV_PASS = 0xaa0

	// PHASE: Controls the phase shifted output
	// Position of PASSWD field.
	ROSC_PHASE_PASSWD_Pos = 0x4
	// Bit mask of PASSWD field.
	ROSC_PHASE_PASSWD_Msk = 0xff0
	// Position of ENABLE field.
	ROSC_PHASE_ENABLE_Pos = 0x3
	// Bit mask of ENABLE field.
	ROSC_PHASE_ENABLE_Msk = 0x8
	// Bit ENABLE.
	ROSC_PHASE_ENABLE = 0x8
	// Position of FLIP field.
	ROSC_PHASE_FLIP_Pos = 0x2
	// Bit mask of FLIP field.
	ROSC_PHASE_FLIP_Msk = 0x4
	// Bit FLIP.
	ROSC_PHASE_FLIP = 0x4
	// Position of SHIFT field.
	ROSC_PHASE_SHIFT_Pos = 0x0
	// Bit mask of SHIFT field.
	ROSC_PHASE_SHIFT_Msk = 0x3

	// STATUS: Ring Oscillator Status
	// Position of STABLE field.
	ROSC_STATUS_STABLE_Pos = 0x1f
	// Bit mask of STABLE field.
	ROSC_STATUS_STABLE_Msk = 0x80000000
	// Bit STABLE.
	ROSC_STATUS_STABLE = 0x80000000
	// Position of BADWRITE field.
	ROSC_STATUS_BADWRITE_Pos = 0x18
	// Bit mask of BADWRITE field.
	ROSC_STATUS_BADWRITE_Msk = 0x1000000
	// Bit BADWRITE.
	ROSC_STATUS_BADWRITE = 0x1000000
	// Position of DIV_RUNNING field.
	ROSC_STATUS_DIV_RUNNING_Pos = 0x10
	// Bit mask of DIV_RUNNING field.
	ROSC_STATUS_DIV_RUNNING_Msk = 0x10000
	// Bit DIV_RUNNING.
	ROSC_STATUS_DIV_RUNNING = 0x10000
	// Position of ENABLED field.
	ROSC_STATUS_ENABLED_Pos = 0xc
	// Bit mask of ENABLED field.
	ROSC_STATUS_ENABLED_Msk = 0x1000
	// Bit ENABLED.
	ROSC_STATUS_ENABLED = 0x1000

	// RANDOMBIT: This just reads the state of the oscillator output so randomness is compromised if the ring oscillator is stopped or run at a harmonic of the bus frequency
	// Position of RANDOMBIT field.
	ROSC_RANDOMBIT_RANDOMBIT_Pos = 0x0
	// Bit mask of RANDOMBIT field.
	ROSC_RANDOMBIT_RANDOMBIT_Msk = 0x1
	// Bit RANDOMBIT.
	ROSC_RANDOMBIT_RANDOMBIT = 0x1

	// COUNT
	// A down counter running at the ROSC frequency which counts to zero and stops.
	// To start the counter write a non-zero value.
	// Can be used for short software pauses when setting up time sensitive hardware.
	// Position of COUNT field.
	ROSC_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	ROSC_COUNT_COUNT_Msk = 0xff
)

// Bitfields for VREG_AND_CHIP_RESET: control and status for on-chip voltage regulator and chip level reset subsystem
const (
	// VREG: Voltage regulator control and status
	// Position of ROK field.
	VREG_AND_CHIP_RESET_VREG_ROK_Pos = 0xc
	// Bit mask of ROK field.
	VREG_AND_CHIP_RESET_VREG_ROK_Msk = 0x1000
	// Bit ROK.
	VREG_AND_CHIP_RESET_VREG_ROK = 0x1000
	// Position of VSEL field.
	VREG_AND_CHIP_RESET_VREG_VSEL_Pos = 0x4
	// Bit mask of VSEL field.
	VREG_AND_CHIP_RESET_VREG_VSEL_Msk = 0xf0
	// Position of HIZ field.
	VREG_AND_CHIP_RESET_VREG_HIZ_Pos = 0x1
	// Bit mask of HIZ field.
	VREG_AND_CHIP_RESET_VREG_HIZ_Msk = 0x2
	// Bit HIZ.
	VREG_AND_CHIP_RESET_VREG_HIZ = 0x2
	// Position of EN field.
	VREG_AND_CHIP_RESET_VREG_EN_Pos = 0x0
	// Bit mask of EN field.
	VREG_AND_CHIP_RESET_VREG_EN_Msk = 0x1
	// Bit EN.
	VREG_AND_CHIP_RESET_VREG_EN = 0x1

	// BOD: brown-out detection control
	// Position of VSEL field.
	VREG_AND_CHIP_RESET_BOD_VSEL_Pos = 0x4
	// Bit mask of VSEL field.
	VREG_AND_CHIP_RESET_BOD_VSEL_Msk = 0xf0
	// Position of EN field.
	VREG_AND_CHIP_RESET_BOD_EN_Pos = 0x0
	// Bit mask of EN field.
	VREG_AND_CHIP_RESET_BOD_EN_Msk = 0x1
	// Bit EN.
	VREG_AND_CHIP_RESET_BOD_EN = 0x1

	// CHIP_RESET: Chip reset control and status
	// Position of PSM_RESTART_FLAG field.
	VREG_AND_CHIP_RESET_CHIP_RESET_PSM_RESTART_FLAG_Pos = 0x18
	// Bit mask of PSM_RESTART_FLAG field.
	VREG_AND_CHIP_RESET_CHIP_RESET_PSM_RESTART_FLAG_Msk = 0x1000000
	// Bit PSM_RESTART_FLAG.
	VREG_AND_CHIP_RESET_CHIP_RESET_PSM_RESTART_FLAG = 0x1000000
	// Position of HAD_PSM_RESTART field.
	VREG_AND_CHIP_RESET_CHIP_RESET_HAD_PSM_RESTART_Pos = 0x14
	// Bit mask of HAD_PSM_RESTART field.
	VREG_AND_CHIP_RESET_CHIP_RESET_HAD_PSM_RESTART_Msk = 0x100000
	// Bit HAD_PSM_RESTART.
	VREG_AND_CHIP_RESET_CHIP_RESET_HAD_PSM_RESTART = 0x100000
	// Position of HAD_RUN field.
	VREG_AND_CHIP_RESET_CHIP_RESET_HAD_RUN_Pos = 0x10
	// Bit mask of HAD_RUN field.
	VREG_AND_CHIP_RESET_CHIP_RESET_HAD_RUN_Msk = 0x10000
	// Bit HAD_RUN.
	VREG_AND_CHIP_RESET_CHIP_RESET_HAD_RUN = 0x10000
	// Position of HAD_POR field.
	VREG_AND_CHIP_RESET_CHIP_RESET_HAD_POR_Pos = 0x8
	// Bit mask of HAD_POR field.
	VREG_AND_CHIP_RESET_CHIP_RESET_HAD_POR_Msk = 0x100
	// Bit HAD_POR.
	VREG_AND_CHIP_RESET_CHIP_RESET_HAD_POR = 0x100
)

// Bitfields for TBMAN: Testbench manager. Allows the programmer to know what platform their software is running on.
const (
	// PLATFORM: Indicates the type of platform in use
	// Position of FPGA field.
	TBMAN_PLATFORM_FPGA_Pos = 0x1
	// Bit mask of FPGA field.
	TBMAN_PLATFORM_FPGA_Msk = 0x2
	// Bit FPGA.
	TBMAN_PLATFORM_FPGA = 0x2
	// Position of ASIC field.
	TBMAN_PLATFORM_ASIC_Pos = 0x0
	// Bit mask of ASIC field.
	TBMAN_PLATFORM_ASIC_Msk = 0x1
	// Bit ASIC.
	TBMAN_PLATFORM_ASIC = 0x1
)

// Bitfields for DMA: DMA with separate read and write masters
const (
	// CH0_CTRL_TRIG: DMA Channel 0 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH0_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH0_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH0_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH0_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH0_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH0_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH0_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH0_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH0_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH0_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH0_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH0_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH0_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH0_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH0_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH0_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH0_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH0_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH0_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH0_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH0_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH0_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH0_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH0_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH0_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH0_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH0_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH0_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH0_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH0_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH0_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH0_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH0_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH0_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH0_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH0_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH0_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH0_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH0_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH0_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH0_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH0_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH0_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH0_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH0_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH0_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH0_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH0_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH0_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH0_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH0_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH0_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH0_CTRL_TRIG_EN = 0x1

	// CH1_CTRL_TRIG: DMA Channel 1 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH1_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH1_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH1_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH1_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH1_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH1_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH1_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH1_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH1_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH1_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH1_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH1_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH1_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH1_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH1_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH1_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH1_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH1_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH1_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH1_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH1_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH1_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH1_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH1_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH1_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH1_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH1_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH1_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH1_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH1_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH1_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH1_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH1_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH1_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH1_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH1_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH1_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH1_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH1_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH1_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH1_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH1_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH1_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH1_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH1_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH1_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH1_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH1_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH1_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH1_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH1_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH1_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH1_CTRL_TRIG_EN = 0x1

	// CH2_CTRL_TRIG: DMA Channel 2 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH2_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH2_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH2_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH2_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH2_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH2_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH2_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH2_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH2_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH2_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH2_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH2_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH2_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH2_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH2_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH2_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH2_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH2_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH2_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH2_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH2_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH2_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH2_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH2_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH2_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH2_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH2_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH2_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH2_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH2_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH2_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH2_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH2_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH2_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH2_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH2_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH2_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH2_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH2_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH2_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH2_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH2_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH2_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH2_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH2_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH2_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH2_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH2_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH2_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH2_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH2_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH2_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH2_CTRL_TRIG_EN = 0x1

	// CH3_CTRL_TRIG: DMA Channel 3 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH3_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH3_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH3_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH3_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH3_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH3_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH3_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH3_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH3_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH3_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH3_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH3_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH3_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH3_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH3_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH3_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH3_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH3_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH3_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH3_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH3_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH3_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH3_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH3_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH3_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH3_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH3_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH3_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH3_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH3_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH3_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH3_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH3_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH3_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH3_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH3_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH3_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH3_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH3_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH3_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH3_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH3_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH3_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH3_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH3_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH3_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH3_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH3_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH3_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH3_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH3_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH3_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH3_CTRL_TRIG_EN = 0x1

	// CH4_CTRL_TRIG: DMA Channel 4 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH4_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH4_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH4_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH4_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH4_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH4_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH4_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH4_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH4_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH4_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH4_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH4_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH4_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH4_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH4_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH4_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH4_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH4_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH4_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH4_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH4_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH4_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH4_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH4_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH4_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH4_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH4_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH4_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH4_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH4_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH4_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH4_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH4_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH4_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH4_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH4_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH4_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH4_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH4_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH4_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH4_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH4_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH4_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH4_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH4_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH4_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH4_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH4_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH4_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH4_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH4_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH4_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH4_CTRL_TRIG_EN = 0x1

	// CH5_CTRL_TRIG: DMA Channel 5 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH5_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH5_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH5_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH5_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH5_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH5_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH5_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH5_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH5_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH5_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH5_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH5_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH5_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH5_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH5_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH5_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH5_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH5_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH5_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH5_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH5_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH5_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH5_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH5_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH5_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH5_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH5_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH5_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH5_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH5_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH5_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH5_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH5_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH5_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH5_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH5_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH5_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH5_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH5_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH5_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH5_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH5_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH5_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH5_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH5_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH5_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH5_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH5_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH5_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH5_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH5_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH5_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH5_CTRL_TRIG_EN = 0x1

	// CH6_CTRL_TRIG: DMA Channel 6 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH6_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH6_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH6_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH6_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH6_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH6_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH6_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH6_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH6_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH6_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH6_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH6_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH6_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH6_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH6_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH6_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH6_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH6_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH6_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH6_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH6_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH6_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH6_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH6_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH6_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH6_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH6_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH6_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH6_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH6_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH6_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH6_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH6_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH6_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH6_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH6_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH6_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH6_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH6_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH6_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH6_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH6_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH6_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH6_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH6_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH6_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH6_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH6_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH6_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH6_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH6_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH6_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH6_CTRL_TRIG_EN = 0x1

	// CH7_CTRL_TRIG: DMA Channel 7 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH7_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH7_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH7_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH7_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH7_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH7_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH7_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH7_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH7_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH7_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH7_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH7_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH7_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH7_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH7_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH7_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH7_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH7_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH7_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH7_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH7_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH7_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH7_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH7_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH7_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH7_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH7_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH7_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH7_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH7_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH7_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH7_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH7_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH7_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH7_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH7_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH7_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH7_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH7_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH7_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH7_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH7_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH7_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH7_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH7_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH7_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH7_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH7_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH7_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH7_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH7_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH7_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH7_CTRL_TRIG_EN = 0x1

	// CH8_CTRL_TRIG: DMA Channel 8 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH8_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH8_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH8_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH8_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH8_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH8_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH8_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH8_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH8_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH8_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH8_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH8_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH8_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH8_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH8_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH8_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH8_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH8_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH8_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH8_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH8_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH8_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH8_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH8_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH8_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH8_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH8_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH8_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH8_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH8_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH8_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH8_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH8_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH8_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH8_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH8_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH8_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH8_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH8_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH8_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH8_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH8_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH8_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH8_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH8_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH8_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH8_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH8_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH8_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH8_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH8_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH8_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH8_CTRL_TRIG_EN = 0x1

	// CH9_CTRL_TRIG: DMA Channel 9 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH9_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH9_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH9_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH9_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH9_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH9_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH9_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH9_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH9_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH9_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH9_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH9_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH9_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH9_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH9_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH9_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH9_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH9_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH9_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH9_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH9_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH9_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH9_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH9_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH9_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH9_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH9_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH9_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH9_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH9_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH9_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH9_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH9_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH9_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH9_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH9_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH9_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH9_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH9_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH9_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH9_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH9_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH9_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH9_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH9_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH9_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH9_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH9_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH9_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH9_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH9_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH9_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH9_CTRL_TRIG_EN = 0x1

	// CH10_CTRL_TRIG: DMA Channel 10 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH10_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH10_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH10_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH10_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH10_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH10_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH10_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH10_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH10_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH10_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH10_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH10_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH10_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH10_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH10_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH10_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH10_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH10_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH10_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH10_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH10_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH10_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH10_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH10_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH10_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH10_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH10_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH10_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH10_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH10_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH10_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH10_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH10_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH10_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH10_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH10_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH10_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH10_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH10_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH10_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH10_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH10_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH10_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH10_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH10_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH10_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH10_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH10_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH10_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH10_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH10_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH10_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH10_CTRL_TRIG_EN = 0x1

	// CH11_CTRL_TRIG: DMA Channel 11 Control and Status
	// Position of AHB_ERROR field.
	DMA_CH11_CTRL_TRIG_AHB_ERROR_Pos = 0x1f
	// Bit mask of AHB_ERROR field.
	DMA_CH11_CTRL_TRIG_AHB_ERROR_Msk = 0x80000000
	// Bit AHB_ERROR.
	DMA_CH11_CTRL_TRIG_AHB_ERROR = 0x80000000
	// Position of READ_ERROR field.
	DMA_CH11_CTRL_TRIG_READ_ERROR_Pos = 0x1e
	// Bit mask of READ_ERROR field.
	DMA_CH11_CTRL_TRIG_READ_ERROR_Msk = 0x40000000
	// Bit READ_ERROR.
	DMA_CH11_CTRL_TRIG_READ_ERROR = 0x40000000
	// Position of WRITE_ERROR field.
	DMA_CH11_CTRL_TRIG_WRITE_ERROR_Pos = 0x1d
	// Bit mask of WRITE_ERROR field.
	DMA_CH11_CTRL_TRIG_WRITE_ERROR_Msk = 0x20000000
	// Bit WRITE_ERROR.
	DMA_CH11_CTRL_TRIG_WRITE_ERROR = 0x20000000
	// Position of BUSY field.
	DMA_CH11_CTRL_TRIG_BUSY_Pos = 0x18
	// Bit mask of BUSY field.
	DMA_CH11_CTRL_TRIG_BUSY_Msk = 0x1000000
	// Bit BUSY.
	DMA_CH11_CTRL_TRIG_BUSY = 0x1000000
	// Position of SNIFF_EN field.
	DMA_CH11_CTRL_TRIG_SNIFF_EN_Pos = 0x17
	// Bit mask of SNIFF_EN field.
	DMA_CH11_CTRL_TRIG_SNIFF_EN_Msk = 0x800000
	// Bit SNIFF_EN.
	DMA_CH11_CTRL_TRIG_SNIFF_EN = 0x800000
	// Position of BSWAP field.
	DMA_CH11_CTRL_TRIG_BSWAP_Pos = 0x16
	// Bit mask of BSWAP field.
	DMA_CH11_CTRL_TRIG_BSWAP_Msk = 0x400000
	// Bit BSWAP.
	DMA_CH11_CTRL_TRIG_BSWAP = 0x400000
	// Position of IRQ_QUIET field.
	DMA_CH11_CTRL_TRIG_IRQ_QUIET_Pos = 0x15
	// Bit mask of IRQ_QUIET field.
	DMA_CH11_CTRL_TRIG_IRQ_QUIET_Msk = 0x200000
	// Bit IRQ_QUIET.
	DMA_CH11_CTRL_TRIG_IRQ_QUIET = 0x200000
	// Position of TREQ_SEL field.
	DMA_CH11_CTRL_TRIG_TREQ_SEL_Pos = 0xf
	// Bit mask of TREQ_SEL field.
	DMA_CH11_CTRL_TRIG_TREQ_SEL_Msk = 0x1f8000
	// Select Timer 0 as TREQ
	DMA_CH11_CTRL_TRIG_TREQ_SEL_TIMER0 = 0x3b
	// Select Timer 1 as TREQ
	DMA_CH11_CTRL_TRIG_TREQ_SEL_TIMER1 = 0x3c
	// Select Timer 2 as TREQ (Optional)
	DMA_CH11_CTRL_TRIG_TREQ_SEL_TIMER2 = 0x3d
	// Select Timer 3 as TREQ (Optional)
	DMA_CH11_CTRL_TRIG_TREQ_SEL_TIMER3 = 0x3e
	// Permanent request, for unpaced transfers.
	DMA_CH11_CTRL_TRIG_TREQ_SEL_PERMANENT = 0x3f
	// Position of CHAIN_TO field.
	DMA_CH11_CTRL_TRIG_CHAIN_TO_Pos = 0xb
	// Bit mask of CHAIN_TO field.
	DMA_CH11_CTRL_TRIG_CHAIN_TO_Msk = 0x7800
	// Position of RING_SEL field.
	DMA_CH11_CTRL_TRIG_RING_SEL_Pos = 0xa
	// Bit mask of RING_SEL field.
	DMA_CH11_CTRL_TRIG_RING_SEL_Msk = 0x400
	// Bit RING_SEL.
	DMA_CH11_CTRL_TRIG_RING_SEL = 0x400
	// Position of RING_SIZE field.
	DMA_CH11_CTRL_TRIG_RING_SIZE_Pos = 0x6
	// Bit mask of RING_SIZE field.
	DMA_CH11_CTRL_TRIG_RING_SIZE_Msk       = 0x3c0
	DMA_CH11_CTRL_TRIG_RING_SIZE_RING_NONE = 0x0
	// Position of INCR_WRITE field.
	DMA_CH11_CTRL_TRIG_INCR_WRITE_Pos = 0x5
	// Bit mask of INCR_WRITE field.
	DMA_CH11_CTRL_TRIG_INCR_WRITE_Msk = 0x20
	// Bit INCR_WRITE.
	DMA_CH11_CTRL_TRIG_INCR_WRITE = 0x20
	// Position of INCR_READ field.
	DMA_CH11_CTRL_TRIG_INCR_READ_Pos = 0x4
	// Bit mask of INCR_READ field.
	DMA_CH11_CTRL_TRIG_INCR_READ_Msk = 0x10
	// Bit INCR_READ.
	DMA_CH11_CTRL_TRIG_INCR_READ = 0x10
	// Position of DATA_SIZE field.
	DMA_CH11_CTRL_TRIG_DATA_SIZE_Pos = 0x2
	// Bit mask of DATA_SIZE field.
	DMA_CH11_CTRL_TRIG_DATA_SIZE_Msk           = 0xc
	DMA_CH11_CTRL_TRIG_DATA_SIZE_SIZE_BYTE     = 0x0
	DMA_CH11_CTRL_TRIG_DATA_SIZE_SIZE_HALFWORD = 0x1
	DMA_CH11_CTRL_TRIG_DATA_SIZE_SIZE_WORD     = 0x2
	// Position of HIGH_PRIORITY field.
	DMA_CH11_CTRL_TRIG_HIGH_PRIORITY_Pos = 0x1
	// Bit mask of HIGH_PRIORITY field.
	DMA_CH11_CTRL_TRIG_HIGH_PRIORITY_Msk = 0x2
	// Bit HIGH_PRIORITY.
	DMA_CH11_CTRL_TRIG_HIGH_PRIORITY = 0x2
	// Position of EN field.
	DMA_CH11_CTRL_TRIG_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH11_CTRL_TRIG_EN_Msk = 0x1
	// Bit EN.
	DMA_CH11_CTRL_TRIG_EN = 0x1

	// INTR: Interrupt Status (raw)
	// Position of INTR field.
	DMA_INTR_INTR_Pos = 0x0
	// Bit mask of INTR field.
	DMA_INTR_INTR_Msk = 0xffff

	// INTE0: Interrupt Enables for IRQ 0
	// Position of INTE0 field.
	DMA_INTE0_INTE0_Pos = 0x0
	// Bit mask of INTE0 field.
	DMA_INTE0_INTE0_Msk = 0xffff

	// INTF0: Force Interrupts
	// Position of INTF0 field.
	DMA_INTF0_INTF0_Pos = 0x0
	// Bit mask of INTF0 field.
	DMA_INTF0_INTF0_Msk = 0xffff

	// INTS0: Interrupt Status for IRQ 0
	// Position of INTS0 field.
	DMA_INTS0_INTS0_Pos = 0x0
	// Bit mask of INTS0 field.
	DMA_INTS0_INTS0_Msk = 0xffff

	// INTE1: Interrupt Enables for IRQ 1
	// Position of INTE1 field.
	DMA_INTE1_INTE1_Pos = 0x0
	// Bit mask of INTE1 field.
	DMA_INTE1_INTE1_Msk = 0xffff

	// INTF1: Force Interrupts for IRQ 1
	// Position of INTF1 field.
	DMA_INTF1_INTF1_Pos = 0x0
	// Bit mask of INTF1 field.
	DMA_INTF1_INTF1_Msk = 0xffff

	// INTS1: Interrupt Status (masked) for IRQ 1
	// Position of INTS1 field.
	DMA_INTS1_INTS1_Pos = 0x0
	// Bit mask of INTS1 field.
	DMA_INTS1_INTS1_Msk = 0xffff

	// TIMER0
	// Pacing (X/Y) Fractional Timer
	// The pacing timer produces TREQ assertions at a rate set by ((X/Y) * sys_clk). This equation is evaluated every sys_clk cycles and therefore can only generate TREQs at a rate of 1 per sys_clk (i.e. permanent TREQ) or less.
	// Position of X field.
	DMA_TIMER0_X_Pos = 0x10
	// Bit mask of X field.
	DMA_TIMER0_X_Msk = 0xffff0000
	// Position of Y field.
	DMA_TIMER0_Y_Pos = 0x0
	// Bit mask of Y field.
	DMA_TIMER0_Y_Msk = 0xffff

	// TIMER1
	// Pacing (X/Y) Fractional Timer
	// The pacing timer produces TREQ assertions at a rate set by ((X/Y) * sys_clk). This equation is evaluated every sys_clk cycles and therefore can only generate TREQs at a rate of 1 per sys_clk (i.e. permanent TREQ) or less.
	// Position of X field.
	DMA_TIMER1_X_Pos = 0x10
	// Bit mask of X field.
	DMA_TIMER1_X_Msk = 0xffff0000
	// Position of Y field.
	DMA_TIMER1_Y_Pos = 0x0
	// Bit mask of Y field.
	DMA_TIMER1_Y_Msk = 0xffff

	// MULTI_CHAN_TRIGGER: Trigger one or more channels simultaneously
	// Position of MULTI_CHAN_TRIGGER field.
	DMA_MULTI_CHAN_TRIGGER_MULTI_CHAN_TRIGGER_Pos = 0x0
	// Bit mask of MULTI_CHAN_TRIGGER field.
	DMA_MULTI_CHAN_TRIGGER_MULTI_CHAN_TRIGGER_Msk = 0xffff

	// SNIFF_CTRL: Sniffer Control
	// Position of OUT_INV field.
	DMA_SNIFF_CTRL_OUT_INV_Pos = 0xb
	// Bit mask of OUT_INV field.
	DMA_SNIFF_CTRL_OUT_INV_Msk = 0x800
	// Bit OUT_INV.
	DMA_SNIFF_CTRL_OUT_INV = 0x800
	// Position of OUT_REV field.
	DMA_SNIFF_CTRL_OUT_REV_Pos = 0xa
	// Bit mask of OUT_REV field.
	DMA_SNIFF_CTRL_OUT_REV_Msk = 0x400
	// Bit OUT_REV.
	DMA_SNIFF_CTRL_OUT_REV = 0x400
	// Position of BSWAP field.
	DMA_SNIFF_CTRL_BSWAP_Pos = 0x9
	// Bit mask of BSWAP field.
	DMA_SNIFF_CTRL_BSWAP_Msk = 0x200
	// Bit BSWAP.
	DMA_SNIFF_CTRL_BSWAP = 0x200
	// Position of CALC field.
	DMA_SNIFF_CTRL_CALC_Pos = 0x5
	// Bit mask of CALC field.
	DMA_SNIFF_CTRL_CALC_Msk = 0x1e0
	// Calculate a CRC-32 (IEEE802.3 polynomial)
	DMA_SNIFF_CTRL_CALC_CRC32 = 0x0
	// Calculate a CRC-32 (IEEE802.3 polynomial) with bit reversed data
	DMA_SNIFF_CTRL_CALC_CRC32R = 0x1
	// Calculate a CRC-16-CCITT
	DMA_SNIFF_CTRL_CALC_CRC16 = 0x2
	// Calculate a CRC-16-CCITT with bit reversed data
	DMA_SNIFF_CTRL_CALC_CRC16R = 0x3
	// XOR reduction over all data. == 1 if the total 1 population count is odd.
	DMA_SNIFF_CTRL_CALC_EVEN = 0xe
	// Calculate a simple 32-bit checksum (addition with a 32 bit accumulator)
	DMA_SNIFF_CTRL_CALC_SUM = 0xf
	// Position of DMACH field.
	DMA_SNIFF_CTRL_DMACH_Pos = 0x1
	// Bit mask of DMACH field.
	DMA_SNIFF_CTRL_DMACH_Msk = 0x1e
	// Position of EN field.
	DMA_SNIFF_CTRL_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_SNIFF_CTRL_EN_Msk = 0x1
	// Bit EN.
	DMA_SNIFF_CTRL_EN = 0x1

	// FIFO_LEVELS: Debug RAF, WAF, TDF levels
	// Position of RAF_LVL field.
	DMA_FIFO_LEVELS_RAF_LVL_Pos = 0x10
	// Bit mask of RAF_LVL field.
	DMA_FIFO_LEVELS_RAF_LVL_Msk = 0xff0000
	// Position of WAF_LVL field.
	DMA_FIFO_LEVELS_WAF_LVL_Pos = 0x8
	// Bit mask of WAF_LVL field.
	DMA_FIFO_LEVELS_WAF_LVL_Msk = 0xff00
	// Position of TDF_LVL field.
	DMA_FIFO_LEVELS_TDF_LVL_Pos = 0x0
	// Bit mask of TDF_LVL field.
	DMA_FIFO_LEVELS_TDF_LVL_Msk = 0xff

	// CHAN_ABORT: Abort an in-progress transfer sequence on one or more channels
	// Position of CHAN_ABORT field.
	DMA_CHAN_ABORT_CHAN_ABORT_Pos = 0x0
	// Bit mask of CHAN_ABORT field.
	DMA_CHAN_ABORT_CHAN_ABORT_Msk = 0xffff

	// N_CHANNELS: The number of channels this DMA instance is equipped with. This DMA supports up to 16 hardware channels, but can be configured with as few as one, to minimise silicon area.
	// Position of N_CHANNELS field.
	DMA_N_CHANNELS_N_CHANNELS_Pos = 0x0
	// Bit mask of N_CHANNELS field.
	DMA_N_CHANNELS_N_CHANNELS_Msk = 0x1f

	// CH0_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH0_DBG_CTDREQ field.
	DMA_CH0_DBG_CTDREQ_CH0_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH0_DBG_CTDREQ field.
	DMA_CH0_DBG_CTDREQ_CH0_DBG_CTDREQ_Msk = 0x3f

	// CH1_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH1_DBG_CTDREQ field.
	DMA_CH1_DBG_CTDREQ_CH1_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH1_DBG_CTDREQ field.
	DMA_CH1_DBG_CTDREQ_CH1_DBG_CTDREQ_Msk = 0x3f

	// CH2_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH2_DBG_CTDREQ field.
	DMA_CH2_DBG_CTDREQ_CH2_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH2_DBG_CTDREQ field.
	DMA_CH2_DBG_CTDREQ_CH2_DBG_CTDREQ_Msk = 0x3f

	// CH3_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH3_DBG_CTDREQ field.
	DMA_CH3_DBG_CTDREQ_CH3_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH3_DBG_CTDREQ field.
	DMA_CH3_DBG_CTDREQ_CH3_DBG_CTDREQ_Msk = 0x3f

	// CH4_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH4_DBG_CTDREQ field.
	DMA_CH4_DBG_CTDREQ_CH4_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH4_DBG_CTDREQ field.
	DMA_CH4_DBG_CTDREQ_CH4_DBG_CTDREQ_Msk = 0x3f

	// CH5_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH5_DBG_CTDREQ field.
	DMA_CH5_DBG_CTDREQ_CH5_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH5_DBG_CTDREQ field.
	DMA_CH5_DBG_CTDREQ_CH5_DBG_CTDREQ_Msk = 0x3f

	// CH6_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH6_DBG_CTDREQ field.
	DMA_CH6_DBG_CTDREQ_CH6_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH6_DBG_CTDREQ field.
	DMA_CH6_DBG_CTDREQ_CH6_DBG_CTDREQ_Msk = 0x3f

	// CH7_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH7_DBG_CTDREQ field.
	DMA_CH7_DBG_CTDREQ_CH7_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH7_DBG_CTDREQ field.
	DMA_CH7_DBG_CTDREQ_CH7_DBG_CTDREQ_Msk = 0x3f

	// CH8_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH8_DBG_CTDREQ field.
	DMA_CH8_DBG_CTDREQ_CH8_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH8_DBG_CTDREQ field.
	DMA_CH8_DBG_CTDREQ_CH8_DBG_CTDREQ_Msk = 0x3f

	// CH9_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH9_DBG_CTDREQ field.
	DMA_CH9_DBG_CTDREQ_CH9_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH9_DBG_CTDREQ field.
	DMA_CH9_DBG_CTDREQ_CH9_DBG_CTDREQ_Msk = 0x3f

	// CH10_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH10_DBG_CTDREQ field.
	DMA_CH10_DBG_CTDREQ_CH10_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH10_DBG_CTDREQ field.
	DMA_CH10_DBG_CTDREQ_CH10_DBG_CTDREQ_Msk = 0x3f

	// CH11_DBG_CTDREQ: Read: get channel DREQ counter (i.e. how many accesses the DMA expects it can perform on the peripheral without overflow/underflow. Write any value: clears the counter, and cause channel to re-initiate DREQ handshake.
	// Position of CH11_DBG_CTDREQ field.
	DMA_CH11_DBG_CTDREQ_CH11_DBG_CTDREQ_Pos = 0x0
	// Bit mask of CH11_DBG_CTDREQ field.
	DMA_CH11_DBG_CTDREQ_CH11_DBG_CTDREQ_Msk = 0x3f
)

// Bitfields for USBCTRL_REGS: USB FS/LS controller device registers
const (
	// ADDR_ENDP: Device address and endpoint control
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP_ADDRESS_Msk = 0x7f

	// ADDR_ENDP1: Interrupt endpoint 1. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP1_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP1_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP1_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP1_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP1_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP1_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP1_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP1_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP1_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP1_ADDRESS_Msk = 0x7f

	// ADDR_ENDP2: Interrupt endpoint 2. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP2_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP2_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP2_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP2_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP2_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP2_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP2_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP2_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP2_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP2_ADDRESS_Msk = 0x7f

	// ADDR_ENDP3: Interrupt endpoint 3. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP3_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP3_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP3_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP3_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP3_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP3_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP3_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP3_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP3_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP3_ADDRESS_Msk = 0x7f

	// ADDR_ENDP4: Interrupt endpoint 4. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP4_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP4_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP4_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP4_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP4_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP4_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP4_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP4_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP4_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP4_ADDRESS_Msk = 0x7f

	// ADDR_ENDP5: Interrupt endpoint 5. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP5_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP5_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP5_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP5_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP5_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP5_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP5_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP5_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP5_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP5_ADDRESS_Msk = 0x7f

	// ADDR_ENDP6: Interrupt endpoint 6. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP6_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP6_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP6_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP6_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP6_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP6_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP6_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP6_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP6_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP6_ADDRESS_Msk = 0x7f

	// ADDR_ENDP7: Interrupt endpoint 7. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP7_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP7_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP7_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP7_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP7_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP7_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP7_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP7_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP7_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP7_ADDRESS_Msk = 0x7f

	// ADDR_ENDP8: Interrupt endpoint 8. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP8_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP8_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP8_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP8_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP8_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP8_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP8_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP8_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP8_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP8_ADDRESS_Msk = 0x7f

	// ADDR_ENDP9: Interrupt endpoint 9. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP9_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP9_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP9_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP9_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP9_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP9_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP9_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP9_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP9_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP9_ADDRESS_Msk = 0x7f

	// ADDR_ENDP10: Interrupt endpoint 10. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP10_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP10_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP10_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP10_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP10_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP10_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP10_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP10_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP10_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP10_ADDRESS_Msk = 0x7f

	// ADDR_ENDP11: Interrupt endpoint 11. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP11_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP11_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP11_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP11_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP11_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP11_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP11_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP11_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP11_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP11_ADDRESS_Msk = 0x7f

	// ADDR_ENDP12: Interrupt endpoint 12. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP12_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP12_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP12_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP12_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP12_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP12_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP12_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP12_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP12_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP12_ADDRESS_Msk = 0x7f

	// ADDR_ENDP13: Interrupt endpoint 13. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP13_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP13_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP13_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP13_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP13_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP13_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP13_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP13_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP13_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP13_ADDRESS_Msk = 0x7f

	// ADDR_ENDP14: Interrupt endpoint 14. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP14_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP14_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP14_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP14_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP14_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP14_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP14_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP14_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP14_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP14_ADDRESS_Msk = 0x7f

	// ADDR_ENDP15: Interrupt endpoint 15. Only valid for HOST mode.
	// Position of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP15_INTEP_PREAMBLE_Pos = 0x1a
	// Bit mask of INTEP_PREAMBLE field.
	USBCTRL_REGS_ADDR_ENDP15_INTEP_PREAMBLE_Msk = 0x4000000
	// Bit INTEP_PREAMBLE.
	USBCTRL_REGS_ADDR_ENDP15_INTEP_PREAMBLE = 0x4000000
	// Position of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP15_INTEP_DIR_Pos = 0x19
	// Bit mask of INTEP_DIR field.
	USBCTRL_REGS_ADDR_ENDP15_INTEP_DIR_Msk = 0x2000000
	// Bit INTEP_DIR.
	USBCTRL_REGS_ADDR_ENDP15_INTEP_DIR = 0x2000000
	// Position of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP15_ENDPOINT_Pos = 0x10
	// Bit mask of ENDPOINT field.
	USBCTRL_REGS_ADDR_ENDP15_ENDPOINT_Msk = 0xf0000
	// Position of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP15_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USBCTRL_REGS_ADDR_ENDP15_ADDRESS_Msk = 0x7f

	// MAIN_CTRL: Main control register
	// Position of SIM_TIMING field.
	USBCTRL_REGS_MAIN_CTRL_SIM_TIMING_Pos = 0x1f
	// Bit mask of SIM_TIMING field.
	USBCTRL_REGS_MAIN_CTRL_SIM_TIMING_Msk = 0x80000000
	// Bit SIM_TIMING.
	USBCTRL_REGS_MAIN_CTRL_SIM_TIMING = 0x80000000
	// Position of HOST_NDEVICE field.
	USBCTRL_REGS_MAIN_CTRL_HOST_NDEVICE_Pos = 0x1
	// Bit mask of HOST_NDEVICE field.
	USBCTRL_REGS_MAIN_CTRL_HOST_NDEVICE_Msk = 0x2
	// Bit HOST_NDEVICE.
	USBCTRL_REGS_MAIN_CTRL_HOST_NDEVICE = 0x2
	// Position of CONTROLLER_EN field.
	USBCTRL_REGS_MAIN_CTRL_CONTROLLER_EN_Pos = 0x0
	// Bit mask of CONTROLLER_EN field.
	USBCTRL_REGS_MAIN_CTRL_CONTROLLER_EN_Msk = 0x1
	// Bit CONTROLLER_EN.
	USBCTRL_REGS_MAIN_CTRL_CONTROLLER_EN = 0x1

	// SOF_WR: Set the SOF (Start of Frame) frame number in the host controller. The SOF packet is sent every 1ms and the host will increment the frame number by 1 each time.
	// Position of COUNT field.
	USBCTRL_REGS_SOF_WR_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	USBCTRL_REGS_SOF_WR_COUNT_Msk = 0x7ff

	// SOF_RD: Read the last SOF (Start of Frame) frame number seen. In device mode the last SOF received from the host. In host mode the last SOF sent by the host.
	// Position of COUNT field.
	USBCTRL_REGS_SOF_RD_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	USBCTRL_REGS_SOF_RD_COUNT_Msk = 0x7ff

	// SIE_CTRL: SIE control register
	// Position of EP0_INT_STALL field.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_STALL_Pos = 0x1f
	// Bit mask of EP0_INT_STALL field.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_STALL_Msk = 0x80000000
	// Bit EP0_INT_STALL.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_STALL = 0x80000000
	// Position of EP0_DOUBLE_BUF field.
	USBCTRL_REGS_SIE_CTRL_EP0_DOUBLE_BUF_Pos = 0x1e
	// Bit mask of EP0_DOUBLE_BUF field.
	USBCTRL_REGS_SIE_CTRL_EP0_DOUBLE_BUF_Msk = 0x40000000
	// Bit EP0_DOUBLE_BUF.
	USBCTRL_REGS_SIE_CTRL_EP0_DOUBLE_BUF = 0x40000000
	// Position of EP0_INT_1BUF field.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_1BUF_Pos = 0x1d
	// Bit mask of EP0_INT_1BUF field.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_1BUF_Msk = 0x20000000
	// Bit EP0_INT_1BUF.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_1BUF = 0x20000000
	// Position of EP0_INT_2BUF field.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_2BUF_Pos = 0x1c
	// Bit mask of EP0_INT_2BUF field.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_2BUF_Msk = 0x10000000
	// Bit EP0_INT_2BUF.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_2BUF = 0x10000000
	// Position of EP0_INT_NAK field.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_NAK_Pos = 0x1b
	// Bit mask of EP0_INT_NAK field.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_NAK_Msk = 0x8000000
	// Bit EP0_INT_NAK.
	USBCTRL_REGS_SIE_CTRL_EP0_INT_NAK = 0x8000000
	// Position of DIRECT_EN field.
	USBCTRL_REGS_SIE_CTRL_DIRECT_EN_Pos = 0x1a
	// Bit mask of DIRECT_EN field.
	USBCTRL_REGS_SIE_CTRL_DIRECT_EN_Msk = 0x4000000
	// Bit DIRECT_EN.
	USBCTRL_REGS_SIE_CTRL_DIRECT_EN = 0x4000000
	// Position of DIRECT_DP field.
	USBCTRL_REGS_SIE_CTRL_DIRECT_DP_Pos = 0x19
	// Bit mask of DIRECT_DP field.
	USBCTRL_REGS_SIE_CTRL_DIRECT_DP_Msk = 0x2000000
	// Bit DIRECT_DP.
	USBCTRL_REGS_SIE_CTRL_DIRECT_DP = 0x2000000
	// Position of DIRECT_DM field.
	USBCTRL_REGS_SIE_CTRL_DIRECT_DM_Pos = 0x18
	// Bit mask of DIRECT_DM field.
	USBCTRL_REGS_SIE_CTRL_DIRECT_DM_Msk = 0x1000000
	// Bit DIRECT_DM.
	USBCTRL_REGS_SIE_CTRL_DIRECT_DM = 0x1000000
	// Position of TRANSCEIVER_PD field.
	USBCTRL_REGS_SIE_CTRL_TRANSCEIVER_PD_Pos = 0x12
	// Bit mask of TRANSCEIVER_PD field.
	USBCTRL_REGS_SIE_CTRL_TRANSCEIVER_PD_Msk = 0x40000
	// Bit TRANSCEIVER_PD.
	USBCTRL_REGS_SIE_CTRL_TRANSCEIVER_PD = 0x40000
	// Position of RPU_OPT field.
	USBCTRL_REGS_SIE_CTRL_RPU_OPT_Pos = 0x11
	// Bit mask of RPU_OPT field.
	USBCTRL_REGS_SIE_CTRL_RPU_OPT_Msk = 0x20000
	// Bit RPU_OPT.
	USBCTRL_REGS_SIE_CTRL_RPU_OPT = 0x20000
	// Position of PULLUP_EN field.
	USBCTRL_REGS_SIE_CTRL_PULLUP_EN_Pos = 0x10
	// Bit mask of PULLUP_EN field.
	USBCTRL_REGS_SIE_CTRL_PULLUP_EN_Msk = 0x10000
	// Bit PULLUP_EN.
	USBCTRL_REGS_SIE_CTRL_PULLUP_EN = 0x10000
	// Position of PULLDOWN_EN field.
	USBCTRL_REGS_SIE_CTRL_PULLDOWN_EN_Pos = 0xf
	// Bit mask of PULLDOWN_EN field.
	USBCTRL_REGS_SIE_CTRL_PULLDOWN_EN_Msk = 0x8000
	// Bit PULLDOWN_EN.
	USBCTRL_REGS_SIE_CTRL_PULLDOWN_EN = 0x8000
	// Position of RESET_BUS field.
	USBCTRL_REGS_SIE_CTRL_RESET_BUS_Pos = 0xd
	// Bit mask of RESET_BUS field.
	USBCTRL_REGS_SIE_CTRL_RESET_BUS_Msk = 0x2000
	// Bit RESET_BUS.
	USBCTRL_REGS_SIE_CTRL_RESET_BUS = 0x2000
	// Position of RESUME field.
	USBCTRL_REGS_SIE_CTRL_RESUME_Pos = 0xc
	// Bit mask of RESUME field.
	USBCTRL_REGS_SIE_CTRL_RESUME_Msk = 0x1000
	// Bit RESUME.
	USBCTRL_REGS_SIE_CTRL_RESUME = 0x1000
	// Position of VBUS_EN field.
	USBCTRL_REGS_SIE_CTRL_VBUS_EN_Pos = 0xb
	// Bit mask of VBUS_EN field.
	USBCTRL_REGS_SIE_CTRL_VBUS_EN_Msk = 0x800
	// Bit VBUS_EN.
	USBCTRL_REGS_SIE_CTRL_VBUS_EN = 0x800
	// Position of KEEP_ALIVE_EN field.
	USBCTRL_REGS_SIE_CTRL_KEEP_ALIVE_EN_Pos = 0xa
	// Bit mask of KEEP_ALIVE_EN field.
	USBCTRL_REGS_SIE_CTRL_KEEP_ALIVE_EN_Msk = 0x400
	// Bit KEEP_ALIVE_EN.
	USBCTRL_REGS_SIE_CTRL_KEEP_ALIVE_EN = 0x400
	// Position of SOF_EN field.
	USBCTRL_REGS_SIE_CTRL_SOF_EN_Pos = 0x9
	// Bit mask of SOF_EN field.
	USBCTRL_REGS_SIE_CTRL_SOF_EN_Msk = 0x200
	// Bit SOF_EN.
	USBCTRL_REGS_SIE_CTRL_SOF_EN = 0x200
	// Position of SOF_SYNC field.
	USBCTRL_REGS_SIE_CTRL_SOF_SYNC_Pos = 0x8
	// Bit mask of SOF_SYNC field.
	USBCTRL_REGS_SIE_CTRL_SOF_SYNC_Msk = 0x100
	// Bit SOF_SYNC.
	USBCTRL_REGS_SIE_CTRL_SOF_SYNC = 0x100
	// Position of PREAMBLE_EN field.
	USBCTRL_REGS_SIE_CTRL_PREAMBLE_EN_Pos = 0x6
	// Bit mask of PREAMBLE_EN field.
	USBCTRL_REGS_SIE_CTRL_PREAMBLE_EN_Msk = 0x40
	// Bit PREAMBLE_EN.
	USBCTRL_REGS_SIE_CTRL_PREAMBLE_EN = 0x40
	// Position of STOP_TRANS field.
	USBCTRL_REGS_SIE_CTRL_STOP_TRANS_Pos = 0x4
	// Bit mask of STOP_TRANS field.
	USBCTRL_REGS_SIE_CTRL_STOP_TRANS_Msk = 0x10
	// Bit STOP_TRANS.
	USBCTRL_REGS_SIE_CTRL_STOP_TRANS = 0x10
	// Position of RECEIVE_DATA field.
	USBCTRL_REGS_SIE_CTRL_RECEIVE_DATA_Pos = 0x3
	// Bit mask of RECEIVE_DATA field.
	USBCTRL_REGS_SIE_CTRL_RECEIVE_DATA_Msk = 0x8
	// Bit RECEIVE_DATA.
	USBCTRL_REGS_SIE_CTRL_RECEIVE_DATA = 0x8
	// Position of SEND_DATA field.
	USBCTRL_REGS_SIE_CTRL_SEND_DATA_Pos = 0x2
	// Bit mask of SEND_DATA field.
	USBCTRL_REGS_SIE_CTRL_SEND_DATA_Msk = 0x4
	// Bit SEND_DATA.
	USBCTRL_REGS_SIE_CTRL_SEND_DATA = 0x4
	// Position of SEND_SETUP field.
	USBCTRL_REGS_SIE_CTRL_SEND_SETUP_Pos = 0x1
	// Bit mask of SEND_SETUP field.
	USBCTRL_REGS_SIE_CTRL_SEND_SETUP_Msk = 0x2
	// Bit SEND_SETUP.
	USBCTRL_REGS_SIE_CTRL_SEND_SETUP = 0x2
	// Position of START_TRANS field.
	USBCTRL_REGS_SIE_CTRL_START_TRANS_Pos = 0x0
	// Bit mask of START_TRANS field.
	USBCTRL_REGS_SIE_CTRL_START_TRANS_Msk = 0x1
	// Bit START_TRANS.
	USBCTRL_REGS_SIE_CTRL_START_TRANS = 0x1

	// SIE_STATUS: SIE status register
	// Position of DATA_SEQ_ERROR field.
	USBCTRL_REGS_SIE_STATUS_DATA_SEQ_ERROR_Pos = 0x1f
	// Bit mask of DATA_SEQ_ERROR field.
	USBCTRL_REGS_SIE_STATUS_DATA_SEQ_ERROR_Msk = 0x80000000
	// Bit DATA_SEQ_ERROR.
	USBCTRL_REGS_SIE_STATUS_DATA_SEQ_ERROR = 0x80000000
	// Position of ACK_REC field.
	USBCTRL_REGS_SIE_STATUS_ACK_REC_Pos = 0x1e
	// Bit mask of ACK_REC field.
	USBCTRL_REGS_SIE_STATUS_ACK_REC_Msk = 0x40000000
	// Bit ACK_REC.
	USBCTRL_REGS_SIE_STATUS_ACK_REC = 0x40000000
	// Position of STALL_REC field.
	USBCTRL_REGS_SIE_STATUS_STALL_REC_Pos = 0x1d
	// Bit mask of STALL_REC field.
	USBCTRL_REGS_SIE_STATUS_STALL_REC_Msk = 0x20000000
	// Bit STALL_REC.
	USBCTRL_REGS_SIE_STATUS_STALL_REC = 0x20000000
	// Position of NAK_REC field.
	USBCTRL_REGS_SIE_STATUS_NAK_REC_Pos = 0x1c
	// Bit mask of NAK_REC field.
	USBCTRL_REGS_SIE_STATUS_NAK_REC_Msk = 0x10000000
	// Bit NAK_REC.
	USBCTRL_REGS_SIE_STATUS_NAK_REC = 0x10000000
	// Position of RX_TIMEOUT field.
	USBCTRL_REGS_SIE_STATUS_RX_TIMEOUT_Pos = 0x1b
	// Bit mask of RX_TIMEOUT field.
	USBCTRL_REGS_SIE_STATUS_RX_TIMEOUT_Msk = 0x8000000
	// Bit RX_TIMEOUT.
	USBCTRL_REGS_SIE_STATUS_RX_TIMEOUT = 0x8000000
	// Position of RX_OVERFLOW field.
	USBCTRL_REGS_SIE_STATUS_RX_OVERFLOW_Pos = 0x1a
	// Bit mask of RX_OVERFLOW field.
	USBCTRL_REGS_SIE_STATUS_RX_OVERFLOW_Msk = 0x4000000
	// Bit RX_OVERFLOW.
	USBCTRL_REGS_SIE_STATUS_RX_OVERFLOW = 0x4000000
	// Position of BIT_STUFF_ERROR field.
	USBCTRL_REGS_SIE_STATUS_BIT_STUFF_ERROR_Pos = 0x19
	// Bit mask of BIT_STUFF_ERROR field.
	USBCTRL_REGS_SIE_STATUS_BIT_STUFF_ERROR_Msk = 0x2000000
	// Bit BIT_STUFF_ERROR.
	USBCTRL_REGS_SIE_STATUS_BIT_STUFF_ERROR = 0x2000000
	// Position of CRC_ERROR field.
	USBCTRL_REGS_SIE_STATUS_CRC_ERROR_Pos = 0x18
	// Bit mask of CRC_ERROR field.
	USBCTRL_REGS_SIE_STATUS_CRC_ERROR_Msk = 0x1000000
	// Bit CRC_ERROR.
	USBCTRL_REGS_SIE_STATUS_CRC_ERROR = 0x1000000
	// Position of BUS_RESET field.
	USBCTRL_REGS_SIE_STATUS_BUS_RESET_Pos = 0x13
	// Bit mask of BUS_RESET field.
	USBCTRL_REGS_SIE_STATUS_BUS_RESET_Msk = 0x80000
	// Bit BUS_RESET.
	USBCTRL_REGS_SIE_STATUS_BUS_RESET = 0x80000
	// Position of TRANS_COMPLETE field.
	USBCTRL_REGS_SIE_STATUS_TRANS_COMPLETE_Pos = 0x12
	// Bit mask of TRANS_COMPLETE field.
	USBCTRL_REGS_SIE_STATUS_TRANS_COMPLETE_Msk = 0x40000
	// Bit TRANS_COMPLETE.
	USBCTRL_REGS_SIE_STATUS_TRANS_COMPLETE = 0x40000
	// Position of SETUP_REC field.
	USBCTRL_REGS_SIE_STATUS_SETUP_REC_Pos = 0x11
	// Bit mask of SETUP_REC field.
	USBCTRL_REGS_SIE_STATUS_SETUP_REC_Msk = 0x20000
	// Bit SETUP_REC.
	USBCTRL_REGS_SIE_STATUS_SETUP_REC = 0x20000
	// Position of CONNECTED field.
	USBCTRL_REGS_SIE_STATUS_CONNECTED_Pos = 0x10
	// Bit mask of CONNECTED field.
	USBCTRL_REGS_SIE_STATUS_CONNECTED_Msk = 0x10000
	// Bit CONNECTED.
	USBCTRL_REGS_SIE_STATUS_CONNECTED = 0x10000
	// Position of RESUME field.
	USBCTRL_REGS_SIE_STATUS_RESUME_Pos = 0xb
	// Bit mask of RESUME field.
	USBCTRL_REGS_SIE_STATUS_RESUME_Msk = 0x800
	// Bit RESUME.
	USBCTRL_REGS_SIE_STATUS_RESUME = 0x800
	// Position of VBUS_OVER_CURR field.
	USBCTRL_REGS_SIE_STATUS_VBUS_OVER_CURR_Pos = 0xa
	// Bit mask of VBUS_OVER_CURR field.
	USBCTRL_REGS_SIE_STATUS_VBUS_OVER_CURR_Msk = 0x400
	// Bit VBUS_OVER_CURR.
	USBCTRL_REGS_SIE_STATUS_VBUS_OVER_CURR = 0x400
	// Position of SPEED field.
	USBCTRL_REGS_SIE_STATUS_SPEED_Pos = 0x8
	// Bit mask of SPEED field.
	USBCTRL_REGS_SIE_STATUS_SPEED_Msk = 0x300
	// Position of SUSPENDED field.
	USBCTRL_REGS_SIE_STATUS_SUSPENDED_Pos = 0x4
	// Bit mask of SUSPENDED field.
	USBCTRL_REGS_SIE_STATUS_SUSPENDED_Msk = 0x10
	// Bit SUSPENDED.
	USBCTRL_REGS_SIE_STATUS_SUSPENDED = 0x10
	// Position of LINE_STATE field.
	USBCTRL_REGS_SIE_STATUS_LINE_STATE_Pos = 0x2
	// Bit mask of LINE_STATE field.
	USBCTRL_REGS_SIE_STATUS_LINE_STATE_Msk = 0xc
	// Position of VBUS_DETECTED field.
	USBCTRL_REGS_SIE_STATUS_VBUS_DETECTED_Pos = 0x0
	// Bit mask of VBUS_DETECTED field.
	USBCTRL_REGS_SIE_STATUS_VBUS_DETECTED_Msk = 0x1
	// Bit VBUS_DETECTED.
	USBCTRL_REGS_SIE_STATUS_VBUS_DETECTED = 0x1

	// INT_EP_CTRL: interrupt endpoint control register
	// Position of INT_EP_ACTIVE field.
	USBCTRL_REGS_INT_EP_CTRL_INT_EP_ACTIVE_Pos = 0x1
	// Bit mask of INT_EP_ACTIVE field.
	USBCTRL_REGS_INT_EP_CTRL_INT_EP_ACTIVE_Msk = 0xfffe

	// BUFF_STATUS: Buffer status register. A bit set here indicates that a buffer has completed on the endpoint (if the buffer interrupt is enabled). It is possible for 2 buffers to be completed, so clearing the buffer status bit may instantly re set it on the next clock cycle.
	// Position of EP15_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP15_OUT_Pos = 0x1f
	// Bit mask of EP15_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP15_OUT_Msk = 0x80000000
	// Bit EP15_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP15_OUT = 0x80000000
	// Position of EP15_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP15_IN_Pos = 0x1e
	// Bit mask of EP15_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP15_IN_Msk = 0x40000000
	// Bit EP15_IN.
	USBCTRL_REGS_BUFF_STATUS_EP15_IN = 0x40000000
	// Position of EP14_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP14_OUT_Pos = 0x1d
	// Bit mask of EP14_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP14_OUT_Msk = 0x20000000
	// Bit EP14_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP14_OUT = 0x20000000
	// Position of EP14_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP14_IN_Pos = 0x1c
	// Bit mask of EP14_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP14_IN_Msk = 0x10000000
	// Bit EP14_IN.
	USBCTRL_REGS_BUFF_STATUS_EP14_IN = 0x10000000
	// Position of EP13_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP13_OUT_Pos = 0x1b
	// Bit mask of EP13_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP13_OUT_Msk = 0x8000000
	// Bit EP13_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP13_OUT = 0x8000000
	// Position of EP13_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP13_IN_Pos = 0x1a
	// Bit mask of EP13_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP13_IN_Msk = 0x4000000
	// Bit EP13_IN.
	USBCTRL_REGS_BUFF_STATUS_EP13_IN = 0x4000000
	// Position of EP12_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP12_OUT_Pos = 0x19
	// Bit mask of EP12_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP12_OUT_Msk = 0x2000000
	// Bit EP12_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP12_OUT = 0x2000000
	// Position of EP12_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP12_IN_Pos = 0x18
	// Bit mask of EP12_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP12_IN_Msk = 0x1000000
	// Bit EP12_IN.
	USBCTRL_REGS_BUFF_STATUS_EP12_IN = 0x1000000
	// Position of EP11_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP11_OUT_Pos = 0x17
	// Bit mask of EP11_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP11_OUT_Msk = 0x800000
	// Bit EP11_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP11_OUT = 0x800000
	// Position of EP11_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP11_IN_Pos = 0x16
	// Bit mask of EP11_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP11_IN_Msk = 0x400000
	// Bit EP11_IN.
	USBCTRL_REGS_BUFF_STATUS_EP11_IN = 0x400000
	// Position of EP10_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP10_OUT_Pos = 0x15
	// Bit mask of EP10_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP10_OUT_Msk = 0x200000
	// Bit EP10_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP10_OUT = 0x200000
	// Position of EP10_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP10_IN_Pos = 0x14
	// Bit mask of EP10_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP10_IN_Msk = 0x100000
	// Bit EP10_IN.
	USBCTRL_REGS_BUFF_STATUS_EP10_IN = 0x100000
	// Position of EP9_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP9_OUT_Pos = 0x13
	// Bit mask of EP9_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP9_OUT_Msk = 0x80000
	// Bit EP9_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP9_OUT = 0x80000
	// Position of EP9_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP9_IN_Pos = 0x12
	// Bit mask of EP9_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP9_IN_Msk = 0x40000
	// Bit EP9_IN.
	USBCTRL_REGS_BUFF_STATUS_EP9_IN = 0x40000
	// Position of EP8_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP8_OUT_Pos = 0x11
	// Bit mask of EP8_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP8_OUT_Msk = 0x20000
	// Bit EP8_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP8_OUT = 0x20000
	// Position of EP8_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP8_IN_Pos = 0x10
	// Bit mask of EP8_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP8_IN_Msk = 0x10000
	// Bit EP8_IN.
	USBCTRL_REGS_BUFF_STATUS_EP8_IN = 0x10000
	// Position of EP7_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP7_OUT_Pos = 0xf
	// Bit mask of EP7_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP7_OUT_Msk = 0x8000
	// Bit EP7_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP7_OUT = 0x8000
	// Position of EP7_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP7_IN_Pos = 0xe
	// Bit mask of EP7_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP7_IN_Msk = 0x4000
	// Bit EP7_IN.
	USBCTRL_REGS_BUFF_STATUS_EP7_IN = 0x4000
	// Position of EP6_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP6_OUT_Pos = 0xd
	// Bit mask of EP6_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP6_OUT_Msk = 0x2000
	// Bit EP6_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP6_OUT = 0x2000
	// Position of EP6_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP6_IN_Pos = 0xc
	// Bit mask of EP6_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP6_IN_Msk = 0x1000
	// Bit EP6_IN.
	USBCTRL_REGS_BUFF_STATUS_EP6_IN = 0x1000
	// Position of EP5_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP5_OUT_Pos = 0xb
	// Bit mask of EP5_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP5_OUT_Msk = 0x800
	// Bit EP5_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP5_OUT = 0x800
	// Position of EP5_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP5_IN_Pos = 0xa
	// Bit mask of EP5_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP5_IN_Msk = 0x400
	// Bit EP5_IN.
	USBCTRL_REGS_BUFF_STATUS_EP5_IN = 0x400
	// Position of EP4_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP4_OUT_Pos = 0x9
	// Bit mask of EP4_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP4_OUT_Msk = 0x200
	// Bit EP4_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP4_OUT = 0x200
	// Position of EP4_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP4_IN_Pos = 0x8
	// Bit mask of EP4_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP4_IN_Msk = 0x100
	// Bit EP4_IN.
	USBCTRL_REGS_BUFF_STATUS_EP4_IN = 0x100
	// Position of EP3_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP3_OUT_Pos = 0x7
	// Bit mask of EP3_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP3_OUT_Msk = 0x80
	// Bit EP3_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP3_OUT = 0x80
	// Position of EP3_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP3_IN_Pos = 0x6
	// Bit mask of EP3_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP3_IN_Msk = 0x40
	// Bit EP3_IN.
	USBCTRL_REGS_BUFF_STATUS_EP3_IN = 0x40
	// Position of EP2_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP2_OUT_Pos = 0x5
	// Bit mask of EP2_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP2_OUT_Msk = 0x20
	// Bit EP2_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP2_OUT = 0x20
	// Position of EP2_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP2_IN_Pos = 0x4
	// Bit mask of EP2_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP2_IN_Msk = 0x10
	// Bit EP2_IN.
	USBCTRL_REGS_BUFF_STATUS_EP2_IN = 0x10
	// Position of EP1_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP1_OUT_Pos = 0x3
	// Bit mask of EP1_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP1_OUT_Msk = 0x8
	// Bit EP1_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP1_OUT = 0x8
	// Position of EP1_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP1_IN_Pos = 0x2
	// Bit mask of EP1_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP1_IN_Msk = 0x4
	// Bit EP1_IN.
	USBCTRL_REGS_BUFF_STATUS_EP1_IN = 0x4
	// Position of EP0_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP0_OUT_Pos = 0x1
	// Bit mask of EP0_OUT field.
	USBCTRL_REGS_BUFF_STATUS_EP0_OUT_Msk = 0x2
	// Bit EP0_OUT.
	USBCTRL_REGS_BUFF_STATUS_EP0_OUT = 0x2
	// Position of EP0_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP0_IN_Pos = 0x0
	// Bit mask of EP0_IN field.
	USBCTRL_REGS_BUFF_STATUS_EP0_IN_Msk = 0x1
	// Bit EP0_IN.
	USBCTRL_REGS_BUFF_STATUS_EP0_IN = 0x1

	// BUFF_CPU_SHOULD_HANDLE: Which of the double buffers should be handled. Only valid if using an interrupt per buffer (i.e. not per 2 buffers). Not valid for host interrupt endpoint polling because they are only single buffered.
	// Position of EP15_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP15_OUT_Pos = 0x1f
	// Bit mask of EP15_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP15_OUT_Msk = 0x80000000
	// Bit EP15_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP15_OUT = 0x80000000
	// Position of EP15_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP15_IN_Pos = 0x1e
	// Bit mask of EP15_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP15_IN_Msk = 0x40000000
	// Bit EP15_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP15_IN = 0x40000000
	// Position of EP14_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP14_OUT_Pos = 0x1d
	// Bit mask of EP14_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP14_OUT_Msk = 0x20000000
	// Bit EP14_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP14_OUT = 0x20000000
	// Position of EP14_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP14_IN_Pos = 0x1c
	// Bit mask of EP14_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP14_IN_Msk = 0x10000000
	// Bit EP14_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP14_IN = 0x10000000
	// Position of EP13_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP13_OUT_Pos = 0x1b
	// Bit mask of EP13_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP13_OUT_Msk = 0x8000000
	// Bit EP13_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP13_OUT = 0x8000000
	// Position of EP13_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP13_IN_Pos = 0x1a
	// Bit mask of EP13_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP13_IN_Msk = 0x4000000
	// Bit EP13_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP13_IN = 0x4000000
	// Position of EP12_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP12_OUT_Pos = 0x19
	// Bit mask of EP12_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP12_OUT_Msk = 0x2000000
	// Bit EP12_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP12_OUT = 0x2000000
	// Position of EP12_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP12_IN_Pos = 0x18
	// Bit mask of EP12_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP12_IN_Msk = 0x1000000
	// Bit EP12_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP12_IN = 0x1000000
	// Position of EP11_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP11_OUT_Pos = 0x17
	// Bit mask of EP11_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP11_OUT_Msk = 0x800000
	// Bit EP11_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP11_OUT = 0x800000
	// Position of EP11_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP11_IN_Pos = 0x16
	// Bit mask of EP11_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP11_IN_Msk = 0x400000
	// Bit EP11_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP11_IN = 0x400000
	// Position of EP10_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP10_OUT_Pos = 0x15
	// Bit mask of EP10_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP10_OUT_Msk = 0x200000
	// Bit EP10_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP10_OUT = 0x200000
	// Position of EP10_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP10_IN_Pos = 0x14
	// Bit mask of EP10_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP10_IN_Msk = 0x100000
	// Bit EP10_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP10_IN = 0x100000
	// Position of EP9_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP9_OUT_Pos = 0x13
	// Bit mask of EP9_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP9_OUT_Msk = 0x80000
	// Bit EP9_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP9_OUT = 0x80000
	// Position of EP9_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP9_IN_Pos = 0x12
	// Bit mask of EP9_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP9_IN_Msk = 0x40000
	// Bit EP9_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP9_IN = 0x40000
	// Position of EP8_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP8_OUT_Pos = 0x11
	// Bit mask of EP8_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP8_OUT_Msk = 0x20000
	// Bit EP8_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP8_OUT = 0x20000
	// Position of EP8_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP8_IN_Pos = 0x10
	// Bit mask of EP8_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP8_IN_Msk = 0x10000
	// Bit EP8_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP8_IN = 0x10000
	// Position of EP7_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP7_OUT_Pos = 0xf
	// Bit mask of EP7_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP7_OUT_Msk = 0x8000
	// Bit EP7_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP7_OUT = 0x8000
	// Position of EP7_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP7_IN_Pos = 0xe
	// Bit mask of EP7_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP7_IN_Msk = 0x4000
	// Bit EP7_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP7_IN = 0x4000
	// Position of EP6_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP6_OUT_Pos = 0xd
	// Bit mask of EP6_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP6_OUT_Msk = 0x2000
	// Bit EP6_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP6_OUT = 0x2000
	// Position of EP6_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP6_IN_Pos = 0xc
	// Bit mask of EP6_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP6_IN_Msk = 0x1000
	// Bit EP6_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP6_IN = 0x1000
	// Position of EP5_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP5_OUT_Pos = 0xb
	// Bit mask of EP5_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP5_OUT_Msk = 0x800
	// Bit EP5_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP5_OUT = 0x800
	// Position of EP5_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP5_IN_Pos = 0xa
	// Bit mask of EP5_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP5_IN_Msk = 0x400
	// Bit EP5_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP5_IN = 0x400
	// Position of EP4_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP4_OUT_Pos = 0x9
	// Bit mask of EP4_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP4_OUT_Msk = 0x200
	// Bit EP4_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP4_OUT = 0x200
	// Position of EP4_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP4_IN_Pos = 0x8
	// Bit mask of EP4_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP4_IN_Msk = 0x100
	// Bit EP4_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP4_IN = 0x100
	// Position of EP3_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP3_OUT_Pos = 0x7
	// Bit mask of EP3_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP3_OUT_Msk = 0x80
	// Bit EP3_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP3_OUT = 0x80
	// Position of EP3_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP3_IN_Pos = 0x6
	// Bit mask of EP3_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP3_IN_Msk = 0x40
	// Bit EP3_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP3_IN = 0x40
	// Position of EP2_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP2_OUT_Pos = 0x5
	// Bit mask of EP2_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP2_OUT_Msk = 0x20
	// Bit EP2_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP2_OUT = 0x20
	// Position of EP2_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP2_IN_Pos = 0x4
	// Bit mask of EP2_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP2_IN_Msk = 0x10
	// Bit EP2_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP2_IN = 0x10
	// Position of EP1_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP1_OUT_Pos = 0x3
	// Bit mask of EP1_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP1_OUT_Msk = 0x8
	// Bit EP1_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP1_OUT = 0x8
	// Position of EP1_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP1_IN_Pos = 0x2
	// Bit mask of EP1_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP1_IN_Msk = 0x4
	// Bit EP1_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP1_IN = 0x4
	// Position of EP0_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP0_OUT_Pos = 0x1
	// Bit mask of EP0_OUT field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP0_OUT_Msk = 0x2
	// Bit EP0_OUT.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP0_OUT = 0x2
	// Position of EP0_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP0_IN_Pos = 0x0
	// Bit mask of EP0_IN field.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP0_IN_Msk = 0x1
	// Bit EP0_IN.
	USBCTRL_REGS_BUFF_CPU_SHOULD_HANDLE_EP0_IN = 0x1

	// EP_ABORT: Device only: Can be set to ignore the buffer control register for this endpoint in case you would like to revoke a buffer. A NAK will be sent for every access to the endpoint until this bit is cleared. A corresponding bit in `EP_ABORT_DONE` is set when it is safe to modify the buffer control register.
	// Position of EP15_OUT field.
	USBCTRL_REGS_EP_ABORT_EP15_OUT_Pos = 0x1f
	// Bit mask of EP15_OUT field.
	USBCTRL_REGS_EP_ABORT_EP15_OUT_Msk = 0x80000000
	// Bit EP15_OUT.
	USBCTRL_REGS_EP_ABORT_EP15_OUT = 0x80000000
	// Position of EP15_IN field.
	USBCTRL_REGS_EP_ABORT_EP15_IN_Pos = 0x1e
	// Bit mask of EP15_IN field.
	USBCTRL_REGS_EP_ABORT_EP15_IN_Msk = 0x40000000
	// Bit EP15_IN.
	USBCTRL_REGS_EP_ABORT_EP15_IN = 0x40000000
	// Position of EP14_OUT field.
	USBCTRL_REGS_EP_ABORT_EP14_OUT_Pos = 0x1d
	// Bit mask of EP14_OUT field.
	USBCTRL_REGS_EP_ABORT_EP14_OUT_Msk = 0x20000000
	// Bit EP14_OUT.
	USBCTRL_REGS_EP_ABORT_EP14_OUT = 0x20000000
	// Position of EP14_IN field.
	USBCTRL_REGS_EP_ABORT_EP14_IN_Pos = 0x1c
	// Bit mask of EP14_IN field.
	USBCTRL_REGS_EP_ABORT_EP14_IN_Msk = 0x10000000
	// Bit EP14_IN.
	USBCTRL_REGS_EP_ABORT_EP14_IN = 0x10000000
	// Position of EP13_OUT field.
	USBCTRL_REGS_EP_ABORT_EP13_OUT_Pos = 0x1b
	// Bit mask of EP13_OUT field.
	USBCTRL_REGS_EP_ABORT_EP13_OUT_Msk = 0x8000000
	// Bit EP13_OUT.
	USBCTRL_REGS_EP_ABORT_EP13_OUT = 0x8000000
	// Position of EP13_IN field.
	USBCTRL_REGS_EP_ABORT_EP13_IN_Pos = 0x1a
	// Bit mask of EP13_IN field.
	USBCTRL_REGS_EP_ABORT_EP13_IN_Msk = 0x4000000
	// Bit EP13_IN.
	USBCTRL_REGS_EP_ABORT_EP13_IN = 0x4000000
	// Position of EP12_OUT field.
	USBCTRL_REGS_EP_ABORT_EP12_OUT_Pos = 0x19
	// Bit mask of EP12_OUT field.
	USBCTRL_REGS_EP_ABORT_EP12_OUT_Msk = 0x2000000
	// Bit EP12_OUT.
	USBCTRL_REGS_EP_ABORT_EP12_OUT = 0x2000000
	// Position of EP12_IN field.
	USBCTRL_REGS_EP_ABORT_EP12_IN_Pos = 0x18
	// Bit mask of EP12_IN field.
	USBCTRL_REGS_EP_ABORT_EP12_IN_Msk = 0x1000000
	// Bit EP12_IN.
	USBCTRL_REGS_EP_ABORT_EP12_IN = 0x1000000
	// Position of EP11_OUT field.
	USBCTRL_REGS_EP_ABORT_EP11_OUT_Pos = 0x17
	// Bit mask of EP11_OUT field.
	USBCTRL_REGS_EP_ABORT_EP11_OUT_Msk = 0x800000
	// Bit EP11_OUT.
	USBCTRL_REGS_EP_ABORT_EP11_OUT = 0x800000
	// Position of EP11_IN field.
	USBCTRL_REGS_EP_ABORT_EP11_IN_Pos = 0x16
	// Bit mask of EP11_IN field.
	USBCTRL_REGS_EP_ABORT_EP11_IN_Msk = 0x400000
	// Bit EP11_IN.
	USBCTRL_REGS_EP_ABORT_EP11_IN = 0x400000
	// Position of EP10_OUT field.
	USBCTRL_REGS_EP_ABORT_EP10_OUT_Pos = 0x15
	// Bit mask of EP10_OUT field.
	USBCTRL_REGS_EP_ABORT_EP10_OUT_Msk = 0x200000
	// Bit EP10_OUT.
	USBCTRL_REGS_EP_ABORT_EP10_OUT = 0x200000
	// Position of EP10_IN field.
	USBCTRL_REGS_EP_ABORT_EP10_IN_Pos = 0x14
	// Bit mask of EP10_IN field.
	USBCTRL_REGS_EP_ABORT_EP10_IN_Msk = 0x100000
	// Bit EP10_IN.
	USBCTRL_REGS_EP_ABORT_EP10_IN = 0x100000
	// Position of EP9_OUT field.
	USBCTRL_REGS_EP_ABORT_EP9_OUT_Pos = 0x13
	// Bit mask of EP9_OUT field.
	USBCTRL_REGS_EP_ABORT_EP9_OUT_Msk = 0x80000
	// Bit EP9_OUT.
	USBCTRL_REGS_EP_ABORT_EP9_OUT = 0x80000
	// Position of EP9_IN field.
	USBCTRL_REGS_EP_ABORT_EP9_IN_Pos = 0x12
	// Bit mask of EP9_IN field.
	USBCTRL_REGS_EP_ABORT_EP9_IN_Msk = 0x40000
	// Bit EP9_IN.
	USBCTRL_REGS_EP_ABORT_EP9_IN = 0x40000
	// Position of EP8_OUT field.
	USBCTRL_REGS_EP_ABORT_EP8_OUT_Pos = 0x11
	// Bit mask of EP8_OUT field.
	USBCTRL_REGS_EP_ABORT_EP8_OUT_Msk = 0x20000
	// Bit EP8_OUT.
	USBCTRL_REGS_EP_ABORT_EP8_OUT = 0x20000
	// Position of EP8_IN field.
	USBCTRL_REGS_EP_ABORT_EP8_IN_Pos = 0x10
	// Bit mask of EP8_IN field.
	USBCTRL_REGS_EP_ABORT_EP8_IN_Msk = 0x10000
	// Bit EP8_IN.
	USBCTRL_REGS_EP_ABORT_EP8_IN = 0x10000
	// Position of EP7_OUT field.
	USBCTRL_REGS_EP_ABORT_EP7_OUT_Pos = 0xf
	// Bit mask of EP7_OUT field.
	USBCTRL_REGS_EP_ABORT_EP7_OUT_Msk = 0x8000
	// Bit EP7_OUT.
	USBCTRL_REGS_EP_ABORT_EP7_OUT = 0x8000
	// Position of EP7_IN field.
	USBCTRL_REGS_EP_ABORT_EP7_IN_Pos = 0xe
	// Bit mask of EP7_IN field.
	USBCTRL_REGS_EP_ABORT_EP7_IN_Msk = 0x4000
	// Bit EP7_IN.
	USBCTRL_REGS_EP_ABORT_EP7_IN = 0x4000
	// Position of EP6_OUT field.
	USBCTRL_REGS_EP_ABORT_EP6_OUT_Pos = 0xd
	// Bit mask of EP6_OUT field.
	USBCTRL_REGS_EP_ABORT_EP6_OUT_Msk = 0x2000
	// Bit EP6_OUT.
	USBCTRL_REGS_EP_ABORT_EP6_OUT = 0x2000
	// Position of EP6_IN field.
	USBCTRL_REGS_EP_ABORT_EP6_IN_Pos = 0xc
	// Bit mask of EP6_IN field.
	USBCTRL_REGS_EP_ABORT_EP6_IN_Msk = 0x1000
	// Bit EP6_IN.
	USBCTRL_REGS_EP_ABORT_EP6_IN = 0x1000
	// Position of EP5_OUT field.
	USBCTRL_REGS_EP_ABORT_EP5_OUT_Pos = 0xb
	// Bit mask of EP5_OUT field.
	USBCTRL_REGS_EP_ABORT_EP5_OUT_Msk = 0x800
	// Bit EP5_OUT.
	USBCTRL_REGS_EP_ABORT_EP5_OUT = 0x800
	// Position of EP5_IN field.
	USBCTRL_REGS_EP_ABORT_EP5_IN_Pos = 0xa
	// Bit mask of EP5_IN field.
	USBCTRL_REGS_EP_ABORT_EP5_IN_Msk = 0x400
	// Bit EP5_IN.
	USBCTRL_REGS_EP_ABORT_EP5_IN = 0x400
	// Position of EP4_OUT field.
	USBCTRL_REGS_EP_ABORT_EP4_OUT_Pos = 0x9
	// Bit mask of EP4_OUT field.
	USBCTRL_REGS_EP_ABORT_EP4_OUT_Msk = 0x200
	// Bit EP4_OUT.
	USBCTRL_REGS_EP_ABORT_EP4_OUT = 0x200
	// Position of EP4_IN field.
	USBCTRL_REGS_EP_ABORT_EP4_IN_Pos = 0x8
	// Bit mask of EP4_IN field.
	USBCTRL_REGS_EP_ABORT_EP4_IN_Msk = 0x100
	// Bit EP4_IN.
	USBCTRL_REGS_EP_ABORT_EP4_IN = 0x100
	// Position of EP3_OUT field.
	USBCTRL_REGS_EP_ABORT_EP3_OUT_Pos = 0x7
	// Bit mask of EP3_OUT field.
	USBCTRL_REGS_EP_ABORT_EP3_OUT_Msk = 0x80
	// Bit EP3_OUT.
	USBCTRL_REGS_EP_ABORT_EP3_OUT = 0x80
	// Position of EP3_IN field.
	USBCTRL_REGS_EP_ABORT_EP3_IN_Pos = 0x6
	// Bit mask of EP3_IN field.
	USBCTRL_REGS_EP_ABORT_EP3_IN_Msk = 0x40
	// Bit EP3_IN.
	USBCTRL_REGS_EP_ABORT_EP3_IN = 0x40
	// Position of EP2_OUT field.
	USBCTRL_REGS_EP_ABORT_EP2_OUT_Pos = 0x5
	// Bit mask of EP2_OUT field.
	USBCTRL_REGS_EP_ABORT_EP2_OUT_Msk = 0x20
	// Bit EP2_OUT.
	USBCTRL_REGS_EP_ABORT_EP2_OUT = 0x20
	// Position of EP2_IN field.
	USBCTRL_REGS_EP_ABORT_EP2_IN_Pos = 0x4
	// Bit mask of EP2_IN field.
	USBCTRL_REGS_EP_ABORT_EP2_IN_Msk = 0x10
	// Bit EP2_IN.
	USBCTRL_REGS_EP_ABORT_EP2_IN = 0x10
	// Position of EP1_OUT field.
	USBCTRL_REGS_EP_ABORT_EP1_OUT_Pos = 0x3
	// Bit mask of EP1_OUT field.
	USBCTRL_REGS_EP_ABORT_EP1_OUT_Msk = 0x8
	// Bit EP1_OUT.
	USBCTRL_REGS_EP_ABORT_EP1_OUT = 0x8
	// Position of EP1_IN field.
	USBCTRL_REGS_EP_ABORT_EP1_IN_Pos = 0x2
	// Bit mask of EP1_IN field.
	USBCTRL_REGS_EP_ABORT_EP1_IN_Msk = 0x4
	// Bit EP1_IN.
	USBCTRL_REGS_EP_ABORT_EP1_IN = 0x4
	// Position of EP0_OUT field.
	USBCTRL_REGS_EP_ABORT_EP0_OUT_Pos = 0x1
	// Bit mask of EP0_OUT field.
	USBCTRL_REGS_EP_ABORT_EP0_OUT_Msk = 0x2
	// Bit EP0_OUT.
	USBCTRL_REGS_EP_ABORT_EP0_OUT = 0x2
	// Position of EP0_IN field.
	USBCTRL_REGS_EP_ABORT_EP0_IN_Pos = 0x0
	// Bit mask of EP0_IN field.
	USBCTRL_REGS_EP_ABORT_EP0_IN_Msk = 0x1
	// Bit EP0_IN.
	USBCTRL_REGS_EP_ABORT_EP0_IN = 0x1

	// EP_ABORT_DONE: Device only: Used in conjunction with `EP_ABORT`. Set once an endpoint is idle so the programmer knows it is safe to modify the buffer control register.
	// Position of EP15_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP15_OUT_Pos = 0x1f
	// Bit mask of EP15_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP15_OUT_Msk = 0x80000000
	// Bit EP15_OUT.
	USBCTRL_REGS_EP_ABORT_DONE_EP15_OUT = 0x80000000
	// Position of EP15_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP15_IN_Pos = 0x1e
	// Bit mask of EP15_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP15_IN_Msk = 0x40000000
	// Bit EP15_IN.
	USBCTRL_REGS_EP_ABORT_DONE_EP15_IN = 0x40000000
	// Position of EP14_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP14_OUT_Pos = 0x1d
	// Bit mask of EP14_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP14_OUT_Msk = 0x20000000
	// Bit EP14_OUT.
	USBCTRL_REGS_EP_ABORT_DONE_EP14_OUT = 0x20000000
	// Position of EP14_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP14_IN_Pos = 0x1c
	// Bit mask of EP14_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP14_IN_Msk = 0x10000000
	// Bit EP14_IN.
	USBCTRL_REGS_EP_ABORT_DONE_EP14_IN = 0x10000000
	// Position of EP13_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP13_OUT_Pos = 0x1b
	// Bit mask of EP13_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP13_OUT_Msk = 0x8000000
	// Bit EP13_OUT.
	USBCTRL_REGS_EP_ABORT_DONE_EP13_OUT = 0x8000000
	// Position of EP13_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP13_IN_Pos = 0x1a
	// Bit mask of EP13_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP13_IN_Msk = 0x4000000
	// Bit EP13_IN.
	USBCTRL_REGS_EP_ABORT_DONE_EP13_IN = 0x4000000
	// Position of EP12_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP12_OUT_Pos = 0x19
	// Bit mask of EP12_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP12_OUT_Msk = 0x2000000
	// Bit EP12_OUT.
	USBCTRL_REGS_EP_ABORT_DONE_EP12_OUT = 0x2000000
	// Position of EP12_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP12_IN_Pos = 0x18
	// Bit mask of EP12_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP12_IN_Msk = 0x1000000
	// Bit EP12_IN.
	USBCTRL_REGS_EP_ABORT_DONE_EP12_IN = 0x1000000
	// Position of EP11_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP11_OUT_Pos = 0x17
	// Bit mask of EP11_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP11_OUT_Msk = 0x800000
	// Bit EP11_OUT.
	USBCTRL_REGS_EP_ABORT_DONE_EP11_OUT = 0x800000
	// Position of EP11_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP11_IN_Pos = 0x16
	// Bit mask of EP11_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP11_IN_Msk = 0x400000
	// Bit EP11_IN.
	USBCTRL_REGS_EP_ABORT_DONE_EP11_IN = 0x400000
	// Position of EP10_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP10_OUT_Pos = 0x15
	// Bit mask of EP10_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP10_OUT_Msk = 0x200000
	// Bit EP10_OUT.
	USBCTRL_REGS_EP_ABORT_DONE_EP10_OUT = 0x200000
	// Position of EP10_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP10_IN_Pos = 0x14
	// Bit mask of EP10_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP10_IN_Msk = 0x100000
	// Bit EP10_IN.
	USBCTRL_REGS_EP_ABORT_DONE_EP10_IN = 0x100000
	// Position of EP9_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP9_OUT_Pos = 0x13
	// Bit mask of EP9_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP9_OUT_Msk = 0x80000
	// Bit EP9_OUT.
	USBCTRL_REGS_EP_ABORT_DONE_EP9_OUT = 0x80000
	// Position of EP9_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP9_IN_Pos = 0x12
	// Bit mask of EP9_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP9_IN_Msk = 0x40000
	// Bit EP9_IN.
	USBCTRL_REGS_EP_ABORT_DONE_EP9_IN = 0x40000
	// Position of EP8_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP8_OUT_Pos = 0x11
	// Bit mask of EP8_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP8_OUT_Msk = 0x20000
	// Bit EP8_OUT.
	USBCTRL_REGS_EP_ABORT_DONE_EP8_OUT = 0x20000
	// Position of EP8_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP8_IN_Pos = 0x10
	// Bit mask of EP8_IN field.
	USBCTRL_REGS_EP_ABORT_DONE_EP8_IN_Msk = 0x10000
	// Bit EP8_IN.
	USBCTRL_REGS_EP_ABORT_DONE_EP8_IN = 0x10000
	// Position of EP7_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP7_OUT_Pos = 0xf
	// Bit mask of EP7_OUT field.
	USBCTRL_REGS_EP_ABORT_DONE_EP7_OUT_Msk = 0x8000
	// Bit EP7_OUT.
	USBCTRL_REGS_EP_ABORT_DONE_EP7_OUT = 0x8000
	/