// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATtiny26.atdf, see http://packs.download.atmel.com/

//go:build avr && attiny26
// +build avr,attiny26

// Device information for the ATtiny26.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATtiny26"
	ARCH   = "AVR8"
	FAMILY = "tinyAVR"
)

// Interrupts
const (
	IRQ_RESET       = 0  // External Reset, Power-on Reset and Watchdog Reset
	IRQ_INT0        = 1  // External Interrupt 0
	IRQ_IO_PINS     = 2  // External Interrupt Request 0
	IRQ_TIMER1_CMPA = 3  // Timer/Counter1 Compare Match 1A
	IRQ_TIMER1_CMPB = 4  // Timer/Counter1 Compare Match 1B
	IRQ_TIMER1_OVF1 = 5  // Timer/Counter1 Overflow
	IRQ_TIMER0_OVF0 = 6  // Timer/Counter0 Overflow
	IRQ_USI_STRT    = 7  // USI Start
	IRQ_USI_OVF     = 8  // USI Overflow
	IRQ_EE_RDY      = 9  // EEPROM Ready
	IRQ_ANA_COMP    = 10 // Analog Comparator
	IRQ_ADC         = 11 // ADC Conversion Complete
	IRQ_max         = 11 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_IO_PINS
//go:interrupt
func interruptIO_PINS() {
	callHandlers(IRQ_IO_PINS)
}

//export __vector_TIMER1_CMPA
//go:interrupt
func interruptTIMER1_CMPA() {
	callHandlers(IRQ_TIMER1_CMPA)
}

//export __vector_TIMER1_CMPB
//go:interrupt
func interruptTIMER1_CMPB() {
	callHandlers(IRQ_TIMER1_CMPB)
}

//export __vector_TIMER1_OVF1
//go:interrupt
func interruptTIMER1_OVF1() {
	callHandlers(IRQ_TIMER1_OVF1)
}

//export __vector_TIMER0_OVF0
//go:interrupt
func interruptTIMER0_OVF0() {
	callHandlers(IRQ_TIMER0_OVF0)
}

//export __vector_USI_STRT
//go:interrupt
func interruptUSI_STRT() {
	callHandlers(IRQ_USI_STRT)
}

//export __vector_USI_OVF
//go:interrupt
func interruptUSI_OVF() {
	callHandlers(IRQ_USI_OVF)
}

//export __vector_EE_RDY
//go:interrupt
func interruptEE_RDY() {
	callHandlers(IRQ_EE_RDY)
}

//export __vector_ANA_COMP
//go:interrupt
func interruptANA_COMP() {
	callHandlers(IRQ_ANA_COMP)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

// Peripherals.
var (
	// Fuses
	HIGH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Analog-to-Digital Converter
	ADMUX = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	ADCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	ADCL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	ADCH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))

	// Analog Comparator
	ACSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))

	// Universal Serial Interface
	USIDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))
	USISR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	USICR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))

	// EEPROM
	EEAR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	EEDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EECR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))

	// Watchdog Timer
	WDTCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))

	// CPU Registers
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SP     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	MCUCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))

	// Timer/Counter, 8-bit
	TIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x59)))
	TIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x58)))
	TCCR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x52)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4f)))
	TCNT1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))
	OCR1A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	OCR1B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	OCR1C  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	PLLCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))

	// External Interrupts
	GIMSK = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5a)))
)

// Bitfields for FUSE: Fuses
const (
	// HIGH
	HIGH_RSTDISBL     = 0x10 // Reset Disabled (Enable PB7 as i/o pin)
	HIGH_RSTDISBL_Msk = 0x10 // Reset Disabled (Enable PB7 as i/o pin)
	HIGH_SPIEN        = 0x8  // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk    = 0x8  // Serial program downloading (SPI) enabled
	HIGH_EESAVE       = 0x4  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk   = 0x4  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BODLEVEL     = 0x2  // Brownout detector trigger level
	HIGH_BODLEVEL_Msk = 0x2  // Brownout detector trigger level
	HIGH_BODEN        = 0x1  // Brown-out detection enabled
	HIGH_BODEN_Msk    = 0x1  // Brown-out detection enabled

	// LOW
	LOW_CKOPT               = 0x40 // CKOPT fuse (operation dependent of CKSEL fuses)
	LOW_CKOPT_Msk           = 0x40 // CKOPT fuse (operation dependent of CKSEL fuses)
	LOW_PLLCK_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_PLLCK_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_PLLCK_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_PLLCK_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_PLLCK_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_PLLCK_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_PLLCK_SUT_CKSEL6    = 0x80 // Select Clock Source
	LOW_PLLCK_SUT_CKSEL_Msk = 0xbf // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0    = 0x1 // Memory Lock
	LOCKBIT_LB1    = 0x2 // Memory Lock
	LOCKBIT_LB_Msk = 0x3 // Memory Lock
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0     = 0x40 // Reference Selection Bits
	ADMUX_REFS1     = 0x80 // Reference Selection Bits
	ADMUX_REFS_Msk  = 0xc0 // Reference Selection Bits
	ADMUX_ADLAR     = 0x20 // Left Adjust Result
	ADMUX_ADLAR_Msk = 0x20 // Left Adjust Result
	ADMUX_MUX0      = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1      = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2      = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3      = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4      = 0x10 // Analog Channel and Gain Selection Bits
	ADMUX_MUX_Msk   = 0x1f // Analog Channel and Gain Selection Bits

	// ADCSR: The ADC Control and Status register
	ADCSR_ADEN     = 0x80 // ADC Enable
	ADCSR_ADEN_Msk = 0x80 // ADC Enable
	ADCSR_ADSC     = 0x40 // ADC Start Conversion
	ADCSR_ADSC_Msk = 0x40 // ADC Start Conversion
	ADCSR_ADFR     = 0x20 // ADC  Free Running Select
	ADCSR_ADFR_Msk = 0x20 // ADC  Free Running Select
	ADCSR_ADIF     = 0x10 // ADC Interrupt Flag
	ADCSR_ADIF_Msk = 0x10 // ADC Interrupt Flag
	ADCSR_ADIE     = 0x8  // ADC Interrupt Enable
	ADCSR_ADIE_Msk = 0x8  // ADC Interrupt Enable
	ADCSR_ADPS0    = 0x1  // ADC  Prescaler Select Bits
	ADCSR_ADPS1    = 0x2  // ADC  Prescaler Select Bits
	ADCSR_ADPS2    = 0x4  // ADC  Prescaler Select Bits
	ADCSR_ADPS_Msk = 0x7  // ADC  Prescaler Select Bits
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD      = 0x80 // Analog Comparator Disable
	ACSR_ACD_Msk  = 0x80 // Analog Comparator Disable
	ACSR_ACBG     = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACBG_Msk = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO      = 0x20 // Analog Compare Output
	ACSR_ACO_Msk  = 0x20 // Analog Compare Output
	ACSR_ACI      = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACI_Msk  = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE     = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIE_Msk = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACME     = 0x4  // Analog Comparator Multiplexer Enable
	ACSR_ACME_Msk = 0x4  // Analog Comparator Multiplexer Enable
	ACSR_ACIS0    = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1    = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS_Msk = 0x3  // Analog Comparator Interrupt Mode Select bits
)

// Bitfields for USI: Universal Serial Interface
const (
	// USISR: USI Status Register
	USISR_USISIF     = 0x80 // Start Condition Interrupt Flag
	USISR_USISIF_Msk = 0x80 // Start Condition Interrupt Flag
	USISR_USIOIF     = 0x40 // Counter Overflow Interrupt Flag
	USISR_USIOIF_Msk = 0x40 // Counter Overflow Interrupt Flag
	USISR_USIPF      = 0x20 // Stop Condition Flag
	USISR_USIPF_Msk  = 0x20 // Stop Condition Flag
	USISR_USIDC      = 0x10 // Data Output Collision
	USISR_USIDC_Msk  = 0x10 // Data Output Collision
	USISR_USICNT0    = 0x1  // USI Counter Value Bits
	USISR_USICNT1    = 0x2  // USI Counter Value Bits
	USISR_USICNT2    = 0x4  // USI Counter Value Bits
	USISR_USICNT3    = 0x8  // USI Counter Value Bits
	USISR_USICNT_Msk = 0xf  // USI Counter Value Bits

	// USICR: USI Control Register
	USICR_USISIE     = 0x80 // Start Condition Interrupt Enable
	USICR_USISIE_Msk = 0x80 // Start Condition Interrupt Enable
	USICR_USIOIE     = 0x40 // Counter Overflow Interrupt Enable
	USICR_USIOIE_Msk = 0x40 // Counter Overflow Interrupt Enable
	USICR_USIWM0     = 0x10 // USI Wire Mode Bits
	USICR_USIWM1     = 0x20 // USI Wire Mode Bits
	USICR_USIWM_Msk  = 0x30 // USI Wire Mode Bits
	USICR_USICS0     = 0x4  // USI Clock Source Select Bits
	USICR_USICS1     = 0x8  // USI Clock Source Select Bits
	USICR_USICS_Msk  = 0xc  // USI Clock Source Select Bits
	USICR_USICLK     = 0x2  // Clock Strobe
	USICR_USICLK_Msk = 0x2  // Clock Strobe
	USICR_USITC      = 0x1  // Toggle Clock Port Pin
	USICR_USITC_Msk  = 0x1  // Toggle Clock Port Pin
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EERIE     = 0x8 // EEProm Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8 // EEProm Ready Interrupt Enable
	EECR_EEMWE     = 0x4 // EEPROM Master Write Enable
	EECR_EEMWE_Msk = 0x4 // EEPROM Master Write Enable
	EECR_EEWE      = 0x2 // EEPROM Write Enable
	EECR_EEWE_Msk  = 0x2 // EEPROM Write Enable
	EECR_EERE      = 0x1 // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1 // EEPROM Read Enable
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCR: Watchdog Timer Control Register
	WDTCR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCR_WDE      = 0x8  // Watch Dog Enable
	WDTCR_WDE_Msk  = 0x8  // Watch Dog Enable
	WDTCR_WDP0     = 0x1  // Watch Dog Timer Prescaler bits
	WDTCR_WDP1     = 0x2  // Watch Dog Timer Prescaler bits
	WDTCR_WDP2     = 0x4  // Watch Dog Timer Prescaler bits
	WDTCR_WDP_Msk  = 0x7  // Watch Dog Timer Prescaler bits
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_PUD      = 0x40 // Pull-up Disable
	MCUCR_PUD_Msk  = 0x40 // Pull-up Disable
	MCUCR_SE       = 0x20 // Sleep Enable
	MCUCR_SE_Msk   = 0x20 // Sleep Enable
	MCUCR_SM0      = 0x8  // Sleep Mode Select Bits
	MCUCR_SM1      = 0x10 // Sleep Mode Select Bits
	MCUCR_SM_Msk   = 0x18 // Sleep Mode Select Bits
	MCUCR_ISC00    = 0x1  // Interrupt Sense Control 0 bits
	MCUCR_ISC01    = 0x2  // Interrupt Sense Control 0 bits
	MCUCR_ISC0_Msk = 0x3  // Interrupt Sense Control 0 bits

	// MCUSR: MCU Status register
	MCUSR_WDRF      = 0x8 // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8 // Watchdog Reset Flag
	MCUSR_BORF      = 0x4 // Brown-out Reset Flag
	MCUSR_BORF_Msk  = 0x4 // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2 // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2 // External Reset Flag
	MCUSR_PORF      = 0x1 // Power-On Reset Flag
	MCUSR_PORF_Msk  = 0x1 // Power-On Reset Flag

	// OSCCAL: Status Register
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TIMSK: Timer/Counter Interrupt Mask Register
	TIMSK_TOIE0      = 0x2  // Timer/Counter0 Overflow Interrupt Enable
	TIMSK_TOIE0_Msk  = 0x2  // Timer/Counter0 Overflow Interrupt Enable
	TIMSK_OCIE1A     = 0x40 // Timer/Counter1 Output Compare Interrupt Enable
	TIMSK_OCIE1A_Msk = 0x40 // Timer/Counter1 Output Compare Interrupt Enable
	TIMSK_OCIE1B     = 0x20 // Timer/Counter1 Output Compare Interrupt Enable
	TIMSK_OCIE1B_Msk = 0x20 // Timer/Counter1 Output Compare Interrupt Enable
	TIMSK_TOIE1      = 0x4  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK_TOIE1_Msk  = 0x4  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR: Timer/Counter Interrupt Flag register
	TIFR_TOV0      = 0x2  // Timer/Counter0 Overflow Flag
	TIFR_TOV0_Msk  = 0x2  // Timer/Counter0 Overflow Flag
	TIFR_OCF1A     = 0x40 // Timer/Counter1 Output Compare Flag 1A
	TIFR_OCF1A_Msk = 0x40 // Timer/Counter1 Output Compare Flag 1A
	TIFR_OCF1B     = 0x20 // Timer/Counter1 Output Compare Flag 1B
	TIFR_OCF1B_Msk = 0x20 // Timer/Counter1 Output Compare Flag 1B
	TIFR_TOV1      = 0x4  // Timer/Counter1 Overflow Flag
	TIFR_TOV1_Msk  = 0x4  // Timer/Counter1 Overflow Flag

	// TCCR0: Timer/Counter0 Control Register
	TCCR0_PSR0     = 0x8 // Prescaler Reset Timer/Counter0
	TCCR0_PSR0_Msk = 0x8 // Prescaler Reset Timer/Counter0
	TCCR0_CS00     = 0x1 // Clock Select0 bits
	TCCR0_CS01     = 0x2 // Clock Select0 bits
	TCCR0_CS02     = 0x4 // Clock Select0 bits
	TCCR0_CS0_Msk  = 0x7 // Clock Select0 bits

	// TCCR1A: Timer/Counter Control Register A
	TCCR1A_COM1A0    = 0x40 // Comparator A Output Mode Bits
	TCCR1A_COM1A1    = 0x80 // Comparator A Output Mode Bits
	TCCR1A_COM1A_Msk = 0xc0 // Comparator A Output Mode Bits
	TCCR1A_COM1B0    = 0x10 // Comparator B Output Mode Bits
	TCCR1A_COM1B1    = 0x20 // Comparator B Output Mode Bits
	TCCR1A_COM1B_Msk = 0x30 // Comparator B Output Mode Bits
	TCCR1A_FOC1A     = 0x8  // Force Output Compare Match 1A
	TCCR1A_FOC1A_Msk = 0x8  // Force Output Compare Match 1A
	TCCR1A_FOC1B     = 0x4  // Force Output Compare Match 1B
	TCCR1A_FOC1B_Msk = 0x4  // Force Output Compare Match 1B
	TCCR1A_PWM1A     = 0x2  // Pulse Width Modulator A Enable
	TCCR1A_PWM1A_Msk = 0x2  // Pulse Width Modulator A Enable
	TCCR1A_PWM1B     = 0x1  // Pulse Width Modulator B Enable
	TCCR1A_PWM1B_Msk = 0x1  // Pulse Width Modulator B Enable

	// TCCR1B: Timer/Counter Control Register B
	TCCR1B_CTC1     = 0x80 // Clear Timer/Counter on Compare Match
	TCCR1B_CTC1_Msk = 0x80 // Clear Timer/Counter on Compare Match
	TCCR1B_PSR1     = 0x40 // Prescaler Reset Timer/Counter1
	TCCR1B_PSR1_Msk = 0x40 // Prescaler Reset Timer/Counter1
	TCCR1B_CS10     = 0x1  // Clock Select Bits
	TCCR1B_CS11     = 0x2  // Clock Select Bits
	TCCR1B_CS12     = 0x4  // Clock Select Bits
	TCCR1B_CS13     = 0x8  // Clock Select Bits
	TCCR1B_CS1_Msk  = 0xf  // Clock Select Bits

	// PLLCSR: PLL Control and Status Register
	PLLCSR_PCKE      = 0x4 // PCK Enable
	PLLCSR_PCKE_Msk  = 0x4 // PCK Enable
	PLLCSR_PLLE      = 0x2 // PLL Enable
	PLLCSR_PLLE_Msk  = 0x2 // PLL Enable
	PLLCSR_PLOCK     = 0x1 // PLL Lock Detector
	PLLCSR_PLOCK_Msk = 0x1 // PLL Lock Detector
)

// Bitfields for EXINT: External Interrupts
const (
	// GIMSK: General Interrupt Mask Register
	GIMSK_INT0     = 0x40 // External Interrupt Request 0 Enable
	GIMSK_INT0_Msk = 0x40 // External Interrupt Request 0 Enable
	GIMSK_PCIE0    = 0x10 // Pin Change Interrupt Enables
	GIMSK_PCIE1    = 0x20 // Pin Change Interrupt Enables
	GIMSK_PCIE_Msk = 0x30 // Pin Change Interrupt Enables

	// GIFR: General Interrupt Flag register
	GIFR_INTF0     = 0x40 // External Interrupt Flag 0
	GIFR_INTF0_Msk = 0x40 // External Interrupt Flag 0
	GIFR_PCIF      = 0x20 // Pin Change Interrupt Flag
	GIFR_PCIF_Msk  = 0x20 // Pin Change Interrupt Flag
)
