/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanPositionQueue;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanOrQuery
extends SpanQuery
implements Cloneable {
    private List<SpanQuery> clauses;
    private String field;

    public SpanOrQuery(SpanQuery ... clauses) {
        this.clauses = new ArrayList<SpanQuery>(clauses.length);
        for (SpanQuery seq : clauses) {
            this.addClause(seq);
        }
    }

    public final void addClause(SpanQuery clause) {
        if (this.field == null) {
            this.field = clause.getField();
        } else if (clause.getField() != null && !clause.getField().equals(this.field)) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
        this.clauses.add(clause);
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public SpanOrQuery clone() {
        int sz = this.clauses.size();
        SpanQuery[] newClauses = new SpanQuery[sz];
        for (int i = 0; i < sz; ++i) {
            newClauses[i] = (SpanQuery)this.clauses.get(i).clone();
        }
        SpanOrQuery soq = new SpanOrQuery(newClauses);
        soq.setBoost(this.getBoost());
        return soq;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanOrQuery clone = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            SpanQuery c = this.clauses.get(i);
            SpanQuery query = (SpanQuery)c.rewrite(reader);
            if (query == c) continue;
            if (clone == null) {
                clone = this.clone();
            }
            clone.clauses.set(i, query);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanOr([");
        Iterator<SpanQuery> i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("])");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanOrQuery that = (SpanOrQuery)o;
        return this.clauses.equals(that.clauses);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = h * 7 ^ this.clauses.hashCode();
        return h;
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        ArrayList<SpanWeight> subWeights = new ArrayList<SpanWeight>(this.clauses.size());
        for (SpanQuery q : this.clauses) {
            subWeights.add(q.createWeight(searcher, false));
        }
        return new SpanOrWeight(searcher, needsScores ? SpanOrQuery.getTermContexts(subWeights) : null, subWeights);
    }

    public class SpanOrWeight
    extends SpanWeight {
        final List<SpanWeight> subWeights;

        public SpanOrWeight(IndexSearcher searcher, Map<Term, TermContext> terms, List<SpanWeight> subWeights) throws IOException {
            super(SpanOrQuery.this, searcher, terms);
            this.subWeights = subWeights;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (SpanWeight w : this.subWeights) {
                w.extractTerms(terms);
            }
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            for (SpanWeight w : this.subWeights) {
                w.extractTermContexts(contexts);
            }
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            final ArrayList<Spans> subSpans = new ArrayList<Spans>(SpanOrQuery.this.clauses.size());
            for (SpanWeight w : this.subWeights) {
                Spans spans = w.getSpans(context, requiredPostings);
                if (spans == null) continue;
                subSpans.add(spans);
            }
            if (subSpans.size() == 0) {
                return null;
            }
            if (subSpans.size() == 1) {
                return (Spans)subSpans.get(0);
            }
            final DisiPriorityQueue<Spans> byDocQueue = new DisiPriorityQueue<Spans>(subSpans.size());
            for (Spans spans : subSpans) {
                byDocQueue.add(new DisiWrapper<Spans>(spans));
            }
            final SpanPositionQueue byPositionQueue = new SpanPositionQueue(subSpans.size());
            return new Spans(){
                Spans topPositionSpans = null;
                int lastDocTwoPhaseMatched = -1;
                long cost = -1L;

                @Override
                public int nextDoc() throws IOException {
                    this.topPositionSpans = null;
                    DisiWrapper topDocSpans = byDocQueue.top();
                    int currentDoc = topDocSpans.doc;
                    do {
                        topDocSpans.doc = ((Spans)topDocSpans.iterator).nextDoc();
                        topDocSpans = byDocQueue.updateTop();
                    } while (topDocSpans.doc == currentDoc);
                    return topDocSpans.doc;
                }

                @Override
                public int advance(int target) throws IOException {
                    this.topPositionSpans = null;
                    DisiWrapper topDocSpans = byDocQueue.top();
                    do {
                        topDocSpans.doc = ((Spans)topDocSpans.iterator).advance(target);
                        topDocSpans = byDocQueue.updateTop();
                    } while (topDocSpans.doc < target);
                    return topDocSpans.doc;
                }

                @Override
                public int docID() {
                    DisiWrapper topDocSpans = byDocQueue.top();
                    return topDocSpans.doc;
                }

                @Override
                public TwoPhaseIterator asTwoPhaseIterator() {
                    boolean hasApproximation = false;
                    for (DisiWrapper w : byDocQueue) {
                        if (w.twoPhaseView == null) continue;
                        hasApproximation = true;
                        break;
                    }
                    if (!hasApproximation) {
                        return null;
                    }
                    return new TwoPhaseIterator(new DisjunctionDISIApproximation(byDocQueue)){

                        @Override
                        public boolean matches() throws IOException {
                            return this.twoPhaseCurrentDocMatches();
                        }
                    };
                }

                boolean twoPhaseCurrentDocMatches() throws IOException {
                    DisiWrapper listAtCurrentDoc = byDocQueue.topList();
                    int currentDoc = listAtCurrentDoc.doc;
                    while (listAtCurrentDoc.twoPhaseView != null) {
                        if (listAtCurrentDoc.twoPhaseView.matches()) {
                            listAtCurrentDoc.lastApproxMatchDoc = currentDoc;
                            break;
                        }
                        listAtCurrentDoc.lastApproxNonMatchDoc = currentDoc;
                        listAtCurrentDoc = listAtCurrentDoc.next;
                        if (listAtCurrentDoc != null) continue;
                        return false;
                    }
                    this.lastDocTwoPhaseMatched = currentDoc;
                    this.topPositionSpans = null;
                    return true;
                }

                void fillPositionQueue() throws IOException {
                    assert (byPositionQueue.size() == 0);
                    DisiWrapper listAtCurrentDoc = byDocQueue.topList();
                    while (listAtCurrentDoc != null) {
                        Spans spansAtDoc = (Spans)listAtCurrentDoc.iterator;
                        if (this.lastDocTwoPhaseMatched == listAtCurrentDoc.doc && listAtCurrentDoc.twoPhaseView != null) {
                            if (listAtCurrentDoc.lastApproxNonMatchDoc == listAtCurrentDoc.doc) {
                                spansAtDoc = null;
                            } else if (listAtCurrentDoc.lastApproxMatchDoc != listAtCurrentDoc.doc && !listAtCurrentDoc.twoPhaseView.matches()) {
                                spansAtDoc = null;
                            }
                        }
                        if (spansAtDoc != null) {
                            assert (spansAtDoc.docID() == listAtCurrentDoc.doc);
                            assert (spansAtDoc.startPosition() == -1);
                            spansAtDoc.nextStartPosition();
                            assert (spansAtDoc.startPosition() != Integer.MAX_VALUE);
                            byPositionQueue.add(spansAtDoc);
                        }
                        listAtCurrentDoc = listAtCurrentDoc.next;
                    }
                    assert (byPositionQueue.size() > 0);
                }

                @Override
                public int nextStartPosition() throws IOException {
                    if (this.topPositionSpans == null) {
                        byPositionQueue.clear();
                        this.fillPositionQueue();
                        this.topPositionSpans = (Spans)byPositionQueue.top();
                    } else {
                        this.topPositionSpans.nextStartPosition();
                        this.topPositionSpans = (Spans)byPositionQueue.updateTop();
                    }
                    return this.topPositionSpans.startPosition();
                }

                @Override
                public int startPosition() {
                    return this.topPositionSpans == null ? -1 : this.topPositionSpans.startPosition();
                }

                @Override
                public int endPosition() {
                    return this.topPositionSpans == null ? -1 : this.topPositionSpans.endPosition();
                }

                @Override
                public int width() {
                    return this.topPositionSpans.width();
                }

                @Override
                public void collect(SpanCollector collector) throws IOException {
                    this.topPositionSpans.collect(collector);
                }

                @Override
                public String toString() {
                    return "spanOr(" + SpanOrQuery.this + ")@" + this.docID() + ": " + this.startPosition() + " - " + this.endPosition();
                }

                @Override
                public long cost() {
                    if (this.cost == -1L) {
                        this.cost = 0L;
                        for (Spans spans : subSpans) {
                            this.cost += spans.cost();
                        }
                    }
                    return this.cost;
                }
            };
        }
    }
}

