/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui.dnd;

import esmska.Context;
import esmska.data.Contact;
import esmska.gui.ImportFrame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.TransferHandler;
import org.apache.commons.lang.StringUtils;

public class ImportContactsTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(ImportContactsTransferHandler.class.getName());
    private static DataFlavor uriListFlavor;

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (!(support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || support.isDataFlavorSupported(uriListFlavor) || support.isDataFlavorSupported(DataFlavor.stringFlavor))) {
            return false;
        }
        support.setDropAction(1);
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            logger.warning("Can't import contacts data by drag&drop, unsupported format.");
            return false;
        }
        try {
            if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || support.isDataFlavorSupported(uriListFlavor)) {
                if (!this.isVCard(support)) {
                    logger.warning("Can't import contacts data by drag&drop, not a vCard file.");
                    return false;
                }
                List<File> files = this.getInputFiles(support);
                String fileName = files.get(0).getAbsolutePath();
                ImportFrame importFrame = new ImportFrame();
                importFrame.setLocationRelativeTo(Context.mainFrame);
                importFrame.importVCardFile(fileName);
                importFrame.setVisible(true);
            } else if (support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                String name = null;
                String number = null;
                StringUtils.trim(data);
                if (data == null || data.length() > 100 || data.contains("\n")) {
                    logger.warning("Can't import contacts data by drag&drop, not a valid string.");
                    return false;
                }
                String pNumber = Contact.parseNumber(data);
                Matcher matcher = Pattern.compile("[+0-9]").matcher(data);
                int numbers = 0;
                while (matcher.find()) {
                    ++numbers;
                }
                if (pNumber != null && numbers > data.length() / 2) {
                    number = pNumber;
                } else {
                    name = data;
                }
                Contact skeleton = new Contact(name, number, null);
                Context.mainFrame.getContactPanel().showAddContactDialog(skeleton);
            } else {
                String msg = "Unknown supported DnD flavor: " + Arrays.toString(support.getDataFlavors());
                assert (false) : msg;
                logger.warning(msg);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Problem getting dropped data", ex);
            return false;
        }
        return true;
    }

    private boolean isVCard(TransferHandler.TransferSupport support) throws UnsupportedFlavorException, IOException {
        List<File> files = this.getInputFiles(support);
        if (files.size() != 1) {
            return false;
        }
        String fileName = files.get(0).getAbsolutePath();
        String lower = fileName.toLowerCase();
        boolean supported = lower.endsWith("vcard") || lower.endsWith("vcf");
        return supported;
    }

    private List<File> getInputFiles(TransferHandler.TransferSupport support) throws UnsupportedFlavorException, IOException {
        if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Object data = support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            return (List)data;
        }
        if (support.isDataFlavorSupported(uriListFlavor)) {
            Object data = support.getTransferable().getTransferData(uriListFlavor);
            return ImportContactsTransferHandler.textURIListToFileList((String)data);
        }
        return Collections.emptyList();
    }

    private static List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        return list;
    }

    static {
        try {
            uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException ex) {
            assert (false) : "Can't happen";
            ex.printStackTrace();
        }
    }
}

