/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import org.gradle.model.internal.type.TypeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericArrayTypeWrapper
implements GenericArrayType,
TypeWrapper {
    private final TypeWrapper componentType;
    private final int hashCode;

    public GenericArrayTypeWrapper(TypeWrapper componentType, int hashCode) {
        this.componentType = componentType;
        this.hashCode = hashCode;
    }

    @Override
    public Type getGenericComponentType() {
        return this.componentType.unwrap();
    }

    @Override
    public Type unwrap() {
        return this;
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        this.componentType.collectClasses(builder);
    }

    public boolean equals(Object o) {
        if (o instanceof GenericArrayType) {
            GenericArrayType that = (GenericArrayType)o;
            return this == that || this.getGenericComponentType().equals(that.getGenericComponentType());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getRepresentation(true);
    }

    @Override
    public String getRepresentation(boolean full) {
        return this.componentType.getRepresentation(full) + "[]";
    }
}

