/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.Random;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class ScanexTileSource
extends TMSTileSource {
    private static final String DEFAULT_URL = "http://maps.kosmosnimki.ru";
    private static final int DEFAULT_MAXZOOM = 14;
    private static final String API_KEY = "4018C5A9AECAD8868ED5DEB2E41D09F7";
    private static double RADIUS_E = 6378137.0;
    private static double EQUATOR = 4.007501668557849E7;
    private static double E = 0.0818191908426;
    private ScanexLayer layer = ScanexLayer.IRS;
    private double cachedLat = 0.0;

    public ScanexTileSource(TileSourceInfo tileSourceInfo) {
        super(tileSourceInfo);
        String string = tileSourceInfo.getUrl();
        for (ScanexLayer scanexLayer : ScanexLayer.values()) {
            if (!string.equalsIgnoreCase(scanexLayer.getName())) continue;
            this.layer = scanexLayer;
            this.baseUrl = DEFAULT_URL;
            if (this.maxZoom != 0) break;
            this.maxZoom = 14;
            break;
        }
    }

    @Override
    public String getExtension() {
        return "jpeg";
    }

    @Override
    public String getTilePath(int n, int n2, int n3) {
        int n4 = (int)Math.pow(2.0, n - 1);
        n3 = n4 - n3 - 1;
        return this.layer.getUri() + "&apikey=" + API_KEY + "&x=" + (n2 -= n4) + "&y=" + n3 + "&z=" + n;
    }

    private double tileYToLat(double d, int n) {
        double d2;
        double d3 = this.cachedLat;
        do {
            d2 = d3;
            if (!((d3 -= Math.toDegrees(ScanexTileSource.nextTerm(Math.toRadians(d3), d, n))) > 85.05112877980659) && !(d3 < -85.05112877980659)) continue;
            Random random = new Random();
            d3 = -85.05112877980659 + (double)random.nextInt(170);
        } while (Math.abs(d2 - d3) > 1.0E-6);
        this.cachedLat = d3;
        return d3;
    }

    private static double nextTerm(double d, double d2, int n) {
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        n = (int)Math.pow(2.0, n - 1);
        double d5 = Math.exp((1.0 - d2 / (double)n) * Math.PI);
        double d6 = Math.tan(0.7853981633974483 + d / 2.0) - d5 * Math.pow(Math.tan(0.7853981633974483 + Math.asin(E * d3) / 2.0), E);
        double d7 = 1.0 / (1.0 - d3) - d5 * E * d4 / ((1.0 - E * d3) * Math.sqrt(1.0 - E * E * d3 * d3));
        return d6 / d7;
    }

    private static enum ScanexLayer {
        IRS("irs", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=BAC78D764F0443BD9AF93E7A998C9F5B"),
        SPOT("spot", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=F51CE95441284AF6B2FC319B609C7DEC");

        private String name;
        private String uri;

        private ScanexLayer(String string2, String string3) {
            this.name = string2;
            this.uri = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

