/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public class CombineWayAction
extends JosmAction {
    private static final BooleanProperty PROP_REVERSE_WAY = new BooleanProperty("tag-correction.reverse-way", true);

    public CombineWayAction() {
        super(I18n.tr("Combine Way", new Object[0]), "combineway", I18n.tr("Combine several ways into one.", new Object[0]), Shortcut.registerShortcut("tools:combineway", I18n.tr("Tool: {0}", I18n.tr("Combine Way", new Object[0])), 67, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/CombineWay"));
    }

    protected static boolean confirmChangeDirectionOfWays() {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Change directions?", new Object[0]), new String[]{I18n.tr("Reverse and Combine", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"wayflip", "cancel"});
        extendedDialog.setContent(I18n.tr("The ways can not be combined in their current directions.  Do you want to reverse some of them?", new Object[0]));
        extendedDialog.toggleEnable("combineway-reverse");
        extendedDialog.showDialog();
        return extendedDialog.getValue() == 1;
    }

    protected static void warnCombiningImpossible() {
        String string = I18n.tr("Could not combine ways<br>(They could not be merged into a single string of nodes)", new Object[0]);
        new Notification(string).setIcon(1).show();
    }

    protected static Way getTargetWay(Collection<Way> collection) {
        Way way = collection.iterator().next();
        Iterator<Way> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Way way2;
            way = way2 = iterator.next();
            if (way2.isNew()) continue;
            break;
        }
        return way;
    }

    public static Pair<Way, Command> combineWaysWorker(Collection<Way> collection) throws UserCancelException {
        Collection<Command> collection2;
        List<Command> list;
        List<Way> list2;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        collection.remove(null);
        collection = new LinkedHashSet<Way>(collection);
        NodeGraph nodeGraph = NodeGraph.createNearlyUndirectedGraphFromNodeWays(collection);
        List<Node> list3 = nodeGraph.buildSpanningPath();
        if (list3 == null) {
            CombineWayAction.warnCombiningImpossible();
            return null;
        }
        TagCollection tagCollection = TagCollection.unionOfAllPrimitives(collection);
        List<Way> list4 = new LinkedList<Way>();
        List<Way> list5 = new LinkedList<Way>();
        for (Way object22 : collection) {
            if (object22.getNodesCount() < 2 || list3.indexOf(object22.getNode(0)) + 1 == list3.lastIndexOf(object22.getNode(1))) {
                list5.add(object22);
                continue;
            }
            list4.add(object22);
        }
        if (list5.isEmpty()) {
            Collections.reverse(list3);
            list5 = list4;
            list4 = null;
        }
        if (list4 != null && !list4.isEmpty()) {
            if (!CombineWayAction.confirmChangeDirectionOfWays()) {
                return null;
            }
            list5 = ReverseWayTagCorrector.irreversibleWays(list5);
            if ((list4 = ReverseWayTagCorrector.irreversibleWays(list4)).size() > list5.size()) {
                Collections.reverse(list3);
                list2 = list5;
                list5 = list4;
                list4 = list2;
            }
            if (!list4.isEmpty() && PROP_REVERSE_WAY.get().booleanValue()) {
                list2 = new ArrayList<Way>(collection);
                list2.removeAll(list4);
                ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
                list = new ArrayList<Command>(list4.size());
                collection2 = null;
                for (Way way : list4) {
                    Way way2 = new Way(way);
                    list.add((Command)((Object)way2));
                    collection2 = reverseWayTagCorrector.execute(way, way2);
                }
                if (collection2 != null && !collection2.isEmpty()) {
                    for (Command command : collection2) {
                        command.executeCommand();
                    }
                }
                tagCollection = TagCollection.unionOfAllPrimitives(list);
                tagCollection.add(TagCollection.unionOfAllPrimitives(list2));
            }
        }
        list2 = CombineWayAction.getTargetWay(collection);
        Way way = new Way((Way)((Object)list2));
        way.setNodes(list3);
        list = CombinePrimitiveResolverDialog.launchIfNecessary(tagCollection, collection, Collections.singleton(list2));
        collection2 = new LinkedList<Command>();
        Iterator iterator = new LinkedList<Way>(collection);
        iterator.remove(list2);
        collection2.add(new ChangeCommand((OsmPrimitive)((Object)list2), way));
        collection2.addAll(list);
        collection2.add(new DeleteCommand((Collection<? extends OsmPrimitive>)((Object)iterator)));
        SequenceCommand sequenceCommand = new SequenceCommand(I18n.trn("Combine {0} way", "Combine {0} ways", collection.size(), collection.size()), collection2);
        return new Pair<List<Way>, SequenceCommand>(list2, sequenceCommand);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Pair<Way, Command> pair;
        if (CombineWayAction.getCurrentDataSet() == null) {
            return;
        }
        Collection<OsmPrimitive> collection = CombineWayAction.getCurrentDataSet().getSelected();
        Set<Way> set = OsmPrimitive.getFilteredSet(collection, Way.class);
        if (set.size() < 2) {
            new Notification(I18n.tr("Please select at least two ways to combine.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        try {
            pair = CombineWayAction.combineWaysWorker(set);
        }
        catch (UserCancelException userCancelException) {
            return;
        }
        if (pair == null) {
            return;
        }
        final Way way = (Way)pair.a;
        Main.main.undoRedo.add((Command)pair.b);
        if (way != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    JosmAction.getCurrentDataSet().setSelected(way);
                }
            };
            GuiHelper.runInEDT(runnable);
        }
    }

    @Override
    protected void updateEnabledState() {
        if (CombineWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
            return;
        }
        Collection<OsmPrimitive> collection = CombineWayAction.getCurrentDataSet().getSelected();
        this.updateEnabledState(collection);
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        int n = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++n;
        }
        this.setEnabled(n >= 2);
    }

    public static class NodeGraph {
        private Set<NodePair> edges = new LinkedHashSet<NodePair>();
        private int numUndirectedEges;
        private Map<Node, List<NodePair>> successors;
        private Map<Node, List<NodePair>> predecessors;

        public static List<NodePair> buildNodePairs(Way way, boolean bl) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (Pair<Node, Node> pair : way.getNodePairs(false)) {
                arrayList.add(new NodePair(pair));
                if (bl) continue;
                arrayList.add(new NodePair(pair).swap());
            }
            return arrayList;
        }

        public static List<NodePair> buildNodePairs(List<Way> list, boolean bl) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (Way way : list) {
                arrayList.addAll(NodeGraph.buildNodePairs(way, bl));
            }
            return arrayList;
        }

        public static List<NodePair> eliminateDuplicateNodePairs(List<NodePair> list) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (NodePair nodePair : list) {
                if (arrayList.contains(nodePair) || arrayList.contains(nodePair.swap())) continue;
                arrayList.add(nodePair);
            }
            return arrayList;
        }

        public static NodeGraph createDirectedGraphFromNodePairs(List<NodePair> list) {
            NodeGraph nodeGraph = new NodeGraph();
            for (NodePair nodePair : list) {
                nodeGraph.add(nodePair);
            }
            return nodeGraph;
        }

        public static NodeGraph createDirectedGraphFromWays(Collection<Way> collection) {
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                nodeGraph.add(NodeGraph.buildNodePairs(way, true));
            }
            return nodeGraph;
        }

        public static NodeGraph createUndirectedGraphFromNodeList(List<NodePair> list) {
            NodeGraph nodeGraph = new NodeGraph();
            for (NodePair nodePair : list) {
                nodeGraph.add(nodePair);
                nodeGraph.add(nodePair.swap());
            }
            return nodeGraph;
        }

        public static NodeGraph createUndirectedGraphFromNodeWays(Collection<Way> collection) {
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                nodeGraph.add(NodeGraph.buildNodePairs(way, false));
            }
            return nodeGraph;
        }

        public static NodeGraph createNearlyUndirectedGraphFromNodeWays(Collection<Way> collection) {
            boolean bl = true;
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                if (!way.isNew()) {
                    nodeGraph.add(NodeGraph.buildNodePairs(way, bl));
                    bl = false;
                    continue;
                }
                nodeGraph.add(NodeGraph.buildNodePairs(way, false));
            }
            return nodeGraph;
        }

        protected void rememberSuccessor(NodePair nodePair) {
            if (this.successors.containsKey(nodePair.getA())) {
                if (!this.successors.get(nodePair.getA()).contains(nodePair)) {
                    this.successors.get(nodePair.getA()).add(nodePair);
                }
            } else {
                ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
                arrayList.add(nodePair);
                this.successors.put(nodePair.getA(), arrayList);
            }
        }

        protected void rememberPredecessors(NodePair nodePair) {
            if (this.predecessors.containsKey(nodePair.getB())) {
                if (!this.predecessors.get(nodePair.getB()).contains(nodePair)) {
                    this.predecessors.get(nodePair.getB()).add(nodePair);
                }
            } else {
                ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
                arrayList.add(nodePair);
                this.predecessors.put(nodePair.getB(), arrayList);
            }
        }

        protected boolean isTerminalNode(Node node) {
            if (this.successors.get(node) == null) {
                return false;
            }
            if (this.successors.get(node).size() != 1) {
                return false;
            }
            if (this.predecessors.get(node) == null) {
                return true;
            }
            if (this.predecessors.get(node).size() == 1) {
                NodePair nodePair = this.successors.get(node).get(0);
                NodePair nodePair2 = this.predecessors.get(node).get(0);
                return nodePair.equals(nodePair2.swap());
            }
            return false;
        }

        protected void prepare() {
            LinkedHashSet<NodePair> linkedHashSet = new LinkedHashSet<NodePair>();
            this.successors = new LinkedHashMap<Node, List<NodePair>>();
            this.predecessors = new LinkedHashMap<Node, List<NodePair>>();
            for (NodePair nodePair : this.edges) {
                if (!linkedHashSet.contains(nodePair) && !linkedHashSet.contains(nodePair.swap())) {
                    linkedHashSet.add(nodePair);
                }
                this.rememberSuccessor(nodePair);
                this.rememberPredecessors(nodePair);
            }
            this.numUndirectedEges = linkedHashSet.size();
        }

        public void add(NodePair nodePair) {
            if (!this.edges.contains(nodePair)) {
                this.edges.add(nodePair);
            }
        }

        public void add(List<NodePair> list) {
            for (NodePair nodePair : list) {
                this.add(nodePair);
            }
        }

        protected Set<Node> getTerminalNodes() {
            LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
            for (Node node : this.getNodes()) {
                if (!this.isTerminalNode(node)) continue;
                linkedHashSet.add(node);
            }
            return linkedHashSet;
        }

        protected List<NodePair> getOutboundPairs(NodePair nodePair) {
            return this.getOutboundPairs(nodePair.getB());
        }

        protected List<NodePair> getOutboundPairs(Node node) {
            List<NodePair> list = this.successors.get(node);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        protected Set<Node> getNodes() {
            LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>(2 * this.edges.size());
            for (NodePair nodePair : this.edges) {
                linkedHashSet.add(nodePair.getA());
                linkedHashSet.add(nodePair.getB());
            }
            return linkedHashSet;
        }

        protected boolean isSpanningWay(Stack<NodePair> stack) {
            return this.numUndirectedEges == stack.size();
        }

        protected List<Node> buildPathFromNodePairs(Stack<NodePair> stack) {
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (NodePair nodePair : stack) {
                linkedList.add(nodePair.getA());
            }
            linkedList.add(stack.peek().getB());
            return linkedList;
        }

        protected List<Node> buildSpanningPath(Node node) {
            if (node == null) {
                return null;
            }
            Stack<NodePair> stack = new Stack<NodePair>();
            Stack<NodePair> stack2 = new Stack<NodePair>();
            stack2.addAll(this.getOutboundPairs(node));
            while (!stack2.isEmpty()) {
                NodePair nodePair = (NodePair)stack2.pop();
                if (stack.contains(nodePair) || stack.contains(nodePair.swap())) continue;
                while (!stack.isEmpty() && !((NodePair)stack.peek()).isPredecessorOf(nodePair)) {
                    stack.pop();
                }
                stack.push(nodePair);
                if (this.isSpanningWay(stack)) {
                    return this.buildPathFromNodePairs(stack);
                }
                stack2.addAll(this.getOutboundPairs(stack.peek()));
            }
            return null;
        }

        public List<Node> buildSpanningPath() {
            this.prepare();
            Set<Node> set = this.getTerminalNodes();
            set = set.isEmpty() ? this.getNodes() : set;
            for (Node node : set) {
                List<Node> list = this.buildSpanningPath(node);
                if (list == null) continue;
                return list;
            }
            return null;
        }
    }

    public static class NodePair {
        private final Node a;
        private final Node b;

        public NodePair(Node node, Node node2) {
            this.a = node;
            this.b = node2;
        }

        public NodePair(Pair<Node, Node> pair) {
            this((Node)pair.a, (Node)pair.b);
        }

        public NodePair(NodePair nodePair) {
            this(nodePair.a, nodePair.b);
        }

        public Node getA() {
            return this.a;
        }

        public Node getB() {
            return this.b;
        }

        public boolean isAdjacentToA(NodePair nodePair) {
            return nodePair.getA() == this.a || nodePair.getB() == this.a;
        }

        public boolean isAdjacentToB(NodePair nodePair) {
            return nodePair.getA() == this.b || nodePair.getB() == this.b;
        }

        public boolean isSuccessorOf(NodePair nodePair) {
            return nodePair.getB() == this.a;
        }

        public boolean isPredecessorOf(NodePair nodePair) {
            return this.b == nodePair.getA();
        }

        public NodePair swap() {
            return new NodePair(this.b, this.a);
        }

        public String toString() {
            return "" + '[' + this.a.getId() + ',' + this.b.getId() + ']';
        }

        public boolean contains(Node node) {
            return this.a == node || this.b == node;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.a == null ? 0 : this.a.hashCode());
            n = 31 * n + (this.b == null ? 0 : this.b.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NodePair nodePair = (NodePair)object;
            if (this.a == null ? nodePair.a != null : !this.a.equals(nodePair.a)) {
                return false;
            }
            return !(this.b == null ? nodePair.b != null : !this.b.equals(nodePair.b));
        }
    }
}

