/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RemoveNodesCommand
extends Command {
    private final Way way;
    private final Set<Node> rmNodes;

    public RemoveNodesCommand(Way way, List<Node> list) {
        this.way = way;
        this.rmNodes = new HashSet<Node>(list);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.way.removeNodes(this.rmNodes);
        this.way.setModified(true);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.way);
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Removed nodes from {0}", this.way.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(OsmPrimitiveType.WAY);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.rmNodes == null ? 0 : this.rmNodes.hashCode());
        n = 31 * n + (this.way == null ? 0 : this.way.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RemoveNodesCommand removeNodesCommand = (RemoveNodesCommand)object;
        if (this.rmNodes == null ? removeNodesCommand.rmNodes != null : !this.rmNodes.equals(removeNodesCommand.rmNodes)) {
            return false;
        }
        return !(this.way == null ? removeNodesCommand.way != null : !this.way.equals(removeNodesCommand.way));
    }
}

