/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import jcmdline.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.EncryptParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class EncryptCmdValidator
extends AbstractCmdValidator {
    public AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        EncryptParsedCommand parsedCommandDTO = new EncryptParsedCommand();
        if (cmdLineHandler != null) {
            StringParam etypeOption;
            StringParam upwdOption;
            StringParam apwdOption;
            FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
            if (!oOption.isSet()) {
                throw new ParseException(15);
            }
            File outFile = oOption.getFile();
            ValidationUtility.assertValidDirectory(outFile);
            parsedCommandDTO.setOutputFile(outFile);
            StringParam pOption = (StringParam)cmdLineHandler.getOption("p");
            if (pOption.isSet()) {
                parsedCommandDTO.setOutputFilesPrefix(pOption.getValue());
            }
            if ((apwdOption = (StringParam)cmdLineHandler.getOption("apwd")).isSet()) {
                parsedCommandDTO.setOwnerPwd(apwdOption.getValue());
            }
            if ((upwdOption = (StringParam)cmdLineHandler.getOption("upwd")).isSet()) {
                parsedCommandDTO.setUserPwd(upwdOption.getValue());
            }
            if ((etypeOption = (StringParam)cmdLineHandler.getOption("etype")).isSet()) {
                parsedCommandDTO.setEncryptionType(etypeOption.getValue());
            }
            PdfFileParam fOption = (PdfFileParam)cmdLineHandler.getOption("f");
            FileParam dOption = (FileParam)cmdLineHandler.getOption("d");
            if (fOption.isSet() || dOption.isSet()) {
                if (fOption.isSet()) {
                    Iterator fIterator = fOption.getPdfFiles().iterator();
                    while (fIterator.hasNext()) {
                        PdfFile currentFile = (PdfFile)fIterator.next();
                        ValidationUtility.assertValidPdfExtension(currentFile.getFile().getName());
                    }
                    parsedCommandDTO.setInputFileList(FileUtility.getPdfFiles(fOption.getPdfFiles()));
                }
                if (dOption.isSet()) {
                    File inputDir = dOption.getFile();
                    ValidationUtility.assertValidDirectory(inputDir);
                    parsedCommandDTO.setInputDirectory(inputDir);
                }
            } else {
                throw new ParseException(25);
            }
            StringParam allowOption = (StringParam)cmdLineHandler.getOption("allow");
            if (allowOption.isSet()) {
                Hashtable permissionsMap = this.getPermissionsMap(parsedCommandDTO.getEncryptionType());
                int permissions = 0;
                if (!permissionsMap.isEmpty()) {
                    Iterator permIterator = allowOption.getValues().iterator();
                    while (permIterator.hasNext()) {
                        String currentPermission = (String)permIterator.next();
                        Object value = permissionsMap.get(currentPermission);
                        if (value == null) continue;
                        permissions |= ((Integer)value).intValue();
                    }
                }
                permissionsMap = null;
                parsedCommandDTO.setPermissions(permissions);
            }
        } else {
            throw new ConsoleException(2);
        }
        return parsedCommandDTO;
    }

    private Hashtable getPermissionsMap(String encryptionType) {
        Hashtable<String, Integer> retMap = new Hashtable<String, Integer>(12);
        if ("rc4_40".equals(encryptionType)) {
            retMap.put("print", new Integer(2052));
            retMap.put("modify", new Integer(8));
            retMap.put("copy", new Integer(16));
            retMap.put("modifyannotations", new Integer(32));
        } else {
            retMap.put("print", new Integer(2052));
            retMap.put("modify", new Integer(8));
            retMap.put("copy", new Integer(16));
            retMap.put("modifyannotations", new Integer(32));
            retMap.put("fill", new Integer(256));
            retMap.put("screenreaders", new Integer(512));
            retMap.put("assembly", new Integer(1024));
            retMap.put("degradedprinting", new Integer(4));
        }
        return retMap;
    }
}

