/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.IntParam;
import jcmdline.LongParam;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import jcmdline.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.SplitParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class SplitCmdValidator
extends AbstractCmdValidator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        PdfFileParam fOption;
        SplitParsedCommand parsedCommandDTO = new SplitParsedCommand();
        if (cmdLineHandler == null) throw new ConsoleException(2);
        FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
        if (!oOption.isSet()) {
            throw new ParseException(15);
        }
        File outFile = oOption.getFile();
        ValidationUtility.assertValidDirectory(outFile);
        parsedCommandDTO.setOutputFile(outFile);
        StringParam pOption = (StringParam)cmdLineHandler.getOption("p");
        if (pOption.isSet()) {
            parsedCommandDTO.setOutputFilesPrefix(pOption.getValue());
        }
        if (!(fOption = (PdfFileParam)cmdLineHandler.getOption("f")).isSet()) {
            throw new ParseException(20);
        }
        PdfFile inputFile = fOption.getPdfFile();
        ValidationUtility.assertValidPdfExtension(inputFile.getFile().getName());
        parsedCommandDTO.setInputFile(FileUtility.getPdfFile(inputFile));
        StringParam sOption = (StringParam)cmdLineHandler.getOption("s");
        if (!sOption.isSet()) {
            throw new ParseException(10);
        }
        parsedCommandDTO.setSplitType(sOption.getValue());
        LongParam bOption = (LongParam)cmdLineHandler.getOption("b");
        if ("SIZE".equals(parsedCommandDTO.getSplitType())) {
            if (!bOption.isSet()) throw new ParseException(19);
            parsedCommandDTO.setSplitSize(new Long(bOption.longValue()));
        } else if (bOption.isSet()) {
            throw new ParseException(18);
        }
        IntParam blOption = (IntParam)cmdLineHandler.getOption("bl");
        StringParam bregexpOption = (StringParam)cmdLineHandler.getOption("b_regexp");
        if ("BLEVEL".equals(parsedCommandDTO.getSplitType())) {
            if (!blOption.isSet()) {
                throw new ParseException(24);
            }
            parsedCommandDTO.setBookmarksLevel(new Integer(blOption.intValue()));
            if (bregexpOption.isSet()) {
                parsedCommandDTO.setBookmarkRegexp(bregexpOption.getValue());
            }
        } else {
            if (blOption.isSet()) {
                throw new ParseException(23);
            }
            if (bregexpOption.isSet()) {
                throw new ParseException(28);
            }
        }
        StringParam nOption = (StringParam)cmdLineHandler.getOption("n");
        if ("NSPLIT".equals(parsedCommandDTO.getSplitType()) || "SPLIT".equals(parsedCommandDTO.getSplitType())) {
            Pattern p;
            if (!nOption.isSet()) throw new ParseException(13);
            String nValue = nOption.getValue().trim().replaceAll(",", "-").replaceAll(" ", "-");
            if ("NSPLIT".equals(parsedCommandDTO.getSplitType()) && !(p = Pattern.compile("([0-9]+)*")).matcher(nValue).matches()) {
                throw new ParseException(11);
            }
            if ("SPLIT".equals(parsedCommandDTO.getSplitType()) && !(p = Pattern.compile("([0-9]+)([-][0-9]+)*")).matcher(nValue).matches()) {
                throw new ParseException(12);
            }
            parsedCommandDTO.setSplitPageNumbers(this.getSplitPageNumbers(nValue));
            return parsedCommandDTO;
        } else {
            if (!nOption.isSet()) return parsedCommandDTO;
            throw new ParseException(14);
        }
    }

    private Integer[] getSplitPageNumbers(String nValue) throws ParseException {
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        try {
            String[] limits = nValue.split("-");
            for (int i = 0; i < limits.length; ++i) {
                retVal.add(new Integer(limits[i]));
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(12, nfe);
        }
        return retVal.toArray(new Integer[0]);
    }
}

