/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.preferences.IPreferences;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;

public class PreferencesArgs
implements IArgs {
    private static final String UNDEFINED = new String();
    private final IPreferences preferences;

    public PreferencesArgs(IPreferences iPreferences) {
        this.preferences = iPreferences;
    }

    @Override
    public IArgs.IBinding add(Object object) {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        return new ConversionIterator<String, IArgs.IBinding>(this.names().iterator()){

            @Override
            protected IArgs.IBinding createTargetObject(String string) {
                return new Binding(string);
            }
        };
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public IArgs copy() {
        return new PreferencesArgs(this.preferences);
    }

    @Override
    public IArgs.IBinding declare(String string) {
        return new Binding(string);
    }

    @Override
    public Object get(int n) {
        return this.get(String.valueOf(n));
    }

    @Override
    public Object get(int n, Object object) {
        return object;
    }

    @Override
    public Object get(String string) {
        try {
            if (this.preferences.nodeExists(string)) {
                IPreferences iPreferences = this.preferences.node(string);
                return new PreferencesArgs(iPreferences);
            }
            return this.preferences.get(string, null);
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    @Override
    public Object get(String string, Object object) {
        try {
            if (this.preferences.nodeExists(string)) {
                IPreferences iPreferences = this.preferences.node(string);
                return new PreferencesArgs(iPreferences);
            }
            String string2 = this.preferences.get(string, null);
            if (string2 == null) {
                return object;
            }
            return string2;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    @Override
    public boolean isDefined(String string) {
        return this.preferences.get(string, UNDEFINED) != UNDEFINED;
    }

    public boolean isIndexed() {
        return false;
    }

    public boolean isNamed() {
        return true;
    }

    public Set names() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.preferences.childrenNames()));
            List<String> list = Arrays.asList(this.preferences.keys());
            arrayList.addAll(list);
            return new HashSet<String>(arrayList);
        }
        catch (BackingStoreException backingStoreException) {
            return new HashSet();
        }
    }

    @Override
    public IArgs.IBinding put(int n, Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public IArgs.IBinding put(String string, Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public int size() {
        try {
            return this.preferences.childrenNames().length + this.preferences.keys().length;
        }
        catch (BackingStoreException backingStoreException) {
            return 0;
        }
    }

    public String toString() {
        return ArgTools.toString(this, "[p]");
    }

    @Override
    public void undefine(int n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public void undefine(String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    class Binding
    implements IArgs.IBinding {
        private String name;

        public Binding(String string) {
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return PreferencesArgs.this.get(this.name);
        }

        @Override
        public boolean isDefined() {
            return PreferencesArgs.this.isDefined(this.name);
        }

        @Override
        public void setValue(Object object) {
            PreferencesArgs.this.put(this.name, object);
        }
    }
}

