/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;
import de.intarsys.tools.reporter.ReportDispatcher;
import de.intarsys.tools.reporter.ReportEvent;

public class ReplayReporter
implements IReporter,
IReporterSupport {
    private final Object owner;
    private final ReportDispatcher dispatcher;
    private final ReportEvent[] messages = new ReportEvent[10];
    private int first = 0;

    public ReplayReporter(Object object) {
        this.owner = object;
        this.dispatcher = new ReportDispatcher(object);
    }

    protected void addMessage(ReportEvent reportEvent) {
        this.messages[this.first] = reportEvent;
        this.first = (this.first + 1) % this.messages.length;
    }

    @Override
    public void addReporter(IReporter iReporter) {
        this.dispatcher.addReporter(iReporter);
        this.replay(iReporter);
    }

    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void removeReporter(IReporter iReporter) {
        this.dispatcher.removeReporter(iReporter);
    }

    protected void replay(IReporter iReporter) {
        int n = 0;
        while (n < this.messages.length) {
            int n2 = (n + this.first) % this.messages.length;
            ReportEvent reportEvent = this.messages[n2];
            if (reportEvent != null) {
                if (reportEvent.isTypeStatus()) {
                    iReporter.reportStatus(reportEvent.getMessage(), reportEvent.getStyle());
                } else if (reportEvent.isTypeMessage()) {
                    iReporter.reportMessage(reportEvent.getTitle(), reportEvent.getMessage(), reportEvent.getStyle());
                } else if (reportEvent.isTypeError()) {
                    iReporter.reportError(reportEvent.getTitle(), reportEvent.getMessage(), reportEvent.getThrowable(), reportEvent.getStyle());
                }
            }
            ++n;
        }
    }

    @Override
    public void reportActivityEnd() {
        this.addMessage(new ReportEvent(2));
        this.dispatcher.reportActivityEnd();
    }

    @Override
    public void reportActivityStart(String string, int n) {
        this.addMessage(new ReportEvent(1, string, n));
        this.dispatcher.reportActivityStart(string, n);
    }

    @Override
    public void reportError(String string, String string2, Throwable throwable, int n) {
        this.addMessage(new ReportEvent(5, string, string2, throwable, n));
        this.dispatcher.reportError(string, string2, throwable, n);
    }

    @Override
    public void reportMessage(String string, String string2, int n) {
        this.addMessage(new ReportEvent(4, string, string2, n));
        this.dispatcher.reportMessage(string, string2, n);
    }

    @Override
    public void reportProgress(String string, int n, int n2) {
        this.addMessage(new ReportEvent(0, string, n, n2));
        this.dispatcher.reportProgress(string, n, n2);
    }

    @Override
    public void reportStatus(String string, int n) {
        this.addMessage(new ReportEvent(3, string, n));
        this.dispatcher.reportStatus(string, n);
    }
}

