/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize;

import de.intarsys.tools.serialize.SerializationContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class StreamSerializationContext
extends SerializationContext {
    private final InputStream inputStream;
    private final OutputStream outputStream;

    public StreamSerializationContext() {
        this.inputStream = null;
        this.outputStream = new ByteArrayOutputStream();
    }

    public StreamSerializationContext(byte[] byArray) {
        this.inputStream = new ByteArrayInputStream(byArray);
        this.outputStream = null;
    }

    public StreamSerializationContext(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public StreamSerializationContext(String string) {
        byte[] byArray;
        try {
            if (string == null) {
                string = "";
            }
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF-8 not supported");
        }
        this.inputStream = new ByteArrayInputStream(byArray);
        this.outputStream = null;
    }

    public byte[] getBytes() {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.outputStream).toByteArray();
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

