/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tlv.common;

import de.intarsys.tools.tlv.common.SimpleInputStream;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvFormatException;
import de.intarsys.tools.tlv.common.TlvInputStream;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SimpleElement
extends TlvElement {
    public static SimpleElement parseElement(byte[] byArray, int n, int n2) throws IOException {
        SimpleInputStream simpleInputStream = new SimpleInputStream(byArray, n, n2);
        return (SimpleElement)simpleInputStream.readElement();
    }

    public static TlvTemplate parseTemplate(byte[] byArray, int n, int n2) throws IOException {
        SimpleInputStream simpleInputStream = new SimpleInputStream(byArray, n, n2);
        return new TlvTemplate(simpleInputStream);
    }

    public SimpleElement(int n, byte[] byArray) {
        super(n, byArray);
        if (n <= 0 || n >= 255) {
            throw new IllegalArgumentException("illegal identifier value");
        }
    }

    public SimpleElement(int n, byte[] byArray, int n2, int n3) {
        super(n, byArray, n2, n3);
        if (n <= 0 || n >= 255) {
            throw new IllegalArgumentException("illegal identifier value");
        }
    }

    @Override
    public TlvInputStream createTlvInputStream(byte[] byArray, int n, int n2) throws TlvFormatException {
        return new SimpleInputStream(byArray, n, n2);
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.getIdentifier());
        if (this.getLength() < 255) {
            byteArrayOutputStream.write(this.getLength());
        } else if (this.getLength() <= 65535) {
            byteArrayOutputStream.write(255);
            byteArrayOutputStream.write(this.getLength() >> 8 & 0xFF);
            byteArrayOutputStream.write(this.getLength() & 0xFF);
        } else {
            throw new IllegalArgumentException("size > 0xFFFF not supported");
        }
        byteArrayOutputStream.write(this.buffer, this.offset, this.length);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public boolean isComposite() {
        return false;
    }
}

