/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.dnd.droppers;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.commons.dnd.DnDSupportUtility;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public abstract class AbstractDropper
extends DropTargetAdapter {
    private static final Logger log = Logger.getLogger(AbstractDropper.class.getPackage().getName());

    @Override
    public void drop(DropTargetDropEvent e) {
        try {
            DropTargetContext context = e.getDropTargetContext();
            e.acceptDrop(3);
            Transferable t = e.getTransferable();
            List<File> data = null;
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                data = (List<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
            } else if (t.isDataFlavorSupported(DnDSupportUtility.URI_LIST_FLAVOR)) {
                data = DnDSupportUtility.textURIListToFileList((String)t.getTransferData(DnDSupportUtility.URI_LIST_FLAVOR));
            }
            if (data != null) {
                this.executeDrop(data);
            }
            context.dropComplete(true);
        }
        catch (Exception ex) {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), ex);
        }
    }

    protected abstract void executeDrop(List<File> var1);
}

