/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCompleteTextField;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.FontNameComboBox;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LabelController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabelPanel
extends JPanel
implements DialogView {
    private final boolean labelModification;
    private final LabelController controller;
    private JLabel textLabel;
    private JTextField textTextField;
    private JLabel fontNameLabel;
    private FontNameComboBox fontNameComboBox;
    private JLabel fontSizeLabel;
    private JSpinner fontSizeSpinner;
    private JLabel colorLabel;
    private ColorButton colorButton;
    private NullableCheckBox visibleIn3DViewCheckBox;
    private JLabel pitchLabel;
    private JRadioButton pitch0DegreeRadioButton;
    private JRadioButton pitch90DegreeRadioButton;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private String dialogTitle;

    public LabelPanel(boolean bl, UserPreferences userPreferences, LabelController labelController) {
        super(new GridBagLayout());
        this.labelModification = bl;
        this.controller = labelController;
        this.createComponents(bl, userPreferences, labelController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(labelController, userPreferences);
    }

    private void createComponents(boolean bl, UserPreferences userPreferences, final LabelController labelController) {
        this.textLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "textLabel.text", new Object[0]));
        this.textTextField = new AutoCompleteTextField(labelController.getText(), 20, userPreferences.getAutoCompletionStrings("LabelText"));
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.textTextField);
        }
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LabelPanel.this.textTextField.setText(labelController.getText());
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.TEXT, propertyChangeListener);
        this.textTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                labelController.removePropertyChangeListener(LabelController.Property.TEXT, propertyChangeListener);
                String string = LabelPanel.this.textTextField.getText();
                if (string == null || string.trim().length() == 0) {
                    labelController.setText("");
                } else {
                    labelController.setText(string);
                }
                labelController.addPropertyChangeListener(LabelController.Property.TEXT, propertyChangeListener);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        this.fontNameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "fontNameLabel.text", new Object[0]));
        this.fontNameComboBox = new FontNameComboBox(userPreferences);
        this.fontNameComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)LabelPanel.this.fontNameComboBox.getSelectedItem();
                labelController.setFontName(string == "DEFAULT_SYSTEM_FONT_NAME" ? null : string);
            }
        });
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (labelController.isFontNameSet()) {
                    String string = labelController.getFontName();
                    LabelPanel.this.fontNameComboBox.setSelectedItem(string == null ? "DEFAULT_SYSTEM_FONT_NAME" : string);
                } else {
                    LabelPanel.this.fontNameComboBox.setSelectedItem(null);
                }
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.FONT_NAME, propertyChangeListener2);
        propertyChangeListener2.propertyChange(null);
        String string = userPreferences.getLengthUnit().getName();
        this.fontSizeLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "fontSizeLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 5.0f, 999.0f);
        this.fontSizeSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        final PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Float f = labelController.getFontSize();
                nullableSpinnerLengthModel.setNullable(f == null);
                nullableSpinnerLengthModel.setLength(f);
            }
        };
        propertyChangeListener3.propertyChange(null);
        labelController.addPropertyChangeListener(LabelController.Property.FONT_SIZE, propertyChangeListener3);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                labelController.removePropertyChangeListener(LabelController.Property.FONT_SIZE, propertyChangeListener3);
                labelController.setFontSize(nullableSpinnerLengthModel.getLength());
                labelController.addPropertyChangeListener(LabelController.Property.FONT_SIZE, propertyChangeListener3);
            }
        });
        this.colorLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "colorLabel.text", new Object[0]));
        this.colorButton = new ColorButton(userPreferences);
        if (OperatingSystem.isMacOSX()) {
            this.colorButton.putClientProperty("JButton.buttonType", "segmented");
            this.colorButton.putClientProperty("JButton.segmentPosition", "only");
        }
        this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(LabelPanel.class, "colorDialog.title", new Object[0]));
        this.colorButton.setColor(labelController.getColor());
        this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                labelController.setColor(LabelPanel.this.colorButton.getColor());
            }
        });
        labelController.addPropertyChangeListener(LabelController.Property.COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LabelPanel.this.colorButton.setColor(labelController.getColor());
            }
        });
        final PropertyChangeListener propertyChangeListener4 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LabelPanel.this.update3DViewComponents(labelController);
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.PITCH, propertyChangeListener4);
        this.visibleIn3DViewCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "visibleIn3DViewCheckBox.text", new Object[0]));
        if (labelController.isPitchEnabled() != null) {
            this.visibleIn3DViewCheckBox.setValue(labelController.isPitchEnabled());
        } else {
            this.visibleIn3DViewCheckBox.setNullable(true);
            this.visibleIn3DViewCheckBox.setValue(null);
        }
        this.visibleIn3DViewCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                labelController.removePropertyChangeListener(LabelController.Property.PITCH, propertyChangeListener4);
                if (LabelPanel.this.visibleIn3DViewCheckBox.isNullable()) {
                    LabelPanel.this.visibleIn3DViewCheckBox.setNullable(false);
                }
                if (Boolean.FALSE.equals(LabelPanel.this.visibleIn3DViewCheckBox.getValue())) {
                    labelController.setPitch(null);
                } else if (LabelPanel.this.pitch90DegreeRadioButton.isSelected()) {
                    labelController.setPitch(Float.valueOf(1.5707964f));
                } else {
                    labelController.setPitch(Float.valueOf(0.0f));
                }
                LabelPanel.this.update3DViewComponents(labelController);
                labelController.addPropertyChangeListener(LabelController.Property.PITCH, propertyChangeListener4);
            }
        });
        this.pitchLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "pitchLabel.text", new Object[0]));
        this.pitch0DegreeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "pitch0DegreeRadioButton.text", new Object[0]));
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (LabelPanel.this.pitch0DegreeRadioButton.isSelected()) {
                    labelController.setPitch(Float.valueOf(0.0f));
                } else if (LabelPanel.this.pitch90DegreeRadioButton.isSelected()) {
                    labelController.setPitch(Float.valueOf(1.5707964f));
                }
            }
        };
        this.pitch0DegreeRadioButton.addItemListener(itemListener);
        this.pitch90DegreeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "pitch90DegreeRadioButton.text", new Object[0]));
        this.pitch90DegreeRadioButton.addItemListener(itemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.pitch0DegreeRadioButton);
        buttonGroup.add(this.pitch90DegreeRadioButton);
        this.elevationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, LabelPanel.class, "elevationLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, userPreferences.getLengthUnit().getMaximumElevation());
        this.elevationSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.setNullable(labelController.getElevation() == null);
        nullableSpinnerLengthModel2.setLength(labelController.getElevation());
        final PropertyChangeListener propertyChangeListener5 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel2.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        labelController.addPropertyChangeListener(LabelController.Property.ELEVATION, propertyChangeListener5);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                labelController.removePropertyChangeListener(LabelController.Property.ELEVATION, propertyChangeListener5);
                labelController.setElevation(nullableSpinnerLengthModel2.getLength());
                labelController.addPropertyChangeListener(LabelController.Property.ELEVATION, propertyChangeListener5);
            }
        });
        this.update3DViewComponents(labelController);
        this.dialogTitle = userPreferences.getLocalizedString(LabelPanel.class, bl ? "labelModification.title" : "labelCreation.title", new Object[0]);
    }

    private void update3DViewComponents(LabelController labelController) {
        boolean bl = Boolean.TRUE.equals(labelController.isPitchEnabled());
        this.pitch0DegreeRadioButton.setEnabled(bl);
        this.pitch90DegreeRadioButton.setEnabled(bl);
        this.elevationSpinner.setEnabled(bl);
        if (labelController.getPitch() != null) {
            if (labelController.getPitch().floatValue() == 0.0f) {
                this.pitch0DegreeRadioButton.setSelected(true);
            } else if (labelController.getPitch().floatValue() == 1.5707964f) {
                this.pitch90DegreeRadioButton.setSelected(true);
            }
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.textLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "textLabel.mnemonic", new Object[0])).getKeyCode());
            this.textLabel.setLabelFor(this.textTextField);
            this.fontNameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "fontNameLabel.mnemonic", new Object[0])).getKeyCode());
            this.fontNameLabel.setLabelFor(this.fontNameComboBox);
            this.fontSizeLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "fontSizeLabel.mnemonic", new Object[0])).getKeyCode());
            this.fontSizeLabel.setLabelFor(this.fontSizeSpinner);
            this.visibleIn3DViewCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "visibleIn3DViewCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.pitch0DegreeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "pitch0DegreeRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.pitch90DegreeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "pitch90DegreeRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(LabelPanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setLabelFor(this.elevationSpinner);
        }
    }

    private void layoutComponents(LabelController labelController, UserPreferences userPreferences) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        JPanel jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(LabelPanel.class, "textAndStylePanel.title", new Object[0]));
        jPanel.add((Component)this.textLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel.add((Component)this.textTextField, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.fontNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel.add((Component)this.fontNameComboBox, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.fontSizeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.fontSizeSpinner, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 5, 0));
        jPanel.add((Component)this.colorLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 10, 0, 5), 0, 0));
        jPanel.add((Component)this.colorButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, OperatingSystem.isMacOSX() ? 6 : 0), 0, 0));
        int n2 = OperatingSystem.isMacOSXLeopardOrSuperior() ? 0 : 5;
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, n2, 0), 0, 0));
        JPanel jPanel2 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(LabelPanel.class, "rendering3DPanel.title", new Object[0]));
        jPanel2.add((Component)this.visibleIn3DViewCheckBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, OperatingSystem.isMacOSX() ? -8 : 0, 5, 0), 0, 0));
        jPanel2.add((Component)this.pitchLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel2.add((Component)this.pitch0DegreeRadioButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel2.add((Component)this.pitch90DegreeRadioButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel2.add((Component)this.elevationLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel2.add((Component)this.elevationSpinner, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.textTextField) == 0 && this.controller != null) {
            if (this.labelModification) {
                this.controller.modifyLabels();
            } else {
                this.controller.createLabel();
            }
        }
    }
}

