/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics.geom;

import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
    }

    public Rectangle(Double d, Double d2, Double d3, Double d4) {
        this((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
    }

    public Rectangle(int n, int n2, int n3, int n4) {
        this();
        this.setBounds(n, n2, n3, n4);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public int getX() {
        return this.x;
    }

    public int getX2() {
        return this.x + this.width;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public int getY2() {
        return this.y + this.height;
    }

    public PointDouble getUpperLeftCorner() {
        return new PointDouble(this.x, this.y);
    }

    public PointDouble getCenter() {
        return new PointDouble(this.x + this.width / 2, this.y + this.height / 2);
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public void addBorder(int n) {
        this.x -= n;
        this.y -= n;
        this.width += n * 2;
        this.height += n * 2;
    }

    public boolean contains(Point point) {
        return this.contains(new Rectangle(point.getX(), point.getY(), 0, 0));
    }

    public boolean contains(Rectangle rectangle) {
        return this.getX() <= rectangle.getX() && this.getX2() >= rectangle.getX2() && this.getY() <= rectangle.getY() && this.getY2() >= rectangle.getY2();
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public boolean intersects(Rectangle rectangle) {
        if (this.getY2() < rectangle.getY()) {
            return false;
        }
        if (this.getY() > rectangle.getY2()) {
            return false;
        }
        if (this.getX2() < rectangle.getX()) {
            return false;
        }
        return this.getX() <= rectangle.getX2();
    }

    public void merge(Rectangle rectangle) {
        int n = this.getX2();
        int n2 = this.getY2();
        this.setX(Math.min(this.getX(), rectangle.getX()));
        this.setY(Math.min(this.getY(), rectangle.getY()));
        this.setWidth(Math.max(n, rectangle.getX2()) - this.getX());
        this.setHeight(Math.max(n2, rectangle.getY2()) - this.getY());
    }

    public Rectangle copy() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle copyInverted() {
        return new Rectangle(-this.x, -this.y, -this.width, -this.height);
    }

    public Rectangle subtract(Rectangle rectangle) {
        return new Rectangle(this.x - rectangle.x, this.y - rectangle.y, this.width - rectangle.width, this.height - rectangle.height);
    }

    public Rectangle add(Rectangle rectangle) {
        return new Rectangle(this.x + rectangle.x, this.y + rectangle.y, this.width + rectangle.width, this.height + rectangle.height);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.height;
        n = 31 * n + this.width;
        n = 31 * n + this.x;
        n = 31 * n + this.y;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)object;
        if (this.height != rectangle.height) {
            return false;
        }
        if (this.width != rectangle.width) {
            return false;
        }
        if (this.x != rectangle.x) {
            return false;
        }
        return this.y == rectangle.y;
    }

    public String toString() {
        return "Rectangle [x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

