/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.Main;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DrawPanel;
import com.baselet.diagram.SelectorFrame;
import com.baselet.element.Selector;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.custom.CustomElement;
import com.baselet.gui.CurrentGui;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class SelectorOld
extends Selector {
    private GridElement dominantEntity;
    private final Vector<GridElement> selectedElements = new Vector();
    private final DrawPanel panel;
    private boolean _selectorframeactive;
    private final SelectorFrame _selectorframe;

    public SelectorOld(DrawPanel panel) {
        this.panel = panel;
        this._selectorframeactive = false;
        this._selectorframe = new SelectorFrame();
    }

    public GridElement getDominantEntity() {
        if (this.dominantEntity == null && !this.selectedElements.isEmpty()) {
            return this.selectedElements.firstElement();
        }
        return this.dominantEntity;
    }

    public void setDominantEntity(GridElement dominantEntity) {
        this.dominantEntity = dominantEntity;
    }

    public SelectorFrame getSelectorFrame() {
        return this._selectorframe;
    }

    public void setSelectorFrameActive(boolean active) {
        this._selectorframeactive = active;
        if (!active) {
            this._selectorframe.reset();
        }
    }

    public boolean isSelectorFrameActive() {
        return this._selectorframeactive;
    }

    public void deselectAllWithoutUpdatePropertyPanel() {
        ArrayList<GridElement> listCopy = new ArrayList<GridElement>(this.selectedElements);
        this.selectedElements.clear();
        for (GridElement e : listCopy) {
            e.repaint();
        }
        this.dominantEntity = null;
    }

    public void selectAll() {
        this.select(this.panel.getGridElements());
    }

    @Override
    public void doAfterSelectionChanged() {
        this.updateSelectorInformation();
    }

    private void updateGUIInformation() {
        CurrentGui.getInstance().getGui().elementsSelected(this.selectedElements);
        boolean customElementSelected = this.selectedElements.size() == 1 && this.selectedElements.get(0) instanceof CustomElement;
        CurrentGui.getInstance().getGui().setCustomElementSelected(customElementSelected);
    }

    public void updateSelectorInformation() {
        GridElement elementForPropPanel = null;
        if (!this.selectedElements.isEmpty()) {
            elementForPropPanel = this.selectedElements.elementAt(this.selectedElements.size() - 1);
        }
        this.updateSelectorInformation(elementForPropPanel);
    }

    public void updateSelectorInformation(GridElement elementForPropPanel) {
        CurrentDiagram.getInstance().setCurrentDiagramHandler(this.panel.getHandler());
        if (CurrentGui.getInstance().getGui() != null) {
            this.updateGUIInformation();
            Main.getInstance().setPropertyPanelToGridElement(elementForPropPanel);
        }
    }

    public void multiSelect(Rectangle rect) {
        for (GridElement e : this.panel.getGridElements()) {
            if (!e.isInRange(rect)) continue;
            this.select(e);
        }
    }

    @Override
    public boolean isSelected(GridElement ge) {
        boolean isSelected = super.isSelected(ge);
        return isSelected;
    }

    @Override
    public List<GridElement> getSelectedElements() {
        return this.selectedElements;
    }

    @Override
    public List<GridElement> getAllElements() {
        if (CurrentDiagram.getInstance().getDiagramHandler() == null) {
            return Collections.emptyList();
        }
        return CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel().getGridElements();
    }

    @Override
    public void doAfterSelect(GridElement e) {
        super.doAfterSelect(e);
        e.repaint();
    }

    @Override
    public void doAfterDeselect(GridElement e) {
        super.doAfterDeselect(e);
        e.repaint();
    }
}

