/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.parser;

import com.baselet.control.Matrix;
import com.baselet.element.elementnew.plot.parser.ParserException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataSet {
    private String id;
    private Integer nr;
    private int lineNr;
    private boolean isInverted;
    private List<String> titleRow = null;
    private List<String> titleCol = null;
    private Matrix<Double> valueMatrix;
    private Matrix<String> analyseMatrix;
    public static final Double VALUE_DEFAULT = 0.0;

    protected DataSet(String string, int n, int n2) {
        this.id = string;
        this.nr = n;
        this.lineNr = n2;
        this.analyseMatrix = new Matrix();
    }

    public String getId() {
        return this.id;
    }

    public Integer getNr() {
        return this.nr;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public int rows() {
        return this.valueMatrix.rows();
    }

    public int cols() {
        return this.valueMatrix.cols();
    }

    public boolean isEmpty() {
        return this.valueMatrix.isEmpty();
    }

    public Double[] row(int n) {
        List<Double> list = this.valueMatrix.row(n);
        return list.toArray(new Double[list.size()]);
    }

    public Double[][] data() {
        if (this.valueMatrix.isEmpty()) {
            throw new ParserException("The dataset (line: " + this.getLineNr() + ") has no values");
        }
        Double[][] doubleArray = new Double[this.rows()][];
        for (int i = 0; i < this.rows(); ++i) {
            doubleArray[i] = this.row(i);
        }
        return doubleArray;
    }

    public void setInvert(boolean bl) {
        if (this.isInverted == !bl) {
            this.analyseMatrix.invert();
            this.separateTitleRowColFromContent();
            this.isInverted = bl;
        }
    }

    public String[] titleRow() {
        return this.titleRow.toArray(new String[this.titleRow.size()]);
    }

    public String[] titleCol() {
        return this.titleCol.toArray(new String[this.titleCol.size()]);
    }

    public String toString() {
        return "Dataset (" + this.id + ")\n" + this.analyseMatrix;
    }

    protected void addLine(String[] stringArray) {
        this.analyseMatrix.addLine(new ArrayList<String>(Arrays.asList(stringArray)));
    }

    protected void analyseMatrix() {
        this.separateTitleRowColFromContent();
    }

    private void separateTitleRowColFromContent() {
        int n;
        if (this.analyseMatrix.isEmpty()) {
            throw new ParserException("The dataset (line: " + this.getLineNr() + ") has no content");
        }
        List<String> list = this.analyseMatrix.row(0);
        List<String> list2 = this.analyseMatrix.col(0);
        boolean bl = this.isTitleLine(list);
        boolean bl2 = this.isTitleLine(list2);
        if (bl && bl2) {
            if (!list.get(0).isEmpty() || !list2.get(0).isEmpty()) {
                throw new ParserException("If a dataset has a title row and column, the upper left space must be empty");
            }
            this.titleRow = list.subList(1, list.size());
            this.titleCol = list2.subList(1, list2.size());
        } else if (bl && !bl2) {
            this.titleRow = list;
            this.titleCol = this.createEmptyList(list2.size() - 1);
        } else if (!bl && bl2) {
            this.titleRow = this.createEmptyList(list.size() - 1);
            this.titleCol = list2;
        } else {
            this.titleRow = this.createEmptyList(list.size());
            this.titleCol = this.createEmptyList(list2.size());
        }
        this.valueMatrix = new Matrix();
        int n2 = n = bl ? 1 : 0;
        while (n < this.analyseMatrix.rows()) {
            int n3;
            List<String> list3 = this.analyseMatrix.row(n);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            int n4 = n3 = bl2 ? 1 : 0;
            while (n3 < list3.size()) {
                String string = list3.get(n3);
                try {
                    if (string == null) {
                        throw new NumberFormatException();
                    }
                    arrayList.add(Double.parseDouble(string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException("The Dataset (line: " + this.getLineNr() + ") contains invalid values");
                }
                ++n3;
            }
            this.valueMatrix.addLine(arrayList);
            ++n;
        }
    }

    private boolean isTitleLine(List<String> list) {
        int n = 0;
        for (String string : list) {
            if (string == null) continue;
            try {
                Double.parseDouble(string);
                ++n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return list.size() - n > n;
    }

    private List<String> createEmptyList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add("");
        }
        return arrayList;
    }
}

