/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.activity;

import com.baselet.control.enums.Direction;
import com.baselet.diagram.DiagramHandler;
import com.baselet.element.old.activity.Row;
import java.awt.Graphics2D;
import java.awt.Point;

public abstract class Element {
    private Graphics2D graphics;
    private int leftwidth;
    private int rightwidth;
    private int height;
    private int padding;
    private Point cord;
    private String id;
    private Row row;
    private DiagramHandler handler;
    private float zoom;
    private boolean terminated;

    public Element(DiagramHandler handler, Graphics2D g, int padding, String id) {
        this.handler = handler;
        this.graphics = g;
        this.padding = padding;
        this.id = id;
        this.leftwidth = 0;
        this.rightwidth = 0;
        this.height = 0;
        this.cord = new Point(0, 0);
        this.zoom = handler.getZoomFactor();
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public Row getRow() {
        return this.row;
    }

    public final void setTerminated() {
        this.terminated = true;
    }

    public final void setNotTerminated() {
        this.terminated = false;
    }

    public Point getPosition() {
        return this.cord;
    }

    public void setY(int y) {
        this.cord.y = y;
    }

    public void setX(int x) {
        this.cord.x = x;
    }

    protected Graphics2D getGraphics() {
        return this.graphics;
    }

    public String getId() {
        return this.id;
    }

    protected int getHeight() {
        return this.height;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected int getLeftWidth() {
        return this.leftwidth;
    }

    protected int getRightWidth() {
        return this.rightwidth;
    }

    protected int getWidth() {
        return this.getLeftWidth() + this.getRightWidth();
    }

    protected void setWidth(int width) {
        this.setLeftWidth(width / 2);
        this.setRightWidth(width - width / 2);
    }

    protected void setLeftWidth(int width) {
        this.leftwidth = width;
    }

    protected void setRightWidth(int width) {
        this.rightwidth = width;
    }

    protected int getPadding() {
        return this.padding;
    }

    public abstract void paint();

    public boolean connectIn() {
        return true;
    }

    public boolean connectOut_overrideable() {
        return true;
    }

    public final boolean connectOut() {
        return this.connectOut_overrideable() && !this.terminated;
    }

    public boolean arrowOut() {
        return true;
    }

    public boolean arrowIn() {
        return true;
    }

    public void printData(String prefix) {
        System.out.println(String.valueOf(prefix) + this.getClass().getSimpleName());
    }

    protected Point getNonStdConnectIn(Direction dir) {
        return this.getConnect(dir);
    }

    protected Point getNonStdConnectOut(Direction dir) {
        return this.getConnect(dir);
    }

    protected Point getConnect(Direction dir) {
        Point c = (Point)this.cord.clone();
        if (dir == Direction.UP) {
            c.y -= this.getHeight() / 2;
        } else if (dir == Direction.DOWN) {
            c.y += this.getHeight() - this.getHeight() / 2;
        } else if (dir == Direction.LEFT) {
            c.x -= this.getLeftWidth();
        } else if (dir == Direction.RIGHT) {
            c.x += this.getRightWidth();
        }
        return c;
    }

    protected DiagramHandler getHandler() {
        return this.handler;
    }

    protected float getZoom() {
        return this.zoom;
    }
}

