/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.plugin.gui;

import com.baselet.control.CanCloseProgram;
import com.baselet.control.config.Config;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.custom.CustomElementHandler;
import com.baselet.gui.BaseGUI;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.pane.OwnSyntaxPane;
import com.baselet.plugin.gui.Contributor;
import com.baselet.plugin.gui.Editor;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;

public class EclipseGUI
extends BaseGUI {
    private static final Logger log = Logger.getLogger(EclipseGUI.class);
    private Editor editor;
    private final HashMap<DiagramHandler, Editor> diagrams = new HashMap();
    private Contributor contributor;

    public EclipseGUI(CanCloseProgram main) {
        super(main);
    }

    @Override
    public void close(DiagramHandler diagram) {
    }

    @Override
    public void closeWindow() {
        this.main.closeProgram();
    }

    @Override
    public void diagramSelected(DiagramHandler handler) {
        DrawPanel currentDiagram = CurrentGui.getInstance().getGui().getCurrentDiagram();
        if (currentDiagram == null) {
            return;
        }
        boolean enable = handler != null && !currentDiagram.getGridElements().isEmpty();
        this.contributor.setExportAsEnabled(enable);
    }

    @Override
    public void enablePasteMenuEntry() {
        if (this.contributor != null) {
            this.contributor.setPaste(true);
        }
    }

    @Override
    public CustomElementHandler getCurrentCustomHandler() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getCustomElementHandler();
    }

    @Override
    public DrawPanel getCurrentDiagram() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getDiagram();
    }

    @Override
    public int getMainSplitPosition() {
        return Config.getInstance().getMain_split_position();
    }

    @Override
    public int getRightSplitPosition() {
        return Config.getInstance().getRight_split_position();
    }

    @Override
    public int getMailSplitPosition() {
        return Config.getInstance().getMail_split_position();
    }

    @Override
    public String getSelectedPalette() {
        if (this.editor != null) {
            return this.editor.getSelectedPaletteName();
        }
        return null;
    }

    @Override
    protected void init() {
    }

    @Override
    public void open(DiagramHandler diagram) {
        if (this.editor != null) {
            this.editor.open(diagram);
        }
    }

    @Override
    public void jumpTo(DiagramHandler diagram) {
    }

    @Override
    public void showPalette(String palette) {
        super.showPalette(palette);
        if (this.editor != null) {
            this.editor.showPalette(palette);
        }
    }

    @Override
    public void setCustomElementChanged(CustomElementHandler handler, boolean changed) {
    }

    @Override
    public void setCustomElementSelected(boolean selected) {
        if (this.editor != null && this.contributor != null) {
            this.contributor.setCustomElementSelected(selected);
        }
    }

    @Override
    public void setCustomPanelEnabled(boolean enable) {
        if (this.editor != null) {
            this.editor.setCustomPanelEnabled(enable);
            if (this.contributor != null) {
                this.contributor.setCustomPanelEnabled(enable);
            }
        }
    }

    @Override
    public void setMailPanelEnabled(boolean enable) {
        if (this.editor != null) {
            this.editor.setMailPanelEnabled(enable);
        }
    }

    @Override
    public boolean isMailPanelVisible() {
        return this.editor.isMailPanelVisible();
    }

    @Override
    public void updateDiagramName(DiagramHandler diagram, String name) {
        Editor editor = this.diagrams.get(diagram);
        if (editor != null) {
            editor.diagramNameChanged();
        }
    }

    @Override
    public void setDiagramChanged(DiagramHandler diagram, boolean changed) {
        Editor editor = this.diagrams.get(diagram);
        if (editor != null) {
            editor.dirtyChanged();
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.editor != null) {
            this.editor.setCursor(cursor);
        }
    }

    public void registerEditorForDiagramHandler(Editor editor, DiagramHandler handler) {
        this.diagrams.put(handler, editor);
    }

    public void setCurrentDiagramHandler(DiagramHandler handler) {
        CurrentDiagram.getInstance().setCurrentDiagramHandler(handler);
    }

    public void setCurrentEditor(Editor editor) {
        this.editor = editor;
    }

    public void editorRemoved(Editor editor) {
        Config.getInstance().setMain_split_position(editor.getMainSplitLocation());
        Config.getInstance().setRight_split_position(editor.getRightSplitLocation());
        Config.getInstance().setLastUsedPalette(this.getSelectedPalette());
        this.diagrams.remove(editor.getDiagram().getHandler());
        if (((Object)((Object)editor)).equals((Object)this.editor)) {
            this.editor = null;
        }
    }

    @Override
    public OwnSyntaxPane getPropertyPane() {
        if (this.editor != null) {
            return this.editor.getPropertyPane();
        }
        return null;
    }

    public void panelDoAction(Pane pane, Contributor.ActionName actionName) {
        JTextComponent textpane = null;
        if (pane == Pane.PROPERTY) {
            textpane = this.editor.getPropertyPane().getTextComponent();
        } else if (pane == Pane.CUSTOMCODE) {
            textpane = this.editor.getCustomPane();
        }
        if (textpane != null) {
            if (actionName == Contributor.ActionName.COPY) {
                textpane.copy();
            } else if (actionName == Contributor.ActionName.CUT) {
                textpane.cut();
                int pos = textpane.getSelectionStart();
                textpane.setCaretPosition(pos);
            } else if (actionName == Contributor.ActionName.PASTE) {
                try {
                    Transferable cont = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                    if (cont != null) {
                        int pos = ((String)cont.getTransferData(DataFlavor.stringFlavor)).length() + textpane.getSelectionStart();
                        textpane.paste();
                        textpane.setCaretPosition(pos);
                    }
                }
                catch (Exception e) {
                    log.error(null, (Throwable)e);
                }
            } else if (actionName == Contributor.ActionName.SELECTALL) {
                textpane.selectAll();
            }
        }
    }

    @Override
    public void requestFocus() {
        if (this.editor != null) {
            this.editor.requestFocus();
        }
    }

    public void setContributor(Contributor contributor) {
        this.contributor = contributor;
    }

    @Override
    public void elementsSelected(Collection<GridElement> selectedElements) {
        super.elementsSelected(selectedElements);
        if (this.contributor != null) {
            this.contributor.setElementsSelected(selectedElements);
        }
    }

    public void setPaneFocused(final Pane pane) {
        if (this.contributor != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    EclipseGUI.this.contributor.setGlobalActionHandlers(pane);
                }
            });
        }
    }

    @Override
    public void setValueOfZoomDisplay(int i) {
        if (this.contributor != null) {
            this.contributor.updateZoomMenuRadioButton(i);
        }
    }

    @Override
    public void afterSaving() {
        super.afterSaving();
        EclipseGUI.refreshWorkspace();
    }

    @Override
    public void focusPropertyPane() {
        this.editor.focusPropertyPane();
    }

    @Override
    public Frame getMainFrame() {
        return this.editor.getMainFrame();
    }

    public static void refreshWorkspace() {
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            myWorkspaceRoot.refreshLocal(2, null);
        }
        catch (CoreException e) {
            log.error((Object)"Error at refreshing the workspace", (Throwable)e);
        }
    }

    public static enum Pane {
        PROPERTY,
        CUSTOMCODE,
        DIAGRAM;

    }
}

