/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.ListIterator;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import sun.management.GarbageCollectionNotifInfoCompositeData;
import sun.management.GcInfoBuilder;
import sun.management.MemoryManagerImpl;
import sun.management.Util;

class GarbageCollectorImpl
extends MemoryManagerImpl
implements GarbageCollectorMXBean {
    private String[] poolNames = null;
    private GcInfoBuilder gcInfoBuilder;
    private static final String notifName = "javax.management.Notification";
    private static final String[] gcNotifTypes = new String[]{"com.sun.management.gc.notification"};
    private MBeanNotificationInfo[] notifInfo = null;
    private static long seqNumber = 0L;

    GarbageCollectorImpl(String name) {
        super(name);
    }

    @Override
    public native long getCollectionCount();

    @Override
    public native long getCollectionTime();

    synchronized String[] getAllPoolNames() {
        if (this.poolNames == null) {
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            this.poolNames = new String[pools.size()];
            int i = 0;
            ListIterator<MemoryPoolMXBean> iter = pools.listIterator();
            while (iter.hasNext()) {
                MemoryPoolMXBean p = iter.next();
                this.poolNames[i] = p.getName();
                ++i;
            }
        }
        return this.poolNames;
    }

    private synchronized GcInfoBuilder getGcInfoBuilder() {
        if (this.gcInfoBuilder == null) {
            this.gcInfoBuilder = new GcInfoBuilder(this, this.getAllPoolNames());
        }
        return this.gcInfoBuilder;
    }

    @Override
    public GcInfo getLastGcInfo() {
        GcInfo info = this.getGcInfoBuilder().getLastGcInfo();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        GarbageCollectorImpl garbageCollectorImpl = this;
        synchronized (garbageCollectorImpl) {
            if (this.notifInfo == null) {
                this.notifInfo = new MBeanNotificationInfo[1];
                this.notifInfo[0] = new MBeanNotificationInfo(gcNotifTypes, notifName, "GC Notification");
            }
        }
        return this.notifInfo;
    }

    private static long getNextSeqNumber() {
        return ++seqNumber;
    }

    void createGCNotification(long timestamp, String gcName, String gcAction, String gcCause, GcInfo gcInfo) {
        if (!this.hasListeners()) {
            return;
        }
        Notification notif = new Notification("com.sun.management.gc.notification", this.getObjectName(), GarbageCollectorImpl.getNextSeqNumber(), timestamp, gcName);
        GarbageCollectionNotificationInfo info = new GarbageCollectionNotificationInfo(gcName, gcAction, gcCause, gcInfo);
        CompositeData cd = GarbageCollectionNotifInfoCompositeData.toCompositeData(info);
        notif.setUserData(cd);
        this.sendNotification(notif);
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        boolean before = this.hasListeners();
        super.addNotificationListener(listener, filter, handback);
        boolean after = this.hasListeners();
        if (!before && after) {
            this.setNotificationEnabled(this, true);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        boolean before = this.hasListeners();
        super.removeNotificationListener(listener);
        boolean after = this.hasListeners();
        if (before && !after) {
            this.setNotificationEnabled(this, false);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        boolean before = this.hasListeners();
        super.removeNotificationListener(listener, filter, handback);
        boolean after = this.hasListeners();
        if (before && !after) {
            this.setNotificationEnabled(this, false);
        }
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=GarbageCollector", this.getName());
    }

    native void setNotificationEnabled(GarbageCollectorMXBean var1, boolean var2);
}

