/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import sun.management.MemoryNotifInfoCompositeData;
import sun.management.NotificationEmitterSupport;
import sun.management.Util;
import sun.management.VMManagement;
import sun.misc.VM;

class MemoryImpl
extends NotificationEmitterSupport
implements MemoryMXBean {
    private final VMManagement jvm;
    private static MemoryPoolMXBean[] pools = null;
    private static MemoryManagerMXBean[] mgrs = null;
    private static final String notifName = "javax.management.Notification";
    private static final String[] notifTypes = new String[]{"java.management.memory.threshold.exceeded", "java.management.memory.collection.threshold.exceeded"};
    private static final String[] notifMsgs = new String[]{"Memory usage exceeds usage threshold", "Memory usage exceeds collection usage threshold"};
    private MBeanNotificationInfo[] notifInfo = null;
    private static long seqNumber = 0L;

    MemoryImpl(VMManagement vm) {
        this.jvm = vm;
    }

    @Override
    public int getObjectPendingFinalizationCount() {
        return VM.getFinalRefCount();
    }

    @Override
    public void gc() {
        Runtime.getRuntime().gc();
    }

    @Override
    public MemoryUsage getHeapMemoryUsage() {
        return this.getMemoryUsage0(true);
    }

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        return this.getMemoryUsage0(false);
    }

    @Override
    public boolean isVerbose() {
        return this.jvm.getVerboseGC();
    }

    @Override
    public void setVerbose(boolean value) {
        Util.checkControlAccess();
        this.setVerboseGC(value);
    }

    static synchronized MemoryPoolMXBean[] getMemoryPools() {
        if (pools == null) {
            pools = MemoryImpl.getMemoryPools0();
        }
        return pools;
    }

    static synchronized MemoryManagerMXBean[] getMemoryManagers() {
        if (mgrs == null) {
            mgrs = MemoryImpl.getMemoryManagers0();
        }
        return mgrs;
    }

    private static native MemoryPoolMXBean[] getMemoryPools0();

    private static native MemoryManagerMXBean[] getMemoryManagers0();

    private native MemoryUsage getMemoryUsage0(boolean var1);

    private native void setVerboseGC(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MemoryImpl memoryImpl = this;
        synchronized (memoryImpl) {
            if (this.notifInfo == null) {
                this.notifInfo = new MBeanNotificationInfo[1];
                this.notifInfo[0] = new MBeanNotificationInfo(notifTypes, notifName, "Memory Notification");
            }
        }
        return this.notifInfo;
    }

    private static String getNotifMsg(String notifType) {
        for (int i = 0; i < notifTypes.length; ++i) {
            if (notifType != notifTypes[i]) continue;
            return notifMsgs[i];
        }
        return "Unknown message";
    }

    private static long getNextSeqNumber() {
        return ++seqNumber;
    }

    static void createNotification(String notifType, String poolName, MemoryUsage usage, long count) {
        MemoryImpl mbean = (MemoryImpl)ManagementFactory.getMemoryMXBean();
        if (!mbean.hasListeners()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        String msg = MemoryImpl.getNotifMsg(notifType);
        Notification notif = new Notification(notifType, mbean.getObjectName(), MemoryImpl.getNextSeqNumber(), timestamp, msg);
        MemoryNotificationInfo info = new MemoryNotificationInfo(poolName, usage, count);
        CompositeData cd = MemoryNotifInfoCompositeData.toCompositeData(info);
        notif.setUserData(cd);
        mbean.sendNotification(notif);
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Memory");
    }
}

