/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;

public abstract class StatusDisplayer {
    private static StatusDisplayer INSTANCE = null;

    protected StatusDisplayer() {
    }

    public static synchronized StatusDisplayer getDefault() {
        if (INSTANCE == null && (INSTANCE = (StatusDisplayer)Lookup.getDefault().lookup(StatusDisplayer.class)) == null) {
            INSTANCE = new Trivial();
        }
        return INSTANCE;
    }

    public abstract String getStatusText();

    public abstract void setStatusText(String var1);

    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    private static final class Trivial
    extends StatusDisplayer {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private String text = "";

        private Trivial() {
        }

        public synchronized String getStatusText() {
            return this.text;
        }

        public synchronized void setStatusText(String string) {
            if (string.equals(this.text)) {
                return;
            }
            this.text = string;
            if (string.length() > 0) {
                System.err.println("(" + string + ")");
            }
            this.cs.fireChange();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }
    }
}

