/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.gui.ThemeManager;
import esmska.utils.AlphanumComparator;
import java.awt.Dimension;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class Config
implements Serializable {
    private static GlobalConfig globalConfig = GlobalConfig.getInstance();
    private static Config instance = new Config();
    private static boolean loaded = false;
    private static final String LATEST_VERSION = "1.8";
    private static final Logger logger = Logger.getLogger(Config.class.getName());
    private String version = "";
    private Dimension mainDimension;
    private Integer horizontalSplitPaneLocation;
    private Integer verticalSplitPaneLocation;
    private ThemeManager.LAF lookAndFeel = ThemeManager.LAF.SUBSTANCE;
    private String lafJGoodiesTheme = "Experience Blue";
    private String lafSubstanceSkin = "Business Black Steel";
    private boolean removeAccents = true;
    private boolean announceProgramUpdates = GlobalConfig.access$000(globalConfig);
    private boolean announceUnstableUpdates = false;
    private boolean startCentered = false;
    private boolean toolbarVisible = true;
    private String countryPrefix = "";
    private boolean useProxy = false;
    private boolean sameProxy = true;
    private String httpProxy = "";
    private String httpsProxy = "";
    private String socksProxy = "";
    private boolean notificationIconVisible = false;
    private boolean showTips = true;
    private boolean reducedHistory = false;
    private int reducedHistoryCount = 30;
    private boolean startMinimized = false;
    private boolean showAdvancedSettings = false;
    private boolean debugMode = false;
    private boolean showAdvancedControls = false;
    private String[] favoriteGateways = new String[0];
    private String[] hiddenGateways = new String[0];
    private String uuid = null;
    private int uuidMonth = -1;
    private Date lastStatsSent = null;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this){

        @Override
        public void firePropertyChange(PropertyChangeEvent evt) {
            if (ObjectUtils.equals(evt.getOldValue(), evt.getNewValue())) {
                return;
            }
            Object newValue = evt.getNewValue();
            Object oldValue = evt.getOldValue();
            if (oldValue instanceof Object[]) {
                oldValue = Arrays.toString((Object[])oldValue);
                newValue = Arrays.toString((Object[])newValue);
            }
            logger.log(Level.CONFIG, "Config changed - property: {0}, old: {1}, new: {2}", new Object[]{evt.getPropertyName(), oldValue, newValue});
            super.firePropertyChange(evt);
        }
    };

    public static Config getInstance() {
        if (!loaded && !Beans.isDesignTime()) {
            throw new IllegalStateException("Config not yet loaded!");
        }
        return instance;
    }

    public static void setSharedInstance(Config config) {
        loaded = true;
        instance = config;
    }

    public static String getLatestVersion() {
        return LATEST_VERSION;
    }

    public static boolean isStableVersion() {
        return !LATEST_VERSION.contains("beta") && !LATEST_VERSION.contains(".99");
    }

    public static int compareProgramVersions(String version1, String version2) {
        if (version1 == null) {
            return version2 == null ? 0 : -1;
        }
        String v1 = version1;
        String v2 = version2;
        boolean beta1 = version1.toLowerCase().contains("beta");
        boolean beta2 = version2.toLowerCase().contains("beta");
        if (beta1) {
            v1 = version1.substring(0, version1.toLowerCase().indexOf("beta")).trim();
        }
        if (beta2) {
            v2 = version2.substring(0, version2.toLowerCase().indexOf("beta")).trim();
        }
        AlphanumComparator comparator = new AlphanumComparator();
        if (beta1 && beta2) {
            return comparator.compare(v1, v2) == 0 ? version1.compareTo(version2) : comparator.compare(v1, v2);
        }
        if (beta1) {
            return comparator.compare(v1, v2) == 0 ? -1 : comparator.compare(v1, v2);
        }
        if (beta2) {
            return comparator.compare(v1, v2) == 0 ? 1 : comparator.compare(v1, v2);
        }
        return comparator.compare(v1, v2);
    }

    public boolean isFirstRun() {
        return StringUtils.isEmpty(this.version);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Dimension getMainDimension() {
        return this.mainDimension;
    }

    public Integer getHorizontalSplitPaneLocation() {
        return this.horizontalSplitPaneLocation;
    }

    public Integer getVerticalSplitPaneLocation() {
        return this.verticalSplitPaneLocation;
    }

    public ThemeManager.LAF getLookAndFeel() {
        return this.lookAndFeel;
    }

    public String getLafJGoodiesTheme() {
        return this.lafJGoodiesTheme;
    }

    public String getLafSubstanceSkin() {
        return this.lafSubstanceSkin;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRemoveAccents() {
        return this.removeAccents;
    }

    public boolean isShowAdvancedControls() {
        return this.showAdvancedControls;
    }

    public boolean isAnnounceProgramUpdates() {
        return this.announceProgramUpdates;
    }

    public boolean isAnnounceUnstableUpdates() {
        return this.announceUnstableUpdates;
    }

    public boolean isStartCentered() {
        return this.startCentered;
    }

    public boolean isToolbarVisible() {
        return this.toolbarVisible;
    }

    public String getCountryPrefix() {
        return this.countryPrefix;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public boolean isSameProxy() {
        return this.sameProxy;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public String getSocksProxy() {
        return this.socksProxy;
    }

    public boolean isNotificationIconVisible() {
        return this.notificationIconVisible;
    }

    public boolean isShowTips() {
        return this.showTips;
    }

    public boolean isReducedHistory() {
        return this.reducedHistory;
    }

    public int getReducedHistoryCount() {
        return this.reducedHistoryCount;
    }

    public boolean isStartMinimized() {
        return this.startMinimized;
    }

    public boolean isShowAdvancedSettings() {
        return this.showAdvancedSettings;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public String[] getFavoriteGateways() {
        return this.favoriteGateways;
    }

    public String[] getHiddenGateways() {
        return this.hiddenGateways;
    }

    public String getUUID() {
        return this.uuid;
    }

    public int getUUIDMonth() {
        return this.uuidMonth;
    }

    public Date getLastStatsSent() {
        return this.lastStatsSent;
    }

    public void setMainDimension(Dimension mainDimension) {
        Dimension oldMainDimension = this.mainDimension;
        this.mainDimension = mainDimension;
        this.changeSupport.firePropertyChange("mainDimension", oldMainDimension, mainDimension);
    }

    public void setHorizontalSplitPaneLocation(Integer horizontalSplitPaneLocation) {
        Integer oldHorizontalSplitPaneLocation = this.horizontalSplitPaneLocation;
        this.horizontalSplitPaneLocation = horizontalSplitPaneLocation;
        this.changeSupport.firePropertyChange("horizontalSplitPaneLocation", oldHorizontalSplitPaneLocation, horizontalSplitPaneLocation);
    }

    public void setVerticalSplitPaneLocation(Integer verticalSplitPaneLocation) {
        Integer oldVerticalSplitPaneLocation = this.verticalSplitPaneLocation;
        this.verticalSplitPaneLocation = verticalSplitPaneLocation;
        this.changeSupport.firePropertyChange("verticalSplitPaneLocation", oldVerticalSplitPaneLocation, verticalSplitPaneLocation);
    }

    public void setLookAndFeel(ThemeManager.LAF lookAndFeel) {
        if (lookAndFeel == null) {
            throw new IllegalArgumentException("lookAndFeel may not be null");
        }
        ThemeManager.LAF oldLookAndFeel = this.lookAndFeel;
        this.lookAndFeel = lookAndFeel;
        this.changeSupport.firePropertyChange("lookAndFeel", (Object)oldLookAndFeel, (Object)lookAndFeel);
    }

    public void setLafJGoodiesTheme(String lafJGoodiesTheme) {
        String oldLafJGoodiesTheme = this.lafJGoodiesTheme;
        this.lafJGoodiesTheme = lafJGoodiesTheme;
        this.changeSupport.firePropertyChange("lafJGoodiesTheme", oldLafJGoodiesTheme, lafJGoodiesTheme);
    }

    public void setLafSubstanceSkin(String lafSubstanceSkin) {
        String oldLafSubstanceSkin = this.lafSubstanceSkin;
        this.lafSubstanceSkin = lafSubstanceSkin;
        this.changeSupport.firePropertyChange("lafSubstanceSkin", oldLafSubstanceSkin, lafSubstanceSkin);
    }

    public void setVersion(String version) {
        String oldVersion = this.version;
        this.version = version;
        this.changeSupport.firePropertyChange("version", oldVersion, version);
    }

    public void setRemoveAccents(boolean removeAccents) {
        boolean oldRemoveAccents = this.removeAccents;
        this.removeAccents = removeAccents;
        this.changeSupport.firePropertyChange("removeAccents", oldRemoveAccents, removeAccents);
    }

    public void setAnnounceProgramUpdates(boolean announceProgramUpdates) {
        boolean old = this.announceProgramUpdates;
        this.announceProgramUpdates = announceProgramUpdates;
        this.changeSupport.firePropertyChange("announceProgramUpdates", old, announceProgramUpdates);
    }

    public void setAnnounceUnstableUpdates(boolean announceUnstableUpdates) {
        if (!Config.isStableVersion()) {
            announceUnstableUpdates = true;
        }
        boolean old = this.announceUnstableUpdates;
        this.announceUnstableUpdates = announceUnstableUpdates;
        this.changeSupport.firePropertyChange("announceUnstableUpdates", old, announceUnstableUpdates);
    }

    public void setStartCentered(boolean startCentered) {
        boolean old = this.startCentered;
        this.startCentered = startCentered;
        this.changeSupport.firePropertyChange("startCentered", old, startCentered);
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        boolean old = this.toolbarVisible;
        this.toolbarVisible = toolbarVisible;
        this.changeSupport.firePropertyChange("toolbarVisible", old, toolbarVisible);
    }

    public void setCountryPrefix(String countryPrefix) {
        String old = this.countryPrefix;
        this.countryPrefix = countryPrefix;
        this.changeSupport.firePropertyChange("countryPrefix", old, countryPrefix);
    }

    public void setUseProxy(boolean useProxy) {
        boolean old = this.useProxy;
        this.useProxy = useProxy;
        this.changeSupport.firePropertyChange("useProxy", old, useProxy);
    }

    public void setSameProxy(boolean sameProxy) {
        boolean old = this.sameProxy;
        this.sameProxy = sameProxy;
        this.changeSupport.firePropertyChange("sameProxy", old, sameProxy);
    }

    public void setHttpProxy(String httpProxy) {
        String old = this.httpProxy;
        this.httpProxy = httpProxy;
        this.changeSupport.firePropertyChange("httpProxy", old, httpProxy);
    }

    public void setHttpsProxy(String httpsProxy) {
        String old = this.httpsProxy;
        this.httpsProxy = httpsProxy;
        this.changeSupport.firePropertyChange("httpsProxy", old, httpsProxy);
    }

    public void setSocksProxy(String socksProxy) {
        String old = this.socksProxy;
        this.socksProxy = socksProxy;
        this.changeSupport.firePropertyChange("socksProxy", old, socksProxy);
    }

    public void setNotificationIconVisible(boolean notificationIconVisible) {
        boolean old = this.notificationIconVisible;
        this.notificationIconVisible = notificationIconVisible;
        this.changeSupport.firePropertyChange("notificationIconVisible", old, notificationIconVisible);
    }

    public void setShowTips(boolean showTips) {
        boolean old = this.showTips;
        this.showTips = showTips;
        this.changeSupport.firePropertyChange("showTips", old, showTips);
    }

    public void setReducedHistory(boolean reducedHistory) {
        boolean oldReducedHistory = this.reducedHistory;
        this.reducedHistory = reducedHistory;
        this.changeSupport.firePropertyChange("reducedHistory", oldReducedHistory, reducedHistory);
    }

    public void setReducedHistoryCount(int reducedHistoryCount) {
        int oldReducedHistoryCount = this.reducedHistoryCount;
        this.reducedHistoryCount = reducedHistoryCount;
        this.changeSupport.firePropertyChange("reducedHistoryCount", oldReducedHistoryCount, reducedHistoryCount);
    }

    public void setStartMinimized(boolean startMinimized) {
        boolean old = this.startMinimized;
        this.startMinimized = startMinimized;
        this.changeSupport.firePropertyChange("startMinimized", old, startMinimized);
    }

    public void setShowAdvancedSettings(boolean showAdvancedSettings) {
        boolean old = this.showAdvancedSettings;
        this.showAdvancedSettings = showAdvancedSettings;
        this.changeSupport.firePropertyChange("showAdvancedSettings", old, showAdvancedSettings);
    }

    public void setDebugMode(boolean debugMode) {
        boolean old = this.debugMode;
        this.debugMode = debugMode;
        this.changeSupport.firePropertyChange("debugMode", old, debugMode);
    }

    public void setShowAdvancedControls(boolean showAdvancedControls) {
        boolean old = this.showAdvancedControls;
        this.showAdvancedControls = showAdvancedControls;
        this.changeSupport.firePropertyChange("showAdvancedControls", old, showAdvancedControls);
    }

    public void setFavoriteGateways(String[] favoriteGateways) {
        String[] old = this.favoriteGateways;
        this.favoriteGateways = favoriteGateways;
        this.changeSupport.firePropertyChange("favoriteGateways", old, favoriteGateways);
    }

    public void setHiddenGateways(String[] hiddenGateways) {
        String[] old = this.hiddenGateways;
        this.hiddenGateways = hiddenGateways;
        this.changeSupport.firePropertyChange("hiddenGateways", old, hiddenGateways);
    }

    public void setUUID(String uuid) {
        String old = this.uuid;
        this.uuid = uuid;
        this.changeSupport.firePropertyChange("uuid", old, uuid);
    }

    public void setUUIDMonth(int uuidMonth) {
        int old = this.uuidMonth;
        this.uuidMonth = uuidMonth;
        this.changeSupport.firePropertyChange("uuidMonth", old, uuidMonth);
    }

    public void setLastStatsSent(Date lastStatsSent) {
        Date old = this.lastStatsSent;
        this.lastStatsSent = lastStatsSent;
        this.changeSupport.firePropertyChange("lastStatsSent", old, lastStatsSent);
    }

    public static class GlobalConfig {
        private static final GlobalConfig instance = new GlobalConfig();
        private boolean announceProgramUpdates = true;

        private GlobalConfig() {
        }

        public static GlobalConfig getInstance() {
            return instance;
        }

        public void setAnnounceProgramUpdates(boolean announceProgramUpdates) {
            this.announceProgramUpdates = announceProgramUpdates;
        }

        static /* synthetic */ boolean access$000(GlobalConfig x0) {
            return x0.announceProgramUpdates;
        }
    }
}

