/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.scilab.forge.jlatexmath.Box;

public class RotateBox
extends Box {
    public static final int BL = 0;
    public static final int BC = 1;
    public static final int BR = 2;
    public static final int TL = 3;
    public static final int TC = 4;
    public static final int TR = 5;
    public static final int BBL = 6;
    public static final int BBR = 7;
    public static final int BBC = 8;
    public static final int CL = 9;
    public static final int CC = 10;
    public static final int CR = 11;
    protected double angle = 0.0;
    private Box box;
    private float xmax;
    private float xmin;
    private float ymax;
    private float ymin;
    private int option;
    private float shiftX;
    private float shiftY;

    public RotateBox(Box box, double d, float f, float f2) {
        this.box = box;
        this.angle = d * Math.PI / 180.0;
        this.height = box.height;
        this.depth = box.depth;
        this.width = box.width;
        double d2 = Math.sin(this.angle);
        double d3 = Math.cos(this.angle);
        this.shiftX = (float)((double)f * (1.0 - d3) + (double)f2 * d2);
        this.shiftY = (float)((double)f2 * (1.0 - d3) - (double)f * d2);
        this.xmax = (float)Math.max((double)(-this.height) * d2, Math.max((double)this.depth * d2, Math.max((double)this.width * d3 + (double)this.depth * d2, (double)this.width * d3 - (double)this.height * d2))) + this.shiftX;
        this.xmin = (float)Math.min((double)(-this.height) * d2, Math.min((double)this.depth * d2, Math.min((double)this.width * d3 + (double)this.depth * d2, (double)this.width * d3 - (double)this.height * d2))) + this.shiftX;
        this.ymax = (float)Math.max((double)this.height * d3, Math.max((double)(-this.depth) * d3, Math.max((double)this.width * d2 - (double)this.depth * d3, (double)this.width * d2 + (double)this.height * d3)));
        this.ymin = (float)Math.min((double)this.height * d3, Math.min((double)(-this.depth) * d3, Math.min((double)this.width * d2 - (double)this.depth * d3, (double)this.width * d2 + (double)this.height * d3)));
        this.width = this.xmax - this.xmin;
        this.height = this.ymax + this.shiftY;
        this.depth = -this.ymin - this.shiftY;
    }

    public RotateBox(Box box, double d, Point2D.Float float_) {
        this(box, d, float_.x, float_.y);
    }

    public RotateBox(Box box, double d, int n) {
        this(box, d, RotateBox.calculateShift(box, n));
    }

    public static int getOrigin(String string) {
        if (string == null || string.length() == 0) {
            return 6;
        }
        if (string.length() == 1) {
            string = string + "c";
        }
        if (string.equals("bl") || string.equals("lb")) {
            return 0;
        }
        if (string.equals("bc") || string.equals("cb")) {
            return 1;
        }
        if (string.equals("br") || string.equals("rb")) {
            return 2;
        }
        if (string.equals("cl") || string.equals("lc")) {
            return 9;
        }
        if (string.equals("cc")) {
            return 10;
        }
        if (string.equals("cr") || string.equals("cr")) {
            return 11;
        }
        if (string.equals("tl") || string.equals("lt")) {
            return 3;
        }
        if (string.equals("tc") || string.equals("ct")) {
            return 4;
        }
        if (string.equals("tr") || string.equals("rt")) {
            return 5;
        }
        if (string.equals("Bl") || string.equals("lB")) {
            return 6;
        }
        if (string.equals("Bc") || string.equals("cB")) {
            return 8;
        }
        if (string.equals("Br") || string.equals("rB")) {
            return 7;
        }
        return 6;
    }

    private static Point2D.Float calculateShift(Box box, int n) {
        Point2D.Float float_ = new Point2D.Float(0.0f, -box.depth);
        switch (n) {
            case 0: {
                float_.x = 0.0f;
                float_.y = -box.depth;
                break;
            }
            case 2: {
                float_.x = box.width;
                float_.y = -box.depth;
                break;
            }
            case 1: {
                float_.x = box.width / 2.0f;
                float_.y = -box.depth;
                break;
            }
            case 3: {
                float_.x = 0.0f;
                float_.y = box.height;
                break;
            }
            case 5: {
                float_.x = box.width;
                float_.y = box.height;
                break;
            }
            case 4: {
                float_.x = box.width / 2.0f;
                float_.y = box.height;
                break;
            }
            case 6: {
                float_.x = 0.0f;
                float_.y = 0.0f;
                break;
            }
            case 7: {
                float_.x = box.width;
                float_.y = 0.0f;
                break;
            }
            case 8: {
                float_.x = box.width / 2.0f;
                float_.y = 0.0f;
                break;
            }
            case 9: {
                float_.x = 0.0f;
                float_.y = (box.height - box.depth) / 2.0f;
                break;
            }
            case 11: {
                float_.x = box.width;
                float_.y = (box.height - box.depth) / 2.0f;
                break;
            }
            case 10: {
                float_.x = box.width / 2.0f;
                float_.y = (box.height - box.depth) / 2.0f;
                break;
            }
        }
        return float_;
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        this.drawDebug(graphics2D, f, f2);
        this.box.drawDebug(graphics2D, f, f2, true);
        graphics2D.rotate(-this.angle, f += this.shiftX - this.xmin, f2 -= this.shiftY);
        this.box.draw(graphics2D, f, f2);
        this.box.drawDebug(graphics2D, f, f2, true);
        graphics2D.rotate(this.angle, f, f2);
    }

    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

