/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.nativeplatform.toolchain.internal.OptionsFileArgsWriter;
import org.gradle.platform.base.internal.toolchain.ArgWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GccOptionsFileArgsWriter
extends OptionsFileArgsWriter {
    private static final List<String> CLI_ONLY_ARGS = Arrays.asList("-m32", "-m64");

    public GccOptionsFileArgsWriter(File tempDir) {
        super((Transformer<ArgWriter, PrintWriter>)ArgWriter.unixStyleFactory(), tempDir);
    }

    @Override
    public List<String> transformArgs(List<String> originalArgs, File tempDir) {
        List<String> commandLineOnlyArgs = this.getCommandLineOnlyArgs(originalArgs);
        ArrayList finalArgs = Lists.newArrayList();
        finalArgs.addAll(super.transformArgs(originalArgs, tempDir));
        finalArgs.addAll(commandLineOnlyArgs);
        return finalArgs;
    }

    private List<String> getCommandLineOnlyArgs(List<String> allArgs) {
        ArrayList<String> commandLineOnlyArgs = new ArrayList<String>(allArgs);
        commandLineOnlyArgs.retainAll(CLI_ONLY_ARGS);
        return commandLineOnlyArgs;
    }
}

