/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.gradle.api.specs.Spec;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.BuildScriptData;
import org.gradle.groovy.scripts.internal.FilteringScriptTransformer;
import org.gradle.groovy.scripts.internal.FixMainScriptTransformer;
import org.gradle.groovy.scripts.internal.ImperativeStatementDetectingTransformer;
import org.gradle.groovy.scripts.internal.ScriptSourceTransformer;
import org.gradle.groovy.scripts.internal.StatementLabelsScriptTransformer;
import org.gradle.groovy.scripts.internal.TaskDefinitionScriptTransformer;
import org.gradle.internal.Factory;
import org.gradle.model.dsl.internal.transform.ModelBlockTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildScriptTransformer
implements Transformer,
Factory<BuildScriptData> {
    private final Spec<? super Statement> filter;
    private final ScriptSource scriptSource;
    private final ImperativeStatementDetectingTransformer imperativeStatementDetectingTransformer = new ImperativeStatementDetectingTransformer();

    public BuildScriptTransformer(String classpathClosureName, ScriptSource scriptSource) {
        final List<String> blocksToIgnore = Arrays.asList(classpathClosureName, "plugins");
        this.filter = new Spec<Statement>(){

            public boolean isSatisfiedBy(Statement statement) {
                return AstUtils.detectScriptBlock((Statement)statement, (Collection)blocksToIgnore) != null;
            }
        };
        this.scriptSource = scriptSource;
    }

    public void register(CompilationUnit compilationUnit) {
        new FilteringScriptTransformer(this.filter).register(compilationUnit);
        new TaskDefinitionScriptTransformer().register(compilationUnit);
        new FixMainScriptTransformer().register(compilationUnit);
        new StatementLabelsScriptTransformer().register(compilationUnit);
        new ScriptSourceTransformer(this.scriptSource.getDisplayName(), this.scriptSource.getResource().getURI()).register(compilationUnit);
        new ModelBlockTransformer().register(compilationUnit);
        this.imperativeStatementDetectingTransformer.register(compilationUnit);
    }

    public BuildScriptData create() {
        return new BuildScriptData(this.imperativeStatementDetectingTransformer.isImperativeStatementDetected());
    }
}

