/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import java.util.Iterator;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.registry.LanguageRegistration;
import org.gradle.language.base.internal.registry.LanguageRegistry;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class ComponentBinaryRules
extends RuleSource {
    @Defaults
    void initializeBinarySourceSets(final ComponentSpec component, final LanguageRegistry languageRegistry) {
        component.getBinaries().withType(BinarySpecInternal.class).beforeEach((Action)new Action<BinarySpecInternal>(){

            public void execute(BinarySpecInternal binary) {
                Iterator i$ = languageRegistry.iterator();
                while (i$.hasNext()) {
                    LanguageRegistration languageRegistration = (LanguageRegistration)i$.next();
                    this.registerLanguageSourceSets(binary, component.getName(), languageRegistration);
                }
                this.addComponentSourceSetsToBinaryInputs(binary, component);
            }

            private <U extends LanguageSourceSet> void registerLanguageSourceSets(BinarySpecInternal binary, String componentName, LanguageRegistration<U> languageRegistration) {
                NamedDomainObjectFactory<U> sourceSetFactory = languageRegistration.getSourceSetFactory(componentName);
                binary.getEntityInstantiator().registerFactory(languageRegistration.getSourceSetType(), sourceSetFactory);
            }

            private void addComponentSourceSetsToBinaryInputs(BinarySpec binary, ComponentSpec component2) {
                binary.getInputs().addAll(component2.getSources().values());
            }
        });
    }
}

