/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.resolve;

import java.util.Iterator;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.language.base.internal.DependentSourceSetInternal;
import org.gradle.language.base.internal.model.DefaultLibraryLocalComponentMetaData;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.platform.base.DependencySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentSourceSetResolveContext
implements ResolveContext {
    private final LibraryBinaryIdentifier binaryId;
    private final DependentSourceSetInternal sourceSet;
    private final ResolutionStrategyInternal resolutionStrategy = new DefaultResolutionStrategy();
    private final VariantsMetaData variants;
    private final Iterable<DependencySpec> dependencies;

    public DependentSourceSetResolveContext(LibraryBinaryIdentifier binaryId, DependentSourceSetInternal sourceSet, VariantsMetaData variants) {
        this(binaryId, sourceSet, variants, DependentSourceSetResolveContext.dependenciesOf(sourceSet));
    }

    public DependentSourceSetResolveContext(LibraryBinaryIdentifier binaryId, DependentSourceSetInternal sourceSet, VariantsMetaData variants, Iterable<DependencySpec> dependencies) {
        this.binaryId = binaryId;
        this.sourceSet = sourceSet;
        this.variants = variants;
        this.dependencies = dependencies;
    }

    public String getName() {
        return "API";
    }

    public String getDisplayName() {
        return this.sourceSet.getDisplayName();
    }

    public LibraryBinaryIdentifier getComponentId() {
        return this.binaryId;
    }

    public DependentSourceSetInternal getSourceSet() {
        return this.sourceSet;
    }

    public VariantsMetaData getVariants() {
        return this.variants;
    }

    public ResolutionStrategyInternal getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public ComponentResolveMetaData toRootComponentMetaData() {
        LibraryBinaryIdentifier libraryBinaryIdentifier = this.getComponentId();
        DefaultLibraryLocalComponentMetaData metaData = DefaultLibraryLocalComponentMetaData.newMetaData(libraryBinaryIdentifier, this.sourceSet.getBuildDependencies());
        this.addDependenciesTo(metaData, libraryBinaryIdentifier.getProjectPath(), this.dependencies);
        return metaData;
    }

    private void addDependenciesTo(DefaultLibraryLocalComponentMetaData metaData, String defaultProject, Iterable<DependencySpec> dependencies) {
        for (DependencySpec dependency : dependencies) {
            metaData.addDependency(dependency, defaultProject);
        }
    }

    private static Iterable<DependencySpec> dependenciesOf(final DependentSourceSetInternal sourceSet) {
        return new Iterable<DependencySpec>(){

            @Override
            public Iterator<DependencySpec> iterator() {
                return sourceSet.getDependencies().getDependencies().iterator();
            }
        };
    }
}

