/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.model.dsl.internal.inputs;

import org.gradle.model.internal.core.ModelView;

import java.util.List;

public class PotentialInput {
    private final String consumerPath;
    private final int inputIndex;

    private PotentialInput(String consumerPath, int inputIndex) {
        this.inputIndex = inputIndex;
        this.consumerPath = consumerPath;
    }

    public String getConsumerPath() {
        return consumerPath;
    }

    public Object get(List<ModelView<?>> views) {
        return views.get(inputIndex).getInstance();
    }

    public static PotentialInput absoluteInput(String consumerPath, int indexPath) {
        return new PotentialInput(consumerPath, indexPath);
    }
}
