/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import javajs.util.AU;
import javajs.util.V3;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Mesh;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.util.C;
import org.jmol.util.Logger;

public class BioShape
extends AtomShape {
    public int modelIndex;
    public int modelVisibilityFlags = 0;
    BioShapeCollection shape;
    public BioPolymer bioPolymer;
    public Mesh[] meshes;
    public boolean[] meshReady;
    public short[] colixesBack;
    public Monomer[] monomers;
    public V3[] wingVectors;
    int[] leadAtomIndices;
    boolean hasBfactorRange = false;
    int bfactorMin;
    int bfactorMax;
    int range;
    float floatRange;
    private static final double eightPiSquared100 = 7895.6835208714865;

    @Override
    public void setProperty(String string, Object object, BS bS) {
        this.setPropAS(string, object, bS);
    }

    @Override
    public Group[] getMonomers() {
        return this.monomers;
    }

    BioShape(BioShapeCollection bioShapeCollection, int n, BioPolymer bioPolymer) {
        this.shape = bioShapeCollection;
        this.modelIndex = n;
        this.bioPolymer = bioPolymer;
        this.isActive = bioShapeCollection.isActive;
        this.bsSizeDefault = new BS();
        this.monomerCount = bioPolymer.monomerCount;
        if (this.monomerCount > 0) {
            this.colixes = new short[this.monomerCount];
            this.paletteIDs = new byte[this.monomerCount];
            this.mads = new short[this.monomerCount + 1];
            this.monomers = bioPolymer.monomers;
            this.meshReady = new boolean[this.monomerCount];
            this.meshes = new Mesh[this.monomerCount];
            this.wingVectors = bioPolymer.getWingVectors();
            this.leadAtomIndices = bioPolymer.getLeadAtomIndices();
        }
    }

    void calcBfactorRange() {
        this.bfactorMin = this.bfactorMax = this.monomers[0].getLeadAtom().getBfactor100();
        int n = this.monomerCount;
        while (--n > 0) {
            int n2 = this.monomers[n].getLeadAtom().getBfactor100();
            if (n2 < this.bfactorMin) {
                this.bfactorMin = n2;
                continue;
            }
            if (n2 <= this.bfactorMax) continue;
            this.bfactorMax = n2;
        }
        this.range = this.bfactorMax - this.bfactorMin;
        this.floatRange = this.range;
        this.hasBfactorRange = true;
    }

    short calcMeanPositionalDisplacement(int n) {
        return (short)(Math.sqrt((double)n / 7895.6835208714865) * 1000.0);
    }

    @Override
    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, BS bS) {
        this.bioPolymer.findNearestAtomIndex(n, n2, atomArray, this.mads, this.shape.vf, bS);
    }

    void setMad(short s, BS bS, float[] fArray) {
        int n;
        if (this.monomerCount < 2) {
            return;
        }
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BS();
        }
        boolean bl = (n = this.shape.vf) == 32768 && this.bioPolymer instanceof NucleicPolymer;
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            int n3 = this.leadAtomIndices[n2];
            if (!bS.get(n3)) continue;
            if (fArray != null && n3 < fArray.length) {
                if (Float.isNaN(fArray[n3])) continue;
                s = (short)(fArray[n3] * 2000.0f);
            }
            boolean bl2 = (this.mads[n2] = this.getMad(n2, s)) > 0;
            this.bsSizeSet.setBitTo(n2, bl2);
            this.monomers[n2].setShapeVisibility(n, bl2);
            this.shape.atoms[n3].setShapeVisibility(n, bl2);
            if (bl) {
                ((NucleicMonomer)this.monomers[n2]).setRingsVisible(bl2);
            }
            this.falsifyNearbyMesh(n2);
        }
        if (this.monomerCount > 1) {
            this.mads[this.monomerCount] = this.mads[this.monomerCount - 1];
        }
    }

    private short getMad(int n, short s) {
        this.bsSizeDefault.setBitTo(n, s == -1 || s == -2);
        if (s >= 0) {
            return s;
        }
        switch (s) {
            case -2: 
            case -1: {
                if (s == -1 && this.shape.madOn >= 0) {
                    return this.shape.madOn;
                }
                switch (this.monomers[n].getProteinStructureType()) {
                    case SHEET: 
                    case HELIX: {
                        return this.shape.madHelixSheet;
                    }
                    case DNA: 
                    case RNA: {
                        return this.shape.madDnaRna;
                    }
                }
                return this.shape.madTurnRandom;
            }
            case -3: {
                if (!this.hasBfactorRange) {
                    this.calcBfactorRange();
                }
                Atom atom = this.monomers[n].getLeadAtom();
                int n2 = atom.getBfactor100();
                int n3 = n2 - this.bfactorMin;
                if (this.range == 0) {
                    return 0;
                }
                float f = (float)n3 / this.floatRange;
                if (f < 0.0f || f > 1.0f) {
                    Logger.error("Que ha ocurrido? " + f);
                }
                return (short)(1750.0f * f + 250.0f);
            }
            case -4: {
                Atom atom = this.monomers[n].getLeadAtom();
                return (short)(2 * this.calcMeanPositionalDisplacement(atom.getBfactor100()));
            }
        }
        Logger.error("unrecognized setMad(" + s + ")");
        return 0;
    }

    public void falsifyMesh() {
        if (this.meshReady == null) {
            return;
        }
        for (int i = 0; i < this.monomerCount; ++i) {
            this.meshReady[i] = false;
        }
    }

    private void falsifyNearbyMesh(int n) {
        if (this.meshReady == null) {
            return;
        }
        this.meshReady[n] = false;
        if (n > 0) {
            this.meshReady[n - 1] = false;
        }
        if (n < this.monomerCount - 1) {
            this.meshReady[n + 1] = false;
        }
    }

    void setColixBS(short s, byte by, BS bS) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = new BS();
        }
        int n = this.monomerCount;
        while (--n >= 0) {
            int n2 = this.leadAtomIndices[n];
            if (!bS.get(n2)) continue;
            this.colixes[n] = this.shape.getColixI(s, by, n2);
            if (this.colixesBack != null && this.colixesBack.length > n) {
                this.colixesBack[n] = 0;
            }
            this.paletteIDs[n] = by;
            this.bsColixSet.setBitTo(n, this.colixes[n] != 0);
        }
    }

    void setColixes(short[] sArray, BS bS) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = new BS();
        }
        int n = this.monomerCount;
        while (--n >= 0) {
            int n2 = this.leadAtomIndices[n];
            if (!bS.get(n2) || n >= this.colixes.length || n2 >= sArray.length) continue;
            this.colixes[n] = this.shape.getColixI(sArray[n2], PAL.UNKNOWN.id, n2);
            if (this.colixesBack != null && n < this.colixesBack.length) {
                this.colixesBack[n] = 0;
            }
            this.paletteIDs[n] = PAL.UNKNOWN.id;
            this.bsColixSet.set(n);
        }
    }

    public void setParams(Object[] objectArray, int[] nArray, BS bS) {
        if (this.monomerCount == 0) {
            return;
        }
        short[] sArray = (short[])objectArray[0];
        float[] fArray = (float[])objectArray[1];
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = new BS();
        }
        int n = nArray.length;
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            float f;
            int n3 = this.leadAtomIndices[n2];
            if (!bS.get(n3) || n2 >= this.colixes.length || n3 >= n) continue;
            int n4 = nArray[n3];
            short s = sArray == null ? (short)0 : sArray[n4];
            float f2 = f = fArray == null ? 0.0f : fArray[n4];
            if (f > 0.01f) {
                s = C.getColixTranslucent3(s, true, f);
            }
            this.colixes[n2] = this.shape.getColixI(s, PAL.UNKNOWN.id, n3);
            if (this.colixesBack != null && n2 < this.colixesBack.length) {
                this.colixesBack[n2] = 0;
            }
            this.paletteIDs[n2] = PAL.UNKNOWN.id;
            this.bsColixSet.set(n2);
        }
    }

    void setColixBack(short s, BS bS) {
        int n = this.monomerCount;
        while (--n >= 0) {
            int n2 = this.leadAtomIndices[n];
            if (!bS.get(n2)) continue;
            if (this.colixesBack == null) {
                this.colixesBack = new short[this.colixes.length];
            }
            if (this.colixesBack.length < this.colixes.length) {
                this.colixesBack = AU.ensureLengthShort(this.colixesBack, this.colixes.length);
            }
            this.colixesBack[n] = s;
        }
    }

    void setTranslucent(boolean bl, BS bS, float f) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = new BS();
        }
        int n = this.monomerCount;
        while (--n >= 0) {
            if (!bS.get(this.leadAtomIndices[n])) continue;
            this.colixes[n] = C.getColixTranslucent3(this.colixes[n], bl, f);
            if (this.colixesBack != null && this.colixesBack.length > n) {
                this.colixesBack[n] = C.getColixTranslucent3(this.colixesBack[n], bl, f);
            }
            this.bsColixSet.setBitTo(n, this.colixes[n] != 0);
        }
    }

    @Override
    public void setAtomClickability() {
        if (!this.isActive || this.wingVectors == null || this.monomerCount == 0) {
            return;
        }
        boolean bl = this.bioPolymer instanceof NucleicPolymer && this.shape.shapeID == 11;
        boolean bl2 = this.bioPolymer instanceof AlphaPolymer || this.shape.shapeID != 15;
        ModelSet modelSet = this.monomers[0].chain.model.ms;
        int n = this.monomerCount;
        while (--n >= 0) {
            int n2;
            if (this.mads[n] <= 0 || modelSet.isAtomHidden(n2 = this.leadAtomIndices[n])) continue;
            if (bl2) {
                modelSet.at[n2].setClickable(1040384);
            }
            if (!bl) continue;
            ((NucleicMonomer)this.monomers[n]).setRingsClickable();
        }
    }
}

