/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolZipUtilities;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;

public class JmolBinary {
    public FileManager fm;
    public static final String PMESH_BINARY_MAGIC_NUMBER = "PM\u0001\u0000";
    JmolZipUtilities jzu;

    public JmolBinary set(FileManager fileManager) {
        this.fm = fileManager;
        return this;
    }

    public static String getEmbeddedScript(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf("**** Jmol Embedded Script ****");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf("/*", n);
        int n3 = string.indexOf((string.charAt(n2 + 2) == '*' ? "*" : "") + "*/", n);
        if (n2 >= 0 && n3 >= n) {
            string = string.substring(n + "**** Jmol Embedded Script ****".length(), n3) + "\n";
        }
        while ((n2 = string.indexOf(" #Jmol...\u0000")) >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + " #Jmol...\u0000".length() + 4);
        }
        if (Logger.debugging) {
            Logger.debug(string);
        }
        return string;
    }

    private JmolZipUtilities getJzu() {
        return this.jzu == null ? (this.jzu = (JmolZipUtilities)Interface.getOption("io.JmolUtil", this.fm.vwr, "file")) : this.jzu;
    }

    public Object getAtomSetCollectionOrBufferedReaderFromZip(JmolAdapter jmolAdapter, InputStream inputStream, String string, String[] stringArray, Map<String, Object> map, boolean bl) {
        return this.getJzu().getAtomSetCollectionOrBufferedReaderFromZip(this.fm.vwr, jmolAdapter, inputStream, string, stringArray, map, 1, bl);
    }

    public Object getImage(Object object, String string, boolean bl) {
        return this.getJzu().getImage(this.fm.vwr, object, string, bl);
    }

    public static void getFileReferences(String string, Lst<String> lst) {
        for (int i = 0; i < FileManager.scriptFilePrefixes.length; ++i) {
            String string2 = FileManager.scriptFilePrefixes[i];
            int n = -1;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                String string3 = PT.getQuotedStringAt(string, n);
                if (string3.indexOf("::") >= 0) {
                    string3 = PT.split(string3, "::")[1];
                }
                lst.addLast(string3);
            }
        }
    }

    public static String getManifestScriptPath(String string) {
        String string2;
        if (string.indexOf("$SCRIPT_PATH$") >= 0) {
            return "";
        }
        String string3 = string2 = string.indexOf(10) >= 0 ? "\n" : "\r";
        if (string.indexOf(".spt") >= 0) {
            String[] stringArray = PT.split(string, string2);
            int n = stringArray.length;
            while (--n >= 0) {
                if (stringArray[n].indexOf(".spt") < 0) continue;
                return "|" + PT.trim(stringArray[n], "\r\n \t");
            }
        }
        return null;
    }

    public BufferedReader spartanFileGetRdr(String string, String[] stringArray) {
        String string2;
        Object object;
        String string3 = string;
        String string4 = stringArray[1];
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (stringArray.length == 3) {
            object = this.spartanGetObjectAsSections(stringArray[2], string4, hashtable);
            hashtable.put("OUTPUT", (String)object);
            stringArray = this.spartanFileList(string, (String)hashtable.get(object));
            if (stringArray.length == 3) {
                object = this.spartanGetObjectAsSections(stringArray[2], string4, hashtable);
                hashtable.put("OUTPUT", (String)object);
                stringArray = this.spartanFileList(stringArray[1], (String)hashtable.get(object));
            }
        }
        object = new SB();
        if (hashtable.get("OUTPUT") != null) {
            ((SB)object).append((String)hashtable.get(hashtable.get("OUTPUT")));
        }
        for (int i = 2; i < stringArray.length; ++i) {
            string = stringArray[i];
            string = this.spartanGetObjectAsSections(string, string4, hashtable);
            Logger.info("reading " + string);
            string2 = (String)hashtable.get(string);
            ((SB)object).append(string2);
        }
        string2 = ((SB)object).toString();
        this.fm.spardirPut(string3.replace('\\', '/'), string2.getBytes());
        return Rdr.getBR(string2);
    }

    private String[] spartanFileList(String string, String string2) {
        return this.getJzu().spartanFileList(this.fm.vwr.getJzt(), string, string2);
    }

    private String spartanGetObjectAsSections(String string, String string2, Map<String, String> map) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        boolean bl = false;
        String string3 = string.replace('\\', '/');
        if (string.indexOf(":asBinaryString") >= 0) {
            bl = true;
            string = string.substring(0, string.indexOf(":asBinaryString"));
        }
        SB sB = null;
        if (map.containsKey(string3)) {
            return string3;
        }
        if (string.indexOf("#JMOL_MODEL ") >= 0) {
            map.put(string3, string3 + "\n");
            return string3;
        }
        String string4 = string;
        if (string.indexOf("|") >= 0) {
            stringArray = PT.split(string, "|");
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            Object object = this.fm.getBufferedInputStreamOrErrorMessageFromName(string, string4, false, false, null, false, true);
            if (object instanceof String) {
                map.put(string3, (String)object + "\n");
                return string3;
            }
            bufferedInputStream = (BufferedInputStream)object;
            if (Rdr.isCompoundDocumentS(bufferedInputStream)) {
                GenericBinaryDocument genericBinaryDocument = (GenericBinaryDocument)Interface.getInterface("javajs.util.CompoundDocument", this.fm.vwr, "file");
                genericBinaryDocument.setStream(this.fm.vwr.getJzt(), bufferedInputStream, true);
                genericBinaryDocument.getAllDataMapped(string.replace('\\', '/'), "Molecule", map);
            } else if (Rdr.isZipS(bufferedInputStream)) {
                this.fm.vwr.getJzt().getAllZipData(bufferedInputStream, stringArray, string.replace('\\', '/'), "Molecule", map);
            } else if (bl) {
                GenericBinaryDocument genericBinaryDocument = (GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", this.fm.vwr, "file");
                genericBinaryDocument.setStream(this.fm.vwr.getJzt(), bufferedInputStream, false);
                sB = new SB();
                if (string2 != null) {
                    sB.append("BEGIN Directory Entry " + string3 + "\n");
                }
                try {
                    while (true) {
                        sB.append(Integer.toHexString(genericBinaryDocument.readByte() & 0xFF)).appendC(' ');
                    }
                }
                catch (Exception exception) {
                    sB.appendC('\n');
                    if (string2 != null) {
                        sB.append("\nEND Directory Entry " + string3 + "\n");
                    }
                    map.put(string3, sB.toString());
                }
            } else {
                String string5;
                BufferedReader bufferedReader = Rdr.getBufferedReader(Rdr.isGzipS(bufferedInputStream) ? new BufferedInputStream(this.fm.vwr.getJzt().newGZIPInputStream(bufferedInputStream)) : bufferedInputStream, null);
                sB = new SB();
                if (string2 != null) {
                    sB.append("BEGIN Directory Entry " + string3 + "\n");
                }
                while ((string5 = bufferedReader.readLine()) != null) {
                    sB.append(string5);
                    sB.appendC('\n');
                }
                bufferedReader.close();
                if (string2 != null) {
                    sB.append("\nEND Directory Entry " + string3 + "\n");
                }
                map.put(string3, sB.toString());
            }
        }
        catch (Exception exception) {
            map.put(string3, exception.toString());
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!map.containsKey(string3)) {
            map.put(string3, "FILE NOT FOUND: " + string3 + "\n");
        }
        return string3;
    }

    public byte[] getCachedPngjBytes(String string) {
        return this.getJzu().getCachedPngjBytes(this, string);
    }
}

