/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.config.PropertySetterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertySetter {
    private static final Log log = LogFactory.getLog(PropertySetter.class);
    private final Object obj;
    private PropertyDescriptor[] props;

    public PropertySetter(Object object) {
        this.obj = object;
    }

    protected void introspect() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.obj.getClass());
            this.props = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            log.error("Failed to introspect " + this.obj + ": " + introspectionException.getMessage());
            this.props = new PropertyDescriptor[0];
        }
    }

    public static void setProperties(Object object, Properties properties, String string) {
        new PropertySetter(object).setProperties(properties, string);
    }

    public void setProperties(Properties properties, String string) {
        int n = string.length();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string) || string2.indexOf(46, n + 1) > 0) continue;
            String string3 = OptionConverter.findAndSubst(string2, properties);
            string2 = string2.substring(n);
            this.setProperty(string2, string3);
        }
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string = Introspector.decapitalize(string));
        if (propertyDescriptor == null) {
            log.warn("No such property [" + string + "] in " + this.obj.getClass().getName() + ".");
        } else {
            try {
                this.setProperty(propertyDescriptor, string, string2);
            }
            catch (PropertySetterException propertySetterException) {
                log.warn("Failed to set property " + string + " to value \"" + string2 + "\". " + propertySetterException.getMessage());
            }
        }
    }

    public void setProperty(PropertyDescriptor propertyDescriptor, String string, String string2) throws PropertySetterException {
        Object object;
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new PropertySetterException("No setter for property");
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            object = this.convertArg(string2, classArray[0]);
        }
        catch (Throwable throwable) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed. Reason: " + throwable);
        }
        if (object == null) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed.");
        }
        log.debug("Setting property [" + string + "] to [" + object + "].");
        try {
            method.invoke(this.obj, object);
        }
        catch (Exception exception) {
            throw new PropertySetterException(exception);
        }
    }

    protected Object convertArg(String string, Class<?> clazz) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (String.class.isAssignableFrom(clazz)) {
            return string;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return Integer.valueOf(string2);
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return Long.valueOf(string2);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            if ("true".equalsIgnoreCase(string2)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string2)) {
                return Boolean.FALSE;
            }
        } else {
            if (clazz.isEnum()) {
                Enum enum_ = Enum.valueOf(clazz.asSubclass(Enum.class), string2);
                return enum_;
            }
            if (File.class.isAssignableFrom(clazz)) {
                return new File(string2);
            }
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(String string) {
        if (this.props == null) {
            this.introspect();
        }
        for (int i = 0; i < this.props.length; ++i) {
            if (!string.equals(this.props[i].getName())) continue;
            return this.props[i];
        }
        return null;
    }
}

