/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import javax.swing.JEditorPane;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmHTMLEditorKit;
import org.openstreetmap.josm.gui.widgets.TextContextualPopupMenu;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public class JosmEditorPane
extends JEditorPane {
    public JosmEditorPane() {
        TextContextualPopupMenu.enableMenuFor(this, true);
    }

    public JosmEditorPane(URL uRL) throws IOException {
        this();
        this.setPage(uRL);
    }

    public JosmEditorPane(String string) throws IOException {
        this();
        this.setPage(string);
    }

    public JosmEditorPane(String string, String string2) {
        this();
        this.setContentType(string);
        this.setText(string2);
    }

    @Override
    protected InputStream getStream(URL uRL) throws IOException {
        URLConnection uRLConnection = Utils.setupURLConnection(uRL.openConnection());
        InputStream inputStream = uRLConnection.getInputStream();
        String string = uRLConnection.getContentType();
        if (string != null) {
            this.setContentType(string);
        }
        return inputStream;
    }

    public static void makeJLabelLike(JEditorPane jEditorPane, boolean bl) {
        jEditorPane.setContentType("text/html");
        jEditorPane.setOpaque(false);
        jEditorPane.setEditable(false);
        JosmEditorPane.adaptForNimbus(jEditorPane);
        JosmHTMLEditorKit josmHTMLEditorKit = new JosmHTMLEditorKit();
        Font font = UIManager.getFont("Label.font");
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule((bl ? "html" : "strong, b") + " {" + JosmEditorPane.getFontRule(font) + '}');
        styleSheet.addRule("a {text-decoration: underline; color: blue}");
        styleSheet.addRule("h1 {" + JosmEditorPane.getFontRule(GuiHelper.getTitleFont()) + '}');
        styleSheet.addRule("ol {margin-left: 1cm; margin-top: 0.1cm; margin-bottom: 0.2cm; list-style-type: decimal}");
        styleSheet.addRule("ul {margin-left: 1cm; margin-top: 0.1cm; margin-bottom: 0.2cm; list-style-type: disc}");
        if ("km".equals(LanguageInfo.getJOSMLocaleCode())) {
            styleSheet.addRule("p {" + JosmEditorPane.getFontRule(UIManager.getFont("Label.font")) + '}');
        }
        josmHTMLEditorKit.setStyleSheet(styleSheet);
        jEditorPane.setEditorKit(josmHTMLEditorKit);
    }

    public static void adaptForNimbus(JEditorPane jEditorPane) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null && "Nimbus".equals(lookAndFeel.getName())) {
            Color color = UIManager.getColor("Label.background");
            UIDefaults uIDefaults = new UIDefaults();
            uIDefaults.put("EditorPane[Enabled].backgroundPainter", color);
            jEditorPane.putClientProperty("Nimbus.Overrides", uIDefaults);
            jEditorPane.putClientProperty("Nimbus.Overrides.InheritDefaults", Boolean.TRUE);
            jEditorPane.setBackground(color);
        }
    }

    private static String getFontRule(Font font) {
        return MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", font.getName(), font.getSize(), "bold", font.isItalic() ? "italic" : "normal");
    }
}

