/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectLocation;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.object.TypedLocation;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LocationImpl;
import java.util.Objects;

public abstract class Locations {

    public static final class ConstantLocation
    extends ValueLocation {
        public ConstantLocation(Object value) {
            super(value);
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static class DeclaredDualLocation
    extends DualLocation {
        private final Object defaultValue;

        public DeclaredDualLocation(LocationImpl.InternalLongLocation primitiveLocation, ObjectLocation objectLocation, Object defaultValue, LayoutImpl layout) {
            super(primitiveLocation, objectLocation, layout);
            this.defaultValue = defaultValue;
        }

        @Override
        public Object get(DynamicObject store, boolean condition) {
            return this.defaultValue;
        }

        @Override
        public void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (DeclaredDualLocation.valueEquals(this.defaultValue, value)) {
                return;
            }
            throw DeclaredDualLocation.incompatibleLocation();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.defaultValue, ((DeclaredDualLocation)obj).defaultValue);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public DualLocation changeType(Class<?> newType) {
            return new DualLocation(this.primitiveLocation, this.objectLocation, this.layout, newType);
        }

        @Override
        public boolean canStore(Object value) {
            return DeclaredDualLocation.valueEquals(this.defaultValue, value);
        }

        @Override
        public String toString() {
            return String.valueOf(this.objectLocation.toString()) + "," + this.primitiveLocation.toString() + ",unset";
        }
    }

    public static final class DeclaredLocation
    extends ValueLocation {
        public DeclaredLocation(Object value) {
            super(value);
        }
    }

    public static class DualLocation
    extends LocationImpl
    implements TypedLocation {
        protected final LocationImpl.InternalLongLocation primitiveLocation;
        protected final ObjectLocation objectLocation;
        protected final LayoutImpl layout;
        private final Class<?> type;

        public DualLocation(LocationImpl.InternalLongLocation primitiveLocation, ObjectLocation objectLocation, LayoutImpl layout) {
            this(primitiveLocation, objectLocation, layout, null);
        }

        public DualLocation(LocationImpl.InternalLongLocation primitiveLocation, ObjectLocation objectLocation, LayoutImpl layout, Class<?> type) {
            this.primitiveLocation = primitiveLocation;
            this.objectLocation = objectLocation;
            this.layout = layout;
            this.type = type;
        }

        @Override
        public Object get(DynamicObject store, boolean condition) {
            if (this.type == Object.class) {
                return this.objectLocation.get(store, condition);
            }
            long rawValue = this.primitiveLocation.getLong(store, condition);
            if (this.type == Integer.TYPE) {
                return (int)rawValue;
            }
            if (this.type == Long.TYPE) {
                return rawValue;
            }
            if (this.type == Double.TYPE) {
                return Double.longBitsToDouble(rawValue);
            }
            if (this.type == Boolean.TYPE) {
                if (rawValue != 0L) {
                    return true;
                }
                return false;
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException();
        }

        @Override
        public void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (this.type == Object.class) {
                ((LocationImpl)((Object)this.objectLocation)).setInternal(store, value);
            } else {
                long rawValue;
                if (this.type == Integer.TYPE && value instanceof Integer) {
                    rawValue = ((Integer)value).intValue();
                } else if (this.type == Long.TYPE && value instanceof Long) {
                    rawValue = (Long)value;
                } else if (this.type == Long.TYPE && this.layout.isAllowedIntToLong() && value instanceof Integer) {
                    rawValue = ((Integer)value).intValue();
                } else if (this.type == Double.TYPE && value instanceof Double) {
                    rawValue = Double.doubleToRawLongBits((Double)value);
                } else if (this.type == Double.TYPE && this.layout.isAllowedIntToDouble() && value instanceof Integer) {
                    rawValue = Double.doubleToRawLongBits(((Integer)value).intValue());
                } else if (this.type == Boolean.TYPE && value instanceof Boolean) {
                    rawValue = (Boolean)value != false ? 1 : 0;
                } else {
                    throw DualLocation.incompatibleLocation();
                }
                this.primitiveLocation.setLongInternal(store, rawValue);
            }
        }

        @Override
        public int primitiveFieldCount() {
            return ((LocationImpl)((Object)this.primitiveLocation)).primitiveFieldCount();
        }

        @Override
        public int primitiveArrayCount() {
            return ((LocationImpl)((Object)this.primitiveLocation)).primitiveArrayCount();
        }

        @Override
        public int objectFieldCount() {
            return ((LocationImpl)((Object)this.objectLocation)).objectFieldCount();
        }

        @Override
        public int objectArrayCount() {
            return ((LocationImpl)((Object)this.objectLocation)).objectArrayCount();
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            ((LocationImpl)((Object)this.primitiveLocation)).accept(locationVisitor);
            ((LocationImpl)((Object)this.objectLocation)).accept(locationVisitor);
        }

        @Override
        public String toString() {
            return String.valueOf(this.objectLocation.toString()) + "," + this.primitiveLocation.toString() + "," + this.type;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            DualLocation other = (DualLocation)obj;
            return this.getObjectLocation().equals(other.getObjectLocation()) && this.primitiveLocation.equals(other.primitiveLocation) && this.layout.equals(other.layout) && Objects.equals(this.type, other.type);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.getObjectLocation() == null ? 0 : this.getObjectLocation().hashCode());
            result = 31 * result + (this.primitiveLocation == null ? 0 : this.primitiveLocation.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public ObjectLocation getObjectLocation() {
            return this.objectLocation;
        }

        public DualLocation changeType(Class<?> newType) {
            return new DualLocation(this.primitiveLocation, this.objectLocation, this.layout, newType);
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        public boolean isNonNull() {
            return false;
        }

        @Override
        public boolean canStore(Object value) {
            if (this.type == null) {
                return false;
            }
            if (this.type == Integer.TYPE) {
                return value instanceof Integer;
            }
            if (this.type == Long.TYPE) {
                return value instanceof Long || this.layout.isAllowedIntToLong() && value instanceof Integer;
            }
            if (this.type == Double.TYPE) {
                return value instanceof Double || this.layout.isAllowedIntToDouble() && value instanceof Integer;
            }
            if (this.type == Boolean.TYPE) {
                return value instanceof Boolean;
            }
            if (this.type == Object.class) {
                return true;
            }
            throw new IllegalStateException();
        }
    }

    public static abstract class ValueLocation
    extends LocationImpl {
        private final Object value;

        public ValueLocation(Object value) {
            assert (!(value instanceof Location));
            this.value = value;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.value == null ? 0 : 0);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ValueLocation other = (ValueLocation)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.value;
        }

        @Override
        public final void set(DynamicObject store, Object value, Shape shape) throws IncompatibleLocationException, FinalLocationException {
            if (!this.canStoreFinal(store, value)) {
                throw ValueLocation.finalLocation();
            }
        }

        @Override
        protected boolean canStoreFinal(DynamicObject store, Object val) {
            return ValueLocation.valueEquals(this.value, val);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (!this.canStoreFinal(store, value)) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public String toString() {
            return "=" + String.valueOf(this.value);
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
        }
    }
}

