/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.util.Arrays;
import org.jruby.exceptions.MainExitException;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ThreadExitException;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ExceptionTranslatingNode
extends RubyNode {
    private final UnsupportedOperationBehavior unsupportedOperationBehavior;
    @Node.Child
    private RubyNode child;
    private final BranchProfile controlProfile = BranchProfile.create();
    private final BranchProfile rethrowProfile = BranchProfile.create();

    public ExceptionTranslatingNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
        this(context, sourceSection, child, UnsupportedOperationBehavior.TYPE_ERROR);
    }

    public ExceptionTranslatingNode(RubyContext context, SourceSection sourceSection, RubyNode child, UnsupportedOperationBehavior unsupportedOperationBehavior) {
        super(context, sourceSection);
        this.child = child;
        this.unsupportedOperationBehavior = unsupportedOperationBehavior;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            assert (this.assertArgumentsShouldBeVisible(frame));
            Object result = this.child.execute(frame);
            assert (this.shouldObjectBeVisible(result)) : "result@" + this.getEncapsulatingSourceSection().getShortDescription();
            return result;
        }
        catch (StackOverflowError error) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.translate(error));
        }
        catch (ThreadExitException | TruffleFatalException exception) {
            CompilerDirectives.transferToInterpreter();
            throw exception;
        }
        catch (ControlFlowException exception) {
            this.controlProfile.enter();
            throw exception;
        }
        catch (RaiseException exception) {
            this.rethrowProfile.enter();
            throw exception;
        }
        catch (MainExitException exception) {
            CompilerDirectives.transferToInterpreter();
            throw exception;
        }
        catch (ArithmeticException exception) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.translate(exception));
        }
        catch (UnsupportedSpecializationException exception) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.translate(exception));
        }
        catch (org.jruby.exceptions.RaiseException e) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().toTruffle(e.getException(), this));
        }
        catch (Throwable exception) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.translate(exception));
        }
    }

    private DynamicObject translate(ArithmeticException exception) {
        if (this.getContext().getOptions().EXCEPTIONS_PRINT_JAVA) {
            exception.printStackTrace();
        }
        return this.getContext().getCoreLibrary().zeroDivisionError(this);
    }

    private DynamicObject translate(UnsupportedSpecializationException exception) {
        if (this.getContext().getOptions().EXCEPTIONS_PRINT_JAVA) {
            exception.printStackTrace();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Truffle doesn't have a case for the ");
        builder.append(exception.getNode().getClass().getName());
        builder.append(" node with values of type ");
        for (Object value : exception.getSuppliedValues()) {
            builder.append(" ");
            if (value == null) {
                builder.append("null");
            } else if (value instanceof DynamicObject) {
                builder.append(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass((DynamicObject)value)).getName());
                builder.append("(");
                builder.append(value.getClass().getName());
                builder.append(")");
                if (RubyGuards.isRubyArray(value)) {
                    DynamicObject array = (DynamicObject)value;
                    builder.append("[");
                    if (Layouts.ARRAY.getStore(array) == null) {
                        builder.append("null");
                    } else {
                        builder.append(Layouts.ARRAY.getStore(array).getClass().getName());
                    }
                    builder.append(",");
                    builder.append(Layouts.ARRAY.getSize(array));
                    builder.append("]");
                } else if (RubyGuards.isRubyHash(value)) {
                    Object store = Layouts.HASH.getStore((DynamicObject)value);
                    if (store == null) {
                        builder.append("[null]");
                    } else {
                        builder.append("[");
                        builder.append(store.getClass().getName());
                        builder.append("]");
                    }
                }
            } else {
                builder.append(value.getClass().getName());
            }
            if (!(value instanceof Number) && !(value instanceof Boolean)) continue;
            builder.append("=");
            builder.append(value.toString());
        }
        switch (this.unsupportedOperationBehavior) {
            case TYPE_ERROR: {
                return this.getContext().getCoreLibrary().typeError(builder.toString(), this);
            }
            case ARGUMENT_ERROR: {
                return this.getContext().getCoreLibrary().argumentError(builder.toString(), this);
            }
        }
        throw new UnsupportedOperationException();
    }

    public DynamicObject translate(Throwable throwable) {
        if (this.getContext().getOptions().EXCEPTIONS_PRINT_JAVA || this.getContext().getOptions().EXCEPTIONS_PRINT_UNCAUGHT_JAVA) {
            throwable.printStackTrace();
        }
        if (throwable.getStackTrace().length > 0) {
            return this.getContext().getCoreLibrary().internalError(String.format("%s %s %s", throwable.getClass().getSimpleName(), throwable.getMessage(), throwable.getStackTrace()[0].toString()), this);
        }
        return this.getContext().getCoreLibrary().internalError(String.format("%s %s ???", throwable.getClass().getSimpleName(), throwable.getMessage()), this);
    }

    private boolean shouldObjectBeVisible(Object object) {
        return object instanceof TruffleObject || object instanceof Boolean || object instanceof Integer || object instanceof Long || object instanceof Double;
    }

    private boolean assertArgumentsShouldBeVisible(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame.getArguments());
        assert (this.shouldObjectBeVisible(self)) : "self=" + (self == null ? "null" : self.getClass()) + "@" + this.getEncapsulatingSourceSection().getShortDescription();
        Object[] arguments = RubyArguments.extractUserArguments(frame.getArguments());
        for (int n = 0; n < arguments.length; ++n) {
            Object argument = arguments[n];
            assert (this.shouldObjectBeVisible(argument)) : "arg[" + n + "]=" + (argument == null ? "null" : argument.getClass() + "=" + this.toString(argument)) + "@" + this.getEncapsulatingSourceSection().getShortDescription();
        }
        return true;
    }

    private String toString(Object object) {
        if (object instanceof Object[]) {
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }
}

