/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Iterator;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.ModuleNodes;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

public class DefineOrGetModuleNode
extends RubyNode {
    protected final String name;
    @Node.Child
    private RubyNode lexicalParentModule;
    @Node.Child
    private KernelNodes.RequireNode requireNode;

    public DefineOrGetModuleNode(RubyContext context, SourceSection sourceSection, String name, RubyNode lexicalParent) {
        super(context, sourceSection);
        this.name = name;
        this.lexicalParentModule = lexicalParent;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject definingModule;
        CompilerDirectives.transferToInterpreter();
        DynamicObject lexicalParent = this.getLexicalParentModule(frame);
        RubyConstant constant = this.lookupForExistingModule(lexicalParent);
        if (constant == null) {
            definingModule = ModuleNodes.createRubyModule(this.getContext(), this.getContext().getCoreLibrary().getModuleClass(), lexicalParent, this.name, this);
        } else {
            Object module = constant.getValue();
            if (!RubyGuards.isRubyModule(module) || RubyGuards.isRubyClass(module)) {
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorIsNotA(this.name, "module", this));
            }
            definingModule = (DynamicObject)module;
        }
        return definingModule;
    }

    protected DynamicObject getLexicalParentModule(VirtualFrame frame) {
        Object lexicalParent = this.lexicalParentModule.execute(frame);
        if (!RubyGuards.isRubyModule(lexicalParent)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorIsNotA(lexicalParent.toString(), "module", this));
        }
        return (DynamicObject)lexicalParent;
    }

    @CompilerDirectives.TruffleBoundary
    protected RubyConstant lookupForExistingModule(DynamicObject lexicalParent) {
        RubyConstant constant = Layouts.MODULE.getFields(lexicalParent).getConstants().get(this.name);
        DynamicObject objectClass = this.getContext().getCoreLibrary().getObjectClass();
        if (constant == null && lexicalParent == objectClass) {
            DynamicObject included;
            Iterator<DynamicObject> i$ = Layouts.MODULE.getFields(objectClass).prependedAndIncludedModules().iterator();
            while (i$.hasNext() && (constant = Layouts.MODULE.getFields(included = i$.next()).getConstants().get(this.name)) == null) {
            }
        }
        if (constant != null && !constant.isVisibleTo(this.getContext(), LexicalScope.NONE, lexicalParent)) {
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateConstant(lexicalParent, this.name, this));
        }
        if (constant != null && constant.isAutoload()) {
            if (this.requireNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.requireNode = this.insert(KernelNodesFactory.RequireNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            Layouts.MODULE.getFields(lexicalParent).removeConstant(this.getContext(), this, this.name);
            this.requireNode.require((DynamicObject)constant.getValue());
            return this.lookupForExistingModule(lexicalParent);
        }
        return constant;
    }
}

