/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeStringType;
import de.intarsys.nativec.type.NativeType;

public class NativeString
extends NativeObject {
    public static final NativeStringType META = new NativeStringType();
    private int size = 0;
    private NativeStringType type;

    static {
        NativeType.register(NativeString.class, META);
    }

    public static NativeString createFromAddress(long l) {
        return (NativeString)META.createNative(NativeTools.toHandle(l));
    }

    protected NativeString(NativeStringType nativeStringType) {
        this.type = nativeStringType;
        this.allocate();
    }

    protected NativeString(NativeStringType nativeStringType, INativeHandle iNativeHandle) {
        super(iNativeHandle);
        this.type = nativeStringType;
        if (this.type.hasByteCount()) {
            iNativeHandle.setSize(this.type.getByteCount());
        }
    }

    protected NativeString(NativeStringType nativeStringType, String string) {
        this.type = nativeStringType;
        if (this.type.getStringSize() == 0) {
            this.size = string.length() + 1;
        }
        this.allocate();
        this.setValue(string);
    }

    public NativeString(String string) {
        this(META, string);
    }

    @Override
    public int getByteCount() {
        if (this.type.hasByteCount()) {
            return this.type.getByteCount();
        }
        return this.size;
    }

    @Override
    public INativeType getNativeType() {
        return this.type;
    }

    @Override
    public Object getValue() {
        return this.stringValue();
    }

    @Override
    public void setValue(Object object) {
        this.setValue((String)object);
    }

    public void setValue(String string) {
        this.size = string.length() + 1;
        this.handle.setString(0, string);
    }

    public String stringValue() {
        return this.handle.getString(0);
    }
}

