/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontFamily;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FontFamily
implements IFontFamily {
    private final IFont[] fonts = new IFont[4];
    private String name = "";
    private String type = "";

    public FontFamily(String string) {
        this.name = string;
    }

    @Override
    public String getFamilyName() {
        return this.name;
    }

    @Override
    public IFont getFont(FontStyle fontStyle) {
        return this.fonts[fontStyle.getIndex()];
    }

    public Iterator<IFont> getFontIterator() {
        return new Iterator<IFont>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < FontFamily.this.fonts.length) {
                    if (FontFamily.this.fonts[this.index] != null) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public IFont next() {
                while (this.index < FontFamily.this.fonts.length) {
                    if (FontFamily.this.fonts[this.index] != null) {
                        return FontFamily.this.fonts[this.index++];
                    }
                    ++this.index;
                }
                throw new NoSuchElementException("no more fonts");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("can not remove font");
            }
        };
    }

    @Override
    public IFont[] getFonts() {
        ArrayList<IFont> arrayList = new ArrayList<IFont>();
        int n = 0;
        while (n < this.fonts.length) {
            if (this.fonts[n] != null) {
                arrayList.add(this.fonts[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IFont[arrayList.size()]);
    }

    @Override
    public FontStyle[] getFontStyles() {
        ArrayList<FontStyle> arrayList = new ArrayList<FontStyle>();
        int n = 0;
        while (n < this.fonts.length) {
            if (this.fonts[n] != null) {
                arrayList.add(this.fonts[n].getFontStyle());
            }
            ++n;
        }
        return arrayList.toArray(new FontStyle[arrayList.size()]);
    }

    @Override
    public String getFontType() {
        return this.type;
    }

    @Override
    public void registerFont(IFont iFont) {
        this.fonts[iFont.getFontStyle().getIndex()] = iFont;
        this.type = iFont.getFontType();
    }
}

