/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.freetype;

import de.intarsys.cwt.common.ShapeWrapper;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.freetype.GlyphSlot;
import de.intarsys.cwt.freetype.Outline;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.freetype.FreetypeFont;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;
import de.intarsys.tools.geometry.ApplyTransformationShape;
import de.intarsys.tools.geometry.TransformedShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class FreetypeGlyphs
implements IPlatformGlyphs {
    private static final Shape EMPTY = new GeneralPath();
    private final FreetypeFont font;
    private final PDGlyphs glyphs;
    private Shape shape;
    private int width;

    protected FreetypeGlyphs(FreetypeFont freetypeFont, PDGlyphs pDGlyphs) throws PlatformFontException {
        this.font = freetypeFont;
        this.glyphs = pDGlyphs;
        this.init();
    }

    protected void createContour(GeneralPath generalPath, Outline outline, int n, int n2) {
        boolean bl = outline.isReverseFill();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n3 = 0;
        boolean bl2 = true;
        int n4 = n;
        while (true) {
            byte by = outline.getTag(n4);
            int n5 = outline.getPointX(n4);
            int n6 = outline.getPointY(n4);
            float f7 = n5;
            float f8 = n6;
            if (bl2) {
                f = f7;
                f2 = f8;
                generalPath.moveTo(f7, f8);
            } else if ((by & 1) != 0) {
                if (n3 == 0) {
                    generalPath.lineTo(f7, f8);
                } else if (n3 == 1) {
                    generalPath.quadTo(f3, f4, f7, f8);
                } else {
                    generalPath.curveTo(f3, f4, f5, f6, f7, f8);
                }
                n3 = 0;
            } else {
                if ((by & 2) == 0 && n3 == 1) {
                    float f9 = f3 + (f7 - f3) / 2.0f;
                    float f10 = f4 + (f8 - f4) / 2.0f;
                    generalPath.quadTo(f3, f4, f9, f10);
                    n3 = 0;
                }
                if (n3 == 0) {
                    f3 = f7;
                    f4 = f8;
                    n3 = 1;
                } else {
                    f5 = f7;
                    f6 = f8;
                    n3 = 2;
                }
            }
            bl2 = false;
            if (bl) {
                if (--n4 < n) {
                    n4 = n2;
                }
                if (n4 != n) continue;
                break;
            }
            if (n4 == n2) break;
            ++n4;
        }
        if (n3 == 0) {
            generalPath.lineTo(f, f2);
        } else if (n3 == 1) {
            generalPath.quadTo(f3, f4, f, f2);
        } else {
            generalPath.curveTo(f3, f4, f5, f6, f, f2);
        }
        generalPath.closePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Shape createShape() {
        FreetypeFont freetypeFont = this.font;
        synchronized (freetypeFont) {
            GlyphSlot glyphSlot;
            try {
                glyphSlot = this.loadGlyphSlot();
            }
            catch (PlatformFontException platformFontException) {
                return EMPTY;
            }
            Outline outline = glyphSlot.getOutline();
            int n = outline.getNumContours();
            if (n == 0) {
                return EMPTY;
            }
            int n2 = outline.isEvenOddFill() ? 0 : 1;
            GeneralPath generalPath = new GeneralPath(n2, 40);
            ShapeWrapper shapeWrapper = new ShapeWrapper((Shape)generalPath);
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                int n5 = outline.getContour(n4);
                this.createContour(generalPath, outline, n3, n5);
                n3 = n5 + 1;
                ++n4;
            }
            return shapeWrapper;
        }
    }

    public FreetypeFont getFont() {
        return this.font;
    }

    @Override
    public PDGlyphs getGlyphs() {
        return this.glyphs;
    }

    @Override
    public IPlatformFont getPlatformFont() {
        return this.font;
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = this.createShape();
        }
        return this.shape;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws PlatformFontException {
        FreetypeFont freetypeFont = this.font;
        synchronized (freetypeFont) {
            GlyphSlot glyphSlot = this.loadGlyphSlot();
            long l = glyphSlot.getLinearHoriAdvance();
            if (l == 0L) {
                l = glyphSlot.getGlyphMetrics().getHoriAdvance();
            }
            int n = (int)((double)l * this.getFont().getTextSpaceFactor());
            this.setWidth(n);
        }
    }

    protected GlyphSlot loadGlyphSlot() throws PlatformFontException {
        return this.getFont().loadGlyphSlot(this.getGlyphs());
    }

    @Override
    public void render(ICSPlatformDevice iCSPlatformDevice) {
        Shape shape = this.getShape();
        if (shape == EMPTY) {
            return;
        }
        GraphicsState graphicsState = iCSPlatformDevice.getGraphicsState();
        IGraphicsContext iGraphicsContext = iCSPlatformDevice.getGraphicsContext();
        AffineTransform affineTransform = (AffineTransform)graphicsState.getAttribute((Object)FreetypeFont.ATTR_TRANSFORM);
        TransformedShape transformedShape = ApplyTransformationShape.create((Shape)shape, (AffineTransform)affineTransform);
        int n = graphicsState.textState.renderingMode & 3;
        if (n == 0) {
            iGraphicsContext.fill((Shape)transformedShape);
        } else if (n == 1) {
            iGraphicsContext.draw((Shape)transformedShape);
        } else if (n == 2) {
            iGraphicsContext.fill((Shape)transformedShape);
            iGraphicsContext.draw((Shape)transformedShape);
        }
        if ((graphicsState.textState.renderingMode & 4) == 4) {
            iCSPlatformDevice.addTextClip((Shape)transformedShape);
        }
    }

    public void setWidth(int n) {
        this.width = n;
    }
}

