/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.logging.CommonHandlerFactory;
import de.intarsys.tools.logging.FileDumpHandler;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.util.logging.Handler;

public class FileDumpHandlerFactory
extends CommonHandlerFactory {
    private String directoryName = "dumplog.${system.uniquetime:d}";
    private IStringEvaluator stringEvaluator;

    @Override
    protected Handler basicCreateHandler() {
        FileDumpHandler fileDumpHandler = new FileDumpHandler();
        fileDumpHandler.setDirectory(this.getDirectory());
        return fileDumpHandler;
    }

    public File getDirectory() {
        String string = this.getDirectoryName();
        if (StringTools.isEmpty(string)) {
            string = "dumplog.${system.uniquetime:d}";
        }
        try {
            string = (String)this.getStringEvaluator().evaluate(string, Args.create());
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        string = FileTools.trimPath(string);
        File file = FileEnvironment.get().getProfileDir();
        return FileTools.resolvePath(file, string);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public IStringEvaluator getStringEvaluator() {
        if (this.stringEvaluator == null) {
            return TemplateEvaluator.get();
        }
        return this.stringEvaluator;
    }

    public void setDirectoryName(String string) {
        this.directoryName = string;
    }

    public void setStringEvaluator(IStringEvaluator iStringEvaluator) {
        this.stringEvaluator = iStringEvaluator;
    }
}

